###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openoffice_detect_lin.nasl 893 2009-01-29 11:10:46Z jan $
#
# OpenOffice Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900073);
  script_version("$Revision: 1.0 $");
  script_name(english:"OpenOffice Version Detection (Linux)");
  desc["english"] = "

  Overview: The script detects the version of OpenOffice and sets the
  result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

openName = find_file(file_name:"versionrc", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
foreach binaryName (openName)
{
  binaryName = chomp(binaryName);
  if("openoffice" >!< binaryName){
    continue;
  }

  openVer = get_bin_version(full_prog_name:"cat", version_argv:binaryName,
                           ver_pattern:"[0-9]\.[0-9](\.[0-9])?", sock:sock);
  if(openVer[0] != NULL)
  {
    set_kb_item(name:"OpenOffice/Linux/Ver", value:openVer[0]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
