##############################################################################
#
#  phpMyAdmin Detection 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/23
#
#  Revision: 1.2
#
#  Modified 2009/03/20 by Michael Meyer
#
#  Log: ssharath
#  Issue #0252
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

desc["english"] = "

  phpMyAdmin is running at this Host.

  phpMyAdmin is a free software tool written in PHP intended to handle
  the administration of MySQL over the World Wide Web. 

 Risk factor : None";

if(description)
{
 script_id(900129);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"General");
 script_name(english:"phpMyAdmin Detection");
 script_summary(english:"Set File Version of phpMyAdmin in KB and report about it");

 script_description(english:desc["english"]);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = get_http_port(default:80);
 if(!port){
        exit(0);
 }

 x = 0;
 foreach dir (make_list("/phpmyadmin","/phpMyAdmin","/pma", cgi_dirs()))
 {
        sndReq = http_get(item:string(dir, "/index.php"), port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
        if(rcvRes == NULL){
          exit(0);
        }

        if(
            egrep(pattern:"^Set-Cookie: pma_.*", string:rcvRes)       ||
	    egrep(pattern:"^Set-Cookie: phpMyAdmin.*",string:rcvRes)  ||
	    egrep(pattern:"phpMyAdmin was unable to read your configuration file",string:rcvRes)  ||
	    egrep(pattern:"<title>phpMyAdmin.*", string:rcvRes)       ||
            egrep(pattern:"href=.*phpmyadmin.css.php")                ||
	   (egrep(pattern:"pma_password", string:rcvRes) && egrep(pattern:"pma_username", string:rcvRes)) 	
          )
        {
                phpmaVer = eregmatch(pattern:"phpMyAdmin ([0-9.]+(?=-)*[rc0-9]*)", string:rcvRes);

		if(isnull(phpmaVer[0])) {
		  version = string("unknown");
		} else {
		  version = phpmaVer[1];
		}                
 
	 	  if(dir == "")dir = string("/");

		  pw_protected=0;

		  if(egrep(pattern:"1045", string:rcvRes) || 
                     egrep(pattern:"phpMyAdmin was unable to read your configuration file", string:rcvRes)) { 
		     pw_protected=2; # broken config
		  }
		  
		  if(egrep(pattern:"pma_username", string:rcvRes) &&
		     egrep(pattern:"pma_password", string:rcvRes)) { 
		     pw_protected=1; # username password required
		  } 
		  
		  set_kb_item(name:"www/"+ port + "/phpMyAdmin", value:version + " under " + dir);                
		  installations[x] = string(version + " under " + dir + ":" + pw_protected + "");
		  x++;
                 
	      }
 }
 

if(installations) {

 info = string("None\n\nphpMyAdmin was detected on the remote host in the following directory(s):\n\n"); 

 foreach found (installations) {

  infos = eregmatch(pattern:"(.*) under (/.*):+([0-2]+)", string:found);
  ver = infos[1];
  dir = infos[2];
  protected = infos[3];

  info += string("phpMyAdmin (Ver. ");
  info += ver;
  info += string(") under ");
  info += dir;
  if(protected == 0) {
   info += ". (Not protected by Username/Password)";
  }
  else if(protected == 2) {
    info += ". (Problem with configuration file)";
  }
  
  info +=string(".\n");

 }

 desc = ereg_replace(
    	string:desc["english"],
    	pattern:"None$",
    	replace:info
    );   

 security_note(port:port,data:desc);
 exit(0);

}

exit(0);
