###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xampp_detect_win.nasl 1065 2009-03-20 16:25:36Z mar $
#
# XAMPP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900526);
  script_version("Revision: 1.0 ");
  script_name(english:"XAMPP Version Detection");
  desc["english"] = "
  Overview: This script finds the installed XAMPP version and saves the
  version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the Version of XAMPP in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

xamppPort = get_kb_item("Services/www");
if(!xamppPort){
  exit(0);
}

foreach path (make_list("/", "/xampp", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:xamppPort);
  rcvRes = http_keepalive_send_recv(port:xamppPort, data:sndReq);

  if("XAMPP" >!< rcvRes)
  {
    sndReq = http_get(item:string(dir,"/start.php"), port:xamppPort);
    rcvRes = http_keepalive_send_recv(port:xamppPort, data:sndReq);
  }

  if("XAMPP" >< rcvRes)
  {
    xamppVer = eregmatch(pattern:"XAMPP.* ([0-9.]+)", string:rcvRes);
    if(xamppVer[1] != NULL)
    {
      set_kb_item(name:"www/" + xamppPort + "/XAMPP", value:xamppVer[1]);
      exit(0);
    }
    exit(0);
  }
}
