###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xitami_mult_format_string_vuln.nasl 1210 2009-05-05 12:39:43Z apr $
#
# Xitami Multiple Format String Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900548);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6519", "CVE-2008-6520");
  script_bugtraq_id(28603);
  script_name(english:"Xitami Multiple Format String Vulnerabilities");
  desc["english"] = "

  Overview: This host has Xitami web server installed and is prone to
  Multiple Format String Vulnerabilities.

  Vulnerability Insight:
  - Error exists while handling a format string specifiers in a Long Running
    Web Process (LRWP) request, which triggers incorrect logging code involving
    the sendfmt function in the SMT kernel.
  - Error in Server Side Includes (SSI) filter when processes requests with
    specially crafted URIs ending in .ssi, .shtm, or .shtml, which triggers
    incorrect logging code involving the sendfmt function in the SMT kernel.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary code
  and can lead to application crash.

  Impact Level: Application

  Affected Software/OS:
  Xitami version 2.5c2 and prior.

  Fix: No solution or patch is available as on 05th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.xitami.com/

  References:
  http://www.milw0rm.com/exploits/5354
  http://xforce.iss.net/xforce/xfdb/41644
  http://xforce.iss.net/xforce/xfdb/41645

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Xitami Web Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_xitami_server_detect.nasl");
  script_require_keys("Xitami/Ver");
  exit(0);
}


include("version_func.inc");

xVer = get_kb_item("Xitami/Ver");
if(xVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:xVer, test_version:"2.5.c2")){
  security_hole(0);
}
