#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90030);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2008-2152");
 name["english"] = "OpenOffice.org <= 2.4.1 vulnerability (Win)";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is probably affected by the vulnerabilities described in
CVE-2008-2152 or CVE-2008-3282 on 64-bit platform's

OpenOffice.org <= 2.4.1 vulnerability

Impact

   CVE-2008-2152
     Integer overflow in the rtl_allocateMemory function in
     sal/rtl/source/alloc_global.c in OpenOffice.org (OOo)
     2.0 through 2.4 allows remote attackers to execute
     arbitrary code via a crafted file that triggers a
     heap-based buffer overflow. 
   CVE-2008-3282
     Integer overflow in the rtl_allocateMemory function
     in sal/rtl/source/alloc_global.c in the memory allocator
     in OpenOffice.org (OOo) 2.4.1, on 64-bit platforms, allows
     remote attackers to cause a denial of service (application
     crash) or possibly execute arbitrary code via a crafted
     document, related to a 'numeric truncation error,' a
     different vulnerability than CVE-2008-2152. 
 
References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2152
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-3282

Solution:
    All OpenOffice.org users should upgrade to the latest version:


Risk factor : High
";

 script_description(english:desc["english"]);
 summary["english"] = "Determines OpenOffice.org <= 2.4.1 vulnerability";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The code starts here
#
include("version_func.inc");
include("smbcl_func.inc");
if( check_smbcl() == 0 ) exit(0);

sec_hole = 0;
sec_proto = "OpenOffice.org";
test_version = "2.4.9310";
ver = NULL;
r = NULL;

  sec_hole = 0;
  path = "Programme\";
  share ="C$";
  prog = "OpenOffice.org*";
  r = smbgetdir(share: share, dir: path+prog, typ: 2 );
  if( isnull(r) ) {
    path = "Program Files\";
    r = smbgetdir(share: share, dir: path+prog, typ: 2 );
  }
  if( !isnull(r) ) {
    foreach oodir (r) {
      file_spec = path+oodir+"\program\version.ini";
      r = smbgetdir(share: "C$", dir: file_spec, typ: 1 );
      if( !isnull(r) ) {
        tmp_filename = get_tmp_dir()+"tmpfile"+rand();
        if( smbgetfile(share: "C$", filename: file_spec, tmp_filename: tmp_filename) ) {
          ver = fread(tmp_filename);
          unlink(tmp_filename);
          if( ! isnull(ver) ) {
            version = ereg_replace(pattern:".+OOOBaseVersion=", string: ver, replace: "")+".";
            version = eregmatch(pattern:"([0-9]\.)+[0-9]+", string: version);
            build = ereg_replace(pattern:".+ProductBuildid=", string: ver, replace: "");
            build = eregmatch(pattern:"^[0-9]+", string: build);
            ver = version[0]+"."+build[0];
            set_kb_item(name: "OpenOffice.org/Build", value: ver);
            if( version_is_less(version:ver, test_version:test_version) ) {
              if(sec_hole == 0) {
                security_warning(port:0, proto:sec_proto);
                sec_hole = 1;
              }
              security_warning(port:0, proto:sec_proto, data:string("\nFound : ") + oodir + 
                                                                    "  Build : " + ver + string("\n"));
            }
          }
        }
      }
    }
  }
exit(0);
