#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90010);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2007-0043");
 name["english"] = ".NET JIT Compiler Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is affected by the vulnerabilitys described in
CVE-2007-0043

Checking if System.web.dll version is less than 2.0.50727.832

Impact
    The Just In Time (JIT) Compiler service in Microsoft 
    .NET Framework 1.0, 1.1, and 2.0 for Windows 2000, XP, 
    Server 2003, and Vista allows user-assisted remote 
    attackers to execute arbitrary code via unspecified 
    vectors involving an unchecked buffer, probably a 
    buffer overflow, aka .NET JIT Compiler Vulnerability.
    Checking if System.web.dll version is less than 2.0.50727.832

References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0043

Solution:
    All Users should upgrade to the latest version.


Risk factor : High";

 script_description(english:desc["english"]);
 summary["english"] = "Test for .NET JIT Compiler Vulnerability";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The code starts here
#

include("version_func.inc");
include("smbcl_func.inc");
if( check_smbcl() == 0 ) exit(0);

  test_version = "2.0.50727.832";
  win_dir = get_windir();
  if( !isnull(win_dir) ) {
    path = win_dir+"Microsoft.NET\Framework\";
    filespec = "v2*";
    r = smbgetdir(share: "C$", dir: path+filespec, typ: 2 );
    if( !isnull(r) ) {
      filespec = r[0]+"\"+"system.web.dll";
      r = smbgetdir(share: "C$", dir: path+filespec, typ: 1 );
      if( !isnull(r) ) {
          tmp_filename = get_tmp_dir()+"tmpfile"+rand();
          orig_filename = path+filespec;
          if( smbgetfile(share: "C$", filename: orig_filename, tmp_filename: tmp_filename) ) {
            v = GetPEFileVersion(tmp_filename:tmp_filename, orig_filename:orig_filename);
            unlink(tmp_filename);
            if( version_is_less(version: v, test_version: test_version) ) {
              security_hole(port:0, proto:"SMB");
              report = report + "Fileversion : C$ "+orig_filename + " "+v+string("\n");
              security_hole(port:0, proto:"SMB", data:report);
            }
          } else {
            report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
            security_note(port:0, proto:"SMB", data:report);
          }
      }
    } else {
      report = string(".NET V2xx not found/no access -> "+get_kb_item("SMB/ERROR")) + string("\n");
      security_note(port:0, proto:"SMB", data:report);	      
    }
  }

exit(0);
