/*

    Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
    trade-off using rainbow tables. 
    
    Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
    Hochreutiner, Andreas Huber and Etienne Dysli.

    Copyright 2006 Philippe Oechslin, Cedric Tissieres

    Ophcrack is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Ophcrack is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Ophcrack; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

    This program is released under the GPL with the additional exemption 
    that compiling, linking, and/or using OpenSSL is allowed.
*/

/* Reduction functions to make passwords from hashes */

/* 
 * $Log: make_redux.c,v $
 * Revision 2.3.4 2007/02/19 tissieres
 * German chars support
 *
 * Revision 2.3.1 2006/07/31  tissieres oechslin
 * Fix performance optimisation
 *
 * Revision 2.3 2006/07/21  tissieres oechslin
 * NTLM crack support
 *
 * Revision 2.2 2006/03/20  dysli oechslin
 * Extended charset support
 *
 * Revision 1.0  2004/07/09 12:54:15  oechslin
 * Initial revision
 *
 */


#include "make_hash.h"
#include "make_redux.h"



//LM chars
unsigned char chars[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
unsigned char ext_chars[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~"; /* all printable ASCII characters (except lowercase letters) -> 69 chars */

//NT chars
unsigned char nt_chars_low36[]="0123456789abcdefghijklmnopqrstuvwxyz";
unsigned char nt_chars_alphanum62[]="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
unsigned char nt_chars_ext95[]="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

//German chars
unsigned char german_chars[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~"; /* german ae, oe, ue, ss -> 4 chars */
int german_chars_size = 4;

int n_redux = 0; /* current number of the redux fucntion */
int ident_redux =0; /* row at which all tables share the same redux function */
int length_redux =0;
int limit_redux;
extern int chkpt1;
extern int chkpt2;
extern int table_type;
unsigned int max[9];
unsigned char* charset;
extern int chars_size;
extern int crack_type;
struct special_max spec_max[28];



//german chars
unsigned char ranks[28][35] = {
  {1,2,4,8,16,32,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {3,5,9,17,33,65,6,10,18,34,66,12,20,36,68,24,40,72,48,80,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {7,11,19,35,67,13,21,37,69,25,41,73,49,81,97,14,22,38,70,26,42,74,50,82,98,28,44,76,52,84,100,56,88,104,112},
  {1,2,4,8,16,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {3,5,9,17,33,6,10,18,34,12,20,36,24,40,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {15,23,39,71,27,43,75,51,83,99,29,45,77,53,85,101,57,89,105,113,30,46,78,54,86,102,58,90,106,114,60,92,108,116,120},
  {1,2,4,8,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {7,11,19,35,13,21,37,25,41,49,14,22,38,26,42,50,28,44,52,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {31,47,79,55,87,103,59,91,107,115,61,93,109,117,121,62,94,110,118,122,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {3,5,9,17,6,10,18,12,20,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {15,23,39,27,43,51,29,45,53,57,30,46,54,58,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,2,4,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {7,11,19,13,21,25,14,22,26,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {63,95,111,119,123,125,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {3,5,9,6,10,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {31,47,55,59,61,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {15,23,27,29,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,2,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {7,11,13,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {3,5,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  
};


static const signed char choose [8][8] = 
  { 1,0,0,0,0,0,0,0,
    1,1,0,0,0,0,0,0,
    1,2,1,0,0,0,0,0,
    1,3,3,1,0,0,0,0,
    1,4,6,4,1,0,0,0,
    1,5,10,10,5,1,0,0,
    1,6,15,20,15,6,1,0,
    1,7,21,35,35,21,7,1,
  };



/* initializes the variables that are necessary to find out which reduction 
   has to be applied in each column of each table */
void init_redux(int length, int ident)
{
  ident_redux=ident;
  length_redux=length;

  switch(crack_type) {
  case REDUX_LM_ALPHANUM10k:
  case REDUX_LM_ALPHANUM5k:
    chars_size = 36;
    charset = (unsigned char *)chars;
    max[7] = 119304647;
    max[6] = 3314018;
    max[5] = 92056;
    max[4] = 2557;
    max[3] = 71;
    max[2] = 2;
    break;
  case REDUX_LM_EXTENDED:
    chars_size = 69;
    charset = (unsigned char *)ext_chars;
    max[7]=62254232;
    max[6]=902235;
    max[5]=13076;
    max[4]=190;
    max[3]=3;
    max[2]=1;
    break;  
  case REDUX_LM_GERMAN:
    chars_size = 69;
    charset = (unsigned char *)ext_chars;
    spec_max[0].n=7; spec_max[0].k=1; spec_max[0].max=3560555371U;
    spec_max[1].n=7; spec_max[1].k=2; spec_max[1].max=4179782393U;
    spec_max[2].n=7; spec_max[2].k=3; spec_max[2].max=4239611091U;
    spec_max[3].n=6; spec_max[3].k=1; spec_max[3].max=4283841592U;
    spec_max[4].n=6; spec_max[4].k=2; spec_max[4].max=4290251810U;
    spec_max[5].n=7; spec_max[5].k=4; spec_max[5].max=4293720140U;
    spec_max[6].n=5; spec_max[6].k=1; spec_max[6].max=4294254325U;
    spec_max[7].n=6; spec_max[7].k=3; spec_max[7].max=4294749801U;
    spec_max[8].n=7; spec_max[8].k=5; spec_max[8].max=4294870439U;
    spec_max[9].n=5; spec_max[9].k=2; spec_max[9].max=4294932373U;
    spec_max[10].n=6; spec_max[10].k=4; spec_max[10].max=4294953915U;
    spec_max[11].n=4; spec_max[11].k=1; spec_max[11].max=4294960109U;
    spec_max[12].n=5; spec_max[12].k=3; spec_max[12].max=4294963699U;
    spec_max[13].n=7; spec_max[13].k=6; spec_max[13].max=4294966030U;
    spec_max[14].n=4; spec_max[14].k=2; spec_max[14].max=4294966569U;
    spec_max[15].n=6; spec_max[15].k=5; spec_max[15].max=4294967069U;
    spec_max[16].n=5; spec_max[16].k=4; spec_max[16].max=4294967173U;
    spec_max[17].n=3; spec_max[17].k=1; spec_max[17].max=4294967240U;
    spec_max[18].n=4; spec_max[18].k=3; spec_max[18].max=4294967261U;
    spec_max[19].n=7; spec_max[19].k=7; spec_max[19].max=4294967280U;
    spec_max[20].n=6; spec_max[20].k=6; spec_max[20].max=4294967285U;
    spec_max[21].n=3; spec_max[21].k=2; spec_max[21].max=4294967289U;
    spec_max[22].n=5; spec_max[22].k=5; spec_max[22].max=4294967290U;
    spec_max[23].n=2; spec_max[23].k=1; spec_max[23].max=4294967291U;
    spec_max[24].n=4; spec_max[24].k=4; spec_max[24].max=4294967292U;
    spec_max[25].n=3; spec_max[25].k=3; spec_max[25].max=4294967293U;
    spec_max[26].n=2; spec_max[26].k=2; spec_max[26].max=4294967294U;
    spec_max[27].n=1; spec_max[27].k=1; spec_max[27].max=4294967295U;
    break;
  case REDUX_NT_EXTENDED:
    chars_size = -1; // not used
    max[8] = 2584948056U;
    max[7] = 450317032;
    max[6] = 4740179;
    max[5] = 49896;
    max[4] = 525;
    max[3] = 6;
    max[2] = 1;
    break;

  }
}

void next_redux()
{
  n_redux++;
  if (n_redux == limit_redux)
    n_redux=ident_redux;
}	

void set_redux(int col, int table)
{
  n_redux = col + table*length_redux;
  /* cache this value to avoid recalculating it over and over in next_redux */
  limit_redux = (n_redux / length_redux)*length_redux + ident_redux;
  if (n_redux >= limit_redux )
    n_redux=n_redux % length_redux;
}

/* creates a new password from a given hash. 
   First the higher 4 bytes are Xored
   with n_redux. A variable length password is derived
   from the two ints that form the hash.*/

void make_redux(unsigned char *in, unsigned char *out)
{
  int i;
  unsigned int n;
  
  if (crack_type == REDUX_LM_ALPHANUM10k
      || crack_type == REDUX_LM_ALPHANUM5k
      || crack_type == REDUX_LM_EXTENDED ) {
    union {
      unsigned char p_bytes[8];
      unsigned int p_int[2];
    } p;
    
    /* xor with nredux */
    p.p_int[0] = *(int*)&in[0] ^ (int)n_redux;
    p.p_int[1] = *(int*)&in[4];
    
    n = p.p_int[1];

    /* get four chars out of the upper word and 3 of the lower 
       (avoids calculations with long long ints */
    for (i=0; i<4; i++) {out[i]=charset[p.p_int[0]%chars_size]; p.p_int[0]/=chars_size;} 
    for (i=4; i<7; i++) {out[i]=charset[p.p_int[1]%chars_size]; p.p_int[1]/=chars_size;} 
    
    /* truncate the password */
    if (n<max[7]) {
      out[6]=0; 
      if (n<max[6]) {
	out[5]=0; 
	if (n<max[5]) {
	  out[4]=0; 
	  if (n<max[4]) {
	    out[3]=0; 
	    if (n<max[3]) {
	      out[2]=0; 
	      if (n<max[2]) { 
		out[1]=0;	
	      }
	    }
	  }
	}
      }
    } 
  }
  else if (crack_type == REDUX_LM_GERMAN) {
    unsigned char len,k,x,rank,j= 0;
    unsigned int p_int[2];
    unsigned char chars1[8], chars2[8];
    
    /* xor with nredux */
    p_int[0] = *(int*)&in[0] ^ (int)n_redux;
    p_int[1] = *(int*)&in[4];
    
    n = p_int[1];
    
    if (n<=spec_max[0].max) 
      x=0;
    else
      if (n<=spec_max[1].max)
	x=1;
      else
	if (n<=spec_max[2].max)
	  x=2;
	else
	  for (i=3; i<28; i++)
	    if (n<=spec_max[i].max) {
	      x=i;
	      break;
	    }
    
    len = spec_max[x].n; k = spec_max[x].k;
    
    for (i=0; i<4 || i<(len-k); i++) {chars1[i]=charset[p_int[0]%chars_size]; p_int[0]/=chars_size;} 
    for (i=4; i<(len-k); i++) {chars1[i]=charset[p_int[1]%chars_size]; p_int[1]/=chars_size;} 
    
    rank = p_int[1]%choose[len][k];
    for (i=0; i<k; i++) {chars2[i]=german_chars[p_int[1]%german_chars_size]; p_int[1]/=german_chars_size;};
    
    for (i=0,j=0,k=0; i<len; i++)
      if (getbit(ranks[x][rank],i)) {out[i]=chars2[k];k++;}
      else {out[i]=chars1[j];j++;}
    for (i=len; i<7; i++)
      out[i]=0;
    
  }
  
  else if (crack_type == REDUX_NT_EXTENDED) {

    union {
      unsigned char p_bytes[8];
      unsigned int p_int[4];
    } p;
    
    /* xor with nredux */
    p.p_int[0] = *(int*)&in[0] ^ (int)n_redux;
    p.p_int[1] = *(int*)&in[4];
    p.p_int[2] = *(int*)&in[8];
    p.p_int[3] = *(int*)&in[12];
    
    n = p.p_int[3];
    if (n>max[8]) { //36 chars

      for (i=0; i<3; i++) {out[i]=nt_chars_low36[p.p_int[0]%36]; p.p_int[0]/=36;} 
      for (i=3; i<6; i++) {out[i]=nt_chars_low36[p.p_int[1]%36]; p.p_int[1]/=36;} 
      for (i=6; i<8; i++) {out[i]=nt_chars_low36[p.p_int[2]%36]; p.p_int[2]/=36;} 
    
    } else if (n>max[7]) { //62 chars

      for (i=0; i<3; i++) {out[i]=nt_chars_alphanum62[p.p_int[0]%62]; p.p_int[0]/=62;} 
      for (i=3; i<7; i++) {out[i]=nt_chars_alphanum62[p.p_int[1]%62]; p.p_int[1]/=62;} 

      out[7]=0;

    } else { //95 chars

      for (i=0; i<3; i++) {out[i]=nt_chars_ext95[p.p_int[0]%95]; p.p_int[0]/=95;} 
      for (i=3; i<6; i++) {out[i]=nt_chars_ext95[p.p_int[1]%95]; p.p_int[1]/=95;}

    /* truncate the password */
      out[7]=0;
      out[6]=0; 
      if (n<max[6]) {
	out[5]=0; 
	if (n<max[5]) {
	  out[4]=0; 
	  if (n<max[4]) {
	    out[3]=0; 
	    if (n<max[3]) {
	      out[2]=0; 
	      if (n<max[2]) { 
		out[1]=0;	
	      }
	    }
	  }
	}
      }
    }
  }
}  
	
