/*
 *   
 *   Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
 *   trade-off using rainbow tables. 
 *   
 *   Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
 *   Hochreutiner, Andreas Huber and Etienne Dysli.
 *   
 *   Copyright (c) 2008 Philippe Oechslin, Cedric Tissieres, Bertrand Mesot
 *   
 *   Ophcrack is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   Ophcrack is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Ophcrack; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *   
 *   This program is released under the GPL with the additional exemption 
 *   that compiling, linking, and/or using OpenSSL is allowed.
 *   
 *   
 *   $Rev: 124 $
 *   $Date: 2008-05-05 14:11:52 +0200 (Mon, 05 May 2008) $
 *   
 *   
*/
#include <config.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#ifdef WIN32
#define WINVER 0x0500
#include <windows.h>
#else
#if HAVE_SYS_SYSINFO_H
#include <sys/sysinfo.h>
#elif HAVE_SYS_SYSCTL_H
#include <sys/sysctl.h>
#endif
#endif

#include "misc.h"
/*-------------------------------------------------------------------------*/
#ifdef WIN32
char *strsep(char** stringp, const char* delim) {
  char *s;
  const char *spanp;
  int c, sc;
  char *tok;
  
  if ((s = *stringp) == NULL)
    return (NULL);
  for (tok = s;;) {
    c = *s++;
    spanp = delim;
    do {
      if ((sc = *spanp++) == c) {
	if (c == 0)
	  s = NULL;
	else
	  s[-1] = 0;
	*stringp = s;
	return (tok);
      }
    } while (sc != 0);
  }
  /* NOTREACHED */
}
#endif
/*-------------------------------------------------------------------------*/
uint64_t find_freeram(void) {
  ulong_t freeram  = 0;
  ulong_t cacheram = 0;

#ifndef WIN32
  FILE *file = fopen("/proc/meminfo", "r");
  char buff[STR_BUFF_SIZE];
  char *fst, *lst;

  /* Try to find the info we need from /proc/meminfo. */

  if (file) {
    fgets(buff, sizeof(buff), file);   /* MemTotal */
    fgets(buff, sizeof(buff), file);   /* MemFree  */

    fst = strchr(buff, ':');
    lst = strchr(fst+1, 'k');

    *lst = 0;
    sscanf(fst+1, "%lu", &freeram);

    fgets(buff, sizeof(buff), file);   /* Buffers */
    fgets(buff, sizeof(buff), file);   /* Cached  */

    fst = strchr(buff, ':');
    lst = strchr(fst+1, 'k');

    *lst = 0;
    sscanf(fst+1, "%lu", &cacheram);
    fclose(file);

    freeram = freeram << 10;
    cacheram = cacheram << 10;
  }

  /* Otherwise, we try to guess. */
  else {

#if HAVE_SYS_SYSINFO_H
    struct sysinfo info;   
    sysinfo(&info);
    freeram = (ulong_t)info.freeram;
    cacheram = 0;
#elif HAVE_SYS_SYSCTL_H
    int mib[2] = {CTL_HW, HW_USERMEM}, mem;
    size_t len;
    len = sizeof(mem);
    if (sysctl(mib, 2, &mem, &len, NULL, 0) == 0) {
      freeram = mem;
      cacheram = 0;
    } else {
      return 0;
    }
#else
    /* unix system but we don't know how to get available RAM */
    return 0;
#endif
    
  }
#else
  MEMORYSTATUSEX statex;
  statex.dwLength = sizeof(statex);
  GlobalMemoryStatusEx(&statex);
  freeram  = (ulong_t)statex.ullAvailPhys;

  cacheram = 0;
#endif

  /* Take 90% of the available free RAM and return the resulting value
     in bytes (not kB). */

  uint64_t ram = floor(0.9 * (freeram + cacheram));

  return ram;
}
/*-------------------------------------------------------------------------*/
void convert_to_colon(uchar_t *input) {
  uchar_t *tmp;

  for (tmp = input; (*tmp = (*tmp == 193U ? ':' : *tmp)); ++tmp);
}
/*-------------------------------------------------------------------------*/
void convert_from_colon(uchar_t *input) {
  uchar_t *tmp;

  for (tmp = input; (*tmp = (*tmp == ':' ? 193U : *tmp)); ++tmp);
}
/*-------------------------------------------------------------------------*/
void wincp1252_to_ascii(uchar_t *str) {
  int len = strlen((char*)str);
  int i;

  for (i=0; i<len; i++)
    if (str[i] >= 128) 
      switch (str[i]) {
      case 0x8e: str[i] = 0xc4; break; // capital a umlaut
      case 0x99: str[i] = 0xd6; break; // capital o umlaut
      case 0x9a: str[i] = 0xdc; break; // capital u umlaut
      case 0xe1: str[i] = 0xdf; break; // double s (sharp/german s)
      case 0xa5: str[i] = 0xd1; break; // capital n tilda
      case 0x90: str[i] = 0xc9; break; // capital e accute
      case 0x80: str[i] = 0xc7; break; // capital c cedilla
      }
}
/*-------------------------------------------------------------------------*/
void fprintf_hex(FILE *file, char *str, int len) {
  int i;

  fprintf(file, "0x");

  for (i=0; i<len; ++i) 
    fprintf(file, "%2x", str[i]);
}
