node default{
  case $role 
  {
    'undefined': { include sudo }
    /^hadoop-master:(.*)/: { class { hadoop_master: clustername => $1 } }
    /^hadoop-slave:(.*)/: { class { hadoop_slave: clustername => $1 } }
    /^hadoop-namenode:(.*):(.*):(.*)/: { class { hadoop_namenode: namenode => $1, jobtracker => $2, hdfsdatadir => $3 } }
    /^hadoop-jobtracker:(.*):(.*):(.*)/: { class { hadoop_jobtracker: namenode => $1, jobtracker => $2, hdfsdatadir => $3 } }
    /^hadoop-datanode:(.*):(.*):(.*)/: { class { hadoop_datanode: namenode => $1, jobtracker => $2, hdfsdatadir => $3 } }
    /^hadoop-tasktracker:(.*):(.*):(.*)/: { class { hadoop_tasktracker: namenode => $1, jobtracker => $2, hdfsdatadir => $3 } }
    'hadoop-pseudo': { include hadoop_pseudo }
    /^gearman-job-server:(.*)/: { class { gearman_job_server: deploymentname => $1 } }
    /^gearman-worker:(.*)/: { class { gearman_worker: deploymentname => $1 } }
    'mongodb-master': { include mongodb_master }
    /^mongodb-master:(.*)/: { class { mongodb_master: deploymentname => $1 } }
    /^mongodb-slave:(.*)/: { class { mongodb_slave: deploymentname => $1 } }
    /^mongodb-replicaset:(.*)/: { class { mongodb_replicaset: deploymentname => $1 } }
    'mongodb-replicaset': { include mongodb_replicaset }
    /^distcc:(.*)/: { class { distcc: farmname => $1 } }
    /^apache:(\w+):(\w+):modules:(.*)/: { class { apache: sitename => $1, clustername => $2, modules => $3 } }
    /^apache:(\w+):(\w+)/: { class { apache: sitename => $1, clustername => $2 } }
    /^haproxy:(.*)/: { class { haproxy: clustername => $1 } }
    /^glusterfs-server:(.*)/: { class { glusterfs_server: clustername => $1 } }
    /^glusterfs-client:(.*)/: { class { glusterfs_client: clustername => $1 } }
    /^mpi-master:(.*)/: { class { mpi_master: clustername => $1 } }
    /^mpi-client:(.*)/: { class { mpi_client: clustername => $1 } }
    /^tomcat6:(\w+):admin_username:(\w+):admin_password:(\w+)/: { class { tomcat6: clustername => $1, admin_username => $2, admin_password => $3 } }
    /^tomcat6:(\w+)/: { class { tomcat6: clustername => $1 } }
    /^apache-tomcat6:(\w+):admin_username:(\w+):admin_password:(\w+)/: { class { tomcat6: clustername => $1, admin_username => $2, admin_password => $3, enable_ajp => true } }
    /^apache-tomcat6:(\w+)/: { class { tomcat6: clustername => $1, enable_ajp => true } }
    /^mysqlebs-master:(.*):(.*)/: { class { mysqlebs_master: clustername => $1, cloudzone => $2, volname => $3 } }
    /^mysqlebs-slave:(.*):(.*)/: { class { mysqlebs_slave: clustername => $1, cloudzone => $2 } }
    /^mysql-master:(\w+):admin_password:(.*)/: { class { mysql_master: clustername => $1, admin_password => $2 } }
    /^mysql-master:(\w+)/: { class { mysql_master: clustername => $1 } }
    /^mysql-slave:(\w+):admin_password:(.*)/: { class { mysql_slave: clustername => $1, admin_password => $2 } }
    /^mysql-slave:(\w+)/: { class { mysql_slave: clustername => $1 } }
  }

}
