class glusterfs_server( $clustername = $uniqueid, $volume_name = "brick", $export_dir = "/home/export", $listen_port = "6996" )
{
  package{"glusterfs-server": ensure => installed }

  exec{"glusterfs_export":
    command => "mkdir -p ${export_dir}",
    unless => "test -d ${export_dir}",
    require => Package["glusterfs-server"],
  }

  file {"glusterfsd_vol":
    name    => "/etc/glusterfs/glusterfsd.vol",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Exec["glusterfs_export"],
    notify => Service["glusterfs-server"],
    content => template("/etc/puppet/modules/orchestra-glusterfs/templates/glusterfsd.vol.erb"),
  }

  service {"glusterfs-server":
    ensure => running,
    enable => true,
    subscribe => File["glusterfsd_vol"],
    hasstatus => true,
    restart   => "/etc/init.d/glusterfs-server restart",
    require => File["glusterfsd_vol"],
  }
  
  exec{"${clustername}_dir":
    command => "mkdir -p /etc/glusterfs/${clustername}",
    unless => "test -d /etc/glusterfs/${clustername}",
    require => Package["glusterfs-server"],
  }

  @@file{"/etc/glusterfs/${clustername}/$uniqueid.server_config":
    content => template("/etc/puppet/modules/orchestra-glusterfs/templates/server_config.erb"),
    tag => "${clustername}",
    ensure => present,
    require => Exec["glusterfs_${clustername}_dir"],
  }

  @@file{"/etc/glusterfs/${clustername}/$uniqueid.server":
    content => "$hostname ",
    tag => "${clustername}",
    ensure => present,
    require => Exec["glusterfs_${clustername}_dir"],
  }

} 
 
