/*
 * stock.c
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 * Stock icon code, stolen from:
 *  Eye of Gnome image viewer - stock icons
 *
 * Copyright (C) 1999 The Free Software Foundation
 *
 * Author: Federico Mena-Quintero <federico@gimp.org>
 */

#include <config.h>
#include <gnome.h>
#include "stock.h"
#include "stock/sim-settings.xpm"
#include "stock/rotate.xpm"
#include "stock/zoom_in.xpm"
#include "stock/zoom_out.xpm"
#include "stock/plot.xpm"
#include "stock/part-browser.xpm"
#include "stock/grid.xpm"
#include "stock/arrow.xpm"
#include "stock/text.xpm"
#include "stock/wire.xpm"
#include "stock/voltmeter.xpm"

void
stock_init (void)
{
	static GnomeStockPixmapEntry entries[11];

	entries[0].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[0].data.width = 24;
	entries[0].data.height = 24;
	entries[0].data.xpm_data = sim_settings_xpm;

	entries[1].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[1].data.width = 24;
	entries[1].data.height = 24;
	entries[1].data.xpm_data = rotate_xpm;

	entries[2].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[2].data.width = 24;
	entries[2].data.height = 24;
	entries[2].data.xpm_data = zoom_in_xpm;

	entries[3].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[3].data.width = 24;
	entries[3].data.height = 24;
	entries[3].data.xpm_data = zoom_out_xpm;

	entries[4].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[4].data.width = 24;
	entries[4].data.height = 24;
	entries[4].data.xpm_data = plot_xpm;

	entries[5].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[5].data.width = 24;
	entries[5].data.height = 24;
	entries[5].data.xpm_data = part_browser_xpm;

	entries[6].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[6].data.width = 24;
	entries[6].data.height = 24;
	entries[6].data.xpm_data = grid_xpm;

	entries[7].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[7].data.width = 24;
	entries[7].data.height = 24;
	entries[7].data.xpm_data = arrow_xpm;

	entries[8].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[8].data.width = 24;
	entries[8].data.height = 24;
	entries[8].data.xpm_data = text_xpm;

	entries[9].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[9].data.width = 24;
	entries[9].data.height = 24;
	entries[9].data.xpm_data = wire_xpm;

	entries[10].data.type = GNOME_STOCK_PIXMAP_TYPE_DATA;
	entries[10].data.width = 24;
	entries[10].data.height = 24;
	entries[10].data.xpm_data = voltmeter_xpm;

	gnome_stock_pixmap_register (STOCK_PIXMAP_SIM_SETTINGS, GNOME_STOCK_PIXMAP_REGULAR, &entries[0]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_ROTATE, GNOME_STOCK_PIXMAP_REGULAR, &entries[1]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_ZOOM_IN, GNOME_STOCK_PIXMAP_REGULAR, &entries[2]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_ZOOM_OUT, GNOME_STOCK_PIXMAP_REGULAR, &entries[3]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_PLOT, GNOME_STOCK_PIXMAP_REGULAR, &entries[4]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_PART_BROWSER, GNOME_STOCK_PIXMAP_REGULAR, &entries[5]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_GRID, GNOME_STOCK_PIXMAP_REGULAR, &entries[6]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_ARROW, GNOME_STOCK_PIXMAP_REGULAR, &entries[7]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_TEXT, GNOME_STOCK_PIXMAP_REGULAR, &entries[8]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_WIRE, GNOME_STOCK_PIXMAP_REGULAR, &entries[9]);
	gnome_stock_pixmap_register (STOCK_PIXMAP_VOLTMETER, GNOME_STOCK_PIXMAP_REGULAR, &entries[10]);
}
