/**
 * Orthanc - A Lightweight, RESTful DICOM Store
 * Copyright (C) 2012-2016 Sebastien Jodogne, Medical Physics
 * Department, University Hospital of Liege, Belgium
 * Copyright (C) 2017-2023 Osimis S.A., Belgium
 * Copyright (C) 2024-2024 Orthanc Team SRL, Belgium
 * Copyright (C) 2021-2024 Sebastien Jodogne, ICTEAM UCLouvain, Belgium
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, see
 * <http://www.gnu.org/licenses/>.
 **/

// This file is autogenerated by "../Resources/GenerateTransferSyntaxes.py"

namespace Orthanc
{
  bool FromDcmtkBridge::LookupDcmtkTransferSyntax(E_TransferSyntax& target,
                                                  DicomTransferSyntax source)
  {
    switch (source)
    {
      case DicomTransferSyntax_LittleEndianImplicit:
        target = EXS_LittleEndianImplicit;
        return true;

      case DicomTransferSyntax_LittleEndianExplicit:
        target = EXS_LittleEndianExplicit;
        return true;

      case DicomTransferSyntax_DeflatedLittleEndianExplicit:
        target = EXS_DeflatedLittleEndianExplicit;
        return true;

      case DicomTransferSyntax_BigEndianExplicit:
        target = EXS_BigEndianExplicit;
        return true;

      case DicomTransferSyntax_JPEGProcess1:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess1TransferSyntax;
#  else
        target = EXS_JPEGProcess1;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess2_4:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess2_4TransferSyntax;
#  else
        target = EXS_JPEGProcess2_4;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess3_5:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess3_5TransferSyntax;
#  else
        target = EXS_JPEGProcess3_5;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess6_8:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess6_8TransferSyntax;
#  else
        target = EXS_JPEGProcess6_8;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess7_9:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess7_9TransferSyntax;
#  else
        target = EXS_JPEGProcess7_9;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess10_12:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess10_12TransferSyntax;
#  else
        target = EXS_JPEGProcess10_12;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess11_13:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess11_13TransferSyntax;
#  else
        target = EXS_JPEGProcess11_13;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess14:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess14TransferSyntax;
#  else
        target = EXS_JPEGProcess14;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess15:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess15TransferSyntax;
#  else
        target = EXS_JPEGProcess15;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess16_18:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess16_18TransferSyntax;
#  else
        target = EXS_JPEGProcess16_18;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess17_19:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess17_19TransferSyntax;
#  else
        target = EXS_JPEGProcess17_19;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess20_22:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess20_22TransferSyntax;
#  else
        target = EXS_JPEGProcess20_22;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess21_23:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess21_23TransferSyntax;
#  else
        target = EXS_JPEGProcess21_23;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess24_26:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess24_26TransferSyntax;
#  else
        target = EXS_JPEGProcess24_26;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess25_27:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess25_27TransferSyntax;
#  else
        target = EXS_JPEGProcess25_27;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess28:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess28TransferSyntax;
#  else
        target = EXS_JPEGProcess28;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess29:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess29TransferSyntax;
#  else
        target = EXS_JPEGProcess29;
#  endif
        return true;

      case DicomTransferSyntax_JPEGProcess14SV1:
#  if DCMTK_VERSION_NUMBER <= 360
        target = EXS_JPEGProcess14SV1TransferSyntax;
#  else
        target = EXS_JPEGProcess14SV1;
#  endif
        return true;

      case DicomTransferSyntax_JPEGLSLossless:
        target = EXS_JPEGLSLossless;
        return true;

      case DicomTransferSyntax_JPEGLSLossy:
        target = EXS_JPEGLSLossy;
        return true;

      case DicomTransferSyntax_JPEG2000LosslessOnly:
        target = EXS_JPEG2000LosslessOnly;
        return true;

      case DicomTransferSyntax_JPEG2000:
        target = EXS_JPEG2000;
        return true;

      case DicomTransferSyntax_JPEG2000MulticomponentLosslessOnly:
        target = EXS_JPEG2000MulticomponentLosslessOnly;
        return true;

      case DicomTransferSyntax_JPEG2000Multicomponent:
        target = EXS_JPEG2000Multicomponent;
        return true;

      case DicomTransferSyntax_JPIPReferenced:
        target = EXS_JPIPReferenced;
        return true;

      case DicomTransferSyntax_JPIPReferencedDeflate:
        target = EXS_JPIPReferencedDeflate;
        return true;

      case DicomTransferSyntax_MPEG2MainProfileAtMainLevel:
        target = EXS_MPEG2MainProfileAtMainLevel;
        return true;

      case DicomTransferSyntax_MPEG2MainProfileAtHighLevel:
        target = EXS_MPEG2MainProfileAtHighLevel;
        return true;

#if DCMTK_VERSION_NUMBER >= 361
      case DicomTransferSyntax_MPEG4HighProfileLevel4_1:
        target = EXS_MPEG4HighProfileLevel4_1;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case DicomTransferSyntax_MPEG4BDcompatibleHighProfileLevel4_1:
        target = EXS_MPEG4BDcompatibleHighProfileLevel4_1;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case DicomTransferSyntax_MPEG4HighProfileLevel4_2_For2DVideo:
        target = EXS_MPEG4HighProfileLevel4_2_For2DVideo;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case DicomTransferSyntax_MPEG4HighProfileLevel4_2_For3DVideo:
        target = EXS_MPEG4HighProfileLevel4_2_For3DVideo;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case DicomTransferSyntax_MPEG4StereoHighProfileLevel4_2:
        target = EXS_MPEG4StereoHighProfileLevel4_2;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 362
      case DicomTransferSyntax_HEVCMainProfileLevel5_1:
        target = EXS_HEVCMainProfileLevel5_1;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 362
      case DicomTransferSyntax_HEVCMain10ProfileLevel5_1:
        target = EXS_HEVCMain10ProfileLevel5_1;
        return true;
#endif

      case DicomTransferSyntax_RLELossless:
        target = EXS_RLELossless;
        return true;

      default:
        return false;
    }
  }
  

  bool FromDcmtkBridge::LookupOrthancTransferSyntax(DicomTransferSyntax& target,
                                                    E_TransferSyntax source)
  {
    switch (source)
    {
      case EXS_LittleEndianImplicit:
        target = DicomTransferSyntax_LittleEndianImplicit;
        return true;

      case EXS_LittleEndianExplicit:
        target = DicomTransferSyntax_LittleEndianExplicit;
        return true;

      case EXS_DeflatedLittleEndianExplicit:
        target = DicomTransferSyntax_DeflatedLittleEndianExplicit;
        return true;

      case EXS_BigEndianExplicit:
        target = DicomTransferSyntax_BigEndianExplicit;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess1TransferSyntax:
#  else
      case EXS_JPEGProcess1:
#  endif
        target = DicomTransferSyntax_JPEGProcess1;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess2_4TransferSyntax:
#  else
      case EXS_JPEGProcess2_4:
#  endif
        target = DicomTransferSyntax_JPEGProcess2_4;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess3_5TransferSyntax:
#  else
      case EXS_JPEGProcess3_5:
#  endif
        target = DicomTransferSyntax_JPEGProcess3_5;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess6_8TransferSyntax:
#  else
      case EXS_JPEGProcess6_8:
#  endif
        target = DicomTransferSyntax_JPEGProcess6_8;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess7_9TransferSyntax:
#  else
      case EXS_JPEGProcess7_9:
#  endif
        target = DicomTransferSyntax_JPEGProcess7_9;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess10_12TransferSyntax:
#  else
      case EXS_JPEGProcess10_12:
#  endif
        target = DicomTransferSyntax_JPEGProcess10_12;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess11_13TransferSyntax:
#  else
      case EXS_JPEGProcess11_13:
#  endif
        target = DicomTransferSyntax_JPEGProcess11_13;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess14TransferSyntax:
#  else
      case EXS_JPEGProcess14:
#  endif
        target = DicomTransferSyntax_JPEGProcess14;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess15TransferSyntax:
#  else
      case EXS_JPEGProcess15:
#  endif
        target = DicomTransferSyntax_JPEGProcess15;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess16_18TransferSyntax:
#  else
      case EXS_JPEGProcess16_18:
#  endif
        target = DicomTransferSyntax_JPEGProcess16_18;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess17_19TransferSyntax:
#  else
      case EXS_JPEGProcess17_19:
#  endif
        target = DicomTransferSyntax_JPEGProcess17_19;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess20_22TransferSyntax:
#  else
      case EXS_JPEGProcess20_22:
#  endif
        target = DicomTransferSyntax_JPEGProcess20_22;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess21_23TransferSyntax:
#  else
      case EXS_JPEGProcess21_23:
#  endif
        target = DicomTransferSyntax_JPEGProcess21_23;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess24_26TransferSyntax:
#  else
      case EXS_JPEGProcess24_26:
#  endif
        target = DicomTransferSyntax_JPEGProcess24_26;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess25_27TransferSyntax:
#  else
      case EXS_JPEGProcess25_27:
#  endif
        target = DicomTransferSyntax_JPEGProcess25_27;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess28TransferSyntax:
#  else
      case EXS_JPEGProcess28:
#  endif
        target = DicomTransferSyntax_JPEGProcess28;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess29TransferSyntax:
#  else
      case EXS_JPEGProcess29:
#  endif
        target = DicomTransferSyntax_JPEGProcess29;
        return true;

#  if DCMTK_VERSION_NUMBER <= 360
      case EXS_JPEGProcess14SV1TransferSyntax:
#  else
      case EXS_JPEGProcess14SV1:
#  endif
        target = DicomTransferSyntax_JPEGProcess14SV1;
        return true;

      case EXS_JPEGLSLossless:
        target = DicomTransferSyntax_JPEGLSLossless;
        return true;

      case EXS_JPEGLSLossy:
        target = DicomTransferSyntax_JPEGLSLossy;
        return true;

      case EXS_JPEG2000LosslessOnly:
        target = DicomTransferSyntax_JPEG2000LosslessOnly;
        return true;

      case EXS_JPEG2000:
        target = DicomTransferSyntax_JPEG2000;
        return true;

      case EXS_JPEG2000MulticomponentLosslessOnly:
        target = DicomTransferSyntax_JPEG2000MulticomponentLosslessOnly;
        return true;

      case EXS_JPEG2000Multicomponent:
        target = DicomTransferSyntax_JPEG2000Multicomponent;
        return true;

      case EXS_JPIPReferenced:
        target = DicomTransferSyntax_JPIPReferenced;
        return true;

      case EXS_JPIPReferencedDeflate:
        target = DicomTransferSyntax_JPIPReferencedDeflate;
        return true;

      case EXS_MPEG2MainProfileAtMainLevel:
        target = DicomTransferSyntax_MPEG2MainProfileAtMainLevel;
        return true;

      case EXS_MPEG2MainProfileAtHighLevel:
        target = DicomTransferSyntax_MPEG2MainProfileAtHighLevel;
        return true;

#if DCMTK_VERSION_NUMBER >= 361
      case EXS_MPEG4HighProfileLevel4_1:
        target = DicomTransferSyntax_MPEG4HighProfileLevel4_1;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case EXS_MPEG4BDcompatibleHighProfileLevel4_1:
        target = DicomTransferSyntax_MPEG4BDcompatibleHighProfileLevel4_1;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case EXS_MPEG4HighProfileLevel4_2_For2DVideo:
        target = DicomTransferSyntax_MPEG4HighProfileLevel4_2_For2DVideo;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case EXS_MPEG4HighProfileLevel4_2_For3DVideo:
        target = DicomTransferSyntax_MPEG4HighProfileLevel4_2_For3DVideo;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 361
      case EXS_MPEG4StereoHighProfileLevel4_2:
        target = DicomTransferSyntax_MPEG4StereoHighProfileLevel4_2;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 362
      case EXS_HEVCMainProfileLevel5_1:
        target = DicomTransferSyntax_HEVCMainProfileLevel5_1;
        return true;
#endif

#if DCMTK_VERSION_NUMBER >= 362
      case EXS_HEVCMain10ProfileLevel5_1:
        target = DicomTransferSyntax_HEVCMain10ProfileLevel5_1;
        return true;
#endif

      case EXS_RLELossless:
        target = DicomTransferSyntax_RLELossless;
        return true;

      default:
        return false;
    }
  }
}
