
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    osirisd.h
**  Date:    February 17, 2002
**
**  Author:  Brian Wotring
**  Purpose: scanning daemon options.
**
******************************************************************************/

#ifndef OSIRISD_H_
#define OSIRISD_H_

/* program version and name. */

#define PROGRAM_NAME     	    "osirisd"

/* paramaters for server process. */

#define LISTEN_QUEUE_MAX  5

/* exit codes for this daemon. */

#define EXIT_CODE_ERROR  -1
#define EXIT_CODE_NORMAL  0

/* paramaters for SSL */

#define OSIRISD_CIPHER_LIST               "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH"
#define OSIRISD_SERVER_CERT_CHAIN_DEPTH   4
#define OSIRISD_SSL_OPTIONS               ( SSL_OP_ALL|SSL_OP_NO_SSLv2 )

#define HOST_SESSION_KEY_LENGTH	     	  64

/* macros for selecting on important sockets. */

#define INCOMING_SERVER_REQUEST()	( FD_ISSET( server_socket, &read_set ) )
#define INCOMING_CONFIG_REQUEST()	( FD_ISSET( config_socket, &read_set ) )

#ifdef WIN32
#define THREAD_FUNCTION_TYPE unsigned __stdcall
#define THREAD_FUNCTION_RETURN 0
#else
#define THREAD_FUNCTION_TYPE void
#define THREAD_FUNCTION_RETURN
#endif

#define ROOT_CERT_NAME			"osiris_root.pem"

/* function prototypes. */

void set_platform_info();

THREAD_FUNCTION_TYPE run( void *unused );
void become_windows_service();

void initialize_root_path();
void initialize_priv_pipes();
void initialize_logger();
void initialize_winsock();

void fork_daemons();
void fork_scanning_process();

void initialize_signals();
void initialize_ssl();

void handle_sigint( int signal );
void handle_sigterm( int signal );
void handle_sigchld( int signal );
void handle_sigpipe( int signal );
void handle_sigkill( int signal );
void handle_sighup( int signal );

void check_for_signals();
void cleanup_threads();

void start_server();
void close_logger();

void shutdown_server();
void shutdown_ssl();

THREAD_FUNCTION_TYPE run_scanner( void *unused );
void process();

void halt( int code );
osi_bool reset_config();

int ssl_verify_callback( int ok, X509_STORE_CTX *store );

void process_new_request();
void process_config_request();

/* message routines. */

int process_incoming_message( MESSAGE *message );
int process_outgoing_message( MESSAGE *message );

void start_scan();
void stop_scan();

void start_config_push( MESSAGE *message );
void stop_config_push( MESSAGE *message );

void wait_for_data();
void assume_connection_socket( int *new_socket );
void assume_ssl_connection( SSL **new_ssl_connection );

void issue_status_response();
void set_state( int new_state );
void drop_config();

void process_config_data( MESSAGE *message );
void perform_session_key_negotiation();

void parse_arguments( int argument_count, char *argument_list[] );
void print_usage();

#endif
