
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      filter_file.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>

#include "utilities.h"

#include "regex.h"
#include "scan_record.h"
#include "filter.h"

#define REGEX_FLAGS   (REG_EXTENDED|REG_ICASE|REG_NOSUB)

osi_bool name_regex( const char *name, const char *pattern )
{
    regex_t preg;
    regmatch_t results;

    if( name != NULL && pattern != NULL )
    {
        if( strlen( pattern ) == 1 && pattern[0] == '*' )
        {
            return TRUE;
        }

        memset( &preg, 0, sizeof( preg ) );
        memset( &results, 0, sizeof( results ) );

        if( hs_regcomp( &preg, pattern, REGEX_FLAGS ) == 0 )
        {
            if( hs_regexec( &preg, name, 1, &results, 0 ) == 0 )
            {
                hs_regfree( &preg );
                return TRUE;
            }

            hs_regfree( &preg );
        }
    }

    return FALSE;
}


osi_bool filter_file( const char *file_path, FILTER_CONTEXT *context )
{
    if( ( file_path == NULL ) || ( context == NULL ) || 
        ( context->filter_argument == NULL ) )
    {
        return FALSE;
    }

    return name_regex( file_path, context->filter_argument );
}

