
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      filter_gzip.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

osi_bool filter_gzip( const char *file_path, FILTER_CONTEXT *context )
{
    char number[3] = "\0\0\0";
    int length = 0;
    
    if( ( file_path != NULL ) && ( context != NULL ) )
    {
        if( context->file_handle == NULL )
        {
            context->file_handle = osi_fopen( file_path, "r", 0 );
        }

        else
        {
            fseek( context->file_handle, 0, SEEK_SET );
        }

        if( context->file_handle != NULL )
        {
            length = fread( number, 1, 2, context->file_handle );
        
            if( length == 2 )
            {        
                if( number[0] == '\037' && number[1] == '\213')
                {
                    return TRUE;
                }
            }
        }
    }

    return FALSE;
}

