
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      filter_permissions.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

#ifdef WIN32

osi_bool filter_permissions( const char *file_path, FILTER_CONTEXT *context )
{
    return FALSE;
}

#else

osi_bool filter_permissions( const char *file_path, FILTER_CONTEXT *context )
{
    char permissions[PERMISSIONS_STRING_LENGTH] = "";
    
    int index            = 0;
    int argument_length  = 0;
    
    if( ( file_path != NULL ) && ( context != NULL ) &&
        ( context->filter_argument != NULL ) )
    {
        if( context->file_stats != NULL )
        {
            argument_length = strlen( context->filter_argument );
            get_file_attribute_string( permissions, sizeof( permissions ),
                                       context->file_stats->st_mode );
        
            for( index = 0;
                 ( index < PERMISSIONS_STRING_LENGTH ) &&
                 ( index < argument_length );
                 index++ )
            {
                /* bit is equal or wildcard, move on to the next one. */
        
                if( ( context->filter_argument[index] == permissions[index] ) ||
                      context->filter_argument[index] == '*' )
                {
                    continue;
                }
        
                /* otherwise, it's not equal, filter fails to catch this one. */
        
                return FALSE;
            }
        }
    }

    return TRUE;
}

#endif
