
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    status.h
**  Date:    March 12, 2002
**  
**  Author:  Brian Wotring
**  Purpose: status handling routines.
**
******************************************************************************/

#ifndef STATUS_H_
#define STATUS_H_


#define STATE_UNKNOWN_STRING		"unknown"


/* configuration module states */

#define CONFIG_STATE_NULL	 	0
#define CONFIG_STATE_RECEIVING 	1
#define CONFIG_STATE_VALID	 	2
#define CONFIG_STATE_INVALID 	3

#define CONFIG_STATE_STRING_NULL        "no config present"
#define CONFIG_STATE_STRING_RECEIVING	"receiving config"
#define CONFIG_STATE_STRING_VALID       "current config is valid"
#define CONFIG_STATE_STRING_INVALID	    "current config is invalid"

/* daemon module states */

#define DAEMON_STATE_IDLE        	0
#define DAEMON_STATE_RECEIVING   	1
#define DAEMON_STATE_SCANNING    	2

#define DAEMON_STATE_STRING_IDLE	    "idle"
#define DAEMON_STATE_STRING_RECEIVING	"receiving config"
#define DAEMON_STATE_STRING_SCANNING	"scanning host environment..."


#define MAX_STATUS_VERSION_LENGTH       20

#define MAX_STATUS_OS_NAME_LENGTH       30              
#define MAX_STATUS_OS_VERSION_LENGTH    20

typedef struct OSI_STATUS
{
    osi_uint32 start_time;
    osi_uint32 current_time;
    osi_uint32 config_time;
    
    osi_uint16 config_state;
    osi_uint16 daemon_state;

    char osiris_version[MAX_STATUS_VERSION_LENGTH];
    char config_id[MAX_CHECKSUM_LENGTH];

    char os_name[MAX_STATUS_OS_NAME_LENGTH];
    char os_version[MAX_STATUS_OS_VERSION_LENGTH];
    
    osi_uint16 reserved1;
    osi_uint16 reserved2;

} OSI_STATUS;


char * get_name_for_daemon_status( int status );
char * get_name_for_config_status( int status );

void wrap_status( OSI_STATUS *status );
void unwrap_status( OSI_STATUS *status );


#endif


