--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: gb_postcode; Type: TABLE; Schema: public; Owner: twain; Tablespace: 
--

CREATE TABLE gb_postcode (
    nextval bigint,
    postcode character varying(9),
    countrycode character(2),
    geometry geometry,
    CONSTRAINT enforce_dims_geometry CHECK ((ndims(geometry) = 2)),
    CONSTRAINT enforce_srid_geometry CHECK ((srid(geometry) = 4326))
);


ALTER TABLE public.gb_postcode OWNER TO twain;

--
-- Data for Name: gb_postcode; Type: TABLE DATA; Schema: public; Owner: twain
--

COPY gb_postcode (nextval, postcode, countrycode, geometry) FROM stdin;
73040	CV5 7BH	GB	0101000020E6100000541EDD088B0AF9BF73BB97FBE4344A40
73041	CV5 7BX	GB	0101000020E6100000CC9717601F5DF9BFF241CF66D5354A40
73042	CV5 7DA	GB	0101000020E610000046B247A81992F9BF8E1EBFB7E9354A40
73043	CV5 7DJ	GB	0101000020E6100000917C2590123BF9BF67463F1A4E354A40
73044	CV5 7DS	GB	0101000020E610000041BB438A0112F9BFA60BB1FA23344A40
73045	CV5 7FQ	GB	0101000020E6100000F0F78BD99295F9BF3E95D39E92354A40
73046	CV5 7JR	GB	0101000020E6100000022EC896E52BF9BF4FC939B187344A40
73047	CV5 7LH	GB	0101000020E6100000B741EDB77622F9BF15AB06616E354A40
73048	CV5 7NH	GB	0101000020E6100000020F0C207C28F9BF431CEBE236364A40
73049	CV5 7NJ	GB	0101000020E6100000E3C5C210393DF9BF50E1085229364A40
73050	CV5 7NX	GB	0101000020E61000008ECBB8A98166F9BF8CBFED0912354A40
73051	CV5 8BD	GB	0101000020E6100000A1D79FC4E7CEF8BF25EB707495344A40
73052	CV5 8BS	GB	0101000020E61000008E0244C18CE9F8BFEF53556820344A40
73053	CV5 8ER	GB	0101000020E61000001EA7E8482EBFF8BF98874CF910344A40
73054	CV5 8EZ	GB	0101000020E6100000DE74CB0EF1CFF8BF5F24B4E55C344A40
73055	CV5 8FX	GB	0101000020E6100000A0E1CD1ABCAFF8BF6380441328344A40
73056	CV5 8FY	GB	0101000020E6100000F59CF4BEF1B5F8BFA7E7DD5850344A40
73057	CV5 8JT	GB	0101000020E6100000F581E49D4399F8BFFA62EFC517354A40
73058	CV5 9BL	GB	0101000020E6100000691B7FA2B221F9BF9010E50B5A364A40
73059	CV5 9EE	GB	0101000020E610000067EDB60BCDF5F8BF9A0645F300384A40
73060	CV5 9FB	GB	0101000020E610000008CC43A67C08F9BFC9C859D8D3364A40
73061	CV5 9NB	GB	0101000020E6100000AAB9DC60A803F9BF1B62BCE655354A40
73062	CV5 9NT	GB	0101000020E6100000761893FE5E4AF9BFBC0853944B374A40
73063	CV5 9QG	GB	0101000020E6100000F0879FFF1EBCF9BFDE59BBED42374A40
73064	CV5 9QJ	GB	0101000020E61000001899805F23C9F9BF685DA3E540374A40
73065	CV5 9QQ	GB	0101000020E6100000A88FC01F7EBEF9BF44DE72F563374A40
73066	CV6	GB	0101000020E6100000D175E107E713F8BFA20914B188374A40
73067	CV6 1BY	GB	0101000020E6100000BDE13E726B92F8BFD95BCAF962354A40
73068	CV6 1DQ	GB	0101000020E6100000EC2E505260C1F8BFC8D2872EA8374A40
73069	CV6 1NR	GB	0101000020E6100000D3FA5B02F04FF8BF59198D7C5E354A40
73070	CV6 1PL	GB	0101000020E610000023F433F5BA05F8BF9162804413384A40
73071	CV6 2AA	GB	0101000020E6100000CEA78E554A8FF8BF81B053AC1A364A40
73072	CV6 2AT	GB	0101000020E61000001348895DDB9BF8BF1CD0D2156C374A40
73073	CV6 2DR	GB	0101000020E61000006687F8872D7DF8BF91F12895F0364A40
73074	CV6 2FP	GB	0101000020E610000033DFC14F1C80F8BFA51133FB3C384A40
73075	CV6 2GB	GB	0101000020E6100000B18861873169F8BF87E123624A384A40
73076	CV6 2HD	GB	0101000020E610000039D384ED2763F8BF0B45BA9F53384A40
73077	CV6 2HZ	GB	0101000020E6100000320395F1EF73F8BF3C139A2496384A40
73078	CV6 2LA	GB	0101000020E6100000C24D4695615CF8BF82902C6002374A40
73079	CV6 3FX	GB	0101000020E610000057D11F9A7932F8BF8ACC5CE0F2364A40
73080	CV6 4AN	GB	0101000020E6100000BB9866BAD749F8BFF88A6EBDA6374A40
73081	CV6 4AP	GB	0101000020E6100000ABD1AB014A03F8BF736891ED7C354A40
73082	CV6 4AW	GB	0101000020E610000039D4EFC2D62CF8BF56F0DB10E3374A40
73083	CV6 4DZ	GB	0101000020E610000091B932A83638F8BF08AF5DDA70384A40
73084	CV6 4FE	GB	0101000020E61000004A5D328E912CF8BF09A87004A9384A40
73085	CV6 4GD	GB	0101000020E610000036751E15FF37F8BF58E6ADBA0E394A40
73086	CV6 4GF	GB	0101000020E61000001ADB6B41EF4DF8BFA6B73F170D394A40
73087	CV6 4GG	GB	0101000020E61000001A506F46CD57F8BFC9AA083719394A40
73088	CV6 4HG	GB	0101000020E6100000D31396784059F8BF005471E316394A40
73089	CV6 4HR	GB	0101000020E6100000A3CD716E132EF8BFEAE8B81AD9394A40
73090	CV6 4JX	GB	0101000020E6100000E25AED612F14F8BF33C4B12E6E394A40
73091	CV6 4QX	GB	0101000020E610000047904AB1A331F8BF024BAE62F1374A40
73092	CV6 5DY	GB	0101000020E6100000CEFFAB8E1CE9F7BF04E78C28ED354A40
73093	CV6 5EY	GB	0101000020E61000006F0C01C0B1E7F7BF3752B648DA354A40
73094	CV6 5FD	GB	0101000020E6100000416667D13BD5F7BF7E37DDB243364A40
73095	CV6 5FN	GB	0101000020E61000000C789961A3ECF7BF8D96033DD4364A40
73096	CV6 5GQ	GB	0101000020E6100000D49AE61DA7E8F7BFA77686A92D374A40
73097	CV6 5GR	GB	0101000020E61000008A592F8672E2F7BF620FED6305374A40
73098	CV6 5GS	GB	0101000020E6100000F20A444FCAE4F7BF992CEE3F32374A40
73099	CV6 5JH	GB	0101000020E61000003B00E2AE5E05F8BFFFE9060ABC374A40
73100	CV6 5JJ	GB	0101000020E6100000C09481035AFAF7BFDC9F8B868C374A40
73101	CV6 6EL	GB	0101000020E61000005F419AB168BAF7BF1004C8D0B1394A40
73102	CV6 6NW	GB	0101000020E610000098A608707AD7F7BF23BBD23252394A40
73103	CV6 6QR	GB	0101000020E610000077BB5E9A2280F7BF71C806D2C53A4A40
73104	CV6 7FJ	GB	0101000020E6100000B7EF517FBD02F8BF75AE282504374A40
73105	CV6 7FL	GB	0101000020E61000001D1EC2F869DCF7BF0322C495B3374A40
73106	CV6 7JH	GB	0101000020E610000015E0BBCD1BA7F7BF18EAB0C22D374A40
73107	CV6 7LF	GB	0101000020E6100000DD0720B58993F7BFDD442DCDAD364A40
73108	CV7	GB	0101000020E6100000CBF78C446844FABF48E17A14AE374A40
73109	CV7 7BL	GB	0101000020E6100000FE62B6645544FABF1B0E4B033F344A40
73110	CV7 7DD	GB	0101000020E6100000B328ECA2E8C1F9BF5DC47762D6334A40
73111	CV7 7EF	GB	0101000020E6100000A6B5696CAF45FABF1DE90C8CBC324A40
73112	CV7 7EP	GB	0101000020E6100000C4978922A46EFABF58AD4CF8A5324A40
73113	CV7 7FG	GB	0101000020E6100000B972F6CE686BFABF931B45D61A324A40
73114	CV7 7FX	GB	0101000020E6100000C0232A543757FABF61A417B5FB314A40
73115	CV7 7GT	GB	0101000020E6100000B3075A81212BFABFD7FA22A12D314A40
73116	CV7 7HN	GB	0101000020E610000042B3EBDE8A04FBBFF296AB1F9B3A4A40
73117	CV7 7NS	GB	0101000020E6100000A4A99ECC3F3AFABF5B0BB3D0CE374A40
73118	CV7 7QL	GB	0101000020E6100000B58CD47B2A67FABF2D060FD3BE314A40
73119	CV7 7QR	GB	0101000020E61000008BC56F0A2B95FABF45BDE0D39C344A40
73120	CV7 8BL	GB	0101000020E61000006A4E5E6402FEF8BF87A6ECF4833C4A40
73121	CV7 8HX	GB	0101000020E610000002B7EEE6A98EF8BFE7E104A6D33A4A40
73122	CV7 8JT	GB	0101000020E61000003143E389208EF8BF79E6E5B0FB3A4A40
73123	CV7 8PE	GB	0101000020E6100000BA6587F8876DF8BF847F1134663A4A40
73124	CV7 9HL	GB	0101000020E6100000C64E78094E3DF8BFC3B986191A3B4A40
73125	CV7 9HX	GB	0101000020E6100000EEB435221887F6BFB72572C1193A4A40
73126	CV7 9JL	GB	0101000020E61000003881E9B46E43F6BF965F066344384A40
73127	CV8	GB	0101000020E610000074982F2FC03EF9BF29CC7B9C692C4A40
73128	CV8 1AD	GB	0101000020E6100000BD1AA034D468F9BFF581E49D432D4A40
73129	CV8 1AF	GB	0101000020E6100000753925202661F9BF7AABAE43352D4A40
73130	CV8 1BE	GB	0101000020E6100000CFDBD8EC4875F9BF4850FC18732D4A40
73131	CV8 1BL	GB	0101000020E6100000A260C614AC71F9BF58AD4CF8A52C4A40
73132	CV8 1DU	GB	0101000020E6100000D655815A0C5EF9BF5BEB8B84B62A4A40
73133	CV8 1HR	GB	0101000020E6100000D5EAABAB0235F9BFC8CD70033E2B4A40
73134	CV8 1JR	GB	0101000020E61000004D1421753B3BF9BF74452921582B4A40
73135	CV8 1LW	GB	0101000020E610000074B7EBA52942F9BF6B64575A462C4A40
73136	CV8 1NE	GB	0101000020E6100000204432E4D87AF9BFDE550F98872C4A40
73137	CV8 1NS	GB	0101000020E61000006F4A79AD84AEFABF61A6ED5F592F4A40
73138	CV8 1QD	GB	0101000020E6100000F705F4C29DCBFABF6075E448672E4A40
73139	CV8 1QQ	GB	0101000020E6100000973B33C1702EF9BF2C9B3924B52A4A40
73140	CV8 1RB	GB	0101000020E6100000D28F8653E626F9BFF5F411F8C32B4A40
73141	CV8 2	GB	0101000020E61000005854C4E9241BF9BFE883656CE82A4A40
73142	CV8 2EN	GB	0101000020E6100000D7F6764B7200F9BF7F349C32372D4A40
73143	CV8 2EX	GB	0101000020E61000009F7422C154F3F8BF1553E9279C2D4A40
73144	CV8 2FU	GB	0101000020E610000091ED7C3F351EF9BF0A65E1EB6B2D4A40
73145	CV8 2GY	GB	0101000020E6100000A950DD5CFC2DF9BF95F1EF332E2C4A40
73146	CV8 2HJ	GB	0101000020E61000002CF3565D872AF9BFB6D95889792C4A40
73147	CV8 2JY	GB	0101000020E6100000E9B985AE4460F9BFB32616F88A2E4A40
73148	CV8 2NS	GB	0101000020E6100000CBF3E0EEACDDF8BFFC010F0C202C4A40
73149	CV8 2PD	GB	0101000020E6100000FFB27BF2B010F9BFD89B1892932D4A40
73150	CV8 2PW	GB	0101000020E6100000540262122EE4F8BFCA518028982D4A40
73151	CV8 2SD	GB	0101000020E610000033F9669B1BD3F8BFA88AA9F4132C4A40
73152	CV8 2SW	GB	0101000020E6100000465F419AB1E8F8BF4EB340BB432C4A40
73153	CV8 3AH	GB	0101000020E6100000672C9ACE4E06F8BF69554B3ACA2F4A40
73154	CV8 3AZ	GB	0101000020E6100000C423F1F274AEF7BF9BC8CC052E2F4A40
73155	CV8 3DN	GB	0101000020E6100000787E5182FE42F8BFA06F0B96EA2C4A40
73156	CV8 3HB	GB	0101000020E6100000715985CD0057F6BF2D5DC136E22F4A40
73157	CV8 3PE	GB	0101000020E610000097361C96067EF6BFA8A8FA95CE2F4A40
73158	CV9	GB	0101000020E6100000209738F240A4F8BF1AA88C7F9F494A40
73159	CV9 1BH	GB	0101000020E61000000BB3D0CE69D6F8BF82AAD1AB014A4A40
73160	CV9 2DQ	GB	0101000020E610000029E9616875B2F8BFC100C28712494A40
73161	CV9 2DU	GB	0101000020E610000038656EBE119DF9BFDE9046054E4A4A40
73162	CV9 2QH	GB	0101000020E6100000359A5C8C8135F8BF425E0F26C54D4A40
73163	CV9 3QN	GB	0101000020E61000007E8AE3C0ABE5F7BFFFB3E6C75F504A40
73164	CW1	GB	0101000020E61000007349D576133C03C021E4BCFF8F8D4A40
73165	CW1 1DY	GB	0101000020E61000002AABE97AA26B03C0B439CE6DC28B4A40
73166	CW1 3HF	GB	0101000020E6100000A51309A69A9903C0C7BDF90D138D4A40
73167	CW1 3NW	GB	0101000020E6100000EF3B86C77EB603C09C3061342B8D4A40
73168	CW1 3RF	GB	0101000020E6100000C1E09A3BFA9F03C0643E20D0998E4A40
73169	CW1 3RS	GB	0101000020E6100000BB421F2C63A303C01FF46C567D8E4A40
73170	CW1 4HG	GB	0101000020E61000008B16A06D356B03C0A4198BA6B38D4A40
73171	CW1 4RQ	GB	0101000020E61000007496598462EB03C0C824236761914A40
73172	CW1 5EQ	GB	0101000020E6100000164CFC51D47903C0289A07B0C88B4A40
73173	CW1 6RT	GB	0101000020E61000008657923CD77703C03A9160AA998B4A40
73174	CW1 6UZ	GB	0101000020E6100000D6FF39CC973703C01AA54BFF928A4A40
73175	CW10	GB	0101000020E610000096EB6D3315A203C00E4A9869FB994A40
73176	CW10 0EP	GB	0101000020E6100000F850A2258F8703C01DAB949EE9974A40
73177	CW10 0GL	GB	0101000020E6100000AAD55757058A03C0A52F849CF7974A40
73178	CW10 0PJ	GB	0101000020E610000047CB811E6A9B03C09D9CA1B8E3974A40
73179	CW10 0RH	GB	0101000020E610000019FED30D147803C0F4C5DE8B2F964A40
73180	CW10 0SE	GB	0101000020E6100000DB317557768103C07575C7629B964A40
73181	CW10 9AN	GB	0101000020E6100000E84D452A8C8D03C01363997E89984A40
73182	CW10 9GQ	GB	0101000020E6100000FA97A432C57C03C0930035B56C994A40
73183	CW10 9HR	GB	0101000020E6100000DB31755776A103C0BB7EC16ED8984A40
73184	CW11	GB	0101000020E6100000A379008BFC1A03C0DB32E02C25934A40
73185	CW11 1FH	GB	0101000020E610000065E08096AE0003C09D499BAA7B924A40
73186	CW11 3BH	GB	0101000020E61000007F83F6EAE32103C08FFCC1C073934A40
73187	CW11 3JG	GB	0101000020E61000003E23111AC12603C014B2F33636934A40
73188	CW11 3LT	GB	0101000020E610000010786000E10303C02D5A80B6D5904A40
73189	CW11 3RT	GB	0101000020E6100000944DB9C2BBFC02C0F981AB3C81904A40
73190	CW11 4HE	GB	0101000020E6100000596B28B517D102C07DD0B359F5914A40
73191	CW11 4TS	GB	0101000020E6100000CB9C2E8B890D03C0F374AE28258E4A40
73192	CW12 1ER	GB	0101000020E6100000A968ACFD9DAD01C0F24410E7E1944A40
73193	CW12 1LX	GB	0101000020E610000066136058FEBC01C072BF4351A0954A40
73194	CW12 1NX	GB	0101000020E6100000A3CC069964A401C0E5D3635B06964A40
73195	CW12 2AY	GB	0101000020E610000052D32EA6998E01C04D68925852964A40
73196	CW12 2DE	GB	0101000020E6100000EC884336908E01C0C6C1A563CE954A40
73197	CW12 2LP	GB	0101000020E6100000C93A1C5DA53B02C01C7A8B87F79A4A40
73198	CW12 3BG	GB	0101000020E6100000ADFBC74274A801C0CA51802898934A40
73199	CW12 3BJ	GB	0101000020E610000069A7E67283A101C0460BD0B69A934A40
73200	CW12 3BS	GB	0101000020E6100000471D1D57239B01C024B4E55C8A934A40
73201	CW12 3DE	GB	0101000020E61000001BBCAFCA858A01C040DEAB5626944A40
73202	CW12 3HX	GB	0101000020E610000060234910AE8001C00C5872158B934A40
73203	CW12 3LY	GB	0101000020E6100000FC8EE1B19F8501C0B4722F302B944A40
73204	CW12 3SS	GB	0101000020E6100000C1CAA145B67301C0259694BBCF934A40
73205	CW12 3TZ	GB	0101000020E610000093A641D13C8001C0F27A30293E944A40
73206	CW12 4NX	GB	0101000020E6100000F1F3DF83D7EE01C07024D06053954A40
73207	CW12 4YH	GB	0101000020E6100000D99942E735F601C01D3EE94482954A40
73208	CW2	GB	0101000020E610000038F6ECB94C6D03C0386744696F8A4A40
73209	CW2 5BW	GB	0101000020E61000000F46EC13409103C06DA818E76F884A40
73210	CW2 5DT	GB	0101000020E6100000E4F560527C9C03C05A677C5F5C884A40
73211	CW2 5LR	GB	0101000020E6100000EA42ACFE084303C0516B9A779C884A40
73212	CW2 6HD	GB	0101000020E610000004C765DCD48003C00D8D2782388B4A40
73213	CW2 6HH	GB	0101000020E6100000E2067C7E188103C009C38025578B4A40
73214	CW2 6HR	GB	0101000020E610000092239D81917703C0DB148F8B6A8B4A40
73215	CW2 6JT	GB	0101000020E6100000D15790662C9A03C0198EE733A08A4A40
73216	CW2 6TN	GB	0101000020E610000069FF03AC559B03C0EA211ADD418A4A40
73217	CW2 6TT	GB	0101000020E61000008A027D224F9203C0B98C9B1A688A4A40
73218	CW2 7BE	GB	0101000020E6100000C6E1CCAFE68003C0FE47A643A78B4A40
73219	CW2 7JE	GB	0101000020E6100000C4EC65DB698B03C00B0DC4B2998B4A40
73220	CW2 7LG	GB	0101000020E6100000674815C5AB8C03C079245E9ECE8B4A40
73221	CW2 7LH	GB	0101000020E610000018B2BAD5739203C001309E41438B4A40
73222	CW2 7LQ	GB	0101000020E610000013D6C6D8098F03C0B0ABC953568B4A40
73223	CW2 7PH	GB	0101000020E6100000BBD408FD4C9D03C0A857CA32C48B4A40
73224	CW2 7PR	GB	0101000020E610000092E68F696D5A03C07A51BB5F058C4A40
73225	CW2 7PU	GB	0101000020E61000005B069CA5649903C05AD76839D08B4A40
73226	CW2 7SY	GB	0101000020E61000000E2C47C840BE03C010070951BE8C4A40
73227	CW2 8DU	GB	0101000020E6100000AA7F10C990A303C0F8A41309A68C4A40
73228	CW2 8NQ	GB	0101000020E610000018B14F00C5A803C094DC6113998B4A40
73229	CW2 8SZ	GB	0101000020E6100000520ABABDA4D103C0E4A25A44148D4A40
73230	CW3 0AY	GB	0101000020E610000052BAF42F490504C09F76F86BB27E4A40
73231	CW3 9	GB	0101000020E6100000583B8A73D49102C0D905836BEE804A40
73232	CW3 9BT	GB	0101000020E61000009609BFD4CFFB02C0E7C41EDAC7824A40
73233	CW3 9BY	GB	0101000020E61000005322895E46F102C0F415A4198B824A40
73234	CW3 9ED	GB	0101000020E61000003E59315C1DC002C07E8FFAEB15804A40
73235	CW3 9HX	GB	0101000020E6100000BABE0F0709B102C0B91798158A804A40
73236	CW3 9QE	GB	0101000020E6100000022EC896E5CB02C0A5677A89B17E4A40
73237	CW4 7AP	GB	0101000020E6100000E00F3FFF3DD802C07461A417B5994A40
73238	CW4 7HU	GB	0101000020E6100000C0B2D2A414D402C052616C21C8994A40
73239	CW4 7LH	GB	0101000020E6100000B6662B2FF9FF02C0058A58C4B0994A40
73240	CW4 7NH	GB	0101000020E6100000EEB1F4A10BCA02C080D4264EEE994A40
73241	CW4 7NJ	GB	0101000020E6100000E4310395F1CF02C02DB4739A059A4A40
73242	CW4 7PP	GB	0101000020E6100000F1A0D9756FE502C06FBC3B3256994A40
73243	CW4 7QE	GB	0101000020E6100000C07ADCB75AC702C08B37328FFC994A40
73244	CW4 8	GB	0101000020E61000006E313F37348502C036AD1402B99C4A40
73245	CW4 8AA	GB	0101000020E610000024473A0323CF02C043E4F4F57C994A40
73246	CW4 8EJ	GB	0101000020E610000037A6272CF10003C0C537143E5B9B4A40
73247	CW4 8FA	GB	0101000020E6100000D061BEBC00FB02C024F0879FFF9A4A40
73248	CW4 8HL	GB	0101000020E6100000B7989F1B9A1203C0C07B478D099D4A40
73249	CW4 8JJ	GB	0101000020E61000008C6665FB90B702C0CF842689259D4A40
73250	CW4 8PJ	GB	0101000020E6100000ADA1D45E449B02C0A3570394869C4A40
73251	CW5	GB	0101000020E6100000DB6CACC43C8B03C0FE9E58A7CA894A40
73252	CW5 5BQ	GB	0101000020E610000016DD7A4D0F2A04C005C24EB16A884A40
73253	CW5 5EW	GB	0101000020E6100000574277499C3504C0075DC2A1B7884A40
73254	CW5 5SB	GB	0101000020E61000000CCD751A692904C0C6F8307BD9884A40
73255	CW5 5SG	GB	0101000020E61000000551F701482D04C018265305A3884A40
73256	CW5 5SS	GB	0101000020E610000065AA6054522704C0BB97FBE428884A40
73257	CW5 6AW	GB	0101000020E6100000A60D87A5813F04C01D2098A3C78B4A40
73258	CW5 6EZ	GB	0101000020E61000002CEFAA07CC6303C0B876A224248A4A40
73259	CW5 6HG	GB	0101000020E61000002920ED7F801504C0DB8827BB99894A40
73260	CW5 6NP	GB	0101000020E6100000A4C2D84290E303C0B7D0950854894A40
73261	CW5 6NW	GB	0101000020E61000009E9ACB0D86DA03C08D26176360894A40
73262	CW5 6QD	GB	0101000020E6100000DE718A8EE4F203C0BEBC00FBE8884A40
73263	CW5 6QG	GB	0101000020E610000014CC988235CE03C028EE7893DF884A40
73264	CW5 7EY	GB	0101000020E61000004F745DF8C1B903C0EF90628044874A40
73265	CW5 7HD	GB	0101000020E61000004CA60A4625B503C02272FA7ABE864A40
73266	CW5 7HY	GB	0101000020E6100000389ECF807AD303C0B5E0455F41884A40
73267	CW5 7NA	GB	0101000020E6100000904C874ECF9B03C0B726DD96C8854A40
73268	CW5 8BB	GB	0101000020E61000004B033FAA617F04C06D1FF296AB834A40
73269	CW5 8BG	GB	0101000020E61000003CDD79E2397B04C0F722DA8EA9834A40
73270	CW5 8DB	GB	0101000020E61000009B73F04C689204C0FD4B529962824A40
73271	CW5 8EB	GB	0101000020E6100000179F02603CC304C0C79C67EC4B824A40
73272	CW5 8EX	GB	0101000020E61000000F60915F3FC404C0B9A981E673824A40
73273	CW5 8NP	GB	0101000020E6100000EC14AB0661AE04C069C70DBF9B884A40
73274	CW6	GB	0101000020E610000003999D45EF1405C062F5471806964A40
73275	CW6 0ES	GB	0101000020E6100000C5CA68E4F3EA05C0ECA529029C964A40
73276	CW6 0HB	GB	0101000020E61000004E4354E1CFD005C0F6B6990AF1964A40
73277	CW6 0NJ	GB	0101000020E61000001840F850A2A505C0A087DA368C9A4A40
73278	CW6 0PZ	GB	0101000020E6100000B98E71C5C5B105C0CD94D6DF129A4A40
73279	CW6 9DA	GB	0101000020E6100000C30E63D2DFCB04C08962F20698974A40
73280	CW6 9GN	GB	0101000020E61000009B3A8F8AFF3B05C026016A6AD98E4A40
73281	CW6 9PZ	GB	0101000020E6100000FA25E2ADF32F05C06CB41CE8A18E4A40
73282	CW6 9RN	GB	0101000020E6100000CD052E8F350305C0B587BD50C08C4A40
73283	CW6 9SP	GB	0101000020E610000061C43E01148305C02C9D0FCF12924A40
73284	CW7	GB	0101000020E6100000D8D47954FCDF04C007D2C5A695A44A40
73285	CW7 1FA	GB	0101000020E610000062A3ACDF4C4C04C0EE224C512E974A40
73286	CW7 1JE	GB	0101000020E6100000CC0A45BA9F5304C05DFDD8243F984A40
73287	CW7 1SE	GB	0101000020E610000058C9C7EE024504C07C9BFEEC47964A40
73288	CW7 2JL	GB	0101000020E61000009A79724D812C04C0DB334B02D4984A40
73289	CW7 2LE	GB	0101000020E6100000B189CC5CE03204C0134548DDCE984A40
73290	CW7 2LH	GB	0101000020E610000073BD6DA6425C04C0DB34B6D782984A40
73291	CW7 2LY	GB	0101000020E6100000321CCF67405D04C003B16CE690984A40
73292	CW7 3EY	GB	0101000020E6100000D4450A65E10B04C03A1F9E25C8984A40
73293	CW7 3NF	GB	0101000020E61000002106BAF605F403C05AB8ACC266984A40
73294	CW7 4DP	GB	0101000020E610000028452BF7027304C05F45460724914A40
73295	CW8	GB	0101000020E610000003CDE7DCED5A04C0D6C743DFDDA24A40
73296	CW8 1AW	GB	0101000020E6100000B55208E4122704C098F738D384A14A40
73297	CW8 1DB	GB	0101000020E6100000A94A5B5CE33304C0F7C8E6AA79A04A40
73298	CW8 1LQ	GB	0101000020E6100000F83768AF3E5E04C090696D1ADB9F4A40
73299	CW8 1NU	GB	0101000020E6100000889E94490D2D04C0BF2B82FFADA04A40
73300	CW8 1QX	GB	0101000020E6100000F1B913ECBF6E04C02EC896E5EB9E4A40
73301	CW8 1RB	GB	0101000020E61000007C2766BD186A04C0EB8D5A61FA9E4A40
73302	CW8 2BJ	GB	0101000020E6100000B6DAC35E288004C0EFE192E34E9B4A40
73303	CW8 2BY	GB	0101000020E6100000D74FFF59F3A304C02FDE8FDB2F9B4A40
73304	CW8 2FE	GB	0101000020E61000009012BBB6B77B04C0081F4AB4E49F4A40
73305	CW8 2JQ	GB	0101000020E6100000247B849A215505C0FCE07CEA589D4A40
73306	CW8 2JT	GB	0101000020E6100000158F8B6A11B104C08F6FEF1AF49D4A40
73307	CW8 2LE	GB	0101000020E61000009CFBABC77DCB04C09143C4CDA99E4A40
73308	CW8 2LR	GB	0101000020E610000045F295404ACC04C07F86376BF09E4A40
73309	CW8 2LU	GB	0101000020E6100000E2934E2498CA04C08A0629780A9F4A40
73310	CW8 2RE	GB	0101000020E61000002A8D98D9E7D104C043C5387F13A24A40
73311	CW8 2RN	GB	0101000020E610000042EE224C510E05C08D2441B802A24A40
73312	CW8 2TA	GB	0101000020E61000007041B62C5FD704C0187C9A93179F4A40
73313	CW8 2TS	GB	0101000020E6100000919C4CDC2AE804C0812381069BA04A40
73314	CW8 2TZ	GB	0101000020E61000005453927538DA04C0745E6397A89E4A40
73315	CW8 2UH	GB	0101000020E6100000103FFF3D78CD04C0E21E4B1FBA9E4A40
73316	CW8 2XB	GB	0101000020E61000007B4D0F0A4AF104C0E770ADF6B09F4A40
73317	CW8 3EU	GB	0101000020E61000009F0436E7E0F903C0B7442E3883A14A40
73318	CW8 3LA	GB	0101000020E61000008BA548BE128804C023A298BC01A24A40
73319	CW8 3NN	GB	0101000020E6100000DB8651103C9E04C04224438EADA14A40
73320	CW8 4BW	GB	0101000020E6100000BD1DE1B4E04504C068B27F9E06A24A40
73321	CW8 4HB	GB	0101000020E6100000DCD9571EA46704C0B18A37328FA24A40
73322	CW8 4LX	GB	0101000020E6100000E35295B6B86604C0F99D2633DEA24A40
73323	CW9	GB	0101000020E6100000B2B8FFC874E803C0B51666A19DA34A40
73324	CW9 6EA	GB	0101000020E61000005C1E6B4606D903C098FA795391A44A40
73325	CW9 6HU	GB	0101000020E610000077103B53E83C04C0DFE1766858A64A40
73326	CW9 7HF	GB	0101000020E6100000FA5FAE450BF003C0FC010F0C20A04A40
73327	CW9 7NJ	GB	0101000020E610000068D0D03FC14504C0780C8FFD2CA04A40
73328	CW9 7NU	GB	0101000020E61000003DD68C0C72B703C038BF61A241A24A40
73329	CW9 8DS	GB	0101000020E61000002BD9B111881704C01669E21DE09F4A40
73330	CW9 8DT	GB	0101000020E6100000F8E12021CA1704C079AF5A99F09F4A40
73331	CW9 8DU	GB	0101000020E61000001D739EB12F1904C0E4F8A1D2889F4A40
73332	CW9 8NP	GB	0101000020E610000068942EFD4B1204C04AF086342A9E4A40
73333	DA1	GB	0101000020E6100000B7EBA529029CC63FDCA0F65B3BB94940
73334	DA1 1	GB	0101000020E6100000B98AC56F0A2BCD3FBC5AEECC04B94940
73335	DA1 1LS	GB	0101000020E61000005682C5E1CCAFCC3F2E8F352383B84940
73336	DA1 2XQ	GB	0101000020E6100000062B4EB51666CB3F09C6C1A563B84940
73337	DA1 3ER	GB	0101000020E61000009ED2C1FA3F87C93F94FAB2B453B94940
73338	DA1 3JS	GB	0101000020E6100000CBDB114E0B5EC83F0377A04E79B84940
73339	DA1 3JU	GB	0101000020E6100000E5266A696E85C83F4BAE62F19BB84940
73340	DA1 3NG	GB	0101000020E6100000782975C93846C83F90DAC4C9FDB84940
73341	DA1 3NT	GB	0101000020E61000000F63D2DF4BE1C73FEC2E505260B94940
73342	DA1 3PY	GB	0101000020E61000005DFE43FAEDEBC63F41F163CC5DB94940
73343	DA1 4AN	GB	0101000020E6100000DC9C4A06802AC83F53E751F17FB94940
73344	DA1 4BF	GB	0101000020E61000009C1727BEDA51C63F0CCC0A45BAB94940
73345	DA1 4BS	GB	0101000020E6100000D386C3D2C08FC63F25E7C41EDAB94940
73346	DA1 4RX	GB	0101000020E6100000C493DDCCE847C73F807D74EACAB94940
73347	DA1 5DE	GB	0101000020E61000003866D993C0E6CC3F0F971C774AB94940
73348	DA10 0AG	GB	0101000020E6100000E9EFA5F0A0D9D33FF3AACE6A81B94940
73349	DA10 0LD	GB	0101000020E6100000D253E4107173D33FDC65BFEE74B94940
73350	DA11	GB	0101000020E6100000E5EE737CB438D73F7FA0DCB6EFB74940
73351	DA11 0PN	GB	0101000020E610000056D28A6F287CD73FEC4FE27327B84940
73352	DA11 7NW	GB	0101000020E610000082AD122C0E67D73FD1CABDC0ACB64940
73353	DA11 7QQ	GB	0101000020E6100000D12346CF2D74D73F234DBC033CB74940
73354	DA11 8JG	GB	0101000020E61000007651F4C0C760D53F35272F3201B74940
73355	DA11 8QR	GB	0101000020E6100000EED0B01875ADD63F4B02D4D4B2B74940
73356	DA11 9BA	GB	0101000020E61000002AC8CF46AE9BD43FE7ABE46377B94940
73357	DA11 9DY	GB	0101000020E610000090F7AA9509BFD43FF33D23111AB94940
73358	DA11 9LW	GB	0101000020E6100000E57FF277EFA8D63FB42094F771B84940
73359	DA11 9NR	GB	0101000020E610000001A3CB9BC3B5D63FE5EFDE5163B84940
73360	DA11 9PW	GB	0101000020E610000065355D4F745DD73F7349D57613B84940
73361	DA11 9QF	GB	0101000020E61000003A9677D503E6D63F2FA3586E69B94940
73362	DA12	GB	0101000020E61000006CD097DEFE5CD83F295E656D53B64940
73363	DA12 2AX	GB	0101000020E61000006CEBA7FFACF9D73F5307793D98B84940
73364	DA12 2NN	GB	0101000020E61000009C33A2B437F8D93F99A0866F61B74940
73365	DA12 2PN	GB	0101000020E6100000F69A1E1494A2D93F68CEFA9463B84940
73366	DA12 3AP	GB	0101000020E61000000F441669E21DD93FA0DFF76F5EB24940
73367	DA12 3EG	GB	0101000020E6100000B456B439CE6DDB3FE9D500A5A1B44940
73368	DA12 4AD	GB	0101000020E610000013F3ACA415DFD93F7F30F0DC7BB44940
73369	DA12 4EB	GB	0101000020E61000001AA54BFF9254D93FB05582C5E1B64940
73370	DA12 5HF	GB	0101000020E6100000DD5D6743FE99D73F7905A22765B64940
73371	DA12 5LU	GB	0101000020E61000004E9D47C5FF1DD83F47C7D5C8AEB64940
73372	DA13	GB	0101000020E610000084F4143944DCD73F0377A04E79AE4940
73373	DA13 0	GB	0101000020E6100000F722DA8EA9BBD63FA6EECA2E18AA4940
73374	DA13 0JE	GB	0101000020E6100000F4A44C6A6803D73F3DD2E0B6B6B04940
73375	DA13 0LU	GB	0101000020E610000086A92D7590D7D63F541B9C887EB14940
73376	DA13 0XY	GB	0101000020E6100000AED9CA4BFE27D83F6519E25817B14940
73377	DA13 9AY	GB	0101000020E61000007CED9925016AD83FCC272B86ABB14940
73378	DA13 9EH	GB	0101000020E61000007D76C075C58CD63F3EB324404DB34940
73379	DA13 9HF	GB	0101000020E61000004F5C8E57207AD63F3F8F519E79B34940
73380	DA13 9NN	GB	0101000020E61000009C51F355F2B1D43F1AFA27B858B54940
73381	DA13 9NQ	GB	0101000020E6100000221807978E39D43FF65FE7A6CDB44940
73382	DA13 9PZ	GB	0101000020E6100000E6577380608ED43F1D39D21918B54940
73383	DA14 4LU	GB	0101000020E61000009065C1C41F45C13F48C32973F3B74940
73384	DA14 4LX	GB	0101000020E61000004031B2648EE5BD3FE947C32973B74940
73385	DA14 4NG	GB	0101000020E61000001D5723BBD232BE3F0938842A35B74940
73386	DA14 4PB	GB	0101000020E6100000D1CDFE40B96DBF3FCC6262F371B74940
73387	DA14 4PT	GB	0101000020E6100000902FA182C30BC23FEAEA8EC536B74940
73388	DA14 4QS	GB	0101000020E6100000751DAA29C93ABC3F3D997FF44DB64940
73389	DA14 5AA	GB	0101000020E610000076A4FACE2F4ABC3FEF004F5AB8B44940
73390	DA14 5BN	GB	0101000020E61000003DD4B6611404BF3F3D4679E6E5B44940
73391	DA14 5BU	GB	0101000020E610000027F911BF620DBF3F1B0FB6D8EDB54940
73392	DA14 5DA	GB	0101000020E61000008C9E5BE84A04BE3F5D16139B8FB54940
73393	DA14 5DF	GB	0101000020E610000064EAAEEC82C1BD3FA514747B49B54940
73394	DA14 5ET	GB	0101000020E610000085CE6BEC12D5C13F3B00E2AE5EB74940
73395	DA14 5JW	GB	0101000020E61000008736001B1021C03F304CA60A46B54940
73396	DA14 6BP	GB	0101000020E61000003737A6272CF1B83F4B3CA06CCAB54940
73397	DA14 6HY	GB	0101000020E61000001899805F2349BC3FD05E7D3CF4B54940
73398	DA14 6LN	GB	0101000020E6100000D68D7747C66ABB3FD95F764F1EB64940
73399	DA14 6LX	GB	0101000020E610000030BDFDB968C8BC3F6B7F677BF4B44940
73400	DA14 6NE	GB	0101000020E6100000E5F04927124CBD3FA56ABB09BEB54940
73401	DA15 7AW	GB	0101000020E6100000EA944737C2A2BA3F179E978A8DB74940
73402	DA15 7HJ	GB	0101000020E61000006AF5D555815AB83F245E9ECE15B74940
73403	DA15 7HT	GB	0101000020E61000002E7590D78349B93F6D0377A04EB74940
73404	DA15 7NB	GB	0101000020E610000088821953B0C6BD3F2503401537B84940
73405	DA15 7NU	GB	0101000020E6100000F855B950F9D7B63F280F0BB5A6B74940
73406	DA15 7NY	GB	0101000020E610000059DC7F643A74B63F250516C094B74940
73407	DA15 8BH	GB	0101000020E610000097ADF545425BB63FFC010F0C20B84940
73408	DA15 8DY	GB	0101000020E61000003A9677D503E6B53F8DD0CFD4EBB84940
73409	DA15 8EU	GB	0101000020E61000003FC91D369199B73F58569A9482B84940
73410	DA15 8NB	GB	0101000020E61000001B4CC3F01131B93F921FF12BD6B84940
73411	DA15 8WA	GB	0101000020E610000058E6ADBA0ED5B83FFBCDC47421B84940
73412	DA15 8WN	GB	0101000020E61000000AA359D93EE4B93F86048C2E6FB84940
73413	DA15 9AP	GB	0101000020E610000039F240649126BE3F6A317898F6B74940
73414	DA15 9DL	GB	0101000020E6100000F0A485CB2A6CBA3F02F2255470B84940
73415	DA15 9ER	GB	0101000020E61000004D81CCCEA277BA3FECA4BE2CEDB84940
73416	DA15 9EW	GB	0101000020E61000009F0436E7E099B83F5F7B664980B84940
73417	DA15 9HX	GB	0101000020E610000066101FD8F15FBC3F6E14596B28B94940
73418	DA16	GB	0101000020E61000007714E7A8A3E3BA3FEE5BAD1397BB4940
73419	DA16 1	GB	0101000020E61000008E3BA583F57FBE3F761893FE5EBC4940
73420	DA16 1LP	GB	0101000020E61000003C139A249694C13F7C992842EABC4940
73421	DA16 3AU	GB	0101000020E610000049B9FB1C1F2DBA3FF56393FC88BB4940
73422	DA16 3BX	GB	0101000020E6100000DBFAE93F6B7EBC3FCAA5F10BAFBC4940
73423	DA16 3BY	GB	0101000020E6100000A6D425E318C9BA3FB0AE0AD462BC4940
73424	DA16 3JG	GB	0101000020E6100000F12A6B9BE271BD3F61FD9FC37CBB4940
73425	DA17 4AH	GB	0101000020E61000008CF7E3F6CB27C13FC7BB2363B5BD4940
73426	DA17 5EE	GB	0101000020E6100000E886A6ECF483C23F44A2D0B2EEBD4940
73427	DA17 5HF	GB	0101000020E6100000DE04DF347D76C43F89D4B48B69BE4940
73428	DA17 5JZ	GB	0101000020E6100000C0779B374E0AC53F959F54FB74BE4940
73429	DA17 5RN	GB	0101000020E6100000FD885FB1868BC03FAE9CBD33DABE4940
73430	DA17 6JJ	GB	0101000020E61000006CB07092E68FC33F7B6B60AB04BF4940
73431	DA18 4AA	GB	0101000020E610000082AE7D01BD70C33F45BA9F5390BF4940
73432	DA2 6AH	GB	0101000020E6100000C991CEC0C8CBCE3F051901158EB84940
73433	DA2 6DW	GB	0101000020E6100000F2EB87D860E1CE3F0612143FC6B84940
73434	DA2 7AW	GB	0101000020E6100000F4C1323674B3C73FAE9B525E2BB74940
73435	DA2 7HE	GB	0101000020E6100000BA4BE2AC889AC63F61A92EE065B64940
73436	DA2 7SA	GB	0101000020E6100000622F14B01D8CCC3F1973D712F2B54940
73437	DA2 8BP	GB	0101000020E61000004276DEC66647D23F84B9DDCB7DB64940
73438	DA3	GB	0101000020E6100000B7442E3883BFDC3FDDB419A721AC4940
73439	DA3 7JG	GB	0101000020E61000008FC6A17E17B6D43F07793D9814B34940
73440	DA3 7JJ	GB	0101000020E6100000B18A37328FFCD43F0D8E9257E7B24940
73441	DA3 7QA	GB	0101000020E61000000DC171193735D33FB4024356B7B24940
73442	DA3 7QL	GB	0101000020E6100000AE2CD1596611D33FAC5791D101B34940
73443	DA3 7QW	GB	0101000020E6100000DAE6C6F48425D33F865968E734B34940
73444	DA3 8BP	GB	0101000020E61000005039268BFB8FD33F4F1E166A4DB14940
73445	DA3 8HS	GB	0101000020E61000009F56D11F9A79D33FB69E211CB3AE4940
73446	DA3 8JG	GB	0101000020E610000072512D228AC9D33FCB82893F8AAE4940
73447	DA3 8LR	GB	0101000020E6100000E2EA0088BB7AD33F0EA48B4D2BAF4940
73448	DA3 8LW	GB	0101000020E6100000D5D006600322D33F92EBA694D7AE4940
73449	DA4	GB	0101000020E6100000DBFCBFEAC891CE3F42EDB776A2B64940
73450	DA4 0	GB	0101000020E61000007714E7A8A3E3CC3F80D3BB783FB04940
73451	DA4 0AE	GB	0101000020E6100000E0BE0E9C33A2CA3FD57B2AA73DAF4940
73452	DA4 0BH	GB	0101000020E6100000FBCE2F4AD05FCC3F923EADA23FB04940
73453	DA4 0HP	GB	0101000020E6100000662FDB4E5B23CA3F522B4CDF6BAE4940
73454	DA4 0JA	GB	0101000020E61000001FD95C35CF11C93F58A9A0A2EAAD4940
73455	DA4 9JA	GB	0101000020E6100000A0DD21C50089CC3F2BC3B81B44B34940
73456	DA4 9JB	GB	0101000020E610000095456117450FCE3F33C4B12E6EB34940
73457	DA4 9JH	GB	0101000020E61000008B338639419BCC3F899B53C900B24940
73458	DA5	GB	0101000020E6100000325A47551344C53F917BBABA63B74940
73459	DA5 1AA	GB	0101000020E61000007C0BEBC6BB23C33F83A279008BB84940
73460	DA5 1AL	GB	0101000020E6100000AEA0698995D1C23F27A435069DB84940
73461	DA5 1AQ	GB	0101000020E6100000D49AE61DA7E8C23F33A48AE255B84940
73462	DA5 1AW	GB	0101000020E6100000053411363CBDC23F9757AEB7CDB84940
73463	DA5 1DX	GB	0101000020E61000003F355EBA490CC03FF3936A9F8EB94940
73464	DA5 1HU	GB	0101000020E6100000D76B7A50508AC23F8274B169A5B84940
73465	DA5 1HX	GB	0101000020E61000007B12D89C8367C23FFC8BA03193B84940
73466	DA5 1JB	GB	0101000020E61000009276A38FF980C03F39B69E211CB94940
73467	DA5 1JE	GB	0101000020E61000001FD95C35CF11C13FC7D45DD905B94940
73468	DA5 1JY	GB	0101000020E61000003F19E3C3EC65C33F37E2C96E66B84940
73469	DA5 1LZ	GB	0101000020E61000003FC91D369199C33FBC1FB75F3EB94940
73470	DA5 1ND	GB	0101000020E61000008FC536A968ACC33F9949D40B3EB94940
73471	DA5 1PQ	GB	0101000020E6100000C3BB5CC47762C43FC4B2994352B94940
73472	DA5 2BA	GB	0101000020E6100000D2C5A6954220C53F0B24287E8CB74940
73473	DA5 2BE	GB	0101000020E6100000145D177E703EC53F35EB8CEF8BB74940
73474	DA5 2DA	GB	0101000020E6100000406A1327F73BC43F9415C3D501B84940
73475	DA5 2DB	GB	0101000020E6100000DE54A4C2D842C43F89B2B794F3B74940
73476	DA5 2DR	GB	0101000020E61000008CA37213B534C53FA25F5B3FFDB74940
73477	DA5 2DS	GB	0101000020E61000004221020EA14AC53F44A2D0B2EEB74940
73478	DA5 3AA	GB	0101000020E6100000E59997C3EE3BC03F384E0AF31EB94940
73479	DA5 3AH	GB	0101000020E610000042959A3DD00AC03F4432E4D87AB84940
73480	DA5 3AJ	GB	0101000020E6100000D1950854FF20C03F499EEBFB70B84940
73481	DA5 3AN	GB	0101000020E6100000DEAAEB504D49C03FF73C7FDAA8B84940
73482	DA5 3AP	GB	0101000020E61000004D158C4AEA04C03FE5805D4D9EB84940
73483	DA5 3AW	GB	0101000020E6100000F0F8F6AE415FC03F997FF44D9AB84940
73484	DA5 3EU	GB	0101000020E61000009F93DE37BEF6C23F4A5E9D6340B84940
73485	DA5 3HE	GB	0101000020E61000009355116E32AAC03FB08C0DDDECB74940
73486	DA5 3HF	GB	0101000020E61000000796236420CFC03F158C4AEA04B84940
73487	DA5 3HL	GB	0101000020E6100000EECD6F986890C03F62D8614CFAB74940
73488	DA5 3HN	GB	0101000020E6100000D21C59F96530C03F6F63B323D5B74940
73489	DA5 3HP	GB	0101000020E6100000F0C16B97361CC03F00529B38B9B74940
73490	DA5 3JR	GB	0101000020E6100000745DF8C1F9D4C13F8A027D224FB84940
73491	DA5 3JZ	GB	0101000020E6100000C32973F38DE8C03FCAC4AD8218B84940
73492	DA5 3LD	GB	0101000020E610000043AD69DE718AC03FB6BDDD921CB84940
73493	DA5 3LE	GB	0101000020E6100000CB660E492D94C03F03CFBD874BB84940
73494	DA5 3LJ	GB	0101000020E6100000A699EE75525FC03FD47E6B274AB84940
73495	DA5 3LL	GB	0101000020E6100000172829B000A6C03F0F0EF62686B84940
73496	DA5 3LN	GB	0101000020E610000021E868554B3AC03FB51A12F758B84940
73497	DA5 3LU	GB	0101000020E61000003B191C25AFCEC33FCF12640454B84940
73498	DA5 3LW	GB	0101000020E6100000772FF7C95180C03F26361FD786B84940
73499	DA5 3LX	GB	0101000020E610000065C39ACAA2B0C33F3F1EFAEE56B84940
73500	DA5 3NP	GB	0101000020E6100000C93846B247A8C13FA837A3E6ABB84940
73501	DA5 3NR	GB	0101000020E6100000A13028D36872C13F13807F4A95B84940
73502	DA5 3NS	GB	0101000020E61000000B45BA9F5390C13FDA1D520C90B84940
73503	DA5 3NT	GB	0101000020E6100000E9BAF083F3A9C13F429605137FB84940
73504	DA5 3NU	GB	0101000020E6100000E4A08499B67FC13F976F7D586FB84940
73505	DA5 3NW	GB	0101000020E6100000EC4D0CC9C9C4C13F739F1C0588B84940
73506	DA5 3NX	GB	0101000020E6100000D6355A0EF450C13F5A7EE02A4FB84940
73507	DA5 3NZ	GB	0101000020E61000003AAFB14B546FC13FB8EA3A5453B84940
73508	DA5 3PA	GB	0101000020E6100000982F2FC03E3AC13F56F5F23B4DB84940
73509	DA5 3PE	GB	0101000020E6100000DBFD2AC0779BC33FFF21FDF675B84940
73510	DA5 3PQ	GB	0101000020E61000000A2B155454FDC03FB5E0455F41B84940
73511	DA5 3QA	GB	0101000020E61000001EC18D942D92C03F9148DBF813B94940
73512	DA5 3QE	GB	0101000020E610000023D923D40CA9C23F16DC0F7860B84940
73513	DA5 3QF	GB	0101000020E6100000A33B889D2974C23FE78BBD175FB84940
73514	DA5 3QG	GB	0101000020E61000004FB2D5E59480C23F9FE6E44526B84940
73515	DA5 3QH	GB	0101000020E6100000CAA8328CBB41C23FB5E0455F41B84940
73516	DA5 3QJ	GB	0101000020E61000005A2904728923C13F8B6B7C26FBB74940
73517	DA5 3QL	GB	0101000020E61000004034F3E49A02C13F98874CF910B84940
73518	DA5 3QN	GB	0101000020E6100000331AF9BCE2A9C13FE3C281902CB84940
73519	DA5 3QQ	GB	0101000020E61000009B20EA3E00A9C13FE7A90EB919B84940
73520	DA5 3QW	GB	0101000020E6100000C8444AB3791CC23F62D7F6764BB84940
73521	DA6 7AU	GB	0101000020E6100000F50F2219726CC13FBC218D0A9CBA4940
73522	DA6 8BW	GB	0101000020E6100000723106D671FCC03F325871AAB5BA4940
73523	DA7	GB	0101000020E6100000693524EEB1F4C13F42E90B21E7BB4940
73524	DA7 4AA	GB	0101000020E6100000FDA204FD851EC13F79CE16105ABB4940
73525	DA7 4BW	GB	0101000020E6100000C493DDCCE847C13F62DBA2CC06BB4940
73526	DA7 4EW	GB	0101000020E6100000906AD8EF8975C03FFEB7921D1BBB4940
73527	DA7 4SG	GB	0101000020E61000007B4FE5B4A7E4C03F45B9347EE1BB4940
73528	DA7 4TU	GB	0101000020E6100000BC3FDEAB5626C03FF2D3B837BFBB4940
73529	DA7 4UN	GB	0101000020E61000005743E21E4B1FC03FD40CA9A278BB4940
73530	DA7 5NG	GB	0101000020E61000002EAEF199EC9FC13F27DE019EB4BC4940
73531	DA7 5NS	GB	0101000020E6100000E6779ACC785BC13FD9226937FABC4940
73532	DA7 5SU	GB	0101000020E6100000BBEEAD484C50BF3F69A9BC1DE1BC4940
73533	DA7 6HQ	GB	0101000020E6100000A6F10BAF2479C43F64EAAEEC82BB4940
73534	DA7 6LS	GB	0101000020E61000007102D369DD06C53FEC2FBB270FBB4940
73535	DA7 6QD	GB	0101000020E6100000A37895B54DF1C43FD1EAE40CC5BB4940
73536	DA8	GB	0101000020E6100000FCE4284014CCC63FC03C64CA87BC4940
73537	DA8 1EB	GB	0101000020E6100000B54E5C8E5720C43F59F78F85E8BC4940
73538	DA8 1PU	GB	0101000020E61000007460394206F2C43F8176871403BE4940
73539	DA8 2AH	GB	0101000020E6100000F6CE68AB92C8C83FB727486C77BD4940
73540	DA8 2DE	GB	0101000020E6100000A036AAD381ACC73FEAE8B81AD9BB4940
73541	DA8 2EB	GB	0101000020E61000004B2025766D6FC73F08E6E8F17BBB4940
73542	DA8 2JZ	GB	0101000020E61000003E92921E8656CB3FE42CEC6987BD4940
73543	DA8 2NX	GB	0101000020E6100000A25EF0694E5EC83FE6B0FB8EE1BB4940
73544	DA8 3DE	GB	0101000020E61000008AAC3594DA8BC63F0F46EC1340BD4940
73545	DA8 3HB	GB	0101000020E6100000AF21382EE3A6C43FF0A31AF67BBC4940
73546	DA8 3JL	GB	0101000020E61000006C41EF8D2100C63F37A79201A0BC4940
73547	DA9	GB	0101000020E6100000CDAE7B2B1213D23FAD31E884D0B94940
73548	DA9 9AR	GB	0101000020E610000054AC1A84B9DDD03FF9669B1BD3B94940
73549	DA9 9DR	GB	0101000020E6100000AC1BEF8E8CD5D03F64CF9ECBD4B84940
73550	DA9 9EQ	GB	0101000020E6100000E42EC214E5D2D23F57CEDE196DB94940
73551	DA9 9ER	GB	0101000020E61000001C5E10919A76D23FAF264F594DB94940
73552	DA9 9LA	GB	0101000020E610000020B24813EF00D13F0D535BEA20B94940
73553	DA9 9ND	GB	0101000020E6100000732F302B14E9D13FC974E8F4BCB94940
73554	DA9 9NF	GB	0101000020E610000077F4BF5C8B16D23F3CA1D79FC4B94940
73555	DA9 9QN	GB	0101000020E6100000E86A2BF697DDD13F61C26856B6B94940
73556	DD1	GB	0101000020E61000002C280CCA341A08C0BAC0E5B1663C4C40
73557	DD1 1QP	GB	0101000020E6100000D53F8864C8D107C0F56569A7E63A4C40
73558	DD1 2PA	GB	0101000020E6100000FCC401F4FBBE07C033C34659BF3B4C40
73559	DD1 4BY	GB	0101000020E6100000B03907CF84C607C09DBD33DAAA3A4C40
73560	DD1 4HN	GB	0101000020E61000002288F37002D307C0F2B391EBA63A4C40
73561	DD1 4NH	GB	0101000020E61000005D6BEF5355E807C0B2852007253A4C40
73562	DD10 0SR	GB	0101000020E6100000F6B2EDB435C201C0780DFAD2DB6B4C40
73563	DD10 0TG	GB	0101000020E6100000FF5C34643C0A02C037A5BC5642714C40
73564	DD10 8LW	GB	0101000020E6100000CDEA1D6E87C603C0246420CF2E5B4C40
73565	DD10 8QA	GB	0101000020E6100000EF1EA0FB72A603C0B7ED7BD45F5B4C40
73566	DD10 9HH	GB	0101000020E6100000430070ECD9D303C00F0D8B51D75E4C40
73567	DD10 9LQ	GB	0101000020E61000006E693524EE5104C0A986FD9E585D4C40
73568	DD11 1RQ	GB	0101000020E61000001C2444F982B604C05AF5B9DA8A474C40
73569	DD11 2AR	GB	0101000020E610000030D80DDB16C504C0F0A7C64B37474C40
73570	DD11 2BZ	GB	0101000020E61000006475ABE7A4B704C00D6E6B0BCF474C40
73571	DD11 2NS	GB	0101000020E61000004B21904B1C1905C00FD4298F6E484C40
73572	DD11 2NX	GB	0101000020E610000042E8A04B383405C0C2A2224E27474C40
73573	DD11 2RE	GB	0101000020E61000008D800A4790CA05C03E95D39E924B4C40
73574	DD11 2RH	GB	0101000020E6100000FF93BF7B470D06C0EFACDD76A14B4C40
73575	DD11 4AG	GB	0101000020E6100000FEB7921D1BA104C0A86F99D365494C40
73576	DD11 5AA	GB	0101000020E6100000D4D2DC0A619504C00CAD4ECE50484C40
73577	DD11 5BD	GB	0101000020E6100000E564E256418C04C062122EE411484C40
73578	DD11 5DD	GB	0101000020E61000009A0B5C1E6B8604C0231631EC30484C40
73579	DD2	GB	0101000020E610000012329067974F08C0976F7D586F3C4C40
73580	DD2 1NA	GB	0101000020E61000005E10919A763108C023145B41D33A4C40
73581	DD2 1NB	GB	0101000020E6100000B0ABC953563308C06DAD2F12DA3A4C40
73582	DD2 1SW	GB	0101000020E6100000CF81E508196808C091990B5C1E3B4C40
73583	DD2 1TY	GB	0101000020E6100000D653ABAFAE4A08C068976F7D583B4C40
73584	DD2 2BU	GB	0101000020E61000005BCD3AE3FB0208C05DE2C803913B4C40
73585	DD2 2NH	GB	0101000020E6100000732D5A80B6F507C048F8DEDFA03B4C40
73586	DD2 2QD	GB	0101000020E6100000EC4D0CC9C90408C02D05A4FD0F3C4C40
73587	DD2 3HL	GB	0101000020E6100000CEA78E554A0F08C0F6CFD380413E4C40
73588	DD2 3XR	GB	0101000020E6100000C1560916871308C0785F950B953D4C40
73589	DD2 4DS	GB	0101000020E6100000626534F2796508C00EBBEF181E3F4C40
73590	DD2 4EH	GB	0101000020E610000037DF88EE593708C07976F9D6873B4C40
73591	DD2 4TF	GB	0101000020E6100000959BA8A5B95508C00CE8853B173E4C40
73592	DD2 5	GB	0101000020E6100000BD1E4C8A8F6F08C054C4E9245B3F4C40
73593	DD2 5AP	GB	0101000020E6100000247B849A217508C055867137883A4C40
73594	DD2 5DG	GB	0101000020E610000021CCED5EEE9308C07841446ADA394C40
73595	DD2 5DP	GB	0101000020E6100000810871E5EC7D08C055F65D11FC394C40
73596	DD2 5DT	GB	0101000020E6100000FC6EBA65877808C02B3410CB663A4C40
73597	DD2 5EU	GB	0101000020E6100000A835CD3B4ED108C01E3526C45C3A4C40
73598	DD2 5EW	GB	0101000020E610000094313ECC5EF608C0A070766B993A4C40
73599	DD2 5HQ	GB	0101000020E610000050A8A78FC0FF08C0A5BF97C283384C40
73600	DD2 5HS	GB	0101000020E61000009A232BBF0CE608C0E675C4211B384C40
73601	DD2 5HT	GB	0101000020E610000031992A1895D408C0698CD651D5384C40
73602	DD2 5JA	GB	0101000020E6100000130EBDC5C35B08C0BCCFF1D1E23A4C40
73603	DD2 5LL	GB	0101000020E61000006B2920ED7F2009C0C37FBA81023F4C40
73604	DD3	GB	0101000020E6100000A260C614ACD107C0D1798D5DA23A4C40
73605	DD3 0BS	GB	0101000020E6100000541A31B3CFE307C0DD5B9198A03E4C40
73606	DD3 0HU	GB	0101000020E6100000C79FA86C58F307C0F99D2633DE3E4C40
73607	DD3 0QN	GB	0101000020E6100000ECDB4944F8B708C0CD3AE3FBE2424C40
73608	DD3 0QT	GB	0101000020E610000028EFE3688EAC08C04B766C04E2454C40
73609	DD3 6QW	GB	0101000020E61000000A849D62D5E007C0D2C43BC0933C4C40
73610	DD3 6TR	GB	0101000020E610000081CD397826D407C0300F99F2213C4C40
73611	DD3 8EG	GB	0101000020E6100000566133C005D907C03C4A253CA13D4C40
73612	DD3 8LJ	GB	0101000020E6100000D1B01875ADDD07C05471E316F33D4C40
73613	DD3 9RJ	GB	0101000020E6100000CF488446B01108C04703780B24404C40
73614	DD4	GB	0101000020E6100000B1DCD26A48DC07C0508F6D19703E4C40
73615	DD4 0	GB	0101000020E610000009151C5E10D107C014EB54F99E3F4C40
73616	DD4 0NP	GB	0101000020E6100000F390291F824A07C0B5DD04DF343F4C40
73617	DD4 0QX	GB	0101000020E610000011E2CAD93B8307C08E739B70AF424C40
73618	DD4 6NN	GB	0101000020E61000003B511212699B07C080D250A3903C4C40
73619	DD4 6PR	GB	0101000020E6100000F31FD26F5FA707C017B83CD68C3C4C40
73620	DD4 7ED	GB	0101000020E6100000D40CA9A2789507C0520C9068023D4C40
73621	DD4 8AL	GB	0101000020E61000009A982EC4EA8F07C0DE0033DFC13D4C40
73622	DD4 9FB	GB	0101000020E6100000B5183C4CFBA607C0543882548A3F4C40
73623	DD4 9PF	GB	0101000020E61000008201840F257A07C03CF6B3588A3E4C40
73624	DD5	GB	0101000020E6100000D3FA5B02F0EF06C06682E15CC33C4C40
73625	DD5 1	GB	0101000020E610000049658A3908FA06C0DCF5D214013C4C40
73626	DD5 1DY	GB	0101000020E6100000DFF8DA334B0207C0DBDE6E490E3C4C40
73627	DD5 1QN	GB	0101000020E6100000466117450F3C07C0AD855968E73C4C40
73628	DD5 2JG	GB	0101000020E6100000D9B45208E4F206C0FE9DEDD11B3C4C40
73629	DD5 2JS	GB	0101000020E610000014967840D9F406C02E008DD2A53B4C40
73630	DD5 2SQ	GB	0101000020E6100000A2D5C9198ABB06C0D829560DC23C4C40
73631	DD5 2TS	GB	0101000020E61000001B9B1DA9BED306C01FA2D11DC43C4C40
73632	DD5 3EE	GB	0101000020E61000008331225168F906C07522C154333D4C40
73633	DD5 3JY	GB	0101000020E6100000A9BF5E61C11D07C02A90D959F43C4C40
73634	DD5 3SF	GB	0101000020E6100000C939B187F6D106C0F6D37FD6FC3C4C40
73635	DD5 4EF	GB	0101000020E61000001C25AFCE318006C00DA7CCCD373E4C40
73636	DD5 4EW	GB	0101000020E6100000CEFE40B96D7F06C0DD5CFC6D4F3E4C40
73637	DD5 4QA	GB	0101000020E61000004359F8FA5AB706C0FF942A51F63C4C40
73638	DD5 4QU	GB	0101000020E61000007A54FCDF11B506C00DAA0D4E443D4C40
73639	DD6	GB	0101000020E6100000AB09A2EE031007C01F2DCE18E6384C40
73640	DD6 8JD	GB	0101000020E6100000B4386398139407C0ACCABE2B82374C40
73641	DD6 8LS	GB	0101000020E610000068CEFA9463D207C05E30B8E68E364C40
73642	DD6 8LU	GB	0101000020E61000006765FB90B7DC07C0D3BEB9BF7A364C40
73643	DD6 8NB	GB	0101000020E61000002026E1421EE107C03FC7478B33364C40
73644	DD6 9HU	GB	0101000020E6100000018750A5660F07C026C5C72764394C40
73645	DD7	GB	0101000020E610000065C6DB4AAF6D05C0D4B5F63E553F4C40
73646	DD7 7JZ	GB	0101000020E61000004628B682A6C505C08EB0A888D33F4C40
73647	DD7 7NY	GB	0101000020E61000007A6EA12B11E805C023DC645419404C40
73648	DD7 7RJ	GB	0101000020E61000000057B263231006C0992EC4EA8F404C40
73649	DD8 1RR	GB	0101000020E6100000CA6B2574970408C0821FD5B0DF4D4C40
73650	DD8 1RT	GB	0101000020E61000001CB5C2F4BD0608C0950F41D5E84D4C40
73651	DD8 1XF	GB	0101000020E61000002D25CB49285D07C08B389D64AB4D4C40
73652	DD8 2LJ	GB	0101000020E6100000E78D93C2BCC706C04A99D4D006504C40
73653	DD8 2QF	GB	0101000020E61000008ECEF9298E2306C0E55E605628504C40
73654	DD8 2SN	GB	0101000020E61000006E50FBAD9DA805C0C49448A297514C40
73655	DD8 4BX	GB	0101000020E6100000BBB6B75B920308C0EF703B342C564C40
73656	DD8 4DB	GB	0101000020E6100000ADF71BEDB80108C0B459F5B9DA564C40
73657	DD8 4QS	GB	0101000020E6100000BC3FDEAB56A608C05EBA490C026B4C40
73658	DD8 5BN	GB	0101000020E6100000FCC56CC9AA0808C0C6FCDCD094554C40
73659	DD8 5JJ	GB	0101000020E61000002F88484DBB7809C0506D7022FA554C40
73660	DD9 6	GB	0101000020E61000004E0E9F74224105C0957EC2D9AD5D4C40
73661	DE1	GB	0101000020E61000001AE1ED410888F7BF56D3F544D7754A40
73662	DE1 1DZ	GB	0101000020E6100000946A9F8EC7CCF7BFCBF78C4468764A40
73663	DE1 1LH	GB	0101000020E6100000F279C5538FB4F7BFB0C6D97404764A40
73664	DE1 1PP	GB	0101000020E6100000D7BD158909AAF7BFCC7F48BF7D754A40
73665	DE1 1XB	GB	0101000020E61000008B8C0E48C2BEF7BFD4D688601C764A40
73666	DE1 2BR	GB	0101000020E6100000668522DDCF69F7BF11E2CAD93B754A40
73667	DE1 2DW	GB	0101000020E61000005DF8C1F9D471F7BF7DE71725E8754A40
73668	DE1 2FS	GB	0101000020E6100000B1A547533D99F7BF12D9075916764A40
73669	DE1 3AR	GB	0101000020E610000005FA449E249DF7BF2123A0C211764A40
73670	DE1 3AZ	GB	0101000020E6100000EFCB99ED0ABDF7BF8333F8FBC5764A40
73671	DE1 3DE	GB	0101000020E61000005874EB353DA8F7BFA6D0798D5D764A40
73672	DE1 3EP	GB	0101000020E6100000014EEFE2FDB8F7BF6687F8872D774A40
73673	DE1 3LQ	GB	0101000020E6100000A489778027ADF7BFEFAA07CC43764A40
73674	DE1 3NH	GB	0101000020E61000007FD93D7958A8F7BF18963FDF16764A40
73675	DE1 3NQ	GB	0101000020E6100000A4A7C821E2A6F7BF779E78CE16764A40
73676	DE1 3PD	GB	0101000020E61000004F9143C4CDA9F7BF82E49D4319764A40
73677	DE1 3RZ	GB	0101000020E6100000EF39B01C2183F7BF81B1BE81C9774A40
73678	DE1 3SN	GB	0101000020E6100000DDD1FF722DDAF7BF19E42EC214774A40
73679	DE11	GB	0101000020E6100000F81C588E9001F9BF5262D7F676634A40
73680	DE11 0BH	GB	0101000020E61000001749BBD1C7FCF8BF488B338639634A40
73681	DE11 0LH	GB	0101000020E6100000527C7C42761EF9BF5D3123BC3D644A40
73682	DE11 0QR	GB	0101000020E610000066118AADA029F9BFE751F17F47644A40
73683	DE11 2RW	GB	0101000020E6100000994869368F43F9BFE7A90EB919624A40
73684	DE11 7LX	GB	0101000020E6100000AEBCE47FF2B7F8BF79AEEFC341644A40
73685	DE11 9AE	GB	0101000020E6100000732EC55565DFF8BF39B874CC79624A40
73686	DE11 9AH	GB	0101000020E6100000F52D73BA2CE6F8BF7EE5417A8A624A40
73687	DE11 9PH	GB	0101000020E61000009609BFD4CF1BF9BFDC9E20B1DD614A40
73688	DE11 9PL	GB	0101000020E61000004791B58652FBF8BF12BD8C62B9614A40
73689	DE12 6ER	GB	0101000020E6100000D064FF3C0D58F8BF753FA7203F5F4A40
73690	DE12 6NB	GB	0101000020E61000000EBDC5C37B0EF9BF35F0A31AF65D4A40
73691	DE12 6QN	GB	0101000020E6100000666A12BC218DF9BF4D4D8237A45F4A40
73692	DE12 6RB	GB	0101000020E610000097546D37C177F9BFA3B1F677B65F4A40
73693	DE12 7	GB	0101000020E6100000166EF9484AFAF7BF96404AECDA584A40
73694	DE12 7AF	GB	0101000020E6100000B18BA2073E86F8BF3F19E3C3EC574A40
73695	DE13	GB	0101000020E6100000876C205D6C5AF8BF8E76DCF0BB674A40
73696	DE13 0AW	GB	0101000020E61000002C2CB81FF0C0FABF53211E89976B4A40
73697	DE13 0AZ	GB	0101000020E6100000CD5B751DAA29FABFA471A8DF856B4A40
73698	DE13 0DU	GB	0101000020E61000003D9D2B4A0901FABF505436ACA96A4A40
73699	DE13 0GZ	GB	0101000020E6100000C51EDAC70AFEF9BF0E130D52F06A4A40
73700	DE13 0HB	GB	0101000020E61000004568041BD73FFABF9CC420B0726A4A40
73701	DE13 0JD	GB	0101000020E61000006971C63027E8F9BFD2AC6C1FF26A4A40
73702	DE13 0JN	GB	0101000020E61000004167D2A6EA1EFABF56BC9179E4694A40
73703	DE13 0PN	GB	0101000020E6100000042159C0046EFABF18247D5A45694A40
73704	DE13 0PQ	GB	0101000020E6100000DC48D9226977FABFD61BB5C2F4694A40
73705	DE13 0TD	GB	0101000020E6100000B05758703F60FABF81ED60C43E694A40
73706	DE13 0TL	GB	0101000020E6100000ADF71BEDB821FABFF4C473B680684A40
73707	DE13 0XT	GB	0101000020E6100000C0EB33677D4AFABF7D1F0E12A26A4A40
73708	DE13 7AG	GB	0101000020E610000050340F6091DFFBBF80B6D5AC335E4A40
73709	DE13 7AX	GB	0101000020E61000004031B2648EE5FBBF0FB40243565D4A40
73710	DE13 7EE	GB	0101000020E6100000DC662AC423F1FBBF506EDBF7A85D4A40
73711	DE13 7HW	GB	0101000020E61000005BEA20AF0713FDBF3A22DFA5D45F4A40
73712	DE13 8BU	GB	0101000020E6100000215B96AFCB30FCBFA69718CBF45F4A40
73713	DE13 8ET	GB	0101000020E6100000E57CB1F7E28BFBBF69AD68739C614A40
73714	DE13 8JD	GB	0101000020E6100000FBC9181F66AFFBBFBBD408FD4C614A40
73715	DE13 8NQ	GB	0101000020E6100000990E9D9E77A3FCBFDA9255116E624A40
73716	DE13 8QD	GB	0101000020E6100000876F61DD78B7FCBFAA108FC4CB614A40
73717	DE13 8RB	GB	0101000020E6100000D636C5E3A2DAFCBFF0BE2A172A674A40
73718	DE13 9AJ	GB	0101000020E610000011A62897C62FFABFCBBDC0AC506C4A40
73719	DE13 9BE	GB	0101000020E610000009FF2268CC64FABF859675FF586C4A40
73720	DE13 9BY	GB	0101000020E61000009206B7B585A7FABF9E44847F116C4A40
73721	DE13 9JF	GB	0101000020E61000008B506C054D0BFBBFDFE2E13D076E4A40
73722	DE13 9NL	GB	0101000020E61000004E5E64027E0DFBBF08228B34F16C4A40
73723	DE13 9QT	GB	0101000020E6100000D350A3906456FABF48F8DEDFA06B4A40
73724	DE13 9TE	GB	0101000020E6100000CC608C4814DAFABFD106600322684A40
73725	DE13 9TH	GB	0101000020E61000001DAD6A4947F9FABFC0E78711C2674A40
73726	DE13 9TL	GB	0101000020E610000025EB707495EEFABFA857CA32C4674A40
73727	DE14 1BY	GB	0101000020E61000000A2B1554543DFABF6F0ED76A0F674A40
73728	DE14 2AQ	GB	0101000020E61000009C4EB2D5E514FABF53E8BCC62E694A40
73729	DE14 2AU	GB	0101000020E610000066136058FE7CFABFDF6A9DB81C674A40
73730	DE14 2DA	GB	0101000020E61000009A42E7357649FABFBF81C98D22674A40
73731	DE14 2HL	GB	0101000020E61000001B2B31CF4A5AFABF39EE940ED6674A40
73732	DE14 2JS	GB	0101000020E6100000AA4544317943FABF9A249694BB674A40
73733	DE14 2LU	GB	0101000020E6100000D80E46EC1340FABF93E2E313B2674A40
73734	DE14 2PN	GB	0101000020E61000000ABE69FAEC40FABF84BA48A12C684A40
73735	DE14 2WB	GB	0101000020E6100000A629029CDEC5FABF6B2DCC423B654A40
73736	DE14 2WF	GB	0101000020E6100000A45016BEBE96FABF8AABCABE2B664A40
73737	DE14 3AF	GB	0101000020E6100000E3A7716F7E43FABF4417D4B7CC654A40
73738	DE14 3AH	GB	0101000020E610000040DD40817732FABFE28FA2CEDC654A40
73739	DE14 3RJ	GB	0101000020E61000003D44A33B881DFABF3F53AF5B04664A40
73740	DE14 3RW	GB	0101000020E6100000D921FE614B0FFABF6C7A50508A664A40
73741	DE14 3SH	GB	0101000020E610000069554B3ACA41FABFB857E6ADBA664A40
73742	DE14 9GX	GB	0101000020E61000003BFF76D9AF7BFABFCCD3B9A294644A40
73743	DE15 0AB	GB	0101000020E6100000240A2DEBFEB1F9BF63B48EAA26684A40
73744	DE15 0DW	GB	0101000020E6100000EB387EA834A2F9BF86C77E164B674A40
73745	DE15 0DX	GB	0101000020E6100000E9633E20D099F9BF5EF23FF9BB674A40
73746	DE15 0NL	GB	0101000020E61000001971016894AEF9BFF7E5CC7685664A40
73747	DE15 0NX	GB	0101000020E61000008A00A777F17EF9BF068195438B664A40
73748	DE15 0YZ	GB	0101000020E610000069C6A2E9EC24F9BFE754320054654A40
73749	DE15 9AB	GB	0101000020E6100000FA7E6ABC74D3F9BF8E5C37A5BC664A40
73750	DE15 9AN	GB	0101000020E61000004FCDE506439DF9BF0C40A374E9654A40
73751	DE15 9BD	GB	0101000020E6100000B3B112F3ACE4F9BF3C66A032FE654A40
73752	DE15 9EY	GB	0101000020E610000071E316F37303FABF0B992B836A654A40
73753	DE15 9GJ	GB	0101000020E61000005872158BDF94F9BF1A14CD0358664A40
73754	DE15 9HB	GB	0101000020E610000037DDB243FC03FABFDFC14F1C40654A40
73755	DE15 9HN	GB	0101000020E61000009EB30584D6C3F9BF6138D73043654A40
73756	DE15 9LD	GB	0101000020E610000096CFF23CB8FBF9BF3080F0A144654A40
73757	DE15 9RS	GB	0101000020E61000006DA818E76F02FABF9D9D0C8E92654A40
73758	DE2	GB	0101000020E6100000844A5CC7B862F6BF753C66A032764A40
73759	DE21	GB	0101000020E610000048FC8A355CE4F6BF6555849B8C784A40
73760	DE21 2LR	GB	0101000020E610000027F911BF62CDF6BF83F92B64AE784A40
73761	DE21 2RA	GB	0101000020E61000009D2D20B41EBEF6BF38143E5B07794A40
73762	DE21 2TD	GB	0101000020E610000040C05AB56BC2F6BF7573F1B73D794A40
73763	DE21 2XT	GB	0101000020E61000000934D8D47994F6BFAA45443179794A40
73764	DE21 4JA	GB	0101000020E6100000855FEAE74D05F7BF22E3512AE1774A40
73765	DE21 4QS	GB	0101000020E6100000C72FBC92E4F9F6BF70CD1DFD2F774A40
73766	DE21 4SZ	GB	0101000020E610000038DC476E4D7AF7BFF3E32F2DEA774A40
73767	DE21 5BL	GB	0101000020E61000005E11FC6F25BBF6BFFC6D4F90D87E4A40
73768	DE21 6DA	GB	0101000020E61000005551BCCADA66F7BFD6C8AEB48C764A40
73769	DE21 6RW	GB	0101000020E61000000796236420CFF6BFC09657AEB7754A40
73770	DE21 7EQ	GB	0101000020E6100000490ED8D5E469F6BFBD1B0B0A83764A40
73771	DE21 7HY	GB	0101000020E610000024438EAD6788F6BF988922A46E7B4A40
73772	DE21 7LU	GB	0101000020E6100000278925E5EEB3F6BF1FDAC70A7E754A40
73773	DE21 7RX	GB	0101000020E6100000DFE17668588CF6BF967B8159A1744A40
73774	DE22	GB	0101000020E610000073F4F8BD4DFFF6BF594FADBEBA864A40
73775	DE22 1BH	GB	0101000020E610000019C8B3CBB7BEF7BFD6C56D3480774A40
73776	DE22 1BP	GB	0101000020E610000023C0E95DBCDFF7BFDD06B5DFDA774A40
73777	DE22 1ET	GB	0101000020E610000009C4EBFA05BBF7BF81CF0F2384794A40
73778	DE22 1GB	GB	0101000020E610000032772D211FF4F7BF876D8B321B784A40
73779	DE22 1JX	GB	0101000020E6100000A14CA3C9C5D8F7BFB91803EB38784A40
73780	DE22 2BA	GB	0101000020E61000005859DB148FCBF7BF23BA675DA3794A40
73781	DE22 2FJ	GB	0101000020E6100000E1D05B3CBCE7F7BF59A7CAF78C7C4A40
73782	DE22 2FS	GB	0101000020E610000030F5F3A622D5F7BFCE1951DA1B7A4A40
73783	DE22 2GG	GB	0101000020E6100000ADDC0BCC0AC5F7BFF8E0B54B1B7A4A40
73784	DE22 2SZ	GB	0101000020E6100000B2D5E5948018F8BFCBA145B6F3794A40
73785	DE22 3AD	GB	0101000020E61000004E29AF95D0DDF7BFD4F2035779764A40
73786	DE22 3EF	GB	0101000020E61000009B711AA20AFFF7BFBB9D7DE541764A40
73787	DE22 3GB	GB	0101000020E6100000221807978EF9F7BFD15CA79196764A40
73788	DE22 3GD	GB	0101000020E6100000498446B071FDF7BF0F48C2BE9D764A40
73789	DE22 3JB	GB	0101000020E6100000EBABAB02B5D8F7BFD960E124CD754A40
73790	DE22 3LZ	GB	0101000020E61000009E077767ED36F8BFD66EBBD05C754A40
73791	DE22 3NL	GB	0101000020E61000007383A10E2BDCF7BF84471B47AC754A40
73792	DE22 3PB	GB	0101000020E61000007653CA6B25F4F7BF7EA8346266754A40
73793	DE22 3PP	GB	0101000020E6100000E2934E2498EAF7BFD42B6519E2744A40
73794	DE22 3QT	GB	0101000020E61000006B0C3A2174D0F7BFEF1AF4A5B7754A40
73795	DE22 3QU	GB	0101000020E61000008A39083A5AD5F7BF9E3F6D54A7754A40
73796	DE22 3ST	GB	0101000020E61000005C92037635B9F7BFA565A4DE53754A40
73797	DE22 3TH	GB	0101000020E6100000834D9D47C53FF7BFFB1EF5D72B764A40
73798	DE22 3UF	GB	0101000020E61000002AA73D25E7C4F7BF6A334E4354754A40
73799	DE22 3UL	GB	0101000020E6100000314278B471C4F7BF6D1ADB6B41754A40
73800	DE22 3UN	GB	0101000020E6100000C7D45DD905C3F7BF0492B06F27754A40
73801	DE22 3UP	GB	0101000020E6100000BE175FB4C7CBF7BF246420CF2E754A40
73802	DE22 3UT	GB	0101000020E6100000570A815CE2C8F7BF7F2E1A321E754A40
73803	DE22 4BT	GB	0101000020E6100000132D793C2D3FF8BF8FFE976BD1764A40
73804	DE22 4DZ	GB	0101000020E610000001DBC1887D42F8BF5F28603B18774A40
73805	DE22 4EY	GB	0101000020E61000001A6B7F677B74F8BF8E23D6E253764A40
73806	DE22 4FQ	GB	0101000020E610000099654F029B73F8BF959A3DD00A764A40
73807	DE22 4HF	GB	0101000020E610000062156F641E39F8BF0053060E68774A40
73808	DE22 5EN	GB	0101000020E6100000001E51A1BAF9F7BF79573D601E764A40
73809	DE22 5JA	GB	0101000020E610000058C7F143A511F8BF4ED367075C7B4A40
73810	DE22 5JH	GB	0101000020E61000001A868F882991F8BFEDD286C3D27A4A40
73811	DE22 5JR	GB	0101000020E610000065C6DB4AAFCDF7BF793BC269C17B4A40
73812	DE23	GB	0101000020E61000001E8B6D52D1D8F7BF8ECEF9298E734A40
73813	DE23 1DB	GB	0101000020E6100000F6ED2422FC0BF8BF14967840D9724A40
73814	DE23 1HG	GB	0101000020E61000008E588B4F01F0F7BF145E82531F724A40
73815	DE23 1TN	GB	0101000020E6100000AAF06778B306F8BFBD72BD6DA6724A40
73816	DE23 2GG	GB	0101000020E6100000C6A6954220D7F7BF5ABDC3EDD0744A40
73817	DE23 3DT	GB	0101000020E6100000C0EAC891CE40F8BF03B4AD669D734A40
73818	DE23 3UD	GB	0101000020E6100000CB845FEAE74DF8BF2B3410CB66724A40
73819	DE23 3WE	GB	0101000020E6100000B7291E17D562F8BF72FDBB3E73724A40
73820	DE23 6BA	GB	0101000020E6100000B3295778970BF8BF6E693524EE734A40
73821	DE23 6EE	GB	0101000020E6100000AC527AA69718F8BF5A9BC6F65A744A40
73822	DE23 6HY	GB	0101000020E6100000BEA4315A4715F8BF8B71FE2614744A40
73823	DE23 6JY	GB	0101000020E6100000A7CB6262F3F1F7BFBB2BBB6070734A40
73824	DE23 6TJ	GB	0101000020E61000007F87A2409FC8F7BF639CBF0985744A40
73825	DE23 6UG	GB	0101000020E610000007077B1343B2F7BFAB251DE560744A40
73826	DE23 8BP	GB	0101000020E6100000118FC4CBD3B9F7BF7B8670CCB2734A40
73827	DE23 8BY	GB	0101000020E6100000F910548D5ECDF7BF63D34A2190734A40
73828	DE23 8FR	GB	0101000020E6100000A14ACD1E6885F7BF30DAE38574744A40
73829	DE23 8FY	GB	0101000020E610000002452C62D8A1F7BFC669882AFC734A40
73830	DE23 8UW	GB	0101000020E6100000AFD2DD7536A4F7BFDD09F65FE7724A40
73831	DE24	GB	0101000020E6100000DAC9E0287935F7BFA20BEA5BE6704A40
73832	DE24 0FN	GB	0101000020E6100000C362D4B5F6FEF6BF3A9677D503724A40
73833	DE24 0FT	GB	0101000020E6100000D7135D177EF0F6BFA260C614AC714A40
73834	DE24 0JH	GB	0101000020E6100000F3E49A0299DDF6BFFF78AF5A99724A40
73835	DE24 0JS	GB	0101000020E6100000AE9D280989B4F6BFA2B77878CF714A40
73836	DE24 0JW	GB	0101000020E6100000F0BF95ECD8C8F6BF527DE71725724A40
73837	DE24 0PA	GB	0101000020E61000006ADB300A82C7F6BFCAA4863600734A40
73838	DE24 0PR	GB	0101000020E61000003FADA23F34B3F6BF4D672783A3724A40
73839	DE24 2BH	GB	0101000020E61000000BB8E7F9D306F8BF2252D32EA66F4A40
73840	DE24 4TH	GB	0101000020E61000005E143DF03118F7BF0A3197546D734A40
73841	DE24 8NT	GB	0101000020E61000001A88653387E4F6BF3EE94482A9744A40
73842	DE24 8QX	GB	0101000020E6100000732F302B14E9F6BFB83F170D19734A40
73843	DE24 8RP	GB	0101000020E6100000AED7F4A0A054F6BF6F4562821A764A40
73844	DE24 8UP	GB	0101000020E61000003430F2B22656F7BFAA0EB9196E744A40
73845	DE24 8WL	GB	0101000020E61000003F1D8F19A8CCF5BFCFA10C5531794A40
73846	DE24 8XL	GB	0101000020E6100000BF0CC6884421F7BF5B07077B13754A40
73847	DE24 9AL	GB	0101000020E6100000A94A5B5CE333F7BFF698486936714A40
73848	DE24 9BU	GB	0101000020E6100000A2427573F137F7BF2106BAF605724A40
73849	DE24 9DD	GB	0101000020E6100000AEBA0ED59424F7BFA7069ACFB9714A40
73850	DE24 9DE	GB	0101000020E6100000287CB60E0E36F7BFB760A92EE0714A40
73851	DE24 9EL	GB	0101000020E61000006ADFDC5F3D2EF7BF5A83F755B9704A40
73852	DE24 9PD	GB	0101000020E61000003C2F151BF3BAF7BF4AD1CABDC0704A40
73853	DE24 9PT	GB	0101000020E61000002920ED7F80B5F7BF605628D2FD704A40
73854	DE3 0QE	GB	0101000020E6100000C2A6CEA3E2BFF8BFAF5A99F04B754A40
73855	DE3 0RU	GB	0101000020E61000009C16BCE82BC8F8BF9966BAD749754A40
73856	DE3 0SL	GB	0101000020E61000005BCEA5B8AAECF8BF40DD408177724A40
73857	DE3 9	GB	0101000020E610000007EA94473782F8BF9143C4CDA9744A40
73858	DE3 9AS	GB	0101000020E6100000E8A04B38F456F8BFD097DEFE5C744A40
73859	DE3 9BL	GB	0101000020E61000001DB0ABC95396F8BF7D03931B45744A40
73860	DE3 9FH	GB	0101000020E610000087A5811FD5B0F8BFB890477023754A40
73861	DE3 9SW	GB	0101000020E61000009A43520B2593F8BF236937FA98734A40
73862	DE4	GB	0101000020E61000006954E0641B38F9BF643A747ADE8F4A40
73863	DE4 2AE	GB	0101000020E61000004DBB9866BA57F9BF31EE06D15A8F4A40
73864	DE4 2AW	GB	0101000020E610000054E0641BB883F9BF463F1A4E998F4A40
73865	DE4 2AX	GB	0101000020E61000008E23D6E25380F9BFA911FA997A8F4A40
73866	DE4 2DP	GB	0101000020E61000009679ABAE43F5F9BF425C397B67924A40
73867	DE4 2DQ	GB	0101000020E6100000570A815CE248FABF47C9AB730C924A40
73868	DE4 2DS	GB	0101000020E6100000A8A78FC01F3EFABFFB761211FE914A40
73869	DE4 2FY	GB	0101000020E61000004016A243E088F9BF24D236FE44954A40
73870	DE4 2HF	GB	0101000020E6100000A3923A014D84F9BF360186E5CF954A40
73871	DE4 2HX	GB	0101000020E61000000589EDEE01FAF9BF295AB91798954A40
73872	DE4 2JS	GB	0101000020E6100000C2A2224E2799F9BF377172BF43934A40
73873	DE4 2SD	GB	0101000020E61000007845F0BF956CF9BF4852D2C3D0944A40
73874	DE4 3AG	GB	0101000020E61000001F84807C09D5F8BF0074982F2F924A40
73875	DE4 3FY	GB	0101000020E61000005F46B1DCD2AAF8BF9D2CB5DE6F924A40
73876	DE4 3JQ	GB	0101000020E61000003A24B5503279FBBF7EE36BCF2C9D4A40
73877	DE4 3NA	GB	0101000020E6100000739D465A2AEFF8BFCBBF9657AE914A40
73878	DE4 3NN	GB	0101000020E610000079C9FFE4EFDEF8BFF81BEDB8E1914A40
73879	DE4 3QB	GB	0101000020E6100000FD9FC37C79C1F8BFF357C85C19924A40
73880	DE4 4AP	GB	0101000020E6100000ACC43C2B6945F9BF8FAA2688BA894A40
73881	DE4 4BG	GB	0101000020E6100000D751D5045137F9BF09FD4CBD6E894A40
73882	DE4 4BW	GB	0101000020E6100000384888F2052DFABF87A757CA328E4A40
73883	DE4 4DE	GB	0101000020E6100000F6D4EAABAB02FABF4C8DD0CFD4894A40
73884	DE4 4DG	GB	0101000020E61000009D64ABCB2941F9BFFAB9A1293B894A40
73885	DE4 4ER	GB	0101000020E610000053CDACA58034F9BF6F8445459C8A4A40
73886	DE4 4EX	GB	0101000020E61000006551D845D143F9BF499F56D11F8A4A40
73887	DE4 4FB	GB	0101000020E61000009A931799801FF9BF666CE8667F8A4A40
73888	DE4 4FD	GB	0101000020E610000068942EFD4B12F9BFA19E3E027F8A4A40
73889	DE4 4FG	GB	0101000020E6100000B6F3FDD47829F9BF184339D1AE8A4A40
73890	DE4 4HB	GB	0101000020E610000065C570750084FABFDB8AFD65F78A4A40
73891	DE4 4NF	GB	0101000020E6100000AC53E57B4662F9BF446B459BE38C4A40
73892	DE4 5BH	GB	0101000020E61000008176871403A4F7BF16687748318A4A40
73893	DE4 5DW	GB	0101000020E61000008A5A9A5B21ACF7BF5796E82CB38A4A40
73894	DE4 5EP	GB	0101000020E6100000399D64ABCBE9F7BF7171546EA28A4A40
73895	DE4 5EX	GB	0101000020E61000009162804413A8F8BF76711B0DE0914A40
73896	DE4 5FY	GB	0101000020E6100000377172BF4351F8BF3D0CAD4ECE904A40
73897	DE4 5HE	GB	0101000020E61000006211C30E6312F8BF6D3997E2AA8A4A40
73898	DE4 5JA	GB	0101000020E6100000E200FA7DFFE6F8BF2C8194D8B58F4A40
73899	DE4 5JJ	GB	0101000020E61000006FF1F09E03CBF8BF637FD93D798E4A40
73900	DE45 1EL	GB	0101000020E6100000390EBC5AEECCFABFE63E390A109B4A40
73901	DE45 1JE	GB	0101000020E610000077137CD3F419FBBF49111956F1984A40
73902	DE45 1LA	GB	0101000020E610000088307E1AF766FABF3CA41820D1984A40
73903	DE45 1QN	GB	0101000020E6100000C0B0FCF9B660FBBFBA675DA3E59C4A40
73904	DE45 1RR	GB	0101000020E6100000ED478AC8B00AFABF4012F6ED24A04A40
73905	DE45 1SR	GB	0101000020E610000041F0F8F6AEC1F9BFBCEA01F3909F4A40
73906	DE5	GB	0101000020E610000015C616821C14F7BF768C2B2E8E7E4A40
73907	DE5 3BB	GB	0101000020E61000001AFB928D075BF6BFB98C9B1A68864A40
73908	DE5 3ER	GB	0101000020E6100000CF4E0647C96BF6BFDC2F9FAC18864A40
73909	DE5 3HN	GB	0101000020E61000005C751DAA2909F6BF919DB7B1D9854A40
73910	DE5 3HZ	GB	0101000020E61000002713B70A6260F6BF2AFD84B35B854A40
73911	DE5 6LP	GB	0101000020E610000056F5F23B4D26F6BFC2FA3F87F9904A40
73912	DE5 8JB	GB	0101000020E6100000BEA3C684988BF6BFF699B33EE5844A40
73913	DE5 8JF	GB	0101000020E610000051BF0B5BB395F6BFA182C30B22844A40
73914	DE5 8JJ	GB	0101000020E610000087889B53C980F6BFF758FAD005854A40
73915	DE5 8PA	GB	0101000020E6100000DB4C8578249EF6BFEB6E9EEA90814A40
73916	DE5 9RX	GB	0101000020E6100000787FBC57AD0CF6BF80BA8102EF844A40
73917	DE55	GB	0101000020E6100000F6D1A92B9F65F5BF2429E961688D4A40
73918	DE55 1DJ	GB	0101000020E610000004594FADBE3AF6BF4DBED9E6C68A4A40
73919	DE55 1EH	GB	0101000020E6100000D9942BBCCB45F6BF0D39B69E218A4A40
73920	DE55 2AX	GB	0101000020E6100000BD0166BE839FF5BF990CC7F3198C4A40
73921	DE55 2DN	GB	0101000020E6100000354415FE0C6FF5BF6B0DA5F6228E4A40
73922	DE55 3NN	GB	0101000020E61000009F1D705D3163F5BF4C6BD3D85E8D4A40
73923	DE55 4AR	GB	0101000020E6100000BBD408FD4CFDF5BFB08EE3874A894A40
73924	DE55 4ND	GB	0101000020E6100000FC389A232BBFF5BF6B9E23F25D8A4A40
73925	DE55 5LG	GB	0101000020E61000000AA1832EE150F5BF02A08A1BB7924A40
73926	DE55 5PP	GB	0101000020E61000009C89E942AC7EF5BF5740A19E3E924A40
73927	DE55 5UB	GB	0101000020E6100000FAB31F292243F5BFBE310400C7924A40
73928	DE55 6FH	GB	0101000020E61000008FFCC1C0732FF7BFB20E4757E9924A40
73929	DE55 7AY	GB	0101000020E61000008AAF7614E7A8F5BF658BA4DDE88B4A40
73930	DE55 7DQ	GB	0101000020E61000008D7F9F71E140F6BF423F53AF5B8C4A40
73931	DE55 7EW	GB	0101000020E610000081B1BE81C90DF6BFE65C8AABCA8C4A40
73932	DE56	GB	0101000020E610000097C62FBC9264F7BF1A4D2EC6C0824A40
73933	DE56 0HU	GB	0101000020E61000005D70067FBF58F7BF9964E42CEC834A40
73934	DE56 0JA	GB	0101000020E6100000A986FD9E5867F7BFF148BC3C9D814A40
73935	DE56 0SJ	GB	0101000020E6100000856055BDFC4EF7BFD2FE0758AB824A40
73936	DE56 1DA	GB	0101000020E61000002FC214E5D2B8F7BF9301A08A1B834A40
73937	DE56 1DN	GB	0101000020E61000006A6CAF05BDB7F7BFEA92718C64834A40
73938	DE56 1EJ	GB	0101000020E61000003CC093162EABF7BFCE8DE9094B844A40
73939	DE56 1GB	GB	0101000020E6100000143FC6DCB584F7BFAEBCE47FF2834A40
73940	DE56 1GN	GB	0101000020E61000004757E9EE3A9BF7BFD3F4D901D7834A40
73941	DE56 1JH	GB	0101000020E6100000EB8D5A61FA9EF7BF66136058FE824A40
73942	DE56 1LJ	GB	0101000020E610000075B0FECF617EF7BF2829B000A6824A40
73943	DE56 1RZ	GB	0101000020E61000002E3883BF5F4CF7BF52465C001A834A40
73944	DE56 1TJ	GB	0101000020E6100000E7340BB43BA4F7BFA3ACDF4C4C834A40
73945	DE56 2BE	GB	0101000020E6100000A65EB7088C35F7BF520E661360864A40
73946	DE56 2BN	GB	0101000020E61000009835B1C05734F7BF65E3C116BB854A40
73947	DE56 2EN	GB	0101000020E6100000B0592E1B9DB3F7BFA5BBEB6CC8874A40
73948	DE56 2EW	GB	0101000020E6100000812381069B7AF7BF4CA8E0F082884A40
73949	DE56 2JN	GB	0101000020E6100000F3E846585484F7BF6518778368874A40
73950	DE56 2LG	GB	0101000020E61000005858703FE0C1F8BFBEDBBC7152824A40
73951	DE56 2TS	GB	0101000020E61000005FB2F1608BDDF7BF279F1EDB32844A40
73952	DE56 2UE	GB	0101000020E610000093A641D13CC0F7BF202922C32A844A40
73953	DE56 4EP	GB	0101000020E610000092955F0663C4F7BF95B6B8C6677E4A40
73954	DE56 4EW	GB	0101000020E6100000BF49D3A068DEF7BFD49AE61DA77E4A40
73955	DE56 4FL	GB	0101000020E6100000174850FC18F3F7BF6EDDCD531D804A40
73956	DE6	GB	0101000020E6100000637C98BD6CBBFBBFFA997ADD22824A40
73957	DE6 1EF	GB	0101000020E610000063D520CCED9EFBBFA7B1BD16F4824A40
73958	DE6 1GF	GB	0101000020E6100000287CB60E0EB6FBBF56815A0C1E824A40
73959	DE6 1GY	GB	0101000020E610000003931B45D6DAFBBF54C4E9245B814A40
73960	DE6 1GZ	GB	0101000020E610000057276728EEB8FBBF1F86562767824A40
73961	DE6 1JF	GB	0101000020E6100000C7293A92CBBFFABFEBE6E26F7B844A40
73962	DE6 1JJ	GB	0101000020E61000007880272D5C16FBBFA94F72874D864A40
73963	DE6 1NB	GB	0101000020E61000004205871744A4FBBF6765FB90B7804A40
73964	DE6 1PR	GB	0101000020E61000002ACAA5F10B6FFABF376C5B94D9864A40
73965	DE6 1RA	GB	0101000020E61000004CAAB69BE0DBFBBF85950A2AAA884A40
73966	DE6 1RE	GB	0101000020E6100000213A048E045AFBBF220038F6EC894A40
73967	DE6 2AZ	GB	0101000020E6100000249BABE639E2FCBFD63BDC0E0D874A40
73968	DE6 2BN	GB	0101000020E6100000B6696CAF053DFCBFD717096D39814A40
73969	DE6 2DD	GB	0101000020E61000000BD3F71A82E3FCBFCFBD874B8E814A40
73970	DE6 2DT	GB	0101000020E6100000F0BE2A172A7FFBBF6AA33A1DC87A4A40
73971	DE6 2ED	GB	0101000020E61000001135D1E7A30CFDBF6E14596B287D4A40
73972	DE6 2FT	GB	0101000020E6100000F8E0B54B1BCEFCBF87DBA161318E4A40
73973	DE6 2HB	GB	0101000020E6100000AB3E575BB13FFDBF4A97FE25A97E4A40
73974	DE6 2HQ	GB	0101000020E610000009168733BF5AFCBFC64D0D349F814A40
73975	DE6 2JF	GB	0101000020E61000005B087250C24CFCBF069E7B0F97804A40
73976	DE6 3AE	GB	0101000020E610000045BA9F53909FFBBFF4160FEF39824A40
73977	DE6 3EA	GB	0101000020E61000007061DD7877E4F9BF2CD670917B824A40
73978	DE6 3EE	GB	0101000020E6100000899B53C900D0F9BFC79C67EC4B824A40
73979	DE6 3EZ	GB	0101000020E6100000255AF2785ABEF9BFC170AE6186824A40
73980	DE6 3JW	GB	0101000020E61000008A592F8672A2F9BF8D4127840E864A40
73981	DE6 3LD	GB	0101000020E6100000D3D85E0B7A6FF9BFB2D5E59480864A40
73982	DE6 5AA	GB	0101000020E6100000D7A02FBDFDB9FBBF17BB7D5699754A40
73983	DE6 5AD	GB	0101000020E61000002D41464085A3FBBFAE8218E8DA754A40
73984	DE6 5BY	GB	0101000020E610000053B131AF234EFCBF80289831056D4A40
73985	DE6 5DL	GB	0101000020E610000013807F4A9568FBBF0D36751E15714A40
73986	DE6 5HT	GB	0101000020E610000062A1D634EF38FCBFF65D11FC6F714A40
73987	DE6 5LB	GB	0101000020E61000004B2366F6798CFBBFDBFCBFEAC8714A40
73988	DE65 5DQ	GB	0101000020E6100000BDA772DA5332F9BF317BD976DA624A40
73989	DE65 5DX	GB	0101000020E610000059FAD005F5EDFABF88653387A46E4A40
73990	DE65 5ED	GB	0101000020E61000001F477364E5D7FABF09A69A594B6F4A40
73991	DE65 5GL	GB	0101000020E610000086E810381228FABFDBA50D87A56F4A40
73992	DE65 5LD	GB	0101000020E6100000D53F8864C831FABF8D429259BD6F4A40
73993	DE65 6AA	GB	0101000020E6100000DC9DB5DB2EB4F8BFEC8502B6836F4A40
73994	DE65 6AF	GB	0101000020E6100000F3380CE6AF90F8BF44DE72F5636F4A40
73995	DE65 6BN	GB	0101000020E6100000D5592DB0C704F9BFDC662AC4236D4A40
73996	DE65 6EA	GB	0101000020E6100000862172FA7AFEF8BFFD6662BA106D4A40
73997	DE65 6ES	GB	0101000020E6100000103CBEBD6B10F9BFCCEEC9C3426D4A40
73998	DE65 6EW	GB	0101000020E610000058AEB7CD5408F9BFF9F5436CB06C4A40
73999	DE65 6FB	GB	0101000020E6100000234DBC033CA9F8BF42791F47736A4A40
74000	DE65 6FQ	GB	0101000020E61000003A4030478FDFF8BF7E350708E66A4A40
74001	DE65 6FZ	GB	0101000020E610000082902C6002B7F8BFB56E83DA6F6B4A40
74002	DE65 6GJ	GB	0101000020E6100000D1E638B709B7F8BFB534B742586B4A40
74003	DE65 6JD	GB	0101000020E61000009B3C65355D8FF9BF71C806D2C5704A40
74004	DE65 6JJ	GB	0101000020E6100000006F8104C58FF9BF663046240A714A40
74005	DE65 6NH	GB	0101000020E610000040A54A94BDA5F9BF7AC37DE4D6704A40
74006	DE65 6NR	GB	0101000020E61000005517F032C346F9BFC537143E5B6F4A40
74007	DE7	GB	0101000020E6100000E92807B30930F5BF24EEB1F4A17B4A40
74008	DE7 3AP	GB	0101000020E610000017D86322A5D9F4BFD272A087DA724A40
74009	DE7 4DB	GB	0101000020E6100000CE1C925A28D9F4BF3276C24B707A4A40
74010	DE7 4EF	GB	0101000020E6100000941458005306F5BFC6BE64E3C17C4A40
74011	DE7 4LL	GB	0101000020E610000010255AF278DAF4BF548CF337A17C4A40
74012	DE7 5AD	GB	0101000020E610000072512D228AC9F4BFF5D89601677B4A40
74013	DE7 5LG	GB	0101000020E6100000A1BB24CE8AE8F4BF2E3D9AEAC97C4A40
74014	DE7 6DG	GB	0101000020E6100000259012BBB677F6BFED815660C87C4A40
74015	DE7 6DH	GB	0101000020E6100000382F4E7CB5A3F6BFBE2EC37FBA7D4A40
74016	DE7 6DR	GB	0101000020E61000004030478FDF9BF6BFB27F9E060C804A40
74017	DE7 6EF	GB	0101000020E610000064B2B8FFC834F6BF1157CEDE197F4A40
74018	DE7 6ER	GB	0101000020E61000006FB9FAB1493EF6BFBE11DDB3AE7F4A40
74019	DE7 6ET	GB	0101000020E6100000261DE5603641F6BF99D36531B17F4A40
74020	DE7 6FP	GB	0101000020E6100000E31B0A9FAD03F6BFBE6C3B6D8D7C4A40
74021	DE7 6GR	GB	0101000020E6100000CA6ABA9EE8BAF5BF27DBC01DA87B4A40
74022	DE7 8RD	GB	0101000020E6100000A6D1E4620C2CF5BF85268925E57E4A40
74023	DE7 9HH	GB	0101000020E6100000D593F947DF24F5BF622F14B01D7E4A40
74024	DE7 9JU	GB	0101000020E6100000412AC58EC621F5BF9D6340F67A7D4A40
74025	DE72	GB	0101000020E61000003BC8EBC1A4F8F5BF6682E15CC3744A40
74026	DE72 2AU	GB	0101000020E6100000F94A2025762DF6BF41649126DE6D4A40
74027	DE72 2BL	GB	0101000020E6100000DC7F643A747AF6BF90847D3B896C4A40
74028	DE72 3AA	GB	0101000020E6100000A8FC6B79E5FAF4BF5B07077B13734A40
74029	DE72 3AH	GB	0101000020E610000052F2EA1C03F2F4BF81E84999D4724A40
74030	DE72 3BH	GB	0101000020E6100000EF74E789E7ECF4BF8DB800344A734A40
74031	DE72 3DE	GB	0101000020E610000090F63FC05A35F5BFA7C98CB795724A40
74032	DE72 3EA	GB	0101000020E610000043572250FD03F5BF4167D2A6EA724A40
74033	DE72 3EH	GB	0101000020E61000005952EE3EC707F5BF7EC6850321734A40
74034	DE72 3HA	GB	0101000020E610000084A0A3552D29F6BF56815A0C1E744A40
74035	DE72 3HW	GB	0101000020E6100000ACE0B721C6EBF5BF4012F6ED24744A40
74036	DE72 3NF	GB	0101000020E61000002D077AA86D83F5BF62D7F6764B724A40
74037	DE72 3PS	GB	0101000020E6100000AED3484BE56DF5BFF4C473B680724A40
74038	DE72 3QD	GB	0101000020E6100000D102B4AD665DF5BFA69C2FF65E724A40
74039	DE72 3TZ	GB	0101000020E6100000C1CAA145B673F5BF40170D198F724A40
74040	DE72 6TB	GB	0101000020E6100000E67805A227E5F5BF4F5DF92CCF754A40
74041	DE73 1BQ	GB	0101000020E6100000F9BEB854A5ADF6BF5C381092056A4A40
74042	DE73 1ES	GB	0101000020E61000002AE27492ADEEF6BF892991442F694A40
74043	DE73 1FE	GB	0101000020E6100000D4B7CCE9B2D8F6BFBE2F2E5569694A40
74044	DE73 5BX	GB	0101000020E6100000F8A57EDE5424F7BFE3FDB8FDF26F4A40
74045	DE73 5SQ	GB	0101000020E6100000CB10C7BAB84DF6BFF5D72B2CB8634A40
74046	DE73 6UL	GB	0101000020E61000001492CCEA1DEEF6BF87C1FC15326F4A40
74047	DE73 7HJ	GB	0101000020E61000001B65FD66623AF8BF354415FE0C6D4A40
74048	DE73 7JG	GB	0101000020E6100000CE8DE9094BBCF7BFDC63E94317684A40
74049	DE73 7LE	GB	0101000020E6100000CB4752D2C390F7BFB2BB404981674A40
74050	DE73 8	GB	0101000020E610000000FE2955A2ECF6BF47CB811E6A694A40
74051	DE73 8GJ	GB	0101000020E6100000F56393FC88DFF6BFDEC7D11C59694A40
74052	DE74	GB	0101000020E6100000047289230F84F4BF1C0B0A83326B4A40
74053	DE74 2EN	GB	0101000020E61000007D9411178086F4BF2A55A2EC2D6B4A40
74054	DE74 2JQ	GB	0101000020E6100000070951BEA085F5BF1B4AED45B46B4A40
74055	DE74 2JW	GB	0101000020E6100000B1A71DFE9AACF5BFD767CEFA946B4A40
74056	DE74 2NN	GB	0101000020E61000008BC1C3B46F6EF5BFA41AF67B626D4A40
74057	DE74 2SA	GB	0101000020E6100000E38BF678215DF5BF2976340EF5694A40
74058	DE74 2SR	GB	0101000020E6100000E4874A236676F5BFF8A6E9B3036C4A40
74059	DE75	GB	0101000020E61000005CFFAECF9CB5F5BFB4CBB73EAC814A40
74060	DE75 7BA	GB	0101000020E610000003CDE7DCED7AF5BF53B29C84D2814A40
74061	DE75 7BY	GB	0101000020E61000008BE1EA00887BF5BFC66F0A2B15804A40
74062	DE75 7FR	GB	0101000020E6100000F69A1E149462F5BF6C5ED5592D824A40
74063	DE75 7NN	GB	0101000020E610000051D9B0A6B2E8F5BFC3D66CE525834A40
74064	DG1	GB	0101000020E6100000BABA63B14D8A0BC0199128B4AC834B40
74065	DG1 1BT	GB	0101000020E61000000CC9C9C4AD220CC0FA4509FA0B874B40
74066	DG1 1DF	GB	0101000020E610000034D93F4F03E60CC09A0986730D894B40
74067	DG1 1LT	GB	0101000020E6100000D847A7AE7CD60CC05CE333D93F894B40
74068	DG1 1NL	GB	0101000020E6100000E603029D49BB0CC0354415FE0C894B40
74069	DG1 1NT	GB	0101000020E61000001FDAC70A7EDB0CC0581AF8510D894B40
74070	DG1 1SL	GB	0101000020E6100000056D72F8A4D30CC03EEB1A2D078E4B40
74071	DG1 2EX	GB	0101000020E61000003B376DC669C80CC0EDD3F19881884B40
74072	DG1 3BQ	GB	0101000020E6100000D55C6E30D4C10CC0D66F26A60B894B40
74073	DG1 3LU	GB	0101000020E6100000B741EDB776A20CC02E71E481C8964B40
74074	DG1 3NE	GB	0101000020E6100000AF415F7AFB530CC09EB4705985954B40
74075	DG1 3RF	GB	0101000020E61000008718AF7955A70CC0E0F25833328C4B40
74076	DG1 3RN	GB	0101000020E61000001FBC7669C3A10CC059164CFC518C4B40
74077	DG1 4NF	GB	0101000020E61000003A58FFE7305F0BC0E1B721C66B804B40
74078	DG1 4NN	GB	0101000020E610000049A0C1A6CE430BC0765089EB187F4B40
74079	DG1 4RS	GB	0101000020E6100000FC7266BB42DF0BC0744012F6ED7C4B40
74080	DG10 9	GB	0101000020E6100000A4C343183F8D0BC0A374E95F92AA4B40
74081	DG10 9LU	GB	0101000020E61000005B5F24B4E55C0BC0E350BF0B5BA94B40
74082	DG10 9RS	GB	0101000020E610000008CA6DFB1E950BC0E29178793AAB4B40
74083	DG10 9SH	GB	0101000020E6100000BCE82B4833D60BC09C340D8AE6A94B40
74084	DG11 1	GB	0101000020E6100000988922A46E870BC0048F6FEF1A9C4B40
74085	DG11 1NN	GB	0101000020E6100000E9633E20D0790BC0CD94D6DF12904B40
74086	DG11 1RP	GB	0101000020E610000046425BCEA5180BC0C440D7BE809C4B40
74087	DG11 2	GB	0101000020E610000082548A1D8D230AC09432A9A10D904B40
74088	DG11 2HA	GB	0101000020E6100000A646E867EAD50AC0029D499BAA8F4B40
74089	DG11 2PY	GB	0101000020E610000040FCFCF7E0350AC054E0641BB88F4B40
74090	DG11 3DG	GB	0101000020E61000007E9065C1C41F0AC01079CBD58F874B40
74091	DG11 3EX	GB	0101000020E6100000A25D85949F9409C0C3802557B18C4B40
74092	DG12 5PB	GB	0101000020E6100000FD4B5299622E0AC098C0ADBB79804B40
74093	DG12 6AG	GB	0101000020E6100000B05758703F200AC08B53AD85597E4B40
74094	DG12 6AR	GB	0101000020E610000037161406651A0AC03BC43F6CE97D4B40
74095	DG12 6NL	GB	0101000020E6100000F8A8BF5E618109C0E08442041C7E4B40
74096	DG13 0	GB	0101000020E6100000D00CE2033BFE07C08693347F4C934B40
74097	DG13 0BG	GB	0101000020E6100000E1EB6B5D6AC407C083F755B9509B4B40
74098	DG13 0QL	GB	0101000020E610000079C9FFE4EF7E09C0537B116DC7A44B40
74099	DG14 0	GB	0101000020E61000006BD784B4C6A008C082751C3F54864B40
74100	DG14 0SY	GB	0101000020E6100000BB4560AC6FA007C06D1E87C1FC894B40
74101	DG16 5ET	GB	0101000020E6100000FC56EBC4E59808C00E4E44BFB67E4B40
74102	DG16 5EU	GB	0101000020E6100000E19BA6CF0E9808C02366F6798C7E4B40
74103	DG16 5HF	GB	0101000020E6100000D3F9F02C418608C0BF61A2410A804B40
74104	DG16 5HL	GB	0101000020E6100000A6608DB3E98808C0BF2B82FFAD824B40
74105	DG16 5JZ	GB	0101000020E61000005A643BDF4F8D08C01361C3D32B7F4B40
74106	DG2	GB	0101000020E6100000F530B43A39430DC01AA54BFF928E4B40
74107	DG2 7BE	GB	0101000020E6100000E36BCF2C09F00CC0F5A0A014AD884B40
74108	DG2 7DG	GB	0101000020E610000084B7072120DF0CC09A982EC4EA874B40
74109	DG2 7JP	GB	0101000020E6100000DC2BF3565DE70CC0AE484C50C3874B40
74110	DG2 7PD	GB	0101000020E610000049F59D5F94000DC05C21ACC612884B40
74111	DG2 7RJ	GB	0101000020E61000005455682096ED0CC0AB2688BA0F884B40
74112	DG2 8AA	GB	0101000020E610000047C9AB730CC80CC0224F92AE99744B40
74113	DG2 8AG	GB	0101000020E610000003B5183C4C1B0DC0F1F44A5986724B40
74114	DG2 8BX	GB	0101000020E6100000207EFE7BF0FA0CC0F9DC09F65F7D4B40
74115	DG2 8JE	GB	0101000020E6100000CEC47421569F0CC050C422861D764B40
74116	DG2 8JX	GB	0101000020E6100000213EB0E3BF200EC089963C9E967D4B40
74117	DG2 8PP	GB	0101000020E6100000AE0FEB8D5A210DC01D01DC2C5E884B40
74118	DG2 8RA	GB	0101000020E610000058552FBFD3A40EC0C8B260E28F844B40
74119	DG2 9AX	GB	0101000020E6100000494C50C3B7100DC05F46B1DCD2884B40
74120	DG2 9PZ	GB	0101000020E6100000E7A7380EBC1A0DC0CBF78C44688A4B40
74121	DG2 9SF	GB	0101000020E6100000A1BFD02346EF0DC01B9E5E29CB8A4B40
74122	DG2 9SL	GB	0101000020E6100000572250FD83280EC080D3BB783F884B40
74123	DG3	GB	0101000020E6100000768A558330770EC00A815CE2C89D4B40
74124	DG3 4HN	GB	0101000020E6100000AA29C93A1C5D0FC07E00529B38994B40
74125	DG3 4JB	GB	0101000020E61000003BDF4F8D97CE0FC0FD6CE4BA29994B40
74126	DG3 5	GB	0101000020E6100000D07D39B35D210EC068588CBAD69E4B40
74127	DG3 5BQ	GB	0101000020E610000095287B4B391F0EC01FF5D72B2CA84B40
74128	DG3 5EA	GB	0101000020E610000000E31934F4CF0DC0F0FCA204FD9F4B40
74129	DG4 6	GB	0101000020E610000036583849F3670FC011E2CAD93BAF4B40
74130	DG4 6LU	GB	0101000020E61000009D67EC4B36FE0FC0EAE923F087B14B40
74131	DG5 4	GB	0101000020E6100000340EF5BBB0950EC0F646AD307D774B40
74132	DG5 4LN	GB	0101000020E6100000A3586E6935840EC0D882DE1B43704B40
74133	DG6 4	GB	0101000020E6100000527E52EDD33110C0397CD289046B4B40
74134	DG6 4JX	GB	0101000020E6100000384E0AF31E3710C0963FDF162C6B4B40
74135	DG7 1BB	GB	0101000020E610000048C2BE9D44840FC0D4F02DAC1B794B40
74136	DG7 1BP	GB	0101000020E6100000581AF8510D7B0FC013F4177AC4784B40
74137	DG7 1BZ	GB	0101000020E6100000BE6A65C22F750FC0B6D8EDB3CA784B40
74138	DG7 1DZ	GB	0101000020E6100000768D96033D740FC018213CDA38784B40
74139	DG7 1FD	GB	0101000020E6100000D6355A0EF4700FC08A00A777F1784B40
74140	DG7 1HL	GB	0101000020E6100000488C9E5BE86A0FC0AE4676A565784B40
74141	DG7 1LB	GB	0101000020E61000002AFEEF880A550FC0AB75E272BC784B40
74142	DG7 1LD	GB	0101000020E610000044A67C08AA660FC0697407B133794B40
74143	DG7 1LQ	GB	0101000020E610000048E2E5E95C710FC0035DFB027A794B40
74144	DG7 1SR	GB	0101000020E610000087FE092E56740FC0C4CE143AAF734B40
74145	DG7 2HY	GB	0101000020E6100000FA0E7EE200BA10C0B6BA9C1210714B40
74146	DG7 2NB	GB	0101000020E6100000D690B8C7D24710C00C91D3D7F37B4B40
74147	DG7 2NU	GB	0101000020E61000005F79909E22870FC0E816BA12817A4B40
74148	DG7 3	GB	0101000020E6100000D2730B5D89A010C00987DEE2E18D4B40
74149	DG7 3DR	GB	0101000020E61000004D10751F80940FC0105839B4C8884B40
74150	DG7 3HD	GB	0101000020E61000000C94145800330FC0494A7A185A814B40
74151	DG7 3NU	GB	0101000020E6100000234C512E8D9F0FC01364045438824B40
74152	DG7 3QE	GB	0101000020E6100000EDB776A2247410C0CD22145B418B4B40
74153	DG7 3RL	GB	0101000020E61000005F402FDCB99010C0EA4141295A894B40
74154	DG7 3SB	GB	0101000020E6100000D50451F701A810C0BF9EAF592E894B40
74155	DG7 3TE	GB	0101000020E6100000478E740646DE10C0F27A30293E9A4B40
74156	DG7 3TQ	GB	0101000020E610000044882B67EF0C11C0F6984869369B4B40
74157	DG7 3UD	GB	0101000020E6100000D65416855DB410C0AE0E80B8AB954B40
74158	DG7 3UP	GB	0101000020E6100000F0164850FCA810C074ED0BE8858D4B40
74159	DG7 3UW	GB	0101000020E61000004FE61F7D93A610C00684D6C3978D4B40
74160	DG7 3YA	GB	0101000020E6100000613596B036E60EC0395FECBDF87C4B40
74161	DG8 0AJ	GB	0101000020E6100000DE921CB0AB6913C0E3FA777DE6784B40
74162	DG8 6LR	GB	0101000020E6100000E7C8CA2F83F111C05DA626C11B7A4B40
74163	DG8 6RN	GB	0101000020E6100000506D7022FA5512C0DCF0BBE996874B40
74164	DG8 7JF	GB	0101000020E6100000868F8829918411C05A2A6F4738734B40
74165	DG8 8DG	GB	0101000020E610000045BDE0D39CDC11C062BCE6559D5F4B40
74166	DG8 8LL	GB	0101000020E6100000A9DBD9571E7411C083E0F1ED5D594B40
74167	DG8 9AB	GB	0101000020E6100000FA60191BBAD911C06EFB1EF5D76D4B40
74168	DG8 9DZ	GB	0101000020E61000002C2B4D4A41C711C062DC0DA2B56E4B40
74169	DG8 9HY	GB	0101000020E6100000371C96067EC411C075ADBD4F556F4B40
74170	DG8 9NR	GB	0101000020E61000007FC2D9AD65F211C0B39AAE27BA684B40
74171	DG8 9SE	GB	0101000020E610000029B16B7BBB5512C084BD892139614B40
74172	DG9	GB	0101000020E6100000B9FDF2C98A9114C05517F032C36E4B40
74173	DG9 0NE	GB	0101000020E6100000F487669E5C8314C0B83CD68C0C724B40
74174	DG9 0NL	GB	0101000020E6100000F98381E7DE5314C089247A19C57C4B40
74175	DG9 8EJ	GB	0101000020E6100000ACC612D6C61814C01F69705B5B744B40
74176	DG9 8JR	GB	0101000020E61000004E0D349F737714C070067FBF986B4B40
74177	DG9 8QX	GB	0101000020E610000041F2CEA10C1514C0C13BF9F4D87C4B40
74178	DG9 9PS	GB	0101000020E6100000D2FC31AD4D9313C05839B4C876584B40
74179	DH1	GB	0101000020E61000009A43520B2513F9BFAB402D060F674B40
74180	DH1 1AN	GB	0101000020E610000081AFE8D66B7AF8BFDF3653211E654B40
74181	DH1 1DJ	GB	0101000020E610000048A8195245B1F8BF8A9466F338644B40
74182	DH1 1LA	GB	0101000020E610000001C3F2E7DB02F9BFC8EE022505644B40
74183	DH1 1NB	GB	0101000020E610000031074147AB5AF8BFFB20CB8289654B40
74184	DH1 1QZ	GB	0101000020E6100000AE49B7257201F9BF06F2ECF2AD634B40
74185	DH1 1RU	GB	0101000020E61000000327DBC01D28F9BF11C30E63D2634B40
74186	DH1 2	GB	0101000020E6100000CE52B29C84D2F8BF361E6CB1DB634B40
74187	DH1 2AH	GB	0101000020E61000008BDF14562A28F9BF25B20FB22C624B40
74188	DH1 2DQ	GB	0101000020E6100000CA52EBFD467BF8BF711B0DE02D644B40
74189	DH1 2ES	GB	0101000020E6100000DA756F4562C2F8BFB1FCF9B660634B40
74190	DH1 2EZ	GB	0101000020E6100000DC9F8B868CC7F8BFCA181F662F634B40
74191	DH1 2JP	GB	0101000020E610000059A2B3CC22D4F8BF7C80EECB99634B40
74192	DH1 2NN	GB	0101000020E61000009E40D82956CDF8BFCB694FC939614B40
74193	DH1 2NQ	GB	0101000020E6100000C4EA8F300CD8F8BF555051F52B614B40
74194	DH1 2SL	GB	0101000020E610000004ABEAE5775AF8BF31074147AB604B40
74195	DH1 2YJ	GB	0101000020E610000007978E39CF98F8BFED7DAA0A0D604B40
74196	DH1 3AN	GB	0101000020E6100000357A35406928F9BF07EE409DF2624B40
74197	DH1 3AZ	GB	0101000020E610000022FDF675E01CF9BF931ADA006C624B40
74198	DH1 3BE	GB	0101000020E6100000C687D9CBB613F9BFDD96C80567624B40
74199	DH1 3DB	GB	0101000020E6100000F645425BCE25F9BF5B24ED461F634B40
74200	DH1 3DG	GB	0101000020E610000090DD054A0A2CF9BF19E59997C3624B40
74201	DH1 3DJ	GB	0101000020E61000003082C64CA21EF9BF8194D8B5BD614B40
74202	DH1 3DY	GB	0101000020E6100000FF5A5EB9DE36F9BFB24AE9995E624B40
74203	DH1 3EE	GB	0101000020E6100000740CC85EEF3EF9BF2670EB6E9E624B40
74204	DH1 3ET	GB	0101000020E6100000522976340E35F9BF1F2C634337634B40
74205	DH1 3JP	GB	0101000020E6100000BF654E97C504F9BF65A54929E8624B40
74206	DH1 3JR	GB	0101000020E610000054AA44D95B0AF9BFA7B1BD16F4624B40
74207	DH1 3JU	GB	0101000020E610000080D767CEFA14F9BF2600FF942A634B40
74208	DH1 3LA	GB	0101000020E61000000820B58993FBF8BFDFDFA0BDFA624B40
74209	DH1 3LE	GB	0101000020E61000007BFA08FCE127F9BF6E3480B740624B40
74210	DH1 3LJ	GB	0101000020E610000062F3716DA858F9BF92054CE0D6614B40
74211	DH1 3LN	GB	0101000020E610000016FBCBEEC943F9BF5682C5E1CC614B40
74212	DH1 3LT	GB	0101000020E6100000D00CE2033B3EF9BF7E8AE3C0AB614B40
74213	DH1 3LY	GB	0101000020E6100000AF5FB01BB62DF9BFC921E2E654624B40
74214	DH1 3PU	GB	0101000020E610000095F1EF332EDCF8BFB9196EC0E7634B40
74215	DH1 3QQ	GB	0101000020E61000004D158C4AEA84F9BFA81C93C5FD614B40
74216	DH1 3RJ	GB	0101000020E61000005AB741EDB736F9BF35B39602D2624B40
74217	DH1 3RQ	GB	0101000020E610000082035ABA822DF9BFAF0AD462F0624B40
74218	DH1 3RW	GB	0101000020E61000002C4A09C1AA3AF9BFFEF15EB532634B40
74219	DH1 3TQ	GB	0101000020E610000009E1D1C6112BF9BFC2853C821B614B40
74220	DH1 4AT	GB	0101000020E610000006F1811DFF85F9BFA3E6ABE463634B40
74221	DH1 4DS	GB	0101000020E610000069C537143E5BF9BFC495B37746634B40
74222	DH1 4DY	GB	0101000020E610000067EE21E17B7FF9BFA0FA07910C634B40
74223	DH1 4EN	GB	0101000020E61000000135B56CAD6FF9BF3B527DE717634B40
74224	DH1 4JA	GB	0101000020E61000003201BF4692A0F9BF637D03931B634B40
74225	DH1 4JT	GB	0101000020E610000008228B34F18EF9BFE529ABE97A624B40
74226	DH1 4JY	GB	0101000020E6100000272F3201BF86F9BFC5CBD3B9A2624B40
74227	DH1 4LA	GB	0101000020E6100000DC114E0B5E74F9BF2593533BC3624B40
74228	DH1 4LS	GB	0101000020E610000055849B8C2A83F9BFA796ADF545644B40
74229	DH1 4LT	GB	0101000020E6100000527FBDC2827BF9BF2BFA43334F644B40
74230	DH1 4PS	GB	0101000020E6100000E36BCF2C0950F9BF713B342C46634B40
74231	DH1 4QU	GB	0101000020E61000008C14CAC2D757F9BF36CAFACDC4624B40
74232	DH1 4RB	GB	0101000020E6100000B9A640666751F9BF2B6A300DC3634B40
74233	DH1 4SU	GB	0101000020E61000007923F3C81F8CF9BF1B62BCE655634B40
74234	DH1 4TE	GB	0101000020E61000000F4757E9EE7AF9BFFCA71B28F0624B40
74235	DH1 5AE	GB	0101000020E61000005454FD4AE783F9BF526342CC25654B40
74236	DH1 5DD	GB	0101000020E610000021B07268916DF9BF7095271076664B40
74237	DH1 5NB	GB	0101000020E6100000BC02D1933229F9BFCEA96400A8664B40
74238	DH1 5NH	GB	0101000020E6100000E2ADF36F973DF9BF0A100533A6664B40
74239	DH1 5PQ	GB	0101000020E6100000BE1589096A38F9BFF110C64FE3664B40
74240	DH1 5PU	GB	0101000020E610000064AE0CAA0D0EF9BF9DD9AED007674B40
74241	DH1 5QT	GB	0101000020E6100000B34291EEE754F9BFA583F57F0E674B40
74242	DH1 5XW	GB	0101000020E6100000CA6FD1C9522BF9BFADDEE17668664B40
74243	DH1 5YN	GB	0101000020E61000008597E0D40712F9BF7520EBA9D5654B40
74244	DH1 5YR	GB	0101000020E61000005EB9DE365321F9BF401361C3D3654B40
74245	DH2	GB	0101000020E6100000D9976C3CD8A2F9BFDB8AFD65F7704B40
74246	DH2 1HY	GB	0101000020E61000003143E389208EF9BFEFAA07CC43704B40
74247	DH2 1RS	GB	0101000020E6100000574277499C95F9BF0EA0DFF76F724B40
74248	DH2 1SG	GB	0101000020E61000006AA2CF4719B1F9BF1478279F1E714B40
74249	DH2 1TW	GB	0101000020E6100000917C259012BBF9BFF67F0EF3E5714B40
74250	DH2 1XJ	GB	0101000020E61000000726378AACB5F9BFB2D826158D6F4B40
74251	DH2 2AB	GB	0101000020E610000037C64E78094EF9BF011764CBF26D4B40
74252	DH2 2DR	GB	0101000020E61000006EFAB31F2962F9BF57772CB6496D4B40
74253	DH2 2JE	GB	0101000020E61000006C425A63D049F9BF4694F6065F6E4B40
74254	DH2 2NQ	GB	0101000020E610000012DBDD03749FF9BF1074B4AA256D4B40
74255	DH2 2XE	GB	0101000020E61000000E65A88AA974F9BF6C96CB46E76C4B40
74256	DH2 3AB	GB	0101000020E61000002E7079AC1959F9BF4D49D6E1E86C4B40
74257	DH2 3NA	GB	0101000020E6100000416326512FB8F9BF959A3DD00A6E4B40
74258	DH3	GB	0101000020E6100000A20BEA5BE634F9BF0F2A711DE3724B40
74259	DH3 1AJ	GB	0101000020E61000009692E52494BEF8BFB7990AF148724B40
74260	DH3 1RS	GB	0101000020E61000005A677C5F5CAAF7BF77DCF0BBE96C4B40
74261	DH3 2DA	GB	0101000020E610000045B75ED38342F9BFFC709010E5714B40
74262	DH3 2PT	GB	0101000020E610000086C613419C07F9BF677DCA3159724B40
74263	DH3 2SZ	GB	0101000020E61000007C629D2ADFF3F8BF4147AB5AD2714B40
74264	DH3 3EE	GB	0101000020E61000009B594B01693FF9BFB6A2CD716E6D4B40
74265	DH3 4LD	GB	0101000020E61000006B813D26529AF8BFD89C8367426B4B40
74266	DH3 4LF	GB	0101000020E6100000132D793C2DBFF8BF938D075BEC6A4B40
74267	DH3 4PJ	GB	0101000020E61000008A56EE056645F8BFC59107228B6E4B40
74268	DH4	GB	0101000020E6100000B39597FC4FFEF7BF9160AA99B56C4B40
74269	DH4 4XZ	GB	0101000020E6100000C8D0B1834A9CF7BFF01472A59E6D4B40
74270	DH4 6LA	GB	0101000020E6100000E90AB6114FF6F7BF22179CC1DF6B4B40
74271	DH4 6SX	GB	0101000020E610000090BB0853940BF8BF9F77634161684B40
74272	DH4 6TA	GB	0101000020E61000004AB3791C06F3F7BFCF842689256B4B40
74273	DH4 7	GB	0101000020E6100000556D37C137CDF7BF957CEC2E50704B40
74274	DH5	GB	0101000020E6100000C8EA56CF492FF7BFFB3DB14E95694B40
74275	DH5 0DW	GB	0101000020E6100000A0C6BDF90D53F7BF5E656D533C684B40
74276	DH5 8AR	GB	0101000020E6100000B6494563ED6FF7BFB4C9E1934E6C4B40
74277	DH5 8ER	GB	0101000020E61000001C7BF65CA666F7BFBD8DCD8E546B4B40
74278	DH5 8JX	GB	0101000020E61000009929ADBF2580F7BF50C24CDBBF6A4B40
74279	DH5 8PB	GB	0101000020E6100000A471A8DF856DF7BFF0517FBDC26A4B40
74280	DH5 9JB	GB	0101000020E610000067800BB26539F7BFB5FCC0559E684B40
74281	DH5 9SB	GB	0101000020E61000007E39B35DA18FF7BFD369DD06B5694B40
74282	DH6	GB	0101000020E6100000DCA16131EA1AF8BFA16AF46A805C4B40
74283	DH6 1AE	GB	0101000020E610000031276893C3E7F7BFB2B96A9E23664B40
74284	DH6 1AU	GB	0101000020E6100000AB984A3FE1ECF7BFFBB0DEA815664B40
74285	DH6 1DB	GB	0101000020E610000016DF50F86CDDF7BF4D486B0C3A654B40
74286	DH6 1PA	GB	0101000020E61000000C3A2174D0A5F7BF7DCD72D9E8624B40
74287	DH6 2	GB	0101000020E610000027C286A7570AF7BF191EFB592C634B40
74288	DH6 2SR	GB	0101000020E6100000AED85F764F5EF6BF37E3344415664B40
74289	DH6 3	GB	0101000020E61000005649641F6499F6BFE3E13D07965F4B40
74290	DH6 3DX	GB	0101000020E6100000CA32C4B12EEEF6BFC6A354C213604B40
74291	DH6 3EN	GB	0101000020E610000081785DBF60F7F6BFEE60C43E01604B40
74292	DH6 3FB	GB	0101000020E610000057CC086F0F02F7BFE5D3635B06604B40
74293	DH6 4LX	GB	0101000020E61000009C35785F958BF7BF3B72A433305C4B40
74294	DH6 5DD	GB	0101000020E61000006D7539252066F8BFCB2C42B1155E4B40
74295	DH7	GB	0101000020E6100000E6EB32FCA7DBFABF10CF126404664B40
74296	DH7 0HR	GB	0101000020E6100000EFC8586DFEDFFBBFDA73999A04694B40
74297	DH7 6BB	GB	0101000020E610000083F92B64AE0CFABF0AF65FE7A6694B40
74298	DH7 6JY	GB	0101000020E6100000FEB7921D1B01FABF679E5C5320694B40
74299	DH7 6NJ	GB	0101000020E6100000F38DE89E750DFABF99D6A6B1BD684B40
74300	DH7 6SL	GB	0101000020E61000002D060FD3BE39FABF1EC4CE143A674B40
74301	DH7 7AA	GB	0101000020E6100000032670EB6E1EFABF425BCEA5B8644B40
74302	DH7 7HN	GB	0101000020E6100000853E58C686AEFABF53B4722F30634B40
74303	DH7 7NN	GB	0101000020E610000011A7936C75F9F9BF83DF8618AF654B40
74304	DH7 7PF	GB	0101000020E6100000501BD5E94056FABF97033DD4B6634B40
74305	DH7 7QP	GB	0101000020E6100000B3CD8DE9090BFABF53AEF02E17634B40
74306	DH7 7QS	GB	0101000020E6100000E2CAD93BA3EDF9BFB5FCC0559E624B40
74307	DH7 8DE	GB	0101000020E61000006E52D158FB7BFABF1F4DF564FE5D4B40
74308	DH7 8EX	GB	0101000020E61000003621AD31E8C4F9BF5A2BDA1CE7604B40
74309	DH7 8RU	GB	0101000020E6100000A08B868C47E9F9BFDF6DDE3829604B40
74310	DH7 8UN	GB	0101000020E6100000452BF702B342FABF49BA66F2CD604B40
74311	DH7 8UZ	GB	0101000020E6100000DD611399B900FABFF0366F9C14604B40
74312	DH7 9EX	GB	0101000020E6100000433866D99340FCBF3F8C101E6D624B40
74313	DH7 9FD	GB	0101000020E61000006876DD5B91D8FABF9B9141EE22664B40
74314	DH7 9FS	GB	0101000020E61000003AEAE8B81AD9FABF6FD74B5304664B40
74315	DH7 9PS	GB	0101000020E6100000A6EF3504C725FBBF9F58A7CAF7624B40
74316	DH7 9RH	GB	0101000020E610000066C0594A9693FABFC8B1F50CE1644B40
74317	DH7 9SF	GB	0101000020E610000035B742588DA5FABF1E1840F850664B40
74318	DH7 9TN	GB	0101000020E610000088F6B182DF86FABF2B16BF29AC664B40
74319	DH7 9YJ	GB	0101000020E6100000CAFD0E4581BEFABF20EEEA5564664B40
74320	DH8 0HX	GB	0101000020E6100000AF795567B5C0FDBF76A73B4F3C6F4B40
74321	DH8 0RB	GB	0101000020E6100000B4E55C8AAB8AFDBF5B608F89946E4B40
74322	DH8 0RF	GB	0101000020E6100000AFCC5B751D6AFDBFB212F3ACA4714B40
74323	DH8 0SX	GB	0101000020E6100000F581E49D4359FDBFA08A1BB798714B40
74324	DH8 0SY	GB	0101000020E61000009415C3D50190FDBF6420CF2EDF704B40
74325	DH8 6SZ	GB	0101000020E6100000C4D2C08F6A58FDBF7155D97745704B40
74326	DH8 7ES	GB	0101000020E61000003C16DBA4A231FDBF212235ED626C4B40
74327	DH8 8AU	GB	0101000020E610000050C3B7B06EBCFDBF8A3C49BA666C4B40
74328	DH8 8BN	GB	0101000020E61000001897AAB4C5B5FDBFDE8FDB2F9F6C4B40
74329	DH8 9NH	GB	0101000020E6100000463F1A4E999BFFBF0DFE7E315B6C4B40
74330	DH8 9NL	GB	0101000020E6100000AE2CD1596691FFBF7BDCB75A276C4B40
74331	DH9	GB	0101000020E610000036785F950B15FBBF1D7233DC806F4B40
74332	DH9 0EN	GB	0101000020E6100000640795B88EF1FABFE751F17F47704B40
74333	DH9 0RG	GB	0101000020E61000003A083A5AD592FABFAFEC82C135714B40
74334	DH9 0RY	GB	0101000020E6100000FB20CB82893FFABFA3957B8159714B40
74335	DH9 6DS	GB	0101000020E6100000B9E00CFE7EB1FABFA4C343183F6D4B40
74336	DH9 6EZ	GB	0101000020E6100000075DC2A1B7B8FABF8E210038F66C4B40
74337	DH9 7AR	GB	0101000020E61000000BEC3191D22CFBBFCB0F5CE5096E4B40
74338	DH9 7BJ	GB	0101000020E61000001633C2DB8350FBBF45B8C9A8326E4B40
74339	DH9 7TT	GB	0101000020E6100000925CFE43FAADFBBF3C66A032FE6D4B40
74340	DH9 8RA	GB	0101000020E61000000E66136058FEFABF3B72A43330704B40
74341	DH9 9PW	GB	0101000020E61000009D103AE8128EFBBFFED30D1478714B40
74342	DH9 9QP	GB	0101000020E6100000A930B610E460FBBF429605137F724B40
74343	DL1	GB	0101000020E6100000EE940ED6FFF9F6BF1B0DE02D903E4B40
74344	DL1 1EU	GB	0101000020E6100000450DA661F888F8BFEEE87FB916434B40
74345	DL1 1HA	GB	0101000020E61000004721C9ACDE21F7BF5308E41247424B40
74346	DL1 1JU	GB	0101000020E61000002922C32ADE48F8BF685BCD3AE33F4B40
74347	DL1 2AE	GB	0101000020E610000061DEE34C1376F8BFCA6ABA9EE8444B40
74348	DL1 2AT	GB	0101000020E61000009ACC785BE975F8BF857CD0B359454B40
74349	DL1 2BQ	GB	0101000020E6100000C289E8D7D68FF8BF18B0E42A16454B40
74350	DL1 2JZ	GB	0101000020E61000005F622CD32F91F8BFDE3994A12A444B40
74351	DL1 2QT	GB	0101000020E6100000670C73823639F8BFEED11BEE23454B40
74352	DL1 2XH	GB	0101000020E61000006747AAEFFC62F8BF33E202D028454B40
74353	DL1 3DX	GB	0101000020E6100000D4D17135B2ABF8BF6D91B41B7D464B40
74354	DL1 3EL	GB	0101000020E61000004B8FA67A32BFF8BF64CC5D4BC8454B40
74355	DL1 3SG	GB	0101000020E6100000C66CC9AA0837F8BFA1A17F828B454B40
74356	DL1 4AA	GB	0101000020E6100000CF68AB92C8BEF8BF19ABCDFFAB424B40
74357	DL1 4JD	GB	0101000020E61000002FC37FBA8182F8BF4E266E15C4424B40
74358	DL1 4LH	GB	0101000020E61000004EF2237EC59AF8BF3B3AAE4676414B40
74359	DL1 4YW	GB	0101000020E61000007460394206B2F8BF810706103E424B40
74360	DL1 5AG	GB	0101000020E6100000588FFB56EBC4F8BF9C1551137D424B40
74361	DL1 5DX	GB	0101000020E61000004D4D8237A4D1F8BF31EBC5504E424B40
74362	DL1 5JU	GB	0101000020E610000097E4805D4DDEF8BFC2137AFD49424B40
74363	DL1 5TH	GB	0101000020E6100000B2BAD573D2FBF8BF9BC6F65AD0414B40
74364	DL10	GB	0101000020E61000000DFE7E315B32FBBF84BA48A12C344B40
74365	DL10 1	GB	0101000020E61000000DE4D9E55B1FFABFFC523F6F2A304B40
74366	DL10 4AP	GB	0101000020E61000004D309C6B98E1FBBF569FABADD8334B40
74367	DL10 4BL	GB	0101000020E6100000AC1F9BE4477CFBBF795A7EE02A334B40
74368	DL10 4DW	GB	0101000020E6100000EE60C43E01D4FBBFDE921CB0AB334B40
74369	DL10 4HD	GB	0101000020E61000002E9276A38FB9FCBF0D1B65FD66344B40
74370	DL10 4NS	GB	0101000020E6100000B2BAD573D2BBFBBF87FD9E58A7344B40
74371	DL10 5AN	GB	0101000020E61000003D618907948DFBBFBC033C69E1344B40
74372	DL10 6DN	GB	0101000020E6100000F23FF9BB77D4F9BF96AFCBF09F324B40
74373	DL10 6JU	GB	0101000020E61000005E6919A9F754FABFE97E4E417E3C4B40
74374	DL10 6PE	GB	0101000020E61000005915E126A30AFBBFDD274701A2364B40
74375	DL10 6PQ	GB	0101000020E610000019541B9C88BEFABF813FFCFCF7384B40
74376	DL10 7	GB	0101000020E6100000834E081D7409FABF863C821B292F4B40
74377	DL10 7HA	GB	0101000020E61000008CBD175FB4C7FABF9E42AED4B3324B40
74378	DL10 7RQ	GB	0101000020E6100000DBC2F352B1F1FABF0DE198654F324B40
74379	DL11	GB	0101000020E6100000CF9F36AAD341FFBFEB3BBF2841334B40
74380	DL11 6AW	GB	0101000020E6100000EFFFE38409E3FEBFDEE4B7E864314B40
74381	DL11 6BJ	GB	0101000020E610000071546EA29666FCBF0EDAAB8F87324B40
74382	DL11 6ED	GB	0101000020E610000045F5D6C0564901C0C8ED974F563A4B40
74383	DL11 6HN	GB	0101000020E6100000D61EF64201DBFEBF5FEFFE78AF304B40
74384	DL11 6QX	GB	0101000020E6100000B82231410D1FFFBFDD7A4D0F0A324B40
74385	DL11 6SP	GB	0101000020E6100000587380608E1EFFBFB1A371A8DF314B40
74386	DL11 6SX	GB	0101000020E61000007364E597C118FFBF02D71533C2314B40
74387	DL11 6SY	GB	0101000020E610000034F3E49A0219FFBF4B3CA06CCA314B40
74388	DL11 7PT	GB	0101000020E61000003E3C4B901190FCBFD200DE02093E4B40
74389	DL11 7RT	GB	0101000020E6100000D811876C205DFBBFEFC8586DFE3F4B40
74390	DL11 7TW	GB	0101000020E61000001D75745C8DACFBBF8B8862F206404B40
74391	DL12	GB	0101000020E610000051DB865110FCFFBF6BB6F292FF4D4B40
74392	DL12 0AU	GB	0101000020E6100000020D36751E1500C09E98F562284F4B40
74393	DL12 0BQ	GB	0101000020E6100000E69315C3D50100C09F3E027FF84D4B40
74394	DL12 0JJ	GB	0101000020E6100000A032FE7DC66500C0B6DB2E34D74D4B40
74395	DL12 0LP	GB	0101000020E6100000B7D4415E0F4600C0DE76A1B94E4D4B40
74396	DL12 0QH	GB	0101000020E6100000537AA69718AB00C012A5BDC117504B40
74397	DL12 0XN	GB	0101000020E6100000D0D2156C23BE01C09F56D11F9A554B40
74398	DL12 8BG	GB	0101000020E6100000B5C01E1329CDFEBF430070ECD9454B40
74399	DL12 8BJ	GB	0101000020E6100000E1270EA0DFB7FEBFFA7C941117464B40
74400	DL12 8BP	GB	0101000020E610000099107349D5B6FEBFE412471E88464B40
74401	DL12 8DJ	GB	0101000020E6100000E34F5436ACA9FEBFE8A221E351464B40
74402	DL12 8NF	GB	0101000020E61000000CE8853B17C6FEBF82035ABA82454B40
74403	DL12 8NW	GB	0101000020E6100000575EF23FF9BBFEBF52EE3EC747454B40
74404	DL12 9EB	GB	0101000020E61000005E81E849991400C0ED832C0B264C4B40
74405	DL12 9QE	GB	0101000020E6100000CCD1E3F736BDFFBF4D486B0C3A494B40
74406	DL12 9RA	GB	0101000020E6100000B39602D2FE07FFBF096F0F4240444B40
74407	DL12 9SB	GB	0101000020E6100000D27135B22BEDFDBFE0F3C308E1414B40
74408	DL12 9TN	GB	0101000020E61000000B2AAA7EA573FEBFC214E5D2F8434B40
74409	DL12 9UP	GB	0101000020E61000009758198D7CDE00C0DB89929048474B40
74410	DL13 1AQ	GB	0101000020E6100000FF25A94C31E701C0C828CFBC1C624B40
74411	DL13 1NN	GB	0101000020E610000016FA60191B7A01C04CE0D6DD3C5D4B40
74412	DL13 1QP	GB	0101000020E6100000718FA50F5D9001C0C9E53FA4DF5E4B40
74413	DL13 2EF	GB	0101000020E610000060747973B81600C0724D81CCCE604B40
74414	DL13 2RY	GB	0101000020E61000009529E620E828FFBF5516855D145D4B40
74415	DL13 3BQ	GB	0101000020E6100000D4B837BF6162FEBF32772D211F5C4B40
74416	DL13 3ES	GB	0101000020E61000001E4E603AAD1BFEBFF3AFE595EB5D4B40
74417	DL13 3LF	GB	0101000020E6100000D1E80E62670AFEBF23861DC6A45D4B40
74418	DL13 4AR	GB	0101000020E6100000C095ECD80804FDBFD673D2FBC65F4B40
74419	DL13 5RR	GB	0101000020E6100000094FE8F52771FEBF04594FADBE504B40
74420	DL14	GB	0101000020E6100000D8800871E56CFABFCC988235CE524B40
74421	DL14 0BL	GB	0101000020E6100000CE50DCF1267FFCBFF624B03907574B40
74422	DL14 0NG	GB	0101000020E610000088BEBB95253AFCBF253B3602F1504B40
74423	DL14 0PT	GB	0101000020E6100000577A6D3656A2FCBF35ECF7C43A534B40
74424	DL14 6AL	GB	0101000020E6100000389F3A56293DFBBF1D2098A3C7514B40
74425	DL14 6BQ	GB	0101000020E61000000DE4D9E55BDFFABFA565A4DE53534B40
74426	DL14 6HJ	GB	0101000020E6100000FD6A0E10CCD1FABFF33B4D66BC534B40
74427	DL14 6UF	GB	0101000020E6100000FFCEF6E80D37FBBF4B0169FF03544B40
74428	DL14 7EJ	GB	0101000020E6100000D09B8A5418DBFABF79573D601E544B40
74429	DL14 7NR	GB	0101000020E610000071E2AB1DC5B9FABFC4B2994352554B40
74430	DL14 8PD	GB	0101000020E6100000E3DEFC868906FABF76C58CF0F6544B40
74431	DL14 8QS	GB	0101000020E6100000B7D26BB3B112FABFC55565DF15554B40
74432	DL14 8YR	GB	0101000020E610000024EF1CCA5095FABF6DE7FBA9F1524B40
74433	DL14 9QF	GB	0101000020E6100000EF37DA71C32FFCBFB9C32632734F4B40
74434	DL15	GB	0101000020E6100000FF428F183D77FBBF3065E08096564B40
74435	DL15 0SZ	GB	0101000020E61000008EE55DF580F9FABF8544DAC69F5C4B40
74436	DL15 8BN	GB	0101000020E61000001399B9C0E571FCBFF52D73BA2C5A4B40
74437	DL15 8DA	GB	0101000020E6100000B18BA2073E86FCBFE23D0796235A4B40
74438	DL15 9AD	GB	0101000020E61000001C7DCC0704BAFBBFA6643909A55B4B40
74439	DL16	GB	0101000020E61000003239B5334CADF9BF5D514A0856594B40
74440	DL16 6DN	GB	0101000020E6100000E5B9BE0F0789F9BF46ED7E15E0594B40
74441	DL16 7NW	GB	0101000020E61000008E588B4F0170FABFFA6184F068594B40
74442	DL16 7TU	GB	0101000020E6100000A65EB7088CB5F9BFB8E864A9F5584B40
74443	DL16 7XJ	GB	0101000020E61000007B4CA4349B87F9BF0E32C9C859564B40
74444	DL17 0RR	GB	0101000020E6100000DFFAB0DEA895F8BF487023658B564B40
74445	DL17 8AF	GB	0101000020E61000005FECBDF8A2BDF8BF1329CDE671584B40
74446	DL17 9AA	GB	0101000020E61000000C040132742CF8BFDD0A613596564B40
74447	DL17 9HE	GB	0101000020E61000008461C092AB18F8BF9065C1C41F594B40
74448	DL18 8RD	GB	0101000020E610000060C77F8120C0F8BF13807F4A95584B40
74449	DL1O 4DW	GB	0101000020E6100000F609A01859F2FBBF889D29745E334B40
74450	DL2 1EP	GB	0101000020E6100000E811A3E7167AF7BF21CCED5EEE414B40
74451	DL2 1TF	GB	0101000020E61000001F10E84CDA94F7BFB169A510C8454B40
74452	DL2 2JZ	GB	0101000020E6100000CA8B4CC0AF11FABFAB048BC399434B40
74453	DL2 2LY	GB	0101000020E6100000B5C189E8D756FABF703FE08101484B40
74454	DL2 2ST	GB	0101000020E610000097E5EB32FCE7F8BF6D3CD862B73D4B40
74455	DL2 3AH	GB	0101000020E6100000BAA0BE654ED7FCBF93C5FD47A64B4B40
74456	DL2 3DB	GB	0101000020E6100000F7AE415F7ABBFBBF0EA14ACD1E464B40
74457	DL2 3EJ	GB	0101000020E6100000D15D126745D4FBBF9F20B1DD3D464B40
74458	DL2 3QS	GB	0101000020E61000000D1AFA27B818FDBFB72572C119484B40
74459	DL3	GB	0101000020E6100000EBABAB02B518F9BF9CA6CF0EB8444B40
74460	DL3 0JH	GB	0101000020E61000000588821953F0F8BF3F52448655444B40
74461	DL3 6AJ	GB	0101000020E610000034F790F0BD3FF8BF6F8445459C424B40
74462	DL3 6EL	GB	0101000020E6100000F33CB83B6BF7F8BFEE93A30051444B40
74463	DL3 6ES	GB	0101000020E6100000554D10751F00F9BFE33785950A444B40
74464	DL3 6HX	GB	0101000020E6100000BE175FB4C70BF9BF0A12DBDD03444B40
74465	DL3 6NQ	GB	0101000020E610000013622EA9DAEEF8BF40FB912232444B40
74466	DL3 6PP	GB	0101000020E610000053EBFD463BEEF8BF97A949F086444B40
74467	DL3 6QJ	GB	0101000020E61000009E5DBEF561FDF8BF2829B000A6444B40
74468	DL3 6RQ	GB	0101000020E6100000492C29779FE3F8BF77BAF3C473444B40
74469	DL3 6ST	GB	0101000020E6100000E3AAB2EF8AE0F8BF037D224F92444B40
74470	DL3 6TA	GB	0101000020E6100000F71F990E9DDEF8BFD34A21904B444B40
74471	DL3 7AU	GB	0101000020E6100000D4F19881CAF8F8BFB8E7F9D346434B40
74472	DL3 7HR	GB	0101000020E61000005ABDC3EDD0F0F8BF3F6F2A5261444B40
74473	DL3 7RD	GB	0101000020E610000032E719FB920DF9BF992CEE3F32434B40
74474	DL3 7SX	GB	0101000020E6100000295E656D53FCF8BF5C001AA54B434B40
74475	DL3 7TD	GB	0101000020E6100000F06AB933130CF9BF2FC1A90F24434B40
74476	DL3 8DZ	GB	0101000020E6100000E91038126830F9BF9E0AB8E7F9414B40
74477	DL3 8EP	GB	0101000020E6100000C18C2958E3ECF8BF992EC4EA8F424B40
74478	DL3 8NL	GB	0101000020E6100000174A26A77606F9BFB35E0CE544434B40
74479	DL3 9JF	GB	0101000020E61000001157CEDE192DF9BFFCA9F1D24D444B40
74480	DL3 9LS	GB	0101000020E610000034812216312CF9BF0725CCB4FD434B40
74481	DL3 9RQ	GB	0101000020E610000045292158556FF9BF8544DAC69F444B40
74482	DL3 9UB	GB	0101000020E6100000598AE42B8114F9BF3221E692AA434B40
74483	DL4	GB	0101000020E61000002AA8A8FA954EFABFF2CD3637A6514B40
74484	DL4 1BB	GB	0101000020E61000009082A7902B75FABF4F93196F2B514B40
74485	DL4 1HF	GB	0101000020E6100000B4CA4C69FD2DFABFDCBA9BA73A504B40
74486	DL4 1LX	GB	0101000020E61000006B4606B98B30FABF1A6CEA3C2A504B40
74487	DL5	GB	0101000020E6100000D064FF3C0D98F9BF4815C5ABAC4D4B40
74488	DL5 4HX	GB	0101000020E61000008D0C7217610AF9BF5000C5C8924F4B40
74489	DL5 4TU	GB	0101000020E6100000E1B37570B0F7F8BFDF6B088ECB504B40
74490	DL5 6BF	GB	0101000020E61000002EC6C03A8E1FF9BFFF942A51F64C4B40
74491	DL5 6JY	GB	0101000020E6100000DAACFA5C6D05F9BFFE28EACC3D4C4B40
74492	DL5 6PX	GB	0101000020E61000006B0C3A217450F9BF1557957D574C4B40
74493	DL5 7AJ	GB	0101000020E6100000ECDFF599B33EF9BFC4EC65DB694F4B40
74494	DL6	GB	0101000020E61000009B030473F438F5BF172829B0002C4B40
74495	DL6 1AW	GB	0101000020E61000007D2079E750C6F6BFED9FA701832A4B40
74496	DL6 1DJ	GB	0101000020E61000009702D2FE07D8F6BFD5CF9B8A542A4B40
74497	DL6 2LB	GB	0101000020E6100000350A4966F58EF5BFA67F492A53364B40
74498	DL6 2LL	GB	0101000020E6100000C3B986191ACFF5BF00FF942A51364B40
74499	DL6 2RN	GB	0101000020E61000008813984EEBB6F6BFA306D3307C2E4B40
74500	DL6 3DH	GB	0101000020E610000066F50EB74343F4BFE5D2F88557344B40
74501	DL7 0DQ	GB	0101000020E610000018265305A352F8BF282B86AB03364B40
74502	DL7 0HQ	GB	0101000020E6100000320400C79E3DF9BFC100C28712374B40
74503	DL7 8AN	GB	0101000020E6100000E1CE85915E14F7BF253CA1D79F2A4B40
74504	DL7 8HF	GB	0101000020E6100000596E6935242EF7BF946B0A64762A4B40
74505	DL7 8HN	GB	0101000020E6100000359BC761303FF7BF03EB387EA82A4B40
74506	DL7 9HA	GB	0101000020E610000023DC64541906F7BF5EF1D4230D244B40
74507	DL7 9NJ	GB	0101000020E6100000A795422097B8F8BF33FB3C4679264B40
74508	DL7 9SN	GB	0101000020E6100000F6798CF2CCCBF8BF14E97E4E41264B40
74509	DL8	GB	0101000020E61000003FE3C28190ECF8BFD74B530438234B40
74510	DL8 1JU	GB	0101000020E610000034DAAA24B20FFBBFE4857478082B4B40
74511	DL8 1LA	GB	0101000020E61000004F93196F2B3DFABF7BDAE1AFC9284B40
74512	DL8 1QB	GB	0101000020E6100000D388997D1E63FBBF63B5F97FD5294B40
74513	DL8 1QP	GB	0101000020E6100000EFAD484C5083FBBFD28E1B7E372B4B40
74514	DL8 3AE	GB	0101000020E610000076525F9676EAFFBFE8887C9752254B40
74515	DL8 3TD	GB	0101000020E61000003FE603029D0900C06D8C9DF012224B40
74516	DL8 4	GB	0101000020E6100000029CDEC5FBB1FDBF4F95EF1989264B40
74517	DL8 4DQ	GB	0101000020E6100000F355F2B1BB80FFBF899B53C900264B40
74518	DL8 4ET	GB	0101000020E61000001711C5E40D30FFBFEEEE01BA2F294B40
74519	DL8 4LU	GB	0101000020E6100000B7EBA529029CFDBF863C821B29274B40
74520	DL8 4RS	GB	0101000020E610000030849CF7FFF1FDBF1615713AC9204B40
74521	DL8 4RT	GB	0101000020E61000002D2460747933FEBFDE0033DFC11F4B40
74522	DL8 4RU	GB	0101000020E6100000836BEEE87F39FEBF11E0F42EDE1F4B40
74523	DL8 4RY	GB	0101000020E61000006B64575A466AFEBF6878B306EF1F4B40
74524	DL8 4RZ	GB	0101000020E6100000DDB243FCC316FEBF19726C3D43204B40
74525	DL8 4TW	GB	0101000020E6100000555051F52B1DFEBFB22FD978B0214B40
74526	DL8 5GA	GB	0101000020E6100000BF2CEDD45C2EFDBFE17EC00303284B40
74527	DL8 5HN	GB	0101000020E610000099840B790437FDBF3C4B901150274B40
74528	DL8 5ND	GB	0101000020E61000007D224F92AE99FBBFE960FD9FC3264B40
74529	DL9 3EN	GB	0101000020E61000002D3F70952790FBBF90A339B2F22F4B40
74530	DL9 3JY	GB	0101000020E6100000876BB587BD90FBBF38D89B18922F4B40
74531	DL9 3LL	GB	0101000020E61000001827BEDA519CFBBFB4CBB73EAC2F4B40
74532	DL9 3RG	GB	0101000020E61000001B2B31CF4A5AFBBFC478CDAB3A2D4B40
74533	DL9 4DF	GB	0101000020E61000009204E10A2854FBBFB1524145D52F4B40
74534	DL9 4GA	GB	0101000020E6100000904B1C7920F2FABF8AC745B588304B40
74535	DL9 4RB	GB	0101000020E61000003D7FDAA84E07FBBFEC88433690304B40
74536	DN1 1PE	GB	0101000020E6100000AE6708C72C3BF2BF46CD57C9C7C24A40
74537	DN1 1TT	GB	0101000020E61000007F8978EBFC1BF2BF191F662FDBC24A40
74538	DN1 3QS	GB	0101000020E61000009BE7887C9712F2BFDCB8C5FCDCC24A40
74539	DN10 4BL	GB	0101000020E6100000DD5ED218AD23EBBF62F9F36DC1B84A40
74540	DN10 4ER	GB	0101000020E610000018B5FB5580EFEABFB2D826158DB74A40
74541	DN10 4LT	GB	0101000020E6100000310917F2086EEBBF11A96917D3B64A40
74542	DN10 4PR	GB	0101000020E61000003C11C4793881EABFD55DD90583B34A40
74543	DN10 5DF	GB	0101000020E61000000516C0948103EEBF9F724C16F7B34A40
74544	DN10 5HB	GB	0101000020E61000003F52448655BCEFBFD3F6AFAC34B34A40
74545	DN10 5HD	GB	0101000020E6100000E42EC214E5D2EEBFED82C13577B24A40
74546	DN10 6BJ	GB	0101000020E6100000FD135CACA801F0BF2CD670917BB64A40
74547	DN10 6DJ	GB	0101000020E61000004C38F4160FEFEFBFA5D7666325B84A40
74548	DN10 6JW	GB	0101000020E6100000F855B950F957F0BFB3075A8121B74A40
74549	DN10 6NU	GB	0101000020E6100000554FE61F7D53F0BFAC1A84B9DDB74A40
74550	DN10 6QU	GB	0101000020E6100000FF5D9F39EB13F0BF52465C001AB94A40
74551	DN10 6RT	GB	0101000020E610000079573D601E72F0BF3DD7F7E120B74A40
74552	DN10 6XP	GB	0101000020E6100000B073D3669C46F0BF501C40BFEFB74A40
74553	DN11 0DX	GB	0101000020E610000006BD37860020F1BF4968CBB914BD4A40
74554	DN11 0HW	GB	0101000020E6100000CB1132906797F0BFC0EC9E3C2CBC4A40
74555	DN11 0QA	GB	0101000020E6100000487023658B64F1BFA92F4B3B35BD4A40
74556	DN11 8NT	GB	0101000020E6100000F8544E7B4A0EF1BFD5E76A2BF6B54A40
74557	DN11 9	GB	0101000020E61000008544DAC69FA8F1BF6EC2BD326FB74A40
74558	DN11 9HY	GB	0101000020E610000094A0BFD023C6F1BFC443183F8DB74A40
74559	DN11 9NF	GB	0101000020E6100000B39602D2FEC7F1BF3106D671FCB64A40
74560	DN12	GB	0101000020E61000009A27D714C8ACF3BF9752978C63BE4A40
74561	DN12 1EQ	GB	0101000020E6100000259529E620E8F2BFDF162CD505BE4A40
74562	DN12 1PQ	GB	0101000020E61000002AE620E86815F3BF0070ECD973BD4A40
74563	DN12 1PY	GB	0101000020E6100000CD3D247CEF2FF3BF015130630ABC4A40
74564	DN12 3BU	GB	0101000020E610000035ED629AE99EF3BF6DE4BA29E5BD4A40
74565	DN12 3DX	GB	0101000020E61000009E08E23C9CC0F3BFDCB930D28BBE4A40
74566	DN14	GB	0101000020E61000009B215514AFB2EDBF368FC360FED44A40
74567	DN14 0DR	GB	0101000020E6100000A439B2F2CB20F1BFE8F4BC1B0BD64A40
74568	DN14 0HH	GB	0101000020E61000004F57772CB689F2BFDE019EB470D94A40
74569	DN14 0QN	GB	0101000020E61000007E39B35DA1CFF1BF8735954561D94A40
74570	DN14 0QZ	GB	0101000020E610000009A4C4AEEDADF1BFFA5FAE450BDA4A40
74571	DN14 5DD	GB	0101000020E6100000D316D7F84CF6EBBF0AA359D93EDA4A40
74572	DN14 5JG	GB	0101000020E61000004D2F3196E997EBBF1C5F7B6649DA4A40
74573	DN14 5PL	GB	0101000020E6100000B090B932A836EBBF228E75711BDD4A40
74574	DN14 6DH	GB	0101000020E61000005F0D501A6A14ECBFA7B228ECA2DA4A40
74575	DN14 6RX	GB	0101000020E610000036AB3E575BB1EBBFA6457D923BDC4A40
74576	DN14 6SH	GB	0101000020E6100000A41B615111A7EBBF1AFCFD62B6DA4A40
74577	DN14 6YH	GB	0101000020E61000001A4D2EC6C0BAEBBFEBC6BB2363DB4A40
74578	DN14 7BW	GB	0101000020E61000003D433866D913E5BF16C3D50110E54A40
74579	DN14 7ER	GB	0101000020E6100000809F71E140C8EBBF005471E316DF4A40
74580	DN14 7NA	GB	0101000020E61000009F71E1404816EABF438D429259E34A40
74581	DN14 7PX	GB	0101000020E61000005A12A0A6962DE9BF4C33DDEBA4E04A40
74582	DN14 7SE	GB	0101000020E6100000D386C3D2C08FEBBFB16F2711E1E14A40
74583	DN14 7TW	GB	0101000020E61000006380441328E2E9BF61FA5E4370DC4A40
74584	DN14 7YN	GB	0101000020E6100000410E4A9869FBE6BF371B2B31CFDA4A40
74585	DN14 8LF	GB	0101000020E61000002EE411DC48D9ECBFEA211ADD41DC4A40
74586	DN14 8LU	GB	0101000020E6100000273108AC1CDAECBF679C86A8C2DB4A40
74587	DN14 8LY	GB	0101000020E6100000FF774485EAE6ECBFB2BAD573D2DB4A40
74588	DN14 8QR	GB	0101000020E61000005FEB5223F4B3EEBF5DA9674128D94A40
74589	DN14 8RN	GB	0101000020E61000000936AE7FD7E7EEBF7427D87F9DD94A40
74590	DN14 9HX	GB	0101000020E6100000F4160FEF3970F0BF2AFF5A5EB9D84A40
74591	DN14 9PF	GB	0101000020E61000006B2C616D8C5DF0BF9758198D7CDA4A40
74592	DN15	GB	0101000020E61000004E62105839B4E0BFF3936A9F8ECF4A40
74593	DN15 6LN	GB	0101000020E61000005BEECC04C3B9E4BFF486FBC8ADCB4A40
74594	DN15 6NS	GB	0101000020E610000000C974E8F4BCE4BFA48E8EAB91CB4A40
74595	DN15 6PY	GB	0101000020E6100000EE5A423EE8D9E4BFAB06616EF7CA4A40
74596	DN15 7HT	GB	0101000020E610000029594E42E98BE5BF6EA6423C12CB4A40
74597	DN15 8QP	GB	0101000020E610000094BF7B478D09E5BF2D40DB6AD6CD4A40
74598	DN15 8QT	GB	0101000020E61000008E1F2A8D98D9E4BFE719FB928DCD4A40
74599	DN15 9ED	GB	0101000020E61000003526C45C52B5E5BF6CB1DB6795D34A40
74600	DN15 9JY	GB	0101000020E61000002254A9D9032DE5BFED0BE8853BD74A40
74601	DN15 9LX	GB	0101000020E61000002FFB75A73BCFE2BF15A930B610D64A40
74602	DN15 9NE	GB	0101000020E610000034130CE71AE6E2BF7E1B62BCE6D74A40
74603	DN15 9NF	GB	0101000020E610000079CA6ABA9EE8E2BF2DCC423BA7D74A40
74604	DN15 9NH	GB	0101000020E61000002E573F36C90FE3BFBA4DB857E6D74A40
74605	DN15 9NL	GB	0101000020E610000092EBA694D74AE3BF31B2648EE5D74A40
74606	DN15 9NN	GB	0101000020E6100000880D164ED2FCE2BF89B2B794F3D74A40
74607	DN15 9NQ	GB	0101000020E61000003813D38558FDE2BFC8EF6DFAB3D74A40
74608	DN15 9NR	GB	0101000020E6100000A852B3075A01E3BFFEBAD39D27D84A40
74609	DN15 9NT	GB	0101000020E610000048FC8A355CE4E2BF6877483140D84A40
74610	DN15 9NW	GB	0101000020E6100000F5A276BF0AF0E2BF490ED8D5E4D74A40
74611	DN15 9NX	GB	0101000020E61000004A7A185A9D1CE3BFB403AE2B66D84A40
74612	DN15 9NY	GB	0101000020E610000045292158552FE3BF1059A48977D84A40
74613	DN15 9PA	GB	0101000020E6100000AB2006BAF605E3BF9A27D714C8D84A40
74614	DN15 9PE	GB	0101000020E61000008A3A730F09DFE2BF68757286E2D84A40
74615	DN15 9PF	GB	0101000020E6100000C5573B8A73D4E2BFE3FC4D2844D84A40
74616	DN15 9PQ	GB	0101000020E6100000EC4FE27327D8E2BF01F8A75489D64A40
74617	DN15 9YA	GB	0101000020E61000002C836A831351E5BFE04BE141B3CF4A40
74618	DN16	GB	0101000020E61000000074982F2FC0E4BFDA03ADC090C74A40
74619	DN16 2	GB	0101000020E61000003E05C078068DE4BF17838769DFC84A40
74620	DN16 2HF	GB	0101000020E6100000DFA46950348FE4BFBF654E97C5C84A40
74621	DN16 2QB	GB	0101000020E6100000AFCC5B751D2AE4BFEB39E97DE3C74A40
74622	DN16 2SF	GB	0101000020E6100000357F4C6BD3D8E4BF31992A1895C84A40
74623	DN16 3LW	GB	0101000020E61000005A63D009A103E5BFA1116C5CFFC64A40
74624	DN17	GB	0101000020E610000050AA7D3A1E33E5BFD89AADBCE4CB4A40
74625	DN17 1AP	GB	0101000020E61000007C8159A14877E5BF5401F73C7FCA4A40
74626	DN17 1LY	GB	0101000020E6100000E29178793A57E5BF912C6002B7C84A40
74627	DN17 3HL	GB	0101000020E6100000A33B889D2974E7BF073F7100FDCA4A40
74628	DN17 3HT	GB	0101000020E61000000114234BE6D8E7BF9162804413CA4A40
74629	DN17 3LG	GB	0101000020E6100000348463963D09E8BFDF35E84B6FC54A40
74630	DN17 4JS	GB	0101000020E610000087E123624A24EABFB7442E3883CB4A40
74631	DN17 4LQ	GB	0101000020E6100000BC581822A7AFEABF1956F146E6CD4A40
74632	DN18 5AB	GB	0101000020E6100000BD18CA897615DDBF25E7C41EDAD74A40
74633	DN18 5HN	GB	0101000020E61000008DEDB5A0F7C6DBBF7B698A00A7D74A40
74634	DN18 5PZ	GB	0101000020E61000000CC85EEFFE78DCBF707A17EFC7D74A40
74635	DN18 5SJ	GB	0101000020E6100000764F1E166A4DDCBF18D00B772ED84A40
74636	DN19 7	GB	0101000020E6100000F5B86FB54E5CD5BF3A0664AF77D94A40
74637	DN19 7AA	GB	0101000020E61000002E1F49490F43D8BF76A911FA99D64A40
74638	DN19 7AX	GB	0101000020E6100000AA9B8BBFED09D8BFE8887C9752D74A40
74639	DN19 7BE	GB	0101000020E610000096CB46E7FC14D7BFEC6D3315E2D94A40
74640	DN19 7ET	GB	0101000020E610000095F1EF332E1CD9BF2EE411DC48D94A40
74641	DN19 7HS	GB	0101000020E6100000D462F030ED9BD5BF284696CCB1D64A40
74642	DN19 7JS	GB	0101000020E61000006EDFA3FE7A85D5BF24986A662DD94A40
74643	DN19 7RL	GB	0101000020E61000005875560BEC31D6BF03931B45D6D84A40
74644	DN2 4	GB	0101000020E6100000D6C8AEB48C54F1BFC6A354C213C64A40
74645	DN2 4BN	GB	0101000020E6100000FC8D76DCF0FBF1BF4D2EC6C03AC44A40
74646	DN2 4DS	GB	0101000020E61000005725917D90E5F1BF048E041A6CC44A40
74647	DN2 4JQ	GB	0101000020E610000013B9E00CFEBEF1BF8BC1C3B46FC44A40
74648	DN2 4TP	GB	0101000020E6100000D7BD158909EAF1BF58C7F143A5C34A40
74649	DN2 5HB	GB	0101000020E610000044DC9C4A06C0F1BF7D0569C6A2C34A40
74650	DN2 5LG	GB	0101000020E6100000906AD8EF89B5F1BF99D9E731CAC34A40
74651	DN2 5PE	GB	0101000020E6100000683EE76ED78BF1BF651A4D2EC6C44A40
74652	DN2 5SU	GB	0101000020E610000009C556D0B484F1BFC55565DF15C54A40
74653	DN2 5SZ	GB	0101000020E6100000ECF7C43A557EF1BF6B9C4D4700C54A40
74654	DN2 6HE	GB	0101000020E61000002BA226FA7C94F1BF94128255F5C24A40
74655	DN20 0AG	GB	0101000020E6100000D5CC5A0A487BE1BF3602F1BA7EC74A40
74656	DN20 0BA	GB	0101000020E61000000CE6AF90B9B2E1BF810A47904AC94A40
74657	DN20 0BU	GB	0101000020E6100000CF4BC5C6BC0EE1BF87A4164A26C94A40
74658	DN20 0BZ	GB	0101000020E61000003A02B859BCD8E0BFB16D516683C84A40
74659	DN20 0EG	GB	0101000020E6100000FEEE1D3526C4E1BF4BE7C3B304C94A40
74660	DN20 0JG	GB	0101000020E610000040868E1D5462E1BF5AF2785A7EC84A40
74661	DN20 0JY	GB	0101000020E61000003140A20914B1E1BF35D252793BC84A40
74662	DN20 0LR	GB	0101000020E61000001024EF1CCA50DDBFFF03AC55BBCA4A40
74663	DN20 0LS	GB	0101000020E6100000CEC29E76F86BDDBF22A7AFE76BCA4A40
74664	DN20 0PB	GB	0101000020E6100000E202D0285DFADBBF09C556D0B4CA4A40
74665	DN20 0QP	GB	0101000020E61000004A5D328E91ECDEBF1878EE3D5CD04A40
74666	DN20 8AT	GB	0101000020E6100000A1664815C5ABDFBF397CD28904C74A40
74667	DN20 8HH	GB	0101000020E61000007FC2D9AD6532DFBF29CB10C7BAC64A40
74668	DN20 8HX	GB	0101000020E610000027A435069D10DFBF75C7629B54C64A40
74669	DN20 8LW	GB	0101000020E610000026E0D7481284DFBFDA3A38D89BC64A40
74670	DN20 8NW	GB	0101000020E61000000AA0185932C7DFBFF9D85DA0A4C64A40
74671	DN20 8QY	GB	0101000020E6100000A4FACE2F4AD0DDBFC4CDA96400C84A40
74672	DN20 8RB	GB	0101000020E610000095F430B43A39DEBF5D16139B8FC74A40
74673	DN20 8RD	GB	0101000020E61000000C2252D32EA6DDBFE50D30F31DC84A40
74674	DN20 8RE	GB	0101000020E61000005308E412471EDEBF3B56293DD3C74A40
74675	DN20 8RF	GB	0101000020E6100000F75B3B511212DEBFE4141DC9E5C74A40
74676	DN20 8RG	GB	0101000020E6100000C2A6CEA3E2FFDDBF153B1A87FAC74A40
74677	DN20 8RH	GB	0101000020E6100000D4BB783F6EBFDDBF25CFF57D38C84A40
74678	DN20 8RL	GB	0101000020E6100000A20DC0064488DDBFF661BD512BC84A40
74679	DN20 8RP	GB	0101000020E610000040A374E95F92DDBFD00B772E8CC84A40
74680	DN20 8RR	GB	0101000020E610000022A5D93C0E83DDBFA9DA6E826FC84A40
74681	DN20 8RS	GB	0101000020E610000096B1A19BFD81DDBF38F8C264AAC84A40
74682	DN20 8RT	GB	0101000020E61000004CFC51D4997BDDBF76C075C58CC84A40
74683	DN20 8RW	GB	0101000020E6100000874ECFBBB1A0DDBFFBCC599F72C84A40
74684	DN20 8RX	GB	0101000020E6100000C6F8307BD976DDBF5299620E82C84A40
74685	DN20 8RY	GB	0101000020E610000060CAC0012D5DDDBF721AA20A7FC84A40
74686	DN20 8RZ	GB	0101000020E6100000DEAAEB504D49DDBF9F02603C83C84A40
74687	DN20 8SA	GB	0101000020E6100000DEACC1FBAA5CDDBF04029D499BC84A40
74688	DN20 8SB	GB	0101000020E61000001C0934D8D479DDBF1F85EB51B8C84A40
74689	DN20 8SD	GB	0101000020E61000006823D74D29AFDDBF817A336ABEC84A40
74690	DN20 8SE	GB	0101000020E61000007DCF488446B0DDBFB0726891EDC84A40
74691	DN20 8SF	GB	0101000020E6100000786000E14389DDBF793E03EACDC84A40
74692	DN20 8SG	GB	0101000020E61000005C01857AFA08DEBFA5660FB402C94A40
74693	DN20 8SH	GB	0101000020E6100000BC5CC47762D6DDBFB891B245D2C84A40
74694	DN20 8SJ	GB	0101000020E6100000C68A1A4CC3F0DDBFAF230ED940C84A40
74695	DN20 8SL	GB	0101000020E61000009DF4BEF1B567DDBFC51D6FF25BC84A40
74696	DN20 8SN	GB	0101000020E6100000064CE0D6DD3CDDBF207A522635C84A40
74697	DN20 8SP	GB	0101000020E6100000B77C24253D0CDDBFF5DBD78173C84A40
74698	DN20 8SQ	GB	0101000020E6100000DBE044F46BEBDDBF20CF2EDFFAC84A40
74699	DN20 8SR	GB	0101000020E61000008A3A730F09DFDCBF452C62D861C84A40
74700	DN20 8SS	GB	0101000020E6100000FAB836548CF3DCBF10CD3CB9A6C84A40
74701	DN20 8ST	GB	0101000020E6100000043752B648DADBBFA20914B188C94A40
74702	DN20 8SU	GB	0101000020E61000004165FCFB8C0BDDBF3E3DB665C0C74A40
74703	DN20 8SW	GB	0101000020E6100000C020E9D32AFADCBFAAB9DC60A8C74A40
74704	DN20 8SX	GB	0101000020E61000003A77BB5E9A22DDBFAE9FFEB3E6C74A40
74705	DN20 8SY	GB	0101000020E6100000611A868F8829DDBF1363997E89C84A40
74706	DN20 8SZ	GB	0101000020E6100000126A865451BCDDBF6DFE5F75E4C84A40
74707	DN20 8TB	GB	0101000020E6100000A56B26DF6C73DDBFD6AA5D13D2C84A40
74708	DN20 8TD	GB	0101000020E61000003C11C4793881DDBF64CF9ECBD4C84A40
74709	DN20 8TE	GB	0101000020E610000008B0C8AF1F62DDBFDFFDF15EB5C84A40
74710	DN20 8TH	GB	0101000020E61000004F948444DAC6DDBFC1012D5DC1C84A40
74711	DN20 8TQ	GB	0101000020E61000001215AA9B8BBFDDBF198EE733A0C84A40
74712	DN20 8UN	GB	0101000020E6100000F38DE89E750DE0BFC367EBE060C74A40
74713	DN20 9AE	GB	0101000020E61000008F8AFF3BA242E1BF2FFCE07CEAC44A40
74714	DN20 9DX	GB	0101000020E6100000FF3F4E98301AE1BFEE08A7052FC24A40
74715	DN20 9EH	GB	0101000020E6100000AD342905DDDEE0BF27158DB5BFC14A40
74716	DN20 9EP	GB	0101000020E6100000D07D39B35D21E1BFEBC891CEC0C44A40
74717	DN20 9FD	GB	0101000020E6100000FE7E315BB2AAE0BF2194F77134C14A40
74718	DN20 9HF	GB	0101000020E6100000A4FB3905F9D9DCBF9E077767EDC64A40
74719	DN20 9HG	GB	0101000020E610000099B7EA3A5453DCBFF910548D5EC74A40
74720	DN20 9HH	GB	0101000020E61000005070B1A206D3DBBF514D49D6E1C64A40
74721	DN20 9HJ	GB	0101000020E6100000656EBE11DDB3DBBF02B9C49107C84A40
74722	DN20 9HL	GB	0101000020E61000004AEEB089CC5CDBBFD09CF529C7C64A40
74723	DN20 9HN	GB	0101000020E610000079CA6ABA9EE8DBBF36E84B6F7FC64A40
74724	DN20 9LX	GB	0101000020E61000008D98D9E7314AE1BF85CE6BEC12C54A40
74725	DN20 9PT	GB	0101000020E610000080D8D2A3A99EE0BF10CB660E49C14A40
74726	DN20 9PW	GB	0101000020E61000004C1B0E4B03BFE0BF54E1CFF066C14A40
74727	DN20 9QG	GB	0101000020E6100000BD8BF7E3F6CBE0BF9B70AFCC5BC14A40
74728	DN21	GB	0101000020E6100000A56950340F60E9BFB2135E8253B54A40
74729	DN21 1AB	GB	0101000020E6100000F96A47718EBAE8BFBDFC4E9319B34A40
74730	DN21 1AH	GB	0101000020E6100000F4FC69A33A9DE8BFDC2BF3565DB14A40
74731	DN21 1AN	GB	0101000020E61000007D073F71007DE8BFCBD93BA3ADB04A40
74732	DN21 1GB	GB	0101000020E6100000774A07EBFF9CE7BF59C16F438CB54A40
74733	DN21 1XH	GB	0101000020E6100000931D1B81785DE8BF29931ADA00B24A40
74734	DN21 4BD	GB	0101000020E6100000DF8AC40435FCE2BF81CD397826BE4A40
74735	DN21 4ET	GB	0101000020E610000068B0A9F3A8F8E2BFFAD346753ABA4A40
74736	DN21 4GA	GB	0101000020E6100000392A37514BF3E2BFFDDD3B6A4CBC4A40
74737	DN21 4NP	GB	0101000020E61000000C93A98251C9E2BFD65240DAFFBC4A40
74738	DN21 4RH	GB	0101000020E610000090A1630795B8E0BFE7FD7F9C30B94A40
74739	DN21 4ST	GB	0101000020E610000088F546AD307DE0BFEC4FE27327BA4A40
74740	DN21 5HP	GB	0101000020E6100000DF1797AAB445E8BFF452B131AFAF4A40
74741	DN21 5JZ	GB	0101000020E61000005532005471E3E5BFA35C1ABFF0AC4A40
74742	DN21 5UA	GB	0101000020E6100000CEC64ACCB312E2BF61C614AC71B24A40
74743	DN21 5UJ	GB	0101000020E61000009A0B5C1E6B46E3BF8A9466F338B44A40
74744	DN22	GB	0101000020E6100000A663CE33F6A5E9BF323D618907A64A40
74745	DN22 0RD	GB	0101000020E6100000E8F692C6681DECBF662FDB4E5BA54A40
74746	DN22 6SB	GB	0101000020E61000007E1B62BCE6D5EDBF7DCF488446AA4A40
74747	DN22 6TN	GB	0101000020E610000052D158FB3BDBEDBFE63BF88903AA4A40
74748	DN22 7DE	GB	0101000020E6100000E124CD1FD35AEEBFC09481035AA84A40
74749	DN22 7LD	GB	0101000020E610000029D027F22469EEBF27A089B0E1A94A40
74750	DN22 7NN	GB	0101000020E6100000D26F5F07CE99EEBFCFDC43C2F7A84A40
74751	DN22 7UQ	GB	0101000020E61000004221020EA14AEEBFD927806264A74A40
74752	DN22 8AP	GB	0101000020E61000003EEB1A2D07FAEEBFE35295B6B8A24A40
74753	DN22 8HT	GB	0101000020E61000005DFDD8243F62F0BF5DC0CB0C1BA94A40
74754	DN22 8ND	GB	0101000020E61000002D2460747933F0BF22DFA5D425B14A40
74755	DN22 8NW	GB	0101000020E61000001BBAD91F2837F0BFC7116BF129B04A40
74756	DN22 8RB	GB	0101000020E6100000F46A80D250A3EFBF938B31B08EAF4A40
74757	DN22 9AJ	GB	0101000020E6100000FA47DFA469D0ECBFC4E8B985AEB04A40
74758	DN22 9DH	GB	0101000020E61000006B494739984DEBBFF0A485CB2AAE4A40
74759	DN22 9NN	GB	0101000020E61000000F971C774A07EDBFAC8E1CE90CAC4A40
74760	DN3	GB	0101000020E6100000A8E15B58371EF1BF0A2B155454C94A40
74761	DN3 1AA	GB	0101000020E6100000CF4C309C6B18F1BF700B96EA02CA4A40
74762	DN3 1HW	GB	0101000020E61000008BDD3EABCC54F1BF5303CDE7DCC74A40
74763	DN3 1JP	GB	0101000020E61000006A696E85B01AF1BF8ECC237F30C84A40
74764	DN3 1JW	GB	0101000020E61000005F605628D2FDF0BF42942F6821C94A40
74765	DN3 1LN	GB	0101000020E6100000DCD440F339F7F0BF0DE4D9E55BC94A40
74766	DN3 1PR	GB	0101000020E6100000B8567BD80B05F1BF6A4E5E6402C84A40
74767	DN3 1SJ	GB	0101000020E61000008F368E588B0FF1BF9AB51490F6C94A40
74768	DN3 2NT	GB	0101000020E61000001AFCFD62B624F1BF268BFB8F4CC74A40
74769	DN3 2QG	GB	0101000020E6100000535A7F4B003EF1BF08043A9336C74A40
74770	DN3 2RG	GB	0101000020E61000005ED905836BEEF0BFEF39B01C21C74A40
74771	DN3 3AA	GB	0101000020E610000090D8EE1EA0FBF0BFDCB930D28BC44A40
74772	DN3 3AW	GB	0101000020E6100000B4571F0F7DF7F0BFB5705985CDC44A40
74773	DN3 3PS	GB	0101000020E6100000ECF99AE5B291F0BFA7CD380D51C14A40
74774	DN31 1EP	GB	0101000020E6100000F0A2AF20CD58B4BFC7478B3386C94A40
74775	DN31 1LY	GB	0101000020E6100000BF823463D174B6BF016E162F16C84A40
74776	DN31 1QD	GB	0101000020E6100000F46E2C280CCAB4BFEA78CC4065C84A40
74777	DN31 2SR	GB	0101000020E610000006BAF605F4C2BDBF0EA320787CCB4A40
74778	DN31 3PB	GB	0101000020E6100000B403AE2B6684B3BFDB31755776C94A40
74779	DN32 0DQ	GB	0101000020E61000004EB7EC10FFB0B5BFBA85AE44A0C64A40
74780	DN32 0JR	GB	0101000020E6100000DCB8C5FCDCD0B4BF761BD47E6BC74A40
74781	DN32 0NQ	GB	0101000020E6100000A647533D997FB4BF5E2D776682C74A40
74782	DN32 0PD	GB	0101000020E6100000FB90B75CFDD8B4BF3E3DB665C0C74A40
74783	DN32 5GR	GB	0101000020E6100000D40E7F4DD6A8AFBFD28DB0A888C94A40
74784	DN32 8PT	GB	0101000020E61000004628B682A625AEBF52F01472A5C64A40
74785	DN32 9DR	GB	0101000020E610000025ADF886C267B3BF10CD3CB9A6C84A40
74786	DN32 9DW	GB	0101000020E6100000637AC2120F28B3BF0E315EF3AAC84A40
74787	DN33 2EF	GB	0101000020E61000007AE40F069E7BB7BF80EECB99EDC44A40
74788	DN33 2HU	GB	0101000020E61000004E64E60297C7B6BF59BE2EC37FC44A40
74789	DN33 2LX	GB	0101000020E6100000CAFCA36FD234B8BF5704FF5BC9C44A40
74790	DN33 3	GB	0101000020E610000056D7A19A92ACB7BFC5A9D6C22CC44A40
74791	DN33 3DX	GB	0101000020E6100000DC662AC423F1B6BFA9A5B915C2C44A40
74792	DN33 3EA	GB	0101000020E61000008FAB915D6919B9BFDAC87553CAC34A40
74793	DN33 3ED	GB	0101000020E6100000EF92382BA226BABF8E93C2BCC7C34A40
74794	DN33 3NG	GB	0101000020E6100000884CF910548DB6BFBA85AE44A0C44A40
74795	DN33 3PE	GB	0101000020E61000000B410E4A9869BBBF653909A52FC44A40
74796	DN34	GB	0101000020E610000096404AECDADEA6BF76C075C58CC84A40
74797	DN34 4EH	GB	0101000020E6100000BB5F05F86EF3BABFDD28B2D650C84A40
74798	DN34 4QP	GB	0101000020E61000002920ED7F80B5BABFB328ECA2E8C74A40
74799	DN34 4UG	GB	0101000020E61000002D95B7239C16B8BF46D26EF431C94A40
74800	DN34 5	GB	0101000020E61000001DCBBBEA01F3C0BF1155F833BCC74A40
74801	DN34 5BH	GB	0101000020E6100000268A90BA9D7DB9BF38F8C264AAC64A40
74802	DN34 5LU	GB	0101000020E61000004D4C1762F547B8BF6E8AC745B5C64A40
74803	DN34 5LW	GB	0101000020E610000044FCC3961E4DBDBF7F6ABC7493C64A40
74804	DN34 5QN	GB	0101000020E61000002FA4C343183FC1BFACE3F8A1D2C64A40
74805	DN35	GB	0101000020E6100000C0EAC891CEC0A0BF2254A9D903C74A40
74806	DN35 0AL	GB	0101000020E61000008C65FA25E2AD93BFE5805D4D9EC64A40
74807	DN35 0DQ	GB	0101000020E61000003C11C479388199BF622D3E05C0C64A40
74808	DN35 0HP	GB	0101000020E61000005CCB64389ECF90BFFD885FB186C54A40
74809	DN35 7JL	GB	0101000020E610000033DC80CF0F23A4BFA4C519C39CC84A40
74810	DN35 7QU	GB	0101000020E61000001AC39CA04D0EA7BF59A7CAF78CC84A40
74811	DN35 7SX	GB	0101000020E610000024473A03232FABBF029B73F04CC84A40
74812	DN35 8NW	GB	0101000020E61000003430F2B2261698BF643C4A253CC74A40
74813	DN35 8RJ	GB	0101000020E6100000A8E15B5837DE8D3F410C74ED0BC84A40
74814	DN35 9AP	GB	0101000020E6100000A45181936DE0A6BFFF243E7782C74A40
74815	DN35 9DD	GB	0101000020E610000082AD122C0E67A6BF552FBFD364C64A40
74816	DN35 9EN	GB	0101000020E6100000672AC423F1F2A4BFAA99B51490C64A40
74817	DN35 9JR	GB	0101000020E61000003752B648DA8D9EBF77A1B94E23C74A40
74818	DN35 9QR	GB	0101000020E6100000266F8099EFE0A7BF29E78BBD17C54A40
74819	DN35 9SJ	GB	0101000020E61000008B71FE261422A0BF821E6ADB30C84A40
74820	DN36 4AH	GB	0101000020E6100000D828EB3713D3A5BFE0BC38F1D5C44A40
74821	DN36 4HQ	GB	0101000020E61000008DB454DE8E708ABF25CFF57D38C44A40
74822	DN36 4PA	GB	0101000020E61000004FAC53E57B46B2BF0E4E44BFB6C24A40
74823	DN36 4QQ	GB	0101000020E61000008881AE7D01BDB0BF10CCD1E3F7C24A40
74824	DN36 4TU	GB	0101000020E6100000A3C85A43A9BD98BF07B29E5A7DC34A40
74825	DN36 4XR	GB	0101000020E61000007AC2120F289B92BF89EB18575CC44A40
74826	DN36 4YA	GB	0101000020E61000007497C4591135B1BF18080264E8C24A40
74827	DN36 5	GB	0101000020E61000000EA2B5A2CD71B2BF80608E1EBFBB4A40
74828	DN36 5AB	GB	0101000020E6100000CAFACDC47421AEBFE605D847A7C04A40
74829	DN36 5LW	GB	0101000020E61000004F401361C3D39BBF9F1C058882BF4A40
74830	DN36 5PT	GB	0101000020E6100000D1048A58C4B0B3BFD331E719FBBC4A40
74831	DN36 5QG	GB	0101000020E6100000FDF7E0B54B1BAEBFF9F719170EBC4A40
74832	DN36 5QR	GB	0101000020E61000001E335019FF3EABBF0A6AF816D6BB4A40
74833	DN37	GB	0101000020E6100000C5A9D6C22CB4D6BF31B610E4A0D24A40
74834	DN37 0BZ	GB	0101000020E61000007A34D593F947BBBFC712D6C6D8C14A40
74835	DN37 0JY	GB	0101000020E6100000EE3D5C72DC29B5BF44520B2593C34A40
74836	DN37 0NB	GB	0101000020E6100000FF59F3E32F2DBABF8FE21C7574C24A40
74837	DN37 0UL	GB	0101000020E610000052B5DD04DF34B9BF96438B6CE7C14A40
74838	DN37 0UX	GB	0101000020E6100000C45BE7DF2EFBBDBF11548D5E0DC24A40
74839	DN37 7DF	GB	0101000020E61000009758198D7C5EC5BF0551F70148C54A40
74840	DN37 7RY	GB	0101000020E6100000B073D3669C86C4BF8789062978CA4A40
74841	DN37 8NX	GB	0101000020E6100000A8195245F12ACBBF2C4A09C1AAC64A40
74842	DN37 9NH	GB	0101000020E6100000D5E8D500A5A1C0BFADA6EB89AEC94A40
74843	DN37 9PG	GB	0101000020E6100000419E5DBEF561C1BF36E675C421C94A40
74844	DN38	GB	0101000020E6100000A79201A08A1BDABF31444E5FCFC94A40
74845	DN38 6DG	GB	0101000020E61000007CB8E4B8533ADABF2BC24D4695C94A40
74846	DN38 6DL	GB	0101000020E610000028F4FA93F8DCDABFC2C3B46FEEC94A40
74847	DN38 6DN	GB	0101000020E61000005FEB5223F433DBBFAB59677C5FCA4A40
74848	DN38 6DW	GB	0101000020E61000004C55DAE21A9FDABF300E2E1D73CA4A40
74849	DN38 6HJ	GB	0101000020E61000006DC9AA083719DABF5DE15D2EE2C94A40
74850	DN39 6BE	GB	0101000020E61000000341800C1D3BD3BF810A47904ACF4A40
74851	DN39 6XF	GB	0101000020E6100000100874266DAAD4BF7AA9D898D7D34A40
74852	DN4	GB	0101000020E61000004703780B2468F2BFD6C743DFDDC04A40
74853	DN4 0DN	GB	0101000020E6100000F8FA5A971A61F2BF4450357A35C24A40
74854	DN4 0JB	GB	0101000020E6100000ADF6B0170A98F2BF37E3344415C24A40
74855	DN4 0PU	GB	0101000020E6100000746039420672F2BF03CC7C073FC14A40
74856	DN4 0SU	GB	0101000020E6100000F110C64FE39EF2BFFCA886FD9EC04A40
74857	DN4 5DA	GB	0101000020E61000003ACFD8976CFCF1BFD6389B8E00C24A40
74858	DN4 5EE	GB	0101000020E610000038876BB587BDF1BF390A100533C24A40
74859	DN4 5RA	GB	0101000020E6100000F2D3B837BF21F2BF988A8D791DC34A40
74860	DN4 7JP	GB	0101000020E6100000DA03ADC09055F1BF55F99E9108C14A40
74861	DN4 7RH	GB	0101000020E6100000A8E507AEF284F1BFA4349BC761C04A40
74862	DN4 8HD	GB	0101000020E610000068AED3484B65F2BF7442E8A04BC04A40
74863	DN4 8PP	GB	0101000020E6100000D7A02FBDFD79F2BFBDC458A65FC04A40
74864	DN4 8QE	GB	0101000020E610000028F04E3E3D76F2BF16DD7A4D0FC04A40
74865	DN4 8QG	GB	0101000020E61000002EFF21FDF675F2BF54E0641BB8BF4A40
74866	DN4 9JH	GB	0101000020E6100000501DAB949EA9F2BF52431B800DC04A40
74867	DN4 9LN	GB	0101000020E6100000745DF8C1F9D4F2BF6C5A290472BF4A40
74868	DN40 1LQ	GB	0101000020E6100000B2BE81C98D22CBBF7D5A457F68CE4A40
74869	DN40 1RJ	GB	0101000020E6100000664F029B73F0CABFBDA60705A5CE4A40
74870	DN40 2LF	GB	0101000020E61000007FDC7EF964C5CABF88687407B1CF4A40
74871	DN40 3AB	GB	0101000020E6100000C91EA1664815D1BF3E95D39E92CD4A40
74872	DN40 3AE	GB	0101000020E6100000611BF1643733D1BF8F52094FE8CD4A40
74873	DN41 7RG	GB	0101000020E61000000C21E7FD7F9CC6BF984D8061F9CB4A40
74874	DN41 8AS	GB	0101000020E61000003599F1B6D26BC7BF7218CC5F21CB4A40
74875	DN43	GB	0101000020E610000091813CBB7C2BF9BFCE3637A627BE4A40
74876	DN5	GB	0101000020E610000050E449D23593F2BF990E9D9E77C34A40
74877	DN5 0PH	GB	0101000020E610000089B3226AA24FF2BF26C632FD12C74A40
74878	DN5 7AB	GB	0101000020E610000096AFCBF09FAEF2BF83DDB06D51C24A40
74879	DN5 7AT	GB	0101000020E610000029CC7B9C6982F3BF897AC1A739C54A40
74880	DN5 7JD	GB	0101000020E6100000CCED5EEE9363F4BFCB660E492DC24A40
74881	DN5 7JF	GB	0101000020E6100000B98E71C5C551F4BF9ECF807A33C24A40
74882	DN5 7PD	GB	0101000020E61000005340DAFF002BF3BF130EBDC5C3C14A40
74883	DN5 7RJ	GB	0101000020E6100000471FF301810EF3BF77BD344580C14A40
74884	DN5 7UF	GB	0101000020E61000006BB75D68AE13F3BF55F65D11FCC54A40
74885	DN5 7XJ	GB	0101000020E61000009701672959CEF3BF1975ADBD4FC74A40
74886	DN5 8BP	GB	0101000020E61000002AA8A8FA958EF2BF76C58CF0F6C24A40
74887	DN5 8DX	GB	0101000020E61000002219726C3D83F2BF14596B28B5C34A40
74888	DN5 8HJ	GB	0101000020E6100000D7C3978922A4F2BF033E3F8C10C44A40
74889	DN5 8JN	GB	0101000020E61000004512BD8C62B9F2BFEA79371614C44A40
74890	DN6 7AJ	GB	0101000020E610000093E1783E03EAF2BFAE2CD15966C94A40
74891	DN6 7QB	GB	0101000020E6100000DD611399B900F3BFA06CCA15DEC74A40
74892	DN6 8EJ	GB	0101000020E6100000CB2F833122D1F2BF0938842A35CB4A40
74893	DN6 9	GB	0101000020E6100000FF942A51F6D6F2BF2995F0845ECF4A40
74894	DN6 9DL	GB	0101000020E610000059130B7C45F7F2BFB5705985CDD04A40
74895	DN6 9GA	GB	0101000020E6100000FE0FB056ED1AF3BF543A58FFE7D44A40
74896	DN6 9JF	GB	0101000020E6100000D253E41071B3F2BFD31742CEFBCB4A40
74897	DN6 9JL	GB	0101000020E61000006BB6F292FF09F3BF1BF5108DEECC4A40
74898	DN7 4BS	GB	0101000020E61000005308E412475EF0BFDF3312A111C84A40
74899	DN7 4EE	GB	0101000020E61000008A3BDEE4B768F0BFC93D5DDDB1CA4A40
74900	DN7 4EQ	GB	0101000020E6100000973AC8EBC164F0BF2F8672A25DCB4A40
74901	DN7 4HG	GB	0101000020E61000005C01857AFA48F0BFC85C19541BCA4A40
74902	DN7 4QB	GB	0101000020E610000009DE9046058EF0BFD656EC2FBBC74A40
74903	DN7 5BX	GB	0101000020E610000096404AECDA1EF0BF062FFA0AD2CC4A40
74904	DN7 5HD	GB	0101000020E610000055682096CD5CF0BF4391EEE714CC4A40
74905	DN7 5JX	GB	0101000020E61000001FF296AB1F1BF0BFAD4CF8A57ECE4A40
74906	DN7 5LL	GB	0101000020E6100000BA4DB857E62DF0BF64213A048ECE4A40
74907	DN7 5LS	GB	0101000020E6100000027FF8F9EF41F0BF97C79A9141CE4A40
74908	DN7 5TP	GB	0101000020E610000030849CF7FF31F0BFB8567BD80BCD4A40
74909	DN7 6JE	GB	0101000020E61000002C9CA4F9631AF0BF909E228788C94A40
74910	DN7 6JX	GB	0101000020E6100000DF15C1FF5632F0BFFDC1C073EFC94A40
74911	DN7 6PQ	GB	0101000020E6100000D36C1E87C17CEFBF5B0C1EA67DC94A40
74912	DN7 6QE	GB	0101000020E61000007BD80B056C87EFBF643F8BA548CA4A40
74913	DN7 6QQ	GB	0101000020E610000057410C74ED0BF0BF3F1EFAEE56CA4A40
74914	DN7 6QR	GB	0101000020E610000054ABAFAE0A14F0BFE945ED7E15CA4A40
74915	DN8 4HZ	GB	0101000020E6100000C91EA1664815EFBF44882B67EFCE4A40
74916	DN8 5QN	GB	0101000020E610000032AB77B81D9AEEBFE57E87A240CD4A40
74917	DN8 5QP	GB	0101000020E61000006ABE4A3E7697EEBFE2E995B20CCD4A40
74918	DN9	GB	0101000020E61000003C33C170AE61EFBF7C0E2C47C8BE4A40
74919	DN9 1JJ	GB	0101000020E61000001D8F19A88CFFE9BF7590D78349C34A40
74920	DN9 1JT	GB	0101000020E61000006490BB085394EABF1A8BA6B393C34A40
74921	DN9 1NS	GB	0101000020E61000008BDF14562A28EABFAF22A30392C64A40
74922	DN9 1PT	GB	0101000020E61000004580D3BB783FEABF85285FD042C64A40
74923	DN9 1QN	GB	0101000020E6100000CF488446B0F1E9BF15C9570229C74A40
74924	DN9 2AL	GB	0101000020E6100000DA03ADC090D5EBBF9833DB15FABE4A40
74925	DN9 2ER	GB	0101000020E61000002FFCE07CEAD8ECBF6688635DDCBC4A40
74926	DN9 2JQ	GB	0101000020E6100000FF08C38025D7EABFB39AAE27BABE4A40
74927	DN9 3AF	GB	0101000020E6100000C2DB831090AFEFBF98F90E7EE2BE4A40
74928	DN9 3RA	GB	0101000020E6100000986BD102B4ADEFBF4567994528BE4A40
74929	DT1 1QX	GB	0101000020E6100000797764AC367F03C06116DA39CD5A4940
74930	DT1 1SE	GB	0101000020E61000003599F1B6D28B03C06A6798DA525B4940
74931	DT1 1XY	GB	0101000020E6100000E15F048D998403C09D137B681F5B4940
74932	DT1 2AE	GB	0101000020E61000008D5F7825C95303C018EC866D8B5A4940
74933	DT1 2DS	GB	0101000020E6100000AA0F24EF1C6A03C04FB16A10E65A4940
74934	DT1 2EG	GB	0101000020E6100000802DAF5C6F7B03C0B96FB54E5C5A4940
74935	DT1 2HL	GB	0101000020E610000034DAAA24B28F03C0C007AF5DDA5A4940
74936	DT1 2HR	GB	0101000020E61000008ACBF10A448F03C026C632FD125B4940
74937	DT1 2LB	GB	0101000020E61000000A9DD7D8258A03C0E3344415FE5A4940
74938	DT1 2NL	GB	0101000020E6100000C614AC71369D03C05FB35C363A5B4940
74939	DT1 2PP	GB	0101000020E6100000779D0DF967A603C06F2EFEB6275C4940
74940	DT1 3SS	GB	0101000020E610000054AC1A84B9BD03C0158E2095625B4940
74941	DT1 3WE	GB	0101000020E6100000800BB265F9BA03C0236937FA985B4940
74942	DT10	GB	0101000020E6100000F8FA5A971A6102C01B2FDD24067D4940
74943	DT10 1BQ	GB	0101000020E6100000A56ABB09BE6902C0E44D7E8B4E764940
74944	DT10 1LQ	GB	0101000020E6100000A568E55E607602C0787AA52C437C4940
74945	DT10 1NA	GB	0101000020E61000008ECD8E54DF7902C08B34F10EF0784940
74946	DT10 1PF	GB	0101000020E610000068B0A9F3A87802C06D1D1CEC4D764940
74947	DT10 2AR	GB	0101000020E61000001C25AFCE316002C0C5C9FD0E457D4940
74948	DT10 2PP	GB	0101000020E610000067994528B60203C0AC70CB47527A4940
74949	DT11	GB	0101000020E6100000ED9FA701834401C03AE7A7380E6E4940
74950	DT11 0DB	GB	0101000020E6100000CE8AA8893E7F02C054C90050C5694940
74951	DT11 0EN	GB	0101000020E6100000E8F527F1B97302C03239B5334C6F4940
74952	DT11 0JZ	GB	0101000020E61000004ED4D2DC0A4102C090F46915FD634940
74953	DT11 0NT	GB	0101000020E61000008D9B1A683EE701C09B8D9598676B4940
74954	DT11 0NX	GB	0101000020E610000059F8FA5A97DA01C0B1DCD26A486A4940
74955	DT11 0PX	GB	0101000020E6100000BAF94674CF7A01C0CC0C1B65FD6E4940
74956	DT11 0RX	GB	0101000020E61000005DF92CCF833B02C095BA641C23734940
74957	DT11 0SL	GB	0101000020E61000001AA6B6D441FE01C01C96067E54734940
74958	DT11 0SZ	GB	0101000020E61000004B051555BFF201C0C896E5EB32724940
74959	DT11 7BP	GB	0101000020E6100000B58D3F51D95001C0B7088CF50D6E4940
74960	DT11 7LL	GB	0101000020E6100000F3936A9F8E4701C02B685A62656E4940
74961	DT11 7RH	GB	0101000020E61000002EE6E786A64C01C02C29779FE36D4940
74962	DT11 7RR	GB	0101000020E61000004C18CDCAF64101C06D1D1CEC4D6E4940
74963	DT11 8AE	GB	0101000020E6100000DFC2BAF1EEE800C09B012EC896714940
74964	DT11 8EN	GB	0101000020E6100000F1D93A38D8FB01C05F5CAAD216754940
74965	DT11 8LS	GB	0101000020E610000023F77475C78201C0B939950C00774940
74966	DT11 8TA	GB	0101000020E610000067F0F78BD99201C05F419AB1686C4940
74967	DT11 9	GB	0101000020E610000006BEA25BAF2901C01502B9C491634940
74968	DT11 9AD	GB	0101000020E61000000BD0B69A758601C09A7CB3CD8D6B4940
74969	DT11 9BQ	GB	0101000020E610000087FA5DD89A8D01C0B2D826158D634940
74970	DT11 9DF	GB	0101000020E6100000CA1B60E63BF800C003CFBD874B6A4940
74971	DT11 9DG	GB	0101000020E6100000211E8997A71301C0477364E597694940
74972	DT11 9DY	GB	0101000020E6100000FD9FC37C790101C0187D0569C6684940
74973	DT11 9HG	GB	0101000020E6100000CF656A12BC0101C03B51121269694940
74974	DT11 9PA	GB	0101000020E6100000286211C30E2301C0D923D40CA96A4940
74975	DT11 9PU	GB	0101000020E61000002A00C633684801C081221631EC6C4940
74976	DT11 9PW	GB	0101000020E6100000C619C39CA04D01C07B4FE5B4A76C4940
74977	DT2	GB	0101000020E6100000C5E3A25A44B404C06E32AA0CE36A4940
74978	DT2 0AE	GB	0101000020E6100000B56E83DA6F8D04C002452C62D8634940
74979	DT2 0LX	GB	0101000020E6100000240C03965CE504C05E2A36E675704940
74980	DT2 0NA	GB	0101000020E610000079944A7842CF04C0737FF5B86F6F4940
74981	DT2 7DE	GB	0101000020E6100000A54FABE80F8D03C05DFDD8243F6E4940
74982	DT2 7DP	GB	0101000020E6100000C18EFF02418003C0D8EF8975AA6C4940
74983	DT2 7HS	GB	0101000020E6100000C5CBD3B9A21402C06589CE328B5E4940
74984	DT2 7QY	GB	0101000020E6100000F1BBE9961D6203C026A94C3107674940
74985	DT2 8AP	GB	0101000020E610000045F6419605F302C08198840B795A4940
74986	DT2 8BB	GB	0101000020E610000043E38920CE8302C02FBFD364C6594940
74987	DT2 8BH	GB	0101000020E6100000AB24B20FB2AC02C0E5B33C0FEE584940
74988	DT2 8JR	GB	0101000020E61000000953944BE33702C00403081F4A544940
74989	DT2 8LE	GB	0101000020E6100000205F4205873702C0B685E7A562554940
74990	DT2 8LX	GB	0101000020E6100000041C42959AFD02C0AFCC5B751D564940
74991	DT2 8PP	GB	0101000020E6100000BF99982EC40A03C0ACFE08C380574940
74992	DT2 8QB	GB	0101000020E6100000C7BC8E38644303C046990D32C95C4940
74993	DT2 8UH	GB	0101000020E6100000EBC37AA3561803C03EE94482A9564940
74994	DT2 9BN	GB	0101000020E6100000B4E4F1B4FC4005C09DF6949C13594940
74995	DT2 9DD	GB	0101000020E610000009DE9046054E05C0E42D573F36574940
74996	DT2 9DE	GB	0101000020E6100000D28E1B7E373D05C093196F2BBD564940
74997	DT2 9DF	GB	0101000020E6100000705E9CF86A4705C030BC92E4B9564940
74998	DT2 9PR	GB	0101000020E6100000C102983270A003C03D61890794594940
74999	DT3	GB	0101000020E6100000B532E197FA7903C054FCDF1115524940
75000	DT3 4HA	GB	0101000020E6100000E0F25833328804C0183F8D7BF3554940
75001	DT3 5AG	GB	0101000020E6100000A1A17F828BD504C0CEFBFF3861544940
75002	DT3 5EE	GB	0101000020E610000022C5008926B003C0E481C8224D504940
75003	DT3 5ET	GB	0101000020E6100000B1506B9A77BC03C0EE2422FC8B504940
75004	DT3 5JL	GB	0101000020E610000038A27BD635BA03C0C1A90F24EF504940
75005	DT3 5JR	GB	0101000020E6100000790778D2C2A503C0572250FD83504940
75006	DT3 5LJ	GB	0101000020E6100000DCD5ABC8E8C003C085984BAAB6534940
75007	DT3 5RB	GB	0101000020E6100000C5C551B989BA03C08FA67A32FF524940
75008	DT3 5RW	GB	0101000020E6100000965984622BC803C0560F98874C514940
75009	DT3 6HS	GB	0101000020E6100000D36A48DC638903C0043A933655514940
75010	DT3 6NQ	GB	0101000020E61000000A2FC1A90FA403C028452BF702534940
75011	DT4	GB	0101000020E6100000C85BAE7E6CD203C03CA41820D14E4940
75012	DT4 0BN	GB	0101000020E6100000FF08C38025B703C0575F5D15A84D4940
75013	DT4 0ET	GB	0101000020E610000011E15F048DB903C076F9D687F54E4940
75014	DT4 0NP	GB	0101000020E6100000D5EB1681B1BE03C00EDAAB8F874E4940
75015	DT4 0PH	GB	0101000020E61000009818CBF44BC403C01211FE45D04E4940
75016	DT4 0PL	GB	0101000020E6100000944BE3175EC903C0268DD13AAA4E4940
75017	DT4 0UE	GB	0101000020E61000000B0E2F8848AD03C05B9544F6414E4940
75018	DT4 7BN	GB	0101000020E6100000828E56B5A4A303C09032E202D04E4940
75019	DT4 7LF	GB	0101000020E6100000C3482F6AF7AB03C0CE531D7233504940
75020	DT4 8ED	GB	0101000020E6100000E44D7E8B4E9603C0FF91E9D0E94D4940
75021	DT4 8SQ	GB	0101000020E610000023A298BC01A603C09C86A8C29F4D4940
75022	DT4 8TJ	GB	0101000020E61000008A93FB1D8AA203C0E5B7E864A94D4940
75023	DT4 9BN	GB	0101000020E6100000EFC9C342ADC903C0F69B89E9424C4940
75024	DT4 9JB	GB	0101000020E6100000FFE6C589AFD603C02FE065868D4C4940
75025	DT4 9NQ	GB	0101000020E6100000459E245D33D903C054AA44D95B4C4940
75026	DT4 9PE	GB	0101000020E61000000EF7915B93CE03C09BADBCE47F4C4940
75027	DT4 9RJ	GB	0101000020E6100000927538BA4AB703C06249B9FB1C4D4940
75028	DT4 9TJ	GB	0101000020E610000081CCCEA277EA03C0083A5AD5924E4940
75029	DT5	GB	0101000020E610000033A31F0DA78C03C060CD018239484940
75030	DT5 1AZ	GB	0101000020E61000004D4A41B7979403C01F85EB51B8484940
75031	DT5 1BD	GB	0101000020E61000004EF04DD3678703C0A7203F1BB9484940
75032	DT5 1HW	GB	0101000020E6100000514EB4AB907203C04C546F0D6C454940
75033	DT5 1JA	GB	0101000020E61000005C9198A0866F03C0FF25A94C31454940
75034	DT5 1JG	GB	0101000020E61000003DD175E1076703C039F06AB933474940
75035	DT5 1LP	GB	0101000020E6100000D5CA845FEA8703C0F646AD307D474940
75036	DT5 2ED	GB	0101000020E6100000FB03E5B67D8F03C048FDF50A0B444940
75037	DT5 2HP	GB	0101000020E61000004AED45B41D9303C0E4D6A4DB12454940
75038	DT5 2JG	GB	0101000020E6100000E02D90A0F89103C01BBAD91F28454940
75039	DT5 2TD	GB	0101000020E61000002B6D718DCF8403C07007EA9447454940
75040	DT51 1JA	GB	0101000020E61000002EA9DA6E826F03C03274ECA012454940
75041	DT6	GB	0101000020E6100000581F0F7D770B06C0A54FABE80F614940
75042	DT6 3ED	GB	0101000020E6100000301004C8D0F105C0FD4D2844C05F4940
75043	DT6 3NW	GB	0101000020E6100000CC2555DB4D1006C0AEF204C24E5D4940
75044	DT6 3PN	GB	0101000020E6100000F0181EFB590C06C076C4211B485D4940
75045	DT6 3PR	GB	0101000020E610000062BEBC00FB0806C02B4D4A41B75D4940
75046	DT6 3SL	GB	0101000020E6100000605793A7ACA605C088A1D5C919624940
75047	DT6 3SX	GB	0101000020E610000037C30DF8FC7005C034BF9A0304614940
75048	DT6 3TF	GB	0101000020E6100000E50CC51D6FD205C076FC1708025A4940
75049	DT6 4BJ	GB	0101000020E610000023111AC1C6D505C0E9EDCF45435C4940
75050	DT6 4DP	GB	0101000020E61000002C6519E2581706C0771211FE455C4940
75051	DT6 4NY	GB	0101000020E61000002F4FE78A52A205C0A88FC01F7E5E4940
75052	DT6 4QA	GB	0101000020E6100000F487669E5CD305C0D50451F7015A4940
75053	DT6 4QJ	GB	0101000020E6100000FE4465C39ACA05C0C77F8120405A4940
75054	DT6 4SU	GB	0101000020E61000007DCF4884461006C04B8FA67A325D4940
75055	DT6 5AL	GB	0101000020E6100000BDFF8F13262C06C0D89C8367425D4940
75056	DT6 5BL	GB	0101000020E6100000BE4D7FF6232506C04A7CEE04FB5D4940
75057	DT6 5DB	GB	0101000020E6100000BE16F4DE182206C09F8EC70C54624940
75058	DT6 5HR	GB	0101000020E610000097C9703C9F2106C0E466B8019F5F4940
75059	DT6 5NX	GB	0101000020E6100000392A37514BB306C0613255302A674940
75060	DT6 6DD	GB	0101000020E6100000B6A0F7C6108007C0F9A23D5E48634940
75061	DT6 6EE	GB	0101000020E6100000416667D13BD506C0CA6DFB1EF55F4940
75062	DT6 6EG	GB	0101000020E6100000C2DCEEE53EB906C035EB8CEF8B5F4940
75063	DT6 6LA	GB	0101000020E61000002B4F20EC148B06C01BD82AC1E25E4940
75064	DT6 6NN	GB	0101000020E610000054FCDF11152A07C0E5D3635B06644940
75065	DT6 6PA	GB	0101000020E610000065FF3C0D184407C037E15E99B75E4940
75066	DT6 6PL	GB	0101000020E61000007CB8E4B8533A07C024253D0CAD5E4940
75067	DT7 3NY	GB	0101000020E6100000B1C403CAA67C07C0F41ABB44F55C4940
75068	DT7 3PY	GB	0101000020E610000053CDACA5807407C0992D5915E15C4940
75069	DT7 3RF	GB	0101000020E6100000FB04508C2CD907C0EA5A7B9FAA5C4940
75070	DT7 3RW	GB	0101000020E610000067B796C970BC07C0E5D2F88557604940
75071	DT7 3SE	GB	0101000020E61000009C1A683EE7AE07C0AB3DEC85025E4940
75072	DT7 3UP	GB	0101000020E6100000D009A1832EA107C0D9EBDD1FEF5D4940
75073	DT7 3UX	GB	0101000020E6100000B9FE5D9F39AB07C0145E82531F5E4940
75074	DT8	GB	0101000020E6100000D15966118ACD05C0F84F3750E0694940
75075	DT8 3AA	GB	0101000020E61000007C9BFEEC47EA05C0F59D5F94A0674940
75076	DT8 3BY	GB	0101000020E61000000D51853FC3FB05C0FED2A23EC9674940
75077	DT8 3DR	GB	0101000020E6100000C7B94DB857E605C0535BEA20AF674940
75078	DT8 3EP	GB	0101000020E61000002254A9D903ED05C0C9552C7E53684940
75079	DT8 3JQ	GB	0101000020E6100000FA7ABE66B92C06C0749B70AFCC6B4940
75080	DT8 3JU	GB	0101000020E610000053793BC2694106C0D122DBF97E664940
75081	DT8 3LN	GB	0101000020E6100000257497C4597106C0BD361B2B31694940
75082	DT8 3LX	GB	0101000020E61000006536C82423E705C058207A5226674940
75083	DT8 3SP	GB	0101000020E6100000FCDEA63FFBF105C0A0E1CD1ABC674940
75084	DT9	GB	0101000020E6100000EF1F0BD1215004C0FE7DC68503774940
75085	DT9 3DX	GB	0101000020E6100000066344A2D01204C055F7C8E6AA794940
75086	DT9 3NB	GB	0101000020E610000070ECD973991A04C0639B5434D6784940
75087	DT9 3QL	GB	0101000020E610000063B9A5D5903804C039D2191879794940
75088	DT9 4JB	GB	0101000020E6100000A88DEA74202B04C02EFF21FDF6794940
75089	DT9 4QS	GB	0101000020E6100000EA7AA2EBC2AF04C059C16F438C794940
75090	DT9 5DR	GB	0101000020E6100000AF7AC03C64AA03C0E5F1B4FCC07B4940
75091	DT9 5PD	GB	0101000020E61000000B5F5FEB520304C0D7A3703D0A754940
75092	DT9 6	GB	0101000020E6100000A5F8F884EC5C04C0F0BF95ECD8764940
75093	DT9 6EP	GB	0101000020E6100000C9E4D4CE309504C07B82C476F76E4940
75094	DT9 6HT	GB	0101000020E6100000B7B41A12F73804C05260014C19704940
75095	DT9 6LH	GB	0101000020E6100000C51A2E724F9704C041B96DDFA3724940
75096	DT9 6LL	GB	0101000020E610000066BB421F2CA304C077F4BF5C8B724940
75097	DT9 6LR	GB	0101000020E61000009E060C923EAD04C04D0F0A4AD1724940
75098	DT9 6PT	GB	0101000020E61000008F537424979F04C0664F029B73744940
75099	DT9 6QB	GB	0101000020E6100000FB5A971AA17F04C0F67AF7C77B754940
75100	DT9 6RS	GB	0101000020E61000000CE6AF90B9B204C0B4AA251DE5764940
75101	DT9 6SH	GB	0101000020E610000029B2D6506AAF04C0D8EF8975AA764940
75102	DY1	GB	0101000020E6100000B952CF82507E00C0FD101B2C9C424A40
75103	DY1 1PS	GB	0101000020E61000005CAFE94141A900C0C901BB9A3C414A40
75104	DY1 1UB	GB	0101000020E61000005B96AFCBF0BF00C0B1FD648C0F414A40
75105	DY1 2DW	GB	0101000020E6100000CFF3A78DEAD400C00E4FAF9465404A40
75106	DY1 2GA	GB	0101000020E6100000A9FB00A436B100C0F9F4D89601414A40
75107	DY1 3EB	GB	0101000020E6100000FD31AD4D63BB00C06346787B10424A40
75108	DY1 3EX	GB	0101000020E610000019541B9C88BE00C0BEBED6A546424A40
75109	DY1 3LS	GB	0101000020E6100000C1745AB7418D00C04833164D67414A40
75110	DY1 4AY	GB	0101000020E6100000B7F0BC546CAC00C0A4A99ECC3F424A40
75111	DY1 4BA	GB	0101000020E6100000079B3A8F8A7F00C0E06932E36D434A40
75112	DY1 4HQ	GB	0101000020E610000052EFA99CF69400C0BA10AB3FC2404A40
75113	DY1 4NP	GB	0101000020E610000062484E266EB500C081E9B46E83444A40
75114	DY1 4SQ	GB	0101000020E6100000AE9D2809899400C014799274CD424A40
75115	DY10 1LZ	GB	0101000020E61000006C257497C4B901C0A724EB7074314A40
75116	DY10 1QX	GB	0101000020E61000007F8461C092EB01C0A489778027314A40
75117	DY10 1QZ	GB	0101000020E61000005E83BEF4F6E701C07C478D0931314A40
75118	DY10 1RS	GB	0101000020E6100000F0A7C64B37E901C099BC0166BE314A40
75119	DY10 1SG	GB	0101000020E6100000C87C40A033E901C06DE525FF93314A40
75120	DY10 1XD	GB	0101000020E610000076F9D687F5E601C0284696CCB1304A40
75121	DY10 2EB	GB	0101000020E61000008C868C47A9E401C009C1AA7AF9314A40
75122	DY10 2LB	GB	0101000020E6100000A45181936D0002C0EE23B726DD324A40
75123	DY10 2RY	GB	0101000020E610000088A06AF46AE001C05C1E6B4606334A40
75124	DY10 2TY	GB	0101000020E6100000AF777FBC57CD01C0E62329E961324A40
75125	DY10 3AP	GB	0101000020E6100000ECA2E8818FE101C0B612BA4BE2304A40
75126	DY10 3EG	GB	0101000020E61000008DCF64FF3CCD01C00FEF39B01C314A40
75127	DY10 3JG	GB	0101000020E6100000BFBA2A508B6101C096218E7571334A40
75128	DY10 3LF	GB	0101000020E61000002788BA0F406A01C06EA301BC05344A40
75129	DY10 3TA	GB	0101000020E610000078280AF489DC01C04B77D7D990354A40
75130	DY10 3TB	GB	0101000020E610000088BEBB9525DA01C07E9065C1C4354A40
75131	DY10 4AP	GB	0101000020E6100000161406651AAD01C0DA1A118C832F4A40
75132	DY10 4HB	GB	0101000020E6100000E3E13D0796C301C0FA97A432C52A4A40
75133	DY10 4JR	GB	0101000020E610000084BC1E4C8ACF01C05CC7B8E2E22C4A40
75134	DY10 4RS	GB	0101000020E6100000844BC79C67CC01C009FCE1E7BF2F4A40
75135	DY10 4TR	GB	0101000020E6100000280EA0DFF7CF01C0DE1FEF552B2F4A40
75136	DY11	GB	0101000020E6100000CC4065FCFB0C02C03BC8EBC1A4304A40
75137	DY11 5EB	GB	0101000020E610000046B1DCD26A0802C029780AB952334A40
75138	DY11 5HA	GB	0101000020E61000002B16BF29AC1402C0CF4A5AF10D334A40
75139	DY11 5HW	GB	0101000020E610000048197101681402C0A73D25E7C4324A40
75140	DY11 5LB	GB	0101000020E6100000D71533C2DB2302C0C2BF081A33334A40
75141	DY11 5PN	GB	0101000020E61000002907B309302C02C0F7E6374C34324A40
75142	DY11 5XB	GB	0101000020E61000004AB54FC7630602C0CCB56801DA344A40
75143	DY11 6AX	GB	0101000020E61000003FE08101842F02C08E93C2BCC7314A40
75144	DY11 6BS	GB	0101000020E61000009CFD8172DB1E02C04774CFBA46314A40
75145	DY11 6LT	GB	0101000020E61000003F1EFAEE561602C056F5F23B4D304A40
75146	DY11 6NJ	GB	0101000020E6100000E57E87A2401F02C0FFB3E6C75F304A40
75147	DY11 7AQ	GB	0101000020E6100000E2CAD93BA30D02C0840CE4D9E52F4A40
75148	DY11 7BS	GB	0101000020E610000037FB03E5B61D02C02429E961682F4A40
75149	DY11 7EW	GB	0101000020E61000004B75012F332C02C076711B0DE02F4A40
75150	DY11 7RB	GB	0101000020E6100000B4006DAB59E701C017D86322A52F4A40
75151	DY11 7TW	GB	0101000020E6100000D7BE805EB8D301C0BADBF5D2142B4A40
75152	DY12 1BG	GB	0101000020E6100000AAD6C22CB47302C03CBD529621304A40
75153	DY12 1EJ	GB	0101000020E61000007C65DEAAEB7002C0F60D4C6E14314A40
75154	DY12 1NG	GB	0101000020E61000006B64575A466A02C0562DE92807334A40
75155	DY12 1SY	GB	0101000020E6100000B6A1629CBF8902C04BB1A371A8374A40
75156	DY12 2BQ	GB	0101000020E6100000D6AC33BE2F8E02C08C648F5033304A40
75157	DY12 2DX	GB	0101000020E61000005EF3AACE6A8102C06667D13B15304A40
75158	DY12 2EL	GB	0101000020E61000007B4963B48E8A02C0A27C410B09304A40
75159	DY12 2HG	GB	0101000020E61000006269E047358C02C0D656EC2FBB2F4A40
75160	DY12 2QF	GB	0101000020E61000000B7F86376BD002C0D42CD0EE90304A40
75161	DY12 3BG	GB	0101000020E6100000D9EDB3CA4C4903C01D2098A3C7354A40
75162	DY12 3DW	GB	0101000020E61000002174D0251C1A03C061A417B5FB354A40
75163	DY13	GB	0101000020E6100000D7A19A92AC2302C0E36E10AD152B4A40
75164	DY13 0AT	GB	0101000020E61000002BF697DD934702C0E048A0C1A62A4A40
75165	DY13 0BE	GB	0101000020E6100000030B60CAC06102C07A1C06F3572A4A40
75166	DY13 0LF	GB	0101000020E61000004374081C095402C083A3E4D5392A4A40
75167	DY13 0NX	GB	0101000020E610000026DF6C73635A02C0029D499BAA294A40
75168	DY13 8DH	GB	0101000020E61000001A506F46CD3702C09C35785F952B4A40
75169	DY13 8QL	GB	0101000020E6100000758F6CAE9A4702C0BD5301F73C2D4A40
75170	DY13 8UL	GB	0101000020E61000001BF5108DEE4002C07825C9737D2B4A40
75171	DY13 9AA	GB	0101000020E6100000255987A3AB3402C0AA622AFD842B4A40
75172	DY13 9ND	GB	0101000020E6100000662E7079AC1902C05E6397A8DE2A4A40
75173	DY13 9QA	GB	0101000020E6100000AB4198DBBD1C02C0CD3CB9A6402A4A40
75174	DY14	GB	0101000020E61000007D21E4BCFFAF03C0E8BB5B59A2374A40
75175	DY14 8AR	GB	0101000020E610000099107349D5D603C04E7D2079E7304A40
75176	DY14 8HR	GB	0101000020E6100000E622BE13B39E03C0488AC8B08A334A40
75177	DY14 8HX	GB	0101000020E61000009FE6E445268003C0A48B4D2B85344A40
75178	DY14 8TZ	GB	0101000020E610000011902FA182E303C06327BC04A7384A40
75179	DY14 8UH	GB	0101000020E61000000B62A06B5FE003C0C5FF1D51A1384A40
75180	DY14 9LQ	GB	0101000020E6100000BC934F8F6D7903C0DC645419C62D4A40
75181	DY14 9NR	GB	0101000020E61000001363997E895803C06939D0436D2D4A40
75182	DY14 9UR	GB	0101000020E61000003CDD79E2391B03C01364045438304A40
75183	DY2	GB	0101000020E61000002A90D959F40E01C0CD74AF93FA364A40
75184	DY2 0AN	GB	0101000020E6100000B62FA017EEBC00C058E4D70FB13D4A40
75185	DY2 0EE	GB	0101000020E6100000865968E734CB00C0B34291EEE73E4A40
75186	DY2 8AF	GB	0101000020E610000024253D0CAD8E00C0A1D9756F45404A40
75187	DY2 8LA	GB	0101000020E6100000D921FE614B6F00C0F4BF5C8B16404A40
75188	DY2 9HS	GB	0101000020E6100000A7E67283A18E00C0739F1C05883E4A40
75189	DY2 9RA	GB	0101000020E61000007C6473D53CA700C0F8713447563E4A40
75190	DY3	GB	0101000020E6100000B4AD669DF1FD00C06A32E36DA5454A40
75191	DY3 1AF	GB	0101000020E6100000C87A6AF5D59500C0CF12640454464A40
75192	DY3 1SN	GB	0101000020E6100000D40CA9A278F500C0377172BF43454A40
75193	DY3 1US	GB	0101000020E6100000B62BF4C132F600C0378E588B4F454A40
75194	DY3 2HZ	GB	0101000020E6100000E5266A696EE500C03CDEE4B7E8424A40
75195	DY3 3DL	GB	0101000020E610000039ECBE63782C01C0962023A0C2434A40
75196	DY3 3DS	GB	0101000020E61000004B22FB20CB2201C01D554D1075434A40
75197	DY3 3LN	GB	0101000020E6100000C6A70018CF0001C063096B63EC444A40
75198	DY3 3TR	GB	0101000020E6100000E2033BFE0B0401C04C1B0E4B03474A40
75199	DY4	GB	0101000020E61000004CE0D6DD3C9500C07DCF488446444A40
75200	DY4 7AL	GB	0101000020E6100000486E4DBA2D5100C0929735B1C0434A40
75201	DY4 7BD	GB	0101000020E61000004BCADDE7F84800C0ECA012D731444A40
75202	DY4 7SF	GB	0101000020E61000008BF9B9A1297B00C01407D0EFFB414A40
75203	DY4 8DZ	GB	0101000020E61000004C89247A19A500C07E39B35DA1434A40
75204	DY4 8EB	GB	0101000020E6100000C90050C58D9B00C0F6402B3064434A40
75205	DY4 8ET	GB	0101000020E6100000BB61DBA2CC8600C0FDC1C073EF434A40
75206	DY4 8UB	GB	0101000020E61000003EE94482A96600C0679E5C5320434A40
75207	DY4 9JB	GB	0101000020E6100000C5E74EB0FF7A00C039EFFFE384454A40
75208	DY4 9PG	GB	0101000020E61000005EBC1FB75F7E00C0DA1B7C6132454A40
75209	DY5 1DL	GB	0101000020E61000008B70935165D800C0B587BD50C03C4A40
75210	DY5 1HR	GB	0101000020E6100000DE59BBED42F300C0AA471ADCD63E4A40
75211	DY5 1LX	GB	0101000020E6100000ED6305BF0DF100C02E1C08C9023E4A40
75212	DY5 1RJ	GB	0101000020E61000006C921FF12BB600C0EA58A5F44C414A40
75213	DY5 2DR	GB	0101000020E61000006F7EC34483D400C0CF81E508193C4A40
75214	DY5 2LU	GB	0101000020E6100000BD8E386403E900C016FA60191B3C4A40
75215	DY5 2RH	GB	0101000020E6100000B821C66B5EF500C0A41AF67B623D4A40
75216	DY5 3HG	GB	0101000020E610000085CD0017640B01C0381092054C3C4A40
75217	DY5 3JT	GB	0101000020E61000002CF4C132361401C01B47ACC5A73C4A40
75218	DY5 3TA	GB	0101000020E610000015FDA199271701C0BF28417FA13D4A40
75219	DY5 4NE	GB	0101000020E6100000C0232A54371701C066BCADF4DA3E4A40
75220	DY5 4RP	GB	0101000020E6100000876C205D6C1A01C0CCD4247843404A40
75221	DY6	GB	0101000020E61000007EFE7BF0DA6501C0E657738060404A40
75222	DY6 0JE	GB	0101000020E61000000B7F86376B7001C0DFFB1BB457414A40
75223	DY6 0LT	GB	0101000020E61000002E9276A38F7901C00839EFFFE3404A40
75224	DY6 7AE	GB	0101000020E610000019E6046D725801C0A8902BF52C404A40
75225	DY6 7YB	GB	0101000020E6100000AE8218E8DA3701C02DB4739A05404A40
75226	DY6 7YD	GB	0101000020E610000072C0AE264F3901C025C9737D1F404A40
75227	DY6 8AL	GB	0101000020E6100000310917F2084E01C03A5D16139B3F4A40
75228	DY6 8AY	GB	0101000020E6100000FFCC203EB04301C0A60BB1FA23404A40
75229	DY6 8EB	GB	0101000020E61000007993DFA2934501C0F04FA912653F4A40
75230	DY6 8JT	GB	0101000020E610000083BEF4F6E74201C098BED7101C3F4A40
75231	DY6 8NX	GB	0101000020E61000003830B951642D01C047E5266A693E4A40
75232	DY6 8RD	GB	0101000020E61000001AC05B20413101C00934D8D4793E4A40
75233	DY6 8RP	GB	0101000020E6100000193DB7D0952801C01024EF1CCA3E4A40
75234	DY6 8TA	GB	0101000020E61000008BE255D6362501C079C9FFE4EF3E4A40
75235	DY6 9BN	GB	0101000020E6100000632992AF047201C0D2E3F736FD3F4A40
75236	DY6 9EH	GB	0101000020E6100000292158552F5F01C0D4282499D53F4A40
75237	DY6 9JS	GB	0101000020E61000004C8E3BA5835501C05B7A34D5933F4A40
75238	DY6 9NA	GB	0101000020E6100000BFB67EFACF5A01C08869DFDC5F3F4A40
75239	DY7 5EP	GB	0101000020E61000005A1135D1E70302C05116BEBED6434A40
75240	DY7 5JG	GB	0101000020E61000004E4700378B5702C0637B2DE8BD3D4A40
75241	DY7 6HP	GB	0101000020E61000007E1EA33CF3D201C02DEBFEB110394A40
75242	DY7 6RX	GB	0101000020E6100000BDFBE3BD6A6501C059198D7C5E3B4A40
75243	DY8 1AZ	GB	0101000020E61000004E603AADDB2001C059FAD005F5394A40
75244	DY8 1BJ	GB	0101000020E6100000618BDD3EAB2C01C0404D2D5BEB394A40
75245	DY8 1EX	GB	0101000020E6100000ABD1AB014A2301C013EF004F5A3A4A40
75246	DY8 1HD	GB	0101000020E61000001A69A9BC1D2101C01AF7E6374C3A4A40
75247	DY8 1NH	GB	0101000020E61000009DF529C7641101C09088299144394A40
75248	DY8 1RG	GB	0101000020E6100000B2632310AF2B01C01C0A9FAD83394A40
75249	DY8 1XQ	GB	0101000020E61000005A80B6D5AC3301C08D98D9E7313A4A40
75250	DY8 2	GB	0101000020E61000004B3FE1ECD61201C0263ACB2C42394A40
75251	DY8 2AL	GB	0101000020E610000007B309302C3F01C008E8BE9CD9384A40
75252	DY8 2AR	GB	0101000020E610000085D21742CE3B01C0718DCF64FF384A40
75253	DY8 2LQ	GB	0101000020E6100000A20914B1882101C044C2F7FE06394A40
75254	DY8 2RD	GB	0101000020E61000002C29779FE32301C0925CFE43FA374A40
75255	DY8 3NG	GB	0101000020E61000007C9DD497A55D01C0EF3B86C77E3A4A40
75256	DY8 3UF	GB	0101000020E6100000DFA3FE7A854501C0FC8C0B07423A4A40
75257	DY8 4ED	GB	0101000020E6100000B1FD648C0F3301C080B6D5AC333C4A40
75258	DY8 4YY	GB	0101000020E6100000802A6EDC623E01C0A25F5B3FFD3B4A40
75259	DY8 5YS	GB	0101000020E610000046240A2DEB3E01C0514D49D6E13C4A40
75260	DY9 0JF	GB	0101000020E61000000A9FAD83833D01C0213D450E11354A40
75261	DY9 0JT	GB	0101000020E610000090C18A53AD2501C04BC972124A354A40
75262	DY9 0LF	GB	0101000020E6100000DFDFA0BDFA1801C03BE5D18DB0364A40
75263	DY9 0NX	GB	0101000020E610000084D72E6D382C01C026C3F17C06364A40
75264	DY9 0RG	GB	0101000020E61000000744882B670F01C0562AA8A8FA374A40
75265	DY9 0ST	GB	0101000020E61000009EB7B1D9910A01C068E7340BB4374A40
75266	DY9 7DT	GB	0101000020E61000002367614F3BFC00C0C4060B27693A4A40
75267	DY9 7EJ	GB	0101000020E6100000C921E2E654F200C07BA2EBC20F3A4A40
75268	DY9 7JT	GB	0101000020E6100000FD101B2C9C0401C044300E2E1D394A40
75269	DY9 7NT	GB	0101000020E6100000F415A4198BE600C07A3881E9B43A4A40
75270	DY9 8ES	GB	0101000020E610000029CDE67118EC00C0D272A087DA3A4A40
75271	DY9 8XQ	GB	0101000020E610000099107349D5D600C0B41CE8A1B6394A40
75272	DY9 9ER	GB	0101000020E6100000F4FE3F4E98F000C0A4C4AEEDED384A40
75273	DY9 9UT	GB	0101000020E6100000328FFCC1C09300C03883BF5FCC324A40
75274	E1	GB	0101000020E61000000EDAAB8F87BEA3BF6A12BC218DC24940
75275	E1 0BF	GB	0101000020E6100000E4486760E465ADBF7765170CAEC14940
75276	E1 0JP	GB	0101000020E610000040321D3A3DEFA6BFC426327381C14940
75277	E1 0PU	GB	0101000020E61000008EB0A888D349A6BF583B8A73D4C14940
75278	E1 1EP	GB	0101000020E6100000F624B03907CFB0BF247F30F0DCC14940
75279	E1 1LS	GB	0101000020E6100000E773EE76BD34ADBFB284B53176C24940
75280	E1 1LU	GB	0101000020E61000007F130A117008B1BF5D50DF32A7C14940
75281	E1 1LX	GB	0101000020E6100000FD4AE7C3B304B1BFF7AE415F7AC14940
75282	E1 1NH	GB	0101000020E6100000406A1327F73BB0BFD7A19A92ACC14940
75283	E1 1PW	GB	0101000020E6100000A4AB74779D0DB1BFBC7A15191DC24940
75284	E1 2HU	GB	0101000020E610000051F701486DE2ACBFE7012CF2EBC14940
75285	E1 2JP	GB	0101000020E6100000569FABADD85FAEBF15E46723D7C14940
75286	E1 3BJ	GB	0101000020E6100000F60D4C6E1459ABBF475A2A6F47C24940
75287	E1 3JF	GB	0101000020E61000002844C02154A9A9BFE65DF58079C24940
75288	E1 3NJ	GB	0101000020E6100000DFDDCA129D65A6BF41800C1D3BC24940
75289	E1 4AA	GB	0101000020E6100000E6CDE15AED61A7BF3D29931ADAC24940
75290	E1 4AP	GB	0101000020E6100000276893C3279DA0BFC9E6AA798EC24940
75291	E1 4BU	GB	0101000020E610000008E6E8F17B9BA6BFA9D898D711C34940
75292	E1 4DN	GB	0101000020E6100000D4450A65E1EBA3BFDE718A8EE4C24940
75293	E1 4EE	GB	0101000020E61000009FC9FE791A30A8BFF817416326C34940
75294	E1 4JJ	GB	0101000020E6100000E1421EC18D949DBF895E46B1DCC24940
75295	E1 4NS	GB	0101000020E6100000FB2477D84466A6BFFB22A12DE7C24940
75296	E1 4PD	GB	0101000020E6100000548F34B8AD2DA4BF271763601DC34940
75297	E1 5AW	GB	0101000020E6100000AD69DE718A8EB0BFD4D4B2B5BEC24940
75298	E1 5BX	GB	0101000020E6100000CDB051D66F26A6BFEFE4D3635BC44940
75299	E1 5QY	GB	0101000020E6100000A6643909A52FACBF4450357A35C24940
75300	E1 5RY	GB	0101000020E610000067B5C01E13299DBF85B4C6A013C44940
75301	E1 6BT	GB	0101000020E6100000DF32A7CB6262B3BFBE4EEACBD2C24940
75302	E1 6EB	GB	0101000020E61000006EA6423C122FB3BF2DEC6987BFC24940
75303	E1 6JJ	GB	0101000020E6100000A7751BD47E6BB3BF8E78B29B19C34940
75304	E1 6JX	GB	0101000020E6100000E20511A96917B3BFA6F10BAF24C34940
75305	E1 6LS	GB	0101000020E6100000E620E868554BB2BF0BB43BA418C24940
75306	E1 6LY	GB	0101000020E610000014419C871398B2BF144031B264C24940
75307	E1 6NW	GB	0101000020E6100000027E8D2441B8B2BF93AB58FCA6C24940
75308	E1 6RU	GB	0101000020E61000004696CCB1BCABB2BF5586713788C24940
75309	E1 7ED	GB	0101000020E610000052465C001AA5B3BFD6E07D552EC24940
75310	E1 7NY	GB	0101000020E6100000219221C7D633B4BFB91803EB38C24940
75311	E1 7QL	GB	0101000020E61000000E30F31DFCC4B1BF632992AF04C24940
75312	E1 8BU	GB	0101000020E6100000DAAA24B20FB2B0BFACE122F774C14940
75313	E1 8DL	GB	0101000020E610000084D89942E735B2BF340EF5BBB0C14940
75314	E1 8RL	GB	0101000020E6100000A65EB7088CF5B1BF33FE7DC685C14940
75315	E10	GB	0101000020E61000004F22C2BF081A83BF18E945ED7EC94940
75316	E10 5DY	GB	0101000020E61000002F6EA301BC0592BF80BA8102EFC84940
75317	E10 5NF	GB	0101000020E6100000DFC2BAF1EEC898BF417E3672DDC84940
75318	E10 5NW	GB	0101000020E610000047C8409E5DBE85BF3694DA8B68C74940
75319	E10 5RQ	GB	0101000020E6100000655419C6DD207A3F471FF30181C84940
75320	E10 6JT	GB	0101000020E6100000F304C24EB16A80BF73D87DC7F0C84940
75321	E10 6LA	GB	0101000020E6100000FA635A9BC6F67ABF2272FA7ABEC84940
75322	E10 6LN	GB	0101000020E6100000ED65DB696B4480BF4432E4D87AC84940
75323	E10 6NJ	GB	0101000020E61000004BC8073D9B557FBFD046AE9B52C84940
75324	E10 6PH	GB	0101000020E610000030A182C30B2272BFA983BC1E4CC84940
75325	E10 6PP	GB	0101000020E61000003FE603029D496BBFA587A1D5C9C74940
75326	E10 6QB	GB	0101000020E61000009B1DA9BEF38B82BFF69B89E942C84940
75327	E10 6QH	GB	0101000020E6100000C7BDF90D130D82BF897E6DFDF4C74940
75328	E10 6RP	GB	0101000020E610000055D97745F0BF953F96EB6D3315CA4940
75329	E10 6SR	GB	0101000020E61000007FA2B2614D6581BF64213A048EC84940
75330	E10 7PF	GB	0101000020E610000016BEBED6A546A0BF73D9E89C9FC84940
75331	E10 7QT	GB	0101000020E61000001212691B7FA2A2BF90BFB4A84FC84940
75332	E11	GB	0101000020E6100000B9FE5D9F39EB833F7FDC7EF964C94940
75333	E11 1BP	GB	0101000020E6100000C6A2E9EC6470743F2E8ECA4DD4C84940
75334	E11 1NB	GB	0101000020E6100000FCC8AD49B725823F603DEE5BADC94940
75335	E11 1QL	GB	0101000020E61000008D43FD2E6CCD963F1B65FD6662CA4940
75336	E11 1SZ	GB	0101000020E6100000FA27B8585183993F68CC24EA05CB4940
75337	E11 2JR	GB	0101000020E6100000645A9BC6F65AA03F3F373465A7C94940
75338	E11 2JS	GB	0101000020E61000007978CF81E508A13F871744A4A6C94940
75339	E11 2NP	GB	0101000020E61000005BD07B6308009E3FEA758BC058C94940
75340	E11 2PZ	GB	0101000020E6100000D4D4B2B5BE48983F6F8104C58FC94940
75341	E11 2SF	GB	0101000020E61000004B3FE1ECD632993FB5705985CDCA4940
75342	E11 3BL	GB	0101000020E61000004CC11A67D311903F7077D66EBBC84940
75343	E11 3BW	GB	0101000020E610000084674293C492923FACC77DAB75C84940
75344	E11 3DR	GB	0101000020E61000000BEBC6BB2363853F223317B83CC84940
75345	E11 3EN	GB	0101000020E6100000D7DCD1FF722D8A3F9C6ED921FEC74940
75346	E11 3JH	GB	0101000020E6100000F661BD512B4C7F3FE814E46723C74940
75347	E11 3QP	GB	0101000020E6100000929735B1C057943F8048BF7D1DC84940
75348	E11 3QZ	GB	0101000020E610000072C284D1AC6C9F3FAC8DB1135EC84940
75349	E11 4AD	GB	0101000020E61000003A2009FB7612413F2D077AA86DC94940
75350	E11 4BT	GB	0101000020E6100000AA656B7D91D066BFB4E7323509C84940
75351	E11 4BW	GB	0101000020E6100000A0FB7266BB425FBF11C8258E3CC84940
75352	E11 4BZ	GB	0101000020E61000001F1329CDE67148BF20B24813EFC84940
75353	E11 4RE	GB	0101000020E61000000306499F56D17F3F60B01BB62DC84940
75354	E12 5AZ	GB	0101000020E6100000AF5A99F04BFDA43F919BE1067CC64940
75355	E12 5BD	GB	0101000020E6100000978FA4A487A1A53F7A56D28A6FC64940
75356	E12 5DZ	GB	0101000020E6100000F9BA0CFFE906A23F6BF0BE2A17C84940
75357	E12 5EA	GB	0101000020E6100000EB353D282845A33F9FC9FE791AC84940
75358	E12 5EL	GB	0101000020E6100000416326512FF8A43F76FD82DDB0C74940
75359	E12 5EP	GB	0101000020E6100000E76D6C76A4FAA63F68CD8FBFB4C64940
75360	E12 5EU	GB	0101000020E6100000DB8827BB99D1A73F9A5B21ACC6C64940
75361	E12 5HN	GB	0101000020E61000005F984C158C4AA23F7B1684F23EC84940
75362	E12 5HT	GB	0101000020E61000002882380F2730A53FABEAE5779AC64940
75363	E12 5JE	GB	0101000020E6100000FCC22B499EEBAB3F0B26FE28EAC64940
75364	E12 5RL	GB	0101000020E610000029CDE67118CCAF3F696FF085C9C64940
75365	E13	GB	0101000020E6100000D52478431A15883FF0BF95ECD8C24940
75366	E13 0SJ	GB	0101000020E6100000E6CDE15AED619F3FA52DAEF199C44940
75367	E13 8QD	GB	0101000020E6100000FC7266BB421F9C3F5C3B511212C34940
75368	E13 8QS	GB	0101000020E610000010069E7B0F979C3F408A3A730FC34940
75369	E13 8SL	GB	0101000020E6100000058BC3995FCDA13F06802A6EDCC24940
75370	E13 9AE	GB	0101000020E61000001EFF058200199A3FF1811DFF05C44940
75371	E13 9LX	GB	0101000020E61000001DACFF73982F9F3F68E89FE062C34940
75372	E13 9PX	GB	0101000020E610000049A0C1A6CEA3A23F97E13FDD40C34940
75373	E14	GB	0101000020E61000001381EA1F443294BFB88FDC9A74C14940
75374	E14 0BB	GB	0101000020E61000004A9BAA7B647385BF2E5393E00DC14940
75375	E14 0BS	GB	0101000020E6100000D311C0CDE2C592BF338AE59656C14940
75376	E14 2BG	GB	0101000020E6100000D313967840D974BFB08EE3874AC14940
75377	E14 2DE	GB	0101000020E610000090BE49D3A0685EBF28F4FA93F8C04940
75378	E14 3AQ	GB	0101000020E610000054E57B46223492BF587380608EBE4940
75379	E14 3AX	GB	0101000020E6100000C9570229B16B8BBF45F0BF95ECBE4940
75380	E14 3BG	GB	0101000020E61000006B48DC63E94387BF72FDBB3E73BE4940
75381	E14 3EL	GB	0101000020E610000030D978B0C56E6FBF39F1D58EE2BE4940
75382	E14 3EN	GB	0101000020E61000002882380F27306DBFFB912232ACBE4940
75383	E14 3GE	GB	0101000020E61000001D774A07EBFF6CBFF05014E813BF4940
75384	E14 3GG	GB	0101000020E61000004776A565A4DE73BF42EC4CA1F3BE4940
75385	E14 3SJ	GB	0101000020E6100000AAD6C22CB4739ABFFDDB65BFEEBE4940
75386	E14 3TH	GB	0101000020E6100000BDFF8F13268C96BFBBB9F8DB9EBE4940
75387	E14 3UX	GB	0101000020E6100000109546CCECF3783F336C94F59BBF4940
75388	E14 3WA	GB	0101000020E61000007AC37DE4D6A48BBFF69B89E942BE4940
75389	E14 3WD	GB	0101000020E61000003A92CB7F48BF8DBF984C158C4ABE4940
75390	E14 3XA	GB	0101000020E610000022DFA5D425E378BFE7C2482F6ABF4940
75391	E14 4QJ	GB	0101000020E6100000D65757056A3198BF82C5E1CCAFC04940
75392	E14 4QT	GB	0101000020E61000000EA320787C7B97BF58CA32C4B1C04940
75393	E14 5LB	GB	0101000020E61000008A73D4D1713592BFC02500FF94C04940
75394	E14 5LH	GB	0101000020E61000006347E350BF0B8BBF14AE47E17AC04940
75395	E14 5SG	GB	0101000020E6100000929735B1C05784BF80EF366F9CC04940
75396	E14 7HP	GB	0101000020E6100000302AA913D044A0BF56B77A4E7AC14940
75397	E14 7JB	GB	0101000020E61000001137A79201A0A2BF359A5C8C81C14940
75398	E14 7JD	GB	0101000020E6100000D93D7958A835A5BFC6FCDCD094C14940
75399	E14 8AS	GB	0101000020E6100000AAEE91CD55F39CBFEF90628044C14940
75400	E14 8DJ	GB	0101000020E61000002D95B7239C16A4BFE71A66683CC14940
75401	E14 8DZ	GB	0101000020E61000005B94D920938CA4BF7FA2B2614DC14940
75402	E14 8EG	GB	0101000020E6100000BBD1C77C40A0A3BF61A6ED5F59C14940
75403	E14 8HU	GB	0101000020E6100000E3FBE25295B6A0BF5C001AA54BC14940
75404	E14 8JR	GB	0101000020E6100000392A37514B739BBF5682C5E1CCBF4940
75405	E14 8LH	GB	0101000020E61000002046088F368E98BF74435376FABF4940
75406	E14 8LN	GB	0101000020E61000007F69519FE40E9BBF448655BC91BF4940
75407	E14 8LR	GB	0101000020E61000009B3BFA5FAE459BBF7A34D593F9BF4940
75408	E14 8SP	GB	0101000020E6100000DB1324B6BB0798BFC26C020CCBBF4940
75409	E14 9GE	GB	0101000020E61000002DB4739A05DA8DBF0F27309DD6BF4940
75410	E14 9GR	GB	0101000020E610000050C763062AE38FBF28F38FBE49BF4940
75411	E14 9PF	GB	0101000020E6100000AED85F764F1E76BFD1E7A38CB8C04940
75412	E14 9RP	GB	0101000020E61000006C239EEC66468FBFA8A9656B7DBF4940
75413	E14 9UU	GB	0101000020E61000002FC03E3A75E593BF793D98141FBF4940
75414	E14 9XD	GB	0101000020E6100000CF9ECBD4247893BF31D28BDAFDBE4940
75415	E14 9YT	GB	0101000020E6100000B43A394371C78BBFFED137691AC04940
75416	E15	GB	0101000020E61000008A929048DBF863BF56116E32AAC44940
75417	E15 1AZ	GB	0101000020E61000007CB5A338471D6DBFB9C3263273C54940
75418	E15 1PX	GB	0101000020E6100000E5B67D8FFAEB653F9FCA694FC9C54940
75419	E15 1SA	GB	0101000020E610000063F19BC24A05753F390B7BDAE1C54940
75420	E15 1SX	GB	0101000020E610000031D120054F21873F47938B31B0C64940
75421	E15 2FH	GB	0101000020E61000005A492BBEA1F079BF41446ADAC5C64940
75422	E15 3BT	GB	0101000020E6100000DC114E0B5EF4753F98C3EE3B86C34940
75423	E15 3DX	GB	0101000020E6100000F793313ECC5E863F6E35EB8CEFC34940
75424	E15 3PY	GB	0101000020E61000006A6AD95A5F24943F74232C2AE2C44940
75425	E15 3QR	GB	0101000020E610000021904B1C7920923F5C77F35487C44940
75426	E15 4ED	GB	0101000020E6100000B3B112F3ACA4953F0C1EA67D73C54940
75427	E15 4HD	GB	0101000020E6100000E2B034F0A31A863F234DBC033CC54940
75428	E15 4JY	GB	0101000020E6100000034015376E318F3F44DE72F563C54940
75429	E16 0PX	GB	0101000020E6100000C53D963E7441A53F325871AAB5C04940
75430	E16 1DW	GB	0101000020E6100000664CC11A67D3913F674815C5ABC04940
75431	E16 1TZ	GB	0101000020E610000026C808A87004993F52F01472A5C04940
75432	E16 2AF	GB	0101000020E61000001BF1643733FA913FFD6838656EC04940
75433	E16 2BF	GB	0101000020E61000005BD07B630800A63FECBE6378ECBF4940
75434	E16 2DE	GB	0101000020E6100000F436363B527DA73FF8A57EDE54C04940
75435	E16 2EQ	GB	0101000020E6100000EC4CA1F31ABBA43F4E0B5EF415C04940
75436	E16 2JJ	GB	0101000020E6100000A648BE124889AD3F14AE47E17AC04940
75437	E16 2QQ	GB	0101000020E61000008FDE701FB935B13FF62686E464C04940
75438	E16 3BX	GB	0101000020E6100000DD5ED218ADA39A3FE3C5C21039C14940
75439	E16 3DZ	GB	0101000020E61000004981053065E0A03FFAF202ECA3C14940
75440	E16 3QR	GB	0101000020E610000047AD307DAF21983F9CFA40F2CEC14940
75441	E16 3TS	GB	0101000020E61000009AB1683A3B19A43F2DCDAD1056C14940
75442	E16 4ED	GB	0101000020E6100000D95DA0A4C002983F7BF5F1D077C14940
75443	E17	GB	0101000020E6100000A3CA30EE06D18ABF2B137EA99FC94940
75444	E17 3AE	GB	0101000020E6100000362383DC459892BF6E895C7006CB4940
75445	E17 3LX	GB	0101000020E61000002C2B4D4A41B767BFA27F828B15CB4940
75446	E17 3PG	GB	0101000020E6100000F5DBD7817346843F44A7E7DD58CA4940
75447	E17 3PY	GB	0101000020E610000096D05D126745843F34F3E49A02CB4940
75448	E17 4BJ	GB	0101000020E6100000A226FA7C941107BF43572250FDCB4940
75449	E17 4BN	GB	0101000020E6100000664CC11A67D331BF1E19ABCDFFCB4940
75450	E17 4BT	GB	0101000020E61000000C40A374E95F723FFE80070610CC4940
75451	E17 4ER	GB	0101000020E6100000118AADA0698975BFA391CF2B9ECC4940
75452	E17 4GN	GB	0101000020E6100000ADBF2500FF94A2BF2B2FF99FFCC94940
75453	E17 4JY	GB	0101000020E6100000921FF12BD67081BFD99942E735CC4940
75454	E17 4LB	GB	0101000020E610000012A5BDC1172683BFAFCDC64ACCCB4940
75455	E17 4SD	GB	0101000020E61000007E8E8F16670C93BF4C546F0D6CCB4940
75456	E17 5AX	GB	0101000020E61000000C569C6A2DCC92BF569DD5027BCC4940
75457	E17 5BY	GB	0101000020E61000009738F240649196BFE9279CDD5ACC4940
75458	E17 5DS	GB	0101000020E6100000CC5D4BC8073D9BBFDA740470B3CC4940
75459	E17 5LF	GB	0101000020E6100000BE840A0E2F8898BFEE7893DFA2CB4940
75460	E17 5QY	GB	0101000020E61000008C81751C3F54A2BF38842A357BCC4940
75461	E17 6HJ	GB	0101000020E61000000FD3BEB9BF7AA4BF4C1AA37554CB4940
75462	E17 6HS	GB	0101000020E6100000B9FE5D9F39EBA3BFA2B8E34D7ECB4940
75463	E17 6JB	GB	0101000020E61000006DC669882AFCA1BF5B069CA564CB4940
75464	E17 6LG	GB	0101000020E61000009370218FE046A2BF2009FB7612CB4940
75465	E17 6LP	GB	0101000020E6100000950ED6FF39CC97BF65C746205ECB4940
75466	E17 6LU	GB	0101000020E6100000778368AD6873A4BFF9307BD976CA4940
75467	E17 6NH	GB	0101000020E6100000E6ADBA0ED594A4BF2B4F20EC14CB4940
75468	E17 6NP	GB	0101000020E61000008D0E48C2BE9DA4BF69A9BC1DE1CA4940
75469	E17 6PR	GB	0101000020E6100000FDBD141E34BB9EBFFED478E926CB4940
75470	E17 6SB	GB	0101000020E6100000C1C6F5EFFACC99BFE2E995B20CCB4940
75471	E17 7DN	GB	0101000020E6100000143DF0315871A2BFD3BD4EEACBCA4940
75472	E17 7DT	GB	0101000020E6100000E3344415FE0C9FBF17D4B7CCE9CA4940
75473	E17 7HE	GB	0101000020E61000009548A297512CA7BF890CAB7823CB4940
75474	E17 7HL	GB	0101000020E610000078D498107349A5BF9753026212CA4940
75475	E17 7LX	GB	0101000020E6100000AC527AA697189BBFADF6B0170ACA4940
75476	E17 7PL	GB	0101000020E6100000857B65DEAAEBA0BFFA2AF9D85DCA4940
75477	E17 7QJ	GB	0101000020E6100000015130630AD698BF522B4CDF6BCA4940
75478	E17 8AA	GB	0101000020E61000003FFD67CD8FBF94BF5CE509849DCA4940
75479	E17 8AS	GB	0101000020E61000001CB28174B169A5BFD925AAB706CA4940
75480	E17 8DU	GB	0101000020E61000003201BF4692209CBF8FFCC1C073C94940
75481	E17 8JY	GB	0101000020E6100000D4EFC2D66CE595BFB30B06D7DCC94940
75482	E17 8QT	GB	0101000020E610000030815B77F35497BF37DDB243FCC94940
75483	E17 9AN	GB	0101000020E61000008D2441B8020A953F732F302B14CB4940
75484	E17 9AZ	GB	0101000020E61000008CA03193A8178CBF8202EFE4D3C94940
75485	E17 9BG	GB	0101000020E61000003813D38558FD91BF9566F3380CCA4940
75486	E17 9BU	GB	0101000020E61000007590D78349F181BF8335CEA623CA4940
75487	E17 9JW	GB	0101000020E61000006A50340F60917FBF0C2252D32ECA4940
75488	E17 9QS	GB	0101000020E610000011AAD4EC815690BF93FDF33460CA4940
75489	E17 9RA	GB	0101000020E6100000008E3D7B2E53633F89963C9E96CB4940
75490	E17 9RG	GB	0101000020E610000069C4CC3E8F518EBF44F7AC6BB4CA4940
75491	E18	GB	0101000020E610000086AE44A0FA07913F42791F4773CC4940
75492	E18 1BL	GB	0101000020E61000004832AB77B81D9A3FC3B645990DCC4940
75493	E18 1DE	GB	0101000020E61000003DEFC682C2A09C3FFBCDC47421CC4940
75494	E18 1DL	GB	0101000020E6100000FA0967B796C9A03F95B6B8C667CC4940
75495	E18 1DY	GB	0101000020E61000005184D4EDEC2B9F3FB95164ADA1CC4940
75496	E18 1HX	GB	0101000020E610000064E76D6C76A4A23FBD1C76DF31CC4940
75497	E18 1JA	GB	0101000020E6100000EA094B3CA06CA23F381092054CCC4940
75498	E18 1JZ	GB	0101000020E610000059C16F438CD7A43F8318E8DA17CC4940
75499	E18 1QL	GB	0101000020E6100000C710001C7BF69C3F8FAB915D69CB4940
75500	E18 2HA	GB	0101000020E610000064E60297C79A913F65E3C116BBCB4940
75501	E18 2HB	GB	0101000020E610000006651A4D2EC6903F30D63730B9CB4940
75502	E18 2HD	GB	0101000020E6100000758E01D9EBDD8F3F2F51BD35B0CB4940
75503	E18 2JT	GB	0101000020E61000002DB308C556D0943F33DFC14F1CCC4940
75504	E18 2LG	GB	0101000020E6100000D6E3BED53A71893F79CBD58F4DCC4940
75505	E18 2LJ	GB	0101000020E61000008EAD6708C72C8B3F7769C36169CC4940
75506	E18 2LL	GB	0101000020E6100000F8A8BF5E61C18D3FC24D469561CC4940
75507	E18 2PW	GB	0101000020E6100000C217265305A3923F1135D1E7A3CC4940
75508	E1W	GB	0101000020E610000066F84F3750E0ADBF2EC901BB9AC04940
75509	E1W 1PW	GB	0101000020E6100000331AF9BCE2A9AFBF7C60C77F81C04940
75510	E1W 2NP	GB	0101000020E61000001CB4571F0F7DAFBFB0045262D7C04940
75511	E1W 3ES	GB	0101000020E61000003D49BA66F2CDA6BF5305A3923AC14940
75512	E1W 3ET	GB	0101000020E6100000622EA9DA6E82A7BF3ECA880B40C14940
75513	E1W 3EU	GB	0101000020E610000057410C74ED0BA8BF7F349C3237C14940
75514	E1W 3HU	GB	0101000020E6100000C1ADBB79AA43A6BF4640852348C14940
75515	E1W 3NL	GB	0101000020E61000001E1840F850A2ADBF1135D1E7A3C04940
75516	E1W 3TA	GB	0101000020E6100000882CD2C43BC0ABBFCA87A06AF4C04940
75517	E2	GB	0101000020E61000001FDAC70A7E1BB2BF6A8995D1C8C34940
75518	E2 0AN	GB	0101000020E61000003B00E2AE5E45AEBF136058FE7CC34940
75519	E2 0DS	GB	0101000020E6100000344B02D4D4B2ADBFD49E927362C34940
75520	E2 0HQ	GB	0101000020E61000000A2C80290307ACBF136058FE7CC34940
75521	E2 0NF	GB	0101000020E6100000B131AF230ED9A8BF9A417C60C7C34940
75522	E2 0QL	GB	0101000020E610000066DB696B4430A6BF3DD68C0C72C34940
75523	E2 6DG	GB	0101000020E6100000D0ED258DD13AB2BFAFEC82C135C34940
75524	E2 6DR	GB	0101000020E61000008CDCD3D51D8BB1BF0F63D2DF4BC34940
75525	E2 6DZ	GB	0101000020E6100000CE37A27BD635B2BF12BF620D17C34940
75526	E2 6EG	GB	0101000020E610000000A94D9CDCEFB0BFEE05668522C34940
75527	E2 6EH	GB	0101000020E6100000130A11700855B2BF958098840BC34940
75528	E2 6JD	GB	0101000020E610000008944DB9C2BBB0BF1FBDE13E72C34940
75529	E2 6JL	GB	0101000020E61000006458C51B9947AEBFB87361A417C34940
75530	E2 6PE	GB	0101000020E6100000D200DE02098AAFBF33A5F5B704C44940
75531	E2 6PF	GB	0101000020E6100000168A743FA720AFBF0589EDEE01C44940
75532	E2 7BF	GB	0101000020E6100000290989B48D3FB1BFC37DE4D6A4C34940
75533	E2 7BU	GB	0101000020E6100000179E978A8D79B1BF8BA6B393C1C34940
75534	E2 7DP	GB	0101000020E610000023BC3D0801F9B2BF8D614ED026C34940
75535	E2 7EF	GB	0101000020E6100000836A8313D1AFB1BFE8F4BC1B0BC44940
75536	E2 7LD	GB	0101000020E6100000240C03965CC5B2BF8A73D4D171C34940
75537	E2 7LE	GB	0101000020E610000056B950F9D7F2B2BFE5F21FD26FC34940
75538	E2 7PQ	GB	0101000020E61000000C3CF71E2E39B2BF06D50627A2C34940
75539	E2 7PR	GB	0101000020E6100000E6046D72F8A4B3BF4E64E60297C34940
75540	E2 7RU	GB	0101000020E61000005E656D533C2EB2BF4F78094E7DC44940
75541	E2 7SQ	GB	0101000020E6100000C87E164B917CB1BF58923CD7F7C34940
75542	E2 8DY	GB	0101000020E6100000ED9BFBABC77DB3BFB81FF0C000C44940
75543	E2 8HD	GB	0101000020E6100000E2B19FC55224B3BF378C82E0F1C34940
75544	E2 8NP	GB	0101000020E6100000BD35B05582C5B1BFFA7C941117C44940
75545	E2 9AQ	GB	0101000020E6100000A585CB2A6C06B0BF359886E123C44940
75546	E2 9EG	GB	0101000020E6100000A48AE255D636ADBF583A1F9E25C44940
75547	E2 9JF	GB	0101000020E610000015014EEFE2FDA8BF75779D0DF9C34940
75548	E2 9LE	GB	0101000020E61000002FA4C343183FADBF8B36C7B94DC44940
75549	E2 9PT	GB	0101000020E610000047ACC5A70018A7BF986A662D05C44940
75550	E2 9QY	GB	0101000020E6100000CD57C9C7EE02ADBF813D26529AC34940
75551	E2 9RJ	GB	0101000020E610000070952710768AADBF4C18CDCAF6C34940
75552	E2 9RR	GB	0101000020E6100000E4839ECDAACFADBF0D51853FC3C34940
75553	E3	GB	0101000020E61000008942CBBA7F2C94BFD47E6B274AC24940
75554	E3 2SQ	GB	0101000020E6100000BCCADAA6785C94BF46B1DCD26AC44940
75555	E3 3DA	GB	0101000020E61000001DC87A6AF5D585BF2FFA0AD28CC34940
75556	E3 3EU	GB	0101000020E610000016DEE522BE1393BF0F289B7285C34940
75557	E3 3HQ	GB	0101000020E6100000F73FC05AB56B92BF23A46E675FC34940
75558	E3 3JB	GB	0101000020E61000008AE5965643E28EBF456458C51BC34940
75559	E3 4BA	GB	0101000020E610000019E25817B7D1903F77A38FF980C44940
75560	E3 4EA	GB	0101000020E61000006D8C9DF0129C8ABF5F45460724C34940
75561	E3 4HJ	GB	0101000020E6100000AE65321CCF67A0BF467C2766BDC24940
75562	E3 4LH	GB	0101000020E61000001B4641F0F8F69EBF03B5183C4CC34940
75563	E3 4NU	GB	0101000020E6100000AA2B9FE57970873FB85A272EC7C34940
75564	E3 4PN	GB	0101000020E610000082FFAD64C746A0BFC9C7EE0225C34940
75565	E3 4QG	GB	0101000020E61000009A05DA1D520CA0BF85CFD6C1C1C24940
75566	E3 4QU	GB	0101000020E61000001B118C834BC79CBFB119E0826CC14940
75567	E3 4TH	GB	0101000020E61000001A506F46CD57A1BFE7C41EDAC7C24940
75568	E3 5AP	GB	0101000020E6100000D3DEE00B93A9A2BF3ED00A0C59C34940
75569	E3 5AX	GB	0101000020E6100000817A336ABE4A9EBF07CF842689C34940
75570	E3 5BH	GB	0101000020E610000060014C1938A0A5BFF59D5F94A0C34940
75571	E3 5BN	GB	0101000020E6100000A0E062450DA6A1BF27158DB5BFC34940
75572	E3 5GN	GB	0101000020E6100000C1ADBB79AA439EBF82A8FB00A4C44940
75573	E3 5HU	GB	0101000020E61000005EF3AACE6A819DBFF50F221972C44940
75574	E3 5RH	GB	0101000020E61000000DA837A3E6ABA4BF7FDAA84E07C44940
75575	E3 5SA	GB	0101000020E61000005BEECC04C3B9A6BF6A882AFC19C44940
75576	E4	GB	0101000020E61000001D03B2D7BB3F7EBF05E10A28D4CD4940
75577	E4 6AL	GB	0101000020E610000044DD0720B589833FE789E76C01D14940
75578	E4 6BT	GB	0101000020E6100000925A28999CDA893FFC56EBC4E5D04940
75579	E4 6BZ	GB	0101000020E61000004606B98B3045893FAB4198DBBDD04940
75580	E4 6EF	GB	0101000020E6100000790261A75835983F730F09DFFBD54940
75581	E4 6LU	GB	0101000020E6100000C8ED974F560C773FA12E52280BCF4940
75582	E4 6ND	GB	0101000020E610000085CE6BEC12D57B3FC0CC77F013CF4940
75583	E4 6PE	GB	0101000020E61000006FF1F09E03CB413F9012BBB6B7CF4940
75584	E4 6PH	GB	0101000020E6100000994BAAB69BE06BBF4F0647C9ABCF4940
75585	E4 6PQ	GB	0101000020E6100000B5E1B034F0A35ABF7A8CF2CCCBCF4940
75586	E4 6PZ	GB	0101000020E6100000EF1CCA501553A13F060FD3BEB9D14940
75587	E4 6QJ	GB	0101000020E6100000BFB67EFACF9A6FBF51A5660FB4D04940
75588	E4 7AL	GB	0101000020E61000002DEA93DC6113793F1CEE23B726D14940
75589	E4 7AX	GB	0101000020E6100000786000E14389763F3B342C465DD14940
75590	E4 7DU	GB	0101000020E610000092CB7F48BF7D3DBFDAE731CA33D14940
75591	E4 7DX	GB	0101000020E61000009A5E622CD32F61BF74B4AA251DD14940
75592	E4 7HH	GB	0101000020E6100000F0F78BD9925551BF145D177E70D04940
75593	E4 7JT	GB	0101000020E610000055A3570394868ABFD7DEA7AAD0D04940
75594	E4 7LQ	GB	0101000020E6100000259694BBCFF181BF0DC2DCEEE5D04940
75595	E4 7LY	GB	0101000020E6100000D2393FC571E075BF3FFF3D78EDD04940
75596	E4 7QW	GB	0101000020E6100000CB8635954561673FE4D6A4DB12D34940
75597	E4 8AU	GB	0101000020E61000009F39EB538EC992BF9B00C3F2E7CF4940
75598	E4 8EE	GB	0101000020E6100000B950F9D7F2CA95BFBB5F05F86ECF4940
75599	E4 8EP	GB	0101000020E61000001A88653387A496BF2C6684B707CF4940
75600	E4 8HS	GB	0101000020E6100000EC4B361E6CB19BBFF0A2AF20CDCE4940
75601	E4 8HT	GB	0101000020E610000069554B3ACAC19CBF9757AEB7CDCE4940
75602	E4 8PD	GB	0101000020E61000001A4D2EC6C03A9EBF2BFA43334FCE4940
75603	E4 9DY	GB	0101000020E61000009A249694BBCF91BF4E9B711AA2CE4940
75604	E4 9LA	GB	0101000020E6100000B7EEE6A90EB949BF76A565A4DECD4940
75605	E4 9LJ	GB	0101000020E6100000D7868A71FE2664BF83E0F1ED5DCD4940
75606	E4 9LP	GB	0101000020E610000092EC116A865471BFB329577897CD4940
75607	E4 9NB	GB	0101000020E610000073D9E89C9FE288BF30D7A20568CD4940
75608	E4 9RB	GB	0101000020E6100000E2CCAFE600C16C3F0116F9F543CE4940
75609	E4 9RJ	GB	0101000020E61000006DE4BA29E5B5823FDF6DDE3829CE4940
75610	E5	GB	0101000020E610000082ACA7565F5DA5BF882AFC19DEC64940
75611	E5 0AR	GB	0101000020E610000067B796C9703CA7BF2387889B53C74940
75612	E5 0DP	GB	0101000020E61000008577B988EFC4A4BF4DF910548DC64940
75613	E5 0EN	GB	0101000020E6100000041F8315A75AA3BF04E44BA8E0C64940
75614	E5 0JA	GB	0101000020E610000047AAEFFCA204A5BF034356B77AC64940
75615	E5 0JB	GB	0101000020E6100000EC2FBB270F0BA5BF0A11700855C64940
75616	E5 0PP	GB	0101000020E6100000D5CDC5DFF604A9BFC9022670EBC64940
75617	E5 0QP	GB	0101000020E610000065FD6662BA10ABBF7D24253D0CC74940
75618	E5 8AP	GB	0101000020E6100000EB387EA83462AEBFED612F14B0C74940
75619	E5 8NB	GB	0101000020E61000001631EC3026FDADBFF6B4C35F93C74940
75620	E5 8NN	GB	0101000020E610000091F0BDBF417BADBFC55565DF15C74940
75621	E5 8NZ	GB	0101000020E610000066321CCF6740ADBF8B8A389D64C74940
75622	E5 8RD	GB	0101000020E610000041481630815BAFBF54ABAFAE0AC84940
75623	E5 8RP	GB	0101000020E61000009BCAA2B08BA2AFBF06BCCCB051C84940
75624	E5 9BZ	GB	0101000020E6100000AE9E93DE37BEAEBFD2FF722D5AC84940
75625	E5 9JP	GB	0101000020E61000009B1F7F69519FACBF8159A148F7C74940
75626	E5 9NS	GB	0101000020E6100000A1BDFA78E8BBABBFEFACDD76A1C74940
75627	E5 9PT	GB	0101000020E61000000EF7915B936EABBF5D6C5A2904C84940
75628	E5 9PX	GB	0101000020E61000008B506C054D4BACBF56D28A6F28C84940
75629	E5 9QL	GB	0101000020E6100000880D164ED2FCA9BF92E9D0E979C74940
75630	E6 1AB	GB	0101000020E61000000B42791F4773A43FC843DFDDCAC44940
75631	E6 1AD	GB	0101000020E6100000A8E507AEF204A23F22A64412BDC44940
75632	E6 1PD	GB	0101000020E6100000BCCD1B278579A73F698EACFC32C44940
75633	E6 2HS	GB	0101000020E6100000DD0720B58993AB3F732B84D558C44940
75634	E6 2LA	GB	0101000020E61000003FFD67CD8FBFAC3FE5B512BA4BC44940
75635	E6 2RQ	GB	0101000020E61000009AB2D30FEA22AD3F2191B6F127C44940
75636	E6 3EZ	GB	0101000020E6100000DDED7A698A00A73F9F91088D60C34940
75637	E6 3PX	GB	0101000020E61000003BC43F6CE9D1B03F429946938BC54940
75638	E6 3RS	GB	0101000020E61000000B42791F4773AC3FF86F5E9CF8C24940
75639	E6 3RT	GB	0101000020E610000051F701486DE2AC3FC6BE64E3C1C24940
75640	E6 5RR	GB	0101000020E61000003FE42D573F36A93F6EA46C91B4C14940
75641	E6 5XJ	GB	0101000020E61000000726378AAC35AC3F27D9EA724AC24940
75642	E6 7FB	GB	0101000020E6100000EB8EC536A968B43FD5EAABAB02C14940
75643	E7	GB	0101000020E610000041102043C70E9A3F2BF9D85DA0C64940
75644	E7 0DD	GB	0101000020E61000001D76DF313CF6933FEBABAB02B5C64940
75645	E7 0HX	GB	0101000020E6100000C632FD12F1D6993F5BB1BFEC9EC64940
75646	E7 0JG	GB	0101000020E6100000BA6A9E23F25D9A3F6BD784B4C6C64940
75647	E7 0NF	GB	0101000020E610000008CA6DFB1EF5973FA22AA6D24FC64940
75648	E7 0NL	GB	0101000020E61000004F3BFC3559A39E3F724EECA17DC64940
75649	E7 0PX	GB	0101000020E610000098E0D40792779E3F2AC8CF46AEC54940
75650	E7 5LN	GB	0101000020E61000002F6D382C0DFC983F3A3FC571E0C54940
75651	E7 8AF	GB	0101000020E6100000C7F484251E50A63FF888981249C64940
75652	E7 8BS	GB	0101000020E6100000CD1E680586AC9E3F4B9352D0EDC54940
75653	E7 8EN	GB	0101000020E6100000E751F17F4754A03F4435255987C54940
75654	E7 9AP	GB	0101000020E6100000ABD0402C9B39943F8505F7031EC64940
75655	E7 9BY	GB	0101000020E6100000170FEF39B01C913FD49B51F355C64940
75656	E7 9HR	GB	0101000020E610000054FCDF1115AA8B3FE20511A969C54940
75657	E7 9JP	GB	0101000020E6100000BF0CC68844A1953F9E7939ECBEC54940
75658	E7 9LE	GB	0101000020E610000091B932A83638913FE46723D74DC54940
75659	E8	GB	0101000020E610000094675E0EBBEFB0BF3716140665C64940
75660	E8 1AD	GB	0101000020E610000072E0D5726726B0BF91B41B7DCCC54940
75661	E8 1BG	GB	0101000020E6100000B8019F1F4608AFBF2F336C94F5C54940
75662	E8 1BP	GB	0101000020E6100000AEB9A3FFE55AACBF2DD1596611C64940
75663	E8 1DE	GB	0101000020E6100000041DAD6A4947B1BFC1E61C3C13C64940
75664	E8 1EU	GB	0101000020E610000002F1BA7EC16EB0BF6BF12900C6C54940
75665	E8 1EY	GB	0101000020E61000006153E751F17FAFBF31EC3026FDC54940
75666	E8 1JH	GB	0101000020E610000090F8156BB8C8ADBFFCC6D79E59C64940
75667	E8 1LP	GB	0101000020E61000002BF702B34291AEBF252026E142C64940
75668	E8 1NE	GB	0101000020E610000080457EFD101BB0BFB6662B2FF9C54940
75669	E8 1NH	GB	0101000020E6100000C79BFC169D2CB1BF3D7C992842C64940
75670	E8 1NT	GB	0101000020E6100000541A31B3CF63B0BFF2237EC51AC64940
75671	E8 2EP	GB	0101000020E6100000E08442041C42B1BFE9D66B7A50C64940
75672	E8 2HN	GB	0101000020E61000003E7AC37DE4D6B0BF228AC91B60C64940
75673	E8 2JS	GB	0101000020E61000000F26C5C72764B3BF6ADFDC5F3DC64940
75674	E8 2PH	GB	0101000020E61000009F5912A0A696B1BF9DB81CAF40C64940
75675	E8 2RS	GB	0101000020E61000005FB4C70BE9F0B0BFF986C267EBC64940
75676	E8 3EY	GB	0101000020E6100000E57D1CCD9195AFBFAE669DF17DC54940
75677	E8 3PG	GB	0101000020E6100000C53D963E7441ADBFDA5548F949C54940
75678	E8 3PR	GB	0101000020E6100000C00303081F4AACBF356090F469C54940
75679	E8 3QP	GB	0101000020E610000008AA46AF0628ADBF624ED02687C54940
75680	E8 3QW	GB	0101000020E61000004ACE893DB48FADBFF6B4C35F93C54940
75681	E8 3RH	GB	0101000020E6100000B34291EEE714ACBF86AA984A3FC54940
75682	E8 3TH	GB	0101000020E6100000FB95CE876709B2BFD9B11188D7C54940
75683	E8 4HT	GB	0101000020E6100000E1B88C9B1A68B2BFAC3AAB05F6C44940
75684	E8 4LL	GB	0101000020E61000006B28B517D176B0BFE84EB0FF3AC54940
75685	E8 4LY	GB	0101000020E61000000D0055DCB8C5B0BFCC7A319413C54940
75686	E8 4NS	GB	0101000020E610000049BC3C9D2B4AB1BF7978CF81E5C44940
75687	E8 4PG	GB	0101000020E6100000182312859675AFBF15FE0C6FD6C44940
75688	E8 4PY	GB	0101000020E6100000F59D5F94A0BFB0BF9DF17D71A9C44940
75689	E9	GB	0101000020E61000002D776682E15CA3BF475A2A6F47C64940
75690	E9 5AH	GB	0101000020E61000004B2366F6798CA2BF8FDE701FB9C54940
75691	E9 5DB	GB	0101000020E610000003098A1F63EEA2BF28D53E1D8FC54940
75692	E9 5ER	GB	0101000020E610000055A3570394869ABF5FB2F1608BC54940
75693	E9 5HP	GB	0101000020E61000001A6A1492CCEA9DBF910DA48B4DC54940
75694	E9 6DX	GB	0101000020E6100000AB92C83EC8B2A8BF1F9E25C808C64940
75695	E9 6EH	GB	0101000020E61000004ED1915CFE43AABF04C93B8732C64940
75696	E9 6HA	GB	0101000020E6100000CE8B135FED28A6BF9279E40F06C64940
75697	E9 7AU	GB	0101000020E61000004BC8073D9B55A7BF3B191C25AFC44940
75698	E9 7DH	GB	0101000020E6100000003ACC971760A7BFD0ECBAB722C54940
75699	E9 7DP	GB	0101000020E610000017299485AFAFA5BF2AE109BDFEC44940
75700	E9 7JF	GB	0101000020E6100000F627F1B913ECA7BF7767EDB60BC54940
75701	E9 7NJ	GB	0101000020E610000099107349D576ABBFE4BA29E5B5C44940
75702	E9 7NP	GB	0101000020E610000055C2137AFD499CBF3E97A949F0C64940
75703	E9 7QL	GB	0101000020E6100000198D7C5EF1D4ABBF3EE8D9ACFAC44940
75704	E9 7SN	GB	0101000020E61000000262122EE411ACBF5778978BF8C44940
75705	EC1	GB	0101000020E61000007B32FFE89B34B9BFAA29C93A1CC34940
75706	EC1 1HQ	GB	0101000020E6100000DD7A4D0F0A4AB9BF0A4CA7751BC24940
75707	EC1A 2FG	GB	0101000020E6100000D4B837BF61A2B5BF4850FC1873C34940
75708	EC1A 4JA	GB	0101000020E61000006938656EBE11B9BFCC24EA059FC24940
75709	EC1A 7AJ	GB	0101000020E6100000C4060B2769FEB8BF49A297512CC34940
75710	EC1A 7HU	GB	0101000020E6100000626A4B1DE4F5B8BFB75ED38382C24940
75711	EC1M 5NP	GB	0101000020E610000079CA6ABA9EE8BABF655419C6DDC24940
75712	EC1M 5QP	GB	0101000020E610000074232C2AE274BABFD2E1218C9FC24940
75713	EC1M 5RS	GB	0101000020E610000009FF2268CC24BABF973C9E961FC24940
75714	EC1M 5UQ	GB	0101000020E6100000F8E12021CA17B8BFCC09DAE4F0C14940
75715	EC1M 6BY	GB	0101000020E61000002460747973B8BABF0B444FCAA4C24940
75716	EC1M 6HA	GB	0101000020E6100000AD889AE8F351BABF9C1551137DC24940
75717	EC1M 7AN	GB	0101000020E6100000DD2230D63730B9BF11001C7BF6C24940
75718	EC1N 2HT	GB	0101000020E610000028BB99D18F86BBBFFF3F4E9830C24940
75719	EC1N 2LX	GB	0101000020E610000062821ABE8575BBBFED0E290648C24940
75720	EC1N 2NS	GB	0101000020E6100000A0504F1F813FBCBFCEFBFF3861C24940
75721	EC1N 6SJ	GB	0101000020E6100000A053909F8D5CBBBF6E8B321B64C24940
75722	EC1N 8ER	GB	0101000020E61000002D7B12D89C83BBBF23BDA8DDAFC24940
75723	EC1R 0DP	GB	0101000020E6100000D46531B1F9B8BABF03EACDA8F9C24940
75724	EC1R 1UQ	GB	0101000020E6100000EF01BA2F67B6BBBFA18499B67FC34940
75725	EC1R 3BL	GB	0101000020E610000077DA1A118C83BBBFE8DA17D00BC34940
75726	EC1R 3ER	GB	0101000020E610000045B9347EE195BCBF392A37514BC34940
75727	EC1R 4TP	GB	0101000020E61000004E2A1A6B7F67BBBF8DD47B2AA7C34940
75728	EC1R 5XB	GB	0101000020E6100000E88711C2A38DBBBF8D9C853DEDC24940
75729	EC1V	GB	0101000020E6100000EF71A609DB4FBABFFE47A643A7C34940
75730	EC1V 0BP	GB	0101000020E61000001FDAC70A7E1BBABF5F28603B18C34940
75731	EC1V 0HB	GB	0101000020E61000009DBD33DAAA24BABF4165FCFB8CC34940
75732	EC1V 2NR	GB	0101000020E6100000944F8F6D1970B6BF340F60915FC34940
75733	EC1V 2PD	GB	0101000020E6100000AEF204C24EB1B6BFD0D4EB1681C34940
75734	EC1V 3SU	GB	0101000020E6100000D10836AE7FD7B7BF6DC83F3388C34940
75735	EC1V 4NN	GB	0101000020E61000002EE411DC48D9BABFA2427573F1C34940
75736	EC1V 7NB	GB	0101000020E610000092B245D26EF4B9BFAC72A1F2AFC34940
75737	EC1V 8BB	GB	0101000020E6100000FF3F4E98309AB9BF91291F82AAC34940
75738	EC1V 8BP	GB	0101000020E6100000D7F6764B72C0B6BF11C4793881C34940
75739	EC1V 9HL	GB	0101000020E6100000EACDA8F92AF9B8BF454772F90FC34940
75740	EC1Y 2BQ	GB	0101000020E6100000DFFE5C34643CB6BFAB06616EF7C24940
75741	EC1Y 8PQ	GB	0101000020E6100000CCD24ECDE506B7BF90F7AA9509C34940
75742	EC1Y 8PW	GB	0101000020E6100000726A6798DA52B7BFD482177D05C34940
75743	EC1Y 8RD	GB	0101000020E61000006EFAB31F2922B3BFD4D17135B2C34940
75744	EC1Y 8RQ	GB	0101000020E6100000D07CCEDDAE97B6BFF27D71A94AC34940
75745	EC1Y 8YY	GB	0101000020E6100000A0C03BF9F4D8B6BF6D567DAEB6C24940
75746	EC1Y 8YZ	GB	0101000020E610000051F52B9D0FCFB6BF2FC214E5D2C24940
75747	EC2	GB	0101000020E61000009EEBFB709010B5BFE7C6F48425C24940
75748	EC2A 2AL	GB	0101000020E6100000B7B75B920376B5BFCEC64ACCB3C24940
75749	EC2A 3AY	GB	0101000020E6100000D2C6116BF129B4BF2DEA93DC61C34940
75750	EC2A 3EH	GB	0101000020E6100000D78A36C7B94DB4BF55336B2920C34940
75751	EC2A 3PB	GB	0101000020E6100000E22021CA17B4B4BFE146CA1649C34940
75752	EC2A 3PY	GB	0101000020E610000059A31EA2D11DB4BF8D9B1A683EC34940
75753	EC2A 3QP	GB	0101000020E6100000622F14B01D8CB4BF86014BAE62C34940
75754	EC2A 4BX	GB	0101000020E6100000CCEEC9C342ADB5BF2BF86D88F1C24940
75755	EC2M 3XW	GB	0101000020E6100000730F09DFFB1BB4BF9C6C0377A0C24940
75756	EC2M 4LN	GB	0101000020E6100000427C60C77F81B4BF373465A71FC24940
75757	EC2M 4PL	GB	0101000020E610000033164D672783B3BF19AC38D55AC24940
75758	EC2M 7BT	GB	0101000020E61000002EE3A6069ACFB5BF8A3C49BA66C24940
75759	EC2M 7DH	GB	0101000020E61000003EB2B96A9E23B6BFA1478C9E5BC24940
75760	EC2M 7PY	GB	0101000020E61000007C9BFEEC478AB4BF6A87BF266BC24940
75761	EC2M 7UH	GB	0101000020E6100000144031B2648EB5BFEE76BD3445C24940
75762	EC2N 1FP	GB	0101000020E6100000FCFECD8B135FB5BFFF976BD102C24940
75763	EC2N 1PH	GB	0101000020E61000004E8061F9F36DB5BF09DE904605C24940
75764	EC2R 8AB	GB	0101000020E6100000F9F6AE415F7AB7BF45B9347EE1C14940
75765	EC2R 8AD	GB	0101000020E610000031CD74AF93FAB6BF6DC7D45DD9C14940
75766	EC2R 8AH	GB	0101000020E6100000310BED9C6681B6BF36EA211ADDC14940
75767	EC2V 5BT	GB	0101000020E61000007369FCC22B49B6BF33A5F5B704C24940
75768	EC2V 6EE	GB	0101000020E610000035ED629AE95EB7BFFD4D2844C0C14940
75769	EC2Y 8AX	GB	0101000020E6100000C1525DC0CB0CB7BFD671FC5069C24940
75770	EC2Y 8DH	GB	0101000020E6100000D7C1C1DEC490B8BF8E226B0DA5C24940
75771	EC2Y 9AE	GB	0101000020E6100000EB1F4432E4D8B6BF410B09185DC24940
75772	EC3	GB	0101000020E6100000721AA20A7F86B3BF008DD2A57FC14940
75773	EC3 4AJ	GB	0101000020E6100000E0A0BDFA78E8B3BF22FB20CB82C14940
75774	EC3A 8BD	GB	0101000020E6100000C53C2B69C537B4BF2B1895D409C24940
75775	EC3A 8NA	GB	0101000020E61000003F1EFAEE5696B4BFB33F506EDBC14940
75776	EC3M 2RY	GB	0101000020E61000006B494739984DB4BF7782FDD7B9C14940
75777	EC3M 4HH	GB	0101000020E6100000170E84640113B4BFAC55BB26A4C14940
75778	EC3M 5AT	GB	0101000020E610000018CC5F217365B4BFC07971E2ABC14940
75779	EC3M 7JJ	GB	0101000020E6100000B857E6ADBA0EB5BFF697DD9387C14940
75780	EC3N 1AL	GB	0101000020E6100000C11BD2A8C0C9B2BF1BA19FA9D7C14940
75781	EC3N 1JJ	GB	0101000020E6100000378DEDB5A0F7B2BFE7ABE46377C14940
75782	EC3N 4AB	GB	0101000020E61000001EDFDE35E84BB3BF09151C5E10C14940
75783	EC3N 4DH	GB	0101000020E610000022FB20CB8289B3BFD1B1834A5CC14940
75784	EC3N 4HH	GB	0101000020E610000098512CB7B41AB2BF2785798F33C14940
75785	EC3R 7QR	GB	0101000020E61000005778978BF84EB4BFE9F010C64FC14940
75786	EC3R 8AJ	GB	0101000020E61000007D23BA675DA3B5BF4A95287B4BC14940
75787	EC3V 0AD	GB	0101000020E6100000B58B69A67B9DB4BF5C9198A086C14940
75788	EC3V 1LR	GB	0101000020E61000006BF294D5743DB5BF1DC9E53FA4C14940
75789	EC3V 3ND	GB	0101000020E6100000581EA4A7C821B6BFB11875ADBDC14940
75790	EC3V 4QT	GB	0101000020E61000008121AB5B3D27B5BF9E62D520CCC14940
75791	EC3V 9DS	GB	0101000020E610000081EB8A19E1EDB5BF1CB28174B1C14940
75792	EC4	GB	0101000020E61000001D007157AF22BBBFB24CBF44BCC14940
75793	EC4A 2BU	GB	0101000020E610000063997E8978EBB8BF90BB085394C14940
75794	EC4A 2PP	GB	0101000020E6100000034015376E31BBBFBC067DE9EDC14940
75795	EC4A 3DQ	GB	0101000020E6100000EE27637C98BDBCBFB29DEFA7C6C14940
75796	EC4A 4AS	GB	0101000020E6100000DB87BCE5EAC7BABFF9A067B3EAC14940
75797	EC4A 4TR	GB	0101000020E610000089B2B794F3C5BABF295FD04202C24940
75798	EC4M 7DX	GB	0101000020E610000091477023658BB8BF04ADC090D5C14940
75799	EC4N 4SJ	GB	0101000020E610000091B8C7D2872EB8BFE9D2BF2495C14940
75800	EC4N 6AP	GB	0101000020E6100000B9347EE19524B7BFD3307C444CC14940
75801	EC4R 0HH	GB	0101000020E61000007BF486FBC8ADB9BF76E107E753C14940
75802	EC4R 9AD	GB	0101000020E6100000F240649126DEB5BF7CEF6FD05EC14940
75803	EC4V 3PR	GB	0101000020E6100000A5F3E159828CB8BF0FEECEDA6DC14940
75804	EC4V 3PS	GB	0101000020E61000002A7288B83995B8BF16F6B4C35FC14940
75805	EC4V 4DY	GB	0101000020E6100000DD239BABE639BABF554FE61F7DC14940
75806	EC4V 5EX	GB	0101000020E610000038BBB54C86E3B9BFD02B9E7AA4C14940
75807	EC4Y 7AS	GB	0101000020E61000006DE2E47E87A2BCBF070951BEA0C14940
75808	EC4Y 8	GB	0101000020E6100000FF06EDD5C743BBBF609335EA21C24940
75809	EC4Y 8JX	GB	0101000020E61000009DBAF2599E07BBBF9CDD5A26C3C14940
75810	EH1	GB	0101000020E6100000A5F3E159824C09C0485167EE21F94B40
75811	EH1 1BB	GB	0101000020E61000009C1551137D7E09C01AA721AAF0F94B40
75812	EH1 1BS	GB	0101000020E61000009C189293897B09C04F9143C4CDF94B40
75813	EH1 1EZ	GB	0101000020E6100000C8D11C59F98509C0F226BF4527F94B40
75814	EH1 1PT	GB	0101000020E610000030833122518809C0815A0C1EA6F94B40
75815	EH1 2BW	GB	0101000020E610000097A8DE1AD8AA09C00FBA84436FF94B40
75816	EH1 2EU	GB	0101000020E61000004FAF946588A309C0EEED96E480F94B40
75817	EH1 2PF	GB	0101000020E6100000D7169E978A8D09C0F9A1D28899F94B40
75818	EH1 3AA	GB	0101000020E6100000008BFCFA217609C087C3D2C08FFA4B40
75819	EH1 3AT	GB	0101000020E6100000FED30D14784709C020F0C000C2FB4B40
75820	EH1 3AY	GB	0101000020E6100000CE8AA8893E7F09C08FC536A968FA4B40
75821	EH10	GB	0101000020E61000000B613596B0B609C0323ECC5EB6F54B40
75822	EH10 4	GB	0101000020E6100000D1967329AEAA09C0B7088CF50DF84B40
75823	EH10 4AA	GB	0101000020E610000090F8156BB8A809C0B0CA85CABFF64B40
75824	EH10 4DW	GB	0101000020E6100000776A2E3718AA09C0E36DA5D766F74B40
75825	EH10 4DZ	GB	0101000020E61000005A7F4B00FEA909C0A1496249B9F74B40
75826	EH10 4EW	GB	0101000020E6100000177E703E75AC09C038F4160FEFF74B40
75827	EH10 4EX	GB	0101000020E61000009A5DF75624A609C073D53C47E4F74B40
75828	EH10 4JL	GB	0101000020E61000005859DB148FAB09C0D595CFF23CF84B40
75829	EH10 4JW	GB	0101000020E6100000CA17B49080B109C0C5E2378595F84B40
75830	EH10 4NT	GB	0101000020E61000005FEE93A300B109C0967840D994F74B40
75831	EH10 4PE	GB	0101000020E6100000F9307BD976BA09C0A5D7666325F84B40
75832	EH10 4SW	GB	0101000020E61000004D8578245E9E09C00664AF777FF64B40
75833	EH10 5AB	GB	0101000020E6100000C190D5AD9EB309C038D89B1892F74B40
75834	EH10 5AG	GB	0101000020E610000093196F2BBDB609C069A7E67283F74B40
75835	EH10 5AL	GB	0101000020E6100000BA826DC4939D09C0959BA8A5B9F74B40
75836	EH10 5EG	GB	0101000020E6100000EFCB99ED0ABD09C07B9FAA4203F74B40
75837	EH10 5HU	GB	0101000020E61000005C0531D0B5AF09C00F2BDCF291F64B40
75838	EH10 5LZ	GB	0101000020E6100000DB368C82E0B109C0FAB660A92EF64B40
75839	EH10 5QJ	GB	0101000020E6100000581CCEFC6AAE09C0075F984C15F64B40
75840	EH10 5TX	GB	0101000020E61000008B89CDC7B5C109C07A6D365662F64B40
75841	EH10 6AA	GB	0101000020E61000005B7C0A80F1AC09C0B2101D0247F64B40
75842	EH10 6BH	GB	0101000020E61000006CD102B4ADA609C0E606431D56F64B40
75843	EH10 6DP	GB	0101000020E61000002D077AA86DA309C0C0CFB87020F64B40
75844	EH10 7AQ	GB	0101000020E61000001D554D10759F09C01E6CB1DB67F34B40
75845	EH10 7AY	GB	0101000020E6100000B5503239B5B309C0BE86E0B88CF34B40
75846	EH10 7BE	GB	0101000020E6100000B61490F63FA009C0048D9944BDF44B40
75847	EH10 7DS	GB	0101000020E6100000AA29C93A1CBD09C0B554DE8E70F24B40
75848	EH10 7HY	GB	0101000020E6100000B000A60C1C9009C01C23D923D4F64B40
75849	EH11	GB	0101000020E61000007366BB421F2C0AC02FE065868DF84B40
75850	EH11 1HU	GB	0101000020E61000009EF0129CFAC009C0D5EDEC2B0FF84B40
75851	EH11 1LT	GB	0101000020E61000006A334E4354C109C0F99FFCDD3BF84B40
75852	EH11 1NR	GB	0101000020E6100000087767EDB6CB09C08237A45181F74B40
75853	EH11 1QL	GB	0101000020E61000003E9468C9E36909C0E4839ECDAAF94B40
75854	EH11 1UN	GB	0101000020E6100000FA7FD59123DD09C02FA2ED98BAF74B40
75855	EH11 2AA	GB	0101000020E610000047B071FDBBBE09C0D7DEA7AAD0F84B40
75856	EH11 2AG	GB	0101000020E610000074CFBA46CBC109C0AC6F6072A3F84B40
75857	EH11 2AN	GB	0101000020E6100000A79201A08ABB09C0ADDD76A1B9F84B40
75858	EH11 2BR	GB	0101000020E61000001FF296AB1FBB09C0A94D9CDCEFF84B40
75859	EH11 2JL	GB	0101000020E61000004EB7EC10FFD009C05951836918F84B40
75860	EH11 3AA	GB	0101000020E6100000D3C1FA3F87F909C0506F46CD57F74B40
75861	EH11 3AF	GB	0101000020E610000060E97C7896000AC03EB324404DF74B40
75862	EH11 3DE	GB	0101000020E61000000211E2CAD9FB09C0630B410E4AF84B40
75863	EH11 3PP	GB	0101000020E61000007094BC3AC7200AC0E02A4F20ECF64B40
75864	EH11 4AA	GB	0101000020E61000004EB51666A15D0AC01A89D00836F64B40
75865	EH11 4LU	GB	0101000020E61000001C2444F982560AC0B7CF2A33A5F54B40
75866	EH11 4NB	GB	0101000020E6100000B6A0F7C610600AC0E1B4E0455FF54B40
75867	EH11 4QH	GB	0101000020E610000021E9D32AFA430AC098A59D9ACBF54B40
75868	EH11 4QJ	GB	0101000020E61000004B02D4D4B2350AC05D8940F50FF64B40
75869	EH11 4RZ	GB	0101000020E6100000C190D5AD9E330AC0E7A90EB919F64B40
75870	EH12	GB	0101000020E610000042B456B4390E0AC0E8F692C668F94B40
75871	EH12 0AA	GB	0101000020E610000074B33F506E9B0AC0DAACFA5C6DF94B40
75872	EH12 5AA	GB	0101000020E610000062A1D634EFB809C0BEA4315A47F94B40
75873	EH12 5EA	GB	0101000020E610000069739CDB84BB09C0FDBD141E34F94B40
75874	EH12 5EG	GB	0101000020E61000009335EA211ABD09C0AD84EE9238F94B40
75875	EH12 5PL	GB	0101000020E610000050A912656FE909C02E03CE52B2F84B40
75876	EH12 5PN	GB	0101000020E6100000683D7C9928E209C040F9BB77D4F84B40
75877	EH12 6AA	GB	0101000020E61000000FB56D1805E109C043E55FCB2BF94B40
75878	EH12 6AQ	GB	0101000020E61000001FA0FB7266DB09C0FED30D1478F94B40
75879	EH12 6AX	GB	0101000020E6100000F9DC09F65FE709C034A1496249F94B40
75880	EH12 6BG	GB	0101000020E61000000B7DB08C0DDD09C00DFAD2DB9FF94B40
75881	EH12 6NN	GB	0101000020E6100000D714C8EC2C3A0AC0952A51F696F84B40
75882	EH12 7AA	GB	0101000020E6100000C11DA8531E3D0AC0C24CDBBFB2F84B40
75883	EH12 7AF	GB	0101000020E610000052F355F2B13B0AC0193735D07CF84B40
75884	EH12 7EY	GB	0101000020E610000013EE9579AB2E0AC05C1C959BA8F74B40
75885	EH12 7LE	GB	0101000020E61000002D6002B7EE460AC0B98C9B1A68F84B40
75886	EH12 7PR	GB	0101000020E610000087A4164A26470AC0CF9F36AAD3F74B40
75887	EH12 7TY	GB	0101000020E61000007FDAA84E07520AC0E7FF55478EF84B40
75888	EH12 7UQ	GB	0101000020E6100000C0232A5437570AC05B09DD2571F84B40
75889	EH12 8	GB	0101000020E61000007364E597C1780AC0486FB88FDCF84B40
75890	EH12 8AP	GB	0101000020E6100000B05417F032430AC0B70C384BC9F84B40
75891	EH12 8AW	GB	0101000020E6100000C8940F41D5480AC08333F8FBC5F84B40
75892	EH12 8EB	GB	0101000020E6100000512D228AC95B0AC06B9A779CA2F94B40
75893	EH12 8ER	GB	0101000020E610000070D234289A670AC0255987A3ABF84B40
75894	EH12 8JA	GB	0101000020E61000009D7FBBECD77D0AC047AF06280DF94B40
75895	EH12 8RL	GB	0101000020E6100000F0FD0DDAAB4F0AC02E5393E00DF94B40
75896	EH12 8RS	GB	0101000020E61000009B560A815C620AC0B83A00E2AEF84B40
75897	EH12 8ST	GB	0101000020E6100000E08096AE605B0AC07E5704FF5BF94B40
75898	EH12 8UA	GB	0101000020E6100000D89DEE3CF17C0AC017D9CEF753F94B40
75899	EH12 9AA	GB	0101000020E61000007764AC36FF4F0AC099D36531B1F74B40
75900	EH12 9JE	GB	0101000020E6100000F3C98AE1EA800AC0A8FFACF9F1F74B40
75901	EH13 0BW	GB	0101000020E61000009352D0ED252D0AC0E564E25641F44B40
75902	EH13 0DW	GB	0101000020E61000004F0647C9AB130AC0F9BEB854A5F34B40
75903	EH13 0NA	GB	0101000020E610000069AD68739CDB09C011C30E63D2F74B40
75904	EH13 0PA	GB	0101000020E610000003EFE4D3631B0AC0F99D2633DEF24B40
75905	EH13 0QB	GB	0101000020E6100000B6BC72BD6D060AC0F2EB87D860F34B40
75906	EH13 9AB	GB	0101000020E6100000572250FD83E809C021787C7BD7F44B40
75907	EH13 9BX	GB	0101000020E610000024456458C5DB09C05917B7D100F44B40
75908	EH13 9BY	GB	0101000020E610000056D5CBEF34D909C050C422861DF44B40
75909	EH13 9EW	GB	0101000020E6100000EB7420EBA9D509C0CE6E2D93E1F44B40
75910	EH13 9NQ	GB	0101000020E610000060E7A6CD38CD09C064AF777FBCF34B40
75911	EH13 9PP	GB	0101000020E610000054A86E2EFED609C0E57CB1F7E2F34B40
75912	EH13 9QR	GB	0101000020E6100000C005D9B27CDD09C091F0BDBF41F34B40
75913	EH14	GB	0101000020E610000032AA0CE36E100AC04371C79BFCF44B40
75914	EH14 1	GB	0101000020E6100000520E661360F809C09D2D20B41EF64B40
75915	EH14 1BX	GB	0101000020E61000009BAA7B6473F509C02332ACE28DF64B40
75916	EH14 1LH	GB	0101000020E6100000CAC4AD8218E809C0E54526E0D7F64B40
75917	EH14 1PA	GB	0101000020E6100000CC79C6BE64E309C012DC48D922F74B40
75918	EH14 1RZ	GB	0101000020E610000066F7E461A1F609C0B9382A3751F74B40
75919	EH14 1SZ	GB	0101000020E610000003CE52B29C040AC09F58A7CAF7F64B40
75920	EH14 1TQ	GB	0101000020E6100000836BEEE87FF909C084F4143944F64B40
75921	EH14 2LL	GB	0101000020E6100000A609DB4FC6180AC032CC09DAE4F44B40
75922	EH14 3AE	GB	0101000020E61000002EA9DA6E822F0AC06D73637AC2F44B40
75923	EH14 3BY	GB	0101000020E61000008507CDAE7B4B0AC0AF0B3F389FF44B40
75924	EH14 4AA	GB	0101000020E6100000BE69FAEC808B0AC05186AA984AF34B40
75925	EH14 4AQ	GB	0101000020E6100000CD21A98592890AC073B9C15087F54B40
75926	EH14 4AR	GB	0101000020E6100000E8BCC62E517D0AC0B37DC85BAEF44B40
75927	EH14 4AS	GB	0101000020E6100000B5C01E13298D0AC09A3FA6B569F44B40
75928	EH14 5AA	GB	0101000020E6100000CBA145B6F37D0AC0E06932E36DF34B40
75929	EH14 5BE	GB	0101000020E6100000D06053E751310AC067F2CD3637F44B40
75930	EH14 5HR	GB	0101000020E6100000A2F14410E7810AC0DEAB5626FCF24B40
75931	EH14 5HW	GB	0101000020E6100000A7785C548B680AC0ACC5A70018F34B40
75932	EH14 5NX	GB	0101000020E61000004FE8F527F1790AC015ADDC0BCCF24B40
75933	EH14 5TH	GB	0101000020E61000003D7E6FD39F9D0AC0F5BEF1B567F24B40
75934	EH14 6AA	GB	0101000020E610000068588CBAD65E0AC062F8889812F34B40
75935	EH14 6AG	GB	0101000020E6100000384BC972126A0AC07AC4E8B985F24B40
75936	EH14 6AT	GB	0101000020E6100000679E5C5320730AC00A2B155454F14B40
75937	EH14 7AF	GB	0101000020E6100000548CF337A1B00AC05F7F129F3BF14B40
75938	EH14 7AS	GB	0101000020E6100000B8CD548847820AC0221CB3EC49F04B40
75939	EH14 7BA	GB	0101000020E61000009561DC0DA2B50AC0AE7FD767CEF04B40
75940	EH14 7DL	GB	0101000020E6100000821E6ADB30CA0AC09F1C058882F14B40
75941	EH14 7EN	GB	0101000020E6100000AAEE91CD55B30AC064744012F6EF4B40
75942	EH14 7HE	GB	0101000020E6100000705D3123BCBD0AC0DB4DF04DD3EF4B40
75943	EH14 7HS	GB	0101000020E61000006C26DF6C73C30AC05B44149337F04B40
75944	EH14 7NH	GB	0101000020E61000008063CF9ECBB40AC0C79E3D97A9F14B40
75945	EH15 1AF	GB	0101000020E6100000ECDD1FEF55EB08C06BD3D85E0BFA4B40
75946	EH15 1AT	GB	0101000020E61000002FFB75A73BEF08C0FFAECF9CF5F94B40
75947	EH15 1BD	GB	0101000020E6100000D61D8B6D52F108C079AF5A99F0F94B40
75948	EH15 1JD	GB	0101000020E6100000DFFC868906E908C0F20C1AFA27FA4B40
75949	EH15 1LL	GB	0101000020E610000076FA415DA4F008C0F9A1D28899F94B40
75950	EH15 1NB	GB	0101000020E61000000322C495B3F708C0BE86E0B88CF94B40
75951	EH15 2BP	GB	0101000020E6100000A1832EE1D0DB08C094F8DC09F6F94B40
75952	EH15 2BU	GB	0101000020E610000059FB3BDBA3D708C03ACAC16C02FA4B40
75953	EH15 2ES	GB	0101000020E6100000D87F9D9B36C308C08D7DC9C683F94B40
75954	EH15 2HU	GB	0101000020E6100000DDB3AED172C008C02D42B11534F94B40
75955	EH15 2ND	GB	0101000020E61000000D17B9A7ABBB08C07FDDE9CE13F94B40
75956	EH15 2QR	GB	0101000020E6100000D87DC7F0D8CF08C04A7F2F8507F94B40
75957	EH15 3AA	GB	0101000020E610000012F5824F73D208C05610035DFBF84B40
75958	EH16	GB	0101000020E610000048DFA46950F408C08E3D7B2E53F74B40
75959	EH16 5BS	GB	0101000020E61000001442075DC26109C0E8F4BC1B0BF84B40
75960	EH16 5JN	GB	0101000020E6100000594C6C3EAE4D09C075E61E12BEF74B40
75961	EH16 5JY	GB	0101000020E610000040A20914B14809C0473A03232FF74B40
75962	EH16 5QP	GB	0101000020E6100000B7B41A12F75809C06D75392520F64B40
75963	EH16 5XG	GB	0101000020E61000000C906802454C09C0492EFF21FDF64B40
75964	EH16 6AA	GB	0101000020E61000008104C58F315709C0D235936FB6F54B40
75965	EH16 6JZ	GB	0101000020E61000009C1A683EE74E09C0821C9430D3F44B40
75966	EH16 6LY	GB	0101000020E61000004E7ADFF8DA5309C001892650C4F44B40
75967	EH16 6UZ	GB	0101000020E61000005DDE1CAED55E09C00344C18C29F44B40
75968	EH17	GB	0101000020E6100000356090F469D508C02AE109BDFEF64B40
75969	EH17 7DP	GB	0101000020E6100000DB87BCE5EA0709C0C89A9141EEF44B40
75970	EH17 7NP	GB	0101000020E6100000732A1900AA1809C0DAACFA5C6DF54B40
75971	EH17 7RP	GB	0101000020E61000008E3A3AAE461609C09B3C65355DF54B40
75972	EH17 7TA	GB	0101000020E6100000F33B4D66BC2D09C06090F46915F54B40
75973	EH17 8AB	GB	0101000020E6100000FFAF3A72A45309C0E84EB0FF3AF34B40
75974	EH17 8QJ	GB	0101000020E6100000B39AAE27BA0E09C0F7ADD689CBF34B40
75975	EH17 8RR	GB	0101000020E6100000A2EE0390DA8409C0F52F49658AF94B40
75976	EH17 8RT	GB	0101000020E6100000757632384A5E09C08BAA5FE97CF24B40
75977	EH18 1	GB	0101000020E6100000FA4509FA0BDD08C0A0A4C00298F04B40
75978	EH18 1HX	GB	0101000020E6100000986DA7AD110109C03F52448655F04B40
75979	EH18 1JT	GB	0101000020E6100000C58EC6A17E1709C0FDD98F1491EF4B40
75980	EH19 2DA	GB	0101000020E6100000B81E85EB51D808C0D2E3F736FDEF4B40
75981	EH19 2DH	GB	0101000020E61000007AC8940F41D508C09204E10A28F04B40
75982	EH19 3BD	GB	0101000020E61000002D3F709527D008C0BCE9961DE2EF4B40
75983	EH19 3BN	GB	0101000020E61000005D876A4AB2CE08C0609335EA21F04B40
75984	EH19 3QF	GB	0101000020E61000005E2A36E675C408C080D8D2A3A9F04B40
75985	EH2 1AF	GB	0101000020E61000000053060E688909C01F2FA4C343FA4B40
75986	EH2 2AA	GB	0101000020E61000007FDC7EF9648509C0035B25581CFA4B40
75987	EH2 3DF	GB	0101000020E6100000C76647AAEF9C09C07DD0B359F5F94B40
75988	EH2 4LS	GB	0101000020E6100000BF982D5915A109C03D0FEECEDAF94B40
75989	EH2 4SD	GB	0101000020E610000020240B98C0AD09C0A911FA997AF94B40
75990	EH20	GB	0101000020E610000029047289232F09C0C2137AFD49F04B40
75991	EH20 9	GB	0101000020E610000038A45181932D09C0A81B28F04EF04B40
75992	EH21 6BQ	GB	0101000020E6100000327216F6B48308C00F2A711DE3F84B40
75993	EH21 6LB	GB	0101000020E6100000C9E88024EC7B08C013F3ACA415F94B40
75994	EH21 6PL	GB	0101000020E610000003CC7C073F7108C0DFE00B93A9F84B40
75995	EH21 6RY	GB	0101000020E61000000D5531957EA208C04CA8E0F082F84B40
75996	EH21 6XB	GB	0101000020E61000007C5F5CAAD27608C02711E15F04F74B40
75997	EH21 7AG	GB	0101000020E61000008EACFC32186308C06478EC67B1F84B40
75998	EH21 7PL	GB	0101000020E61000008D800A47904A08C0C05E61C1FDF84B40
75999	EH21 7TD	GB	0101000020E6100000CFD8976C3C5808C02C0C91D3D7F74B40
76000	EH21 7TE	GB	0101000020E6100000BA111615715A08C0B58B69A67BF74B40
76001	EH21 8RE	GB	0101000020E6100000FB3F87F9F28208C022FE614B8FF64B40
76002	EH22	GB	0101000020E610000088484DBB988608C09A0B5C1E6BF44B40
76003	EH22 1RE	GB	0101000020E6100000361E6CB1DBE708C05A828C800AF54B40
76004	EH22 2AF	GB	0101000020E6100000F4C29D0B237D08C04205871744F24B40
76005	EH22 3AA	GB	0101000020E6100000EF3A1BF2CF8C08C05B5B785E2AF24B40
76006	EH22 3JX	GB	0101000020E610000002B9C49107A208C02041F163CCEF4B40
76007	EH22 3LS	GB	0101000020E6100000CB9E0436E7A008C02046088F36F04B40
76008	EH22 4NR	GB	0101000020E6100000F5BD86E0B88C08C05610035DFBEE4B40
76009	EH22 4PF	GB	0101000020E610000064062AE3DF8708C0492F6AF7ABEE4B40
76010	EH22 5DG	GB	0101000020E610000014419C87135808C063B48EAA26F04B40
76011	EH22 5RZ	GB	0101000020E6100000516859F78F6508C0C8CD70033EEF4B40
76012	EH23	GB	0101000020E61000005437177FDB1308C068B27F9E06F84B40
76013	EH23 4AA	GB	0101000020E61000001C08C902267008C043FE99417CEC4B40
76014	EH23 4LZ	GB	0101000020E6100000C5C6BC8E388408C08237A45181ED4B40
76015	EH23 4NL	GB	0101000020E61000005FD218ADA34A08C0AC53E57B46EC4B40
76016	EH23 4QG	GB	0101000020E6100000FE0DDAAB8F4708C05B94D92093EA4B40
76017	EH23 4TS	GB	0101000020E610000013B70A62A06B08C0C500892650EC4B40
76018	EH23 9AG	GB	0101000020E6100000ACAC6D8AC70508C05532005471ED4B40
76019	EH24 9AG	GB	0101000020E6100000067FBF982D1909C0BDC282FB01ED4B40
76020	EH25	GB	0101000020E6100000705CC64D0D7409C05186AA984AEF4B40
76021	EH25 9PT	GB	0101000020E610000065C22FF5F34609C0F3AACE6A81ED4B40
76022	EH25 9SZ	GB	0101000020E6100000D2730B5D898009C02026E1421EEF4B40
76023	EH26 0BJ	GB	0101000020E6100000795C548B88C209C0008DD2A57FEB4B40
76024	EH26 0EE	GB	0101000020E61000002A53CC41D0D109C08461C092ABEA4B40
76025	EH26 0PE	GB	0101000020E6100000EC3026FDBDB409C020274C18CDEE4B40
76026	EH26 0PW	GB	0101000020E610000068EC4B361ECC09C09E29745E63ED4B40
76027	EH26 0PZ	GB	0101000020E6100000CE52B29C849209C02D5DC136E2ED4B40
76028	EH26 0RD	GB	0101000020E610000015CAC2D7D79A09C06C223317B8EC4B40
76029	EH26 8AA	GB	0101000020E610000077F69507E9C909C090DD054A0AEA4B40
76030	EH26 8HY	GB	0101000020E610000054E3A59BC4C009C092CA147310EA4B40
76031	EH26 8NS	GB	0101000020E61000000C5872158BBF09C0210725CCB4E94B40
76032	EH26 8PG	GB	0101000020E6100000661536035C9009C0823AE5D18DEA4B40
76033	EH26 9BZ	GB	0101000020E6100000B7ED7BD45FCF09C0CD5A0A48FBE94B40
76034	EH26 9DU	GB	0101000020E6100000FF93BF7B47CD09C071AFCC5B75E94B40
76035	EH26 9LB	GB	0101000020E6100000734BAB21712F0AC0BF9B6ED921EA4B40
76036	EH26 9LZ	GB	0101000020E6100000F418E59997830AC04834812216E74B40
76037	EH26 9NF	GB	0101000020E6100000A565A4DE53B90AC05053CBD6FAE44B40
76038	EH26 9NL	GB	0101000020E61000005B5F24B4E5BC0AC027C286A757E44B40
76039	EH27 8BE	GB	0101000020E61000008176871403440BC0D481ACA756F34B40
76040	EH27 8DH	GB	0101000020E610000005172B6A30AD0BC006465ED6C4EA4B40
76041	EH28 8NU	GB	0101000020E61000002C2D23F59ECA0AC08CDCD3D51DF54B40
76042	EH28 8RA	GB	0101000020E61000007BA180ED60040BC0CFBBB1A030F64B40
76043	EH29 9EH	GB	0101000020E61000000B43E4F4F5FC0AC032384A5E9DFB4B40
76044	EH3	GB	0101000020E6100000E370E65773A009C041D3122BA3F94B40
76045	EH3 5AA	GB	0101000020E6100000392861A6ED9F09C05D5320B3B3FA4B40
76046	EH3 5AG	GB	0101000020E6100000EBE3A1EF6EA509C0C971A774B0FA4B40
76047	EH3 5BE	GB	0101000020E61000005BEF37DA71A309C0E292E34EE9FA4B40
76048	EH3 5BL	GB	0101000020E61000007974232C2AA209C027C0B0FCF9FA4B40
76049	EH3 5DS	GB	0101000020E6100000D33252EFA99C09C083F8C08EFFFA4B40
76050	EH3 5DW	GB	0101000020E6100000C9AB730CC89E09C0C66CC9AA08FB4B40
76051	EH3 5DZ	GB	0101000020E610000078EE3D5C729C09C083328D2617FB4B40
76052	EH3 5EU	GB	0101000020E61000006ABE4A3E769709C00CCEE0EF17FB4B40
76053	EH3 5JE	GB	0101000020E61000008C2B2E8ECAAD09C08FFD2C9622FB4B40
76054	EH3 5LR	GB	0101000020E6100000D3A1D3F36EAC09C092239D8191FB4B40
76055	EH3 5LS	GB	0101000020E6100000EEB089CC5CA009C0F6B4C35F93FB4B40
76056	EH3 5NU	GB	0101000020E610000048A7AE7C96A709C0CF2EDFFAB0F84B40
76057	EH3 5PL	GB	0101000020E6100000791F477364A509C0EDD45C6E30FC4B40
76058	EH3 5PS	GB	0101000020E6100000A27BD6355AAE09C0EA211ADD41FC4B40
76059	EH3 6AA	GB	0101000020E6100000C7A17E17B6A609C06BF0BE2A17FA4B40
76060	EH3 6AP	GB	0101000020E610000089F02F82C6AC09C03430F2B226FA4B40
76061	EH3 6DS	GB	0101000020E6100000F986C267EBA009C04FB2D5E594FA4B40
76062	EH3 6DY	GB	0101000020E6100000F51263997EA909C0C4060B2769FA4B40
76063	EH3 6PX	GB	0101000020E6100000232F6B62818F09C03485CE6BECFA4B40
76064	EH3 6QE	GB	0101000020E610000028B9C326329309C0DAC69FA86CFA4B40
76065	EH3 6RB	GB	0101000020E610000015562AA8A89A09C0B64DF1B8A8FA4B40
76066	EH3 6SH	GB	0101000020E6100000700B96EA029E09C084D6C39789FA4B40
76067	EH3 6SZ	GB	0101000020E61000002A8C2D0439A809C00D5531957EFA4B40
76068	EH3 7DY	GB	0101000020E610000067EF8CB62AA909C09F71E14048FA4B40
76069	EH3 8AA	GB	0101000020E61000006B4606B98BB009C0664E97C5C4F84B40
76070	EH3 8BZ	GB	0101000020E61000007BF486FBC8AD09C0BC5AEECC04F94B40
76071	EH3 8DG	GB	0101000020E610000058CA32C4B1AE09C070438CD7BCF84B40
76072	EH3 8EB	GB	0101000020E6100000B96FB54E5CAE09C01478279F1EF94B40
76073	EH3 8HP	GB	0101000020E610000001A3CB9BC3B509C0C34483143CF94B40
76074	EH3 8HX	GB	0101000020E6100000DC2C5E2C0CB109C015376E313FF94B40
76075	EH3 9AA	GB	0101000020E610000064ADA1D45EA409C0F60D4C6E14F94B40
76076	EH3 9BH	GB	0101000020E61000003A1E3350199F09C085B1852007F94B40
76077	EH3 9BQ	GB	0101000020E6100000DFDDCA129DA509C0B4C70BE9F0F84B40
76078	EH3 9DZ	GB	0101000020E61000005C5837DE1D9909C018CDCAF621F94B40
76079	EH3 9HB	GB	0101000020E6100000DEAB5626FC9209C0F12DAC1BEFF84B40
76080	EH3 9HJ	GB	0101000020E610000008AD872F138509C075745C8DECF84B40
76081	EH3 9HP	GB	0101000020E6100000AB5CA8FC6B9909C08E3F51D9B0F84B40
76082	EH3 9JU	GB	0101000020E61000001E882CD2C49B09C0CD751A69A9F84B40
76083	EH3 9ND	GB	0101000020E61000008FFE976BD1A209C0BEBD6BD097F84B40
76084	EH3 9NH	GB	0101000020E610000049A0C1A6CEA309C08198840B79F84B40
76085	EH3 9NU	GB	0101000020E61000009604A8A965AB09C067B796C970F84B40
76086	EH30 9JU	GB	0101000020E6100000F20BAF24790E0BC0336ABE4A3EFE4B40
76087	EH30 9LL	GB	0101000020E6100000221ADD41EC2C0BC0CC0D863AACFE4B40
76088	EH30 9PA	GB	0101000020E61000003B38D89B18320BC07EC3448314FE4B40
76089	EH30 9PB	GB	0101000020E6100000B954A52DAE310BC06CEEE87FB9FE4B40
76090	EH30 9PP	GB	0101000020E610000085CD0017642B0BC04B051555BFFE4B40
76091	EH30 9QN	GB	0101000020E6100000B6696CAF051D0BC022516859F7FD4B40
76092	EH30 9SA	GB	0101000020E61000003140A20914510BC09ECE15A584FE4B40
76093	EH30 9SL	GB	0101000020E6100000695721E527B50BC054E1CFF066FF4B40
76094	EH30 9SP	GB	0101000020E6100000446ADAC534530BC0C556D0B4C4FC4B40
76095	EH30 9TA	GB	0101000020E61000008063CF9ECB140BC03A02B859BCFE4B40
76096	EH30 9TH	GB	0101000020E6100000B1DD3D40F7A50AC0F46DC1525DFC4B40
76097	EH30 9TN	GB	0101000020E6100000C078060DFDB30AC0755B22179CFB4B40
76098	EH30 9TQ	GB	0101000020E61000004D13B69F8CB10AC058E2016553FE4B40
76099	EH30 9TR	GB	0101000020E61000000057B26323D00AC0FCC56CC9AAFC4B40
76100	EH30 9XL	GB	0101000020E61000008FDE701FB9350BC0A12B11A8FEFD4B40
76101	EH31 2AA	GB	0101000020E6100000BF28417FA1A706C0C57421567F044C40
76102	EH31 2HR	GB	0101000020E6100000751DAA29C99A06C086AC6EF59C044C40
76103	EH32 0AP	GB	0101000020E61000003B376DC669A807C00F60915F3FFC4B40
76104	EH32 0HZ	GB	0101000020E6100000B9AAECBB22B807C0079964E42CFC4B40
76105	EH32 0JA	GB	0101000020E610000017D86322A5B907C0C956975302FC4B40
76106	EH32 0LS	GB	0101000020E61000003909A52F841C07C03AB01C2103FD4B40
76107	EH32 0NH	GB	0101000020E61000007A50508A562E07C0F71E2E39EEFC4B40
76108	EH32 0NY	GB	0101000020E6100000B60F79CBD52F07C0BABF7ADCB7FC4B40
76109	EH32 0TD	GB	0101000020E61000002594BE10727E07C063F20698F9FA4B40
76110	EH32 9AA	GB	0101000020E610000019C8B3CBB7DE07C09A95ED43DEFA4B40
76111	EH32 9JF	GB	0101000020E61000006494675E0EDB07C0CCD24ECDE5FA4B40
76112	EH32 9RL	GB	0101000020E6100000BEC0AC50A4FB07C0465C001AA5FB4B40
76113	EH33	GB	0101000020E610000013EE9579AB8E07C0A48AE255D6F84B40
76114	EH33 1AB	GB	0101000020E61000002F89B3226AA207C0F9C08EFF02F94B40
76115	EH33 1BW	GB	0101000020E61000005B608F8994A607C0A647533D99F94B40
76116	EH33 1JY	GB	0101000020E61000009CFD8172DB9E07C04FEACBD24EF94B40
76117	EH33 1NG	GB	0101000020E61000000FB6D8EDB3CA07C0A148F7730AFA4B40
76118	EH33 2AA	GB	0101000020E61000000821205F42A507C03CDEE4B7E8F84B40
76119	EH33 2HE	GB	0101000020E6100000F226BF45278B07C0F3C81F0C3CF94B40
76120	EH34 5AA	GB	0101000020E6100000AD32535A7F2B07C0DDED7A698AF44B40
76121	EH34 5AT	GB	0101000020E61000005E9ECE15A52407C04B72C0AE26F54B40
76122	EH35 5	GB	0101000020E610000032E6AE25E48307C0F6251B0FB6F44B40
76123	EH37 5PT	GB	0101000020E610000026C79DD2C1BA07C054742497FFEE4B40
76124	EH37 5TB	GB	0101000020E610000013D55B035B6507C0FA7ABE66B9EA4B40
76125	EH38 5YE	GB	0101000020E610000050A8A78FC0BF07C0A91611C5E4E14B40
76126	EH39 4BG	GB	0101000020E61000001B84B9DDCBDD05C01A34F44F70074C40
76127	EH39 4BP	GB	0101000020E610000026378AAC35D405C0C39CA04D0E074C40
76128	EH39 4BY	GB	0101000020E6100000315C1D0071D705C032056B9C4D074C40
76129	EH39 4DX	GB	0101000020E6100000802DAF5C6FBB05C0611C5C3AE6064C40
76130	EH39 4HG	GB	0101000020E6100000CC61F71DC3C305C0F1F109D979074C40
76131	EH39 4QZ	GB	0101000020E6100000D7DB662AC4C305C080EF366F9C064C40
76132	EH39 4RE	GB	0101000020E61000008272DBBE47DD05C016A1D80A9A064C40
76133	EH39 5DB	GB	0101000020E610000033A7CB6262F305C06DAB59677C074C40
76134	EH39 5LW	GB	0101000020E610000054AA44D95B4A06C0718E3A3AAE004C40
76135	EH39 5NA	GB	0101000020E61000005DA3E5400F9505C0406D54A703074C40
76136	EH39 5PN	GB	0101000020E61000009C33A2B4373805C0187C9A9317074C40
76137	EH39 5PW	GB	0101000020E6100000E8DD5850183405C0F6436CB070064C40
76138	EH4	GB	0101000020E6100000DEACC1FBAAFC09C07AA69718CBFA4B40
76139	EH4 1AF	GB	0101000020E6100000643A747ADECD09C047E4BB94BAFA4B40
76140	EH4 1DZ	GB	0101000020E61000002448A5D8D1B809C04F0306499FFA4B40
76141	EH4 1HN	GB	0101000020E6100000FF3EE3C281B009C009336DFFCAFA4B40
76142	EH4 2AA	GB	0101000020E6100000E607AEF204020AC08AB0E1E995FA4B40
76143	EH4 2AU	GB	0101000020E6100000878C47A984070AC07A54FCDF11FB4B40
76144	EH4 2DG	GB	0101000020E6100000E08442041C020AC04F5AB8ACC2FA4B40
76145	EH4 2QP	GB	0101000020E6100000E19524CFF5FD09C06D3656629EFB4B40
76146	EH4 3AA	GB	0101000020E6100000FAD4B14AE9B909C08386FE092EFA4B40
76147	EH4 3AB	GB	0101000020E6100000111B2C9CA4B909C08AABCABE2BFA4B40
76148	EH4 3BT	GB	0101000020E61000007F83F6EAE3C109C00BEF7211DFF94B40
76149	EH4 3JY	GB	0101000020E61000000B630B410EEA09C0E869C020E9F94B40
76150	EH4 3PH	GB	0101000020E61000008CF2CCCB61170AC0ECDADE6E49FA4B40
76151	EH4 3RL	GB	0101000020E61000007F17B6662B0F0AC005871744A4FA4B40
76152	EH4 3TU	GB	0101000020E6100000DA56B3CEF81E0AC0982F2FC03EFA4B40
76153	EH4 4PZ	GB	0101000020E6100000187B2FBE680F0AC0BC7A15191DFC4B40
76154	EH4 5AA	GB	0101000020E610000069C6A2E9EC240AC08962F20698FB4B40
76155	EH4 5DZ	GB	0101000020E61000003E78EDD286230AC00FEECEDA6DFB4B40
76156	EH4 6AE	GB	0101000020E610000052F355F2B13B0AC010E6762FF7FB4B40
76157	EH4 6DJ	GB	0101000020E610000049D6E1E82A7D0AC0717495EEAEFB4B40
76158	EH4 6DU	GB	0101000020E6100000BE66B96C748E0AC068791EDC9DFB4B40
76159	EH4 6JB	GB	0101000020E61000007593180456EE09C0B95164ADA1FC4B40
76160	EH4 6NP	GB	0101000020E6100000A51133FB3C660AC0AA9ECC3FFAFC4B40
76161	EH4 7AB	GB	0101000020E6100000F3E670ADF6100AC03999B85510FB4B40
76162	EH4 7DE	GB	0101000020E61000004B1E4FCB0FFC09C0F06B2409C2FB4B40
76163	EH4 8AB	GB	0101000020E6100000F3565D876A8A0AC03672DD94F2FA4B40
76164	EH4 8EP	GB	0101000020E61000005AF5B9DA8A7D0AC0280B5F5FEBFA4B40
76165	EH4 8HL	GB	0101000020E61000005680EF366F5C0AC00FB4024356FB4B40
76166	EH40 3AQ	GB	0101000020E610000074982F2FC03E05C08BFCFA2136FE4B40
76167	EH40 3BS	GB	0101000020E6100000CAC0012D5D4105C0A9F8BF232AFE4B40
76168	EH40 3DP	GB	0101000020E6100000E466B8019F3F05C0D8F15F2008FE4B40
76169	EH40 3DS	GB	0101000020E61000007AA9D898D73105C0D8D7BAD408FF4B40
76170	EH41	GB	0101000020E61000006211C30E635206C0F7E7A221E3F94B40
76171	EH41 3AR	GB	0101000020E6100000603DEE5BAD5306C0EC17EC866DFB4B40
76172	EH41 3JD	GB	0101000020E61000003C11C479384106C0074147AB5AFA4B40
76173	EH41 3RW	GB	0101000020E6100000BEF6CC92003506C0205F420587FB4B40
76174	EH41 3SJ	GB	0101000020E61000007C0DC171197706C02DB1321AF9FC4B40
76175	EH41 4AA	GB	0101000020E610000070EB6E9EEA3006C04C546F0D6CF94B40
76176	EH41 4ER	GB	0101000020E61000005C1FD61BB56206C0A114ADDC0BFA4B40
76177	EH41 4HN	GB	0101000020E6100000E7E3DA50314E06C0E222F77475F54B40
76178	EH41 4JA	GB	0101000020E610000074999A046F0806C040BE840A0EF74B40
76179	EH41 4JW	GB	0101000020E610000092E9D0E9793706C0A67B9DD497EF4B40
76180	EH41 4NH	GB	0101000020E610000024607479735806C0B075A911FAF94B40
76181	EH41 4QA	GB	0101000020E61000008CB96B09F92005C0081C0934D8FA4B40
76182	EH41 9SA	GB	0101000020E6100000E7FD7F9C304106C03EB0E3BF40FA4B40
76183	EH42	GB	0101000020E610000004FEF0F3DF2304C0103CBEBD6B004C40
76184	EH42 1HG	GB	0101000020E6100000F1BC546CCC0B04C08109DCBA9BFF4B40
76185	EH42 1HU	GB	0101000020E6100000FDD98F14912104C0ADC090D5AD004C40
76186	EH42 1HW	GB	0101000020E6100000B2F1608BDD1E04C0D5CF9B8A54004C40
76187	EH42 1JX	GB	0101000020E61000005E85949F541B04C0A1664815C5FF4B40
76188	EH42 1JY	GB	0101000020E6100000D658C2DA181B04C0D1419770E8FF4B40
76189	EH42 1NG	GB	0101000020E6100000FBE93F6B7E3C04C0D4B9A29410004C40
76190	EH42 1PA	GB	0101000020E6100000029CDEC5FB5104C06F2F698CD6FF4B40
76191	EH42 1PX	GB	0101000020E61000003A7AFCDEA61F04C034D8D47954004C40
76192	EH42 1QG	GB	0101000020E6100000A4E2FF8EA83004C0CE3461FBC9FE4B40
76193	EH42 1QS	GB	0101000020E6100000C2D9AD65323C03C06744696FF0FB4B40
76194	EH42 1QT	GB	0101000020E61000003A579412823503C01A5245F12AFB4B40
76195	EH42 1QZ	GB	0101000020E61000006B459BE3DC2604C0ED10FFB0A5FF4B40
76196	EH42 1RF	GB	0101000020E61000002C9B3924B53004C05D52B5DD04FF4B40
76197	EH42 1TE	GB	0101000020E6100000785F950B95DF04C087FD9E58A7FA4B40
76198	EH42 1TG	GB	0101000020E6100000C13A8E1F2A2D05C0776682E15CF74B40
76199	EH42 1US	GB	0101000020E61000001A355F251F3B04C03481221631FC4B40
76200	EH42 1XS	GB	0101000020E6100000D6C8AEB48C3405C027A25F5B3F034C40
76201	EH42 1XW	GB	0101000020E61000000EF450DB86D104C01D588E9081024C40
76202	EH43 6AN	GB	0101000020E6100000812040868E1D08C0FC36C478CDCF4B40
76203	EH43 6AU	GB	0101000020E61000009607E929722808C097033DD4B6CF4B40
76204	EH44	GB	0101000020E6100000F261F6B2ED7408C0B3EA73B515CF4B40
76205	EH44 6HA	GB	0101000020E61000003BE466B8017F08C0FAB9A1293BCF4B40
76206	EH44 6NL	GB	0101000020E61000005FF0694E5E8408C0B4AA251DE5D24B40
76207	EH44 6PD	GB	0101000020E61000004DC0AF91248808C0FA28232E00CF4B40
76208	EH44 6QE	GB	0101000020E6100000959D7E50178908C05DC136E2C9CE4B40
76209	EH45 7NP	GB	0101000020E610000063635E471C120AC0C0CDE2C5C2D24B40
76210	EH45 8AG	GB	0101000020E6100000A4880CAB788309C08448861C5BD34B40
76211	EH45 8NQ	GB	0101000020E61000008B51D7DAFB3409C088F71C588ED24B40
76212	EH45 8NW	GB	0101000020E61000006AF816D68DB709C00B7C45B75ED34B40
76213	EH45 8RS	GB	0101000020E6100000D97C5C1B2A8609C04E7B4ACE89D34B40
76214	EH46 7AB	GB	0101000020E610000026732CEFAA670BC03F1EFAEE56DA4B40
76215	EH46 7AS	GB	0101000020E6100000FD851E317AAE0AC068AED3484BE34B40
76216	EH46 7BH	GB	0101000020E6100000630B410E4AB80AC08735954561DD4B40
76217	EH46 7BZ	GB	0101000020E6100000BAF59A1E14B40AC01BF2CF0CE2DB4B40
76218	EH46 7DD	GB	0101000020E61000004815C5ABACAD0AC0F94D61A582D84B40
76219	EH46 7EE	GB	0101000020E610000018080264E8D80AC0672618CE35E04B40
76220	EH46 7EL	GB	0101000020E61000001FF296AB1FDB0AC07B681F2BF8DF4B40
76221	EH46 7ES	GB	0101000020E610000080290307B4D40AC0CF488446B0DF4B40
76222	EH46 7HJ	GB	0101000020E61000003D44A33B887D0BC0A94D9CDCEFDC4B40
76223	EH46 7HL	GB	0101000020E610000005C3B986191A0BC06D59BE2EC3E34B40
76224	EH47 0AA	GB	0101000020E610000053CE177B2FBE0DC0B40584D6C3ED4B40
76225	EH47 0AE	GB	0101000020E610000073B8567BD8AB0DC04F78094E7DEE4B40
76226	EH47 0EU	GB	0101000020E6100000DB4FC6F8307B0DC0FE0FB056EDEE4B40
76227	EH47 7	GB	0101000020E6100000FD4AE7C3B3040DC04451A04FE4EF4B40
76228	EH47 7LG	GB	0101000020E6100000F566D47C95FC0CC0FDA4DAA7E3EF4B40
76229	EH47 7LW	GB	0101000020E6100000799274CDE4FB0CC07CD11E2FA4EF4B40
76230	EH47 7NA	GB	0101000020E610000031276893C3070DC0006F8104C5EF4B40
76231	EH47 9DJ	GB	0101000020E6100000C1FF56B263C30DC05E9CF86A47E94B40
76232	EH48	GB	0101000020E61000008E3EE603023D0DC04A0A2C8029F34B40
76233	EH48 1AZ	GB	0101000020E6100000ABAFAE0AD4220DC035272F3201F34B40
76234	EH48 2ES	GB	0101000020E6100000FD8348861CFB0CC0144031B264F24B40
76235	EH48 2JS	GB	0101000020E610000067463F1A4E790DC011ACAA97DFF14B40
76236	EH48 2PT	GB	0101000020E6100000978E39CFD8970DC03F912749D7F24B40
76237	EH48 2QU	GB	0101000020E61000005648F949B54F0DC06C770FD07DF34B40
76238	EH48 3LD	GB	0101000020E61000002942EA76F6950DC0E3E2A8DC44F14B40
76239	EH48 4DE	GB	0101000020E6100000486C770FD01D0DC089EDEE01BAF34B40
76240	EH48 4GZ	GB	0101000020E61000006667D13B15D00CC08E01D9EBDDF74B40
76241	EH48 4LY	GB	0101000020E61000000CE71A66683C0DC04B3D0B4279F74B40
76242	EH48 4LZ	GB	0101000020E61000005DFC6D4F90380DC03A5D16139BF74B40
76243	EH48 4SA	GB	0101000020E61000004D1421753BBB0BC052B81E85EBF54B40
76244	EH49	GB	0101000020E6100000967B8159A1880CC039984D8061FD4B40
76245	EH49 6AQ	GB	0101000020E6100000BD8DCD8E549F0CC0917D9065C1FC4B40
76246	EH49 6AS	GB	0101000020E61000003FFD67CD8FBF0CC0A2410A9E42FC4B40
76247	EH49 6AW	GB	0101000020E6100000A67B9DD497250CC0BA675DA3E5FC4B40
76248	EH49 6BQ	GB	0101000020E61000005875560BECD10CC02AC58EC6A1FC4B40
76249	EH49 6PB	GB	0101000020E61000005AD427B9C3460CC0691CEA7761FB4B40
76250	EH49 7DH	GB	0101000020E6100000151DC9E53FC40CC04D83A27900FD4B40
76251	EH49 7LD	GB	0101000020E610000050E3DEFC86290CC0EFE192E34EFD4B40
76252	EH49 7NA	GB	0101000020E6100000CE70033E3F2C0CC00E4E44BFB6FE4B40
76253	EH49 7NB	GB	0101000020E6100000CAF962EFC5D70BC0713AC95697FD4B40
76254	EH49 7NH	GB	0101000020E610000099F4F75278300CC09A3FA6B569004C40
76255	EH49 7RH	GB	0101000020E6100000594FADBEBACA0CC0757808E3A7FF4B40
76256	EH49 7SY	GB	0101000020E610000095826E2F698C0CC0AD4F39268BFD4B40
76257	EH5 1EY	GB	0101000020E61000001F645930F1C709C0293DD34B8CFD4B40
76258	EH5 1HD	GB	0101000020E6100000F645425BCEC509C051FA42C879FD4B40
76259	EH5 2AA	GB	0101000020E6100000A3ACDF4C4CB709C01AF7E6374CFC4B40
76260	EH5 2AB	GB	0101000020E61000007A8B87F71CB809C073F7393E5AFC4B40
76261	EH5 2AD	GB	0101000020E6100000645A9BC6F6BA09C0111956F146FC4B40
76262	EH5 2BE	GB	0101000020E6100000C84109336DBF09C07A724D81CCFC4B40
76263	EH5 2EF	GB	0101000020E61000003D0AD7A370BD09C0DC68006F81FC4B40
76264	EH5 3AA	GB	0101000020E61000008F1B7E37DD9209C0E8DCED7A69FC4B40
76265	EH5 3ED	GB	0101000020E6100000FAB31F2922A309C00C1EA67D73FD4B40
76266	EH5 3HA	GB	0101000020E610000031D120054FA109C08F899466F3FC4B40
76267	EH5 3LP	GB	0101000020E610000071033E3F8CB009C06FA0C03BF9FC4B40
76268	EH5 3PJ	GB	0101000020E6100000AAD6C22CB47309C09E7B0F971CFD4B40
76269	EH5 3QS	GB	0101000020E6100000C30C8D2782B809C0F6EB4E779EFC4B40
76270	EH5 3RE	GB	0101000020E610000012BF620D17B909C0E8DB82A5BAFC4B40
76271	EH51	GB	0101000020E610000079CDAB3AAB050DC054C4E9245B014C40
76272	EH51 9AN	GB	0101000020E61000002600FF942AD10CC070D05E7D3C024C40
76273	EH51 9AZ	GB	0101000020E610000061FBC9181FE60CC047CA1649BB014C40
76274	EH51 9DW	GB	0101000020E6100000B587BD50C0D60CC0320395F1EF014C40
76275	EH51 9EQ	GB	0101000020E610000021EA3E00A9CD0CC03E20D099B4014C40
76276	EH51 9HP	GB	0101000020E6100000085A8121ABDB0CC065C39ACAA2004C40
76277	EH51 9JA	GB	0101000020E610000038F7578FFBD60CC0ED80EB8A19014C40
76278	EH51 9PA	GB	0101000020E61000007958A835CDBB0CC08A8EE4F21F024C40
76279	EH51 9QB	GB	0101000020E610000000E5EFDE51630CC0378AAC3594FE4B40
76280	EH51 9SX	GB	0101000020E6100000E42CEC69879F0CC030D80DDB16014C40
76281	EH52	GB	0101000020E610000097E65608ABF10BC09A42E73576F74B40
76282	EH52 5HY	GB	0101000020E6100000DCB8C5FCDC100CC0815CE2C803F74B40
76283	EH52 5JE	GB	0101000020E6100000FED30D1478A70BC03961C26856FA4B40
76284	EH52 5LR	GB	0101000020E61000004A404CC285DC0BC0FF25A94C31F74B40
76285	EH52 5PJ	GB	0101000020E6100000969526A5A0BB0BC0D4635B069CF94B40
76286	EH52 5QY	GB	0101000020E610000031B3CF6394C70BC04A44F81741F74B40
76287	EH52 5QZ	GB	0101000020E6100000581F0F7D77CB0BC0950B957F2DF74B40
76288	EH52 6LG	GB	0101000020E6100000DBA337DC474E0CC05B28999CDAF54B40
76289	EH52 6PJ	GB	0101000020E61000003F53AF5B04C60BC062855B3E92F84B40
76290	EH52 6QH	GB	0101000020E610000085B53176C2AB0BC02B6A300DC3FD4B40
76291	EH53 0EP	GB	0101000020E6100000750470B378B10BC0DC7EF964C5F24B40
76292	EH53 0RT	GB	0101000020E610000084B7072120FF0AC0751DAA29C9F44B40
76293	EH54	GB	0101000020E6100000357C0BEBC61B0CC0CAA7C7B60CF44B40
76294	EH54 5QG	GB	0101000020E610000090BE49D3A0080CC0D89B189293F54B40
76295	EH54 6EE	GB	0101000020E6100000AFEC82C135170CC0070ABC934FF34B40
76296	EH54 6NW	GB	0101000020E6100000C9737D1F0E320CC05706D50627F04B40
76297	EH54 6RN	GB	0101000020E61000000322C495B3570CC02079E75086F24B40
76298	EH54 6TB	GB	0101000020E610000096D05D1267450CC0FFB1101D02F34B40
76299	EH54 6TZ	GB	0101000020E6100000ADA23F34F3440CC0D388997D1EF34B40
76300	EH54 6UQ	GB	0101000020E610000096E82CB308650CC09E060C923EF14B40
76301	EH54 6UT	GB	0101000020E61000005E30B8E68E1E0CC0C6DFF60489F34B40
76302	EH54 8HT	GB	0101000020E610000084D382177D450CC014799274CDF44B40
76303	EH54 8NY	GB	0101000020E61000004206F2ECF26D0CC0705F07CE19F34B40
76304	EH54 9AD	GB	0101000020E6100000DC9DB5DB2E340CC0091B9E5E29EF4B40
76305	EH54 9AR	GB	0101000020E6100000AE6186C613010CC09241EE224CEF4B40
76306	EH54 9EE	GB	0101000020E6100000A16AF46A80120CC0E9EDCF4543EE4B40
76307	EH54 9HP	GB	0101000020E61000005531957EC2190CC000529B38B9ED4B40
76308	EH54 9HT	GB	0101000020E610000087A2409FC8130CC075CB0EF10FEF4B40
76309	EH55	GB	0101000020E61000002C2CB81FF0A00CC0081F4AB4E4ED4B40
76310	EH55 8AB	GB	0101000020E6100000C5AC174339910CC0567E198C11ED4B40
76311	EH55 8BP	GB	0101000020E6100000F705F4C29D8B0CC032056B9C4DED4B40
76312	EH55 8ED	GB	0101000020E61000000C923EADA29F0CC0EB1F4432E4EC4B40
76313	EH55 8LG	GB	0101000020E6100000016E162F16C60CC038656EBE11E94B40
76314	EH55 8LH	GB	0101000020E6100000FF428F183DB70CC0DD0C37E0F3E54B40
76315	EH55 8LJ	GB	0101000020E610000057B08D78B29B0CC03D80457EFDE44B40
76316	EH55 8LL	GB	0101000020E61000002C0DFCA886BD0CC0207C28D192E34B40
76317	EH55 8LN	GB	0101000020E610000044C18C2958A30CC008E6E8F17BE34B40
76318	EH55 8LP	GB	0101000020E61000000400C79E3D370CC09BE5B2D139E54B40
76319	EH55 8LQ	GB	0101000020E61000005F0839EFFFA30CC02FFCE07CEAE64B40
76320	EH55 8LR	GB	0101000020E61000005A7EE02A4F200CC0056F48A302E74B40
76321	EH55 8LS	GB	0101000020E6100000290989B48D7F0CC0388600E0D8E14B40
76322	EH55 8LW	GB	0101000020E6100000D7A205685B6D0CC06EC493DDCCE24B40
76323	EH55 8NQ	GB	0101000020E6100000C4211B4817DB0CC0DA70581AF8EB4B40
76324	EH55 8QE	GB	0101000020E610000042791F4773640CC0083A5AD592EA4B40
76325	EH55 8QQ	GB	0101000020E61000007E00529B38590CC024D5777E51EE4B40
76326	EH55 8RG	GB	0101000020E610000010CEA78E552A0CC0AC1919E42EEC4B40
76327	EH55 8RJ	GB	0101000020E6100000D653ABAFAE2A0CC052F01472A5EA4B40
76328	EH55 8RL	GB	0101000020E6100000E73A8DB4543E0CC07808E3A771E94B40
76329	EH55 8RN	GB	0101000020E6100000D9E89C9FE2380CC02B4B749659EA4B40
76330	EH55 8RP	GB	0101000020E6100000E75608ABB1440CC03A419B1C3EEB4B40
76331	EH55 8RR	GB	0101000020E6100000BA13ECBFCE4D0CC0554B3ACAC1EA4B40
76332	EH55 8RS	GB	0101000020E6100000E3344415FE4C0CC055336B2920EB4B40
76333	EH55 8RT	GB	0101000020E6100000F29A5775564B0CC051DCF126BFE94B40
76334	EH55 8TJ	GB	0101000020E61000007BF65CA626810CC06D3CD862B7ED4B40
76335	EH55 8XA	GB	0101000020E6100000A5F44C2F31760CC089450C3B8CE34B40
76336	EH55 8XB	GB	0101000020E61000007CEE04FBAF730CC0EA5DBC1FB7E34B40
76337	EH55 8XD	GB	0101000020E61000009F03CB1132700CC02D978DCEF9E34B40
76338	EH55 8XE	GB	0101000020E61000008731E9EFA5700CC0293C6876DDE34B40
76339	EH55 8XF	GB	0101000020E6100000658F5033A46A0CC04721C9ACDEE34B40
76340	EH6	GB	0101000020E6100000478D0931975409C0FDA19927D7FC4B40
76341	EH6 4AD	GB	0101000020E6100000D505BCCCB07109C09D2B4A09C1FC4B40
76342	EH6 4AR	GB	0101000020E61000006D3CD862B76F09C04C1B0E4B03FD4B40
76343	EH6 4AS	GB	0101000020E6100000640795B88E7109C0620FED6305FD4B40
76344	EH6 4BN	GB	0101000020E610000042B5C189E87709C0D74D29AF95FC4B40
76345	EH6 4BY	GB	0101000020E61000008928266F807909C0BBB9F8DB9EFC4B40
76346	EH6 4QW	GB	0101000020E61000007DAF21382E8309C0D1031F8315FD4B40
76347	EH6 5BH	GB	0101000020E6100000EAE8B81AD97509C0DEE8633E20FC4B40
76348	EH6 5DT	GB	0101000020E61000008BFD65F7E46109C05C3E92921EFC4B40
76349	EH6 5HA	GB	0101000020E610000053793BC2696109C02CF4C13236FC4B40
76350	EH6 5QN	GB	0101000020E61000002B51F696727E09C06DAE9AE788FC4B40
76351	EH6 5QQ	GB	0101000020E6100000826F9A3E3B8009C0876C205D6CFC4B40
76352	EH6 6EX	GB	0101000020E6100000B4722F302B5409C0467BBC900EFD4B40
76353	EH6 6PW	GB	0101000020E6100000C806D2C5A65509C06B459BE3DCFC4B40
76354	EH6 6RG	GB	0101000020E61000009CDF30D1206509C09FCDAACFD5FC4B40
76355	EH6 7AA	GB	0101000020E6100000558A1D8D435D09C06CB587BD50FC4B40
76356	EH6 7EZ	GB	0101000020E61000003FE3C281904C09C0A9143B1A87FC4B40
76357	EH6 7LY	GB	0101000020E6100000DB166536C84409C0D15790662CFC4B40
76358	EH6 8AH	GB	0101000020E61000009AB33EE5984C09C059349D9D0CFC4B40
76359	EH6 8HQ	GB	0101000020E6100000F5F23B4D665C09C01BA034D428FC4B40
76360	EH6 8NY	GB	0101000020E61000005E126745D46409C00DE36E10ADFB4B40
76361	EH6 8NZ	GB	0101000020E6100000A1D9756F45C209C0C993A46B26FB4B40
76362	EH6 8RF	GB	0101000020E6100000446CB070926609C091B586527BFB4B40
76363	EH7	GB	0101000020E610000078EE3D5C727C09C09CDF30D120FB4B40
76364	EH7 4AA	GB	0101000020E6100000BC96900F7A7609C0E21E4B1FBAFA4B40
76365	EH7 4DA	GB	0101000020E6100000C47762D68BA109C09DBAF2599EF74B40
76366	EH7 4EN	GB	0101000020E6100000471CB281749109C06F48A30227FB4B40
76367	EH7 4NF	GB	0101000020E610000025ECDB49447809C049D6E1E82AFB4B40
76368	EH7 4NW	GB	0101000020E6100000EB19C231CB7E09C0C5E57805A2FB4B40
76369	EH7 5AA	GB	0101000020E61000005CE7DF2EFB7509C0333674B33FFA4B40
76370	EH7 5AH	GB	0101000020E6100000E8F4BC1B0B6A09C0EB3713D385FA4B40
76371	EH7 5ED	GB	0101000020E610000041BAD8B4526809C096067E54C3FA4B40
76372	EH7 5ET	GB	0101000020E61000003C3080F0A16409C0D670917BBAFA4B40
76373	EH7 5LT	GB	0101000020E6100000ABD1AB014A6309C00938842A35FB4B40
76374	EH7 5SY	GB	0101000020E61000002C62D8614C5A09C08C2FDAE385FA4B40
76375	EH7 6AA	GB	0101000020E6100000D8648D7A884609C03DB665C059FA4B40
76376	EH7 6BX	GB	0101000020E6100000F3565D876A4A09C0043A933655FB4B40
76377	EH7 6QR	GB	0101000020E6100000261DE560362109C0D481ACA756FB4B40
76378	EH75 5PY	GB	0101000020E6100000B2BAD573D25B09C0C362D4B5F6FA4B40
76379	EH8	GB	0101000020E6100000ED2B0FD2532409C0F3E49A0299F94B40
76380	EH8 7AB	GB	0101000020E61000009207228B343109C0D4449F8F32FA4B40
76381	EH8 7AQ	GB	0101000020E61000005AD6FD63213A09C00F43AB9333FA4B40
76382	EH8 7NS	GB	0101000020E6100000605AD427B92309C052B5DD04DFF84B40
76383	EH8 8AA	GB	0101000020E61000009C4EB2D5E57409C02F34D769A4F94B40
76384	EH8 8AS	GB	0101000020E6100000D177B7B2446709C0A8514832ABF94B40
76385	EH8 8BQ	GB	0101000020E6100000F1BDBF417B7509C0EA7AA2EBC2F94B40
76386	EH8 8DD	GB	0101000020E6100000C3F352B1316F09C087A2409FC8F94B40
76387	EH8 8HE	GB	0101000020E61000009B8F6B43C53809C028999CDA19FA4B40
76388	EH8 9AA	GB	0101000020E6100000D0807A336A7E09C06E4E250340F94B40
76389	EH8 9DT	GB	0101000020E61000006C3D4338667909C0C4279D4830F94B40
76390	EH8 9NB	GB	0101000020E6100000C0B2D2A4147409C071E6577380F84B40
76391	EH8 9PL	GB	0101000020E6100000F2ECF2AD0F6B09C044BE4BA94BF84B40
76392	EH8 9QN	GB	0101000020E6100000C2A1B778786F09C0E7A7380EBCF84B40
76393	EH8 9QS	GB	0101000020E6100000D06394675E6E09C096AFCBF09FF84B40
76394	EH8 9SW	GB	0101000020E61000006344A2D0B26E09C02593533BC3F84B40
76395	EH8 9TS	GB	0101000020E610000077BD3445807309C04C7155D977F94B40
76396	EH8 9XP	GB	0101000020E610000011363CBD527609C0F29A577556F94B40
76397	EH9 1AS	GB	0101000020E61000000C3CF71E2E9909C05BB4006DABF74B40
76398	EH9 1AZ	GB	0101000020E6100000726BD26D899C09C08C6665FB90F74B40
76399	EH9 1BJ	GB	0101000020E610000050C58D5BCC8F09C027327381CBF74B40
76400	EH9 1BZ	GB	0101000020E61000001630815B779309C0B726DD96C8F74B40
76401	EH9 1EA	GB	0101000020E6100000D4D7F335CB8509C0BBD1C77C40F84B40
76402	EH9 1EL	GB	0101000020E61000004512BD8C629909C078D2C26515F84B40
76403	EH9 1ET	GB	0101000020E6100000D36BB3B1129309C07C0A80F10CF84B40
76404	EH9 1HE	GB	0101000020E610000052D66F26A68B09C09D9CA1B8E3F74B40
76405	EH9 1HN	GB	0101000020E6100000AAD216D7F88C09C060B01BB62DF84B40
76406	EH9 1JS	GB	0101000020E6100000CAC4AD82188809C0CB49287D21F84B40
76407	EH9 1JW	GB	0101000020E61000000053060E688909C0E962D34A21F84B40
76408	EH9 1JY	GB	0101000020E6100000F6B6990AF18809C08690F3FE3FF84B40
76409	EH9 1PJ	GB	0101000020E6100000C616821C947009C06500A8E2C6F74B40
76410	EH9 1RA	GB	0101000020E6100000512FF834276F09C0A29927D714F84B40
76411	EH9 1UB	GB	0101000020E6100000CF656A12BC8109C0D76CE525FFF74B40
76412	EH9 2	GB	0101000020E61000009BE61DA7E86809C0520ABABDA4F74B40
76413	EH9 2DJ	GB	0101000020E61000002E3A596ABD5F09C002D9EBDD1FF74B40
76414	EH9 2ER	GB	0101000020E6100000B0AE0AD4627009C07B87DBA161F74B40
76415	EH9 2ES	GB	0101000020E6100000BAA29410AC8A09C0BE69FAEC80F74B40
76416	EH9 2GZ	GB	0101000020E6100000A69D9ACB0D8609C0350BB43BA4F64B40
76417	EH9 2HH	GB	0101000020E6100000DAE4F049279209C096E99788B7F64B40
76418	EH9 2HQ	GB	0101000020E6100000F1660DDE578509C03883BF5FCCF64B40
76419	EH9 2HZ	GB	0101000020E6100000EA3F6B7EFC8509C0EFFFE38409F74B40
76420	EH9 2JF	GB	0101000020E61000006E52D158FB7B09C0B323D5777EF74B40
76421	EH9 3AA	GB	0101000020E610000006F1811DFF6509C06BB933130CF74B40
76422	EH9 3DH	GB	0101000020E61000003DF03158716A09C06DC5FEB27BF64B40
76423	EH9 3DJ	GB	0101000020E6100000A6423C122F6F09C0853E58C686F64B40
76424	EH9 3HJ	GB	0101000020E6100000B5519D0E647D09C0AD1397E315F64B40
76425	EH9 3JJ	GB	0101000020E61000005E83BEF4F66709C070D05E7D3CF64B40
76426	EH9 3JZ	GB	0101000020E61000009F1D705D316309C0C58CF0F620F64B40
76427	EN1	GB	0101000020E6100000983270404B57A8BF3354C554FAD14940
76428	EN1 1BA	GB	0101000020E6100000349F73B7EBA5B1BFE8DD585018D24940
76429	EN1 1ER	GB	0101000020E610000088670932022AB0BFCDE67118CCD14940
76430	EN1 1JA	GB	0101000020E6100000A3E5400FB56DB0BF021077F52AD24940
76431	EN1 1JB	GB	0101000020E6100000AB07CC43A67CB0BFDDD1FF722DD24940
76432	EN1 1JG	GB	0101000020E6100000596B28B517D1A6BF605B3FFD67D34940
76433	EN1 1PS	GB	0101000020E610000025E659492BBEB1BF8011346612D34940
76434	EN1 1YX	GB	0101000020E6100000C921E2E65432B4BFD6743DD175D34940
76435	EN1 2AJ	GB	0101000020E6100000ACFF73982F2FB4BF488C9E5BE8D24940
76436	EN1 2AZ	GB	0101000020E61000001AFA27B85851B3BF4D83A27900D34940
76437	EN1 2BB	GB	0101000020E61000000B630B410E4AB4BFD65416855DD24940
76438	EN1 2LN	GB	0101000020E6100000C3B645990D32B1BF2920ED7F80D14940
76439	EN1 2PD	GB	0101000020E6100000377007EA9447B3BF4AD1CABDC0D24940
76440	EN1 2PL	GB	0101000020E61000004B5645B8C9A8B2BF9C8BBFED09D24940
76441	EN1 2QX	GB	0101000020E6100000E57FF277EFA8B1BF897E6DFDF4D14940
76442	EN1 2RP	GB	0101000020E6100000B262B83A00E2B2BFDDB6EF517FD14940
76443	EN1 3AE	GB	0101000020E6100000EDD808C4EBFAADBFA9F6E978CCD44940
76444	EN1 3DJ	GB	0101000020E610000066A19DD32CD0B2BF271422E010D44940
76445	EN1 3HQ	GB	0101000020E610000026016A6AD95AB3BFC7B8E2E2A8D44940
76446	EN1 3SW	GB	0101000020E6100000C91F0C3CF71EB2BF30116F9D7FD34940
76447	EN1 3UL	GB	0101000020E6100000AF264F594DD7B3BF0EBE30992AD44940
76448	EN1 3UT	GB	0101000020E6100000247EC51A2E72B3BFB1DCD26A48D44940
76449	EN1 3XY	GB	0101000020E61000008C834BC79C67B4BFCCB22781CDD34940
76450	EN10 6NY	GB	0101000020E6100000FE28EACC3D248CBFED66463F1AE04940
76451	EN10 6PD	GB	0101000020E610000094895B0531D095BFE2B19FC552DE4940
76452	EN10 7	GB	0101000020E61000005D15A8C5E0619ABF87DBA16131E04940
76453	EN10 7AW	GB	0101000020E61000008BFCFA21365888BF274A42226DDF4940
76454	EN10 7PB	GB	0101000020E61000003881E9B46E839ABF9204E10A28E04940
76455	EN11	GB	0101000020E610000056BABBCE86FC83BFD1419770E8E14940
76456	EN11 0EG	GB	0101000020E6100000B2632310AFEB773FE083D72E6DE24940
76457	EN11 0NS	GB	0101000020E61000009C887E6DFDF46FBF32022A1C41E24940
76458	EN11 0QW	GB	0101000020E61000005680EF366F9C64BF8FAB915D69E34940
76459	EN11 8BD	GB	0101000020E6100000AB24B20FB22C88BF2DCE18E604E14940
76460	EN11 8BE	GB	0101000020E6100000C91D3691990B8CBF685DA3E540E14940
76461	EN11 8EA	GB	0101000020E61000008CDAFD2AC0777BBFC0AE264F59E14940
76462	EN11 9EW	GB	0101000020E61000001F84807C09154C3FC631923D42E14940
76463	EN11 9LG	GB	0101000020E6100000C66B5ED5592D80BFFF78AF5A99E24940
76464	EN2	GB	0101000020E6100000A81B28F04E3EB5BFE413B2F336D44940
76465	EN2 0JB	GB	0101000020E61000001D3D7E6FD39FB5BF2E3D9AEAC9D44940
76466	EN2 0QF	GB	0101000020E61000004DBED9E6C6F4B4BF65C39ACAA2D44940
76467	EN2 0QG	GB	0101000020E6100000DB183BE12538B5BFA24621C9ACD44940
76468	EN2 0QU	GB	0101000020E6100000B9895A9A5B21B8BFF986C267EBD44940
76469	EN2 0RQ	GB	0101000020E610000024B891B245D2B6BFD1C952EBFDD44940
76470	EN2 6HT	GB	0101000020E6100000E4D6A4DB12B9B4BFF7E461A1D6D24940
76471	EN2 6JR	GB	0101000020E6100000D9B3E7323509B6BF9D2D20B41ED44940
76472	EN2 6LN	GB	0101000020E6100000E030D120054FB5BF68791EDC9DD34940
76473	EN2 6NN	GB	0101000020E6100000B0C56E9F5566B6BFE78BBD175FD44940
76474	EN2 6PX	GB	0101000020E6100000085740A19E3EB6BFD386C3D2C0D34940
76475	EN2 6UD	GB	0101000020E6100000BC77D4981073B5BFF6EFFACC59D34940
76476	EN2 7AA	GB	0101000020E6100000B9347EE19524B7BFA10F96B1A1D34940
76477	EN2 7AW	GB	0101000020E6100000A1BDFA78E8BBB7BF2843554CA5D34940
76478	EN2 7HF	GB	0101000020E610000070EF1AF4A5B7B7BFF646AD307DD34940
76479	EN2 8HG	GB	0101000020E6100000B1A206D3307CB8BF855B3E9292D44940
76480	EN2 8JF	GB	0101000020E6100000FB07910C39B6BABF0D71AC8BDBD44940
76481	EN2 8LX	GB	0101000020E6100000C64FE3DEFC86B9BF9CFD8172DBD44940
76482	EN2 9DA	GB	0101000020E6100000CFA10C553195BABF51DEC7D11CD74940
76483	EN2 9DZ	GB	0101000020E61000002DCDAD105663B9BF377007EA94D74940
76484	EN2 9EA	GB	0101000020E61000002B6D718DCF64BBBFC39ACAA2B0D74940
76485	EN2 9HA	GB	0101000020E61000006F1283C0CAA1B1BFEF0390DAC4D54940
76486	EN3	GB	0101000020E6100000CF49EF1B5F7BA6BFDBDB2DC901D54940
76487	EN3 4AZ	GB	0101000020E6100000A27A6B60AB04ABBFF78E1A1362D24940
76488	EN3 4HW	GB	0101000020E610000033C51C041DADAABFF46BEBA7FFD24940
76489	EN3 4LE	GB	0101000020E61000002CBB6070CD1DADBF5A9C31CC09D64940
76490	EN3 4PQ	GB	0101000020E6100000B79BE09BA6CFA6BF4B1E4FCB0FD24940
76491	EN3 4QB	GB	0101000020E6100000C4D2C08F6AD89FBF97AB1F9BE4D34940
76492	EN3 4SA	GB	0101000020E6100000DBF7A8BF5E61A9BF1615713AC9D24940
76493	EN3 4SF	GB	0101000020E6100000D046AE9B525EABBF2D6002B7EED24940
76494	EN3 5DS	GB	0101000020E6100000753E3C4B9011A0BF6A87BF266BD44940
76495	EN3 5RP	GB	0101000020E6100000CBA145B6F3FDACBF6C3F19E3C3D64940
76496	EN3 5TT	GB	0101000020E6100000693BA6EECA2EA8BF1E705D3123D64940
76497	EN3 6EF	GB	0101000020E6100000C93A1C5DA5BB9BBFB2BB404981D54940
76498	EN3 6HA	GB	0101000020E610000053EBFD463B6EA0BFE92807B309D44940
76499	EN3 6HE	GB	0101000020E6100000F1F62004E44B98BF79758E01D9D54940
76500	EN3 6HF	GB	0101000020E610000020B3B3E89D0A98BF840CE4D9E5D54940
76501	EN3 6LG	GB	0101000020E6100000892650C42286A5BFE4D87A8670D64940
76502	EN3 6PD	GB	0101000020E6100000F6251B0FB6D8A5BF13B69F8CF1D54940
76503	EN3 6PR	GB	0101000020E61000009D499BAA7B64A3BFEBFD463B6ED64940
76504	EN3 6WN	GB	0101000020E61000009D64ABCB290191BF9F909DB7B1D54940
76505	EN3 7HZ	GB	0101000020E6100000B0E595EB6D33A5BFC30DF8FC30D44940
76506	EN3 7LS	GB	0101000020E6100000AED689CBF10AA4BF0DFFE9060AD44940
76507	EN3 7RT	GB	0101000020E6100000895E46B1DCD2A2BFBD5296218ED34940
76508	EN4 0EL	GB	0101000020E6100000C138B874CC79C6BFDFA9807B9ED54940
76509	EN4 8AA	GB	0101000020E6100000CAA65CE15D2EC4BF774B72C0AED24940
76510	EN4 8DG	GB	0101000020E61000004CFDBCA94885C5BF008BFCFA21D24940
76511	EN4 8LE	GB	0101000020E6100000E199D024B1A4C2BF64EB19C231D14940
76512	EN4 8NA	GB	0101000020E6100000F6083543AA28C4BF30BB270F0BD14940
76513	EN4 8PZ	GB	0101000020E61000001346B3B27DC8C1BF535DC0CB0CD34940
76514	EN4 8QD	GB	0101000020E6100000E4310395F1EFC3BF4F5C8E5720D24940
76515	EN4 8QG	GB	0101000020E6100000AAF06778B306C3BFECF7C43A55D24940
76516	EN4 8TU	GB	0101000020E61000000B630B410E4AC4BF1BBD1AA034D24940
76517	EN4 8UL	GB	0101000020E61000000729780AB952C5BF0EF8FC3042D24940
76518	EN4 9LS	GB	0101000020E61000006EFC89CA8635C3BF27BF45274BD34940
76519	EN4 9RT	GB	0101000020E610000044C4CDA96400C2BFEEB5A0F7C6D24940
76520	EN5 1AR	GB	0101000020E61000006D7539252026C7BF621399B9C0D14940
76521	EN5 1AS	GB	0101000020E61000000229B16B7BBBC7BF69E55E6056D24940
76522	EN5 1BU	GB	0101000020E6100000CAFD0E45813EC5BF93C5FD47A6D14940
76523	EN5 1DX	GB	0101000020E61000002385B2F0F5B5C6BF6E861BF0F9D14940
76524	EN5 1ES	GB	0101000020E6100000F032C34659BFC7BF4BE82E89B3D24940
76525	EN5 1HY	GB	0101000020E61000006B0DA5F622DAC6BFCF86FC3383D24940
76526	EN5 1JL	GB	0101000020E6100000641EF98381E7C6BFB81E85EB51D24940
76527	EN5 1QT	GB	0101000020E6100000F450DB865110C6BF6E6C76A4FAD24940
76528	EN5 2	GB	0101000020E6100000823AE5D18DB0CABF062AE3DF67D24940
76529	EN5 2BE	GB	0101000020E6100000D89AADBCE47FC8BF245F09A4C4D24940
76530	EN5 2EP	GB	0101000020E6100000CFBBB1A03028C9BF693A3B191CD34940
76531	EN5 2JZ	GB	0101000020E6100000FDF50A0BEE07CABFA3C9C51858D34940
76532	EN5 2LE	GB	0101000020E61000005C8E57207A52CABFF4A5B73F17D34940
76533	EN5 2SN	GB	0101000020E6100000DBDFD91EBDE1CABFDF5339ED29D34940
76534	EN5 3HJ	GB	0101000020E6100000F73DEAAF5758CEBF98BF42E6CAD24940
76535	EN5 3HS	GB	0101000020E6100000F19F6EA0C03BD0BF745E6397A8D24940
76536	EN5 4	GB	0101000020E6100000C9B08A37328FCABFA3586E6935D44940
76537	EN5 4DA	GB	0101000020E6100000B403AE2B6684CBBF1502B9C491D34940
76538	EN5 4EE	GB	0101000020E610000050DF32A7CB62CABFCADC7C23BAD34940
76539	EN5 4EW	GB	0101000020E610000027124C35B396CABF8657923CD7D34940
76540	EN5 4JN	GB	0101000020E6100000D48041D2A755CABF7E1B62BCE6D34940
76541	EN5 4JW	GB	0101000020E610000035B742588D25CABF639813B4C9D34940
76542	EN5 4PP	GB	0101000020E61000004E637B2DE8BDC9BF0874266DAAD44940
76543	EN5 4RE	GB	0101000020E61000000BD28C45D3D9CBBF2F50526001D64940
76544	EN5 5DG	GB	0101000020E610000066DAFE959526C7BFA60EF27A30D34940
76545	EN5 5EL	GB	0101000020E61000001D3D7E6FD39FC5BF05508C2C99D34940
76546	EN5 5EQ	GB	0101000020E6100000F0FD0DDAAB8FC7BF87FBC8AD49D34940
76547	EN5 5JN	GB	0101000020E6100000B16A10E6762FC7BFE06932E36DD34940
76548	EN5 5JY	GB	0101000020E6100000C9E7154F3DD2C8BF0ABDFE243ED34940
76549	EN5 5LT	GB	0101000020E61000005B28999CDA19C8BFC5AA4198DBD34940
76550	EN5 5NS	GB	0101000020E6100000B40584D6C397C7BFB532E197FAD34940
76551	EN5 5PD	GB	0101000020E6100000BF81C98D226BC7BF38A3E6ABE4D34940
76552	EN5 5SN	GB	0101000020E610000011381268B0A9C9BFCC272B86ABD34940
76553	EN52 2HR	GB	0101000020E6100000E146CA1649BBC9BF2E5393E00DD34940
76554	EN6 1AJ	GB	0101000020E6100000A5F78DAF3DB3C8BFA227655243D94940
76555	EN6 1DG	GB	0101000020E6100000C4CDA96400A8C8BF855E7F129FD94940
76556	EN6 1ER	GB	0101000020E61000000135B56CAD2FC8BFDE73603942DA4940
76557	EN6 1HU	GB	0101000020E61000005680EF366F9CC6BF72A774B0FED94940
76558	EN6 1LQ	GB	0101000020E6100000A08A1BB7989FC7BF8690F3FE3FDA4940
76559	EN6 1LW	GB	0101000020E610000092770E65A88AC7BF2B85402E71DA4940
76560	EN6 1QP	GB	0101000020E61000002BDB87BCE5EAC7BF0C93A98251D94940
76561	EN6 1QY	GB	0101000020E610000068B0A9F3A8F8C7BFF7730AF2B3D94940
76562	EN6 1SB	GB	0101000020E6100000069E7B0F971CC7BF723106D671DA4940
76563	EN6 1SN	GB	0101000020E6100000B3B112F3ACA4C5BF6F29E78BBDD94940
76564	EN6 2AF	GB	0101000020E61000003BFBCA83F414C9BFA852B3075AD94940
76565	EN6 2DU	GB	0101000020E6100000473CD9CD8C7ECABFE529ABE97AD84940
76566	EN6 2EP	GB	0101000020E6100000B7B585E7A562C9BF100874266DD84940
76567	EN6 2LA	GB	0101000020E6100000417FA1478C9EC9BF5CE333D93FD94940
76568	EN6 3HB	GB	0101000020E610000055C2137AFD49CABFE3A8DC442DD94940
76569	EN6 3HZ	GB	0101000020E610000085CFD6C1C1DECABFDC4944F817D94940
76570	EN6 3LX	GB	0101000020E61000003BFE0B040132D0BFA818E76F42D94940
76571	EN6 4DG	GB	0101000020E6100000FD2D01F8A754C3BF61A7583508D94940
76572	EN6 4DU	GB	0101000020E6100000FD4B5299620EBEBFC5CA68E4F3DA4940
76573	EN6 4EQ	GB	0101000020E61000000055DCB8C5FCBCBF0ADB4FC6F8DA4940
76574	EN6 4HN	GB	0101000020E61000000D37E0F3C308BDBF5EF1D4230DDA4940
76575	EN6 4HY	GB	0101000020E6100000662D05A4FD0FBCBFA69BC420B0DA4940
76576	EN6 4JJ	GB	0101000020E610000090831266DAFEC1BF295E656D53DC4940
76577	EN6 4NX	GB	0101000020E610000025E7C41EDAC7C2BFBB63B14D2ADA4940
76578	EN6 4PR	GB	0101000020E6100000008BFCFA2136C0BF4E0B5EF415DC4940
76579	EN6 4QJ	GB	0101000020E6100000C6A695422097BCBF2524D236FEDA4940
76580	EN6 4RG	GB	0101000020E610000052B648DA8D3EBEBFE831CA332FDB4940
76581	EN6 5DD	GB	0101000020E610000013BBB6B75B92C5BFB988EFC4ACD94940
76582	EN7 5LF	GB	0101000020E6100000AEF36F97FDBAB7BF0B7E1B62BCDA4940
76583	EN7 5QW	GB	0101000020E610000010E9B7AF03E7ACBF6C239EEC66DA4940
76584	EN7 6BQ	GB	0101000020E6100000273108AC1C5AB0BFF48B12F417DC4940
76585	EN7 6LW	GB	0101000020E61000009D67EC4B361EACBF5303CDE7DCDB4940
76586	EN8	GB	0101000020E6100000CC988235CEA6A3BFB0AD9FFEB3D84940
76587	EN8 0EN	GB	0101000020E610000061A6ED5F596992BF8386FE092EDC4940
76588	EN8 0TA	GB	0101000020E61000002BC0779B374EA2BF1558005306DC4940
76589	EN8 7EG	GB	0101000020E6100000BC3D0801F912A2BF501A6A1492D84940
76590	EN8 7LU	GB	0101000020E6100000C6BE64E3C1169BBF226FB9FAB1D74940
76591	EN8 8JQ	GB	0101000020E6100000942EFD4B529992BF8FFD2C9622DB4940
76592	EN8 8LQ	GB	0101000020E6100000448B6CE7FBA9A1BFFF91E9D0E9D94940
76593	EN8 8UH	GB	0101000020E6100000632AFD84B35B9BBFCFF753E3A5D94940
76594	EN8 8UX	GB	0101000020E61000003049658A39089ABF917C259012DB4940
76595	EN8 9AQ	GB	0101000020E610000028B85851836998BF7FA0DCB6EFD94940
76596	EN8 9HJ	GB	0101000020E610000031410DDFC2BAA1BF3A3FC571E0D94940
76597	EN8 9RR	GB	0101000020E6100000A86DC328081E9FBF062B4EB516DA4940
76598	EN9 1HJ	GB	0101000020E610000047CCECF318E5693F2D98F8A3A8D74940
76599	EN9 1NG	GB	0101000020E61000004B5AF10D85CF763F2D7AA702EED74940
76600	EN9 1PQ	GB	0101000020E6100000FBCC599F724C563F60C8EA56CFD74940
76601	EN9 1ST	GB	0101000020E6100000FBAD9D280989843FF7915B936ED74940
76602	EN9 1UH	GB	0101000020E6100000D7FB8D76DCF08B3FB153AC1A84D74940
76603	EN9 1XQ	GB	0101000020E61000004FE8F527F1B953BF8FC6A17E17D84940
76604	EN9 2DF	GB	0101000020E6100000D6ABC8E88024AC3F71AB2006BADE4940
76605	EN9 2HB	GB	0101000020E6100000A94D9CDCEF50643F12A452EC68DE4940
76606	EN9 2HJ	GB	0101000020E6100000DCF63DEAAF57883FE50E9BC8CCDD4940
76607	EN9 2HS	GB	0101000020E6100000378C82E0F1EDA53F5F7AFB73D1DE4940
76608	EN9 2LD	GB	0101000020E610000089EE59D76839903FB89388F02FDE4940
76609	EN9 3NY	GB	0101000020E6100000541B9C887E6D9D3F9A05DA1D52D84940
76610	EN9 3QJ	GB	0101000020E61000008BA71E69705BA33F793BC269C1D94940
76611	EN91 1NS	GB	0101000020E61000009F55664AEB6FA13F2976340EF5D94940
76612	EX1	GB	0101000020E6100000346612F582EF0BC006685BCD3A5D4940
76613	EX1 1EE	GB	0101000020E610000092CB7F48BF3D0CC0A31EA2D11D5C4940
76614	EX1 1EZ	GB	0101000020E6100000DBC35E28603B0CC004ABEAE5775C4940
76615	EX1 1TQ	GB	0101000020E6100000180AD80E462C0CC0BCCFF1D1E25C4940
76616	EX1 2BG	GB	0101000020E61000007E5704FF5B090CC09E42AED4B35C4940
76617	EX1 2DR	GB	0101000020E6100000B7627FD93D190CC09D82FC6CE45C4940
76618	EX1 2DS	GB	0101000020E6100000566133C005190CC03A765089EB5C4940
76619	EX1 2PB	GB	0101000020E6100000371C96067E140CC00C957F2DAF5C4940
76620	EX1 2PP	GB	0101000020E6100000D865F84F37100CC031B5A50EF25C4940
76621	EX1 2PR	GB	0101000020E610000005F9D9C875130CC05036E50AEF5C4940
76622	EX1 2PU	GB	0101000020E610000052448655BC110CC07099D365315D4940
76623	EX1 2QD	GB	0101000020E6100000A27F828B15150CC0213CDA38625D4940
76624	EX1 2SQ	GB	0101000020E6100000F86BB2463D040CC0ADC090D5AD5C4940
76625	EX1 3EE	GB	0101000020E61000007BBDFBE3BD0A0CC02367614F3B5C4940
76626	EX1 3PB	GB	0101000020E6100000E1D4079277CE0BC0AF264F594D5D4940
76627	EX1 3SE	GB	0101000020E6100000EFC517EDF1C20BC0902DCBD7655E4940
76628	EX10	GB	0101000020E6100000C843DFDDCAF209C0738577B988574940
76629	EX10 0JQ	GB	0101000020E6100000F92EA52E19A709C0581B6327BC584940
76630	EX10 8ET	GB	0101000020E61000001F4C8A8F4FE809C0A489778027574940
76631	EX10 8NZ	GB	0101000020E6100000FF04172B6AF009C0A9C1340C1F574940
76632	EX10 8SG	GB	0101000020E6100000E50D30F31DFC09C00BB8E7F9D3564940
76633	EX10 9BD	GB	0101000020E6100000FED30D1478E709C0D6FECEF6E8574940
76634	EX10 9NN	GB	0101000020E6100000087250C24CDB09C0EE3D5C72DC594940
76635	EX10 9QA	GB	0101000020E6100000356090F469D509C0E27668588C584940
76636	EX10 9QF	GB	0101000020E6100000923D42CD90CA09C0C901BB9A3C594940
76637	EX10 9RX	GB	0101000020E61000004643C6A354E209C0A911FA997A594940
76638	EX10 9TU	GB	0101000020E6100000580394861AE509C078D4981073594940
76639	EX10 9UZ	GB	0101000020E6100000DCF0BBE996FD09C0EB5223F433594940
76640	EX11 1BY	GB	0101000020E6100000EE7C3F355E3A0AC008B0C8AF1F604940
76641	EX11 1BZ	GB	0101000020E610000036CEA623803B0AC0F20698F90E604940
76642	EX11 1EF	GB	0101000020E610000035D3BD4EEACB09C0B4226AA2CF5F4940
76643	EX11 1JJ	GB	0101000020E6100000168733BF9A230AC04F90D8EE1E604940
76644	EX11 1NP	GB	0101000020E6100000C9AB730CC83E0AC0BEA3C684985F4940
76645	EX11 1QB	GB	0101000020E61000007B832F4CA60A0AC09D64ABCB295D4940
76646	EX11 1RP	GB	0101000020E610000066136058FE3C0AC044FAEDEBC05F4940
76647	EX11 1SY	GB	0101000020E6100000008E3D7B2E330AC0C2887D0228604940
76648	EX11 1XJ	GB	0101000020E610000073309B00C3920AC0A4A7C821E25E4940
76649	EX12	GB	0101000020E6100000ED28CE5147A708C0354580D3BB5A4940
76650	EX12 2LL	GB	0101000020E61000006CB07092E68F08C02063EE5A425A4940
76651	EX12 2RU	GB	0101000020E6100000D3F71A82E39208C0E25817B7D15A4940
76652	EX12 3EQ	GB	0101000020E61000000D17B9A7ABBB08C0D65757056A594940
76653	EX12 3LB	GB	0101000020E61000002F6EA301BCC508C02E008DD2A5594940
76654	EX13 5BH	GB	0101000020E610000010E6762FF7E907C0C85D8429CA634940
76655	EX13 5EB	GB	0101000020E6100000F7E461A1D6F407C01DB0ABC953644940
76656	EX13 5ED	GB	0101000020E610000012842BA050EF07C03750E09D7C644940
76657	EX13 5EW	GB	0101000020E61000001F0E12A27CE107C02D5A80B6D5644940
76658	EX13 5NG	GB	0101000020E6100000B5A7E49CD80308C0DEAE97A608644940
76659	EX13 5PF	GB	0101000020E61000002BDEC83CF20708C03F8EE6C8CA634940
76660	EX13 5SW	GB	0101000020E6100000BCCCB051D6CF07C093020B60CA624940
76661	EX13 7	GB	0101000020E61000001171732A198008C08BFB8F4C87624940
76662	EX13 7AQ	GB	0101000020E6100000BFD53A71393E08C093020B60CA684940
76663	EX13 7BQ	GB	0101000020E61000005E68AED348CB07C0F20698F90E6A4940
76664	EX13 7PF	GB	0101000020E6100000B69F8CF1613608C0D1B1834A5C5F4940
76665	EX13 7PU	GB	0101000020E6100000CC79C6BE648308C076C4211B48634940
76666	EX14 1RQ	GB	0101000020E61000006364C91CCB9B09C0C37DE4D6A4654940
76667	EX14 1SQ	GB	0101000020E61000005EBEF561BD9109C0750305DEC9654940
76668	EX14 1SS	GB	0101000020E6100000E99E758D968309C092B245D26E664940
76669	EX14 2GU	GB	0101000020E6100000EB6E9EEA909B09C0CF15A58460654940
76670	EX14 2HS	GB	0101000020E610000023111AC1C67509C0F12900C633664940
76671	EX14 2YT	GB	0101000020E6100000DE76A1B94E8309C0B4588AE42B654940
76672	EX14 4QS	GB	0101000020E6100000A24621C9ACFE09C01D93C5FD476E4940
76673	EX14 4UF	GB	0101000020E61000004A5D328E918C09C08E791D71C86A4940
76674	EX14 8DA	GB	0101000020E610000011FDDAFAE97F09C0AAB8718BF9654940
76675	EX14 9DG	GB	0101000020E6100000AEF36F97FDBA08C030B95164AD694940
76676	EX14 9JN	GB	0101000020E61000009198A0866F0109C0A3C9C51858654940
76677	EX14 9NA	GB	0101000020E61000000740DCD5AB480AC08A1EF818AC644940
76678	EX15	GB	0101000020E6100000DE91B1DAFCFF0AC05858703FE0714940
76679	EX15 1JP	GB	0101000020E61000002E71E481C8220BC021EA3E00A96D4940
76680	EX15 2AP	GB	0101000020E6100000B6696CAF059D0AC0DBFAE93F6B704940
76681	EX15 2HH	GB	0101000020E610000069E55E6056480AC0C30FCEA78E6F4940
76682	EX15 2LB	GB	0101000020E61000006BD3D85E0BBA0AC0DE02098A1F694940
76683	EX15 2LF	GB	0101000020E6100000B682A62556C60AC0A9FA95CE87674940
76684	EX15 2PH	GB	0101000020E6100000F2D077B7B2040BC0B5A50EF27A724940
76685	EX15 2RB	GB	0101000020E6100000A5DAA7E331A30AC07C0DC171196D4940
76686	EX15 2RE	GB	0101000020E61000000989B48D3FB10AC0AA99B514906E4940
76687	EX15 2SA	GB	0101000020E6100000AC5791D101E90AC01EA9BEF38B724940
76688	EX15 3AF	GB	0101000020E61000008CDAFD2AC0B70AC07841446ADA734940
76689	EX15 3RJ	GB	0101000020E6100000321F10E84CDA09C089247A19C5744940
76690	EX15 3XZ	GB	0101000020E6100000035C902DCB370AC0B459F5B9DA744940
76691	EX16	GB	0101000020E61000006325E65949CB0BC09CDF30D120754940
76692	EX16 4	GB	0101000020E61000005C3E92921EC60BC064EAAEEC82734940
76693	EX16 4DL	GB	0101000020E610000065E08096AEC00BC03B8A73D4D1734940
76694	EX16 4DN	GB	0101000020E61000000E10CCD1E3B70BC02BDEC83CF2734940
76695	EX16 4DU	GB	0101000020E61000006F7EC34483B40BC0A19FA9D72D744940
76696	EX16 4ND	GB	0101000020E6100000AF44A0FA07910BC0CDEA1D6E87744940
76697	EX16 4NJ	GB	0101000020E61000006666666666860BC0412D060FD3724940
76698	EX16 5HH	GB	0101000020E610000002284696CCF10BC0A8E49CD843734940
76699	EX16 6DN	GB	0101000020E6100000F86C1D1CECCD0BC01077F52A32744940
76700	EX16 6HH	GB	0101000020E6100000EE5D83BEF4D60BC0417FA1478C744940
76701	EX16 6JA	GB	0101000020E61000005D3123BC3DC80BC085ED27637C744940
76702	EX16 6TS	GB	0101000020E6100000703E75AC52BA0BC0D4B837BF61744940
76703	EX16 6XL	GB	0101000020E6100000F2272A1BD6D40BC0D6ABC8E880744940
76704	EX16 7AZ	GB	0101000020E6100000E884D04197500BC0A2EBC20FCE734940
76705	EX16 7HT	GB	0101000020E6100000EC3026FDBDB40AC0D46531B1F9784940
76706	EX16 7RQ	GB	0101000020E6100000EDB94C4D82D70BC0051901158E764940
76707	EX16 8BA	GB	0101000020E6100000800D8810572E0CC082531F48DE754940
76708	EX16 8BN	GB	0101000020E61000004302469737A70CC05FEB5223F4734940
76709	EX16 8NX	GB	0101000020E61000003D484F9143A40DC0548D5E0D50724940
76710	EX16 9	GB	0101000020E610000029E8F692C6C80CC01310937021814940
76711	EX16 9AE	GB	0101000020E6100000E9633E20D0B90BC03EAF78EA91804940
76712	EX16 9AJ	GB	0101000020E6100000D464C6DB4AAF0BC055A0168387734940
76713	EX16 9BY	GB	0101000020E6100000FA7B293C68D60BC0CE8C7E349C824940
76714	EX16 9PP	GB	0101000020E6100000B0CBF09F6E600CC0081EDFDE357A4940
76715	EX16 9PR	GB	0101000020E610000049F7730AF2130CC02E9276A38F774940
76716	EX17	GB	0101000020E6100000CEFBFF3861220DC076C6F7C5A56A4940
76717	EX17 2EJ	GB	0101000020E610000080D591239D610DC0662E7079AC654940
76718	EX17 3BL	GB	0101000020E61000009B38B9DFA1280DC068CEFA9463644940
76719	EX17 3BY	GB	0101000020E6100000E085ADD9CA2B0DC084D72E6D38644940
76720	EX17 4BS	GB	0101000020E610000006F1811DFF450DC0C0B4A84F72694940
76721	EX17 4LE	GB	0101000020E61000005C1FD61BB5020DC02426A8E15B6E4940
76722	EX17 4SW	GB	0101000020E61000005CE674594C0C0EC0105839B4C8764940
76723	EX17 4UA	GB	0101000020E61000009082A7902B150EC0A27DACE0B7734940
76724	EX17 5JA	GB	0101000020E61000002463B5F97FD50DC0FCE25295B6624940
76725	EX17 5JB	GB	0101000020E6100000DF18028063CF0DC0BC7669C361634940
76726	EX17 5LR	GB	0101000020E610000058E6ADBA0E350EC02881CD39786A4940
76727	EX17 5NE	GB	0101000020E6100000083C3080F0010EC0CD3CB9A640684940
76728	EX17 6AW	GB	0101000020E6100000A54E401361A30EC0336ABE4A3E6E4940
76729	EX17 6EZ	GB	0101000020E610000069E21DE0498B0EC013807F4A95664940
76730	EX17 6HZ	GB	0101000020E610000004E78C28ED8D0EC08C2E6F0ED7644940
76731	EX17 6LN	GB	0101000020E61000004DA1F31ABBC40EC0B0ABC95356674940
76732	EX17 6QU	GB	0101000020E610000013D4F02DAC7B0EC086AFAF75A96D4940
76733	EX18	GB	0101000020E6100000D0D4EB1681910EC0E719FB928D734940
76734	EX18 7AG	GB	0101000020E6100000C7BAB88D06100FC0C3D66CE525774940
76735	EX18 7BH	GB	0101000020E610000041D47D0052FB0EC09B711AA20A754940
76736	EX18 7JZ	GB	0101000020E6100000D314014EEF020FC0A98592C9A9714940
76737	EX19 8AP	GB	0101000020E6100000508C2C9963990FC0B0E595EB6D6D4940
76738	EX19 8DN	GB	0101000020E61000002F4D11E0F4CE0FC0AD510FD1E8704940
76739	EX19 8NS	GB	0101000020E610000032C9C859D85310C031B5A50EF2764940
76740	EX19 8QH	GB	0101000020E61000009D64ABCB292110C086FF740305724940
76741	EX2	GB	0101000020E61000005C76887FD8120CC0726BD26D895A4940
76742	EX2 4AS	GB	0101000020E6100000D7A4DB12B9000CC0D4F36E2C285C4940
76743	EX2 4BW	GB	0101000020E61000005C3CBCE7C0320CC0ACCABE2B825B4940
76744	EX2 4EU	GB	0101000020E6100000F88BD99255310CC02A8D98D9E75B4940
76745	EX2 4NT	GB	0101000020E6100000BB29E5B5121A0CC097C79A91415C4940
76746	EX2 4PA	GB	0101000020E6100000D31742CEFB1F0CC0B1FA230C035C4940
76747	EX2 4PL	GB	0101000020E610000089963C9E961F0CC08DF161F6B25B4940
76748	EX2 6BU	GB	0101000020E6100000FB75A73B4FFC0BC0B1A547533D5B4940
76749	EX2 6EB	GB	0101000020E61000002B6A300DC3070CC04FCE50DCF15A4940
76750	EX2 6LG	GB	0101000020E610000089997D1EA3FC0BC0336C94F59B594940
76751	EX2 7	GB	0101000020E610000061A6ED5F59090CC075ABE7A4F7594940
76752	EX2 7AW	GB	0101000020E6100000E21FB6F468CA0BC05EA10F96B15B4940
76753	EX2 7BH	GB	0101000020E610000054FEB5BC72FD0BC0F2EB87D860594940
76754	EX2 7DZ	GB	0101000020E610000085EAE6E26FDB0BC0C4978922A4584940
76755	EX2 7EB	GB	0101000020E6100000BA111615715A0CC05C3B5112125B4940
76756	EX2 7HY	GB	0101000020E610000055A2EC2DE5DC0BC0FC54151A885B4940
76757	EX2 8TZ	GB	0101000020E61000009414580053460CC025581CCEFC584940
76758	EX2 9BE	GB	0101000020E6100000FED478E926510CC02920ED7F805B4940
76759	EX2 9BP	GB	0101000020E610000035D07CCEDD4E0CC0C1A73979915B4940
76760	EX2 9EJ	GB	0101000020E61000009D103AE8124E0CC0CF9F36AAD35B4940
76761	EX20	GB	0101000020E6100000252026E142DE0FC0FDA204FD85664940
76762	EX20 1AS	GB	0101000020E6100000494739984D0010C01118EB1B985E4940
76763	EX20 1EH	GB	0101000020E610000039622D3E050010C066683C11C45D4940
76764	EX20 1SY	GB	0101000020E610000007978E39CFF80FC028637C98BD5E4940
76765	EX20 2BB	GB	0101000020E6100000F2086EA46C310FC0DA56B3CEF8644940
76766	EX20 2BY	GB	0101000020E610000069E21DE0490B0FC0BAC0E5B166664940
76767	EX20 2HX	GB	0101000020E6100000CAFACDC474210FC03333333333594940
76768	EX20 2JT	GB	0101000020E6100000A2B8E34D7E4B0FC0A5BE2CEDD45C4940
76769	EX20 2NG	GB	0101000020E6100000C4CDA96400680FC0F9669B1BD35D4940
76770	EX20 2NH	GB	0101000020E610000011E0F42EDE6F0FC051DD5CFC6D5D4940
76771	EX20 3AD	GB	0101000020E610000081ECF5EE8F1710C0FBC9181F66614940
76772	EX20 3BN	GB	0101000020E6100000F8DD74CB0E8110C005C24EB16A624940
76773	EX20 3QW	GB	0101000020E61000005778978BF8EE0FC0A1698995D1664940
76774	EX20 3RF	GB	0101000020E610000099D6A6B1BD0610C0C30E63D2DF654940
76775	EX20 4BH	GB	0101000020E6100000CDE67118CC6F10C090F9804067524940
76776	EX20 4EL	GB	0101000020E6100000A019C407766C10C0F88A6EBDA6574940
76777	EX20 4HB	GB	0101000020E6100000F3AD0FEB8D6A10C00BD3F71A82574940
76778	EX20 4HE	GB	0101000020E6100000B9C667B27F5E10C0F8510DFB3D554940
76779	EX20 4HF	GB	0101000020E61000004A60730E9E5910C0CFD72C978D544940
76780	EX20 4LR	GB	0101000020E61000002DEBFEB1102D10C0F4C0C760C55B4940
76781	EX20 4PW	GB	0101000020E61000005534D6FECEC610C073F38DE89E534940
76782	EX20 6QW	GB	0101000020E61000006BD619DF17D70EC0EA060ABC935B4940
76783	EX21 5BY	GB	0101000020E6100000C2137AFD490C11C0048E041A6C604940
76784	EX21 5LT	GB	0101000020E6100000266DAAEE919D10C0054D4BAC8C684940
76785	EX21 5PT	GB	0101000020E6100000B9A5D590B8B710C0815F2349106A4940
76786	EX21 5QA	GB	0101000020E610000048F949B54FC710C08753E6E61B654940
76787	EX21 5QU	GB	0101000020E61000005D6E30D461F510C02CD8463CD96F4940
76788	EX21 5UJ	GB	0101000020E6100000D55E44DB31D510C04ACE893DB4634940
76789	EX21 5UW	GB	0101000020E6100000BA84436FF10011C097E2AAB2EF624940
76790	EX21 5XR	GB	0101000020E610000065E256410CD410C0C8409E5DBE634940
76791	EX22	GB	0101000020E61000003C6C2233176811C082A8FB00A4684940
76792	EX22 6DL	GB	0101000020E6100000992A1895D46911C019FF3EE3C2674940
76793	EX22 6LD	GB	0101000020E6100000A2629CBF09D511C0E60819C8B35F4940
76794	EX22 7HU	GB	0101000020E6100000B5C35F93357A11C02F50526001684940
76795	EX22 7QX	GB	0101000020E6100000F0E0270EA09F11C0849F38807E754940
76796	EX22 7TR	GB	0101000020E61000008D45D3D9C9B011C0FAD005F52D734940
76797	EX22 7XY	GB	0101000020E6100000D656EC2FBB0711C0CAFE791A30684940
76798	EX23	GB	0101000020E6100000CC43A67C082A12C0E84F1BD5E96A4940
76799	EX23 8AP	GB	0101000020E61000004739984D802112C07BDCB75A276A4940
76800	EX23 8DJ	GB	0101000020E61000004DDA54DD232B12C0D908C4EBFA694940
76801	EX23 8NP	GB	0101000020E6100000D4BB783F6E2F12C01B6327BC046B4940
76802	EX23 8NW	GB	0101000020E6100000C573B680D02A12C0AB5D13D21A6B4940
76803	EX23 9BQ	GB	0101000020E6100000D993C0E61C0C12C0282A1BD6546A4940
76804	EX23 9EE	GB	0101000020E61000004AF086342A3012C06CB07092E66B4940
76805	EX23 9HE	GB	0101000020E61000004815C5ABAC1D12C0151E34BBEE6B4940
76806	EX23 9LB	GB	0101000020E6100000F5824F73F2F211C09240834D9D6B4940
76807	EX23 9QW	GB	0101000020E610000015AC71361DF111C0C382FB010F704940
76808	EX24 6BH	GB	0101000020E610000084B70721201F09C0E200FA7DFF604940
76809	EX24 6HN	GB	0101000020E6100000C5AC1743399108C0C1A8A44E405D4940
76810	EX24 6ND	GB	0101000020E6100000A88DEA74208B08C0FB5C6DC5FE5E4940
76811	EX24 6SL	GB	0101000020E610000085CD001764AB08C0FC6D4F90D8604940
76812	EX29 6QS	GB	0101000020E6100000177FDB1324560EC0513239B5335A4940
76813	EX3 0AF	GB	0101000020E6100000A913D044D8B00BC0EC4B361E6C574940
76814	EX3 0AR	GB	0101000020E61000004B5AF10D85AF0BC07784D38217574940
76815	EX3 0DS	GB	0101000020E6100000C26B97361CB60BC0D97745F0BF574940
76816	EX3 0PN	GB	0101000020E61000009F3C2CD49A860BC00708E6E8F1554940
76817	EX3 0PR	GB	0101000020E610000032E719FB928D0BC0AD32535A7F554940
76818	EX30	GB	0101000020E61000004E469561DCCD10C0CAA31B6151854940
76819	EX31	GB	0101000020E6100000F9F4D896014710C0642310AFEB894940
76820	EX31 1PS	GB	0101000020E61000008BA71E69703B10C083DA6FED448B4940
76821	EX31 2AU	GB	0101000020E61000003B8A73D4D14110C056B77A4E7A894940
76822	EX31 2DS	GB	0101000020E6100000BF982D59155110C055DD239BAB884940
76823	EX31 2ND	GB	0101000020E6100000C971A774B06E10C0B131AF230E894940
76824	EX31 2NX	GB	0101000020E61000005167EE21E17B10C0D7851F9C4F894940
76825	EX31 3AE	GB	0101000020E6100000F355F2B1BB3010C0CAF962EFC5894940
76826	EX31 3BL	GB	0101000020E61000009EF0129CFA8010C0C79FA86C58894940
76827	EX31 3BZ	GB	0101000020E61000000F62670A9D8710C08E78B29B19894940
76828	EX31 3DD	GB	0101000020E6100000D926158DB57F10C0B20DDC813A894940
76829	EX31 3EH	GB	0101000020E610000066F9BA0CFF9910C008E9297288884940
76830	EX31 4AQ	GB	0101000020E6100000994869368F4310C0F4A44C6A688B4940
76831	EX31 4BY	GB	0101000020E61000005A63D009A16310C015C440D7BE8C4940
76832	EX31 4JD	GB	0101000020E6100000FAD005F52D3310C06937FA980F8C4940
76833	EX31 4QE	GB	0101000020E610000043C9E4D4CE700FC010CD3CB9A69A4940
76834	EX31 4RQ	GB	0101000020E6100000473CD9CD8C7E0FC041D7BE805E904940
76835	EX31 4RW	GB	0101000020E610000041D5E8D500A50FC07D09151C5E8E4940
76836	EX31 4SS	GB	0101000020E61000003599F1B6D2AB0FC0BA2EFCE07C904940
76837	EX32	GB	0101000020E6100000E542E55FCBEB0FC02881CD39788C4940
76838	EX32 0AF	GB	0101000020E6100000062CB98AC52F10C039984D8061874940
76839	EX32 0BP	GB	0101000020E6100000C0AE264F591D10C008E8BE9CD9864940
76840	EX32 0ND	GB	0101000020E61000006D3656629EF50FC0A3E5400FB5874940
76841	EX32 0PX	GB	0101000020E6100000923F1878EEBD0FC08C69A67B9D864940
76842	EX32 0QA	GB	0101000020E6100000A0504F1F819F0FC0A22424D236864940
76843	EX32 0QX	GB	0101000020E610000015FDA19927970FC0B8054B7501874940
76844	EX32 0RE	GB	0101000020E6100000849A215514EF0EC0A2427573F1854940
76845	EX32 0SG	GB	0101000020E61000001A87FA5DD85A0FC05C7171546E884940
76846	EX32 0SX	GB	0101000020E6100000A587A1D5C9390FC003EB387EA8884940
76847	EX32 7EU	GB	0101000020E6100000656D533C2E3A10C0111E6D1CB18A4940
76848	EX32 7NR	GB	0101000020E61000008F6E844545FC0FC078465B95448C4940
76849	EX32 8	GB	0101000020E61000005F5CAAD2163710C0A2F0D93A388A4940
76850	EX32 8NR	GB	0101000020E6100000BB09BE69FA3C10C00420EEEA558A4940
76851	EX32 8PG	GB	0101000020E6100000BFB9BF7ADC2710C084D382177D894940
76852	EX32 9EE	GB	0101000020E61000002FDE8FDB2F2F10C007280D350A894940
76853	EX32 9EN	GB	0101000020E6100000828C800A473010C0FAB48AFED0884940
76854	EX32 9JR	GB	0101000020E610000052B5DD04DF3410C038D89B1892894940
76855	EX33 1AA	GB	0101000020E6100000B2F50CE198A510C00F61FC34EE8D4940
76856	EX33 1AR	GB	0101000020E61000008B36C7B94DA810C0F3CB608C488E4940
76857	EX33 1EG	GB	0101000020E6100000EE06D15AD1A610C0929735B1C08D4940
76858	EX33 1EL	GB	0101000020E6100000A33D5E4887A710C07D5C1B2AC68D4940
76859	EX33 1LX	GB	0101000020E61000001D3C139A24E610C0F94CF6CFD3904940
76860	EX33 1NN	GB	0101000020E610000044A67C08AAE610C0055262D7F6904940
76861	EX33 1PA	GB	0101000020E6100000B134F0A31AF610C001DF6DDE38914940
76862	EX33 1PF	GB	0101000020E6100000732B84D558E210C0C24CDBBFB2904940
76863	EX33 2BG	GB	0101000020E61000007D2079E750A610C05BB6D617098D4940
76864	EX33 2DX	GB	0101000020E6100000D5CA845FEAA710C0F71E2E39EE8C4940
76865	EX33 2LG	GB	0101000020E61000008F37F92D3A9910C02C8194D8B58D4940
76866	EX34	GB	0101000020E6100000F6D214014E7F10C0AF3F89CF9D9A4940
76867	EX34 0DS	GB	0101000020E61000003A05F9D9C81510C03B014D840D9B4940
76868	EX34 7DG	GB	0101000020E6100000AF05BD3786D010C07974232C2A964940
76869	EX34 7DU	GB	0101000020E6100000C4961E4DF5D410C09AB67F65A5974940
76870	EX34 8AU	GB	0101000020E6100000E012807F4A8510C066F7E461A19A4940
76871	EX34 8EQ	GB	0101000020E61000004F04711E4E8010C04C8DD0CFD4994940
76872	EX34 8HX	GB	0101000020E6100000C8EA56CF497F10C08B4E965AEF994940
76873	EX34 8LQ	GB	0101000020E61000009C86A8C29F7110C03B3602F1BA9A4940
76874	EX34 9	GB	0101000020E61000001C615111A77310C029064834819A4940
76875	EX34 9LG	GB	0101000020E6100000D7DCD1FF727D10C054A9D903AD9A4940
76876	EX34 9PQ	GB	0101000020E6100000454948A46D5C10C0BDE47FF2779B4940
76877	EX34 9SB	GB	0101000020E61000002BA226FA7C4410C06C41EF8D219A4940
76878	EX34 9TB	GB	0101000020E610000092AD2EA7044410C09F008A9125994940
76879	EX35 6AL	GB	0101000020E6100000E412471E88AC0EC0A7CD380D519D4940
76880	EX35 6LN	GB	0101000020E61000005F44DB3175970EC0560BEC3191984940
76881	EX35 6ND	GB	0101000020E610000041F4A44C6A280FC026E0D748129A4940
76882	EX35 6NT	GB	0101000020E6100000AAD72D02635D0EC06E15C440D79C4940
76883	EX36 3AA	GB	0101000020E6100000D2A8C0C936B00EC05470784144824940
76884	EX36 3AB	GB	0101000020E6100000414AECDADEAE0EC07880272D5C824940
76885	EX36 3AZ	GB	0101000020E6100000A568E55E60B60EC03B53E8BCC6824940
76886	EX36 3QS	GB	0101000020E61000007286E28E37190EC0630D17B9A7834940
76887	EX36 4DN	GB	0101000020E610000091D442C9E4B40EC03BAC70CB47824940
76888	EX36 4NL	GB	0101000020E610000072FC5069C4AC0EC03A1E335019834940
76889	EX37 9AB	GB	0101000020E610000091D5AD9E93DE0FC033897AC1A77F4940
76890	EX37 9DZ	GB	0101000020E610000005FD851E311A10C0FD86890629824940
76891	EX37 9EU	GB	0101000020E6100000E789E76C01410FC0E6B0FB8EE1774940
76892	EX37 9LG	GB	0101000020E61000003E5DDDB1D8E60FC0CFF3A78DEA764940
76893	EX37 9NB	GB	0101000020E6100000E27327D87F9D0FC01920D1048A7A4940
76894	EX37 9NE	GB	0101000020E6100000DC0F786000610FC03543AA285E794940
76895	EX38	GB	0101000020E610000085ECBC8DCD6E10C010C99063EB794940
76896	EX38 7EJ	GB	0101000020E6100000F8C264AA605410C064CC5D4BC8774940
76897	EX38 7JX	GB	0101000020E61000003D821B295B5410C0E333D93F4F7B4940
76898	EX39	GB	0101000020E6100000266DAAEE91CD10C024D236FE44854940
76899	EX39 1PP	GB	0101000020E6100000EFCA2E185CC310C0897B2C7DE8864940
76900	EX39 1PS	GB	0101000020E61000009D6516A1D8CA10C0D906EE409D864940
76901	EX39 1PX	GB	0101000020E610000020F0C000C2C710C00EBDC5C37B864940
76902	EX39 1TU	GB	0101000020E61000007CD6355A0ED410C04B3D0B4279854940
76903	EX39 1XN	GB	0101000020E6100000813E912749E710C0A2EC2DE57C854940
76904	EX39 3AR	GB	0101000020E6100000158DB5BFB3DD10C032772D211F824940
76905	EX39 3DX	GB	0101000020E6100000EE05668522ED10C0EA08E066F1804940
76906	EX39 3EX	GB	0101000020E61000001C0C7558E1D610C08B36C7B94D824940
76907	EX39 3HB	GB	0101000020E6100000B47405DB88E710C0BA83D89942814940
76908	EX39 3JE	GB	0101000020E6100000C80BE9F010D610C07061DD7877824940
76909	EX39 3PR	GB	0101000020E610000086032159C0E410C09FAC18AE0E844940
76910	EX39 3PS	GB	0101000020E6100000CC63CDC820E710C0361E6CB1DB834940
76911	EX39 3RX	GB	0101000020E6100000DBF97E6ABC3411C034B91803EB7E4940
76912	EX39 4DP	GB	0101000020E6100000B2BAD573D2CB10C0CF4E0647C9814940
76913	EX39 4LN	GB	0101000020E61000003BFE0B0401B210C095D39E9273864940
76914	EX39 4PB	GB	0101000020E61000009F758D96038D10C0130EBDC5C3834940
76915	EX39 4RD	GB	0101000020E610000012F5824F73A210C07EA7C98CB7814940
76916	EX39 5AW	GB	0101000020E61000009F3C2CD49A1611C09A94826E2F7F4940
76917	EX39 5EL	GB	0101000020E61000003D0B42791F0711C0516C054D4B7C4940
76918	EX39 5HN	GB	0101000020E6100000EBC891CEC0E810C044A7E7DD587E4940
76919	EX39 5LR	GB	0101000020E610000006836BEEE8FF10C0AE49B725727B4940
76920	EX39 6BD	GB	0101000020E61000001590F63FC0EA11C03C2F151BF37E4940
76921	EX39 6EH	GB	0101000020E610000095BA641C23E911C0C1CAA145B67B4940
76922	EX39 6HG	GB	0101000020E61000008484285FD01212C060AC6F6072774940
76923	EX4	GB	0101000020E610000099840B7904B70BC0B58B69A67B614940
76924	EX4 0	GB	0101000020E6100000F0A7C64B37C90BC0FC372F4E7C634940
76925	EX4 1AJ	GB	0101000020E610000040A6B5696C4F0CC0E659492BBE5B4940
76926	EX4 1NQ	GB	0101000020E6100000066344A2D0720CC0EC51B81E855B4940
76927	EX4 1RB	GB	0101000020E6100000AE2B6684B7670CC06AFAEC80EB5C4940
76928	EX4 1RG	GB	0101000020E6100000E65AB4006D6B0CC05BD07B63085C4940
76929	EX4 2BB	GB	0101000020E610000030A017EE5C380CC04033880FEC5C4940
76930	EX4 2EL	GB	0101000020E6100000BA490C022B670CC065A9F57EA35D4940
76931	EX4 2HA	GB	0101000020E6100000C3633F8BA5880CC0C70E2A711D5B4940
76932	EX4 2LD	GB	0101000020E61000004F3BFC3559C30CC0D93D7958A85D4940
76933	EX4 2PN	GB	0101000020E61000006EDE3829CC7B0CC055BDFC4E935D4940
76934	EX4 3AN	GB	0101000020E6100000102043C70E4A0CC02461DF4E225C4940
76935	EX4 3BH	GB	0101000020E6100000B98D06F016480CC01844A4A65D5C4940
76936	EX4 3BL	GB	0101000020E6100000B0FF3A376D460CC03F0114234B5C4940
76937	EX4 3ET	GB	0101000020E61000006B7F677BF4460CC0AC6F6072A35C4940
76938	EX4 3SB	GB	0101000020E6100000A915A6EF35440CC032E9EFA5F05C4940
76939	EX4 4	GB	0101000020E6100000CF8250DEC7510CC015580053065E4940
76940	EX4 4DZ	GB	0101000020E61000003A75E5B33C4F0CC06C223317B85C4940
76941	EX4 4JS	GB	0101000020E61000009274CDE49B4D0CC022AB5B3D275D4940
76942	EX4 4LR	GB	0101000020E6100000DDB3AED172400CC0E6CFB7054B5D4940
76943	EX4 4NR	GB	0101000020E6100000A305685BCD3A0CC09510ACAA975D4940
76944	EX4 4NT	GB	0101000020E61000007A39ECBE63580CC08B6D52D1585D4940
76945	EX4 4NY	GB	0101000020E6100000B4C876BE9F5A0CC0B0E3BF40105E4940
76946	EX4 4PH	GB	0101000020E610000054ABAFAE0A540CC07DB3CD8DE95D4940
76947	EX4 4PS	GB	0101000020E6100000EC87D860E1440CC0766B990CC75D4940
76948	EX4 4QG	GB	0101000020E6100000DDEEE53E394A0CC09450FA42C85D4940
76949	EX4 4RG	GB	0101000020E6100000D540F339775B0CC0583849F3C75E4940
76950	EX4 4RP	GB	0101000020E61000002634492C29570CC059DB148F8B5E4940
76951	EX4 4SF	GB	0101000020E61000002C80290307340CC02E7590D7835D4940
76952	EX4 5AR	GB	0101000020E610000084B9DDCB7D520CC081785DBF605F4940
76953	EX4 5DJ	GB	0101000020E6100000C72C7B12D81C0CC0AB3FC230605F4940
76954	EX4 6	GB	0101000020E6100000088ECBB8A9210CC005C58F31775D4940
76955	EX4 6AP	GB	0101000020E6100000F10F5B7A34350CC01D058882195D4940
76956	EX4 6DA	GB	0101000020E61000002DB308C556300CC0B62DCA6C905D4940
76957	EX4 6DJ	GB	0101000020E6100000AF777FBC572D0CC08884EFFD0D5E4940
76958	EX4 6JA	GB	0101000020E6100000F8325184D42D0CC052D66F26A65D4940
76959	EX4 6JT	GB	0101000020E6100000F9D9C875532A0CC0FEB4519D0E5E4940
76960	EX4 6LJ	GB	0101000020E6100000A06CCA15DE250CC0A4A5F276845D4940
76961	EX4 6LT	GB	0101000020E6100000091A33897A210CC004FF5BC98E5D4940
76962	EX4 6LW	GB	0101000020E610000061C26856B62F0CC062A06B5F405D4940
76963	EX4 6NF	GB	0101000020E610000015AC71361D210CC03E3DB665C05D4940
76964	EX4 6QB	GB	0101000020E6100000BF44BC75FE2D0CC0EC51B81E855D4940
76965	EX4 6RF	GB	0101000020E61000003BA759A0DD210CC08F352383DC5D4940
76966	EX4 6SD	GB	0101000020E6100000D88349F1F1290CC0B247A819525D4940
76967	EX4 6TG	GB	0101000020E610000064E60297C73A0CC089CF9D60FF5D4940
76968	EX4 7BE	GB	0101000020E610000074D190F128150CC0EAE923F0875D4940
76969	EX4 7BQ	GB	0101000020E610000046B58828260F0CC007EC6AF2945D4940
76970	EX4 7JF	GB	0101000020E61000003E5DDDB1D8060CC0F31E679AB05D4940
76971	EX4 7JZ	GB	0101000020E6100000E198654F023B0CC0F4FBFECD8B5D4940
76972	EX4 8AB	GB	0101000020E610000084622B685A020CC0C1560916875D4940
76973	EX4 8AF	GB	0101000020E6100000BC77D49810F30BC07CB43863985D4940
76974	EX4 8AW	GB	0101000020E6100000B66801DA56F30BC04224438EAD5D4940
76975	EX4 8BR	GB	0101000020E6100000711B0DE02DF00BC01FF64201DB5D4940
76976	EX4 8DQ	GB	0101000020E610000066A032FE7DE60BC0F030ED9BFB5D4940
76977	EX4 8LL	GB	0101000020E6100000B54E5C8E57000CC07D789620235E4940
76978	EX4 9EA	GB	0101000020E61000006EF8DD74CB0E0CC0AF777FBC575D4940
76979	EX5	GB	0101000020E6100000317E1AF7E6170CC0AE49B725725D4940
76980	EX5 1DE	GB	0101000020E61000001B0FB6D8ED930BC0E94482A9665A4940
76981	EX5 1EE	GB	0101000020E6100000302E55698B2B0BC0E78BBD175F5E4940
76982	EX5 1PR	GB	0101000020E61000007EFCA5457D320BC0F660527C7C584940
76983	EX5 2EQ	GB	0101000020E61000003F1C2444F9220BC002BB9A3C655F4940
76984	EX5 2JS	GB	0101000020E610000043588D25ACCD0AC0535BEA20AF594940
76985	EX5 2PE	GB	0101000020E6100000A08A1BB7981F0BC099620E828E624940
76986	EX5 2QW	GB	0101000020E6100000A04FE449D2D50AC0EB724A404C624940
76987	EX5 2RJ	GB	0101000020E6100000D1CB28965B9A0AC084F23E8EE6644940
76988	EX5 3HJ	GB	0101000020E6100000CF84268925850BC05C751DAA29614940
76989	EX5 3LE	GB	0101000020E6100000C9207711A6A80BC09966BAD749654940
76990	EX5 4AS	GB	0101000020E6100000FAEE5696E80C0CC02C67EF8CB6624940
76991	EX5 4HR	GB	0101000020E6100000E1CFF0660DDE0BC058CB9D9960684940
76992	EX5 4JH	GB	0101000020E6100000D4BA0D6ABFD50BC040FA264D83684940
76993	EX5 4NP	GB	0101000020E6100000B3B3E89D0A580BC0E57B4622346A4940
76994	EX5 4QX	GB	0101000020E6100000CBD58F4DF2630BC08A8F4FC8CE694940
76995	EX5 5AB	GB	0101000020E6100000369204E10A880CC07233DC80CF614940
76996	EX5 5AP	GB	0101000020E61000002AE620E868B50CC01DC9E53FA4634940
76997	EX5 5DE	GB	0101000020E6100000DECCE847C3A90CC0F392FFC9DF614940
76998	EX5 5LB	GB	0101000020E610000069E388B5F8540CC08C48145AD6694940
76999	EX5 5NG	GB	0101000020E6100000B612BA4BE24C0CC04CFDBCA948674940
77000	EX6	GB	0101000020E6100000BF9A030473140CC0E2CAD93BA3574940
77001	EX6 6NB	GB	0101000020E6100000E0BE0E9C33220EC02B8716D9CE5B4940
77002	EX6 6PB	GB	0101000020E61000003DF20703CF7D0EC0DBC4C9FD0E594940
77003	EX6 6QD	GB	0101000020E61000008EC9E2FE23D30DC044317903CC584940
77004	EX6 6RD	GB	0101000020E6100000BD8DCD8E547F0EC0526342CC255B4940
77005	EX6 7DD	GB	0101000020E61000005F96766A2E770DC0A779C7293A584940
77006	EX6 7EF	GB	0101000020E6100000C8CD70033E7F0DC089B48D3F51574940
77007	EX6 7EG	GB	0101000020E6100000B60F79CBD58F0DC09983A0A355574940
77008	EX6 7EQ	GB	0101000020E610000027F6D03E56900DC0459E245D33574940
77009	EX6 7HS	GB	0101000020E6100000657094BC3A670DC07B88467710554940
77010	EX6 7JD	GB	0101000020E6100000073F7100FD3E0DC05E4BC8073D554940
77011	EX6 7JJ	GB	0101000020E61000005C0531D0B56F0DC0CAE1934E24584940
77012	EX6 7YL	GB	0101000020E6100000247F30F0DC5B0CC0164CFC51D4554940
77013	EX6 8HS	GB	0101000020E610000036C8242367E10BC0111C9771534F4940
77014	EX6 8HW	GB	0101000020E6100000C4060B2769FE0BC09D668176874E4940
77015	EX6 8JE	GB	0101000020E61000005B26C3F17CC60BC0CA349A5C8C514940
77016	EX6 8JQ	GB	0101000020E610000079E6E5B0FBAE0BC0EE42739D46524940
77017	EX6 8ND	GB	0101000020E610000005E09F5225CA0BC0710514EAE9514940
77018	EX6 8PA	GB	0101000020E6100000D00B772E8C940BC0255AF2785A504940
77019	EX6 8PP	GB	0101000020E61000001D8EAED2DD950BC0D9CD8C7E34504940
77020	EX6 8SP	GB	0101000020E61000009B046F48A3020CC0E2AE5E4546574940
77021	EX7	GB	0101000020E61000006FB72407ECAA0BC0EA4141295A4D4940
77022	EX7 0AJ	GB	0101000020E61000005053CBD6FAA20BC0C34A0515554B4940
77023	EX7 0NF	GB	0101000020E6100000513239B5338C0BC0F96A47718E4C4940
77024	EX7 0NZ	GB	0101000020E61000009B3DD00A0CB90BC0DC813AE5D14D4940
77025	EX7 0PA	GB	0101000020E6100000CAFCA36FD2B40BC009DFFB1BB44D4940
77026	EX7 9BU	GB	0101000020E61000009483D90418960BC01EDD088B8A4A4940
77027	EX7 9LJ	GB	0101000020E6100000B745990D32C90BC05F5E807D744A4940
77028	EX7 9PJ	GB	0101000020E61000001B800D8810B70BC0F163CC5D4B4A4940
77029	EX7 9PQ	GB	0101000020E6100000151C5E1091BA0BC03D821B295B4A4940
77030	EX7 9QH	GB	0101000020E61000001D1CEC4D0CC90BC09E7E5017294A4940
77031	EX7 9SQ	GB	0101000020E61000009CE09BA6CFCE0BC0641F645930494940
77032	EX8	GB	0101000020E6100000B05582C5E12C0BC083BF5FCC96504940
77033	EX8 1BZ	GB	0101000020E61000003659A31EA2510BC09B7631CD744F4940
77034	EX8 1XZ	GB	0101000020E610000059C2DA183B610BC0BE4D7FF6234F4940
77035	EX8 2AG	GB	0101000020E6100000E3344415FE4C0BC006BAF605F44E4940
77036	EX8 2AT	GB	0101000020E61000002E8CF4A2763F0BC026FBE769C04E4940
77037	EX8 2DU	GB	0101000020E61000007653CA6B25340BC0A37895B54D4F4940
77038	EX8 2HB	GB	0101000020E6100000293DD34B8C250BC0041DAD6A494F4940
77039	EX8 2PG	GB	0101000020E61000004700378B170B0BC014AFB2B629504940
77040	EX8 2QF	GB	0101000020E6100000D63730B951040BC0D655815A0C504940
77041	EX8 2RX	GB	0101000020E61000003012DA722E450BC0DD7D8E8F164F4940
77042	EX8 2TH	GB	0101000020E610000043E38920CE030BC0D95E0B7A6F504940
77043	EX8 3DR	GB	0101000020E6100000B058C345EE490BC0912749D74C504940
77044	EX8 3HT	GB	0101000020E6100000425DA450163E0BC018946934B9504940
77045	EX8 4BY	GB	0101000020E61000001C295B24ED260BC02F88484DBB504940
77046	EX8 5JW	GB	0101000020E61000003AE63C635F720BC094128255F5524940
77047	EX8 5NR	GB	0101000020E6100000FFCD8B135F2D0BC0511553E927504940
77048	EX9 6LA	GB	0101000020E6100000F0F8F6AE419F0AC02A00C63368504940
77049	EX9 6RH	GB	0101000020E610000058C7F143A5910AC029965B5A0D514940
77050	EX9 7AR	GB	0101000020E6100000456458C51BD90AC087A2409FC8514940
77051	EX9 7BX	GB	0101000020E61000002367614F3B3C0AC088A06AF46A544940
77052	EX9 7DW	GB	0101000020E61000000FB6D8EDB38A0AC010B3976DA7534940
77053	EX9 7HB	GB	0101000020E61000001D90847D3B690AC08BAA5FE97C544940
77054	EX9 7HG	GB	0101000020E61000004240BE840A6E0AC0CB0EF10F5B544940
77055	EX9 7JQ	GB	0101000020E610000094BE1072DE5F0AC0E1606F6248544940
77056	FK1	GB	0101000020E61000007407B133852E0EC00C79043752FE4B40
77057	FK1 1UP	GB	0101000020E6100000B745990D32490EC0494739984D004C40
77058	FK1 2QE	GB	0101000020E6100000E71DA7E8482E0EC0423F53AF5BFE4B40
77059	FK1 2QQ	GB	0101000020E6100000B3295778972B0EC089B14CBF44FE4B40
77060	FK1 3EU	GB	0101000020E61000000839EFFFE3A40EC0952C27A1F4F74B40
77061	FK1 4DS	GB	0101000020E6100000D595CFF23C780EC06CB587BD50004C40
77062	FK1 4JF	GB	0101000020E6100000D788601C5C9A0EC0D1915CFE43004C40
77063	FK1 4SG	GB	0101000020E6100000EE0A7DB08C8D0EC0F451465C00004C40
77064	FK1 5HU	GB	0101000020E6100000E90DF7915B730EC0778368AD68FF4B40
77065	FK1 5LN	GB	0101000020E6100000D68EE21C75540EC0C4279D4830FF4B40
77066	FK1 5PX	GB	0101000020E6100000997E8978EB5C0EC0A510C8258EFE4B40
77067	FK1 5QX	GB	0101000020E61000004E5FCFD72C570EC0BED9E6C6F4FE4B40
77068	FK1 5UL	GB	0101000020E61000004EB340BB436A0EC0BA2EFCE07CFE4B40
77069	FK10	GB	0101000020E61000001A8BA6B393810EC012A5BDC117104C40
77070	FK10 1EG	GB	0101000020E610000053EBFD463B4E0EC02096CD1C920E4C40
77071	FK10 1LZ	GB	0101000020E610000027BEDA519C630EC0CD58349D9D0E4C40
77072	FK10 1PP	GB	0101000020E610000011FFB0A547530EC0124DA088450E4C40
77073	FK10 2AN	GB	0101000020E61000000AF2B391EB460EC0340F60915F0F4C40
77074	FK10 2DS	GB	0101000020E6100000ED2B0FD253640EC0A1D634EF380F4C40
77075	FK10 2GD	GB	0101000020E610000027327381CBA30EC002486DE2E4104C40
77076	FK10 2PX	GB	0101000020E61000009CFA40F2CEA10EC0BB270F0BB5104C40
77077	FK10 2UD	GB	0101000020E61000004F3E3DB665A00EC066DAFE9595104C40
77078	FK10 2XA	GB	0101000020E6100000651D8EAED29D0EC0E8A221E351104C40
77079	FK10 3AL	GB	0101000020E61000000CB1FA230C630EC0EC1681B1BE114C40
77080	FK10 3AR	GB	0101000020E610000039B4C876BE1F0EC034F5BA4560124C40
77081	FK10 3DS	GB	0101000020E6100000FB05BB61DB420EC0BC22F8DF4A104C40
77082	FK10 3NP	GB	0101000020E61000009352D0ED252D0EC04AF086342A104C40
77083	FK10 4AZ	GB	0101000020E610000062105839B4880DC05089EB1857084C40
77084	FK10 4QZ	GB	0101000020E6100000BA4A77D7D9B00DC0B9E34D7E8B084C40
77085	FK10 4RA	GB	0101000020E610000097395D1613FB0DC083DE1B43000E4C40
77086	FK11	GB	0101000020E610000031EA5A7B9F2A0EC0FE9DEDD11B124C40
77087	FK11 7AD	GB	0101000020E61000008597E0D407D20EC0E1D1C6116B134C40
77088	FK11 7BS	GB	0101000020E6100000BA9EE8BAF0E30EC00FD1E80E62134C40
77089	FK12	GB	0101000020E61000009B70AFCC5B550EC00D384BC9721A4C40
77090	FK12 5HA	GB	0101000020E6100000292158552F5F0EC02AABE97AA2134C40
77091	FK12 5LA	GB	0101000020E61000005C8E57207A720EC00CAF2479AE134C40
77092	FK12 5LQ	GB	0101000020E6100000E84F1BD5E9600EC0D3D85E0B7A134C40
77093	FK13 6AA	GB	0101000020E6100000A3C85A43A9FD0DC040A54A94BD134C40
77094	FK13 6AR	GB	0101000020E610000064575A46EAFD0DC02A01310917144C40
77095	FK13 6NS	GB	0101000020E6100000300F99F221E80DC09FCC3FFA26134C40
77096	FK13 6PQ	GB	0101000020E6100000E60819C8B3EB0DC0FCFCF7E0B5134C40
77097	FK13 6PR	GB	0101000020E6100000EBE5779ACCF80DC0AEBCE47FF2134C40
77098	FK14 7	GB	0101000020E6100000DF6C73637A620DC06EFC89CA86154C40
77099	FK14 7DQ	GB	0101000020E61000009F73B7EBA5690DC0FED5E3BED5144C40
77100	FK14 7ER	GB	0101000020E61000008F6FEF1AF4050DC0A1A2EA573A174C40
77101	FK14 7JT	GB	0101000020E61000000FEECEDA6DD70CC09FAF592E1B194C40
77102	FK14 7JY	GB	0101000020E6100000EAEA8EC536090DC099D711876C1C4C40
77103	FK15	GB	0101000020E61000009B8D959867E50EC0ABB35A608F0B4C40
77104	FK15 0JL	GB	0101000020E610000052B7B3AF3CA80FC084F1D3B8371B4C40
77105	FK15 0LN	GB	0101000020E61000003E3DB665C0590FC03E9468C9E3174C40
77106	FK15 0NA	GB	0101000020E610000004E275FD82FD0EC0414AECDADE1E4C40
77107	FK15 0PA	GB	0101000020E6100000F85278D0EC9A0FC0821B295B24194C40
77108	FK15 0QB	GB	0101000020E6100000D350A39064B60FC035B39602D2184C40
77109	FK15 9ET	GB	0101000020E61000000A80F10C1ABA0FC0C442AD69DE174C40
77110	FK15 9FB	GB	0101000020E61000004B051555BFD20FC0630E828E56174C40
77111	FK15 9JB	GB	0101000020E6100000ECA17DACE0D70FC03E247CEF6F184C40
77112	FK15 9LA	GB	0101000020E61000003946B247A8590FC08881AE7D01234C40
77113	FK16 6	GB	0101000020E6100000E8D84125AE3310C0C8B3CBB73E184C40
77114	FK17 8	GB	0101000020E6100000AB984A3FE1DC10C0F44D9A06451F4C40
77115	FK17 8EL	GB	0101000020E6100000CF49EF1B5FDB10C01A34F44F701F4C40
77116	FK17 8HQ	GB	0101000020E610000033DC80CF0FE310C09D2FF65E7C1F4C40
77117	FK17 8JE	GB	0101000020E61000007B2FBE688FC710C07B849A21551E4C40
77118	FK18 8	GB	0101000020E61000000FD253E4105111C01A6EC0E787294C40
77119	FK18 8NA	GB	0101000020E61000000B28D4D3475011C0B2D826158D294C40
77120	FK19 8	GB	0101000020E6100000F4F8BD4D7F2611C09EB5DB2E34314C40
77121	FK19 8NY	GB	0101000020E610000031EA5A7B9F4A11C0B306EFAB722D4C40
77122	FK19 8PQ	GB	0101000020E6100000A52DAEF199DC11C0FC3559A31E2C4C40
77123	FK2	GB	0101000020E61000007156444DF44911C02098A3C7EFEF4B40
77124	FK2 0BJ	GB	0101000020E61000008B71FE2614A20DC056F31C91EFFC4B40
77125	FK2 0EJ	GB	0101000020E6100000A7E8482EFFC10DC05DE15D2EE2FD4B40
77126	FK2 0HL	GB	0101000020E610000047938B31B0CE0DC066DD3F16A2FD4B40
77127	FK2 0RU	GB	0101000020E61000009FABADD85FB60DC09B3DD00A0CFD4B40
77128	FK2 0RW	GB	0101000020E61000003A2174D025BC0DC0DD60A8C30AFD4B40
77129	FK2 0UF	GB	0101000020E6100000F8DEDFA0BDBA0DC0D49CBCC804FE4B40
77130	FK2 7UP	GB	0101000020E6100000437573F1B71D0EC07C2766BD18044C40
77131	FK2 7YP	GB	0101000020E61000002DCDAD1056830EC0DA91EA3BBF004C40
77132	FK2 8FB	GB	0101000020E61000009C51F355F2F10DC00E4DD9E907094C40
77133	FK2 8LA	GB	0101000020E61000003674B33F502E0EC0FED478E926094C40
77134	FK2 8LU	GB	0101000020E61000008121AB5B3D470EC0D943FB58C1094C40
77135	FK2 9DF	GB	0101000020E6100000C860C5A9D6220EC03D65355D4F004C40
77136	FK2 9DS	GB	0101000020E6100000F4DDAD2CD1190EC0BE50C07630004C40
77137	FK20 8	GB	0101000020E61000006CE9D1544FD612C0BF0AF0DDE6374C40
77138	FK20 8QN	GB	0101000020E610000032C687D9CB7612C02098A3C7EF314C40
77139	FK20 8RQ	GB	0101000020E610000066DB696B44D012C0994869368F374C40
77140	FK20 8RY	GB	0101000020E61000006F4BE48233D812C06C088ECBB8374C40
77141	FK20 8RZ	GB	0101000020E6100000CFA0A17F82DB12C0E1EEACDD76374C40
77142	FK21 8	GB	0101000020E610000021037976F94611C0E998F38C7D3B4C40
77143	FK21 8TN	GB	0101000020E61000007B4E7ADFF84A11C05307793D983C4C40
77144	FK21 8UA	GB	0101000020E61000002F14B01D8C5811C05DDDB1D8263D4C40
77145	FK21 8UW	GB	0101000020E6100000AB5E7EA7C90C11C04F92AE997C414C40
77146	FK28	GB	0101000020E6100000751E15FF77E40DC0B727486C77034C40
77147	FK3	GB	0101000020E61000008F386403E9C20DC08A8EE4F21F024C40
77148	FK3 0JL	GB	0101000020E6100000DA1A118C83CB0DC056478E7406024C40
77149	FK3 8AW	GB	0101000020E6100000DE3D40F7E5CC0DC0B9FAB1497E024C40
77150	FK3 9AF	GB	0101000020E610000057CEDE196DB50DC05C548B8862024C40
77151	FK4	GB	0101000020E6100000312592E865540FC0AA436E861B004C40
77152	FK4 1SA	GB	0101000020E6100000D49E9273626F0FC001DC2C5E2C004C40
77153	FK4 2AT	GB	0101000020E61000008655BC9179040FC0923B6C2233FF4B40
77154	FK5	GB	0101000020E61000003A5D16139B8F0EC02716F88A6E034C40
77155	FK5 3AR	GB	0101000020E6100000D11F9A7972AD0EC0E597C11891024C40
77156	FK5 4AN	GB	0101000020E61000003A22DFA5D4A50EC03485CE6BEC024C40
77157	FK5 4AP	GB	0101000020E61000009817601F9D7A0EC0E814E46723034C40
77158	FK5 4UY	GB	0101000020E6100000AA285E656D730EC08330B77BB9034C40
77159	FK6 5HL	GB	0101000020E6100000B2F677B6476F0FC0ED461FF301034C40
77160	FK6 5JQ	GB	0101000020E61000003F36C98FF8350FC0AF5DDA7058024C40
77161	FK6 5NJ	GB	0101000020E6100000490ED8D5E4A90FC036AD1402B90C4C40
77162	FK6 6DE	GB	0101000020E6100000FE99417C60470FC0EF1CCA5015034C40
77163	FK7	GB	0101000020E61000004CE141B3EB7E0FC0AE2990D9590C4C40
77164	FK7 0BG	GB	0101000020E610000052448655BC710FC02B155454FD0C4C40
77165	FK7 0LJ	GB	0101000020E61000005D37A5BC56820FC02DE8BD31040C4C40
77166	FK7 3EW	GB	0101000020E610000061E3FA777D660FC015AC71361D0B4C40
77167	FK7 7AL	GB	0101000020E6100000410C74ED0BE80EC0EF004F5AB80A4C40
77168	FK7 7RB	GB	0101000020E6100000EE21E17B7F030FC0AFCE31207B0B4C40
77169	FK7 8LQ	GB	0101000020E6100000BBF083F3A9430FC0677E3507080C4C40
77170	FK7 9JB	GB	0101000020E610000027DC2BF3567D0FC08881AE7D010D4C40
77171	FK7 9NW	GB	0101000020E610000029CFBC1C76BF0FC0E02D90A0F80D4C40
77172	FK8 1BJ	GB	0101000020E6100000EC134031B2840FC02A8F6E84450F4C40
77173	FK8 1ET	GB	0101000020E610000051A39064568F0FC05A9D9CA1B80F4C40
77174	FK8 1JP	GB	0101000020E6100000A3772AE09E870FC0BEBF417BF50F4C40
77175	FK8 2AQ	GB	0101000020E6100000CF656A12BC810FC05133A48AE20D4C40
77176	FK8 3AT	GB	0101000020E610000053758F6CAE2A10C0AB75E272BC104C40
77177	FK8 3PT	GB	0101000020E6100000018750A5669F10C0D4F36E2C28164C40
77178	FK8 3PX	GB	0101000020E6100000E71890BDDEBD0EC0F8C5A52A6DEB4B40
77179	FK8 3TU	GB	0101000020E6100000622D3E05C0B812C03A419B1C3E1F4C40
77180	FK9	GB	0101000020E6100000BF7FF3E2C4170FC0D87E32C687114C40
77181	FK9 4EB	GB	0101000020E6100000D7338463967D0FC0588CBAD6DE134C40
77182	FK9 4EE	GB	0101000020E6100000DA3A38D89B780FC0DCBB067DE9134C40
77183	FK9 4LA	GB	0101000020E61000008F71C5C551590FC0FBAE08FEB7124C40
77184	FK9 4LE	GB	0101000020E6100000CC5D4BC8075D0FC0564ACFF412134C40
77185	FK9 4NU	GB	0101000020E6100000C7F5EFFACC990FC0556B6116DA134C40
77186	FK9 5HD	GB	0101000020E61000000F9A5DF756440FC0A7052FFA0A104C40
77187	FK9 5LF	GB	0101000020E6100000B83A00E2AE5E0FC092054CE0D6114C40
77188	FY1	GB	0101000020E61000003A3B191C256F08C017670C7382EA4A40
77189	FY1 1RN	GB	0101000020E6100000145B41D3126B08C0BE13B35E0CE94A40
77190	FY1 2AB	GB	0101000020E6100000397EA834626608C005FA449E24E94A40
77191	FY1 2HT	GB	0101000020E61000003DF03158716A08C05794128255E94A40
77192	FY1 2JA	GB	0101000020E6100000D237691A146D08C0213B6F63B3E94A40
77193	FY1 2LD	GB	0101000020E6100000A2630795B86E08C0AD156D8E73E94A40
77194	FY1 2QP	GB	0101000020E6100000E869C020E95308C0D882DE1B43EA4A40
77195	FY1 4AR	GB	0101000020E6100000EC4CA1F31A5B08C0B1FB8EE1B1E74A40
77196	FY1 4QG	GB	0101000020E6100000B5C6A013426708C018213CDA38E84A40
77197	FY1 5PF	GB	0101000020E6100000466117450F5C08C07A8F334DD8E84A40
77198	FY1 6AR	GB	0101000020E61000007E1AF7E6376C08C032E9EFA5F0E64A40
77199	FY1 6NT	GB	0101000020E61000006EC493DDCC4808C085B2F0F5B5E64A40
77200	FY2	GB	0101000020E6100000C7BDF90D134D08C016A1D80A9AEA4A40
77201	FY2 0AD	GB	0101000020E61000004D9F1D705D5108C0C2A6CEA3E2ED4A40
77202	FY2 0SX	GB	0101000020E6100000B6696CAF053D08C0FDDB65BFEEEA4A40
77203	FY2 9	GB	0101000020E61000006BD3D85E0B5A08C06FD39FFD48EB4A40
77204	FY2 9NL	GB	0101000020E6100000F50EB743C36208C0EF586C938AEC4A40
77205	FY2 9RY	GB	0101000020E6100000C214E5D2F86508C05439ED2939EB4A40
77206	FY3	GB	0101000020E61000002FC214E5D23808C0397CD28904EB4A40
77207	FY3 0AL	GB	0101000020E61000001A51DA1B7C0108C0529ACDE330EA4A40
77208	FY3 7DG	GB	0101000020E6100000D26F5F07CE3908C00E66136058EA4A40
77209	FY3 7EE	GB	0101000020E6100000ECFB7090102508C095D6DF1280E94A40
77210	FY3 7JD	GB	0101000020E610000006685BCD3A4308C0BB9D7DE541EA4A40
77211	FY3 7JN	GB	0101000020E6100000DE59BBED423308C02CD505BCCCEA4A40
77212	FY3 7PL	GB	0101000020E61000002A1DACFF733808C0DF35E84B6FE94A40
77213	FY3 7TN	GB	0101000020E6100000126745D4441F08C027D87F9D9BEA4A40
77214	FY3 8BT	GB	0101000020E6100000B08EE3874AC307C0DE7536E49FE94A40
77215	FY3 8NG	GB	0101000020E61000000186E5CFB72508C0FC7266BB42E94A40
77216	FY3 8NH	GB	0101000020E6100000A1F2AFE5952B08C0AEF36F97FDE84A40
77217	FY3 8PA	GB	0101000020E6100000739F1C05884208C0DBA7E33103EB4A40
77218	FY3 8QW	GB	0101000020E6100000D8F15F20081008C0586FD40AD3E94A40
77219	FY3 9LT	GB	0101000020E61000008BE255D6360508C0FE43FAEDEBE64A40
77220	FY3 9NY	GB	0101000020E610000012BEF737680F08C082548A1D8DE74A40
77221	FY3 9PG	GB	0101000020E6100000EEEC2B0FD23308C0E257ACE122E74A40
77222	FY3 9QA	GB	0101000020E6100000D520CCED5E2E08C064EB19C231E74A40
77223	FY3 9QU	GB	0101000020E610000055A69883A02308C007793D9814E74A40
77224	FY3 9RQ	GB	0101000020E61000008811C2A38D2308C05B5D4E0988E74A40
77225	FY4 1LS	GB	0101000020E610000028999CDA196608C07A3881E9B4E44A40
77226	FY4 1SG	GB	0101000020E6100000B66455849B6C08C0F982161230E44A40
77227	FY4 2FA	GB	0101000020E61000001494A2957B6108C0EF8D210038E64A40
77228	FY4 2JT	GB	0101000020E6100000A30392B06F6708C0302C7FBE2DE64A40
77229	FY4 2LG	GB	0101000020E61000000DE36E10ADF507C086915ED4EEE74A40
77230	FY4 2QJ	GB	0101000020E61000007E71A94A5B3C08C039B9DFA128E44A40
77231	FY4 3BZ	GB	0101000020E6100000FFB1101D024708C07288B83995E64A40
77232	FY4 3HQ	GB	0101000020E6100000B0AA5E7EA74908C01F9DBAF259E64A40
77233	FY4 3RL	GB	0101000020E61000002CB64945632D08C050560C5707E44A40
77234	FY4 4AS	GB	0101000020E61000007E8D2441B84208C0B6BC72BD6DE64A40
77235	FY4 4DU	GB	0101000020E610000033FCA71B285008C00B45BA9F53E84A40
77236	FY4 4JR	GB	0101000020E610000009A4C4AEED2D08C0B1E1E995B2E64A40
77237	FY4 4UJ	GB	0101000020E61000009147702365EB07C0033FAA61BFE54A40
77238	FY4 5EH	GB	0101000020E6100000849D62D5200C08C0E3C4573B8AE34A40
77239	FY4 5LY	GB	0101000020E61000004E44BFB67E3A08C0FD4FFEEE1DE54A40
77240	FY4 5NU	GB	0101000020E6100000C3F2E7DB822508C00AA1832EE1E44A40
77241	FY5	GB	0101000020E610000059A31EA2D11D08C0B4AA251DE5F04A40
77242	FY5 1	GB	0101000020E61000002237C30DF85C08C088F6B182DFEE4A40
77243	FY5 1AJ	GB	0101000020E6100000F2272A1BD65408C0FCC6D79E59F04A40
77244	FY5 1BJ	GB	0101000020E6100000E92CB308C55608C09A44BDE0D3F04A40
77245	FY5 1BS	GB	0101000020E6100000F1D93A38D85B08C0F7AB00DF6DF04A40
77246	FY5 1EY	GB	0101000020E6100000F20C1AFA275808C0132D793C2DF14A40
77247	FY5 2AP	GB	0101000020E610000064B0E2546B4108C02AFF5A5EB9F04A40
77248	FY5 2JR	GB	0101000020E610000072C119FCFD4208C0156F641EF9EF4A40
77249	FY5 2TX	GB	0101000020E610000063B48EAA262808C0D3BF249529F04A40
77250	FY5 2ZD	GB	0101000020E6100000BA10AB3FC23008C011AAD4EC81F04A40
77251	FY5 3	GB	0101000020E61000004F2157EA593008C0BE4EEACBD2EE4A40
77252	FY5 3AF	GB	0101000020E6100000A663CE33F64508C09E23F25D4AEF4A40
77253	FY5 3JF	GB	0101000020E61000002BA226FA7C5408C00A80F10C1AF04A40
77254	FY5 4JD	GB	0101000020E6100000B8ACC266800B08C0A9DDAF027CF14A40
77255	FY5 4LS	GB	0101000020E610000065C746205E1708C006685BCD3AF14A40
77256	FY5 4NE	GB	0101000020E61000002D26361FD70608C02FA2ED98BAEF4A40
77257	FY5 5NR	GB	0101000020E6100000BFD7101C971108C0F7B182DF86EE4A40
77258	FY6	GB	0101000020E61000008944A165DDDF07C0F0A7C64B37F34A40
77259	FY6 0DQ	GB	0101000020E610000089F02F82C6EC07C03D47E4BB94F64A40
77260	FY6 0EB	GB	0101000020E6100000753DD175E1C707C095490D6D00F64A40
77261	FY6 7AA	GB	0101000020E610000047C66AF3FFEA07C0390F27309DEC4A40
77262	FY6 7DX	GB	0101000020E61000002123A0C2110408C0BC92E4B9BEEB4A40
77263	FY6 7ER	GB	0101000020E6100000F7C77BD5CAE407C09143C4CDA9EC4A40
77264	FY6 7FY	GB	0101000020E610000054E1CFF0660D08C0C3B645990DEC4A40
77265	FY6 7PU	GB	0101000020E610000014E7A8A3E3EA07C0C7832D76FBEC4A40
77266	FY6 7RJ	GB	0101000020E61000009D121093700108C0D8F15F2008EC4A40
77267	FY6 7RU	GB	0101000020E61000005DDF8783842808C05D8AABCABEF14A40
77268	FY6 7TF	GB	0101000020E6100000A83462669F0708C005323B8BDEED4A40
77269	FY6 8HJ	GB	0101000020E6100000034356B77AEE07C056D7A19A92EE4A40
77270	FY6 8HX	GB	0101000020E61000008EAF3DB3240008C0A5F78DAF3DEB4A40
77271	FY6 8JZ	GB	0101000020E6100000118C834BC7BC07C073A087DA36EC4A40
77272	FY6 9BG	GB	0101000020E610000052103CBEBD6B07C09929ADBF25F04A40
77273	FY6 9EF	GB	0101000020E610000045D4449F8F9207C0C6353E93FDEF4A40
77274	FY7	GB	0101000020E61000002DE92807B30908C02502D53F88F64A40
77275	FY7 6AB	GB	0101000020E610000076C3B645990D08C06FB9FAB149F64A40
77276	FY7 6DY	GB	0101000020E6100000ACC95356D31508C02975C93846F64A40
77277	FY7 6LH	GB	0101000020E610000096CCB1BCAB1E08C0823CBB7CEBF54A40
77278	FY7 7DW	GB	0101000020E6100000B5F97FD5914308C0121615713AF54A40
77279	FY7 7LD	GB	0101000020E610000087E123624A4408C02766BD18CAF54A40
77280	FY7 8NL	GB	0101000020E6100000F83768AF3E3E08C0CF31207BBDF34A40
77281	FY7 8QG	GB	0101000020E610000034828DEBDF5508C02503401537F44A40
77282	FY8	GB	0101000020E610000079211D1EC2F807C09C6ED921FEDF4A40
77283	FY8 1AG	GB	0101000020E61000006EA301BC05F207C03ECBF3E0EEDE4A40
77284	FY8 1HN	GB	0101000020E6100000B7B41A12F73808C03EB14E95EFDF4A40
77285	FY8 1HR	GB	0101000020E61000001BD7BFEB332708C0EA23F0879FDF4A40
77286	FY8 1JD	GB	0101000020E61000005A290472892308C06536C82423DF4A40
77287	FY8 1JE	GB	0101000020E61000007E569929AD1F08C09E7B0F971CDF4A40
77288	FY8 1LE	GB	0101000020E6100000FA9CBB5D2F2D08C02BFC19DEACDF4A40
77289	FY8 1NL	GB	0101000020E6100000CE55F31C912F08C04242942F68DF4A40
77290	FY8 1PN	GB	0101000020E610000078465B95443608C061C1FD8007E04A40
77291	FY8 2BQ	GB	0101000020E610000052D7DAFB543508C01FBFB7E9CFE04A40
77292	FY8 2HX	GB	0101000020E6100000A228D027F24408C0211FF46C56E14A40
77293	FY8 2JE	GB	0101000020E61000007C444C89243A08C0B3CF639467E04A40
77294	FY8 2JJ	GB	0101000020E6100000EDBAB722314108C041B96DDFA3E04A40
77295	FY8 2QG	GB	0101000020E61000001D03B2D7BB5F08C030DAE38574E24A40
77296	FY8 2SD	GB	0101000020E6100000062E8F35234308C091B41B7DCCE14A40
77297	FY8 2SL	GB	0101000020E610000085EB51B81E6508C01FDAC70A7EE34A40
77298	FY8 3	GB	0101000020E610000090831266DA3E08C0A6643909A5E14A40
77299	FY8 3ER	GB	0101000020E610000035D1E7A38C1808C0DF8C9AAF92E14A40
77300	FY8 3HW	GB	0101000020E6100000304CA60A462508C09F9273620FE14A40
77301	FY8 3UE	GB	0101000020E6100000914259F8FAFA07C0740CC85EEFE04A40
77302	FY8 4	GB	0101000020E61000004BE658DE554F08C0D87DC7F0D8E14A40
77303	FY8 4AB	GB	0101000020E61000005B608F8994E607C04F965AEF37E04A40
77304	FY8 4DG	GB	0101000020E6100000F373435376FA07C0AF08FEB792DF4A40
77305	FY8 4DJ	GB	0101000020E6100000B56B425A63F007C07F68E6C935DF4A40
77306	FY8 4EZ	GB	0101000020E610000052431B800DE807C09D6516A1D8DE4A40
77307	FY8 4FE	GB	0101000020E6100000433866D993E007C0F4A62215C6E04A40
77308	FY8 4FX	GB	0101000020E610000056116E32AAEC07C084D6C39789E04A40
77309	FY8 4HY	GB	0101000020E6100000BDA94885B1A507C0E50B5A48C0DE4A40
77310	FY8 4JF	GB	0101000020E61000008F17D2E121AC07C03F55850662DF4A40
77311	FY8 4NB	GB	0101000020E6100000986E1283C08A07C013656F29E7E14A40
77312	FY8 5	GB	0101000020E61000004EEFE2FDB8DD07C04145D5AF74DE4A40
77313	FY8 5DE	GB	0101000020E61000004CE0D6DD3C9507C066DAFE9595DE4A40
77314	FY8 5HA	GB	0101000020E6100000F8544E7B4AAE07C0DE04DF347DDE4A40
77315	FY8 5NG	GB	0101000020E6100000F4BF5C8B162008C04CA60A4625E14A40
77316	FY8 5NJ	GB	0101000020E61000001D0247020DB607C09F5912A0A6DE4A40
77317	FY8 5QT	GB	0101000020E610000035ECF7C43AD507C0662D05A4FDDD4A40
77318	G1 1NL	GB	0101000020E6100000AD307DAF21F810C0E338F06AB9ED4B40
77319	G1 2AF	GB	0101000020E6100000921FF12BD60011C09E60FF756EEE4B40
77320	G1 3SL	GB	0101000020E61000000EDB1665360811C0DBA4A2B1F6ED4B40
77321	G1 4LH	GB	0101000020E61000009DB98784EFFD10C049BE124889ED4B40
77322	G1 5HX	GB	0101000020E6100000DF5339ED29F910C0F06DFAB31FED4B40
77323	G1 5PP	GB	0101000020E6100000F949B54FC7F310C0C806D2C5A6ED4B40
77324	G1 5QT	GB	0101000020E6100000889E94490DFD10C0FE2AC0779BED4B40
77325	G10	GB	0101000020E61000001E6FF25B74F2F7BFF6402B3064794B40
77326	G11	GB	0101000020E61000003D0AD7A3703D11C094F947DFA4EF4B40
77327	G11 5AP	GB	0101000020E61000006B662D05A43D11C00952297634F04B40
77328	G11 5AY	GB	0101000020E6100000FC6F253B363211C02BFBAE08FEEF4B40
77329	G11 5BU	GB	0101000020E61000004C6F7F2E1A3211C02A6F47382DF04B40
77330	G11 5EG	GB	0101000020E61000001CB5C2F4BD3611C075E61E12BEEF4B40
77331	G11 5HD	GB	0101000020E610000049DA8D3EE63311C0C425C79DD2EF4B40
77332	G11 6BU	GB	0101000020E6100000FEEF880AD53D11C0B2BB404981EF4B40
77333	G11 7BU	GB	0101000020E61000007CED9925014A11C0A7E7DD5850F04B40
77334	G11 7HF	GB	0101000020E61000008BDF14562A4811C03D29931ADAF04B40
77335	G11 7HY	GB	0101000020E610000095EF1989D04811C0514EB4AB90F04B40
77336	G11 7JB	GB	0101000020E61000000E10CCD1E34711C0F4E159828CF04B40
77337	G11 7QP	GB	0101000020E610000085402E71E44111C05EBD8A8C0EF04B40
77338	G11 7ST	GB	0101000020E6100000DE54A4C2D84211C001FBE8D495EF4B40
77339	G11 7SW	GB	0101000020E6100000D4D51D8B6D4211C079245E9ECEEF4B40
77340	G11 7UB	GB	0101000020E61000000305DEC9A74711C02EA9DA6E82EF4B40
77341	G11 7UY	GB	0101000020E610000010B22C98F84311C0B64AB0389CEF4B40
77342	G12 0AY	GB	0101000020E6100000BC07E8BE9C4911C017D7F84CF6F14B40
77343	G12 0EB	GB	0101000020E61000000BF0DDE68D4311C037514B732BF24B40
77344	G12 0EG	GB	0101000020E6100000C9AB730CC83E11C0CF12640454F24B40
77345	G12 0JT	GB	0101000020E61000009D9FE238F03A11C07022FAB5F5F14B40
77346	G12 0QU	GB	0101000020E61000001021AE9CBD3311C051BF0B5BB3F14B40
77347	G12 0TR	GB	0101000020E6100000A393A5D6FB2D11C01BD82AC1E2F04B40
77348	G12 8BT	GB	0101000020E610000053060E68E92A11C0629D2ADF33F04B40
77349	G12 8DH	GB	0101000020E6100000BABDA4315A2711C00FD4298F6EF04B40
77350	G12 8DY	GB	0101000020E6100000990E9D9E772311C00F60915F3FF04B40
77351	G12 8LB	GB	0101000020E6100000672C9ACE4E2611C0698F17D2E1EF4B40
77352	G12 8NZ	GB	0101000020E6100000AE8383BD892111C0A29A92ACC3EF4B40
77353	G12 8QQ	GB	0101000020E6100000D1967329AE2A11C0DF35E84B6FEF4B40
77354	G12 9AE	GB	0101000020E6100000FD885FB1862B11C0679AB0FD64F04B40
77355	G12 9EE	GB	0101000020E61000000B42791F473311C038A3E6ABE4EF4B40
77356	G12 9JD	GB	0101000020E61000007369FCC22B3911C055185B0872F04B40
77357	G12 9NY	GB	0101000020E61000001AFD6838652E11C053944BE317F04B40
77358	G12 9PP	GB	0101000020E610000052F01472A53E11C06DE2E47E87F04B40
77359	G12 9SU	GB	0101000020E610000062D8614CFA3B11C07A6CCB80B3F04B40
77360	G12 9YG	GB	0101000020E6100000371AC05B203111C07D5C1B2AC6EF4B40
77361	G13	GB	0101000020E6100000B6476FB88FEC10C0653909A52FEC4B40
77362	G13 1	GB	0101000020E610000024F0879FFF4E11C007B5DFDA89F24B40
77363	G13 1DL	GB	0101000020E61000008A05BEA25B4F11C0D5963AC8EBF14B40
77364	G13 1DN	GB	0101000020E6100000C1CAA145B64311C0ACC612D6C6F24B40
77365	G13 1HY	GB	0101000020E6100000B2D7BB3FDE4B11C01B49827005F24B40
77366	G13 1QG	GB	0101000020E610000036583849F36711C02C4833164DF14B40
77367	G13 1QL	GB	0101000020E6100000FB75A73B4F4C11C0C1E3DBBB06F14B40
77368	G13 1UG	GB	0101000020E6100000AF44A0FA076111C0855E7F129FF14B40
77369	G13 1UQ	GB	0101000020E6100000D61D8B6D525111C046EC134031F24B40
77370	G13 2JP	GB	0101000020E6100000247CEF6FD05E11C0F4DDAD2CD1F34B40
77371	G13 2JX	GB	0101000020E61000008E210038F65C11C0ACCABE2B82F34B40
77372	G13 3NH	GB	0101000020E61000009FAC18AE0E6011C0069E7B0F97F24B40
77373	G13 3RX	GB	0101000020E61000001C78B5DC996911C0ED9C668176F14B40
77374	G13 4PT	GB	0101000020E6100000D13B1570CF7311C0B2D7BB3FDEF34B40
77375	G14 0AS	GB	0101000020E610000007431D56B86511C0BB80971936F04B40
77376	G14 0DF	GB	0101000020E610000013F4177AC46811C0E1421EC18DF04B40
77377	G14 0EE	GB	0101000020E6100000E8F7FD9B177711C0D0B7054B75F14B40
77378	G14 0YT	GB	0101000020E6100000E8F7FD9B177711C0D0B7054B75F14B40
77379	G14 9AR	GB	0101000020E61000005891D101496811C04E2B85402EF14B40
77380	G14 9EB	GB	0101000020E61000002AC423F1F26411C0706072A3C8F04B40
77381	G14 9QG	GB	0101000020E61000008A3E1F65C45511C049145AD6FDEF4B40
77382	G14 9RN	GB	0101000020E610000063450DA6615811C02C45F29540F04B40
77383	G15	GB	0101000020E6100000103B53E8BC7611C0AC36FFAF3AF44B40
77384	G15 6AH	GB	0101000020E61000000397C79A918111C0A873452921F44B40
77385	G15 6RG	GB	0101000020E610000034130CE71A6611C0A9D898D711F54B40
77386	G2 3JD	GB	0101000020E61000006728EE78930F11C0E10D6954E0EE4B40
77387	G2 3LN	GB	0101000020E610000056F2B1BB40E910C0C362D4B5F6EE4B40
77388	G2 3NP	GB	0101000020E6100000904E5DF92CFF10C0C6DB4AAFCDEE4B40
77389	G2 7BW	GB	0101000020E61000006AA2CF47191111C0672618CE35EE4B40
77390	G2 7HX	GB	0101000020E6100000B0C91AF5100D11C00116F9F543EE4B40
77391	G2 8NE	GB	0101000020E6100000779E78CE161011C07CB94F8E02EE4B40
77392	G20	GB	0101000020E6100000DD9A745B221711C0A6D3BA0D6AF14B40
77393	G20 0EZ	GB	0101000020E610000050FF59F3E32F11C0AF5B04C6FAF24B40
77394	G20 0SP	GB	0101000020E6100000FCDEA63FFB4111C000AAB8718BF34B40
77395	G20 0XA	GB	0101000020E6100000B39AAE27BA3E11C0FAB7CB7EDDF34B40
77396	G20 6ND	GB	0101000020E6100000C4EC65DB691B11C051F86C1D1CF04B40
77397	G20 6UQ	GB	0101000020E610000088821953B01611C08A8F4FC8CEEF4B40
77398	G20 7AL	GB	0101000020E6100000EC18575C1C1511C05E807D74EAF04B40
77399	G20 7XN	GB	0101000020E610000085D1AC6C1F1211C0390CE6AF90EF4B40
77400	G20 8NT	GB	0101000020E610000059A7CAF78C2411C04B901150E1F04B40
77401	G20 8QG	GB	0101000020E61000003F1EFAEE562611C040DCD5ABC8F04B40
77402	G20 8QW	GB	0101000020E61000008FFAEB15162C11C0F624B03907F14B40
77403	G20 8QX	GB	0101000020E6100000FF942A51F62611C0787E5182FEF04B40
77404	G20 8RN	GB	0101000020E6100000E658DE550F2811C0227024D060F14B40
77405	G21	GB	0101000020E61000009FE40E9BC80C11C0217711A628EF4B40
77406	G21 1SB	GB	0101000020E6100000E04BE141B3EB10C0768BC058DFF04B40
77407	G21 2DP	GB	0101000020E61000000ABB287AE0D310C0060E68E90AF04B40
77408	G21 2EQ	GB	0101000020E6100000C8B7770DFAE210C02C0C91D3D7EF4B40
77409	G21 2LG	GB	0101000020E6100000B091240857F010C01EA4A7C821F24B40
77410	G21 2QH	GB	0101000020E610000047C66AF3FFDA10C008AF5DDA70F04B40
77411	G21 4NB	GB	0101000020E6100000CBF78C4468E410C020EEEA5564F04B40
77412	G21 4XF	GB	0101000020E6100000F981AB3C81E010C08AE8D7D64FF14B40
77413	G22	GB	0101000020E61000004E9D47C5FFDD10C0641F645930F34B40
77414	G22 6LR	GB	0101000020E610000084656CE866FF10C0A4703D0AD7F14B40
77415	G23 5AT	GB	0101000020E61000008B1BB7989F2B11C08E78B29B19F34B40
77416	G23 5DB	GB	0101000020E610000033C34659BF1911C0AF27BA2EFCF24B40
77417	G24 9LS	GB	0101000020E6100000FD6B79E57AFB01C0D731AEB838844A40
77418	G3	GB	0101000020E6100000EF8D210038F610C07D9752978CED4B40
77419	G3 6AA	GB	0101000020E6100000486AA164721A11C050C763062AEF4B40
77420	G3 6DF	GB	0101000020E61000005247C7D5C81E11C004AF963B33EF4B40
77421	G3 6NS	GB	0101000020E61000003B191C25AF0E11C03E7958A835EF4B40
77422	G3 6QN	GB	0101000020E6100000D2DF4BE1411311C0E7FD7F9C30EF4B40
77423	G3 7HR	GB	0101000020E6100000F7E80DF7911B11C07EAA0A0DC4EE4B40
77424	G3 7RU	GB	0101000020E61000008692C9A99D2111C05ABDC3EDD0EE4B40
77425	G3 7SD	GB	0101000020E610000099654F029B2311C0520C906802EF4B40
77426	G3 8AB	GB	0101000020E61000002EE411DC482911C0FE2C9622F9EE4B40
77427	G3 8AG	GB	0101000020E6100000E9B5D958892911C017D34CF73AEF4B40
77428	G3 8EH	GB	0101000020E610000086ADD9CA4B1E11C00EA0DFF76FEE4B40
77429	G3 8LD	GB	0101000020E610000038DA71C3EF2611C04A7B832F4CEE4B40
77430	G31 1AF	GB	0101000020E6100000BDFC4E9319DF10C06CCD565EF2ED4B40
77431	G31 1JF	GB	0101000020E6100000363D282845EB10C0A376BF0AF0ED4B40
77432	G31 1LL	GB	0101000020E6100000121615713AD910C00E164ED2FCED4B40
77433	G31 1SG	GB	0101000020E610000096D05D1267E510C0B6847CD0B3ED4B40
77434	G31 1ST	GB	0101000020E6100000F8DF4A766CE410C0556B6116DAED4B40
77435	G31 2HJ	GB	0101000020E61000009EEFA7C64BE710C0B115342DB1EE4B40
77436	G31 2JF	GB	0101000020E6100000A20BEA5BE6E410C0B1A71DFE9AEE4B40
77437	G31 2NU	GB	0101000020E610000093C83EC8B2E010C02D9622F94AEE4B40
77438	G31 2QS	GB	0101000020E6100000034356B77ADE10C05C38109205EE4B40
77439	G31 2TB	GB	0101000020E61000005DC2A1B778D810C02DB308C556EE4B40
77440	G31 3JN	GB	0101000020E6100000A8514832ABD710C024B726DD96EE4B40
77441	G31 5RS	GB	0101000020E610000002BC051214BF10C00536E7E099EC4B40
77442	G32	GB	0101000020E6100000D1048A58C4B010C002840F255AEC4B40
77443	G32 0DB	GB	0101000020E6100000C24F1C40BF9F10C01DC87A6AF5ED4B40
77444	G32 0PF	GB	0101000020E6100000817B9E3F6DA410C01B118C834BED4B40
77445	G32 6AW	GB	0101000020E6100000F8C43A55BEB710C040F7E5CC76ED4B40
77446	G32 6TB	GB	0101000020E610000081423D7D04AE10C05BB4006DABED4B40
77447	G32 7AB	GB	0101000020E6100000F0880AD5CDA510C033164D6727ED4B40
77448	G32 7QW	GB	0101000020E610000094A3005130B310C0E84A04AA7FEC4B40
77449	G32 7SX	GB	0101000020E6100000E3546B6116AA10C0CEAACFD556EC4B40
77450	G32 8DD	GB	0101000020E610000015713AC9569710C0DDB5847CD0EB4B40
77451	G32 8SA	GB	0101000020E6100000253CA1D79FB410C01442075DC2EB4B40
77452	G32 8SG	GB	0101000020E61000005917B7D100BE10C06D533C2EAAEB4B40
77453	G32 8YS	GB	0101000020E6100000A1D9756F45A210C0D3BD4EEACBEA4B40
77454	G32 9	GB	0101000020E610000045F295404A9C10C00A2FC1A90FEC4B40
77455	G32 9HZ	GB	0101000020E6100000C11A67D3119010C0B648DA8D3EEC4B40
77456	G33 1HJ	GB	0101000020E61000008A929048DBB810C034BBEEAD48F24B40
77457	G33 2AW	GB	0101000020E6100000D234289A07C010C01EE0490B97EF4B40
77458	G33 2JT	GB	0101000020E6100000C24D469561CC10C07E384888F2ED4B40
77459	G33 2RH	GB	0101000020E6100000FAF202ECA3C310C084A0A3552DEF4B40
77460	G33 3RX	GB	0101000020E6100000BD1DE1B4E0A510C0FB777DE6ACEF4B40
77461	G33 6	GB	0101000020E61000002786E464E2A610C0A0A70183A4F14B40
77462	G33 6AT	GB	0101000020E61000009BAF928FDD9510C09F724C16F7F14B40
77463	G4 0HF	GB	0101000020E6100000CE8C7E349C0211C01D740987DEEE4B40
77464	G4 0HL	GB	0101000020E6100000CF842689250511C00F98874CF9EE4B40
77465	G4 0PX	GB	0101000020E61000002444F98216F210C036E7E099D0EE4B40
77466	G4 0RA	GB	0101000020E610000034BF9A0304F310C0051901158EEE4B40
77467	G4 0YF	GB	0101000020E61000008E06F01648F010C08B36C7B94DEE4B40
77468	G4 9EE	GB	0101000020E6100000494DBB98661A11C03D7E6FD39FEF4B40
77469	G4 9HF	GB	0101000020E6100000242A5437171F11C007CE1951DAEF4B40
77470	G40 1AZ	GB	0101000020E61000004CFBE6FEEAF110C0F19BC24A05ED4B40
77471	G40 1BN	GB	0101000020E61000006AA164726AE710C0FCC56CC9AAEC4B40
77472	G40 4HG	GB	0101000020E610000052F01472A5DE10C0DE1D19ABCDEB4B40
77473	G41	GB	0101000020E610000063096B63EC2411C08D5E0D501AEC4B40
77474	G41 1PR	GB	0101000020E610000045292158550F11C0F8E0B54B1BEC4B40
77475	G41 1RR	GB	0101000020E61000001E4E603AAD0B11C0D6AD9E93DEE94B40
77476	G41 2AL	GB	0101000020E6100000F0366F9C141611C0D575A8A624EB4B40
77477	G41 2DP	GB	0101000020E6100000C11DA8531E1D11C0EAB12D03CEEA4B40
77478	G41 2HA	GB	0101000020E6100000B1169F02601C11C05628D2FD9CEA4B40
77479	G41 2LW	GB	0101000020E6100000E014562AA81811C0B51666A19DEB4B40
77480	G41 2NE	GB	0101000020E610000005E10A28D41311C0B7CF2A33A5EB4B40
77481	G41 3AZ	GB	0101000020E6100000DD0BCC0A451A11C0C1C9367007EA4B40
77482	G41 3LP	GB	0101000020E6100000957F2DAF5C1F11C046787B1002EA4B40
77483	G41 3LR	GB	0101000020E6100000772FF7C9512011C0A0FD481119EA4B40
77484	G41 3RR	GB	0101000020E6100000A33B889D292411C056EF703B34EA4B40
77485	G41 3TW	GB	0101000020E61000004374081C092411C0FA97A432C5EA4B40
77486	G41 3UG	GB	0101000020E6100000D9226937FA2811C06362F3716DEA4B40
77487	G41 3UH	GB	0101000020E6100000F437A110012711C0E353008C67EA4B40
77488	G41 3XG	GB	0101000020E610000013F3ACA4151F11C0795C548B88EA4B40
77489	G41 3YN	GB	0101000020E6100000809BC58B852111C052499D8026EA4B40
77490	G41 4DT	GB	0101000020E61000000FD6FF39CC2711C0F6B52E3542EB4B40
77491	G41 4HE	GB	0101000020E610000041F2CEA10C3511C00EBE30992AEC4B40
77492	G41 4NW	GB	0101000020E6100000B7989F1B9A2211C04C38F4160FEB4B40
77493	G41 5BZ	GB	0101000020E6100000410C74ED0B3811C0A6B915C26AEC4B40
77494	G41 5DJ	GB	0101000020E6100000D7C22CB4733A11C039D55A9885EC4B40
77495	G41 5DU	GB	0101000020E610000055849B8C2A2311C02BDD5D6743EC4B40
77496	G41 5HW	GB	0101000020E6100000D331E719FB2211C0E25B5837DEEB4B40
77497	G41 5LE	GB	0101000020E61000008E075BECF63911C0FA0D130D52EC4B40
77498	G41 5QE	GB	0101000020E610000031992A18953411C01B0DE02D90EC4B40
77499	G42	GB	0101000020E6100000F355F2B1BB1011C0469561DC0DEA4B40
77500	G42 1AA	GB	0101000020E610000012A27C410BE910C0CE3461FBC9E84B40
77501	G42 7RR	GB	0101000020E61000003332C85D840911C030F5F3A622EB4B40
77502	G42 8AY	GB	0101000020E610000018D1764CDD2511C0ADDC0BCC0AEB4B40
77503	G42 8ES	GB	0101000020E6100000D61C2098A30711C01A4D2EC6C0EA4B40
77504	G42 8NG	GB	0101000020E6100000C0CDE2C5C21011C08DCF64FF3CEB4B40
77505	G42 8PH	GB	0101000020E610000048FAB48AFE1011C05B5F24B4E5EA4B40
77506	G42 8PQ	GB	0101000020E6100000F81C588E901111C0309E4143FFEA4B40
77507	G42 8RT	GB	0101000020E61000004CE141B3EB0E11C0C45A7C0A80EB4B40
77508	G42 9NA	GB	0101000020E61000000CCD751A691911C00C7558E196E94B40
77509	G42 9TT	GB	0101000020E6100000787C7BD7A00F11C0672618CE35EA4B40
77510	G42 9TY	GB	0101000020E61000001DAED51EF61211C06346787B10EA4B40
77511	G43	GB	0101000020E61000005BB05417F02211C00E828E56B5E84B40
77512	G43 1AT	GB	0101000020E610000056D3F544D74511C04C5299620EEA4B40
77513	G43 1NE	GB	0101000020E61000006326512FF83411C01781B1BE81E94B40
77514	G43 1TS	GB	0101000020E61000003412A1116C1C11C00FF10F5B7AE84B40
77515	G43 1TW	GB	0101000020E6100000DA91EA3BBF2811C0DC627E6E68E84B40
77516	G43 2AR	GB	0101000020E61000000BD0B69A753611C0D525E318C9E84B40
77517	G43 2HD	GB	0101000020E6100000A31EA2D11D1411C0AFEDED96E4E84B40
77518	G43 2HP	GB	0101000020E610000017B7D100DE1211C02864E76D6CEA4B40
77519	G43 2JH	GB	0101000020E61000005340DAFF001B11C0849A215514E94B40
77520	G43 2SL	GB	0101000020E6100000EB353D28282511C0103CBEBD6BE84B40
77521	G43 2SW	GB	0101000020E610000087FC3383F82011C09BE3DC26DCE74B40
77522	G43 2YQ	GB	0101000020E61000001E8B6D52D12811C0815D4D9EB2E84B40
77523	G44	GB	0101000020E61000007AFEB4519DFE10C03C139A2496E84B40
77524	G44 3BP	GB	0101000020E6100000554E7B4ACE1911C0D9791B9B1DE54B40
77525	G44 3HG	GB	0101000020E6100000C2340C1F110311C0E5B9BE0F07ED4B40
77526	G44 3HZ	GB	0101000020E610000017D9CEF7532311C0772B4B7496E74B40
77527	G44 3NY	GB	0101000020E610000088635DDC460311C047753A90F5E84B40
77528	G44 3QE	GB	0101000020E61000003FC7478B331611C0D55E44DB31E74B40
77529	G44 3TE	GB	0101000020E61000003B545392751811C0552E54FEB5E64B40
77530	G44 3YU	GB	0101000020E6100000E42D573F360911C068CA4E3FA8E74B40
77531	G44 3YZ	GB	0101000020E610000008C90226700B11C09C51F355F2E74B40
77532	G44 4ED	GB	0101000020E61000005340DAFF000B11C0FD4AE7C3B3E84B40
77533	G44 4QR	GB	0101000020E6100000F0F96184F01811C040A54A94BDE74B40
77534	G44 4TD	GB	0101000020E61000005001309E410311C03FE1ECD632E94B40
77535	G44 4UP	GB	0101000020E6100000A4C4AEEDED0611C09E25C808A8E84B40
77536	G44 5AH	GB	0101000020E6100000BB48A12C7CED10C052B81E85EBE94B40
77537	G44 5HS	GB	0101000020E6100000DB4DF04DD3F710C049F7730AF2E74B40
77538	G44 5RB	GB	0101000020E6100000172B6A300DF310C08CBAD6DEA7E84B40
77539	G44 5UT	GB	0101000020E61000003EEDF0D764FD10C0236B0DA5F6E84B40
77540	G46	GB	0101000020E6100000BE175FB4C73B11C0300DC347C4E64B40
77541	G46 6AH	GB	0101000020E6100000A2293BFDA02E11C0C7BB2363B5E74B40
77542	G46 6JB	GB	0101000020E6100000E7357689EA3D11C015E63DCE34E54B40
77543	G46 6JF	GB	0101000020E6100000F5D555815A2C11C0DD60A8C30AE74B40
77544	G46 6JT	GB	0101000020E61000003677F4BF5C2B11C0C90391459AE64B40
77545	G46 6LN	GB	0101000020E6100000ADF886C2672B11C0284696CCB1E64B40
77546	G46 6SA	GB	0101000020E610000048895DDBDB3D11C0E92B483316E54B40
77547	G46 6SY	GB	0101000020E61000009831056B9C3D11C0C70E2A711DE54B40
77548	G46 7AL	GB	0101000020E6100000A796ADF5453211C097A8DE1AD8E64B40
77549	G46 7AN	GB	0101000020E6100000D4EFC2D66C3511C0F9C08EFF02E74B40
77550	G46 7BY	GB	0101000020E61000002A91442FA33811C0F0332E1C08E74B40
77551	G46 7DA	GB	0101000020E6100000BE839F38803E11C0B9AB5791D1E74B40
77552	G46 7DH	GB	0101000020E6100000179AEB34D22211C03411363CBDE84B40
77553	G46 7JF	GB	0101000020E6100000518369183E4211C027A435069DE64B40
77554	G46 7JP	GB	0101000020E6100000A14CA3C9C53811C0AF2479AEEFE54B40
77555	G46 7SR	GB	0101000020E6100000D9E89C9FE23811C07007EA9447E74B40
77556	G46 7UP	GB	0101000020E610000003EFE4D3636B11C0BBD23252EFE94B40
77557	G46 8HP	GB	0101000020E61000001D01DC2C5E4C11C0BCAE5FB01BE84B40
77558	G5	GB	0101000020E610000092CB7F48BFDD10C0392BA226FAEA4B40
77559	G5 0QD	GB	0101000020E610000014967840D9F410C04B917C2590EC4B40
77560	G5 0SL	GB	0101000020E610000046EA3D95D3FE10C09B38B9DFA1EC4B40
77561	G51	GB	0101000020E6100000C712D6C6D83911C084F23E8EE6EC4B40
77562	G51 1QH	GB	0101000020E6100000C4E9245B5D0E11C0CA6C904946EC4B40
77563	G51 2BG	GB	0101000020E6100000355F251FBB5B11C015A930B610E64B40
77564	G51 2TN	GB	0101000020E6100000B0E76B96CB4611C07EE36BCF2CE94B40
77565	G52	GB	0101000020E610000070067FBF98DD10C0AE635C7171EC4B40
77566	G52 1QR	GB	0101000020E6100000F7AFAC34295511C0CB4C69FD2DEB4B40
77567	G52 2DE	GB	0101000020E6100000D49CBCC8045C11C01C0B0A8332ED4B40
77568	G52 2TD	GB	0101000020E6100000A1478C9E5B6811C06BD8EF8975EC4B40
77569	G52 3ET	GB	0101000020E6100000DAE6C6F4846511C0128942CBBAEB4B40
77570	G52 3NF	GB	0101000020E6100000E46A64575A7611C0E8BB5B59A2EB4B40
77571	G52 3QF	GB	0101000020E6100000AD16D863227511C0F4BF5C8B16EC4B40
77572	G52 3TX	GB	0101000020E61000003F709527107611C0261B0FB6D8EB4B40
77573	G52 4NQ	GB	0101000020E6100000616C21C8417911C0A48E8EAB91ED4B40
77574	G52 4RU	GB	0101000020E6100000B8C83D5DDD7111C045A165DD3FEE4B40
77575	G53	GB	0101000020E6100000E4BB94BA644C11C0C0B2D2A414EA4B40
77576	G53 7NX	GB	0101000020E6100000E8F86871C67011C0897E6DFDF4E74B40
77577	G53 7SX	GB	0101000020E6100000100874266D7A11C000ADF9F197EA4B40
77578	G53 7US	GB	0101000020E6100000A33EC91D366111C0601F9DBAF2E74B40
77579	G60 5AH	GB	0101000020E6100000ABE80FCD3CF911C0D6C6D8092FF74B40
77580	G60 5AQ	GB	0101000020E61000003CA06CCA15EE11C07EE36BCF2CF74B40
77581	G60 5AY	GB	0101000020E6100000952A51F696F211C0D76839D043F74B40
77582	G60 5DP	GB	0101000020E61000007F17B6662BCF11C00EDB166536F64B40
77583	G60 5LX	GB	0101000020E6100000740CC85EEFCE11C0E9B985AE44F64B40
77584	G61	GB	0101000020E61000003F3BE0BA624611C06D00362042F44B40
77585	G61 0NL	GB	0101000020E6100000234C512E8D3F11C0C39E76F86BF64B40
77586	G61 1	GB	0101000020E6100000D6743DD1755111C0DFC5FB71FBF34B40
77587	G61 1PA	GB	0101000020E61000009A7ADD22305611C0293C6876DDF34B40
77588	G61 2AG	GB	0101000020E6100000EB5223F4334511C072BF4351A0F54B40
77589	G61 2EP	GB	0101000020E61000008995D1C8E74511C018CC5F2173F54B40
77590	G61 2NA	GB	0101000020E6100000D9226937FA4811C02DCE18E604F54B40
77591	G61 3PG	GB	0101000020E610000067614F3BFC4511C00262122EE4F54B40
77592	G61 4AN	GB	0101000020E61000007AC37DE4D65411C0102219726CF54B40
77593	G61 4SQ	GB	0101000020E6100000EEEA5564747011C05C566133C0F74B40
77594	G62 6EL	GB	0101000020E6100000EBE5779ACC2811C04EB4AB90F2F74B40
77595	G62 7JL	GB	0101000020E6100000EE5EEE93A35011C082035ABA82F94B40
77596	G62 8NH	GB	0101000020E61000007CB43863984311C02B4EB51666F94B40
77597	G62 8PG	GB	0101000020E61000000E1137A7924111C0EDB60BCD75F84B40
77598	G63 0AR	GB	0101000020E610000034812216318C12C01D59F96530144C40
77599	G63 0BQ	GB	0101000020E610000041102043C7CE11C034130CE71A084C40
77600	G63 0XA	GB	0101000020E61000001FA1664815E510C093E52494BE064C40
77601	G63 9EE	GB	0101000020E6100000588E90813C3B11C0A33B889D29FE4B40
77602	G63 9QE	GB	0101000020E6100000B58AFED0CC8311C0C8CD70033E054C40
77603	G64	GB	0101000020E6100000F9D687F5465D10C019709692E5F24B40
77604	G64 1	GB	0101000020E6100000CEFDD5E3BEC510C0179E978A8DF34B40
77605	G64 1LU	GB	0101000020E6100000EA76F69507C910C0BEA4315A47F34B40
77606	G64 2BX	GB	0101000020E6100000BC581822A7EF10C0062CB98AC5F34B40
77607	G64 2LX	GB	0101000020E6100000E6CFB7054BE510C061DF4E22C2F34B40
77608	G64 3AW	GB	0101000020E610000087F9F202ECF310C0998235CEA6F34B40
77609	G64 4BY	GB	0101000020E61000006477819202CB10C0ED80EB8A19F94B40
77610	G65 0DE	GB	0101000020E6100000315C1D00713710C0378B170B43FC4B40
77611	G65 9HT	GB	0101000020E610000096E82CB3082510C07DEC2E5052FA4B40
77612	G66 1DB	GB	0101000020E6100000BC5AEECC04C310C08F1CE90C8CF84B40
77613	G66 1LG	GB	0101000020E61000008F1D54E23A9610C03DF19C2D20F84B40
77614	G66 2DB	GB	0101000020E6100000DA722EC5559510C0EF3CF19C2DF84B40
77615	G66 2DW	GB	0101000020E61000008716D9CEF79310C0E1CFF0660DF84B40
77616	G66 3	GB	0101000020E6100000C02500FF949A10C09544F64196F74B40
77617	G66 4DB	GB	0101000020E610000010C99063EBA910C0552FBFD364F64B40
77618	G66 4DT	GB	0101000020E6100000537B116DC7B410C09566F3380CF64B40
77619	G66 4HJ	GB	0101000020E610000010B22C98F8A310C0E10D6954E0F64B40
77620	G66 4JP	GB	0101000020E61000005BEF37DA71B310C0841266DAFEF54B40
77621	G66 4UA	GB	0101000020E61000008D9AAF928F9D10C056478E7406F64B40
77622	G66 5HB	GB	0101000020E6100000772B4B74969910C062DA37F757F54B40
77623	G66 5LX	GB	0101000020E61000007FBDC282FB9110C0BFF4F6E7A2F54B40
77624	G66 7LF	GB	0101000020E61000006F2EFEB627E810C0D272A087DAFC4B40
77625	G67 1PY	GB	0101000020E6100000B212F3ACA4D50FC001BF469220FA4B40
77626	G67 2DD	GB	0101000020E6100000792288F370C20FC0D80DDB1665FA4B40
77627	G67 3AP	GB	0101000020E61000003C84F1D3B8B70FC0C26D6DE179F94B40
77628	G67 3BD	GB	0101000020E6100000B3D30FEA22A50FC0FF3EE3C281FA4B40
77629	G67 3NN	GB	0101000020E610000026C632FD12D10FC0E7374C3448FB4B40
77630	G67 4EQ	GB	0101000020E61000003815A930B62010C0B5DC990986F74B40
77631	G67 4LB	GB	0101000020E61000001B498270050410C07C80EECB99F74B40
77632	G67 4SE	GB	0101000020E61000009D853DEDF01710C09225732CEFF64B40
77633	G68	GB	0101000020E6100000CE8C7E349CD20FC0F3C81F0C3CFB4B40
77634	G68 0AN	GB	0101000020E6100000ACAB02B5180C10C0626A4B1DE4FB4B40
77635	G68 0DJ	GB	0101000020E6100000081C0934D81410C0698CD651D5FA4B40
77636	G68 9DT	GB	0101000020E61000002123A0C2110410C0E4654D2CF0F94B40
77637	G69	GB	0101000020E6100000CB48BDA7727A10C09F91088D60ED4B40
77638	G69 1AA	GB	0101000020E6100000EFAD484C508310C0B2F50CE198ED4B40
77639	G69 6JX	GB	0101000020E610000007B47405DB7810C0FFB0A54753ED4B40
77640	G69 6NZ	GB	0101000020E61000007BF5F1D0778710C0FB21365838ED4B40
77641	G69 6SE	GB	0101000020E6100000A96A82A8FB7010C0F12A6B9BE2ED4B40
77642	G69 7DB	GB	0101000020E61000004D9EB29AAE8710C0FCC22B499EEB4B40
77643	G69 7DW	GB	0101000020E6100000ACA8C1340C7F10C015FF774485EC4B40
77644	G69 7JL	GB	0101000020E6100000E8A1B60DA37010C0E690D442C9EC4B40
77645	G69 7LU	GB	0101000020E61000003BC61517478510C0C8091346B3EC4B40
77646	G69 7RN	GB	0101000020E6100000C6FB71FBE57310C056D28A6F28EC4B40
77647	G69 7TS	GB	0101000020E6100000B98AC56F0A4B10C040A19E3E02ED4B40
77648	G71	GB	0101000020E6100000BBF083F3A94310C02942EA76F6E74B40
77649	G71 7BU	GB	0101000020E610000084807C09154C10C011514CDE00E94B40
77650	G71 7LR	GB	0101000020E61000009546CCECF35810C0A30392B06FE94B40
77651	G71 8AR	GB	0101000020E6100000F4DC4257224010C0454AB3791CE64B40
77652	G71 8QR	GB	0101000020E6100000899AE8F3513610C0CEC64ACCB3E64B40
77653	G71 8SS	GB	0101000020E61000002BC3B81B445B10C0D07F0F5EBBE84B40
77654	G71 8TS	GB	0101000020E61000004242942F685110C0C0CC77F013E74B40
77655	G72	GB	0101000020E6100000BEA59C2FF69E10C03BFC3559A3E84B40
77656	G72 0DA	GB	0101000020E6100000AD3594DA8B5810C09ECE15A584E44B40
77657	G72 7EL	GB	0101000020E61000008D28ED0DBEB010C075745C8DECE84B40
77658	G72 7TD	GB	0101000020E610000042B5C189E88710C06133C005D9E84B40
77659	G72 7XX	GB	0101000020E610000073672618CE8510C0950ED6FF39E84B40
77660	G72 7YD	GB	0101000020E610000042E90B21E78D10C0063065E080E84B40
77661	G72 8BH	GB	0101000020E61000002252D32EA6B910C0F6083543AAE84B40
77662	G72 8ER	GB	0101000020E610000041446ADAC5B410C0B0C7444AB3E74B40
77663	G72 8NL	GB	0101000020E61000006286C61341AC10C0A5DDE8633EE84B40
77664	G72 8PB	GB	0101000020E610000095F0845E7FB210C0BF2A172AFFE64B40
77665	G72 8RE	GB	0101000020E6100000DDEF5014E8A310C0213B6F63B3E74B40
77666	G72 9BB	GB	0101000020E6100000BDC3EDD0B05810C0D80E46EC13E64B40
77667	G72 9BY	GB	0101000020E610000013F241CF665510C0E8A1B60DA3E64B40
77668	G72 9SR	GB	0101000020E610000077BAF3C4737610C09758198D7CE44B40
77669	G73	GB	0101000020E61000005B25581CCEDC10C05C035B2558EA4B40
77670	G73 1DB	GB	0101000020E6100000753A90F5D4DA10C00C79043752EA4B40
77671	G73 1XW	GB	0101000020E61000008A8F4FC8CEEB10C0944A7842AFE94B40
77672	G73 3LZ	GB	0101000020E6100000C9E4D4CE30C510C01250E10852E94B40
77673	G73 3PA	GB	0101000020E61000009F3D97A949D010C0F9D687F546E94B40
77674	G73 3QY	GB	0101000020E6100000ACE63922DFD510C03A58FFE730E94B40
77675	G73 3SA	GB	0101000020E610000033DFC14F1CD010C088484DBB98E84B40
77676	G73 4NU	GB	0101000020E6100000B60F79CBD5FF10C087A5811FD5EC4B40
77677	G74 1AR	GB	0101000020E610000022C66B5ED5B910C0F78F85E810E24B40
77678	G74 2BJ	GB	0101000020E6100000FED5E3BED59A10C0C2340C1F11E14B40
77679	G74 2BU	GB	0101000020E6100000994A3FE1EC9610C0E2C8039145E24B40
77680	G74 3DY	GB	0101000020E61000003961C26856A610C02C4487C091E24B40
77681	G74 3HY	GB	0101000020E6100000C4211B48179B10C0698CD651D5E24B40
77682	G74 3RU	GB	0101000020E6100000F5B86FB54E8C10C0DEE522BE13E34B40
77683	G74 4DB	GB	0101000020E61000001FBB0B94149810C07A71E2AB1DE34B40
77684	G74 4EP	GB	0101000020E61000003A4030478FAF10C0959F54FB74E24B40
77685	G74 4EX	GB	0101000020E6100000FB22A12DE7B210C0FD2E6CCD56E24B40
77686	G74 4GB	GB	0101000020E6100000971B0C75587110C02FA699EE75E44B40
77687	G74 4JZ	GB	0101000020E61000009563B2B8FFB810C0F27A30293EE24B40
77688	G74 4RT	GB	0101000020E6100000DC63E94317A410C0433BA759A0E14B40
77689	G74 5	GB	0101000020E610000022FDF675E0EC10C086CB2A6C06E24B40
77690	G74 5AB	GB	0101000020E6100000BF0CC688440111C0D333BDC458E24B40
77691	G75	GB	0101000020E6100000058BC3995FBD10C04D8237A451E14B40
77692	G75 0YL	GB	0101000020E6100000A2EC2DE57CB110C030F488D173DF4B40
77693	G75 8TH	GB	0101000020E6100000F08975AA7C9F10C02F88484DBBE24B40
77694	G75 9JA	GB	0101000020E6100000CA8CB7955EDB10C0FB743C66A0E84B40
77695	G75 9JT	GB	0101000020E6100000CBF5B6990AC110C0D6C56D3480DF4B40
77696	G76	GB	0101000020E6100000DEC7D11C592911C00BED9C6681E04B40
77697	G76 0EU	GB	0101000020E6100000BD72BD6DA62211C0E886A6ECF4E14B40
77698	G76 0HF	GB	0101000020E6100000F60D4C6E141911C0508E0244C1E04B40
77699	G76 0JD	GB	0101000020E61000004832AB77B81D11C06478EC67B1EA4B40
77700	G76 0NG	GB	0101000020E610000007CF8426892511C0E8A1B60DA3DE4B40
77701	G76 7QW	GB	0101000020E610000071E7C2482F2A11C061A6ED5F59E54B40
77702	G76 8JB	GB	0101000020E6100000BCE7C072840C11C06364C91CCBE34B40
77703	G76 8QB	GB	0101000020E610000040DCD5ABC81811C08481E7DEC3E34B40
77704	G76 8RB	GB	0101000020E610000019761893FE2E11C0DC4603780BE44B40
77705	G76 8RF	GB	0101000020E6100000205F4205870711C01898158A74E34B40
77706	G76 9AT	GB	0101000020E6100000F3CCCB61F7ED10C07026A60BB1E44B40
77707	G76 9DD	GB	0101000020E6100000F8FA5A971AF110C0C6FD47A643E54B40
77708	G76 9HR	GB	0101000020E610000024F25D4A5DE210C09D9CA1B8E3E34B40
77709	G77	GB	0101000020E6100000A3E9EC64705411C0C6BE64E3C1E44B40
77710	G77 6JJ	GB	0101000020E6100000DF8AC404355C11C06FD6E07D55E44B40
77711	G77 6TJ	GB	0101000020E6100000931804560E5D11C033F9669B1BE34B40
77712	G78	GB	0101000020E610000002B7EEE6A98E11C0AE49B72572E54B40
77713	G78 1	GB	0101000020E6100000BBEEAD484C9011C076C6F7C5A5E64B40
77714	G78 1AA	GB	0101000020E6100000C80BE9F0109611C0E3175E49F2E64B40
77715	G78 1DD	GB	0101000020E6100000CD04C3B9868911C0AD1402B9C4E74B40
77716	G78 1LS	GB	0101000020E6100000CB4BFE277F9711C0A182C30B22E64B40
77717	G78 3	GB	0101000020E610000051F701486DB211C0E597C11891E44B40
77718	G78 3EE	GB	0101000020E61000004B1FBAA0BEB511C0118E59F624E44B40
77719	G81	GB	0101000020E61000001689096AF87611C011C7BAB88DF24B40
77720	G81 1AD	GB	0101000020E610000002BA2F67B68B11C0774CDD955DF24B40
77721	G81 1RT	GB	0101000020E610000054556820969D11C066C1C41F45F34B40
77722	G81 2JQ	GB	0101000020E61000004A42226DE39F11C03D5FB35C36F44B40
77723	G81 3QT	GB	0101000020E6100000C40AB77C24B511C07C4276DEC6F44B40
77724	G81 4SS	GB	0101000020E6100000709692E524B411C0C79BFC169DF44B40
77725	G81 6PA	GB	0101000020E610000018601F9DBAA211C03DD175E107F74B40
77726	G82	GB	0101000020E6100000DD06B5DFDA3912C051A3906456F94B40
77727	G82 1PZ	GB	0101000020E61000009E616A4B1D4412C071E481C822F94B40
77728	G82 2BA	GB	0101000020E610000085436FF1F03E12C0D0B69A75C6F94B40
77729	G82 2EP	GB	0101000020E6100000EC6CC83F333812C047938B31B0F84B40
77730	G82 3PQ	GB	0101000020E610000080F44D9A062512C0AD6BB41CE8F94B40
77731	G82 4AD	GB	0101000020E6100000C2A1B778784F12C09B02999D45F94B40
77732	G82 4ND	GB	0101000020E61000007A34D593F95712C08A7780272DFC4B40
77733	G82 5HD	GB	0101000020E6100000F261F6B2EDA412C0B8CEBF5DF6FB4B40
77734	G82 5LY	GB	0101000020E6100000B8EA3A54539212C008AEF204C2FC4B40
77735	G82 5NL	GB	0101000020E61000005CACA8C1349C12C0A20BEA5BE6FA4B40
77736	G83	GB	0101000020E6100000A226FA7C945112C0C2C2499A3FFC4B40
77737	G83 0QP	GB	0101000020E6100000AA27F38FBE4912C0FC5069C4CCFE4B40
77738	G83 0UL	GB	0101000020E6100000BE141E34BB4E12C07C0A80F10CFE4B40
77739	G83 7AJ	GB	0101000020E61000003E40F7E5CCF612C0CB9E0436E71A4C40
77740	G83 7AY	GB	0101000020E6100000707D586FD4FA12C0A2ED98BA2B194C40
77741	G83 8AF	GB	0101000020E6100000BA6B09F9A04712C0F20703CFBD014C40
77742	G83 8LJ	GB	0101000020E6100000950B957F2D4F12C0DE9387855A014C40
77743	G83 8QX	GB	0101000020E6100000C5538F34B85D12C09293895B05014C40
77744	G83 8QZ	GB	0101000020E6100000437573F1B76D12C04D6A6803B0014C40
77745	G83 8SS	GB	0101000020E6100000FB3C4679E65512C01895D40968004C40
77746	G83 9PQ	GB	0101000020E61000007E1CCD91954F12C0569A94826EFD4B40
77747	G84	GB	0101000020E6100000E09C11A5BDE112C06231EA5A7B034C40
77748	G84 7BD	GB	0101000020E6100000C93846B247D812C0A1BFD02346FF4B40
77749	G84 7ER	GB	0101000020E6100000A4552DE928E712C0F355F2B1BB004C40
77750	G84 7QF	GB	0101000020E61000009D7FBBECD7ED12C02E724F5777004C40
77751	G84 7RR	GB	0101000020E6100000730F09DFFBEB12C0B519A721AA004C40
77752	G84 8	GB	0101000020E61000008E041A6CEAFC12C09C6C0377A0004C40
77753	G84 8HL	GB	0101000020E61000009B215514AF4213C063B323D577064C40
77754	G84 8LH	GB	0101000020E61000006AF816D68D1713C027F8A6E9B3014C40
77755	G84 9AJ	GB	0101000020E6100000F5D8960167E912C0118E59F624024C40
77756	G84 9DL	GB	0101000020E6100000AE669DF17DE112C07C629D2ADF014C40
77757	G84 9JX	GB	0101000020E61000008F554ACFF4F212C02313F06B24014C40
77758	G84 9LG	GB	0101000020E6100000B2683A3B19EC12C08C6665FB90014C40
77759	GL1 0XS	GB	0101000020E6100000C6C210397DDD01C066A208A9DBED4940
77760	GL1 1DE	GB	0101000020E6100000EDD632198EE701C0F5BD86E0B8EE4940
77761	GL1 1PN	GB	0101000020E6100000D49E927362EF01C07973B8567BEE4940
77762	GL1 1UG	GB	0101000020E6100000ADC3D155BAFB01C0BDFF8F1326EE4940
77763	GL1 2QG	GB	0101000020E6100000AD4ECE50DCF101C084D9041896EF4940
77764	GL1 2QJ	GB	0101000020E61000000971E5EC9DF101C0BA6587F887EF4940
77765	GL1 3JT	GB	0101000020E6100000EC681CEA77E101C0823CBB7CEBEF4940
77766	GL1 3NN	GB	0101000020E6100000DD9A745B22D701C02E03CE52B2EE4940
77767	GL1 3PP	GB	0101000020E610000093DFA293A5D601C09BFEEC478AEE4940
77768	GL1 5EA	GB	0101000020E610000039454772F9EF01C0A3CA30EE06ED4940
77769	GL1 5NL	GB	0101000020E61000005DE2C803910502C0CE18E6046DEC4940
77770	GL10 2BG	GB	0101000020E6100000CCD42478435A02C09C887E6DFDDE4940
77771	GL10 2HH	GB	0101000020E6100000897B2C7DE84202C0A3AF20CD58E04940
77772	GL10 2JW	GB	0101000020E6100000603E59315C3D02C0D6A8876874DF4940
77773	GL10 2QS	GB	0101000020E610000034F44F70B14202C039F2406491E04940
77774	GL10 3BH	GB	0101000020E610000073D87DC7F09802C041B7973446DF4940
77775	GL10 3DB	GB	0101000020E61000003F53AF5B042602C0D21A834E08E14940
77776	GL10 3JA	GB	0101000020E6100000A70705A5682502C0AE4A22FB20DD4940
77777	GL10 3JD	GB	0101000020E6100000C6FB71FBE53302C0A0DCB6EF51DD4940
77778	GL10 3QS	GB	0101000020E61000003752B648DA4D02C0B1DCD26A48DE4940
77779	GL10 3RE	GB	0101000020E610000076C58CF0F66002C06DC83F3388DF4940
77780	GL10 3TS	GB	0101000020E6100000535E2BA1BB4402C06E32AA0CE3DA4940
77781	GL11	GB	0101000020E61000002C9D0FCF12E402C02F6D382C0DD84940
77782	GL11 4BT	GB	0101000020E6100000CD785BE9B5D902C073F38DE89ED74940
77783	GL11 4DG	GB	0101000020E61000005B96AFCBF0DF02C0DAE4F04927D84940
77784	GL11 4EY	GB	0101000020E6100000B9382A3751EB02C037514B732BD84940
77785	GL11 4JT	GB	0101000020E61000002F17F19D98D502C0026553AEF0D64940
77786	GL11 4ND	GB	0101000020E6100000ADC266800BD202C047753A90F5D64940
77787	GL11 5BS	GB	0101000020E6100000263ACB2C429102C06EDDCD531DD64940
77788	GL11 5DJ	GB	0101000020E61000007C48F8DEDFE002C0A0FEB3E6C7DB4940
77789	GL11 5EH	GB	0101000020E6100000CA5356D3F5A402C02B6EDC627EDA4940
77790	GL11 5EP	GB	0101000020E61000003161342BDBA702C0AAB5300BEDDA4940
77791	GL11 5HL	GB	0101000020E61000002785798F33AD02C0AC71361D01DA4940
77792	GL11 5JN	GB	0101000020E61000008F72309B00E302C09BAF928FDDD94940
77793	GL11 5LE	GB	0101000020E61000003080F0A144EB02C00DFAD2DB9FD94940
77794	GL11 5NU	GB	0101000020E6100000965984622BE802C0895C70067FD94940
77795	GL11 5RX	GB	0101000020E61000000DC347C494E802C02F36AD1402D94940
77796	GL11 5SS	GB	0101000020E6100000923EADA23F7402C0397B67B455D74940
77797	GL11 5TJ	GB	0101000020E6100000D2510E66138002C03B6F63B323D74940
77798	GL11 6AL	GB	0101000020E6100000512E8D5F780503C0C9AB730CC8D84940
77799	GL11 6BQ	GB	0101000020E6100000672C9ACE4E2603C0F030ED9BFBD74940
77800	GL11 6DH	GB	0101000020E6100000E525FF93BF1B03C016889E9449D54940
77801	GL11 6DT	GB	0101000020E61000001A69A9BC1D0103C0F549EEB089D44940
77802	GL11 6HB	GB	0101000020E61000008DD47B2AA7FD02C0F4C308E1D1D84940
77803	GL11 6HE	GB	0101000020E61000006A2FA2ED98FA02C065ABCB2901D94940
77804	GL11 6HG	GB	0101000020E610000006A1BC8FA3F902C0390EBC5AEED84940
77805	GL12 7AR	GB	0101000020E61000008D60E3FA77DD02C03C50A73CBAD14940
77806	GL12 7BN	GB	0101000020E6100000F08AE07F2BD902C0C284D1AC6CD14940
77807	GL12 7BX	GB	0101000020E610000045D4449F8FD202C01232906797D14940
77808	GL12 7DT	GB	0101000020E6100000261AA4E029E402C06F9C14E63DD24940
77809	GL12 7DZ	GB	0101000020E61000001E8CD82780E202C0E0F2583332D24940
77810	GL12 7HP	GB	0101000020E610000033FAD170CABC02C0B3976DA7ADD14940
77811	GL12 7JA	GB	0101000020E6100000A9C0C93670C702C0E466B8019FD14940
77812	GL12 7NB	GB	0101000020E61000001689096AF8B602C0B9C667B27FD24940
77813	GL12 7PP	GB	0101000020E61000008330B77BB9EF02C0D462F030EDD14940
77814	GL12 7PZ	GB	0101000020E610000067EF8CB62A8902C0E6E5B0FB8ED14940
77815	GL12 7RU	GB	0101000020E610000058569A9482AE02C0E5ED08A705CD4940
77816	GL12 8AD	GB	0101000020E610000014B2F336367B03C0B41EBE4C14CF4940
77817	GL12 8AF	GB	0101000020E6100000CFDC43C2F77E03C0709A3E3BE0CE4940
77818	GL12 8AH	GB	0101000020E6100000CB49287D218403C0BE89213999CE4940
77819	GL12 8AJ	GB	0101000020E61000005A84622B687A03C064E76D6C76CE4940
77820	GL12 8AL	GB	0101000020E6100000D13DEB1A2D8703C0E353008C67CE4940
77821	GL12 8AN	GB	0101000020E61000004CC79C67EC8B03C06F29E78BBDCD4940
77822	GL12 8AT	GB	0101000020E610000032AF230ED98003C02C2B4D4A41CD4940
77823	GL12 8AU	GB	0101000020E6100000DC65BFEE748703C06823D74D29CD4940
77824	GL12 8AW	GB	0101000020E610000042E8A04B389403C05307793D98CE4940
77825	GL12 8AX	GB	0101000020E61000007CF31B261A8403C0BCCFF1D1E2CC4940
77826	GL12 8AY	GB	0101000020E6100000AB5CA8FC6B7903C03A94A12AA6CC4940
77827	GL12 8BG	GB	0101000020E6100000ABCE6A813D8603C0E6913F1878CE4940
77828	GL12 8DL	GB	0101000020E6100000B80721205FA203C0B0FECF61BED24940
77829	GL12 8DS	GB	0101000020E6100000081D740987BE03C07BA35698BECF4940
77830	GL12 8JB	GB	0101000020E6100000BA85AE44A03A03C03B730F09DFCB4940
77831	GL12 8JD	GB	0101000020E6100000A703594FAD3E03C084807C0915CC4940
77832	GL12 8JU	GB	0101000020E610000084D89942E79503C00821205F42CD4940
77833	GL12 8NB	GB	0101000020E610000058E20165532E03C01FF64201DBCB4940
77834	GL12 8NH	GB	0101000020E61000007FDDE9CE132F03C05DC30C8D27CC4940
77835	GL12 8RB	GB	0101000020E61000001EE21FB6F4E802C0B0045262D7D04940
77836	GL12 8RF	GB	0101000020E610000069723106D6F102C03524EEB1F4CF4940
77837	GL12 8RS	GB	0101000020E610000021956247E3F002C06CCD565EF2CF4940
77838	GL12 8TW	GB	0101000020E6100000363E93FDF33403C062A06B5F40CF4940
77839	GL13 9AW	GB	0101000020E6100000245F09A4C4AE03C0A5A0DB4B1AD94940
77840	GL13 9BA	GB	0101000020E6100000E65AB4006DAB03C08F554ACFF4D84940
77841	GL13 9BG	GB	0101000020E6100000D0251C7A8BA703C01D1EC2F869D84940
77842	GL13 9BQ	GB	0101000020E610000024F1F274AEA803C02174D0251CD84940
77843	GL13 9HE	GB	0101000020E61000002BDB87BCE56A03C076A4FACE2FDA4940
77844	GL14	GB	0101000020E6100000D3838252B4B203C0BE9F1A2FDDE84940
77845	GL14 1DU	GB	0101000020E6100000A4FD0FB056AD03C098DEFE5C34E64940
77846	GL14 1LE	GB	0101000020E61000003CF9F4D896A103C0AB2006BAF6E94940
77847	GL14 1PD	GB	0101000020E6100000CAC4AD82184803C032E884D041E94940
77848	GL14 2BH	GB	0101000020E6100000DAE731CA33EF03C00C59DDEA39E94940
77849	GL14 2DS	GB	0101000020E61000006649809A5AF603C0D34D621058E94940
77850	GL14 2QT	GB	0101000020E61000004277499C15F103C06806F1811DE94940
77851	GL14 3DG	GB	0101000020E6100000C7478B3386F903C0A181583673E84940
77852	GL15	GB	0101000020E610000064CDC820777104C06687F8872DE34940
77853	GL15 4DS	GB	0101000020E610000022AAF06778D303C087FBC8AD49E14940
77854	GL15 4EJ	GB	0101000020E61000009B728577B92804C0942F682101DB4940
77855	GL15 4ET	GB	0101000020E6100000B2F677B6474F04C0D461855B3EDE4940
77856	GL15 4JF	GB	0101000020E61000001C5F7B66498004C033FB3C4679E24940
77857	GL15 4JY	GB	0101000020E6100000753E3C4B907104C0469A780778E24940
77858	GL15 4TR	GB	0101000020E6100000462234828D4B04C03A1E335019E14940
77859	GL15 5EW	GB	0101000020E61000009B1F7F69513F04C0A81E69705BDB4940
77860	GL15 6DP	GB	0101000020E6100000B4226AA2CF8704C0CBD8D0CDFEDA4940
77861	GL15 6DS	GB	0101000020E61000009F909DB7B19904C02733DE567ADB4940
77862	GL15 6JY	GB	0101000020E6100000F54718062C9904C076C24B70EADF4940
77863	GL15 6PE	GB	0101000020E6100000DD3F16A243C004C0D3FA5B02F0D94940
77864	GL15 6RG	GB	0101000020E6100000C2A6CEA3E21F05C0E7C589AF76DE4940
77865	GL15 6RT	GB	0101000020E610000010B22C98F86305C00A3197546DDD4940
77866	GL16 7AH	GB	0101000020E61000002497FF907E7B04C02BA4FCA4DAE54940
77867	GL16 7EQ	GB	0101000020E6100000560E2DB29D8F04C09DBD33DAAAE64940
77868	GL16 7JR	GB	0101000020E6100000731074B4AAC504C02F4D11E0F4E44940
77869	GL16 7LJ	GB	0101000020E6100000E0B9F770C9D104C04D124BCADDE34940
77870	GL16 7LT	GB	0101000020E610000007280D350AC904C02D05A4FD0FE44940
77871	GL16 8AA	GB	0101000020E61000003A3B191C25EF04C077483140A2E54940
77872	GL16 8NQ	GB	0101000020E6100000FE9AAC510F3105C00742B28009E44940
77873	GL16 8QR	GB	0101000020E610000007CE1951DAFB04C0261AA4E029E64940
77874	GL16 8QT	GB	0101000020E61000004227840EBA0405C0E7DF2EFB75E54940
77875	GL17	GB	0101000020E610000047AB5AD2510E04C0310A82C7B7EF4940
77876	GL17 0DD	GB	0101000020E6100000B343FCC396DE03C0744012F6EDEE4940
77877	GL17 0EE	GB	0101000020E61000008655BC9179E403C0B2BCAB1E30ED4940
77878	GL17 0HY	GB	0101000020E61000000FED6305BFED03C04583143C85EE4940
77879	GL17 0JW	GB	0101000020E6100000FD2FD7A2050804C0E6400FB56DF04940
77880	GL17 0NL	GB	0101000020E610000007B47405DB6803C05130630AD6F04940
77881	GL17 0QE	GB	0101000020E61000004F5DF92CCFA303C074EFE192E3EE4940
77882	GL17 0RD	GB	0101000020E61000001F12BEF7378803C0C878944A78F04940
77883	GL17 9DE	GB	0101000020E61000004700378B172B04C09A249694BBEB4940
77884	GL17 9LN	GB	0101000020E6100000DCF29194F49004C0AF0AD462F0EA4940
77885	GL17 9PD	GB	0101000020E610000059A7CAF78CC404C0486E4DBA2DED4940
77886	GL17 9PS	GB	0101000020E6100000A5DDE8633EA004C0BD70E7C248EB4940
77887	GL17 9ST	GB	0101000020E6100000CC2555DB4D9004C022A7AFE76BEC4940
77888	GL17 9SX	GB	0101000020E610000080457EFD109B04C0462234828DEB4940
77889	GL17 9XA	GB	0101000020E61000009DBCC804FC5A04C0F06C8FDE70ED4940
77890	GL17 9YL	GB	0101000020E6100000E7357689EA4D04C01381EA1F44EC4940
77891	GL18 1DJ	GB	0101000020E61000009DF6949C135B03C04EB7EC10FFF84940
77892	GL18 1PW	GB	0101000020E61000002FA2ED98BA4B03C0889FFF1EBCF64940
77893	GL18 1QD	GB	0101000020E6100000185C7347FF4B03C0B493C151F2F64940
77894	GL18 2AD	GB	0101000020E6100000EBE0606F626803C0F17F4754A8FC4940
77895	GL19 3AF	GB	0101000020E610000072C0AE264FD902C05CC823B891F24940
77896	GL19 3DD	GB	0101000020E61000007973B8567B9802C036CCD07822F64940
77897	GL19 3ND	GB	0101000020E6100000F4FC69A33ABD02C0F7949C137BFC4940
77898	GL19 3RG	GB	0101000020E6100000E8A1B60DA36002C0A911FA997AF74940
77899	GL19 4BB	GB	0101000020E6100000645930F1475101C024B726DD96F84940
77900	GL19 4EB	GB	0101000020E6100000C9E7154F3D9201C074999A046FFA4940
77901	GL19 4EU	GB	0101000020E6100000EFFFE38409E301C0486B0C3A21FA4940
77902	GL19 4HJ	GB	0101000020E6100000BCAE5FB01BD601C08A3F8A3A73F94940
77903	GL19 4JW	GB	0101000020E6100000FB90B75CFD3802C0F0164850FCF84940
77904	GL19 4RE	GB	0101000020E6100000BC95253ACB6C01C0D7A02FBDFDFD4940
77905	GL2	GB	0101000020E6100000A8531EDD082B03C04E0D349F73E54940
77906	GL2 0DA	GB	0101000020E6100000F451465C00BA01C026C808A870F04940
77907	GL2 0SA	GB	0101000020E61000002A58E36C3AC201C0696E85B01AEF4940
77908	GL2 3NJ	GB	0101000020E6100000ABB184B5313602C0CEFFAB8E1CEB4940
77909	GL2 3NS	GB	0101000020E61000001A6B7F677B7402C0605628D2FDEA4940
77910	GL2 4JH	GB	0101000020E61000003946B247A85902C04260E5D022E94940
77911	GL2 4YF	GB	0101000020E61000004F2157EA595002C0DAE21A9FC9E84940
77912	GL2 5DL	GB	0101000020E6100000448655BC911902C0AC58FCA6B0EC4940
77913	GL2 7BT	GB	0101000020E6100000EC866D8B323B03C048A30227DBDE4940
77914	GL2 7BU	GB	0101000020E6100000B8CB7EDDE9EE02C07B681F2BF8DD4940
77915	GL2 7DN	GB	0101000020E61000004A5E9D63403602C0FB3A70CE88F04940
77916	GL2 7NP	GB	0101000020E6100000F56393FC889F02C0516A2FA2EDE24940
77917	GL2 8AS	GB	0101000020E61000006327BC04A7DE02C0FD135CACA8EF4940
77918	GL2 8DB	GB	0101000020E6100000AAD381ACA73602C0A8A8FA95CEEF4940
77919	GL2 8DL	GB	0101000020E6100000944A7842AF5F02C013D731AEB8F04940
77920	GL2 8DW	GB	0101000020E61000004014CC98827502C0C24EB16A10F04940
77921	GL2 8JF	GB	0101000020E6100000BA30D28BDA9D02C02DCE18E604ED4940
77922	GL2 9ES	GB	0101000020E61000006EA7AD11C1D801C0AF78EA9106F14940
77923	GL2 9LR	GB	0101000020E61000006D59BE2EC3FF01C0F1B913ECBFF84940
77924	GL2 9PG	GB	0101000020E610000024D40CA9A2D801C01FF46C567DF24940
77925	GL20	GB	0101000020E610000065E08096AE4001C0043DD4B661FE4940
77926	GL20 5AB	GB	0101000020E61000000C3D62F4DC4201C0BAA1293BFDFE4940
77927	GL20 5BX	GB	0101000020E6100000116DC7D45D3901C0821FD5B0DFFF4940
77928	GL20 5DL	GB	0101000020E610000073B9C150873501C0FACF9A1F7FFF4940
77929	GL20 5EU	GB	0101000020E61000006F6589CE322B01C0390A100533FE4940
77930	GL20 5FF	GB	0101000020E6100000DE205A2BDA3C01C07940D9942BFE4940
77931	GL20 5RE	GB	0101000020E61000008CA03193A83701C0CB80B3942CFF4940
77932	GL20 6AT	GB	0101000020E6100000E2E82ADD5DE701C02AE109BDFE024A40
77933	GL20 6BB	GB	0101000020E6100000419FC893A4EB01C0BDE0D39CBC024A40
77934	GL20 6DG	GB	0101000020E6100000A20C5531951E01C07D9752978C034A40
77935	GL20 6EF	GB	0101000020E6100000ECBE6378EC4701C011548D5E0D044A40
77936	GL20 6EL	GB	0101000020E610000025AE635C715101C0750470B378034A40
77937	GL20 6EU	GB	0101000020E61000003ACC9717607F01C03D9E961FB8044A40
77938	GL20 7AW	GB	0101000020E6100000960A2AAA7E4500C031444E5FCF014A40
77939	GL20 7BU	GB	0101000020E6100000E31934F44F1001C076E3DD91B1FA4940
77940	GL20 7DA	GB	0101000020E6100000384D9F1D703D01C0C0046EDDCDFB4940
77941	GL20 7LA	GB	0101000020E6100000FE7BF0DAA5ED00C01AF8510DFB034A40
77942	GL20 7LW	GB	0101000020E6100000790778D2C2E500C01348895DDB034A40
77943	GL20 7NQ	GB	0101000020E61000004C512E8D5FD800C0CDCAF6216F034A40
77944	GL20 7PP	GB	0101000020E6100000605B3FFD676D00C09946938B31044A40
77945	GL20 7QP	GB	0101000020E6100000B89388F02FE200C012BC218D0A044A40
77946	GL20 8	GB	0101000020E610000043E6CAA0DA0001C06F83DA6FED004A40
77947	GL20 8AE	GB	0101000020E6100000003ACC97172001C078978BF84E004A40
77948	GL20 8AF	GB	0101000020E610000004392861A62D01C0158DB5BFB3014A40
77949	GL20 8DY	GB	0101000020E61000001762F547180601C0D5EDEC2B0FFE4940
77950	GL20 8HG	GB	0101000020E6100000E7525C55F6DD00C0006F8104C5FF4940
77951	GL20 8JE	GB	0101000020E61000004510E7E1042601C04E4700378BFF4940
77952	GL20 8LH	GB	0101000020E610000090BB085394CB00C0F12BD67091FF4940
77953	GL20 8LP	GB	0101000020E6100000028063CF9EAB00C06F7F2E1A32004A40
77954	GL20 8NN	GB	0101000020E61000009EF0129CFA0000C0EDF318E599FF4940
77955	GL20 8RE	GB	0101000020E6100000EC67B114C9F700C080EECB99ED004A40
77956	GL20 8TB	GB	0101000020E610000043C9E4D4CEF000C0B1DEA815A6FF4940
77957	GL29 9LR	GB	0101000020E61000001DACFF7398CF02C02DB5DE6FB40B4A40
77958	GL3 1	GB	0101000020E6100000CE6C57E8838501C0917F66101FF24940
77959	GL3 1DL	GB	0101000020E6100000B87361A417B501C01553E9279CF14940
77960	GL3 1DR	GB	0101000020E6100000DE7536E49FB901C0D099B4A9BAF14940
77961	GL3 1EE	GB	0101000020E6100000336ABE4A3EB601C054E23AC615F14940
77962	GL3 1EZ	GB	0101000020E610000022FDF675E09C01C0753BFBCA83F24940
77963	GL3 1HA	GB	0101000020E61000005A2F8672A27D01C01B9B1DA9BEF14940
77964	GL3 1NT	GB	0101000020E6100000621399B9C08501C05EDA70581AF24940
77965	GL3 2AH	GB	0101000020E61000003FC91D36917901C0C70DBF9B6EF14940
77966	GL3 2LT	GB	0101000020E6100000D2E28C614E7001C0793A579412EE4940
77967	GL3 2PF	GB	0101000020E6100000AA9D616A4B3D01C011E4A08499F04940
77968	GL3 3	GB	0101000020E61000001092054CE07601C09143C4CDA9EC4940
77969	GL3 3AZ	GB	0101000020E61000006C06B8205B7601C0A1DB4B1AA3EF4940
77970	GL3 3PZ	GB	0101000020E6100000664CC11A677301C001C0B167CFF14940
77971	GL3 3QS	GB	0101000020E610000013EF004F5A7801C0AA285E656DED4940
77972	GL3 3QX	GB	0101000020E6100000908653E6E67B01C0A759A0DD21ED4940
77973	GL3 3RP	GB	0101000020E61000000E2C47C8407E01C0494C50C3B7EC4940
77974	GL3 3SW	GB	0101000020E6100000B5FD2B2B4D6A01C0A6F10BAF24ED4940
77975	GL3 4AB	GB	0101000020E61000008A75AA7CCF6801C0FBCDC47421EC4940
77976	GL3 4EQ	GB	0101000020E6100000E0DBF4673F5201C0F17F4754A8EC4940
77977	GL3 4HE	GB	0101000020E61000003B1BF2CF0C4201C0BD6DA6423CEC4940
77978	GL3 4UG	GB	0101000020E610000056F487669EFC00C0A7B228ECA2EC4940
77979	GL4	GB	0101000020E61000005A9C31CC09BA01C0A2410A9E42EC4940
77980	GL4 0BU	GB	0101000020E610000047904AB1A3F101C0EFAA07CC43EA4940
77981	GL4 0BX	GB	0101000020E6100000F2ED5D83BEF401C0E1B721C66BEA4940
77982	GL4 0DQ	GB	0101000020E61000006283859334FF01C0200BD12170EA4940
77983	GL4 0XS	GB	0101000020E61000008A5759DB142F02C0B37BF2B050EB4940
77984	GL4 3EZ	GB	0101000020E610000032C687D9CB9601C055F833BC59ED4940
77985	GL4 3LE	GB	0101000020E61000008D4127840E9A01C051BEA08504EE4940
77986	GL4 3RR	GB	0101000020E61000008335CEA623A001C085285FD042EE4940
77987	GL4 5DP	GB	0101000020E61000002BDD5D67439E01C0492D944C4EEB4940
77988	GL4 5JE	GB	0101000020E610000001310917F28801C0CA1AF5108DEC4940
77989	GL4 6SL	GB	0101000020E61000008201840F25DA01C0FFEC478AC8EA4940
77990	GL4 6SX	GB	0101000020E6100000558847E2E5E901C0B3EF8AE07FEB4940
77991	GL4 8AY	GB	0101000020E6100000D99596917A8F01C0ED647094BCEA4940
77992	GL4 8EZ	GB	0101000020E61000006B662D05A45D01C0B83B6BB75DE84940
77993	GL4 8HX	GB	0101000020E61000001C98DC28B25601C01898158A74E74940
77994	GL4 8LA	GB	0101000020E61000000E4B033FAAA100C02E76FBAC32E94940
77995	GL5	GB	0101000020E6100000C652245F092402C0B4024356B7EC4940
77996	GL5 1BG	GB	0101000020E61000002330D63730B901C0E9D2BF2495DF4940
77997	GL5 1JD	GB	0101000020E61000002A91442FA39801C093C7D3F203DF4940
77998	GL5 1PP	GB	0101000020E61000005D35CF11F9AE01C040DAFF006BDF4940
77999	GL5 1SY	GB	0101000020E610000089D2DEE00BB301C0C05B2041F1DF4940
78000	GL5 1TE	GB	0101000020E61000007BD976DA1AD101C0E15E99B7EADE4940
78001	GL5 2JL	GB	0101000020E610000019390B7BDAA101C01FF46C567DDE4940
78002	GL5 2JZ	GB	0101000020E6100000F3E505D847A701C0B29C84D217DE4940
78003	GL5 2PS	GB	0101000020E6100000BE310400C79E01C0855FEAE74DDB4940
78004	GL5 2QG	GB	0101000020E6100000CDE7DCED7A8901C0E19524CFF5DB4940
78005	GL5 2RR	GB	0101000020E6100000D2E0B6B6F07C01C0931ADA006CDC4940
78006	GL5 2TH	GB	0101000020E6100000B401D880087101C0FD135CACA8DB4940
78007	GL5 3AP	GB	0101000020E61000000EF96706F1C101C00B2593533BDF4940
78008	GL5 3EB	GB	0101000020E6100000C84274081CC901C01348895DDBDF4940
78009	GL5 3LS	GB	0101000020E6100000EC33677DCAD101C01C5E10919ADE4940
78010	GL5 3QF	GB	0101000020E610000033198EE733E001C09BAF928FDDDD4940
78011	GL5 3TZ	GB	0101000020E6100000ECA694D74AC801C00951BEA085DE4940
78012	GL5 4AL	GB	0101000020E6100000170CAEB9A3DF01C069FE98D6A6DF4940
78013	GL5 4BJ	GB	0101000020E6100000E3C5C21039BD01C041B62C5F97DF4940
78014	GL5 4JE	GB	0101000020E6100000F04DD36707DC01C0A73FFB9122DC4940
78015	GL5 4JG	GB	0101000020E6100000DB368C82E0F101C035B8AD2D3CDF4940
78016	GL5 4JW	GB	0101000020E610000071E481C822ED01C0A96917D34CDF4940
78017	GL5 4NX	GB	0101000020E61000009757AEB7CDF401C0DC80CF0F23E04940
78018	GL5 5AN	GB	0101000020E61000005C001AA54BBF01C07CEE04FBAFDB4940
78019	GL5 5AW	GB	0101000020E61000006F2A52616CC101C0758F6CAE9ADB4940
78020	GL5 5DG	GB	0101000020E6100000B51A12F758BA01C07F1475E61EDC4940
78021	GL50	GB	0101000020E61000004E0E9F7422C100C0467BBC900EF34940
78022	GL50 1AA	GB	0101000020E61000002096CD1C929A00C06C5A290472F34940
78023	GL50 1HX	GB	0101000020E610000065C405A0519A00C0E292E34EE9F24940
78024	GL50 2AQ	GB	0101000020E61000003E0455A357A300C0BE2D58AA0BF24940
78025	GL50 2JN	GB	0101000020E61000000533A6608DB300C096E99788B7F24940
78026	GL50 2JP	GB	0101000020E6100000232F6B6281AF00C0CDCCCCCCCCF24940
78027	GL50 2JX	GB	0101000020E6100000AB984A3FE1AC00C0723788D68AF24940
78028	GL50 2LF	GB	0101000020E61000003A083A5AD5B200C09AB33EE598F24940
78029	GL50 2LR	GB	0101000020E61000006C94F59B89A900C0E3FC4D2844F24940
78030	GL50 2NG	GB	0101000020E6100000D53C47E4BBB400C004ABEAE577F24940
78031	GL50 2PT	GB	0101000020E6100000C5C6BC8E38C400C04AEEB089CCF24940
78032	GL50 2QJ	GB	0101000020E6100000DF6DDE3829AC00C0425C397B67F24940
78033	GL50 2QL	GB	0101000020E610000069554B3ACAC100C07B4D0F0A4AF14940
78034	GL50 3HJ	GB	0101000020E6100000AF42CA4FAA9D00C0691CEA7761F34940
78035	GL50 3HU	GB	0101000020E6100000C2853C821BA900C08236397CD2F34940
78036	GL50 3PS	GB	0101000020E6100000DDD26A48DCA300C0F81C588E90F34940
78037	GL50 4JW	GB	0101000020E610000028B9C326329300C0D252793BC2F34940
78038	GL50 4PB	GB	0101000020E61000005038BBB54CA600C0B8955E9B8DF54940
78039	GL50 4PF	GB	0101000020E61000000A2C802903A700C01EA67D737FF54940
78040	GL50 4QD	GB	0101000020E61000007D09151C5E9000C07DCD72D9E8F44940
78041	GL50 4RL	GB	0101000020E6100000F8A92A3410AB00C0E719FB928DF54940
78042	GL50 4RP	GB	0101000020E6100000799109F835B200C0DDD3D51D8BF54940
78043	GL50 4RS	GB	0101000020E6100000CC2555DB4DB000C047054EB681F54940
78044	GL50 4SH	GB	0101000020E610000027840EBA848300C0ACCABE2B82F54940
78045	GL50 5HJ	GB	0101000020E6100000F6EFFACC599F00C08505F7031EF44940
78046	GL50 8NR	GB	0101000020E6100000DB4FC6F830BB00C0DFFB1BB457F34940
78047	GL51	GB	0101000020E6100000EAE8B81AD9D500C05D35CF11F9F24940
78048	GL51 0BE	GB	0101000020E6100000E700C11C3DDE00C0F20BAF2479F44940
78049	GL51 0EP	GB	0101000020E61000005A9D9CA1B8E300C0B056ED9A90F44940
78050	GL51 0GG	GB	0101000020E610000097E2AAB2EF6A00C040506EDBF7F24940
78051	GL51 0JN	GB	0101000020E6100000BB9C121093F000C0D520CCED5EF44940
78052	GL51 0NR	GB	0101000020E6100000711E4E603AED00C07E8FFAEB15F44940
78053	GL51 0SS	GB	0101000020E610000070EEAF1EF72D01C0B2F677B647F34940
78054	GL51 3DW	GB	0101000020E61000009A7B48F8DEBF00C0570A815CE2F04940
78055	GL51 3RB	GB	0101000020E61000004AB8904770C300C0ED815660C8F04940
78056	GL51 3RN	GB	0101000020E610000076525F9676EA00C0850A0E2F88F04940
78057	GL51 6BP	GB	0101000020E6100000F5F3A622152601C035B39602D2F24940
78058	GL51 6EA	GB	0101000020E61000008F1D54E23AE600C0990D32C9C8F14940
78059	GL51 6EP	GB	0101000020E610000040DB6AD619DF00C0CF9ECBD424F24940
78060	GL51 6FY	GB	0101000020E6100000CE177B2FBE0801C094F947DFA4F14940
78061	GL51 6HE	GB	0101000020E6100000878A71FE26D400C011AB3FC230F24940
78062	GL51 6JJ	GB	0101000020E61000007DAEB6627FF900C085B69C4B71F14940
78063	GL51 6LJ	GB	0101000020E6100000A2D5C9198ADB00C0CF2F4AD05FF24940
78064	GL51 6PN	GB	0101000020E6100000492C29779F4301C054E23AC615F34940
78065	GL51 6RY	GB	0101000020E61000005A9BC6F65A1001C056D4601A86F14940
78066	GL51 6UD	GB	0101000020E61000001AC1C6F5EFFA00C0791EDC9DB5F14940
78067	GL51 7DF	GB	0101000020E61000002A1BD65416E500C02EE57CB1F7F24940
78068	GL51 8AL	GB	0101000020E610000089247A19C5D200C0EE04FBAF73F34940
78069	GL51 8HJ	GB	0101000020E610000084BC1E4C8AAF00C044A2D0B2EEF34940
78070	GL51 8JX	GB	0101000020E6100000ECC1A4F8F8C400C05B79C9FFE4F34940
78071	GL51 8NP	GB	0101000020E61000003677F4BF5CCB00C0A9D903ADC0F24940
78072	GL51 9BN	GB	0101000020E6100000CFC0C8CB9AB800C0C4E9245B5DF44940
78073	GL51 9HH	GB	0101000020E6100000E2CAD93BA3AD00C0DE91B1DAFCF34940
78074	GL51 9RJ	GB	0101000020E6100000BC0512143FC600C010B1C1C249F64940
78075	GL52	GB	0101000020E610000036035C902D8B00C04225AE635CF54940
78076	GL52 2JN	GB	0101000020E61000008B6D52D1585B00C0BF6378EC67F34940
78077	GL52 2PZ	GB	0101000020E61000004983DBDAC27300C05514AFB2B6F34940
78078	GL52 2RX	GB	0101000020E6100000BABE0F07099100C04F594DD713F34940
78079	GL52 3BL	GB	0101000020E610000012D89C83676200C0CC457C2766F54940
78080	GL52 3LW	GB	0101000020E610000078D15790666C00C0D42B6519E2F44940
78081	GL52 5AB	GB	0101000020E610000055C2137AFD6900C0D2C8E7154FF34940
78082	GL52 5DB	GB	0101000020E610000011C47938814900C0A0353FFED2F44940
78083	GL52 5JU	GB	0101000020E6100000F91400E3195400C0BA85AE44A0F44940
78084	GL52 5LP	GB	0101000020E6100000F7AE415F7A5B00C0C2887D0228F44940
78085	GL52 6AR	GB	0101000020E6100000CB129D65168100C0236AA2CF47F34940
78086	GL52 6LT	GB	0101000020E61000004A95287B4B5900C0A7E9B303AEF14940
78087	GL52 6RD	GB	0101000020E610000012876C205D6C00C0D9226937FAF24940
78088	GL52 6RQ	GB	0101000020E61000003D1059A4897700C0E945ED7E15F24940
78089	GL52 8JE	GB	0101000020E6100000A92F4B3B357700C0151A886533F94940
78090	GL52 8NQ	GB	0101000020E6100000DFDDCA129D4503C0944DB9C2BBF04940
78091	GL52 8PH	GB	0101000020E61000000DE02D90A07800C0874ECFBBB1F84940
78092	GL52 8RA	GB	0101000020E61000000DC68844A18500C06FF4311F10F44940
78093	GL52 8XB	GB	0101000020E610000097FDBAD39DC700C044DD0720B5ED4940
78094	GL52 9HZ	GB	0101000020E61000006F641EF9836100C05BD3BCE314F94940
78095	GL52 9QF	GB	0101000020E610000028999CDA194600C074EFE192E3F84940
78096	GL52 9RG	GB	0101000020E61000000C3CF71E2E7900C084D72E6D38FC4940
78097	GL53	GB	0101000020E61000002541B8020A9500C06342CC2555F14940
78098	GL53 0BJ	GB	0101000020E6100000C860C5A9D6A200C0DD7D8E8F16F14940
78099	GL53 0JD	GB	0101000020E61000007C4276DEC6A600C001A4367172F14940
78100	GL53 0JY	GB	0101000020E61000000CCA349A5CAC00C09BABE63922F14940
78101	GL53 0LA	GB	0101000020E6100000C843DFDDCAB200C0C36169E047F14940
78102	GL53 0PJ	GB	0101000020E61000003DB5FAEAAAA000C098874CF910F04940
78103	GL53 0PR	GB	0101000020E6100000A180ED60C49E00C0C7629B5434F04940
78104	GL53 0QB	GB	0101000020E6100000DC2A8881AEBD00C0EAAF575870EF4940
78105	GL53 7AN	GB	0101000020E6100000FC00A436719200C066BE839F38F24940
78106	GL53 7JJ	GB	0101000020E6100000BAA3FFE55A9400C0F415A4198BF24940
78107	GL53 7PJ	GB	0101000020E6100000AEB6627FD99D00C07217618A72F14940
78108	GL53 8AN	GB	0101000020E6100000B1F9B836546C00C012DC48D922F14940
78109	GL53 8DL	GB	0101000020E610000059501894697400C04D4A41B797F04940
78110	GL53 8LQ	GB	0101000020E61000009485AFAF756900C0299831056BF04940
78111	GL53 8LZ	GB	0101000020E610000065AA6054526700C025EB707495F04940
78112	GL53 8QL	GB	0101000020E61000000CCEE0EF175300C0F4311F10E8F04940
78113	GL53 9HU	GB	0101000020E61000004C50C3B7B06E00C0C6A354C213F04940
78114	GL53 9NJ	GB	0101000020E61000004A5F0839EF7F00C0FFCA4A9352EA4940
78115	GL54	GB	0101000020E6100000DCF29194F4B0FCBF1118EB1B98F04940
78116	GL54 1LZ	GB	0101000020E6100000E223624A2411FCBF38F8C264AAF64940
78117	GL54 2AP	GB	0101000020E6100000E4F90CA83723FCBF6155BDFC4EF14940
78118	GL54 2HD	GB	0101000020E61000005051F52B9D0FFCBFC7293A92CBF14940
78119	GL54 2HH	GB	0101000020E61000009813B4C9E113FCBF1BF2CF0CE2F14940
78120	GL54 2LN	GB	0101000020E610000045F295404A6CFBBFA912656F29ED4940
78121	GL54 2NB	GB	0101000020E610000082380F27309DFBBFB9DE365321F04940
78122	GL54 3EU	GB	0101000020E6100000AB59677C5F5CFDBFA72215C616EA4940
78123	GL54 3HG	GB	0101000020E61000006F2BBD361B6BFDBFB5A679C729EA4940
78124	GL54 3LJ	GB	0101000020E6100000C93B873254C5FEBF6FF1F09E03E94940
78125	GL54 3PF	GB	0101000020E61000009F8F32E20250FDBF2F8A1EF818EA4940
78126	GL54 4NQ	GB	0101000020E6100000B00111E2CA99FEBF1B9B1DA9BEE54940
78127	GL54 5AL	GB	0101000020E6100000F7578FFB566BFFBF2CD8463CD9F74940
78128	GL54 5AQ	GB	0101000020E6100000CC43A67C080A00C02E3883BF5FF84940
78129	GL54 5BJ	GB	0101000020E61000000723F609A058FFBFA06B5F402FFC4940
78130	GL54 5DT	GB	0101000020E6100000A4E36A6457DAFEBF0ABFD4CF9BFE4940
78131	GL54 5HD	GB	0101000020E6100000569929ADBF0500C0F0879FFF1EFC4940
78132	GL54 5HY	GB	0101000020E61000007FF8F9EFC16BFFBFE4F6CB272BFA4940
78133	GL54 5JD	GB	0101000020E610000041B8020AF534FFBFBD5301F73CF94940
78134	GL54 5LJ	GB	0101000020E610000064E8D841256EFFBF4EEE77280AFA4940
78135	GL54 5LX	GB	0101000020E6100000BCAFCA85CA7FFFBF59C0046EDDF94940
78136	GL54 5NQ	GB	0101000020E6100000AC8F87BEBB95FFBF6CEC12D55BF94940
78137	GL54 5PB	GB	0101000020E6100000B939950C00D5FEBF766B990CC7FB4940
78138	GL54 5PW	GB	0101000020E6100000191D90847D7BFFBF7D03931B45FA4940
78139	GL54 5RX	GB	0101000020E6100000CC99ED0A7DF0FDBF89EB18575CFC4940
78140	GL54 5SJ	GB	0101000020E6100000526342CC2555FFBF92B1DAFCBFF04940
78141	GL54 5SW	GB	0101000020E61000003621AD31E844FFBF8D63247B84F24940
78142	GL54 5TH	GB	0101000020E610000013BA4BE2AC48FFBF67B96C74CEF34940
78143	GL54 5TU	GB	0101000020E6100000EAD0E97937D6FDBFF9156BB8C8F74940
78144	GL54 5XL	GB	0101000020E610000075AC527AA617FFBFD2FD9C82FCF24940
78145	GL54 5YL	GB	0101000020E61000001AE0826C597EFFBF17105A0F5FFA4940
78146	GL55	GB	0101000020E6100000F46C567DAEF6FBBF73F6CE68AB0A4A40
78147	GL55 6DZ	GB	0101000020E61000002711E15F048DFCBFFA5E43705C064A40
78148	GL55 6JN	GB	0101000020E6100000234A7B832FCCFDBFEA3F6B7EFCF74940
78149	GL55 6QH	GB	0101000020E61000003C9F01F56614FDBFDC9BDF30D1084A40
78150	GL56	GB	0101000020E61000007D93A641D13CFBBFCEFA9463B2FE4940
78151	GL56 0AA	GB	0101000020E6100000D6027B4CA434FBBF4FEB36A8FDFE4940
78152	GL56 0EF	GB	0101000020E61000002C2E8ECA4D54FBBF46EC134031FE4940
78153	GL56 0LH	GB	0101000020E61000004450357A3540FBBF1059A48977FE4940
78154	GL56 0QZ	GB	0101000020E61000005436ACA92C0AFCBFD828EB3713FB4940
78155	GL56 9AH	GB	0101000020E61000000B0BEE073CF0FBBF9FC728CFBCFE4940
78156	GL56 9NP	GB	0101000020E6100000E36E10AD15EDFABF3B18B14F00014A40
78157	GL5O	GB	0101000020E610000052616C21C84100C090DC9A745BF64940
78158	GL6	GB	0101000020E6100000481B47ACC5E700C0CFDC43C2F7DC4940
78159	GL6 0RD	GB	0101000020E6100000C2BD326FD5D501C081053065E0D84940
78160	GL6 0RH	GB	0101000020E6100000C22FF5F3A6E201C04F594DD713D94940
78161	GL6 6BW	GB	0101000020E6100000BE6BD097DEDE01C029EB3713D3E14940
78162	GL6 6DG	GB	0101000020E6100000A31F0DA7CCED01C06552431B80E14940
78163	GL6 6EU	GB	0101000020E61000004DBC033C690102C07061DD7877E04940
78164	GL6 6HQ	GB	0101000020E6100000CE8E54DFF90502C0E8F7FD9B17E14940
78165	GL6 6LJ	GB	0101000020E6100000E4BF401020C301C07DE6AC4F39E24940
78166	GL6 6ND	GB	0101000020E61000008C12F4177AC401C03A950C0055E44940
78167	GL6 6QN	GB	0101000020E61000009FAA4203B18C01C00C03965CC5E44940
78168	GL6 6RU	GB	0101000020E61000000420EEEA558401C034643C4A25E44940
78169	GL6 7BB	GB	0101000020E6100000DA56B3CEF81E01C0350C1F1153E04940
78170	GL6 7BL	GB	0101000020E6100000812040868E1D01C0CE52B29C84E04940
78171	GL6 7JS	GB	0101000020E610000048FAB48AFE9001C059350873BBE14940
78172	GL6 7LH	GB	0101000020E61000008524B37A877B01C0F67EA31D37E04940
78173	GL6 7NL	GB	0101000020E610000087890629780A01C09886E12362DE4940
78174	GL6 7RL	GB	0101000020E61000004B57B08D783201C0D9B27C5D86E54940
78175	GL6 8AZ	GB	0101000020E610000073BD6DA6425C01C0CEA78E554ADD4940
78176	GL6 8LZ	GB	0101000020E610000089D4B48B692601C0E46723D74DDD4940
78177	GL6 9AR	GB	0101000020E6100000143DF031589101C020D5B0DF13D94940
78178	GL6 9AS	GB	0101000020E61000006556EF703B7401C0C53C2B69C5D94940
78179	GL6 9DJ	GB	0101000020E61000008D5F7825C99301C02D228AC91BDA4940
78180	GL6 9EN	GB	0101000020E6100000573F36C98F7801C0691EC022BFDA4940
78181	GL6 9LJ	GB	0101000020E6100000E59B6D6E4C6F01C0EF6FD05E7DDA4940
78182	GL7	GB	0101000020E6100000AFB14B546F0DFFBFF59CF4BEF1D54940
78183	GL7 1DE	GB	0101000020E6100000E4BB94BA641CFFBF2FC1A90F24DB4940
78184	GL7 1DJ	GB	0101000020E6100000263ACB2C4231FFBF65DEAAEB50DB4940
78185	GL7 1EF	GB	0101000020E61000001F680586AC6EFFBFF77475C762DB4940
78186	GL7 1FL	GB	0101000020E610000051A39064562FFFBF53094FE8F5DB4940
78187	GL7 1HW	GB	0101000020E6100000A5BC56427789FFBFA6D24F38BBDB4940
78188	GL7 1LA	GB	0101000020E610000002D880087165FFBFBAF94674CFDA4940
78189	GL7 1NP	GB	0101000020E6100000207C28D19247FFBF1D75745C8DDA4940
78190	GL7 1SD	GB	0101000020E6100000BF654E97C5C4FFBF1D03B2D7BBD94940
78191	GL7 1TN	GB	0101000020E61000004B06802A6E5CFFBF836DC493DDDA4940
78192	GL7 2DH	GB	0101000020E6100000A4C343183F8DFFBFCA6C904946DC4940
78193	GL7 2EL	GB	0101000020E6100000834E081D7489FFBFCA89761552DC4940
78194	GL7 2HF	GB	0101000020E6100000E84F1BD5E980FFBF93E00D6954DC4940
78195	GL7 2PP	GB	0101000020E61000005358A9A0A26AFFBFA3772AE09EDB4940
78196	GL7 3AE	GB	0101000020E610000015527E52ED13FBBF3CDEE4B7E8D84940
78197	GL7 3AY	GB	0101000020E6100000EE224C512E0DFBBF5111A7936CD94940
78198	GL7 3BJ	GB	0101000020E61000009FC728CFBC1CFBBF6AA67B9DD4D94940
78199	GL7 3BQ	GB	0101000020E61000000E9F7422C114FBBF2CF015DD7AD94940
78200	GL7 3JG	GB	0101000020E6100000185C7347FF8BFABFF3CB608C48DE4940
78201	GL7 5BN	GB	0101000020E6100000BB7B80EECB99FCBFF91400E319DE4940
78202	GL7 5LP	GB	0101000020E610000004029D499B2AFDBF4BC8073D9BD94940
78203	GL7 5NX	GB	0101000020E61000003FFF3D78ED92FDBF30F1475167E24940
78204	GL7 5RR	GB	0101000020E61000000EDC813AE591FEBF47AE9B525EDB4940
78205	GL7 5TJ	GB	0101000020E61000004AD1CABDC0ACFEBF5308E41247D64940
78206	GL7 6AW	GB	0101000020E61000008A9125732C2F00C041B96DDFA3D64940
78207	GL7 6HP	GB	0101000020E610000088B839950C40FFBFEFA99CF694D84940
78208	GL7 7AQ	GB	0101000020E6100000D20149D8B71300C0E48409A359DF4940
78209	GL7 7DA	GB	0101000020E61000008CF4A276BF8AFFBFAAF06778B3E24940
78210	GL7 7DJ	GB	0101000020E610000054539275387AFFBF82A8FB00A4DE4940
78211	GL7 7EP	GB	0101000020E61000005B069CA564F9FFBFF7730AF2B3E54940
78212	GL75	GB	0101000020E6100000A1F2AFE5956BFCBF59DFC0E446DF4940
78213	GL8 8AA	GB	0101000020E61000005B0BB3D0CE4901C04D9EB29AAED14940
78214	GL8 8DG	GB	0101000020E6100000FA6184F0684301C0F984ECBC8DD14940
78215	GL9 1AU	GB	0101000020E61000001AFA27B8589102C08CBB41B456CA4940
78216	GU1	GB	0101000020E6100000A41AF67B621DE2BF93C7D3F2039F4940
78217	GU1 1EA	GB	0101000020E6100000AA4544317983E2BFF94A2025769F4940
78218	GU1 1EP	GB	0101000020E61000000727A25F5B3FE2BF63D4B5F63E9F4940
78219	GU1 1EY	GB	0101000020E6100000EA060ABC934FE2BF7DE882FA969F4940
78220	GU1 1HD	GB	0101000020E610000058923CD7F761E2BF47567E198C9F4940
78221	GU1 1HN	GB	0101000020E6100000BD564277499CE2BF9D67EC4B36A04940
78222	GU1 1JH	GB	0101000020E61000007F33315D8855E2BFBDC458A65FA04940
78223	GU1 1PP	GB	0101000020E61000005FB35C363A67E2BFF29881CAF89F4940
78224	GU1 1QG	GB	0101000020E6100000E8BD31040047E2BF5C3B511212A14940
78225	GU1 1QT	GB	0101000020E6100000A5677A89B14CE2BFE21DE0490BA14940
78226	GU1 1QZ	GB	0101000020E610000056D636C5E3A2E2BF4EECA17DACA04940
78227	GU1 1SX	GB	0101000020E61000006C95607138F3E1BFB82231410D9F4940
78228	GU1 1UF	GB	0101000020E6100000E6B0FB8EE1B1E1BF91459A7807A04940
78229	GU1 2AW	GB	0101000020E6100000B5C6A0134207E2BF7B4FE5B4A79E4940
78230	GU1 2BQ	GB	0101000020E6100000B2DAFCBFEAC8E1BF34F5BA45609E4940
78231	GU1 2DS	GB	0101000020E6100000C9AEB48CD4FBE1BF3A02B859BC9E4940
78232	GU1 2HU	GB	0101000020E61000008B7093516598E1BF9BCB0D863A9E4940
78233	GU1 2JB	GB	0101000020E610000090A2CEDC43C2E1BFC66B5ED5599F4940
78234	GU1 2LZ	GB	0101000020E610000078B471C45A7CE1BF88BB7A15199F4940
78235	GU1 2PS	GB	0101000020E6100000F566D47C957CE1BFB306EFAB729F4940
78236	GU1 2PX	GB	0101000020E610000073F1B73D4162E1BF00917EFB3A9E4940
78237	GU1 2TD	GB	0101000020E61000001F813FFCFC77E1BF018750A5669F4940
78238	GU1 2TF	GB	0101000020E6100000CE16105A0F5FE1BF3F373465A79F4940
78239	GU1 3LD	GB	0101000020E6100000ACE28DCC23FFE1BFBA2EFCE07C9E4940
78240	GU1 3PP	GB	0101000020E6100000AF7B2B121354E2BF4EB340BB439E4940
78241	GU1 3RX	GB	0101000020E6100000282B86AB0320E2BF41BB438A019E4940
78242	GU1 4BD	GB	0101000020E610000003B2D7BB3F5EE2BF5089EB18579E4940
78243	GU1 4DH	GB	0101000020E6100000628731E9EF25E2BFB43C0FEECE9E4940
78244	GU1 4DN	GB	0101000020E61000005D8AABCABE2BE2BF075DC2A1B79E4940
78245	GU1 4DQ	GB	0101000020E6100000B0CA85CABF16E2BF6284F068E39E4940
78246	GU1 4NT	GB	0101000020E61000001A51DA1B7C61E2BF4F594DD7139F4940
78247	GU1 4PG	GB	0101000020E61000006EC493DDCC68E2BF0C3CF71E2E9F4940
78248	GU1 4RP	GB	0101000020E610000042E90B21E77DE2BFE8A04B38F49E4940
78249	GU1 4SY	GB	0101000020E610000000A94D9CDC6FE2BFDC7F643A749E4940
78250	GU1 4UT	GB	0101000020E6100000331823128596E2BF115322895E9E4940
78251	GU1 4UU	GB	0101000020E61000001E537765178CE2BF75012F336C9E4940
78252	GU10	GB	0101000020E6100000D787F546ADB0E9BF7217618A72994940
78253	GU10 1AX	GB	0101000020E61000007521567F8461E7BFB933130CE79E4940
78254	GU10 1ER	GB	0101000020E6100000CA1AF5108D6EE7BFDD239BABE69D4940
78255	GU10 1HD	GB	0101000020E6100000DAFF006BD5AEE6BF336E6AA0F99C4940
78256	GU10 1HS	GB	0101000020E6100000E0BA624678FBE6BF139D6516A19C4940
78257	GU10 2	GB	0101000020E6100000C6DB4AAFCDC6E8BF20EBA9D557914940
78258	GU10 2QE	GB	0101000020E6100000719351651877E9BF17A06D35EB924940
78259	GU10 2QG	GB	0101000020E6100000BEF6CC9200B5E9BF28EE7893DF924940
78260	GU10 2QH	GB	0101000020E61000009869FB57561AEABFFB3BDBA337924940
78261	GU10 3DP	GB	0101000020E6100000E0D572672618E9BF86747808E3954940
78262	GU10 3HT	GB	0101000020E610000090831266DA7EE9BF81B053AC1A984940
78263	GU10 3LR	GB	0101000020E61000007B4ACE893D34E9BF8927BB99D1994940
78264	GU10 3PE	GB	0101000020E610000045D61A4AED45E9BF630E828E56994940
78265	GU10 4DD	GB	0101000020E6100000691CEA77616BEABF058A58C4B0974940
78266	GU10 4LR	GB	0101000020E6100000624B8FA67AB2E9BF92E86514CB974940
78267	GU10 4QF	GB	0101000020E610000072E140481630EABF1689096AF8984940
78268	GU10 4RP	GB	0101000020E6100000F54883DBDAC2E9BF6D3997E2AA984940
78269	GU10 4SX	GB	0101000020E61000007026A60BB1FAE9BF4C33DDEBA4984940
78270	GU10 5AS	GB	0101000020E610000097C4591135D1EABF158BDF14569E4940
78271	GU10 5HD	GB	0101000020E61000004451A04FE449EBBFE6913F18789A4940
78272	GU10 5JZ	GB	0101000020E6100000876A4AB20EC7EBBFE29178793A974940
78273	GU10 5LS	GB	0101000020E6100000AB22DC645419ECBFB20FB22C98984940
78274	GU10 5PH	GB	0101000020E6100000B3D30FEA2285EBBF96E7C1DD599D4940
78275	GU10 5RQ	GB	0101000020E6100000FBE93F6B7E7CEBBF51888043A89E4940
78276	GU10 5TN	GB	0101000020E61000004B2366F6798CEABFB741EDB7769E4940
78277	GU11 1HN	GB	0101000020E6100000C6C4E6E3DA50E8BF077E54C37E9F4940
78278	GU11 1SQ	GB	0101000020E6100000DDE9CE13CFD9E8BF9CF9D51C20A04940
78279	GU11 3	GB	0101000020E61000004CAAB69BE09BE8BF7DE9EDCF459F4940
78280	GU11 3AN	GB	0101000020E610000008C9022670EBE8BF05FA449E249F4940
78281	GU11 3NX	GB	0101000020E6100000242713B70AE2E8BF4B02D4D4B29F4940
78282	GU11 3PS	GB	0101000020E6100000399B8E006E16E8BFA9143B1A879E4940
78283	GU11 3RD	GB	0101000020E610000045813E912749E8BF70EEAF1EF79D4940
78284	GU12	GB	0101000020E61000003CA583F57F0EE7BFCF85915ED4A24940
78285	GU12 4AY	GB	0101000020E6100000E146CA1649BBE7BF0249D8B7939E4940
78286	GU12 4JH	GB	0101000020E6100000588FFB56EB44E8BF9E40D829569F4940
78287	GU12 4LD	GB	0101000020E6100000D7A19A92AC43E8BF64EAAEEC829F4940
78288	GU12 4NE	GB	0101000020E61000000C1F11532209E8BFF7AFAC34299F4940
78289	GU12 4QD	GB	0101000020E6100000B98D06F016C8E6BFCCCF0D4DD9A34940
78290	GU12 4QS	GB	0101000020E610000087FBC8AD49B7E7BF512D228AC99F4940
78291	GU12 4QY	GB	0101000020E610000005F86EF3C6C9E7BF2F6F0ED76A9F4940
78292	GU12 4TW	GB	0101000020E6100000C53C2B69C5B7E7BFCAA7C7B60CA04940
78293	GU12 5HH	GB	0101000020E6100000255D33F9661BE7BF3D29931ADAA04940
78294	GU12 5LL	GB	0101000020E61000001D3A3DEFC602E7BF6A12BC218DA24940
78295	GU12 5LP	GB	0101000020E610000060E811A3E716E7BF904FC8CEDBA24940
78296	GU12 5LS	GB	0101000020E6100000F12C41464005E7BFA45016BEBEA24940
78297	GU12 5QA	GB	0101000020E6100000C5C6BC8E3864E7BF59C2DA183BA34940
78298	GU12 5SG	GB	0101000020E6100000F08975AA7C4FE7BF1F82AAD1ABA14940
78299	GU12 6	GB	0101000020E6100000C1E5B1666410E7BF020D36751E9F4940
78300	GU12 6BE	GB	0101000020E6100000F7E7A221E3D1E6BF2BDEC83CF29F4940
78301	GU12 6DX	GB	0101000020E6100000BF45274BAD77E6BFD0EE906280A04940
78302	GU12 6HN	GB	0101000020E61000004CC45BE7DFAEE6BFD9CC21A9859E4940
78303	GU12 6NE	GB	0101000020E61000000EF8FC3042F8E6BFE04A766C04A04940
78304	GU12 6NN	GB	0101000020E61000002507EC6AF214E7BF3C50A73CBA9F4940
78305	GU14 0DH	GB	0101000020E61000006C06B8205B96E8BF86C8E9EBF9A44940
78306	GU14 0ES	GB	0101000020E61000003753211E8997E8BF4B033FAA61A54940
78307	GU14 0ET	GB	0101000020E61000008505F7031E98E8BF17EFC7ED97A54940
78308	GU14 0HP	GB	0101000020E6100000DA3C0E83F9ABE8BF74ED0BE885A54940
78309	GU14 0HW	GB	0101000020E6100000699082A790ABE8BF6D59BE2EC3A54940
78310	GU14 0JE	GB	0101000020E6100000179F02603C03E9BFC8B5A1629CA54940
78311	GU14 0JN	GB	0101000020E6100000DE1E84807C09E9BF56F2B1BB40A54940
78312	GU14 0LX	GB	0101000020E6100000D102B4AD661DE9BF677E350708A44940
78313	GU14 0NL	GB	0101000020E6100000E21E4B1FBA20E9BFB9A6406667A54940
78314	GU14 2PL	GB	0101000020E6100000601DC70F95C6E7BF9C6C0377A0A64940
78315	GU14 6EE	GB	0101000020E6100000F1811DFF0502E8BFD2DF4BE141A34940
78316	GU14 6PR	GB	0101000020E61000006E5166834CB2E7BF5514AFB2B6A34940
78317	GU14 6QG	GB	0101000020E610000053AF5B04C6FAE7BF653909A52FA44940
78318	GU14 7HF	GB	0101000020E61000000C79043752B6E7BF02BA2F67B6A54940
78319	GU14 7HL	GB	0101000020E6100000014EEFE2FDB8E7BF7E5182FE42A54940
78320	GU14 7NL	GB	0101000020E6100000B282DF86182FE8BFF5B9DA8AFDA54940
78321	GU14 7QA	GB	0101000020E6100000637D03931B45E8BF60AB048BC3A54940
78322	GU14 7TJ	GB	0101000020E6100000AF5FB01BB62DE8BF2DB5DE6FB4A54940
78323	GU14 8	GB	0101000020E61000008F53742497FFE7BF2AC93A1C5DA74940
78324	GU14 8AF	GB	0101000020E6100000D828EB3713D3E7BF3FA9F6E978A64940
78325	GU14 8QH	GB	0101000020E61000008BE07F2BD9B1E8BFF77475C762A54940
78326	GU14 8SG	GB	0101000020E6100000494BE5ED08A7E8BFEE3D5C72DCA74940
78327	GU14 9EJ	GB	0101000020E61000001C9AB2D30FEAE8BFAEEFC34142A84940
78328	GU14 9EZ	GB	0101000020E6100000ED82C13577F4E8BF1F82AAD1ABA74940
78329	GU14 9HX	GB	0101000020E610000034828DEBDFF5E8BF9147702365A74940
78330	GU14 9LH	GB	0101000020E610000068D0D03FC145E9BF2F6F0ED76AA74940
78331	GU14 9QP	GB	0101000020E610000007793D98141FE9BFCEFBFF3861A64940
78332	GU14 9RJ	GB	0101000020E6100000C51EDAC70AFEE8BF782AE09EE7A54940
78333	GU14 9RZ	GB	0101000020E6100000F67CCD72D9E8E8BFAA49F08634A64940
78334	GU14 9SG	GB	0101000020E6100000232E008DD225E9BFCADC7C23BAA54940
78335	GU15	GB	0101000020E6100000D122DBF97E6AE6BF9A94826E2FAB4940
78336	GU15 1AS	GB	0101000020E610000089247A19C5F2E6BFFA25E2ADF3A94940
78337	GU15 1BL	GB	0101000020E6100000BDA60705A568E6BF26DF6C7363AA4940
78338	GU15 1DA	GB	0101000020E6100000D717096D3917E7BF62D68BA19CAA4940
78339	GU15 1EB	GB	0101000020E6100000D66F26A60BB1E6BFB29B19FD68AA4940
78340	GU15 1QH	GB	0101000020E61000006C3F19E3C36CE6BF971DE21FB6AA4940
78341	GU15 1QQ	GB	0101000020E610000009E23C9CC074E6BF5F5E807D74AA4940
78342	GU15 1RQ	GB	0101000020E6100000B08C0DDDEC8FE6BF45B75ED383AA4940
78343	GU15 1SA	GB	0101000020E6100000FB9463B2B87FE6BF5A492BBEA1AA4940
78344	GU15 1SB	GB	0101000020E6100000C493DDCCE8C7E6BFF146E6913FAA4940
78345	GU15 2AD	GB	0101000020E61000001092054CE056E7BF170D198F52AB4940
78346	GU15 2BY	GB	0101000020E610000028B858518369E7BFDE718A8EE4AA4940
78347	GU15 2EB	GB	0101000020E6100000746039420672E7BF608F899466AB4940
78348	GU15 2SP	GB	0101000020E6100000BB0ED594641DE8BFAA0A0DC4B2A94940
78349	GU15 2UZ	GB	0101000020E6100000D923D40CA922E8BF59DDEA39E9A94940
78350	GU15 2YB	GB	0101000020E610000049DBF813950DE8BFCA51802898A94940
78351	GU15 3BA	GB	0101000020E6100000081C0934D854E8BF9032E202D0AA4940
78352	GU15 3HL	GB	0101000020E6100000A837A3E6AB64E8BF069D103AE8AA4940
78353	GU15 3JT	GB	0101000020E6100000E4326E6AA0F9E7BF10E84CDA54AB4940
78354	GU15 3ND	GB	0101000020E6100000CB2C42B11534E8BF61A8C30AB7AA4940
78355	GU15 3NJ	GB	0101000020E6100000A228D027F224E8BF8F519E7939AA4940
78356	GU15 3RR	GB	0101000020E6100000166A4DF38ED3E7BF663046240AAB4940
78357	GU15 3SY	GB	0101000020E610000036583849F3C7E7BF60E7A6CD38AB4940
78358	GU15 4BE	GB	0101000020E6100000187AC4E8B905E7BFF81C588E90AD4940
78359	GU15 4DN	GB	0101000020E61000008D0E48C2BE9DE7BF7E1AF7E637AC4940
78360	GU15 4EF	GB	0101000020E61000003FC91D369119E7BFA6D6FB8D76AC4940
78361	GU16	GB	0101000020E61000003F3BE0BA6246E7BF8BA8893E1FA94940
78362	GU16 5EW	GB	0101000020E61000009696917A4FE5E7BFA5F5B704E0A74940
78363	GU16 6AS	GB	0101000020E61000004B9352D0EDA5E7BF88BA0F406AA54940
78364	GU16 6AY	GB	0101000020E610000045BB0A293F29E7BFF661BD512BA44940
78365	GU16 6DX	GB	0101000020E61000000729780AB952E7BF091B9E5E29A54940
78366	GU16 6HH	GB	0101000020E6100000E6E61BD13D6BE7BFBAF3C473B6A64940
78367	GU16 6JX	GB	0101000020E61000007F880D164E52E7BFD7868A71FEA64940
78368	GU16 6LJ	GB	0101000020E6100000A94C31074147E7BF0C3D62F4DCA64940
78369	GU16 6QX	GB	0101000020E6100000FED5E3BED5BAE6BF05C078060DA74940
78370	GU16 7EL	GB	0101000020E61000007C2766BD18CAE7BF8C14CAC2D7A74940
78371	GU16 7HD	GB	0101000020E6100000A01518B2BAD5E7BFAE11C138B8A84940
78372	GU16 8LD	GB	0101000020E61000009A40118B1876E7BF587380608EA84940
78373	GU16 8TU	GB	0101000020E6100000C2C3B46FEEAFE7BF5F46B1DCD2A84940
78374	GU16 8XT	GB	0101000020E610000047ACC5A70098E7BF92EC116A86A84940
78375	GU16 9QX	GB	0101000020E61000004B5CC7B8E2E2E7BF98DC28B2D6A64940
78376	GU16 9YE	GB	0101000020E610000087FC3383F840E7BFD943FB58C1A74940
78377	GU17	GB	0101000020E6100000581D39D21918E9BFB936548CF3A94940
78378	GU17 0DT	GB	0101000020E610000073A25D85949FE9BF2E1F49490FAB4940
78379	GU17 0HA	GB	0101000020E610000026C3F17C0654E9BF0B2593533BAB4940
78380	GU17 9AA	GB	0101000020E6100000E5B67D8FFAEBE8BFE370E65773AA4940
78381	GU17 9AB	GB	0101000020E6100000C0ED0912DBDDE8BFD68EE21C75AA4940
78382	GU17 9BB	GB	0101000020E6100000CAC4AD8218E8E8BF10B22C98F8A94940
78383	GU17 9DZ	GB	0101000020E6100000DFC2BAF1EEC8E8BF4EEE77280AAA4940
78384	GU17 9LX	GB	0101000020E61000008908FF22684CE9BF45D7851F9CA94940
78385	GU17 9QG	GB	0101000020E61000008386FE092E56E9BFB037312427A74940
78386	GU18 5RA	GB	0101000020E610000020D3DA34B657E5BFE3344415FEAC4940
78387	GU18 5RL	GB	0101000020E6100000855FEAE74D45E5BF245F09A4C4AC4940
78388	GU18 5RS	GB	0101000020E6100000C571E0D57267E5BF2A38BC2022AD4940
78389	GU18 5SP	GB	0101000020E6100000338AE5965643E5BFB308C556D0AC4940
78390	GU18 5SY	GB	0101000020E6100000F38FBE49D320E5BFEF74E789E7AC4940
78391	GU18 5TA	GB	0101000020E6100000F46E2C280C4AE5BFA41CCC26C0AC4940
78392	GU18 5UP	GB	0101000020E6100000997E8978EB7CE5BF0729780AB9AC4940
78393	GU18 5YT	GB	0101000020E6100000BE4C142175BBE5BFE5B67D8FFAAB4940
78394	GU19 5AS	GB	0101000020E610000035B401D88008E6BF80BBECD79DAE4940
78395	GU19 5BP	GB	0101000020E61000007B4ACE893D34E6BF9BE3DC26DCAD4940
78396	GU19 5DZ	GB	0101000020E61000009E0B23BDA85DE6BF9626A5A0DBAD4940
78397	GU19 5HD	GB	0101000020E610000089EC832C0B26E6BF7CF2B0506BAE4940
78398	GU19 5JL	GB	0101000020E6100000E9633E20D019E6BFA6B915C26AAE4940
78399	GU19 5NW	GB	0101000020E6100000698A00A777F1E5BF583B8A73D4AD4940
78400	GU19 8BL	GB	0101000020E6100000DDD3D51D8B6DE5BF8E91EC116AAE4940
78401	GU2	GB	0101000020E6100000F19F6EA0C0BBE2BF3F0114234B9E4940
78402	GU2 4AT	GB	0101000020E610000042D13C80457EE2BF077DE9EDCF9D4940
78403	GU2 4EW	GB	0101000020E6100000B6F81400E399E2BF4260E5D0229D4940
78404	GU2 4JB	GB	0101000020E6100000501BD5E940D6E1BF8A8F4FC8CE9D4940
78405	GU2 4JD	GB	0101000020E6100000959D7E5017A9E2BF3718EAB0C29D4940
78406	GU2 4JF	GB	0101000020E6100000C7D79E5912A0E2BF1FD95C35CF9D4940
78407	GU2 4JX	GB	0101000020E610000090300C587295E2BF7C9C69C2F69D4940
78408	GU2 7NJ	GB	0101000020E6100000C93A1C5DA5BBE2BFD15CA791969E4940
78409	GU2 7NU	GB	0101000020E6100000F46E2C280CCAE2BFEC3191D26C9E4940
78410	GU2 7NY	GB	0101000020E61000007407B13385CEE2BF01F8A754899E4940
78411	GU2 7PQ	GB	0101000020E6100000FAD170CADCFCE2BF698F17D2E19D4940
78412	GU2 7QB	GB	0101000020E6100000A1F7C610009CE3BF53AEF02E179F4940
78413	GU2 7SS	GB	0101000020E61000008351499D8026E3BF3A3E5A9C319E4940
78414	GU2 7XE	GB	0101000020E61000007024D06053E7E2BFF1129CFA40A04940
78415	GU2 7XH	GB	0101000020E61000003BC5AA4198DBE2BFA0C6BDF90D9F4940
78416	GU2 8AF	GB	0101000020E6100000292504ABEAE5E2BF57AF22A303A04940
78417	GU2 8AX	GB	0101000020E6100000732CEFAA07CCE2BF07B13385CE9F4940
78418	GU2 8ND	GB	0101000020E6100000916456EF70BBE2BF0D6D003620A04940
78419	GU2 9AB	GB	0101000020E610000077103B53E8BCE2BFE98024ECDB9F4940
78420	GU2 9JX	GB	0101000020E6100000EA5DBC1FB7DFE2BF48DC63E943A14940
78421	GU2 9NS	GB	0101000020E61000009CDB847B65DEE2BFBE839F3880A04940
78422	GU2 9QQ	GB	0101000020E610000079AF5A99F0CBE2BF7B4D0F0A4AA14940
78423	GU2 9RQ	GB	0101000020E61000007E8AE3C0ABE5E2BF9FE3A3C519A14940
78424	GU2 9TT	GB	0101000020E6100000959C137B681FE3BFD593F947DFA04940
78425	GU2 9TU	GB	0101000020E6100000B9E00CFE7E31E3BF691EC022BFA04940
78426	GU2 9XR	GB	0101000020E61000007D5C1B2AC6F9E2BF03EFE4D363A14940
78427	GU20 6AG	GB	0101000020E610000027F56569A7E6E4BF21CA17B490AE4940
78428	GU20 6AR	GB	0101000020E6100000ED9BFBABC7FDE4BF29B4ACFBC7AE4940
78429	GU20 6BH	GB	0101000020E610000013471E882C52E5BF2F19C748F6AE4940
78430	GU20 6BZ	GB	0101000020E61000000BEE073C3000E5BF7D21E4BCFFAD4940
78431	GU20 6DP	GB	0101000020E610000021C9ACDEE1F6E4BF01310917F2AE4940
78432	GU20 6HA	GB	0101000020E61000006150A6D1E4E2E4BF33DC80CF0FAF4940
78433	GU20 6QD	GB	0101000020E610000064247B849A21E5BF0264E8D841AF4940
78434	GU21	GB	0101000020E6100000809E060C92BEE2BF0420EEEA55A84940
78435	GU21 1XB	GB	0101000020E6100000AC394030478FE3BF06D50627A2A74940
78436	GU21 2AA	GB	0101000020E6100000E2C80391459AE3BFBA10AB3FC2A84940
78437	GU21 2BL	GB	0101000020E6100000E7A7380EBC5AE3BF77F4BF5C8BA84940
78438	GU21 2BW	GB	0101000020E6100000AB048BC3995FE3BF946B0A6476A84940
78439	GU21 2EY	GB	0101000020E6100000AF5A99F04B7DE3BF9BAE27BA2EA84940
78440	GU21 2JF	GB	0101000020E6100000276BD44334BAE3BF5EF58079C8A84940
78441	GU21 2LD	GB	0101000020E6100000AD31E884D0C1E3BFAD50A4FB39A94940
78442	GU21 2LG	GB	0101000020E6100000705E9CF86AC7E3BF63D4B5F63EA94940
78443	GU21 2QL	GB	0101000020E61000004A7CEE04FB2FE3BF6FB9FAB149A84940
78444	GU21 2QQ	GB	0101000020E6100000DCF63DEAAFD7E3BF52465C001AA94940
78445	GU21 2QZ	GB	0101000020E6100000359A5C8C81F5E3BFA723809BC5A74940
78446	GU21 3HG	GB	0101000020E61000009624CFF57D38E2BFECA529029CA84940
78447	GU21 3PR	GB	0101000020E6100000F855B950F9D7E2BF03B16CE690A84940
78448	GU21 4AU	GB	0101000020E610000082C7B7770DFAE1BF2463B5F97FA94940
78449	GU21 4AX	GB	0101000020E6100000E2EA0088BBFAE1BF8AE76C01A1A94940
78450	GU21 4BL	GB	0101000020E6100000EA5BE67459CCE1BFF48C7DC9C6A94940
78451	GU21 4BX	GB	0101000020E61000005D52B5DD04DFE1BF185B087250AA4940
78452	GU21 4DY	GB	0101000020E61000008D4127840EBAE1BF2672C119FCA94940
78453	GU21 4ET	GB	0101000020E610000051DB865110BCE1BF5C2041F163AA4940
78454	GU21 4HY	GB	0101000020E6100000069D103AE812E2BF2EAD86C43DAA4940
78455	GU21 4JN	GB	0101000020E6100000EE43DE72F563E2BFA9F8BF232AAA4940
78456	GU21 4LY	GB	0101000020E6100000873595456117E2BFF47002D369A94940
78457	GU21 4LZ	GB	0101000020E61000004B00FE295522E2BF9E7B0F971CA94940
78458	GU21 4NQ	GB	0101000020E61000002655DB4DF0CDE1BFDEAB5626FCA84940
78459	GU21 4RB	GB	0101000020E610000088670932022AE2BF153B1A87FAA94940
78460	GU21 4RP	GB	0101000020E61000004B1FBAA0BE65E2BF31B43A3943A94940
78461	GU21 4SJ	GB	0101000020E6100000C614AC71369DE2BFEE5C18E945A94940
78462	GU21 4TA	GB	0101000020E61000004B7842AF3F89E2BF780DFAD2DBA94940
78463	GU21 4XS	GB	0101000020E6100000B2648EE55DF5E2BF3B1A87FA5DAA4940
78464	GU21 5EF	GB	0101000020E61000007EE4D6A4DB92E0BF2A8F6E8445AB4940
78465	GU21 5TA	GB	0101000020E6100000E73A8DB4545EE1BF8E739B70AFAA4940
78466	GU21 5TR	GB	0101000020E6100000A05225CADED2E0BFF0F8F6AE41AB4940
78467	GU21 5UB	GB	0101000020E610000045B9347EE115E1BFDCBA9BA73AAA4940
78468	GU21 6BH	GB	0101000020E61000003657CD7344BEE1BFF38FBE49D3A84940
78469	GU21 6GQ	GB	0101000020E6100000F5BA4560ACEFE1BF2ACAA5F10BA94940
78470	GU21 6NW	GB	0101000020E6100000B9A640666751E2BF098B8A389DA84940
78471	GU21 7LD	GB	0101000020E61000009A94826E2FE9E2BFD2C6116BF1A74940
78472	GU21 7PT	GB	0101000020E610000034D593F9475FE2BF9A417C60C7A74940
78473	GU21 7PY	GB	0101000020E6100000B35E0CE544BBE2BF3F1EFAEE56A84940
78474	GU21 7QB	GB	0101000020E6100000096F0F4240BEE2BFEA211ADD41A84940
78475	GU21 8PU	GB	0101000020E61000006FD39FFD4811E3BFD3A23EC91DA84940
78476	GU22	GB	0101000020E6100000EEEC2B0FD2D3E0BF83A7902BF5A84940
78477	GU22 0	GB	0101000020E61000004AB8904770A3E2BF145B41D312A74940
78478	GU22 0AJ	GB	0101000020E6100000AAD72D0263FDE1BF6BB8C83D5DA74940
78479	GU22 0AZ	GB	0101000020E61000002522FC8BA031E2BF88BB7A1519A74940
78480	GU22 0DB	GB	0101000020E6100000355D4F745D78E2BF677BF486FBA64940
78481	GU22 0JB	GB	0101000020E61000003B6EF8DD744BE2BF00581D39D2A74940
78482	GU22 0NP	GB	0101000020E610000083161230BABCE2BFBEDD921CB0A54940
78483	GU22 0NR	GB	0101000020E610000044A51133FBBCE2BFE92807B309A64940
78484	GU22 0NX	GB	0101000020E61000004D2CF015DD7AE2BFE469F981ABA64940
78485	GU22 7JD	GB	0101000020E6100000DD611399B9C0E1BF3CF6B3588AA84940
78486	GU22 7JP	GB	0101000020E6100000170D198F5289E1BFBAD8B45208A84940
78487	GU22 7JT	GB	0101000020E6100000DCBDDC274701E2BF9160AA99B5A84940
78488	GU22 7LJ	GB	0101000020E6100000202922C32ADEE1BFF62686E464A84940
78489	GU22 7PH	GB	0101000020E6100000A7069ACFB9DBE1BF31D3F6AFACA84940
78490	GU22 7QW	GB	0101000020E6100000E17A14AE47E1E1BF8C4D2B8540A84940
78491	GU22 7TD	GB	0101000020E6100000C0CC77F01307E2BF56D28A6F28A84940
78492	GU22 7TH	GB	0101000020E6100000A20E2BDCF211E2BF97AB1F9BE4A74940
78493	GU22 7UN	GB	0101000020E61000000DFD135CAC28E2BFAD31E884D0A74940
78494	GU22 7XJ	GB	0101000020E61000001F69705B5BF8E1BF342F87DD77A84940
78495	GU22 8AA	GB	0101000020E610000016139B8F6B43E1BFC8EC2C7AA7A84940
78496	GU22 8AP	GB	0101000020E6100000514CDE00335FE1BF815B77F354A94940
78497	GU22 8BF	GB	0101000020E610000051D9B0A6B228E1BF1686C8E9EBA74940
78498	GU22 8LP	GB	0101000020E61000005395B6B8C6E7E0BF88D68A36C7A94940
78499	GU22 8PL	GB	0101000020E6100000143DF0315871E0BF598B4F0130AA4940
78500	GU22 8PR	GB	0101000020E610000063D34A21904BE0BFC58D5BCCCFA94940
78501	GU22 8PT	GB	0101000020E61000001A321EA5129EE0BF55D97745F0A94940
78502	GU22 8QR	GB	0101000020E610000042EA76F69587E0BF431D56B8E5A94940
78503	GU22 8QX	GB	0101000020E61000004568041BD7BFDFBFEF74E789E7AA4940
78504	GU22 8SA	GB	0101000020E61000009DB98784EF7DE0BF8787307E1AA94940
78505	GU22 8UL	GB	0101000020E610000031D120054F21E0BF068200193AAA4940
78506	GU22 9BJ	GB	0101000020E61000001B13622EA95AE1BFAB5E7EA7C9A84940
78507	GU22 9BL	GB	0101000020E61000002F35423F53AFE1BF069D103AE8A64940
78508	GU22 9EN	GB	0101000020E61000008A592F8672A2E1BF60915F3FC4A64940
78509	GU22 9LB	GB	0101000020E61000003274ECA01257E1BFC72C7B12D8A64940
78510	GU22 9PY	GB	0101000020E61000007233DC80CF0FE2BF45BDE0D39CA64940
78511	GU23	GB	0101000020E6100000FBC9181F662FE0BF251FBB0B94A84940
78512	GU23 6AA	GB	0101000020E61000003291D26C1E87DFBF8BAA5FE97CA64940
78513	GU23 6EP	GB	0101000020E61000008A58C4B0C318E0BF7A6F0C01C0A54940
78514	GU23 6JX	GB	0101000020E610000047904AB1A371E0BF064A0A2C80A54940
78515	GU23 6LS	GB	0101000020E610000012DDB3AED172E0BFDA8F149161A54940
78516	GU23 6LW	GB	0101000020E610000021ACC612D646E0BF1C45D61A4AA54940
78517	GU23 7AJ	GB	0101000020E6100000DCA0F65B3B51E1BFC90050C58DA54940
78518	GU23 7DD	GB	0101000020E61000005801BEDBBC71E0BF83A279008BA44940
78519	GU23 7HP	GB	0101000020E610000019E3C3EC65DBE0BF26E4839ECDA44940
78520	GU24	GB	0101000020E6100000F2B4FCC0551EE3BFCC0C1B65FDAC4940
78521	GU24 0ER	GB	0101000020E6100000917F66101F58E4BF8080B56AD7A64940
78522	GU24 0ES	GB	0101000020E610000084D558C2DA18E4BFA379008BFCA64940
78523	GU24 0JB	GB	0101000020E610000091B8C7D287AEE4BF747CB43863A64940
78524	GU24 0JD	GB	0101000020E6100000715AF0A2AFA0E4BFF085C954C1A44940
78525	GU24 0JE	GB	0101000020E6100000B49080D1E5CDE4BF577C43E1B3A54940
78526	GU24 0NU	GB	0101000020E610000060747973B8D6E4BFF9C08EFF02A74940
78527	GU24 0NY	GB	0101000020E6100000378E588B4F01E5BF1D8EAED2DDA74940
78528	GU24 0QQ	GB	0101000020E6100000B7D09508547FE5BFAA471ADCD6A64940
78529	GU24 8HJ	GB	0101000020E6100000E4A1EF6E6509E3BF793A579412AE4940
78530	GU24 8HT	GB	0101000020E6100000C7F0D8CF6229E2BF6A183E22A6AC4940
78531	GU24 8NE	GB	0101000020E61000009B8F6B43C538E3BF8ACC5CE0F2AC4940
78532	GU24 8QD	GB	0101000020E6100000EE7BD45FAF30E3BF8E03AF963BAD4940
78533	GU24 8RL	GB	0101000020E6100000601E32E54350E3BF2A37514B73AD4940
78534	GU24 9BX	GB	0101000020E6100000D50792770E65E4BF7FF964C570A94940
78535	GU24 9EB	GB	0101000020E610000039D219187959E4BF003ACC9717AA4940
78536	GU24 9HF	GB	0101000020E610000049BBD1C77C40E4BF87DC0C37E0A94940
78537	GU24 9LZ	GB	0101000020E610000007EFAB72A1F2E4BF0074982F2FAA4940
78538	GU24 9PW	GB	0101000020E61000005D8940F50FA2E4BFB2BB404981AB4940
78539	GU24 9QF	GB	0101000020E61000002158552FBF53E4BFF01472A59EAB4940
78540	GU25	GB	0101000020E61000000F46EC1340B1E1BF7AE063B0E2B44940
78541	GU25 4AA	GB	0101000020E610000081971936CAFAE1BF8E942D9276B34940
78542	GU25 4BU	GB	0101000020E61000008318E8DA17D0E1BFDA20938C9CB34940
78543	GU25 4JR	GB	0101000020E61000006C04E275FD02E3BF68CBB91457B14940
78544	GU25 4PW	GB	0101000020E610000036AB3E575B31E2BF0FED6305BFB74940
78545	GU26 6DU	GB	0101000020E61000004A6249B9FB1CE9BF3E3E213B6F8D4940
78546	GU26 6HE	GB	0101000020E61000002C0DFCA886FDE7BF3F1F65C4058E4940
78547	GU26 6HL	GB	0101000020E6100000A5F622DA8E29E8BFD6389B8E008E4940
78548	GU26 6JA	GB	0101000020E6100000DB6AD619DF97E8BF81D07AF8328F4940
78549	GU26 6LF	GB	0101000020E610000082E49D43192AE8BF054EB6813B8E4940
78550	GU26 6QA	GB	0101000020E6100000C0B167CF65EAE7BF81EB8A19E18F4940
78551	GU26 6RG	GB	0101000020E61000004BC972124ADFE7BF44A7E7DD58904940
78552	GU27	GB	0101000020E6100000807EDFBF7971E6BF4E0B5EF4158C4940
78553	GU27 1BB	GB	0101000020E6100000234BE658DED5E6BFF73DEAAF578C4940
78554	GU27 1DA	GB	0101000020E610000088484DBB98E6E6BFC66B5ED5598B4940
78555	GU27 1EF	GB	0101000020E6100000D97BF1457BBCE6BFFBAC32535A8B4940
78556	GU27 1JS	GB	0101000020E61000007B319413EDAAE6BFEAB12D03CE8C4940
78557	GU27 1LY	GB	0101000020E610000074D3669C8628E8BF6E4C4F58E28B4940
78558	GU27 1QH	GB	0101000020E610000089450C3B8C49E8BF7DAF21382E8B4940
78559	GU27 2BD	GB	0101000020E6100000C669882AFC99E7BF86C8E9EBF98A4940
78560	GU27 2DU	GB	0101000020E61000009A7B48F8DEDFE5BF9F573CF5488D4940
78561	GU27 2JP	GB	0101000020E6100000E6AE25E4839EE6BFDF88EE59D78A4940
78562	GU27 2LF	GB	0101000020E61000002AAC54505175E6BF317E1AF7E68B4940
78563	GU27 2NY	GB	0101000020E6100000AD32535A7FCBE6BF76E107E7538B4940
78564	GU27 3AA	GB	0101000020E61000003AB01C2103F9E6BFC405A051BA8A4940
78565	GU27 3AG	GB	0101000020E6100000BF2B82FFAD64E6BF4B02D4D4B2894940
78566	GU27 3BG	GB	0101000020E61000005DFDD8243F62E5BFB0C56E9F558A4940
78567	GU27 3BS	GB	0101000020E6100000DF4E22C2BF08E6BF3A02B859BC864940
78568	GU27 3BW	GB	0101000020E610000070067FBF98ADE5BF1CD3139678864940
78569	GU27 3BX	GB	0101000020E6100000618907944DB9E5BF058A58C4B0854940
78570	GU27 3JY	GB	0101000020E61000008AC8B08A3732E7BF12F6ED2422864940
78571	GU27 3RD	GB	0101000020E6100000185C7347FFCBE6BFD89B1892938B4940
78572	GU27 3RN	GB	0101000020E61000000FED6305BF0DE7BF24B6BB07E88A4940
78573	GU27 9BY	GB	0101000020E61000003509DE904685E5BFE21DE0490B874940
78574	GU27 9PE	GB	0101000020E610000084D382177D05E7BF8B6D52D1588B4940
78575	GU28 0AB	GB	0101000020E6100000840EBA84436FE3BF2BFA43334F7E4940
78576	GU28 0AE	GB	0101000020E6100000319413ED2AA4E3BF39B874CC797E4940
78577	GU28 0DD	GB	0101000020E61000002FDCB930D20BE4BFAA7CCF48847A4940
78578	GU28 0JX	GB	0101000020E61000007BC1A7397911E4BF61E3FA777D7A4940
78579	GU28 0JY	GB	0101000020E61000008483BD892139E4BFA56ABB09BE794940
78580	GU28 0LS	GB	0101000020E6100000C87C40A033E9E3BF431EC18D94794940
78581	GU28 9BD	GB	0101000020E61000004B1E4FCB0FDCE4BF0798F90E7E824940
78582	GU28 9DE	GB	0101000020E6100000E6400FB56D98E5BF90D8EE1EA07F4940
78583	GU28 9DW	GB	0101000020E6100000AF777FBC572DE5BFCE35CCD078804940
78584	GU28 9EG	GB	0101000020E61000007156444DF479E4BF79B29B19FD844940
78585	GU28 9EP	GB	0101000020E6100000DBA4A2B1F6F7E4BF54E23AC615854940
78586	GU28 9EQ	GB	0101000020E610000033C170AE6186E4BF6F2F698CD6854940
78587	GU28 9ER	GB	0101000020E61000006490BB085314E5BF732EC55565834940
78588	GU28 9ES	GB	0101000020E6100000D1B01875AD3DE5BF5D4E098849844940
78589	GU28 9ET	GB	0101000020E610000066A032FE7D46E5BF1AA54BFF92844940
78590	GU28 9EW	GB	0101000020E6100000255CC823B811E5BF82A966D652864940
78591	GU28 9EX	GB	0101000020E610000086E464E256C1E5BF274F594DD7834940
78592	GU28 9EY	GB	0101000020E6100000DC9F8B868CC7E5BFB187F6B182834940
78593	GU28 9HA	GB	0101000020E6100000CD5CE0F258B3E5BFFC3905F9D9844940
78594	GU28 9HH	GB	0101000020E6100000117349D57693E4BF97A8DE1AD8864940
78595	GU28 9HL	GB	0101000020E6100000ED612F14B09DE4BFC9E53FA4DF864940
78596	GU28 9HN	GB	0101000020E610000047551344DD87E4BF240D6E6B0B874940
78597	GU28 9HP	GB	0101000020E610000016DEE522BE93E4BFC3F352B131874940
78598	GU28 9HY	GB	0101000020E6100000CC7F48BF7D9DE4BF20425C397B874940
78599	GU28 9LZ	GB	0101000020E6100000FAB660A92E60E4BF5EF58079C8824940
78600	GU28 9NB	GB	0101000020E61000004D6A6803B001E4BF6FBC3B3256834940
78601	GU29 9BN	GB	0101000020E6100000CF2C0950534BE7BF1349F4328A7F4940
78602	GU29 9DR	GB	0101000020E61000004A0C022B8796E7BFA73E90BC737E4940
78603	GU29 9HL	GB	0101000020E61000000514EAE923F0E7BFBD3AC780EC7D4940
78604	GU29 9QZ	GB	0101000020E6100000AA61BF27D6A9E7BF72E14048167E4940
78605	GU29 9RS	GB	0101000020E61000005FEB5223F4B3E7BFE085ADD9CA7F4940
78606	GU3	GB	0101000020E6100000C4B12E6EA301E4BF35B401D8809C4940
78607	GU3 1BG	GB	0101000020E610000026A8E15B5837E7BFC79BFC169D9A4940
78608	GU3 1LP	GB	0101000020E61000007D23BA675DA3E2BFF4DC4257229C4940
78609	GU3 2AX	GB	0101000020E6100000B01D8CD82700E5BF08E3A7716FA04940
78610	GU3 2DF	GB	0101000020E61000003C4A253CA157E5BF965AEF37DA9F4940
78611	GU3 2ED	GB	0101000020E6100000A9674128EF63E5BF155454FD4A9F4940
78612	GU3 2EH	GB	0101000020E6100000B3B794F3C55EE5BF37E0F3C3089F4940
78613	GU3 2HA	GB	0101000020E61000001CEC4D0CC949E5BFFC5580EF369F4940
78614	GU3 2HU	GB	0101000020E610000075C93846B247E6BF836E2F698CA04940
78615	GU3 3BH	GB	0101000020E61000001059A4897780E3BF0DA7CCCD37A04940
78616	GU3 3ES	GB	0101000020E6100000AA9A20EA3E00E4BF0531D0B52FA04940
78617	GU3 3QQ	GB	0101000020E6100000D68C0C7217E1E3BF9A97C3EE3BA24940
78618	GU3 3RL	GB	0101000020E610000039605793A7ACE2BF4C8A8F4FC8A44940
78619	GU30	GB	0101000020E6100000075F984C158CE8BF44DD0720B57B4940
78620	GU30 7	GB	0101000020E6100000E030D12005CFE8BFFB3C4679E6834940
78621	GU30 7BW	GB	0101000020E61000003A933655F748E9BFF0366F9C148A4940
78622	GU30 7DJ	GB	0101000020E61000002FF834272FB2E9BF0F46EC1340894940
78623	GU30 7DR	GB	0101000020E6100000799274CDE49BE9BF15FDA19927894940
78624	GU30 7DW	GB	0101000020E610000063B7CF2A33A5E9BFD6C6D8092F894940
78625	GU30 7HX	GB	0101000020E610000099A0866F615DE9BF8B1BB7989F894940
78626	GU30 7LY	GB	0101000020E61000002B31CF4A5A71E9BFE40F069E7B854940
78627	GU30 7QE	GB	0101000020E610000097C4591135D1E9BFE5B512BA4B8A4940
78628	GU30 7RJ	GB	0101000020E6100000268C6665FB90EABFC042E6CAA08C4940
78629	GU30 7RY	GB	0101000020E61000003B376DC66908EABFE9297288B88D4940
78630	GU31	GB	0101000020E6100000CBD8D0CDFE40EDBF3DD4B66114804940
78631	GU31 4DB	GB	0101000020E6100000876D8B321B64EDBFE86C01A1F5804940
78632	GU31 4HJ	GB	0101000020E610000060730E9E094DEDBF05E09F5225804940
78633	GU31 4LN	GB	0101000020E6100000EBAD81AD122CEEBF89B3226AA27F4940
78634	GU31 4PG	GB	0101000020E610000022FAB5F5D3FFEDBF5E13D21A83804940
78635	GU31 5DJ	GB	0101000020E6100000CA32C4B12EEEEABFC80C54C6BF814940
78636	GU31 5QR	GB	0101000020E610000076AA7CCF4884ECBF029CDEC5FB794940
78637	GU32	GB	0101000020E6100000B41EBE4C1421EEBFDDB243FCC3804940
78638	GU32 1BJ	GB	0101000020E6100000AAD5575705EAEEBF9D853DEDF0854940
78639	GU32 1LN	GB	0101000020E6100000F52C08E57D5CF1BF9F56D11F9A814940
78640	GU32 2AN	GB	0101000020E61000003FC571E0D572EDBF1155F833BC814940
78641	GU32 2DG	GB	0101000020E610000098C0ADBB792AEEBF39605793A7824940
78642	GU32 2EH	GB	0101000020E61000008E57207A5226EEBF51D845D103814940
78643	GU32 3BG	GB	0101000020E6100000274A42226D63EEBF7A89B14CBF804940
78644	GU32 3BH	GB	0101000020E610000091813CBB7C6BEEBFC64FE3DEFC804940
78645	GU32 3LF	GB	0101000020E6100000D8D2A3A99E4CEEBF761893FE5E804940
78646	GU32 3LS	GB	0101000020E61000006D54A703594FEEBF766B990CC77F4940
78647	GU32 3PF	GB	0101000020E6100000A27BD6355A8EEEBF88BCE5EAC7804940
78648	GU33 7AA	GB	0101000020E6100000F911BF620D97ECBF98E0D40792854940
78649	GU33 7BH	GB	0101000020E6100000A37554354154ECBF3C889D2974864940
78650	GU33 7DB	GB	0101000020E610000089EFC4AC1743ECBFE17A14AE47874940
78651	GU33 7QD	GB	0101000020E6100000D0D2156C231EECBFFFAECF9CF5834940
78652	GU34	GB	0101000020E61000009370218FE0C6F0BF4B917C2590924940
78653	GU34 1AW	GB	0101000020E61000001904560E2D32EFBFFFCEF6E80D934940
78654	GU34 1AY	GB	0101000020E6100000B610E4A08419EFBF01309E4143934940
78655	GU34 1DD	GB	0101000020E6100000F4BF5C8B1620EFBF1AC05B2041934940
78656	GU34 1HL	GB	0101000020E61000007E022846964CEFBF335184D4ED924940
78657	GU34 1SD	GB	0101000020E61000001D93C5FD47A6EFBF4C89247A19914940
78658	GU34 2LD	GB	0101000020E610000096E7C1DD593BEFBFC9C9C4AD82944940
78659	GU34 2PE	GB	0101000020E610000006465ED6C482EFBF40A374E95F924940
78660	GU34 2PZ	GB	0101000020E6100000DB368C82E0F1EEBF650113B875934940
78661	GU34 3JH	GB	0101000020E61000005682C5E1CC2FEEBF569DD5027B8C4940
78662	GU34 3NX	GB	0101000020E6100000CC79C6BE64E3F0BFC9586DFE5F854940
78663	GU34 4AE	GB	0101000020E6100000C573B680D03AF0BF7E1AF7E637924940
78664	GU34 4AN	GB	0101000020E610000021AE9CBD331AF0BF79E6E5B0FB924940
78665	GU34 4BY	GB	0101000020E6100000CA198A3BDE64EFBFE2CAD93BA3974940
78666	GU34 4EG	GB	0101000020E610000044BE4BA94BC6EEBF3CBCE7C072944940
78667	GU34 5DY	GB	0101000020E6100000BC57AD4CF8A5F0BFC007AF5DDA8E4940
78668	GU34 5EQ	GB	0101000020E610000049BBD1C77CC0F0BF75E8F4BC1B8F4940
78669	GU34 5HY	GB	0101000020E61000000B43E4F4F5FCF0BF1349F4328A8D4940
78670	GU34 5JE	GB	0101000020E6100000EEED96E4801DF1BFEB39E97DE38D4940
78671	GU34 5JF	GB	0101000020E6100000DFC2BAF1EE08F1BF1AA54BFF928E4940
78672	GU34 5PB	GB	0101000020E61000000987DEE2E1BDF0BF68925852EE904940
78673	GU34 5PF	GB	0101000020E61000006D6FB72407ECF0BF1EA9BEF38B904940
78674	GU34 5PH	GB	0101000020E6100000658F5033A40AF1BF94F7713447904940
78675	GU34 5PW	GB	0101000020E6100000AB09A2EE0310F1BF8C82E0F1ED8F4940
78676	GU34 5SS	GB	0101000020E6100000B09124085780F0BF5B44149337984940
78677	GU35	GB	0101000020E61000003F0114234B66EBBF433A3C84F1874940
78678	GU35 0BD	GB	0101000020E61000004E42E90B2167EBBFD32EA699EE8D4940
78679	GU35 0EX	GB	0101000020E6100000E6965643E21EEBBF8B355CE49E8E4940
78680	GU35 0HA	GB	0101000020E6100000BC94BA641CA3EBBF0CAF2479AE8F4940
78681	GU35 0LF	GB	0101000020E61000000EBBEF181EFBEABF7CD28904538F4940
78682	GU35 0QB	GB	0101000020E61000004F5B238271F0EABFE0F42EDE8F8F4940
78683	GU35 0TR	GB	0101000020E610000042226DE34F54EBBF4ED1915CFE8D4940
78684	GU35 0XG	GB	0101000020E6100000D0251C7A8B87EBBF994869368F8D4940
78685	GU35 0YR	GB	0101000020E6100000CCD42478431AEBBF3737A6272C8F4940
78686	GU35 0YW	GB	0101000020E610000023658BA4DDE8EABF02D369DD068F4940
78687	GU35 7RY	GB	0101000020E61000006D72F8A41309EABFB6F81400E38D4940
78688	GU35 8AG	GB	0101000020E6100000F4E159828C00EABF882CD2C43B904940
78689	GU35 8AL	GB	0101000020E6100000DB8827BB99D1E9BFF9F884ECBC8F4940
78690	GU35 8DE	GB	0101000020E6100000231631EC3026EABF0B24287E8C8F4940
78691	GU35 8DS	GB	0101000020E6100000BD8DCD8E54DFE9BFD66EBBD05C8F4940
78692	GU35 8DT	GB	0101000020E610000015AA9B8BBFEDE9BF1E8A027D228F4940
78693	GU35 8DU	GB	0101000020E6100000DE1E84807C09EABFC66B5ED5598F4940
78694	GU35 8DX	GB	0101000020E6100000448B6CE7FB29EABF50172994858F4940
78695	GU35 8EU	GB	0101000020E61000006682E15CC38CE9BF0DC2DCEEE58E4940
78696	GU35 8EX	GB	0101000020E610000017A06D35EB8CE9BFDE03745FCE8E4940
78697	GU35 8HA	GB	0101000020E610000070952710768AE9BF7120240B988E4940
78698	GU35 8HF	GB	0101000020E6100000740D33349E88E9BFF4C29D0B238F4940
78699	GU35 8JA	GB	0101000020E6100000AEF36F97FDBAE9BF6D1ADB6B418F4940
78700	GU35 8JR	GB	0101000020E610000060E5D022DB79E9BFB8054B75018F4940
78701	GU35 8JS	GB	0101000020E61000005B7B9FAA4283E9BFAF5B04C6FA8E4940
78702	GU35 8JT	GB	0101000020E61000002EAA45443179E9BFEB36A8FDD68E4940
78703	GU35 8JU	GB	0101000020E610000053978C63247BE9BF5C8DEC4ACB8E4940
78704	GU35 8JX	GB	0101000020E6100000B3D0CE691668E9BF66136058FE8E4940
78705	GU35 8NH	GB	0101000020E610000018B5FB5580EFE9BFCA880B40A38E4940
78706	GU35 8NJ	GB	0101000020E610000015FF774485EAE9BF179AEB34D28E4940
78707	GU35 8NN	GB	0101000020E610000065DF15C1FFD6E9BF2997C62FBC8E4940
78708	GU35 8NQ	GB	0101000020E61000008D2782380F27EABF904AB1A3718E4940
78709	GU35 8NU	GB	0101000020E61000007B1002F225D4E9BFB41F2922C38E4940
78710	GU35 8PU	GB	0101000020E6100000FA7ABE66B96CEABF87889B53C98E4940
78711	GU35 8SB	GB	0101000020E6100000F8713447567EEABF4D86E3F90C904940
78712	GU35 8SQ	GB	0101000020E6100000DE0033DFC14FEABFAA2B9FE579904940
78713	GU35 9EL	GB	0101000020E6100000593673486A21ECBFAEF02E17F18D4940
78714	GU35 9JN	GB	0101000020E61000005EBEF561BDD1ECBF90BB0853948F4940
78715	GU35 9NE	GB	0101000020E6100000E7FEEA71DFEAEBBF51D9B0A6B28E4940
78716	GU35 9QW	GB	0101000020E61000009DD7D825AA37EBBFBBB88D06F08E4940
78717	GU35 9RE	GB	0101000020E61000004ACE893DB48FEBBFC43E0114238D4940
78718	GU4 2WS	GB	0101000020E6100000A5A0DB4B1A23E2BFC3F2E7DB829B4940
78719	GU4 6TT	GB	0101000020E61000009D84D21742CEE0BF910C39B69E9B4940
78720	GU4 7HQ	GB	0101000020E610000000E31934F44FE1BF15E3FC4D28A04940
78721	GU4 7HY	GB	0101000020E6100000B2463D44A33BE1BF227024D060A14940
78722	GU4 7JT	GB	0101000020E610000034828DEBDF75E1BFD027F224E9A04940
78723	GU4 7LL	GB	0101000020E6100000D13DEB1A2D87E1BFBF9EAF592EA14940
78724	GU4 7NB	GB	0101000020E6100000C614AC71369DE1BFFD4E93196FA14940
78725	GU4 7NR	GB	0101000020E61000008D429259BD43E2BFC9E7154F3DA24940
78726	GU4 7RL	GB	0101000020E61000001DACFF73982FDFBFC8444AB379A04940
78727	GU4 7RQ	GB	0101000020E610000028B682A62556E0BF261AA4E029A04940
78728	GU4 7RT	GB	0101000020E61000008942CBBA7F2CDEBF79AC1919E4A04940
78729	GU4 7TE	GB	0101000020E6100000D00F2384471BE0BF8202EFE4D3A14940
78730	GU4 7YY	GB	0101000020E6100000ABCDFFAB8E9CE1BFD576137CD3A04940
78731	GU4 8AD	GB	0101000020E610000096218E75711BE2BFDC0F7860009D4940
78732	GU4 8AJ	GB	0101000020E610000030BC92E4B93EE2BF0729780AB99C4940
78733	GU4 8EB	GB	0101000020E61000006C09F9A06733E2BFC5909C4CDC9A4940
78734	GU4 8HL	GB	0101000020E6100000293FA9F6E9F8E1BFE3A7716F7E9B4940
78735	GU4 8JU	GB	0101000020E6100000E8A1B60DA320E2BFBC5983F7559B4940
78736	GU4 8JX	GB	0101000020E610000056D5CBEF3419E2BF62BD512B4C9B4940
78737	GU4 8RB	GB	0101000020E61000009F1F46088FB6E0BF30A017EE5C9A4940
78738	GU45 6FG	GB	0101000020E61000006493FC885F31EBBF6A34B91803AB4940
78739	GU46	GB	0101000020E6100000D07F0F5EBBB4EABF6B0DA5F622AA4940
78740	GU46 6AF	GB	0101000020E6100000562AA8A8FA15EABF357EE19524AB4940
78741	GU46 6EF	GB	0101000020E6100000787AA52C439CEABF244223D8B8AA4940
78742	GU46 6EY	GB	0101000020E6100000D8F335CB65A3EABFE62329E961AA4940
78743	GU46 6FE	GB	0101000020E6100000A8C4758C2B2EEBBFF12C414640AB4940
78744	GU46 6HA	GB	0101000020E61000009DD843FB58C1EABFBDAB1E300FAB4940
78745	GU46 6JX	GB	0101000020E6100000B39602D2FE87EABF1B1021AE9CAB4940
78746	GU46 6NG	GB	0101000020E610000098158A743FA7EABF736891ED7CAB4940
78747	GU46 7SG	GB	0101000020E6100000D6FD63213A84EABF6405BF0D31AC4940
78748	GU46 7TY	GB	0101000020E610000001C287122DF9EBBF24B726DD96AC4940
78749	GU46 7UW	GB	0101000020E61000008BF9B9A129BBEABFBC57AD4CF8AB4940
78750	GU47 0DZ	GB	0101000020E610000033A48AE255D6E8BFBC7A15191DAC4940
78751	GU47 0QF	GB	0101000020E6100000B891B245D2EEE8BFC3D32B6519AC4940
78752	GU47 0RE	GB	0101000020E610000094F6065F98CCE8BFF0FB372F4EAC4940
78753	GU47 0XR	GB	0101000020E610000088F546AD30FDE8BF2FC37FBA81AC4940
78754	GU47 4	GB	0101000020E6100000DFC14F1C40BFE9BF63450DA661AC4940
78755	GU47 8HE	GB	0101000020E6100000DC645419C6DDE9BF16A75A0BB3AC4940
78756	GU47 8LS	GB	0101000020E61000007EE02A4F20ECE9BFE4BF401020AD4940
78757	GU47 8NL	GB	0101000020E6100000A94D9CDCEFD0E9BFC619C39CA0AD4940
78758	GU5	GB	0101000020E61000007D3ECA880B40E1BFC9E53FA4DF984940
78759	GU5 0AX	GB	0101000020E6100000D1B2EE1F0BD1E1BFE883656CE8984940
78760	GU5 0HZ	GB	0101000020E6100000B22AC24D4695E1BF261B0FB6D8974940
78761	GU5 0PB	GB	0101000020E610000017D7F84CF64FE1BF28B9C32632994940
78762	GU5 0PG	GB	0101000020E6100000251FBB0B9494E1BF371AC05B20994940
78763	GU5 0SF	GB	0101000020E6100000A24621C9AC5EE1BF3735D07CCE994940
78764	GU5 0SU	GB	0101000020E610000038D73043E389DFBF92B3B0A71D964940
78765	GU5 0UA	GB	0101000020E61000006DE4BA29E5B5E0BF3E5B07077B974940
78766	GU5 9AG	GB	0101000020E6100000B7EEE6A90EB9DFBFAF5DDA70589C4940
78767	GU5 9DG	GB	0101000020E610000039D6C56D3480DEBFCA198A3BDE9A4940
78768	GU5 9JB	GB	0101000020E6100000D7851F9C4F1DDEBF92CA1473109C4940
78769	GU5 9JQ	GB	0101000020E6100000F67B629D2ADFDDBF696FF085C99A4940
78770	GU5 9LB	GB	0101000020E61000008EE9094B3CA0DCBF1FBB0B94149C4940
78771	GU5 9LS	GB	0101000020E6100000266E15C440D7DCBF641EF983819B4940
78772	GU5 9NX	GB	0101000020E6100000406CE9D1544FDCBF01BF4692209C4940
78773	GU5 9QG	GB	0101000020E6100000804413286211DDBFF7E6374C349A4940
78774	GU5 9QW	GB	0101000020E610000016DC0F786000DDBF4359F8FA5A994940
78775	GU5 9RL	GB	0101000020E6100000C0E95DBC1FB7DBBFDE3994A12A9C4940
78776	GU5 9RR	GB	0101000020E61000007CF2B0506B9ADCBF954737C2A2984940
78777	GU51	GB	0101000020E61000003AEB538EC9E2EABFCC24EA059FA44940
78778	GU51 1AJ	GB	0101000020E61000009A779CA223B9EBBF3B3AAE4676A54940
78779	GU51 1LE	GB	0101000020E61000009D2B4A09C12AEBBF7F4B00FE29A54940
78780	GU51 2TF	GB	0101000020E6100000EEB1F4A10B6AEABF962023A0C2A54940
78781	GU51 3AX	GB	0101000020E61000002E3C2F151B73EABF810706103EA44940
78782	GU51 3DB	GB	0101000020E6100000C573B680D07AEABFD82B2CB81FA44940
78783	GU51 3LL	GB	0101000020E6100000410E4A98697BEABFD49B51F355A44940
78784	GU51 3LN	GB	0101000020E6100000CA8AE1EA0088EABF9B559FABADA44940
78785	GU51 3LU	GB	0101000020E61000000DFCA886FD1EEBBF7461A417B5A34940
78786	GU51 3NF	GB	0101000020E6100000E222F77475C7EABF6DC9AA0837A34940
78787	GU51 3QF	GB	0101000020E6100000731074B4AAA5EABF4A79AD84EEA44940
78788	GU51 3QR	GB	0101000020E61000000805A568E55EEABF3F55850662A34940
78789	GU51 5NR	GB	0101000020E6100000B0928FDD054AEBBFE17CEA58A5A24940
78790	GU51 5SX	GB	0101000020E6100000494739984D80EBBFBF2A172AFFA04940
78791	GU51 5TS	GB	0101000020E6100000048D9944BD60EBBF78280AF489A24940
78792	GU52	GB	0101000020E6100000707D586FD48AEABFF224E99AC9A14940
78793	GU52 0XL	GB	0101000020E61000002579AEEFC341EBBF790261A758A14940
78794	GU52 5	GB	0101000020E61000007D3D5FB35C36EBBFF296AB1F9BA24940
78795	GU52 6AP	GB	0101000020E6100000E333D93F4F83EABF29AF95D05DA24940
78796	GU52 6DH	GB	0101000020E6100000A1BFD023464FEBBF2CF3565D87A04940
78797	GU52 6JL	GB	0101000020E6100000F0DFBC38F155EBBF99F1B6D26BA34940
78798	GU52 6LQ	GB	0101000020E610000091477023658BEABF7C9A931799A24940
78799	GU52 6PN	GB	0101000020E61000008AE76C01A1F5EABF99A0866F61A14940
78800	GU52 6PZ	GB	0101000020E6100000FF40B96DDF23EBBF938C9C853DA14940
78801	GU52 6RS	GB	0101000020E610000082531F48DE39EBBF1F1494A295A14940
78802	GU52 7SS	GB	0101000020E610000097361C9606FEEABF5B41D3122BA34940
78803	GU52 8DE	GB	0101000020E6100000E90DF7915B93EABF5C751DAA29A14940
78804	GU52 8EW	GB	0101000020E61000007E3672DD9472EABFBE11DDB3AEA14940
78805	GU52 8TH	GB	0101000020E610000045BC75FEEDB2EABF69FD2D01F8A14940
78806	GU53 7UX	GB	0101000020E61000005C77F35487DCEABF5682C5E1CCA14940
78807	GU6 7BL	GB	0101000020E61000001DE8A1B60DA3DEBF280CCA349A924940
78808	GU6 7BX	GB	0101000020E6100000A4C4AEEDED96DEBF01A60C1CD0924940
78809	GU6 7DF	GB	0101000020E610000006103E9468C9DEBF679AB0FD64924940
78810	GU6 7DH	GB	0101000020E6100000310BED9C6681DEBF1BB96E4A79934940
78811	GU6 7DW	GB	0101000020E61000001421753BFBCADDBF8E5C37A5BC924940
78812	GU6 7EF	GB	0101000020E61000009CA4F9635A9BDCBF3A07CF8426954940
78813	GU6 7EG	GB	0101000020E61000005FECBDF8A23DDEBF6EA12B11A8924940
78814	GU6 7EU	GB	0101000020E610000074999A046F48DEBF3083312251924940
78815	GU6 7NN	GB	0101000020E6100000916280441328DDBFA6EF3504C7954940
78816	GU6 7NP	GB	0101000020E610000052F355F2B1BBDCBF0B47904AB1954940
78817	GU6 7NS	GB	0101000020E61000009F008A912573DCBF8CF50D4C6E964940
78818	GU6 7NW	GB	0101000020E61000001E6B4606B98BDBBF71581AF851954940
78819	GU6 7PF	GB	0101000020E6100000C30DF8FC3042DDBF268A90BA9D934940
78820	GU6 8AJ	GB	0101000020E6100000E9D500A5A146DFBF39622D3E05924940
78821	GU6 8AS	GB	0101000020E6100000E8F527F1B913DFBF41F50F2219924940
78822	GU6 8DB	GB	0101000020E6100000D82AC1E270E6DEBF959BA8A5B9914940
78823	GU6 8DH	GB	0101000020E6100000A0C03BF9F4D8DEBF529E7939EC904940
78824	GU6 8DS	GB	0101000020E610000068244223D8B8DEBFABB2EF8AE0914940
78825	GU6 8JF	GB	0101000020E61000003C122F4FE78ADDBF6150A6D1E48A4940
78826	GU6 8JJ	GB	0101000020E610000067EF8CB62A09E1BF41B8020AF5924940
78827	GU6 8LH	GB	0101000020E6100000F52C08E57D1CE1BF8C3045B934924940
78828	GU6 8QJ	GB	0101000020E6100000A35A44149337DFBFECFA05BB61934940
78829	GU6 8RG	GB	0101000020E610000094FAB2B45373DFBF18963FDF16924940
78830	GU7	GB	0101000020E61000008AE6012CF2EBE3BF33164D6727974940
78831	GU7 1BQ	GB	0101000020E6100000E294B9F94674E3BF11A7936C75974940
78832	GU7 1BZ	GB	0101000020E6100000904946CEC29EE3BFAFCDC64ACC974940
78833	GU7 1DU	GB	0101000020E6100000C669882AFC99E3BFFD87F4DBD7974940
78834	GU7 1EN	GB	0101000020E6100000603AADDBA076E3BF4B02D4D4B2974940
78835	GU7 1EU	GB	0101000020E6100000BEA3C68498CBE3BF2C29779FE3974940
78836	GU7 1JU	GB	0101000020E610000011001C7BF65CE3BF48C49448A2974940
78837	GU7 1JY	GB	0101000020E6100000B804E09F5225E3BFF7E5CC7685984940
78838	GU7 1PW	GB	0101000020E610000029CFBC1C765FE3BF158F8B6A11974940
78839	GU7 1RG	GB	0101000020E61000009D9E776341E1E3BF438D429259974940
78840	GU7 1RS	GB	0101000020E610000047C7D5C8AEB4E3BF0CACE3F8A1964940
78841	GU7 1SY	GB	0101000020E610000031B77BB94F0EE4BFB9AB5791D1974940
78842	GU7 1TT	GB	0101000020E6100000263ACB2C4231E3BF17299485AF974940
78843	GU7 1XT	GB	0101000020E6100000B5DE6FB4E306E3BF2C11A8FE41984940
78844	GU7 2	GB	0101000020E61000003EB324404D2DE4BF97FE25A94C974940
78845	GU7 2HU	GB	0101000020E6100000C7DADFD91E3DE4BFB2648EE55D974940
78846	GU7 2JX	GB	0101000020E610000025085740A11EE4BF8F8AFF3BA2964940
78847	GU7 2NT	GB	0101000020E610000098DA5207793DE4BF5FEFFE78AF964940
78848	GU7 2PW	GB	0101000020E6100000373811FDDAFAE3BF718E3A3AAE984940
78849	GU7 2RW	GB	0101000020E610000048533D997F74E4BF99B7EA3A54994940
78850	GU7 3AG	GB	0101000020E6100000C5C9FD0E4581E3BFA16AF46A80984940
78851	GU7 3BT	GB	0101000020E6100000B323D5777ED1E2BFF0315871AA994940
78852	GU7 3BW	GB	0101000020E61000001DE4F56052FCE2BF992A1895D4994940
78853	GU7 3DJ	GB	0101000020E610000094D920938C1CE3BFF8C1F9D4B1984940
78854	GU7 3DU	GB	0101000020E6100000394371C79B7CE3BFFA0E7EE200984940
78855	GU7 3EU	GB	0101000020E6100000D7A19A92AC43E3BFF25B74B2D4984940
78856	GU7 3HA	GB	0101000020E6100000BCCD1B278579E3BF4221020EA1984940
78857	GU7 3JG	GB	0101000020E610000040A54A94BD25E3BF8D45D3D9C9984940
78858	GU7 3JP	GB	0101000020E61000009C69C2F69331E3BF9276A38FF9984940
78859	GU7 3NF	GB	0101000020E6100000C70DBF9B6E59E3BFBFEFDFBC38994940
78860	GU7 3PP	GB	0101000020E610000082380F27309DE3BF477364E597994940
78861	GU7 3PT	GB	0101000020E6100000D255BABBCE86E3BF0937195586994940
78862	GU7 3SW	GB	0101000020E610000035423F53AF5BE3BF548EC9E2FE994940
78863	GU7 3TF	GB	0101000020E6100000EC8497E0D487E3BF5F5E807D749A4940
78864	GU8	GB	0101000020E61000008578245E9E4EE5BFD6C56D3480954940
78865	GU8 4AA	GB	0101000020E6100000B952CF8250DEE2BFF6ED2422FC954940
78866	GU8 4DG	GB	0101000020E610000014EAE923F087E3BFD89B189293934940
78867	GU8 4DX	GB	0101000020E61000004EF04DD36707E4BF9510ACAA97914940
78868	GU8 4HL	GB	0101000020E6100000C24D469561DCE3BF221807978E914940
78869	GU8 4JN	GB	0101000020E6100000FF092E56D460E2BFD15966118A934940
78870	GU8 4LE	GB	0101000020E6100000454AB3791C06E2BF64C91CCBBB8E4940
78871	GU8 4RB	GB	0101000020E610000005C078060D7DE4BFFC1C1F2DCE8E4940
78872	GU8 4XS	GB	0101000020E6100000ADFBC7427488E2BF630CACE3F8914940
78873	GU8 5AD	GB	0101000020E61000009CC3B5DAC35EE4BF672AC423F1944940
78874	GU8 5EN	GB	0101000020E61000000B2593533BC3E4BF3DB665C059964940
78875	GU8 5LU	GB	0101000020E610000033897AC1A7B9E4BFE2C96E66F4934940
78876	GU8 5PH	GB	0101000020E6100000051A6CEA3CAAE4BFA77686A92D934940
78877	GU8 5PP	GB	0101000020E61000003DD2E0B6B6F0E4BF3E22A64412934940
78878	GU8 5QW	GB	0101000020E61000002AA73D25E7C4E4BFDC7F643A74944940
78879	GU8 5SW	GB	0101000020E6100000E78C28ED0DBEE4BFF2237EC51A924940
78880	GU8 5TJ	GB	0101000020E6100000535E2BA1BBA4E4BF321EA5129E904940
78881	GU8 5TL	GB	0101000020E610000048C5FF1D51A1E4BF7F86376BF0904940
78882	GU8 5TY	GB	0101000020E61000004DF564FED1B7E3BF331B649291914940
78883	GU8 6AE	GB	0101000020E6100000B8239C16BCE8E4BFB9E2E2A8DC984940
78884	GU8 6AH	GB	0101000020E61000003196E9978837E5BF29081EDFDE994940
78885	GU8 6BN	GB	0101000020E6100000F0315871AAB5E6BF522976340E974940
78886	GU8 6DR	GB	0101000020E6100000DF516342CCA5E6BF043BFE0B04974940
78887	GU8 6DS	GB	0101000020E6100000BE310400C79EE6BFEBFCDB65BF964940
78888	GU8 6EF	GB	0101000020E6100000054F2157EA59E6BFF4DE180280974940
78889	GU8 6HN	GB	0101000020E6100000601E32E54350E6BFF299EC9FA7974940
78890	GU8 6HP	GB	0101000020E610000083328D261763E6BF1B1021AE9C974940
78891	GU8 6LB	GB	0101000020E61000002426A8E15BD8E5BF274F594DD7974940
78892	GU8 6NW	GB	0101000020E6100000DE3829CC7B1CE6BFF850A2258F914940
78893	GU9	GB	0101000020E61000008CF678211D1EE9BF45D4449F8F9A4940
78894	GU9 0	GB	0101000020E6100000EEEA556474C0E9BF82035ABA829D4940
78895	GU9 0RA	GB	0101000020E61000007F6DFDF49F35E9BF213A048E049E4940
78896	GU9 0RE	GB	0101000020E6100000A933F790F03DE9BF5E0EBBEF189E4940
78897	GU9 0SJ	GB	0101000020E61000005853591476D1E9BF8D2441B8029E4940
78898	GU9 7BH	GB	0101000020E6100000FEB7921D1B01EABF3EB324404D9B4940
78899	GU9 7BT	GB	0101000020E6100000AED85F764F1EEABF8E03AF963B9B4940
78900	GU9 7JH	GB	0101000020E6100000A92F4B3B3597E9BF5DA79196CA9B4940
78901	GU9 7UF	GB	0101000020E6100000FB22A12DE752E9BFFCABC77DAB9B4940
78902	GU9 8	GB	0101000020E610000079CA6ABA9E68E9BF8995D1C8E7994940
78903	GU9 8AA	GB	0101000020E61000001B81785DBF60E9BFAA807B9E3F9B4940
78904	GU9 8AD	GB	0101000020E61000001F662FDB4E5BE9BF95BA641C239B4940
78905	GU9 8AJ	GB	0101000020E61000007DAD4B8DD04FE9BF5FD04202469B4940
78906	GU9 8BR	GB	0101000020E6100000F700DD97335BE9BFA0C1A6CEA39A4940
78907	GU9 8DL	GB	0101000020E610000056478E740646E9BFD6011077F59A4940
78908	GU9 8DY	GB	0101000020E6100000EA93DC611319E9BF725303CDE79A4940
78909	GU9 8HN	GB	0101000020E6100000FA2B64AE0C2AE9BFDBDFD91EBD994940
78910	GU9 8LQ	GB	0101000020E6100000DE04DF347D76E9BF83BF5FCC969A4940
78911	GU9 8LR	GB	0101000020E6100000E9B6442E3883E9BF2AA913D0449A4940
78912	GU9 8NU	GB	0101000020E610000086C8E9EBF99AE9BF663387A4169A4940
78913	GU9 8RN	GB	0101000020E6100000CA3505323B0BE9BFD82AC1E2709C4940
78914	GU9 8SF	GB	0101000020E610000003B34291EEE7E9BFD905836BEE984940
78915	GU9 8UG	GB	0101000020E61000002DEA93DC6113EABFE57CB1F7E2994940
78916	GU9 9BJ	GB	0101000020E6100000BFF2203D450EE9BFCF66D5E76A9D4940
78917	GU9 9BS	GB	0101000020E61000004E4700378B17E9BF4DBA2D910B9E4940
78918	GU9 9HS	GB	0101000020E610000074ED0BE885BBE8BF9E08E23C9C9E4940
78919	GU9 9LX	GB	0101000020E61000007AC8940F4155E8BF1B8524B37A9D4940
78920	GU9 9QF	GB	0101000020E61000000E30F31DFC44E9BF7D789620239C4940
78921	GU9 9QG	GB	0101000020E6100000D235936FB639E9BFB2852007259C4940
78922	GY1 1	GB	0101000020E6100000626534F2794504C09FABADD85FBA4840
78923	GY1 1JD	GB	0101000020E6100000D2C43BC0935604C09FE925C632BB4840
78924	GY5 7FP	GB	0101000020E6100000F1D7648D7AA804C05303CDE7DCBD4840
78925	HA0	GB	0101000020E610000017B83CD68C0CD4BFA7052FFA0AC84940
78926	HA0 1BW	GB	0101000020E6100000734BAB21718FD3BF394206F2ECC44940
78927	HA0 1LT	GB	0101000020E6100000DD5ED218ADA3D2BF23145B41D3C44940
78928	HA0 1NX	GB	0101000020E6100000804754A86E2ED2BF6745D4449FC54940
78929	HA0 2LA	GB	0101000020E6100000525F96766A2ED4BF38842A357BC64940
78930	HA0 2LW	GB	0101000020E610000054909F8D5C37D4BF79B29B19FDC64940
78931	HA0 3QX	GB	0101000020E6100000787B1002F225D4BF19ABCDFFABC84940
78932	HA0 3RB	GB	0101000020E6100000ED647094BC3AD4BFC05FCC96ACC84940
78933	HA0 4BN	GB	0101000020E610000016DBA4A2B1F6D2BF72C45A7C0AC64940
78934	HA0 4JL	GB	0101000020E6100000F59ECA694FC9D2BF52D66F26A6C54940
78935	HA0 4LL	GB	0101000020E61000009EEE3CF19C2DD3BF00AB23473AC54940
78936	HA1	GB	0101000020E6100000AB7823F3C81FD5BF37E0F3C308C94940
78937	HA1 1BB	GB	0101000020E61000003CBCE7C07284D5BF6380441328CA4940
78938	HA1 1SF	GB	0101000020E61000004818062CB98AD5BF8D9B1A683ECB4940
78939	HA1 1UA	GB	0101000020E6100000EF586C938AC6D5BFA86F99D365CB4940
78940	HA1 1UW	GB	0101000020E61000002D05A4FD0FB0D5BF3222516859CB4940
78941	HA1 1XU	GB	0101000020E6100000E57FF277EFA8D5BF44C02154A9CB4940
78942	HA1 2LX	GB	0101000020E6100000ED7E15E0BBCDD4BFF62686E464CA4940
78943	HA1 2TL	GB	0101000020E610000097033DD4B661D5BF7AA52C431CCB4940
78944	HA1 3EN	GB	0101000020E61000007BA4C16D6DE1D5BFC91EA16648C94940
78945	HA1 3HP	GB	0101000020E6100000F25B74B2D47AD5BF8CF2CCCB61C94940
78946	HA1 3LL	GB	0101000020E6100000E481C8224DBCD5BFF5F6E7A221C94940
78947	HA1 3QN	GB	0101000020E61000007730629F008AD5BFF032C34659C74940
78948	HA1 3RJ	GB	0101000020E6100000D32F116F9D7FD5BFFF756EDA8CC74940
78949	HA1 3RQ	GB	0101000020E610000062156F641EF9D5BFA88C7F9F71C74940
78950	HA1 3SE	GB	0101000020E6100000EFA99CF6949CD4BFCE8E54DFF9C74940
78951	HA1 3UQ	GB	0101000020E6100000CC9A58E02BBAD4BF1BBCAFCA85C84940
78952	HA1 3UX	GB	0101000020E610000000C45DBD8A8CD5BF560E2DB29DC74940
78953	HA1 4AH	GB	0101000020E610000002469737876BD6BF35423F53AFC94940
78954	HA1 4DR	GB	0101000020E610000045BB0A293FA9D3BFB0E595EB6DCB4940
78955	HA1 4ED	GB	0101000020E610000093C49272F739D6BF2A6F47382DCA4940
78956	HA1 4EJ	GB	0101000020E6100000910A630B410ED6BF3D2B69C537CA4940
78957	HA1 4EN	GB	0101000020E610000038F3AB394030D6BF7104A9143BCA4940
78958	HA1 4HD	GB	0101000020E6100000C18C2958E36CD6BFF6B2EDB435CA4940
78959	HA1 4HE	GB	0101000020E61000000E2C47C8409ED6BFF661BD512BCA4940
78960	HA1 4QT	GB	0101000020E610000038F7578FFB56D6BF3D29931ADACA4940
78961	HA1 4RL	GB	0101000020E61000008692C9A99D61D6BFE7C2482F6ACB4940
78962	HA1 4SZ	GB	0101000020E610000027F6D03E56F0D5BF4225AE635CCB4940
78963	HA1 4TA	GB	0101000020E6100000664F029B73F0D5BFC216BB7D56CB4940
78964	HA1 4TG	GB	0101000020E6100000BADDCB7D7214D6BFE754320054CB4940
78965	HA1 4TJ	GB	0101000020E61000007104A9143B1AD5BF4F965AEF37CA4940
78966	HA1 4TQ	GB	0101000020E610000073BED87BF145D6BF66F50EB743CB4940
78967	HA1 4UQ	GB	0101000020E6100000F46DC1525DC0D5BFEE26F8A6E9CB4940
78968	HA2	GB	0101000020E61000001BBCAFCA85CAD7BF4FCAA48636C84940
78969	HA2 0SN	GB	0101000020E6100000CAFCA36FD234D7BF69A7E67283C94940
78970	HA2 3ES	GB	0101000020E61000008E75711B0DE0D5BF963FDF162CC94940
78971	HA2 6LE	GB	0101000020E6100000B6B9313D6189D6BF42EDB776A2CC4940
78972	HA2 6NB	GB	0101000020E61000008EC8772975C9D6BF9335EA211ACD4940
78973	HA2 7BP	GB	0101000020E61000009F73B7EBA529D7BFC1E44691B5CA4940
78974	HA2 7EQ	GB	0101000020E6100000D6E6FF55478ED5BFF2EA1C03B2CB4940
78975	HA2 7LD	GB	0101000020E6100000D3F9F02C4146D7BF0E9E094D12CB4940
78976	HA2 7RB	GB	0101000020E6100000164F3DD2E0B6D7BF60048D9944CB4940
78977	HA2 8BT	GB	0101000020E61000001A8BA6B393C1D6BF2C11A8FE41C84940
78978	HA2 8HN	GB	0101000020E6100000C443183F8D7BD6BF89B14CBF44C84940
78979	HA2 8LD	GB	0101000020E6100000E36F7B82C476D6BF7FF78E1A13C84940
78980	HA2 8NU	GB	0101000020E61000006D3CD862B7CFD6BF998235CEA6C74940
78981	HA2 8NW	GB	0101000020E61000006D74CE4F711CD7BF4CC11A67D3C74940
78982	HA2 8QA	GB	0101000020E61000008484285FD042D7BF50C422861DC84940
78983	HA2 8RS	GB	0101000020E6100000BC0512143FC6D7BFE2AC889AE8C74940
78984	HA2 8SZ	GB	0101000020E610000095B54DF1B8A8D7BF27158DB5BFC74940
78985	HA2 8TY	GB	0101000020E6100000B5A50EF27A30D7BF916456EF70C74940
78986	HA2 9AP	GB	0101000020E61000000B5D8940F50FD8BF292504ABEAC74940
78987	HA2 9BP	GB	0101000020E6100000CFD72C978DCED7BFF7C9518028C84940
78988	HA2 9DL	GB	0101000020E6100000E8D9ACFA5C6DD7BFFFCA4A9352C84940
78989	HA2 9JE	GB	0101000020E610000034A2B437F8C2D7BF6DE34F5436C84940
78990	HA2 9RD	GB	0101000020E61000004D6551D845D1D7BF728BF9B9A1C94940
78991	HA3	GB	0101000020E6100000A9F6E978CC40D4BF0BD0B69A75CC4940
78992	HA3 0AA	GB	0101000020E6100000B75ED3838252D4BF17450F7C0CCA4940
78993	HA3 0AZ	GB	0101000020E61000006C787AA52C43D4BFDE04DF347DCA4940
78994	HA3 0HS	GB	0101000020E610000058AD4CF8A57ED3BF016BD5AE09CB4940
78995	HA3 0LR	GB	0101000020E610000025034015376ED3BFE2E5E95C51CA4940
78996	HA3 0LY	GB	0101000020E6100000772CB6494563D3BF292499D53BCA4940
78997	HA3 0NB	GB	0101000020E6100000161406651A4DD3BFDA006C4084CA4940
78998	HA3 0PS	GB	0101000020E6100000EE5BAD1397E3D2BF7B30293E3EC94940
78999	HA3 0UJ	GB	0101000020E61000000470B378B130D4BFF834272F32CB4940
79000	HA3 0UT	GB	0101000020E6100000AA99B51490F6D2BF2B6D718DCFCA4940
79001	HA3 5BP	GB	0101000020E610000098DEFE5C3464D5BF6F1283C0CACB4940
79002	HA3 5HR	GB	0101000020E6100000AFD2DD7536E4D5BF4548DDCEBECC4940
79003	HA3 5LF	GB	0101000020E6100000C6DD205A2BDAD5BF4D31074147CD4940
79004	HA3 6	GB	0101000020E610000017EFC7ED974FD2BF2A01310917CC4940
79005	HA3 6HZ	GB	0101000020E61000004EEE77280AF4D5BFCADDE7F868CD4940
79006	HA3 6JN	GB	0101000020E6100000A0C6BDF90D13D6BF562B137EA9CD4940
79007	HA3 6SB	GB	0101000020E61000002DEA93DC6113D6BF8B1BB7989FCF4940
79008	HA3 6TG	GB	0101000020E61000003143E38920CED5BFE7C75F5AD4CD4940
79009	HA3 8LF	GB	0101000020E61000005AB8ACC26680D4BFB30C71AC8BCB4940
79010	HA3 8LU	GB	0101000020E6100000EB6F09C03FA5D4BFC537143E5BCB4940
79011	HA3 8PB	GB	0101000020E6100000D13E56F0DB10D3BFA4C343183FCB4940
79012	HA3 8PT	GB	0101000020E6100000F73B1405FA44D4BF014D840D4FCB4940
79013	HA3 8QN	GB	0101000020E6100000C2887D022846D4BF0A4966F50ECD4940
79014	HA3 8TE	GB	0101000020E6100000085740A19E3ED4BF137CD3F4D9CB4940
79015	HA3 8TZ	GB	0101000020E6100000D5230D6E6B0BD3BF374F75C8CDCA4940
79016	HA3 9AJ	GB	0101000020E61000009835B1C05774D3BF01C0B167CFCB4940
79017	HA3 9HT	GB	0101000020E6100000F6D214014EEFD2BFF70489EDEECB4940
79018	HA3 9TP	GB	0101000020E6100000E597C1189128D2BFDBDD03745FCA4940
79019	HA4	GB	0101000020E6100000093719558671D9BF4277499C15C74940
79020	HA4 0TD	GB	0101000020E61000002E573F36C98FD9BFFDFA213658C84940
79021	HA4 0TS	GB	0101000020E6100000E3C281902C60D9BFADA580B4FFC74940
79022	HA4 0TW	GB	0101000020E61000002619390B7BDAD8BF22179CC1DFC74940
79023	HA4 6NG	GB	0101000020E6100000068541994693DABFADF886C267C74940
79024	HA4 6PU	GB	0101000020E610000018247D5A457FDABF69FE98D6A6C74940
79025	HA4 6PW	GB	0101000020E6100000AA0EB9196EC0DABFFA7E6ABC74C74940
79026	HA4 7DW	GB	0101000020E610000058AB764D486BDBBF452A8C2D04C94940
79027	HA4 7EF	GB	0101000020E61000008483BD892139DBBFF98557923CC94940
79028	HA4 7HX	GB	0101000020E6100000247F30F0DC7BDBBF9BE447FC8AC94940
79029	HA4 7HY	GB	0101000020E6100000315F5E807D74DBBF064A0A2C80C94940
79030	HA4 7LB	GB	0101000020E6100000CFF6E80DF791DBBF240B98C0ADC94940
79031	HA4 7QN	GB	0101000020E610000081B053AC1A84DBBF21CB82893FCA4940
79032	HA4 7UL	GB	0101000020E6100000D6AD9E93DE37DBBFDAA9B9DC60CA4940
79033	HA4 8AN	GB	0101000020E61000002A711DE38A8BDABFE1EB6B5D6ACA4940
79034	HA4 8PD	GB	0101000020E6100000A3E9EC647094D9BF4B598638D6C94940
79035	HA4 8SL	GB	0101000020E610000045BA9F53909FD9BF9ED0EB4FE2C94940
79036	HA4 8SN	GB	0101000020E6100000B91CAF40F4A4D9BF138255F5F2C94940
79037	HA4 8SW	GB	0101000020E6100000FF9600FC53AAD9BF8733BF9A03CA4940
79038	HA4 8SZ	GB	0101000020E6100000EED0B01875ADD9BFF1D8CF6229CA4940
79039	HA4 8TA	GB	0101000020E61000003831242713B7D9BFDEE8633E20CA4940
79040	HA4 8TB	GB	0101000020E6100000CC99ED0A7DB0D9BF5E9F39EB53CA4940
79041	HA4 8TE	GB	0101000020E6100000575F5D15A8C5D9BF9EEC66463FCA4940
79042	HA4 9AA	GB	0101000020E610000094A12AA6D24FDABF4ACFF41263C94940
79043	HA4 9AS	GB	0101000020E6100000745C8DEC4ACBD9BF74F04C6892C84940
79044	HA4 9QF	GB	0101000020E6100000971DE21FB6F4D8BFE831CA332FC94940
79045	HA5	GB	0101000020E6100000F2E9B12D03CED8BFA0FF1EBC76CB4940
79046	HA5 1NB	GB	0101000020E61000000589EDEE01BAD8BFF01989D008CA4940
79047	HA5 1NQ	GB	0101000020E6100000328FFCC1C073D8BF4DD7135D17CA4940
79048	HA5 1QG	GB	0101000020E610000051137D3ECA88D9BF82A966D652CA4940
79049	HA5 1QL	GB	0101000020E6100000871A8524B37AD9BF5F42058717CA4940
79050	HA5 1QR	GB	0101000020E61000000D6FD6E07D55DABFFBCA83F414CB4940
79051	HA5 1RF	GB	0101000020E61000008670CCB22781D9BFDB87BCE5EAC94940
79052	HA5 1RJ	GB	0101000020E610000069723106D671D9BFFAF19716F5C94940
79053	HA5 1RL	GB	0101000020E61000009CF9D51C2098D9BF17D68D7747CA4940
79054	HA5 1ST	GB	0101000020E610000082548A1D8D43D9BF79AD84EE92CA4940
79055	HA5 2BU	GB	0101000020E6100000511212691B7FD9BF05A6D3BA0DCC4940
79056	HA5 2DN	GB	0101000020E610000097E2AAB2EF8AD9BFEE7C3F355ECC4940
79057	HA5 2EX	GB	0101000020E6100000B48EAA2688BAD9BF29CFBC1C76CB4940
79058	HA5 2TD	GB	0101000020E61000005C59A2B3CC22D9BF3D0B42791FCB4940
79059	HA5 3EN	GB	0101000020E6100000247EC51A2E72D8BF6CEEE87FB9CC4940
79060	HA5 3SL	GB	0101000020E6100000F030ED9BFBABD9BFA532C51C04CD4940
79061	HA5 3XQ	GB	0101000020E6100000EAE8B81AD995D9BFC05DF6EB4ECD4940
79062	HA5 4AY	GB	0101000020E61000005DFDD8243FE2D6BF8C9E5BE84ACE4940
79063	HA5 4ER	GB	0101000020E61000005EA0A4C00298D7BFE71DA7E848CE4940
79064	HA5 4HU	GB	0101000020E6100000B91AD9959691D7BF72F8A41309CE4940
79065	HA5 4JG	GB	0101000020E6100000862172FA7ABED7BFC3BCC79926CE4940
79066	HA5 4NQ	GB	0101000020E6100000963E74417DCBD7BF34DB15FA60CD4940
79067	HA5 4RF	GB	0101000020E610000039F06AB93313D8BFFDBB3E73D6CD4940
79068	HA5 5AA	GB	0101000020E6100000B5A50EF27A30D8BF249C16BCE8C94940
79069	HA5 5BJ	GB	0101000020E6100000CAC4AD8218E8D7BF08E3A7716FCA4940
79070	HA5 5EG	GB	0101000020E6100000ED7DAA0A0DC4D7BF7E39B35DA1C94940
79071	HA5 5EN	GB	0101000020E61000008751103CBEBDD7BF9BA9108FC4C94940
79072	HA5 5NT	GB	0101000020E61000009CA5643909A5D7BF5E4BC8073DCB4940
79073	HA5 5PG	GB	0101000020E6100000067FBF982D59D8BF6BF12900C6CB4940
79074	HA5 5PJ	GB	0101000020E6100000A71FD4450A65D8BFBAF59A1E14CC4940
79075	HA6 1AU	GB	0101000020E61000006534F279C553DABF84D9041896CD4940
79076	HA6 1EB	GB	0101000020E61000004B5645B8C9A8DABF492C29779FCD4940
79077	HA6 1EH	GB	0101000020E6100000BD8A8C0E48C2DABF261B0FB6D8CD4940
79078	HA6 1HW	GB	0101000020E6100000C6DE8B2FDAE3DABFB6D782DE1BCD4940
79079	HA6 1RE	GB	0101000020E61000000F9D9E776341DABF82E673EE76CD4940
79080	HA6 1SP	GB	0101000020E6100000ECC039234A7BDABF8F705AF0A2CD4940
79081	HA6 2	GB	0101000020E6100000BDE3141DC9E5DBBFDE3AFF76D9CD4940
79082	HA6 2AA	GB	0101000020E6100000B37C5D86FF74DBBFEA03C93B87CE4940
79083	HA6 2BY	GB	0101000020E61000003C139A249694DBBFA99F3715A9CE4940
79084	HA6 2HT	GB	0101000020E6100000A818E76F4221DBBF17821C9430D14940
79085	HA6 2LP	GB	0101000020E6100000555051F52B9DDBBF91D5AD9E93D04940
79086	HA6 2RX	GB	0101000020E6100000465B9544F641DABFABB2EF8AE0CF4940
79087	HA6 3BE	GB	0101000020E6100000ADA7565F5D15DBBFCEE33098BFCE4940
79088	HA6 3HE	GB	0101000020E6100000A087DA368C82DABF05E10A28D4CF4940
79089	HA6 3HP	GB	0101000020E61000005645B8C9A832DABF554FE61F7DCF4940
79090	HA6 3NL	GB	0101000020E61000007D23BA675DA3DABFBE1589096ACE4940
79091	HA7	GB	0101000020E61000003D7FDAA84E07D5BF944C4EED0CCF4940
79092	HA7 1DA	GB	0101000020E6100000570A815CE2C8D2BFFDA19927D7CC4940
79093	HA7 2JS	GB	0101000020E6100000DD989EB0C403D4BF3C86C77E16CD4940
79094	HA7 3NR	GB	0101000020E61000002FDD24068195D4BF9B5AB6D617CF4940
79095	HA7 3PQ	GB	0101000020E6100000AC1A84B9DDCBD3BFF699B33EE5CE4940
79096	HA7 3PW	GB	0101000020E6100000CA1649BBD1C7D4BF520FD1E80ECE4940
79097	HA7 3RY	GB	0101000020E6100000CFF57D384888D4BF02F566D47CCF4940
79098	HA7 4BA	GB	0101000020E61000008F1A13622EA9D3BF9BCB0D863ACE4940
79099	HA7 4JU	GB	0101000020E6100000378E588B4F01D4BF8EEBDFF599CF4940
79100	HA7 4QR	GB	0101000020E6100000232C2AE27492D2BFE65B1FD61BCF4940
79101	HA7 4RF	GB	0101000020E610000018946934B918D3BFF38E537424CF4940
79102	HA7 4RG	GB	0101000020E610000081221631EC30D3BFA1A2EA573ACF4940
79103	HA8 0AD	GB	0101000020E6100000AEBB79AA436ED1BF9C6F44F7ACCD4940
79104	HA8 0HJ	GB	0101000020E610000022A98592C9A9D0BF32CB9E0436CD4940
79105	HA8 0PD	GB	0101000020E610000035423F53AF5BD0BF5D6DC5FEB2CD4940
79106	HA8 0RW	GB	0101000020E61000003C1570CFF3A7CDBFEBC9FCA36FCE4940
79107	HA8 5QX	GB	0101000020E6100000C2A4F8F884ECCEBF9E7E501729CE4940
79108	HA8 6NS	GB	0101000020E61000004F779E78CE16D1BF4F745DF8C1CD4940
79109	HA8 6PF	GB	0101000020E61000007F4FAC53E57BD2BF4CE3175E49CE4940
79110	HA8 6TQ	GB	0101000020E6100000F96A47718E3AD3BFD7D9907F66CE4940
79111	HA8 7JS	GB	0101000020E610000095826E2F698CD1BF62F6B2EDB4CD4940
79112	HA8 8PF	GB	0101000020E61000008202EFE4D363D1BF1B683EE76ECF4940
79113	HA8 8QJ	GB	0101000020E61000006ADFDC5F3DEED1BF5AF3E32F2DD04940
79114	HA8 8SP	GB	0101000020E61000001AFCFD62B664D1BFD8F15F2008D04940
79115	HA8 8YY	GB	0101000020E6100000C40B2252D32ED1BFB8CCE9B298D04940
79116	HA8 9EQ	GB	0101000020E6100000DD611399B9C0D0BF9D853DEDF0CD4940
79117	HA8 9HX	GB	0101000020E61000007F129F3BC1FED0BFC6866EF607CE4940
79118	HA8 9JN	GB	0101000020E6100000DA571EA4A7C8D0BF14E97E4E41CE4940
79119	HA8 9SW	GB	0101000020E61000001B0FB6D8EDB3D0BF7FDC7EF964CF4940
79120	HA9	GB	0101000020E6100000A226FA7C9411D3BF07CF842689C74940
79121	HA9 0RS	GB	0101000020E6100000A8C5E061DA37D2BF8962F20698C74940
79122	HA9 6BZ	GB	0101000020E6100000D50792770E65D2BFF7B0170AD8C64940
79123	HA9 6DE	GB	0101000020E6100000A69883A0A355D1BF14CD0358E4C54940
79124	HA9 7AJ	GB	0101000020E61000004E999B6F44F7D2BFFCE25295B6C64940
79125	HA9 7NT	GB	0101000020E61000003E9468C9E369D3BF41D829560DC84940
79126	HA9 7QX	GB	0101000020E6100000C6DCB5847CD0D2BF68E7340BB4C74940
79127	HA9 8BQ	GB	0101000020E6100000D0ED258DD13AD2BF392BA226FAC64940
79128	HA9 8JB	GB	0101000020E610000071FF91E9D0E9D1BF4DD7135D17C84940
79129	HA9 8RB	GB	0101000020E61000000458E4D70FB1D3BF3D80457EFDC84940
79130	HA9 8SG	GB	0101000020E6100000357BA01518B2D3BF98E0D40792C94940
79131	HA9 9AA	GB	0101000020E6100000F3C64961DEE3D1BFD55B035B25C84940
79132	HA9 9HD	GB	0101000020E6100000C72AA5677A89D1BF47020D3675C84940
79133	HA9 9QE	GB	0101000020E61000002272FA7ABE66D2BFFC3905F9D9C84940
79134	HA9 9QL	GB	0101000020E610000013B70A62A06BD2BF397CD28904C94940
79135	HA9 9SB	GB	0101000020E61000009622F94A2025D2BF81CF0F2384C94940
79136	HD1 1DD	GB	0101000020E610000067D65240DA7FFCBFBC202235EDD24A40
79137	HD1 1LB	GB	0101000020E61000000CB265F9BA8CFCBF014EEFE2FDD24A40
79138	HD1 3DH	GB	0101000020E6100000821B295B246DFCBF540262122ED24A40
79139	HD1 3DX	GB	0101000020E610000050560C570780FCBF1805C1E3DBD14A40
79140	HD1 3SJ	GB	0101000020E6100000B5C5353E93BDFCBF2827DA5548D14A40
79141	HD1 3SR	GB	0101000020E6100000406A1327F77BFCBFFBCC599F72D24A40
79142	HD1 3TZ	GB	0101000020E6100000BFBA2A508BC1FCBFC901BB9A3CD14A40
79143	HD1 3UB	GB	0101000020E6100000782AE09EE7CFFCBF0E2F88484DD14A40
79144	HD1 4ES	GB	0101000020E6100000A6F0A0D975AFFCBF3E40F7E5CCD24A40
79145	HD1 4JS	GB	0101000020E6100000211FF46C56FDFCBF88A06AF46AD24A40
79146	HD1 4LH	GB	0101000020E6100000C8CF46AE9BD2FCBF988A8D791DD34A40
79147	HD1 4NG	GB	0101000020E6100000E2AE5E454687FCBFFA28232E00D34A40
79148	HD1 4PF	GB	0101000020E610000040BD19355FE5FCBFD597A59D9AD34A40
79149	HD1 4PQ	GB	0101000020E61000004C33DDEBA4BEFCBFC078060DFDD34A40
79150	HD1 4QD	GB	0101000020E6100000A1DAE044F4EBFCBF6C94F59B89D34A40
79151	HD1 4QZ	GB	0101000020E61000006326512FF8B4FCBFE5D3635B06D44A40
79152	HD1 4UJ	GB	0101000020E6100000B03BDD79E2F9FCBF55C1A8A44ED24A40
79153	HD2	GB	0101000020E6100000FEBAD39D279EFCBF06A1BC8FA3D54A40
79154	HD2 1EG	GB	0101000020E61000002B14E97E4E41FCBFD6FD63213AD64A40
79155	HD2 1FF	GB	0101000020E610000060E63BF88903FCBF69E388B5F8D44A40
79156	HD2 1LX	GB	0101000020E6100000EBE0606F6208FCBFC03FA54A94D54A40
79157	HD2 1NH	GB	0101000020E6100000551344DD0760FCBF9E4319AA62D64A40
79158	HD2 2BQ	GB	0101000020E610000007D2C5A695C2FCBF8D47A98427D44A40
79159	HD2 2DL	GB	0101000020E6100000A81C93C5FDC7FCBF88F19A5775D44A40
79160	HD2 2NF	GB	0101000020E6100000A9FA95CE87A7FCBF2234828DEBD54A40
79161	HD2 2SW	GB	0101000020E6100000F1F44A5986B8FCBF9014916115D54A40
79162	HD2 2XQ	GB	0101000020E6100000F816D68D77C7FCBFB4E55C8AABD44A40
79163	HD3	GB	0101000020E6100000742843554C25FDBF22FAB5F5D3D34A40
79164	HD3 3AZ	GB	0101000020E61000001B1021AE9CFDFCBF5039268BFBD34A40
79165	HD3 3HN	GB	0101000020E61000006F2F698CD611FDBFE8DB82A5BAD44A40
79166	HD3 3HR	GB	0101000020E610000004C6FA062637FDBF08E57D1CCDD34A40
79167	HD3 3LA	GB	0101000020E61000004016A243E048FDBF2B84D558C2D44A40
79168	HD3 3SH	GB	0101000020E6100000465F419AB168FDBF6D58535914D44A40
79169	HD3 3TL	GB	0101000020E6100000718DCF64FF7CFDBFE1606F6248D44A40
79170	HD3 3YA	GB	0101000020E6100000D845D1031F83FDBF19C748F608D74A40
79171	HD3 4AE	GB	0101000020E6100000AD6D8AC745F5FCBFF5BBB0355BD34A40
79172	HD3 4EQ	GB	0101000020E61000006C7C26FBE729FDBF535E2BA1BBD24A40
79173	HD3 4FF	GB	0101000020E61000006AF7AB00DF2DFDBF23DA8EA9BBD24A40
79174	HD3 4PG	GB	0101000020E61000002D431CEBE236FDBF7FA65EB708D24A40
79175	HD3 4TU	GB	0101000020E61000008D2441B8028AFDBF7E5182FE42D34A40
79176	HD3 4UZ	GB	0101000020E6100000DA1EBDE13E72FDBF3AB01C2103D34A40
79177	HD4 5JR	GB	0101000020E6100000AF94658863DDFCBF0AF31E679AD04A40
79178	HD4 5NU	GB	0101000020E6100000D21BEE23B726FDBF041F8315A7D04A40
79179	HD4 5TN	GB	0101000020E6100000CCF10A444F4AFDBF7E6E68CA4ED14A40
79180	HD4 6SG	GB	0101000020E6100000401878EE3DDCFBBF9775FF5888D04A40
79181	HD4 6TZ	GB	0101000020E610000002F2255470F8FBBF8C135FED28CE4A40
79182	HD4 6UE	GB	0101000020E61000009ED2C1FA3F07FCBF045ABA826DCE4A40
79183	HD4 6XN	GB	0101000020E610000057410C74ED8BFBBFD925AAB706CC4A40
79184	HD4 7EA	GB	0101000020E61000005D18E945EDFEFCBFC5C6BC8E38CE4A40
79185	HD4 7HA	GB	0101000020E6100000AC376A85E9FBFCBF1D588E9081CE4A40
79186	HD4 7LP	GB	0101000020E61000008ECD8E54DFB9FCBF98E0D40792CF4A40
79187	HD4 7NG	GB	0101000020E6100000E2934E2498AAFCBF917C259012CF4A40
79188	HD5	GB	0101000020E61000000B462575029AFBBF179B560A81D44A40
79189	HD5 0PF	GB	0101000020E610000054909F8D5C77FBBF795DBF6037D44A40
79190	HD5 8BN	GB	0101000020E6100000F33977BB5E1AFCBF2FF834272FD24A40
79191	HD5 8JL	GB	0101000020E61000005CE674594C2CFCBF62F6B2EDB4D14A40
79192	HD5 8LP	GB	0101000020E6100000BBEF181EFB19FCBFAC38D55A98D14A40
79193	HD5 8PR	GB	0101000020E6100000B7D5AC33BEEFFBBF7BF99D2633D24A40
79194	HD5 8QT	GB	0101000020E6100000A1681EC022BFFBBF4EB9C2BB5CD24A40
79195	HD5 8XG	GB	0101000020E61000006CCB80B394ECFBBF4C16F71F99D04A40
79196	HD5 9JN	GB	0101000020E6100000A148F7730AF2FBBFF65E7CD11ED34A40
79197	HD6 1DH	GB	0101000020E6100000E2E47E87A280FCBF753C66A032DA4A40
79198	HD6 1HX	GB	0101000020E610000009E066F16261FCBF47C9AB730CDA4A40
79199	HD6 1LE	GB	0101000020E61000007BDD2230D677FCBF51F4C0C760D94A40
79200	HD6 1QW	GB	0101000020E61000004165FCFB8C4BFCBF8A20CEC309DA4A40
79201	HD6 1RZ	GB	0101000020E6100000FDBB3E73D667FCBFEBE1CB4411DA4A40
79202	HD6 2AE	GB	0101000020E610000047ACC5A70098FCBFA0A696ADF5D94A40
79203	HD6 3AG	GB	0101000020E61000000DE36E10AD95FCBFF59F353FFED84A40
79204	HD6 3LU	GB	0101000020E6100000C1C41F459DB9FCBF925D6919A9D74A40
79205	HD6 3NL	GB	0101000020E6100000D09849D40BBEFCBFC576F700DDD74A40
79206	HD6 3NU	GB	0101000020E6100000A96A82A8FBC0FCBF5AD6FD6321D84A40
79207	HD6 3PN	GB	0101000020E61000009E42AED4B3A0FCBFBABA63B14DD84A40
79208	HD6 3RY	GB	0101000020E6100000B515FBCBEE89FCBFD908C4EBFAD74A40
79209	HD6 3TG	GB	0101000020E6100000A01518B2BA55FCBF6DFFCA4A93D84A40
79210	HD6 3TN	GB	0101000020E610000066BD18CA8976FCBFE14389963CD84A40
79211	HD6 3UU	GB	0101000020E6100000DE567A6D3696FCBFCDAFE600C1D84A40
79212	HD6 3XB	GB	0101000020E6100000A54E401361C3FCBFAEF4DA6CACD84A40
79213	HD6 4BA	GB	0101000020E6100000F5BC1B0B0A83FCBF336FD575A8DA4A40
79214	HD6 4FW	GB	0101000020E61000005FD1ADD7F460FCBF4DF910548DDC4A40
79215	HD7	GB	0101000020E610000091D3D7F3358BFDBF5F44DB3175D14A40
79216	HD7 3LZ	GB	0101000020E6100000B9FB1C1F2D8EFDBF2BD9B11188D14A40
79217	HD7 4EA	GB	0101000020E6100000C6504EB4AB90FDBF99D4D00660D14A40
79218	HD7 4JN	GB	0101000020E61000000DA661F888D8FDBF4EB6813B50D14A40
79219	HD7 5DB	GB	0101000020E61000004F7633A31F0DFEBFFDF9B660A9D04A40
79220	HD7 5EB	GB	0101000020E610000024253D0CAD0EFEBF810871E5ECCF4A40
79221	HD7 5HP	GB	0101000020E61000002B1213D4F02DFEBFB4AF3C484FCF4A40
79222	HD7 5LS	GB	0101000020E610000079E9263108ECFDBF3C2D3F7095CF4A40
79223	HD7 5NG	GB	0101000020E610000074435376FA81FDBF908653E6E6CF4A40
79224	HD7 5QY	GB	0101000020E6100000C0CB0C1B657DFDBF97AE601BF1D04A40
79225	HD7 5RX	GB	0101000020E61000005456D3F54497FDBFD5D0066003D04A40
79226	HD7 5TN	GB	0101000020E6100000874ECFBBB1A0FDBFC91CCBBBEACF4A40
79227	HD7 6AX	GB	0101000020E61000005F9A22C0E9DDFEBF770FD07D39CD4A40
79228	HD7 6BJ	GB	0101000020E61000008CBAD6DEA76AFDBF027E8D2441D44A40
79229	HD7 6DH	GB	0101000020E610000084B872F6CEE8FEBF7F349C3237CD4A40
79230	HD7 6EP	GB	0101000020E61000001171732A19C0FEBF5E6397A8DECC4A40
79231	HD7 7AW	GB	0101000020E61000004F029B73F04CFCBFC7F319506FCC4A40
79232	HD8	GB	0101000020E6100000A08CF161F6F2FABF7905A22765CE4A40
79233	HD8 0AJ	GB	0101000020E6100000E63C635FB271FBBFF4328AE596D04A40
79234	HD8 8DB	GB	0101000020E610000003D19332A961FBBF519FE40E9BCA4A40
79235	HD8 8DJ	GB	0101000020E61000006F48A302275BFBBF6B7F677BF4CA4A40
79236	HD8 8DS	GB	0101000020E6100000D40B3ECDC94BFBBFAE10566309CB4A40
79237	HD8 8DU	GB	0101000020E6100000B1169F02603CFBBFE5EC9DD156CB4A40
79238	HD8 8HZ	GB	0101000020E61000003DF03158712AFBBFACC95356D3CB4A40
79239	HD8 8RX	GB	0101000020E61000005A9C31CC099AFABFF27D71A94AC94A40
79240	HD8 8SB	GB	0101000020E61000009B7631CD746FFABF508C2C9963C94A40
79241	HD8 8TB	GB	0101000020E61000007E552E54FE75FABF3EB48F15FCC84A40
79242	HD8 9	GB	0101000020E6100000B9AAECBB22B8F9BF6F2F698CD6CB4A40
79243	HD8 9EY	GB	0101000020E6100000C91CCBBBEA41FABF6138D73043CB4A40
79244	HD8 9LX	GB	0101000020E610000069C70DBF9BEEF9BF3B394371C7CB4A40
79245	HD8 9LZ	GB	0101000020E6100000CFBF5DF6EBCEF9BF15C78157CBCB4A40
79246	HD8 9PR	GB	0101000020E6100000569C6A2DCCC2F9BFD449B6BA9CCC4A40
79247	HD8 9PW	GB	0101000020E6100000E82E89B3226AFABFFA298E03AFCC4A40
79248	HD8 9QH	GB	0101000020E61000005039268BFBCFFABF0F971C774ACD4A40
79249	HD80 0HZ	GB	0101000020E61000007DAD4B8DD08FFBBF511212691BD14A40
79250	HD9 1AH	GB	0101000020E6100000967840D9946BFCBF5DF8C1F9D4C94A40
79251	HD9 1EE	GB	0101000020E61000001650A8A78F80FCBF47AAEFFCA2C84A40
79252	HD9 1HR	GB	0101000020E61000004FAC53E57B06FCBFF6D03E56F0C74A40
79253	HD9 1TE	GB	0101000020E61000004C546F0D6C15FCBFF2086EA46CC74A40
79254	HD9 1UQ	GB	0101000020E61000004A26A7768629FCBFF0694E5E64C84A40
79255	HD9 2LP	GB	0101000020E6100000DDB5847CD0F3FCBFB75D68AED3C84A40
79256	HD9 2NB	GB	0101000020E610000020274C18CDCAFCBFF0A31AF67BC84A40
79257	HD9 2NF	GB	0101000020E61000000729780AB912FDBF512FF83427C74A40
79258	HD9 2NH	GB	0101000020E610000068226C787A25FDBFF816D68D77C74A40
79259	HD9 2PY	GB	0101000020E610000008AA46AF06E8FCBF223317B83CC84A40
79260	HD9 2RL	GB	0101000020E6100000AA61BF27D6E9FCBF49145AD6FDC54A40
79261	HD9 2TA	GB	0101000020E61000005ABBED42735DFCBFB212F3ACA4C54A40
79262	HD9 3BP	GB	0101000020E61000003A02B859BC98FCBFC26856B60FC94A40
79263	HD9 3EF	GB	0101000020E6100000C93EC8B260A2FCBFFB912232ACCA4A40
79264	HD9 3EQ	GB	0101000020E6100000FA804067D2A6FCBF65FD6662BACA4A40
79265	HD9 4DQ	GB	0101000020E61000007A6D3656625EFDBFE17A14AE47CB4A40
79266	HD9 4HH	GB	0101000020E6100000B98C9B1A68BEFDBF481630815BCB4A40
79267	HD9 6GJ	GB	0101000020E6100000DCD6169E97CAFCBF0E87A5811FCD4A40
79268	HD9 6LE	GB	0101000020E6100000E65AB4006D6BFCBFCC272B86ABCD4A40
79269	HD9 6RL	GB	0101000020E61000002312859675BFFCBFD540F33977CB4A40
79270	HD9 7BT	GB	0101000020E6100000F4E0EEACDDF6FBBF6FF607CA6DC94A40
79271	HD9 7DF	GB	0101000020E61000006284F068E3C8FBBF5D6DC5FEB2CB4A40
79272	HD9 7EW	GB	0101000020E61000008C6A11514C5EFCBFEB55647440CC4A40
79273	HG1	GB	0101000020E610000009E066F162A1F8BFB16B7BBB25014B40
79274	HG1 1JA	GB	0101000020E61000009758198D7C9EF8BF50C24CDBBFFE4A40
79275	HG1 1LX	GB	0101000020E61000005B96AFCBF09FF8BFB74604E3E0FE4A40
79276	HG1 1TE	GB	0101000020E6100000A81E69705B9BF8BF6EC328081EFF4A40
79277	HG1 2BH	GB	0101000020E61000001C5C3AE63CE3F8BFDE54A4C2D8004B40
79278	HG1 2DY	GB	0101000020E610000014B01D8CD827F8BFD9EBDD1FEFFD4A40
79279	HG1 2EE	GB	0101000020E61000006D0377A04EB9F8BF92770E65A8004B40
79280	HG1 2EZ	GB	0101000020E61000002272FA7ABEE6F8BF25404D2D5BFF4A40
79281	HG1 2HE	GB	0101000020E6100000E8323509DE10F9BF548B8862F2FE4A40
79282	HG1 2HS	GB	0101000020E6100000CFBEF2203DC5F8BF8331225168FF4A40
79283	HG1 2HX	GB	0101000020E6100000D8B8FE5D9FB9F8BFEAAEEC82C1FF4A40
79284	HG1 2PH	GB	0101000020E61000003E5A9C31CCC9F8BFFF76D9AF3BFF4A40
79285	HG1 2SG	GB	0101000020E6100000D447E00F3FBFF8BF3E213B6F63FF4A40
79286	HG1 2SS	GB	0101000020E610000085CC9541B5C1F8BF427C60C77FFF4A40
79287	HG1 3AW	GB	0101000020E6100000C9224DBC03BCF8BFE23FDD4081014B40
79288	HG1 3EA	GB	0101000020E6100000CEE15AED616FF8BF6C938AC6DA014B40
79289	HG1 3HA	GB	0101000020E61000001CCF6740BD59F8BF4609FA0B3D024B40
79290	HG1 3HX	GB	0101000020E610000035289A07B0C8F8BFB939950C00014B40
79291	HG1 4	GB	0101000020E6100000AF601BF164F7F7BFC6DCB5847C004B40
79292	HG1 4AS	GB	0101000020E61000004BCADDE7F868F8BFCA1B60E63B004B40
79293	HG1 4AZ	GB	0101000020E6100000904B1C792072F8BF92E86514CBFF4A40
79294	HG1 4BW	GB	0101000020E610000088B839950C80F8BFB9533A58FFFF4A40
79295	HG1 4DW	GB	0101000020E6100000E99B340D8AE6F7BFCB11329067014B40
79296	HG1 4HR	GB	0101000020E61000003AE7A7380E7CF8BFAE0D15E3FCFF4A40
79297	HG1 4RU	GB	0101000020E61000008DD47B2AA73DF8BF1442075DC2FF4A40
79298	HG1 5HA	GB	0101000020E61000004983DBDAC2B3F8BFDF6B088ECB004B40
79299	HG1 5HB	GB	0101000020E610000008E929728878F8BFA0E062450D004B40
79300	HG1 5JA	GB	0101000020E61000003672DD94F29AF8BFD74E948444004B40
79301	HG1 5JB	GB	0101000020E6100000198D7C5EF194F8BF280D350A49004B40
79302	HG1 5JF	GB	0101000020E6100000003961C26896F8BFC119FCFD62004B40
79303	HG1 5JS	GB	0101000020E61000001840F850A2A5F8BF1155F833BCFF4A40
79304	HG1 5NG	GB	0101000020E610000056D3F544D785F8BF895DDBDB2DFF4A40
79305	HG1 5RH	GB	0101000020E6100000A12B11A8FE81F8BF8A58C4B0C3FE4A40
79306	HG1 5SP	GB	0101000020E6100000C2DF2F664B96F8BFBBD408FD4CFF4A40
79307	HG2	GB	0101000020E61000008E791D71C8C6F8BFB01EF7ADD6FD4A40
79308	HG2 0DR	GB	0101000020E6100000616F62484EA6F8BF5726FC523FFF4A40
79309	HG2 0DZ	GB	0101000020E6100000A3923A014DC4F8BFC3A04CA3C9FD4A40
79310	HG2 0LS	GB	0101000020E6100000F7E5CC7685BEF8BFC2120F289BFE4A40
79311	HG2 0NU	GB	0101000020E6100000DE550F9887CCF8BF573F36C98FFE4A40
79312	HG2 7EX	GB	0101000020E61000007FF78E1A13E2F7BFF1811DFF05004B40
79313	HG2 7JE	GB	0101000020E61000007CEF6FD05EFDF7BFA91611C5E4FF4A40
79314	HG2 7RL	GB	0101000020E610000053EC681CEA37F8BFE50AEF7211FF4A40
79315	HG2 8BT	GB	0101000020E61000009D4CDC2A8881F8BFC6FD47A643FD4A40
79316	HG2 8JL	GB	0101000020E61000009C6B98A1F184F8BF2FDD240681FD4A40
79317	HG2 8NE	GB	0101000020E6100000BBED42739D46F8BF6404543882FE4A40
79318	HG2 8NS	GB	0101000020E6100000ED832C0B263EF8BF7BBE66B96CFE4A40
79319	HG2 8QT	GB	0101000020E6100000D2FD9C82FC6CF8BF44FB58C16FFD4A40
79320	HG2 8RE	GB	0101000020E61000003EE8D9ACFA5CF8BF3E5B07077BFD4A40
79321	HG2 9AY	GB	0101000020E6100000B6F292FFC99FF8BFDFBF7971E2FD4A40
79322	HG2 9LP	GB	0101000020E6100000BD5301F73CBFF8BF487023658BFC4A40
79323	HG2 9PA	GB	0101000020E6100000747E8AE3C0ABF8BFA1BB24CE8AFC4A40
79324	HG3 1EX	GB	0101000020E6100000DECB7D721460F8BFF373435376FA4A40
79325	HG3 1JZ	GB	0101000020E610000052D7DAFB5495F8BFC91F0C3CF7FA4A40
79326	HG3 1LL	GB	0101000020E61000009012BBB6B7DBF7BF1CD13DEB1AFD4A40
79327	HG3 1NF	GB	0101000020E61000007286E28E37B9F7BF66BFEE74E7FB4A40
79328	HG3 1NX	GB	0101000020E61000000ABB287AE0E3F8BF0F2BDCF291FA4A40
79329	HG3 1QB	GB	0101000020E610000080D3BB783F2EF9BF7BA35698BEFD4A40
79330	HG3 1QQ	GB	0101000020E61000009BE3DC26DC2BF9BF5858703FE0FB4A40
79331	HG3 1RY	GB	0101000020E6100000B37DC85BAEFEF8BFAB05F69848FD4A40
79332	HG3 1RZ	GB	0101000020E61000004E417E36721DF9BFF54718062CFD4A40
79333	HG3 2DG	GB	0101000020E6100000670E492D940CF9BF471E882CD2024B40
79334	HG3 2DW	GB	0101000020E6100000AA656B7D9110F9BF1EDC9DB5DB024B40
79335	HG3 2GP	GB	0101000020E61000009EEFA7C64B77F9BF0B0BEE073C024B40
79336	HG3 2JE	GB	0101000020E610000043E73576892AFABF713B342C46034B40
79337	HG3 2JG	GB	0101000020E6100000B7B41A12F758FABFDB8827BB99034B40
79338	HG3 2JZ	GB	0101000020E6100000077B13437232FABF259694BBCF014B40
79339	HG3 2ND	GB	0101000020E61000007BC1A7397991FABF7E1CCD9195054B40
79340	HG3 3AB	GB	0101000020E61000007C5F5CAAD296F9BFC26C020CCB034B40
79341	HG3 3AG	GB	0101000020E61000001E15FF774405FABF4F7974232C044B40
79342	HG3 3AY	GB	0101000020E6100000EFE192E34E29F9BF105D50DF32054B40
79343	HG3 3BB	GB	0101000020E61000001349F4328AE5F8BF8FA850DD5C044B40
79344	HG3 3HA	GB	0101000020E6100000CF328B506CC5FABF6A317898F6074B40
79345	HG3 3RU	GB	0101000020E6100000D07CCEDDAE17F8BF207EFE7BF0084B40
79346	HG3 3TJ	GB	0101000020E6100000077C7E1821FCF7BF85949F54FB084B40
79347	HG3 4DW	GB	0101000020E6100000016DAB5967FCFABF1FBAA0BE650A4B40
79348	HG3 4EL	GB	0101000020E61000007841446ADA45FBBFEEB5A0F7C6064B40
79349	HG3 4HY	GB	0101000020E61000000E87A5811F15FBBF32CA332F87074B40
79350	HG3 5DT	GB	0101000020E61000002A1900AAB8B1FBBF9FABADD85F0A4B40
79351	HG3 5HG	GB	0101000020E61000006284F068E348FCBF684128EFE30A4B40
79352	HG3 5LQ	GB	0101000020E6100000F7E978CC4025FCBFE9D32AFA430B4B40
79353	HG3 5PG	GB	0101000020E610000096253ACB2C02FCBF5C1D0071570B4B40
79354	HG3 5RZ	GB	0101000020E61000005E49F25CDF87FDBFB000A60C1C144B40
79355	HG3 5SY	GB	0101000020E610000094A3005130E3FDBF0C569C6A2D144B40
79356	HG4 1BE	GB	0101000020E6100000AE282504AB6AF8BFE6B1666490114B40
79357	HG4 1BG	GB	0101000020E61000005CE674594C6CF8BFFC5580EF36114B40
79358	HG4 1ET	GB	0101000020E6100000EA08E066F162F8BF50C422861D124B40
79359	HG4 1JR	GB	0101000020E61000008A3E1F65C445F8BF7B849A2155124B40
79360	HG4 1QT	GB	0101000020E61000006DC9AA083759F8BF813E912749114B40
79361	HG4 1QW	GB	0101000020E6100000C91EA1664855F8BFE4D6A4DB12114B40
79362	HG4 1SD	GB	0101000020E6100000A56950340F60F8BFBF7D1D3867104B40
79363	HG4 1SN	GB	0101000020E610000076711B0DE06DF8BFD482177D05114B40
79364	HG4 1SQ	GB	0101000020E6100000D80B056C0763F8BFC3D8429083104B40
79365	HG4 2JF	GB	0101000020E6100000706072A3C89AF8BF5740A19E3E104B40
79366	HG4 2PD	GB	0101000020E610000022E3512AE189F8BFFDBB3E73D60F4B40
79367	HG4 2RD	GB	0101000020E6100000751F80D426CEF8BF721AA20A7F124B40
79368	HG4 2RZ	GB	0101000020E61000009DD7D825AA77F8BF7C992842EA0E4B40
79369	HG4 3NJ	GB	0101000020E610000071E5EC9DD1D6F9BF78D503E621134B40
79370	HG4 3SR	GB	0101000020E6100000278925E5EE73F8BFB933130CE7104B40
79371	HG4 4PW	GB	0101000020E6100000F372D87DC7B0FBBF02452C62D81F4B40
79372	HG4 5DP	GB	0101000020E610000069A7E6728321F8BFEC134031B2124B40
79373	HG41 1HS	GB	0101000020E610000014CD0358E457F8BF5C8FC2F528124B40
79374	HG5	GB	0101000020E610000049F3C7B4360DF7BFD2A755F487024B40
79375	HG5 0AD	GB	0101000020E61000004696CCB1BC6BF7BFDCD5ABC8E8004B40
79376	HG5 0AT	GB	0101000020E61000001711C5E40DB0F6BF3E0455A357014B40
79377	HG5 0BE	GB	0101000020E6100000B0E600C11C3DF7BF4FB0FF3A37014B40
79378	HG5 0BZ	GB	0101000020E6100000CCED5EEE9363F7BF7A19C5724B014B40
79379	HG5 0DD	GB	0101000020E6100000817687140364F7BF766C04E275014B40
79380	HG5 0HQ	GB	0101000020E6100000B37DC85BAE3EF7BFF35487DC0C014B40
79381	HG5 0NB	GB	0101000020E6100000E8C072840C64F7BFE3FBE25295024B40
79382	HG5 0NN	GB	0101000020E61000004D9EB29AAE67F7BF670FB40243024B40
79383	HG5 0QU	GB	0101000020E6100000D9B3E7323589F6BFC4EC65DB69054B40
79384	HG5 0RP	GB	0101000020E6100000FE9B1727BE5AF6BF1CB1169F02024B40
79385	HG5 8EZ	GB	0101000020E6100000FC51D4997B48F7BF0588821953004B40
79386	HG5 8HY	GB	0101000020E6100000F67D38488872F7BF46EC134031004B40
79387	HG5 8JY	GB	0101000020E6100000A054FB743CA6F7BF575F5D15A8FF4A40
79388	HG5 8LQ	GB	0101000020E610000039252026E142F7BF7E3672DD94004B40
79389	HG5 9AA	GB	0101000020E61000009240834D9D87F7BF0938842A35014B40
79390	HG5 9BB	GB	0101000020E6100000FC1A49827085F7BF59FB3BDBA3014B40
79391	HG5 9ES	GB	0101000020E610000058207A522675F7BF62C092AB58024B40
79392	HG5 9LZ	GB	0101000020E6100000D40D147827DFF7BF5663096B63024B40
79393	HG5 9ND	GB	0101000020E61000001230BABC391CF8BF390CE6AF90034B40
79394	HP1	GB	0101000020E61000009B02999D45EFDDBFF2ED5D83BEDE4940
79395	HP1 1HH	GB	0101000020E6100000E6CE4C309C6BDEBF3A3DEFC682E04940
79396	HP1 1HP	GB	0101000020E6100000E38C614ED026DFBF1366DAFE95DF4940
79397	HP1 1JT	GB	0101000020E61000002995F0845E7FDEBF6D1FF296ABDF4940
79398	HP1 1PE	GB	0101000020E6100000BD1AA034D428DFBFE6E5B0FB8EDF4940
79399	HP1 1QD	GB	0101000020E6100000414640852348DFBFAABA473657DF4940
79400	HP1 1RP	GB	0101000020E6100000E9D495CFF23CDFBFB24CBF44BCDF4940
79401	HP1 1RZ	GB	0101000020E61000003F3A75E5B33CDFBF9B215514AFE04940
79402	HP1 2JD	GB	0101000020E6100000A8902BF52C08E0BF2B4CDF6B08E04940
79403	HP1 2RL	GB	0101000020E6100000FC389A232BBFE0BF938C9C853DDF4940
79404	HP1 3AT	GB	0101000020E61000001363997E8978DEBFD881734694E24940
79405	HP1 3BH	GB	0101000020E6100000068541994613E0BF51888043A8E44940
79406	HP1 3DT	GB	0101000020E6100000BB473657CDF3E0BF06D49B51F3DF4940
79407	HP1 3ND	GB	0101000020E610000028D53E1D8F19DFBFFAB31F2922DF4940
79408	HP10	GB	0101000020E6100000AA9ECC3FFAA6E5BF2DD1596611D24940
79409	HP10 0DJ	GB	0101000020E61000004371C79BFC16E6BF014D840D4FCD4940
79410	HP10 0DL	GB	0101000020E6100000DAAA24B20F32E6BFC05E61C1FDCC4940
79411	HP10 0JX	GB	0101000020E6100000A79201A08A1BE6BF3A90F5D4EACD4940
79412	HP10 0NG	GB	0101000020E61000001781B1BE81C9E5BF64C91CCBBBCC4940
79413	HP10 0NQ	GB	0101000020E6100000C32ADEC83CF2E5BFF64201DBC1CE4940
79414	HP10 8BX	GB	0101000020E6100000404E98309A95E6BF7D5BB05417D24940
79415	HP10 9BY	GB	0101000020E610000096236420CFAEE6BF70D234289ACD4940
79416	HP10 9DZ	GB	0101000020E6100000DD94F25A09DDE6BFF1F274AE28CD4940
79417	HP10 9HA	GB	0101000020E61000006B7EFCA545FDE6BF7B698A00A7CD4940
79418	HP10 9JJ	GB	0101000020E610000005E10A28D453E6BF145E82531FCC4940
79419	HP10 9RL	GB	0101000020E6100000D1782288F370E6BFCCF10A444FCE4940
79420	HP11	GB	0101000020E6100000AF5A99F04BFDE7BFA661F88898D04940
79421	HP11 1	GB	0101000020E6100000CEC3094CA775E7BFAE0E80B8ABCF4940
79422	HP11 1JG	GB	0101000020E61000000DAB7823F3C8E6BFD503E62153CE4940
79423	HP11 1PL	GB	0101000020E610000084D90418963FE8BF572426A8E1CD4940
79424	HP11 1XA	GB	0101000020E61000000EA14ACD1EE8E6BFC2C073EFE1CE4940
79425	HP11 2TJ	GB	0101000020E6100000037D224F922EE8BFC0594A9693D04940
79426	HP11 2TN	GB	0101000020E6100000C8EC2C7AA782E8BFB2B96A9E23D04940
79427	HP11 2TX	GB	0101000020E6100000554D10751F00E8BF812381069BD04940
79428	HP11 2UW	GB	0101000020E6100000698CD651D504E8BFFDDCD0949DD04940
79429	HP12	GB	0101000020E6100000D21C59F96530E8BF018A912573CE4940
79430	HP12 3HU	GB	0101000020E6100000A741D13C80C5E8BF43739D465AD04940
79431	HP12 4JF	GB	0101000020E6100000437573F1B73DE9BF58AD4CF8A5D04940
79432	HP12 4NX	GB	0101000020E6100000F60CE19865CFE8BFD68EE21C75CE4940
79433	HP12 4PS	GB	0101000020E6100000373465A71FD4E8BF76E272BC02CF4940
79434	HP13	GB	0101000020E610000073D6A71C93C5E6BFA872DA5372D04940
79435	HP13 5	GB	0101000020E6100000B75D68AED348E8BFE4DA5031CED14940
79436	HP13 5AE	GB	0101000020E610000079758E01D96BE7BF344C6DA983D24940
79437	HP13 5HD	GB	0101000020E6100000BD55D7A19A12E8BFE4310395F1D14940
79438	HP13 5HS	GB	0101000020E6100000FBAE08FEB712E8BF5D514A0856D14940
79439	HP13 5HZ	GB	0101000020E61000005ED905836BEEE8BFF6436CB070D24940
79440	HP13 5JX	GB	0101000020E610000059198D7C5EF1E8BF04711E4E60D24940
79441	HP13 5NN	GB	0101000020E61000004B94BDA59C2FECBF4D81CCCEA2D54940
79442	HP13 5UG	GB	0101000020E610000006BD37860060E9BF4F3DD2E0B6D44940
79443	HP13 5YX	GB	0101000020E61000000A0F9A5DF756E8BFCD3FFA264DD14940
79444	HP13 6HW	GB	0101000020E6100000C9772975C9B8E7BF99F38C7DC9D04940
79445	HP13 6JP	GB	0101000020E6100000E607AEF20442E7BF24B4E55C8AD14940
79446	HP13 6JX	GB	0101000020E61000006D1D1CEC4D8CE7BF6A6AD95A5FD24940
79447	HP13 6NN	GB	0101000020E61000007D410B0918DDE7BF11E4A08499D04940
79448	HP13 6QT	GB	0101000020E610000027BEDA519CA3E7BFADC266800BD24940
79449	HP13 6QX	GB	0101000020E6100000FF959526A5A0E7BFDD24068195D14940
79450	HP13 6XG	GB	0101000020E61000008B16A06D356BE7BF144031B264D04940
79451	HP13 6XJ	GB	0101000020E6100000E71BD13DEB9AE7BF122F4FE78AD04940
79452	HP13 7BD	GB	0101000020E6100000D7DAFB54159AE6BF06D50627A2CF4940
79453	HP13 7BL	GB	0101000020E6100000537765170CAEE6BF617138F3ABD14940
79454	HP13 7EY	GB	0101000020E61000005793A7ACA6EBE6BFE5F0492712D04940
79455	HP13 7HD	GB	0101000020E6100000E3AAB2EF8AE0E6BF4145D5AF74D04940
79456	HP13 7NN	GB	0101000020E6100000D655815A0C1EE7BFD74FFF59F3CF4940
79457	HP14	GB	0101000020E61000005930F1475167EABF4450357A35D84940
79458	HP14 3AJ	GB	0101000020E610000092EA3BBF28C1E9BF36AD1402B9D24940
79459	HP14 3PL	GB	0101000020E61000009BCB0D863AACEBBF8FC6A17E17D04940
79460	HP14 3PX	GB	0101000020E610000000917EFB3AF0ECBF56D80C7041D44940
79461	HP14 3QR	GB	0101000020E6100000B398D87C5C9BECBFD1AFAD9FFED34940
79462	HP14 3RP	GB	0101000020E610000084BD89213999ECBFC3BCC79926D44940
79463	HP14 3TJ	GB	0101000020E61000002A55A2EC2DE5ECBFB64DF1B8A8D44940
79464	HP14 3XF	GB	0101000020E6100000CF4D9B711AA2EBBFD6743DD175D34940
79465	HP14 3XQ	GB	0101000020E6100000FAB7CB7EDDE9EBBF207A522635D44940
79466	HP14 4AJ	GB	0101000020E6100000A54929E8F612EBBF0211E2CAD9D54940
79467	HP14 4LB	GB	0101000020E61000000249D8B79308E8BFB760A92EE0D34940
79468	HP14 4LJ	GB	0101000020E6100000A1DAE044F46BEABFEDF0D7648DD64940
79469	HP14 4LL	GB	0101000020E610000030BB270F0B35E8BF4301DBC188D54940
79470	HP14 4LN	GB	0101000020E61000007FC2D9AD6532E8BFE78EFE976BD54940
79471	HP14 4LW	GB	0101000020E6100000158C4AEA04B4E7BF9831056B9CD54940
79472	HP14 4LX	GB	0101000020E6100000B612BA4BE22CE8BFBFB9BF7ADCD54940
79473	HP14 4PG	GB	0101000020E6100000D0D38041D227E8BF8DEDB5A0F7D44940
79474	HP15	GB	0101000020E610000075779D0DF967E6BF8E0244C18CD54940
79475	HP15 6BX	GB	0101000020E6100000284701A260C6E6BFFE60E0B9F7D44940
79476	HP15 6BZ	GB	0101000020E61000001E15FF774405E7BFADFA5C6DC5D44940
79477	HP15 6EZ	GB	0101000020E6100000E22021CA1734E6BF217711A628D54940
79478	HP15 6HW	GB	0101000020E6100000630D17B9A72BE7BFFD101B2C9CD64940
79479	HP15 6HX	GB	0101000020E6100000E8887C975217E7BFFC6D4F90D8D64940
79480	HP15 6RF	GB	0101000020E6100000DB1324B6BB07E6BFA35A441493D54940
79481	HP15 6UA	GB	0101000020E6100000195586713788E6BF8B8C0E48C2D44940
79482	HP15 7DT	GB	0101000020E6100000297AE063B0E2E6BF5039268BFBD34940
79483	HP15 7JW	GB	0101000020E6100000711E4E603AADE6BFE57B462234D44940
79484	HP15 7PG	GB	0101000020E6100000C93EC8B26062E6BF1E705D3123D24940
79485	HP15 7RB	GB	0101000020E6100000957EC2D9ADE5E6BF0A48FB1F60D34940
79486	HP16	GB	0101000020E61000001A87FA5DD89AE6BF62BCE6559DD94940
79487	HP16 0DF	GB	0101000020E6100000A24621C9AC5EE6BFEF3A1BF2CFD84940
79488	HP16 0EZ	GB	0101000020E6100000D3C1FA3F8779E6BF4F5C8E5720D84940
79489	HP16 0HD	GB	0101000020E610000098C1189128B4E6BF672618CE35D84940
79490	HP16 0HH	GB	0101000020E6100000768C2B2E8E4AE7BF3A3FC571E0D74940
79491	HP16 0HJ	GB	0101000020E61000003813D385587DE7BF876D8B321BD84940
79492	HP16 0LD	GB	0101000020E610000085D041977068E7BFD5928E7230D94940
79493	HP16 0RG	GB	0101000020E6100000F86F5E9CF86AE5BF64E94317D4D94940
79494	HP16 9AZ	GB	0101000020E6100000B742588D25ACE6BFDCF5D21401DA4940
79495	HP16 9BL	GB	0101000020E6100000ED116A8654D1E6BF2BC1E270E6D94940
79496	HP16 9DS	GB	0101000020E610000099D711876CA0E7BFFD304278B4D94940
79497	HP16 9HF	GB	0101000020E61000009C6A2DCC42BBE7BF4E4700378BD94940
79498	HP16 9JY	GB	0101000020E6100000CD3AE3FBE2D2E5BF6F2BBD361BDD4940
79499	HP16 9QJ	GB	0101000020E6100000CB2F833122D1E5BF073F7100FDDA4940
79500	HP16 9QY	GB	0101000020E61000005111A7936CF5E7BF84D89942E7D94940
79501	HP17	GB	0101000020E610000081AFE8D66BFAEDBF7C5F5CAAD2E24940
79502	HP17 0XP	GB	0101000020E61000005FB2F1608BDDE9BF3BAC70CB47E04940
79503	HP17 8AD	GB	0101000020E6100000C3499A3FA6B5EDBF5517F032C3E24940
79504	HP17 8BG	GB	0101000020E6100000026729594EC2EDBFA05225CADEE24940
79505	HP17 8EP	GB	0101000020E610000060AC6F607223EEBF871A8524B3E24940
79506	HP17 8EX	GB	0101000020E610000094FAB2B453F3EDBFD25625917DE24940
79507	HP17 8JP	GB	0101000020E6100000D4635B069CA5EDBF7E39B35DA1E34940
79508	HP17 8PY	GB	0101000020E61000005FECBDF8A2BDEBBF2524D236FEE64940
79509	HP17 8QN	GB	0101000020E6100000116E32AA0CE3EABF77BCC96FD1E54940
79510	HP17 8SH	GB	0101000020E6100000B2D5E5948098EABF618C48145AE44940
79511	HP17 8UL	GB	0101000020E6100000598B4F01309EECBF971C774A07E54940
79512	HP18	GB	0101000020E6100000D5230D6E6B8BECBF82751C3F54EA4940
79513	HP18 0	GB	0101000020E610000095D40968222CF0BF2CD8463CD9F14940
79514	HP18 0AB	GB	0101000020E61000009DA04D0E9FF4ECBFCDACA580B4E74940
79515	HP18 0AN	GB	0101000020E6100000122EE411DCC8EDBFD7DCD1FF72E54940
79516	HP18 0BU	GB	0101000020E61000008FC536A968ACEEBF87A4164A26E54940
79517	HP18 0JA	GB	0101000020E61000000AA2EE03905AEDBF90BFB4A84FEC4940
79518	HP18 0NS	GB	0101000020E6100000E71A66683C91EEBF4CE2AC889AEC4940
79519	HP18 0RA	GB	0101000020E61000006CEC12D55B03F0BF8813984EEBEE4940
79520	HP18 0RB	GB	0101000020E61000007D2079E75006F0BF71C806D2C5EE4940
79521	HP18 9AN	GB	0101000020E610000001344A97FEA5EFBFD4D2DC0A61E34940
79522	HP18 9ED	GB	0101000020E6100000FF9254A69803F0BFA912656F29E34940
79523	HP18 9HY	GB	0101000020E6100000FBE8D495CFF2F0BFF7E978CC40E14940
79524	HP18 9JD	GB	0101000020E6100000240B98C0ADFBF0BFFC372F4E7CE14940
79525	HP18 9SG	GB	0101000020E61000004E4700378BD7F0BF293E3E213BE74940
79526	HP18 9SU	GB	0101000020E61000003D98141F9FD0F0BF8FC360FE0AE94940
79527	HP18 9TQ	GB	0101000020E6100000954737C2A2E2F0BFD845D1031FE94940
79528	HP18 9UX	GB	0101000020E6100000F67F0EF3E585F1BF79CBD58F4DEA4940
79529	HP19	GB	0101000020E6100000471D1D57233BEABFA306D3307CE84940
79530	HP19 0FX	GB	0101000020E6100000BDE2A9471ADCE9BFCB85CABF96E94940
79531	HP19 7FS	GB	0101000020E610000085B01A4B589BEABF93FDF33460E84940
79532	HP19 7GW	GB	0101000020E61000001EC4CE143AAFEABF1CB62DCA6CE84940
79533	HP19 8AD	GB	0101000020E6100000FBB1497EC42FEABFAF44A0FA07E94940
79534	HP19 8EB	GB	0101000020E61000000B62A06B5F40EABF300DC347C4E84940
79535	HP19 8JB	GB	0101000020E610000095456117458FEABF438D429259E94940
79536	HP19 8TE	GB	0101000020E61000009B012EC896E5EABF7099D36531E94940
79537	HP19 9NB	GB	0101000020E61000004B92E7FA3E1CEABF61C5A9D6C2E84940
79538	HP2	GB	0101000020E610000012DA722EC555DDBFB4CA4C69FDDF4940
79539	HP2 4ER	GB	0101000020E61000001903EB387EA8DCBFEACF7EA488E04940
79540	HP2 4LW	GB	0101000020E6100000BADDCB7D7214DDBFC020E9D32AE04940
79541	HP2 4NW	GB	0101000020E6100000EBE5779ACC78DCBF4850FC1873E14940
79542	HP2 4PA	GB	0101000020E61000003255302AA913DCBF1BD5E940D6DF4940
79543	HP2 4QA	GB	0101000020E6100000C45E28603B18DCBF7270E998F3E04940
79544	HP2 4RN	GB	0101000020E61000007FDB1324B6BBDCBF9566F3380CE04940
79545	HP2 4RQ	GB	0101000020E6100000569929ADBF25DCBF5E85949F54E14940
79546	HP2 4TR	GB	0101000020E6100000CC28965B5A0DDEBF5419C6DD20E04940
79547	HP2 5HJ	GB	0101000020E610000061E3FA777DE6DDBF614F3BFC35E14940
79548	HP2 5JX	GB	0101000020E61000004700378B170BDDBFC4B3041901E14940
79549	HP2 5NB	GB	0101000020E6100000DD60A8C30AB7DCBF293DD34B8CE14940
79550	HP2 6BB	GB	0101000020E61000007366BB421F2CDDBFB8054B7501E34940
79551	HP2 6EY	GB	0101000020E6100000B345D26EF431DFBF9E245D33F9E44940
79552	HP2 7GY	GB	0101000020E61000006249B9FB1C1FDBBFFBB2B45373E14940
79553	HP2 7NL	GB	0101000020E6100000DEC66647AAEFDBBF4D9EB29AAEE34940
79554	HP2 7NX	GB	0101000020E61000003D2AFEEF880ADCBF028063CF9EE34940
79555	HP2 7PA	GB	0101000020E6100000397EA8346266DABF5264ADA1D4E24940
79556	HP20 1RU	GB	0101000020E610000069520ABABD24EBBF6EC2BD326FE94940
79557	HP20 2QZ	GB	0101000020E6100000EA25C632FD12EABFA4C519C39CE84940
79558	HP20 2RZ	GB	0101000020E6100000072461DF4E22EABFE833A0DE8CE84940
79559	HP21	GB	0101000020E61000002594BE1072DEE9BF1D774A07EBE74940
79560	HP21 7AR	GB	0101000020E6100000075E2D776602E9BF31B2648EE5E74940
79561	HP21 7EU	GB	0101000020E6100000F6984869368FE9BF9752978C63E84940
79562	HP21 7LU	GB	0101000020E6100000F0A7C64B3789E9BF0F2A711DE3E64940
79563	HP21 7QG	GB	0101000020E6100000CF81E50819C8E9BF9F55664AEBE74940
79564	HP21 7SX	GB	0101000020E61000008A05BEA25BAFE9BF98FC4FFEEEE74940
79565	HP21 8	GB	0101000020E6100000CF68AB92C83EEABF5E6397A8DEE64940
79566	HP21 8BP	GB	0101000020E6100000560BEC3191D2E9BF438D429259E74940
79567	HP21 8LA	GB	0101000020E61000006808C72C7B12EABFB726DD96C8E74940
79568	HP21 9DL	GB	0101000020E61000006ADAC534D33DE9BFEC2FBB270FE74940
79569	HP21 9DS	GB	0101000020E61000001FBB0B9414D8E9BF7A50508A56E64940
79570	HP21 9HW	GB	0101000020E610000077DA1A118C03EABFBDDF68C70DE74940
79571	HP21 9LT	GB	0101000020E6100000A4DFBE0E9C33EABF52EDD3F198E54940
79572	HP22	GB	0101000020E61000008995D1C8E715E8BFE97DE36BCFE44940
79573	HP22 4BY	GB	0101000020E6100000B9E00CFE7EB1EDBFA8FDD64E94EE4940
79574	HP22 4JB	GB	0101000020E6100000B43BA41820D1EABF5C1FD61BB5F04940
79575	HP22 4LH	GB	0101000020E61000000E2E1D739EB1EABF3FA9F6E978F04940
79576	HP22 4NH	GB	0101000020E61000006DC83F33880FEABFD6C56D3480ED4940
79577	HP22 4PA	GB	0101000020E61000001D554D10759FE7BF524832AB77EE4940
79578	HP22 4PS	GB	0101000020E6100000AD16D86322A5E7BF3750E09D7CEE4940
79579	HP22 5DD	GB	0101000020E6100000C59272F7393EE9BF86E63A8DB4EA4940
79580	HP22 5EJ	GB	0101000020E61000008DD0CFD4EB96E7BF3E4162BB7BE64940
79581	HP22 5GB	GB	0101000020E6100000AF415F7AFBF3E7BFBE67244223E84940
79582	HP22 5HY	GB	0101000020E6100000C993A46B26DFE6BF94A3005130E74940
79583	HP22 5QH	GB	0101000020E6100000D009A1832E61E7BF58E36C3A02E24940
79584	HP22 5QX	GB	0101000020E610000076FBAC32535AE8BF6000E14389E44940
79585	HP22 5TG	GB	0101000020E610000041B62C5F97E1E8BFBC033C69E1E44940
79586	HP22 5TJ	GB	0101000020E6100000102219726CBDE8BF8E7406465EE44940
79587	HP22 5UA	GB	0101000020E6100000E8DD58501814E9BFA439B2F2CBE44940
79588	HP22 5UP	GB	0101000020E61000002FA52E19C748E9BF7C7DAD4B8DE44940
79589	HP22 5US	GB	0101000020E6100000DCF29194F4B0E6BF73F22213F0E54940
79590	HP22 6AJ	GB	0101000020E6100000E3C3EC65DBE9E7BFE97C789620E34940
79591	HP22 6BN	GB	0101000020E61000006FF4311F10E8E7BF766C04E275E14940
79592	HP22 6EA	GB	0101000020E6100000B5A679C729BAE7BF00E48409A3E14940
79593	HP22 6EG	GB	0101000020E61000006F2D93E178BEE7BFEA4141295AE14940
79594	HP22 6HH	GB	0101000020E6100000C0E78711C2A3E7BFC4B0C398F4E14940
79595	HP22 6JJ	GB	0101000020E61000002EE23B31EBC5E7BF2ECBD765F8E14940
79596	HP22 6LX	GB	0101000020E6100000EC4FE27327D8E7BFDECA129D65E24940
79597	HP22 6NF	GB	0101000020E61000006E4C4F58E281E7BF130B7C45B7E04940
79598	HP22 6PE	GB	0101000020E61000003065E08096AEE7BF94331477BCE14940
79599	HP23	GB	0101000020E61000003E05C078060DE5BFB020CD5834E54940
79600	HP23 4AT	GB	0101000020E6100000751E15FF7744E5BF2DE92807B3E54940
79601	HP23 4DD	GB	0101000020E61000001DAD6A494739E5BFC5C8923996E54940
79602	HP23 4LP	GB	0101000020E6100000B58CD47B2A27E5BF3DD7F7E120E94940
79603	HP23 4PU	GB	0101000020E6100000CEFBFF386142E5BFF94CF6CFD3EA4940
79604	HP23 4QL	GB	0101000020E61000009370218FE046E6BF6479573D60EA4940
79605	HP23 4QS	GB	0101000020E6100000C310397D3D5FE6BF38BEF6CC92EA4940
79606	HP23 4RA	GB	0101000020E6100000B6BB07E8BE9CE6BF880D164ED2EC4940
79607	HP23 5AH	GB	0101000020E6100000AFB2B6291E17E5BF516859F78FE54940
79608	HP23 5AU	GB	0101000020E610000026E4839ECD2AE5BF7A522635B4E54940
79609	HP23 5JU	GB	0101000020E6100000779D0DF96706E5BF5B28999CDAE54940
79610	HP23 5QR	GB	0101000020E61000001A14CD0358E4E3BF66834C3272E64940
79611	HP23 6AA	GB	0101000020E61000006F2C280CCA34E5BFB306EFAB72E54940
79612	HP23 6AN	GB	0101000020E61000009EEE3CF19C2DE5BFCB694FC939E54940
79613	HP23 6EH	GB	0101000020E61000006BBB09BE697AE4BF6D3B6D8D08E44940
79614	HP23 6HS	GB	0101000020E61000008C2B2E8ECA4DE4BF0E4DD9E907E34940
79615	HP27 0JA	GB	0101000020E61000005A492BBEA170EABF5019FF3EE3DC4940
79616	HP27 0JL	GB	0101000020E61000009929ADBF2580EABF64AC36FFAFDC4940
79617	HP27 0LH	GB	0101000020E61000008B34F10EF024EABF94FAB2B453DD4940
79618	HP27 0NT	GB	0101000020E61000002B51F696723EEABFD68BA19C68D94940
79619	HP27 0PT	GB	0101000020E6100000D0B359F5B9DAE9BFFDDB65BFEED84940
79620	HP27 0RH	GB	0101000020E61000003C17467A513BEABF7313B534B7DA4940
79621	HP27 0RU	GB	0101000020E6100000908653E6E61BE9BFB72A89EC83D84940
79622	HP27 0TD	GB	0101000020E6100000EDF2AD0FEB0DE9BFE19A3BFA5FD84940
79623	HP27 9AR	GB	0101000020E610000012C0CDE2C5C2EABF22FE614B8FDC4940
79624	HP27 9DA	GB	0101000020E6100000696E85B01ACBEABFDC813AE5D1DB4940
79625	HP27 9DN	GB	0101000020E61000004D2CF015DDFAEABFF3E32F2DEADB4940
79626	HP27 9DX	GB	0101000020E6100000F6251B0FB6D8EABF1DAB949EE9DB4940
79627	HP27 9HT	GB	0101000020E6100000B41D53776597EABF18D2E1218CDD4940
79628	HP27 9JH	GB	0101000020E6100000D046AE9B525EEABF1F317A6EA1DD4940
79629	HP27 9JQ	GB	0101000020E6100000D2C3D0EAE48CEABF74B7EBA529DE4940
79630	HP27 9NE	GB	0101000020E6100000EFE53E390A10EBBF54AC1A84B9DB4940
79631	HP27 9PL	GB	0101000020E61000006825ADF88642ECBF39F1D58EE2DC4940
79632	HP27 9SJ	GB	0101000020E6100000FED2A23EC99DEBBFF777B6476FDE4940
79633	HP27 9SS	GB	0101000020E6100000F1D93A38D89BEBBF47AF06280DDF4940
79634	HP27 9TB	GB	0101000020E61000006347E350BF8BEBBF9DD9AED007DF4940
79635	HP3	GB	0101000020E6100000AA49F086342ADFBFECBFCE4D9BDD4940
79636	HP3 0AA	GB	0101000020E61000005B785E2A36E6DDBF6DFE5F75E4DC4940
79637	HP3 0BQ	GB	0101000020E61000008C4CC0AF9124E0BF05E10A28D4DD4940
79638	HP3 0HS	GB	0101000020E610000044300E2E1DF3E0BF2BF9D85DA0DC4940
79639	HP3 0JX	GB	0101000020E610000085268925E5EEE0BF58A9A0A2EADB4940
79640	HP3 0RX	GB	0101000020E610000093196F2BBDB6E1BF32384A5E9DDB4940
79641	HP3 8BD	GB	0101000020E6100000BEDEFDF15EB5DCBF8597E0D407DE4940
79642	HP3 8HW	GB	0101000020E61000007A3716140665DCBF6CB07092E6DF4940
79643	HP3 8LY	GB	0101000020E6100000EA5A7B9FAA42DBBF9755D80C70DF4940
79644	HP3 8NH	GB	0101000020E61000004374081C0934DCBF486C770FD0DF4940
79645	HP3 9BQ	GB	0101000020E6100000BB4560AC6F60DFBF2C499EEBFBDE4940
79646	HP3 9HN	GB	0101000020E61000007C0DC1711937DEBF14CFD90242DF4940
79647	HP3 9PA	GB	0101000020E6100000A9328CBB41B4DDBFE1D39CBCC8DE4940
79648	HP3 9QB	GB	0101000020E6100000D787F546AD30DDBF738236397CDE4940
79649	HP3 9SH	GB	0101000020E6100000EE5D83BEF4F6DDBF4626E0D748DE4940
79650	HP3 9SX	GB	0101000020E6100000E44EE960FD9FDDBF8FFB56EBC4DD4940
79651	HP3 9TP	GB	0101000020E610000055BDFC4E9319DDBF08B0C8AF1FDE4940
79652	HP3 9UT	GB	0101000020E61000005726FC523F6FDDBFBE839F3880DE4940
79653	HP4	GB	0101000020E6100000C154336B29A0E1BF1615713AC9E24940
79654	HP4 1DR	GB	0101000020E6100000202A8D98D967E2BF89EB18575CE24940
79655	HP4 1HJ	GB	0101000020E6100000F0FCA204FD05E2BFC493DDCCE8E14940
79656	HP4 1QE	GB	0101000020E61000004B92E7FA3E9CE1BF022A1C412AE74940
79657	HP4 1RW	GB	0101000020E6100000CA181F662FDBE1BFDE8D058541EB4940
79658	HP4 2AA	GB	0101000020E6100000BFEE74E789E7E1BFBA9EE8BAF0E14940
79659	HP4 2AJ	GB	0101000020E6100000E7559DD502FBE1BF5C397B67B4E14940
79660	HP4 2PD	GB	0101000020E61000003293A8177C9AE1BF60E63BF889E14940
79661	HP4 2PN	GB	0101000020E6100000861C5BCF108EE1BF5000C5C892E14940
79662	HP4 2QU	GB	0101000020E61000006284F068E388E0BFAE80423D7DE24940
79663	HP4 2RE	GB	0101000020E61000007026A60BB1FAE0BF7F6ABC7493E24940
79664	HP4 3AD	GB	0101000020E6100000425BCEA5B82AE2BFAAD381ACA7E04940
79665	HP4 3AP	GB	0101000020E6100000AA9A20EA3E00E2BFE7ABE46377E14940
79666	HP4 3DS	GB	0101000020E6100000200DA7CCCD37E2BF121615713AE14940
79667	HP4 3ET	GB	0101000020E6100000B62C5F97E13FE2BF05F9D9C875E14940
79668	HP4 3NH	GB	0101000020E61000009850C1E10591E2BF29E8F692C6E04940
79669	HP4 3TQ	GB	0101000020E6100000888043A85233E3BFCD052E8F35E34940
79670	HP5	GB	0101000020E610000021938C9C85BDE2BF38F8C264AADA4940
79671	HP5 1AZ	GB	0101000020E61000006DFDF49F353FE3BFF1D6F9B7CBDA4940
79672	HP5 1BA	GB	0101000020E610000098C0ADBB792AE3BF53927538BADA4940
79673	HP5 1QL	GB	0101000020E6100000977329AE2AFBE2BF88122D793CD94940
79674	HP5 1QQ	GB	0101000020E61000000E881057CEDEE2BF02A08A1BB7D84940
79675	HP5 1SX	GB	0101000020E6100000EAE923F0871FE3BF24B726DD96D84940
79676	HP5 1UG	GB	0101000020E6100000C30DF8FC30C2E1BF86AB0320EED64940
79677	HP5 1XG	GB	0101000020E610000071CCB22781CDE2BF70438CD7BCDA4940
79678	HP5 1YG	GB	0101000020E61000007AC2120F289BE2BF3596B036C6DA4940
79679	HP5 2DF	GB	0101000020E610000050FEEE1D35A6E3BFB1DD3D40F7DB4940
79680	HP5 2PY	GB	0101000020E6100000FF04172B6AB0E3BF882EA86F99DB4940
79681	HP5 2RP	GB	0101000020E6100000FD885FB1860BE4BFC03FA54A94DB4940
79682	HP5 2RS	GB	0101000020E61000008CA03193A817E4BF5F09A4C4AEDB4940
79683	HP5 2SQ	GB	0101000020E61000007100FDBE7F73E4BFEE76BD3445DC4940
79684	HP5 3	GB	0101000020E6100000D8B628B34126E2BF97C5C4E6E3DA4940
79685	HP5 3PT	GB	0101000020E6100000C5CBD3B9A214E3BFCEA78E554ADF4940
79686	HP5 3RB	GB	0101000020E610000093ACC3D155BAE2BF7AA86DC328DE4940
79687	HP6 1HY	GB	0101000020E6100000DF52CE177BAFE3BF77BB5E9A22DA4940
79688	HP6 5AW	GB	0101000020E61000005BB4006DAB59E3BF88DA368C82D64940
79689	HP6 5AZ	GB	0101000020E6100000A6457D923B6CE3BF89601C5C3AD64940
79690	HP6 5PB	GB	0101000020E6100000A92F4B3B3597E3BF105CE50984D74940
79691	HP6 5TD	GB	0101000020E61000005D16139B8F6BE3BF7AE1CE8591D64940
79692	HP6 6BQ	GB	0101000020E61000008DB800344A17E3BF1494A2957BD74940
79693	HP6 6EB	GB	0101000020E6100000D593F947DF24E3BFF9BF232A54D74940
79694	HP6 6EF	GB	0101000020E6100000A9DBD9571E24E3BF5FB35C363AD74940
79695	HP6 6HG	GB	0101000020E6100000151DC9E53F24E3BF3B191C25AFD64940
79696	HP6 6QS	GB	0101000020E6100000DAC87553CAEBE1BFEF8FF7AA95D54940
79697	HP6 6RS	GB	0101000020E6100000AABA473657CDE1BFB212F3ACA4D54940
79698	HP6 6RX	GB	0101000020E61000006422A5D93C8EE1BF58A9A0A2EAD54940
79699	HP6 6SX	GB	0101000020E61000002577D84466AEE1BFDF52CE177BD54940
79700	HP7 0BN	GB	0101000020E610000071CCB227814DE3BF990E9D9E77D54940
79701	HP7 0HA	GB	0101000020E610000095826E2F698CE3BFE146CA1649D54940
79702	HP7 0HT	GB	0101000020E6100000325871AAB5B0E3BFA1681EC022D54940
79703	HP7 0LW	GB	0101000020E610000088D860E1244DE4BFCBBC55D7A1D24940
79704	HP7 0NF	GB	0101000020E6100000AB3FC23060C9E4BF65C8B1F50CD34940
79705	HP7 0RL	GB	0101000020E6100000C66F0A2B1554E4BF642310AFEBD54940
79706	HP7 9AX	GB	0101000020E61000002907B309302CE3BF0F9BC8CC05D64940
79707	HP7 9HL	GB	0101000020E6100000399B8E006E16E3BF1E5036E50AD54940
79708	HP7 9NW	GB	0101000020E61000000BB43BA41820E2BFA2B8E34D7ED54940
79709	HP7 9PF	GB	0101000020E6100000B1F9B836540CE2BFD4EFC2D66CD54940
79710	HP7 9PR	GB	0101000020E610000064B14D2A1AEBE1BF890B40A374D54940
79711	HP7 9RZ	GB	0101000020E6100000DAAD65321C4FE2BF603DEE5BADD54940
79712	HP8 4AJ	GB	0101000020E61000003EEC8502B683E1BF36ACA92C0AD54940
79713	HP8 4DN	GB	0101000020E6100000A60A46257582E2BF9886E12362D04940
79714	HP8 4DX	GB	0101000020E610000079CA6ABA9E68E2BF8BFED0CC93CF4940
79715	HP8 4HN	GB	0101000020E61000000F643DB5FAEAE1BF2AE09EE74FD14940
79716	HP8 4HP	GB	0101000020E61000001C977153034DE2BF8D96033DD4D04940
79717	HP8 4HZ	GB	0101000020E6100000E17B7F83F6EAE1BF9C31CC09DAD04940
79718	HP8 4JB	GB	0101000020E610000092054CE0D6DDE1BFF33E8EE6C8D04940
79719	HP8 4QS	GB	0101000020E6100000292158552F3FE2BF9B73F04C68D04940
79720	HP9	GB	0101000020E6100000C364AA6054D2E4BF249D819197CD4940
79721	HP9 1AJ	GB	0101000020E610000040D9942BBC4BE4BFA8FFACF9F1CD4940
79722	HP9 1BP	GB	0101000020E610000094F59B89E942E5BF7DCA3159DCCD4940
79723	HP9 1HT	GB	0101000020E6100000CAFD0E45813EE5BF94895B0531CE4940
79724	HP9 1RD	GB	0101000020E6100000E4DBBB067D69E4BF128942CBBACD4940
79725	HP9 2EA	GB	0101000020E6100000425F7AFB7351E4BF8EE6C8CA2FCD4940
79726	HP9 2PJ	GB	0101000020E61000007A17EFC7ED97E4BFEDD45C6E30CE4940
79727	HP9 2RW	GB	0101000020E61000007841446ADAC5E3BFE10CFE7E31CD4940
79728	HP9 2UR	GB	0101000020E61000005AF5B9DA8A7DE3BFC2DA183BE1CD4940
79729	HP9 2UT	GB	0101000020E61000009D4A06802A6EE3BFD76CE525FFCD4940
79730	HP9 2XJ	GB	0101000020E61000002DD15966118AE3BF137EA99F37CF4940
79731	HR1 1BB	GB	0101000020E61000001409A69A59AB05C0E28FA2CEDC074A40
79732	HR1 1EG	GB	0101000020E6100000FD3383F8C0AE05C01E53776517084A40
79733	HR1 1JE	GB	0101000020E6100000CF9ECBD4249805C0342F87DD77084A40
79734	HR1 1JJ	GB	0101000020E61000006A1327F73B9405C06684B70721084A40
79735	HR1 1LY	GB	0101000020E6100000D3A1D3F36E8C05C02E7590D783074A40
79736	HR1 1PZ	GB	0101000020E6100000E2016553AEB005C09CBF0985080A4A40
79737	HR1 1RS	GB	0101000020E610000089D4B48B698605C00B5F5FEB52074A40
79738	HR1 1TY	GB	0101000020E6100000105CE509847D05C052465C001A074A40
79739	HR1 2AF	GB	0101000020E6100000664F029B739005C0297B4B395F064A40
79740	HR1 2NU	GB	0101000020E61000005DA9674128AF05C00D71AC8BDB064A40
79741	HR1 2NZ	GB	0101000020E6100000ACC5A70018AF05C07B32FFE89B064A40
79742	HR1 2RD	GB	0101000020E610000055DD239BABA605C0DBDD03745F064A40
79743	HR1 3DD	GB	0101000020E610000078B471C45A5C05C0810A47904A114A40
79744	HR1 3EU	GB	0101000020E6100000A5F622DA8E8905C0A8C4758C2B104A40
79745	HR1 3JJ	GB	0101000020E6100000171230BABC5905C0C07ADCB75A134A40
79746	HR1 3NP	GB	0101000020E6100000DA39CD02ED4E05C096253ACB2C0E4A40
79747	HR1 3RQ	GB	0101000020E61000007AFF1F274CD804C0C558A65F220C4A40
79748	HR1 4ES	GB	0101000020E6100000C042E6CAA0DA04C07217618A72074A40
79749	HR1 4JA	GB	0101000020E6100000B247A819526504C033FAD170CA084A40
79750	HR1 4JQ	GB	0101000020E61000000E83F92B644E04C0CEC7B5A162064A40
79751	HR1 4JU	GB	0101000020E610000058ACE122F73405C09E7AA4C16D054A40
79752	HR1 4LW	GB	0101000020E6100000CCF09F6EA00005C0AEEFC34142044A40
79753	HR1 4RL	GB	0101000020E6100000ECFB7090106504C0C4961E4DF5FE4940
79754	HR1 4UL	GB	0101000020E6100000130EBDC5C31B05C0D95E0B7A6FFA4940
79755	HR2 0EH	GB	0101000020E610000016FBCBEEC90307C0B5705985CDF84940
79756	HR2 0ES	GB	0101000020E6100000BFB67EFACF1A07C01503249A40F94940
79757	HR2 0EX	GB	0101000020E61000006ADE718A8E2407C0E869C020E9F94940
79758	HR2 0JJ	GB	0101000020E6100000058BC3995F6D07C0511212691BFD4940
79759	HR2 0RF	GB	0101000020E610000049A297512C9707C0FD31AD4D63FF4940
79760	HR2 0RT	GB	0101000020E6100000C89750C1E1A507C0E06932E36D054A40
79761	HR2 0SN	GB	0101000020E610000022FFCC203ED007C069E55E6056064A40
79762	HR2 0TE	GB	0101000020E610000043FE99417CE007C02E008DD2A5054A40
79763	HR2 6PF	GB	0101000020E6100000D6AD9E93DEF705C0B686527B11FF4940
79764	HR2 6PH	GB	0101000020E61000002A1C412AC56E05C01781B1BE81FF4940
79765	HR2 6QL	GB	0101000020E6100000DA1A118C836B05C0D8666325E6FB4940
79766	HR2 7AY	GB	0101000020E610000085EAE6E26FDB05C017B9A7AB3B064A40
79767	HR2 7DD	GB	0101000020E6100000F83768AF3EDE05C04C89247A19054A40
79768	HR2 7QF	GB	0101000020E610000031EE06D15AD105C0D7DD3CD521054A40
79769	HR2 7YH	GB	0101000020E610000018E945ED7EF505C078B7B24467054A40
79770	HR2 8AW	GB	0101000020E6100000FA6184F068C305C0F032C34659FD4940
79771	HR2 8BB	GB	0101000020E61000004D2F3196E9B705C06DACC43C2BFD4940
79772	HR2 8BD	GB	0101000020E61000004700378B17AB05C0B9A6406667FD4940
79773	HR2 8DU	GB	0101000020E610000018231285963506C072FC5069C4FE4940
79774	HR2 8EL	GB	0101000020E610000033C51C041DED05C050E09D7C7AFA4940
79775	HR2 8JJ	GB	0101000020E6100000C460FE0A99CB05C0164F3DD2E0FA4940
79776	HR2 8RX	GB	0101000020E6100000BFD364C6DB8A06C0390D51853FF54940
79777	HR2 9HJ	GB	0101000020E610000042942F6821C106C0AC527AA697024A40
79778	HR2 9HW	GB	0101000020E6100000F2D077B7B2C406C0E867EA758B024A40
79779	HR2 9JY	GB	0101000020E6100000FD82DDB06D5107C0A5677A89B1084A40
79780	HR2 9NJ	GB	0101000020E61000007898F6CDFDB506C0B5C6A01342054A40
79781	HR2 9QD	GB	0101000020E61000001C96067E548306C06FD74B5304064A40
79782	HR2 9SR	GB	0101000020E6100000A6D1E4620C6C06C027DA5548F9034A40
79783	HR2 9TR	GB	0101000020E61000000801F9122A9806C0CD57C9C7EE024A40
79784	HR3 5	GB	0101000020E610000049D92269379A09C009FEB7921D054A40
79785	HR3 5AJ	GB	0101000020E6100000AF08FEB792FD08C09E7AA4C16D094A40
79786	HR3 5DB	GB	0101000020E61000007B15191D900409C05CAE7E6C92094A40
79787	HR3 5DJ	GB	0101000020E6100000BAA1293BFD0009C02EE3A6069A094A40
79788	HR3 5DX	GB	0101000020E6100000FAF02C41460009C04C1B0E4B03094A40
79789	HR3 5EW	GB	0101000020E61000001DAA29C93AFC08C003B2D7BB3F0A4A40
79790	HR3 5EX	GB	0101000020E61000009818CBF44BC408C0D481ACA7560D4A40
79791	HR3 5LL	GB	0101000020E6100000B874CC79C69E09C0D7BE805EB8054A40
79792	HR3 5NT	GB	0101000020E6100000CE1951DA1BFC08C054C4E9245B094A40
79793	HR3 5QX	GB	0101000020E61000008C101E6D1CF108C03D9CC0745A094A40
79794	HR3 6AZ	GB	0101000020E610000047753A90F51408C0C7A17E17B60A4A40
79795	HR3 6JT	GB	0101000020E6100000A4A7C821E28608C0EA059FE6E4114A40
79796	HR3 6LZ	GB	0101000020E610000086C613419C4708C0F73FC05AB5114A40
79797	HR3 6NB	GB	0101000020E610000093C5FD47A64308C04CFF9254A6124A40
79798	HR3 6NJ	GB	0101000020E610000067F3380CE60F08C06DE4BA29E5114A40
79799	HR3 6NU	GB	0101000020E610000033A83638111D08C09C4F1DAB94104A40
79800	HR3 6QF	GB	0101000020E6100000E8F7FD9B17A707C0ED7DAA0A0D124A40
79801	HR4	GB	0101000020E6100000605AD427B92306C02FC214E5D20C4A40
79802	HR4 0AS	GB	0101000020E6100000E0D6DD3CD5C105C0AC5791D101074A40
79803	HR4 0EH	GB	0101000020E61000002AA913D044D805C0A01B9AB2D3074A40
79804	HR4 0EY	GB	0101000020E6100000355D4F745DD805C04CFDBCA948074A40
79805	HR4 0TE	GB	0101000020E610000069AB92C83E0806C018CFA0A17F084A40
79806	HR4 6PQ	GB	0101000020E61000007500C45DBD6A06C017B9A7AB3B144A40
79807	HR4 7EQ	GB	0101000020E6100000F4328AE5967606C0DFFDF15EB50A4A40
79808	HR4 7QN	GB	0101000020E61000005C381092050C06C03F1C2444F90A4A40
79809	HR4 7RH	GB	0101000020E6100000DBF97E6ABC1406C0D07D39B35D0B4A40
79810	HR4 8BU	GB	0101000020E6100000406D54A7033906C01C412AC58E144A40
79811	HR4 8HD	GB	0101000020E6100000965E9B8D95B806C0EE5EEE93A3164A40
79812	HR4 8HZ	GB	0101000020E6100000AB96749483D906C0FC19DEACC1174A40
79813	HR4 8PX	GB	0101000020E6100000265305A3929A06C0AB3DEC8502144A40
79814	HR4 8QZ	GB	0101000020E6100000800C1D3BA82407C04E2B85402E154A40
79815	HR4 9AU	GB	0101000020E61000003F8C101E6DBC05C00DE4D9E55B074A40
79816	HR4 9JE	GB	0101000020E6100000799274CDE4BB05C0B16B7BBB25074A40
79817	HR4 9JR	GB	0101000020E6100000CB64389ECFC005C006F2ECF2AD074A40
79818	HR4 9LZ	GB	0101000020E6100000514D49D6E1E805C0F700DD9733094A40
79819	HR4 9NE	GB	0101000020E610000007D3307C44CC05C0A64412BD8C084A40
79820	HR4 9NZ	GB	0101000020E610000009C6C1A563CE05C0917EFB3A70084A40
79821	HR4 9PQ	GB	0101000020E610000081ED60C43EE105C0B03DB32440094A40
79822	HR5 3AJ	GB	0101000020E6100000DD7D8E8F164708C06E861BF0F9194A40
79823	HR5 3BJ	GB	0101000020E610000044317903CC3C08C06D6FB724071A4A40
79824	HR5 3DJ	GB	0101000020E6100000AABBB20B063708C02D978DCEF9194A40
79825	HR5 3EL	GB	0101000020E6100000A1866F61DD5808C03881E9B46E194A40
79826	HR5 3NY	GB	0101000020E610000029E9616875F208C0D4B9A29410184A40
79827	HR6 0AU	GB	0101000020E61000002E8D5F78252906C0A9C29FE1CD244A40
79828	HR6 0BZ	GB	0101000020E6100000608F8994663306C0DB15FA6019214A40
79829	HR6 0DW	GB	0101000020E61000000ADAE4F049C705C01EFAEE5696224A40
79830	HR6 0EA	GB	0101000020E6100000D76B7A50500A06C093399677D5214A40
79831	HR6 0HQ	GB	0101000020E6100000D3307C444C8905C004AE2B66841F4A40
79832	HR6 0HZ	GB	0101000020E6100000DEAB5626FC9205C00B7E1B62BC224A40
79833	HR6 0LG	GB	0101000020E6100000060FD3BEB99F05C0F69B89E9421A4A40
79834	HR6 0RY	GB	0101000020E610000047AB5AD2510E05C0AFB321FFCC1A4A40
79835	HR6 0SF	GB	0101000020E610000086AE44A0FAC704C0CDC98B4CC01D4A40
79836	HR6 8AN	GB	0101000020E6100000ED4960730EDE05C0DA56B3CEF81C4A40
79837	HR6 8AR	GB	0101000020E6100000ADF6B0170AD805C0EB1F4432E41C4A40
79838	HR6 8BN	GB	0101000020E610000088122D793CED05C095287B4B391D4A40
79839	HR6 8EY	GB	0101000020E6100000A81ABD1AA0F405C0185FB4C70B1D4A40
79840	HR6 8PR	GB	0101000020E6100000E7DF2EFB750706C055C03DCF9F1C4A40
79841	HR6 8RS	GB	0101000020E610000098C11891281406C0C74ACCB3921C4A40
79842	HR6 8SF	GB	0101000020E61000008E058541990606C0EA5910CAFB1C4A40
79843	HR6 8SP	GB	0101000020E610000099F04BFDBC0906C02DEBFEB1101D4A40
79844	HR6 9BH	GB	0101000020E61000003E5E488787D006C019FED30D141C4A40
79845	HR6 9DD	GB	0101000020E61000001F9E25C8086806C025CB49287D1B4A40
79846	HR6 9DN	GB	0101000020E6100000DDCF29C8CFC606C05281936DE01A4A40
79847	HR6 9DQ	GB	0101000020E6100000D447E00F3F9F06C007EDD5C743194A40
79848	HR6 9JA	GB	0101000020E61000007C43E1B3757007C06891ED7C3F1B4A40
79849	HR6 9LR	GB	0101000020E6100000CBD93BA3AD0A07C04FCAA48636204A40
79850	HR6 9LX	GB	0101000020E6100000E7E26F7B820407C0CDB051D66F204A40
79851	HR6 9NG	GB	0101000020E6100000EF586C938A2607C0E1606F6248204A40
79852	HR6 9NJ	GB	0101000020E61000000FD07D39B33D07C0AA0F24EF1C224A40
79853	HR6 9PF	GB	0101000020E610000035B56CAD2FB206C0C3D7D7BAD4224A40
79854	HR7	GB	0101000020E61000007D7555A016E303C0E54526E0D71A4A40
79855	HR7 4AE	GB	0101000020E6100000A99F3715A91004C05038BBB54C184A40
79856	HR7 4EB	GB	0101000020E6100000C9FFE4EFDE1104C0410B09185D184A40
79857	HR7 4EL	GB	0101000020E610000032AEB8382A1704C0E0D6DD3CD5174A40
79858	HR7 4LY	GB	0101000020E6100000B22D03CE523204C05EBBB4E1B01C4A40
79859	HR7 4NJ	GB	0101000020E6100000BA66F2CD367704C00A698D41271E4A40
79860	HR7 4PW	GB	0101000020E6100000EF92382BA2E603C010C99063EB1B4A40
79861	HR7 4PZ	GB	0101000020E6100000A8C64B3789C103C08544DAC69F204A40
79862	HR8	GB	0101000020E61000009357E718901D04C0D1CE691668FF4940
79863	HR8 1AD	GB	0101000020E61000007008556AF66003C01FDB32E02C054A40
79864	HR8 1AR	GB	0101000020E610000021205F42056703C01B9B1DA9BE054A40
79865	HR8 1BJ	GB	0101000020E6100000FD4D2844C06103C0D9092FC1A9054A40
79866	HR8 1BS	GB	0101000020E6100000634337FB036503C06C5B94D920054A40
79867	HR8 1BZ	GB	0101000020E6100000A30392B06F6703C05760C8EA56054A40
79868	HR8 1NE	GB	0101000020E61000000A100533A66003C09C1727BEDA074A40
79869	HR8 1PQ	GB	0101000020E61000004F7974232C2A03C0B136C64E78FF4940
79870	HR8 1RL	GB	0101000020E6100000A435069D101A03C0BCAFCA85CA034A40
79871	HR8 2AA	GB	0101000020E610000006F4C29D0B6303C0535E2BA1BB044A40
79872	HR8 2HW	GB	0101000020E6100000CBF3E0EEAC5D03C0BC57AD4CF8034A40
79873	HR8 2PW	GB	0101000020E6100000B8B06EBC3B7203C0A530EF71A6054A40
79874	HR8 2TD	GB	0101000020E61000004432E4D87A2604C068226C787A0B4A40
79875	HR8 2TP	GB	0101000020E61000007D21E4BCFF2F04C0FF3EE3C2810C4A40
79876	HR8 2XJ	GB	0101000020E6100000D1AE42CA4F6A03C0A5D8D138D4034A40
79877	HR9	GB	0101000020E6100000D4B7CCE9B27805C0B8E4B8533AFA4940
79878	HR9 5BH	GB	0101000020E6100000FCABC77DABB504C08D976E1283F44940
79879	HR9 5RF	GB	0101000020E610000037C478CDABBA04C0812557B1F8EF4940
79880	HR9 5SZ	GB	0101000020E61000003C16DBA4A23104C0FFEC478AC8F24940
79881	HR9 5UU	GB	0101000020E6100000A67B9DD4974504C0DDE9CE13CFF34940
79882	HR9 6EE	GB	0101000020E61000007C48F8DEDFE004C0ADC266800BF64940
79883	HR9 6HA	GB	0101000020E610000074ECA012D79105C06806F1811DEF4940
79884	HR9 6JJ	GB	0101000020E610000090A2CEDC43C204C0EB8B84B69CED4940
79885	HR9 6JX	GB	0101000020E6100000AC1919E42E0205C071C806D2C5F44940
79886	HR9 6PG	GB	0101000020E6100000E719FB928DA705C07B30293E3EF14940
79887	HR9 6QJ	GB	0101000020E6100000A3E9EC6470F404C02A6F47382DF64940
79888	HR9 6QP	GB	0101000020E6100000209BE447FC0A05C0392BA226FAF84940
79889	HR9 7AN	GB	0101000020E61000003DD175E107A704C02A38BC2022F54940
79890	HS1 2DZ	GB	0101000020E610000052103CBEBD8B19C0FC54151A881B4D40
79891	HS1 2LL	GB	0101000020E6100000450DA661F88819C01FBE4C14211B4D40
79892	HS1 2NP	GB	0101000020E610000031EE06D15A8119C047AF06280D1B4D40
79893	HS1 2RE	GB	0101000020E61000007041B62C5F8719C01E8CD827801A4D40
79894	HS2 0	GB	0101000020E610000011FDDAFAE94F19C0EAB46E83DA294D40
79895	HS2 0BQ	GB	0101000020E61000002448A5D8D13819C0AAF1D24D621A4D40
79896	HS2 0DR	GB	0101000020E610000063EFC517ED9119C0F52A323A201D4D40
79897	HS2 0HE	GB	0101000020E61000008484285FD0D218C0A75A0BB3D01E4D40
79898	HS2 0NB	GB	0101000020E61000004BCD1E68052619C0525F96766A264D40
79899	HS2 0SH	GB	0101000020E61000000455A357038419C029CB10C7BA384D40
79900	HS2 0TX	GB	0101000020E6100000D9D0CDFE40D918C0FBE93F6B7E3C4D40
79901	HS2 0XH	GB	0101000020E6100000D84812842B1019C087FE092E56404D40
79902	HS2 9	GB	0101000020E61000000C022B8716091BC0CF30B5A50E204D40
79903	HS2 9AA	GB	0101000020E61000001399B9C0E5211BC0857CD0B359214D40
79904	HS2 9AW	GB	0101000020E61000007AE2395B40181BC0D9CD8C7E34244D40
79905	HS2 9AZ	GB	0101000020E6100000F88C4468042B1BC06BBB09BE69224D40
79906	HS2 9DW	GB	0101000020E6100000A8FFACF9F1271BC06494675E0E1F4D40
79907	HS2 9HB	GB	0101000020E6100000E8A1B60DA3701CC031B43A39430F4D40
79908	HS2 9JA	GB	0101000020E6100000CE531D72331C1CC03F1BB96E4A1D4D40
79909	HS2 9LQ	GB	0101000020E6100000D943FB58C11F1AC0E7A90EB919024D40
79910	HS2 9QJ	GB	0101000020E61000003DB665C059AA19C081E84999D40C4D40
79911	HS2 9QX	GB	0101000020E61000005950189469B419C0B7990AF148064D40
79912	HS2 9RD	GB	0101000020E6100000E90C8CBCACB919C0FE2955A2EC014D40
79913	HS3 3	GB	0101000020E610000037E3344415BE1BC0193735D07CEC4C40
79914	HS3 3BD	GB	0101000020E610000019E8DA17D0BB1AC0B439CE6DC2F54C40
79915	HS3 3DG	GB	0101000020E610000074B2D47ABF311BC0A1BAB9F8DBF24C40
79916	HS3 3DX	GB	0101000020E6100000C156091687131BC0D9B3E73235ED4C40
79917	HS3 3EN	GB	0101000020E6100000C6DB4AAFCD461BC0CDCEA2772AE84C40
79918	HS3 3HX	GB	0101000020E61000006D01A1F5F0251CC00000000000EA4C40
79919	HS4	GB	0101000020E6100000DFBF7971E2CB1AC070E998F38CEF4C40
79920	HS4 3XU	GB	0101000020E6100000BABA63B14DCA1AC0A2B8E34D7EEF4C40
79921	HS5 3	GB	0101000020E6100000CEE15AED610F1CC04583143C85E24C40
79922	HS5 3TW	GB	0101000020E61000004EF2237EC5DA1BC00806103E94DE4C40
79923	HS5 3UA	GB	0101000020E6100000CE18E6046D121CC0D49AE61DA7E24C40
79924	HS6 5AA	GB	0101000020E6100000E7C75F5AD4A71CC0195932C7F2CC4C40
79925	HS6 5BJ	GB	0101000020E61000008E226B0DA5B61CC0D0ECBAB722DB4C40
79926	HS6 5BS	GB	0101000020E6100000E14389963C6E1DC041B96DDFA3D24C40
79927	HS6 5HD	GB	0101000020E610000043AB933314571DC0CB9E0436E7C64C40
79928	HS7 5LA	GB	0101000020E61000003579CA6ABA7E1DC0174A26A776BC4C40
79929	HS7 5LH	GB	0101000020E610000016FA60191B8A1DC04759BF9998BC4C40
79930	HS7 5PG	GB	0101000020E6100000486DE2E47E571DC04792205C01B54C40
79931	HS8 5	GB	0101000020E61000008C12F4177A441DC074B7EBA529AE4C40
79932	HS8 5JH	GB	0101000020E6100000753DD175E1371DC0E1F08288D48A4C40
79933	HS8 5SH	GB	0101000020E610000005F86EF3C6891DC0CAC2D7D7BAA64C40
79934	HS8 5SS	GB	0101000020E61000002C4487C091901DC0AA0CE36E10954C40
79935	HS8 5TH	GB	0101000020E6100000D66EBBD05C371DC0D00EB8AE98934C40
79936	HS8 5TT	GB	0101000020E6100000D3122BA3917F1DC04E0D349F738D4C40
79937	HS9 5XD	GB	0101000020E6100000BEC1172653F51DC09B1C3EE9447A4C40
79938	HS9 5XW	GB	0101000020E6100000E0A128D027121EC0F0BF95ECD87C4C40
79939	HS9 5YD	GB	0101000020E6100000850A0E2F88C81DC0F8A8BF5E61834C40
79940	HU1	GB	0101000020E61000005E4BC8073D9BD5BFA0A52BD846E04A40
79941	HU1 1EP	GB	0101000020E61000007E18213CDA38D5BFCEA78E554ADF4A40
79942	HU1 1QE	GB	0101000020E610000095F3C5DE8B2FD5BFC422861DC6DE4A40
79943	HU1 1SE	GB	0101000020E61000003B3602F1BA7ED5BFE6797077D6DE4A40
79944	HU10	GB	0101000020E6100000FA62EFC517EDDBBFD7C1C1DEC4E04A40
79945	HU10 6JQ	GB	0101000020E6100000E197FA795391DBBF8A01124DA0E04A40
79946	HU10 6LZ	GB	0101000020E610000072FBE59315C3DBBF062AE3DF67E04A40
79947	HU10 6NA	GB	0101000020E6100000F436363B527DDBBF723106D671E04A40
79948	HU10 6NJ	GB	0101000020E6100000A0E1CD1ABCAFDABFDA01D71533E04A40
79949	HU10 6PT	GB	0101000020E610000011C5E40D30F3DBBF1CB5C2F4BDE04A40
79950	HU10 6QN	GB	0101000020E610000003CC7C073F71DBBFA0A70183A4DF4A40
79951	HU10 6SH	GB	0101000020E610000096ED43DE72F5DABFB1DD3D40F7DF4A40
79952	HU10 7EH	GB	0101000020E6100000F7CABC55D7A1DCBF51D9B0A6B2DE4A40
79953	HU10 7ND	GB	0101000020E6100000BDC282FB010FDDBF32E719FB92DF4A40
79954	HU10 7NR	GB	0101000020E6100000117349D57613DDBF59164CFC51E04A40
79955	HU10 7QD	GB	0101000020E6100000874D64E60297DCBF3430F2B226E04A40
79956	HU10 7SB	GB	0101000020E6100000ABEAE5779ACCDCBF543BC3D496E04A40
79957	HU10 7TA	GB	0101000020E61000000C79043752B6DCBFADC090D5ADE04A40
79958	HU10 7UU	GB	0101000020E610000089963C9E961FDDBFD4B7CCE9B2E04A40
79959	HU10 7UX	GB	0101000020E6100000849ECDAACFD5DCBF691EC022BFE04A40
79960	HU11	GB	0101000020E6100000A96BED7DAA0AD0BFEF71A609DBE34A40
79961	HU11 4AR	GB	0101000020E610000089963C9E961FD0BF9DD7D825AAE34A40
79962	HU11 4DS	GB	0101000020E6100000B1321AF9BCE2CFBF6EC1525DC0E34A40
79963	HU11 4HB	GB	0101000020E61000009143C4CDA964CEBF36CCD07822E44A40
79964	HU11 4LN	GB	0101000020E6100000EE27637C98BDC8BFBF1072DEFFE74A40
79965	HU11 4TL	GB	0101000020E6100000D3C08F6AD8EFC7BFA48CB80034EC4A40
79966	HU11 5RJ	GB	0101000020E6100000CAE2FE23D3A1CBBF2254A9D903F34A40
79967	HU12 0AE	GB	0101000020E6100000ACADD85F764FAEBF8E3D7B2E53D94A40
79968	HU12 0HE	GB	0101000020E6100000344C6DA983BCA6BF7CD5CA845FE04A40
79969	HU12 0NP	GB	0101000020E6100000AB93331477BCA1BF56D5CBEF34DB4A40
79970	HU12 0PR	GB	0101000020E610000037001B1021AEA4BF99D53BDC0ED74A40
79971	HU12 0RP	GB	0101000020E610000055A2EC2DE57C813FB28009DCBAD54A40
79972	HU12 0RY	GB	0101000020E6100000815F234910AEA03FDFC0E44691D54A40
79973	HU12 0UB	GB	0101000020E61000007DE71725E82FC03FB29C84D217D04A40
79974	HU12 8NJ	GB	0101000020E6100000B9A6406667D1C9BF664F029B73DE4A40
79975	HU12 8NW	GB	0101000020E61000009757AEB7CD54C8BFB98B3045B9DE4A40
79976	HU12 9AW	GB	0101000020E6100000CFF9298E03AFBABFEA5E27F565E14A40
79977	HU12 9DZ	GB	0101000020E61000001D226E4E2503C2BFD34F38BBB5DE4A40
79978	HU12 9TP	GB	0101000020E61000008FC4CBD3B9A2BCBF755776C1E0DA4A40
79979	HU13 0EL	GB	0101000020E610000026FDBD141E34DCBFB4739A05DADB4A40
79980	HU13 0HN	GB	0101000020E6100000DF3312A1116CDCBF9DA04D0E9FDC4A40
79981	HU13 0HP	GB	0101000020E61000007A8CF2CCCB61DCBFE75608ABB1DC4A40
79982	HU13 0NB	GB	0101000020E6100000CC61F71DC363DCBF0EBBEF181EDD4A40
79983	HU13 0PG	GB	0101000020E6100000CE8AA8893E1FDCBF3293A8177CDC4A40
79984	HU13 0PJ	GB	0101000020E61000007FC2D9AD6532DCBF3082C64CA2DC4A40
79985	HU13 0PZ	GB	0101000020E610000018D00B772E8CDCBF21037976F9DC4A40
79986	HU13 0SE	GB	0101000020E6100000740D33349E08DCBFB7B585E7A5DC4A40
79987	HU13 0SY	GB	0101000020E6100000A5F78DAF3DB3DBBF1DE8A1B60DDD4A40
79988	HU13 9BA	GB	0101000020E6100000AEB7CD548847DBBFE7E099D024DD4A40
79989	HU13 9BN	GB	0101000020E6100000AEF204C24EB1DBBF71AFCC5B75DD4A40
79990	HU13 9EA	GB	0101000020E6100000C45BE7DF2EFBDABFE3C62DE6E7DC4A40
79991	HU13 9EH	GB	0101000020E61000008484285FD042DBBF087250C24CDD4A40
79992	HU13 9JH	GB	0101000020E6100000CAFB389A232BDBBF6DE179A9D8DC4A40
79993	HU14 3BG	GB	0101000020E6100000B77A4E7ADFF8DDBFB003E78C28DD4A40
79994	HU14 3DJ	GB	0101000020E6100000520B2593533BE0BFE55FCB2BD7DB4A40
79995	HU14 3HU	GB	0101000020E6100000128942CBBAFFE0BF041DAD6A49DD4A40
79996	HU14 3JN	GB	0101000020E61000003C4D66BCADF4DFBF51A3906456DD4A40
79997	HU14 3JR	GB	0101000020E61000001F49490F432BE0BF6EF8DD74CBDC4A40
79998	HU14 3QH	GB	0101000020E61000000ABFD4CF9B8ADFBFC6A70018CFDE4A40
79999	HU15	GB	0101000020E6100000E1EB6B5D6A84E4BF577C43E1B3E34A40
80000	HU15 1BJ	GB	0101000020E6100000E8A221E3512AE2BF20425C397BDD4A40
80001	HU15 1DZ	GB	0101000020E61000006B662D05A47DE2BFDDB1D82615DD4A40
80002	HU15 1EQ	GB	0101000020E6100000E0F76F5E9C78E2BF3A94A12AA6DC4A40
80003	HU15 1HT	GB	0101000020E610000057B26323102FE2BF6B7F677BF4DE4A40
80004	HU15 1JG	GB	0101000020E6100000923D42CD902AE2BFCFF57D3848DE4A40
80005	HU15 1PE	GB	0101000020E61000008B170B43E474E1BFEA04341136DE4A40
80006	HU15 1RQ	GB	0101000020E610000038143E5B0787E5BFF5DA6CACC4DE4A40
80007	HU15 1RX	GB	0101000020E61000008CBD175FB447E2BF6C41EF8D21DE4A40
80008	HU15 2AL	GB	0101000020E6100000E4F90CA83723E3BF5E126745D4E24A40
80009	HU15 2HD	GB	0101000020E6100000F56915FDA199E0BF1F6ADB300AE24A40
80010	HU15 2LJ	GB	0101000020E610000045D4449F8FB2E4BF957D5704FFE34A40
80011	HU15 2PX	GB	0101000020E6100000BE1248895DDBE6BFED6305BF0DE14A40
80012	HU15 2RG	GB	0101000020E610000007280D350A49E6BFC21550A8A7E14A40
80013	HU15 2RX	GB	0101000020E6100000080264E8D8C1E6BF228D0A9C6CE34A40
80014	HU15 2SL	GB	0101000020E61000006C787AA52C43E1BF7AE063B0E2DC4A40
80015	HU15 2SU	GB	0101000020E6100000D50792770E65E7BF679C86A8C2DF4A40
80016	HU15 2XH	GB	0101000020E6100000BBD408FD4CBDE7BF069D103AE8E04A40
80017	HU16 4ES	GB	0101000020E61000005D6DC5FEB27BDABF16A1D80A9AE44A40
80018	HU16 4QU	GB	0101000020E6100000FC1873D712F2D9BF81936DE00EE44A40
80019	HU16 5AB	GB	0101000020E61000003813D38558FDDABF89618731E9E34A40
80020	HU16 5AJ	GB	0101000020E61000002BBF0CC68844DBBFC5C8923996E34A40
80021	HU16 5EB	GB	0101000020E6100000F3583332C85DDABF12A452EC68E44A40
80022	HU16 5ED	GB	0101000020E6100000C4D155BABBCEDABFCBF8F71917E44A40
80023	HU16 5JQ	GB	0101000020E610000050ABE80FCD3CDCBF857B65DEAAE34A40
80024	HU16 5PB	GB	0101000020E61000003048FAB48AFEDABF85B4C6A013E44A40
80025	HU16 5QZ	GB	0101000020E610000078978BF84ECCDABF59BF99982EE44A40
80026	HU16 5RL	GB	0101000020E6100000E4D6A4DB12B9DABFB2B8FFC874E44A40
80027	HU16 5RX	GB	0101000020E6100000F8DD74CB0EF1DABFAD4B8DD0CFE44A40
80028	HU16 5SH	GB	0101000020E6100000E99C9FE238F0DABFA379008BFCE44A40
80029	HU16 5YT	GB	0101000020E6100000D26D895C7006DCBF3CF71E2E39E44A40
80030	HU17	GB	0101000020E61000006C5B94D92093D9BFB6BDDD921CEC4A40
80031	HU17 0AS	GB	0101000020E6100000043C69E1B20ADBBF908653E6E6EB4A40
80032	HU17 0ES	GB	0101000020E61000007B14AE47E17ADABF562AA8A8FAEB4A40
80033	HU17 0NH	GB	0101000020E6100000221807978E39DBBFFA0AD28C45EB4A40
80034	HU17 0NY	GB	0101000020E61000006B8313D1AFADDABFCBF44BC45BEB4A40
80035	HU17 0SQ	GB	0101000020E6100000575C1C959BA8D8BF1EE0490B97EB4A40
80036	HU17 0TL	GB	0101000020E61000000DC51D6FF25BD9BFCBA145B6F3E94A40
80037	HU17 7BP	GB	0101000020E6100000651A4D2EC6C0DBBF073F7100FDEC4A40
80038	HU17 7DY	GB	0101000020E6100000287CB60E0EF6DBBFFC8F4C874EED4A40
80039	HU17 7EQ	GB	0101000020E61000007C7BD7A02FBDDBBF225514AFB2EC4A40
80040	HU17 7HY	GB	0101000020E61000009413ED2AA4FCDBBF8EE89E758DEC4A40
80041	HU17 7LG	GB	0101000020E61000009947FE60E0B9DCBF923F1878EEEF4A40
80042	HU17 7LX	GB	0101000020E6100000AD6D8AC745B5DCBF3E4162BB7BF04A40
80043	HU17 7NR	GB	0101000020E6100000E4688EACFC32DBBF105D50DF32F14A40
80044	HU17 7RF	GB	0101000020E610000033E202D0285DDFBF3DBB7CEBC3EE4A40
80045	HU17 8NG	GB	0101000020E6100000392BA226FA7CDABF485167EE21EB4A40
80046	HU17 8PE	GB	0101000020E6100000205F42058717DCBF6286C61341EA4A40
80047	HU17 8RX	GB	0101000020E6100000624ED026874FDFBF1A18795913E94A40
80048	HU17 8XP	GB	0101000020E610000076C1E09A3BFADBBFAD307DAF21EA4A40
80049	HU17 9BA	GB	0101000020E61000003620425C397BDBBFA4198BA6B3EB4A40
80050	HU17 9BH	GB	0101000020E6100000C6FA0626378ADBBFA320787C7BEB4A40
80051	HU17 9DB	GB	0101000020E61000003D635FB2F160DBBFE0F2583332EC4A40
80052	HU17 9HY	GB	0101000020E61000008BC404357C0BDBBF9EF0129CFAEC4A40
80053	HU17 9QU	GB	0101000020E61000004CE141B3EBDED9BF23F433F5BAED4A40
80054	HU18	GB	0101000020E6100000E9818FC18A53C5BF89B5F81400F54A40
80055	HU18 1	GB	0101000020E6100000FBCBEEC9C342C5BF02F04FA912F54A40
80056	HU18 1AQ	GB	0101000020E6100000F37519FED30DC6BFD1E80E6267F44A40
80057	HU18 1EL	GB	0101000020E6100000E5D18DB0A888C7BFF4328AE596F64A40
80058	HU18 1EU	GB	0101000020E610000044FCC3961E4DC5BFE8667FA0DCF44A40
80059	HU18 1HB	GB	0101000020E61000001DAD6A494739C6BF98A7734529F54A40
80060	HU18 1JY	GB	0101000020E6100000E1B20A9B012EC6BFB05582C5E1F64A40
80061	HU18 1LP	GB	0101000020E610000008E753C72AA5C5BF6F6589CE32F54A40
80062	HU18 1PH	GB	0101000020E6100000EC504D49D6E1C4BFD0ED258DD1F44A40
80063	HU18 1QS	GB	0101000020E6100000CF6916687748C5BF868F882991F44A40
80064	HU18 1TF	GB	0101000020E6100000EE7893DFA293C5BFED7E15E0BBF34A40
80065	HU18 1UH	GB	0101000020E6100000E14048163081BFBF7EACE0B721F44A40
80066	HU18 1XG	GB	0101000020E610000074EB353D2828C5BF378E588B4FF54A40
80067	HU19 2	GB	0101000020E6100000787FBC57AD4CA03F12BF620D17DD4A40
80068	HU19 2AP	GB	0101000020E6100000C7D6338463969D3F3B8908FF22DE4A40
80069	HU19 2AY	GB	0101000020E6100000213A048E041A9C3F5EF7562426DE4A40
80070	HU19 2DT	GB	0101000020E610000052D4997B48F89E3F25B37A87DBDD4A40
80071	HU19 2EB	GB	0101000020E610000063F20698F90E9E3F6939D0436DDD4A40
80072	HU19 2NY	GB	0101000020E61000000070ECD97399A23F9679ABAE43DD4A40
80073	HU19 2QZ	GB	0101000020E61000007FC00303081FB23FC87E164B91D84A40
80074	HU2	GB	0101000020E61000006AC2F693313ED5BF67B96C74CEDF4A40
80075	HU2 8NH	GB	0101000020E6100000033FAA61BF27D6BF6DC9AA0837DF4A40
80076	HU2 9	GB	0101000020E6100000522B4CDF6B08D6BFB4C9E1934EE04A40
80077	HU20 3UP	GB	0101000020E6100000A69718CBF4CBE1BFA80018CFA0E54A40
80078	HU20 3UR	GB	0101000020E6100000613255302AA9E1BF58ACE122F7E64A40
80079	HU20 3XE	GB	0101000020E61000004F029B73F04CE0BF5B41D3122BE54A40
80080	HU20 3XR	GB	0101000020E6100000F4FC69A33A9DE0BF03D0285DFAE34A40
80081	HU3	GB	0101000020E610000027F911BF620DD7BF38691A14CDDF4A40
80082	HU3 1LN	GB	0101000020E6100000257A19C5724BD7BFE5417A8A1CE04A40
80083	HU3 1LW	GB	0101000020E61000007B67B4554964D7BF6B48DC63E9DF4A40
80084	HU3 2JZ	GB	0101000020E6100000CE001764CBF2D6BF33164D6727DF4A40
80085	HU3 2SB	GB	0101000020E6100000DA91EA3BBF28D7BF7193516518DF4A40
80086	HU3 3HW	GB	0101000020E61000005F79909E2287D7BF36E84B6F7FDE4A40
80087	HU3 4DL	GB	0101000020E6100000BF0B5BB39597D6BFDD28B2D650DE4A40
80088	HU3 5DD	GB	0101000020E610000077F700DD9733D8BFDFC5FB71FBDD4A40
80089	HU3 6ES	GB	0101000020E6100000465C001AA54BD8BFD1782288F3DE4A40
80090	HU3 6PG	GB	0101000020E6100000384A5E9D6340D8BF97C9703C9FDF4A40
80091	HU3 6PY	GB	0101000020E610000027874F3A9160D8BF1F300F99F2DF4A40
80092	HU3 6QZ	GB	0101000020E61000003DBB7CEBC37AD8BF3A3FC571E0DF4A40
80093	HU4 6AN	GB	0101000020E61000008192020B60CAD9BFE4F8A1D288DF4A40
80094	HU4 6BT	GB	0101000020E6100000CBA0DAE044F4D8BF469737876BDF4A40
80095	HU4 6DD	GB	0101000020E61000005D34643C4A25D9BF46B5882826DF4A40
80096	HU4 6DY	GB	0101000020E6100000B6300BED9C66D9BF44317903CCDE4A40
80097	HU4 6JR	GB	0101000020E6100000CE37A27BD635D9BF33198EE733DE4A40
80098	HU4 6LD	GB	0101000020E610000011C4793881E9D8BFB24AE9995EDE4A40
80099	HU4 6ND	GB	0101000020E6100000CBF78C446804D9BFB0E42A16BFDD4A40
80100	HU4 6PP	GB	0101000020E61000007FDC7EF964C5D8BFCBD6FA22A1DD4A40
80101	HU4 6UP	GB	0101000020E6100000BD344580D3BBD7BF2C62D8614CE04A40
80102	HU4 6XP	GB	0101000020E6100000F78F85E81038DABF000341800CDF4A40
80103	HU4 7JE	GB	0101000020E6100000AAD55757056ADABF6A317898F6DD4A40
80104	HU4 7RE	GB	0101000020E610000012329067976FDABF91813CBB7CDF4A40
80105	HU5 1LD	GB	0101000020E610000061A92EE06586D6BF6347E350BFE14A40
80106	HU5 1ND	GB	0101000020E61000008C31B08EE387D6BF87C43D963EE24A40
80107	HU5 2AZ	GB	0101000020E6100000399CF9D51C20D7BF31D0B52FA0E14A40
80108	HU5 2DN	GB	0101000020E61000003082C64CA25ED7BFD32D3BC43FE24A40
80109	HU5 2DR	GB	0101000020E61000001E6E8786C5A8D7BF4DF4F92823E24A40
80110	HU5 2DS	GB	0101000020E61000003A3B191C25AFD7BFC9737D1F0EE24A40
80111	HU5 2EX	GB	0101000020E6100000A27E17B6662BD7BF1A33897AC1E14A40
80112	HU5 2HE	GB	0101000020E6100000295C8FC2F528D7BFA9F92AF9D8E14A40
80113	HU5 2HL	GB	0101000020E6100000F06E6589CE32D7BF5F7D3CF4DDE14A40
80114	HU5 2JA	GB	0101000020E6100000376DC669882AD7BF0F61FC34EEE14A40
80115	HU5 2NT	GB	0101000020E6100000B8B06EBC3B32D6BFC9CB9A58E0E14A40
80116	HU5 2SJ	GB	0101000020E6100000F052EA92718CD6BF410DDFC2BAE14A40
80117	HU5 3AT	GB	0101000020E61000002C7DE882FA96D7BF365A0EF450E14A40
80118	HU5 3DN	GB	0101000020E6100000847EA65EB708D7BF30F5F3A622E14A40
80119	HU5 3EX	GB	0101000020E61000002A1C412AC58ED7BF2828452BF7E04A40
80120	HU5 3HW	GB	0101000020E61000005D35CF11F92ED7BF72DEFFC709E14A40
80121	HU5 3JX	GB	0101000020E6100000CFF8BEB854A5D7BFDD5B9198A0E04A40
80122	HU5 3LE	GB	0101000020E6100000B43BA41820D1D7BF5ABDC3EDD0E04A40
80123	HU5 3NT	GB	0101000020E61000001FA1664815C5D7BF0EA0DFF76FE04A40
80124	HU5 3PE	GB	0101000020E61000004337FB03E5B6D7BFE3C116BB7DE04A40
80125	HU5 3RD	GB	0101000020E6100000CB2E185C7347D7BF9911DE1E84E04A40
80126	HU5 3UB	GB	0101000020E610000021753BFBCA83D7BFAAB8718BF9DF4A40
80127	HU5 4BH	GB	0101000020E6100000ED444948A46DD8BFC4245CC823E24A40
80128	HU5 4NX	GB	0101000020E6100000A73D25E7C41ED9BF98A432C51CE24A40
80129	HU5 4QZ	GB	0101000020E610000027BC04A73E90D8BF861BF0F961E24A40
80130	HU5 4TE	GB	0101000020E61000004167D2A6EA1ED9BFEF6FD05E7DE24A40
80131	HU5 5JW	GB	0101000020E6100000A58636001B10DABFC498F4F752E04A40
80132	HU5 5QG	GB	0101000020E6100000739CDB847B65DABFD27135B22BE14A40
80133	HU5 5QN	GB	0101000020E610000053094FE8F527DABFED9DD15625E14A40
80134	HU5 5UZ	GB	0101000020E61000001DCC26C0B0FCD9BF41F2CEA10CE14A40
80135	HU5 5YE	GB	0101000020E61000009DF4BEF1B567DABF390B7BDAE1DF4A40
80136	HU6 0AL	GB	0101000020E6100000321CCF6740BDD7BF7BF7C77BD5E64A40
80137	HU6 7AB	GB	0101000020E6100000931D1B81785DD6BFFD67CD8FBFE44A40
80138	HU6 7DR	GB	0101000020E6100000D05E7D3CF4DDD6BF145E82531FE44A40
80139	HU6 7DW	GB	0101000020E6100000C495B377465BD6BF2AC76471FFE34A40
80140	HU6 7RX	GB	0101000020E61000002B51F69672BED7BFAEBA0ED594E24A40
80141	HU6 7SH	GB	0101000020E6100000FA43334FAE29D7BF5F7B664980E24A40
80142	HU6 8BA	GB	0101000020E6100000A2F0D93A38D8D8BF87C5A86BEDE34A40
80143	HU6 9EU	GB	0101000020E61000009641B5C189E8D7BFC93B873254E54A40
80144	HU7	GB	0101000020E61000007E18213CDA38D3BF4CFF9254A6E44A40
80145	HU7 0BT	GB	0101000020E6100000425E0F26C5C7D4BFA69C2FF65EE24A40
80146	HU7 3DD	GB	0101000020E6100000A070766B990CD7BFB682A62556E64A40
80147	HU7 4QF	GB	0101000020E610000058A835CD3B4ED3BFBB641C23D9E34A40
80148	HU7 4TN	GB	0101000020E610000062DBA2CC0699D3BFA968ACFD9DE34A40
80149	HU7 4XJ	GB	0101000020E61000004FEB36A8FDD6D3BF69C4CC3E8FE34A40
80150	HU7 4YY	GB	0101000020E6100000BA4DB857E6ADD3BF57CEDE196DE34A40
80151	HU7 5XJ	GB	0101000020E610000018EAB0C22D1FD6BF75CDE49B6DE84A40
80152	HU74U	GB	0101000020E61000007714E7A8A3E3D1BFCAA7C7B60CE24A40
80153	HU8	GB	0101000020E6100000E1270EA0DFF7D2BFC9E4D4CE30E14A40
80154	HU8 0JD	GB	0101000020E61000002ECBD765F84FD3BF90DC9A745BE24A40
80155	HU8 0NA	GB	0101000020E610000003EFE4D3635BD2BF677DCA3159E24A40
80156	HU8 7TP	GB	0101000020E61000005473B9C15087D4BFF46C567DAEE04A40
80157	HU8 8BZ	GB	0101000020E61000008CF337A11001D5BFAD6D8AC745E14A40
80158	HU8 8JU	GB	0101000020E61000004298DBBDDC27D3BF5D50DF32A7E14A40
80159	HU8 8RE	GB	0101000020E61000005E143DF03158D3BF4AB20E4757E14A40
80160	HU8 8SS	GB	0101000020E610000098DC28B2D650D4BF4F2157EA59E04A40
80161	HU8 9BA	GB	0101000020E61000002B4B74965984D1BFB874CC79C6E24A40
80162	HU8 9ES	GB	0101000020E61000000D1AFA27B858D1BFBFB5132521E34A40
80163	HU8 9HE	GB	0101000020E61000000ADAE4F04927D2BFCE55F31C91E34A40
80164	HU8 9JZ	GB	0101000020E61000002234828DEBDFD2BFC8EE022505E44A40
80165	HU8 9TU	GB	0101000020E610000079E6E5B0FB8ED2BF9C340D8AE6E34A40
80166	HU9	GB	0101000020E6100000B686527B116DD3BF7DCB9C2E8BDF4A40
80167	HU9 3BP	GB	0101000020E61000000D18247D5A45D3BF07EE409DF2E04A40
80168	HU9 3EH	GB	0101000020E6100000AD510FD1E80ED6BF9F58A7CAF7E24A40
80169	HU9 4AJ	GB	0101000020E61000004C18CDCAF621D3BFD0D6C1C1DEE04A40
80170	HU9 5RJ	GB	0101000020E6100000EA2285B2F0F5CBBF3FC91D3691E14A40
80171	HU9 5SA	GB	0101000020E6100000D8F0F44A5986D1BFEA961DE21FE04A40
80172	HU9 5TB	GB	0101000020E610000045B75ED38382D1BF0377A04E79E04A40
80173	HX1	GB	0101000020E61000009C3237DF88EEFDBFFCDEA63FFBDB4A40
80174	HX1 1QE	GB	0101000020E61000008481E7DEC3A5FDBFAA9A20EA3EDC4A40
80175	HX1 2BG	GB	0101000020E6100000BC3D0801F9D2FDBFADC266800BDC4A40
80176	HX1 2NF	GB	0101000020E6100000EBFEB1101DC2FDBFD9942BBCCBDB4A40
80177	HX1 3TF	GB	0101000020E61000007D5A457F6826FEBF98F6CDFDD5DB4A40
80178	HX1 4HN	GB	0101000020E610000037514B732B44FEBF3CF71E2E39DC4A40
80179	HX1 4TE	GB	0101000020E610000092AE997CB3CDFDBF462575029ADC4A40
80180	HX2 0LR	GB	0101000020E610000044F817416366FEBF72193735D0DC4A40
80181	HX2 0LU	GB	0101000020E6100000DC8310902F61FEBF5C02F04FA9DC4A40
80182	HX2 6NP	GB	0101000020E6100000AAD72D0263FDFEBF4B75012F33DC4A40
80183	HX2 6TA	GB	0101000020E61000004EEFE2FDB8FDFEBFC5E57805A2DF4A40
80184	HX2 6TB	GB	0101000020E61000000DFAD2DB9F0BFFBF2B8716D9CEDF4A40
80185	HX2 6UX	GB	0101000020E610000084D6C3978922FFBF045ABA826DDE4A40
80186	HX2 9LS	GB	0101000020E61000009B75C6F7C565FEBF03ECA35357DE4A40
80187	HX2 9PY	GB	0101000020E610000081936DE00E14FEBF8A5759DB14E14A40
80188	HX3	GB	0101000020E61000008028983105ABFDBF9A40118B18DE4A40
80189	HX3 0AT	GB	0101000020E61000009C1A683EE7AEFDBFF8DF4A766CDA4A40
80190	HX3 0DL	GB	0101000020E61000003753211E89D7FDBFD658C2DA18DB4A40
80191	HX3 0DU	GB	0101000020E610000086A92D7590D7FDBFE1F08288D4DA4A40
80192	HX3 5AX	GB	0101000020E6100000679AB0FD64CCFDBF46D26EF431DD4A40
80193	HX3 5RW	GB	0101000020E610000033C170AE6106FEBFB16D516683DE4A40
80194	HX3 6DD	GB	0101000020E6100000492F6AF7ABC0FDBF28603B18B1DD4A40
80195	HX3 6LW	GB	0101000020E6100000DDB243FCC3D6FDBF3A05F9D9C8DD4A40
80196	HX3 7HS	GB	0101000020E610000027A25F5B3FBDFCBFB378B13044E04A40
80197	HX3 7RP	GB	0101000020E6100000D5E940D653EBFCBF6B44300E2EE14A40
80198	HX3 7RR	GB	0101000020E61000004C37894160E5FCBF9B8E006E16E14A40
80199	HX3 8HN	GB	0101000020E61000004208C8975001FDBF30134548DDDC4A40
80200	HX3 8NJ	GB	0101000020E6100000844BC79C67ECFCBFD55E44DB31DD4A40
80201	HX3 8UD	GB	0101000020E6100000C5C72764E7ADFCBFD8D825AAB7DC4A40
80202	HX3 9AL	GB	0101000020E6100000EE9579ABAE83FDBFF2D077B7B2DA4A40
80203	HX3 9LD	GB	0101000020E610000059A2B3CC2294FDBF51DB865110DA4A40
80204	HX4	GB	0101000020E6100000A8E0F08288D4F4BFCEFDD5E3BEFB4A40
80205	HX4 0HD	GB	0101000020E6100000876EF607CAADFEBFC2FBAA5CA8D64A40
80206	HX4 9HF	GB	0101000020E6100000179B560A811CFEBF3ECE3461FBD54A40
80207	HX4 9HS	GB	0101000020E610000010B22C98F823FEBF1DE6CB0BB0D54A40
80208	HX5 0AJ	GB	0101000020E6100000F793313ECC5EFDBF67F3380CE6D74A40
80209	HX5 0LD	GB	0101000020E6100000162F1686C869FDBFF29A577556D74A40
80210	HX5 9ES	GB	0101000020E61000009CF86A47714EFDBFBF7FF3E2C4D74A40
80211	HX5 9QJ	GB	0101000020E6100000DC68006F8144FDBFE0F3C308E1D74A40
80212	HX6	GB	0101000020E61000000C3ECDC98B0CFFBF9886E12362D64A40
80213	HX6 0DT	GB	0101000020E61000009A0645F30056FEBF9A5B21ACC6DC4A40
80214	HX6 1BS	GB	0101000020E61000002B51F69672BEFEBFE08442041CDA4A40
80215	HX6 2AG	GB	0101000020E6100000FD851E317A6EFEBF2A560DC2DCDA4A40
80216	HX6 2HR	GB	0101000020E6100000ABAE43352599FEBF6B2DCC423BDB4A40
80217	HX6 2HY	GB	0101000020E61000003561FBC9189FFEBF043A933655DB4A40
80218	HX6 2UJ	GB	0101000020E61000006803B00111A2FEBF008DD2A57FDB4A40
80219	HX6 3DU	GB	0101000020E6100000ACA92C0ABB28FFBF4D672783A3D84A40
80220	HX6 3LB	GB	0101000020E610000094BE1072DE7FFEBFD906EE409DDA4A40
80221	HX6 4DA	GB	0101000020E61000005859DB148F0BFFBF69AB92C83ED64A40
80222	HX6 4LN	GB	0101000020E6100000C022BF7E888DFFBFE5F21FD26FD54A40
80223	HX6 4ND	GB	0101000020E6100000A08B868C4729FFBF813E912749D74A40
80224	HX6 4NH	GB	0101000020E6100000F8F9EFC16B97FFBFF6F065A208D74A40
80225	HX6 4NQ	GB	0101000020E610000087BF266BD483FFBFE09F5225CAD64A40
80226	HX6 4QB	GB	0101000020E610000052280B5F5F2BFFBF83A279008BD44A40
80227	HX6 4RS	GB	0101000020E6100000F0C4AC174339FFBF8E7406465ED44A40
80228	HX6 4RZ	GB	0101000020E610000074965984622BFFBFF54A598638D44A40
80229	HX7	GB	0101000020E61000006956B60F790B00C05E13D21A83DE4A40
80230	HX7 5AA	GB	0101000020E6100000A437DC476ECDFFBF4568041BD7DD4A40
80231	HX7 5DZ	GB	0101000020E61000008F705AF0A2AFFFBF21CEC3094CDD4A40
80232	HX7 5HQ	GB	0101000020E6100000C5724BAB21B1FFBF9293895B05DD4A40
80233	HX7 6DG	GB	0101000020E610000094C151F2EA3C00C052616C21C8DF4A40
80234	HX7 6JE	GB	0101000020E61000000FBA84436F1100C02E3883BF5FDE4A40
80235	HX7 6JJ	GB	0101000020E610000068AF3E1EFA2E00C0D1798D5DA2DC4A40
80236	HX7 6LZ	GB	0101000020E610000037C478CDAB3A00C0DA39CD02EDDE4A40
80237	HX7 6NR	GB	0101000020E6100000529CA38E8E4B00C07F130A1170DE4A40
80238	HX7 6NX	GB	0101000020E6100000B2A03028D34800C01920D1048ADE4A40
80239	HX7 7DT	GB	0101000020E6100000C5AA4198DB1D00C07B88467710DF4A40
80240	HX7 7HA	GB	0101000020E610000075392520264100C005C24EB16AE04A40
80241	HX7 7JX	GB	0101000020E610000018213CDA388200C003E962D34ADF4A40
80242	HX7 7ND	GB	0101000020E610000072512D228A2900C01F6ADB300AE04A40
80243	HX7 7NS	GB	0101000020E610000072FC5069C42C00C0598638D6C5DF4A40
80244	HX7 7NX	GB	0101000020E6100000DD257156442D00C089618731E9DF4A40
80245	HX7 8AU	GB	0101000020E610000069C4CC3E8F1100C03D9E961FB8DE4A40
80246	HX7 8DE	GB	0101000020E6100000E9EE3A1BF20F00C0E1D231E719DF4A40
80247	HX7 8HL	GB	0101000020E61000002FF834272F1200C002124DA088DF4A40
80248	HX7 8HQ	GB	0101000020E6100000BA2F67B62B1400C0DA0418963FDF4A40
80249	HX7 8LR	GB	0101000020E6100000508C2C99631900C0CE6C57E883DF4A40
80250	HX7 8SZ	GB	0101000020E61000005AD5928E721000C03F00A94D9CE04A40
80251	IG1	GB	0101000020E61000009C14E63DCE34B13F514CDE0033C74940
80252	IG1 1QN	GB	0101000020E6100000E25817B7D100B63F58C6866EF6C74940
80253	IG1 1XZ	GB	0101000020E610000014083BC5AA41B83F8A5759DB14C74940
80254	IG1 2PA	GB	0101000020E610000041D47D00529BB43FFE0C6FD6E0C74940
80255	IG1 3BL	GB	0101000020E610000047AD307DAF21B03FAB5AD2510EC84940
80256	IG1 3LD	GB	0101000020E6100000D636C5E3A25AAC3FDFE00B93A9C84940
80257	IG1 3NN	GB	0101000020E61000007C80EECB99EDAA3F17F032C346C94940
80258	IG1 4AR	GB	0101000020E610000029CB10C7BAB8B93F28EE7893DFC84940
80259	IG1 4DU	GB	0101000020E6100000ED9DD1562591B13F249D819197C74940
80260	IG1 4HP	GB	0101000020E610000090BDDEFDF15EB53F3B8C497F2FC74940
80261	IG1 4TA	GB	0101000020E6100000881057CEDE19B13F5A7F4B00FEC74940
80262	IG1 4TT	GB	0101000020E6100000B5A7E49CD843B33F9CA6CF0EB8C84940
80263	IG10 1	GB	0101000020E6100000274D83A27900AB3F8104C58F31D34940
80264	IG10 1LR	GB	0101000020E610000023F8DF4A766CB03F3DD4B66114D44940
80265	IG10 1LT	GB	0101000020E61000001E882CD2C43BB03FA2427573F1D34940
80266	IG10 1PX	GB	0101000020E6100000DB148F8B6A11B13F4224438EADD34940
80267	IG10 2	GB	0101000020E61000002E1D739EB12FB53FF1B73D4162D34940
80268	IG10 2NS	GB	0101000020E6100000D2C5A6954220B33F3E42CD902AD44940
80269	IG10 2QN	GB	0101000020E610000048C0E8F2E670B13F39D55A9885D44940
80270	IG10 2QQ	GB	0101000020E61000003E95D39E9273B23FE14389963CD44940
80271	IG10 3	GB	0101000020E61000006133C005D9B2B03F5797530262D24940
80272	IG10 3EW	GB	0101000020E61000006B990CC7F319B03F2783A3E4D5D14940
80273	IG10 3RW	GB	0101000020E6100000ABB019E0826CB53F48C153C895D24940
80274	IG10 3TS	GB	0101000020E61000000FEECEDA6D17B63F5890662C9AD24940
80275	IG10 4	GB	0101000020E6100000C9224DBC033CA93FBB9D7DE541D24940
80276	IG10 4BP	GB	0101000020E6100000988A8D791D71B03FFF791A3048D44940
80277	IG10 4EN	GB	0101000020E61000006C239EEC6646A73F88F71C588ED24940
80278	IG10 4JJ	GB	0101000020E61000008E91EC116A86A43FBDFBE3BD6AD14940
80279	IG10 4PD	GB	0101000020E6100000530438BD8BF7AB3F9128B4ACFBD14940
80280	IG10 4PL	GB	0101000020E6100000CC9717601F9DAA3F6058FE7C5BD24940
80281	IG10 4QA	GB	0101000020E61000002FA86F99D365B13FD4D4B2B5BED24940
80282	IG11	GB	0101000020E61000002716F88A6EBDBA3FD0D2156C23C64940
80283	IG11 0JP	GB	0101000020E61000001BD65416855DBC3FEE5D83BEF4C24940
80284	IG11 0RD	GB	0101000020E61000007EC9C6832D76BF3FD0F0660DDEC34940
80285	IG11 0XN	GB	0101000020E6100000FDBB3E73D6A7BC3F6C95607138C34940
80286	IG11 7BS	GB	0101000020E610000021054F2157EAB13F17D522A298C44940
80287	IG11 7LU	GB	0101000020E610000065FED137691AB43F31EA5A7B9FC44940
80288	IG11 7RS	GB	0101000020E6100000952C27A1F485B43FD655815A0CC44940
80289	IG11 8TU	GB	0101000020E6100000F2B0506B9A77B43F9A0986730DC54940
80290	IG11 9AL	GB	0101000020E610000095826E2F698CBA3FD31742CEFBC54940
80291	IG11 9BT	GB	0101000020E6100000581F0F7D772BBB3F36751E15FFC54940
80292	IG11 9NF	GB	0101000020E6100000C8CF46AE9B52BA3F5ABDC3EDD0C44940
80293	IG11 9XE	GB	0101000020E610000062855B3E9292B63FCAFCA36FD2C44940
80294	IG2 6AT	GB	0101000020E61000008D45D3D9C9E0B43FD7187442E8C84940
80295	IG2 6DL	GB	0101000020E61000007E71A94A5B5CB33F3DD68C0C72C94940
80296	IG2 6PX	GB	0101000020E6100000A9D898D71187B43F1C78B5DC99C94940
80297	IG2 6UJ	GB	0101000020E610000037FB03E5B67DAF3F0DE2033BFEC94940
80298	IG2 7AA	GB	0101000020E6100000F92EA52E19C7B83F08043A9336C94940
80299	IG2 7AN	GB	0101000020E61000006F0C01C0B167B73F691EC022BFC84940
80300	IG2 7SR	GB	0101000020E6100000DF347D76C075B93FE0BE0E9C33CA4940
80301	IG3	GB	0101000020E610000085B4C6A01342BB3FDC847B65DEC84940
80302	IG3 8LY	GB	0101000020E6100000CEA623809BC5B73FE00ED4298FC84940
80303	IG3 8RE	GB	0101000020E610000000C63368E89FB83F1668774831C84940
80304	IG3 8TN	GB	0101000020E61000000C5BB39597FCBB3F61FA5E4370C84940
80305	IG3 9DW	GB	0101000020E61000007D3F355EBA49C03FA1F48590F3C64940
80306	IG3 9LX	GB	0101000020E61000009AB0FD648C0FBB3F28603B18B1C74940
80307	IG3 9LZ	GB	0101000020E6100000A20DC0064488B73F50FD834886C84940
80308	IG3 9QZ	GB	0101000020E6100000DA740470B378BD3FC89750C1E1C74940
80309	IG3 9TY	GB	0101000020E61000000FEECEDA6D17BA3F1A33897AC1C74940
80310	IG3 9UH	GB	0101000020E61000001BD65416855DBC3F9F77634161C84940
80311	IG4	GB	0101000020E6100000B58CD47B2AA7AD3F4489963C9ECA4940
80312	IG4 5DA	GB	0101000020E6100000B01D8CD82780AA3FD71533C2DBC94940
80313	IG4 5EP	GB	0101000020E6100000B7D4415E0F26AD3F55185B0872CA4940
80314	IG4 5JD	GB	0101000020E61000001F6ADB300A82A73F3ECE3461FBC94940
80315	IG4 5NA	GB	0101000020E6100000253FE257ACE1AA3F62F3716DA8CA4940
80316	IG4 5NP	GB	0101000020E6100000861F9C4F1DABAC3F535E2BA1BBCA4940
80317	IG4 5PH	GB	0101000020E6100000F1F44A598638A63F61A8C30AB7CA4940
80318	IG5 0AG	GB	0101000020E61000000F48C2BE9D44B03F4E61A5828ACA4940
80319	IG5 0AZ	GB	0101000020E61000002B155454FD4AAF3F67F1626188CA4940
80320	IG5 0BL	GB	0101000020E6100000C1CAA145B6F3B13F2191B6F127CC4940
80321	IG5 0BP	GB	0101000020E610000083BEF4F6E7A2B13FEDF483BA48CB4940
80322	IG5 0DP	GB	0101000020E61000008369183E22A6AC3F3F1A4E999BCB4940
80323	IG5 0JJ	GB	0101000020E6100000F9653046240AAD3F91B8C7D287C84940
80324	IG5 0JW	GB	0101000020E61000005794128255F5AA3F118AADA069CB4940
80325	IG5 0QE	GB	0101000020E6100000B1A371A8DF85B13FEE93A30051CC4940
80326	IG5 0TP	GB	0101000020E6100000CEFC6A0E10CCB13F20240B98C0CB4940
80327	IG5 0XL	GB	0101000020E61000006EA296E65608B33F16BF29AC54CC4940
80328	IG6	GB	0101000020E61000009D2B4A09C1AABA3F14083BC5AACD4940
80329	IG6 1AB	GB	0101000020E6100000DCA0F65B3B51B63FA41B615111CB4940
80330	IG6 1HY	GB	0101000020E6100000180AD80E46ECB33F2DEC6987BFCA4940
80331	IG6 1LG	GB	0101000020E61000001F10E84CDA54B53FA1F5F065A2CA4940
80332	IG6 2AR	GB	0101000020E6100000CD57C9C7EE02B53F3E03EACDA8CB4940
80333	IG6 2AY	GB	0101000020E610000069AD68739CDBB43FFF9254A698CB4940
80334	IG6 2DZ	GB	0101000020E610000090BDDEFDF15EB53F7FDB1324B6CB4940
80335	IG6 2RA	GB	0101000020E6100000D238D4EFC2D6B03F8E05854199CC4940
80336	IG6 2RN	GB	0101000020E6100000A0FCDD3B6A4CB43F938C9C853DCD4940
80337	IG6 2SG	GB	0101000020E6100000B48EAA2688BAB33F22AB5B3D27CD4940
80338	IG6 2SX	GB	0101000020E610000055D97745F0BFB53F9679ABAE43CD4940
80339	IG6 2UR	GB	0101000020E6100000B1FCF9B660A9B63F50E449D235CD4940
80340	IG7 4BN	GB	0101000020E6100000D1CB28965B5AB93F9C16BCE82BCE4940
80341	IG7 4DZ	GB	0101000020E610000024B4E55C8AABB63F46EEE9EA8ECF4940
80342	IG7 5BH	GB	0101000020E61000007461A417B5FBB13F7EAB75E272CE4940
80343	IG7 5LD	GB	0101000020E6100000C4211B48179BB63FE4486760E4CD4940
80344	IG7 5QB	GB	0101000020E6100000613255302AA9B73F9F94490D6DCE4940
80345	IG7 6NT	GB	0101000020E610000056444DF4F928B33FB535221807CF4940
80346	IG8	GB	0101000020E6100000B933130CE71AA63F874D64E602CF4940
80347	IG8 0AL	GB	0101000020E610000009C3802557B1A03F8524B37A87CD4940
80348	IG8 0JN	GB	0101000020E61000009D6681768714A33F1B9FC9FE79CE4940
80349	IG8 0NN	GB	0101000020E61000002EC55565DF15A13F05C1E3DBBBCE4940
80350	IG8 8DW	GB	0101000020E61000006D8C9DF0129CAA3F6938656EBECD4940
80351	IG8 8DY	GB	0101000020E61000004E97C5C4E6E3AA3FB07614E7A8CD4940
80352	IG8 8HA	GB	0101000020E6100000AFCDC64ACCB3AA3FD0436D1B46CD4940
80353	IG8 8LS	GB	0101000020E6100000527C7C4276DEA63F27F73B1405CC4940
80354	IG8 8NW	GB	0101000020E6100000B95510035DFBAA3F7555A01683CD4940
80355	IG8 9DD	GB	0101000020E6100000971AA19FA9D79D3F03B00111E2CC4940
80356	IG8 9JT	GB	0101000020E6100000C8CEDBD8EC48953F9198A0866FCD4940
80357	IG8 9LG	GB	0101000020E6100000D55B035B25586C3F7EC51A2E72CD4940
80358	IG8P	GB	0101000020E6100000EA42ACFE08C3A03F9692E52494CE4940
80359	IG9	GB	0101000020E6100000FF209221C7D6AB3FB5183C4CFBCE4940
80360	IG9 5AH	GB	0101000020E6100000D36A48DC63E9A33F79B29B19FDCE4940
80361	IG9 5ET	GB	0101000020E61000007E00529B38B9A73F5C72DC291DD04940
80362	IG9 5SS	GB	0101000020E6100000B265F9BA0CFFA13F5AD93EE42DD14940
80363	IG9 5TS	GB	0101000020E6100000DBDB2DC901BB9A3F68EBE0606FD04940
80364	IG9 6BJ	GB	0101000020E6100000ECC1A4F8F884B03F514F1F813FD04940
80365	IG9 6HX	GB	0101000020E61000002101A3CB9BC3A53F959D7E5017CF4940
80366	IG9 6LN	GB	0101000020E610000089EC832C0B26A63F04013274ECCE4940
80367	IM1 1	GB	0101000020E61000006C3EAE0D15F311C02A55A2EC2D134B40
80368	IM1 1AD	GB	0101000020E610000020F12BD670F111C039D384ED27134B40
80369	IM1 1BY	GB	0101000020E6100000EBE1CB4411F211C0957EC2D9AD134B40
80370	IM1 1EQ	GB	0101000020E61000009A05DA1D52EC11C074EE76BD34134B40
80371	IM1 2AA	GB	0101000020E610000044DC9C4A06F011C032569BFF57134B40
80372	IM1 2AY	GB	0101000020E6100000A8DF85ADD9EA11C016A6EF3504134B40
80373	IM1 2EA	GB	0101000020E61000004982700514EA11C0E129E44A3D134B40
80374	IM1 2HG	GB	0101000020E6100000AE282504ABEA11C0F452B131AF134B40
80375	IM1 2HP	GB	0101000020E6100000501DAB949EE911C08048BF7D1D144B40
80376	IM1 2LE	GB	0101000020E6100000C556D0B4C4EA11C0E65B1FD61B134B40
80377	IM1 2LY	GB	0101000020E610000038F4160FEFE911C01764CBF275134B40
80378	IM1 2PT	GB	0101000020E610000083A279008BEC11C0C520B07268134B40
80379	IM1 3AG	GB	0101000020E61000004FE78A5242F011C0AB9509BFD4134B40
80380	IM1 3LY	GB	0101000020E6100000D78A36C7B9ED11C064CC5D4BC8134B40
80381	IM1 4AZ	GB	0101000020E6100000E063B0E254EB11C0971DE21FB6124B40
80382	IM1 4HB	GB	0101000020E610000010E84CDA54FD11C063D2DF4BE1134B40
80383	IM1 4QA	GB	0101000020E610000061DEE34C13F611C0E36DA5D766134B40
80384	IM1 5AX	GB	0101000020E6100000BCCCB051D6EF11C0BDC3EDD0B0124B40
80385	IM1 5BF	GB	0101000020E61000009032E202D0E811C04C50C3B7B0124B40
80386	IM1 5BW	GB	0101000020E610000003EB387EA8E411C07FC2D9AD65124B40
80387	IM1 5ED	GB	0101000020E6100000E7C8CA2F830112C009DFFB1BB4134B40
80388	IM1 5PT	GB	0101000020E6100000B6BA9C1210F311C0CFA2772AE0124B40
80389	IM1 5PZ	GB	0101000020E610000056B77A4E7AFF11C0D95BCAF962134B40
80390	IM2	GB	0101000020E6100000CBF5B6990AE111C0234E27D9EA164B40
80391	IM2 1AS	GB	0101000020E61000000C570740DC0512C07D410B0918134B40
80392	IM2 1HB	GB	0101000020E6100000F790F0BDBF0112C0560DC2DCEE134B40
80393	IM2 1HE	GB	0101000020E6100000E9F2E670AD0612C02D060FD3BE134B40
80394	IM2 1QB	GB	0101000020E6100000572426A8E1FB11C0B91CAF40F4124B40
80395	IM2 1QD	GB	0101000020E6100000DB5031CEDF0412C00E32C9C859124B40
80396	IM2 1QH	GB	0101000020E6100000BEA085048C0E12C051DA1B7C61124B40
80397	IM2 2AA	GB	0101000020E610000015014EEFE21D12C00229B16B7B134B40
80398	IM2 2QT	GB	0101000020E610000037E33444151E12C05ED6C4025F134B40
80399	IM2 2QZ	GB	0101000020E61000007CEE04FBAF2312C050C58D5BCC134B40
80400	IM2 2RD	GB	0101000020E610000015562AA8A80A12C05AA148F773144B40
80401	IM2 2SA	GB	0101000020E61000009AEC9FA7012312C05227A089B0134B40
80402	IM2 2SR	GB	0101000020E61000007F129F3BC11E12C029CFBC1C76134B40
80403	IM2 3EY	GB	0101000020E610000030F488D173EB11C08E3A3AAE46144B40
80404	IM2 3JA	GB	0101000020E610000078280AF489EC11C03CBCE7C072144B40
80405	IM2 3QL	GB	0101000020E610000015C8EC2C7AF711C03A799109F8134B40
80406	IM2 4BS	GB	0101000020E6100000A86E2EFEB6E711C08A929048DB144B40
80407	IM2 4EL	GB	0101000020E61000005D363AE7A7E811C08C648F5033144B40
80408	IM2 4EW	GB	0101000020E6100000E3546B6116EA11C0253D0CAD4E144B40
80409	IM2 4NR	GB	0101000020E6100000C4D2C08F6AD811C0EEB3CA4C69154B40
80410	IM2 4NS	GB	0101000020E61000000CAF2479AEDF11C08CDCD3D51D154B40
80411	IM2 4RD	GB	0101000020E6100000E23D079623E411C01503249A40154B40
80412	IM2 4RG	GB	0101000020E6100000F5B9DA8AFDE511C08A3F8A3A73154B40
80413	IM2 5BS	GB	0101000020E6100000B0743E3C4BF011C0E42D573F36154B40
80414	IM2 5EQ	GB	0101000020E6100000F6622827DAF511C0FBCBEEC9C3144B40
80415	IM2 5HZ	GB	0101000020E6100000965D30B8E6EE11C0E140481630154B40
80416	IM2 5PA	GB	0101000020E6100000F75AD07B63F811C007793D9814154B40
80417	IM2 5RA	GB	0101000020E61000000118CFA0A1EF11C07D5EF1D423154B40
80418	IM2 6AW	GB	0101000020E61000001ADCD6169EE711C0D95A5F24B4154B40
80419	IM2 6BA	GB	0101000020E61000001EC022BF7EE811C00322C495B3154B40
80420	IM3 1BA	GB	0101000020E6100000A33B889D29D411C06556EF703B164B40
80421	IM3 1ED	GB	0101000020E61000009929ADBF25D011C002D8800871154B40
80422	IM3 1HE	GB	0101000020E6100000E1B721C66BCE11C0C7681D554D164B40
80423	IM3 2JP	GB	0101000020E61000005C8DEC4ACBB811C013286211C3164B40
80424	IM3 4LZ	GB	0101000020E61000008ECBB8A981E611C02849D74CBE154B40
80425	IM4 1EG	GB	0101000020E6100000C2DD59BBED5212C0CA6E66F4A30F4B40
80426	IM4 1JE	GB	0101000020E6100000B85B9203763512C0AE0E80B8AB114B40
80427	IM4 1JH	GB	0101000020E61000002EE6E786A61C12C0B8B06EBC3B124B40
80428	IM4 1JJ	GB	0101000020E61000001152B7B3AF1C12C00F5F268A90124B40
80429	IM4 2AJ	GB	0101000020E6100000F52EDE8FDB4F12C035B742588D134B40
80430	IM4 2HN	GB	0101000020E6100000706072A3C85A12C0C1E61C3C13144B40
80431	IM4 2HT	GB	0101000020E6100000153B1A87FA3D12C09F73B7EBA5114B40
80432	IM4 2LX	GB	0101000020E6100000BEBED6A5466812C05CC64D0D34194B40
80433	IM4 3AS	GB	0101000020E6100000F67EA31D378C12C0F3C81F0C3C194B40
80434	IM4 3BA	GB	0101000020E61000003A234A7B838F12C099B7EA3A54174B40
80435	IM4 3BE	GB	0101000020E6100000F0C4AC17439912C0DE1E84807C174B40
80436	IM4 3EF	GB	0101000020E6100000D6726726188E12C0357C0BEBC6154B40
80437	IM4 3ES	GB	0101000020E61000001570CFF3A78D12C0DB4FC6F830134B40
80438	IM4 3EX	GB	0101000020E6100000C7F5EFFACC8912C0B3B45373B9154B40
80439	IM4 3HL	GB	0101000020E6100000011764CBF27512C0F90FE9B7AF154B40
80440	IM4 3HW	GB	0101000020E6100000EC681CEA777112C05A47551344154B40
80441	IM4 3JH	GB	0101000020E610000053758F6CAE8A12C0A3906456EF184B40
80442	IM4 3NA	GB	0101000020E61000004CC631923D9212C0DBA4A2B1F6194B40
80443	IM4 3NF	GB	0101000020E61000008B34F10EF08412C037A968ACFD194B40
80444	IM4 3NP	GB	0101000020E6100000B5FB5580EF7612C066BCADF4DA1C4B40
80445	IM4 4	GB	0101000020E6100000367689EAAD4112C072DD94F25A174B40
80446	IM4 4AR	GB	0101000020E61000006A6CAF05BD1712C04417D4B7CC154B40
80447	IM4 4BN	GB	0101000020E61000006747AAEFFC4212C00BB6114F76174B40
80448	IM4 4HT	GB	0101000020E6100000780C8FFD2C1612C002A08A1BB7164B40
80449	IM4 4HX	GB	0101000020E6100000E2E82ADD5D1712C096B377465B174B40
80450	IM4 4LH	GB	0101000020E6100000091A33897A1112C07993DFA293154B40
80451	IM4 4NE	GB	0101000020E61000008351499D801612C0A8E3310395154B40
80452	IM4 4QE	GB	0101000020E61000009487855AD3FC11C08177F2E9B1154B40
80453	IM4 4QU	GB	0101000020E6100000A92EE065860D12C0B91803EB38164B40
80454	IM4 4RD	GB	0101000020E6100000508C2C99633912C0B9347EE195164B40
80455	IM4 4RJ	GB	0101000020E6100000FA298E03AF0612C012A5BDC117164B40
80456	IM4 5BP	GB	0101000020E61000000038F6ECB9DC11C046EBA86A821A4B40
80457	IM4 5EP	GB	0101000020E610000009C38025571112C02B1213D4F0194B40
80458	IM4 5EY	GB	0101000020E61000008B506C054D1B12C06552431B80194B40
80459	IM4 6AE	GB	0101000020E6100000810706103EB411C01041D5E8D5184B40
80460	IM4 6DU	GB	0101000020E61000003E26529ACDA311C05B785E2A361A4B40
80461	IM4 6ET	GB	0101000020E6100000FCFB8C0B07A211C037FFAF3A721A4B40
80462	IM4 7AA	GB	0101000020E610000023F59ECA699F11C04C530438BD1D4B40
80463	IM4 7DP	GB	0101000020E61000004606B98B309511C081785DBF601D4B40
80464	IM4 7HB	GB	0101000020E6100000E4874A2366A611C021C84109331B4B40
80465	IM4 7HR	GB	0101000020E61000008121AB5B3D9711C07BA180ED601C4B40
80466	IM4 7JP	GB	0101000020E6100000514A0856D59B11C0A9328CBB411C4B40
80467	IM4 7NL	GB	0101000020E610000047B071FDBB9E11C0973B33C1701E4B40
80468	IM5 1	GB	0101000020E61000000CE8853B17C612C02332ACE28D1C4B40
80469	IM5 2AN	GB	0101000020E6100000BC02D19332A912C0F6622827DA1B4B40
80470	IM5 3	GB	0101000020E61000002BF86D88F1DA12C055F65D11FC174B40
80471	IM5 3AZ	GB	0101000020E6100000F0517FBDC2D212C082E673EE76174B40
80472	IM5 3BA	GB	0101000020E61000005F09A4C4AECD12C0DD5F3DEE5B174B40
80473	IM5 3BJ	GB	0101000020E610000077D9AF3BDDD912C02CA0504F1F174B40
80474	IM5 3BP	GB	0101000020E6100000A0C6BDF90DE312C0CF2EDFFAB0164B40
80475	IM5 3BT	GB	0101000020E6100000DEE8633E20F012C0C2F9D4B14A154B40
80476	IM6 1	GB	0101000020E61000005E49F25CDF5712C007CE1951DA234B40
80477	IM6 1AZ	GB	0101000020E6100000EE96E4805D5D12C0A29A92ACC3234B40
80478	IM6 2EY	GB	0101000020E6100000EB8CEF8B4B4512C0E529ABE97A264B40
80479	IM7 1AL	GB	0101000020E6100000259529E6206811C0FFE9060ABC274B40
80480	IM7 1AS	GB	0101000020E6100000AAD72D02633D11C0DE74CB0EF1254B40
80481	IM7 1AY	GB	0101000020E610000035B401D8805811C01AC1C6F5EF244B40
80482	IM7 1BH	GB	0101000020E6100000E4F736FDD96F11C0E35295B6B8264B40
80483	IM7 1EL	GB	0101000020E61000005AB8ACC2662011C09E978A8D791F4B40
80484	IM7 1ES	GB	0101000020E61000008E23D6E2538011C0DD408177F2234B40
80485	IM7 1HP	GB	0101000020E6100000B22B2D23F57E11C0ED832C0B26204B40
80486	IM7 2HR	GB	0101000020E61000000114234BE6F811C0C0249529E6284B40
80487	IM7 3	GB	0101000020E61000000A4AD1CABDC011C0CAA8328CBB314B40
80488	IM7 3AJ	GB	0101000020E61000000DC51D6FF20B12C046EA3D95D32C4B40
80489	IM7 3HA	GB	0101000020E6100000C1E10511A9F911C0CBBC55D7A12E4B40
80490	IM7 4	GB	0101000020E610000015A8C5E061AA11C055D97745F02F4B40
80491	IM7 4AQ	GB	0101000020E6100000003620425C8911C03B6F63B3232D4B40
80492	IM7 4BS	GB	0101000020E610000027A089B0E17911C07E9065C1C4334B40
80493	IM7 5EG	GB	0101000020E61000001233FB3C462912C06745D4449F274B40
80494	IM7 5EN	GB	0101000020E610000043ACFE08C33012C01494A2957B274B40
80495	IM8 1	GB	0101000020E6100000FE9E58A7CA8711C0BB7CEBC37A294B40
80496	IM8 3TD	GB	0101000020E6100000081F4AB4E4A111C093ACC3D1552A4B40
80497	IM8 3UN	GB	0101000020E610000082751C3F548A11C0D5415E0F262B4B40
80498	IM9 1	GB	0101000020E61000004F07B29E5A9D12C08AADA06989094B40
80499	IM9 1AB	GB	0101000020E61000000C01C0B1679F12C0802C4487C0094B40
80500	IM9 1DF	GB	0101000020E6100000377172BF439112C01B498270050A4B40
80501	IM9 1EF	GB	0101000020E610000046B1DCD26A9812C0C4EA8F300C0A4B40
80502	IM9 1LD	GB	0101000020E6100000C2D9AD65329C12C08448861C5B094B40
80503	IM9 1RD	GB	0101000020E61000002DB5DE6FB4A312C0CF6BEC12D5094B40
80504	IM9 1RE	GB	0101000020E6100000613596B036A612C0AC38D55A98094B40
80505	IM9 1TP	GB	0101000020E610000026E4839ECD8A12C0D26EF4311F0A4B40
80506	IM9 1TU	GB	0101000020E6100000232E008DD27512C09624CFF57D0A4B40
80507	IM9 1UA	GB	0101000020E61000005628D2FD9C7212C0E8F7FD9B17094B40
80508	IM9 1UB	GB	0101000020E61000002DD0EE90628012C04698A25C1A074B40
80509	IM9 2	GB	0101000020E61000009E7E5017298412C0E3C798BB960C4B40
80510	IM9 2AH	GB	0101000020E610000098A432C51C8412C05F0839EFFF0B4B40
80511	IM9 2DA	GB	0101000020E6100000C1AA7AF99D8612C061E3FA777D0C4B40
80512	IM9 2DD	GB	0101000020E6100000C2BD326FD58512C096986725AD0C4B40
80513	IM9 2EL	GB	0101000020E61000006534F279C58312C0FBE8D495CF0C4B40
80514	IM9 2LB	GB	0101000020E610000000FDBE7FF38212C0A24621C9AC0C4B40
80515	IM9 3AE	GB	0101000020E6100000B05758703F7012C099D87C5C1B0E4B40
80516	IM9 3AH	GB	0101000020E61000009D2CB5DE6F7412C077BAF3C473104B40
80517	IM9 3AQ	GB	0101000020E6100000DFA3FE7A856512C0DB17D00B77104B40
80518	IM9 3AS	GB	0101000020E61000007E52EDD3F15812C0450E1137A7124B40
80519	IM9 3AT	GB	0101000020E6100000A33D5E48878712C08E3EE60302114B40
80520	IM9 3AW	GB	0101000020E610000003B16CE6907412C07A522635B4114B40
80521	IM9 3BA	GB	0101000020E610000000E65AB4009D12C06BD3D85E0B124B40
80522	IM9 3BD	GB	0101000020E61000006C3EAE0D15A312C01CEDB8E1770F4B40
80523	IM9 3DJ	GB	0101000020E610000053EC681CEA9712C0AB3DEC85020C4B40
80524	IM9 3DN	GB	0101000020E610000099620E828EA612C0B43A3943710D4B40
80525	IM9 3DS	GB	0101000020E6100000ECF7C43A558E12C0F01472A59E0D4B40
80526	IM9 3DW	GB	0101000020E6100000012F336C949512C09BE7887C970C4B40
80527	IM9 4AB	GB	0101000020E6100000C8940F41D5D812C092205C01850C4B40
80528	IM9 4AT	GB	0101000020E61000000C90680245DC12C0473A03232F0B4B40
80529	IM9 4AZ	GB	0101000020E6100000EA5BE67459EC12C01781B1BE810B4B40
80530	IM9 4BB	GB	0101000020E6100000D9B3E73235E912C03C50A73CBA0B4B40
80531	IM9 4BS	GB	0101000020E6100000CDE49B6D6EDC12C0871744A4A60D4B40
80532	IM9 4BZ	GB	0101000020E6100000FA7C941117E012C0A79201A08A0B4B40
80533	IM9 4EA	GB	0101000020E61000008DEE2076A6A012C047718E3A3A0A4B40
80534	IM9 4HB	GB	0101000020E61000003D1059A489B712C0AB7B6473D50C4B40
80535	IM9 4LR	GB	0101000020E61000003813D38558CD12C0B3B27DC85B0C4B40
80536	IM9 4PJ	GB	0101000020E610000022C66B5ED5B912C0F833BC5983094B40
80537	IM9 4PN	GB	0101000020E61000007C9A931799C012C0C405A051BA0A4B40
80538	IM9 4PQ	GB	0101000020E6100000C097C28366B712C0C63368E89F0A4B40
80539	IM9 5AF	GB	0101000020E6100000508A56EE05F612C07F4FAC53E5094B40
80540	IM9 5BF	GB	0101000020E61000002922C32ADEF812C0F6ECB94C4D0A4B40
80541	IM9 5EF	GB	0101000020E6100000A3AD4A22FBF012C0E90DF7915B094B40
80542	IM9 5LD	GB	0101000020E61000006C21C841090313C039D0436D1B0A4B40
80543	IM9 5LQ	GB	0101000020E6100000450DA661F8F812C04E44BFB67E0A4B40
80544	IM9 5LW	GB	0101000020E61000002AA913D044F812C07C2B1213D40A4B40
80545	IM9 5LZ	GB	0101000020E61000000D33349E08E212C0548B8862F20A4B40
80546	IM9 5NE	GB	0101000020E6100000B75F3E5931EC12C0DDD0949D7E0A4B40
80547	IM9 5PQ	GB	0101000020E61000006ABDDF68C7FD12C05A9E077767094B40
80548	IM9 5PS	GB	0101000020E6100000F3734353762A13C01D59F96530084B40
80549	IM9 6	GB	0101000020E6100000BE4C1421750B13C04C55DAE21A0B4B40
80550	IM9 6AQ	GB	0101000020E6100000DB6FED44490813C0AF44A0FA070B4B40
80551	IM9 6EX	GB	0101000020E610000080B74082E20713C0DA91EA3BBF0A4B40
80552	IM9 6JB	GB	0101000020E6100000B72A89EC830C13C0D6ABC8E8800A4B40
80553	IM9 6LN	GB	0101000020E61000006440F67AF70713C0F31FD26F5F0B4B40
80554	IM9 6PP	GB	0101000020E6100000193735D07C0E13C03C6C2233170C4B40
80555	IM9 6QZ	GB	0101000020E61000003E7958A835FD12C05DC2A1B7780C4B40
80556	IM9 6TT	GB	0101000020E61000003929CC7B9CF912C00F99F221A80C4B40
80557	IP1	GB	0101000020E6100000003961C268D6F23F61E0B9F770054A40
80558	IP1 1AF	GB	0101000020E61000002E3BC43F6C69F23FCD91955F06074A40
80559	IP1 2DE	GB	0101000020E61000002B155454FD4AF23FF701486DE2064A40
80560	IP1 2EX	GB	0101000020E61000000282397AFC5EF23FEE5C18E945074A40
80561	IP1 2HF	GB	0101000020E6100000412D060FD33EF23F9AEAC9FCA3074A40
80562	IP1 2QA	GB	0101000020E610000034F3E49A0259F23F713AC95697074A40
80563	IP1 3JT	GB	0101000020E61000004182E2C7987BF23F4A7D59DAA9074A40
80564	IP1 3PE	GB	0101000020E610000031B1F9B83654F23F0B46257502084A40
80565	IP1 3RD	GB	0101000020E6100000616F62484E66F23FDC68006F81084A40
80566	IP1 3RG	GB	0101000020E61000000A80F10C1A7AF23F9D4B7155D9074A40
80567	IP1 3SA	GB	0101000020E61000008B170B43E474F23F6C223317B8084A40
80568	IP1 4BE	GB	0101000020E6100000FB22A12DE712F23F8081204086084A40
80569	IP1 4BZ	GB	0101000020E6100000F0A7C64B3749F23F0FD6FF39CC074A40
80570	IP1 4LL	GB	0101000020E61000002FA699EE7552F23FE7E099D024094A40
80571	IP1 4QF	GB	0101000020E610000069705B5B781EF23F7D78962023084A40
80572	IP1 5PH	GB	0101000020E61000003447567E19CCF13F91B41B7DCC094A40
80573	IP1 6PN	GB	0101000020E61000007BD7A02FBD3DF23F5184D4EDEC094A40
80574	IP10	GB	0101000020E6100000785E2A36E6B5F33FB1C1C2499A034A40
80575	IP10 0LE	GB	0101000020E6100000E7C3B3041901F43F14799274CD004A40
80576	IP10 0LJ	GB	0101000020E61000007B2FBE688F97F43FCA51802898FF4940
80577	IP10 0LZ	GB	0101000020E610000085419946930BF43FADBF2500FF004A40
80578	IP10 0QW	GB	0101000020E6100000487023658B24F53F15562AA8A8004A40
80579	IP10 0TS	GB	0101000020E61000003A950C00551CF53FEFE2FDB8FDFC4940
80580	IP11	GB	0101000020E6100000E620E86855CBF53FF70489EDEEFB4940
80581	IP11 0SU	GB	0101000020E6100000FC6EBA658738F53FBDC282FB01FD4940
80582	IP11 2HW	GB	0101000020E610000022A98592C969F53F810706103EFA4940
80583	IP11 2PZ	GB	0101000020E6100000787DE6AC4FB9F53F5589B2B794FB4940
80584	IP11 7HF	GB	0101000020E610000029266F8099AFF53F1B9DF3531CFB4940
80585	IP11 7PY	GB	0101000020E6100000CD0182397A7CF53FAB984A3FE1FA4940
80586	IP11 7QP	GB	0101000020E6100000362383DC4598F53FF5F6E7A221FB4940
80587	IP11 7RX	GB	0101000020E610000049DA8D3EE683F53FB329577897FB4940
80588	IP11 7TB	GB	0101000020E6100000658A39083A9AF53F6EC1525DC0FB4940
80589	IP11 9DR	GB	0101000020E61000006D57E883656CF53FE3AAB2EF8AFC4940
80590	IP11 9HB	GB	0101000020E6100000B56D1805C1A3F53F5E2BA1BB24FC4940
80591	IP11 9JD	GB	0101000020E6100000295FD04202C6F53FAE9FFEB3E6FB4940
80592	IP11 9LX	GB	0101000020E6100000AB984A3FE1ECF53F0A67B796C9FC4940
80593	IP11 9QB	GB	0101000020E61000002E8ECA4DD4D2F53F9D103AE812FC4940
80594	IP11 9UD	GB	0101000020E61000003468E89FE0A2F53FE2218C9FC6FB4940
80595	IP12	GB	0101000020E610000084BA48A12CFCF43F1E8997A7730B4A40
80596	IP12 0SZ	GB	0101000020E61000004C16F71F990EF63FF8F9EFC16B174A40
80597	IP12 1LB	GB	0101000020E6100000D15D12674514F53FE02F664B560D4A40
80598	IP12 1LE	GB	0101000020E6100000596C938AC61AF53F969350FA420E4A40
80599	IP12 1LQ	GB	0101000020E6100000A25EF0694EDEF43F60234910AE0C4A40
80600	IP12 1LT	GB	0101000020E610000012A5BDC11766F53F3AAFB14B540D4A40
80601	IP12 1RX	GB	0101000020E610000091B586527B11F53F95D233BDC40C4A40
80602	IP12 1SH	GB	0101000020E6100000768C2B2E8E0AF53FAB5FE97C780C4A40
80603	IP12 1SJ	GB	0101000020E610000098BED7101C17F53FF913950D6B0C4A40
80604	IP12 2AX	GB	0101000020E6100000BA32A8363851F83F730F09DFFB0F4A40
80605	IP12 2NU	GB	0101000020E6100000C6FCDCD0949DF83F94675E0EBB0B4A40
80606	IP12 2PJ	GB	0101000020E61000002D5C566133C0F53F840D4FAF940D4A40
80607	IP12 3BE	GB	0101000020E6100000118B18761813F73F02A08A1BB7024A40
80608	IP12 3DJ	GB	0101000020E6100000F94ECC7A3194F53F1B84B9DDCB0B4A40
80609	IP12 3EE	GB	0101000020E610000096986725ADF8F53F529D0E643D074A40
80610	IP12 3ET	GB	0101000020E610000003B68311FB44F53F70ED4449480A4A40
80611	IP12 3HB	GB	0101000020E61000000C957F2DAF1CF63F5E13D21A83064A40
80612	IP12 3JY	GB	0101000020E61000009E2633DE563AF73F7B13437232074A40
80613	IP12 3RB	GB	0101000020E610000061A6ED5F59E9F63F62F4DC4257064A40
80614	IP12 4AU	GB	0101000020E61000008FC2F5285C0FF53F16FC36C4780B4A40
80615	IP12 4BT	GB	0101000020E61000008C2C996379D7F43F3FA7203F1B0B4A40
80616	IP12 4DT	GB	0101000020E610000078EE3D5C72DCF43F8CBE8234630B4A40
80617	IP12 4EH	GB	0101000020E6100000166D8E739BB0F43FBA83D899420B4A40
80618	IP12 4HA	GB	0101000020E6100000B492567C43E1F43FA8A8FA95CE0B4A40
80619	IP12 4HD	GB	0101000020E610000070287CB60ECEF43F7A008BFCFA0B4A40
80620	IP12 4JH	GB	0101000020E61000001D9430D3F6EFF43F9C8A54185B0C4A40
80621	IP12 4JP	GB	0101000020E610000023827170E9D8F43FCD1E6805860C4A40
80622	IP12 4NR	GB	0101000020E6100000B30B06D7DCD1F43FB2101D0247044A40
80623	IP12 4PW	GB	0101000020E61000002F3201BF4612F53FBA83D89942074A40
80624	IP13 0EH	GB	0101000020E61000004E0AF31E675AF53FA2EE0390DA164A40
80625	IP13 0PB	GB	0101000020E610000073D9E89C9F22F63F42EE224C51144A40
80626	IP13 0PT	GB	0101000020E61000004FE5B4A7E45CF63F3D9CC0745A134A40
80627	IP13 0QF	GB	0101000020E610000086CB2A6C0678F63FF4C0C760C5134A40
80628	IP13 0RU	GB	0101000020E6100000083E062B4EB5F53F1DACFF7398134A40
80629	IP13 0SS	GB	0101000020E6100000EC17EC866DCBF53F8B8862F206144A40
80630	IP13 4AS	GB	0101000020E6100000E068C70DBF1BF33F7A3881E9B42E4A40
80631	IP13 6AD	GB	0101000020E6100000E107E753C7EAF43FE1D1C6116B0F4A40
80632	IP13 6BY	GB	0101000020E61000007D23BA675D63F43F4913EF004F124A40
80633	IP13 6DP	GB	0101000020E61000002C6684B707A1F53F32225168590F4A40
80634	IP13 6EL	GB	0101000020E610000068EA758BC098F53FC172840CE40F4A40
80635	IP13 6ES	GB	0101000020E610000078978BF84E8CF53F68AED3484B0F4A40
80636	IP13 7EE	GB	0101000020E61000005CC98E8D403CF43F29965B5A0D1F4A40
80637	IP13 7LR	GB	0101000020E6100000CE88D2DEE04BF43FEB5223F433214A40
80638	IP13 8AZ	GB	0101000020E61000001C615111A753F53F8429CAA5F1214A40
80639	IP13 8EW	GB	0101000020E6100000855B3E92925EF53FAC1919E42E284A40
80640	IP13 8HW	GB	0101000020E61000001233FB3C46F9F53F86014BAE62234A40
80641	IP13 9	GB	0101000020E610000056F0DB10E3F5F43FA663CE33F61B4A40
80642	IP13 9LL	GB	0101000020E6100000EA58A5F44CAFF53F6C938AC6DA194A40
80643	IP13 9QU	GB	0101000020E6100000F8A8BF5E61C1F43FFD8348861C1F4A40
80644	IP13 9SJ	GB	0101000020E610000002BB9A3C6575F53F39D0436D1B1C4A40
80645	IP14 1QJ	GB	0101000020E610000059FAD005F5ADEF3F04E78C28ED174A40
80646	IP14 1RQ	GB	0101000020E61000004CFDBCA94805F03F00AE64C746184A40
80647	IP14 2AX	GB	0101000020E610000083F8C08EFF02F03F0E863AAC70174A40
80648	IP14 2HT	GB	0101000020E610000073A087DA360CEF3FD4B837BF61124A40
80649	IP14 3EJ	GB	0101000020E6100000C573B680D0FAEE3FD6027B4CA4184A40
80650	IP14 3PR	GB	0101000020E61000006FBBD05CA711EF3F88A06AF46A1C4A40
80651	IP14 4BJ	GB	0101000020E610000079B29B19FD68F03FABAE433525194A40
80652	IP14 4BQ	GB	0101000020E6100000056A31789876F03F4293C49272194A40
80653	IP14 4EB	GB	0101000020E6100000BFBA2A508B01F03FC99063EB191C4A40
80654	IP14 4ER	GB	0101000020E61000004A61DEE34C13F03F664E97C5C41C4A40
80655	IP14 4HF	GB	0101000020E610000098E0D40792F7EF3F06465ED6C41C4A40
80656	IP14 4HT	GB	0101000020E6100000F59CF4BEF175F03F98C1189128244A40
80657	IP14 4JP	GB	0101000020E61000008410902FA102F03F3A3C84F1D31C4A40
80658	IP14 4NX	GB	0101000020E6100000BF2CEDD45C2EF03FA01518B2BA214A40
80659	IP14 4QB	GB	0101000020E610000005C1E3DBBB46F03F0150C58D5B1E4A40
80660	IP14 4SQ	GB	0101000020E6100000568330B77BB9EF3F357A354069224A40
80661	IP14 5LG	GB	0101000020E6100000307F85CC9501F23F52EE3EC7471B4A40
80662	IP14 5LS	GB	0101000020E6100000E42CEC6987FFF13F8881AE7D011B4A40
80663	IP14 5QF	GB	0101000020E61000001D8EAED2DD35F23F96CE8767091E4A40
80664	IP14 6AE	GB	0101000020E6100000A8380EBC5AEEF13F3D0B42791F194A40
80665	IP14 6AX	GB	0101000020E610000047E867EA758BF23F7AFEB4519D184A40
80666	IP14 6LA	GB	0101000020E610000028F4FA93F81CF33F97FE25A94C1D4A40
80667	IP14 6LY	GB	0101000020E6100000EB353D2828C5F33F878A71FE261C4A40
80668	IP15 5DE	GB	0101000020E61000002507EC6AF294F93F12C0CDE2C5124A40
80669	IP15 5HN	GB	0101000020E6100000B1F9B836548CF93FB610E4A084134A40
80670	IP15 5PY	GB	0101000020E61000002A1E17D52262F93F2AE109BDFE144A40
80671	IP16 4LE	GB	0101000020E610000065506D70223AF93FB81E85EB511A4A40
80672	IP16 4LH	GB	0101000020E610000072A774B0FE4FF93F4D124BCADD194A40
80673	IP16 4RT	GB	0101000020E6100000CEDF8442041CF93F8E9257E7181E4A40
80674	IP16 4RX	GB	0101000020E61000001CEBE2361A40F93F1C0B0A83321D4A40
80675	IP17 1BA	GB	0101000020E6100000A45016BEBED6F73F5EA10F96B11B4A40
80676	IP17 1BW	GB	0101000020E6100000C1FEEBDCB4D9F73F137D3ECA881B4A40
80677	IP17 1DF	GB	0101000020E610000052F01472A5DEF73F310BED9C661B4A40
80678	IP17 1DP	GB	0101000020E610000053B131AF23CEF73FDCDAC2F3521B4A40
80679	IP17 1JX	GB	0101000020E61000009C6B98A1F184F73FCEDE196D55184A40
80680	IP17 1RB	GB	0101000020E610000035D4282499D5F73FA54A94BDA5164A40
80681	IP17 1XU	GB	0101000020E6100000095053CBD6BAF73F09C556D0B41A4A40
80682	IP17 2HG	GB	0101000020E6100000DDEEE53E390AF73F7F32C687D9214A40
80683	IP17 2LX	GB	0101000020E610000096EB6D3315A2F73FB535221807234A40
80684	IP17 3DJ	GB	0101000020E6100000963E74417D0BFA3F9413ED2AA4204A40
80685	IP17 3EU	GB	0101000020E6100000255987A3ABF4F83FA5A14621C9224A40
80686	IP17 3PN	GB	0101000020E6100000CF656A12BC61F83F9AEC9FA701234A40
80687	IP17 3PP	GB	0101000020E61000009816F549EE70F83F728C648F50234A40
80688	IP18 6EG	GB	0101000020E6100000F04DD36707DCFA3F3B1C5DA5BB294A40
80689	IP18 6NL	GB	0101000020E6100000226DE34F54B6FA3FF085C954C12A4A40
80690	IP18 6TQ	GB	0101000020E6100000B0E595EB6D73FA3F5E143DF031284A40
80691	IP18 6UQ	GB	0101000020E610000019E76F422182FA3FD3A23EC91D284A40
80692	IP19 0EA	GB	0101000020E6100000664AEB6F09C0F63FDD274701A2264A40
80693	IP19 8AY	GB	0101000020E610000006651A4D2E06F83F683EE76ED72B4A40
80694	IP19 8BY	GB	0101000020E6100000273108AC1C1AF83FF6ECB94C4D2C4A40
80695	IP19 8BZ	GB	0101000020E6100000AFE94141291AF83F2992AF04522C4A40
80696	IP19 8HE	GB	0101000020E6100000A0336953750FF83F3BE0BA62462C4A40
80697	IP19 8JU	GB	0101000020E6100000555051F52B1DF83F429770E82D2C4A40
80698	IP19 8PT	GB	0101000020E61000009DD9AED0070BF83FE083D72E6D2C4A40
80699	IP19 8QB	GB	0101000020E6100000552E54FEB53CF83F08E8BE9CD92C4A40
80700	IP19 8QJ	GB	0101000020E6100000E1455F419A31F83FE92ADD5D672D4A40
80701	IP19 9AJ	GB	0101000020E610000042AF3F89CF5DF83FB3D30FEA22274A40
80702	IP19 9AU	GB	0101000020E6100000828B15359886F73FD4D4B2B5BE284A40
80703	IP19 9BB	GB	0101000020E6100000D7C1C1DEC4D0F73F62BEBC00FB284A40
80704	IP19 9DP	GB	0101000020E610000005871744A4E6F83F957EC2D9AD294A40
80705	IP19 9EL	GB	0101000020E6100000728C648F50F3F83FA9DBD9571E2A4A40
80706	IP19 9HD	GB	0101000020E61000000588821953F0F83F4278B471C4284A40
80707	IP19 9LG	GB	0101000020E61000007959130B7CC5F93FD7169E978A294A40
80708	IP19 9NF	GB	0101000020E6100000FE7BF0DAA58DF93F3F6F2A5261264A40
80709	IP2	GB	0101000020E6100000FDF9B660A9EEF13FDC291DACFF034A40
80710	IP2 0EN	GB	0101000020E6100000209C4F1DAB14F23FA3E6ABE463074A40
80711	IP2 0RU	GB	0101000020E6100000FAF202ECA3D3F13FA724EB7074054A40
80712	IP2 8AJ	GB	0101000020E610000067B96C74CE4FF23FF7C8E6AA79064A40
80713	IP2 8AU	GB	0101000020E6100000DF878384285FF23FFE45D09849064A40
80714	IP2 9AD	GB	0101000020E6100000075DC2A1B738F23F7769C36169064A40
80715	IP2 9DZ	GB	0101000020E6100000A1D80A9A9618F23F13F3ACA415054A40
80716	IP2 9EF	GB	0101000020E6100000249C16BCE86BF23FEF552B137E074A40
80717	IP2 9NN	GB	0101000020E61000003A083A5AD5D2F13F371B2B31CF064A40
80718	IP20	GB	0101000020E61000001F0F7D772BCBF43F0820B58993334A40
80719	IP20 0BA	GB	0101000020E61000006B4AB20E4797F53F5E9ECE15A53A4A40
80720	IP20 0BX	GB	0101000020E6100000F758FAD00575F53F2A560DC2DC364A40
80721	IP20 0EF	GB	0101000020E6100000E75086AA988AF53FD15AD1E638354A40
80722	IP20 0EG	GB	0101000020E6100000BC24CE8AA889F53F1D90847D3B354A40
80723	IP20 0EN	GB	0101000020E6100000A182C30B2292F53F77DA1A118C354A40
80724	IP20 0EP	GB	0101000020E61000007D7901F6D1A9F53F8AABCABE2B364A40
80725	IP20 0EU	GB	0101000020E610000019C8B3CBB7BEF53FF9BEB854A5354A40
80726	IP20 0HG	GB	0101000020E610000042D0D1AA9674F53F5C936E4BE4344A40
80727	IP20 0LT	GB	0101000020E61000006B63EC8497E0F53F91EF52EA922F4A40
80728	IP20 0NX	GB	0101000020E6100000310BED9C6601F63F9F5A7D7555344A40
80729	IP20 9AA	GB	0101000020E61000002FDCB930D2CBF43F60AC6F6072334A40
80730	IP20 9BN	GB	0101000020E61000002CF52C08E5BDF43F2499D53BDC324A40
80731	IP20 9DD	GB	0101000020E6100000601F9DBAF2D9F43FFF91E9D0E9334A40
80732	IP20 9EP	GB	0101000020E61000006D3656629ED5F43F087767EDB6334A40
80733	IP20 9JN	GB	0101000020E61000005378D0ECBAB7F43F5796E82CB3324A40
80734	IP21 4AS	GB	0101000020E6100000E3E2A8DC442DF33FF52F49658A2D4A40
80735	IP21 4DJ	GB	0101000020E6100000CBD58F4DF263F23FCF108E59F62E4A40
80736	IP21 4JP	GB	0101000020E6100000342DB1321AF9F33FEACC3D247C2F4A40
80737	IP21 4JQ	GB	0101000020E6100000ECD973999AC4F23F5BEF37DA712D4A40
80738	IP21 4QR	GB	0101000020E61000008597E0D40792F33FB0FF3A376D344A40
80739	IP21 4RU	GB	0101000020E6100000D690B8C7D207F43F9C51F355F2354A40
80740	IP21 5EX	GB	0101000020E6100000E4874A236636F33F064A0A2C80274A40
80741	IP21 5JQ	GB	0101000020E610000056F487669EDCF33F3B6F63B3232B4A40
80742	IP22 1BF	GB	0101000020E6100000598AE42B8114F03F637B2DE8BD2B4A40
80743	IP22 1BN	GB	0101000020E610000017A06D35EB0CF03FA453573ECB2B4A40
80744	IP22 1DJ	GB	0101000020E610000039B35DA10F16F03F349E08E23C2C4A40
80745	IP22 1DT	GB	0101000020E61000005C02F04FA912F03F28D53E1D8F2B4A40
80746	IP22 1DX	GB	0101000020E610000047E867EA750BF03FC898BB96902B4A40
80747	IP22 1EA	GB	0101000020E610000071CCB227810DF03FDCF29194F42A4A40
80748	IP22 1EG	GB	0101000020E61000003FFED2A23EC9EF3FCA5356D3F52A4A40
80749	IP22 1ER	GB	0101000020E6100000F7729F1C0508F03FB4AF3C484F2B4A40
80750	IP22 1HF	GB	0101000020E6100000A1BB24CE8AA8EF3FFA9CBB5D2F2B4A40
80751	IP22 1HW	GB	0101000020E6100000FDBB3E73D627EF3FE57E87A2402D4A40
80752	IP22 1HX	GB	0101000020E61000003A1F9E25C808EF3F75914259F82C4A40
80753	IP22 1LG	GB	0101000020E6100000D00D4DD9E947F03F6FB88FDC9A2A4A40
80754	IP22 1LT	GB	0101000020E6100000D1402C9B3924F03F8F52094FE8274A40
80755	IP22 1PD	GB	0101000020E610000070B1A206D330EF3F8D7F9F71E12C4A40
80756	IP22 1PQ	GB	0101000020E6100000E10A28D4D3C7F03FA0A70183A42D4A40
80757	IP22 1RR	GB	0101000020E61000001EFD2FD7A205F03F19FF3EE3C22D4A40
80758	IP22 1RW	GB	0101000020E6100000782AE09EE70FF03F2E39EE940E2E4A40
80759	IP22 2PR	GB	0101000020E6100000B613252191B6EC3FB83D4162BB2B4A40
80760	IP22 4DB	GB	0101000020E6100000A48CB80034CAF13FAD4B8DD0CF304A40
80761	IP22 4DN	GB	0101000020E61000006CB587BD50C0F13FF4FDD478E9304A40
80762	IP22 4HN	GB	0101000020E6100000D95C35CF11F9F13F8F183DB7D02F4A40
80763	IP22 4LF	GB	0101000020E61000002F4E7CB5A3B8F13FB1DCD26A48304A40
80764	IP22 4PJ	GB	0101000020E61000005A643BDF4F0DF23F496760E4652F4A40
80765	IP23 7AJ	GB	0101000020E6100000999F1B9AB2D3F23FFD4B529962284A40
80766	IP23 7AS	GB	0101000020E61000004F965AEF375AF23F9A27D714C8284A40
80767	IP23 7HL	GB	0101000020E6100000B4722F302B54F23FD68F4DF2232A4A40
80768	IP23 7PB	GB	0101000020E6100000FE648C0FB397F23F51F4C0C760254A40
80769	IP23 7QL	GB	0101000020E61000003868AF3E1E7AF33F3FAA61BF27244A40
80770	IP23 7QY	GB	0101000020E6100000C652245F0964F33F368FC360FE244A40
80771	IP23 8EF	GB	0101000020E6100000D350A3906416F13F494A7A185A294A40
80772	IP23 8LZ	GB	0101000020E610000089230F441629F13FB35C363AE7234A40
80773	IP24	GB	0101000020E6100000CE4F711C7835E93FB5334C6DA9334A40
80774	IP24 1AH	GB	0101000020E610000070CD1DFD2FD7E73F0B410E4A98354A40
80775	IP24 1DU	GB	0101000020E61000007C0F971C77CAE73FC64E78094E354A40
80776	IP24 1QD	GB	0101000020E610000083F92B64AE0CEB3FE02BBAF59A444A40
80777	IP24 2TQ	GB	0101000020E6100000CA198A3BDE64E83F9D4A06802A3A4A40
80778	IP24 2YH	GB	0101000020E610000014D1AFAD9F7EE83F01A3CB9BC3354A40
80779	IP24 3LA	GB	0101000020E610000018D2E1218C9FE73FD20149D8B7334A40
80780	IP24 3RH	GB	0101000020E6100000266F8099EF60E33F73486AA164384A40
80781	IP24 3TA	GB	0101000020E61000004E266E15C4C0E53F48DC63E943314A40
80782	IP24 3TG	GB	0101000020E61000008672A25D8594E53F261C7A8B87314A40
80783	IP24 3TN	GB	0101000020E61000004FE960FD9F43E53FB401D88008314A40
80784	IP24 3TP	GB	0101000020E61000001C7E37DDB243E53F79E57ADB4C314A40
80785	IP25	GB	0101000020E610000047E6913F1878EC3FB0C7444AB3514A40
80786	IP25 6NE	GB	0101000020E6100000B9A81611C5E4E83F9D853DEDF0474A40
80787	IP25 6UA	GB	0101000020E6100000B27F9E060C12EB3FAAF06778B3484A40
80788	IP25 7	GB	0101000020E610000008C9022670EBEE3FE14389963C4C4A40
80789	IP25 7AN	GB	0101000020E6100000CA3505323B8BEF3F3D7C9928424A4A40
80790	IP25 7EW	GB	0101000020E6100000B01BB62DCAECE93F618BDD3EAB4C4A40
80791	IP25 7NH	GB	0101000020E61000004C1C7920B2C8ED3FFC51D4997B524A40
80792	IP26 4BA	GB	0101000020E6100000960A2AAA7EA5E03F68EC4B361E3E4A40
80793	IP26 4LW	GB	0101000020E61000003F355EBA498CE13FB35E0CE5443B4A40
80794	IP26 4NR	GB	0101000020E610000029B3412619B9E13FAF3E1EFAEE424A40
80795	IP26 4PP	GB	0101000020E6100000B0CA85CABF96E13F5DC136E2C9424A40
80796	IP26 4QP	GB	0101000020E61000001B6327BC04A7E03F75AE282504434A40
80797	IP26 5	GB	0101000020E6100000DEE522BE1333E53F156F641EF9414A40
80798	IP26 5HG	GB	0101000020E6100000DCBDDC274701E53FD1764CDD95414A40
80799	IP26 5JL	GB	0101000020E6100000FC6F253B3602E43F5DDE1CAED5424A40
80800	IP26 5JN	GB	0101000020E61000007FF78E1A13E2E33FC217265305434A40
80801	IP27	GB	0101000020E610000014E97E4E41FEE23F514EB4AB90384A40
80802	IP27 0AQ	GB	0101000020E6100000814067D2A6EAE33FFB78E8BB5B394A40
80803	IP27 0AX	GB	0101000020E61000009143C4CDA9E4E33FC58D5BCCCF394A40
80804	IP27 0BA	GB	0101000020E6100000FFCEF6E80DF7E33F72158BDF143A4A40
80805	IP27 0DB	GB	0101000020E6100000B3B112F3AC24E43F6ABFB51325394A40
80806	IP27 0LD	GB	0101000020E6100000B4226AA2CFC7E33FBF823463D1384A40
80807	IP27 0QZ	GB	0101000020E6100000DD088B8A389DE33F3370404B573C4A40
80808	IP27 0TG	GB	0101000020E6100000A515DF50F86CE53FA054FB743C3A4A40
80809	IP27 0YL	GB	0101000020E610000009168733BF1AE43F3CA41820D1384A40
80810	IP27 9AD	GB	0101000020E61000008B8862F20618E13FBBD408FD4C394A40
80811	IP27 9BD	GB	0101000020E61000004DF910548DDEE03FAE11C138B8304A40
80812	IP27 9HZ	GB	0101000020E61000005AD427B9C3A6E03F71A94A5B5C354A40
80813	IP27 9LG	GB	0101000020E6100000055262D7F676DD3F29B16B7BBB374A40
80814	IP28	GB	0101000020E610000004013274ECA0DF3F5708ABB184274A40
80815	IP28 6AA	GB	0101000020E61000009ECF807A33EAE03FA1F48590F32A4A40
80816	IP28 6AB	GB	0101000020E61000002A01310917F2E03F23BC3D08012B4A40
80817	IP28 6AE	GB	0101000020E61000009F03CB113210E13F03D2FE07582B4A40
80818	IP28 6AF	GB	0101000020E61000000B293FA9F6E9E03F3EAE0D15E32A4A40
80819	IP28 6AG	GB	0101000020E61000001D90847D3B09E13F85CFD6C1C12A4A40
80820	IP28 6AJ	GB	0101000020E6100000B972F6CE68ABE03FEC87D860E12A4A40
80821	IP28 6AN	GB	0101000020E61000009B8D959867A5E03FBF823463D12A4A40
80822	IP28 6AP	GB	0101000020E610000023145B41D392E03F65DF15C1FF2A4A40
80823	IP28 6AQ	GB	0101000020E6100000B98E71C5C5D1E03F55850662D92A4A40
80824	IP28 6AR	GB	0101000020E6100000DFA63FFB91A2E03FD09B8A54182B4A40
80825	IP28 6AS	GB	0101000020E6100000E9B6442E3803E13F54573ECBF32A4A40
80826	IP28 6AT	GB	0101000020E610000000581D39D299E03FBB438A01122B4A40
80827	IP28 6AU	GB	0101000020E6100000A779C7293A92E03F3A083A5AD52A4A40
80828	IP28 6AW	GB	0101000020E610000055FB743C66A0E03F325706D5062B4A40
80829	IP28 6AX	GB	0101000020E610000089D349B6BA9CE03F0D54C6BFCF2A4A40
80830	IP28 6AY	GB	0101000020E61000001B9E5E29CB90E03FE5EE737CB42A4A40
80831	IP28 6BA	GB	0101000020E61000003CF9F4D89681E03FA3E8818FC12A4A40
80832	IP28 6BD	GB	0101000020E6100000B39597FC4F7EE03F59C345EEE92A4A40
80833	IP28 6BG	GB	0101000020E610000009DFFB1BB457E03FF71F990E9D2A4A40
80834	IP28 6BH	GB	0101000020E61000006D72F8A41389E03F93C83EC8B22A4A40
80835	IP28 6BL	GB	0101000020E610000054E0641BB883E03FA41820D1042A4A40
80836	IP28 6BP	GB	0101000020E6100000C11C3D7E6FD3DA3F2FBE688F172C4A40
80837	IP28 6BQ	GB	0101000020E61000003E5B07077B93E03F999CDA19A62A4A40
80838	IP28 6JJ	GB	0101000020E6100000BC7A15191D90E13FB4CBB73EAC274A40
80839	IP28 6PL	GB	0101000020E6100000B2852007254CE33F863C821B29294A40
80840	IP28 6PS	GB	0101000020E6100000910C39B69E21E33FA968ACFD9D294A40
80841	IP28 6SA	GB	0101000020E61000001B47ACC5A780E13F361D01DC2C284A40
80842	IP28 6SQ	GB	0101000020E61000007369FCC22B49E13F698D412784284A40
80843	IP28 6SW	GB	0101000020E61000003F389F3A56A9E03FB5FF01D6AA274A40
80844	IP28 6TH	GB	0101000020E6100000569C6A2DCC42E13F3468E89FE0284A40
80845	IP28 7AA	GB	0101000020E61000000F62670A9D57E03FD12346CF2D2C4A40
80846	IP28 7AB	GB	0101000020E61000002861A6ED5F59E03F55FB743C662C4A40
80847	IP28 7AF	GB	0101000020E6100000ADA1D45E445BE03F6EA12B11A82C4A40
80848	IP28 7DL	GB	0101000020E6100000ACAA97DF6932E03F39D21918792B4A40
80849	IP28 7DP	GB	0101000020E6100000855FEAE74D45E03FED444948A42B4A40
80850	IP28 7DR	GB	0101000020E610000097917A4FE534E03FF487669E5C2B4A40
80851	IP28 7DS	GB	0101000020E6100000138255F5F23BE03FE831CA332F2B4A40
80852	IP28 7DX	GB	0101000020E6100000C7BC8E386403E03FF294D5743D2B4A40
80853	IP28 7ED	GB	0101000020E61000006A300DC34744E03FF1F62004E42B4A40
80854	IP28 7EF	GB	0101000020E610000009DFFB1BB457E03F083C3080F02B4A40
80855	IP28 7EQ	GB	0101000020E6100000D28C45D3D949E03FD5B32094F72B4A40
80856	IP28 7EX	GB	0101000020E6100000FA60191BBA59E03FC3482F6AF72B4A40
80857	IP28 7EZ	GB	0101000020E6100000E82D1EDE7360E03F1D9430D3F62B4A40
80858	IP28 7HB	GB	0101000020E6100000E547FC8A355CE03FAE8218E8DA2B4A40
80859	IP28 7HS	GB	0101000020E6100000A6B915C26AACE03F25034015372C4A40
80860	IP28 7HT	GB	0101000020E6100000E61F7D93A6C1E03F9981CAF8F72B4A40
80861	IP28 7JU	GB	0101000020E6100000B5E1B034F023E03F7E552E54FE2B4A40
80862	IP28 7JZ	GB	0101000020E6100000C36169E04735DF3F3DF20703CF2B4A40
80863	IP28 7NX	GB	0101000020E6100000D4B7CCE9B298E03FC40AB77C242D4A40
80864	IP28 8AA	GB	0101000020E61000004CA94BC63192DF3FE7FF55478E2E4A40
80865	IP28 8AE	GB	0101000020E610000020B75F3E5931DD3F367689EAAD2D4A40
80866	IP28 8HZ	GB	0101000020E6100000E882FA96395DDC3F9C887E6DFD284A40
80867	IP28 8JA	GB	0101000020E61000004F232D95B723DC3F397CD28904294A40
80868	IP28 8JB	GB	0101000020E6100000E99D0AB8E7F9DB3FBF64E3C116294A40
80869	IP28 8JD	GB	0101000020E6100000D2C77C40A033DC3F4D9F1D705D294A40
80870	IP28 8JF	GB	0101000020E61000002C9E7AA4C16DDC3F3F8BA548BE284A40
80871	IP28 8JG	GB	0101000020E6100000417E3672DD94DC3F0ADB4FC6F8284A40
80872	IP28 8NJ	GB	0101000020E61000007D09151C5E10DC3F8F72309B00294A40
80873	IP28 8NP	GB	0101000020E6100000C74ACCB39256DD3F832F4CA60A2E4A40
80874	IP28 8PT	GB	0101000020E610000096AFCBF09F6EDD3F475A2A6F472C4A40
80875	IP28 8RU	GB	0101000020E6100000F015DD7A4D0FDF3F1FF30181CE2A4A40
80876	IP28 8RX	GB	0101000020E610000098DBBDDC2747DF3F9B374E0AF32A4A40
80877	IP28 8RY	GB	0101000020E6100000EC6CC83F3388DF3F6D5512D9072B4A40
80878	IP28 8SA	GB	0101000020E610000039471D1D5723DF3FE048A0C1A62A4A40
80879	IP28 8SB	GB	0101000020E61000005723BBD23252DF3FD4D4B2B5BE2A4A40
80880	IP28 8SD	GB	0101000020E6100000F48AA71E6970DF3F847F1134662A4A40
80881	IP28 8SE	GB	0101000020E6100000F0DDE68D93C2DE3F274BADF71B2B4A40
80882	IP28 8SF	GB	0101000020E6100000DD0720B58993DE3FA2630795B82A4A40
80883	IP28 8SG	GB	0101000020E610000084F068E388B5DE3F0114234BE62A4A40
80884	IP28 8SJ	GB	0101000020E61000004B22FB20CB82DE3FC03C64CA872A4A40
80885	IP28 8SW	GB	0101000020E61000003ACC9717601FDE3FAF21382EE32A4A40
80886	IP29 4BY	GB	0101000020E6100000B2BD16F4DE18E33F1669E21DE0174A40
80887	IP29 4DJ	GB	0101000020E6100000494BE5ED08A7E53FDA8EA9BBB2114A40
80888	IP29 4ED	GB	0101000020E61000005EA27A6B60ABE53FCCD3B9A294124A40
80889	IP29 4TQ	GB	0101000020E61000005F251FBB0B14E63F206118B0E4124A40
80890	IP29 5DA	GB	0101000020E61000005B7A34D593F9E23FE4310395F11F4A40
80891	IP29 5QE	GB	0101000020E610000054FEB5BC723DE53FDCA16131EA1C4A40
80892	IP29 5SE	GB	0101000020E61000005D3123BC3D88E53F6A183E22A61C4A40
80893	IP3	GB	0101000020E61000005F27F5656927F33F2028B7ED7B064A40
80894	IP3 0EW	GB	0101000020E610000081D07AF832D1F23F572250FD83044A40
80895	IP3 0JH	GB	0101000020E6100000C9E88024ECDBF23F575C1C959B044A40
80896	IP3 0NS	GB	0101000020E610000023BF7E880DD6F23F31444E5FCF054A40
80897	IP3 0NU	GB	0101000020E6100000AE80423D7D44F33F5D363AE7A7064A40
80898	IP3 0NX	GB	0101000020E610000050E449D235D3F23F4147AB5AD2054A40
80899	IP3 5JQ	GB	0101000020E610000049145AD6FDE3F23F50E27327D8054A40
80900	IP3 8BZ	GB	0101000020E6100000581EA4A7C8E1F23F768C2B2E8E064A40
80901	IP3 8DZ	GB	0101000020E61000000E87A5811FD5F23FA5DDE8633E064A40
80902	IP3 8EL	GB	0101000020E61000006C41EF8D21C0F23FF69B89E942064A40
80903	IP3 8HN	GB	0101000020E6100000D200DE0209CAF23F698CD651D5064A40
80904	IP3 8LP	GB	0101000020E6100000E603029D491BF33F9126DE019E064A40
80905	IP3 8RZ	GB	0101000020E610000010E7E104A653F33F9F3E027FF8054A40
80906	IP3 8SZ	GB	0101000020E6100000BB2A508BC143F33FFCC56CC9AA044A40
80907	IP3 9BN	GB	0101000020E61000000D1CD0D215ECF23FBF61A2410A064A40
80908	IP3 9BY	GB	0101000020E6100000575F5D15A805F33F9DB98784EF054A40
80909	IP3 9GP	GB	0101000020E610000037E0F3C30821F33FAB3E575BB1034A40
80910	IP3 9JN	GB	0101000020E6100000FCE4284014CCF23F4339D1AE42064A40
80911	IP3 9JR	GB	0101000020E6100000EC32FCA71BE8F23F925ED4EE57054A40
80912	IP3 9LD	GB	0101000020E6100000556AF6402BF0F23F4337FB03E5044A40
80913	IP3 9NL	GB	0101000020E6100000C3802557B1F8F23F8CBCAC8905044A40
80914	IP3 9PG	GB	0101000020E6100000A0DCB6EF51FFF23FB4C876BE9F044A40
80915	IP3 9RJ	GB	0101000020E6100000E3361AC05B20F33F10CD3CB9A6044A40
80916	IP3 9RT	GB	0101000020E6100000E44A3D0B4279F33F5CC64D0D34034A40
80917	IP3 9SJ	GB	0101000020E6100000459C4EB2D565F33FF419506F46034A40
80918	IP3 9UT	GB	0101000020E610000023A12DE7521CF33FB7442E3883034A40
80919	IP30 0AB	GB	0101000020E6100000DECCE847C3A9E93F4AD05FE811194A40
80920	IP30 0AY	GB	0101000020E6100000649291B3B0A7E93F782975C9381A4A40
80921	IP30 0DU	GB	0101000020E61000003D2AFEEF888AE83F64EB19C231194A40
80922	IP30 0EF	GB	0101000020E61000002B33A5F5B784E93F0055DCB8C5164A40
80923	IP30 0EQ	GB	0101000020E6100000DFF94509FA8BE93FD95BCAF962174A40
80924	IP30 0ER	GB	0101000020E6100000E38A8BA37293E83F9204E10A281C4A40
80925	IP30 0HA	GB	0101000020E6100000B2F1608BDD3EE93FA2D3F36E2C144A40
80926	IP30 0JB	GB	0101000020E6100000412B306475ABE93F89D00836AE154A40
80927	IP30 0JD	GB	0101000020E61000007CD28904534DE93FFCFF3861C2124A40
80928	IP30 0LA	GB	0101000020E610000010B056ED9A10E93F14234BE658144A40
80929	IP30 0LG	GB	0101000020E6100000F92CCF83BBB3E83F4C1AA37554154A40
80930	IP30 0NR	GB	0101000020E6100000ABD1AB014AC3EA3F6E15C440D7124A40
80931	IP30 0PS	GB	0101000020E610000067D311C0CD62EB3FA29A92ACC3154A40
80932	IP30 0PW	GB	0101000020E61000005645B8C9A832EB3F58AD4CF8A5164A40
80933	IP30 0QE	GB	0101000020E61000001897AAB4C535EB3F1DC9E53FA4174A40
80934	IP30 0TH	GB	0101000020E6100000C44142942FE8E73F7C2B1213D41A4A40
80935	IP30 0UA	GB	0101000020E610000059C345EEE9EAE73FE449D23593194A40
80936	IP30 9AE	GB	0101000020E6100000B40584D6C397EA3F9AEFE0270E1E4A40
80937	IP30 9HA	GB	0101000020E610000017670C738236ED3FDC7F643A741E4A40
80938	IP30 9PG	GB	0101000020E6100000401878EE3DDCEB3F7B336ABE4A1E4A40
80939	IP30 9RN	GB	0101000020E6100000C3D66CE525FFEC3FD6E253008C1B4A40
80940	IP30 9TD	GB	0101000020E61000003143E38920CEEB3F9413ED2AA41A4A40
80941	IP30 9UF	GB	0101000020E6100000C7F65AD07B63ED3FF913950D6B1E4A40
80942	IP31 1AN	GB	0101000020E610000038D906EE401DEB3F7D5C1B2AC6294A40
80943	IP31 1EE	GB	0101000020E6100000CEA78E554ACFE83F37894160E52A4A40
80944	IP31 2	GB	0101000020E61000001ABFF04A92E7EA3FC6A354C213224A40
80945	IP31 2AT	GB	0101000020E6100000BC5CC4776256EC3F9D465A2A6F294A40
80946	IP31 2DT	GB	0101000020E6100000BF0F0709513EEC3FE9B81AD9952A4A40
80947	IP31 2HE	GB	0101000020E6100000C0232A543797EA3F4390831266264A40
80948	IP31 2ND	GB	0101000020E6100000A6272CF18032EA3FE469F981AB224A40
80949	IP31 2PT	GB	0101000020E610000059315C1D00F1E83F40FA264D83224A40
80950	IP31 2SB	GB	0101000020E6100000BD35B0558245E83F7862D68BA1224A40
80951	IP31 2SD	GB	0101000020E6100000478E740646DEE73F9CBF098508224A40
80952	IP31 2SU	GB	0101000020E6100000B1A206D3307CE83FB80721205F224A40
80953	IP31 3DH	GB	0101000020E6100000CEFC6A0E104CED3FDC4603780B244A40
80954	IP31 3EU	GB	0101000020E61000009529E620E868ED3FE2ADF36F97234A40
80955	IP31 3QU	GB	0101000020E61000001118EB1B98DCE93F6B65C22FF51F4A40
80956	IP31 3RX	GB	0101000020E610000085B35BCB6438EA3FAE9E93DE37204A40
80957	IP31 3SE	GB	0101000020E610000000FE2955A26CEA3F2F336C94F51F4A40
80958	IP31 3TF	GB	0101000020E610000057957D5704FFE93FFCE3BD6A65204A40
80959	IP32 6AD	GB	0101000020E61000008522DDCF29C8E63FAA0EB9196E204A40
80960	IP32 6PU	GB	0101000020E6100000EA4141295A39E63F6B2920ED7F204A40
80961	IP32 7AR	GB	0101000020E6100000C898BB96900FE83FB492567C431D4A40
80962	IP32 7DN	GB	0101000020E61000005A2E1B9DF3D3E63F4C8E3BA5831F4A40
80963	IP32 7ET	GB	0101000020E6100000B020CD58349DE73F971AA19FA91F4A40
80964	IP32 7GT	GB	0101000020E61000009EEFA7C64B37E83FAAD5575705204A40
80965	IP32 7HS	GB	0101000020E6100000BD8FA339B2F2E73F9204E10A28204A40
80966	IP32 7JS	GB	0101000020E61000008202EFE4D3E3E63F9886E12362204A40
80967	IP33 1EQ	GB	0101000020E6100000CD8FBFB4A8CFE63FA6643909A51F4A40
80968	IP33 1JN	GB	0101000020E610000026C45C52B5DDE63FDC4603780B204A40
80969	IP33 1QG	GB	0101000020E6100000774EB340BBC3E63F32923D42CD1E4A40
80970	IP33 1RE	GB	0101000020E6100000C7F65AD07BE3E63F213D450E111F4A40
80971	IP33 1RX	GB	0101000020E610000077853E58C606E73F8E3EE603021F4A40
80972	IP33 1SX	GB	0101000020E61000000BEF7211DF09E73FD789CBF10A204A40
80973	IP33 1TF	GB	0101000020E61000005890662C9ACEE63FAC1A84B9DD1F4A40
80974	IP33 1YR	GB	0101000020E6100000ABE7A4F78D2FE73F48895DDBDB1F4A40
80975	IP33 2BD	GB	0101000020E610000046D1031F8315E73F72C3EFA65B1E4A40
80976	IP33 2DT	GB	0101000020E6100000EACC3D247C6FE63F554D10751F1E4A40
80977	IP33 2EW	GB	0101000020E61000006C04E275FD02E63F5376FA415D1E4A40
80978	IP33 2HJ	GB	0101000020E61000001D93C5FD4726E63F91F3FE3F4E1E4A40
80979	IP33 2LA	GB	0101000020E6100000E1421EC18D94E63F7DCF4884461E4A40
80980	IP33 2LG	GB	0101000020E61000004BAC8C463EAFE63F7A008BFCFA1D4A40
80981	IP33 2QJ	GB	0101000020E610000062D8614CFAFBE63FEC34D252791D4A40
80982	IP33 2QL	GB	0101000020E610000083DC4598A2DCE63F9A780778D21C4A40
80983	IP33 3	GB	0101000020E6100000E814E4672357E63FD998D711871E4A40
80984	IP33 3AN	GB	0101000020E610000035B401D88088E63F656EBE11DD1F4A40
80985	IP33 3AT	GB	0101000020E6100000DE205A2BDA9CE63F9ACC785BE91F4A40
80986	IP33 3JU	GB	0101000020E6100000685DA3E5408FE63F096D3997E21E4A40
80987	IP33 3LD	GB	0101000020E6100000DDEA39E97D63E63F8F334DD87E1E4A40
80988	IP33 3RX	GB	0101000020E6100000A8A9656B7D11E63FAA0B7899611F4A40
80989	IP33 3SA	GB	0101000020E6100000546F0D6C95E0E53F5BD2510E661F4A40
80990	IP33 3SY	GB	0101000020E6100000D5E8D500A5A1E63FB763EAAEEC1E4A40
80991	IP33 3SZ	GB	0101000020E6100000643F8BA5483EE63F0AF4893C49204A40
80992	IP33 3TB	GB	0101000020E61000008670CCB22701E63F08B0C8AF1F204A40
80993	IP33 3TQ	GB	0101000020E61000007E737FF5B86FE53F0B46257502204A40
80994	IP33 3XD	GB	0101000020E61000002502D53F88E4E53FD13DEB1A2D1F4A40
80995	IP33 3XH	GB	0101000020E61000006E14596B28B5E53F09C38025571F4A40
80996	IP4 1NP	GB	0101000020E610000098F8A3A833B7F23FB4588AE42B074A40
80997	IP4 1NT	GB	0101000020E6100000FD6662BA10ABF23FD1CFD4EB16074A40
80998	IP4 2BX	GB	0101000020E61000006B2A8BC22E8AF23FF4C0C760C5074A40
80999	IP4 2DX	GB	0101000020E6100000D0285DFA97A4F23FF7393E5A9C074A40
81000	IP4 2HR	GB	0101000020E610000022C7D63384A3F23F0D1D3BA8C4074A40
81001	IP4 2PF	GB	0101000020E6100000742843554CA5F23F836BEEE87F074A40
81002	IP4 2RG	GB	0101000020E61000005260014C19B8F23FFDD98F1491074A40
81003	IP4 2RJ	GB	0101000020E61000006133C005D9B2F23F7E5704FF5B074A40
81004	IP4 2UG	GB	0101000020E6100000C1A8A44E4093F23F0F7C0C569C084A40
81005	IP4 3AH	GB	0101000020E6100000D61F6118B0A4F23FA29C685721094A40
81006	IP4 3BX	GB	0101000020E61000009813B4C9E1D3F23F8736001B10094A40
81007	IP4 3DL	GB	0101000020E61000005B96AFCBF0DFF23F0475CAA31B094A40
81008	IP4 3EQ	GB	0101000020E610000006802A6EDCE2F23F5E4C33DDEB084A40
81009	IP4 4EQ	GB	0101000020E61000005AD93EE42DD7F23FED9BFBABC7074A40
81010	IP4 4HW	GB	0101000020E61000001AC40776FCD7F23FACFE08C380074A40
81011	IP4 4JW	GB	0101000020E61000000CE544BB0AE9F23F3AB187F6B1084A40
81012	IP4 4LP	GB	0101000020E610000053EA92718CE4F23F4A7CEE04FB074A40
81013	IP4 4LR	GB	0101000020E61000008351499D80E6F23FE547FC8A35084A40
81014	IP4 4NT	GB	0101000020E6100000DA0242EBE10BF33FB1868BDCD3074A40
81015	IP4 4RH	GB	0101000020E6100000912749D74CFEF23F50E1085229084A40
81016	IP4 5EY	GB	0101000020E6100000645930F14711F33F41F2CEA10C074A40
81017	IP4 5HD	GB	0101000020E610000036E675C4211BF33F8DEDB5A0F7064A40
81018	IP4 5HP	GB	0101000020E6100000C5724BAB21F1F23F2F6F0ED76A074A40
81019	IP4 5JA	GB	0101000020E61000000E10CCD1E3F7F23FF98557923C074A40
81020	IP4 5PD	GB	0101000020E6100000F9872D3D9A2AF33F1764CBF275074A40
81021	IP4 5QA	GB	0101000020E610000084BA48A12C3CF33F47FFCBB568074A40
81022	IP4 5RA	GB	0101000020E6100000C495B377465BF33FBE2D58AA0B084A40
81023	IP4 5UW	GB	0101000020E6100000E75086AA984AF33F1B2AC6F99B064A40
81024	IP4 5XA	GB	0101000020E6100000395E81E84959F33FA510C8258E064A40
81025	IP5 1	GB	0101000020E61000007FDFBF797162F33F63F19BC24A094A40
81026	IP5 2QG	GB	0101000020E61000008E76DCF0BB29F43F863AAC70CB074A40
81027	IP5 3RE	GB	0101000020E610000063F030ED9B7BF43FCD0358E4D7074A40
81028	IP5 3SU	GB	0101000020E61000003B8DB454DE4EF43FD78A36C7B9074A40
81029	IP5 3UR	GB	0101000020E610000094F6065F984CF43FA94BC63192074A40
81030	IP6	GB	0101000020E61000000E315EF3AACEF13F6EFC89CA860D4A40
81031	IP6 0DL	GB	0101000020E610000029AE2AFBAEC8F13FF56915FDA10D4A40
81032	IP6 0PY	GB	0101000020E6100000C1A90F24EFDCF13F4A9869FB570E4A40
81033	IP6 8AL	GB	0101000020E6100000008E3D7B2ED3F03F76A6D0798D134A40
81034	IP6 8AS	GB	0101000020E6100000C782C2A04CE3F03F3F8F519E79134A40
81035	IP6 8AZ	GB	0101000020E61000002CF3565D87EAF03F0685419946134A40
81036	IP6 8DG	GB	0101000020E6100000D6355A0EF4D0F03F6DC7D45DD9134A40
81037	IP6 8DL	GB	0101000020E61000002BDEC83CF2C7F03F38A3E6ABE4134A40
81038	IP6 8DS	GB	0101000020E6100000060FD3BEB9BFF03FE5B512BA4B144A40
81039	IP6 8NH	GB	0101000020E61000006A17D34CF7FAF03F7592AD2EA7144A40
81040	IP6 9AE	GB	0101000020E61000000CCD751A69A9F23F82C64CA25E0A4A40
81041	IP6 9BT	GB	0101000020E6100000A22424D2363EF33F569FABADD80B4A40
81042	IP6 9HN	GB	0101000020E6100000EBE5779ACCF8F23FC5538F34B80D4A40
81043	IP6 9JL	GB	0101000020E6100000ADA1D45E44DBF13FE54691B586124A40
81044	IP6 9PN	GB	0101000020E6100000634337FB03E5F13F34BA83D899124A40
81045	IP6 9QT	GB	0101000020E6100000F4E159828C40F23F95B6B8C667124A40
81046	IP7 5BU	GB	0101000020E6100000D15B3CBCE7C0EE3FEC8497E0D4054A40
81047	IP7 5DH	GB	0101000020E610000073D712F241CFEE3FE69315C3D5054A40
81048	IP7 5DN	GB	0101000020E610000024D5777E5182EE3F9BC761307F054A40
81049	IP7 5DZ	GB	0101000020E61000001C5E10919A76EE3FE4839ECDAA054A40
81050	IP7 5HZ	GB	0101000020E610000046EF54C03DCFEE3FC2A2224E27054A40
81051	IP7 5RX	GB	0101000020E61000004E6210583934EF3F0E6ABFB513054A40
81052	IP7 5SE	GB	0101000020E6100000E4A1EF6E6589EE3FE272BC02D1054A40
81053	IP7 5SH	GB	0101000020E6100000211D1EC2F8E9EE3F6FB72407EC044A40
81054	IP7 7EB	GB	0101000020E6100000AF5E45460724ED3F8126C286A70D4A40
81055	IP7 7EG	GB	0101000020E61000005EBC1FB75F3EED3F58A835CD3B0E4A40
81056	IP7 7EW	GB	0101000020E61000003883BF5FCC16ED3F75C93846B20D4A40
81057	IP7 7HR	GB	0101000020E610000015E63DCE3461EE3F4C18CDCAF60D4A40
81058	IP7 7NE	GB	0101000020E61000006552431B800DED3FCE52B29C84104A40
81059	IP8	GB	0101000020E61000002575029A089BF13F856055BDFC024A40
81060	IP8 3EW	GB	0101000020E6100000D7C056091687F13F807D74EACA074A40
81061	IP8 3LR	GB	0101000020E61000002788BA0F40AAF13F4CFC51D499034A40
81062	IP8 3LY	GB	0101000020E6100000A7B393C151B2F13F098A1F63EE024A40
81063	IP8 3QG	GB	0101000020E6100000697407B13385F03F5AB8ACC266044A40
81064	IP8 4DX	GB	0101000020E6100000EC6B5D6A847EF13F11DF89592F0A4A40
81065	IP8 4EU	GB	0101000020E6100000C899266C3F99F13F5378D0ECBA094A40
81066	IP8 4RS	GB	0101000020E6100000A48D23D6E2D3EF3F448655BC910D4A40
81067	IP9	GB	0101000020E61000000A0F9A5DF756F33F1422E010AAFE4940
81068	IP9 1AS	GB	0101000020E61000005969520ABAFDF23F596C938AC6004A40
81069	IP9 1HS	GB	0101000020E6100000249A40118B58F33F240ED940BAFE4940
81070	IP9 1QH	GB	0101000020E61000004EB7EC10FF70F43FA873452921FA4940
81071	IP9 2BL	GB	0101000020E6100000B54E5C8E5720F13FFCC56CC9AAFE4940
81072	IP9 2DB	GB	0101000020E610000020F0C000C287F13F3D2AFEEF88004A40
81073	IP9 2DH	GB	0101000020E61000005C381092050CF13F350C1F1153FE4940
81074	IP9 2NN	GB	0101000020E61000001669E21DE0C9F13F276BD44334004A40
81075	IP9 2PY	GB	0101000020E61000002C499EEBFB70F23FCEC133A149FE4940
81076	IP9 2QH	GB	0101000020E610000093020B60CA80F23F685BCD3AE3FD4940
81077	IP9 2SP	GB	0101000020E61000004B1DE4F56012F23FEE5F596952FC4940
81078	IV1 1LE	GB	0101000020E610000008E753C72AE510C0662FDB4E5BBD4C40
81079	IV1 2AG	GB	0101000020E6100000BFF2203D45CE10C0062B4EB516B84C40
81080	IV1 3XG	GB	0101000020E610000061E0B9F770F910C0DC12B9E00CC24C40
81081	IV1 3YG	GB	0101000020E6100000F46A80D250F310C0A983BC1E4CC04C40
81082	IV10 8SJ	GB	0101000020E61000008DD5E6FF557710C074B680D07ACC4C40
81083	IV10 8SL	GB	0101000020E6100000D97BF1457B6C10C0C7629B5434CE4C40
81084	IV10 8TF	GB	0101000020E6100000BF0E9C33A28410C033DE567A6DCA4C40
81085	IV10 8TT	GB	0101000020E6100000DA59F44E058C10C05DA626C11BCA4C40
81086	IV11 8XA	GB	0101000020E6100000AC90F2936A1F10C0D120054F21D74C40
81087	IV11 8YN	GB	0101000020E610000088F19A57752610C0A92F4B3B35D74C40
81088	IV12	GB	0101000020E61000004AD1CABDC07C10C01BD5E940D6C94C40
81089	IV12 4DD	GB	0101000020E6100000B404190115EE0EC07270E998F3CA4C40
81090	IV12 4HA	GB	0101000020E6100000D9B11188D7F50EC070287CB60ECC4C40
81091	IV12 4NL	GB	0101000020E6100000E63DCE34611B0FC030A017EE5CCC4C40
81092	IV12 4NN	GB	0101000020E61000008FAA2688BA0F0FC032FFE89B34CB4C40
81093	IV12 4QR	GB	0101000020E61000007D073F7100FD0EC03F58C6866ECA4C40
81094	IV12 4QS	GB	0101000020E6100000423EE8D9ACFA0EC0E9B985AE44CA4C40
81095	IV12 5	GB	0101000020E61000005AF0A2AF206D0FC0CC5D4BC807C34C40
81096	IV12 5BT	GB	0101000020E61000007B6B60AB04CB0EC0C51A2E724FCB4C40
81097	IV12 5LE	GB	0101000020E61000000EF62686E4A40EC053EC681CEAC94C40
81098	IV12 5QX	GB	0101000020E61000006F6589CE326B10C0DD9A745B22CB4C40
81099	IV12 5RD	GB	0101000020E6100000D95DA0A4C0620FC0AB402D060FC34C40
81100	IV12 5TE	GB	0101000020E61000001D91EF52EA720EC02B86AB0320CA4C40
81101	IV13 7	GB	0101000020E6100000C0D02346CFED0FC0967A1684F2AA4C40
81102	IV13 7YA	GB	0101000020E610000020425C397B2710C024D6E25300A64C40
81103	IV13 7YT	GB	0101000020E6100000A7CCCD37A20B10C0925D6919A9AB4C40
81104	IV14 9	GB	0101000020E6100000267156444D2412C0E813799274CB4C40
81105	IV14 9ER	GB	0101000020E61000003C1405FA442E12C0F2086EA46CC94C40
81106	IV15	GB	0101000020E6100000FCC56CC9AA7811C0100533A660CF4C40
81107	IV15 9PZ	GB	0101000020E610000060AFB0E07EB011C04B0169FF03CC4C40
81108	IV15 9UB	GB	0101000020E6100000B29B19FD68B811C0EC1681B1BECD4C40
81109	IV16 9XA	GB	0101000020E61000001D5A643BDF8F11C0702711E15FD44C40
81110	IV17 0SE	GB	0101000020E6100000569FABADD8FF10C081D1E5CDE1D84C40
81111	IV17 0SG	GB	0101000020E61000006745D4449FFF10C0BBD573D2FBD84C40
81112	IV17 0UL	GB	0101000020E61000006362F3716DF810C014E7A8A3E3D84C40
81113	IV18 0LY	GB	0101000020E610000006D50627A27F10C0789CA223B9DA4C40
81114	IV18 0NJ	GB	0101000020E610000033DC80CF0FB310C0E23D079623D84C40
81115	IV19	GB	0101000020E6100000AFB5F7A92A1410C0BF47FDF50AE14C40
81116	IV19 1JA	GB	0101000020E61000003673486AA13410C0446D1B4641E84C40
81117	IV19 1LF	GB	0101000020E6100000FDF50A0BEEB710C0925CFE43FAE94C40
81118	IV19 1QU	GB	0101000020E61000005AF10D85CF1610C0933655F7C8D84C40
81119	IV19 1QW	GB	0101000020E610000040A03369530510C00FD1E80E62DD4C40
81120	IV2	GB	0101000020E6100000DC679599D2CA10C0E223624A24BB4C40
81121	IV2 3DH	GB	0101000020E61000002EC55565DFC510C0AF06280D35BE4C40
81122	IV2 3EN	GB	0101000020E6100000EECD6F9868D010C09A266C3F19BD4C40
81123	IV2 3HD	GB	0101000020E61000008ECBB8A981E610C0FFCF61BEBCBC4C40
81124	IV2 3HF	GB	0101000020E61000004A0B9755D8EC10C0CC63CDC820BD4C40
81125	IV2 3UE	GB	0101000020E6100000FD885FB186CB10C0B29E5A7D75BD4C40
81126	IV2 3UG	GB	0101000020E6100000B459F5B9DACA10C0FEF15EB532BD4C40
81127	IV2 4HQ	GB	0101000020E6100000A48B4D2B85E010C06D533C2EAABB4C40
81128	IV2 4QW	GB	0101000020E610000000581D39D2E910C07EC6850321BB4C40
81129	IV2 4TB	GB	0101000020E6100000A4DE5339EDE910C047205ED72FBC4C40
81130	IV2 5	GB	0101000020E61000003C2F151BF30A10C062BF27D6A9C24C40
81131	IV2 5AS	GB	0101000020E61000003C873254C5C410C09CC3B5DAC3BC4C40
81132	IV2 5DR	GB	0101000020E6100000693BA6EECA5E10C0B77C24253DC04C40
81133	IV2 5EQ	GB	0101000020E61000004D158C4AEA6410C0DF32A7CB62BE4C40
81134	IV2 5EU	GB	0101000020E61000007EFFE6C5895F10C053AEF02E17BD4C40
81135	IV2 5PA	GB	0101000020E6100000E19A3BFA5F0E10C0A24621C9ACC24C40
81136	IV2 5PG	GB	0101000020E6100000F5B86FB54E0C10C0F3E8465854C24C40
81137	IV2 6DJ	GB	0101000020E61000004FAC53E57B0611C02B6A300DC3B74C40
81138	IV2 6XJ	GB	0101000020E6100000029D499BAABB10C06ADE718A8EB04C40
81139	IV2 7HQ	GB	0101000020E610000074CE4F711C7810C0B9A6406667BF4C40
81140	IV2 7PJ	GB	0101000020E6100000151C5E1091DA0FC0CD936B0A64C24C40
81141	IV2 7PZ	GB	0101000020E6100000C8091346B39210C09694BBCFF1BD4C40
81142	IV2 7QP	GB	0101000020E61000002BFBAE08FE0710C0F12900C633C64C40
81143	IV2 7SW	GB	0101000020E6100000703FE081012410C0DB8651103CC84C40
81144	IV2 7TD	GB	0101000020E6100000E6E786A6EC4410C0EBC891CEC0CA4C40
81145	IV20	GB	0101000020E61000001651137D3E2A0FC0A724EB7074E34C40
81146	IV20 1RS	GB	0101000020E6100000AE9D280989F40FC00A9FAD8383E34C40
81147	IV20 1SL	GB	0101000020E6100000431B800D88F00EC05915E126A3E84C40
81148	IV20 1SX	GB	0101000020E61000008BC22E8A1EB80FC0215A2BDA1CE34C40
81149	IV20 1YS	GB	0101000020E6100000A45181936DA00EC09EEA909BE1EA4C40
81150	IV21 2AN	GB	0101000020E6100000685DA3E540BF16C0EC89AE0B3FD84C40
81151	IV21 2AU	GB	0101000020E61000004CE3175E492217C09B90D61874D64C40
81152	IV21 2BL	GB	0101000020E6100000EBE40CC51DBF16C03FA9F6E978DC4C40
81153	IV21 2DJ	GB	0101000020E61000004434BA83D80917C0CF8250DEC7DD4C40
81154	IV21 2EA	GB	0101000020E61000009A931799803F17C0490ED8D5E4ED4C40
81155	IV22 2EE	GB	0101000020E6100000747973B8564B14C0132A38BC20CA4C40
81156	IV22 2EJ	GB	0101000020E610000041498105305514C0191D90847DC94C40
81157	IV22 2EZ	GB	0101000020E6100000E5D3635B060C16C0A91611C5E4C54C40
81158	IV22 2HE	GB	0101000020E61000006BBB09BE69BA16C0F9D9C87553CA4C40
81159	IV22 2HL	GB	0101000020E610000007EDD5C743FF15C0DEE7F86871D64C40
81160	IV22 2HZ	GB	0101000020E61000000A4D124BCA4D16C0AAD72D0263EB4C40
81161	IV22 2LG	GB	0101000020E61000001DCBBBEA016316C0F4531C075EE34C40
81162	IV22 2PA	GB	0101000020E61000008BC22E8A1E3815C0BE2F2E5569CD4C40
81163	IV23 2PH	GB	0101000020E610000088D860E124BD12C0B439CE6DC2D74C40
81164	IV23 2PQ	GB	0101000020E61000009D2ADF33121113C05C8DEC4ACBD84C40
81165	IV23 2PZ	GB	0101000020E610000046443179033C13C0D6E253008CCF4C40
81166	IV23 2QD	GB	0101000020E6100000B4E386DF4DA713C0AF5E454607CE4C40
81167	IV23 2QF	GB	0101000020E6100000EC6B5D6A84BE12C04B57B08D78CE4C40
81168	IV23 2QP	GB	0101000020E61000001F4C8A8F4F1815C0C30E63D2DFEF4C40
81169	IV23 2QR	GB	0101000020E6100000A1F65B3B51E214C0C4CE143AAFEB4C40
81170	IV23 2QT	GB	0101000020E61000005FD4EE57010E15C03621AD31E8EC4C40
81171	IV23 2RE	GB	0101000020E6100000C39CA04D0E6F15C04912842BA0F44C40
81172	IV23 2SD	GB	0101000020E610000016DEE522BE6314C0B3075A8121EB4C40
81173	IV24	GB	0101000020E61000008E75711B0D8011C053245F09A4F04C40
81174	IV24 3	GB	0101000020E6100000C0046EDDCD7311C02AADBF2500F14C40
81175	IV24 3AH	GB	0101000020E6100000FCC3961E4D5511C0D0D2156C23F24C40
81176	IV24 3BS	GB	0101000020E610000037E2C96E665412C0C4060B2769EE4C40
81177	IV24 3BW	GB	0101000020E6100000B9FC87F4DBA711C00B7DB08C0DF14C40
81178	IV24 3DG	GB	0101000020E610000042E90B21E76D11C02ECA6C9049F04C40
81179	IV24 3DP	GB	0101000020E6100000B56D1805C1A311C0B72407EC6AF64C40
81180	IV24 3EB	GB	0101000020E6100000151BF33AE26011C0B9C1508715F24C40
81181	IV25	GB	0101000020E6100000302E55698B1B10C02062838593F04C40
81182	IV25 3	GB	0101000020E610000061FF756EDA1C10C0D1E7A38CB8F04C40
81183	IV25 3JB	GB	0101000020E6100000102219726C4D10C0191EFB592CF74C40
81184	IV25 3QD	GB	0101000020E6100000F0879FFF1EFC0FC0C44142942FF44C40
81185	IV26 2	GB	0101000020E6100000DE02098A1FA314C046B6F3FDD4F24C40
81186	IV26 2TY	GB	0101000020E61000008B6B7C26FBA714C0A99F3715A9F24C40
81187	IV26 2YB	GB	0101000020E6100000D7A4DB12B91015C0BBB9F8DB9E084D40
81188	IV26 2YG	GB	0101000020E6100000C3D66CE5255F15C0C80A7E1B62024D40
81189	IV26 2YL	GB	0101000020E6100000DDB1D826153D15C051FA42C879FF4C40
81190	IV27 4AB	GB	0101000020E6100000A93121E6920A12C091D10149D8174D40
81191	IV27 4ET	GB	0101000020E6100000D1E80E62679A11C0649126DE01F64C40
81192	IV27 4EX	GB	0101000020E610000061545227A09911C0B6F7A92A34004D40
81193	IV27 4HE	GB	0101000020E610000070067FBF98ED12C011E0F42EDEFB4C40
81194	IV27 4HL	GB	0101000020E6100000D13B1570CFE313C05B9885764E134D40
81195	IV27 4HW	GB	0101000020E6100000C843DFDDCA1214C056F31C91EF204D40
81196	IV27 4JB	GB	0101000020E6100000923EADA23F3415C05514AFB2B6154D40
81197	IV27 4JD	GB	0101000020E6100000A9A10DC0065415C0B8EA3A5453184D40
81198	IV27 4JY	GB	0101000020E6100000732D5A80B6F514C0D5B48B69A6134D40
81199	IV27 4LR	GB	0101000020E610000037894160E50015C0FF243E77820F4D40
81200	IV27 4NW	GB	0101000020E6100000A9A27895B5CD14C03123BC3D081F4D40
81201	IV27 4NY	GB	0101000020E61000001BA034D428C412C05BB4006DAB154D40
81202	IV27 4PN	GB	0101000020E61000008D28ED0DBE0013C052D2C3D0EA484D40
81203	IV27 4PQ	GB	0101000020E61000001A355F251FAB13C0AF0793E2E3274D40
81204	IV27 4QA	GB	0101000020E6100000211E8997A7E312C0E23D079623484D40
81205	IV27 4RH	GB	0101000020E6100000DAC70A7E1B0214C0616BB6F292394D40
81206	IV27 4RN	GB	0101000020E61000008B170B43E4F413C05740A19E3E364D40
81207	IV27 4RS	GB	0101000020E6100000EBC4E578055214C0DE770C8FFD3C4D40
81208	IV27 4SS	GB	0101000020E6100000249BABE6399214C0DFA815A6EF314D40
81209	IV27 4ST	GB	0101000020E6100000D829560DC27C14C00D8E9257E7324D40
81210	IV27 4SX	GB	0101000020E61000005891D101499814C0D39FFD48112D4D40
81211	IV27 4TH	GB	0101000020E61000005073F222139014C01DACFF7398294D40
81212	IV27 4UF	GB	0101000020E6100000E1421EC18DC411C093A7ACA6EB234D40
81213	IV27 4UL	GB	0101000020E6100000D427B9C326C212C0B85A272EC73B4D40
81214	IV27 4XH	GB	0101000020E610000034D93F4F03B611C00569C6A2E93E4D40
81215	IV27 4YP	GB	0101000020E6100000CDCCCCCCCCBC11C0643BDF4F8D434D40
81216	IV28 3XA	GB	0101000020E6100000202922C32A9E10C035D1E7A38CFE4C40
81217	IV28 3XL	GB	0101000020E610000085EE92382BA210C0B16D516683FE4C40
81218	IV3 5BE	GB	0101000020E61000004A7B832F4CF610C05D37A5BC56BC4C40
81219	IV3 5HR	GB	0101000020E6100000E25B5837DEED10C0558A1D8D43BD4C40
81220	IV3 5LE	GB	0101000020E61000007DE71725E8FF10C0A0FD481119BE4C40
81221	IV3 5NE	GB	0101000020E610000027BD6F7CEDE910C05D70067FBFBC4C40
81222	IV3 5RE	GB	0101000020E61000008925E5EE73FC10C01E17D522A2BC4C40
81223	IV3 5SZ	GB	0101000020E61000003B014D840DEF10C06919A9F754BC4C40
81224	IV3 5UE	GB	0101000020E61000005FED28CE51A710C098DA520779BD4C40
81225	IV3 8HE	GB	0101000020E610000053910A630BF110C073D53C47E4BD4C40
81226	IV3 8NJ	GB	0101000020E61000004CFBE6FEEAF110C02CF180B229BD4C40
81227	IV3 8NW	GB	0101000020E61000007E00529B381911C089EE59D768BB4C40
81228	IV3 8QE	GB	0101000020E610000014234BE658DE10C077F52A323ABE4C40
81229	IV30	GB	0101000020E61000005B43A9BD88760AC047CCECF318D14C40
81230	IV30 1NU	GB	0101000020E6100000E1D40792778E0AC06902452C62D24C40
81231	IV30 1NZ	GB	0101000020E6100000BCE6559DD5820AC0C51C041DADD24C40
81232	IV30 1PH	GB	0101000020E6100000BDDF68C70D9F0AC066DAFE9595D24C40
81233	IV30 1QH	GB	0101000020E61000008179C8940F810AC0F4A78DEA74D24C40
81234	IV30 1QP	GB	0101000020E6100000514F1F813F7C0AC0F12900C633D24C40
81235	IV30 1XQ	GB	0101000020E6100000703FE08101640AC0111D024702D34C40
81236	IV30 2NE	GB	0101000020E61000007216F6B4C39F0AC0AFCDC64ACCD34C40
81237	IV30 4EU	GB	0101000020E6100000CB68E4F38A670AC0A1F48590F3D24C40
81238	IV30 5	GB	0101000020E61000006058FE7C5BB00BC05C72DC291DDA4C40
81239	IV30 5TZ	GB	0101000020E610000016A1D80A9AF60BC0A2258FA7E5D94C40
81240	IV30 6UN	GB	0101000020E6100000AC71361D01BC0AC0C6FD47A643D34C40
81241	IV30 8LG	GB	0101000020E610000052D4997B489809C08F899466F3D24C40
81242	IV30 8LN	GB	0101000020E61000009B745B2217BC09C0516B9A779CD04C40
81243	IV30 8RJ	GB	0101000020E61000002B86AB03200E0AC001A5A14621CD4C40
81244	IV30 8SP	GB	0101000020E6100000EFE192E34E890AC0569FABADD8CB4C40
81245	IV30 8UP	GB	0101000020E61000009641B5C189680BC0325706D506D34C40
81246	IV30 8UU	GB	0101000020E61000000F5F268A909A0BC0AEBB79AA43D24C40
81247	IV31	GB	0101000020E6100000572426A8E13B0AC0B89388F02FDC4C40
81248	IV31 6QS	GB	0101000020E610000026FBE769C0600AC0F6B2EDB435DC4C40
81249	IV31 6RY	GB	0101000020E6100000A69A594B01690AC01956F146E6D74C40
81250	IV32 7DP	GB	0101000020E61000007C48F8DEDFC008C028EFE3688ECE4C40
81251	IV32 7PQ	GB	0101000020E61000004580D3BB789F08C05CAFE94141CF4C40
81252	IV36	GB	0101000020E6100000D508FD4CBDAE0CC0DF516342CCCD4C40
81253	IV36 0BQ	GB	0101000020E6100000C47762D68BE10CC0919BE1067CCE4C40
81254	IV36 0EL	GB	0101000020E610000063096B63EC040DC08E9257E718CE4C40
81255	IV36 0QU	GB	0101000020E6100000F110C64FE35E0CC048C5FF1D51CD4C40
81256	IV36 1DG	GB	0101000020E6100000245E9ECE15E50CC0B1C22D1F49CD4C40
81257	IV36 2	GB	0101000020E61000001651137D3E8A0DC06518778368CD4C40
81258	IV36 2JN	GB	0101000020E61000002D08E57D1CCD0CC0B87878CF81CD4C40
81259	IV36 2PG	GB	0101000020E610000067994528B6020DC0DE21C50089CC4C40
81260	IV36 2SA	GB	0101000020E6100000B77BB94F8EC20BC0BAA29410ACC64C40
81261	IV36 2SG	GB	0101000020E6100000826F9A3E3B000DC0B03907CF84CC4C40
81262	IV36 2SW	GB	0101000020E61000007E37DDB2437C0DC070ECD97399C84C40
81263	IV36 2TU	GB	0101000020E61000009163EB19C2710DC0F4A3E194B9C74C40
81264	IV36 3	GB	0101000020E61000009C19FD6838E50CC03DF0315871D44C40
81265	IV36 3UH	GB	0101000020E6100000336E6AA0F97C0CC054E1CFF066D34C40
81266	IV36 3YF	GB	0101000020E6100000336FD575A8E60CC019541B9C88D44C40
81267	IV4	GB	0101000020E61000007FD93D7958E811C0981936CAFABB4C40
81268	IV4 7AF	GB	0101000020E6100000A6608DB3E93812C07905A22765BC4C40
81269	IV4 7BB	GB	0101000020E6100000105839B4C8F611C0E4486760E4B94C40
81270	IV4 7DJ	GB	0101000020E6100000790778D2C2E511C0A357039486BE4C40
81271	IV4 7EP	GB	0101000020E6100000E9F351465CE011C054FF209221BD4C40
81272	IV4 7JQ	GB	0101000020E61000001BD47E6B27FA11C02E5393E00DB74C40
81273	IV4 7LF	GB	0101000020E610000047AD307DAF4113C02593533BC3A64C40
81274	IV4 7LH	GB	0101000020E61000000420EEEA558414C0AE9D280989B44C40
81275	IV4 7ND	GB	0101000020E6100000BF9EAF592EBB14C0E9297288B89D4C40
81276	IV40 7LW	GB	0101000020E6100000BD0166BE830F13C02F151BF33AAC4C40
81277	IV40 8AH	GB	0101000020E61000000454388254DA16C0BC92E4B9BEA34C40
81278	IV40 8BD	GB	0101000020E61000007079AC1919C416C005357C0BEBA84C40
81279	IV40 8BE	GB	0101000020E610000064AC36FFAFBA16C02BDB87BCE5A84C40
81280	IV40 8BT	GB	0101000020E61000002D95B7239CE616C08F17D2E121A44C40
81281	IV40 8DH	GB	0101000020E6100000276C3F19E38316C0CF9ECBD424A44C40
81282	IV40 8DN	GB	0101000020E6100000ADC3D155BA9B16C026AAB706B6A44C40
81283	IV40 8DX	GB	0101000020E610000042B456B4390E16C096E82CB308A34C40
81284	IV40 8DZ	GB	0101000020E6100000DC2F9FAC181E16C07F86376BF0A44C40
81285	IV40 8EA	GB	0101000020E610000041649126DEA115C08141D2A755A64C40
81286	IV40 8EE	GB	0101000020E6100000CCB8A981E69316C0F1F109D979A54C40
81287	IV40 8EG	GB	0101000020E61000004E9B711AA25A16C04034F3E49AA44C40
81288	IV40 8HB	GB	0101000020E6100000CAA4863600AB15C0475A2A6F479C4C40
81289	IV40 8HL	GB	0101000020E610000026C3F17C06A415C06FB72407EC9A4C40
81290	IV40 8HP	GB	0101000020E61000006BB8C83D5DCD15C0AFB48CD47B9C4C40
81291	IV40 8JL	GB	0101000020E61000003E5B07077B4316C0A62BD8463C914C40
81292	IV40 8JR	GB	0101000020E6100000A69C2FF65E7C16C00B42791F479B4C40
81293	IV40 8NT	GB	0101000020E6100000B4588AE42B4118C0C423F1F274AC4C40
81294	IV40 8PB	GB	0101000020E6100000DB148F8B6A5118C0F0F8F6AE41AD4C40
81295	IV41 8PS	GB	0101000020E6100000209BE447FCEA16C0BF823463D1A24C40
81296	IV42 8NH	GB	0101000020E6100000CF69166877A816C03CA3AD4A229D4C40
81297	IV42 8PH	GB	0101000020E61000004AB54FC763E616C02DCE18E604A34C40
81298	IV42 8PY	GB	0101000020E6100000BC92E4B9BE5F17C0338CBB41B49E4C40
81299	IV42 9	GB	0101000020E6100000B22D03CE526217C025CE8AA8899E4C40
81300	IV43 7JX	GB	0101000020E6100000BE141E34BBFE13C0C2853C821BB54C40
81301	IV43 8QR	GB	0101000020E610000074435376FA3117C081E9B46E83924C40
81302	IV44 8RD	GB	0101000020E610000094A46B26DF6C17C0CF31207BBD8D4C40
81303	IV44 8RN	GB	0101000020E610000078B81D1A16C317C003EACDA8F9924C40
81304	IV45 8RN	GB	0101000020E61000000684D6C397D917C0B13385CE6B844C40
81305	IV45 8RS	GB	0101000020E6100000DDEBA4BE2C9D17C0B6494563ED874C40
81306	IV46 8SA	GB	0101000020E61000002BDCF29194F417C05E4C33DDEB8E4C40
81307	IV47 8	GB	0101000020E6100000AB984A3FE16C19C0BBED42739DA64C40
81308	IV47 8SL	GB	0101000020E610000025766D6FB7A419C0C1AA7AF99DAA4C40
81309	IV47 8SW	GB	0101000020E6100000658BA4DDE8B318C0FD4FFEEE1DA54C40
81310	IV47 8TA	GB	0101000020E610000098FA7953912A19C0836BEEE87F9B4C40
81311	IV48 8TD	GB	0101000020E61000000C2252D32E6618C0DEE8633E20A84C40
81312	IV49 9	GB	0101000020E6100000D656EC2FBBA717C059FD1186019F4C40
81313	IV49 9AN	GB	0101000020E6100000FB40F2CEA12C18C0B5A9BA4736A34C40
81314	IV49 9BL	GB	0101000020E6100000FED137691A6418C03EE76ED74B934C40
81315	IV49 9BP	GB	0101000020E61000004B5645B8C97817C07FFB3A70CEA24C40
81316	IV49 9BS	GB	0101000020E61000003B8BDEA980BB17C0C7B94DB857A44C40
81317	IV49 9PB	GB	0101000020E6100000F433F5BA459017C0525F96766A9E4C40
81318	IV5 7NB	GB	0101000020E6100000DDEBA4BE2CAD11C0073F7100FDBC4C40
81319	IV51	GB	0101000020E61000009D2D20B41E6E19C0F46E2C280CCA4C40
81320	IV51 9	GB	0101000020E6100000D40CA9A278C518C093020B60CAB44C40
81321	IV51 9HS	GB	0101000020E6100000EAEBF99AE5D218C0A6B6D4415EB74C40
81322	IV51 9HZ	GB	0101000020E61000005D34643C4A0519C0BBD573D2FBD44C40
81323	IV51 9JS	GB	0101000020E6100000CFBEF2203DE518C0F67D384888D04C40
81324	IV51 9JU	GB	0101000020E61000001B2AC6F99BD018C056EF703B34D04C40
81325	IV51 9LL	GB	0101000020E6100000E0F3C308E17118C089B3226AA2A94C40
81326	IV51 9NG	GB	0101000020E6100000102043C70EBA18C085CFD6C1C1B24C40
81327	IV51 9NR	GB	0101000020E610000066D828EB374319C091D0967329BA4C40
81328	IV51 9RA	GB	0101000020E610000015E63DCE34F117C0B03DB32440C54C40
81329	IV51 9UF	GB	0101000020E61000007D59DAA9B95C19C02159C0046ED74C40
81330	IV51 9YD	GB	0101000020E6100000744694F6066F19C0B13385CE6BCA4C40
81331	IV52 8TN	GB	0101000020E61000006403E962D39A16C0E603029D49AB4C40
81332	IV52 8TX	GB	0101000020E61000002079E75086AA16C05D6A847EA6AA4C40
81333	IV52 8TY	GB	0101000020E6100000CD902A8A579916C064C91CCBBBA84C40
81334	IV52 8TZ	GB	0101000020E610000004E275FD828D16C0618A7269FCAA4C40
81335	IV53 8UH	GB	0101000020E6100000738236397C3216C0438EAD6708AD4C40
81336	IV53 8UT	GB	0101000020E61000005B24ED461F4316C070EF1AF4A5AB4C40
81337	IV54 8HX	GB	0101000020E6100000F6D1A92B9FD516C034BF9A0304C54C40
81338	IV54 8LR	GB	0101000020E61000009A6038D7304317C0988922A46EB74C40
81339	IV54 8LY	GB	0101000020E61000008446B071FD3B17C0C02500FF94B04C40
81340	IV54 8XA	GB	0101000020E6100000A208A9DBD96716C016F71F990EB34C40
81341	IV54 8XN	GB	0101000020E6100000EE7C3F355E9A16C0566133C005C34C40
81342	IV54 8XU	GB	0101000020E6100000C05DF6EB4E1717C0D5CBEF3499C74C40
81343	IV54 8XX	GB	0101000020E61000008ECC237F307017C0E3FA777DE6C04C40
81344	IV54 8YA	GB	0101000020E6100000A85489B2B7F415C0AB048BC399B34C40
81345	IV54 8YB	GB	0101000020E6100000363AE7A738EE15C019C5724BABB34C40
81346	IV54 8YD	GB	0101000020E61000003ECBF3E0EEFC15C0A5A0DB4B1AB34C40
81347	IV54 8YE	GB	0101000020E6100000AE47E17A14FE15C0D1950854FFB24C40
81348	IV54 8YF	GB	0101000020E6100000CEA78E554AFF15C09276A38FF9B24C40
81349	IV54 8YG	GB	0101000020E61000008F37F92D3A0916C0A795422097B24C40
81350	IV54 8YH	GB	0101000020E61000002FDD2406811516C0014EEFE2FDB04C40
81351	IV54 8YJ	GB	0101000020E61000000936AE7FD73716C03BFDA02E52AE4C40
81352	IV54 8YL	GB	0101000020E6100000E78A5242B06A16C0111B2C9CA4AD4C40
81353	IV54 8YN	GB	0101000020E610000040BE840A0EBF15C0E38C614ED0B64C40
81354	IV54 8YP	GB	0101000020E6100000FE7F9C30610416C0492F6AF7ABB24C40
81355	IV54 8YQ	GB	0101000020E6100000DC4B1AA3750416C0DBA2CC0699B24C40
81356	IV54 8YR	GB	0101000020E6100000B62BF4C132B615C0AA436E861BB64C40
81357	IV54 8YS	GB	0101000020E61000008A3C49BA66F215C0C284D1AC6CB34C40
81358	IV54 8YT	GB	0101000020E6100000E3E2A8DC44ED15C043588D25ACB34C40
81359	IV54 8YU	GB	0101000020E6100000765089EB183715C091F3FE3F4EBE4C40
81360	IV54 8YW	GB	0101000020E61000009B728577B9D815C076C24B70EAB54C40
81361	IV54 8YX	GB	0101000020E61000009642209738D215C0EF586C938AB24C40
81362	IV55 8	GB	0101000020E61000009A081B9E5E391AC0956588635DB64C40
81363	IV55 8WA	GB	0101000020E610000046B247A819521AC0317898F6CDB74C40
81364	IV55 8ZG	GB	0101000020E61000006901DA56B30E1AC0F0F8F6AE41B14C40
81365	IV55 8ZT	GB	0101000020E6100000FA0E7EE2009A1AC0DD24068195B94C40
81366	IV56 8FX	GB	0101000020E6100000DC9F8B868C9719C09BE5B2D139AD4C40
81367	IV6 7	GB	0101000020E61000001FF30181CED411C04643C6A354C24C40
81368	IV6 7QG	GB	0101000020E610000050508A56EEB512C0069FE6E445C84C40
81369	IV6 7QQ	GB	0101000020E6100000053411363CED13C0A930B610E4C24C40
81370	IV6 7QX	GB	0101000020E610000057EC2FBB27CF11C0A532C51C04C34C40
81371	IV6 7RQ	GB	0101000020E6100000FFE89B340DCA11C0C3F352B131C34C40
81372	IV6 7SW	GB	0101000020E6100000A9BEF38B12C411C064AF777FBCC14C40
81373	IV6 7UL	GB	0101000020E6100000F20698F90EFE11C0CF108E59F6C44C40
81374	IV6 7XA	GB	0101000020E610000085B01A4B583B12C08B170B43E4C44C40
81375	IV63 2XJ	GB	0101000020E61000001BDA006C40C411C067BAD7497DA94C40
81376	IV63 6	GB	0101000020E6100000D046AE9B52DE11C0139ED0EB4FAA4C40
81377	IV63 6XS	GB	0101000020E6100000AD855968E70412C05531957EC2AB4C40
81378	IV63 7YA	GB	0101000020E61000009143C4CDA97412C0C84109336D9B4C40
81379	IV63 7YN	GB	0101000020E61000000ADB4FC6F8D013C0C3802557B1924C40
81380	IV63 7YW	GB	0101000020E6100000C51C041DADBA14C04B9352D0ED934C40
81381	IV7	GB	0101000020E6100000E563778192D210C02828452BF7D44C40
81382	IV7 6RW	GB	0101000020E610000064E597C118D111C04DBA2D910BC24C40
81383	IV7 8EP	GB	0101000020E610000020D5B0DF136B11C0B95510035DCF4C40
81384	IV7 8ES	GB	0101000020E61000004C5299620EC211C0E78D93C2BCC94C40
81385	IV7 8EW	GB	0101000020E61000003CDA38622D6E11C05CAFE94141CF4C40
81386	IV7 8HQ	GB	0101000020E61000001366DAFE95E511C05859DB148FC94C40
81387	IV7 8LL	GB	0101000020E610000014252191B6E110C097C4591135D34C40
81388	IV7 8LX	GB	0101000020E610000054E57B4622A410C082AD122C0ED34C40
81389	IV7 8LY	GB	0101000020E6100000E469F981AB8C10C011397D3D5FD34C40
81390	IV7 8LZ	GB	0101000020E610000048FC8A355CC410C01F86562767D44C40
81391	IV8 8	GB	0101000020E610000043041C42950A11C04C6E14596BC64C40
81392	IV8 8NL	GB	0101000020E6100000772D211FF40C11C08F1D54E23AC64C40
81393	IV8 8NZ	GB	0101000020E6100000213D450E112711C0939048DBF8C34C40
81394	IV9 8	GB	0101000020E6100000573ECBF3E0AE10C095F0845E7FC84C40
81395	IV9 8QT	GB	0101000020E6100000BA1281EA1FB410C0A680B4FF01C84C40
81396	JE2 3HN	GB	0101000020E6100000D76839D043ED00C0CF8250DEC7994840
81397	JE2 4JP	GB	0101000020E610000024473A0323CF00C0C6A354C2139A4840
81398	JE3 8	GB	0101000020E6100000C68844A1655D01C093FE5E0A0F984840
81399	JE3 9GB	GB	0101000020E610000047CB811E6A7B00C05D177E703E974840
81400	JE4	GB	0101000020E6100000AA29C93A1CBD00C0C345EEE9EA984840
81401	KA1 1SG	GB	0101000020E610000080D250A3900412C038143E5B07CD4B40
81402	KA1 2AF	GB	0101000020E6100000E5ED08A705FF11C0F5BEF1B567CE4B40
81403	KA1 3RB	GB	0101000020E610000040C23060C9F511C04A253CA1D7CB4B40
81404	KA1 4RT	GB	0101000020E6100000BFB854A52DFE11C0A9FB00A436CB4B40
81405	KA1 5EY	GB	0101000020E61000003CBD529621FE11C0314278B471CE4B40
81406	KA1 5QX	GB	0101000020E6100000F1F3DF83D73E12C03C31EBC550C64B40
81407	KA10 6DJ	GB	0101000020E6100000003961C268B612C02FA2ED98BAC54B40
81408	KA10 6HZ	GB	0101000020E610000064AC36FFAF9A12C0F3380CE6AFC44B40
81409	KA10 6JY	GB	0101000020E61000008FDFDBF4679F12C005F9D9C875C54B40
81410	KA10 6SA	GB	0101000020E610000009336DFFCA9A12C00FED6305BFC74B40
81411	KA10 6TB	GB	0101000020E61000006B7EFCA5459D12C0DA1EBDE13EC84B40
81412	KA10 6UB	GB	0101000020E61000009737876BB59712C0B83CD68C0CC84B40
81413	KA10 7AE	GB	0101000020E610000081971936CA8A12C0A29A92ACC3C54B40
81414	KA10 7AJ	GB	0101000020E6100000E3FBE252958612C0B6D617096DC54B40
81415	KA11 1	GB	0101000020E61000005456D3F5448712C05A63D009A1D14B40
81416	KA11 2DH	GB	0101000020E61000001DCC26C0B08C12C0BB9C121093D04B40
81417	KA11 3AW	GB	0101000020E610000004ADC090D55D12C0643E20D099CE4B40
81418	KA11 4AW	GB	0101000020E610000044C362D4B57612C01D774A07EBCD4B40
81419	KA11 5AW	GB	0101000020E610000088BB7A15199D12C0E84A04AA7FCC4B40
81420	KA12 0AD	GB	0101000020E6100000417DCB9C2EAB12C03C6A4C88B9CE4B40
81421	KA12 8NU	GB	0101000020E6100000395FECBDF8B212C067F2CD3637CE4B40
81422	KA12 9AA	GB	0101000020E610000040DB6AD619AF12C06F10AD156DD04B40
81423	KA13 6NT	GB	0101000020E61000000BD0B69A75D612C0C9737D1F0ED44B40
81424	KA13 6RW	GB	0101000020E61000007FA65EB708DC12C02A029CDEC5D34B40
81425	KA13 7DP	GB	0101000020E61000009ED2C1FA3F0713C0CAA99D616AD14B40
81426	KA13 7HD	GB	0101000020E6100000664F029B73D012C097361C9606D44B40
81427	KA14 3AT	GB	0101000020E6100000827170E998B312C078962023A0DE4B40
81428	KA15 1AP	GB	0101000020E6100000C00644882B8712C047718E3A3AE04B40
81429	KA15 1GA	GB	0101000020E6100000B6300BED9C6612C0B43A394371DD4B40
81430	KA15 2	GB	0101000020E6100000A86E2EFEB68712C07C2C7DE882E04B40
81431	KA15 2AA	GB	0101000020E6100000601DC70F958612C00875914259E04B40
81432	KA16 9	GB	0101000020E610000034D769A4A55211C0331B649291CD4B40
81433	KA17 0	GB	0101000020E6100000342C465D6B1F11C0319413ED2ACE4B40
81434	KA17 0AJ	GB	0101000020E6100000E15F048D992411C04AD3A0681ECE4B40
81435	KA17 0LU	GB	0101000020E61000009485AFAF75E910C0DD2230D637CE4B40
81436	KA17 0NG	GB	0101000020E6100000575A46EA3D2511C071E316F373D14B40
81437	KA18	GB	0101000020E61000007EC7F0D8CF1211C0C9ACDEE176BA4B40
81438	KA18 1DX	GB	0101000020E61000002B1213D4F00D11C05378D0ECBAB94B40
81439	KA18 2AA	GB	0101000020E6100000E19BA6CF0E2811C073D6A71C93BB4B40
81440	KA18 2BH	GB	0101000020E6100000EA58A5F44C2F11C0B72572C119BC4B40
81441	KA18 3	GB	0101000020E61000007BBE66B96C4410C05551BCCADAC24B40
81442	KA18 4DG	GB	0101000020E6100000912A8A5759BB10C016139B8F6BB34B40
81443	KA18 4HG	GB	0101000020E6100000151C5E1091BA10C01AA721AAF0B14B40
81444	KA19 7AJ	GB	0101000020E6100000FE4465C39ABA12C08E03AF963BAD4B40
81445	KA19 7NF	GB	0101000020E610000068AED3484B3512C0B5A7E49CD8A74B40
81446	KA19 8DS	GB	0101000020E61000006500A8E2C6BD12C065FB90B75CAD4B40
81447	KA19 8EH	GB	0101000020E6100000B2BCAB1E30AF12C0B3791C06F3B14B40
81448	KA19 8EJ	GB	0101000020E6100000B1E1E995B2BC12C0EF5701BEDBB04B40
81449	KA19 8EU	GB	0101000020E610000061342BDB878C12C0A60A462575B24B40
81450	KA19 8HY	GB	0101000020E61000005358A9A0A21A13C0A088450C3BAA4B40
81451	KA19 8LE	GB	0101000020E61000006939D0436D2B13C0D2C2651536AD4B40
81452	KA2	GB	0101000020E61000008D9AAF928FFD11C02C7FBE2D58CE4B40
81453	KA2 0HA	GB	0101000020E6100000AE2990D9593412C0A400513063CE4B40
81454	KA2 9BL	GB	0101000020E61000005378D0ECBA5712C04F20EC14ABCA4B40
81455	KA2 9HY	GB	0101000020E61000004FCAA486366012C02BFBAE08FEC94B40
81456	KA20	GB	0101000020E6100000C233A149620913C0CDE49B6D6ED24B40
81457	KA20 3	GB	0101000020E6100000DACBB6D3D60813C0A4DE5339EDD14B40
81458	KA20 4DL	GB	0101000020E6100000910DA48B4D0B13C005A568E55ED24B40
81459	KA21 5	GB	0101000020E61000002BFBAE08FE2713C0C7BDF90D13D14B40
81460	KA21 5NS	GB	0101000020E6100000F4F8BD4D7F2613C022E3512AE1D14B40
81461	KA21 6GA	GB	0101000020E6100000C13A8E1F2A1D13C089D4B48B69D24B40
81462	KA22	GB	0101000020E610000008E412471E4813C00FF27A3029D24B40
81463	KA22 7EW	GB	0101000020E61000002C0E677E353713C00518963FDFD24B40
81464	KA22 7GQ	GB	0101000020E610000061E28FA2CE3C13C0CF2C095053D34B40
81465	KA22 8	GB	0101000020E6100000D11E2FA4C34313C0105B7A34D5D14B40
81466	KA22 8AU	GB	0101000020E6100000C9C7EE02253513C030B8E68EFED14B40
81467	KA22 8DB	GB	0101000020E6100000983270404B4713C05AF44E05DCD14B40
81468	KA22 8NG	GB	0101000020E61000007E3B8908FF4213C04FB0FF3A37D34B40
81469	KA22 8NR	GB	0101000020E61000005B40683D7C4913C06CCEC133A1D34B40
81470	KA23	GB	0101000020E6100000D1915CFE436A13C0C0B0FCF9B6DA4B40
81471	KA23 9	GB	0101000020E610000053CC41D0D16A13C038F7578FFBD84B40
81472	KA23 9AH	GB	0101000020E6100000FED64E94845413C058C7F143A5D94B40
81473	KA23 9BP	GB	0101000020E610000017BB7D56996913C061E124CD1FD94B40
81474	KA23 9PA	GB	0101000020E61000007670B037316413C08028983105D94B40
81475	KA23 9PS	GB	0101000020E610000012DC48D9227913C0D996016729D94B40
81476	KA24	GB	0101000020E6100000E50AEF7211DF12C0AB07CC43A6DA4B40
81477	KA24 4DE	GB	0101000020E61000001E17D522A2D812C0A417B5FB55DA4B40
81478	KA24 4DQ	GB	0101000020E6100000B3EBDE8AC4D412C0FFD0CC936BDA4B40
81479	KA24 4LP	GB	0101000020E6100000CB48BDA772BA12C07B1684F23EDC4B40
81480	KA24 5AG	GB	0101000020E6100000E962D34A21E012C05932C7F2AEDA4B40
81481	KA24 5LA	GB	0101000020E6100000DAAB8F87BEEB12C0514A0856D5DF4B40
81482	KA25 6	GB	0101000020E61000004C1B0E4B03BF12C0AA2C0ABB28E04B40
81483	KA25 7	GB	0101000020E6100000971E4DF564BE12C0F12DAC1BEFE04B40
81484	KA26	GB	0101000020E6100000302B14E97E6E13C0D270CADC7C9D4B40
81485	KA26 0AB	GB	0101000020E6100000BFEE74E7896713C0D82D02637D9D4B40
81486	KA26 0AP	GB	0101000020E61000006F4A79AD846E13C05C1B2AC6F99D4B40
81487	KA26 0AY	GB	0101000020E6100000CAA65CE15D6E13C043E4F4F57C9D4B40
81488	KA26 0JQ	GB	0101000020E610000052280B5F5FCB13C054A86E2EFE924B40
81489	KA26 0PZ	GB	0101000020E6100000D7169E978A8D13C061E28FA2CE9C4B40
81490	KA26 9HF	GB	0101000020E61000006A4DF38E536413C03196E997889F4B40
81491	KA26 9HW	GB	0101000020E61000006BB8C83D5D6D13C0162F1686C89F4B40
81492	KA26 9NS	GB	0101000020E61000002DEDD45C6E4013C09A780778D2AA4B40
81493	KA27 8HL	GB	0101000020E6100000F6ED2422FC2B15C04F57772CB6D94B40
81494	KA27 8HY	GB	0101000020E6100000D3D9C9E028A914C0984D8061F9CB4B40
81495	KA27 8LY	GB	0101000020E610000071E82D1EDE8314C02AA913D044C44B40
81496	KA27 8PQ	GB	0101000020E61000006ABC749318F414C0FF942A51F6B84B40
81497	KA27 8QT	GB	0101000020E610000051DB8651106C14C08274B169A5BE4B40
81498	KA28 0	GB	0101000020E6100000F437A11001B713C06B0C3A2174E04B40
81499	KA29 0AS	GB	0101000020E6100000C0E8F2E6706D13C0FCFCF7E0B5E14B40
81500	KA29 0DJ	GB	0101000020E6100000F4DDAD2CD16913C021AE9CBD33E04B40
81501	KA3	GB	0101000020E6100000AA285E656D0312C098512CB7B4D24B40
81502	KA3 1JL	GB	0101000020E6100000FE0E45813E0112C06ADC9BDF30CF4B40
81503	KA3 2RA	GB	0101000020E6100000003CA242751312C00DC1711937D14B40
81504	KA3 2RZ	GB	0101000020E61000004B92E7FA3E1C12C0F3E49A0299D14B40
81505	KA3 4	GB	0101000020E610000086200725CC2412C052D7DAFB54DB4B40
81506	KA3 4AU	GB	0101000020E61000004F78094E7D2012C0ED45B41D53DB4B40
81507	KA3 5	GB	0101000020E6100000BB09BE69FA0C12C033C51C041DD74B40
81508	KA3 5DS	GB	0101000020E6100000A983BC1E4C0A12C01FF818AC38D74B40
81509	KA3 6DY	GB	0101000020E610000032E36DA5D7C611C0CC5EB69DB6D44B40
81510	KA3 7	GB	0101000020E61000008D2AC3B81BE411C03E7958A835CF4B40
81511	KA3 7BA	GB	0101000020E6100000D89FC4E74EF011C03AB2F2CB60CE4B40
81512	KA3 7ET	GB	0101000020E6100000D384ED2763EC11C0B54E5C8E57CE4B40
81513	KA30	GB	0101000020E6100000AFCE31207B6D13C0AA9A20EA3EE84B40
81514	KA30 8AN	GB	0101000020E61000007FA4880CAB7813C01B8524B37AE54B40
81515	KA30 8EZ	GB	0101000020E61000006D59BE2EC36F13C03719558671E34B40
81516	KA30 9DN	GB	0101000020E6100000643C4A253C7113C03F56F0DB10E74B40
81517	KA30 9NE	GB	0101000020E6100000122F4FE78A7213C0E146CA1649E54B40
81518	KA30 9NJ	GB	0101000020E6100000812381069B6A13C0DA8F149161ED4B40
81519	KA4 8DT	GB	0101000020E6100000E04C4C17628511C0EC6B5D6A84CC4B40
81520	KA4 8NP	GB	0101000020E6100000FA7E6ABC745311C0B1C1C2499AC74B40
81521	KA4 8QE	GB	0101000020E6100000713D0AD7A34011C085B1852007C94B40
81522	KA5	GB	0101000020E610000094861A8524A312C0651A4D2EC6CE4B40
81523	KA5 3LH	GB	0101000020E6100000AEB8382A371112C06C088ECBB8D54B40
81524	KA5 5RB	GB	0101000020E6100000DB368C82E0F111C0D960E124CDC14B40
81525	KA5 5RL	GB	0101000020E6100000473CD9CD8CDE11C06CCD565EF2C14B40
81526	KA6 5EH	GB	0101000020E61000007C4276DEC61612C08350DEC7D1BC4B40
81527	KA6 6BP	GB	0101000020E61000007D941117807612C038F92D3A59B44B40
81528	KA6 6DT	GB	0101000020E61000001A69A9BC1D6112C0A835CD3B4EB34B40
81529	KA6 7HF	GB	0101000020E610000080B8AB57918111C0BA15C26A2CB74B40
81530	KA6 7HG	GB	0101000020E610000028B8585183C911C0E0D91EBDE1B24B40
81531	KA6 7QP	GB	0101000020E61000007D3D5FB35C9611C0D3872EA86FA94B40
81532	KA7 1DU	GB	0101000020E6100000E44EE960FD8F12C0D388997D1EBB4B40
81533	KA7 2DG	GB	0101000020E6100000CB65A3737E8A12C04F95EF1989BA4B40
81534	KA7 2DL	GB	0101000020E6100000E675C4211B8812C09E60FF756EBA4B40
81535	KA7 2PQ	GB	0101000020E6100000B20DDC813A8512C03694DA8B68B94B40
81536	KA7 2RA	GB	0101000020E61000005AD76839D08312C0B6DAC35E28BA4B40
81537	KA7 2RB	GB	0101000020E6100000DC114E0B5E8412C02C634337FBB94B40
81538	KA7 2RW	GB	0101000020E6100000D9B27C5D867F12C0D4F02DAC1BBB4B40
81539	KA7 2SF	GB	0101000020E610000000A8E2C62D8612C03F027FF8F9B94B40
81540	KA7 2XH	GB	0101000020E6100000CAFACDC4748112C059C4B0C398BA4B40
81541	KA7 3LZ	GB	0101000020E6100000228E75711B6D12C006F357C85CB94B40
81542	KA7 4HB	GB	0101000020E610000097900F7A369B12C0922232ACE2B74B40
81543	KA7 4LU	GB	0101000020E61000002A1A6B7F67FB12C0B5A7E49CD8B34B40
81544	KA7 4XF	GB	0101000020E6100000ED45B41D537712C058E542E55FB74B40
81545	KA74E	GB	0101000020E6100000F452B131AF9312C0EBC37AA356B84B40
81546	KA8 0DN	GB	0101000020E6100000E622BE13B37E12C00516C09481BB4B40
81547	KA8 0EZ	GB	0101000020E6100000C64D0D349F8312C0FA9B508880BB4B40
81548	KA8 0PX	GB	0101000020E610000047E9D2BF247512C0AF08FEB792BB4B40
81549	KA8 0QL	GB	0101000020E610000053758F6CAE5A12C0897D022846BC4B40
81550	KA8 8LA	GB	0101000020E6100000D9B27C5D867F12C0D3F8855792BC4B40
81551	KA8 8NN	GB	0101000020E6100000617138F3AB7912C05B22179CC1BD4B40
81552	KA8 9PA	GB	0101000020E61000007FDFBF79717212C05663096B63BA4B40
81553	KA9 1PL	GB	0101000020E61000009818CBF44B7412C010CAFB389ABF4B40
81554	KA9 1RR	GB	0101000020E610000083C0CAA1457612C0C8CEDBD8ECBE4B40
81555	KA9 1SQ	GB	0101000020E6100000DD06B5DFDA7912C06E6E4C4F58BE4B40
81556	KA9 2DL	GB	0101000020E6100000A4367172BF7312C0EF3A1BF2CFBE4B40
81557	KA9 2TA	GB	0101000020E61000006552431B805D12C05C8FC2F528C04B40
81558	KA9 9	GB	0101000020E61000009370218FE07612C0EA060ABC93BF4B40
81559	KT1	GB	0101000020E61000009510ACAA97DFD3BF20B24813EFB44940
81560	KT1 1PY	GB	0101000020E61000000533A6608DB3D3BFB2F2CB608CB44940
81561	KT1 1UJ	GB	0101000020E6100000A18158367348D3BFF2785A7EE0B44940
81562	KT1 2AP	GB	0101000020E6100000B5DFDA899290D3BF86E28E37F9B34940
81563	KT1 2BB	GB	0101000020E610000050E108522976D3BF981936CAFAB34940
81564	KT1 2DN	GB	0101000020E61000003A5CAB3DEC85D3BF33315D88D5B34940
81565	KT1 2DY	GB	0101000020E6100000C904FC1A4982D3BFF645425BCEB34940
81566	KT1 2EE	GB	0101000020E6100000ABAFAE0AD462D3BF2F8507CDAEB34940
81567	KT1 2EH	GB	0101000020E6100000B6DAC35E2860D3BF607825C973B34940
81568	KT1 2LJ	GB	0101000020E610000000C79E3D97A9D3BFECFB709010B34940
81569	KT1 2NP	GB	0101000020E61000007CB8E4B8533AD3BFA0A52BD846B44940
81570	KT1 2PS	GB	0101000020E6100000923D42CD902AD3BF048E041A6CB44940
81571	KT1 2PY	GB	0101000020E6100000E411DC48D922D3BFB875374F75B44940
81572	KT1 2QY	GB	0101000020E61000009A081B9E5E29D3BF10786000E1B34940
81573	KT1 2QZ	GB	0101000020E61000006762BA10AB3FD3BFBA6A9E23F2B34940
81574	KT1 2SE	GB	0101000020E610000078D0ECBAB722D3BFFE98D6A6B1B34940
81575	KT1 2SF	GB	0101000020E6100000594E42E90B21D3BF2E008DD2A5B34940
81576	KT1 2SG	GB	0101000020E610000036E49F19C407D3BF42AF3F89CFB34940
81577	KT1 2TY	GB	0101000020E61000007DAF21382EE3D2BF5589B2B794B34940
81578	KT1 2UN	GB	0101000020E61000004033880FECF8D2BF093543AA28B44940
81579	KT1 3AP	GB	0101000020E6100000CE5147C7D5C8D2BFABECBB22F8B34940
81580	KT1 3AY	GB	0101000020E61000002C2D23F59ECAD2BF53211E8997B34940
81581	KT1 3BB	GB	0101000020E61000009D853DEDF0D7D2BF4B77D7D990B34940
81582	KT1 3BJ	GB	0101000020E610000044300E2E1D73D2BFDBF7A8BF5EB34940
81583	KT1 3DS	GB	0101000020E610000095B54DF1B8A8D2BF9F77634161B44940
81584	KT1 3EG	GB	0101000020E6100000978E39CFD897D2BF3691990B5CB44940
81585	KT1 3GD	GB	0101000020E6100000F67B629D2ADFD2BFBB0CFFE906B44940
81586	KT1 3JY	GB	0101000020E610000006D9B27C5D86D2BF63B323D577B44940
81587	KT1 3PS	GB	0101000020E6100000F4FA93F8DC09D2BF85CC9541B5B34940
81588	KT1 3QN	GB	0101000020E6100000F96706F1811DD2BF4C3448C153B44940
81589	KT1 3QX	GB	0101000020E6100000543A58FFE730D2BF519FE40E9BB44940
81590	KT1 4AD	GB	0101000020E6100000271763601DC7D3BFAB97DF6932B34940
81591	KT1 4AL	GB	0101000020E6100000522CB7B41A12D4BF9EEA909BE1B44940
81592	KT1 4AT	GB	0101000020E6100000043BFE0B0401D4BF3621AD31E8B44940
81593	KT1 4AU	GB	0101000020E61000001C7920B24813D4BF38143E5B07B54940
81594	KT1 4BE	GB	0101000020E61000002FF7C9518028D3BF6FF4311F10B44940
81595	KT1 4DQ	GB	0101000020E61000008B170B43E4F4D3BFD8F4A0A014B54940
81596	KT1 4DR	GB	0101000020E6100000E71BD13DEB1AD5BFDF6C73637AB44940
81597	KT1 4ED	GB	0101000020E6100000E109BDFE243ED4BFEE05668522B54940
81598	KT1 4HP	GB	0101000020E6100000244223D8B8FED3BF20D4450A65B54940
81599	KT1 4HW	GB	0101000020E610000033FB3C4679E6D3BF14D044D8F0B44940
81600	KT10	GB	0101000020E6100000D671FC5069C4D5BFF817416326AF4940
81601	KT10 0	GB	0101000020E6100000894336902E36D6BFEB909BE106AE4940
81602	KT10 0BG	GB	0101000020E6100000F1A1444B1E4FD5BF1AE0826C59B04940
81603	KT10 0BQ	GB	0101000020E6100000698D4127840ED5BF271422E010B04940
81604	KT10 0DB	GB	0101000020E61000008F334DD87E32D5BF3271AB2006B04940
81605	KT10 0DL	GB	0101000020E61000009F2287889B53D5BF6118B0E42AAE4940
81606	KT10 0NB	GB	0101000020E6100000073F7100FDBED5BF459BE3DC26AE4940
81607	KT10 0PJ	GB	0101000020E6100000CD5CE0F25833D6BF178046E9D2AD4940
81608	KT10 0RF	GB	0101000020E6100000D829560DC2DCD5BF6B47718E3AAE4940
81609	KT10 0RN	GB	0101000020E610000077BCC96FD1C9D5BF32022A1C41AE4940
81610	KT10 0RZ	GB	0101000020E6100000616BB6F292FFD5BF386744696FAE4940
81611	KT10 0SR	GB	0101000020E6100000A7AD11C138B8D5BF68E6C93505B04940
81612	KT10 8AA	GB	0101000020E6100000E62329E96168D7BF05DCF3FC69AF4940
81613	KT10 8AZ	GB	0101000020E6100000A4C684984BAAD7BF7B4FE5B4A7B04940
81614	KT10 8DY	GB	0101000020E6100000BAA0BE654E97D6BF041F8315A7B04940
81615	KT10 8HF	GB	0101000020E6100000317898F6CDFDD6BF02486DE2E4B04940
81616	KT10 8NP	GB	0101000020E610000018778368AD68D7BF1AFA27B858AF4940
81617	KT10 8PS	GB	0101000020E61000005D363AE7A738D7BF70B54E5C8EAF4940
81618	KT10 9AJ	GB	0101000020E610000039B4C876BE9FD7BF2BA226FA7CB04940
81619	KT10 9AL	GB	0101000020E6100000572426A8E15BD6BFEC4E779E78B04940
81620	KT10 9AZ	GB	0101000020E6100000613596B036C6D5BF35F10EF0A4AF4940
81621	KT10 9DU	GB	0101000020E6100000C554FA0967B7D6BF66DAFE9595AE4940
81622	KT10 9HB	GB	0101000020E6100000333509DE9046D7BF56D28A6F28AE4940
81623	KT10 9JG	GB	0101000020E610000043FE99417C60D8BF1A6D5512D9AD4940
81624	KT10 9NU	GB	0101000020E6100000C040102043C7D6BFB8CA13083BAF4940
81625	KT10 9SD	GB	0101000020E61000008351499D8026D7BF71C6302768AF4940
81626	KT11	GB	0101000020E61000009DD843FB58C1D7BFACE122F774B34940
81627	KT11 1BB	GB	0101000020E6100000513239B5334CD9BFE84EB0FF3AAB4940
81628	KT11 1LT	GB	0101000020E61000008177F2E9B12DDCBFE50E9BC8CCA74940
81629	KT11 1LU	GB	0101000020E61000005BCEA5B8AAECDBBF6B10E6762FA74940
81630	KT11 1NG	GB	0101000020E610000050FD8348861CDCBFC64FE3DEFCA64940
81631	KT11 2AH	GB	0101000020E6100000CAC0012D5DC1D9BFA4A5F27684AD4940
81632	KT11 2ND	GB	0101000020E6100000958098840B79D9BF5DFB027AE1AA4940
81633	KT11 3JB	GB	0101000020E6100000969526A5A0DBD8BF691D554D10A94940
81634	KT12	GB	0101000020E61000003C2EAA454431DBBF6364C91CCBAD4940
81635	KT12 1EJ	GB	0101000020E6100000AF5C6F9BA910DBBF3CDA38622DB04940
81636	KT12 1EU	GB	0101000020E6100000D906EE409DF2DABF71546EA296B04940
81637	KT12 1NR	GB	0101000020E610000099BB96900F7ADABF5801BEDBBCAF4940
81638	KT12 1PE	GB	0101000020E610000075C93846B247DABF580053060EB04940
81639	KT12 1RZ	GB	0101000020E6100000B3EF8AE07F2BDABF369204E10AB04940
81640	KT12 2AE	GB	0101000020E6100000CF656A12BC21DABF9147702365B14940
81641	KT12 2EG	GB	0101000020E6100000D2FE0758AB76D9BF99F1B6D26BB34940
81642	KT12 2JB	GB	0101000020E61000006C223317B83CDABFB1FCF9B660B34940
81643	KT12 2LA	GB	0101000020E61000000CCD751A69A9DABFBC7669C361B14940
81644	KT12 2LE	GB	0101000020E61000004B77D7D9907FDABF295E656D53B24940
81645	KT12 2LJ	GB	0101000020E6100000323A2009FB76DABF6F675F7990B24940
81646	KT12 2PF	GB	0101000020E6100000C8EBC1A4F8F8DABFFE2955A2ECB14940
81647	KT12 3	GB	0101000020E61000003D0FEECEDA6DD9BF836C59BE2EB14940
81648	KT12 3HY	GB	0101000020E610000078D32D3BC43FDABFCD3B4ED191B04940
81649	KT12 3PP	GB	0101000020E6100000917BBABA63B1D8BF79B0C56E9FB14940
81650	KT12 4AA	GB	0101000020E61000008BDF14562AA8D9BF0874266DAAAE4940
81651	KT12 4JF	GB	0101000020E61000000C79043752B6D9BF37FFAF3A72AE4940
81652	KT12 4SQ	GB	0101000020E6100000A4A65D4C33DDD8BF855CA96741B04940
81653	KT12 5AZ	GB	0101000020E610000093A8177C9A93DABF8E226B0DA5AE4940
81654	KT12 5HL	GB	0101000020E6100000FA62EFC517EDD9BFCF85915ED4AE4940
81655	KT12 5HP	GB	0101000020E610000036B05582C5E1D9BF15FE0C6FD6AE4940
81656	KT12 5LJ	GB	0101000020E610000091EEE714E467DABF5A12A0A696AF4940
81657	KT12 5PP	GB	0101000020E6100000268FA7E507AEDABF2CBCCB457CAF4940
81658	KT12 5QG	GB	0101000020E61000006075E4486760D8BFCF31207BBDAF4940
81659	KT13 0BY	GB	0101000020E6100000B1A6B228ECA2DCBFF12E17F19DAE4940
81660	KT13 0DS	GB	0101000020E6100000A08CF161F6B2DDBFDBA4A2B1F6AD4940
81661	KT13 0DZ	GB	0101000020E6100000630E828E56B5DCBF552E54FEB5AE4940
81662	KT13 0EP	GB	0101000020E61000001E54E23AC615DCBF280CCA349AAE4940
81663	KT13 0QN	GB	0101000020E61000007FD93D7958A8DDBFCAC0012D5DAD4940
81664	KT13 0UX	GB	0101000020E61000004A7CEE04FBAFDDBFC3EFA65B76AC4940
81665	KT13 0XF	GB	0101000020E6100000247B849A2155DEBF077C7E1821AC4940
81666	KT13 8AB	GB	0101000020E6100000F8C3CF7F0F5EDDBF5531957EC2AF4940
81667	KT13 8BA	GB	0101000020E6100000DE770C8FFD2CDDBF9450FA42C8AF4940
81668	KT13 8DE	GB	0101000020E610000034130CE71A66DDBF3BE2900DA4AF4940
81669	KT13 8DG	GB	0101000020E610000003CE52B29C84DDBF94BF7B478DAF4940
81670	KT13 8EQ	GB	0101000020E61000004FB0FF3A376DDDBFA8902BF52CB04940
81671	KT13 8LP	GB	0101000020E6100000ED0BE8853B17DDBF118DEE2076B04940
81672	KT13 8NG	GB	0101000020E6100000350A4966F50EDDBFF44F70B1A2B04940
81673	KT13 8PA	GB	0101000020E6100000DB8651103CBEDCBFB2B96A9E23B04940
81674	KT13 8RJ	GB	0101000020E61000000CAF2479AEEFDCBF83A5BA8097AF4940
81675	KT13 8TX	GB	0101000020E61000007B12D89C8367DDBFF777B6476FAE4940
81676	KT13 8UD	GB	0101000020E6100000085740A19E3EDDBF1F4C8A8F4FAE4940
81677	KT13 8UE	GB	0101000020E610000089EDEE01BA2FDDBFF433F5BA45AE4940
81678	KT13 8UT	GB	0101000020E6100000308331225168DDBFB43BA41820AF4940
81679	KT13 8XS	GB	0101000020E6100000BFB854A52DAEDDBF096B63EC84AF4940
81680	KT13 9BN	GB	0101000020E6100000F2B6D26BB3B1DCBFA9F57EA31DAF4940
81681	KT13 9DX	GB	0101000020E610000095D74AE82E89DCBFFD14C78157AF4940
81682	KT13 9HE	GB	0101000020E6100000006F8104C58FDCBF66F9BA0CFFAF4940
81683	KT13 9LA	GB	0101000020E6100000878C47A98427DCBF72F90FE9B7AF4940
81684	KT13 9NH	GB	0101000020E6100000363D2828452BDCBFA5A31CCC26B04940
81685	KT13 9NX	GB	0101000020E610000028D4D347E00FDCBFF4346090F4AF4940
81686	KT13 9QD	GB	0101000020E6100000BB0A293FA9F6DBBFF0C4AC1743AF4940
81687	KT13 9RW	GB	0101000020E61000009E7AA4C16D6DDBBF1B66683C11B04940
81688	KT13 9TL	GB	0101000020E6100000E54691B58652DBBF08944DB9C2AF4940
81689	KT13 9UZ	GB	0101000020E61000008B54185B0872DCBF5BB6D61709AF4940
81690	KT14	GB	0101000020E61000002618CE35CCD0DFBF8D7E349C32AB4940
81691	KT14 6AL	GB	0101000020E6100000601DC70F9546E0BF4F1E166A4DAB4940
81692	KT14 6DR	GB	0101000020E610000066DB696B4430E0BF9C525E2BA1AB4940
81693	KT14 6DY	GB	0101000020E6100000E97DE36BCF2CE0BFF1BDBF417BAB4940
81694	KT14 6JL	GB	0101000020E6100000AF946588635DE0BFC2BD326FD5A94940
81695	KT14 6JQ	GB	0101000020E610000004AC55BB2624E0BF975643E21EAB4940
81696	KT14 7PN	GB	0101000020E6100000A94BC631923DDEBF094E7D2079AB4940
81697	KT14 7QT	GB	0101000020E6100000897AC1A73979DEBFE01115AA9BAB4940
81698	KT14 7RP	GB	0101000020E610000093A7ACA6EB89DEBFAE49B72572A94940
81699	KT15	GB	0101000020E6100000799274CDE41BE0BF7E1AF7E637AE4940
81700	KT15 1AT	GB	0101000020E61000005F4205871744E0BFBADC60A8C3AE4940
81701	KT15 1JJ	GB	0101000020E61000003DB665C0594AE0BF7BDB4C8578AE4940
81702	KT15 1NQ	GB	0101000020E6100000C9E88024ECDBDFBFA379008BFCAE4940
81703	KT15 1PG	GB	0101000020E610000027327381CB63DFBFAF777FBC57AF4940
81704	KT15 1RB	GB	0101000020E61000001781B1BE81C9DFBF8D5F7825C9AF4940
81705	KT15 1TS	GB	0101000020E610000029EB3713D385DFBF3718EAB0C2AF4940
81706	KT15 2AS	GB	0101000020E6100000DA3BA3AD4A22DFBF226FB9FAB1AF4940
81707	KT15 2HR	GB	0101000020E61000000F62670A9DD7DEBF543882548AAF4940
81708	KT15 2JL	GB	0101000020E61000006B64575A46EADEBF95BA641C23AF4940
81709	KT15 2PB	GB	0101000020E610000042E90B21E7FDDEBF5116BEBED6AF4940
81710	KT15 2PW	GB	0101000020E61000003C6876DD5B91DFBFFCA6B05241AF4940
81711	KT15 2SP	GB	0101000020E6100000988A8D791D71DEBF9E23F25D4AAF4940
81712	KT15 3BG	GB	0101000020E6100000917F66101FD8DFBFA983BC1E4CAC4940
81713	KT15 3ED	GB	0101000020E610000007616EF7721FE0BFCDAB3AAB05AC4940
81714	KT15 3ES	GB	0101000020E61000002C0C91D3D7F3DFBFB2BD16F4DEAC4940
81715	KT15 3HL	GB	0101000020E6100000B267CF656A12E0BF533D997FF4AB4940
81716	KT15 3LQ	GB	0101000020E610000055849B8C2AC3DEBF60AE450BD0AC4940
81717	KT15 3NH	GB	0101000020E61000007505DB8827BBDFBF7C65DEAAEBAC4940
81718	KT15 3NL	GB	0101000020E6100000016A6AD95A5FDFBFE25817B7D1AC4940
81719	KT15 3PX	GB	0101000020E61000004223D8B8FE5DE0BF1F2FA4C343AC4940
81720	KT15 3QD	GB	0101000020E6100000FEEDB25F77BAE0BFC4CE143AAFAB4940
81721	KT15 3RB	GB	0101000020E610000076374F75C8CDDFBFE04735ECF7AC4940
81722	KT15 3RD	GB	0101000020E6100000253E7782FDD7DFBF8F37F92D3AAD4940
81723	KT15 3SA	GB	0101000020E6100000DA73999A046FE0BF18213CDA38AC4940
81724	KT15 3SH	GB	0101000020E6100000902E36AD1482E0BFB7F1272A1BAC4940
81725	KT15 3TN	GB	0101000020E61000009CC3B5DAC35EE0BF4AEEB089CCAC4940
81726	KT16	GB	0101000020E610000037A8FDD64E94E1BF66DD3F16A2AF4940
81727	KT16 0HG	GB	0101000020E6100000C971A774B0FEE0BFBAA29410ACAE4940
81728	KT16 0HY	GB	0101000020E610000054E57B4622B4E0BFBA10AB3FC2AE4940
81729	KT16 0HZ	GB	0101000020E610000061889CBE9EAFE0BFD8EF8975AAAE4940
81730	KT16 0JX	GB	0101000020E61000002E76FBAC32D3E0BF3D997FF44DAE4940
81731	KT16 0LE	GB	0101000020E61000003D0E83F92BE4E0BF3387A4164AAE4940
81732	KT16 0NZ	GB	0101000020E610000061C3D32B6519E1BF8351499D80AE4940
81733	KT16 0QG	GB	0101000020E6100000CB64389ECF80E1BF952D9276A3AD4940
81734	KT16 2RB	GB	0101000020E6100000DDB243FCC396E0BF5B44149337B04940
81735	KT16 8AJ	GB	0101000020E610000023BBD23252EFDFBFBF1072DEFFB14940
81736	KT16 8BJ	GB	0101000020E61000005B069CA56439E0BF35F10EF0A4B14940
81737	KT16 8HP	GB	0101000020E6100000F98381E7DEC3DFBF840D4FAF94B14940
81738	KT16 8HQ	GB	0101000020E610000085984BAAB69BDFBF4D6551D845B14940
81739	KT16 8HT	GB	0101000020E61000004FE8F527F1B9DFBFFE648C0FB3B14940
81740	KT16 8HX	GB	0101000020E6100000A7052FFA0AD2DFBFA453573ECBB14940
81741	KT16 8LL	GB	0101000020E610000066834C327216DFBF04E8F7FD9BB14940
81742	KT16 8NT	GB	0101000020E61000000B410E4A9869DFBFEE3EC7478BB14940
81743	KT16 8QF	GB	0101000020E61000004C8E3BA583F5DFBF9770E82D1EB44940
81744	KT16 8RF	GB	0101000020E61000002942EA76F615E0BF5EBC1FB75FB24940
81745	KT16 9BG	GB	0101000020E610000007962364204FE0BF7A185A9D9CB14940
81746	KT16 9BN	GB	0101000020E610000079B130444E5FE0BF6DC83F3388B14940
81747	KT16 9GT	GB	0101000020E6100000B16CE690D442E0BF00E48409A3B14940
81748	KT16 9PE	GB	0101000020E6100000F7393E5A9CB1E0BFC1AC50A4FBAF4940
81749	KT16 9PP	GB	0101000020E61000003049658A3988E0BF05C24EB16AB04940
81750	KT16 9QS	GB	0101000020E6100000EDF1423A3C84E0BF853E58C686B04940
81751	KT16 9RB	GB	0101000020E610000094C151F2EA9CE0BFAA0EB9196EB04940
81752	KT17 1HB	GB	0101000020E6100000A3409FC893A4D0BF16DA39CD02AB4940
81753	KT17 1LL	GB	0101000020E6100000B54FC763062AD0BFB306EFAB72AB4940
81754	KT17 1QR	GB	0101000020E61000000742B28009DCCEBFD6E07D552EAC4940
81755	KT17 1QZ	GB	0101000020E6100000583849F3C7B4CEBF2C7FBE2D58AC4940
81756	KT17 1TU	GB	0101000020E6100000A38FF9804067D0BFF20A444FCAAC4940
81757	KT17 2EB	GB	0101000020E6100000CFBA46CB811ED0BF663046240AAD4940
81758	KT17 2JA	GB	0101000020E6100000E3A430EF71A6CFBFE42F2DEA93AE4940
81759	KT17 2NA	GB	0101000020E6100000FBC9181F662FCFBF30A182C30BAE4940
81760	KT17 2PL	GB	0101000020E6100000FA0B3D62F4DCCEBF61FF756EDAAC4940
81761	KT17 2PQ	GB	0101000020E61000003E78EDD286C3CEBF6D73637AC2AC4940
81762	KT17 2RF	GB	0101000020E6100000726DA818E76FCEBFEDB60BCD75AC4940
81763	KT17 3AX	GB	0101000020E61000003999B8551003D0BF72A43330F2AA4940
81764	KT17 3JX	GB	0101000020E6100000A3E6ABE46377CFBF588FFB56EBAA4940
81765	KT17 3LN	GB	0101000020E61000004D4BAC8C463ECDBFA1664815C5AB4940
81766	KT17 3NL	GB	0101000020E61000006EC493DDCCE8CDBF5A8121AB5BA94940
81767	KT17 4AZ	GB	0101000020E61000008FE1B19FC552D0BFD55E44DB31AB4940
81768	KT17 4BY	GB	0101000020E6100000B37C5D86FF74CFBF0589EDEE01AA4940
81769	KT17 4BZ	GB	0101000020E6100000B8CEBF5DF6EBCEBF0E130D52F0AA4940
81770	KT17 4HQ	GB	0101000020E610000015E0BBCD1B27D0BF98A432C51CAA4940
81771	KT17 4JS	GB	0101000020E6100000D2E4620CACE3CEBF946934B918A94940
81772	KT17 4LD	GB	0101000020E6100000115322895E46D0BF69C36169E0A94940
81773	KT18	GB	0101000020E610000026A94C310741CFBFE9EFA5F0A0A74940
81774	KT18 5HR	GB	0101000020E6100000D33252EFA99CD0BFF817416326A94940
81775	KT18 5JH	GB	0101000020E6100000C39B35785F95D0BF9947FE60E0A94940
81776	KT18 5JY	GB	0101000020E6100000340F60915F3FD0BFC367EBE060A94940
81777	KT18 5NZ	GB	0101000020E61000007E1EA33CF372CEBF2D7AA702EEA74940
81778	KT18 5PR	GB	0101000020E61000000DDFC2BAF1EECEBF994869368FA74940
81779	KT18 5QS	GB	0101000020E61000002D431CEBE236CEBF10406A1327A74940
81780	KT18 5TZ	GB	0101000020E610000007280D350A49CEBF115322895EA84940
81781	KT18 6JB	GB	0101000020E61000001B0FB6D8EDB3D0BF75CB0EF10FA74940
81782	KT18 7DX	GB	0101000020E610000091F3FE3F4E98D1BFC13BF9F4D8A84940
81783	KT18 7EY	GB	0101000020E61000008FC6A17E17B6D1BFAF264F594DA94940
81784	KT18 7HD	GB	0101000020E61000000C5872158BDFD1BF9966BAD749A94940
81785	KT18 7QZ	GB	0101000020E61000000647C9AB730CD1BFEA7AA2EBC2A94940
81786	KT18 7SJ	GB	0101000020E61000005C1E6B4606B9D1BFD2C5A69542AA4940
81787	KT19	GB	0101000020E61000007FBE2D58AA0BD1BF11DF89592FAC4940
81788	KT19 0AN	GB	0101000020E6100000E5EE737CB438D0BF0EF3E505D8AD4940
81789	KT19 0ET	GB	0101000020E61000008544DAC69FA8D0BFA56950340FAE4940
81790	KT19 0HX	GB	0101000020E6100000F33CB83B6BB7CFBF293FA9F6E9AA4940
81791	KT19 0ND	GB	0101000020E6100000DCF4673F5244D0BFE44BA8E0F0AE4940
81792	KT19 0QJ	GB	0101000020E61000005837DE1D19ABD0BFFE0C6FD6E0AF4940
81793	KT19 8AD	GB	0101000020E6100000022B8716D9CED0BFD542C9E4D4AA4940
81794	KT19 8EW	GB	0101000020E6100000FF59F3E32F2DD1BFA0185932C7AA4940
81795	KT19 8EY	GB	0101000020E6100000FB73D190F128D1BFB94F8E0244AB4940
81796	KT19 8LN	GB	0101000020E6100000E2CD1ABCAFCAD1BF8DEC4ACB48AB4940
81797	KT19 8LZ	GB	0101000020E610000088BB7A15191DD2BFC4CF7F0F5EAB4940
81798	KT19 8PB	GB	0101000020E610000029B000A60C1CD3BF1ABFF04A92AB4940
81799	KT19 8QW	GB	0101000020E61000003DD34B8C65FAD0BF6EBF7CB262AA4940
81800	KT19 8RD	GB	0101000020E610000054C4E9245B5DD1BF259012BBB6AB4940
81801	KT19 8RP	GB	0101000020E61000006005F86EF3C6D1BFDE921CB0ABAB4940
81802	KT19 8TU	GB	0101000020E6100000EE5F5969520AD1BF23A46E675FAB4940
81803	KT19 9SY	GB	0101000020E6100000C5538F34B8ADD0BFC68844A165AD4940
81804	KT19 9UF	GB	0101000020E6100000FD8348861C5BD0BF8C2D043928AD4940
81805	KT2	GB	0101000020E6100000425C397B67B4D2BFB3B6291E17B54940
81806	KT2 2ET	GB	0101000020E610000049490F43AB93D3BFA0DCB6EF51B34940
81807	KT2 4LD	GB	0101000020E6100000DE21C5008926D0BF35EF384547B44940
81808	KT2 5	GB	0101000020E610000032022A1C412AD3BFBEA4315A47B54940
81809	KT2 5AP	GB	0101000020E6100000D9EC48F59D5FD3BF10AD156D8EB54940
81810	KT2 5LW	GB	0101000020E61000000455A3570394D2BFC685032159B64940
81811	KT2 5LY	GB	0101000020E61000007AFEB4519D0ED2BF698A00A777B54940
81812	KT2 6AF	GB	0101000020E610000020D4450A65E1D2BF9C18929389B54940
81813	KT2 6DW	GB	0101000020E61000003B3602F1BA7ED2BF6B4AB20E47B54940
81814	KT2 6HU	GB	0101000020E610000011DF89592F86D3BF40BD19355FB54940
81815	KT2 6NH	GB	0101000020E6100000C170AE6186C6D2BF2AA8A8FA95B44940
81816	KT2 6NZ	GB	0101000020E61000000A9FAD8383BDD2BFC443183F8DB54940
81817	KT2 6PG	GB	0101000020E6100000419FC893A46BD2BF03999D45EFB44940
81818	KT2 6PL	GB	0101000020E610000022FC8BA03193D2BFAAEE91CD55B54940
81819	KT2 6PY	GB	0101000020E61000007100FDBE7FF3D2BF2315C61682B44940
81820	KT2 6QL	GB	0101000020E6100000417DCB9C2E8BD2BF3BC8EBC1A4B44940
81821	KT2 6QP	GB	0101000020E61000007B6649809A5AD2BF00FDBE7FF3B44940
81822	KT2 6QW	GB	0101000020E6100000FEB627486C77D2BF5DDE1CAED5B44940
81823	KT2 6RL	GB	0101000020E61000004031B2648EE5D2BFC1C760C5A9B44940
81824	KT2 6SG	GB	0101000020E610000023F609A01859D2BF506EDBF7A8B54940
81825	KT2 7	GB	0101000020E6100000BDC62E51BD35D2BF1536035C90B54940
81826	KT2 7AJ	GB	0101000020E610000098F90E7EE200D2BF1B9E5E29CBB44940
81827	KT2 7AZ	GB	0101000020E6100000020F0C207C28D2BFFEB8FDF2C9B44940
81828	KT2 7JN	GB	0101000020E61000005F984C158C4AD1BFA67EDE54A4B64940
81829	KT2 7PG	GB	0101000020E61000006B990CC7F319D1BFC233A14962B54940
81830	KT2 7PQ	GB	0101000020E61000009581035ABA82D1BF38C0CC77F0B54940
81831	KT2 7QB	GB	0101000020E6100000EEB435221807D2BF8CBFED0912B54940
81832	KT2 7RD	GB	0101000020E6100000A14D0E9F7422D2BF6FBBD05CA7B54940
81833	KT2 7RQ	GB	0101000020E6100000E2033BFE0B04D2BF0F9C33A2B4B54940
81834	KT20 5EF	GB	0101000020E6100000A182C30B2252CFBF102384471BA54940
81835	KT20 5EP	GB	0101000020E6100000BC5983F755B9CEBFCDB1BCAB1EA64940
81836	KT20 5HY	GB	0101000020E6100000AC5791D10149CEBF0C04013274A64940
81837	KT20 5JA	GB	0101000020E6100000E564E256410CCEBF753BFBCA83A64940
81838	KT20 5PQ	GB	0101000020E6100000CB4752D2C3D0CCBF185C7347FFA74940
81839	KT20 5QY	GB	0101000020E610000073DA53724EECCDBF04763579CAA44940
81840	KT20 5SF	GB	0101000020E6100000068195438B6CCDBFFFEC478AC8A44940
81841	KT20 5SP	GB	0101000020E6100000C5909C4CDC2ACEBFF59ECA694FA54940
81842	KT20 6EN	GB	0101000020E6100000193A765089EBCABFC4EBFA05BBA54940
81843	KT20 6EU	GB	0101000020E6100000558847E2E5E9CABFE8853B1746A64940
81844	KT20 6NP	GB	0101000020E6100000809E060C923ECBBFFB73D190F1A44940
81845	KT20 6UP	GB	0101000020E6100000BA9F53909F8DCABF7CB8E4B853A24940
81846	KT20 7AS	GB	0101000020E6100000594C6C3EAE0DCBBFF3AFE595EBA14940
81847	KT20 7DP	GB	0101000020E61000009D685721E527CBBF4913EF004FA24940
81848	KT20 7EJ	GB	0101000020E6100000FFCEF6E80DF7CBBFE8305F5E80A14940
81849	KT20 7LB	GB	0101000020E6100000BC3D0801F912D4BF6CCCEB8843A04940
81850	KT20 7LR	GB	0101000020E610000075594C6C3EAED0BF978BF84ECCA24940
81851	KT20 7NZ	GB	0101000020E6100000770FD07D39B3D0BF5ABA826DC4A14940
81852	KT20 7PY	GB	0101000020E61000006FF1F09E03CBD1BF00C5C89239A04940
81853	KT20 7TA	GB	0101000020E6100000D508FD4CBD6ECDBF39268BFB8FA44940
81854	KT21 1	GB	0101000020E61000004354E1CFF066D3BF524832AB77A84940
81855	KT21 1BH	GB	0101000020E610000043723271AB20D3BFC3B81B446BA74940
81856	KT21 1HJ	GB	0101000020E6100000BF9B6ED921FED1BFFB21365838A74940
81857	KT21 1JX	GB	0101000020E6100000A9DC442DCDADD2BFA0C1A6CEA3A84940
81858	KT21 1LU	GB	0101000020E610000073124A5F0839D2BFA4C16D6DE1A74940
81859	KT21 1QY	GB	0101000020E610000042075DC2A1B7D2BFF4E159828CA84940
81860	KT21 1RH	GB	0101000020E610000071FF91E9D0E9D2BF0987DEE2E1A74940
81861	KT21 2BE	GB	0101000020E6100000B16B7BBB2539D3BF6C76A4FACEA74940
81862	KT21 2DR	GB	0101000020E61000008B8BA37213B5D3BF10CD3CB9A6A84940
81863	KT21 2HW	GB	0101000020E6100000E1ECD632198ED4BFF9484A7A18A84940
81864	KT21 2JZ	GB	0101000020E6100000111E6D1CB116D0BF61DEE34C13A84940
81865	KT21 2NS	GB	0101000020E61000009D84D21742CED3BF46459C4EB2A74940
81866	KT21 2QE	GB	0101000020E610000012F92EA52E19D4BFA67D737FF5A64940
81867	KT21 2RD	GB	0101000020E61000004C88B9A46ABBD3BF09DFFB1BB4A74940
81868	KT21 2TH	GB	0101000020E61000005C1B2AC6F99BD3BF9161156F64A64940
81869	KT21 2TP	GB	0101000020E6100000A4198BA6B393D3BF06BAF605F4A64940
81870	KT22 0EF	GB	0101000020E610000012DDB3AED172D5BF91D10149D8A74940
81871	KT22 0JE	GB	0101000020E61000007381CB63CDC8D6BF69368FC360AA4940
81872	KT22 0LJ	GB	0101000020E6100000325706D50627D7BF5646239F57AA4940
81873	KT22 0QN	GB	0101000020E6100000AFB0E07EC003D7BFB1C403CAA6AA4940
81874	KT22 7HX	GB	0101000020E610000040FA264D83A2D5BFDF6C73637AA64940
81875	KT22 7LP	GB	0101000020E61000007E5704FF5BC9D5BFA437DC476EA74940
81876	KT22 7NR	GB	0101000020E6100000E0B9F770C971D5BFD86322A5D9A64940
81877	KT22 7SQ	GB	0101000020E6100000C8CF46AE9B52D5BFEE42739D46A64940
81878	KT22 7TE	GB	0101000020E6100000C26A2C616D8CD5BFE6B1666490A54940
81879	KT22 8NE	GB	0101000020E6100000485167EE21E1D4BF04E8F7FD9BA54940
81880	KT22 8RB	GB	0101000020E6100000333333333333D5BF802C4487C0A54940
81881	KT22 8RN	GB	0101000020E6100000DE567A6D3656D4BFB0A9F3A8F8A54940
81882	KT22 8SE	GB	0101000020E61000002BF697DD9387D4BF4D124BCADDA54940
81883	KT22 8ST	GB	0101000020E6100000395E81E84999D4BFB2683A3B19A64940
81884	KT22 8SU	GB	0101000020E6100000889FFF1EBC76D4BFAA66D65240A64940
81885	KT22 9EB	GB	0101000020E61000007D0569C6A2E9D5BF7024D06053A54940
81886	KT22 9EN	GB	0101000020E6100000C6C4E6E3DA50D6BFADA7565F5DA54940
81887	KT22 9HN	GB	0101000020E6100000DB32E02C25CBD6BFDAC70A7E1BA44940
81888	KT22 9LJ	GB	0101000020E61000004968CBB91457D6BF7CD6355A0EA64940
81889	KT22 9LP	GB	0101000020E6100000200C3CF71E2ED6BF9981CAF8F7A54940
81890	KT22 9QF	GB	0101000020E6100000764F1E166A4DD7BFE4F90CA837A54940
81891	KT22 9RN	GB	0101000020E61000007D23BA675DA3D6BF5F99B7EA3AA64940
81892	KT23 3AH	GB	0101000020E610000064CDC8207711D8BF2E7590D783A54940
81893	KT23 3AX	GB	0101000020E610000008C72C7B12D8D8BFD1E80E6267A44940
81894	KT23 3HB	GB	0101000020E6100000E014562AA8A8D8BF0C21E7FD7FA44940
81895	KT23 3JG	GB	0101000020E6100000643BDF4F8D97D8BF350A4966F5A44940
81896	KT23 3JU	GB	0101000020E61000009D685721E527D8BFEBABAB02B5A44940
81897	KT23 3NG	GB	0101000020E6100000F12E17F19D98D7BF44F8174163A44940
81898	KT23 3NL	GB	0101000020E61000001E8CD8278062D7BF2C29779FE3A34940
81899	KT23 4AA	GB	0101000020E6100000D87F9D9B36E3D7BF9A07B0C8AFA34940
81900	KT23 4BL	GB	0101000020E610000000750305DEC9D7BF876F61DD78A34940
81901	KT23 4HB	GB	0101000020E6100000F513CE6E2D93D8BF5C8DEC4ACBA24940
81902	KT23 4HR	GB	0101000020E6100000847EA65EB708D9BFD32EA699EEA14940
81903	KT23 4LD	GB	0101000020E61000005A4A969350FAD7BF5F0CE544BBA24940
81904	KT23 4RP	GB	0101000020E6100000FACF9A1F7F69D7BF304B3B3597A34940
81905	KT24 5HX	GB	0101000020E6100000081EDFDE35E8DABF3D62F4DC42A54940
81906	KT24 6HY	GB	0101000020E6100000BB641C23D923DDBFC47AA35698A24940
81907	KT24 6LT	GB	0101000020E6100000828E56B5A4A3DCBF6E4DBA2D91A34940
81908	KT24 6NZ	GB	0101000020E610000034BBEEAD484CDCBFFC6F253B36A44940
81909	KT24 6QX	GB	0101000020E610000034D593F947DFDBBF6500A8E2C6A34940
81910	KT3 3AW	GB	0101000020E6100000917D9065C1C4D0BF9818CBF44BB44940
81911	KT3 3DE	GB	0101000020E61000007CD2890453CDD0BF1E87C1FC15B44940
81912	KT3 3EJ	GB	0101000020E6100000F792C6681D55D1BFD4B9A29410B44940
81913	KT3 3HB	GB	0101000020E610000044C02154A9D9D0BF08E6E8F17BB34940
81914	KT3 3HG	GB	0101000020E6100000629D2ADF3312D0BFAC71361D01B44940
81915	KT3 3HQ	GB	0101000020E6100000BF4351A04FE4D0BF0E2E1D739EB34940
81916	KT3 3HS	GB	0101000020E61000007C8159A148F7D0BFA98427F4FAB34940
81917	KT3 3HT	GB	0101000020E610000069E04735ECF7D0BFA51133FB3CB44940
81918	KT3 3LH	GB	0101000020E6100000944BE3175E49D1BFE0A128D027B44940
81919	KT3 3LS	GB	0101000020E61000006F63B323D577D0BF57B2632310B34940
81920	KT3 3ND	GB	0101000020E6100000FF7A8505F703D1BFE333D93F4FB34940
81921	KT3 3TW	GB	0101000020E61000004563EDEF6C8FD0BFC1FD800706B44940
81922	KT3 3UY	GB	0101000020E61000001B6327BC04A7D0BFCA37DBDC98B44940
81923	KT3 4AX	GB	0101000020E6100000AE9FFEB3E6C7CFBF6B9A779CA2B34940
81924	KT3 4DR	GB	0101000020E6100000CFBA46CB811ED0BFF86D88F19AB34940
81925	KT3 4HN	GB	0101000020E6100000FD4CBD6E1118D0BF2D95B7239CB24940
81926	KT3 4HS	GB	0101000020E61000009641B5C189E8CFBF36E49F19C4B34940
81927	KT3 4JN	GB	0101000020E61000001FBAA0BE654ED0BF8D7C5EF1D4B34940
81928	KT3 4PX	GB	0101000020E6100000273108AC1C5AD0BF1B67D311C0B34940
81929	KT3 5AP	GB	0101000020E61000005969520ABABDD0BF6E895C7006B34940
81930	KT3 5AU	GB	0101000020E61000002C616D8C9DF0D0BFBA11161571B24940
81931	KT3 5BZ	GB	0101000020E61000009DA04D0E9F74D1BFB939950C00B34940
81932	KT3 5DP	GB	0101000020E6100000E96514CB2DADD0BF11C7BAB88DB24940
81933	KT3 5ER	GB	0101000020E61000007E8CB96B09F9D0BF0647C9AB73B24940
81934	KT3 5HF	GB	0101000020E610000012A27C410B09D1BF73BD6DA642B24940
81935	KT3 5JQ	GB	0101000020E61000005BEB8B84B69CD0BF815F234910B24940
81936	KT3 5LN	GB	0101000020E610000076A565A4DE53D0BFCD3D247CEFB14940
81937	KT3 5PD	GB	0101000020E6100000A167B3EA73B5D0BF4CE0D6DD3CB14940
81938	KT3 5RY	GB	0101000020E61000006AF6402B3064D0BF06F2ECF2ADB14940
81939	KT3 6BD	GB	0101000020E61000003412A1116C5CCFBFD6FECEF6E8B14940
81940	KT3 6BT	GB	0101000020E61000001B649291B3B0CFBF575BB1BFECB24940
81941	KT3 6DU	GB	0101000020E6100000371955867137D0BF5DA45016BEB24940
81942	KT3 6JJ	GB	0101000020E6100000FF40B96DDFA3CEBF43723271ABB24940
81943	KT3 6JS	GB	0101000020E6100000C4E8B985AE44CEBFCE50DCF126B34940
81944	KT3 6LB	GB	0101000020E6100000FB761211FE45CEBF310BED9C66B34940
81945	KT3 6LF	GB	0101000020E6100000C172840CE4D9CDBF8AE3C0ABE5B24940
81946	KT3 6PT	GB	0101000020E61000006B813D26529ACFBFAD307DAF21B24940
81947	KT3 6QG	GB	0101000020E610000068AF3E1EFAEECEBFE4A25A4414B34940
81948	KT4	GB	0101000020E6100000E84A04AA7F10CFBFB27F9E060CB04940
81949	KT4 7BG	GB	0101000020E610000004FF5BC98E8DCEBF07B29E5A7DB14940
81950	KT4 7BH	GB	0101000020E6100000EB1C03B2D7BBCFBFE98024ECDBAF4940
81951	KT4 7DZ	GB	0101000020E6100000F373435376FACFBFB262B83A00B04940
81952	KT4 7HB	GB	0101000020E610000077D844662E70CFBF6473D53C47B04940
81953	KT4 7JD	GB	0101000020E610000025ADF886C267D0BFC9E6AA798EB04940
81954	KT4 7JQ	GB	0101000020E61000008E075BECF659D0BF098CF50D4CB04940
81955	KT4 7JR	GB	0101000020E61000001E87C1FC1532D3BF228B34F10EB04940
81956	KT4 7LS	GB	0101000020E61000005645B8C9A832D0BF4E9B711AA2B04940
81957	KT4 7ND	GB	0101000020E6100000EFC682C2A04CCFBF1C23D923D4B04940
81958	KT4 7SE	GB	0101000020E6100000E3DD91B1DAFCCFBFC782C2A04CB14940
81959	KT4 7SJ	GB	0101000020E61000003C2EAA454431CFBFE3FF8EA850B14940
81960	KT4 8FE	GB	0101000020E610000072193735D07CCEBF59DFC0E446B14940
81961	KT4 8JF	GB	0101000020E6100000DB5031CEDF84CEBF47020D3675B04940
81962	KT4 8NQ	GB	0101000020E61000002EC901BB9A3CCBBFA1BAB9F8DBB04940
81963	KT4 8PP	GB	0101000020E6100000FE4465C39ACACCBF9697FC4FFEB04940
81964	KT4 8PU	GB	0101000020E610000053910A630B41CCBFBAF94674CFB04940
81965	KT4 8RR	GB	0101000020E6100000BEF6CC920035CDBFFC19DEACC1AF4940
81966	KT4 8SD	GB	0101000020E61000008C14CAC2D7D7CCBFC652245F09B04940
81967	KT4 8XD	GB	0101000020E610000040A6B5696CAFCDBFD6C6D8092FAF4940
81968	KT4 8YA	GB	0101000020E6100000C02500FF942ACFBF3D7FDAA84EAF4940
81969	KT5	GB	0101000020E6100000A2CF47197101D2BFEA77616BB6B24940
81970	KT5 8HQ	GB	0101000020E6100000718FA50F5D50D2BF499D8026C2B24940
81971	KT5 8HW	GB	0101000020E6100000087250C24CDBD1BF07978E39CFB24940
81972	KT5 8LJ	GB	0101000020E6100000102219726C3DD2BFBA8784EFFDB14940
81973	KT5 8LQ	GB	0101000020E6100000D2A8C0C93670D2BF0952297634B24940
81974	KT5 8LS	GB	0101000020E610000077F35487DC0CD2BF6C3EAE0D15B34940
81975	KT5 8TP	GB	0101000020E6100000527C7C4276DED2BF4CA94BC631B24940
81976	KT5 9AZ	GB	0101000020E61000004A7B832F4CA6D2BFB1DF13EB54B14940
81977	KT5 9HU	GB	0101000020E61000004337FB03E5B6D1BFA5A31CCC26B24940
81978	KT5 9NX	GB	0101000020E61000000F0C207C28D1D1BF5B785E2A36B04940
81979	KT5 9QN	GB	0101000020E61000009EEFA7C64B37D1BF5E2F4D11E0B04940
81980	KT5 9RD	GB	0101000020E6100000B58B69A67B9DD1BFDC4AAFCDC6B04940
81981	KT5 9RH	GB	0101000020E6100000A1116C5CFFAED1BF15562AA8A8B04940
81982	KT6	GB	0101000020E6100000AB5FE97C7896D3BF740B5D8940B14940
81983	KT6 4BX	GB	0101000020E610000058E2016553AED3BFCB4DD4D2DCB24940
81984	KT6 4DE	GB	0101000020E610000079EBFCDB65BFD3BF3317B83CD6B24940
81985	KT6 4DS	GB	0101000020E61000007B9FAA4203B1D3BF7B336ABE4AB24940
81986	KT6 4EB	GB	0101000020E6100000D3156C239EECD3BFCDB051D66FB24940
81987	KT6 4LU	GB	0101000020E610000020B6F468AA27D3BFDB8B683BA6B24940
81988	KT6 4NS	GB	0101000020E6100000286552431B80D3BFE294B9F946B24940
81989	KT6 4PE	GB	0101000020E61000007A8D5DA27A6BD3BF083BC5AA41B24940
81990	KT6 4PS	GB	0101000020E61000009A5C8C81751CD4BFD4450A65E1B14940
81991	KT6 4QH	GB	0101000020E61000005AB91798158AD3BF7E71A94A5BB24940
81992	KT6 4QN	GB	0101000020E61000006BD8EF8975AAD3BF6117450F7CB24940
81993	KT6 4SN	GB	0101000020E6100000419AB1683A3BD3BFC6151747E5B24940
81994	KT6 5DB	GB	0101000020E610000024287E8CB96BD3BF6DE34F5436B04940
81995	KT6 5LQ	GB	0101000020E61000008E06F0164850D3BFEA5C514A08B24940
81996	KT6 5PN	GB	0101000020E61000009C3237DF88EED3BFA86DC32808B24940
81997	KT6 5PW	GB	0101000020E6100000B3EDB4352218D4BF5F0839EFFFB14940
81998	KT6 5QD	GB	0101000020E61000003106D671FC50D4BF700A2B1554B24940
81999	KT6 6AH	GB	0101000020E6100000C6DFF60489EDD2BF92CA147310B24940
82000	KT6 6AZ	GB	0101000020E61000001C7A8B87F71CD6BF8315A75A0BB14940
82001	KT6 6BW	GB	0101000020E6100000A46E675F7990D3BFE8A38CB800B24940
82002	KT6 6DS	GB	0101000020E61000000E4B033FAA61D3BFF0DFBC38F1B14940
82003	KT6 6JR	GB	0101000020E61000005B7A34D593F9D2BF01A4367172B14940
82004	KT6 6RL	GB	0101000020E6100000C26D6DE179A9D3BFF2D077B7B2B04940
82005	KT6 6SE	GB	0101000020E6100000A67D737FF5B8D3BFD26F5F07CEB14940
82006	KT6 7AX	GB	0101000020E6100000AC38D55A9885D2BFB41EBE4C14B14940
82007	KT6 7JY	GB	0101000020E610000080F0A1444B1ED2BF1DAA29C93AB04940
82008	KT6 7LF	GB	0101000020E61000000D5531957EC2D2BF1D75745C8DB04940
82009	KT6 7RQ	GB	0101000020E61000007E52EDD3F198D2BFCC07043A93B04940
82010	KT6 7RU	GB	0101000020E61000003A950C0055DCD2BF63601DC70FB14940
82011	KT6 7RX	GB	0101000020E61000007E5704FF5BC9D2BF5A9F724C16B14940
82012	KT6 7RZ	GB	0101000020E6100000A6D590B8C7D2D2BFDD7D8E8F16B14940
82013	KT7	GB	0101000020E6100000B169A510C825D5BF68EC4B361EB24940
82014	KT7 0AB	GB	0101000020E61000006A334E4354E1D4BF52B5DD04DFB04940
82015	KT7 0BH	GB	0101000020E610000098BED7101C97D4BF18EDF1423AB04940
82016	KT7 0DX	GB	0101000020E610000006D9B27C5D86D5BF63EE5A423EB24940
82017	KT7 0NE	GB	0101000020E61000005C8FC2F5285CD5BF94A3005130B14940
82018	KT7 0NR	GB	0101000020E6100000F5143944DC9CD5BF1805C1E3DBB14940
82019	KT7 0NU	GB	0101000020E610000009185DDE1CAED5BF1B84B9DDCBB14940
82020	KT7 0QS	GB	0101000020E6100000FE0B04013274D5BF3849F3C7B4B24940
82021	KT7 5QG	GB	0101000020E6100000BD1B0B0A8332D3BFE486DF4DB7B64940
82022	KT8	GB	0101000020E6100000BF0D315EF3AAD6BF2F34D769A4B34940
82023	KT8 0BP	GB	0101000020E6100000787C7BD7A02FD6BF37A8FDD64EB24940
82024	KT8 1PQ	GB	0101000020E6100000117349D57613D7BF5CE7DF2EFBB34940
82025	KT8 1TG	GB	0101000020E610000027BC04A73E90D7BF37A8FDD64EB44940
82026	KT8 2LX	GB	0101000020E61000005DF8C1F9D4B1D7BF062E8F3523B34940
82027	KT8 9AE	GB	0101000020E6100000677E350708E6D5BF35B742588DB34940
82028	KT8 9AU	GB	0101000020E6100000CAE1934E2498D5BF76FD82DDB0B34940
82029	KT8 9BN	GB	0101000020E61000002A00C63368E8D5BF01DD9733DBB34940
82030	KT8 9BW	GB	0101000020E6100000CCD0782288F3D5BF8BFD65F7E4B34940
82031	KT8 9DE	GB	0101000020E61000000E6954E0641BD7BFEACC3D247CB34940
82032	KT8 9HL	GB	0101000020E61000003735D07CCEDDD6BF6DE7FBA9F1B24940
82033	KT8 9JP	GB	0101000020E610000043AD69DE718AD6BFCB2E185C73B34940
82034	KT9	GB	0101000020E6100000DFDE35E84B6FD3BF863C821B29AF4940
82035	KT9 1ED	GB	0101000020E61000000805A568E55ED3BF52103CBEBDAF4940
82036	KT9 1EQ	GB	0101000020E6100000F6ECB94C4D82D3BFFEB627486CAF4940
82037	KT9 1HH	GB	0101000020E6100000938FDD054A0AD3BF14252191B6AF4940
82038	KT9 1JJ	GB	0101000020E6100000750470B378B1D2BF0E30F31DFCAE4940
82039	KT9 2AZ	GB	0101000020E6100000ECA012D731AED2BFA8C30AB77CAE4940
82040	KT9 2BU	GB	0101000020E6100000A647533D997FD2BFEFC8586DFEAD4940
82041	KT9 2EG	GB	0101000020E61000001F2C634337FBD2BF17467A51BBAD4940
82042	KT9 2GY	GB	0101000020E6100000AB2006BAF605D4BF5B28999CDAAD4940
82043	KT9 2JB	GB	0101000020E6100000C72B103D2993D3BF1B0E4B033FAE4940
82044	KT9 2JE	GB	0101000020E6100000D20149D8B793D3BF1FD8F15F20AE4940
82045	KT9 2JR	GB	0101000020E61000009FB0C403CAA6D3BF0135B56CADAD4940
82046	KT9 2RT	GB	0101000020E6100000CEE2C5C21039D3BF2AA8A8FA95AE4940
82047	KW1	GB	0101000020E61000006518778368AD08C063601DC70F394D40
82048	KW1 4DA	GB	0101000020E61000004089CF9D60BF08C08CBFED0912394D40
82049	KW1 4HS	GB	0101000020E610000031EF71A609BB08C0EC2E505260394D40
82050	KW1 4NY	GB	0101000020E610000006A051BAF4AF08C06F2BBD361B394D40
82051	KW1 4YH	GB	0101000020E6100000A6EECA2E18FC08C02D431CEBE2504D40
82052	KW1 4YR	GB	0101000020E6100000DFDE35E84B8F08C07EA7C98CB7514D40
82053	KW1 5LB	GB	0101000020E610000076F9D687F5C608C0D44334BA83384D40
82054	KW10 6	GB	0101000020E610000006F6984869D60FC053EA92718CFC4C40
82055	KW10 6SF	GB	0101000020E61000006C2409C215900FC01D5BCF108EFD4C40
82056	KW10 6SZ	GB	0101000020E6100000056F48A302E70FC0081EDFDE35FC4C40
82057	KW11 6UB	GB	0101000020E61000005FF0694E5E840FC087FBC8AD49214D40
82058	KW11 6UF	GB	0101000020E6100000A96C5853595410C0F0F96184F0284D40
82059	KW12 6UR	GB	0101000020E6100000997FF44D9AA60DC05F09A4C4AE314D40
82060	KW12 6XA	GB	0101000020E6100000DC645419C69D0BC0B6847CD0B3414D40
82061	KW12 6XJ	GB	0101000020E6100000B3075A81216B0CC0707A17EFC73D4D40
82062	KW12 6YN	GB	0101000020E6100000EA25C632FDF20BC092E7FA3E1C424D40
82063	KW13 6YT	GB	0101000020E61000005340DAFF002B0FC07B8670CCB22D4D40
82064	KW14 7BQ	GB	0101000020E6100000129F3BC1FE2B0CC0A3EA573A1F4C4D40
82065	KW14 7DL	GB	0101000020E61000003DD68C0C72370CC06F8104C58F4B4D40
82066	KW14 7LZ	GB	0101000020E61000000FD4298F6E440CC07E552E54FE4B4D40
82067	KW14 7RG	GB	0101000020E6100000ADBEBA2A504B0EC0DEE34C13B6474D40
82068	KW14 7RY	GB	0101000020E610000082E673EE760D10C0CD77F01307484D40
82069	KW14 7SP	GB	0101000020E61000009CDF30D120E510C04277499C15434D40
82070	KW14 7TJ	GB	0101000020E6100000F3716DA8185711C0583A1F9E25444D40
82071	KW14 7YJ	GB	0101000020E6100000C2FA3F87F9720FC0378DEDB5A0474D40
82072	KW14 8HN	GB	0101000020E61000002EAD86C43D160CC04DBF44BC754C4D40
82073	KW14 8XD	GB	0101000020E610000010E84CDA54BD0AC03D27BD6F7C4F4D40
82074	KW14 8XT	GB	0101000020E61000006C43C5387FF30AC0A8ACA6EB89504D40
82075	KW14 8YE	GB	0101000020E6100000841266DAFEB50AC0560C570740524D40
82076	KW14 8YN	GB	0101000020E61000001C0A9FAD83C30BC0F19BC24A054B4D40
82077	KW15 1AZ	GB	0101000020E6100000E6AE25E483BE07C06536C824237D4D40
82078	KW15 1LF	GB	0101000020E610000073B8567BD8AB07C08318E8DA177E4D40
82079	KW15 1QX	GB	0101000020E610000051888043A8B207C0C7BAB88D067E4D40
82080	KW16 3	GB	0101000020E6100000D5CA845FEA670AC045813E91277B4D40
82081	KW16 3EB	GB	0101000020E6100000A4A7C821E2660AC03604C765DC7A4D40
82082	KW16 3HA	GB	0101000020E6100000BF6378EC67D109C041EF8D21007C4D40
82083	KW17 2	GB	0101000020E610000079793A57941208C0B2135E8253774D40
82084	KW17 2AB	GB	0101000020E6100000C7D45DD9052306C08A0453CDAC974D40
82085	KW17 2AR	GB	0101000020E6100000E92CB308C5D604C0B3D1393FC5914D40
82086	KW17 2BZ	GB	0101000020E6100000D508FD4CBDEE07C0F0DDE68D93A84D40
82087	KW17 2DX	GB	0101000020E6100000FC170802644807C087C43D963E844D40
82088	KW17 2PS	GB	0101000020E61000005E9F39EB536E08C06901DA56B3964D40
82089	KW17 2QS	GB	0101000020E6100000FA60191BBAB906C0B34291EEE77A4D40
82090	KW17 2RF	GB	0101000020E61000002EAC1BEF8E2C09C0732B84D558764D40
82091	KW17 2SB	GB	0101000020E610000056D3F544D70507C00F80B8AB57734D40
82092	KW17 2SP	GB	0101000020E6100000AAD216D7F8AC07C018D2E1218C694D40
82093	KW17 2SR	GB	0101000020E6100000CD02ED0E29A607C0079B3A8F8A694D40
82094	KW17 2SS	GB	0101000020E610000077A04E79746307C0B742588D256C4D40
82095	KW2 6AB	GB	0101000020E61000002CF015DD7A4D09C0DF1B4300702C4D40
82096	KW3 6	GB	0101000020E610000051A5660FB4420AC050FBAD9D28274D40
82097	KW5 6	GB	0101000020E610000063B5F97FD5F10AC0A46FD23428244D40
82098	KW5 6DX	GB	0101000020E6100000CA332F87DD970AC0A723809BC5294D40
82099	KW6 6	GB	0101000020E6100000630D17B9A76B0BC0EF2076A6D01F4D40
82100	KW7 6HD	GB	0101000020E6100000BAF59A1E14340CC06B7EFCA545174D40
82101	KW8 6	GB	0101000020E61000002786E464E2360DC078616BB6F20E4D40
82102	KW8 6JR	GB	0101000020E610000013D38558FD310DC0AC915D69190F4D40
82103	KW9 6	GB	0101000020E61000002D5A80B6D5CC0EC0ED629AE95E014D40
82104	KW9 6LB	GB	0101000020E61000007099D36531F10EC0622CD32F11034D40
82105	KW9 6NX	GB	0101000020E6100000CC7EDDE9CED30EC0D5230D6E6B014D40
82106	KY1	GB	0101000020E61000001E335019FF7E09C0C100C287121B4C40
82107	KY1 1YL	GB	0101000020E6100000469737876B5509C06649809A5A0E4C40
82108	KY1 2DY	GB	0101000020E6100000C39FE1CD1A3C09C0B9162D40DB0E4C40
82109	KY1 3PG	GB	0101000020E61000002312859675FF08C03A2009FB76104C40
82110	KY1 4AF	GB	0101000020E6100000AEBA0ED5942409C0B308C556D0144C40
82111	KY1 4NQ	GB	0101000020E6100000958098840BB908C063F19BC24A134C40
82112	KY1 4RA	GB	0101000020E6100000B6DB2E34D78908C08F334DD87E144C40
82113	KY1 4SP	GB	0101000020E610000026A77686A9AD08C050560C5707124C40
82114	KY10 2RF	GB	0101000020E610000072FDBB3E733606C0ABEB504D491E4C40
82115	KY10 3AR	GB	0101000020E6100000ADA3AA09A28E05C0FAD2DB9F8B1C4C40
82116	KY10 3EA	GB	0101000020E61000008272DBBE47DD05C039984D80611B4C40
82117	KY10 3TR	GB	0101000020E6100000503750E09DFC04C0014EEFE2FD204C40
82118	KY10 3TY	GB	0101000020E6100000A9F6E978CC0005C07E6E68CA4E214C40
82119	KY10 3XN	GB	0101000020E61000007171546EA2B604C03CDC0E0D8B234C40
82120	KY11	GB	0101000020E61000000266BE839F780BC08D25AC8DB1074C40
82121	KY11 1JE	GB	0101000020E6100000CFA3E2FF8E280BC09C35785F95014C40
82122	KY11 1LN	GB	0101000020E610000081785DBF60370BC0B5F97FD591034C40
82123	KY11 1NJ	GB	0101000020E6100000C422861DC6240BC065E1EB6B5D044C40
82124	KY11 1PX	GB	0101000020E610000057B5A4A31C2C0BC0E22021CA17044C40
82125	KY11 2DQ	GB	0101000020E6100000B0E8D66B7A700BC0F357C85C19044C40
82126	KY11 2JF	GB	0101000020E61000001B8524B37A670BC08E93C2BCC7054C40
82127	KY11 2NY	GB	0101000020E61000004AB6BA9C12500BC0E02F664B56054C40
82128	KY11 2QQ	GB	0101000020E61000001E537765174C0BC08E40BCAE5F044C40
82129	KY11 2QT	GB	0101000020E610000006D671FC50690BC0E754320054054C40
82130	KY11 3AA	GB	0101000020E6100000C636A968AC9D0BC079CC4065FC074C40
82131	KY11 3BD	GB	0101000020E610000075029A081B9E0BC076543541D4074C40
82132	KY11 4RB	GB	0101000020E6100000EB56CF49EF7B0BC091EEE714E4074C40
82133	KY11 4TG	GB	0101000020E61000000B462575029A0BC047020D3675084C40
82134	KY11 7EY	GB	0101000020E6100000D52137C30DF80AC0BC033C69E1064C40
82135	KY11 8	GB	0101000020E61000006022DE3AFF560BC0F2D1E28C61064C40
82136	KY11 8DZ	GB	0101000020E6100000371AC05B20410BC0CE716E13EE094C40
82137	KY11 8GA	GB	0101000020E61000008F386403E9420BC003ED0E2906084C40
82138	KY11 8GG	GB	0101000020E6100000A7EB89AE0B5F0BC08C648F5033064C40
82139	KY11 8HS	GB	0101000020E610000033A5F5B704400BC0315D88D51F074C40
82140	KY11 8TD	GB	0101000020E61000008AE42B8194580BC0384A5E9D63064C40
82141	KY11 9HW	GB	0101000020E6100000DAE4F04927D20AC0452C62D861064C40
82142	KY11 9NQ	GB	0101000020E6100000786000E143C90AC08A8EE4F21F044C40
82143	KY11 9UN	GB	0101000020E610000055BFD2F9F0AC0AC0535E2BA1BB044C40
82144	KY11 9YG	GB	0101000020E6100000607825C973BD0AC09E7E501729044C40
82145	KY12	GB	0101000020E610000055D97745F01F0AC0A704C4245C164C40
82146	KY12 0RY	GB	0101000020E6100000AAF3A8F8BF630BC044334FAE290A4C40
82147	KY12 7HT	GB	0101000020E61000004BAB21718FA50BC0F2ECF2AD0F094C40
82148	KY12 7RS	GB	0101000020E61000008CBCAC89059E0BC0FC1A498270094C40
82149	KY12 7RT	GB	0101000020E610000054556820966D0BC0F25EB532E1094C40
82150	KY12 7SX	GB	0101000020E6100000C9772975C9780BC0B3976DA7AD094C40
82151	KY12 8FG	GB	0101000020E61000005E85949F543B0CC0CD3E8F519E074C40
82152	KY12 8JH	GB	0101000020E61000009E094D124B0A0DC03E3E213B6F074C40
82153	KY12 8RL	GB	0101000020E61000007767EDB60B4D0CC0AFB0E07EC0074C40
82154	KY12 8UU	GB	0101000020E61000006EA12B11A85E0CC0664B5645B8074C40
82155	KY12 9NU	GB	0101000020E6100000D6C9198A3BFE0BC0FAB5F5D37F0A4C40
82156	KY12 9NW	GB	0101000020E610000047E7FC14C7810CC07364E597C10A4C40
82157	KY12 9QH	GB	0101000020E6100000D388997D1E830BC0AA44D95BCA094C40
82158	KY13	GB	0101000020E61000003012DA722E850BC0CB9E0436E71A4C40
82159	KY13 0QG	GB	0101000020E6100000593332C85DA40CC05BE9B5D958154C40
82160	KY13 0QW	GB	0101000020E6100000EA3D95D39ED20BC052D50451F7174C40
82161	KY13 8FD	GB	0101000020E6100000C40B2252D36E0BC0213D450E111B4C40
82162	KY13 9YG	GB	0101000020E6100000F5F57CCD72590BC02DCDAD10561D4C40
82163	KY13 9YH	GB	0101000020E610000078CF81E508590BC090149161151D4C40
82164	KY14	GB	0101000020E6100000BABF7ADCB7DA09C0B6BFB33D7A254C40
82165	KY14 6AH	GB	0101000020E6100000D0B4C4CA68E409C00B43E4F4F52C4C40
82166	KY14 7AL	GB	0101000020E610000045F30016F9D509C0D4298F6E84254C40
82167	KY14 7AX	GB	0101000020E6100000E8FA3E1C24E409C083DA6FED44254C40
82168	KY14 7FB	GB	0101000020E6100000F0879FFF1EDC09C0AFB2B6291E254C40
82169	KY14 7PR	GB	0101000020E6100000B2B96A9E23320AC0755B22179C234C40
82170	KY14 7QB	GB	0101000020E610000064C91CCBBB2A0AC09240834D9D234C40
82171	KY14 7SZ	GB	0101000020E61000001AC05B2041910AC01C9947FE60224C40
82172	KY15	GB	0101000020E610000022C154336B2908C04D9F1D705D254C40
82173	KY15 4HY	GB	0101000020E610000011E0F42EDE2F08C04337FB03E5284C40
82174	KY15 4QD	GB	0101000020E6100000C00303081F2A08C05111A7936C2D4C40
82175	KY15 5HX	GB	0101000020E61000008066101FD81108C0309FAC18AE284C40
82176	KY15 5PB	GB	0101000020E610000009336DFFCA0A08C0B9C2BB5CC4254C40
82177	KY15 5QY	GB	0101000020E61000005E2EE23B316B08C0DD06B5DFDA254C40
82178	KY15 5RF	GB	0101000020E6100000F8C5A52A6DD108C03524EEB1F4254C40
82179	KY15 7BU	GB	0101000020E610000054E4107173AA09C0A7C98CB795204C40
82180	KY15 7JS	GB	0101000020E6100000889CBE9EAFF908C049A297512C234C40
82181	KY15 7PY	GB	0101000020E610000073D87DC7F0F808C007EC6AF294214C40
82182	KY15 7RJ	GB	0101000020E610000064045438821409C06C239EEC66284C40
82183	KY16 0AA	GB	0101000020E6100000A2EBC20FCE2707C09296CADB11304C40
82184	KY16 8BX	GB	0101000020E61000001EDD088B8A5806C0EFCB99ED0A2B4C40
82185	KY16 8DE	GB	0101000020E610000026E318C91E2105C06005F86EF3264C40
82186	KY16 8EA	GB	0101000020E6100000952C27A1F46506C02AAA7EA5F3294C40
82187	KY16 8HA	GB	0101000020E610000087DD770C8F5D06C07B2DE8BD312A4C40
82188	KY16 8QD	GB	0101000020E6100000A54BFF92542605C0419FC893A4254C40
82189	KY16 8SR	GB	0101000020E610000097ADF545423B05C0B3B112F3AC264C40
82190	KY16 9AG	GB	0101000020E6100000C80BE9F0106606C0FAB7CB7EDD2B4C40
82191	KY16 9AJ	GB	0101000020E6100000543541D47D6006C0D3F4D901D72B4C40
82192	KY16 9DA	GB	0101000020E610000004ADC090D56D06C0BEF561BD512B4C40
82193	KY16 9TJ	GB	0101000020E6100000D960E124CD5F06C0F487669E5C2B4C40
82194	KY16 9UE	GB	0101000020E6100000E124CD1FD39A06C05F79909E222B4C40
82195	KY16 9UG	GB	0101000020E61000000F289B72855706C05C751DAA292B4C40
82196	KY2	GB	0101000020E6100000EB8B84B69C8B09C0AE450BD0B60E4C40
82197	KY2 5	GB	0101000020E61000006E1805C1E35B09C057790261A70E4C40
82198	KY2 5LN	GB	0101000020E610000033DFC14F1C4009C03E3C4B9011104C40
82199	KY2 6NL	GB	0101000020E61000005C7171546E8209C0A73FFB9122104C40
82200	KY2 6RY	GB	0101000020E61000006F0F4240BE6409C080D767CEFA0E4C40
82201	KY2 6RZ	GB	0101000020E6100000E7E44526E05709C0043C69E1B2104C40
82202	KY2 6SP	GB	0101000020E6100000AA4885B1856009C05F79909E22114C40
82203	KY3 0SN	GB	0101000020E610000082E7DEC325670AC02C7DE882FA064C40
82204	KY3 9DR	GB	0101000020E610000071AFCC5B75DD09C0BAA0BE654E074C40
82205	KY3 9ES	GB	0101000020E61000002ECBD765F8CF09C0DF8AC40435084C40
82206	KY3 9RA	GB	0101000020E610000042EDB776A26409C00E881057CE084C40
82207	KY4	GB	0101000020E61000002D41464085C30AC0DE3EABCC940E4C40
82208	KY4 0JF	GB	0101000020E6100000639B5434D63E0BC0FF959526A5124C40
82209	KY4 8AP	GB	0101000020E61000009EB5DB2E34770AC05587DC0C37104C40
82210	KY4 8DP	GB	0101000020E61000001C3F541A31F30AC0DBDC989EB00C4C40
82211	KY4 8ED	GB	0101000020E6100000C80A7E1B62DC0AC0EC87D860E10C4C40
82212	KY4 9DS	GB	0101000020E6100000340F60915F9F0AC03F1C2444F90E4C40
82213	KY4 9JG	GB	0101000020E610000024473A0323CF0AC0904FC8CEDB0E4C40
82214	KY4 9SG	GB	0101000020E6100000FDDCD0949DBE0AC0166EF9484A0E4C40
82215	KY5 0BN	GB	0101000020E6100000DC7F643A741A0AC03AEB538EC9124C40
82216	KY5 0BP	GB	0101000020E6100000EEAF1EF7AD160AC001BF469220124C40
82217	KY5 8AP	GB	0101000020E61000003C32569BFF970AC0983270404B134C40
82218	KY5 8LZ	GB	0101000020E61000005AF624B039870AC0221807978E114C40
82219	KY5 8PT	GB	0101000020E6100000ED2C7AA702AE0AC0E57FF277EF144C40
82220	KY5 9EL	GB	0101000020E61000000C1EA67D737F0AC059FCA6B052114C40
82221	KY6 1LU	GB	0101000020E6100000F04DD367079C09C0711FB935E9184C40
82222	KY6 1PA	GB	0101000020E61000005E471CB2819409C0B3F0F5B52E194C40
82223	KY6 2SH	GB	0101000020E61000005E2EE23B314B09C0CFA10C5531174C40
82224	KY6 3AZ	GB	0101000020E61000002D05A4FD0FB009C056BC9179E4194C40
82225	KY6 3EN	GB	0101000020E6100000FA997ADD22B009C07E6FD39FFD184C40
82226	KY7	GB	0101000020E6100000FEB7921D1B4109C0126745D444194C40
82227	KY7 4NS	GB	0101000020E6100000473A03232F2B09C0C460FE0A99174C40
82228	KY7 5NR	GB	0101000020E610000045D4449F8F5209C00C23BDA8DD194C40
82229	KY7 6AQ	GB	0101000020E6100000B8205B96AF0B09C08CA03193A8194C40
82230	KY7 6ET	GB	0101000020E6100000EED0B018754D09C0823B50A73C1A4C40
82231	KY7 6FP	GB	0101000020E61000009D82FC6CE47A09C01EE0490B971B4C40
82232	KY7 6LA	GB	0101000020E61000003CF6B3588AE408C0F645425BCE1B4C40
82233	KY8	GB	0101000020E6100000D8BCAAB35A8008C05131CEDF84144C40
82234	KY8 1HT	GB	0101000020E610000042B5C189E83708C0E15F048D99164C40
82235	KY8 2EQ	GB	0101000020E6100000EB353D28284508C0E2C96E66F4174C40
82236	KY8 3EQ	GB	0101000020E61000005E471CB2811408C00D1D3BA8C4174C40
82237	KY8 3PE	GB	0101000020E610000097900F7A362B08C0807F4A9528174C40
82238	KY8 4EU	GB	0101000020E6100000594E42E90B0108C0D87F9D9B36194C40
82239	KY8 5NX	GB	0101000020E6100000DBC01DA853FE07C03B00E2AE5E1F4C40
82240	KY9 1BZ	GB	0101000020E61000000DA837A3E68B06C078978BF84E184C40
82241	L05	GB	0101000020E6100000425A63D009E107C0DC4AAFCDC6B44A40
82242	L1	GB	0101000020E6100000C37E4FAC53C507C08BC56F0A2BB54A40
82243	L1 0BG	GB	0101000020E6100000F65CA626C1DB07C0DF6C73637AB24A40
82244	L1 1JD	GB	0101000020E6100000A5F78DAF3DD307C04F90D8EE1EB44A40
82245	L1 1JT	GB	0101000020E6100000F279C5538FD407C04D6A6803B0B34A40
82246	L1 2	GB	0101000020E61000005B96AFCBF0BF07C01C5C3AE63CB34A40
82247	L1 2SX	GB	0101000020E61000002922C32ADEC807C0327381CB63B34A40
82248	L1 4LN	GB	0101000020E6100000D1950854FFE007C010E84CDA54B34A40
82249	L1 7BY	GB	0101000020E6100000EB025E66D8C807C0E605D847A7B24A40
82250	L1 9AR	GB	0101000020E610000057CD7344BECB07C0A9DE1AD82AB34A40
82251	L1 9HF	GB	0101000020E6100000B6F63E5585C607C061A7583508B34A40
82252	L10 1LP	GB	0101000020E6100000F01989D0085607C0C078060DFDBB4A40
82253	L10 2JW	GB	0101000020E610000088855AD3BC8307C01D7233DC80BD4A40
82254	L10 6NG	GB	0101000020E610000048DDCEBEF28007C0E6CFB7054BBD4A40
82255	L10 7NG	GB	0101000020E61000003718EAB0C26D07C0CA8CB7955EBB4A40
82256	L10 7NP	GB	0101000020E61000005EF6EB4E775E07C0986C3CD862BB4A40
82257	L11 1BJ	GB	0101000020E61000007FA65EB7086C07C0487023658BB84A40
82258	L11 1DF	GB	0101000020E6100000E63C635FB25107C0BDC799266CB94A40
82259	L11 2SQ	GB	0101000020E61000001AA20A7F865707C0F98381E7DEB94A40
82260	L11 2YA	GB	0101000020E61000009A25016A6A5907C035ED629AE9B84A40
82261	L11 6NA	GB	0101000020E6100000E3546B61163A07C053AEF02E17BB4A40
82262	L11 8LR	GB	0101000020E6100000F910548D5E6D07C078EFA83121B84A40
82263	L12	GB	0101000020E6100000EF1B5F7B662907C07F30F0DC7BB64A40
82264	L12 0BE	GB	0101000020E610000006F2ECF2AD0F07C078B6476FB8B94A40
82265	L12 0LJ	GB	0101000020E610000012BEF737686F07C02409C21550B84A40
82266	L12 0SA	GB	0101000020E61000002096CD1C92FA06C062BD512B4CB94A40
82267	L12 2AN	GB	0101000020E6100000B47570B0373107C0800EF3E505B64A40
82268	L12 7HF	GB	0101000020E6100000560F98874C5907C0ABAE433525B74A40
82269	L12 9EH	GB	0101000020E6100000D6AC33BE2F2E07C0FB0626378AB64A40
82270	L12 9LZ	GB	0101000020E6100000CF81E508192807C0A8716F7EC3B64A40
82271	L13 1DF	GB	0101000020E6100000B03A72A4337007C0AC02B5183CB44A40
82272	L13 1ED	GB	0101000020E61000006D3656629E5507C00F9A5DF756B44A40
82273	L13 1HD	GB	0101000020E6100000F78E1A13624E07C01135D1E7A3B24A40
82274	L13 3AE	GB	0101000020E61000007B30293E3E6107C0BB7D569929B54A40
82275	L13 4AF	GB	0101000020E6100000DA1A118C83CB07C07B4963B48EB44A40
82276	L13 5SP	GB	0101000020E6100000F7E6374C344807C0E50B5A48C0B44A40
82277	L13 5SX	GB	0101000020E6100000FB57569A944207C0C2C073EFE1B44A40
82278	L13 5UP	GB	0101000020E610000071CADC7C233A07C06EBE11DDB3B44A40
82279	L13 5YB	GB	0101000020E6100000AF7B2B12137407C0FF4124438EB74A40
82280	L13 5YE	GB	0101000020E61000009622F94A204507C067D2A6EA1EB54A40
82281	L13 6QP	GB	0101000020E610000056B950F9D75207C06CB1DB6795B54A40
82282	L13 6SF	GB	0101000020E6100000865451BCCA5A07C0C7D8092FC1B54A40
82283	L13 7HB	GB	0101000020E6100000B537F8C2648A07C0C3D8429083B64A40
82284	L13 8BR	GB	0101000020E6100000E54691B5867207C069E4F38AA7B64A40
82285	L14 0JF	GB	0101000020E61000004F745DF8C11907C09C3061342BB54A40
82286	L14 0NU	GB	0101000020E61000000F290648340107C064CDC82077B54A40
82287	L14 1QL	GB	0101000020E61000007C45B75ED32307C0D17AF83251B44A40
82288	L14 3LW	GB	0101000020E6100000B58D3F51D93007C02D5C566133B44A40
82289	L14 3NG	GB	0101000020E6100000FC1A4982702507C097E5EB32FCB34A40
82290	L14 3NR	GB	0101000020E6100000EF8FF7AA950907C0FE463B6EF8B34A40
82291	L14 5NX	GB	0101000020E61000002D077AA86D2307C0E5EC9DD156B54A40
82292	L14 6TH	GB	0101000020E61000004AD40B3ECD2907C0643C4A253CB54A40
82293	L14 7PQ	GB	0101000020E610000027BC04A73E9007C0656EBE11DDB54A40
82294	L15	GB	0101000020E6100000F6984869366F07C0522CB7B41AB24A40
82295	L15 0ED	GB	0101000020E6100000E55E6056287207C0946A9F8EC7B24A40
82296	L15 0HR	GB	0101000020E6100000E945ED7E158007C02FC1A90F24B34A40
82297	L15 0HW	GB	0101000020E61000002843554CA57F07C062BD512B4CB34A40
82298	L15 2HT	GB	0101000020E6100000C1AC50A4FB7907C02D95B7239CB24A40
82299	L15 4LD	GB	0101000020E610000076FBAC32537A07C0A1F2AFE595B34A40
82300	L15 5BU	GB	0101000020E6100000200A664CC15A07C0B404190115B24A40
82301	L15 5EE	GB	0101000020E61000003FADA23F345307C010CEA78E55B24A40
82302	L15 6XE	GB	0101000020E610000078D32D3BC4FF06C01118EB1B98B24A40
82303	L15 6XN	GB	0101000020E61000007B884677103B07C05055A18158B24A40
82304	L15 8GE	GB	0101000020E6100000591822A7AF4707C0ED0BE8853BB34A40
82305	L15 8HH	GB	0101000020E6100000043A9336555707C05E2F4D11E0B24A40
82306	L15 9HD	GB	0101000020E6100000C504357C0B4B07C04B92E7FA3EB24A40
82307	L15 9HP	GB	0101000020E6100000B9A981E6734E07C08A8EE4F21FB24A40
82308	L16 0JR	GB	0101000020E6100000CE1C925A281907C0013274ECA0B24A40
82309	L16 2LY	GB	0101000020E610000094D920938CFC06C03B1BF2CF0CB44A40
82310	L16 2NG	GB	0101000020E61000007C8159A148F706C05395B6B8C6B34A40
82311	L16 2NH	GB	0101000020E6100000AAEE91CD55F306C05531957EC2B34A40
82312	L16 3NG	GB	0101000020E6100000C1711937351007C046ED7E15E0B34A40
82313	L16 4PE	GB	0101000020E610000033349E08E21C07C07FBDC282FBB14A40
82314	L16 5EW	GB	0101000020E61000008483BD89211907C0810A47904AB34A40
82315	L16 7PU	GB	0101000020E6100000791EDC9DB51B07C0A33F34F3E4B24A40
82316	L16 7QR	GB	0101000020E6100000F513CE6E2D3307C05089EB1857B24A40
82317	L16 8NU	GB	0101000020E610000069C36169E02707C02A91442FA3B44A40
82318	L16 9JE	GB	0101000020E6100000029B73F04C0807C093718C648FB44A40
82319	L17	GB	0101000020E6100000A9A0A2EA577A07C024D3A1D3F3AE4A40
82320	L17 0AL	GB	0101000020E6100000B130444E5F6F07C08E76DCF0BBAF4A40
82321	L17 0EE	GB	0101000020E6100000B3075A81216B07C0B1A888D349B04A40
82322	L17 3AX	GB	0101000020E61000003DD175E1078707C0C9CB9A58E0B14A40
82323	L17 3AY	GB	0101000020E6100000BB0F406A138707C05FD4EE5701B24A40
82324	L17 3BE	GB	0101000020E610000014967840D99407C0BC1FB75F3EB14A40
82325	L17 3TX	GB	0101000020E61000002AADBF25009F07C0282B86AB03B04A40
82326	L17 4JL	GB	0101000020E6100000D3A3A99ECC7F07C090A1630795B04A40
82327	L17 6AG	GB	0101000020E6100000A29927D7146807C017D522A298AE4A40
82328	L17 7AD	GB	0101000020E6100000A33EC91D367107C08333F8FBC5B04A40
82329	L17 7AR	GB	0101000020E6100000D3872EA86F9907C09E094D124BB04A40
82330	L17 7BJ	GB	0101000020E61000006C257497C49907C0AA2D7590D7AF4A40
82331	L17 8TN	GB	0101000020E6100000C7F143A5119307C00C022B8716B14A40
82332	L17 8XD	GB	0101000020E6100000A185048C2E8F07C0BEA085048CB04A40
82333	L17 9	GB	0101000020E61000006D382C0DFC8807C02E3A596ABDAF4A40
82334	L17 9PE	GB	0101000020E6100000DDB243FCC39607C0F5BEF1B567B04A40
82335	L17 9QJ	GB	0101000020E610000069368FC3609E07C027F6D03E56B04A40
82336	L18	GB	0101000020E6100000A703594FAD1E07C04BB0389CF9AF4A40
82337	L18 1DH	GB	0101000020E6100000F1F44A59865807C0884CF91054B14A40
82338	L18 1EZ	GB	0101000020E6100000E0A293A5D65B07C0815A0C1EA6B14A40
82339	L18 1JX	GB	0101000020E6100000952710768A5507C0E6B2D1393FB14A40
82340	L18 1LD	GB	0101000020E61000003CD862B7CF4A07C0699082A790B14A40
82341	L18 3EU	GB	0101000020E6100000AFB48CD47B2A07C0E4A1EF6E65B14A40
82342	L18 3NU	GB	0101000020E6100000D87E32C6871907C0BEF90D130DB04A40
82343	L18 4PG	GB	0101000020E6100000ED116A86545107C0ED4ACB48BDAF4A40
82344	L18 4PS	GB	0101000020E6100000F183F3A9635507C02995F0845EAF4A40
82345	L18 4QX	GB	0101000020E6100000BCCE86FC334307C04A09C1AA7AAF4A40
82346	L18 5	GB	0101000020E6100000E8DCED7A694A07C0E527D53E1DB14A40
82347	L18 6HF	GB	0101000020E610000072874D64E64207C0BA10AB3FC2B04A40
82348	L18 6HH	GB	0101000020E6100000ABCDFFAB8E3C07C00856D5CBEFB04A40
82349	L18 6JA	GB	0101000020E610000025E659492B3E07C0B1DF13EB54B14A40
82350	L18 7JD	GB	0101000020E6100000BD8BF7E3F64B07C0AF3F89CF9DB04A40
82351	L18 7JN	GB	0101000020E6100000037CB779E34407C01E87C1FC15B04A40
82352	L18 7JT	GB	0101000020E61000006EFAB31F294207C079E9263108B04A40
82353	L18 7JY	GB	0101000020E610000007EDD5C7433F07C032E5435035B04A40
82354	L18 8AJ	GB	0101000020E6100000478D0931975407C007EFAB72A1B04A40
82355	L18 8BG	GB	0101000020E6100000BE2EC37FBA6107C0E7FEEA71DFB04A40
82356	L18 9UD	GB	0101000020E610000080D8D2A3A93E07C04485EAE6E2AF4A40
82357	L18 9UF	GB	0101000020E61000003D450E11372707C017467A51BBAF4A40
82358	L19	GB	0101000020E61000006DFE5F75E42807C05665DF15C1AD4A40
82359	L19 0PE	GB	0101000020E6100000B41F2922C34A07C08927BB99D1AD4A40
82360	L19 1QL	GB	0101000020E61000001A31B3CF633407C013656F29E7AD4A40
82361	L19 1RF	GB	0101000020E6100000D9E89C9FE23807C006F7031E18AE4A40
82362	L19 3PH	GB	0101000020E6100000D80E46EC136007C0DD26DC2BF3AE4A40
82363	L19 3PW	GB	0101000020E6100000F3CB608C485407C0E030D12005AF4A40
82364	L19 3PY	GB	0101000020E61000000F80B8AB575107C03ACD02ED0EAF4A40
82365	L19 3QH	GB	0101000020E6100000F78F85E8105807C0BE33DAAA24B24A40
82366	L19 3RD	GB	0101000020E6100000931E8656276707C0849B8C2AC3AE4A40
82367	L19 4UB	GB	0101000020E6100000A112D731AE1807C0F17EDC7EF9AE4A40
82368	L19 4UD	GB	0101000020E6100000A94E07B29E1A07C03FE257ACE1AE4A40
82369	L19 6PJ	GB	0101000020E61000007F2F8507CD2E07C0A3E6ABE463AD4A40
82370	L19 6PW	GB	0101000020E6100000DE921CB0AB2907C0C9E7154F3DAE4A40
82371	L19 9DP	GB	0101000020E61000001D3BA8C4754C07C0C3EFA65B76AE4A40
82372	L19 9DQ	GB	0101000020E6100000DC4B1AA3755407C07D93A641D1AE4A40
82373	L2 2DX	GB	0101000020E6100000CC988235CEE607C0C93EC8B260B44A40
82374	L2 2SX	GB	0101000020E61000003D821B295BE407C0525F96766AB44A40
82375	L2 7PQ	GB	0101000020E6100000E204A6D3BAED07C0E2218C9FC6B34A40
82376	L20	GB	0101000020E6100000A3C9C51858E707C0650113B875BF4A40
82377	L20 2BN	GB	0101000020E61000000CC85EEFFED807C064ADA1D45EB84A40
82378	L20 4SU	GB	0101000020E6100000520ABABDA4F107C03AAE4676A5B94A40
82379	L20 5BW	GB	0101000020E61000008DD31055F8F307C00F61FC34EEB94A40
82380	L20 5EL	GB	0101000020E6100000514B732B84F507C04278B471C4BA4A40
82381	L20 6	GB	0101000020E61000008B6B7C26FBC707C00E85CFD6C1BB4A40
82382	L20 7AD	GB	0101000020E610000076FEEDB25FF707C095BA641C23B94A40
82383	L20 8BX	GB	0101000020E61000002368CC24EAE507C0EE43DE72F5B74A40
82384	L20 9AL	GB	0101000020E6100000912A8A5759DB07C0384BC97212BA4A40
82385	L20 9BR	GB	0101000020E6100000E8A04B38F4D607C0DB3521AD31BA4A40
82386	L20 9BY	GB	0101000020E6100000825660C8EAD607C012A5BDC117BA4A40
82387	L20 9LD	GB	0101000020E61000001C7E37DDB2E307C02AC58EC6A1B84A40
82388	L21	GB	0101000020E61000006269E04735EC07C0102043C70EBC4A40
82389	L21 1AS	GB	0101000020E6100000F33B4D66BC2D08C0268BFB8F4CBB4A40
82390	L21 1BL	GB	0101000020E61000001405FA449E2408C0FD12F1D6F9BB4A40
82391	L21 2PT	GB	0101000020E6100000F9F5436CB0D007C0740D33349EBC4A40
82392	L21 3TX	GB	0101000020E61000003E0801F9120A08C0F6D1A92B9FBB4A40
82393	L21 5JU	GB	0101000020E6100000A3409FC893E407C0C921E2E654BC4A40
82394	L21 7LJ	GB	0101000020E6100000D4F36E2C28CC07C0CBBDC0AC50B64A40
82395	L21 9HG	GB	0101000020E6100000888043A852F307C0C845B58828BC4A40
82396	L21 9JS	GB	0101000020E6100000B7D4415E0F0608C0A3E8818FC1BC4A40
82397	L21 9NU	GB	0101000020E61000008527F4FA93B807C00FF27A3029BC4A40
82398	L22	GB	0101000020E610000006F52D73BA2C08C0A7B1BD16F4BC4A40
82399	L22 0LL	GB	0101000020E6100000FCE1E7BF072F08C047B071FDBBBC4A40
82400	L22 0LY	GB	0101000020E61000000E164ED2FC3108C0E90FCD3CB9BC4A40
82401	L22 0NJ	GB	0101000020E6100000FB3A70CE883208C0A777F17EDCBC4A40
82402	L22 0NL	GB	0101000020E61000006EC328081E3F08C0EB025E66D8BC4A40
82403	L22 2BJ	GB	0101000020E61000006E4DBA2D914B08C0AAF3A8F8BFBD4A40
82404	L22 5NS	GB	0101000020E6100000FD868906293808C0594FADBEBABC4A40
82405	L22 5PR	GB	0101000020E61000007AFF1F274C3808C061C614AC71BC4A40
82406	L22 7RY	GB	0101000020E61000006DE7FBA9F15208C0A260C614ACBD4A40
82407	L22 7RZ	GB	0101000020E61000008F17D2E1214C08C0E59B6D6E4CBD4A40
82408	L22 9QS	GB	0101000020E610000041102043C72E08C04D9F1D705DBD4A40
82409	L23	GB	0101000020E61000006AF7AB00DF2D08C0726BD26D89BE4A40
82410	L23 0QG	GB	0101000020E610000003CFBD874B2E08C08B54185B08BE4A40
82411	L23 0QS	GB	0101000020E61000008F8B6A11512C08C07460394206BE4A40
82412	L23 0RW	GB	0101000020E61000000A9E42AED43308C044C02154A9BD4A40
82413	L23 0SS	GB	0101000020E610000062BCE6559D3508C08A8F4FC8CEBD4A40
82414	L23 0TL	GB	0101000020E6100000857CD0B3591508C0632992AF04BE4A40
82415	L23 1TA	GB	0101000020E6100000C80BE9F0100608C0C51EDAC70AC04A40
82416	L23 2RA	GB	0101000020E61000008192020B602A08C0849A215514BF4A40
82417	L23 2SS	GB	0101000020E61000002D077AA86D2308C0CAA31B6151BF4A40
82418	L23 2SW	GB	0101000020E61000006214048F6F2F08C02009FB7612BF4A40
82419	L23 2TP	GB	0101000020E6100000BEF90D130D3208C0848252B472BF4A40
82420	L23 2TQ	GB	0101000020E6100000EC3026FDBD3408C02DEA93DC61BF4A40
82421	L23 3BW	GB	0101000020E6100000C2DCEEE53E3908C079AEEFC341BE4A40
82422	L23 4TU	GB	0101000020E61000008751103CBE3D08C008228B34F1C04A40
82423	L23 5RL	GB	0101000020E61000005AA0DD21C54008C0C9E6AA798EBE4A40
82424	L23 5TP	GB	0101000020E6100000C460FE0A992B08C0CBF6216FB9BE4A40
82425	L23 6TD	GB	0101000020E61000002D7C7DAD4B6D08C0EBC891CEC0BE4A40
82426	L23 6XA	GB	0101000020E61000009EEE3CF19C4D08C086915ED4EEBD4A40
82427	L23 6XS	GB	0101000020E6100000AA605452276008C09CA223B9FCBD4A40
82428	L23 7UH	GB	0101000020E61000007E1AF7E6374C08C0CAA99D616ABF4A40
82429	L23 8SE	GB	0101000020E6100000A779C7293A5208C030A017EE5CBE4A40
82430	L23 8TU	GB	0101000020E610000041D5E8D5006508C07CD11E2FA4BF4A40
82431	L23 8UE	GB	0101000020E61000007520EBA9D55708C0CB64389ECFBE4A40
82432	L23 8UU	GB	0101000020E61000004F2157EA595008C0F71DC3633FBF4A40
82433	L23 9UG	GB	0101000020E61000002CB7B41A123708C0C93EC8B260BE4A40
82434	L23 9UL	GB	0101000020E61000008942CBBA7F2C08C06F9F55664ABB4A40
82435	L23 9UT	GB	0101000020E6100000D712F241CF0608C0817A336ABEBE4A40
82436	L23 9UY	GB	0101000020E6100000999D45EF540008C0CE8AA8893EBF4A40
82437	L23 9YR	GB	0101000020E6100000FDF50A0BEE0708C0E4D87A8670BE4A40
82438	L24	GB	0101000020E6100000056EDDCD539D06C078962023A0AA4A40
82439	L24 5RN	GB	0101000020E6100000D47C957CEC6E06C06CEC12D55BAB4A40
82440	L25 0LA	GB	0101000020E61000005A9F724C16D706C06C054D4BACAE4A40
82441	L25 0LU	GB	0101000020E6100000707B82C476D706C07863416150AE4A40
82442	L25 0NN	GB	0101000020E61000000DE02D90A0D806C00A80F10C1AAE4A40
82443	L25 2NW	GB	0101000020E6100000EE3EC7478BD306C0D0622992AFB04A40
82444	L25 5HP	GB	0101000020E61000009B8D959867E506C0185B087250B04A40
82445	L25 6EX	GB	0101000020E6100000698D4127840E07C0DE73603942B04A40
82446	L25 9NR	GB	0101000020E61000008E5C37A5BCD606C07AC6BE64E3AF4A40
82447	L25 9RN	GB	0101000020E610000094313ECC5ED606C0E9B81AD995B24A40
82448	L25 9RU	GB	0101000020E61000003AAFB14B54CF06C07097FDBAD3AF4A40
82449	L26 0TH	GB	0101000020E610000085798F334D9806C06C054D4BACAE4A40
82450	L26 7YS	GB	0101000020E6100000D464C6DB4AAF06C04CFE277FF7AE4A40
82451	L26 7YU	GB	0101000020E610000097C79A9141AE06C077F700DD97AF4A40
82452	L27 5RA	GB	0101000020E61000003410CB660EA906C07FDDE9CE13B14A40
82453	L28	GB	0101000020E61000005B9A5B21ACE606C0255B5D4E09B84A40
82454	L29	GB	0101000020E61000006B9DB81CAFE007C0526342CC25C14A40
82455	L3 1NX	GB	0101000020E610000082A8FB00A4F607C0F81BEDB8E1B34A40
82456	L3 5GA	GB	0101000020E6100000F9A3A833F7D007C010E6762FF7B34A40
82457	L3 6BN	GB	0101000020E6100000E49EAEEE58EC07C0EFCA2E185CB54A40
82458	L3 6LW	GB	0101000020E610000058569A9482EE07C022179CC1DFB54A40
82459	L3 8AF	GB	0101000020E6100000F90FE9B7AFA307C0556CCCEB88B54A40
82460	L3 8PY	GB	0101000020E61000004CFC51D499BB07C083A10E2BDCB44A40
82461	L3 9UH	GB	0101000020E61000004ACE893DB4EF07C078EE3D5C72B44A40
82462	L30	GB	0101000020E6100000247B849A21B507C09BC8CC052EBF4A40
82463	L30 1RZ	GB	0101000020E6100000AA0D4E44BFB607C0FF428F183DBD4A40
82464	L30 8RD	GB	0101000020E61000008EE55DF5809907C0D8D30E7F4DBE4A40
82465	L31	GB	0101000020E6100000105CE509845D07C0B98E71C5C5BF4A40
82466	L31 0BN	GB	0101000020E610000004E44BA8E07007C0A9D903ADC0C04A40
82467	L31 2JR	GB	0101000020E6100000978BF84ECC9A07C0A96917D34CC34A40
82468	L31 2PA	GB	0101000020E6100000263ACB2C429107C0231631EC30C24A40
82469	L31 3DE	GB	0101000020E61000008F1B7E37DD7207C0F372D87DC7C04A40
82470	L31 4	GB	0101000020E6100000938FDD054A8A07C06B0DA5F622C44A40
82471	L31 5JJ	GB	0101000020E610000073840CE4D98507C00E164ED2FCBF4A40
82472	L31 5NL	GB	0101000020E6100000C58F31772D8107C065506D7022C24A40
82473	L31 6AF	GB	0101000020E6100000A27E17B6666B07C02AE44A3D0BC24A40
82474	L31 7DS	GB	0101000020E6100000A646E867EA9507C09604A8A965C14A40
82475	L31 8AZ	GB	0101000020E6100000070951BEA08507C029EACC3D24C24A40
82476	L31 8BD	GB	0101000020E610000005C078060D9D07C0535A7F4B00C24A40
82477	L31 9AD	GB	0101000020E6100000738236397C7207C05131CEDF84C24A40
82478	L31 9PE	GB	0101000020E6100000BD564277497C07C0D5B2B5BE48C24A40
82479	L32	GB	0101000020E61000003596B036C62E07C0A35698BED7BA4A40
82480	L32 2AE	GB	0101000020E61000000D6FD6E07D3507C0828C800A47BE4A40
82481	L32 3DG	GB	0101000020E610000074417DCB9C6E07C000FE2955A2C04A40
82482	L32 4UU	GB	0101000020E61000001422E010AA3407C0155454FD4ABD4A40
82483	L33 4HG	GB	0101000020E61000002A8E03AF961B07C0FF23D3A1D3BF4A40
82484	L33 7TU	GB	0101000020E6100000213D450E11D706C062D9CC21A9BB4A40
82485	L33 9XZ	GB	0101000020E61000002A6F47382DD806C0268E3C1059BE4A40
82486	L34	GB	0101000020E61000001FD61BB5C27406C0F7E5CC7685B64A40
82487	L34 2GA	GB	0101000020E6100000973C9E961F3806C092CCEA1D6EB74A40
82488	L34 2QS	GB	0101000020E610000089B14CBF443C06C09B02999D45B74A40
82489	L34 5SN	GB	0101000020E610000084BBB376DB6506C01BA034D428B64A40
82490	L35	GB	0101000020E61000001EFD2FD7A26506C0ECD973999AB44A40
82491	L35 0LS	GB	0101000020E61000000B24287E8C1906C012FA997ADDB44A40
82492	L35 0NT	GB	0101000020E6100000486B0C3A211406C081053065E0B44A40
82493	L35 3RY	GB	0101000020E610000077D844662E7006C07BBE66B96CB44A40
82494	L35 3TW	GB	0101000020E61000003D4679E6E55006C0C4B2994352B54A40
82495	L35 4NJ	GB	0101000020E610000059DE550F980706C03B18B14F00B54A40
82496	L35 5AT	GB	0101000020E610000055302AA9135006C0529B38B9DFB54A40
82497	L35 5BL	GB	0101000020E6100000A80018CFA06106C0EA5C514A08B64A40
82498	L35 5DU	GB	0101000020E61000002234828DEB1F06C0D7851F9C4FB74A40
82499	L35 5ES	GB	0101000020E61000005D6F9BA9106F06C0D82AC1E270B64A40
82500	L35 5SN	GB	0101000020E6100000E333D93F4F2306C02E1EDE7360B54A40
82501	L35 6NZ	GB	0101000020E6100000FCA6B052410506C09692E52494B44A40
82502	L35 6PD	GB	0101000020E610000066136058FEFC05C002F390291FB44A40
82503	L35 7JE	GB	0101000020E61000006D72F8A4134906C0F78E1A1362B64A40
82504	L35 7JS	GB	0101000020E6100000B6DAC35E284006C0DEE522BE13B74A40
82505	L35 8NB	GB	0101000020E61000000F99F221A83A06C0AAB8718BF9B54A40
82506	L35 9JH	GB	0101000020E61000007F129F3BC13E06C021EA3E00A9B54A40
82507	L36	GB	0101000020E61000008461C092ABB806C0E622BE13B3B44A40
82508	L36 0UU	GB	0101000020E6100000467BBC900EAF06C03DB83B6BB7B34A40
82509	L36 2LT	GB	0101000020E61000002312859675DF06C00BF0DDE68DB54A40
82510	L36 3UZ	GB	0101000020E6100000001E51A1BAB906C0E0D7481284B54A40
82511	L36 4HU	GB	0101000020E6100000685E0EBBEFD806C086048C2E6FB44A40
82512	L36 5TQ	GB	0101000020E61000001171732A19C006C0CE37A27BD6B34A40
82513	L36 5XE	GB	0101000020E6100000EAE923F087BF06C0C24D469561B44A40
82514	L36 9TN	GB	0101000020E61000007B698A00A7D706C04ED4D2DC0AB54A40
82515	L37	GB	0101000020E6100000F7E6374C348808C0BEDBBC7152C84A40
82516	L37 1PA	GB	0101000020E6100000C2887D0228A608C08F8CD5E6FFC74A40
82517	L37 2JF	GB	0101000020E61000003E247CEF6F9008C03D4679E6E5C64A40
82518	L37 2LY	GB	0101000020E6100000ED461FF301A108C03D4679E6E5C64A40
82519	L37 2YT	GB	0101000020E6100000D40AD3F71AA208C0B3791C06F3C54A40
82520	L37 3HJ	GB	0101000020E610000039EFFFE3848908C0E109BDFE24C84A40
82521	L37 3JJ	GB	0101000020E610000043AED4B3209408C00E84640113C84A40
82522	L37 3NT	GB	0101000020E61000007825C9737D7F08C0EF54C03DCFC74A40
82523	L37 3NW	GB	0101000020E610000012A3E716BA7208C05B23827170C74A40
82524	L37 3PA	GB	0101000020E61000008F56B5A4A37C08C0467EFD101BC84A40
82525	L37 6EH	GB	0101000020E6100000F92EA52E198708C0159161156FC64A40
82526	L37 7AT	GB	0101000020E6100000A35698BED79008C090F8156BB8C84A40
82527	L37 7BS	GB	0101000020E6100000A1F65B3B519208C04F78094E7DC84A40
82528	L37 7DD	GB	0101000020E6100000D49B51F3559208C07E198C1189C84A40
82529	L37 7EE	GB	0101000020E6100000E0675C38107208C0AEEFC34142C84A40
82530	L37 7EF	GB	0101000020E6100000301004C8D07108C032022A1C41C84A40
82531	L37 8BB	GB	0101000020E6100000BE175FB4C78B08C01EFF058200C74A40
82532	L38 3RX	GB	0101000020E610000026C3F17C067408C0DFC14F1C40C34A40
82533	L38 9EH	GB	0101000020E61000000856D5CBEF7408C0A583F57F0EC34A40
82534	L39 0HB	GB	0101000020E6100000CDEA1D6E87C606C043209738F2C44A40
82535	L39 1	GB	0101000020E6100000F75965A6B41E07C01A355F251FC94A40
82536	L39 1NR	GB	0101000020E610000044C02154A91907C0E449D23593C94A40
82537	L39 1NS	GB	0101000020E6100000BC5B59A2B30C07C0FDF7E0B54BC94A40
82538	L39 1PD	GB	0101000020E6100000070B2769FE1807C04A0856D5CBC94A40
82539	L39 1PE	GB	0101000020E61000002BBEA1F0D91A07C0C0EC9E3C2CCA4A40
82540	L39 1RN	GB	0101000020E610000043E6CAA0DA2007C055A69883A0C94A40
82541	L39 2DP	GB	0101000020E610000090A1630795F806C0058C2E6F0EC94A40
82542	L39 2YN	GB	0101000020E6100000BC95253ACB0C07C0A6F27684D3C84A40
82543	L39 3	GB	0101000020E61000003D9CC0745A1707C059F8FA5A97C84A40
82544	L39 3BG	GB	0101000020E61000004F594DD7133D07C0E3175E49F2C84A40
82545	L39 3LG	GB	0101000020E61000003CF9F4D8962107C0E82E89B322C84A40
82546	L39 3NE	GB	0101000020E6100000AB09A2EE033007C0A017EE5C18C94A40
82547	L39 3NJ	GB	0101000020E61000001E34BBEEAD2807C079CA6ABA9EC84A40
82548	L39 4QP	GB	0101000020E61000005AF2785A7E0007C00C5872158BC74A40
82549	L39 4TU	GB	0101000020E61000002AAC5450513507C0069CA56439C74A40
82550	L39 4UJ	GB	0101000020E61000001BA19FA9D72D07C0D4D347E00FC74A40
82551	L39 5AR	GB	0101000020E6100000965F0663444207C0EFE53E390AC64A40
82552	L39 5BN	GB	0101000020E6100000FEB627486C3707C046CF2D7425C64A40
82553	L39 5BT	GB	0101000020E610000059897956D22A07C03621AD31E8C64A40
82554	L39 5BU	GB	0101000020E6100000F4BF5C8B162007C0994BAAB69BC64A40
82555	L39 5DD	GB	0101000020E6100000487023658B2407C0C63368E89FC64A40
82556	L39 6RG	GB	0101000020E61000005A2F8672A23D07C00BD3F71A82C54A40
82557	L39 6RY	GB	0101000020E61000009FB0C403CA2607C00DC1711937C54A40
82558	L39 6SG	GB	0101000020E61000001041D5E8D54007C0B136C64E78C54A40
82559	L39 6SP	GB	0101000020E610000035423F53AF5B07C026E1421EC1C34A40
82560	L39 6SY	GB	0101000020E610000090DC9A745B6207C0FD4D2844C0C34A40
82561	L39 7JG	GB	0101000020E6100000ED9925016ACA07C0D120054F21C94A40
82562	L39 9EG	GB	0101000020E61000004087F9F2020C07C0D8BAD408FDC44A40
82563	L4 0TH	GB	0101000020E61000007E8B4E965AAF07C0793D98141FB74A40
82564	L4 4LG	GB	0101000020E6100000282B86AB03A007C0EEB089CC5CB84A40
82565	L4 5UF	GB	0101000020E610000043041C4295BA07C09D6516A1D8B84A40
82566	L4 9UU	GB	0101000020E6100000681F2BF86D8807C07715527E52B94A40
82567	L40 0RY	GB	0101000020E6100000639AE95E27D506C0C172840CE4CD4A40
82568	L40 1TB	GB	0101000020E61000002DCF83BBB37606C0D55E44DB31D14A40
82569	L40 4BL	GB	0101000020E6100000FA62EFC5176D06C0F660527C7CCC4A40
82570	L40 4BT	GB	0101000020E61000009337C0CC779006C0F03504C765CC4A40
82571	L40 5SP	GB	0101000020E6100000187C9A9317B906C0CE35CCD078CC4A40
82572	L40 5SY	GB	0101000020E6100000100533A660AD06C001F9122A38CC4A40
82573	L40 5UF	GB	0101000020E610000033E02C25CB8906C0E882FA9639C94A40
82574	L40 5UJ	GB	0101000020E610000022E3512AE1A906C01FBC7669C3C94A40
82575	L40 6HH	GB	0101000020E610000067B796C970DC06C0670C738236C74A40
82576	L40 8HB	GB	0101000020E610000042E90B21E73D07C065FB90B75CCB4A40
82577	L40 9QP	GB	0101000020E610000007077B13435207C0E69315C3D5CF4A40
82578	L41	GB	0101000020E610000025EB7074952E08C0897C975297B24A40
82579	L47	GB	0101000020E610000015191D9084DD07C0E3E2A8DC44C14A40
82580	L5	GB	0101000020E61000007B698A00A7D707C0C896E5EB32B64A40
82581	L5 3TX	GB	0101000020E61000002655DB4DF0ED07C037C30DF8FCB64A40
82582	L5 4RT	GB	0101000020E6100000C7D6338463B607C008B0C8AF1FB64A40
82583	L5 4TH	GB	0101000020E6100000B0C6D97404B007C02A58E36C3AB64A40
82584	L6	GB	0101000020E6100000944BE3175E8907C005A3923A01B54A40
82585	L6 0BW	GB	0101000020E610000003CFBD874B8E07C0DDB1D82615B74A40
82586	L6 2HZ	GB	0101000020E6100000CF2F4AD05FA807C086747808E3B54A40
82587	L6 4DB	GB	0101000020E61000002DEE3F321D9A07C021054F2157B64A40
82588	L6 4DX	GB	0101000020E610000061545227A08907C0CDE49B6D6EB64A40
82589	L6 4TJ	GB	0101000020E610000020240B98C0AD07C0E7A90EB919B64A40
82590	L6 8PJ	GB	0101000020E6100000CEA5B8AAEC7B07C0E620E86855B54A40
82591	L6 9HT	GB	0101000020E610000075C8CD70039E07C057ED9A90D6B44A40
82592	L69	GB	0101000020E61000002BBEA1F0D9FA07C0EB56CF49EFB34A40
82593	L7	GB	0101000020E6100000BCE9961DE29F07C060B1868BDCB34A40
82594	L7 0JE	GB	0101000020E610000093C49272F77907C019ABCDFFABB44A40
82595	L7 1AD	GB	0101000020E61000004DD9E907759107C09CFBABC77DB34A40
82596	L7 5PY	GB	0101000020E61000007B67B455498407C076711B0DE0B34A40
82597	L7 9NW	GB	0101000020E6100000FC3905F9D96807C072C3EFA65BB44A40
82598	L7 9PA	GB	0101000020E6100000473CD9CD8C7E07C065C6DB4AAFB34A40
82599	L8	GB	0101000020E610000092239D8191D707C04F78094E7DB24A40
82600	L8 3SA	GB	0101000020E6100000062D2460749907C0D099B4A9BAB14A40
82601	L8 3TZ	GB	0101000020E6100000C8CEDBD8ECA807C0658C0FB397B14A40
82602	L8 5SN	GB	0101000020E61000007F50172994C507C01901158E20B14A40
82603	L8 5TB	GB	0101000020E61000004D0F0A4AD1EA07C0037D224F92B24A40
82604	L8 7LL	GB	0101000020E61000003FADA23F34B307C0AE2EA704C4B24A40
82605	L8 7LP	GB	0101000020E6100000A2629CBF09C507C0AABBB20B06B34A40
82606	L8 7LW	GB	0101000020E610000047205ED72FB807C0F986C267EBB24A40
82607	L85S	GB	0101000020E6100000F9872D3D9ACA07C0AE11C138B8B04A40
82608	L8H	GB	0101000020E61000002A1F82AAD18B05C05BCF108E59AC4A40
82609	L9	GB	0101000020E6100000618E1EBFB78907C0F99D2633DEBA4A40
82610	L9 1EB	GB	0101000020E61000005CE84A04AA9F07C0499D8026C2B84A40
82611	L9 1EY	GB	0101000020E610000017B6662B2FB907C0AA0EB9196EBA4A40
82612	L9 3BY	GB	0101000020E6100000D28DB0A888B307C0C57421567FBA4A40
82613	L9 4RZ	GB	0101000020E6100000C8CEDBD8ECA807C0F392FFC9DFBB4A40
82614	L9 5BE	GB	0101000020E6100000118DEE2076A607C0FC8BA03193BC4A40
82615	L9 7LG	GB	0101000020E61000006D8D08C6C18507C07F33315D88BB4A40
82616	L9 8AL	GB	0101000020E6100000DDD26A48DCC307C08DB800344ABB4A40
82617	L9 8AX	GB	0101000020E61000003A933655F7C807C01A18795913BB4A40
82618	L9 8BG	GB	0101000020E6100000E36DA5D766C307C05D6E30D461BB4A40
82619	L9 8BU	GB	0101000020E610000078EDD286C3B207C0537AA69718BB4A40
82620	L9 8DJ	GB	0101000020E610000096253ACB2CC207C0A27E17B666BB4A40
82621	L9 8DX	GB	0101000020E61000004489963C9EB607C07521567F84BB4A40
82622	L9 8EP	GB	0101000020E610000026DF6C7363BA07C0382F4E7CB5BB4A40
82623	L9 9AS	GB	0101000020E61000001A8BA6B393A107C0D34D621058BB4A40
82624	L9 9EW	GB	0101000020E6100000113AE8120E7D07C0E1CFF0660DBC4A40
82625	LA1	GB	0101000020E610000064045438827406C0B4024356B7064B40
82626	LA1 1ET	GB	0101000020E6100000E9B7AF03E76C06C07FC2D9AD65064B40
82627	LA1 1GE	GB	0101000020E6100000C0CE4D9B715A06C04C16F71F99064B40
82628	LA1 1SL	GB	0101000020E610000093E00D69546006C04B75012F33064B40
82629	LA1 1SY	GB	0101000020E610000009A4C4AEED6D06C02B306475AB054B40
82630	LA1 1TF	GB	0101000020E6100000F56569A7E67206C0D5EC815660064B40
82631	LA1 1TT	GB	0101000020E61000001B498270057406C00C91D3D7F3054B40
82632	LA1 1YX	GB	0101000020E61000005E126745D4A406C0957D5704FF054B40
82633	LA1 2AD	GB	0101000020E6100000397EA834624606C0D6355A0EF4084B40
82634	LA1 2DU	GB	0101000020E6100000A7CD380D516506C0D6A71C93C5074B40
82635	LA1 2EH	GB	0101000020E61000004DD7135D175E06C003081F4AB4084B40
82636	LA1 2HU	GB	0101000020E610000044A33B889D6906C06A1492CCEA074B40
82637	LA1 2NW	GB	0101000020E6100000471D1D57237B06C09F55664AEB074B40
82638	LA1 2RX	GB	0101000020E610000038F92D3A596A06C01E5036E50A074B40
82639	LA1 2TX	GB	0101000020E61000009EEFA7C64B9706C0A94F72874D084B40
82640	LA1 2TY	GB	0101000020E6100000DEACC1FBAA3C06C0AC1F9BE447084B40
82641	LA1 3AL	GB	0101000020E6100000B900344A975E06C04B2025766D054B40
82642	LA1 3DX	GB	0101000020E610000060ADDA35214D06C0DB8827BB99054B40
82643	LA1 3LF	GB	0101000020E6100000D5963AC8EB6106C0FBE93F6B7E064B40
82644	LA1 3QE	GB	0101000020E61000005E2C0C91D35706C048A5D8D138064B40
82645	LA1 3RP	GB	0101000020E6100000EF92382BA22606C0B9718BF9B9054B40
82646	LA1 3ST	GB	0101000020E610000051F4C0C7602506C0C7BB2363B5054B40
82647	LA1 4BQ	GB	0101000020E610000047AE9B525E4B06C075CC79C6BE044B40
82648	LA1 4DH	GB	0101000020E6100000DBA7E331035506C05E2EE23B31054B40
82649	LA1 4DN	GB	0101000020E61000002CBAF59A1E5406C0789CA223B9044B40
82650	LA1 4PH	GB	0101000020E6100000E4BED53A715906C0FBE93F6B7E024B40
82651	LA1 4QL	GB	0101000020E610000056D5CBEF345906C00DE4D9E55B034B40
82652	LA1 4SH	GB	0101000020E6100000C328081EDF5E06C0207BBDFBE3034B40
82653	LA1 4TW	GB	0101000020E6100000168733BF9A6306C0CA54C1A8A4044B40
82654	LA1 4UF	GB	0101000020E610000021904B1C796006C0789B374E0A054B40
82655	LA1 4XD	GB	0101000020E6100000971B0C75586106C09198A0866F054B40
82656	LA1 4XP	GB	0101000020E610000095F0845E7F3206C05AF10D85CF044B40
82657	LA1 4YW	GB	0101000020E6100000CBA2B08BA24706C0554FE61F7D014B40
82658	LA1 5BD	GB	0101000020E6100000F0A5F0A0D97506C00D350A4966054B40
82659	LA1 5EA	GB	0101000020E610000089B5F814008306C0624D6551D8054B40
82660	LA1 5LN	GB	0101000020E6100000CE177B2FBE8806C085D21742CE054B40
82661	LA1 5NW	GB	0101000020E6100000F25EB532E17706C03944DC9C4A064B40
82662	LA1 5PF	GB	0101000020E61000007D224F92AE7906C05A0EF450DB064B40
82663	LA1 5PJ	GB	0101000020E61000009D2E8B89CD6706C0F9484A7A18064B40
82664	LA1 5PL	GB	0101000020E610000025917D90658106C0FA415DA450064B40
82665	LA1 5PY	GB	0101000020E61000005BE9B5D9588906C03B8908FF22064B40
82666	LA1 5QE	GB	0101000020E61000002C2CB81FF08006C0FA980F0874064B40
82667	LA1 5QX	GB	0101000020E6100000904946CEC27E06C0A5677A89B1064B40
82668	LA1 5TP	GB	0101000020E6100000D862B7CF2A9306C0137D3ECA88054B40
82669	LA1 5UB	GB	0101000020E610000056F5F23B4D8606C0514CDE0033054B40
82670	LA10 5BZ	GB	0101000020E6100000529ACDE3303804C065FB90B75C294B40
82671	LA10 5DH	GB	0101000020E6100000FC7266BB423F04C0C6A52A6D71294B40
82672	LA10 5HY	GB	0101000020E6100000D28BDAFD2A8004C014CB2DAD862C4B40
82673	LA10 5JR	GB	0101000020E6100000C9C7EE0225E503C01E6FF25B74284B40
82674	LA10 5NE	GB	0101000020E610000022A81ABD1AC003C0A2F14410E72D4B40
82675	LA10 5PQ	GB	0101000020E6100000FAEC80EB8A9902C0950B957F2D294B40
82676	LA10 5RF	GB	0101000020E6100000A912656F29E702C019CA897615244B40
82677	LA11 6EH	GB	0101000020E6100000A3ACDF4C4C3707C07E6FD39FFD184B40
82678	LA11 6ES	GB	0101000020E61000007CD5CA845F2A07C016F6B4C35F194B40
82679	LA11 6JJ	GB	0101000020E610000045460724615F07C0CB0EF10F5B1E4B40
82680	LA11 6NA	GB	0101000020E61000004B21904B1C3907C004594FADBE1C4B40
82681	LA11 6NS	GB	0101000020E6100000EB36A8FDD62E07C07AA69718CB244B40
82682	LA11 7AB	GB	0101000020E610000044F7AC6BB45C07C0656F29E78B174B40
82683	LA11 7BG	GB	0101000020E61000003AE8120EBD6507C08A8EE4F21F164B40
82684	LA11 7DU	GB	0101000020E6100000F302ECA3535707C0D05E7D3CF4174B40
82685	LA11 7JG	GB	0101000020E6100000CCD42478435A07C06092CA1473184B40
82686	LA11 7JZ	GB	0101000020E610000073BED87BF1C507C09F5912A0A6144B40
82687	LA11 7NL	GB	0101000020E61000000F2A711DE3CA07C039B709F7CA164B40
82688	LA12	GB	0101000020E610000030BC92E4B9DE08C066136058FE164B40
82689	LA12 0DP	GB	0101000020E610000019C91EA166C808C0289EB30584184B40
82690	LA12 0DT	GB	0101000020E6100000A6D425E318C908C0874F3A9160184B40
82691	LA12 0EG	GB	0101000020E61000007C6473D53CC708C0E23D079623184B40
82692	LA12 0UQ	GB	0101000020E61000002D431CEBE2F608C0969350FA42164B40
82693	LA12 7DA	GB	0101000020E6100000BABDA4315AC708C0A67B9DD497194B40
82694	LA12 7EQ	GB	0101000020E610000002486DE2E4BE08C07099D36531194B40
82695	LA12 7LA	GB	0101000020E610000043AD69DE71AA08C007CF842689194B40
82696	LA12 8BS	GB	0101000020E6100000401361C3D38B08C0B343FCC396204B40
82697	LA12 8DJ	GB	0101000020E6100000D0285DFA97C408C02FC03E3A75254B40
82698	LA12 9AL	GB	0101000020E610000018B5FB5580AF08C069006F8104194B40
82699	LA12 9EN	GB	0101000020E61000001D5723BBD27208C0B81D1A16A3184B40
82700	LA12 9JB	GB	0101000020E61000004A99D4D006C008C0FCFCF7E0B5174B40
82701	LA12 9NJ	GB	0101000020E61000004E7FF62345C408C0BC581822A7174B40
82702	LA12 9NW	GB	0101000020E6100000562DE92807D308C00FB6D8EDB3184B40
82703	LA12 9PN	GB	0101000020E6100000BD56427749BC08C018EAB0C22D174B40
82704	LA12 9QL	GB	0101000020E61000003DEFC682C2A008C03C2D3F7095154B40
82705	LA12 9QQ	GB	0101000020E610000088F37002D38908C0C4B0C398F4154B40
82706	LA12 9QT	GB	0101000020E61000008F6CAE9AE7C808C0B72A89EC83184B40
82707	LA12 9RT	GB	0101000020E610000061545227A0C908C0AA0D4E44BF104B40
82708	LA13 9JQ	GB	0101000020E6100000E1606F6248AE09C02DCF83BBB3104B40
82709	LA13 9NS	GB	0101000020E610000037894160E5B009C0BA30D28BDA0F4B40
82710	LA13 9SJ	GB	0101000020E6100000459DB987848F09C0C4B46FEEAF0E4B40
82711	LA14	GB	0101000020E61000001C5E10919AD609C008008E3D7B0E4B40
82712	LA14 1HX	GB	0101000020E6100000F1129CFA40D209C05950189469104B40
82713	LA14 2DX	GB	0101000020E61000002E03CE52B2BC09C0B5C4CA68E40F4B40
82714	LA14 2NE	GB	0101000020E61000009CA4F9635ADB09C00056478E740E4B40
82715	LA14 2NN	GB	0101000020E6100000CE39782634E909C0D0285DFA970E4B40
82716	LA14 3DE	GB	0101000020E6100000B2BE81C98D020AC0DAE1AFC91A0D4B40
82717	LA14 3EY	GB	0101000020E610000072874D64E6020AC07C0E2C47C80C4B40
82718	LA14 3HN	GB	0101000020E61000002B6EDC627E0E0AC0B98C9B1A680C4B40
82719	LA14 4HX	GB	0101000020E61000000074982F2FC009C0E1F1ED5D83124B40
82720	LA14 4LE	GB	0101000020E6100000EBFD463B6EB809C091813CBB7C114B40
82721	LA14 4NP	GB	0101000020E6100000AD156D8E73BB09C0583CF54883114B40
82722	LA14 4PT	GB	0101000020E6100000F06B2409C2B509C0A33D5E48870F4B40
82723	LA14 5ER	GB	0101000020E6100000E04DB7EC10DF09C04DA1F31ABB104B40
82724	LA14 5EZ	GB	0101000020E610000029B4ACFBC7C209C059A48977800F4B40
82725	LA14 5QZ	GB	0101000020E610000012BEF73768CF09C0BB7D5699290F4B40
82726	LA15 8JB	GB	0101000020E61000009BE3DC26DC6B09C0740D33349E144B40
82727	LA15 8NR	GB	0101000020E6100000CA17B490807109C0B2D991EA3B134B40
82728	LA15 8QA	GB	0101000020E610000085B2F0F5B56E09C0677FA0DCB6134B40
82729	LA16 7EN	GB	0101000020E6100000DC68006F81A409C0E564E25641184B40
82730	LA17 7TB	GB	0101000020E61000008E59F624B07909C082AAD1AB011E4B40
82731	LA17 7UA	GB	0101000020E61000009CC24A05157509C01C0934D8D41D4B40
82732	LA17 7UB	GB	0101000020E6100000384A5E9D638009C047382D78D11D4B40
82733	LA18 4AY	GB	0101000020E610000071E7C2482F2A0AC0F437A110011B4B40
82734	LA18 4BN	GB	0101000020E6100000F418E59997230AC00AA1832EE11A4B40
82735	LA18 5AS	GB	0101000020E6100000FD87F4DBD7210AC023BC3D08011F4B40
82736	LA18 5HJ	GB	0101000020E610000071E2AB1DC5190AC0E3C116BB7D204B40
82737	LA18 5HR	GB	0101000020E6100000D8F50B76C3F609C0562C7E53581F4B40
82738	LA18 5LP	GB	0101000020E610000034F279C553AF0AC01538D906EE1C4B40
82739	LA19	GB	0101000020E610000001BEDBBC71120BC0E411DC48D9244B40
82740	LA19 5TA	GB	0101000020E61000004224438EAD270BC0F71DC3633F254B40
82741	LA19 5UJ	GB	0101000020E6100000085A8121ABFB0AC000C63368E8234B40
82742	LA2	GB	0101000020E610000059DFC0E4467103C0338CBB41B40E4B40
82743	LA2 0QB	GB	0101000020E61000003ACFD8976CFC05C0B3B794F3C5004B40
82744	LA2 0RB	GB	0101000020E6100000594FADBEBA4A06C05473B9C150FF4A40
82745	LA2 6NP	GB	0101000020E6100000F8359204E10A06C0A6BA8097190A4B40
82746	LA2 7AD	GB	0101000020E610000094FAB2B4531304C0FD82DDB06D0F4B40
82747	LA2 8AN	GB	0101000020E61000003C2D3F70956704C0384888F205FF4A40
82748	LA2 8DX	GB	0101000020E6100000BF620D17B94703C030F488D1730D4B40
82749	LA2 8HW	GB	0101000020E61000001D5A643BDF6F03C0F015DD7A4D0F4B40
82750	LA2 8JS	GB	0101000020E610000039807EDFBF1905C07B336ABE4A0E4B40
82751	LA2 9LF	GB	0101000020E6100000C18D942D923605C0F163CC5D4B0C4B40
82752	LA2 9PQ	GB	0101000020E6100000C217265305A305C087527B116D094B40
82753	LA2 9QT	GB	0101000020E610000025AFCE3120BB05C06D1FF296AB094B40
82754	LA20 6BX	GB	0101000020E6100000DBFD2AC077BB09C096B4E21B0A214B40
82755	LA20 6EE	GB	0101000020E6100000D66EBBD05C6709C0D80E46EC132E4B40
82756	LA20 6HB	GB	0101000020E6100000BF9A030473B409C0234DBC033C234B40
82757	LA21 8AA	GB	0101000020E6100000FA2B64AE0C6A08C097917A4FE52E4B40
82758	LA21 8BT	GB	0101000020E610000087E123624A0409C0E3546B61162A4B40
82759	LA21 8DD	GB	0101000020E61000007958A835CD9B08C0E31B0A9FAD2F4B40
82760	LA21 8DE	GB	0101000020E61000000DE02D90A09808C009A4C4AEED2F4B40
82761	LA21 8HU	GB	0101000020E61000007714E7A8A3A308C01A355F251F2F4B40
82762	LA22 0EH	GB	0101000020E61000008B5242B0AABE07C022E17B7F83364B40
82763	LA22 0NG	GB	0101000020E6100000751E15FF770408C0B9FDF2C98A334B40
82764	LA22 0NT	GB	0101000020E6100000AE9E93DE37FE07C04417D4B7CC2F4B40
82765	LA22 0QU	GB	0101000020E61000003B8C497F2FA507C031B43A3943374B40
82766	LA22 5JY	GB	0101000020E6100000B1A888D349D608C0D61EF64201394B40
82767	LA22 7JQ	GB	0101000020E6100000E2B19FC5520408C0BF7CB262B8144B40
82768	LA22 9AG	GB	0101000020E61000006F4BE48233B807C0890B40A374374B40
82769	LA22 9EZ	GB	0101000020E61000005D4E098849B807C017299485AF374B40
82770	LA22 9HJ	GB	0101000020E6100000A69BC420B03208C030A182C30B384B40
82771	LA22 9HP	GB	0101000020E610000082035ABA824D08C0B47405DB88374B40
82772	LA22 9HX	GB	0101000020E6100000601E32E5435008C02733DE567A374B40
82773	LA22 9HY	GB	0101000020E6100000034356B77A4E08C0AAF413CE6E374B40
82774	LA22 9JD	GB	0101000020E610000089B5F814006308C056EF703B34384B40
82775	LA22 9NJ	GB	0101000020E6100000494DBB98661A08C07FA65EB708364B40
82776	LA22 9NY	GB	0101000020E61000001EDFDE35E86B08C0C6FB71FBE5354B40
82777	LA22 9NZ	GB	0101000020E61000001555BFD2F97008C0DE74CB0EF1354B40
82778	LA23	GB	0101000020E610000000529B38B93F07C0B39597FC4F304B40
82779	LA23 1AH	GB	0101000020E6100000965B5A0D893B07C0C47AA35698304B40
82780	LA23 1BZ	GB	0101000020E6100000BABDA4315A4707C0FC1D8A027D304B40
82781	LA23 1PF	GB	0101000020E610000048A46DFC894A07C0292504ABEA354B40
82782	LA23 2DW	GB	0101000020E610000045F64196053307C07CD6355A0E304B40
82783	LA23 2JG	GB	0101000020E6100000C828CFBC1C5607C04703780B24304B40
82784	LA23 2JX	GB	0101000020E61000001B65FD66625A07C0C11E1329CD304B40
82785	LA23 3BL	GB	0101000020E6100000C119FCFD625607C07BDAE1AFC92E4B40
82786	LA23 3ES	GB	0101000020E6100000BEF73768AF5E07C0F7729F1C052E4B40
82787	LA3	GB	0101000020E6100000AFCF9CF5292707C073D53C47E4054B40
82788	LA3 1BL	GB	0101000020E6100000B308C556D01407C0137CD3F4D9074B40
82789	LA3 1DA	GB	0101000020E610000072FDBB3E731607C0BC0512143F084B40
82790	LA3 1EB	GB	0101000020E61000003961C268561607C064575A46EA074B40
82791	LA3 1EJ	GB	0101000020E61000007590D783491107C0750305DEC9074B40
82792	LA3 1EX	GB	0101000020E61000003CDD79E2391B07C0CD21A98592074B40
82793	LA3 1EZ	GB	0101000020E61000003ACFD8976C1C07C029B2D6506A074B40
82794	LA3 1HS	GB	0101000020E6100000F7729F1C050807C01E54E23AC6074B40
82795	LA3 1HZ	GB	0101000020E610000003983270400B07C0C7BB2363B5074B40
82796	LA3 1JQ	GB	0101000020E61000008200193A761007C021B0726891074B40
82797	LA3 1NU	GB	0101000020E6100000DE8E705AF02207C02025766D6F074B40
82798	LA3 1RY	GB	0101000020E6100000DB148F8B6A1107C0CDCEA2772A084B40
82799	LA3 1UD	GB	0101000020E61000001B2AC6F99B1007C08E588B4F01084B40
82800	LA3 1UP	GB	0101000020E61000004B766C04E21507C064AE0CAA0D084B40
82801	LA3 2AH	GB	0101000020E610000014252191B61107C064CF9ECBD4064B40
82802	LA3 2JQ	GB	0101000020E61000005EDBDB2DC92107C0787AA52C43064B40
82803	LA3 2PR	GB	0101000020E610000026C79DD2C13A07C0399CF9D51C064B40
82804	LA3 2RX	GB	0101000020E61000005743E21E4B3F07C049D576137C054B40
82805	LA3 3BA	GB	0101000020E6100000A5660FB402C306C0A680B4FF01084B40
82806	LA3 3QN	GB	0101000020E6100000FF2268CC24EA06C03B8BDEA980074B40
82807	LA4	GB	0101000020E61000005706D50627C206C05776C1E09A094B40
82808	LA4 4DE	GB	0101000020E61000009AB2D30FEAE206C0F209D9791B094B40
82809	LA4 4EQ	GB	0101000020E61000006519E25817F706C0CE001764CB084B40
82810	LA4 4JQ	GB	0101000020E6100000BA15C26A2C0107C097C79A9141084B40
82811	LA4 4LT	GB	0101000020E6100000BE89213999F806C009FB761211084B40
82812	LA4 4PA	GB	0101000020E6100000F1B913ECBFEE06C040170D198F084B40
82813	LA4 4PE	GB	0101000020E61000002F4D11E0F4EE06C0DA9255116E084B40
82814	LA4 4PU	GB	0101000020E6100000242BBF0CC6E806C087FD9E58A7084B40
82815	LA4 4UN	GB	0101000020E61000001F662FDB4EDB06C0AB2688BA0F084B40
82816	LA4 5SS	GB	0101000020E61000005DFC6D4F90D806C07A8F334DD8084B40
82817	LA4 5TA	GB	0101000020E6100000410B09185DDE06C0C8EBC1A4F8084B40
82818	LA4 6AT	GB	0101000020E6100000DAE1AFC91AB506C0350708E6E8094B40
82819	LA4 6BW	GB	0101000020E61000004512BD8C62B906C0CD5A0A48FB094B40
82820	LA4 6HZ	GB	0101000020E6100000D1AE42CA4FAA06C0BD00FBE8D4094B40
82821	LA4 6JD	GB	0101000020E61000005F268A90BA9D06C00FD07D39B3054B40
82822	LA4 6LL	GB	0101000020E610000059315C1D00B106C01096B1A19B094B40
82823	LA4 6NB	GB	0101000020E6100000085BECF659A506C064CA87A06A084B40
82824	LA4 6NT	GB	0101000020E61000006A4FC939B1A706C0AE2D3C2F15094B40
82825	LA4 6PE	GB	0101000020E6100000895C70067F9F06C0FC56EBC4E5084B40
82826	LA4 6PS	GB	0101000020E61000008350DEC7D19C06C08C82E0F1ED094B40
82827	LA4 6QX	GB	0101000020E6100000C97553CA6BA506C0D5230D6E6B094B40
82828	LA4 6RB	GB	0101000020E6100000AB798EC877A906C00667F0F78B094B40
82829	LA4 6SE	GB	0101000020E61000000038F6ECB9AC06C030D978B0C5084B40
82830	LA4 6SR	GB	0101000020E610000027DBC01DA8B306C0618907944D094B40
82831	LA4 6TY	GB	0101000020E61000003B394371C7BB06C077BF0AF0DD084B40
82832	LA5 0DR	GB	0101000020E61000004852D2C3D0AA06C018CC5F2173194B40
82833	LA5 0HQ	GB	0101000020E61000006D718DCF649F06C02A70B20DDC194B40
82834	LA5 0SW	GB	0101000020E6100000427A8A1C226E06C0AF5FB01BB6154B40
82835	LA5 8DQ	GB	0101000020E610000043588D25AC4D06C0899B53C9000E4B40
82836	LA5 8DS	GB	0101000020E61000001002F225545006C0CCB56801DA0C4B40
82837	LA5 8JR	GB	0101000020E61000000D350A49667506C0CD3E8F519E0D4B40
82838	LA5 9EA	GB	0101000020E61000000EDC813AE53106C047382D78D10F4B40
82839	LA5 9EH	GB	0101000020E610000075029A081B3E06C0616BB6F2920F4B40
82840	LA5 9ET	GB	0101000020E6100000419C8713982E06C05131CEDF84104B40
82841	LA5 9JY	GB	0101000020E6100000B8CD5488472206C075012F336C104B40
82842	LA5 9LD	GB	0101000020E6100000E48233F8FB2506C089601C5C3A104B40
82843	LA5 9NU	GB	0101000020E6100000821B295B242D06C07BA180ED60124B40
82844	LA5 9RZ	GB	0101000020E61000003C9F01F5669406C091F0BDBF41194B40
82845	LA6	GB	0101000020E6100000AED3484BE54D07C0124E0B5EF4034B40
82846	LA6 1AX	GB	0101000020E6100000228E75711B0D05C0F568AA27F3114B40
82847	LA6 1BH	GB	0101000020E6100000CE1C925A28F905C0043BFE0B04134B40
82848	LA6 1PB	GB	0101000020E61000002F14B01D8CB805C09624CFF57D1C4B40
82849	LA6 1QD	GB	0101000020E610000078D2C26515D605C020B41EBE4C1A4B40
82850	LA6 1RT	GB	0101000020E61000005038BBB54CC605C05AA148F7731A4B40
82851	LA6 1SF	GB	0101000020E61000003FFD67CD8FBF05C0A2258FA7E5174B40
82852	LA6 2HJ	GB	0101000020E610000083893F8A3AD304C05969520ABA194B40
82853	LA6 2JP	GB	0101000020E61000008C834BC79C2704C00B9A9658191D4B40
82854	LA6 2JQ	GB	0101000020E610000086E464E2564104C02BC0779B37164B40
82855	LA6 2SE	GB	0101000020E6100000E90C8CBCACA904C03620425C39194B40
82856	LA6 2SF	GB	0101000020E610000050C3B7B06E9C04C039605793A71A4B40
82857	LA6 3AN	GB	0101000020E6100000A41820D104AA03C06DC83F3388134B40
82858	LA6 3NE	GB	0101000020E61000009240834D9D4704C0C18D942D92124B40
82859	LA63 5NE	GB	0101000020E6100000C5C9FD0E45E102C0FA0D130D521A4B40
82860	LA7 7	GB	0101000020E610000045A0FA07912C06C03B8E1F2A8D1A4B40
82861	LA7 7AX	GB	0101000020E6100000FDBCA948853106C0A7B393C1511A4B40
82862	LA7 7DQ	GB	0101000020E6100000A226FA7C941106C051853FC39B1D4B40
82863	LA7 7DW	GB	0101000020E6100000E2AFC91AF53006C0626534F2791D4B40
82864	LA7 7ET	GB	0101000020E61000005BD2510E663306C0861DC6A4BF1F4B40
82865	LA7 7NU	GB	0101000020E61000004F1E166A4DB305C04AD235936F1E4B40
82866	LA8 8AE	GB	0101000020E6100000A8FE4124432E06C068EBE0606F244B40
82867	LA8 8AG	GB	0101000020E61000000CCB9F6F0B3606C0369204E10A264B40
82868	LA8 8JU	GB	0101000020E610000012BD8C62B9E505C03FA88B14CA2E4B40
82869	LA8 8LA	GB	0101000020E610000099620E828E9606C06B80D250A32C4B40
82870	LA8 8LD	GB	0101000020E610000061A92EE065A606C0E57ADB4C852C4B40
82871	LA8 9AB	GB	0101000020E61000008318E8DA173006C0266DAAEE912F4B40
82872	LA8 9EE	GB	0101000020E610000037E33444159E05C043E7357689304B40
82873	LA8 9JA	GB	0101000020E6100000E44EE960FD5F06C02F6B6281AF2E4B40
82874	LA8 9JP	GB	0101000020E61000008D0E48C2BE9D06C04510E7E104384B40
82875	LA8 9LF	GB	0101000020E6100000558847E2E58905C0B6114F7633354B40
82876	LA8 9NB	GB	0101000020E6100000C3D4963AC88B06C02E1C08C902304B40
82877	LA8 9NG	GB	0101000020E6100000D107CBD8D08D06C07CD6355A0E304B40
82878	LA8 9PW	GB	0101000020E6100000C1E3DBBB069D06C0BBEEAD484C304B40
82879	LA8 9PY	GB	0101000020E610000014CFD90242AB06C0AC1919E42E324B40
82880	LA9	GB	0101000020E61000003CA06CCA15FE05C053758F6CAE284B40
82881	LA9 4BH	GB	0101000020E6100000E40F069E7BEF05C09204E10A282A4B40
82882	LA9 4HT	GB	0101000020E6100000EBE6E26F7B0206C0DA71C3EFA6294B40
82883	LA9 4PU	GB	0101000020E61000008FFAEB1516FC05C0711B0DE02D2A4B40
82884	LA9 4QG	GB	0101000020E6100000EAAF575870FF05C043AD69DE712A4B40
82885	LA9 5	GB	0101000020E6100000B37A87DBA10106C07C0F971C77284B40
82886	LA9 5JR	GB	0101000020E61000000ED76A0F7B0106C02B1213D4F0274B40
82887	LA9 5PH	GB	0101000020E610000057B26323100F06C0DD425722502B4B40
82888	LA9 5PX	GB	0101000020E61000000D36751E15FF05C030815B77F32A4B40
82889	LA9 5RN	GB	0101000020E6100000C921E2E6541206C076A565A4DE274B40
82890	LA9 5SD	GB	0101000020E61000001152B7B3AF1C06C0FD6662BA102D4B40
82891	LA9 6AS	GB	0101000020E61000001C08C90226D005C0527E52EDD3294B40
82892	LA9 6BT	GB	0101000020E610000015E46723D7ED05C02BDCF291942A4B40
82893	LA9 6HG	GB	0101000020E610000035ED629AE9DE05C04B7842AF3F2B4B40
82894	LA9 6RD	GB	0101000020E6100000F0DDE68D932206C04C378941602D4B40
82895	LA9 7AY	GB	0101000020E6100000B7990AF148DC05C0E48233F8FB294B40
82896	LA9 7HG	GB	0101000020E6100000E719FB928DC705C0EBAA402D06274B40
82897	LA9 7QH	GB	0101000020E6100000782975C938E605C0D47FD6FCF8254B40
82898	LA9 7RX	GB	0101000020E6100000D5AF743E3CEB05C0D2A92B9FE5254B40
82899	LD1	GB	0101000020E610000032384A5E9D030BC0DC4AAFCDC61E4A40
82900	LD1 5BB	GB	0101000020E610000028B8585183090BC0F8DD74CB0E1F4A40
82901	LD1 5BH	GB	0101000020E61000004AD3A0681E000BC09AE95E27F51F4A40
82902	LD1 5ES	GB	0101000020E61000001DAB949EE9050BC0B5DFDA89921E4A40
82903	LD1 5LG	GB	0101000020E6100000A777F17EDCFE0AC04BE9995E621E4A40
82904	LD1 5LT	GB	0101000020E6100000D95E0B7A6F0C0BC0D6E07D552E1E4A40
82905	LD1 5LU	GB	0101000020E61000000A850838840A0BC0CA32C4B12E1E4A40
82906	LD1 5NA	GB	0101000020E610000071E7C2482F0A0BC0EFC8586DFE1D4A40
82907	LD1 5NX	GB	0101000020E61000009F5BE84A040A0BC04BB1A371A81D4A40
82908	LD1 5PD	GB	0101000020E610000022A81ABD1AC00AC0A647533D991F4A40
82909	LD1 5PU	GB	0101000020E61000007FD93D7958080BC044F7AC6BB41C4A40
82910	LD1 5PY	GB	0101000020E61000008E20956247230BC063096B63EC1A4A40
82911	LD1 5RA	GB	0101000020E6100000DACA4BFE271F0BC09E961FB8CA1B4A40
82912	LD1 5SH	GB	0101000020E6100000711E4E603AED0AC0A7B228ECA21E4A40
82913	LD1 5TD	GB	0101000020E610000073F7393E5AFC09C0A7C98CB795244A40
82914	LD1 5TG	GB	0101000020E610000063F030ED9B1B0AC0DF1797AAB4254A40
82915	LD1 5UW	GB	0101000020E61000001D5723BBD2B209C015AC71361D2B4A40
82916	LD1 6AA	GB	0101000020E61000001AC05B2041110BC0FD4AE7C3B31E4A40
82917	LD1 6AP	GB	0101000020E6100000B62BF4C132160BC0F59F353FFE1E4A40
82918	LD1 6BL	GB	0101000020E6100000DCD9571EA4070BC0A69883A0A31F4A40
82919	LD1 6DY	GB	0101000020E6100000A583F57F0E330BC0AD3594DA8B204A40
82920	LD1 6HP	GB	0101000020E61000000ABFD4CF9B4A0BC0484F9143C41D4A40
82921	LD1 6RE	GB	0101000020E610000005F9D9C875930AC044FCC3961E234A40
82922	LD1 6RG	GB	0101000020E61000007EE4D6A4DB120BC03C9F01F566224A40
82923	LD2 3	GB	0101000020E61000007E384888F2450BC07C2AA73D25134A40
82924	LD2 3NU	GB	0101000020E610000073BB97FBE4A80BC0E71A66683C134A40
82925	LD2 3PX	GB	0101000020E6100000938E72309BC00AC0512D228AC9094A40
82926	LD2 3PY	GB	0101000020E6100000F148BC3C9D6B0BC055DAE21A9F154A40
82927	LD2 3RP	GB	0101000020E6100000ED478AC8B08A0BC004E44BA8E0164A40
82928	LD2 3SY	GB	0101000020E61000009A266C3F19430BC09A5DF75624144A40
82929	LD3 0DD	GB	0101000020E61000009012BBB6B7DB09C01AC05B2041FF4940
82930	LD3 0DH	GB	0101000020E61000008C82E0F1EDDD09C0EF1B5F7B66FF4940
82931	LD3 0HP	GB	0101000020E61000001077F52A32FA09C0F5F1D077B7004A40
82932	LD3 0PD	GB	0101000020E6100000336E6AA0F9DC09C0018750A566FF4940
82933	LD3 0RE	GB	0101000020E61000003EAF78EA91460AC0D449B6BA9CFE4940
82934	LD3 0SL	GB	0101000020E61000002331410DDFA209C02461DF4E22044A40
82935	LD3 0YP	GB	0101000020E61000003E25E7C41E3A0AC0CA6FD1C952054A40
82936	LD3 7BX	GB	0101000020E6100000DD5B9198A0C60AC01137A79201F64940
82937	LD3 7EQ	GB	0101000020E6100000A5D7666325660AC0164D672783F54940
82938	LD3 7PJ	GB	0101000020E61000006C5B94D920330AC0C6DCB5847CF64940
82939	LD3 7RT	GB	0101000020E6100000E57D1CCD91150BC01B4CC3F011F94940
82940	LD3 7SN	GB	0101000020E6100000F73B1405FAC40AC04FC939B187F84940
82941	LD3 7UG	GB	0101000020E61000009259BDC3ED100AC0AB08371955F84940
82942	LD3 7UH	GB	0101000020E6100000F111312592E809C03FE603029DF74940
82943	LD3 7UL	GB	0101000020E6100000645930F147D109C09624CFF57DFA4940
82944	LD3 8DP	GB	0101000020E61000007A1B9B1DA93E0BC0A14CA3C9C5F84940
82945	LD3 8LT	GB	0101000020E610000092E68F696D3A0BC0914259F8FAF64940
82946	LD3 9BQ	GB	0101000020E6100000DD5ED218ADA30BC0C173EFE192FF4940
82947	LD3 9HB	GB	0101000020E61000009CF86A47712E0BC0D8F2CAF5B6F94940
82948	LD3 9RR	GB	0101000020E61000004A0C022B87B60BC092239D8191FF4940
82949	LD3 9ST	GB	0101000020E610000065E42CEC69070BC0BB7B80EECBFB4940
82950	LD3 9UE	GB	0101000020E6100000DF35E84B6F3F0BC03A7AFCDEA6FD4940
82951	LD4 4AF	GB	0101000020E61000000E881057CE3E0CC0113AE8120E114A40
82952	LD4 4EE	GB	0101000020E61000000DFE7E315B720CC0C042E6CAA00E4A40
82953	LD5 4RP	GB	0101000020E610000069520ABABD040DC014200A664C0D4A40
82954	LD5 4RW	GB	0101000020E61000000B9755D80C100DC03694DA8B680D4A40
82955	LD5 4SL	GB	0101000020E61000007C65DEAAEB100DC090A0F831E60E4A40
82956	LD6 5HA	GB	0101000020E6100000B3D1393FC5310CC03FE603029D274A40
82957	LD6 5HN	GB	0101000020E61000009EB5DB2E34770BC0D7DD3CD521394A40
82958	LD6 5LU	GB	0101000020E610000092239D8191370EC00B60CAC0013F4A40
82959	LD6 5PD	GB	0101000020E61000004B732B84D51809C072874D64E6504A40
82960	LD7 1BT	GB	0101000020E61000001DAED51EF66208C066DCD440F32B4A40
82961	LD7 1DT	GB	0101000020E610000093C7D3F2035708C04A24D1CB282C4A40
82962	LD7 1EA	GB	0101000020E610000001BF4692205C08C05FD38382522C4A40
82963	LD7 1HS	GB	0101000020E61000004E42E90B21C708C0F78F85E8102E4A40
82964	LD7 1PN	GB	0101000020E61000005C8DEC4ACBC808C04510E7E1042E4A40
82965	LD7 1SY	GB	0101000020E61000007B319413ED4A09C02CD505BCCC2C4A40
82966	LD7 1TU	GB	0101000020E610000029ECA2E881EF08C0A8195245F1304A40
82967	LD8 2LT	GB	0101000020E61000003C670B08ADE707C04AEEB089CC244A40
82968	LD8 2NX	GB	0101000020E61000006956B60F792B08C0CCD4247843264A40
82969	LD8 2PB	GB	0101000020E6100000242A5437179F08C0D653ABAFAE224A40
82970	LD8 2SA	GB	0101000020E6100000BE16F4DE18A208C04F95EF1989204A40
82971	LD8 2SB	GB	0101000020E6100000357D76C075A508C0B32616F88A204A40
82972	LE1	GB	0101000020E61000003A07CF842609F2BF0246973787514A40
82973	LE1 1RE	GB	0101000020E6100000F04C68925812F2BFA2D5C9198A514A40
82974	LE1 3BH	GB	0101000020E6100000FDBB3E73D627F2BF9AD2FA5B02524A40
82975	LE1 4FY	GB	0101000020E61000003BC780ECF52EF2BF8E942D9276514A40
82976	LE1 5WW	GB	0101000020E6100000F52D73BA2C26F2BFB97020240B504A40
82977	LE1 6AS	GB	0101000020E61000002E5915E12623F2BFBB7F2C4487524A40
82978	LE1 6GF	GB	0101000020E6100000598AE42B8114F2BF134548DDCE504A40
82979	LE1 6TP	GB	0101000020E6100000D175E107E713F2BFFD101B2C9C504A40
82980	LE1 7DQ	GB	0101000020E6100000C05FCC96AC0AF2BFA8E2C62DE64F4A40
82981	LE1 7QR	GB	0101000020E61000007C43E1B375F0F1BF93E1783E03504A40
82982	LE1 7RH	GB	0101000020E6100000772E8CF4A2F6F1BF427BF5F1D04F4A40
82983	LE1 9BH	GB	0101000020E610000012143FC6DC35F2BFA75B76887F504A40
82984	LE10	GB	0101000020E6100000DB4DF04DD327F6BF1F2BF86D88454A40
82985	LE10 0BU	GB	0101000020E6100000BCCFF1D1E20CF6BFFB3E1C2444454A40
82986	LE10 0JS	GB	0101000020E610000042E8A04B3834F6BF880D164ED2444A40
82987	LE10 0PW	GB	0101000020E6100000863B17467A11F6BF535E2BA1BB444A40
82988	LE10 0TW	GB	0101000020E61000006500A8E2C6EDF5BF2BFC19DEAC454A40
82989	LE10 1AB	GB	0101000020E6100000F819170E84E4F5BFEBE5779ACC444A40
82990	LE10 1DT	GB	0101000020E61000009A93179980DFF5BF936FB6B931454A40
82991	LE10 1LD	GB	0101000020E610000073124A5F08B9F5BFC746205ED7454A40
82992	LE10 1LF	GB	0101000020E6100000FD1186014BEEF5BF2EE3A6069A454A40
82993	LE10 1SW	GB	0101000020E610000074F04C6892D8F5BF871744A4A6474A40
82994	LE10 1UE	GB	0101000020E61000009B215514AFF2F5BF36CB65A373444A40
82995	LE10 2AS	GB	0101000020E61000007289230F4496F5BF13F4177AC4444A40
82996	LE10 2ND	GB	0101000020E61000006D718DCF64BFF5BF8639419B1C444A40
82997	LE10 2NR	GB	0101000020E6100000CD7344BE4BE9F5BF1EC2F869DC434A40
82998	LE10 2SW	GB	0101000020E6100000F0164850FCD8F5BF755B22179C434A40
82999	LE10 2TG	GB	0101000020E61000008CA37213B5F4F5BFDE73603942444A40
83000	LE10 3HW	GB	0101000020E6100000C0CDE2C5C2D0F5BFD540F339773F4A40
83001	LE10 3JA	GB	0101000020E61000009B030473F4B8F5BF18D1764CDD414A40
83002	LE10 3LB	GB	0101000020E61000004FCE50DCF1E6F5BF2B51F696723E4A40
83003	LE10 3LG	GB	0101000020E61000009A27D714C8ECF5BF14234BE6583E4A40
83004	LE10 3PP	GB	0101000020E6100000A514747B49A3F4BFFC6D4F90D8424A40
83005	LE11	GB	0101000020E61000006762BA10ABBFF3BF6687F8872D634A40
83006	LE11 0DE	GB	0101000020E61000006B6116DA398DF3BF4DA088450C634A40
83007	LE11 0XH	GB	0101000020E610000019E76F422142F3BFDD955D30B8624A40
83008	LE11 1EE	GB	0101000020E6100000AFEDED96E440F3BF61FE0A992B634A40
83009	LE11 1EP	GB	0101000020E6100000FAD51C209823F3BF452FA3586E634A40
83010	LE11 1JP	GB	0101000020E6100000FA264D83A239F3BFE9BAF083F3634A40
83011	LE11 1LD	GB	0101000020E61000008D2782380F27F3BFC4B2994352634A40
83012	LE11 1LQ	GB	0101000020E6100000A98768740731F3BF255CC823B8634A40
83013	LE11 1PR	GB	0101000020E61000000FD6FF39CC17F3BF14967840D9624A40
83014	LE11 1PZ	GB	0101000020E61000000E828E56B564F3BF5BD2510E66634A40
83015	LE11 1RW	GB	0101000020E61000007670B0373124F3BF6A87BF266B624A40
83016	LE11 1SD	GB	0101000020E61000003674B33F502EF3BFD6C8AEB48C624A40
83017	LE11 2AU	GB	0101000020E61000003605323B8B1EF3BF09A69A594B614A40
83018	LE11 2BG	GB	0101000020E6100000BA4C4D823764F3BF8FDE701FB9614A40
83019	LE11 2BQ	GB	0101000020E6100000CC0BB08F4E5DF3BF94DBF63DEA614A40
83020	LE11 2BY	GB	0101000020E610000008C72C7B1258F3BFC87E164B91624A40
83021	LE11 2HF	GB	0101000020E6100000D2FC31AD4D63F3BF105839B4C8604A40
83022	LE11 2LJ	GB	0101000020E6100000FEEE1D352644F3BF575BB1BFEC604A40
83023	LE11 2NH	GB	0101000020E61000009605137F1435F3BFCBBBEA01F3604A40
83024	LE11 2PN	GB	0101000020E6100000904AB1A371E8F2BFBA9F53909F614A40
83025	LE11 2SA	GB	0101000020E6100000EF3CF19C2D60F3BFA7E7DD5850604A40
83026	LE11 2SJ	GB	0101000020E610000060217365506DF3BFF69B89E942604A40
83027	LE11 2UA	GB	0101000020E6100000A41B61511167F3BF8AE8D7D64F5F4A40
83028	LE11 3BT	GB	0101000020E6100000E55E60562892F3BF2AE3DF675C604A40
83029	LE11 3EH	GB	0101000020E6100000D1402C9B39A4F3BFF6B3588AE4614A40
83030	LE11 3JF	GB	0101000020E6100000FFE89B340D8AF3BF317898F6CD614A40
83031	LE11 3JS	GB	0101000020E6100000179AEB34D292F3BFCDC98B4CC0614A40
83032	LE11 3JX	GB	0101000020E610000029780AB952CFF3BFFF428F183D614A40
83033	LE11 3LR	GB	0101000020E6100000BC581822A72FF3BFBD3AC780EC614A40
83034	LE11 3NY	GB	0101000020E610000025068195434BF3BFA5DB12B9E0624A40
83035	LE11 3PN	GB	0101000020E610000094BE1072DE7FF3BF598AE42B81604A40
83036	LE11 3PW	GB	0101000020E610000072E0D57267A6F3BFC79BFC169D604A40
83037	LE11 3SE	GB	0101000020E6100000A9BD88B663EAF3BF7711A62897604A40
83038	LE11 3TU	GB	0101000020E610000072361D01DCACF3BF8B71FE2614624A40
83039	LE11 3UG	GB	0101000020E61000000BCF4BC5C63CF3BFBDE0D39CBC624A40
83040	LE11 4EU	GB	0101000020E61000005BCEA5B8AAECF3BF93FFC9DFBD614A40
83041	LE11 4FR	GB	0101000020E6100000028063CF9E0BF4BF2D060FD3BE634A40
83042	LE11 4JT	GB	0101000020E61000000ED8D5E4296BF3BFBDE5EAC726634A40
83043	LE11 4PQ	GB	0101000020E6100000C85EEFFE78EFF3BFCD3D247CEF614A40
83044	LE11 4QH	GB	0101000020E610000072FDBB3E73D6F3BFCD936B0A64624A40
83045	LE11 4QT	GB	0101000020E610000087C267EBE0E0F3BFDDEC0F94DB624A40
83046	LE11 4SE	GB	0101000020E610000034D769A4A5F2F3BFE882FA9639634A40
83047	LE11 4TB	GB	0101000020E6100000A30227DBC0DDF3BF40321D3A3D634A40
83048	LE11 5DG	GB	0101000020E6100000384A5E9D6380F3BF6C04E275FD624A40
83049	LE11 5DT	GB	0101000020E61000008F537424977FF3BF98BED7101C634A40
83050	LE11 5EG	GB	0101000020E610000043209738F280F3BFCFDBD8EC48634A40
83051	LE11 5FB	GB	0101000020E6100000871744A4A6DDF3BF9E094D124B644A40
83052	LE11 5UF	GB	0101000020E6100000A6D1E4620C6CF3BF842C0B26FE644A40
83053	LE11 5YY	GB	0101000020E61000001763601DC7CFF3BF42B5C189E8634A40
83054	LE12	GB	0101000020E6100000AC39403047CFF2BFCB811E6ADB6A4A40
83055	LE12 5AN	GB	0101000020E6100000D4EE5701BE1BF2BF0C79043752644A40
83056	LE12 5DB	GB	0101000020E6100000AF25E4839E8DF4BF79AC1919E4664A40
83057	LE12 5HS	GB	0101000020E6100000D8BB3FDEAB16F4BF8D0E48C2BE654A40
83058	LE12 5JH	GB	0101000020E6100000C39CA04D0E1FF4BF5C9198A086654A40
83059	LE12 5PA	GB	0101000020E61000000CE9F010C60FF4BFB6F3FDD478694A40
83060	LE12 5RD	GB	0101000020E61000008C683BA6EE0AF4BFB3614D65516A4A40
83061	LE12 6HJ	GB	0101000020E6100000E8F86871C6F0F2BF76A73B4F3C6B4A40
83062	LE12 6NX	GB	0101000020E61000002CB81FF0C000F3BF71917BBABA694A40
83063	LE12 6PW	GB	0101000020E61000004E0E9F742201F3BF12F8C3CF7F694A40
83064	LE12 6QL	GB	0101000020E6100000642310AFEBD7F2BFADBEBA2A506B4A40
83065	LE12 6QR	GB	0101000020E61000001D56B8E52329F3BFD68C0C7217634A40
83066	LE12 6SD	GB	0101000020E61000003C69E1B20A1BF1BF841266DAFE654A40
83067	LE12 6SS	GB	0101000020E6100000617138F3ABF9F0BFE603029D49694A40
83068	LE12 6SZ	GB	0101000020E6100000A38FF98040E7F0BF04AF963B33694A40
83069	LE12 6TE	GB	0101000020E61000007B67B45549E4F0BFEE5C18E945694A40
83070	LE12 7AF	GB	0101000020E610000030664B564538F2BF51DA1B7C615E4A40
83071	LE12 7BS	GB	0101000020E6100000AF4335255947F2BF9AD2FA5B025C4A40
83072	LE12 7DL	GB	0101000020E61000008E40BCAE5F30F2BF3387A4164A5C4A40
83073	LE12 7DU	GB	0101000020E6100000AAD6C22CB433F2BFDFFE5C34645C4A40
83074	LE12 7EF	GB	0101000020E6100000C16ED8B628B3F1BF3E7782FDD75D4A40
83075	LE12 7EN	GB	0101000020E6100000B6662B2FF95FF2BFC896E5EB325C4A40
83076	LE12 7EW	GB	0101000020E6100000286211C30E63F2BFFE7E315BB25C4A40
83077	LE12 7FR	GB	0101000020E6100000ABCFD556EC2FF2BFB37C5D86FF5C4A40
83078	LE12 7RN	GB	0101000020E6100000EEEA556474C0F1BF6B60AB048B5D4A40
83079	LE12 7RU	GB	0101000020E61000007D5BB05417B0F1BF2578431A155E4A40
83080	LE12 7SG	GB	0101000020E6100000CBF5B6990AB1F1BFC042E6CAA05C4A40
83081	LE12 7SX	GB	0101000020E61000009DD843FB58C1F1BF088ECBB8A95D4A40
83082	LE12 7TE	GB	0101000020E6100000533C2EAA45C4F1BFB7CF2A33A55D4A40
83083	LE12 8DX	GB	0101000020E6100000849D62D520CCF2BF8E942D92765F4A40
83084	LE12 8EY	GB	0101000020E6100000DAE731CA33AFF2BF4E0E9F74225F4A40
83085	LE12 8FB	GB	0101000020E6100000C4D0EAE40C45F2BFB7291E17D5604A40
83086	LE12 8HD	GB	0101000020E610000042D13C8045BEF2BF1157CEDE195F4A40
83087	LE12 8HP	GB	0101000020E6100000CAE1934E2458F2BF46EC134031604A40
83088	LE12 8PL	GB	0101000020E6100000273108AC1C5AF2BFB742588D25604A40
83089	LE12 8PN	GB	0101000020E61000006F1283C0CA61F2BF4CE3175E49604A40
83090	LE12 8RD	GB	0101000020E61000008198840B7984F3BF00E2AE5E455C4A40
83091	LE12 8SS	GB	0101000020E6100000CC41D0D1AA56F3BFD53F8864C85B4A40
83092	LE12 8US	GB	0101000020E610000066118AADA069F2BF7EC9C6832D604A40
83093	LE12 9DT	GB	0101000020E61000003106D671FC90F4BF58E2016553624A40
83094	LE12 9LS	GB	0101000020E6100000126A865451BCF4BF22718FA50F634A40
83095	LE12 9NX	GB	0101000020E610000056D636C5E3A2F4BF7EAB75E272624A40
83096	LE12 9PD	GB	0101000020E6100000DE3EABCC9496F4BF664E97C5C4624A40
83097	LE12 9PL	GB	0101000020E6100000F25EB532E1D7F4BF209738F240644A40
83098	LE12 9RY	GB	0101000020E6100000331AF9BCE2A9F4BF28452BF702634A40
83099	LE12 9SN	GB	0101000020E610000053CA6B257497F4BF14CD0358E4634A40
83100	LE12 9SR	GB	0101000020E6100000A053909F8DDCF5BF22AB5B3D27634A40
83101	LE12 9TY	GB	0101000020E61000008E5C37A5BC56F5BFD0D2156C23644A40
83102	LE13	GB	0101000020E610000008AD872F1345ECBF4B1FBAA0BE614A40
83103	LE13 0	GB	0101000020E6100000F6B704E09F52ECBF3046240A2D614A40
83104	LE13 0AN	GB	0101000020E6100000BF2A172AFF5AECBFC6A70018CF604A40
83105	LE13 0SS	GB	0101000020E6100000FCA886FD9ED8ECBFFE2AC0779B634A40
83106	LE13 0SZ	GB	0101000020E610000088B9A46ABB09EDBF87A8C29FE1634A40
83107	LE13 1AF	GB	0101000020E6100000C8258E3C1059ECBFA86F99D365614A40
83108	LE13 1DJ	GB	0101000020E61000001FA166481545ECBF2E8D5F7825614A40
83109	LE13 1JX	GB	0101000020E61000001CB1169F0260ECBF29E78BBD17634A40
83110	LE13 1PB	GB	0101000020E610000046B3B27DC8DBEBBF39D384ED27634A40
83111	LE13 1TE	GB	0101000020E61000005A9D9CA1B863ECBFE02BBAF59A624A40
83112	LE14 2QT	GB	0101000020E610000077BB5E9A22C0EABF7AE063B0E2584A40
83113	LE14 2UR	GB	0101000020E6100000BCEB6CC83FB3EBBF3D27BD6F7C5F4A40
83114	LE14 3BL	GB	0101000020E61000002C29779FE3A3EFBFF60A0BEE076A4A40
83115	LE14 3DD	GB	0101000020E6100000ED612F14B09DEFBFE90E62670A654A40
83116	LE14 3HP	GB	0101000020E610000040C1C58A1ACCEDBF0454388254664A40
83117	LE14 3LX	GB	0101000020E6100000CF83BBB3765BF0BF50E1085229684A40
83118	LE14 3QE	GB	0101000020E610000072FDBB3E7356EFBF6DC5FEB27B684A40
83119	LE14 3QX	GB	0101000020E61000004A7EC4AF58C3EDBFA6B4FE9600624A40
83120	LE14 3SJ	GB	0101000020E610000043C5387F130AEEBF1B834E081D624A40
83121	LE14 3TY	GB	0101000020E6100000B4C876BE9F9AEEBF58AA0B7899614A40
83122	LE14 3YG	GB	0101000020E61000000BEF7211DF89EEBF147651F4C0614A40
83123	LE14 4AH	GB	0101000020E6100000C991CEC0C8CBE9BF2F89B3226A684A40
83124	LE14 4QW	GB	0101000020E6100000AE47E17A14AEE7BF7A51BB5F056A4A40
83125	LE15	GB	0101000020E6100000C408E1D1C611E8BF2C4833164D594A40
83126	LE15 6	GB	0101000020E610000052103CBEBD6BE7BFB341261939554A40
83127	LE15 6AF	GB	0101000020E6100000713C9F01F566E7BF8B89CDC7B5554A40
83128	LE15 6GD	GB	0101000020E6100000E01115AA9B0BE7BFAA2D7590D7554A40
83129	LE15 6HF	GB	0101000020E61000006092CA147390E7BF6D73637AC2544A40
83130	LE15 6JG	GB	0101000020E6100000EE409DF2E846E7BF6B6116DA39554A40
83131	LE15 6JQ	GB	0101000020E610000014B01D8CD8A7E6BF810A47904A554A40
83132	LE15 6JS	GB	0101000020E6100000B6F63E558586E7BF8FAB915D69554A40
83133	LE15 6LN	GB	0101000020E6100000228E75711B8DE7BF707A17EFC7554A40
83134	LE15 6NU	GB	0101000020E610000012BC218D0A9CE7BFE7C75F5AD4554A40
83135	LE15 6QT	GB	0101000020E6100000EAE74D452A8CE7BF61C1FD8007564A40
83136	LE15 6RT	GB	0101000020E61000002766BD18CA89E7BFD74B530438554A40
83137	LE15 7ES	GB	0101000020E6100000F2B6D26BB3B1E8BF11548D5E0D5C4A40
83138	LE15 7FD	GB	0101000020E610000005BF0D315EF3E7BF57ED9A90D6564A40
83139	LE15 7PL	GB	0101000020E61000002BDCF29194F4E5BF06D9B27C5D5E4A40
83140	LE15 7PZ	GB	0101000020E610000075ABE7A4F70DE7BFA0DCB6EF515B4A40
83141	LE15 8	GB	0101000020E61000005C902DCBD7E5E6BFD3DC0A6135524A40
83142	LE15 8AT	GB	0101000020E610000007EBFF1CE64BE4BF098CF50D4C584A40
83143	LE15 8HY	GB	0101000020E610000074ED0BE885BBE3BF6DC83F3388514A40
83144	LE15 8QT	GB	0101000020E61000000DFCA886FD9EE8BF31B3CF6394534A40
83145	LE15 9AU	GB	0101000020E610000022FAB5F5D3FFE7BFBF0D315EF34E4A40
83146	LE15 9BP	GB	0101000020E6100000C03FA54A94BDE5BF3F8D7BF31B4C4A40
83147	LE15 9DL	GB	0101000020E61000002009FB761291E4BF83A44FABE84B4A40
83148	LE15 9EJ	GB	0101000020E61000008A05BEA25B2FE6BF4A61DEE34C4B4A40
83149	LE15 9LB	GB	0101000020E61000003A0664AF777FE9BF84B70721204D4A40
83150	LE15 9QB	GB	0101000020E61000006002B7EEE629E7BFBAA0BE654E4B4A40
83151	LE15 9QH	GB	0101000020E610000009A87004A914E7BFBD70E7C2484B4A40
83152	LE16	GB	0101000020E610000002BB9A3C65B5EDBF20B41EBE4C3E4A40
83153	LE16 7DD	GB	0101000020E610000024F25D4A5D32EDBFB60E0EF6263E4A40
83154	LE16 7DF	GB	0101000020E6100000FB1F60ADDA35ECBF9E0C8E92573D4A40
83155	LE16 7DT	GB	0101000020E6100000A59F70766B19EDBF36E50AEF723D4A40
83156	LE16 7HJ	GB	0101000020E61000000186E5CFB705EDBF31B77BB94F3E4A40
83157	LE16 7TA	GB	0101000020E610000028486C770FD0EDBF9CC58B8521444A40
83158	LE16 8AL	GB	0101000020E6100000419B1C3EE944EDBFF7C77BD5CA3C4A40
83159	LE16 8AW	GB	0101000020E610000088F71C588E10EABFD927806264414A40
83160	LE16 8DE	GB	0101000020E61000007E5182FE420FEABF967B8159A1464A40
83161	LE16 8ED	GB	0101000020E61000001A4D2EC6C03AEABF33C170AE61444A40
83162	LE16 8PH	GB	0101000020E61000009813B4C9E193EBBF685DA3E5403D4A40
83163	LE16 8PQ	GB	0101000020E61000004128EFE3688EEBBFBDAB1E300F3D4A40
83164	LE16 8SH	GB	0101000020E6100000CA8AE1EA0008E8BFB30C71AC8B434A40
83165	LE16 8TH	GB	0101000020E6100000FD1186014B2EE7BF63416150A6414A40
83166	LE16 8XL	GB	0101000020E61000004DBF44BC757EE8BFA393A5D6FB3F4A40
83167	LE16 9BZ	GB	0101000020E6100000A626C11BD2A8EDBF145B41D3123D4A40
83168	LE16 9DG	GB	0101000020E6100000187B2FBE680FEEBFE10D6954E03C4A40
83169	LE16 9NF	GB	0101000020E6100000E1D39CBCC884EDBFDBDE6E490E3C4A40
83170	LE16 9PQ	GB	0101000020E610000077137CD3F459EDBF037AE1CE853D4A40
83171	LE16 9SJ	GB	0101000020E61000008E1F2A8D9859EEBF4C6E14596B3A4A40
83172	LE17	GB	0101000020E6100000FBCBEEC9C382F1BF11001C7BF6384A40
83173	LE17 4LD	GB	0101000020E61000005A63D009A143F3BFEAAF5758703B4A40
83174	LE17 4PU	GB	0101000020E6100000E4D9E55B1F56F3BFAED85F764F3A4A40
83175	LE17 4QF	GB	0101000020E6100000B7B6F0BC546CF3BFCBA0DAE0443A4A40
83176	LE17 4XF	GB	0101000020E6100000ECC1A4F8F844F3BFBA9F53909F3B4A40
83177	LE17 5BA	GB	0101000020E6100000C3802557B1F8F4BF2A38BC20223F4A40
83178	LE17 5HY	GB	0101000020E6100000DFFAB0DEA895F3BFC0EAC891CE3E4A40
83179	LE17 5JJ	GB	0101000020E6100000D1402C9B3924F3BFDCDAC2F352414A40
83180	LE17 5JL	GB	0101000020E6100000C504357C0B2BF3BF069CA56439414A40
83181	LE17 5LG	GB	0101000020E6100000B64AB0389CF9F2BFD84AE82E89414A40
83182	LE17 5PU	GB	0101000020E6100000B8CD54884722F2BF74435376FA3F4A40
83183	LE17 6AJ	GB	0101000020E61000000A664CC11A27F2BF583B8A73D4394A40
83184	LE17 6BS	GB	0101000020E61000002DAF5C6F9BA9F2BF639CBF0985344A40
83185	LE17 6BW	GB	0101000020E61000005930F14751A7F2BF58E2016553344A40
83186	LE17 6ET	GB	0101000020E61000008509A359D97EF1BF8E5BCCCF0D394A40
83187	LE17 6LF	GB	0101000020E6100000778192020BE0F0BF37C64E78093A4A40
83188	LE17 6NY	GB	0101000020E61000004910AE8042BDF0BFF73FC05AB53F4A40
83189	LE17 6PH	GB	0101000020E61000008AAC3594DA4BF1BFF6B4C35F93414A40
83190	LE17 6PP	GB	0101000020E610000033198EE73360F1BFCE177B2FBE404A40
83191	LE18	GB	0101000020E610000004AE2B6684B7F1BFA323B9FC874A4A40
83192	LE18 1DR	GB	0101000020E61000002A1900AAB8B1F1BF32E884D0414B4A40
83193	LE18 1JP	GB	0101000020E610000045F0BF95ECD8F1BF4BB0389CF94B4A40
83194	LE18 1NN	GB	0101000020E610000091990B5C1EABF1BF2849D74CBE4B4A40
83195	LE18 2BE	GB	0101000020E61000001250E10852E9F1BFB32616F88A4A4A40
83196	LE18 2BN	GB	0101000020E6100000ABED26F8A6E9F1BFAB92C83EC84A4A40
83197	LE18 3QA	GB	0101000020E6100000533D997FF48DF1BF3750E09D7C4A4A40
83198	LE18 3QD	GB	0101000020E6100000BFB513252191F1BF01DA56B3CE4A4A40
83199	LE18 3QL	GB	0101000020E6100000F8C610001C7BF1BF392861A6ED4B4A40
83200	LE18 3RN	GB	0101000020E61000007F129F3BC17EF1BFD87E32C6874B4A40
83201	LE18 3TD	GB	0101000020E6100000292499D53B5CF1BF25766D6FB7464A40
83202	LE18 3XW	GB	0101000020E6100000116E32AA0C23F1BFEAE923F0874F4A40
83203	LE18 4XU	GB	0101000020E61000005BB56B425A23F2BFBEA085048C4A4A40
83204	LE19 2RN	GB	0101000020E610000097C5C4E6E31AF3BF423EE8D9AC4A4A40
83205	LE19 3FA	GB	0101000020E61000005725917D9065F3BFEACC3D247C494A40
83206	LE19 3LY	GB	0101000020E6100000D87DC7F0D84FF3BF3B1DC87A6A494A40
83207	LE19 3SZ	GB	0101000020E61000005116BEBED665F3BFB5A338471D4B4A40
83208	LE19 4NS	GB	0101000020E610000022DE3AFF7659F3BF3B8C497F2F4B4A40
83209	LE19 4NW	GB	0101000020E6100000B136C64E7849F3BF753FA7203F4B4A40
83210	LE19 4SA	GB	0101000020E6100000EBC4E5780562F3BF7B336ABE4A4C4A40
83211	LE19 5FN	GB	0101000020E6100000C5C892399677F3BF263ACB2C42494A40
83212	LE2	GB	0101000020E61000003927F6D03E56F2BFC39FE1CD1A5A4A40
83213	LE2 0GF	GB	0101000020E6100000D1CE69166877F1BF333674B33F524A40
83214	LE2 0JA	GB	0101000020E61000000A9E42AED4F3F1BF92CEC0C8CB504A40
83215	LE2 0ND	GB	0101000020E6100000B77F65A549E9F1BF1F4B1FBAA0504A40
83216	LE2 0QB	GB	0101000020E610000082C7B7770DFAF1BFE883656CE8504A40
83217	LE2 1DH	GB	0101000020E6100000BD35B05582C5F1BF051901158E504A40
83218	LE2 1FX	GB	0101000020E6100000DFF8DA334BC2F1BF2ECA6C9049504A40
83219	LE2 1HR	GB	0101000020E6100000A3E9EC6470D4F1BF7B4B395FEC4F4A40
83220	LE2 1NP	GB	0101000020E6100000BFBA2A508BC1F1BFCBD58F4DF24F4A40
83221	LE2 1TN	GB	0101000020E610000084D6C39789E2F1BF2592E865144F4A40
83222	LE2 1XB	GB	0101000020E6100000603E59315CDDF1BFF2B0506B9A4F4A40
83223	LE2 1YD	GB	0101000020E610000035B22B2D23F5F1BFA9D903ADC04E4A40
83224	LE2 2FB	GB	0101000020E6100000BF4351A04F24F1BF815EB873614E4A40
83225	LE2 2PA	GB	0101000020E61000006825ADF88682F1BF6F8099EFE04D4A40
83226	LE2 3AJ	GB	0101000020E610000011018750A5E6F1BF1AFCFD62B64E4A40
83227	LE2 3DP	GB	0101000020E6100000FA449E245DF3F1BFA6272CF1804E4A40
83228	LE2 3FA	GB	0101000020E6100000EF1AF4A5B77FF1BF2E3A596ABD4D4A40
83229	LE2 3GD	GB	0101000020E61000002FC1A90F24EFF1BFF8544E7B4A4E4A40
83230	LE2 3JU	GB	0101000020E61000005E6919A9F794F1BF850662D9CC4D4A40
83231	LE2 3LS	GB	0101000020E6100000365B79C9FFA4F1BF27F8A6E9B34D4A40
83232	LE2 3TD	GB	0101000020E6100000E0BA624678BBF1BF145E82531F4E4A40
83233	LE2 3WE	GB	0101000020E6100000145AD6FD63E1F1BFAE8218E8DA4D4A40
83234	LE2 3YB	GB	0101000020E610000068EA758BC0D8F1BFF6D37FD6FC4C4A40
83235	LE2 4FH	GB	0101000020E6100000548D5E0D501AF1BFD80C7041B64C4A40
83236	LE2 4RX	GB	0101000020E610000037DE1D19ABCDF0BFA25EF0694E4C4A40
83237	LE2 4TX	GB	0101000020E61000006649809A5AF6F0BF09371955864B4A40
83238	LE2 5GL	GB	0101000020E610000027A1F4859073F1BF596B28B5174D4A40
83239	LE2 5PP	GB	0101000020E61000003CBCE7C07244F1BF758E01D9EB4B4A40
83240	LE2 5UF	GB	0101000020E6100000C5E74EB0FF3AF1BFA7AFE76B964B4A40
83241	LE2 5WB	GB	0101000020E61000007192E68F692DF1BF9A22C0E95D4C4A40
83242	LE2 6HN	GB	0101000020E6100000DD9733DB15FAF1BF986DA7AD114D4A40
83243	LE2 6SG	GB	0101000020E6100000C5C72764E72DF2BF3049658A394C4A40
83244	LE2 7JE	GB	0101000020E6100000A471A8DF852DF2BF1EDFDE35E84F4A40
83245	LE2 7ND	GB	0101000020E6100000263ACB2C4231F2BF601DC70F954E4A40
83246	LE2 7NH	GB	0101000020E61000005358A9A0A22AF2BFA4E36A64574E4A40
83247	LE2 8AW	GB	0101000020E6100000DC10E335AF2AF2BFF51263997E4D4A40
83248	LE2 8AX	GB	0101000020E610000071CB4752D243F2BFDD5CFC6D4F4E4A40
83249	LE2 8HU	GB	0101000020E6100000EC6987BF266BF2BFF46A80D2504D4A40
83250	LE2 8ND	GB	0101000020E610000042075DC2A177F2BF3F8F519E794D4A40
83251	LE2 8SG	GB	0101000020E610000072FA7ABE6679F2BF59E02BBAF54C4A40
83252	LE2 9JZ	GB	0101000020E6100000B988EFC4ACD7F1BFEB01F390294D4A40
83253	LE3 0PE	GB	0101000020E6100000438CD7BCAA73F2BFD34B8C65FA4F4A40
83254	LE3 0PG	GB	0101000020E61000001BF16437337AF2BF228AC91B60504A40
83255	LE3 0QS	GB	0101000020E61000005AD5928E7270F2BF488787307E504A40
83256	LE3 0RD	GB	0101000020E610000012876C205D6CF2BF5721E527D5504A40
83257	LE3 0TF	GB	0101000020E61000009C6A2DCC427BF2BF465ED6C402514A40
83258	LE3 0UD	GB	0101000020E6100000B519A721AAB0F2BF651A4D2EC6504A40
83259	LE3 0WA	GB	0101000020E6100000B81FF0C000C2F2BFC8CEDBD8EC504A40
83260	LE3 1AP	GB	0101000020E610000029B4ACFBC782F2BF3735D07CCE4F4A40
83261	LE3 1AS	GB	0101000020E61000008255F5F23BCDF2BF94F8DC09F64F4A40
83262	LE3 1DG	GB	0101000020E6100000B79BE09BA68FF2BFC8D3F203574F4A40
83263	LE3 1GB	GB	0101000020E61000005AF3E32F2DAAF2BF1B649291B34E4A40
83264	LE3 1LD	GB	0101000020E6100000D3BF249529A6F2BF47CA1649BB4F4A40
83265	LE3 1UF	GB	0101000020E6100000282D5C5661F3F2BF266F8099EF504A40
83266	LE3 1UT	GB	0101000020E6100000B9DE3653215EF3BF23A46E675F514A40
83267	LE3 2AB	GB	0101000020E61000005BECF6596566F2BFF7CB272B864F4A40
83268	LE3 2AE	GB	0101000020E6100000B2A19BFD8172F2BFDB4E5B23824F4A40
83269	LE3 2BA	GB	0101000020E610000024D5777E5182F2BFB4E4F1B4FC4E4A40
83270	LE3 2DZ	GB	0101000020E6100000336DFFCA4A93F2BF53B131AF234E4A40
83271	LE3 2GB	GB	0101000020E61000009E44847F11B4F2BF96CD1C925A4E4A40
83272	LE3 2GH	GB	0101000020E61000000EA320787CBBF2BF663387A4164E4A40
83273	LE3 2GJ	GB	0101000020E6100000855FEAE74DC5F2BF8C868C47A94E4A40
83274	LE3 2RW	GB	0101000020E6100000259529E62028F2BFF6B6990AF14C4A40
83275	LE3 2UB	GB	0101000020E6100000404B57B08DF8F2BF3EB14E95EF4D4A40
83276	LE3 3DH	GB	0101000020E6100000008BFCFA2136F3BF613596B036504A40
83277	LE3 3FE	GB	0101000020E6100000D45FAFB0E03EF3BFFD86890629504A40
83278	LE3 3FF	GB	0101000020E61000007C45B75ED343F3BF21E9D32AFA4F4A40
83279	LE3 3FP	GB	0101000020E61000002F4E7CB5A338F3BF1C615111A74F4A40
83280	LE3 3GL	GB	0101000020E610000005FBAF73D3A6F3BF9C189293894F4A40
83281	LE3 3PA	GB	0101000020E6100000560C5707405CF3BFA1BE654E974F4A40
83282	LE3 3QF	GB	0101000020E6100000E3DEFC868946F3BF8A027D224F504A40
83283	LE3 6BG	GB	0101000020E6100000A510C8258E7CF2BF126745D444514A40
83284	LE3 8	GB	0101000020E610000055DCB8C5FC1CF3BF7DEBC37AA3524A40
83285	LE3 8GS	GB	0101000020E6100000359BC761303FF3BF941799805F534A40
83286	LE3 8RA	GB	0101000020E61000002828452BF702F3BF1D0247020D544A40
83287	LE3 8RJ	GB	0101000020E610000065A6B4FE9600F3BF0F7EE200FA534A40
83288	LE3 8SU	GB	0101000020E6100000BC0512143FC6F2BFC28A53AD85534A40
83289	LE3 9AP	GB	0101000020E6100000234C512E8D5FF2BFFD3383F8C0524A40
83290	LE3 9AX	GB	0101000020E6100000AB23473A0363F2BFE2E47E87A2524A40
83291	LE3 9ED	GB	0101000020E6100000D34B8C65FA65F2BFC59107228B524A40
83292	LE3 9FA	GB	0101000020E6100000F20698F90EBEF2BF91D10149D8514A40
83293	LE3 9FB	GB	0101000020E6100000E76ED74B5384F2BF5D6C5A2904524A40
83294	LE3 9FR	GB	0101000020E6100000B020CD58341DF2BFDA3C0E83F9514A40
83295	LE3 9GE	GB	0101000020E6100000132C0E677EB5F2BF9ACDE33098514A40
83296	LE3 9PP	GB	0101000020E61000009CA8A5B91582F2BF40FA264D83524A40
83297	LE3 9PX	GB	0101000020E61000009CA8A5B915C2F2BFA9893E1F65524A40
83298	LE3 9QG	GB	0101000020E61000003067B62BF4C1F2BFDC48D92269534A40
83299	LE3 9TD	GB	0101000020E61000007ADE8D058581F2BF52F01472A5524A40
83300	LE4	GB	0101000020E6100000ED10FFB0A5C7F1BFAE2B6684B7554A40
83301	LE4 0HB	GB	0101000020E61000002F3196E99748F2BF6281AFE8D6534A40
83302	LE4 1AX	GB	0101000020E61000007D08AA46AFC6F2BFA680B4FF01564A40
83303	LE4 2BB	GB	0101000020E6100000D00A0C59DD2AF2BFB45549641F544A40
83304	LE4 3AP	GB	0101000020E610000093E52494BE10F2BF2C7FBE2D58564A40
83305	LE4 3DU	GB	0101000020E6100000DD7A4D0F0A0AF2BFBB09BE69FA564A40
83306	LE4 3GT	GB	0101000020E6100000C11E1329CD26F2BF6231EA5A7B574A40
83307	LE4 3JQ	GB	0101000020E61000003DD175E10727F2BF6D8FDE701F574A40
83308	LE4 4BJ	GB	0101000020E61000008DCF64FF3C0DF2BF902FA182C3554A40
83309	LE4 4DF	GB	0101000020E61000003A5AD5928EF2F1BF7F15E0BBCD554A40
83310	LE4 4FQ	GB	0101000020E6100000B75F3E5931DCF1BF1D774A07EB554A40
83311	LE4 5DF	GB	0101000020E61000002B172AFF5A1EF2BF84F1D3B837534A40
83312	LE4 5JW	GB	0101000020E610000046459C4EB295F1BFF9F4D89601574A40
83313	LE4 6FU	GB	0101000020E610000056D28A6F28BCF1BFE030D12005534A40
83314	LE4 6RL	GB	0101000020E6100000DC10E335AFAAF1BF54E6E61BD1534A40
83315	LE4 6SD	GB	0101000020E610000028452BF702B3F1BF594C6C3EAE534A40
83316	LE4 7YL	GB	0101000020E61000009D12109370A1F1BFFF05820019564A40
83317	LE4 8	GB	0101000020E610000015C78157CB9DF1BF3E4162BB7B564A40
83318	LE4 8BB	GB	0101000020E610000078B81D1A16A3F1BFFB0626378A564A40
83319	LE4 8DF	GB	0101000020E6100000EF1B5F7B6689F1BF83A279008B564A40
83320	LE4 9EP	GB	0101000020E61000002CA0504F1FC1F1BF9F8EC70C54544A40
83321	LE42 2GX	GB	0101000020E6100000D7A19A92AC43F2BF71AB2006BA544A40
83322	LE5	GB	0101000020E61000004DBED9E6C674F0BFC364AA6054544A40
83323	LE5 0ER	GB	0101000020E6100000849B8C2AC3B8F1BFE1606F6248524A40
83324	LE5 0FF	GB	0101000020E610000031B43A3943F1F1BF5E0F26C5C7514A40
83325	LE5 1UG	GB	0101000020E6100000C8409E5DBEF5F0BF12A1116C5C514A40
83326	LE5 2EJ	GB	0101000020E610000026C808A87084F1BF0327DBC01D504A40
83327	LE5 3GW	GB	0101000020E6100000F9653046240AF2BF3DF372D87D514A40
83328	LE5 4LX	GB	0101000020E61000004B77D7D990BFF0BF97AB1F9BE44F4A40
83329	LE5 4PW	GB	0101000020E6100000FFB1101D0247F1BFE960FD9FC3504A40
83330	LE5 4UJ	GB	0101000020E610000076FA415DA450F1BF5CAAD216D7504A40
83331	LE5 5EL	GB	0101000020E6100000529ACDE33058F1BF53CBD6FA22514A40
83332	LE5 5NU	GB	0101000020E61000001EDC9DB5DB6EF1BF49A0C1A6CE4F4A40
83333	LE5 5SE	GB	0101000020E610000001F9122A387CF1BF172AFF5A5E4F4A40
83334	LE5 5TY	GB	0101000020E61000006EA5D76663E5F0BFBE839F3880504A40
83335	LE5 6HL	GB	0101000020E6100000EEEC2B0FD213F1BF780DFAD2DB4F4A40
83336	LE5 6JF	GB	0101000020E61000008F386403E9E2F0BF5DE15D2EE24F4A40
83337	LE5 6PR	GB	0101000020E6100000FD6662BA10EBF0BFAB24B20FB2504A40
83338	LE5 6SG	GB	0101000020E6100000195586713708F1BFAD3594DA8B504A40
83339	LE5 6TE	GB	0101000020E6100000E04C4C176235F1BFCF4A5AF10D514A40
83340	LE5 6XB	GB	0101000020E6100000800C1D3BA884F1BFF7E5CC7685504A40
83341	LE6	GB	0101000020E6100000AA6395D233BDF3BF5470784144564A40
83342	LE6 0AE	GB	0101000020E6100000446FF1F09EC3F3BF2D23F59ECA574A40
83343	LE6 0FL	GB	0101000020E61000009DF4BEF1B5A7F3BF55850662D9544A40
83344	LE6 0GU	GB	0101000020E6100000331823128596F3BFD1E80E6267544A40
83345	LE6 0JJ	GB	0101000020E6100000EDD45C6E30D4F3BF075E2D7766524A40
83346	LE65	GB	0101000020E61000005F43705CC68DF7BF392861A6ED634A40
83347	LE65 1DQ	GB	0101000020E61000002D5E2C0C9153F7BFBF61A2410A604A40
83348	LE65 1DW	GB	0101000020E6100000F0A7C64B3749F7BF5680EF366F604A40
83349	LE65 1RW	GB	0101000020E6100000ECDD1FEF55EBF6BFB96FB54E5C644A40
83350	LE65 1TQ	GB	0101000020E61000001F84807C0955F7BF23F77475C75E4A40
83351	LE65 2JL	GB	0101000020E6100000DD7BB8E4B893F7BFD9B11188D75F4A40
83352	LE65 2LX	GB	0101000020E61000005871AAB530CBF7BFA0504F1F815F4A40
83353	LE67	GB	0101000020E6100000933A014D844DF5BFF513CE6E2D5D4A40
83354	LE67 1AE	GB	0101000020E6100000530438BD8BF7F4BF6478EC67B1544A40
83355	LE67 1FJ	GB	0101000020E610000039268BFB8FCCF5BFA5DAA7E331594A40
83356	LE67 1HP	GB	0101000020E6100000D6AA5D13D29AF5BFA7ECF483BA564A40
83357	LE67 2AS	GB	0101000020E61000007958A835CD7BF6BFF627F1B9135C4A40
83358	LE67 2FB	GB	0101000020E61000001EA4A7C82122F6BF5E126745D45A4A40
83359	LE67 2FP	GB	0101000020E61000002AE109BDFEE4F5BF459F8F32E25A4A40
83360	LE67 2RE	GB	0101000020E6100000EE5A423EE8D9F6BFFCA886FD9E584A40
83361	LE67 2XD	GB	0101000020E61000006F490ED8D524F6BF8DB800344A5B4A40
83362	LE67 3JB	GB	0101000020E6100000334FAE299059F5BF36AB3E575B5B4A40
83363	LE67 3QA	GB	0101000020E6100000CD237F30F05CF5BFC0B167CF655C4A40
83364	LE67 3SH	GB	0101000020E610000029931ADA00ECF5BF5262D7F6765B4A40
83365	LE67 4BJ	GB	0101000020E6100000651D8EAED29DF5BF76E09C11A55B4A40
83366	LE67 4DE	GB	0101000020E610000015C5ABAC6D8AF5BFC5CBD3B9A25C4A40
83367	LE67 4DU	GB	0101000020E61000006806F1811D7FF5BF1EE21FB6F45C4A40
83368	LE67 4GF	GB	0101000020E610000072DC291DAC7FF5BF7A8CF2CCCB5B4A40
83369	LE67 4SE	GB	0101000020E610000036AE7FD7674EF5BFF1660DDE575D4A40
83370	LE67 5DQ	GB	0101000020E61000006612F5824FF3F5BFD9E90775915E4A40
83371	LE67 5EG	GB	0101000020E6100000E2E5E95C51CAF5BFF9DA334B025E4A40
83372	LE67 5EU	GB	0101000020E6100000E5266A696EC5F5BF130D52F0145E4A40
83373	LE67 5PU	GB	0101000020E61000002AAA7EA5F3A1F5BF35B56CAD2F5E4A40
83374	LE67 6JG	GB	0101000020E610000027A5A0DB4B5AF6BF26E1421EC1574A40
83375	LE67 6JP	GB	0101000020E61000001D925A28995CF6BF268FA7E507584A40
83376	LE67 6JT	GB	0101000020E6100000D097DEFE5C74F6BFC4995FCD01584A40
83377	LE67 6LH	GB	0101000020E6100000AB048BC3995FF6BF3B8A73D4D1574A40
83378	LE67 6PP	GB	0101000020E6100000308331225168F6BF3D635FB2F1584A40
83379	LE67 8HT	GB	0101000020E610000070B378B13044F6BF247B849A21614A40
83380	LE67 8PH	GB	0101000020E61000004AEB6F09C07FF6BF91F2936A9F624A40
83381	LE67 8PP	GB	0101000020E610000062C092AB587CF6BFE9D500A5A1624A40
83382	LE67 9TW	GB	0101000020E6100000D00EB8AE98D1F4BF3752B648DA574A40
83383	LE67 9WB	GB	0101000020E6100000C4B12E6EA381F4BF67EDB60BCD574A40
83384	LE7	GB	0101000020E6100000AD69DE718A4EF2BFDB8AFD65F74E4A40
83385	LE7 1GX	GB	0101000020E6100000FA7B293C6836F1BF5A12A0A696594A40
83386	LE7 2HA	GB	0101000020E6100000EBE1CB441152F1BF93533BC3D4584A40
83387	LE7 3DN	GB	0101000020E6100000DF6C73637AC2F0BFBD732843555A4A40
83388	LE7 3WY	GB	0101000020E61000008CA19C6857E1F0BF90F46915FD5B4A40
83389	LE7 4UA	GB	0101000020E610000082AE7D01BDB0F0BF5E143DF0315E4A40
83390	LE7 4WF	GB	0101000020E6100000C6DE8B2FDA63EFBFF86F5E9CF85A4A40
83391	LE7 4YY	GB	0101000020E6100000417DCB9C2E8BF0BF12BF620D175D4A40
83392	LE7 7AY	GB	0101000020E61000009F02603C8306F3BF810706103E564A40
83393	LE7 7BF	GB	0101000020E6100000EB6F09C03FE5F2BFDEE68D93C2564A40
83394	LE7 7EB	GB	0101000020E61000000B43E4F4F5FCF2BF1CB1169F02564A40
83395	LE7 7FJ	GB	0101000020E6100000EE04FBAF7313F3BFFBE93F6B7E564A40
83396	LE7 7FZ	GB	0101000020E6100000137EA99F3715F3BFE19524CFF5554A40
83397	LE7 7GN	GB	0101000020E610000082FFAD64C7C6F2BFDA907F6610594A40
83398	LE7 7JQ	GB	0101000020E6100000A393A5D6FB8DF2BF2E04392861584A40
83399	LE7 7JS	GB	0101000020E6100000A04FE449D275F2BF027E8D2441584A40
83400	LE7 7ND	GB	0101000020E6100000F6436CB07052F2BF8DD0CFD4EB4E4A40
83401	LE7 7NF	GB	0101000020E610000000581D39D219F2BFE1CE85915E5A4A40
83402	LE7 7SF	GB	0101000020E6100000016E162F1686F2BF5B22179CC15B4A40
83403	LE7 9AE	GB	0101000020E6100000FB40F2CEA10CEEBFC91F0C3CF74E4A40
83404	LE7 9EG	GB	0101000020E6100000D503E621533EF0BFFB3A70CE884E4A40
83405	LE7 9GU	GB	0101000020E6100000A88B14CAC2D7EFBFA165DD3F16504A40
83406	LE7 9HJ	GB	0101000020E6100000DD7D8E8F16E7EFBF0A86730D33504A40
83407	LE7 9SG	GB	0101000020E6100000320400C79EBDF0BF2E3718EAB0524A40
83408	LE7 9WB	GB	0101000020E6100000467BBC900E0FECBF14967840D94C4A40
83409	LE7 9XF	GB	0101000020E6100000965E9B8D9518EBBFE3E313B2F34A4A40
83410	LE8	GB	0101000020E6100000A46DFC89CAC6F1BFEDF318E599474A40
83411	LE8 0HL	GB	0101000020E610000044DB31755776EFBFADF6B0170A464A40
83412	LE8 0LN	GB	0101000020E61000001615713AC9D6EFBF07B47405DB444A40
83413	LE8 0LQ	GB	0101000020E6100000CAF962EFC597EFBF62F4DC4257444A40
83414	LE8 0LR	GB	0101000020E61000003DB665C059CAEFBFDC7EF964C5444A40
83415	LE8 0NN	GB	0101000020E61000000A4B3CA06CCAEFBF635FB2F160454A40
83416	LE8 0PJ	GB	0101000020E6100000BF44BC75FE6DEEBF342BDB87BC454A40
83417	LE8 0QH	GB	0101000020E61000009B3A8F8AFF7BF0BF9BE7887C97424A40
83418	LE8 0QJ	GB	0101000020E610000035F0A31AF6FBEFBF1669E21DE0434A40
83419	LE8 3HE	GB	0101000020E61000006F83DA6FED84F2BFD06394675E484A40
83420	LE8 4BF	GB	0101000020E6100000D6ABC8E880A4F2BF4D49D6E1E8484A40
83421	LE8 4FE	GB	0101000020E610000055849B8C2A83F2BF1C40BFEFDF484A40
83422	LE8 5PR	GB	0101000020E61000007EE36BCF2C89F2BF7CB60E0EF6464A40
83423	LE8 5PX	GB	0101000020E61000005B069CA56439F2BF57957D5704474A40
83424	LE8 5TD	GB	0101000020E6100000B6DB2E34D769F2BFF38FBE49D3464A40
83425	LE8 5TJ	GB	0101000020E6100000EBA9D5575745F2BF9AB1683A3B474A40
83426	LE8 5WQ	GB	0101000020E6100000D734EF3845C7F1BFF46DC1525D464A40
83427	LE8 6JG	GB	0101000020E6100000CCB56801DAD6F2BF69AD68739C494A40
83428	LE8 6LH	GB	0101000020E61000006A15FDA199E7F2BFF9BCE2A947484A40
83429	LE9	GB	0101000020E6100000C24CDBBFB292F4BF897956D28A4B4A40
83430	LE9 1RQ	GB	0101000020E61000003126FDBD141EF3BFB7088CF50D464A40
83431	LE9 1UT	GB	0101000020E61000009B75C6F7C5E5F2BF0E4B033FAA454A40
83432	LE9 2EB	GB	0101000020E610000068EA758BC098F3BF5F5E807D74504A40
83433	LE9 3EG	GB	0101000020E6100000E4F4F57CCDF2F3BFAD8905BEA2474A40
83434	LE9 3EJ	GB	0101000020E6100000ECA17DACE0F7F3BFD55E44DB31474A40
83435	LE9 4DF	GB	0101000020E6100000FF058200197AF4BFA439B2F2CB464A40
83436	LE9 4JA	GB	0101000020E61000001840F850A265F4BF7B2DE8BD31464A40
83437	LE9 4JN	GB	0101000020E6100000D906EE409D72F4BF6117450F7C444A40
83438	LE9 4TZ	GB	0101000020E6100000EE7C3F355E7AF4BF554CA59F70444A40
83439	LE9 5HR	GB	0101000020E61000008DD47B2AA73DF3BF75E8F4BC1B494A40
83440	LE9 6	GB	0101000020E6100000A4703D0AD7A3F3BF419FC893A4434A40
83441	LE9 6BT	GB	0101000020E610000052448655BC91F4BFA1DAE044F4454A40
83442	LE9 6NF	GB	0101000020E61000002B6EDC627E6EF3BF84D4EDEC2B434A40
83443	LE9 6NU	GB	0101000020E6100000D828EB371393F3BFB5519D0E64434A40
83444	LE9 6PT	GB	0101000020E61000005E143DF03198F3BFF92CCF83BB434A40
83445	LE9 6PU	GB	0101000020E6100000E6CE4C309C6BF3BF766D6FB724434A40
83446	LE9 6QA	GB	0101000020E6100000F790F0BDBF01F4BF1E5036E50A454A40
83447	LE9 6QB	GB	0101000020E6100000AED4B32094B7F3BF91F2936A9F444A40
83448	LE9 6RA	GB	0101000020E6100000DF701FB935A9F3BF130CE71A66444A40
83449	LE9 6RD	GB	0101000020E61000005B22179CC19FF3BF50560C5707444A40
83450	LE9 6ST	GB	0101000020E61000005587DC0C37A0F3BF5073F22213444A40
83451	LE9 6SY	GB	0101000020E6100000369545611785F3BF676325E659434A40
83452	LE9 6YW	GB	0101000020E6100000E15D2EE23B71F3BFA52DAEF199424A40
83453	LE9 7FA	GB	0101000020E6100000E8F692C6681DF5BFB2135E8253494A40
83454	LE9 7LR	GB	0101000020E61000006CEC12D55B03F5BFD6390664AF494A40
83455	LE9 7LZ	GB	0101000020E6100000AC8DB1135E42F5BF8044132862494A40
83456	LE9 7PA	GB	0101000020E61000001D7233DC804FF5BF2BA6D24F38494A40
83457	LE9 7PT	GB	0101000020E61000006494675E0E3BF5BFAA7CCF4884484A40
83458	LE9 8BJ	GB	0101000020E61000005C55F65D117CF4BF6953758F6C4A4A40
83459	LE9 8BL	GB	0101000020E6100000AF264F594D57F5BFEF1CCA5015494A40
83460	LE9 8DJ	GB	0101000020E6100000020F0C207CA8F5BF2E73BA2C26484A40
83461	LE9 8DX	GB	0101000020E6100000CD58349D9D4CF5BF653909A52F4A4A40
83462	LE9 8EQ	GB	0101000020E6100000AB22DC645499F5BFDC68006F81484A40
83463	LE9 8HB	GB	0101000020E61000007E39B35DA14FF5BF83A7902BF5484A40
83464	LE9 8HH	GB	0101000020E61000003F58C6866EF6F5BFA48D23D6E2474A40
83465	LE9 8HL	GB	0101000020E6100000AA471ADCD696F5BFFDF9B660A9484A40
83466	LE9 9FE	GB	0101000020E61000008DD31055F8F3F4BF834F73F222534A40
83467	LE9 9LG	GB	0101000020E6100000D0251C7A8B47F5BFE0F76F5E9C504A40
83468	LE9 9LW	GB	0101000020E6100000446FF1F09E83F5BFD40FEA2285504A40
83469	LE9 9NN	GB	0101000020E6100000E3DD91B1DA7CF5BF4D10751F80504A40
83470	LL11	GB	0101000020E6100000CBBC55D7A13A08C0C5C6BC8E388A4A40
83471	LL11 1SN	GB	0101000020E610000073D87DC7F0F807C059C0046EDD854A40
83472	LL11 2HF	GB	0101000020E6100000B6662B2FF9FF07C096B4E21B0A874A40
83473	LL11 2SA	GB	0101000020E61000009C1A683EE7EE07C008CC43A67C864A40
83474	LL11 2UF	GB	0101000020E61000009A42E73576E907C0336E6AA0F9884A40
83475	LL11 3AA	GB	0101000020E6100000F91400E3191409C0D5E76A2BF6874A40
83476	LL11 3AB	GB	0101000020E6100000B48EAA26887A09C058E542E55F874A40
83477	LL11 3AD	GB	0101000020E61000002F14B01D8C9809C0EB3BBF2841874A40
83478	LL11 3AL	GB	0101000020E61000004565C39ACA8209C0E54350357A894A40
83479	LL11 3AT	GB	0101000020E6100000BFB9BF7ADCB708C0863AAC70CB874A40
83480	LL11 3BT	GB	0101000020E61000009DBAF2599E8708C013BBB6B75B864A40
83481	LL11 3NU	GB	0101000020E6100000F6ED2422FC8B08C056D636C5E3864A40
83482	LL11 3PA	GB	0101000020E6100000DBC2F352B19108C0C2853C821B874A40
83483	LL11 3PJ	GB	0101000020E610000034828DEBDF9508C07F17B6662B874A40
83484	LL11 3RD	GB	0101000020E6100000C6A52A6D718D08C0414AECDADE864A40
83485	LL11 5LR	GB	0101000020E61000001FBC7669C38108C00CE6AF90B98A4A40
83486	LL11 5YL	GB	0101000020E6100000A1866F61DDF808C0DE3D40F7E5884A40
83487	LL11 5YX	GB	0101000020E6100000B81D1A16A3CE08C01E6D1CB116894A40
83488	LL12	GB	0101000020E6100000844BC79C67CC07C01283C0CAA18B4A40
83489	LL12 0EJ	GB	0101000020E61000002A36E675C48107C00C570740DC8D4A40
83490	LL12 0HU	GB	0101000020E610000096B20C71ACAB07C0282B86AB038E4A40
83491	LL12 7PP	GB	0101000020E6100000FB592C45F2D507C092B245D26E884A40
83492	LL12 8AJ	GB	0101000020E6100000734A404CC2E507C04FCAA48636884A40
83493	LL12 8AR	GB	0101000020E6100000EE224C512EED07C0D40B3ECDC9854A40
83494	LL12 8LD	GB	0101000020E610000074B515FBCBAE07C0C976BE9F1A8B4A40
83495	LL12 8PB	GB	0101000020E6100000C173EFE192C307C06FF3C649618A4A40
83496	LL12 8SW	GB	0101000020E61000004487C09140A307C073F7393E5A8C4A40
83497	LL12 8YG	GB	0101000020E61000003815A930B6B007C04A6249B9FB8A4A40
83498	LL12 9HT	GB	0101000020E6100000B343FCC3965E08C0CF15A584608D4A40
83499	LL12 9TA	GB	0101000020E61000007DCD72D9E83C08C087342A70B28B4A40
83500	LL13 0TH	GB	0101000020E61000003ECF9F36AA7307C065FF3C0D18824A40
83501	LL13 7JR	GB	0101000020E6100000958098840BF907C0317903CC7C854A40
83502	LL13 8SS	GB	0101000020E6100000C84274081C2908C0D82C978DCE894A40
83503	LL13 9QU	GB	0101000020E610000078B306EFABB207C03FC91D3691874A40
83504	LL13 9TZ	GB	0101000020E6100000035C902DCBD707C0371B2B31CF884A40
83505	LL13 9UX	GB	0101000020E61000005E49F25CDFE707C0BDA60705A5884A40
83506	LL14	GB	0101000020E6100000BDC282FB014F08C068757286E2804A40
83507	LL14 1LN	GB	0101000020E6100000A86E2EFEB66708C0A243E048A0814A40
83508	LL14 1UA	GB	0101000020E61000009A0B5C1E6BE608C0BDE5EAC7267F4A40
83509	LL14 2NS	GB	0101000020E610000048C153C8955A08C0390F27309D7E4A40
83510	LL14 2SJ	GB	0101000020E610000046D26EF4319F08C07E1B62BCE67F4A40
83511	LL14 3HB	GB	0101000020E6100000FD868906297808C0B72572C1197E4A40
83512	LL14 3LG	GB	0101000020E6100000B6679604A8A908C0941799805F7D4A40
83513	LL14 3YR	GB	0101000020E610000054A703594F8D08C0041F8315A77C4A40
83514	LL14 4EP	GB	0101000020E610000058CB9D99605808C093C7D3F203834A40
83515	LL14 4JE	GB	0101000020E6100000FAD51C20980308C014E97E4E41864A40
83516	LL14 5AA	GB	0101000020E6100000A1BFD023464F08C055FB743C667E4A40
83517	LL14 5AH	GB	0101000020E61000008192020B60AA08C0F29716F5497A4A40
83518	LL14 5BG	GB	0101000020E6100000A06EA0C03B5908C0D2C2651536794A40
83519	LL14 5EY	GB	0101000020E6100000F836FDD98F7408C09E5DBEF561774A40
83520	LL14 5LU	GB	0101000020E6100000F7AC6BB41C8808C0CFA0A17F82774A40
83521	LL14 6DL	GB	0101000020E61000005531957EC25908C08192020B607E4A40
83522	LL15 1DA	GB	0101000020E610000023D923D40C690AC05DA79196CA8D4A40
83523	LL15 1DF	GB	0101000020E6100000D943FB58C16F0AC0B58B69A67B8D4A40
83524	LL15 1EE	GB	0101000020E6100000118DEE2076660AC099840B79048F4A40
83525	LL15 1HP	GB	0101000020E6100000376F9C14E63D0AC090F8156BB8904A40
83526	LL15 1LB	GB	0101000020E61000004F5AB8ACC2660AC06D1CB1169F8E4A40
83527	LL15 1QP	GB	0101000020E6100000C005D9B27C3D0AC04E7ADFF8DA8F4A40
83528	LL15 1SF	GB	0101000020E610000011FDDAFAE97F0AC01BD6541685934A40
83529	LL15 1TF	GB	0101000020E61000002975C93846720AC082E7DEC3258F4A40
83530	LL15 1TY	GB	0101000020E6100000AA29C93A1C7D0AC08C2B2E8ECA914A40
83531	LL15 1ZZ	GB	0101000020E6100000F2D3B837BFE10AC0014D840D4F8F4A40
83532	LL15 2EU	GB	0101000020E6100000C286A757CA320AC004543882548A4A40
83533	LL15 2NU	GB	0101000020E610000054C4E9245B7D0AC0CA6C9049468E4A40
83534	LL16	GB	0101000020E6100000C79C67EC4BD60AC05C3AE63C63994A40
83535	LL16 3EU	GB	0101000020E610000048E17A14AE670BC0ABED26F8A6974A40
83536	LL16 3JS	GB	0101000020E61000002CF3565D874A0BC0D49D279EB3974A40
83537	LL16 3RJ	GB	0101000020E6100000A8902BF52C680BC0151A886533974A40
83538	LL16 3RS	GB	0101000020E6100000AB75E272BC820BC023DC6454199A4A40
83539	LL16 4UA	GB	0101000020E6100000EECD6F9868500BC0331AF9BCE29B4A40
83540	LL17	GB	0101000020E6100000E62329E961680BC05EF1D4230DA44A40
83541	LL17 0LJ	GB	0101000020E6100000E7FC14C781D70BC09293895B05A14A40
83542	LL17 0RS	GB	0101000020E6100000D74E9484447A0BC0CFF57D3848A04A40
83543	LL17 0RW	GB	0101000020E6100000E94999D4D0860BC0537B116DC7A04A40
83544	LL17 0SX	GB	0101000020E6100000467A51BB5F850BC04BE9995E62A04A40
83545	LL17 0UE	GB	0101000020E61000006D382C0DFC080BC061A5828AAA9F4A40
83546	LL18	GB	0101000020E6100000A1D80A9A96180BC0AFCC5B751DA04A40
83547	LL18 1AT	GB	0101000020E6100000A986FD9E58E70BC003250516C0A84A40
83548	LL18 2BH	GB	0101000020E610000036E50AEF72F10BC07E00529B38A94A40
83549	LL18 2ER	GB	0101000020E6100000A45181936DE00BC045A165DD3FA84A40
83550	LL18 2LU	GB	0101000020E6100000F4A62215C6760BC0C4AF58C345AA4A40
83551	LL18 2PU	GB	0101000020E61000001502B9C491C70BC0062CB98AC5A74A40
83552	LL18 2SQ	GB	0101000020E610000000C8091346B30BC00B0E2F8848A54A40
83553	LL18 2SY	GB	0101000020E61000005CAD1397E3B50BC0B58CD47B2AA94A40
83554	LL18 2UF	GB	0101000020E61000004435255987E30BC0F8F9EFC16BA54A40
83555	LL18 3AS	GB	0101000020E6100000AA7EA5F3E1D90BC0384C3448C1A94A40
83556	LL18 3PE	GB	0101000020E61000003DD2E0B6B6D00BC03659A31EA2A94A40
83557	LL18 3PU	GB	0101000020E610000007B47405DBC80BC0AAB9DC60A8A94A40
83558	LL18 3RT	GB	0101000020E6100000A20C553195DE0BC08847E2E5E9A84A40
83559	LL18 4AF	GB	0101000020E6100000A987687407D10BC07C7C4276DEA84A40
83560	LL18 4BA	GB	0101000020E61000006C5D6A847EC60BC04A9BAA7B64A94A40
83561	LL18 4BW	GB	0101000020E61000009EEDD11BEEC30BC05709168733A94A40
83562	LL18 4BX	GB	0101000020E61000004BCADDE7F8880BC0CD5CE0F258A94A40
83563	LL18 4DY	GB	0101000020E6100000588FFB56EBA40BC01F0F7D772BA94A40
83564	LL18 4SG	GB	0101000020E610000047E7FC14C7C10BC07B681F2BF8A74A40
83565	LL18 4UD	GB	0101000020E6100000AE62F19BC2AA0BC0D49D279EB3A74A40
83566	LL18 5HN	GB	0101000020E6100000E50CC51D6F120CC0DE567A6D36A64A40
83567	LL18 5HU	GB	0101000020E610000001193A7650290CC02E3C2F151BA74A40
83568	LL18 5RG	GB	0101000020E6100000D714C8EC2C5A0BC00056478E74A64A40
83569	LL18 5TX	GB	0101000020E6100000381268B0A9130CC0166EF9484AA24A40
83570	LL18 5UJ	GB	0101000020E6100000118FC4CBD3F90BC0D923D40CA9A24A40
83571	LL18 6AR	GB	0101000020E610000018778368AD480BC004711E4E60A64A40
83572	LL18 6EP	GB	0101000020E6100000906B43C5381F0BC01D007157AFA84A40
83573	LL19 7SP	GB	0101000020E61000005C2041F1634C0BC07FDDE9CE13AB4A40
83574	LL19 8BW	GB	0101000020E610000081CB63CDC8600BC04E5FCFD72CA94A40
83575	LL19 8PY	GB	0101000020E6100000185FB4C70B490BC0B6D9588979A84A40
83576	LL19 8TS	GB	0101000020E6100000D02B9E7AA4610BC04777103B53AA4A40
83577	LL19 9HH	GB	0101000020E610000066BB421F2C230BC09E996038D7AA4A40
83578	LL19 9PL	GB	0101000020E6100000A9C1340C1F310BC01C7920B248A94A40
83579	LL19 9PU	GB	0101000020E6100000C5C8923996370BC086747808E3A94A40
83580	LL19 9SL	GB	0101000020E61000006B28B517D1360BC043ACFE08C3AA4A40
83581	LL20	GB	0101000020E6100000008E3D7B2E5309C0232F6B62817B4A40
83582	LL20 8AQ	GB	0101000020E61000007097FDBAD31D09C00FB56D18057D4A40
83583	LL20 8AR	GB	0101000020E610000090BB0853942B09C06155BDFC4E7B4A40
83584	LL20 8AW	GB	0101000020E6100000DD787764AC3609C07768588CBA7C4A40
83585	LL20 8DP	GB	0101000020E6100000C30DF8FC308209C0DE3D40F7E5804A40
83586	LL20 8ED	GB	0101000020E6100000DE91B1DAFC5F09C006BCCCB0517E4A40
83587	LL20 8HH	GB	0101000020E6100000FC1D8A027D6209C05D328E91EC7B4A40
83588	LL20 8PP	GB	0101000020E6100000DE57E542E55F09C0D1066003227C4A40
83589	LL20 8SN	GB	0101000020E61000001CD31396786009C0F2B4FCC0557C4A40
83590	LL20 8SS	GB	0101000020E6100000D55A9885766E09C083328D26177D4A40
83591	LL21 0BD	GB	0101000020E6100000191EFB592C050BC0F629C764717D4A40
83592	LL21 0DB	GB	0101000020E610000087FC3383F8000BC01B62BCE6557D4A40
83593	LL21 0PE	GB	0101000020E6100000DEC66647AA0F0CC07CB8E4B8537E4A40
83594	LL21 0RB	GB	0101000020E61000006C223317B85C0CC03CA1D79FC47D4A40
83595	LL21 0RW	GB	0101000020E6100000F94D61A5826A0CC0F81A82E3327E4A40
83596	LL21 0SP	GB	0101000020E6100000FD86890629780BC0AA2C0ABB28764A40
83597	LL21 9EL	GB	0101000020E61000006687F8872D7D0AC038F6ECB94C7D4A40
83598	LL22	GB	0101000020E610000034A2B437F8C20CC02654707841A04A40
83599	LL22 7AA	GB	0101000020E6100000E54526E0D7A80CC0118DEE2076A44A40
83600	LL22 7AR	GB	0101000020E6100000C845B58828A60CC0F627F1B913A44A40
83601	LL22 7DZ	GB	0101000020E610000036CD3B4ED1B10CC013B534B742A44A40
83602	LL22 7LY	GB	0101000020E61000008505F7031EB80CC0C66B5ED559A54A40
83603	LL22 7NF	GB	0101000020E61000007DCEDDAE97A60CC0D1217024D0A44A40
83604	LL22 7PR	GB	0101000020E6100000988922A46EA70CC0D107CBD8D0A54A40
83605	LL22 8BE	GB	0101000020E6100000A08A1BB7985F0CC0F513CE6E2DA34A40
83606	LL22 8SE	GB	0101000020E6100000FED2A23EC9DD0CC0BF61A2410A9C4A40
83607	LL22 9AF	GB	0101000020E6100000EA23F0879F7F0CC00B630B410EA64A40
83608	LL22 9DP	GB	0101000020E6100000D0285DFA97040CC0E2C96E66F49F4A40
83609	LL22 9ND	GB	0101000020E6100000A7C98CB795DE0BC0E99E758D96A74A40
83610	LL22 9NN	GB	0101000020E6100000CE8C7E349C520CC057790261A7A64A40
83611	LL22 9RF	GB	0101000020E610000004029D499B8A0CC013BA4BE2ACA04A40
83612	LL22 9RG	GB	0101000020E6100000ADDEE17668780CC0B360E28FA2A04A40
83613	LL23	GB	0101000020E6100000A6D590B8C7120CC0BDE47FF277754A40
83614	LL23 7DD	GB	0101000020E610000028D4D347E04F0DC0C2F869DC9B6D4A40
83615	LL23 7NP	GB	0101000020E610000072FC5069C4CC0CC08DD31055F8754A40
83616	LL23 7SR	GB	0101000020E6100000D9CEF753E3C50CC05A492BBEA1744A40
83617	LL24 0ET	GB	0101000020E6100000035FD1ADD7540FC00745F300168D4A40
83618	LL24 0HU	GB	0101000020E610000006BCCCB051760DC034D8D47954864A40
83619	LL25 0TX	GB	0101000020E610000065C746205E170FC0ACA92C0ABB864A40
83620	LL26 0AA	GB	0101000020E6100000A06B5F402F5C0EC0F52EDE8FDB914A40
83621	LL26 0PN	GB	0101000020E6100000621399B9C0650EC07539252026914A40
83622	LL27 0JH	GB	0101000020E610000047E9D2BF24950EC0AD32535A7F934A40
83623	LL27 0JP	GB	0101000020E6100000A2ED98BA2B9B0EC0C7D79E5912944A40
83624	LL27 0JU	GB	0101000020E61000006F9D7FBBEC970EC02B137EA99F934A40
83625	LL27 0JZ	GB	0101000020E6100000BD35B05582650EC01631EC3026914A40
83626	LL27 0RQ	GB	0101000020E61000006EC2BD326F950EC07ADFF8DA33934A40
83627	LL28	GB	0101000020E6100000F6D1A92B9F650EC02992AF0452A04A40
83628	LL28 4AJ	GB	0101000020E6100000AF08FEB792FD0DC0CB9D996038A74A40
83629	LL28 4NR	GB	0101000020E610000076711B0DE0ED0DC072F8A41309A84A40
83630	LL28 4YB	GB	0101000020E6100000B11875ADBD0F0EC060CAC0012DA74A40
83631	LL28 5AP	GB	0101000020E6100000C30C8D2782180EC02194F771349F4A40
83632	LL28 5RH	GB	0101000020E61000000CC85EEFFE580EC095D40968229C4A40
83633	LL28 5TF	GB	0101000020E6100000DBA6785C544B0EC0CC41D0D1AAA04A40
83634	LL28 5TW	GB	0101000020E6100000882F1345485D0EC069E55E6056A04A40
83635	LL28 5UA	GB	0101000020E6100000E1270EA0DF570EC0ECBE6378EC9B4A40
83636	LL28 5UE	GB	0101000020E610000050C24CDBBF320EC01D71C806D29B4A40
83637	LL28 5UL	GB	0101000020E6100000C170AE6186260EC02C802903079A4A40
83638	LL28 5YL	GB	0101000020E610000065FD6662BAF00DC0C45C52B5DDA44A40
83639	LL28 5YU	GB	0101000020E6100000FEF3346090F40DC029E78BBD17A54A40
83640	LL29 7PH	GB	0101000020E610000027C286A757CA0DC045BA9F5390A54A40
83641	LL29 7UN	GB	0101000020E6100000A912656F29070EC0AA2D7590D7A34A40
83642	LL29 7YB	GB	0101000020E61000006C0723F609E00DC0965AEF37DAA54A40
83643	LL29 8DF	GB	0101000020E6100000C5C72764E7CD0DC00D39B69E21A64A40
83644	LL29 8EN	GB	0101000020E61000008CF4A276BF8A0DC016DEE522BEA34A40
83645	LL29 8FD	GB	0101000020E610000069FCC22B493E0DC0D45FAFB0E0A44A40
83646	LL29 8NB	GB	0101000020E610000014B1886187D10DC0B4E7323509A64A40
83647	LL29 8RB	GB	0101000020E610000012DE1E8480BC0DC089B663EAAEA44A40
83648	LL29 8UT	GB	0101000020E61000004162BB7B808E0DC04FAE2990D9A34A40
83649	LL29 8YE	GB	0101000020E610000031B77BB94F4E0DC04D66BCADF4A44A40
83650	LL29 9DP	GB	0101000020E61000006DA983BC1E8C0DC095EEAEB321A54A40
83651	LL29 9HT	GB	0101000020E61000003BC6151747650DC0F355F2B1BBA44A40
83652	LL29 9YP	GB	0101000020E61000003BC5AA41987B0DC0958098840BA54A40
83653	LL30	GB	0101000020E61000008DB5BFB33D1A0EC07CF0DAA50DA94A40
83654	LL30 1BG	GB	0101000020E610000031074147AB7A0EC0D921FE614BA94A40
83655	LL30 1DH	GB	0101000020E6100000730F09DFFB9B0EC03C86C77E16A94A40
83656	LL30 1LZ	GB	0101000020E610000040D9942BBC6B0EC0608F899466A94A40
83657	LL30 1NA	GB	0101000020E6100000F5F3A62215A60EC07270E998F3A64A40
83658	LL30 1NB	GB	0101000020E61000000518963FDF960EC0A0DD21C500A74A40
83659	LL30 1ND	GB	0101000020E6100000C3482F6AF78B0EC0D5E76A2BF6A74A40
83660	LL30 1NE	GB	0101000020E610000038D906EE409D0EC0F6D37FD6FCA64A40
83661	LL30 1NF	GB	0101000020E6100000D99942E735960EC0200A664CC1A64A40
83662	LL30 1NG	GB	0101000020E6100000334FAE2990990EC031EA5A7B9FA64A40
83663	LL30 1NH	GB	0101000020E61000005ABBED42739D0EC059C345EEE9A64A40
83664	LL30 1NJ	GB	0101000020E6100000E57B462234820EC008C72C7B12A84A40
83665	LL30 1NL	GB	0101000020E6100000AFE94141299A0EC082FFAD64C7A64A40
83666	LL30 1NQ	GB	0101000020E610000055DD239BAB860EC08F17D2E121A84A40
83667	LL30 1NR	GB	0101000020E6100000E7DF2EFB75A70EC01361C3D32BA74A40
83668	LL30 1NS	GB	0101000020E61000009677D503E6A10EC0D8B969334EA74A40
83669	LL30 1NT	GB	0101000020E6100000A54E401361A30EC07E3A1E3350A74A40
83670	LL30 1NU	GB	0101000020E610000024D236FE44A50EC0E695EB6D33A74A40
83671	LL30 1NX	GB	0101000020E610000037514B732B840EC0D38558FD11A84A40
83672	LL30 1NY	GB	0101000020E61000001F82AAD1ABA10EC0800BB265F9A64A40
83673	LL30 1NZ	GB	0101000020E6100000779D0DF967860EC06397A8DE1AA84A40
83674	LL30 1PT	GB	0101000020E61000008ACA863595850EC0B075A911FAA74A40
83675	LL30 1RB	GB	0101000020E61000002DEDD45C6E900EC0D921FE614BA74A40
83676	LL30 1RD	GB	0101000020E6100000DC9BDF30D1600EC0E50E9BC8CCA74A40
83677	LL30 1RF	GB	0101000020E61000001F0F7D772B8B0EC09FCC3FFA26A74A40
83678	LL30 1RG	GB	0101000020E6100000CEC133A149820EC040DF162CD5A74A40
83679	LL30 1RH	GB	0101000020E6100000DB32E02C258B0EC0B03A72A433A84A40
83680	LL30 1RJ	GB	0101000020E61000007A19C5724B8B0EC0A585CB2A6CA84A40
83681	LL30 1RN	GB	0101000020E6100000FAF19716F5690EC04E62105839A84A40
83682	LL30 1RP	GB	0101000020E610000014ECBFCE4D7B0EC016BD5301F7A64A40
83683	LL30 1RQ	GB	0101000020E610000060ADDA35218D0EC047718E3A3AA84A40
83684	LL30 1RS	GB	0101000020E61000007CB8E4B8537A0EC0E0DBF4673FA64A40
83685	LL30 1RT	GB	0101000020E6100000E57CB1F7E28B0EC0516A2FA2EDA84A40
83686	LL30 1RU	GB	0101000020E61000004832AB77B87D0EC043739D465AA84A40
83687	LL30 1RW	GB	0101000020E61000002E71E481C8820EC0E527D53E1DA74A40
83688	LL30 1RX	GB	0101000020E6100000DF701FB935890EC0151DC9E53FA84A40
83689	LL30 1RY	GB	0101000020E61000006E50FBAD9D880EC077A22424D2A84A40
83690	LL30 1RZ	GB	0101000020E610000048BF7D1D38870EC0E413B2F336A84A40
83691	LL30 1SA	GB	0101000020E610000068AED3484B850EC0524832AB77A64A40
83692	LL30 1SB	GB	0101000020E6100000151DC9E53F840EC0D5EC815660A64A40
83693	LL30 1SD	GB	0101000020E61000003A1E3350197F0EC0EA944737C2A64A40
83694	LL30 1SE	GB	0101000020E6100000C503CAA65C810EC0E1F08288D4A64A40
83695	LL30 1SF	GB	0101000020E6100000F834272F32810EC0ADA23F34F3A64A40
83696	LL30 1SH	GB	0101000020E6100000F51263997E890EC0A1BAB9F8DBA64A40
83697	LL30 1SJ	GB	0101000020E6100000083D9B559F8B0EC03048FAB48AA84A40
83698	LL30 1SL	GB	0101000020E610000045813E9127890EC0D8F4A0A014A74A40
83699	LL30 1SN	GB	0101000020E6100000FBE769C020890EC071AAB5300BA74A40
83700	LL30 1SP	GB	0101000020E610000090BB0853948B0EC03123BC3D08A74A40
83701	LL30 1SQ	GB	0101000020E6100000D1747632388A0EC0F888981249A84A40
83702	LL30 1SW	GB	0101000020E6100000C634D3BD4E8A0EC02237C30DF8A64A40
83703	LL30 1SX	GB	0101000020E6100000E415889E94890EC0D3A1D3F36EA84A40
83704	LL30 1SZ	GB	0101000020E61000001ABFF04A92870EC0D520CCED5EA84A40
83705	LL30 1US	GB	0101000020E61000003831242713570EC0605793A7ACA84A40
83706	LL30 2AF	GB	0101000020E6100000810871E5EC9D0EC0A0FA07910CA94A40
83707	LL30 2LU	GB	0101000020E6100000EDF2AD0FEBAD0EC0077C7E1821AA4A40
83708	LL30 2NA	GB	0101000020E610000066F9BA0CFFA90EC0D427B9C326AA4A40
83709	LL30 3BD	GB	0101000020E6100000499F56D11F7A0EC0139A249694A94A40
83710	LL30 3BG	GB	0101000020E61000000A4AD1CABD400EC07EFE7BF0DAA94A40
83711	LL30 3LT	GB	0101000020E610000055302AA913300EC0971C774A07A94A40
83712	LL30 3NT	GB	0101000020E61000008F34B8AD2DFC0DC0F855B950F9A94A40
83713	LL31	GB	0101000020E6100000EDBB22F8DF6A0DC0BC934F8F6DA54A40
83714	LL31 9EL	GB	0101000020E6100000933A014D846D0EC0622D3E05C0A44A40
83715	LL31 9JE	GB	0101000020E61000003D0FEECEDA6D0EC05D6F9BA910A34A40
83716	LL31 9LA	GB	0101000020E6100000143DF03158710EC0C4961E4DF5A44A40
83717	LL31 9LH	GB	0101000020E61000003A3DEFC682A20DC030BABC395CA54A40
83718	LL31 9NB	GB	0101000020E61000006954E0641B780EC088A06AF46AA44A40
83719	LL31 9NR	GB	0101000020E6100000E99C9FE238700EC026DF6C7363A44A40
83720	LL31 9RD	GB	0101000020E610000024253D0CAD6E0EC046425BCEA5A44A40
83721	LL31 9TX	GB	0101000020E61000005358A9A0A26A0EC085ED27637CA44A40
83722	LL31 9XX	GB	0101000020E61000003DB7D09508740EC0C72E51BD35A44A40
83723	LL31 9YR	GB	0101000020E610000044BFB67EFAAF0EC017F3734353A64A40
83724	LL32	GB	0101000020E6100000B6D8EDB3CAEC0EC0346612F582954A40
83725	LL32 8AY	GB	0101000020E6100000A2B60DA320980EC080492A53CCA34A40
83726	LL32 8JP	GB	0101000020E61000009CDB847B65BE0EC0F433F5BA45984A40
83727	LL32 8LD	GB	0101000020E61000004A44F81741A30EC0558847E2E5A34A40
83728	LL32 8LL	GB	0101000020E6100000D1B2EE1F0BB10EC0904AB1A371A64A40
83729	LL32 8NT	GB	0101000020E61000006BD8EF8975AA0EC05EA0A4C002A44A40
83730	LL32 8YZ	GB	0101000020E6100000658C0FB397CD0EC0E4BB94BA649A4A40
83731	LL33	GB	0101000020E61000005EF75624269810C02F302B14E99C4A40
83732	LL33 0EB	GB	0101000020E6100000973B33C170CE0FC0D4D17135B29F4A40
83733	LL33 0EY	GB	0101000020E6100000670FB40243960FC0AA0F24EF1CA04A40
83734	LL33 0LU	GB	0101000020E610000083328D26173310C078EFA831219C4A40
83735	LL33 0PA	GB	0101000020E6100000180AD80E46CC0FC04EF1B8A816A14A40
83736	LL33 0SE	GB	0101000020E6100000483657CD73C40FC0B2B96A9E23A04A40
83737	LL34 6	GB	0101000020E6100000C8EA56CF496F0FC0F5673F5244A24A40
83738	LL34 6ER	GB	0101000020E610000010EA2285B2500FC0779E78CE16A24A40
83739	LL34 6RF	GB	0101000020E6100000C2F7FE06ED350FC0A725564623A34A40
83740	LL35 0LU	GB	0101000020E6100000159161156F2410C05F9A22C0E9454A40
83741	LL35 0NR	GB	0101000020E6100000A69A594B013910C02BFC19DEAC454A40
83742	LL36	GB	0101000020E6100000AB083719555610C061C43E01144D4A40
83743	LL36 0BA	GB	0101000020E6100000FAD005F52D6310C0BF99982EC44A4A40
83744	LL36 0DN	GB	0101000020E61000003AADDBA0F65B10C01D75745C8D4A4A40
83745	LL36 9DE	GB	0101000020E6100000D8F335CB655310C07B30293E3E4B4A40
83746	LL36 9EY	GB	0101000020E6100000F31C91EF525A10C016DBA4A2B14A4A40
83747	LL36 9HA	GB	0101000020E61000003604C765DC5410C02A90D959F44A4A40
83748	LL36 9HU	GB	0101000020E610000046072461DF3E10C09013268C66494A40
83749	LL37 2JS	GB	0101000020E6100000AB798EC8775910C08670CCB227554A40
83750	LL38 2AQ	GB	0101000020E61000003FE257ACE13210C04016A243E0584A40
83751	LL38 2BQ	GB	0101000020E6100000EF703B342C3610C0D447E00F3F594A40
83752	LL38 2EX	GB	0101000020E6100000A9BEF38B123410C05F7AFB73D1584A40
83753	LL38 2NX	GB	0101000020E6100000C3F5285C8F3210C0C7B94DB857584A40
83754	LL39 1AX	GB	0101000020E6100000035FD1ADD71410C0492A53CC415A4A40
83755	LL39 1YR	GB	0101000020E6100000276728EE780310C01C0934D8D45B4A40
83756	LL40 1UU	GB	0101000020E61000000E881057CE1E0FC03BE466B8015F4A40
83757	LL40 2AA	GB	0101000020E6100000CEFE40B96DFF0EC06B6281AFE85E4A40
83758	LL40 2AN	GB	0101000020E61000005051F52B9D4F0EC00934D8D479624A40
83759	LL40 2TU	GB	0101000020E6100000880FECF82F900FC089EFC4AC17614A40
83760	LL40 4LA	GB	0101000020E610000006BEA25BAFE90EC00D1D3BA8C45F4A40
83761	LL41	GB	0101000020E61000003BA92F4B3B750FC0AE62F19BC27A4A40
83762	LL41 3PR	GB	0101000020E6100000A587A1D5C9990FC0B5A338471D7F4A40
83763	LL41 4BU	GB	0101000020E6100000663387A4166A0FC00C789961A37E4A40
83764	LL41 4NE	GB	0101000020E610000085B69C4B71750FC0DEC9A7C7B67A4A40
83765	LL41 4RU	GB	0101000020E610000092205C01855A0FC0AA0A0DC4B2734A40
83766	LL41 4UR	GB	0101000020E610000096B4E21B0A3F0FC09C6A2DCC426F4A40
83767	LL42	GB	0101000020E6100000DDD0949D7E3010C0317C444C895C4A40
83768	LL42 1AJ	GB	0101000020E61000008E7406465E4610C0D595CFF23C5E4A40
83769	LL42 1AZ	GB	0101000020E61000002FC1A90F244F10C0814067D2A65E4A40
83770	LL42 1LU	GB	0101000020E61000005419C6DD203A10C08B53AD85595C4A40
83771	LL43 2AP	GB	0101000020E61000007767EDB60B5D10C0C84274081C634A40
83772	LL43 2AQ	GB	0101000020E61000004AED45B41D6310C048DE3994A1624A40
83773	LL44 2BG	GB	0101000020E6100000FFAF3A72A46310C038A4518193654A40
83774	LL44 2DH	GB	0101000020E61000001D91EF52EA6210C042EC4CA1F3644A40
83775	LL44 2DR	GB	0101000020E61000008ECA4DD4D25C10C0E3C5C21039654A40
83776	LL44 2DS	GB	0101000020E6100000FDC0559E405810C0925ED4EE57654A40
83777	LL44 2EP	GB	0101000020E6100000C05B2041F16310C0E108522976644A40
83778	LL44 2ES	GB	0101000020E61000006F66F4A3E16410C075E4486760644A40
83779	LL44 2EU	GB	0101000020E6100000683EE76ED76B10C022C32ADEC8644A40
83780	LL45 2HL	GB	0101000020E6100000A1866F61DD6810C020B75F3E59694A40
83781	LL45 2HP	GB	0101000020E61000007EAA0A0DC47210C00F09DFFB1B6A4A40
83782	LL45 2LD	GB	0101000020E61000007DB1F7E28B6610C0EC12D55B03694A40
83783	LL45 2NW	GB	0101000020E6100000BD512B4CDF5B10C0BB0B9414586A4A40
83784	LL46 2RA	GB	0101000020E6100000C7F0D8CF627910C00B293FA9F66B4A40
83785	LL46 2TE	GB	0101000020E61000004F029B73F05C10C008CC43A67C6C4A40
83786	LL46 2UL	GB	0101000020E61000005F0B7A6F0C7110C034643C4A256E4A40
83787	LL47 6UA	GB	0101000020E6100000B4006DAB594710C0ED612F14B0734A40
83788	LL48 6HG	GB	0101000020E6100000F2B56796045810C0D847A7AE7C764A40
83789	LL48 6LN	GB	0101000020E610000088BA0F406A4310C081971936CA764A40
83790	LL49 9DS	GB	0101000020E61000001FD8F15F208810C03815A930B6764A40
83791	LL49 9HT	GB	0101000020E6100000F6D03E56F08B10C0A46C91B41B774A40
83792	LL49 9NF	GB	0101000020E61000001021AE9CBD8310C029CDE67118764A40
83793	LL49 9PA	GB	0101000020E610000072A59E05A18C10C0520DFB3DB1764A40
83794	LL51 9LX	GB	0101000020E6100000A5F5B704E00F11C05ED72FD80D7D4A40
83795	LL52 0DB	GB	0101000020E6100000C07971E2ABED10C09ED1562591754A40
83796	LL52 0HP	GB	0101000020E6100000D6011077F5EA10C07BF486FBC8754A40
83797	LL52 0RW	GB	0101000020E61000005567B5C01EF310C06EDFA3FE7A754A40
83798	LL53 5BN	GB	0101000020E6100000F8FC304278B411C01ABFF04A92714A40
83799	LL53 5DE	GB	0101000020E61000003DF0315871AA11C044FAEDEBC0714A40
83800	LL53 5HG	GB	0101000020E610000087A6ECF483AA11C0419FC893A4714A40
83801	LL53 6DQ	GB	0101000020E61000005ABC5818226711C0A8FDD64E94784A40
83802	LL53 6JF	GB	0101000020E6100000A1D79FC4E75E11C0AE635C7171784A40
83803	LL53 6PJ	GB	0101000020E610000001309E41437F11C0C092AB58FC724A40
83804	LL53 7ER	GB	0101000020E6100000D8D7BAD4080D12C0454948A46D684A40
83805	LL53 7NH	GB	0101000020E61000008E76DCF0BBD911C09BADBCE47F704A40
83806	LL53 7RH	GB	0101000020E61000008179C8940F1112C0D4484BE5ED6C4A40
83807	LL53 8LF	GB	0101000020E6100000DF88EE59D7C812C0FCC3961E4D6B4A40
83808	LL53 8LH	GB	0101000020E6100000202A8D98D9E712C053B29C84D2694A40
83809	LL54	GB	0101000020E61000001F9F909DB72111C001310917F2864A40
83810	LL54 5EE	GB	0101000020E61000003BAC70CB475211C03A02B859BC864A40
83811	LL54 5LU	GB	0101000020E61000000778D2C265B511C02C836A83137F4A40
83812	LL54 5PS	GB	0101000020E6100000F33CB83B6B9711C0B0743E3C4B804A40
83813	LL54 6	GB	0101000020E6100000761C3F541A2111C05BB05417F0864A40
83814	LL54 6AL	GB	0101000020E6100000F2EB87D8600111C0C0CC77F013874A40
83815	LL54 7AJ	GB	0101000020E61000001825E82FF4C810C0098B8A389D8C4A40
83816	LL54 7SH	GB	0101000020E61000009CFA40F2CE0111C0EC32FCA71B884A40
83817	LL54 7YH	GB	0101000020E610000049BA66F2CD1611C050357A35408D4A40
83818	LL55	GB	0101000020E6100000CD3E8F519ED910C029965B5A0D8F4A40
83819	LL55 1BE	GB	0101000020E6100000492A53CC411011C0EAEA8EC536934A40
83820	LL55 1BX	GB	0101000020E6100000984F560C57D710C040F9BB77D4944A40
83821	LL55 1PH	GB	0101000020E6100000A48D23D6E2F310C0D3BF249529924A40
83822	LL55 1RH	GB	0101000020E6100000876C205D6C1A11C0355EBA490C924A40
83823	LL55 1SH	GB	0101000020E6100000A5BE2CEDD41C11C066DCD440F3914A40
83824	LL55 1YB	GB	0101000020E6100000F06B2409C2D510C0695721E527954A40
83825	LL55 2AR	GB	0101000020E6100000C0098508381411C00C570740DC914A40
83826	LL55 2BJ	GB	0101000020E6100000020EA14ACDFE10C022E2E65432924A40
83827	LL55 2PH	GB	0101000020E6100000B62BF4C1321611C0F705F4C29D914A40
83828	LL55 2SS	GB	0101000020E6100000D26F5F07CE1911C0CEFDD5E3BE914A40
83829	LL55 2YG	GB	0101000020E610000071546EA2961611C053AEF02E17914A40
83830	LL55 3NA	GB	0101000020E610000043C5387F136A10C060915F3FC4924A40
83831	LL55 3NR	GB	0101000020E610000068CA4E3FA89B10C0FE7F9C3061924A40
83832	LL55 3PW	GB	0101000020E61000002B14E97E4ED110C0709A3E3BE0904A40
83833	LL55 4BJ	GB	0101000020E61000004DDC2A8881CE10C0A7AD11C1388E4A40
83834	LL55 4HD	GB	0101000020E6100000B6D782DE1B8310C05DA96741288F4A40
83835	LL55 4HE	GB	0101000020E6100000F819170E848410C0378E588B4F8F4A40
83836	LL55 4NG	GB	0101000020E6100000AA9B8BBFED5910C05AB741EDB7824A40
83837	LL55 4NY	GB	0101000020E6100000CA880B40A31410C046CEC29E768A4A40
83838	LL55 4SA	GB	0101000020E61000001C60E63BF8C910C08B36C7B94D904A40
83839	LL55 4UL	GB	0101000020E6100000DBF97E6ABC4410C0D105F52D738C4A40
83840	LL55 4UN	GB	0101000020E6100000D384ED27635C10C09D2D20B41E8E4A40
83841	LL55 4YR	GB	0101000020E610000073BB97FBE4D810C0CBA0DAE044904A40
83842	LL56 4	GB	0101000020E6100000CB9F6F0B96DA10C05DA3E5400F974A40
83843	LL56 4RZ	GB	0101000020E6100000232F6B6281DF10C05C59A2B3CC964A40
83844	LL57	GB	0101000020E6100000CFBA46CB817E10C0098A1F63EE9C4A40
83845	LL57 1AS	GB	0101000020E6100000488AC8B08A8710C0BDC62E51BD9D4A40
83846	LL57 1BH	GB	0101000020E61000004434BA83D87910C0166A4DF38E9D4A40
83847	LL57 1DZ	GB	0101000020E61000000876FC17088210C0A2EF6E65899C4A40
83848	LL57 1EJ	GB	0101000020E61000002F6F0ED76A7F10C0792288F3709C4A40
83849	LL57 2BE	GB	0101000020E6100000406A1327F78B10C01900AAB8719D4A40
83850	LL57 2BG	GB	0101000020E6100000637FD93D798810C0C64E78094E9D4A40
83851	LL57 2LT	GB	0101000020E6100000BF81C98D228B10C056D5CBEF349D4A40
83852	LL57 2LZ	GB	0101000020E61000004562821ABEA510C0728C648F509B4A40
83853	LL57 2PW	GB	0101000020E6100000A245B6F3FDA410C045D95BCAF99A4A40
83854	LL57 2PY	GB	0101000020E6100000AEF199EC9F8710C00307B474059D4A40
83855	LL57 2PZ	GB	0101000020E61000003F74417DCB9C10C0B18A37328F9C4A40
83856	LL57 2SP	GB	0101000020E61000006EDBF7A8BF7E10C0430070ECD99D4A40
83857	LL57 2SS	GB	0101000020E61000000C06D7DCD17F10C036E49F19C49D4A40
83858	LL57 2TW	GB	0101000020E6100000556D37C1378D10C0446B459BE39C4A40
83859	LL57 2UP	GB	0101000020E6100000897B2C7DE88210C0BC02D193329D4A40
83860	LL57 3	GB	0101000020E6100000F981AB3C813010C0BEDA519CA3964A40
83861	LL57 3EL	GB	0101000020E6100000ED66463F1A3E10C0BA4BE2AC88984A40
83862	LL57 3HA	GB	0101000020E610000049A12C7C7D3D10C0DE21C50089984A40
83863	LL57 3HS	GB	0101000020E6100000F27D71A94A3B10C02EAC1BEF8E984A40
83864	LL57 3YW	GB	0101000020E610000046EA3D95D34E10C02FDCB930D29B4A40
83865	LL57 4AJ	GB	0101000020E610000082ACA7565F4D10C04B21904B1C974A40
83866	LL57 4BG	GB	0101000020E610000038DC476E4D6A10C0054EB6813B9A4A40
83867	LL57 4BY	GB	0101000020E61000006C98A1F144A010C0F4177AC4E8994A40
83868	LL57 4FB	GB	0101000020E610000056664AEB6FB910C0884A2366F6994A40
83869	LL57 4HE	GB	0101000020E61000005A65A6B4FE7610C04F57772CB6954A40
83870	LL57 4HN	GB	0101000020E6100000C1711937356010C0B680D07AF89C4A40
83871	LL57 4NU	GB	0101000020E61000000135B56CAD8F10C02C634337FB9B4A40
83872	LL57 4SU	GB	0101000020E61000004C1762F5479810C0946934B9189B4A40
83873	LL57 4TW	GB	0101000020E6100000AB798EC8779910C0D4635B069C9B4A40
83874	LL57 4YG	GB	0101000020E61000009B215514AF4210C0A033695375954A40
83875	LL58 8HW	GB	0101000020E6100000B51B7DCC076410C0618DB3E908A24A40
83876	LL58 8YQ	GB	0101000020E6100000950C0055DC6810C07C46223482A14A40
83877	LL59 5AD	GB	0101000020E6100000FE0DDAAB8FA710C0FB96395D169D4A40
83878	LL59 5LR	GB	0101000020E6100000BB473657CDB310C04B94BDA59C9D4A40
83879	LL59 5UW	GB	0101000020E61000006D205D6C5A9910C09DBB5D2F4D9F4A40
83880	LL59 5UY	GB	0101000020E61000006AFB57569A9410C06519E258179F4A40
83881	LL60 6DD	GB	0101000020E6100000730F09DFFB1B11C09886E123629C4A40
83882	LL60 6ZZ	GB	0101000020E6100000F4DF83D72ECD10C0859675FF589C4A40
83883	LL61 5AX	GB	0101000020E6100000A6B73F170DF910C0B7291E17D59E4A40
83884	LL61 5JT	GB	0101000020E610000017EFC7ED97CF10C0DACBB6D3D69C4A40
83885	LL61 5UJ	GB	0101000020E6100000CB2E185C73D710C02788BA0F409C4A40
83886	LL61 6AJ	GB	0101000020E6100000DAAD65321C4F11C09FE925C632954A40
83887	LL61 6HZ	GB	0101000020E6100000A12DE7525C1511C0F701486DE2964A40
83888	LL61 6RS	GB	0101000020E61000007061DD78776411C0AC1A84B9DD934A40
83889	LL61 6SF	GB	0101000020E61000003BFE0B04017211C021ACC612D6944A40
83890	LL61 6SG	GB	0101000020E610000024D1CB28967B11C0CEDE196D55944A40
83891	LL61 6TL	GB	0101000020E6100000315BB22AC25D11C071395E81E8954A40
83892	LL61 6YN	GB	0101000020E610000012C138B8744C11C0505260014C954A40
83893	LL62 5AB	GB	0101000020E610000032E719FB929D11C089B3226AA2994A40
83894	LL62 5AD	GB	0101000020E610000075CDE49B6D9E11C0A9FB00A436994A40
83895	LL62 5NL	GB	0101000020E6100000C4CF7F0F5E9B11C0DC4B1AA3759A4A40
83896	LL62 5NW	GB	0101000020E6100000C9ACDEE1769811C0357F4C6BD39A4A40
83897	LL63 5RY	GB	0101000020E61000001FD95C35CFE111C0B0A9F3A8F89D4A40
83898	LL64 5QW	GB	0101000020E61000002502D53F881412C01EA67D737F9D4A40
83899	LL64 5UX	GB	0101000020E6100000FBEAAA402D1612C0E4A25A44149D4A40
83900	LL65	GB	0101000020E6100000446D1B46415012C01B4CC3F011A74A40
83901	LL65 1AR	GB	0101000020E61000006589CE328B9012C0D44334BA83A84A40
83902	LL65 1ET	GB	0101000020E6100000577C43E1B38512C0E529ABE97AA84A40
83903	LL65 1LF	GB	0101000020E610000080289831059B12C05AD76839D0A74A40
83904	LL65 1RR	GB	0101000020E6100000806264C91C8B12C0BE2EC37FBAA74A40
83905	LL65 2BT	GB	0101000020E61000008E791D71C88612C07BA4C16D6DA74A40
83906	LL65 2DN	GB	0101000020E610000085436FF1F07E12C06DAB59677CA74A40
83907	LL65 2NU	GB	0101000020E610000048DDCEBEF28012C0E04DB7EC10A74A40
83908	LL65 2PW	GB	0101000020E610000039639813B47912C00745F30016A74A40
83909	LL65 2UD	GB	0101000020E6100000EE3F321D3A7D12C0BA8784EFFDA34A40
83910	LL65 3NP	GB	0101000020E610000006F2ECF2AD1F12C0795A7EE02AA34A40
83911	LL65 3PP	GB	0101000020E6100000054D4BAC8CE611C0747CB43863A24A40
83912	LL65 3TL	GB	0101000020E6100000185B0872500212C06C94F59B89A54A40
83913	LL65 4DE	GB	0101000020E6100000249A40118BF811C0FFB3E6C75FAE4A40
83914	LL66 0AT	GB	0101000020E6100000878C47A984B711C07FA1478C9EB34A40
83915	LL66 0AY	GB	0101000020E6100000E23E726BD2BD11C0871403249AB44A40
83916	LL66 0BG	GB	0101000020E6100000207F69519FA411C02B508BC1C3AE4A40
83917	LL67 0DH	GB	0101000020E61000001477BCC96FE111C01CB3EC4960B54A40
83918	LL67 0LB	GB	0101000020E610000086C77E164BD111C08E57207A52B44A40
83919	LL68	GB	0101000020E6100000CB85CABF96C711C045B75ED383B24A40
83920	LL68 0PT	GB	0101000020E610000044A4A65D4CD311C0A375543541B24A40
83921	LL68 0RG	GB	0101000020E610000034BC5983F7D511C01A6CEA3C2AB24A40
83922	LL68 0SA	GB	0101000020E61000002B16BF29ACD411C01424B6BB07B24A40
83923	LL68 9BS	GB	0101000020E610000088669E5C536011C09337C0CC77B44A40
83924	LL68 9DN	GB	0101000020E61000005C7171546E5211C0715AF0A2AFB44A40
83925	LL68 9EA	GB	0101000020E61000004CC79C67EC6B11C03C873254C5B44A40
83926	LL68 9LT	GB	0101000020E61000002D27A1F4853011C02C4A09C1AAB44A40
83927	LL68 9NE	GB	0101000020E6100000BFD6A546E83711C0FE7BF0DAA5B14A40
83928	LL69 9AQ	GB	0101000020E61000003D44A33B883D11C03AB187F6B1B04A40
83929	LL69 9YP	GB	0101000020E610000036AD1402B94411C09E3F6D54A7B14A40
83930	LL70 9DX	GB	0101000020E6100000B1DB6795994211C0213EB0E3BFAE4A40
83931	LL70 9EX	GB	0101000020E6100000E31934F44F3011C0FA415DA450AE4A40
83932	LL71 8DP	GB	0101000020E61000004E4354E1CF8011C009C6C1A563AA4A40
83933	LL72 8HA	GB	0101000020E610000071AFCC5B75FD10C069FD2D01F8AB4A40
83934	LL73 8PL	GB	0101000020E610000026E5EE737CF410C06806F1811DAB4A40
83935	LL74 8SG	GB	0101000020E6100000ADDBA0F65BEB10C08C84B69C4BA94A40
83936	LL74 8UA	GB	0101000020E61000009EEFA7C64BE710C0D1C952EBFDA84A40
83937	LL75 8UP	GB	0101000020E61000004969368FC3E010C0E010AAD4ECA34A40
83938	LL75 8YS	GB	0101000020E61000000CCA349A5CDC10C0FE0B040132A24A40
83939	LL76 8SX	GB	0101000020E61000003FE3C28190EC10C02AA8A8FA95A64A40
83940	LL77 7HR	GB	0101000020E610000079CBD58F4D3211C07DEBC37AA3A04A40
83941	LL77 7LZ	GB	0101000020E610000092240857407111C0D175E107E7A14A40
83942	LL77 7NY	GB	0101000020E61000007CB94F8E024411C005A4FD0FB0A04A40
83943	LL77 7UT	GB	0101000020E61000008318E8DA174011C04641F0F8F6A84A40
83944	LL77 7UU	GB	0101000020E610000010ECF82F102411C04BCADDE7F8A44A40
83945	LL78 8QA	GB	0101000020E6100000CB4DD4D2DC0A11C05E49F25CDFA74A40
83946	LL9	GB	0101000020E6100000B0AC342905BD0FC07022FAB5F55F4A40
83947	LN1 1EZ	GB	0101000020E6100000D6C8AEB48C54E1BFD8D5E429AB9D4A40
83948	LN1 1HS	GB	0101000020E610000040A20914B188E1BFDEFFC709139E4A40
83949	LN1 1JT	GB	0101000020E61000003CDEE4B7E864E1BF05BF0D315E9D4A40
83950	LN1 1LB	GB	0101000020E6100000B58828266F80E1BF554E7B4ACE9D4A40
83951	LN1 1LF	GB	0101000020E6100000A2427573F1B7E1BF759483D9049E4A40
83952	LN1 1LR	GB	0101000020E6100000A301BC051294E1BF13B534B7429E4A40
83953	LN1 1WE	GB	0101000020E6100000586FD40AD3F7E1BF2F8672A25D9F4A40
83954	LN1 2	GB	0101000020E6100000300DC347C414E5BF5307793D98A24A40
83955	LN1 2HN	GB	0101000020E6100000E31934F44FF0E4BF3BC8EBC1A4A24A40
83956	LN1 2HX	GB	0101000020E6100000A5BE2CEDD45CE7BFB9C667B27FA44A40
83957	LN1 2NS	GB	0101000020E610000046ED7E15E03BE5BFEB387EA834A24A40
83958	LN1 2PE	GB	0101000020E6100000804413286211E5BF910DA48B4DA34A40
83959	LN1 2WP	GB	0101000020E610000037177FDB1324E3BFC8D11C59F99F4A40
83960	LN1 3EJ	GB	0101000020E6100000AB7B6473D53CE1BFA0C1A6CEA39E4A40
83961	LN1 3JB	GB	0101000020E6100000E065868DB27EE1BF348639419B9E4A40
83962	LN1 3JD	GB	0101000020E6100000D1798D5DA27AE1BFB4E55C8AAB9E4A40
83963	LN1 3NQ	GB	0101000020E61000003C670B08AD87E1BF950D6B2A8B9E4A40
83964	LN1 3PG	GB	0101000020E610000007B13385CE6BE1BFFCE25295B69E4A40
83965	LN1 3UB	GB	0101000020E610000035D252793BC2E1BFBA4BE2AC88A04A40
83966	LN10 5DT	GB	0101000020E6100000F146E6913F18D0BFA6B4FE96009A4A40
83967	LN10 6PX	GB	0101000020E6100000F48B12F4177ACABFFE463B6EF8934A40
83968	LN10 6QD	GB	0101000020E6100000B7B585E7A562CBBFAE8218E8DA934A40
83969	LN10 6TY	GB	0101000020E610000068EA758BC058CBBF48F949B54F934A40
83970	LN11	GB	0101000020E61000006022DE3AFF76793FE59B6D6E4CAD4A40
83971	LN11 0AA	GB	0101000020E6100000790778D2C265553F3DF20703CFAF4A40
83972	LN11 0HG	GB	0101000020E6100000A29A92ACC3D175BF61DF4E22C2AF4A40
83973	LN11 0HU	GB	0101000020E6100000F19E03CB113280BFD600A5A146AF4A40
83974	LN11 0RU	GB	0101000020E6100000FE28EACC3D24A4BFE6AC4F3926AF4A40
83975	LN11 0TB	GB	0101000020E61000001D39D219187999BFE9B7AF03E7B24A40
83976	LN11 7RY	GB	0101000020E6100000BE1248895DDBC73FF3583332C8B54A40
83977	LN11 7RZ	GB	0101000020E6100000C0D02346CF2DC83FE1CFF0660DB64A40
83978	LN11 7SP	GB	0101000020E61000009D6681768714C33FC5AD8218E8B04A40
83979	LN11 8LH	GB	0101000020E61000009BAC510FD1E8A63FABED26F8A6AB4A40
83980	LN11 8LJ	GB	0101000020E61000001EA7E8482EFFA93F8061F9F36DAB4A40
83981	LN11 8LW	GB	0101000020E610000066136058FE7C8B3F1904560E2DAA4A40
83982	LN11 8RZ	GB	0101000020E61000004643C6A354C2633F7286E28E37AF4A40
83983	LN11 8SP	GB	0101000020E61000000B5F5FEB5223B83F1EC4CE143AAF4A40
83984	LN11 9DU	GB	0101000020E6100000CEE15AED612F343F9B728577B9AE4A40
83985	LN11 9TJ	GB	0101000020E610000075914259F8FAC2BF540262122EAA4A40
83986	LN12	GB	0101000020E6100000A565A4DE5339D13F96CB46E7FCAA4A40
83987	LN12 1EW	GB	0101000020E61000001764CBF27519D03FC503CAA65CAB4A40
83988	LN12 1LR	GB	0101000020E6100000376E313F3734D03F2DCF83BBB3AC4A40
83989	LN12 1LT	GB	0101000020E6100000E1B6B6F0BC54D03FE00ED4298FAC4A40
83990	LN12 1LW	GB	0101000020E6100000978DCEF9298ECF3F8AE42B8194AC4A40
83991	LN12 2SA	GB	0101000020E610000014799274CDE4D03FE4BED53A71AB4A40
83992	LN13	GB	0101000020E6100000A69A594B0169C73F418177F2E9A14A40
83993	LN13 0BB	GB	0101000020E61000009B1F7F69519FB03F54E23AC615A34A40
83994	LN13 0NB	GB	0101000020E6100000A2D5C9198A3BC23F0ABFD4CF9BA84A40
83995	LN13 0PL	GB	0101000020E610000026E2ADF36F97C53F5A0D897B2CA14A40
83996	LN13 9	GB	0101000020E6100000BC3FDEAB5626C63F3A92CB7F48A14A40
83997	LN13 9AX	GB	0101000020E61000003A0664AF777FC63FFEF2C98AE1A04A40
83998	LN13 9DJ	GB	0101000020E6100000889E94490D6DC63F7CB5A33847A14A40
83999	LN13 9EQ	GB	0101000020E610000040DAFF006BD5C63F0D52F01472A14A40
84000	LN13 9HP	GB	0101000020E610000000AE64C74620C63F7F2E1A321EA14A40
84001	LN13 9JS	GB	0101000020E61000007008556AF640D13F0516C094819F4A40
84002	LN2	GB	0101000020E6100000D1764CDD955DDFBFF88DAF3DB3A24A40
84003	LN2 2	GB	0101000020E6100000FB3A70CE88D2DFBF9B5775560BA24A40
84004	LN2 2PY	GB	0101000020E61000001A6A1492CCEADFBFAF0793E2E3A14A40
84005	LN2 2QJ	GB	0101000020E61000007A1C06F357C8DCBFA5DB12B9E0A24A40
84006	LN2 2QS	GB	0101000020E6100000658D7A884677DCBF72FE261422A24A40
84007	LN2 2QT	GB	0101000020E61000008F19A88C7F9FDCBF423F53AF5BA24A40
84008	LN2 2YD	GB	0101000020E6100000FAD005F52D73DCBFBEBD6BD097A24A40
84009	LN2 3FE	GB	0101000020E610000054E41071732ADEBF4E4700378BA74A40
84010	LN2 3FQ	GB	0101000020E61000001FD7868A71FEDEBF0DC1711937A74A40
84011	LN2 3LJ	GB	0101000020E6100000C5AC174339D1DEBFD09CF529C7A64A40
84012	LN2 4BU	GB	0101000020E610000034A0DE8C9AAFE0BF06D7DCD1FF9E4A40
84013	LN2 4BY	GB	0101000020E61000006612F5824F73E0BF555051F52B9F4A40
84014	LN2 4HB	GB	0101000020E6100000D461855B3E92E0BFE55FCB2BD79F4A40
84015	LN2 4PJ	GB	0101000020E610000079AF5A99F0CBE0BF4489963C9E9E4A40
84016	LN2 5HA	GB	0101000020E6100000C9C859D8D30EE1BF42CEFBFF389D4A40
84017	LN2 5NG	GB	0101000020E6100000B115342DB132E0BF9B1F7F69519D4A40
84018	LN2 5PU	GB	0101000020E61000004CFBE6FEEA71E0BFE99E758D969D4A40
84019	LN2 5RD	GB	0101000020E61000006D003620425CE0BF09A52F849C9D4A40
84020	LN3 4AQ	GB	0101000020E6100000C00644882B67DDBF23BDA8DDAF9E4A40
84021	LN3 4EF	GB	0101000020E6100000D1E638B709F7DBBF7EACE0B721A04A40
84022	LN3 4HF	GB	0101000020E610000018CDCAF6216FDBBFD4D688601C9E4A40
84023	LN3 5UD	GB	0101000020E61000007D91D0967329D5BF57D0B4C4CA9A4A40
84024	LN4	GB	0101000020E610000028BA2EFCE07CDBBF2522FC8BA0934A40
84025	LN4 1AA	GB	0101000020E61000007EFFE6C589AFDEBF28BA2EFCE09C4A40
84026	LN4 1EL	GB	0101000020E61000001F477364E597DEBFF3734353769C4A40
84027	LN4 1EQ	GB	0101000020E6100000CD3B4ED1915CDEBF4CC5C6BC8E9C4A40
84028	LN4 1EX	GB	0101000020E61000007AA702EE79FEDEBF13EF004F5A9C4A40
84029	LN4 1RW	GB	0101000020E61000004A4563EDEF6CDDBFE8323509DE9A4A40
84030	LN4 2BF	GB	0101000020E6100000B9C7D2872EA8DABFB8ACC26680954A40
84031	LN4 2BG	GB	0101000020E610000085436FF1F09EDABF7B82C476F7944A40
84032	LN4 2BH	GB	0101000020E61000008CBD175FB4C7DABFED6305BF0D954A40
84033	LN4 2BJ	GB	0101000020E61000006F66F4A3E194DABFC217265305954A40
84034	LN4 2EA	GB	0101000020E61000007CD3F4D901D7D9BF6346787B10924A40
84035	LN4 2EH	GB	0101000020E6100000D3F544D7851FDABF664B5645B8934A40
84036	LN4 2HN	GB	0101000020E61000008EAED2DD7536E1BFFA7E6ABC74994A40
84037	LN4 2PH	GB	0101000020E61000008D7C5EF1D423E1BFE833A0DE8C984A40
84038	LN4 2RR	GB	0101000020E6100000008DD2A57FC9E0BFA2EC2DE57C9B4A40
84039	LN4 2TU	GB	0101000020E610000024F25D4A5DB2E0BFD464C6DB4A994A40
84040	LN4 3AQ	GB	0101000020E610000019028063CF9ED7BF7F85CC9541934A40
84041	LN4 3EF	GB	0101000020E6100000ED461FF30181E0BF384D9F1D70834A40
84042	LN4 3HX	GB	0101000020E61000006C97361C9606D9BF3E26529ACD914A40
84043	LN4 3JE	GB	0101000020E610000055A4C2D84290DBBF1497E315888C4A40
84044	LN4 3LH	GB	0101000020E61000007F349C3237DFDBBF61DD7877648C4A40
84045	LN4 3QT	GB	0101000020E61000006AA4A5F27684D4BF946DE00ED48F4A40
84046	LN4 3QY	GB	0101000020E61000006FBDA60705A5D4BF562AA8A8FA8F4A40
84047	LN4 3YG	GB	0101000020E61000005ABA826DC493D9BFCF87670932924A40
84048	LN4 4ED	GB	0101000020E6100000F418E59997C3D1BFC1FD8007068A4A40
84049	LN4 4LR	GB	0101000020E6100000522635B401D8C8BFCB9E0436E78C4A40
84050	LN4 4NQ	GB	0101000020E61000000229B16B7BBBC5BFE73A8DB4548C4A40
84051	LN4 4QB	GB	0101000020E610000041B7973446EBC2BF06A051BAF48B4A40
84052	LN4 4YQ	GB	0101000020E61000007D91D0967329B6BFA64412BD8C844A40
84053	LN5	GB	0101000020E6100000703E75AC527AE1BF4C361E6CB1874A40
84054	LN5 0DB	GB	0101000020E6100000BBD1C77C4020E1BF93FC885FB18C4A40
84055	LN5 0DH	GB	0101000020E6100000815B77F35487DFBF522976340E874A40
84056	LN5 0NF	GB	0101000020E610000027309DD66DD0E1BF952C27A1F4894A40
84057	LN5 0PL	GB	0101000020E610000094861A852433E2BFFCA886FD9E884A40
84058	LN5 7EW	GB	0101000020E61000002E7590D78349E1BFEDBB22F8DF9C4A40
84059	LN5 7UJ	GB	0101000020E6100000C4B304190115E1BFB75F3E59319C4A40
84060	LN5 7UL	GB	0101000020E61000002C7E5358A920E1BF2788BA0F409C4A40
84061	LN5 9DD	GB	0101000020E6100000C422861DC6A4E1BF97FF907EFB964A40
84062	LN5 9GJ	GB	0101000020E6100000DCD5ABC8E880E1BF03081F4AB4924A40
84063	LN5 9NB	GB	0101000020E6100000CDE9B298D8FCE0BFDAAB8F87BE954A40
84064	LN5 9SN	GB	0101000020E61000000684D6C39789E1BF1FF818AC38934A40
84065	LN6	GB	0101000020E6100000899AE8F351C6E2BF85E97B0DC1994A40
84066	LN6 0AW	GB	0101000020E6100000ECDB4944F897E2BFAAF06778B39A4A40
84067	LN6 0HF	GB	0101000020E6100000F6ECB94C4D82E2BF1AF9BCE2A99B4A40
84068	LN6 0JG	GB	0101000020E6100000E2B19FC55224E3BF2BDF3312A19B4A40
84069	LN6 0PX	GB	0101000020E6100000EA059FE6E4C5E3BFCEC47421569B4A40
84070	LN6 0RN	GB	0101000020E6100000A8E2C62DE6E7E2BF930035B56C9B4A40
84071	LN6 0TB	GB	0101000020E610000008008E3D7BAEE3BF6B0F7BA1809B4A40
84072	LN6 3PA	GB	0101000020E6100000F9D7F2CAF536E3BF76E3DD91B19A4A40
84073	LN6 5TN	GB	0101000020E61000004888F2052DA4E3BF334E4354E19D4A40
84074	LN6 5UB	GB	0101000020E6100000AEF4DA6CACC4E3BFFB75A73B4F9E4A40
84075	LN6 7JU	GB	0101000020E6100000AA7D3A1E3350E1BF821DFF05829C4A40
84076	LN6 7LY	GB	0101000020E6100000520B2593533BE2BF5CC7B8E2E29A4A40
84077	LN6 7TS	GB	0101000020E61000008143A852B387E1BFC6C37B0E2C9D4A40
84078	LN6 8	GB	0101000020E61000003D601E32E543E2BF3849F3C7B4984A40
84079	LN6 8AS	GB	0101000020E6100000A47213B53437E2BF834F73F222994A40
84080	LN6 8NT	GB	0101000020E6100000B3295778978BE2BF2C499EEBFB9A4A40
84081	LN6 9AL	GB	0101000020E6100000A1F831E6AE25E3BF31B610E4A0984A40
84082	LN6 9AT	GB	0101000020E61000000F5F268A903AE3BFC362D4B5F6984A40
84083	LN6 9BG	GB	0101000020E6100000908653E6E69BE4BF5BB05417F0964A40
84084	LN6 9HY	GB	0101000020E6100000C6E1CCAFE680E6BFB37A87DBA1954A40
84085	LN6 9LA	GB	0101000020E61000008109DCBA9B27E3BF0553CDACA5984A40
84086	LN6 9LE	GB	0101000020E6100000E77118CC5FA1E6BF959C137B688D4A40
84087	LN6 9LN	GB	0101000020E61000005ABBED42739DE3BFC16ED8B628974A40
84088	LN6 9TN	GB	0101000020E61000000EA2B5A2CD71E5BF0DA837A3E6934A40
84089	LN7 6HE	GB	0101000020E6100000BFEE74E789E7D8BF89B663EAAEC04A40
84090	LN7 6JB	GB	0101000020E61000001CEDB8E177D3D8BFFBCA83F414BD4A40
84091	LN7 6NT	GB	0101000020E610000011E50B5A48C0D4BF703E75AC52BE4A40
84092	LN7 6QA	GB	0101000020E610000062F71DC3633FD5BFC0B33D7AC3BF4A40
84093	LN7 6QH	GB	0101000020E610000093A7ACA6EB89D4BF691B7FA2B2BF4A40
84094	LN8 2AY	GB	0101000020E61000000A849D62D5A0E0BF49490F43ABB54A40
84095	LN8 2DL	GB	0101000020E61000005E9ECE15A504E1BF2009FB7612AD4A40
84096	LN8 3	GB	0101000020E61000006E30D461855BD8BF30B95164ADB54A40
84097	LN8 3AQ	GB	0101000020E61000001CB62DCA6C90D5BFA489778027B14A40
84098	LN8 3EA	GB	0101000020E6100000471E882CD2C4D4BF459F8F32E2B04A40
84099	LN8 3EY	GB	0101000020E6100000234910AE8042DFBFBCEA01F390B34A40
84100	LN8 3JW	GB	0101000020E6100000F5DA6CACC43CD6BF6534F279C5B14A40
84101	LN8 3NE	GB	0101000020E6100000A86F99D36531DCBF4888F2052DAE4A40
84102	LN8 3TS	GB	0101000020E61000000A67B796C970D7BF5D8940F50FB24A40
84103	LN8 3YD	GB	0101000020E6100000888384285FD0D1BF9981CAF8F7B14A40
84104	LN8 5PX	GB	0101000020E6100000EFE53E390A10D2BF787DE6AC4FA34A40
84105	LN8 6JH	GB	0101000020E610000086730D33349EC8BFCA51802898A94A40
84106	LN8 6NL	GB	0101000020E6100000B6F7A92A3410CBBFD07EA4880CAB4A40
84107	LN9	GB	0101000020E610000089D00836AE7FBFBF95607138F39D4A40
84108	LN9 5AU	GB	0101000020E610000059A2B3CC2214BFBF8CBE8234639B4A40
84109	LN9 5HF	GB	0101000020E610000037A6272CF180BEBFF3CAF5B6999A4A40
84110	LN9 5NW	GB	0101000020E610000048DE3994A12ACCBFB9FDF2C98AA14A40
84111	LN9 5PP	GB	0101000020E6100000AA4885B18520BBBF8313D1AFAD9B4A40
84112	LN9 5QF	GB	0101000020E610000007EA944737C2C2BFFC17080264A04A40
84113	LN9 6AS	GB	0101000020E610000065170CAEB9A3BBBF7445292158994A40
84114	LN9 6EL	GB	0101000020E610000034D593F947DFBCBF14EB54F99E994A40
84115	LN9 6RF	GB	0101000020E6100000A5BF97C28366BBBF83DDB06D519A4A40
84116	LS1	GB	0101000020E610000035D252793B82F8BF944A7842AFE54A40
84117	LS1 2DH	GB	0101000020E6100000AEF02E17F1DDF8BF8C31B08EE3E54A40
84118	LS1 2ED	GB	0101000020E61000003A2009FB76D2F8BFFA42C879FFE54A40
84119	LS1 2SZ	GB	0101000020E610000099A0866F61DDF8BFB404190115E64A40
84120	LS1 3EX	GB	0101000020E6100000998235CEA6E3F8BFE605D847A7E64A40
84121	LS1 4DY	GB	0101000020E610000092EA3BBF28C1F8BF00016BD5AEE54A40
84122	LS1 5AB	GB	0101000020E61000007D3ECA880BC0F8BF8B54185B08E64A40
84123	LS10	GB	0101000020E6100000D1CC936B0A64F8BFB05417F032E34A40
84124	LS10 1BL	GB	0101000020E61000000BB77C24253DF8BFC9AF1F6283E34A40
84125	LS10 1ET	GB	0101000020E6100000E27668588CBAF8BF7A1B9B1DA9E44A40
84126	LS10 1JH	GB	0101000020E6100000C573B680D0BAF8BF93C6681D55E54A40
84127	LS10 1XX	GB	0101000020E6100000C845B5882866F8BF068200193AE44A40
84128	LS10 3DX	GB	0101000020E6100000F3599E077767F8BFFCDEA63FFBE14A40
84129	LS10 3NG	GB	0101000020E61000002E8CF4A2767FF8BFF81A82E332E04A40
84130	LS10 4SE	GB	0101000020E6100000C36169E04775F8BF319A95ED43E24A40
84131	LS10 4UW	GB	0101000020E6100000D47FD6FCF84BF8BFF5BC1B0B0AE14A40
84132	LS11	GB	0101000020E61000005706D5062722F9BF75E789E76CE34A40
84133	LS11 0JN	GB	0101000020E6100000FCFD62B66415F9BFFEEE1D3526E24A40
84134	LS11 0JT	GB	0101000020E61000008B53AD855968F9BFC09481035AE24A40
84135	LS11 5BF	GB	0101000020E6100000B0E595EB6DF3F8BFEC6987BF26E14A40
84136	LS11 5EN	GB	0101000020E61000006F4A79AD84AEF8BFB3EF8AE07FE34A40
84137	LS11 5QA	GB	0101000020E6100000ADDD76A1B9CEF8BF0ADAE4F049E54A40
84138	LS11 5TE	GB	0101000020E6100000938C9C853D6DF8BF22C154336BE94A40
84139	LS11 5WF	GB	0101000020E6100000A7CF0EB8AED8F8BF90BC732843E54A40
84140	LS11 6DJ	GB	0101000020E6100000FD6A0E10CCD1F8BFBA826DC493E34A40
84141	LS11 6DS	GB	0101000020E6100000A06F0B96EAC2F8BF5DA8FC6B79E34A40
84142	LS11 7BT	GB	0101000020E610000079CA6ABA9EE8F8BF3927F6D03EE24A40
84143	LS11 7JJ	GB	0101000020E61000008B8C0E48C2FEF8BF66F6798CF2E24A40
84144	LS11 7JW	GB	0101000020E6100000E35295B6B806F9BF4CE141B3EBE24A40
84145	LS11 7PB	GB	0101000020E6100000D7BE805EB8F3F8BF0400C79E3DE34A40
84146	LS11 8JW	GB	0101000020E6100000F697DD938785F9BF035FD1ADD7E24A40
84147	LS11 8PG	GB	0101000020E61000006EC493DDCC28F9BF3B38D89B18E24A40
84148	LS11 8QP	GB	0101000020E6100000DC4944F81701F9BF5BD2510E66E34A40
84149	LS11 9QH	GB	0101000020E6100000D89B189293C9F8BFEA5BE67459E44A40
84150	LS11 9YJ	GB	0101000020E6100000145D177E70BEF8BF63096B63ECE44A40
84151	LS12	GB	0101000020E6100000A37554354114F9BF0E2E1D739EE54A40
84152	LS12 1DR	GB	0101000020E61000003944DC9C4A06F9BF13F1D6F9B7E54A40
84153	LS12 1SR	GB	0101000020E61000003D0CAD4ECED0F8BF7AA702EE79E64A40
84154	LS12 2BE	GB	0101000020E6100000103FFF3D786DF9BF5D6A847EA6E64A40
84155	LS12 3DZ	GB	0101000020E6100000F48AA71E69B0F9BF761A69A9BCE54A40
84156	LS12 3HD	GB	0101000020E6100000C8B4368DED75F9BFE90E62670AE54A40
84157	LS12 3JE	GB	0101000020E6100000EF8CB62A896CF9BF88B839950CE84A40
84158	LS12 3NW	GB	0101000020E61000005E2C0C91D397F9BF159161156FE64A40
84159	LS12 3QN	GB	0101000020E6100000DFC14F1C40BFF9BF62F5471806E64A40
84160	LS12 3RR	GB	0101000020E610000091B75CFDD8A4F9BF4703780B24E64A40
84161	LS12 4HF	GB	0101000020E610000089096AF81696F9BF2F17F19D98E54A40
84162	LS12 4PD	GB	0101000020E6100000AE2CD1596691F9BFD34A21904BE64A40
84163	LS12 5AF	GB	0101000020E610000076FC17080264F9BF4EB340BB43E84A40
84164	LS12 6LP	GB	0101000020E610000072FE261422A0F9BF9AB67F65A5E34A40
84165	LS13	GB	0101000020E610000041BB438A0112FABF2B1895D409E84A40
84166	LS13 1NB	GB	0101000020E61000000CCC0A45BA9FFABF61E0B9F770E94A40
84167	LS13 1NG	GB	0101000020E6100000F12BD67091BBFABF377007EA94E94A40
84168	LS13 2AG	GB	0101000020E61000002E55698B6B3CFABF3D2AFEEF88E84A40
84169	LS13 2AW	GB	0101000020E6100000F3E670ADF630FABF9D83674293E84A40
84170	LS13 2BJ	GB	0101000020E61000008011346612F5F9BFC3B81B446BE74A40
84171	LS13 2HS	GB	0101000020E6100000454772F90FE9F9BF984EEB36A8E74A40
84172	LS13 2TL	GB	0101000020E6100000D97745F0BFD5F9BFD4B5F63E55E74A40
84173	LS13 3JW	GB	0101000020E6100000897D02284616FABFD6FECEF6E8E74A40
84174	LS13 3PS	GB	0101000020E6100000CBF44BC45B27FABFE8887C9752E74A40
84175	LS13 3QE	GB	0101000020E61000005A677C5F5C2AFABF263ACB2C42E74A40
84176	LS13 3ST	GB	0101000020E61000006346787B1002FABF88122D793CE74A40
84177	LS13 4	GB	0101000020E6100000070B2769FE18FABF959D7E5017E74A40
84178	LS13 4DU	GB	0101000020E61000008657923CD737FABF4DBD6E1118E74A40
84179	LS14	GB	0101000020E61000006FBDA6070565F7BF7A36AB3E57E74A40
84180	LS14 1	GB	0101000020E6100000BDFE243E7782F7BFAF06280D35EA4A40
84181	LS14 1HD	GB	0101000020E6100000419B1C3EE944F7BF36E49F19C4E94A40
84182	LS14 1PG	GB	0101000020E610000035D3BD4EEA8BF7BF068200193AEA4A40
84183	LS14 3HJ	GB	0101000020E610000015376E313F37F7BFFEB968C878EE4A40
84184	LS14 3JD	GB	0101000020E61000003ECC5EB69DB6F6BF18963FDF16EE4A40
84185	LS14 5PD	GB	0101000020E6100000D13DEB1A2D07F7BF6E50FBAD9DE84A40
84186	LS14 6UT	GB	0101000020E61000008CBFED09129BF7BF1C3F541A31E74A40
84187	LS14 7PN	GB	0101000020E610000094A2957B8119F7BF471E882CD2E84A40
84188	LS15 0HT	GB	0101000020E610000023BC3D080179F7BFC91CCBBBEAE54A40
84189	LS15 0LG	GB	0101000020E61000003B730F09DF7BF7BF7CB4386398E54A40
84190	LS15 4AX	GB	0101000020E610000090A339B2F2CBF6BF865AD3BCE3EA4A40
84191	LS15 4BP	GB	0101000020E61000007DAD4B8DD0CFF6BFECF82F1004EA4A40
84192	LS15 4DF	GB	0101000020E61000003A083A5AD592F6BF36B1C05774E94A40
84193	LS15 4DH	GB	0101000020E61000007157AF22A3C3F6BFD1CE691668E94A40
84194	LS15 4HS	GB	0101000020E61000003DBB7CEBC37AF6BF8C48145AD6E94A40
84195	LS15 4JN	GB	0101000020E6100000ADBF2500FF54F6BFC4EE3B86C7EA4A40
84196	LS15 4PB	GB	0101000020E6100000EE21E17B7F43F6BF01DD9733DBE94A40
84197	LS15 7AG	GB	0101000020E610000049641F645930F7BF2C4487C091E64A40
84198	LS15 7AY	GB	0101000020E6100000FEEDB25F773AF7BF66A19DD32CE64A40
84199	LS15 7EJ	GB	0101000020E6100000BC0512143F46F7BF52B648DA8DE64A40
84200	LS15 7EP	GB	0101000020E61000002E7079AC1959F7BF2F6B6281AFE64A40
84201	LS15 7PG	GB	0101000020E6100000220038F6ECF9F6BF747ADE8D05E74A40
84202	LS15 8BX	GB	0101000020E6100000B43EE5982C2EF7BF465ED6C402E74A40
84203	LS15 8NZ	GB	0101000020E6100000A35BAFE94101F7BFB587BD50C0E64A40
84204	LS15 8PX	GB	0101000020E6100000A7751BD47EEBF6BF643A747ADEE54A40
84205	LS16	GB	0101000020E6100000944F8F6D19F0F9BF42226DE34FEE4A40
84206	LS16 5AL	GB	0101000020E61000004B04AA7F1089F9BF0FD3BEB9BFEA4A40
84207	LS16 5AZ	GB	0101000020E6100000908653E6E69BF9BF0AF8359204EB4A40
84208	LS16 5BS	GB	0101000020E6100000450F7C0C569CF9BFCFBEF2203DEB4A40
84209	LS16 5DZ	GB	0101000020E61000004CE3175E49B2F9BFACC5A70018EB4A40
84210	LS16 5EB	GB	0101000020E61000001348895DDB9BF9BF9CFC169D2CEB4A40
84211	LS16 5HW	GB	0101000020E610000001F9122A387CF9BF5DA5BBEB6CEA4A40
84212	LS16 5JA	GB	0101000020E6100000F3565D876A8AF9BF66D828EB37EB4A40
84213	LS16 5JG	GB	0101000020E6100000E621533E0455F9BFF73E558506EA4A40
84214	LS16 5JZ	GB	0101000020E6100000D5CA845FEA67F9BF2C9D0FCF12EA4A40
84215	LS16 5LZ	GB	0101000020E61000007CF0DAA50D47F9BF2F8A1EF818EA4A40
84216	LS16 5NA	GB	0101000020E6100000FFE89B340D4AF9BF39B35DA10FEA4A40
84217	LS16 5PW	GB	0101000020E6100000BADC60A8C3CAF9BF2E8ECA4DD4EA4A40
84218	LS16 6BR	GB	0101000020E61000006325E65949ABF9BFBA4A77D7D9EC4A40
84219	LS16 6EH	GB	0101000020E6100000255B5D4E0908FABFFC51D4997BEC4A40
84220	LS16 6EJ	GB	0101000020E6100000A0FCDD3B6A8CF9BF3A58FFE730EB4A40
84221	LS16 6HH	GB	0101000020E6100000CF6A813D2692F9BF9128B4ACFBEB4A40
84222	LS16 6HU	GB	0101000020E61000005531957EC299F9BFBD0166BE83EB4A40
84223	LS16 6JA	GB	0101000020E6100000DFFAB0DEA895F9BF6CB07092E6EB4A40
84224	LS16 6LL	GB	0101000020E6100000F568AA27F34FF9BF0DFCA886FDEE4A40
84225	LS16 6SD	GB	0101000020E6100000D00CE2033BBEF9BF8D45D3D9C9EC4A40
84226	LS16 6TZ	GB	0101000020E610000074B7EBA529C2F9BF03B5183C4CEB4A40
84227	LS16 7HG	GB	0101000020E6100000F355F2B1BB00FABF24EEB1F4A1ED4A40
84228	LS16 7HS	GB	0101000020E610000078094E7D20F9F9BF63635E471CEE4A40
84229	LS16 7LJ	GB	0101000020E6100000B6DAC35E28E0F9BF1406651A4DEE4A40
84230	LS16 7QD	GB	0101000020E6100000A2293BFDA0AEF9BF7C9E3F6D54ED4A40
84231	LS16 8HL	GB	0101000020E61000008369183E2266F9BF368FC360FEEA4A40
84232	LS16 8LB	GB	0101000020E61000001442075DC221F9BF568330B77BEB4A40
84233	LS16 8LN	GB	0101000020E610000075E789E76C41F9BFC66AF3FFAAED4A40
84234	LS16 9AH	GB	0101000020E6100000FCA9F1D24DE2F9BFABCB290131F14A40
84235	LS16 9BE	GB	0101000020E6100000D367075C57CCF9BF687A89B14CF14A40
84236	LS16 9BU	GB	0101000020E6100000AF2479AEEFC3F9BF8D2782380FF14A40
84237	LS16 9DQ	GB	0101000020E6100000814067D2A6AAF9BFF296AB1F9BF04A40
84238	LS16 9EU	GB	0101000020E6100000FF774485EAA6F9BFF92D3A596AF14A40
84239	LS16 9HU	GB	0101000020E610000072DD94F25A49FABF44DD0720B5F14A40
84240	LS16 9JG	GB	0101000020E6100000107A36AB3ED7F9BFE7C8CA2F83F14A40
84241	LS17	GB	0101000020E61000003D484F9143C4F8BFEBAD81AD12F04A40
84242	LS17 0HL	GB	0101000020E61000007923F3C81F4CF9BF643F8BA548F64A40
84243	LS17 5AE	GB	0101000020E6100000971E4DF564BEF8BF30F65E7CD1EA4A40
84244	LS17 5EH	GB	0101000020E6100000A2B60DA320F8F8BF793D98141FED4A40
84245	LS17 5HW	GB	0101000020E610000059FCA6B05201F9BF782634492CED4A40
84246	LS17 5PS	GB	0101000020E610000040DCD5ABC828F9BF5EBC1FB75FEE4A40
84247	LS17 6EG	GB	0101000020E61000009BABE639225FF8BFA94E07B29EEC4A40
84248	LS17 6HU	GB	0101000020E6100000AC730CC85EAFF8BF5D6F9BA910EB4A40
84249	LS17 6HZ	GB	0101000020E61000001327F73B1485F8BF9A22C0E95DEC4A40
84250	LS17 6LE	GB	0101000020E6100000255D33F9669BF8BFAFEC82C135EB4A40
84251	LS17 6LW	GB	0101000020E610000085419946938BF8BF1EF98381E7EA4A40
84252	LS17 6NE	GB	0101000020E6100000EDB94C4D8277F8BF2F35423F53EB4A40
84253	LS17 6NG	GB	0101000020E61000005FB35C363A27F8BF0DDFC2BAF1EC4A40
84254	LS17 6PB	GB	0101000020E61000004582A966D692F8BF541B9C887EEB4A40
84255	LS17 6QE	GB	0101000020E61000008C48145AD67DF8BF9C8C2AC3B8EB4A40
84256	LS17 6RZ	GB	0101000020E6100000C2A38D23D662F8BFCDAB3AAB05EC4A40
84257	LS17 7DF	GB	0101000020E6100000213F1BB96E8AF8BF0327DBC01DEE4A40
84258	LS17 7DT	GB	0101000020E6100000E3C4573B8AF3F8BFF52D73BA2CEE4A40
84259	LS17 7HR	GB	0101000020E61000000283A44FABA8F8BF29D027F224ED4A40
84260	LS17 7QD	GB	0101000020E6100000404D2D5BEB0BF9BFD6E6FF5547EE4A40
84261	LS17 8DQ	GB	0101000020E6100000B9FFC874E874F8BF4BE7C3B304ED4A40
84262	LS17 8LA	GB	0101000020E61000009487855AD37CF7BF5DA3E5400FED4A40
84263	LS17 8NT	GB	0101000020E610000049A297512C37F8BFE0F60489EDEC4A40
84264	LS17 8NZ	GB	0101000020E61000001B47ACC5A740F8BF03B00111E2EC4A40
84265	LS17 9AG	GB	0101000020E6100000CC0A45BA9F13F7BF3354C554FAF14A40
84266	LS17 9DY	GB	0101000020E6100000942F68210163F7BF412E71E481F04A40
84267	LS17 9EJ	GB	0101000020E610000006D847A7AE3CF7BFEBFCDB65BFF24A40
84268	LS17 9EP	GB	0101000020E61000001C7E37DDB243F7BFD8EF8975AAF24A40
84269	LS17 9LF	GB	0101000020E6100000C0B33D7AC37DF8BFEB1F4432E4F24A40
84270	LS17 9LH	GB	0101000020E6100000B34467994528F8BFA911FA997AF34A40
84271	LS18 4DH	GB	0101000020E61000008D25AC8DB153FABFA0353FFED2EA4A40
84272	LS18 4DQ	GB	0101000020E610000098A25C1ABFF0F9BFDFE1766858EA4A40
84273	LS18 4EG	GB	0101000020E61000005FF0694E5EA4FABF6BD784B4C6EA4A40
84274	LS18 4HR	GB	0101000020E610000073F38DE89EF5F9BFDEC9A7C7B6EA4A40
84275	LS18 4LN	GB	0101000020E610000059DB148F8B2AFABFB2D6506A2FEA4A40
84276	LS18 4NJ	GB	0101000020E61000005F5E807D742AFABF412E71E481EA4A40
84277	LS18 4PH	GB	0101000020E61000008D0C7217614AFABF0403081F4AEA4A40
84278	LS18 4QE	GB	0101000020E6100000E4C0ABE5CE4CFABF994528B682EA4A40
84279	LS18 4RW	GB	0101000020E6100000B9C667B27F1EFABF2079E75086EA4A40
84280	LS18 5DD	GB	0101000020E6100000AE10566309EBF9BF15FDA19927EB4A40
84281	LS18 5DP	GB	0101000020E6100000554FE61F7D13FABFE97E4E417EEC4A40
84282	LS18 5LJ	GB	0101000020E6100000FB777DE6AC4FFABF2BF86D88F1EA4A40
84283	LS18 5NL	GB	0101000020E6100000FEB968C87814FABFE99B340D8AEC4A40
84284	LS18 5PP	GB	0101000020E6100000A75D4C33DD2BFABFF296AB1F9BEC4A40
84285	LS18 5QT	GB	0101000020E6100000ECA353573E0BFABF255CC823B8EB4A40
84286	LS19 6BA	GB	0101000020E610000053060E68E90AFBBF9DBCC804FCEC4A40
84287	LS19 6DD	GB	0101000020E61000001CEE23B726DDFABFD7A4DB12B9EC4A40
84288	LS19 6LF	GB	0101000020E610000071581AF8518DFABF0400C79E3DED4A40
84289	LS19 6NZ	GB	0101000020E610000079AEEFC341C2FABF67994528B6EC4A40
84290	LS19 6PR	GB	0101000020E6100000ECDFF599B3BEFABFEB8D5A61FAEC4A40
84291	LS19 6PU	GB	0101000020E6100000B3B45373B9C1FABFC6F8307BD9EC4A40
84292	LS19 6QB	GB	0101000020E61000003657CD7344BEFABF29CB10C7BAEC4A40
84293	LS19 6RD	GB	0101000020E6100000645A9BC6F69AFABFA8C30AB77CEC4A40
84294	LS19 7AS	GB	0101000020E6100000CC441152B7B3FABF80457EFD10EF4A40
84295	LS19 7DN	GB	0101000020E6100000E8F527F1B913FBBF65A9F57EA3ED4A40
84296	LS19 7ET	GB	0101000020E6100000828FC18A532DFBBF999B6F44F7EE4A40
84297	LS19 7NW	GB	0101000020E6100000D50968226C38FBBFFFE7305F5EEE4A40
84298	LS19 7SL	GB	0101000020E61000006E19709692E5FABF6005F86EF3EE4A40
84299	LS19 7YA	GB	0101000020E610000029B4ACFBC7C2FABF1D925A2899EE4A40
84300	LS2	GB	0101000020E6100000F5F57CCD72D9F8BF7AE3A430EFE54A40
84301	LS2 7UA	GB	0101000020E61000005E85949F547BF8BF0261A75835E64A40
84302	LS2 7UE	GB	0101000020E610000014200A664C81F8BF7E1AF7E637E64A40
84303	LS2 9	GB	0101000020E6100000B4CC22145B01F9BF9A266C3F19E74A40
84304	LS2 9AR	GB	0101000020E6100000EBC9FCA36FD2F8BF25E82FF488E74A40
84305	LS2 9JT	GB	0101000020E6100000A1478C9E5BE8F8BFD6A8876874E74A40
84306	LS20	GB	0101000020E61000007BF8325184D4FABF40A6B5696CEF4A40
84307	LS20 8AS	GB	0101000020E610000093E1783E036AFBBF3D0AD7A370EF4A40
84308	LS20 8BZ	GB	0101000020E6100000F1F3DF83D76EFBBFF7C9518028F04A40
84309	LS20 8DP	GB	0101000020E6100000A13028D36872FBBFDAC87553CAEF4A40
84310	LS20 8DX	GB	0101000020E6100000681F2BF86D88FBBF7E5704FF5BEF4A40
84311	LS20 8EN	GB	0101000020E61000009F58A7CAF78CFBBF5D8C81751CEF4A40
84312	LS20 8ES	GB	0101000020E610000000A94D9CDC6FFBBF3E3DB665C0ED4A40
84313	LS20 8JL	GB	0101000020E6100000AF963B33C1B0FBBF2EC6C03A8EEF4A40
84314	LS20 8LY	GB	0101000020E610000088B9A46ABB89FBBF8F6E844545F04A40
84315	LS20 9BX	GB	0101000020E610000054A703594F6DFBBF5325CADE52F04A40
84316	LS20 9DH	GB	0101000020E6100000ED9A90D61874FBBF3FE1ECD632F14A40
84317	LS21	GB	0101000020E61000001F2DCE18E604FBBFF8C5A52A6DF34A40
84318	LS21 1AD	GB	0101000020E61000003F355EBA490CFBBFFBCE2F4AD0F34A40
84319	LS21 1AG	GB	0101000020E610000085B53176C20BFBBF5A2E1B9DF3F34A40
84320	LS21 1AH	GB	0101000020E6100000BC5B59A2B30CFBBFB9C7D2872EF44A40
84321	LS21 1DD	GB	0101000020E6100000E65AB4006DEBFABF1EE0490B97F34A40
84322	LS21 1DY	GB	0101000020E61000007C7C4276DEC6FABF4CA94BC631F44A40
84323	LS21 1DZ	GB	0101000020E610000093567C43E1B3FABF800D881057F44A40
84324	LS21 1EG	GB	0101000020E61000000AD7A3703D4AFABF55A52DAEF1F34A40
84325	LS21 1ET	GB	0101000020E6100000541A31B3CF23FABF97C79A9141F24A40
84326	LS21 1HD	GB	0101000020E61000005C566133C005FBBF48FDF50A0BF44A40
84327	LS21 1HN	GB	0101000020E61000007863416150E6FABF6397A8DE1AF44A40
84328	LS21 1LH	GB	0101000020E6100000EDD3F198810AFABF56F146E691F34A40
84329	LS21 1NL	GB	0101000020E6100000B743C362D4B5F9BF4436902E36F34A40
84330	LS21 1TY	GB	0101000020E61000008352B4722FF0F9BF5F251FBB0BF44A40
84331	LS21 2AU	GB	0101000020E6100000478FDFDBF427FBBFD769A4A5F2F44A40
84332	LS21 2BB	GB	0101000020E610000077F4BF5C8B16FBBFEBC891CEC0F44A40
84333	LS21 2BE	GB	0101000020E6100000397CD2890413FBBF79AC1919E4F44A40
84334	LS21 2EY	GB	0101000020E6100000BCCB457C2726FBBF069FE6E445F64A40
84335	LS21 2HN	GB	0101000020E6100000425DA450167EFBBF6FF59CF4BEF54A40
84336	LS21 2HQ	GB	0101000020E6100000FFB1101D0247FBBFCBF78C4468F44A40
84337	LS21 2JQ	GB	0101000020E610000014E8137992F4FBBFB83F170D19F74A40
84338	LS21 2NN	GB	0101000020E6100000BBB9F8DB9EA0FBBF144031B264FC4A40
84339	LS21 2RR	GB	0101000020E6100000408864C8B175FBBF39471D1D57F54A40
84340	LS21 3AN	GB	0101000020E6100000D940BAD8B412FBBFCBF8F71917F44A40
84341	LS21 3AQ	GB	0101000020E6100000C0232A543717FBBFA680B4FF01F44A40
84342	LS21 3AS	GB	0101000020E610000072DF6A9DB81CFBBF810871E5ECF34A40
84343	LS21 3BB	GB	0101000020E6100000A0C552245F09FBBF6552431B80F34A40
84344	LS21 3BR	GB	0101000020E6100000E4BF40102043FABFAAB69BE09BF24A40
84345	LS21 3DG	GB	0101000020E61000008E739B70AF0CFBBF71CADC7C23F24A40
84346	LS21 3DT	GB	0101000020E61000001B649291B330FBBF80492A53CCF34A40
84347	LS21 3HN	GB	0101000020E610000009168733BF1AFBBF1BA19FA9D7F34A40
84348	LS21 3JL	GB	0101000020E6100000D8F15F200810FBBFF8AA9509BFF24A40
84349	LS21 3JP	GB	0101000020E610000014950D6B2A4BFBBFF0FD0DDAABF34A40
84350	LS21 3JS	GB	0101000020E6100000EA043411363CFBBF3659A31EA2F34A40
84351	LS21 3LS	GB	0101000020E6100000F0C16B97365CFBBF8C67D0D03FF34A40
84352	LS21 3LW	GB	0101000020E6100000085A8121AB5BFBBF81B2295778F34A40
84353	LS21 3LY	GB	0101000020E610000000FE2955A26CFBBF0B992B836AF34A40
84354	LS21 3ND	GB	0101000020E6100000CC9A58E02B7AFBBF9DF6949C13F34A40
84355	LS21 3NE	GB	0101000020E6100000310A82C7B777FBBF3755F7C8E6F24A40
84356	LS21 3NG	GB	0101000020E6100000EEEBC039238AFBBF23D923D40CF34A40
84357	LS21 3NR	GB	0101000020E6100000B9FC87F4DB17FBBF26C5C72764F34A40
84358	LS21 3NS	GB	0101000020E6100000DFDE35E84B2FFBBF255D33F966F34A40
84359	LS22	GB	0101000020E6100000CAFE791A3008F6BFFB5A971AA1F74A40
84360	LS22 5AP	GB	0101000020E6100000B6A2CD716E93F6BFC498F4F752F44A40
84361	LS22 5AZ	GB	0101000020E61000005680EF366F5CF6BF643E20D099F44A40
84362	LS22 5DJ	GB	0101000020E61000004DDBBFB2D2E4F6BFBA1281EA1FF44A40
84363	LS22 6	GB	0101000020E61000003FFED2A23E09F6BF8237A45181F74A40
84364	LS22 6GP	GB	0101000020E6100000EE7BD45FAF70F6BFEE3F321D3AF74A40
84365	LS22 6HA	GB	0101000020E61000004BADF71BED38F6BF6E4F90D8EEF64A40
84366	LS22 6LE	GB	0101000020E6100000588D25AC8D31F6BF22895E46B1F64A40
84367	LS22 6NN	GB	0101000020E61000004AEF1B5F7B26F6BF4FE5B4A7E4F64A40
84368	LS22 6NU	GB	0101000020E6100000E10D6954E024F6BF0E87A5811FF74A40
84369	LS22 6WD	GB	0101000020E6100000FF3EE3C28150F6BFB709F7CABCF74A40
84370	LS22 7GD	GB	0101000020E6100000BA4C4D823724F6BFFF0758AB76F74A40
84371	LS23	GB	0101000020E6100000D25625917D90F5BFC26B97361CF24A40
84372	LS23 6BT	GB	0101000020E6100000E98024ECDB89F5BF6347E350BFF34A40
84373	LS23 6DA	GB	0101000020E6100000CFBC1C76DF31F6BFC18BBE8234F94A40
84374	LS23 6DQ	GB	0101000020E610000061E124CD1F93F5BF3D2828452BF34A40
84375	LS23 6DU	GB	0101000020E61000003F74417DCB9CF5BF88D68A36C7F34A40
84376	LS23 6HJ	GB	0101000020E610000076C3B645998DF5BFB05758703FF24A40
84377	LS23 6NU	GB	0101000020E6100000A4FCA4DAA7A3F5BF809BC58B85F34A40
84378	LS23 6RZ	GB	0101000020E6100000AE7FD767CE3AF5BF1D1EC2F869EE4A40
84379	LS23 6TA	GB	0101000020E6100000CFBD874B8E7BF5BF8638D6C56DF24A40
84380	LS23 7DF	GB	0101000020E6100000E5620CACE338F5BFECF82F1004F64A40
84381	LS23 7DR	GB	0101000020E61000004C33DDEBA47EF5BF74EE76BD34F74A40
84382	LS24 8AF	GB	0101000020E610000041F2CEA10C15F4BFBFBA2A508BF14A40
84383	LS24 8EU	GB	0101000020E61000009641B5C18928F4BF9351651877F14A40
84384	LS24 8EY	GB	0101000020E6100000A9BD88B6632AF4BFC687D9CBB6F14A40
84385	LS24 9BT	GB	0101000020E610000086C77E164B51F4BFCA703C9F01EF4A40
84386	LS24 9DB	GB	0101000020E61000009A7B48F8DEDFF3BFA837A3E6ABEE4A40
84387	LS24 9DJ	GB	0101000020E6100000BAD91F28B76DF3BF9B5AB6D617ED4A40
84388	LS24 9DU	GB	0101000020E610000026E1421EC14DF3BF770FD07D39ED4A40
84389	LS24 9EE	GB	0101000020E6100000A7B1BD16F49EF2BF5FF0694E5EEC4A40
84390	LS24 9LQ	GB	0101000020E6100000BD5296218E75F4BFF778211D1EF04A40
84391	LS24 9LS	GB	0101000020E61000003526C45C52B5F4BFD2AC6C1FF2F24A40
84392	LS24 9NJ	GB	0101000020E6100000533E0455A317F5BF704221020EED4A40
84393	LS24 9PL	GB	0101000020E6100000E7E3DA50310EF4BFF69A1E1494E84A40
84394	LS24 9RA	GB	0101000020E6100000CAFACDC474A1F3BFD6C4025FD1E94A40
84395	LS24 9WA	GB	0101000020E6100000855E7F129F7BF3BF9B92ACC3D1E94A40
84396	LS25	GB	0101000020E61000002524D236FEC4F4BFC9AEB48CD4E54A40
84397	LS25 1AR	GB	0101000020E61000001956F146E651F6BF151F9F909DE54A40
84398	LS25 1AZ	GB	0101000020E6100000B933130CE75AF6BF7689EAAD81E54A40
84399	LS25 1DA	GB	0101000020E6100000A165DD3F1662F6BF3F390A1005E54A40
84400	LS25 1EY	GB	0101000020E6100000CC5D4BC8073DF6BFBCEA01F390E54A40
84401	LS25 1HQ	GB	0101000020E6100000AB4203B16C26F6BF79E9263108E64A40
84402	LS25 1NW	GB	0101000020E610000037FE4465C31AF6BFC0E8F2E670E54A40
84403	LS25 1PY	GB	0101000020E61000009CF9D51C2018F6BFDECCE847C3E54A40
84404	LS25 2BU	GB	0101000020E61000007FD93D795868F5BF5F79909E22E54A40
84405	LS25 2EZ	GB	0101000020E6100000213B6F63B3E3F5BF147B681F2BE64A40
84406	LS25 2JW	GB	0101000020E6100000ED6305BF0DF1F5BFA514747B49E54A40
84407	LS25 3BH	GB	0101000020E61000008AABCABE2B82F5BF1668774831EA4A40
84408	LS25 4AQ	GB	0101000020E610000079944A78422FF5BFB8CB7EDDE9E44A40
84409	LS25 5BA	GB	0101000020E6100000D7A19A92AC03F4BFB29E5A7D75E34A40
84410	LS25 5DA	GB	0101000020E6100000317BD976DADAF3BF78F01307D0E14A40
84411	LS25 5EA	GB	0101000020E61000005A4B0169FFC3F3BFEA08E066F1E04A40
84412	LS25 5HL	GB	0101000020E6100000931804560EADF3BF1DAA29C93AE04A40
84413	LS25 5HW	GB	0101000020E61000001823128596B5F3BFB9C1508715E04A40
84414	LS25 6AA	GB	0101000020E6100000E9F351465C00F4BF8A20CEC309E44A40
84415	LS25 6AJ	GB	0101000020E61000006B0C3A217410F4BF00ADF9F197E44A40
84416	LS25 6DY	GB	0101000020E610000020990E9D9EB7F3BF4BB0389CF9E54A40
84417	LS25 6EH	GB	0101000020E61000005B5D4E098809F4BF54E1CFF066E54A40
84418	LS25 7DR	GB	0101000020E6100000BF0CC6884421F6BF9949D40B3EE34A40
84419	LS25 7ED	GB	0101000020E61000003F74417DCB1CF6BF87DEE2E13DE34A40
84420	LS25 7EP	GB	0101000020E6100000AFCE31207BFDF5BFC6E061DA37E34A40
84421	LS25 7HB	GB	0101000020E6100000EE2422FC8BE0F5BFFD4B529962E24A40
84422	LS25 7NS	GB	0101000020E6100000185B08725002F6BFF9307BD976E24A40
84423	LS25 7RW	GB	0101000020E61000003DD4B66114C4F5BF31D0B52FA0E14A40
84424	LS26 0	GB	0101000020E6100000569929ADBFE5F7BFFCA886FD9EE04A40
84425	LS26 0EP	GB	0101000020E61000008B1A4CC3F091F7BF3CDA38622DE04A40
84426	LS26 0EX	GB	0101000020E61000002331410DDF82F7BFF111312592E04A40
84427	LS26 0PY	GB	0101000020E6100000A5D7666325E6F7BF28BA2EFCE0E04A40
84428	LS26 0SR	GB	0101000020E6100000A5BE2CEDD4DCF7BF435376FA41DF4A40
84429	LS26 0TP	GB	0101000020E61000002AC423F1F2B4F7BF70D234289ADF4A40
84430	LS26 8	GB	0101000020E61000004D4C1762F547F7BF20D26F5F07E04A40
84431	LS26 8HH	GB	0101000020E6100000A51133FB3C86F7BF82E7DEC325DD4A40
84432	LS26 8QN	GB	0101000020E610000009E23C9CC0B4F6BF009013268CE24A40
84433	LS26 8QR	GB	0101000020E6100000E99E758D96C3F6BF6CEEE87FB9E24A40
84434	LS26 8RA	GB	0101000020E6100000664CC11A6713F7BF938D075BECE04A40
84435	LS26 8SF	GB	0101000020E61000007F6C921FF16BF7BF2E20B41EBEE04A40
84436	LS26 8XT	GB	0101000020E6100000A243E048A0C1F6BF68B0A9F3A8E24A40
84437	LS26 9AB	GB	0101000020E610000001DBC1887D42F6BF271422E010DE4A40
84438	LS27	GB	0101000020E61000004CFDBCA94805FABF7A8EC87729E14A40
84439	LS27 0BP	GB	0101000020E61000003ECE3461FBC9F9BF139ED0EB4FDE4A40
84440	LS27 0EL	GB	0101000020E6100000B22C98F8A368F9BF2D793C2D3FDE4A40
84441	LS27 0JG	GB	0101000020E6100000F78E1A1362EEF9BF46EEE9EA8EDF4A40
84442	LS27 0RP	GB	0101000020E610000031B5A50EF2BAF9BFA2B437F8C2DE4A40
84443	LS27 0SA	GB	0101000020E61000005664744012B6F9BF6C4084B872DE4A40
84444	LS27 0SG	GB	0101000020E6100000E02BBAF59A5EF9BFCFA3E2FF8EDE4A40
84445	LS27 0SH	GB	0101000020E61000002D0B26FE28AAF9BF4C6E14596BDE4A40
84446	LS27 7AD	GB	0101000020E61000009FAF592E1B1DFABF83A6255646E14A40
84447	LS27 7DR	GB	0101000020E6100000A7203F1BB9AEF8BFC9022670EBE24A40
84448	LS27 7HH	GB	0101000020E61000004E417E36721DFABF802BD9B111E04A40
84449	LS27 7HY	GB	0101000020E6100000A43330F2B226FABF4B395FECBDE04A40
84450	LS27 7PG	GB	0101000020E6100000E561A1D6346FF9BF6C3EAE0D15E14A40
84451	LS27 7SY	GB	0101000020E6100000035B25581C4EF9BF4E9D47C5FFE14A40
84452	LS27 7TS	GB	0101000020E6100000664F029B73F0F9BF7B9FAA4203E14A40
84453	LS27 8JR	GB	0101000020E6100000C15609168773F9BF0AF5F411F8DF4A40
84454	LS27 8ST	GB	0101000020E6100000274D83A27940F9BF80B8AB5791DF4A40
84455	LS27 9DP	GB	0101000020E6100000A2293BFDA0AEF9BFB438639813E04A40
84456	LS27 9DU	GB	0101000020E61000004563EDEF6C4FF9BFBE8575E3DDDD4A40
84457	LS27 9LW	GB	0101000020E6100000FF0758AB768DF9BF57772CB649E14A40
84458	LS28	GB	0101000020E610000077D7D9907FA6FABF9B560A815CE44A40
84459	LS28 5EJ	GB	0101000020E6100000B3EC496073CEFABFDF1797AAB4E74A40
84460	LS28 5HH	GB	0101000020E6100000C520B07268D1FABF1618B2BAD5E74A40
84461	LS28 5NF	GB	0101000020E6100000AB7AF99D26F3FABF03CFBD874BEA4A40
84462	LS28 5PP	GB	0101000020E6100000C7F2AE7AC0FCFABF62F6B2EDB4E94A40
84463	LS28 5RZ	GB	0101000020E610000004FEF0F3DF43FBBFF7216FB9FAE94A40
84464	LS28 6AN	GB	0101000020E6100000D4635B069CE5FABF74417DCB9CE64A40
84465	LS28 6BD	GB	0101000020E610000070B54E5C8ED7FABFA46C91B41BE74A40
84466	LS28 6QG	GB	0101000020E610000020EC14AB06E1FABF240D6E6B0BE74A40
84467	LS28 6QW	GB	0101000020E6100000A27C410B0998FABF596DFE5F75E64A40
84468	LS28 7HE	GB	0101000020E61000005A83F755B910FBBFED45B41D53E74A40
84469	LS28 7LL	GB	0101000020E610000005C1E3DBBB86FABF7460394206E64A40
84470	LS28 7PN	GB	0101000020E61000005D8C81751CFFFABFF75B3B5112E64A40
84471	LS28 8JX	GB	0101000020E61000009EB64604E320FBBFD34A21904BE64A40
84472	LS28 8NT	GB	0101000020E61000007EE5417A8A9CFABFE910381268E44A40
84473	LS28 8PS	GB	0101000020E610000055849B8C2AC3FABF917C259012E54A40
84474	LS28 8PW	GB	0101000020E610000042CF66D5E7AAFABF013274ECA0E44A40
84475	LS28 9AW	GB	0101000020E61000000116F9F5436CFABFEECD6F9868E64A40
84476	LS28 9BH	GB	0101000020E61000008CF2CCCB6177FABF8BA6B393C1E54A40
84477	LS28 9DY	GB	0101000020E6100000B2F50CE19865FABF09A69A594BE54A40
84478	LS28 9EN	GB	0101000020E61000008EC877297589FABF0341800C1DE54A40
84479	LS28 9GA	GB	0101000020E6100000F1D7648D7A88FABF69519FE40EE54A40
84480	LS29	GB	0101000020E610000090D959F44E45FDBF08AD872F13F74A40
84481	LS29 0AP	GB	0101000020E610000045D61A4AED45FDBF228E75711BF74A40
84482	LS29 0AU	GB	0101000020E610000070B4E386DF4DFDBF51DD5CFC6DF74A40
84483	LS29 0BT	GB	0101000020E6100000992EC4EA8FB0FDBFC5E2378595F84A40
84484	LS29 0SA	GB	0101000020E6100000C713419C87D3FDBF27F6D03E56F84A40
84485	LS29 0TD	GB	0101000020E6100000EBFF1CE6CB4BFEBFB39AAE27BAF84A40
84486	LS29 4BE	GB	0101000020E610000078EC67B11409FCBF1BF1643733F44A40
84487	LS29 6BQ	GB	0101000020E6100000CFF41263997EFBBFAF06280D35F24A40
84488	LS29 6EB	GB	0101000020E6100000E692AAED26B8FBBF9AEE75525FF24A40
84489	LS29 6HS	GB	0101000020E6100000CBBC55D7A1DAFBBFE9D7D64FFFF14A40
84490	LS29 6JH	GB	0101000020E6100000DACA4BFE27BFFBBFDFA7AAD040F24A40
84491	LS29 6NG	GB	0101000020E610000032772D211FF4FBBF26732CEFAAF14A40
84492	LS29 6QB	GB	0101000020E6100000FD4FFEEE1DB5FBBFBEBD6BD097F24A40
84493	LS29 7AX	GB	0101000020E61000003CDA38622D3EFCBF42EC4CA1F3F24A40
84494	LS29 7DB	GB	0101000020E6100000239EEC6646FFFBBF2D7AA702EEF54A40
84495	LS29 7DN	GB	0101000020E61000005FB2F1608BDDFBBF7C992842EAF44A40
84496	LS29 7ET	GB	0101000020E610000023D923D40CE9FBBF664E97C5C4F44A40
84497	LS29 7JL	GB	0101000020E610000005DF347D7600FCBFBC202235EDF44A40
84498	LS29 7NH	GB	0101000020E6100000350A4966F50EFCBFDC7EF964C5F44A40
84499	LS29 7PQ	GB	0101000020E6100000DC4944F81701FCBF0AA359D93EF44A40
84500	LS29 7RU	GB	0101000020E610000064575A46EAFDFBBF14B2F33636F54A40
84501	LS29 8BT	GB	0101000020E6100000736891ED7CBFFCBF87A4164A26F54A40
84502	LS29 8DG	GB	0101000020E6100000AF95D05D1227FDBF14AE47E17AF64A40
84503	LS29 8ET	GB	0101000020E610000006465ED6C4C2FCBFED9FA70183F64A40
84504	LS29 8EW	GB	0101000020E6100000E7A6CD380D11FDBF195932C7F2F64A40
84505	LS29 8HF	GB	0101000020E6100000C3D32B651922FDBF7880272D5CF64A40
84506	LS29 8JJ	GB	0101000020E6100000C85F5AD427F9FCBFA1BB24CE8AF64A40
84507	LS29 8NX	GB	0101000020E6100000137EA99F37D5FCBF390F27309DF64A40
84508	LS29 8PA	GB	0101000020E6100000B439CE6DC2BDFCBF48DE3994A1F64A40
84509	LS29 8PG	GB	0101000020E6100000AA27F38FBEC9FCBF2AA8A8FA95F64A40
84510	LS29 8QJ	GB	0101000020E610000060AB048BC3D9FCBF1B0E4B033FF64A40
84511	LS29 8QY	GB	0101000020E6100000E012807F4AD5FCBF18B325AB22F64A40
84512	LS29 8RW	GB	0101000020E610000046EA3D95D3DEFCBFCF31207BBDF54A40
84513	LS29 8SA	GB	0101000020E6100000BC900E0F61BCFCBFFC709010E5F54A40
84514	LS29 8SB	GB	0101000020E610000026DF6C7363BAFCBF9626A5A0DBF54A40
84515	LS29 8SZ	GB	0101000020E61000006118B0E42A16FDBF0E677E3507F64A40
84516	LS29 8TU	GB	0101000020E6100000F4C0C760C5E9FCBFD5E76A2BF6F54A40
84517	LS29 9BL	GB	0101000020E610000095607138F36BFDBFD49B51F355F64A40
84518	LS29 9EP	GB	0101000020E6100000E2CCAFE60041FDBF2D95B7239CF64A40
84519	LS29 9NW	GB	0101000020E610000066F4A3E19439FDBF6C41EF8D21F64A40
84520	LS29 9QP	GB	0101000020E61000005D6F9BA9104FFDBFF6B3588AE4F54A40
84521	LS3	GB	0101000020E6100000F20BAF24796EF8BFAB3FC23060E74A40
84522	LS3 1AP	GB	0101000020E61000006AA2CF4719F1F8BF4489963C9EE64A40
84523	LS3 1HG	GB	0101000020E6100000B6D8EDB3CA0CF9BF8A743FA720E74A40
84524	LS3 1LY	GB	0101000020E61000003997E2AAB2EFF8BFE5D2F88557E64A40
84525	LS3 1NT	GB	0101000020E6100000F0A65B7688FFF8BF0C5BB39597E64A40
84526	LS4 2DD	GB	0101000020E610000024D40CA9A278F9BF8F368E588BE74A40
84527	LS4 2PG	GB	0101000020E61000003946B247A859F9BFF01307D0EFE74A40
84528	LS4 2QD	GB	0101000020E610000091D26C1E8781F9BFD4BA0D6ABFE74A40
84529	LS4 2SD	GB	0101000020E61000004485EAE6E26FF9BF5114E81379E84A40
84530	LS4 2TU	GB	0101000020E610000051BD35B05582F9BF24F25D4A5DE84A40
84531	LS5 3EU	GB	0101000020E610000047E350BF0B9BF9BFF261F6B2EDE84A40
84532	LS5 3HH	GB	0101000020E61000008C135FED288EF9BF3866D993C0E84A40
84533	LS5 3LD	GB	0101000020E610000066BE839F3880F9BF0E6B2A8BC2E84A40
84534	LS5 3LN	GB	0101000020E6100000E21FB6F468EAF9BF46ED7E15E0E94A40
84535	LS5 3PG	GB	0101000020E61000007A17EFC7EDD7F9BF3CA06CCA15EA4A40
84536	LS6	GB	0101000020E6100000F8C610001CFBF8BF06F6984869EA4A40
84537	LS6 1	GB	0101000020E61000006FA0C03BF934F9BFA796ADF545E84A40
84538	LS6 1AB	GB	0101000020E61000005F5FEB522334F9BF6555849B8CE84A40
84539	LS6 1AS	GB	0101000020E61000001059A4897700F9BFD029C8CF46E84A40
84540	LS6 1AX	GB	0101000020E610000055185B087210F9BF09185DDE1CE84A40
84541	LS6 1AY	GB	0101000020E61000004A79AD84EE12F9BF43E21E4B1FE84A40
84542	LS6 1BU	GB	0101000020E6100000A3AEB5F7A92AF9BFE2934E2498E84A40
84543	LS6 1DL	GB	0101000020E6100000EF8D21003836F9BF771211FE45E84A40
84544	LS6 1ED	GB	0101000020E6100000C5E6E3DA5031F9BFD789CBF10AE84A40
84545	LS6 1HD	GB	0101000020E6100000C501F4FBFE0DF9BF06BD378600E84A40
84546	LS6 1JD	GB	0101000020E610000078EE3D5C721CF9BF6744696FF0E74A40
84547	LS6 1LX	GB	0101000020E6100000D34D62105839F9BFF7CABC55D7E74A40
84548	LS6 1NG	GB	0101000020E6100000F9484A7A181AF9BF0937195586E74A40
84549	LS6 1NL	GB	0101000020E6100000765089EB1817F9BFFE0DDAAB8FE74A40
84550	LS6 1NT	GB	0101000020E610000067F16261881CF9BF72DC291DACE74A40
84551	LS6 1PL	GB	0101000020E6100000EAE923F0871FF9BF17D86322A5E74A40
84552	LS6 1QQ	GB	0101000020E6100000514EB4AB9032F9BF2BF702B342E74A40
84553	LS6 1RD	GB	0101000020E6100000FC389A232BBFF8BF56D7A19A92E84A40
84554	LS6 1SJ	GB	0101000020E6100000FBAD9D280909F9BF2BDEC83CF2E74A40
84555	LS6 2AP	GB	0101000020E610000088635DDC4643F9BF71E316F373E94A40
84556	LS6 2AZ	GB	0101000020E6100000C51B9947FE20F9BF0E12A27C41E94A40
84557	LS6 2BD	GB	0101000020E610000020B58993FB1DF9BF6A334E4354E94A40
84558	LS6 2BZ	GB	0101000020E6100000CFA2772AE0DEF8BFE198654F02E94A40
84559	LS6 2ER	GB	0101000020E610000006F2ECF2AD0FF9BFB1A6B228ECE84A40
84560	LS6 2ET	GB	0101000020E6100000C554FA0967F7F8BF71546EA296E84A40
84561	LS6 2EY	GB	0101000020E6100000A565A4DE53F9F8BFA46DFC89CAE84A40
84562	LS6 2HA	GB	0101000020E6100000790261A758F5F8BF637E6E68CAE84A40
84563	LS6 2HD	GB	0101000020E610000069A9BC1DE1F4F8BF33C005D9B2E84A40
84564	LS6 2WA	GB	0101000020E6100000994869368F03F9BF77A04E7974E94A40
84565	LS6 3DD	GB	0101000020E6100000AD1397E31548F9BF75012F336CE84A40
84566	LS6 3EL	GB	0101000020E61000009BC937DBDC58F9BF2EABB019E0E84A40
84567	LS6 3ER	GB	0101000020E6100000F818AC38D55AF9BF32E9EFA5F0E84A40
84568	LS6 3ES	GB	0101000020E610000023D8B8FE5D5FF9BFAE2EA704C4E84A40
84569	LS6 3EW	GB	0101000020E6100000560C5707405CF9BFFAD005F52DE94A40
84570	LS6 3HA	GB	0101000020E61000004EB6813B5067F9BFC3D7D7BAD4E84A40
84571	LS6 3HN	GB	0101000020E610000068E89FE06245F9BFBB0F406A13E94A40
84572	LS6 3PE	GB	0101000020E610000014596B28B557F9BF4B033FAA61E94A40
84573	LS6 3PN	GB	0101000020E610000001C3F2E7DB42F9BFDFA4695034E94A40
84574	LS6 3QS	GB	0101000020E61000009ACC785BE975F9BF2BC1E270E6E94A40
84575	LS6 3RA	GB	0101000020E6100000C6FB71FBE513F9BFA1496249B9E94A40
84576	LS6 4AJ	GB	0101000020E6100000B727486C770FF9BF97AC8A7093E94A40
84577	LS6 4AZ	GB	0101000020E61000004E469561DC0DF9BFEE5A423EE8E94A40
84578	LS6 4EX	GB	0101000020E6100000A774B0FECF21F9BF62307F85CCE94A40
84579	LS6 4JQ	GB	0101000020E6100000DDB5847CD0F3F8BF20EEEA5564EA4A40
84580	LS6 4JX	GB	0101000020E610000075C93846B207F9BFF660527C7CEA4A40
84581	LS6 4LE	GB	0101000020E61000004243FF04172BF9BFD2FF722D5AEA4A40
84582	LS6 4NX	GB	0101000020E6100000FC8EE1B19F05F9BFE7A7380EBCEA4A40
84583	LS6 4SH	GB	0101000020E61000003831242713F7F8BF113AE8120EEB4A40
84584	LS6 9PR	GB	0101000020E61000005721E527D5FEF8BF8B16A06D35E74A40
84585	LS7 1SA	GB	0101000020E6100000B5A9BA473697F8BF2EC6C03A8EE74A40
84586	LS7 2AA	GB	0101000020E610000059DFC0E44691F8BF834E081D74E74A40
84587	LS7 2EU	GB	0101000020E610000001A5A14621C9F8BF41EF8D2100EA4A40
84588	LS7 2LY	GB	0101000020E6100000F1F62004E4CBF8BF62BF27D6A9EA4A40
84589	LS7 2RZ	GB	0101000020E61000009E616A4B1DE4F8BF6FD8B628B3E94A40
84590	LS7 3DW	GB	0101000020E6100000352A70B20D9CF8BF8FC2F5285CE94A40
84591	LS7 3DZ	GB	0101000020E610000001310917F288F8BF71E6577380E84A40
84592	LS7 3ER	GB	0101000020E610000092EBA694D78AF8BF57CC086F0FE84A40
84593	LS7 3HB	GB	0101000020E6100000946A9F8EC78CF8BF70EB6E9EEAE84A40
84594	LS7 3NX	GB	0101000020E610000005FBAF73D3A6F8BFA06CCA15DEE94A40
84595	LS7 3PT	GB	0101000020E610000019ADA3AA09A2F8BF0A4AD1CABDEA4A40
84596	LS7 3QD	GB	0101000020E6100000C0ED0912DB9DF8BFEA059FE6E4E94A40
84597	LS7 3QS	GB	0101000020E6100000029D499BAABBF8BFE0675C3810EA4A40
84598	LS7 4DT	GB	0101000020E6100000FC3559A31E62F8BFEDD3F19881E84A40
84599	LS7 4JX	GB	0101000020E6100000853E58C6866EF8BF13D38558FDE94A40
84600	LS7 4ND	GB	0101000020E61000007250C24CDB7FF8BF0EF8FC3042EA4A40
84601	LS7 4NL	GB	0101000020E6100000E816BA12816AF8BF3447567E19EA4A40
84602	LS7 4PE	GB	0101000020E610000095287B4B399FF8BFDFA7AAD040EA4A40
84603	LS7 4QA	GB	0101000020E6100000DD989EB0C483F8BFE108522976EA4A40
84604	LS7 4SP	GB	0101000020E6100000C34A0515557FF8BF0A11700855EA4A40
84605	LS8	GB	0101000020E610000089B2B794F305F8BF6090F46915E94A40
84606	LS8 1AW	GB	0101000020E610000067B796C9703CF8BF0F26C5C727EC4A40
84607	LS8 1DA	GB	0101000020E61000001363997E8938F8BFA2427573F1EB4A40
84608	LS8 1LF	GB	0101000020E61000009D0FCF126444F8BF904FC8CEDBEA4A40
84609	LS8 1LG	GB	0101000020E6100000800D8810574EF8BFE6CAA0DAE0EA4A40
84610	LS8 1NF	GB	0101000020E61000002063EE5A423EF8BF392861A6EDE94A40
84611	LS8 1NH	GB	0101000020E6100000821E6ADB304AF8BF2D978DCEF9E94A40
84612	LS8 1PL	GB	0101000020E610000033E197FA7953F8BFD7F6764B72EA4A40
84613	LS8 1PQ	GB	0101000020E610000068E90AB6114FF8BF336ABE4A3EEA4A40
84614	LS8 1QR	GB	0101000020E610000062307F85CC55F8BF65A54929E8EA4A40
84615	LS8 1QX	GB	0101000020E61000009AED0A7DB08CF8BFC74ACCB392EA4A40
84616	LS8 2AF	GB	0101000020E610000083E0F1ED5D43F8BF5891D10149EC4A40
84617	LS8 2EY	GB	0101000020E61000005C02F04FA912F8BFE8A38CB800EC4A40
84618	LS8 2HB	GB	0101000020E6100000548CF337A110F8BFF778211D1EEC4A40
84619	LS8 2LA	GB	0101000020E61000004F0306499FD6F7BFBCCB457C27EA4A40
84620	LS8 2PT	GB	0101000020E610000073F38DE89EF5F7BF6C76A4FACEE94A40
84621	LS8 2QA	GB	0101000020E61000008D4127840EFAF7BF7A17EFC7EDE94A40
84622	LS8 2QP	GB	0101000020E6100000D7C3978922E4F7BFC214E5D2F8E94A40
84623	LS8 2SB	GB	0101000020E6100000363AE7A7380EF8BFA818E76F42E94A40
84624	LS8 2SP	GB	0101000020E61000002FF834272F32F8BF9ED32CD0EEE84A40
84625	LS8 2SY	GB	0101000020E6100000FEF15EB53221F8BFF3716DA818E94A40
84626	OX44 7UR	GB	0101000020E6100000CD1720764B17F2BF6ED4546012D74940
84627	MK7 6HL	GB	0101000020E61000002EFF21FDF675E6BF89D2DEE00B034A40
84628	SY21 9AF	GB	0101000020E6100000D6631179818809C0CC56A87F5A534A40
84629	EH1 3SW	GB	0101000020E6100000099C6549928109C0E26B6A0123FA4B40
84630	NP18 2LX	GB	0101000020E61000002CD49AE61D2707C0D9CEF753E3CD4940
84631	BH20 5RQ	GB	0101000020E6100000FCF867E0290302C0518C91C4494F4940
84632	ML3 7DB	GB	0101000020E6100000270445089C1A10C0A860D1D0A6E24B40
84633	LL57 4BG	GB	0101000020E6100000EECC04C3B96E10C007F1DCD6719A4A40
84634	W1U 5LG	GB	0101000020E61000003524EEB1F4A1C3BFE63FA4DFBEC24940
84635	SY23 2DH	GB	0101000020E6100000B00C6080335710C01245926AE9354A40
84636	LD7 1LT	GB	0101000020E61000002E01F8A754F907C0A44C0FAF902C4A40
84637	LL36 9AD	GB	0101000020E610000066E6B809AD5D10C076F9D687F54A4A40
84638	LL65 3DP	GB	0101000020E61000003C0DBD6A0A4112C0A8C87C9B59A44A40
84639	SA61 1BG	GB	0101000020E6100000FCBC4E8F12E013C0FA032F4498E64940
84640	LL58 8AP	GB	0101000020E6100000C63604221F5F10C0BB911E2B9DA14A40
84641	LL30 2ED	GB	0101000020E61000007B061E296CB00EC063CAD12D85A94A40
84642	LL30 2BD	GB	0101000020E610000094089E8C3BBF0EC057C4FA50B3A84A40
84643	LD1 5HF	GB	0101000020E6100000C564900C50060BC071DF7C80F41E4A40
84644	LD1 5DH	GB	0101000020E6100000D4168D6B32090BC07269A109B91E4A40
84645	LL55 3AE	GB	0101000020E61000009FD0460955B510C04B451960D5964A40
84646	SY20 8ND	GB	0101000020E61000000F5AB4A5B3880FC09E996038D7444A40
84647	LD6 5BL	GB	0101000020E61000008FB234A616000CC09FD1B1DE03264A40
84648	LL23 7AE	GB	0101000020E61000003C0F931568CC0CC0F61ED37F7B744A40
84649	SY16 2BQ	GB	0101000020E6100000B678EDDCF8860AC014623DD407424A40
84650	SY22 5HS	GB	0101000020E6100000A75192BFC5440AC0EA3823EFC1624A40
84651	WD3 5NB	GB	0101000020E6100000076C13969495E0BF7F43FC51C1D34940
84652	LL55 4SU	GB	0101000020E6100000A428E1534A8110C01C42959A3D8F4A40
84653	LL55 1BD	GB	0101000020E610000033BC8C749C1511C0311C1EAE94924A40
84654	LD1 5HW	GB	0101000020E6100000DA4246F6F7080BC0EFF2BE3B431E4A40
84655	LD5 4RR	GB	0101000020E6100000CB924AC2CFF90CC069797995100D4A40
84656	LL32 8TP	GB	0101000020E6100000F5F57CCD72D90EC0F291393BBE9D4A40
84657	LL53 7BU	GB	0101000020E61000007DAF21382EFB11C06D0377A04E674A40
84658	LL46 2PT	GB	0101000020E6100000FE0461B8847510C05F35E03D516D4A40
84659	LL52 0EN	GB	0101000020E6100000FC372F4E7CF510C01C53C1F231754A40
84660	LL32 8BJ	GB	0101000020E610000060843AF6FDF50EC0DA594F0878A34A40
84661	LL30 2DD	GB	0101000020E610000088354BB846AA0EC0FD885FB186A94A40
84662	NW3 3ST	GB	0101000020E6100000784485EAE6E2C5BFBF4692205CC54940
84663	LL55 4NE	GB	0101000020E6100000DB0940ED015C10C0BC992C49F9814A40
84664	LL53 7AG	GB	0101000020E6100000ACFE08C3800512C092CF8657ED694A40
84665	LS8 4DQ	GB	0101000020E6100000A46DFC89CA46F8BF5D8AABCABEE94A40
84666	LL35 0LT	GB	0101000020E61000001992EE42CE2610C0DE36F867AB454A40
84667	SA43 1PP	GB	0101000020E61000003EC3E5C292BC12C05150E50F610E4A40
84668	LL27 0RQ	GB	0101000020E610000093424CCEF89A0EC0F90E6AFE19934A40
84669	NP8 1RH	GB	0101000020E610000034A4E59BC8A709C01AC4622F6FEF4940
84670	LL30 2XS	GB	0101000020E6100000B53F06E1C09A0EC0318969954FA94A40
84671	LL40 2PS	GB	0101000020E6100000D3A3A99ECCCF0EC064647F8FB05E4A40
84672	LD1 5UA	GB	0101000020E61000006DCA15DEE5620AC0E0CAC80F4B224A40
84673	SA3 5TQ	GB	0101000020E61000009A6038D7300310C0DA7AE1293FCA4940
84674	LL30 2LN	GB	0101000020E610000011B7F93548A70EC0E7F7A2E2A4A94A40
84675	SY15 6AA	GB	0101000020E6100000981AFC581C9908C08E57C5C0DF444A40
84676	SA64 0BT	GB	0101000020E6100000370AFFD8DAF913C025DB0AABC2004A40
84677	LD3 7AD	GB	0101000020E6100000B56B425A63200BC0C705B17D12F94940
84678	LL26 0DS	GB	0101000020E6100000C0A113E94E690EC0A7A06BF71C924A40
84679	LL57 1LZ	GB	0101000020E6100000D65B5E14988910C0EE748CD0749C4A40
84680	SA9 1XD	GB	0101000020E6100000635A400D84B90DC00397C79A91E64940
84681	LD3 7YB	GB	0101000020E6100000ED6A4D4E48960AC0179D2CB5DEF64940
84682	LL40 1YD	GB	0101000020E61000003624496B67830FC0B83F72C68B5F4A40
84683	LL52 0RP	GB	0101000020E6100000B676ECB13EF710C0A857CA32C4754A40
84684	LL53 8BE	GB	0101000020E61000006387E75BD5D812C06E0D11DCED664A40
84685	LL52 0SP	GB	0101000020E6100000856863DB581711C08A3A730F09764A40
84686	LL52 0AA	GB	0101000020E6100000B02EB8301CF110C0C7B2AA6FAA754A40
84687	SA43 2BS	GB	0101000020E6100000B6977ED3053E12C0877368ECA60F4A40
84688	LD8 2BE	GB	0101000020E61000002ACF17D6E81008C06B9C4D4700234A40
84689	LL42 1YN	GB	0101000020E6100000F4FA93F8DC4110C08C097B246F5D4A40
84690	LL30 2UG	GB	0101000020E61000007599F5BDE1A90EC06C3DE87EF3A84A40
84691	LL28 5LF	GB	0101000020E610000068EC4B361E5C0EC078F75B960AA34A40
84692	RG4 6TN	GB	0101000020E61000001F85EB51B81EEDBF5C8FC2F528BC4940
84693	LL24 0HD	GB	0101000020E6100000E4254921DA580EC0085B47B0CC8B4A40
84694	LL35 0EB	GB	0101000020E6100000966DF13A2C2E10C0A404583F91454A40
84695	LL40 2HP	GB	0101000020E61000001415BBC7E3230FC074ACF7C033664A40
84696	NP8 1BE	GB	0101000020E61000008A308F464F1B09C0276085A5CBED4940
84697	LL32 8DP	GB	0101000020E6100000E158BCFD5EBF0EC00234A55071A44A40
84698	LL35 0SB	GB	0101000020E6100000F792C6681D4510C06680B0F8F2454A40
84699	LL30 2YG	GB	0101000020E6100000FDDF6CCE1CAD0EC018BC9E9E2DA94A40
84700	LL68 9SA	GB	0101000020E6100000E3474618507911C0D8D5E429ABB54A40
84701	LL40 2SU	GB	0101000020E610000095B54DF1B8380FC023C385973B614A40
84702	LL53 7HR	GB	0101000020E6100000FDFA7CEFCA0912C062C6CA1E57694A40
84703	LL53 7HW	GB	0101000020E61000008A198634CF0612C0C950BA9976694A40
84704	LL30 2NR	GB	0101000020E6100000887082250DA40EC03A79ECC26AA94A40
84705	LD3 0YP	GB	0101000020E610000037058DF4FD4F0AC0F44B69A274064A40
84706	LL30 2LP	GB	0101000020E61000006CA45B655CA70EC01A47F652C2A94A40
84707	LL52 0HP	GB	0101000020E610000098C9CBF511EB10C0CD2E2988CB754A40
84708	KT6 4HN	GB	0101000020E6100000B0B95972CBFDD3BF914D4DDDF0B24940
84709	SW7 4NQ	GB	0101000020E6100000C364AA605452C7BF90A0F831E6BE4940
84710	LL41 3ES	GB	0101000020E610000035023B48997E0FC0C868D3C7327F4A40
84711	LL40 1AR	GB	0101000020E61000004FF6E0FFD8150FC03126FDBD145F4A40
84712	LL52 0HW	GB	0101000020E6100000C57421567FEC10C05D4425BF8F754A40
84713	LL42 1DQ	GB	0101000020E61000004B1C1E673F2F10C0D6A7C1D9525C4A40
84714	LD7 1BL	GB	0101000020E6100000B127CB5A546508C0D905836BEE2B4A40
84715	SY10 9EU	GB	0101000020E61000005376FA415D7408C044FAEDEBC06A4A40
84716	LL55 4YE	GB	0101000020E6100000F836FDD98F6C10C04886C1A15C814A40
84717	SA65 9HJ	GB	0101000020E61000007FFACF9A1FE713C08BE88D4935FF4940
84718	LL25 0EJ	GB	0101000020E6100000E41071732A190FC0F699B33EE5864A40
84719	LL35 0NA	GB	0101000020E61000000F75C4C6612510C0EFEAB01DE7454A40
84720	SA32 7RA	GB	0101000020E6100000B349D97D229A10C0B0B211E390F94940
84721	LL23 7AB	GB	0101000020E6100000DEAF027CB7C90CC0AA51FEA490744A40
84722	LL42 1TG	GB	0101000020E6100000BA8B8BFE2B1610C0AECCA502385E4A40
84723	NP15 1PG	GB	0101000020E6100000BB0819E9C15407C0589CC22EB0D34940
84724	LL40 1YB	GB	0101000020E6100000DDBB61365C6F0FC01DC9E53FA45F4A40
84725	SA62 6BN	GB	0101000020E610000020E84FB8AA1415C0BEC5908A29F04940
84726	EH2 1EX	GB	0101000020E6100000C10EAD5FFA9809C01803907F0BFA4B40
84727	S6 2GB	GB	0101000020E6100000998235CEA6E3F7BFFDCDD5A079B34A40
84728	LL65 2EZ	GB	0101000020E61000007E326BCE665A12C01CEC4D0CC9A24A40
84729	LL32 8YX	GB	0101000020E610000034A7261CD5C40EC0B9A1CE818A9A4A40
84730	NP8 1BW	GB	0101000020E610000025404D2D5B1B09C0416D0A1AE9ED4940
84731	LL52 0HL	GB	0101000020E6100000F57FB33973EC10C054747F5072754A40
84732	LD2 3DT	GB	0101000020E6100000427E912B50360BC0BCD3F8E010134A40
84733	LL30 2YB	GB	0101000020E610000000B49C3A45AD0EC07D5A457F68A94A40
84734	LL30 2EE	GB	0101000020E6100000E37FA4E87EB30EC051D1606C84A94A40
84735	LD2 3TF	GB	0101000020E61000003773C9EAB6310BC001B969D8D4154A40
84736	LL52 0AA	GB	0101000020E6100000B02EB8301CF110C0C7B2AA6FAA754A40
84737	LL53 7EB	GB	0101000020E61000004BA07719B40612C076EFF2BE3B694A40
84738	LL30 2LL	GB	0101000020E6100000F151DA7635A40EC034D769A4A5A94A40
84739	HD6 1JZ	GB	0101000020E61000001C6D663E317CFCBF6790CC34ABD94A40
84740	BT1 3WH	GB	0101000020E6100000B57867A329A917C07D2D9E30174C4B40
84741	WR12 7LF	GB	0101000020E610000048D85CDA153FFDBFB9ED314745054A40
84742	WC1B 3LS	GB	0101000020E610000053D0AB09BB8BC0BF6DB1C4CB1FC24940
84743	SW1W 8EG	GB	0101000020E6100000F9BCE2A9471AC4BF0C16985F17BF4940
84744	PO4 0NQ	GB	0101000020E6100000726DC46D1622F1BF46C7755642644940
84745	W2 3RA	GB	0101000020E6100000CD3B4ED1915CC6BF6F1283C0CAC14940
84746	LN6 3QZ	GB	0101000020E6100000DFE00B93A982E3BF44FAEDEBC0994A40
84747	LL53 5TH	GB	0101000020E6100000D38558FD11CE11C0F83EB03E79724A40
84748	KA11 4LD	GB	0101000020E6100000BC6862964A9912C05B5DD7FA25CE4B40
84749	UB3 5FG	GB	0101000020E61000001CEA77616BB6DBBFB954A52DAEBD4940
84750	BS8 4HY	GB	0101000020E61000004C89247A19F504C04E51E4FF44BA4940
84751	EN2 8AR	GB	0101000020E61000000B53332253E9BCBFFE2A02946DD54940
84752	L3 5UL	GB	0101000020E61000004D3E8CFC39D207C069F8D771CAB34A40
84753	RH5 6HS	GB	0101000020E61000008396E5531631D9BFED2BA235259B4940
84754	HU15 2EU	GB	0101000020E6100000234674740194E3BFC3013E8919E24A40
84755	S40 4TD	GB	0101000020E6100000A13193A817FCF6BFA9F92AF9D89E4A40
84756	SW3 6PU	GB	0101000020E6100000C4B12E6EA301C6BFC6151747E5BE4940
84757	KW14 8EH	GB	0101000020E61000001ACC159458280CC0F8C3CF7F0F4C4D40
84758	RH6 0BE	GB	0101000020E6100000849ECDAACFD5C6BF053411363C954940
84759	NE3 5HN	GB	0101000020E61000001630815B77F3F9BFC092509F89844B40
84760	HP12 3AB	GB	0101000020E61000009F71E1404896E8BF1747E5266AD14940
84761	AB12 4QS	GB	0101000020E610000084622B685A2201C0D003691030884C40
84762	TR18 3AE	GB	0101000020E61000007D6D4782BA2216C0EA9DC02ACD0F4940
84763	DL12 9SE	GB	0101000020E61000000CCC0A45BADFFDBFBCEA01F390414B40
84764	LS8 4DR	GB	0101000020E610000074CFBA46CB41F8BFE527D53E1DE94A40
84765	B26 3EH	GB	0101000020E61000006468051EC989FCBF29108A6EBC394A40
84766	TQ12 3QH	GB	0101000020E6100000CFF8BEB854B50CC0D76F815F7E454940
84767	IP23 8AJ	GB	0101000020E6100000132C0E677E35F23FF8567FDF1A2C4A40
84768	SO23 9EF	GB	0101000020E61000008AE81EACDB15F5BFEB43B1F1ED874940
84769	ST16 1JJ	GB	0101000020E6100000AEBB88D5701401C0DC205DE328694A40
84770	DN34 5AD	GB	0101000020E61000002C5ED1521E82B7BF5AD93EE42DC74A40
84771	DN20 9LF	GB	0101000020E6100000C7890A308778E0BF1B214D0691C64A40
84772	TA8 1BQ	GB	0101000020E6100000D2B8814C7CFF07C0CBA953D44F9E4940
84773	SA1 1NX	GB	0101000020E61000001E55A3102E880FC036A6ED80E7CF4940
84774	BN3 3JE	GB	0101000020E61000001A63A63BEF89C5BFDE95E369076A4940
84775	G2 4DQ	GB	0101000020E6100000022B8716D90E11C09F3C2CD49AEE4B40
84776	BN1 2FW	GB	0101000020E6100000E76CABA03C08C3BF8C55A18611694940
84777	EC3N 4AX	GB	0101000020E610000034F1B8EFEB9CB4BF5D8E242F55C14940
84778	EX4 4HY	GB	0101000020E610000087FDF9111A4C0CC0BACF3B5FFD5C4940
84779	CV7 7NH	GB	0101000020E6100000051AC7A3AF3BFABF025251AB9E374A40
84780	BN1 1AD	GB	0101000020E610000047FC9C18184DC2BFF5985F052C694940
84781	GL50 3DZ	GB	0101000020E6100000BA1DD08888A900C0ED53D79F19F34940
84782	EH2 2DG	GB	0101000020E61000005BF8E006938E09C09F91541BE6F94B40
84783	KT13 9HB	GB	0101000020E6100000AA7D3A1E3350DCBF28A14F3F03B04940
84784	NW2 3ED	GB	0101000020E6100000A59F70766B99CBBFBCD7FFEF3EC74940
84785	EX37 9HD	GB	0101000020E610000099A48D7E8F550FC0D4FF8359B27B4940
84786	CF37 4HP	GB	0101000020E610000027B04A3327790AC0A56208A5D4D14940
84787	CF10 3AL	GB	0101000020E61000000D71AC8BDB6809C03D2CD49AE6BD4940
84788	RG40 5QG	GB	0101000020E6100000F69E8D0637DCEABF6F07B5A2B7B54940
84789	WA6 6HH	GB	0101000020E61000006104E852B7CE05C07B38375C9AA44A40
84790	GL20 5RZ	GB	0101000020E6100000147471D7EF4A01C0C68AFEF6D3FE4940
84791	SW4 9DE	GB	0101000020E6100000E103E04499B2C2BF9F05A1BC8FBA4940
84792	RG14 7HL	GB	0101000020E61000009D11A5BDC117F5BF9BE61DA7E8B04940
84793	NG1 3PZ	GB	0101000020E6100000345651723D60F2BF2D74CA48627A4A40
84794	EH3 5LH	GB	0101000020E6100000CC852579099909C062DC685B28FB4B40
84795	PE8 6JA	GB	0101000020E6100000337BEAA2328FDABF2288F370024A4A40
84796	EH4 1PW	GB	0101000020E6100000BF406E9144C309C01421B29E53FA4B40
84797	EC1M 7AH	GB	0101000020E61000000C906802452CBABF8E06F01648C24940
84798	IV22 2EY	GB	0101000020E610000039454772F90F16C04A7B832F4CC64C40
84799	PH10 7QG	GB	0101000020E61000005E3B11F76AED0BC0A0381D5464694C40
84800	KY7 6NE	GB	0101000020E61000008DAD0C4F542B09C034FDC863BC1A4C40
84801	SW1X 7LA	GB	0101000020E61000009CA223B9FC87C4BF00917EFB3AC04940
84802	PA37 1SD	GB	0101000020E61000006CCABA2473A915C0912C6002B7424C40
84803	SW1X 7DJ	GB	0101000020E6100000678D3F265994C3BFF3BDCBB419C04940
84804	CM24 1SF	GB	0101000020E61000008195438B6CE7CB3FFF21FDF675F04940
84805	SN5 4ED	GB	0101000020E6100000EA1D13CE13D4FDBF16E8C9EB77CA4940
84806	TN25 4HR	GB	0101000020E610000076F9D687F546EC3FDE37633D5A984940
84807	LE10 1AD	GB	0101000020E6100000CC0BF2AB20F3F5BFFFC1F2ADF0444A40
84808	CW1 6UZ	GB	0101000020E61000001B588C8F563603C0C26A01E1908A4A40
84809	SY13 4JH	GB	0101000020E61000003BDF4F8D976E05C04C378941607D4A40
84810	PA38 4BX	GB	0101000020E61000008D55945C0F1815C066C1C41F45554C40
84811	PH10 6JN	GB	0101000020E6100000750470B378B10AC068565B56064B4C40
84812	EH30 9SL	GB	0101000020E61000008E4358E8DEAE0BC06AB3FB9F0DFF4B40
84813	PH16 5HT	GB	0101000020E610000077AE39515CCF0DC0C7C26BF2EF594C40
84814	RG14 3AG	GB	0101000020E6100000C66D3480B740F5BF2EFF21FDF6B54940
84815	CV7 7DE	GB	0101000020E6100000A245B6F3FDD4F9BF431CEBE236324A40
84816	PA9 1DB	GB	0101000020E6100000AE78341F214412C0CD2445BF11E64B40
84817	KY7 6DB	GB	0101000020E61000009016C2C5E51309C0E62ACC310F1A4C40
84818	DG5 4QF	GB	0101000020E6100000E9A45247225F0EC079F64B7ACE6E4B40
84819	ZE1 0RB	GB	0101000020E6100000E8B0B101C774F2BFEA58A5F44C134E40
84820	EH12 5JU	GB	0101000020E6100000A1E1838DA1C209C0DAD836D60FF94B40
84821	PA60 7XU	GB	0101000020E61000001CD94B0977CD17C03A3476D377EA4B40
84822	PH15 2DY	GB	0101000020E610000019814BDC37E60EC0E7FCC37FC24E4C40
84823	KY12 0UB	GB	0101000020E6100000E1E93AF9993F0BC06EF6AC10FB0A4C40
84824	PA28 6AB	GB	0101000020E6100000775FDF98AF6C16C0B7A7F5C830B64B40
84825	HS9 5XD	GB	0101000020E61000006128716770F51DC0C38EB575267A4C40
84826	PH3 1DF	GB	0101000020E6100000E8E96D7DA29C0DC00904F0051C264C40
84827	SA70 7HR	GB	0101000020E6100000CDC8C5BD9ECC12C03464E190B2D54940
84828	LL24 0AS	GB	0101000020E6100000BDE9F1D654610EC056EF1582C18A4A40
84829	LD3 0SL	GB	0101000020E6100000A5F1B0F5B1A709C0C0C3FEFC08044A40
84830	NP8 1PU	GB	0101000020E61000002E3075A1033C09C083EB408CC6ED4940
84831	LL29 7PS	GB	0101000020E61000009C01898109C70DC098CDD20440A54A40
84832	SA70 7PY	GB	0101000020E6100000E92F4F4244E512C05397E71C97D44940
84833	DD10 8RL	GB	0101000020E6100000D5B2E5F75EB903C06101BE6E205B4C40
84834	ML10 6SZ	GB	0101000020E61000003DA632E82B3810C0507B51886ED74B40
84835	KW16 3JX	GB	0101000020E610000082CAF8F719D709C052712DA40D7E4D40
84836	AB54 4SH	GB	0101000020E6100000A6AAA3BFA44006C030C125D73FBA4C40
84837	LL30 1RS	GB	0101000020E6100000FB15772B676D0EC0AE5200E0E6A54A40
84838	BD1 5SH	GB	0101000020E610000011C7BAB88D06FCBFE8D9ACFA5CE54A40
84839	SO15 5AB	GB	0101000020E6100000AD8A709351A5F6BFF7D912036E744940
84840	TN31 7LD	GB	0101000020E61000008819D0C1E993E73F54A7A89FDC794940
84841	IP1 3PH	GB	0101000020E61000007B8C4D863E53F23F3C44488215084A40
84842	EX10 8RY	GB	0101000020E61000003FCF55A98FF609C04600DCD1A4564940
84843	LL18 3AU	GB	0101000020E6100000989130C2CAD70BC06743A3E0CEA94A40
84844	LL52 0PT	GB	0101000020E61000004F232D95B7CB10C06BB8C83D5D774A40
84845	TD15 2EG	GB	0101000020E6100000E48F5841C21600C036F22F3839E14B40
84846	EC4Y 9AT	GB	0101000020E61000006DA23B2DE4B6BCBF3A234A7B83C14940
84847	SO14 2NA	GB	0101000020E61000004AC91759D76DF6BF179F02603C734940
84848	BD17 7QW	GB	0101000020E6100000296C6C9A6ACAFBBF5D1DBE5405EE4A40
84849	NR7 8RP	GB	0101000020E6100000FEFE3C296D73F53F588AF60EFD544A40
84850	BA5 2SQ	GB	0101000020E6100000750A4D6D042D05C049C21957B79A4940
84851	CA13 0EH	GB	0101000020E61000005095A58C6EF30AC0EC5685BCD4544B40
84852	DD8 2QJ	GB	0101000020E61000002AAD1ADF722006C0B8D6CD7B524F4C40
84853	HP3 0DS	GB	0101000020E610000094F5036D5ED4E0BFE504E27F6FDD4940
84854	TR11 4NX	GB	0101000020E6100000B8A68AF3813E14C0F2800DE3C9124940
84855	B15 3TR	GB	0101000020E610000064DEF4786BEAFEBF08A57911B73B4A40
84856	G68 0HD	GB	0101000020E6100000E00014D203970FC07714893762FD4B40
84857	EH1 1LL	GB	0101000020E610000059518369187E09C0941799805FF94B40
84858	TN13 3SH	GB	0101000020E6100000F3DF281EBC1BCA3FAE4BE88942A44940
84859	PA17 5HE	GB	0101000020E6100000A0BE0A95248C13C03B89AD45B0EA4B40
84860	EH1 2NT	GB	0101000020E61000003E3EF101598E09C0E490145E70F94B40
84861	CR0 6XE	GB	0101000020E6100000489C5FDE2DDAB3BF22437D810FB04940
84862	SO42 7YQ	GB	0101000020E61000005D740D8EED10F8BFB590DB8A586D4940
84863	KT2 7HY	GB	0101000020E6100000C4CCBD0E3CA1D1BF08FAABCA35B64940
84864	B92 0EJ	GB	0101000020E6100000823AE5D18D50FBBF00506AD4E8384A40
84865	TQ1 3TG	GB	0101000020E61000002CD49AE61D270CC0CC7F48BF7D3D4940
84866	HP23 5QY	GB	0101000020E61000004CDED0F9C854E4BF2EFC22993CE64940
84867	EH12 8AT	GB	0101000020E61000008A1F63EE5A420AC0FFB27BF2B0F84B40
84868	DH4 6LX	GB	0101000020E61000005110E1044BFAF7BF9BAFED48506B4B40
84869	LE13 0HP	GB	0101000020E6100000159227A490FFECBF2828452BF7614A40
84870	TA21 8SN	GB	0101000020E6100000A8AD6C7AABE909C02CB81FF0C07C4940
84871	TA21 0RU	GB	0101000020E6100000FC8051932A3B0AC0E84B6F7F2E814940
84872	RG29 1LP	GB	0101000020E61000001C06F357C81CEEBFC108D0A56EA04940
84873	HA9 8DS	GB	0101000020E6100000C66D3480B740D2BF2CD49AE61DC74940
84874	SN15 1BX	GB	0101000020E6100000910F7A36ABEE00C0766F456282BB4940
84875	TW18 3JD	GB	0101000020E61000008C214AC5108AE0BF565F025C35B74940
84876	PR6 7ED	GB	0101000020E61000004D066B8F231D05C06437D38765DA4A40
84877	W1B 1NT	GB	0101000020E61000007246DE8321BCC2BFACEBAB06BCC24940
84878	TQ13 7AX	GB	0101000020E6100000733A7FC97C060EC0AC5791D101424940
84879	EC3N 4AB	GB	0101000020E61000009BD145F93889B3BF807B4386FAC04940
84880	TA3 5DH	GB	0101000020E6100000628D695CEE5208C081C0142F60814940
84881	GL20 5BH	GB	0101000020E6100000E40A94B99E3D01C0E7E7E15F5FFF4940
84882	S32 2HE	GB	0101000020E610000077876FBC960BFABF2E0DB21B6CA64A40
84883	CO7 6HN	GB	0101000020E61000008E26BEAA1856EF3FCAE733A597FA4940
84884	LE15 9LT	GB	0101000020E6100000D5D7A9A8B0C8E6BFC03B9E3B66484A40
84885	IP27 0AX	GB	0101000020E6100000EC04EA831BDFE33F3387495DD7394A40
84886	ME17 2ED	GB	0101000020E61000009CCBC3F81F4FE83FB54A557F299F4940
84887	TQ6 0RA	GB	0101000020E61000001443CDEBE3CC0CC09E3F6D54A7294940
84888	DE4 3PG	GB	0101000020E610000063C625D8C90AF9BF2741C92E628F4A40
84889	PE9 2LP	GB	0101000020E6100000D0DFA2985E90DEBF63F49FDFBE524A40
84890	TR6 0BY	GB	0101000020E610000020A1C101889614C08A986D02672C4940
84891	DD11 1QF	GB	0101000020E6100000444FCAA486C604C06F34DB70B3464C40
84892	PA34 4XG	GB	0101000020E6100000726DA818E73716C096A9EE36141E4C40
84893	LE6 0DU	GB	0101000020E61000000B3B31900C5EF3BF676325E659544A40
84894	KY12 8NJ	GB	0101000020E6100000C3C5408D31F60BC0030BBB8333084C40
84895	CT2 8LR	GB	0101000020E610000085590D2EC219F13F7A5B446F4CA44940
84896	GU7 3HS	GB	0101000020E6100000E08442041C42E3BF03160A229C984940
84897	BB3 2JU	GB	0101000020E6100000E7165F590EB903C0C1CD3D7F35D74A40
84898	LS8 4DZ	GB	0101000020E61000000B5D8940F54FF8BF60CAC0012DE94A40
84899	NG10 1LW	GB	0101000020E61000006B3304B63964F4BFDADC3DE53D734A40
84900	EH3 7SL	GB	0101000020E6100000DCA1BCEA5CBC09C0A622BA0CA4F94B40
84901	TA1 5EG	GB	0101000020E6100000E90A5B58DC1409C082209B3F01824940
84902	WR13 6QG	GB	0101000020E61000006222529112DC02C085AFC158650A4A40
84903	GL7 5NT	GB	0101000020E6100000B93C31467F43FDBF2DFC2A0A05E14940
84904	DE45 1NS	GB	0101000020E61000003FF2E8F510ADFABF3A97EC1CA69F4A40
84905	CM3 5XF	GB	0101000020E6100000CE609D746CCEE33FE5CD86A17AD24940
84906	EH42 1AE	GB	0101000020E61000004CA4349BC73104C009BE0E417A004C40
84907	OX7 3PP	GB	0101000020E6100000AAE518DA4AB9F7BFE6A9B3FFA6EF4940
84908	TR26 2EA	GB	0101000020E6100000683D7C9928EA15C018810C78F41A4940
84909	SN8 3AY	GB	0101000020E61000003E6A5DB41199FABFF1DD414706AF4940
84910	DT1 1UP	GB	0101000020E6100000A01A2FDD248603C0EC51B81E855B4940
84911	AB31 4AB	GB	0101000020E61000009E25C808A82004C017789384E9864C40
84912	TQ13 7JW	GB	0101000020E6100000B74604E3E0220EC096F727A72C414940
84913	TQ2 5HG	GB	0101000020E610000024D6E253004C0CC0AE0A79A97D3B4940
84914	RG20 8XY	GB	0101000020E61000001973D712F241F5BFF931E6AE25B44940
84915	RG21 7NY	GB	0101000020E61000007A36AB3E575BF1BF363CBD5296A14940
84916	LL17 0LW	GB	0101000020E610000039F29B1D04780BC06863809FCC9F4A40
84917	WS13 6PR	GB	0101000020E6100000F29860BC0F4DFDBF62F7DBA651574A40
84918	NW9 5LL	GB	0101000020E61000009419CAE42F88CEBFA7C98CB795CC4940
84919	GL50 2DR	GB	0101000020E6100000EA23119688A600C0D61DE16D4BF24940
84920	PL4 6AL	GB	0101000020E610000038EE3955638E10C0619A33EC41304940
84921	EH8 8AU	GB	0101000020E6100000E57235129E6D09C0A94196DA92F94B40
84922	DG16 5JB	GB	0101000020E610000031FB86D3936308C0FEBD6FD7A67E4B40
84923	DN1 2DS	GB	0101000020E6100000D9A55714C006F2BFBD0A9D95BCC24A40
84924	MK16 8DS	GB	0101000020E6100000D6390664AFF7E7BF4029FFFFA40A4A40
84925	SA16 0TH	GB	0101000020E6100000F81515B80F1111C0F5342D9F8FD74940
84926	OX15 4ET	GB	0101000020E6100000B68A598A3F05F6BFD7DAFB5415024A40
84927	G75 0QZ	GB	0101000020E6100000F18643559DA010C0F930C2AE42DF4B40
84928	TW18 3BA	GB	0101000020E61000006F9C863B26A1E0BF0111707571B74940
84929	HA9 7JA	GB	0101000020E610000053509B8246FAD2BFB2721E04D3C64940
84930	BH1 2PR	GB	0101000020E6100000B3A50CF14FDEFDBFDC534E88345C4940
84931	TW10 6UZ	GB	0101000020E61000009A081B9E5E29D3BFEA5DBC1FB7B94940
84932	PL19 8YG	GB	0101000020E6100000FBACD799E79510C086AB0320EE454940
84933	BH23 7BH	GB	0101000020E6100000B63643609BA3FCBFBF2F890EDC654940
84934	WR12 7AJ	GB	0101000020E6100000243031F1A2AAFDBF5D9BD722B3044A40
84935	CT1 3DZ	GB	0101000020E6100000AD35EF93FE79F13F0A63B0879BA24940
84936	BH21 1JA	GB	0101000020E6100000476B56C73BD1FFBFA3C9C51858664940
84937	YO62 4LA	GB	0101000020E610000057772CB64945EFBF7353B93FCD154B40
84938	JE3 8BT	GB	0101000020E61000005DFE43FAED6B01C050864FDFD7994840
84939	S11 8NX	GB	0101000020E6100000A9082BA6B6D2F7BF0AD3C22872AF4A40
84940	EH1 3AA	GB	0101000020E6100000ECC039234A7B09C05F984C158CFA4B40
84941	CF3 2UQ	GB	0101000020E6100000BB7EC16ED8A608C069ED6C7EB2C54940
84942	TN11 0NA	GB	0101000020E610000018C9C3E7F3F6D13F6EB3C23E4B974940
84943	RH10 4ST	GB	0101000020E6100000145FED28CE51C1BF0D8EED105A8F4940
84944	OX15 0SL	GB	0101000020E6100000FE7BC0A18F30F5BF0410CFF68EFD4940
84945	CH2 3PD	GB	0101000020E6100000D2135CCDB6D606C07F6CA14A5E9A4A40
84946	EH2 2BY	GB	0101000020E61000007AD9F0A04B8B09C0CE55749DE6F94B40
84947	CA3 8AL	GB	0101000020E610000026C19598D97E07C0E2ACF07D1D724B40
84948	TR2 5PF	GB	0101000020E6100000D006054AAFC213C0F629C764711A4940
84949	BH2 5HE	GB	0101000020E6100000F79074F66335FEBF867CACEDA15B4940
84950	GL56 0LJ	GB	0101000020E61000002EB4877EEC44FBBF36573A1073FE4940
84951	LE15 8AB	GB	0101000020E6100000881F52C2024EE5BF33970AE01C564A40
84952	RH2 9BL	GB	0101000020E6100000728BF9B9A129CBBFD7E54AF37D9E4940
84953	EH48 2EL	GB	0101000020E6100000864FDFD7ED080DC0CF36925F9AF04B40
84954	SL4 5UR	GB	0101000020E6100000D47C6FB54993E3BF91DA969192BD4940
84955	GU14 6TH	GB	0101000020E6100000C8B60C384B09E8BFF41208E00BA44940
84956	FY3 8LL	GB	0101000020E6100000C287333B621708C0B41EDF5AFDE74A40
84957	BS32 4TS	GB	0101000020E6100000780B24287E8C04C0857CD0B359C54940
84958	TW7 5NA	GB	0101000020E6100000A94BC631923DD5BF7801405FC4BD4940
84959	TW9 1QJ	GB	0101000020E6100000AD7A2166F478D3BFDEFB792519BB4940
84960	EH1 1YT	GB	0101000020E6100000E010AAD4EC8109C0A7BEE25FBAF94B40
84961	TW10 6UT	GB	0101000020E6100000B5B2333B4151D3BF1B4D897F33BA4940
84962	SN5 7DW	GB	0101000020E6100000F58FCABC714CFDBF7B7F8B67B3C74940
84963	HD3 3YP	GB	0101000020E6100000A872DF0C2CF7FDBF62AFB2E129D44A40
84964	WR1 2NF	GB	0101000020E61000001BD7BFEB33C701C01CA4969CC9174A40
84965	TN16 1SJ	GB	0101000020E61000000D665DED725BB03F6E556D927AA14940
84966	DE74 2PP	GB	0101000020E6100000A6633BD02480F5BF7896D4945A6B4A40
84967	CT16 3EL	GB	0101000020E610000069A21E8EED8EF43F2F4B0BFC00944940
84968	SG11 1SA	GB	0101000020E61000003F4DC3764B007B3FED65BA5B42F14940
84969	WC1B 3HD	GB	0101000020E61000003B70CE88D2DEC0BF1895D40968C24940
84970	EX35 6EQ	GB	0101000020E610000024BC98C173AA0EC0E21D8590989D4940
84971	TN37 7DB	GB	0101000020E6100000430E000B4F9EE13F313F373465714940
84972	EH3 7RY	GB	0101000020E61000006AC2514DA4BF09C035255987A3F94B40
84973	AL1 3PR	GB	0101000020E6100000983C7AD0A7E6D4BF41252DE3C6E04940
84974	SY8 4AD	GB	0101000020E6100000D2133BBFCDB705C0A5DC7D8E8F2B4A40
84975	DT3 4HE	GB	0101000020E61000006A1C4531D48C04C03FEB75E679554940
84976	KA27 8PQ	GB	0101000020E61000007A7F65A090EB14C02670E1FCEAB84B40
84977	BS24 0EX	GB	0101000020E61000004628B682A6B507C06A9F330E9AA54940
84978	DH3 2SJ	GB	0101000020E610000025CD1FD3DAF4F8BFD3F4D901D7714B40
84979	CA1 2QS	GB	0101000020E6100000A0ADDE3C304B07C055A0168387704B40
84980	TR7 2QY	GB	0101000020E6100000FACA283BA24714C0736AC2514D354940
84981	PL14 4EB	GB	0101000020E61000007F051F3988E411C0BA7FD18A14394940
84982	EX39 2RG	GB	0101000020E61000004E9D47C5FFD510C04BD356DB03844940
84983	DE13 9LS	GB	0101000020E6100000055807E723F6FABFF56847FDB76D4A40
84984	DG9 9AD	GB	0101000020E61000002E59709A994C14C0A680B4FF016A4B40
84985	SY20 8TA	GB	0101000020E6100000F01D1E8A4E8F0FC0A3E262B9A3454A40
84986	WN8 0QZ	GB	0101000020E61000007B4B395FECBD05C05E82531F48C64A40
84987	CT1 3DX	GB	0101000020E6100000A81ABD1AA074F13F62670A9DD7A24940
84988	PO39 0ET	GB	0101000020E61000005D60A0B5ECBAF8BF2C9A739593564940
84989	PR3 1PH	GB	0101000020E6100000F5C0221A383B06C0971DE21FB6F44A40
84990	ML6 0BA	GB	0101000020E61000000430AF6D9BE30FC0164B36C3B2EE4B40
84991	NE20 0RH	GB	0101000020E6100000FB8038F6893FFFBFFA675CF1FA844B40
84992	NE70 7NE	GB	0101000020E6100000959059075148FDBF8B91802C9FCC4B40
84993	PL25 3RL	GB	0101000020E61000006BA395D63AFC12C0C4B29943522C4940
84994	CM2 6LF	GB	0101000020E61000008C71B499F9C4DE3FA987687407DE4940
84995	PL30 3HH	GB	0101000020E6100000D0132A93752B13C04479D5B9584A4940
84996	TD9 8LB	GB	0101000020E61000006CFCD357A11206C0992CEE3F32B74B40
84997	SO42 7ZL	GB	0101000020E61000001E6338E85C3BF7BF9D50E339B6684940
84998	SG12 7PZ	GB	0101000020E6100000CAC6D92D2FE488BFE9746F313EE94940
84999	TN18 4EY	GB	0101000020E6100000D70D805DF264E03FA2CFEC5FFE854940
85000	GL4 8JH	GB	0101000020E6100000C74ED3C2C0DE00C0F1F62004E4E94940
85001	W2 1QW	GB	0101000020E61000006ABC74931804C6BFC3D32B6519C24940
85002	SR6 8DB	GB	0101000020E6100000DB8AFD65F7E4F5BFD6C56D3480774B40
85003	SM1 2BN	GB	0101000020E610000067A494C61E90CABF9B5CE73AE8AD4940
85004	SO20 6EZ	GB	0101000020E610000079D6242EB6FFF7BFF853E3A59B8E4940
85005	DG9 8TD	GB	0101000020E61000000740811C397714C02BDF8ECB136C4B40
85006	TQ12 2EZ	GB	0101000020E6100000EA3AFE52D9E00CC09BF9E246E2434940
85007	PH16 5JH	GB	0101000020E6100000E24C5D43BAD90DC05663096B635A4C40
85008	CH64 6SA	GB	0101000020E6100000178ED60748AA08C02A63320BA3A54A40
85009	CT1 2TR	GB	0101000020E6100000660575801641F13F3BB077DA75A34940
85010	AB31 5TD	GB	0101000020E6100000787DBB2CF30804C0A6B1F5C092864C40
85011	EX20 2JT	GB	0101000020E610000073ADAC23FD4C0FC0FB1F60ADDA5C4940
85012	BH24 4AH	GB	0101000020E6100000253A7073CF3FFBBFA6A9543F25694940
85013	SO42 7ZP	GB	0101000020E61000008072254C623AF9BF067F64DFBA684940
85014	EX20 4AU	GB	0101000020E6100000A79A6D2FE86310C08B9CFA4AE4524940
85015	EX23 8NG	GB	0101000020E61000009FBEAFDBB13212C020D26F5F076B4940
85016	TR26 2AD	GB	0101000020E610000035F0A31AF6E315C09C44CE0C2C1A4940
85017	CM14 4NR	GB	0101000020E6100000C0EC9E3C2CD4D23FF38E537424CF4940
85018	BS23 1BA	GB	0101000020E61000002D921BEA1CD807C07033260EEAAB4940
85019	NR19 1DL	GB	0101000020E6100000A30227DBC01DEE3F0029A03F23574A40
85020	IV4 7BS	GB	0101000020E61000006ADE718A8EE410C0DA1B7C6132BD4C40
85021	DG7 2HY	GB	0101000020E6100000866D3079A8BA10C037F11F1CFD704B40
85022	WD3 6EQ	GB	0101000020E6100000D373C1CF6EE3E0BF058DF4FD2FD64940
85023	PL22 0DD	GB	0101000020E6100000B0F4A4C378B012C09524FD2DE9334940
85024	WR13 6NA	GB	0101000020E61000000B13A16C257F02C06300F26FE1074A40
85025	TR12 7PG	GB	0101000020E61000008884EFFD0DCA14C02D89FDAF84FB4840
85026	TN13 3BE	GB	0101000020E610000094D0A79F81A2C73F8D91369F84A34940
85027	SS1 1DY	GB	0101000020E6100000A9C53B1B4DC9E63FCADC216A47C44940
85028	WA4 5AW	GB	0101000020E6100000DF5D18FD29B004C0A34BF31FB6AE4A40
85029	AL1 4QQ	GB	0101000020E610000085CDA55DF1F9D3BF659588A6A2E04940
85030	IG1 4UE	GB	0101000020E61000009B1430CBE891B03FE510CC2C9DC84940
85031	NR25 6BS	GB	0101000020E6100000630F481D7870F13FB1BF91E5C9734A40
85032	SW19 4HZ	GB	0101000020E6100000817456B032BFCBBFE67393BD4AB54940
85033	IV25 3SD	GB	0101000020E61000009B5CE73AE81D10C005590520A4F04C40
85034	CM9 4QE	GB	0101000020E6100000CF0B1C7519A3E53F6D4210D6B5DD4940
85035	EH3 8AP	GB	0101000020E610000023BB7779DFAD09C08F4E0240BAF84B40
85036	SO20 6HB	GB	0101000020E610000094CD0B6602F4F7BF0A078C3F9B8E4940
85037	CR2 7DL	GB	0101000020E6100000DB7B0272D3B0B7BFB97CDA9722AE4940
85038	CR2 6NG	GB	0101000020E61000007468ECA6EF90B9BF709C6F9FB0AD4940
85039	GU7 2RN	GB	0101000020E6100000A6666A6D7594E4BFFDB330557A994940
85040	RH6 7DT	GB	0101000020E6100000B8F809D70BD4C5BFCD03EB47A9954940
85041	PA46 7RD	GB	0101000020E61000009BCB0D863A6C18C09F5B430477EC4B40
85042	KY10 3DQ	GB	0101000020E6100000BA71E6B22CA305C0E09D7C7A6C1C4C40
85043	CT17 0SA	GB	0101000020E61000007853DB977DA8F43FE91C4D3FF2914940
85044	SO20 6HB	GB	0101000020E610000094CD0B6602F4F7BF0A078C3F9B8E4940
85045	TN24 9QR	GB	0101000020E610000026E967D892AFEC3F500DB72034954940
85046	EX10 8AZ	GB	0101000020E6100000A99322E81EE809C0E9D08EC0C4564940
85047	EX10 8RW	GB	0101000020E610000063FCADFD9AF909C079AD54B5FC564940
85048	IV32 7DH	GB	0101000020E6100000CCD9965C20CC08C09AA2128DA4CE4C40
85049	EX10 8AY	GB	0101000020E6100000C864CCB804EB09C0B38FBA42C4564940
85050	NR33 0BZ	GB	0101000020E6100000792288F370E2FB3FD425885F563B4A40
85051	EX23 8JY	GB	0101000020E6100000BE1C2C52172F12C02A053818456A4940
85052	DT7 3HZ	GB	0101000020E6100000F041BE3A7D8307C04584DACAA65C4940
85053	PH41 4QZ	GB	0101000020E610000002DAB16C415217C00ACA7E2777804C40
85054	TR7 3AA	GB	0101000020E6100000CB20883DFE4414C0E8B6E974C5354940
85055	TR7 1PL	GB	0101000020E61000005EBBB4E1B06C14C0196547F47C344940
85056	AB31 5HS	GB	0101000020E610000051C5E8143FF103C01715CCF33B864C40
85057	TQ9 6AR	GB	0101000020E6100000D0C07E3E809B0DC0E9ABF58FCF3C4940
85058	FY8 1NP	GB	0101000020E6100000CD91955F063308C0206E98B21DDF4A40
85059	DT9 3BY	GB	0101000020E6100000615A8A9A9E1604C02F9F515F3B794940
85060	FY8 1LZ	GB	0101000020E6100000D20F34B09F3F08C0680014C891DF4A40
85061	CV9 1BB	GB	0101000020E6100000398AB8A832C6F8BF1F63774CE0494A40
85062	TR5 0QD	GB	0101000020E6100000F46679C322AB14C0CD792178D7274940
85063	PE25 3DB	GB	0101000020E6100000D4B8A9144A85D53F1C35FEFBCE904A40
85064	PE9 2LB	GB	0101000020E6100000603FC4060BA7DEBF069BDFD517534A40
85065	NR25 7ND	GB	0101000020E6100000772B41022348F03F81B3731E3E7A4A40
85066	DD9 7TF	GB	0101000020E610000047448C32763D05C03E93FDF334674C40
85067	PH22 1PH	GB	0101000020E61000000E0753DED8AD0EC0970B4BF212984C40
85068	ME10 1NT	GB	0101000020E61000001A6EC0E78711E73FF6C484E2D8AB4940
85069	NR30 1EG	GB	0101000020E6100000561C188A85CBFB3F5AFA2BBF674E4A40
85070	NR30 1EG	GB	0101000020E6100000561C188A85CBFB3F5AFA2BBF674E4A40
85071	CH43 2HJ	GB	0101000020E61000002E90A0F8316608C0DED7929F9EB04A40
85072	DG6 4JG	GB	0101000020E610000027A98123D73610C093FE5951D56A4B40
85073	EH9 2AX	GB	0101000020E6100000C6F3BE96FC6409C00E92F41F88F74B40
85074	SY6 6DP	GB	0101000020E6100000E5C06158B47F06C00BA30F4C24454A40
85075	DE4 3JQ	GB	0101000020E6100000273A819F27D4F8BF020CCB9F6F924A40
85076	PL28 8BY	GB	0101000020E61000001DDE18A7C6C013C079FE59982A454940
85077	M7 3NE	GB	0101000020E61000008B074AC09E2502C0184CB2C4B9C14A40
85078	IV22 2EJ	GB	0101000020E6100000FE20DCAEE15314C0F4A44C6A68C94C40
85079	IV22 2HX	GB	0101000020E6100000D33E671C345516C0E35C797F72EB4C40
85080	BA16 0EF	GB	0101000020E6100000F259434E04E605C078E5C46867904940
85081	BA16 0EF	GB	0101000020E61000005DB4C05104E605C07B88256967904940
85082	HD8 0PE	GB	0101000020E61000007FD93D7958A8FBBFA8C64B3789D14A40
85083	TN30 6BD	GB	0101000020E61000006DE3540DF0F4E53FD71D16609B884940
85084	GL6 6XX	GB	0101000020E6100000C7736CF3B58D01C04C4343B577E44940
85085	IP13 6NU	GB	0101000020E61000002DF246414B92F43F0949B082290B4A40
85086	NN3 7RZ	GB	0101000020E61000002E484442A55BEBBFA05B9EBDE9244A40
85087	DT4 8DN	GB	0101000020E61000000BDE46B9EAA003C00BE6F91DD44D4940
85088	BH2 5QX	GB	0101000020E61000006E1B2AECC046FEBFAF6C2B65355C4940
85089	NE71 6AD	GB	0101000020E6100000C190D5AD9E2300C08F2221808AC64B40
85090	WV15 5AL	GB	0101000020E6100000F9B8997E475003C0C4C204C65E444A40
85091	TA24 7JE	GB	0101000020E6100000B36C9C03BA850CC0E7CEA7E90E8D4940
85092	EX34 9NU	GB	0101000020E6100000298EA8F5237210C055A35703949A4940
85093	EH3 9DJ	GB	0101000020E610000026AD5340359909C04F1F813FFCF84B40
85094	BH23 4DN	GB	0101000020E61000000E2B1E0F64C2FBBFAAC7A62AE75D4940
85095	RG28 7DN	GB	0101000020E6100000B36D07D9686FF5BF51D26817789D4940
85096	W2 3DA	GB	0101000020E610000025E99AC937DBC6BFA723809BC5C14940
85097	EH1 2JR	GB	0101000020E6100000EB820BC3919109C0AC9EDD6B52F94B40
85098	LN8 3JW	GB	0101000020E6100000BBC271CFA91AD6BF8F4BC1BFADB14A40
85099	IP25 6EA	GB	0101000020E61000007993DFA29325EA3F31105F8143494A40
85100	IP12 3NR	GB	0101000020E61000004779419F236DF73FFD135CACA80B4A40
85101	GU4 7RQ	GB	0101000020E6100000EDDC0FD31973E0BF4D11E0F42EA04940
85102	TN12 6PY	GB	0101000020E6100000CB72C8BC442BD93F87FD9E58A7994940
85103	RG20 9LE	GB	0101000020E6100000C6E1CCAFE680F5BFE2372ADC97AA4940
85104	PH35 4HS	GB	0101000020E6100000E721AEF7767E14C0516A2FA2ED874C40
85105	TN3 0TG	GB	0101000020E61000000B1B840A25CBCE3F863F86385D934940
85106	SO20 8EG	GB	0101000020E6100000F05F4987C163F9BF76214955C2914940
85107	W6 9JU	GB	0101000020E6100000D270CADC7C23CEBFB65A71BBE1BE4940
85108	GU7 1HR	GB	0101000020E6100000F70082DEC089E3BFFDDB65BFEE974940
85109	SG3 6SB	GB	0101000020E610000073124A5F0839C4BFBE69FAEC80EB4940
85110	PL35 0AS	GB	0101000020E61000000409E5D8D5C712C04C9C267D6B574940
85111	TR10 8DA	GB	0101000020E6100000DC8882740C6B14C05CFA3CEBBF154940
85112	WA7 4SQ	GB	0101000020E61000005CA4F55C4BDD05C0A1FBCD1F2EAA4A40
85113	SW6 1HS	GB	0101000020E610000081502855EC79C8BFEA5FED8387BD4940
85114	TN11 8NU	GB	0101000020E6100000C51B3E8E8B0FCB3FC23060C9559D4940
85115	AL8 7XG	GB	0101000020E6100000A946544DB5BBCFBF94CACAE5F5E64940
85116	ME17 4BU	GB	0101000020E610000038A7EDBA121CE13F0116F9F5439C4940
85117	KT17 1UF	GB	0101000020E61000004D4BAC8C463ED0BF8BFA2477D8AC4940
85118	AB38 9SR	GB	0101000020E610000060E5D022DB7909C0575BB1BFECBE4C40
85119	BT79 7DH	GB	0101000020E61000005139DCFDE0321DC016EEA6A5034E4B40
85120	RG4 6UT	GB	0101000020E610000019AF79556735EDBF58C5C0DFD4BC4940
85121	B97 4JE	GB	0101000020E610000028147D99831BFFBFFB5B02F04F264A40
85122	TN1 2LY	GB	0101000020E61000009FB0EACA6C12D13F39AF7C59C4904940
85123	PO16 7DS	GB	0101000020E6100000474F368A51DCF2BF71F783CB746D4940
85124	CB2 4QR	GB	0101000020E610000062985D41E43EC03F31C15F82090C4A40
85125	CT15 6EW	GB	0101000020E6100000BEAF80F8AFC2F53F7CF6B75F99934940
85126	OL10 2QD	GB	0101000020E610000093FA57FBE0C101C0E42D573F36C94A40
85127	RH1 4ED	GB	0101000020E6100000D886E52A7178C3BF911ED0E3419E4940
85128	CV35 9JL	GB	0101000020E6100000F9B369B63CC0F9BFF7A287EB62174A40
85129	PE10 0LY	GB	0101000020E61000007AD10D034CCFDCBFE75C401EB0654A40
85130	NR30 2DG	GB	0101000020E6100000A625FB8CB0CDFB3F7F69519FE44D4A40
85131	NR30 2DG	GB	0101000020E6100000823CBB7CEBC3FB3F3F4FA84CD64D4A40
85132	G63 9EH	GB	0101000020E610000082DAB97A5F3611C0243031F1A2FD4B40
85133	ST1 4NW	GB	0101000020E61000009AACF6555E7701C011DB824A01824A40
85134	PH25 3DP	GB	0101000020E61000006728EE78933F0DC0B521B53F06A24C40
85135	PE13 1JD	GB	0101000020E6100000DBB7A4B44824C43FF8C3CF7F0F554A40
85136	NR21 9AY	GB	0101000020E610000038BA4A77D719EB3F489DCAB3DC694A40
85137	TR2 5DJ	GB	0101000020E6100000BF30F4E38A0E14C0462F59CB53144940
85138	CT12 4BZ	GB	0101000020E610000060ABA9D15008F53F76EFF2BE3BAA4940
85139	BN18 0DX	GB	0101000020E61000007C3E866B0EC0E3BFF1C8C70A18694940
85140	RH6 8QG	GB	0101000020E6100000698F8927CA04C5BF1F8BA7FD9A974940
85141	GL8 8XZ	GB	0101000020E61000004EBC5EF5DB2202C06371491F04D54940
85142	BA11 2HJ	GB	0101000020E6100000C244CDA1568202C0679EB70C939E4940
85143	CT14 0ED	GB	0101000020E61000008248D0A9750CF53FDA3BA3AD4A9F4940
85144	TN17 2PT	GB	0101000020E61000003E4970D9D7B0E03FA6F8533E5F8E4940
85145	DT4 7SW	GB	0101000020E61000000C699E6D7F9803C0C30FCEA78E4F4940
85146	CR2 6JJ	GB	0101000020E6100000E69C8EB6E0FBB9BFEFB902C067AD4940
85147	G82 2PJ	GB	0101000020E6100000BEA4315A472D12C0987CFD5AA8F84B40
85148	CV35 8AB	GB	0101000020E610000051823BA6A7EDF9BF55E4C6E398204A40
85149	BB7 9QJ	GB	0101000020E61000004EF1B8A816D103C05DD1F7640FEB4A40
85150	DE45 1QB	GB	0101000020E61000003C8963B89559FBBF1378CCE5AB9C4A40
85151	TQ13 9XP	GB	0101000020E6100000D634947FD2E50DC0828FC18A534A4940
85152	SY6 6HG	GB	0101000020E6100000E8610DBCFF6406C07E20D4A0C3464A40
85153	TA3 7RF	GB	0101000020E6100000D320BBC106FA08C04EA6C0B80A744940
85154	TN27 8DR	GB	0101000020E610000037B2E19F0858E43F6A36EA7CD38A4940
85155	CA3 0DE	GB	0101000020E6100000DC6C2D45529007C0D7D45BFE21764B40
85156	WV15 6AS	GB	0101000020E610000031B837D6FD3703C0AA25BD7274434A40
85157	CV7 7EL	GB	0101000020E6100000BA7A5FA6376DFABF0AB54BC054324A40
85158	EX23 8NG	GB	0101000020E6100000689192C3CC3312C01BF6D61B106B4940
85159	TQ5 8HA	GB	0101000020E61000008C834BC79C270CC0938A6B216D324940
85160	WR12 7DE	GB	0101000020E61000000A50AE8449ECFDBF4D7276210C054A40
85161	HR4 8SJ	GB	0101000020E610000036FAE29C220107C0AA89F4914A144A40
85162	CW5 6NB	GB	0101000020E610000011F46107DF0504C0162296838F884A40
85163	PL35 0AS	GB	0101000020E61000000409E5D8D5C712C04C9C267D6B574940
85164	SY9 5AE	GB	0101000020E6100000A515DF50F8FC07C04BDE4AC0F93E4A40
85165	DE6 2HS	GB	0101000020E6100000844BC79C67CCFCBF6C14483FD0834A40
85166	CO11 2UJ	GB	0101000020E6100000622B0DA1EF53F23FAC7E5B66C7F54940
85167	NG34 7JP	GB	0101000020E61000006F151FFA4910DABF295B24ED467F4A40
85168	CB10 1NY	GB	0101000020E610000031F15B354ED1C83FD8508885BC074A40
85169	CA13 0XW	GB	0101000020E610000002124DA088650BC05F2DD21FF5554B40
85170	NR27 9AS	GB	0101000020E6100000A6F919CD80A9F43FC6ADDDD15A774A40
85171	DT2 8PZ	GB	0101000020E61000009C91F760082F03C070044E5BC85B4940
85172	SP4 7EU	GB	0101000020E6100000905C48D1148BFCBFE339B6F9DA954940
85173	TQ5 9TJ	GB	0101000020E61000002844C02154190CC07FA4880CAB324940
85174	ME14 3DZ	GB	0101000020E6100000E4E9A6DE6465E13F0458E4D70FA74940
85175	CM6 1AX	GB	0101000020E61000009F4F2ED7EC12D73F240ED940BAEF4940
85176	CA4 8QD	GB	0101000020E6100000F065474F364A06C01E28017B96754B40
85177	CT10 3PQ	GB	0101000020E61000004C2C3AA3F717F73FA8CE5955E5B04940
85178	JE3 8AD	GB	0101000020E6100000BCFF345AB36A01C02FE301C00C994840
85179	DG7 3HU	GB	0101000020E6100000AE3720F8CE0E0FC0B6FBB03962844B40
85180	DY12 1AG	GB	0101000020E6100000E4277A85AA7D02C0F196506628304A40
85181	GL16 8JT	GB	0101000020E61000005C8D964A12FC04C0C1974D766FE24940
85182	WD3 4TG	GB	0101000020E6100000DFE00B93A982DDBF2D211FF46CD64940
85183	NG24 2SA	GB	0101000020E6100000461A266431FBE6BF2A25BA1DD0874A40
85184	KT22 7AX	GB	0101000020E610000050C829954B3ED5BF7500C45DBDA54940
85185	NW10 7UG	GB	0101000020E6100000728A8EE4F21FD2BF5B423EE8D9C44940
85186	IV25 3LP	GB	0101000020E61000007DD179E8161D10C089754FC35CF04C40
85187	IV63 7YW	GB	0101000020E6100000C2C30F2961B914C079533651F0934C40
85188	CV34 4DP	GB	0101000020E6100000DCF3FC69A37AF9BFA2348A9B09244A40
85189	GU23 6BB	GB	0101000020E6100000857B65DEAA6BDFBF7AA702EE79A64940
85190	AL1 1TJ	GB	0101000020E610000083EB9B453962D4BF414F5EBFBBDE4940
85191	GU7 1BZ	GB	0101000020E61000008C7AD2D391ADE3BF06E0FA0B98974940
85192	SN16 9LU	GB	0101000020E6100000FDCBA43CA9B500C0ED3A657FEAC94940
85193	RG27 8AR	GB	0101000020E6100000904B1C792032ECBF0555FE1076A64940
85194	PO6 4FB	GB	0101000020E6100000713D0AD7A370F1BF3F355EBA496C4940
85195	IP11 2EY	GB	0101000020E61000008F2AD4E47358F53F78BD8FFEF2F94940
85196	SW5 0EN	GB	0101000020E6100000D2FF722D5A80C8BF677BF486FBBE4940
85197	SP4 0EG	GB	0101000020E6100000E62E7887CAB5FABF04ABEAE577984940
85198	TF10 7AB	GB	0101000020E61000007775D88EF30803C07C968C086B624A40
85199	AB51 4GY	GB	0101000020E6100000ED2A0727602F03C020C776C117A54C40
85200	KW10 6SA	GB	0101000020E61000000169FF03ACC50FC0C39A6FE93DFD4C40
85201	TR21 0PL	GB	0101000020E6100000DA0FC2ED1A4619C0CB8BA77922F54840
85202	RH1 4PB	GB	0101000020E6100000C5387F130A11BABF89015CDABA9E4940
85203	TR11 4AP	GB	0101000020E6100000B8A68AF3813E14C0F2800DE3C9124940
85204	TA24 7PP	GB	0101000020E61000005B4D8D86421A0DC09D6C5E3013914940
85205	EX31 4QT	GB	0101000020E610000048CCA266FE470FC0044BBF8E499C4940
85206	CT5 3BY	GB	0101000020E610000079D6DD582A31F03FC4004AC20CAB4940
85207	FY8 5QJ	GB	0101000020E6100000939F9E888FB907C0052857C224DE4A40
85208	HP23 5AH	GB	0101000020E6100000CCBCB090142CE5BF3ABEAC3F78E54940
85209	SG8 9AW	GB	0101000020E6100000A054562EAFB798BF60DC572FD0054A40
85210	CV8 1LZ	GB	0101000020E61000008F441E77005AF9BF4CA4349BC72C4A40
85211	BH20 6AB	GB	0101000020E61000008A5BEE945A1001C0A3ABD2E85E574940
85212	PH3 1AF	GB	0101000020E6100000231FAADF3BB00DC0B0404F5EBF254C40
85213	AL1 1EZ	GB	0101000020E61000008720BD97B1D7D5BF3C044477FFDF4940
85214	DT7 3HS	GB	0101000020E6100000BCD6941A908307C0635C16B8E15C4940
85215	HU5 2TQ	GB	0101000020E6100000FE6D0503BE91D6BFE9B6442E38E14A40
85216	TN34 1ET	GB	0101000020E6100000260D24DEF031E23F83F178FFC46D4940
85217	CT8 8RE	GB	0101000020E61000007C3661B13C5EF53F51D43EC2D5B04940
85218	KY1 4SL	GB	0101000020E610000073B6251708B708C0049953B8D4114C40
85219	PL23 1LL	GB	0101000020E61000000D3FEE11209112C093A0095E3E2E4940
85220	PL25 3SH	GB	0101000020E6100000CCA43CA9E5F512C0EADB93D1122B4940
85221	OL14 7DQ	GB	0101000020E610000095CCFB49C6EB00C0E07E654A90DC4A40
85222	CM23 5QA	GB	0101000020E61000008634CFB63FBCC73FD744B0BB8AF14940
85223	GU31 5HS	GB	0101000020E610000032D758784D3EEBBF56F54DF5BF7F4940
85224	HA9 9EB	GB	0101000020E6100000FACB47820B1AD1BF876D867961C84940
85225	IP11 2BJ	GB	0101000020E610000068CC24EA0577F53F0DAE567944FA4940
85226	TR26 2NQ	GB	0101000020E6100000CEF9CED490DD15C00093AF5F0B194940
85227	RG23 7EP	GB	0101000020E61000002B2856574F17F3BFEA20AF0793A04940
85228	PH22 1QN	GB	0101000020E6100000A913D044D8700EC003098A1F63964C40
85229	RG27 9DZ	GB	0101000020E61000002588049D5AC7EEBF5C81D71D41A44940
85230	TN24 0NB	GB	0101000020E6100000174A0F0B0145ED3F43BFA29A93914940
85231	TQ13 9EY	GB	0101000020E610000060634D1BC44D0DC06348A9DFE04B4940
85232	SG4 7JJ	GB	0101000020E61000001A8BCC7A364DCFBFBFBD0D5FD6F64940
85233	DT6 6LW	GB	0101000020E6100000F1513530A83507C04ABD022C4D5E4940
85234	FY6 7LE	GB	0101000020E61000005ED4939E8EAC07C0B613252191ED4A40
85235	TQ7 3HJ	GB	0101000020E61000004AF8945286E00EC09A4A9A9A5F1F4940
85236	NR31 6PL	GB	0101000020E6100000E2A0CE26D1BCFB3FA0A9D72D02494A40
85237	BH23 7AS	GB	0101000020E610000091ED7C3F355EFCBFFDDB65BFEE614940
85238	EX22 6PS	GB	0101000020E610000099CD2DBEB26411C091D1A68F65624940
85239	BS27 3UD	GB	0101000020E6100000FE012038783006C0478DAE7724A04940
85240	NG31 8AU	GB	0101000020E6100000EC8C2EF08EBCE4BFAE9D795088754A40
85241	SK23 6AA	GB	0101000020E610000077CD322BDE0FFFBF9623DB2E71AB4A40
85242	B75 6LN	GB	0101000020E61000003C405DC81606FDBF9EAE26038B4A4A40
85243	TQ13 8JN	GB	0101000020E6100000AB37B41204990EC09675A49F15584940
85244	TA22 9AZ	GB	0101000020E610000007BFC3A343360CC0F532E59E09814940
85245	TN18 5DA	GB	0101000020E6100000561682A5859EE03F0AB86679BE854940
85246	ME16 8QL	GB	0101000020E6100000FDA776E16260E03F2346747401A34940
85247	ME16 8SL	GB	0101000020E6100000BFC3A343963BE03F8D8642BA8EA24940
85248	CT16 1QW	GB	0101000020E6100000BE58CE948C12F53FF4BF5C8B16904940
85249	CT14 9PT	GB	0101000020E6100000102043C70E2AF63F39CC3C5EED9B4940
85250	AL6 9BT	GB	0101000020E61000001F4201800816D1BF359886E123EB4940
85251	WF8 3QQ	GB	0101000020E610000061DEE34C1336F4BF19A9F7544ED34A40
85252	ME9 7LU	GB	0101000020E6100000C2E50C20D761E53F1F7D38EDCEAC4940
85253	TR11 4AR	GB	0101000020E61000004B7C49BE6D4114C05546C8E5E4124940
85254	TR11 4NZ	GB	0101000020E610000046E307E9543A14C01C7EB85D08134940
85255	BH24 3HS	GB	0101000020E6100000C4B29943520BFCBFD565E723DF6C4940
85256	WA6 7AB	GB	0101000020E6100000E1A41FC319D205C0CD25B094C0A54A40
85257	PE11 1TX	GB	0101000020E6100000C2F9DE23BEBAC2BF7B8B9BDB03654A40
85258	BH24 1LF	GB	0101000020E610000083CDEFEA0B97FCBF2052C2024E6C4940
85259	EX8 2DF	GB	0101000020E610000027AB7D95D7250BC06D48ED8F414E4940
85260	PO16 7XJ	GB	0101000020E61000007024D0605327F3BF19D69EA39F6E4940
85261	DA12 3BL	GB	0101000020E610000043A8F7F99488DA3FDCDA1DADC5B14940
85262	PE37 7QS	GB	0101000020E6100000613EB4EACE2EE63FE2C226D7B9524A40
85263	BH24 1NP	GB	0101000020E610000046A863DF5F6EFCBFDC7CC800F56B4940
85264	BH24 3JX	GB	0101000020E61000001BD24D075745FCBFFAD4B14AE96D4940
85265	IP32 7DZ	GB	0101000020E6100000FC2BE2769368E73F2A214672B31E4A40
85266	NE2 2AL	GB	0101000020E6100000358CCC6D0CABF9BF9FEF0280BE7E4B40
85267	L1 8LY	GB	0101000020E610000010E9B7AF03E707C05E4BC8073DB34A40
85268	PH20 1BS	GB	0101000020E61000007316516E36F910C03374475A85824C40
85269	BH24 3HH	GB	0101000020E6100000A4816962CBDCFBBF6241ABDDC06C4940
85270	IP11 7DF	GB	0101000020E610000011576BB45E9CF53F663602D0ECFA4940
85271	BA6 9DP	GB	0101000020E6100000DAF8B8DB9AB905C048B76FFFDB924940
85272	MK10 9AA	GB	0101000020E6100000138E3AE96647E6BFC77696D78C064A40
85273	EH28 8LX	GB	0101000020E6100000F566F0D1C4160BC044CC94F274F74B40
85274	SN10 1HS	GB	0101000020E6100000B0211720FAF3FFBFEFB4E6DB03AD4940
85275	CO12 3RE	GB	0101000020E610000096505CB61F76F43F9EC24C0680F74940
85276	DE65 6LP	GB	0101000020E61000004A0BBD1C7BA0F9BF53CA877A23714A40
85277	PL13 2JZ	GB	0101000020E61000006222EF66571B12C0352FE296EA2E4940
85278	LE12 5DG	GB	0101000020E610000044E7EBE86EADF4BF7B1FFDE549674A40
85279	KT10 9AR	GB	0101000020E610000073729B7DD90ED6BFEC8F742995B04940
85280	PO10 7LF	GB	0101000020E61000007454F6DC9096EEBF1FCDBE16A76C4940
85281	NR31 0HW	GB	0101000020E6100000A876E162A086FB3F4DF910548D4D4A40
85282	CA13 9LE	GB	0101000020E6100000DC03BEECE8E90AC0927B1574D6544B40
85283	TR8 5SE	GB	0101000020E6100000C625D8C92A8614C04787D1BD98334940
85284	DY14 8AA	GB	0101000020E6100000F090BD39B7D403C02C7E5358A9304A40
85285	SY6 6AG	GB	0101000020E6100000793F6EBF7C8206C0ACD3371F8D444A40
85286	TF2 8NG	GB	0101000020E6100000508072254C7203C073C009E0C15C4A40
85287	ME15 8JW	GB	0101000020E61000005BB0F95D7DE1E13FA33616B94CA24940
85288	LS8 4EU	GB	0101000020E6100000B8E9CF7EA448F8BF89247A19C5E84A40
85289	TW3 3JJ	GB	0101000020E61000005E1498A9A429D8BF49E1308793BB4940
85290	PH20 1DE	GB	0101000020E6100000A6756561998010C03831242713884C40
85291	SG4 9AH	GB	0101000020E6100000ED1D7FB3DEB9D1BF1D88765FDFF84940
85292	TQ9 6PA	GB	0101000020E610000024CB261969A00DC0996C9C4A4F3B4940
85293	B93 8JA	GB	0101000020E610000044C2F7FE060DFCBF4C58761C9A2F4A40
85294	PL26 6TH	GB	0101000020E6100000C8D11C59F92513C0CF9552E119234940
85295	IP33 1RY	GB	0101000020E6100000FBBC981C2DFDE63FE30BA4D5DA1E4A40
85296	CT3 1ST	GB	0101000020E6100000B78B1F1961A0F23F8B06DFEAEFA24940
85297	SY8 1AA	GB	0101000020E6100000D35746D911BD05C08D3CB59F312F4A40
85298	HR6 8EP	GB	0101000020E61000009A5839E401ED05C01F6022E8EC1C4A40
85299	CT20 2HB	GB	0101000020E61000008369183E22A6F23F10C75FFF1A8A4940
85300	TN8 5AR	GB	0101000020E6100000C2F28C221054B03F76830DF4F5984940
85301	OX7 6YA	GB	0101000020E61000007DA53D6F74FFF9BF1A7B40EAC0F44940
85302	CO6 4JF	GB	0101000020E6100000E78A5242B0EAEB3F6626625B50FC4940
85303	PA3 4RD	GB	0101000020E6100000BBC678DED7AA11C02781728005ED4B40
85304	S35 9XB	GB	0101000020E610000099D711876C60F7BF526BF5300FB84A40
85305	DL2 1AS	GB	0101000020E6100000695B28F4554DF7BF5FC31DB97F404B40
85306	NR25 7SY	GB	0101000020E6100000347914F8D43BF23F41BCAE5FB0784A40
85307	HA1 1SJ	GB	0101000020E61000002819EF7D607DD5BF250C5E4FCFCA4940
85308	CT13 9EF	GB	0101000020E610000080F7E9D38573F53F942243D83AA34940
85309	GU14 7BG	GB	0101000020E610000037853A51B7D8E7BF0AC3DBDEC9A44940
85310	MK9 2EA	GB	0101000020E6100000604E6642E763E8BF50509C39EA044A40
85311	SP6 2HF	GB	0101000020E61000007CF0DAA50D67FCBFB1EA6289BD754940
85312	W14 8RS	GB	0101000020E6100000295140248D1BCABFA95D5D5F35BF4940
85313	BH21 5AD	GB	0101000020E6100000EF66576B72A2FFBFB450D77F42704940
85314	PO4 0NZ	GB	0101000020E61000003255302AA933F1BF9CBF098508644940
85315	BH19 3AH	GB	0101000020E6100000AEEBE2F9B657FFBF94998EDD1E534940
85316	B92 7HW	GB	0101000020E6100000A2FD593D71EAFCBFCB1B165921384A40
85317	SA1 1RR	GB	0101000020E61000004935DFCDC27E0FC078CF72BA1BCF4940
85318	EH1 1JS	GB	0101000020E6100000A285BAFE138209C0C487C89F5EF94B40
85319	DT1 1UP	GB	0101000020E6100000709B04CA018603C0F3E093F36A5B4940
85320	EX5 2TD	GB	0101000020E6100000A3625232EFD70AC05D22CD0EA7614940
85321	EX17 6RJ	GB	0101000020E61000002837401F1B270EC0C18B63C9C16E4940
85322	GL55 6UU	GB	0101000020E6100000B0D4FCF64A50FCBF06FD522DCC044A40
85323	BH14 0LU	GB	0101000020E61000000CEE62F5A251FFBF2DFC2A0A055D4940
85324	CA1 1HR	GB	0101000020E61000006096D123A16807C075D65D8F78724B40
85325	CA10 2QB	GB	0101000020E610000023C96251C72906C0144A157B1E4A4B40
85326	TR19 7HD	GB	0101000020E6100000F157B730C1B716C0DF516342CC0F4940
85327	PL12 6PJ	GB	0101000020E610000033011A00050A11C0019DEEE137374940
85328	EX18 7BW	GB	0101000020E610000025EF7783C3F60EC0801365CAE2744940
85329	TQ11 0JR	GB	0101000020E61000007D9F60B5E8230EC06FAC7AAF103E4940
85330	TQ13 9AE	GB	0101000020E6100000AED7F4A0A0640DC0C9CFA1670E4C4940
85331	EX39 3LP	GB	0101000020E6100000DE9623BFD9D910C01F37B2E19F824940
85332	S32 1BA	GB	0101000020E6100000D2AB014A436DFABF2942EA76F6A84A40
85333	DE4 3NR	GB	0101000020E61000006ED27EB5B404F9BFA7CAF78C448F4A40
85334	MK45 4EP	GB	0101000020E61000007EAA0A0DC432DBBFD79EFE582D014A40
85335	RG17 9DX	GB	0101000020E610000063C625D8C9CAF7BFD6D5D3FD52B04940
85336	SL6 3ET	GB	0101000020E6100000F614EFB6C1FFE6BF0141CA9937C24940
85337	RG20 8JX	GB	0101000020E6100000224D614AC9F7F5BF425DA45016B54940
85338	SL3 0NZ	GB	0101000020E6100000648D1FCFD365E0BF85798F334DBD4940
85339	TR2 4RS	GB	0101000020E6100000A89A0FBEE69B13C07B2DE8BD31264940
85340	PL28 8BG	GB	0101000020E61000000877C2A629C513C06C0E6B8544454940
85341	TR13 9JB	GB	0101000020E6100000E0096245B24415C027E77A91BF0A4940
85342	TR16 4LL	GB	0101000020E6100000A58059468F2415C08F28FE3916214940
85343	PL12 6QS	GB	0101000020E610000098CBFC59E23711C008605EDB363A4940
85344	TR4 8JA	GB	0101000020E6100000BFC579EEF39E14C0C007AF5DDA234940
85345	PL27 7DD	GB	0101000020E610000047D22467175A13C0E4CD2BE807424940
85346	WA16 7PU	GB	0101000020E6100000BE0C6BCFD1BF02C0C16ED8B628A84A40
85347	SK9 3JX	GB	0101000020E61000003F17B25F1CC101C016F6B4C35FAD4A40
85348	EX23 8NS	GB	0101000020E61000005AAEC8F9AC2C12C020D26F5F076B4940
85349	SP3 6PX	GB	0101000020E610000029AF95D05DD200C0D3895F0C408A4940
85350	WR6 6BN	GB	0101000020E6100000F0327C71CDE802C0C4B2012747274A40
85351	CO10 9RW	GB	0101000020E61000002B645353377CE93F5191F936B30D4A40
85352	KT18 5HW	GB	0101000020E6100000FC427EECE4C2D0BF5609BBCDC0A94940
85353	TW10 6UL	GB	0101000020E61000001949CCFD1F71D3BFB0C8AF1F62BA4940
85354	TF10 9LQ	GB	0101000020E6100000DB66D97C24E102C0E4BBBA81C75F4A40
85355	SY11 2NR	GB	0101000020E61000004E661767676C08C0C23577F4BF6D4A40
85356	WR12 7AJ	GB	0101000020E6100000243031F1A2AAFDBF5D9BD722B3044A40
85357	WR14 2HX	GB	0101000020E6100000A0BF756AD39D02C0641415BBC70E4A40
85358	BD24 0BE	GB	0101000020E6100000C6E468E9654F02C0D92038D329094B40
85359	SG18 0JE	GB	0101000020E61000004985B1852007D1BF36CCD078220B4A40
85360	SN15 2LB	GB	0101000020E61000009A3226B330FA00C0A17197B32DB54940
85361	SP2 7RT	GB	0101000020E61000006CD509C3DBDEFCBFB42BE395DA884940
85362	NR21 0NL	GB	0101000020E610000034C97ECCBDF6EE3FC953FB19836D4A40
85363	NR19 1RP	GB	0101000020E610000061B8848DFC0BEF3F7E8D2441B8534A40
85364	PE36 6AP	GB	0101000020E61000004C8BFA247758DF3FD7D75F1B96784A40
85365	PE12 8AY	GB	0101000020E610000020F70890FC1C8ABFF4A78DEA74694A40
85366	NG32 2AZ	GB	0101000020E61000005F79909E2207E4BFA98CDA58E4804A40
85367	TF12 5EW	GB	0101000020E610000040D42247DFD903C052A346D73B4E4A40
85368	TF13 6AQ	GB	0101000020E61000000AEC7B1EED7904C0A2629CBF094C4A40
85369	OX44 9HJ	GB	0101000020E61000006BD9B5189725F2BF849CF7FF71DC4940
85370	DY7 6HF	GB	0101000020E610000072767F7DF3D501C02A2286C745394A40
85371	KT8 9DD	GB	0101000020E61000004EE4935F5070D5BF7F6C921FF1B34940
85372	OX14 3DP	GB	0101000020E61000000E805DF2E4FFF2BF8F4C2C955CD44940
85373	TA3 5SP	GB	0101000020E61000006C3DE87EF36708C0B1362108EB7A4940
85374	TA1 1DG	GB	0101000020E6100000D5F83BCA77DF08C02BC7BF2A72824940
85375	ST10 2HQ	GB	0101000020E6100000728C648F5073FFBFCEEF45C549834A40
85376	SN8 1SL	GB	0101000020E6100000BDE3141DC965FBBF7353B93FCDBB4940
85377	KY15 5NA	GB	0101000020E61000006629FE94CFC707C00544D2B881254C40
85378	KY12 8DW	GB	0101000020E610000036BC0FF6DCC80BC086014BAE62094C40
85379	FK21 8TX	GB	0101000020E6100000F984ECBC8D2D11C0056C0723F63D4C40
85380	FK14 7DE	GB	0101000020E61000000A2A4FC532620DC098631E9ECA144C40
85381	KY8 6BT	GB	0101000020E6100000D9F39084D88407C067599CD6121B4C40
85382	AB56 1UT	GB	0101000020E61000002288F37002B307C0540E773FB8D64C40
85383	LS8 4HA	GB	0101000020E6100000944BE3175E49F8BFF38FBE49D3E84A40
85384	PH20 1DL	GB	0101000020E61000007C79A63C5F7810C0583101648D884C40
85385	PH50 4QL	GB	0101000020E6100000BEFA0B4C8DE313C05E1E00ABC25B4C40
85386	KW6 6EG	GB	0101000020E61000009C7BFE6AC4720BC00710994DDB1F4D40
85387	HS7 5PJ	GB	0101000020E6100000ACDFF192A4701DC069DDABFB6CB64C40
85388	KW15 1BU	GB	0101000020E6100000F0DAA50D87B507C040E7244A317D4D40
85389	GU9 7DR	GB	0101000020E6100000545227A089B0E9BFDE9387855A9B4940
85390	EH4 3DG	GB	0101000020E61000008249E57E6BC909C0E345B28984F94B40
85391	M20 5LH	GB	0101000020E610000042B9C89816D001C0488ECFBFB8B44A40
85392	LS15 9JA	GB	0101000020E6100000984C158C4AEAF6BF857CD0B359E54A40
85393	BH20 5RJ	GB	0101000020E610000058E4239EF60802C06635B808674F4940
85394	BA5 2SE	GB	0101000020E61000008F029F7AFF2A05C0E5D594BFD69A4940
85395	DG11 2RG	GB	0101000020E61000009F7401B36BD40AC0D62F73E2B4914B40
85396	PA1 2BH	GB	0101000020E61000007DD6EBCCF3E611C04D87A9882EEC4B40
85397	EC4V 5AF	GB	0101000020E6100000E55E605628D2B9BF9831056B9CC14940
85398	CO15 1RD	GB	0101000020E6100000CFAA85483C6FF23F1395B2B1B7E44940
85399	OL3 5UE	GB	0101000020E61000008DA72F95C85F00C0A370E25064CA4A40
85400	W2 4AD	GB	0101000020E6100000FBECDBA4FD6AC8BF3EE1911DC0C14940
85401	M1 1JA	GB	0101000020E610000062E7B7F990E101C05060F01FC1BD4A40
85402	JE3 8AD	GB	0101000020E6100000BCFF345AB36A01C02FE301C00C994840
85403	W2 3SH	GB	0101000020E6100000D0D556EC2FBBC7BF6F8104C58FC14940
85404	EX35 6PS	GB	0101000020E6100000A5B9E0CF9A220EC0FDC812751D9C4940
85405	W2 3LB	GB	0101000020E6100000C00C2142B7F2C7BF8E0244C18CC14940
85406	W2 3ES	GB	0101000020E610000068942EFD4B52C7BFBBE188FF85C14940
85407	WC1H 9BA	GB	0101000020E6100000CA54C1A8A44EC0BFB30C71AC8BC34940
85408	BT56 8NX	GB	0101000020E6100000EAE1708B9E981AC05C8242F3EF974B40
85409	GL6 6YB	GB	0101000020E6100000F7730AF2B38D01C001CFC03F5AE44940
85410	SW3 1PS	GB	0101000020E610000015D4A6A091BEC4BF547BC7DFACBF4940
85411	OX18 4LR	GB	0101000020E6100000BF49D3A0683EFABFB8A008F368E74940
85412	W1U 5AF	GB	0101000020E6100000914028942AF6C3BF641CC81FB1C24940
85413	GL16 7EL	GB	0101000020E6100000AFCC7211936B04C084C422F832E74940
85414	EC4V 3DB	GB	0101000020E61000003A70BF5DA524BABF3DC684B460C14940
85415	ST6 2AE	GB	0101000020E6100000A49073811C9301C012123429AF854A40
85416	NR19 1AD	GB	0101000020E6100000D0ACB6AC0C34EE3FE58BACEB06574A40
85417	GL12 8DL	GB	0101000020E610000059DF323A2FA403C0967C68F66BD24940
85418	YO21 3TL	GB	0101000020E6100000680AF8904BB7E5BFC9A596523C3E4B40
85419	CH62 4UE	GB	0101000020E6100000F82ABA741AE507C0A5EB4A4A88AC4A40
85420	EH54 6QB	GB	0101000020E61000000D06A9A4E6080CC0C48415CA69F14B40
85421	W2 3QB	GB	0101000020E610000073A48EE96404C7BF9CF1C7FEC3C14940
85422	TR2 5AN	GB	0101000020E61000007B6F67BA320B14C0D007701F5E144940
85423	EC2A 4BX	GB	0101000020E61000002BE76CB059F6B5BF0F438013D7C24940
85424	CB4 1DA	GB	0101000020E610000091966F229FFCC03FF836FDD98F1B4A40
85425	CH1 1LT	GB	0101000020E61000005883D446A51F07C0814F92FF60984A40
85426	BD1 1JX	GB	0101000020E6100000BEC117265305FCBFDAACFA5C6DE54A40
85427	WC2B 4BZ	GB	0101000020E6100000EFC9C342AD69BEBFD3DEE00B93C14940
85428	TW10 6UH	GB	0101000020E6100000E247C5973A7CD3BF2DBE787168BA4940
85429	CM21 0JU	GB	0101000020E6100000DB300A82C7B7BD3FC1374D9F1DE84940
85430	TQ1 2LL	GB	0101000020E61000008F20F01BBA140CC0F7A9CF7A9D3A4940
85431	SS11 8UE	GB	0101000020E6100000C47F1AF42E29E23F5E12674554CD4940
85432	IP8 3JD	GB	0101000020E6100000FC3E77DDB64AF13F8FE1B19FC5034A40
85433	RG42 6LD	GB	0101000020E6100000DD83C60215C4E6BF9EAB521FEDB84940
85434	NR12 9LL	GB	0101000020E6100000E44E441A70B1F73F42075DC2A1624A40
85435	BB6 8AB	GB	0101000020E610000027FFEE78EE8803C090060143A0E74A40
85436	SW3 2SH	GB	0101000020E61000001BDB54A579BCC4BF6D46DD39DABE4940
85437	EC3N 4DH	GB	0101000020E61000004B1064F327E0B3BF5E4315A353C14940
85438	YO1 9WD	GB	0101000020E610000056976A9ED74BF1BFF560D6B460FA4A40
85439	PE30 5QX	GB	0101000020E6100000A6704E362F18DA3FABD9B91FA65F4A40
85440	W1W 6JQ	GB	0101000020E6100000D8CBBE441F60C2BFE28C7DA37FC24940
85441	E1 6TE	GB	0101000020E61000004414387E4D7BB1BFD1459E7F16C24940
85442	NG7 1GX	GB	0101000020E61000006CE9D1544FA6F2BF5FD1ADD7F4784A40
85443	NG18 2AL	GB	0101000020E610000040B8A7508203F3BFE07C8F9F32934A40
85444	TA9 3RJ	GB	0101000020E61000000907529411F807C0C9D13AAFD3994940
85445	SL6 2EE	GB	0101000020E610000043640A36ABE7E5BF10D4B93A71C04940
85446	W2 1UH	GB	0101000020E6100000C03E3A75E5B3C5BFC5C2B57F0AC24940
85447	CO15 5JB	GB	0101000020E6100000C4FFC2972EE9F23FBCC2CC881CE64940
85448	RG42 4EX	GB	0101000020E6100000E0F0A396BDF7E8BF196BCEAD8FB64940
85449	SN16 0RB	GB	0101000020E610000005888219533001C09C0EAECACFCA4940
85450	LA22 9PR	GB	0101000020E6100000E5C41CD99C2408C058318F0EE5394B40
85451	EH41 4BZ	GB	0101000020E6100000FB5C6DC5FE3206C0273108AC1CFA4B40
85452	SO45 3NE	GB	0101000020E6100000AA995A5B1D45F6BFD2E1218C9F6D4940
85453	NE2 2AP	GB	0101000020E61000007CDA3C693CACF9BFAF6B6A8FCD7E4B40
85454	NW1 6DX	GB	0101000020E6100000E2CCAFE600C1C4BFF5B3A217FFC24940
85455	BB11 2DH	GB	0101000020E610000041063C7A0DEB01C00BABC2B00DE54A40
85456	SW5 9LS	GB	0101000020E61000009C645012B7AFC8BFD65D34BFF5BE4940
85457	CF14 7EF	GB	0101000020E610000002A604AB87E709C093455F16DAC24940
85458	DT8 3AY	GB	0101000020E6100000D49AE61DA7E805C09D8026C286674940
85459	BS10 7TL	GB	0101000020E61000005227A089B0E104C0EBE2361AC0C34940
85460	BN1 2GS	GB	0101000020E61000005557D32FF020C2BF0BCBD260F0684940
85461	SW5 0PU	GB	0101000020E6100000820B68D8DE5DC8BF7A54FCDF11BF4940
85462	WC1H 9EL	GB	0101000020E61000000042DAB57350C0BF95CF978345C34940
85463	W2 3JS	GB	0101000020E610000006F126648CB4C7BF463E54BF77C14940
85464	CO1 1DJ	GB	0101000020E6100000715C724E7FC5EC3F0E85201EC1F14940
85465	AL1 3TF	GB	0101000020E6100000BDCA145202EBD4BF1FB0D84ADBDF4940
85466	DL1 3AD	GB	0101000020E61000000F0BB5A679C7F8BFBBB88D06F0464B40
85467	SW5 0QJ	GB	0101000020E6100000FC8C0B0742B2C8BFDD32969F0ABF4940
85468	BA1 2XT	GB	0101000020E6100000A31DC0EDCC0E03C0980DA7D6FFB14940
85469	TA1 4DQ	GB	0101000020E6100000AABFB91A34DF08C039EA8DFFA7814940
85470	NR25 7AA	GB	0101000020E610000084BC1E4C8A8FEF3F4A35FD231D7A4A40
85471	LE17 4EJ	GB	0101000020E6100000338CBB41B436F3BFF8432223563A4A40
85472	PH33 6RW	GB	0101000020E61000002B8716D9CE7714C055C1A8A44E684C40
85473	EC3N 1NU	GB	0101000020E61000008716D9CEF753B3BFD3DEE00B93C14940
85474	DE45 1RR	GB	0101000020E610000075125B8B600DFABFE5E48FB3FA9F4A40
85475	WA10 1NG	GB	0101000020E6100000A5BC6DDEECE605C0349E4FB788B94A40
85476	BH1 3AQ	GB	0101000020E6100000F131B32A1DC7FDBF719989D8165C4940
85477	LE16 8TH	GB	0101000020E61000004FFFFE39711EE7BFDB19017047414A40
85478	BD23 6AJ	GB	0101000020E6100000A8C64B378941FEBF3255302AA9FB4A40
85479	RH19 4LJ	GB	0101000020E6100000D60E90792E9DADBF28FA2D4EFD8B4940
85480	SW1W 8EB	GB	0101000020E6100000DBA09BA2C8FFC3BF2D544843D7BE4940
85481	SW7 4JW	GB	0101000020E610000039D6C56D3480C7BF2CD49AE61DBF4940
85482	SO42 7QL	GB	0101000020E610000056A0FFE61198F8BF9674CC2D38694940
85483	HD8 9LE	GB	0101000020E61000009FDCE4273D1AFABF474295796FCA4A40
85484	WF2 7AL	GB	0101000020E610000099F04BFDBC29F8BF7D08050022D54A40
85485	EH7 5DD	GB	0101000020E6100000303C4041736709C027E5A4E661FA4B40
85486	TW19 7PW	GB	0101000020E6100000358D62C317E9DEBF6A56F0BA42BA4940
85487	EH8 8PE	GB	0101000020E6100000BC6367C00F6D09C031AE5D7FB7F94B40
85488	HX7 8ES	GB	0101000020E61000009A52A8B8BB1800C082678C20DFDE4A40
85489	ST3 1BZ	GB	0101000020E61000009F7B6A508F1801C03FCF55A98F7E4A40
85490	LU1 3PE	GB	0101000020E61000000B012B4D6B4FDABF7E671B82DAEE4940
85491	NR12 8AJ	GB	0101000020E6100000246724EC2287F63F0294DA19135B4A40
85492	B16 9LQ	GB	0101000020E6100000D66B1F97DD38FFBF7C60C77F813C4A40
85493	BN21 4DH	GB	0101000020E610000050DF32A7CB62D23F6BE9769BDC614940
85494	WR13 6DW	GB	0101000020E6100000CA349A5C8CC102C06E64C33F11084A40
85495	YO7 1LL	GB	0101000020E6100000DE776748707EF5BF23618495AF1D4B40
85496	SW7 2DL	GB	0101000020E6100000B2B5638FF579C6BFA9F34D3F4DBF4940
85497	SW7 2EA	GB	0101000020E61000007DD0B359F5B9C6BF6D2695DF58BF4940
85498	TR11 5LG	GB	0101000020E6100000865A2E76568614C0A0E63FFF980D4940
85499	PO41 0PE	GB	0101000020E6100000FB52E4B5B700F8BF3ABB6BBF6B5A4940
85500	BS35 3XL	GB	0101000020E61000005127EA16CB4E04C0F05D3931DACC4940
85501	SP2 8EU	GB	0101000020E61000009FA40A90B2EFFCBFB5BAE69F2A884940
85502	W2 4NJ	GB	0101000020E6100000C7293A92CB7FC8BF5227A089B0C14940
85503	LL40 2AG	GB	0101000020E6100000267B3A0D07C80EC05D7EF156A7604A40
85504	CM2 8HR	GB	0101000020E6100000A32D9DC54138E03F6A58422DBCDA4940
85505	B31 2ET	GB	0101000020E6100000696FF085C954FFBF30BB270F0B354A40
85506	JE3 8EF	GB	0101000020E610000043FF04172BAA01C07D5A457F68994840
85507	PH16 5LY	GB	0101000020E6100000EA00E62C7CC10DC0C0FF8E5C42594C40
85508	L3 9RE	GB	0101000020E6100000831B89CD50F707C0865CD4E71DB44A40
85509	TN37 7BS	GB	0101000020E6100000DA5B25B3D540E13F42226DE34F714940
85510	PO6 1UN	GB	0101000020E6100000613255302AA9F0BF89D2DEE00B6B4940
85511	EX4 3AZ	GB	0101000020E6100000E9FF6673E6480CC02F41FCB26A5C4940
85512	W2 1RX	GB	0101000020E610000014AE47E17A14C6BFFC1873D712C24940
85513	WS11 1SH	GB	0101000020E610000003098A1F636E00C09E5E29CB10574A40
85514	BH1 3AX	GB	0101000020E6100000CFEB996F8EE4FDBF92C4DCFF115C4940
85515	SW5 9NP	GB	0101000020E6100000B00C608033E7C8BFFCDEA63FFBBE4940
85516	EX6 7UX	GB	0101000020E61000008649021E624D0CC025E428E55A544940
85517	TQ7 2DS	GB	0101000020E6100000B80230BC97ED0DC0016AB1AE66264940
85518	NR1 1RU	GB	0101000020E61000002A3076586700F53F41C4C13606504A40
85519	BD8 7AQ	GB	0101000020E6100000FF1FCC92A53BFCBF397D3D5FB3E74A40
85520	CB8 0UE	GB	0101000020E6100000A986B6C9CCD8D33F52D2DF259A184A40
85521	SW1V 1RR	GB	0101000020E61000008E3ADFF4D324C2BF4B0169FF03BF4940
85522	BH1 2EP	GB	0101000020E6100000DF2527C929F0FDBF73124A5F085C4940
85523	SW5 9LS	GB	0101000020E610000071F783CB74F9C8BFD5B0DF13EBBE4940
85524	M5 4RS	GB	0101000020E61000005BD3BCE3141D02C0931804560EBD4A40
85525	L3 4AJ	GB	0101000020E6100000CDFBA47FEEE007C06486D73F99B24A40
85526	EH12 5LQ	GB	0101000020E610000011F98C1630C909C09C6EBDCC0EF94B40
85527	OX10 7HH	GB	0101000020E6100000FDDD3B6A4CA8F2BF9BA6745545D24940
85528	CH2 2AN	GB	0101000020E61000008170AA5A770807C0C4EE963F3A9A4A40
85529	RH12 1RB	GB	0101000020E610000055E9DD0EC37DD4BF3251291B7B884940
85530	W1J 5NB	GB	0101000020E610000055C1A8A44E40C3BFB7D100DE02C14940
85531	WF8 3JJ	GB	0101000020E61000006DF97B3B1F3CF4BF7ED6B8DB4ED34A40
85532	OX33 1AZ	GB	0101000020E6100000035E66D8282BF2BFCD94D6DF12E74940
85533	SW7 4PE	GB	0101000020E61000001BA33338637BC7BFB1A4D20B5BBF4940
85534	S41 9EH	GB	0101000020E61000007F0E982C9306F7BF4E51E4FF44A34A40
85535	BB5 5JP	GB	0101000020E61000001F85EB51B81E03C0C3F5285C8FE24A40
85536	NP25 4TX	GB	0101000020E6100000AD315068458705C076CB6E633CE14940
85537	IV3 8TA	GB	0101000020E61000008048BF7D1D3811C017C5611F53BD4C40
85538	TN40 1EE	GB	0101000020E61000004DD87E32C687DE3F1212691B7F6B4940
85539	SW7 5DA	GB	0101000020E6100000CDF36BE1354CC7BFF8FCA7505ABF4940
85540	W9 1ER	GB	0101000020E6100000F38E53742497C7BF7AA52C431CC34940
85541	YO24 1DJ	GB	0101000020E610000011363CBD5296F1BF0B24287E8CF94A40
85542	BN11 3QQ	GB	0101000020E6100000451CA1551C3DD8BF894A7E1F69674940
85543	LS8 5AS	GB	0101000020E6100000AEEFC3414254F8BFC7681D554DE84A40
85544	SN4 8EF	GB	0101000020E6100000FFA21529DE32FEBF29EB3713D3C74940
85545	SW3 1AH	GB	0101000020E61000008AAE0B3F389FC4BFAE78341F21C04940
85546	SN5 6QR	GB	0101000020E6100000D89FCE59C281FDBFB50DC7E66FC64940
85547	KA6 6JT	GB	0101000020E6100000A662635E47FC11C09879612129B94B40
85548	YO7 3RW	GB	0101000020E6100000D34D62105839F6BF105839B4C8164B40
85549	BT47 3PA	GB	0101000020E6100000651D8EAED2FD1BC0EB2B595F6E864B40
85550	TR7 1DB	GB	0101000020E6100000FA0967B7965114C05ACA43F009354940
85551	ME12 2DA	GB	0101000020E61000003A24100AA58AE93F54F2FB485BB74940
85552	SO42 7XB	GB	0101000020E6100000B70DA32078BCF6BFE84B6F7F2E664940
85553	W2 3PF	GB	0101000020E610000043AD69DE718AC6BFE10B93A982C14940
85554	GU22 7SG	GB	0101000020E610000008B0236992F3E1BF1C9A0D8D82A74940
85555	TQ1 3SQ	GB	0101000020E6100000453069E78F240CC01E1B81785D3D4940
85556	SO32 3QL	GB	0101000020E6100000B67B5E961B31F2BFB82D80DF757B4940
85557	ST16 2JA	GB	0101000020E6100000B3237ABE0BF000C082493B7F24674A40
85558	DL10 4HS	GB	0101000020E61000007AC7293A92CBFBBFA49A481FA9334B40
85559	W2 4PS	GB	0101000020E6100000E729BC15D396C8BFDBB97A5FA6C14940
85560	YO22 5LZ	GB	0101000020E610000097587446EFEFE6BF845CF3F45B334B40
85561	SW5 9TT	GB	0101000020E610000048179B560A81C8BF7801405FC4BE4940
85562	BH1 3QB	GB	0101000020E610000064963D096CAEFDBFB759619FA55C4940
85563	EC1M 5RJ	GB	0101000020E6100000C442AD69DE71BABFDE718A8EE4C24940
85564	GL52 2PZ	GB	0101000020E61000005A417859B88100C0557545DF93F34940
85565	W2 3AN	GB	0101000020E61000006C843419445AC7BFB087403F9DC14940
85566	MK11 1JP	GB	0101000020E6100000D0C1E9132F45EBBFF93BCA77DF064A40
85567	PO31 7AW	GB	0101000020E6100000C3F5285C8FC2F4BFDF6A42FFA9614940
85568	W1U 8HS	GB	0101000020E6100000533D997FF44DC4BFB40F689F7DC24940
85569	RH5 6BX	GB	0101000020E61000007B14AE47E17AD4BF0000000000A04940
85570	BL0 9DS	GB	0101000020E6100000DD365120F39602C0909B81944FD34A40
85571	SY4 3AG	GB	0101000020E610000000000000000006C0E17A14AE47614A40
85572	W1T 3NG	GB	0101000020E610000016EC1C89EBA6C1BF0B01814D24C24940
85573	PO30 4HX	GB	0101000020E6100000AEF8E17BDAFCF5BF36F7A11C16584940
85574	PO11 0QR	GB	0101000020E610000062FE65529E94EFBFE4277A85AA654940
85575	RG45 6DL	GB	0101000020E61000005C08CD09359EE9BF52955BFF53AF4940
85576	KA23 9NB	GB	0101000020E610000061B47D7ECE7313C0487023658BD74B40
85577	KA27 8LS	GB	0101000020E6100000D8254FFE938414C0D622FD512FC44B40
85578	SP7 8AW	GB	0101000020E6100000EC7717DE9B9501C0A0D16751E9804940
85579	HP22 6DU	GB	0101000020E6100000A088450C3BCCE7BFBD0ADFB18EE14940
85580	SW5 0PG	GB	0101000020E6100000B91C42A4C56AC8BFB50EF55806BF4940
85581	G74 1JR	GB	0101000020E610000039DB920B84B310C0CB11329067E14B40
85582	LD5 4RB	GB	0101000020E6100000B302E89C44190DC03D9E961FB80D4A40
85583	HA9 9EB	GB	0101000020E6100000D1E000440B1AD1BFFEDBC07861C84940
85584	RH19 3UD	GB	0101000020E6100000D855928664127F3F3B4BDA9E6A8F4940
85585	EC4M 8AD	GB	0101000020E61000004AF894528660B9BFAE2B6684B7C14940
85586	SL4 1LJ	GB	0101000020E6100000805BAF9DB37BE3BF71905C7391BD4940
85587	DN2 6AD	GB	0101000020E61000008195438B6CE7F1BF3480B74082C24A40
85588	DE4 5JU	GB	0101000020E6100000CD38DD176FA2F8BFECBC9FB04A904A40
85589	W1G 9DT	GB	0101000020E61000005AE55311B8BFC2BF6E01FCAE63C24940
85590	EH9 2BZ	GB	0101000020E6100000F017B325AB6209C03B7E5EA747F74B40
85591	PH6 2DN	GB	0101000020E61000008195438B6CE70FC0728A8EE4F22F4C40
85592	YO11 2AJ	GB	0101000020E6100000F64D50792A96D9BF12859675FF224B40
85593	KY3 0SW	GB	0101000020E6100000DDC6B0D4C46C0AC06766C11FD9064C40
85594	CW3 9QF	GB	0101000020E6100000689E29627BF702C051828CED267E4A40
85595	W1J 9BR	GB	0101000020E6100000AB3A0E30B141C2BFADD3B89FE2C04940
85596	SW1V 4JE	GB	0101000020E6100000899C9D90C6B6C2BF839E009CB4BE4940
85597	LS8 5DB	GB	0101000020E6100000DCBC71529837F8BF439259BDC3E74A40
85598	DE72 3PB	GB	0101000020E6100000E407F87F1FBFF5BF1C4DE438A6734A40
85599	EC4M 7DR	GB	0101000020E6100000857CD0B359F5B9BFA857CA32C4C14940
85600	FY8 1LX	GB	0101000020E610000047A57D18C64208C0C444DECDAEDF4A40
85601	WV6 7HR	GB	0101000020E6100000805C870F915F02C03AF8D390024C4A40
85602	SL4 1PH	GB	0101000020E610000017A93C29AF6FE3BF1B0E6758AEBD4940
85603	E14 9SH	GB	0101000020E6100000727B687072F791BFAF24A42E0CC04940
85604	GL53 0JE	GB	0101000020E6100000F5BBB0355BA900C0D0DECFDF3AF14940
85605	BA2 4JP	GB	0101000020E6100000A63337AC97D902C0F90320192BB04940
85606	S66 1YY	GB	0101000020E61000008A2D959BCE14F4BF23843DA913B64A40
85607	LE3 8HB	GB	0101000020E610000003322A5F8615F3BF04BD81131B544A40
85608	W2 4NT	GB	0101000020E6100000A4703D0AD7A3C8BFFDF675E09CC14940
85609	LS8 5DE	GB	0101000020E610000028BA2EFCE03CF8BF42D13C8045E84A40
85610	NR7 0HH	GB	0101000020E6100000A13B7771D17FF53F58CA8D7D24504A40
85611	CA18 1SD	GB	0101000020E6100000BF10CD9772490BC03A6C6CC0312D4B40
85612	SS0 7QW	GB	0101000020E61000000C040132746CE63FB37FF9BF7EC44940
85613	SW3 2SA	GB	0101000020E6100000AC6928FFA4EBC4BF903B5BF6DABE4940
85614	IG4 5BG	GB	0101000020E610000042599D41E845A63FE3303D06D0C94940
85615	EX8 2EX	GB	0101000020E6100000B8A3497375310BC0F299EC9FA74E4940
85616	TQ6 9RT	GB	0101000020E610000009394AB956A60CC0D6FECEF6E82C4940
85617	SP4 6AT	GB	0101000020E610000009A52F849C97FCBF282A1BD654904940
85618	BR5 3NJ	GB	0101000020E610000078D498107349BD3F6C6B555C66B24940
85619	E14 8RS	GB	0101000020E6100000F697DD9387859ABF569FABADD8BF4940
85620	EH9 2AX	GB	0101000020E6100000FA563552006609C0E48D829664F74B40
85621	W2 4DX	GB	0101000020E61000008FDF8AAD683FC9BF54A0C8F356C14940
85622	SW1V 1PB	GB	0101000020E61000003714E3A194B5C2BF592D550ED2BE4940
85623	IV23 2PH	GB	0101000020E610000018271994C4BD12C0480F8D38AED74C40
85624	BA22 8LN	GB	0101000020E6100000A4E9471EE37505C07CF31B261A804940
85625	PE30 1NN	GB	0101000020E610000040A20914B188D93F998F5A176D604A40
85626	NN12 6LG	GB	0101000020E6100000DB899290485BEEBF4D1AFE2EC70D4A40
85627	SG4 8XD	GB	0101000020E6100000D4CACEEC0445CEBFAA72EB7FCAEC4940
85628	IP22 5UN	GB	0101000020E6100000FFF5C07DD36AF23F0750429F7E364A40
85629	CO10 8DT	GB	0101000020E6100000421FD1A9D065E03FFB0DC97F370C4A40
85630	TA12 6PB	GB	0101000020E6100000E1F6BAFBD2F105C0B730C15F827D4940
85631	YO13 0PB	GB	0101000020E610000032C280CA9D3EDDBFF02B7BB71E274B40
85632	CB2 4NL	GB	0101000020E61000004A09C1AA7AF9C43F43024697370D4A40
85633	TA24 6SF	GB	0101000020E6100000678D8BB49E8B0BC0554FE61F7D974940
85634	NR27 9QA	GB	0101000020E61000006829DACE5706F43FE55D58ABF4774A40
85635	LL22 9AS	GB	0101000020E61000009B47B4D3C58C0CC0212D848BCBA34A40
85636	OX12 0DQ	GB	0101000020E610000043421F22F197F6BFED5E263E02CF4940
85637	DN21 2DD	GB	0101000020E61000002C79E173CCDEE8BF74BD231928B34A40
85638	PE25 2UB	GB	0101000020E610000039F9E3AC3E0DD63F4BF1A77CBE924A40
85639	DE55 6EH	GB	0101000020E61000001DE38A8BA3B2F6BFB9A2395739904A40
85640	GL16 8QB	GB	0101000020E6100000C28B193CA7E404C0FC034070F0E34940
85641	ST13 8EU	GB	0101000020E6100000DF933DF83F4600C0DB221FAADF8D4A40
85642	IP11 7PF	GB	0101000020E61000003F6AB86D848AF53FE44BA8E0F0FA4940
85643	CW10 0JE	GB	0101000020E61000004CD75DEA318B03C04E98309A95984A40
85644	SW1V 2BB	GB	0101000020E6100000664B5645B8C9C1BF900A0852CEBE4940
85645	WS11 1SF	GB	0101000020E6100000B410D3742C8500C06149038937574A40
85646	OL10 1PX	GB	0101000020E6100000F649496AFCAD01C04449EDEAFACB4A40
85647	EX21 5DF	GB	0101000020E61000002298593AD54011C033A1EEA8D65F4940
85648	CW3 9LP	GB	0101000020E610000030624447179002C03365F1ACEE804A40
85649	PR6 9RH	GB	0101000020E61000006C5B94D920D304C079FC83EDCCCE4A40
85650	KW15 1QX	GB	0101000020E6100000D90ECC25E3B507C0609AA340FF7D4D40
85651	DN20 8EJ	GB	0101000020E6100000918AB5AE8765DFBF91D26C1E87C64A40
85652	BA5 1BH	GB	0101000020E6100000D7677341226205C052802898319C4940
85653	TR7 2RR	GB	0101000020E6100000929735B1C04714C0310CB32B88354940
85654	SY23 2BA	GB	0101000020E610000061A57DD1F05610C0C282CBC838354A40
85655	LS21 1EH	GB	0101000020E6100000DCB529C35D02FABFD64114820BF34A40
85656	BA2 4DL	GB	0101000020E610000020EEEA5564D402C0C1A49D3F12B14940
85657	CV37 6NH	GB	0101000020E610000005CE9B88535DFBBF02039981B0184A40
85658	SW1Y 6HL	GB	0101000020E6100000E10B93A98251C1BFFED478E926C14940
85659	SW1A 1NY	GB	0101000020E61000005227A089B0E1C1BF62105839B4C04940
85660	FY7 6BN	GB	0101000020E610000011244AD63C1208C034D2F7BFC8F64A40
85661	TN2 5TD	GB	0101000020E6100000BE45CC913AA6D03F72158BDF14904940
85662	OX7 6BA	GB	0101000020E6100000C61B87644290F9BF60F335C1F3ED4940
85663	BH2 5AH	GB	0101000020E610000042D4D8B9C40CFEBF33672211BF5B4940
85664	BH2 5DH	GB	0101000020E610000064755F595F18FEBF7D5C712ABF5B4940
85665	OL9 8DW	GB	0101000020E61000002207DB3E9A5001C0818AF4EC03C34A40
85666	AB56 5HJ	GB	0101000020E6100000B01AF09EA84108C0FC9D375F36D24C40
85667	EX16 7BJ	GB	0101000020E6100000828A756D19070BC06D1714B2A5754940
85668	FK8 3RA	GB	0101000020E6100000F4C29D0B232511C0A24621C9AC174C40
85669	BA22 9TD	GB	0101000020E6100000DE93E23ECD0405C05220FD4003764940
85670	TD8 6PJ	GB	0101000020E6100000EEF2F12CE84504C05E937505C9B74B40
85671	KY16 9SP	GB	0101000020E6100000D425885F567D06C07633A31F0D2C4C40
85672	TR16 5BP	GB	0101000020E61000004A9A3FA6B5C914C097169A907B204940
85673	GL16 8AE	GB	0101000020E6100000BCA71721E1F004C07DB1F7E28BE54940
85674	EH12 6HN	GB	0101000020E61000001205E91846F009C0D563B6BF0EF94B40
85675	PL26 8LQ	GB	0101000020E610000004560E2DB25513C086FB6DF4D6354940
85676	PL12 6LJ	GB	0101000020E6100000F500B016ACDC10C0B56A303D7C354940
85677	ST13 8RN	GB	0101000020E61000006284F068E39800C08C4D2B85408F4A40
85678	OX16 9AN	GB	0101000020E6100000E9FEA0E4C46DF5BFBB6D9516E4064A40
85679	IP17 3AD	GB	0101000020E6100000A150AAD8F330F93F88B77306EB214A40
85680	CW2 5NA	GB	0101000020E6100000BCE9961DE22F03C05442661D44884A40
85681	CH1 1HL	GB	0101000020E6100000FBF34EB4941C07C07B96525D61984A40
85682	WR9 0AR	GB	0101000020E6100000EC2CF926EDA001C01E1D6B07E2204A40
85683	IP20 9AS	GB	0101000020E61000000AAD3DA2F8C7F43FF198261186334A40
85684	PE28 4AL	GB	0101000020E61000001801BAD4AD43CBBF319E9CFC712D4A40
85685	PE28 4AL	GB	0101000020E61000001801BAD4AD43CBBF319E9CFC712D4A40
85686	TR17 0EN	GB	0101000020E6100000629346167AE615C0BE6D01FCAE0F4940
85687	MK11 1AH	GB	0101000020E6100000E81E3014525CEBBF334EAB3756074A40
85688	OX13 5BH	GB	0101000020E6100000E99898D30AD8F6BF6371491F04D74940
85689	S33 0AZ	GB	0101000020E6100000F4E967A0E830FBBF215C5C3EEDAD4A40
85690	RG17 7TZ	GB	0101000020E610000014E17030E5EDF8BF6FCED25FF9BD4940
85691	EX31 1PG	GB	0101000020E61000005DFC6D4F904010C0EDF2AD0FEB8A4940
85692	FY1 2JQ	GB	0101000020E610000000917EFB3A7008C0A779C7293AEA4A40
85693	KY16 0BE	GB	0101000020E610000044D5F901594907C021E9D32AFA344C40
85694	GL54 2HP	GB	0101000020E61000003E6F74DF7B29FCBFD8D30E7F4DF34940
85695	SN14 6LB	GB	0101000020E6100000F59C99057F4401C06730A1DD7CC14940
85696	TR21 0PP	GB	0101000020E6100000DA0FC2ED1A4619C0CB8BA77922F54840
85697	OL8 4AS	GB	0101000020E6100000DDA5A2EBA10901C0FE0688AAA1C44A40
85698	SK10 4HP	GB	0101000020E610000086AF0A2F1C3301C0CF7BAD951AA54A40
85699	SO40 7GL	GB	0101000020E61000002FCAC749BCB7F8BF258F4C2C95734940
85700	LE3 2WQ	GB	0101000020E6100000FC1873D712F2F2BF22FDF675E04C4A40
85701	RG30 2UF	GB	0101000020E6100000D7A3703D0AD7EFBFB515FBCBEEB94940
85702	SE1 8XR	GB	0101000020E6100000DA3DD4111B87BDBF34304D6C99C04940
85703	W1D 6BZ	GB	0101000020E6100000D2BEC130C3F3C0BFEAEF77B835C14940
85704	SW1A 2ER	GB	0101000020E6100000C80FF0FF3E3EC0BF821DFF0582C04940
85705	BS31 1SN	GB	0101000020E610000033EDAC2704EC03C0DF8728CBB5B44940
85706	PO21 2LH	GB	0101000020E61000004290D711F4C8E5BF1DDC2E1802644940
85707	PR3 1YE	GB	0101000020E6100000C27781E3492206C0B388216C8AF14A40
85708	S1 2AU	GB	0101000020E6100000840D4FAF9465F7BF36AB3E575BB14A40
85709	DD3 0QN	GB	0101000020E6100000885D256948B608C0D52137C30D434C40
85710	PH13 9HS	GB	0101000020E6100000F3BDD06DD3690AC03182210615484C40
85711	M22 4FH	GB	0101000020E6100000862032A5282102C0647E10F708B44A40
85712	TQ2 5HE	GB	0101000020E610000028999CDA19460CC00B42791F473B4940
85713	OL11 2XX	GB	0101000020E6100000AE6DE580B86601C0BA707BDD7DCA4A40
85714	W1H 5DN	GB	0101000020E610000021B0726891EDC4BFC3D32B6519C24940
85715	WV3 0NR	GB	0101000020E61000007FAE6CD5640C01C03607639F5B4A4A40
85716	E14 5AB	GB	0101000020E610000056968D7340B794BFF5279600A1C04940
85717	BS1 6PL	GB	0101000020E61000003D9B559FABAD04C0287E8CB96BB94940
85718	NE66 1PN	GB	0101000020E6100000E9E62CFD953FFBBF31AB1CFFAAB44B40
85719	WV1 4SW	GB	0101000020E6100000999BDCE0252B01C078F569963D4B4A40
85720	B90 4EB	GB	0101000020E6100000EAFCDE1D4EE5FCBFE2BA340ECD314A40
85721	WA15 0HG	GB	0101000020E6100000B2FFF0A9528902C0F32103D42FAF4A40
85722	UB7 0EQ	GB	0101000020E6100000963A6879950ADFBF148FB9A27CBD4940
85723	W1D 6EX	GB	0101000020E6100000B7BACC4B26F0C0BF28DA27108EC14940
85724	NE66 1PR	GB	0101000020E6100000E9E62CFD953FFBBF31AB1CFFAAB44B40
85725	WA14 1HN	GB	0101000020E610000086425FD5B4C602C0AD7EB61F3AB24A40
85726	IV14 9EH	GB	0101000020E610000094B0259AF66B12C076C6527F18CA4C40
85727	NE66 2RS	GB	0101000020E6100000A8188CB6CFCFF9BF97BDB6C887B14B40
85728	BN2 1AG	GB	0101000020E61000006562D464AF7FC0BF9D0BF83CCC684940
85729	WV3 9NB	GB	0101000020E610000065BDBD10172501C0C3DBDEC9024B4A40
85730	WF15 7LZ	GB	0101000020E6100000AA752C00D73FFBBF58EEBBD86AD94A40
85731	WF5 8JX	GB	0101000020E610000035D7C45D1844F9BF28A325EA60D64A40
85732	GU1 2BT	GB	0101000020E6100000370076C993BFE1BFDA3BA3AD4A9E4940
85733	SK1 1YG	GB	0101000020E61000003748D27F203A01C09E23F25D4AB44A40
85734	EH51 0DN	GB	0101000020E6100000E53B42171EE50CC0651BB80375014C40
85735	WF17 7HR	GB	0101000020E6100000B37B64063966FABFDB21AA623DDB4A40
85736	EH39 4BQ	GB	0101000020E61000001D2FEE505EE505C0D88E988F5A074C40
85737	WV8 1QF	GB	0101000020E610000081C458A1A6B001C031A97EFEAB514A40
85738	EH32 0RE	GB	0101000020E61000007E1EF93CACE306C03F3C7BC927014C40
85739	NG18 2AF	GB	0101000020E61000006A696E85B01AF3BF20E7A2C629934A40
85740	EH41 3RD	GB	0101000020E61000000234A550715706C0BC5EF5DB32FA4B40
85741	WR6 5PH	GB	0101000020E610000044D0E2D6EE2803C0D9CF622992194A40
85742	WR8 9JA	GB	0101000020E61000009441B3C05EAE01C0C3CE0056480C4A40
85743	NG13 8AB	GB	0101000020E61000007448C55AD783EEBF4B3FE1ECD6794A40
85744	NG11 6LA	GB	0101000020E610000059839C9C465FF2BF3DE9E9C836724A40
85745	WS13 7LZ	GB	0101000020E6100000AFD13084B534FDBFF94336073D584A40
85746	WR9 7EA	GB	0101000020E6100000D25048D7F1A400C0FE38AB4F83224A40
85747	M90 4HL	GB	0101000020E6100000EAD55B5E142802C06C7E575FB8AE4A40
85748	NE26 2RG	GB	0101000020E61000003CD5C67D501CF7BFE1AF6E6182854B40
85749	WR1 3QN	GB	0101000020E6100000CAB447B945CA01C00E547C32B5184A40
85750	WR11 1BS	GB	0101000020E6100000703491E39816FFBF984572439D0B4A40
85751	WR11 1DA	GB	0101000020E61000005AA99831A210FFBF42A479DC440B4A40
85752	WR11 8PA	GB	0101000020E6100000D5544E2FBC98FEBF07481DE5AC104A40
85753	NE26 2RL	GB	0101000020E6100000612D8892DA15F7BF619C09979F854B40
85754	NE26 1AP	GB	0101000020E6100000C7592261291CF7BF605B9AB6DA854B40
85755	WR12 7DE	GB	0101000020E61000000A50AE8449ECFDBF4D7276210C054A40
85756	WR11 8JP	GB	0101000020E6100000200A664CC1DAFEBF6CE3F49AC30C4A40
85757	NE26 1PA	GB	0101000020E61000003CD5C67D501CF7BFE1AF6E6182854B40
85758	NE26 1DN	GB	0101000020E6100000F5DD9B491529F7BF0D40EC4AA0854B40
85759	BS1 6HY	GB	0101000020E61000007D008FFE50B204C0E1B690299AB94940
85760	WR5 2DH	GB	0101000020E61000005F6BA5C63ABB01C02A03626DE7174A40
85761	NE2 2AL	GB	0101000020E6100000473250BE45ACF9BF539D691DB07E4B40
85762	NE1 1PG	GB	0101000020E61000009E3935E1A8C6F9BFD90CCBFA287C4B40
85763	NE1 3JF	GB	0101000020E61000006975CD3F55C0F9BF0F05D8ECED7B4B40
85764	NE26 2AW	GB	0101000020E610000059C40B7D0B06F7BF31186D9F9F854B40
85765	PR5 6BZ	GB	0101000020E61000002DB1321AF95C05C08B19E1ED41DC4A40
85766	BT9 6RU	GB	0101000020E61000006DDB7628AAC117C0C32BC0AC4D4A4B40
85767	NE9 6DR	GB	0101000020E61000004D6A6803B0C1F9BFCFA3E2FF8E774B40
85768	BA1 2HH	GB	0101000020E6100000E17A14AE47E102C0713D0AD7A3B04940
85769	NE8 2QS	GB	0101000020E6100000737A83D492B3F9BFFBA01D26D07B4B40
85770	NE9 7UB	GB	0101000020E610000006E0FFC4515CF9BF6F2A2C9AC9744B40
85771	NE2 2RP	GB	0101000020E61000000CC85EEFFE98F9BF17BA1281EA7E4B40
85772	CT2 8AF	GB	0101000020E6100000CBCA0BBDB930F13FCDFC2BAA0CA44940
85773	NE2 2PR	GB	0101000020E6100000AAD44FAC1199F9BF05F3489DAF7E4B40
85774	LS1 4AG	GB	0101000020E6100000F4DE391069B6F8BFB5E1B5EDA9E54A40
85775	NG7 2DP	GB	0101000020E6100000286FEA7D8FD4F2BFA2C1EFA49A794A40
85776	NG2 7NE	GB	0101000020E610000083C71231802BF2BF5583D5FD08774A40
85777	NG2 7LA	GB	0101000020E610000068D6ADF94C31F2BFCB4BFE277F774A40
85778	NG9 1JA	GB	0101000020E6100000EF58E85AE662F3BF6B141DBFF3754A40
85779	NG2 5FW	GB	0101000020E61000007005B9307712F2BF4B32BCA310784A40
85780	GL11 6DD	GB	0101000020E6100000D58FF238B15C03C0C8A5E0DF56D54940
85781	NE68 7RD	GB	0101000020E610000048C0E8F2E670FABFBE69FAEC80CA4B40
85782	NE68 7SQ	GB	0101000020E6100000EFBF3A336677FABFE816BA1281CA4B40
85783	NG2 5FW	GB	0101000020E61000007005B9307712F2BF4B32BCA310784A40
85784	NG7 2NA	GB	0101000020E61000008EE6C8CA2FC3F2BF22A81ABD1A784A40
85785	NG7 2SA	GB	0101000020E61000003139FFC066CAF2BFC0266BD443764A40
85786	NG7 1AG	GB	0101000020E61000000787CDB689A9F2BF2B476D872B7A4A40
85787	NG7 2DZ	GB	0101000020E6100000B730459826EDF2BFC9D79BA143794A40
85788	EC4M 7DD	GB	0101000020E610000056C7E0174D1DBABF9BE84E0BB9C14940
85789	NG5 2EF	GB	0101000020E610000049A559524E71F2BF0CAEF606587C4A40
85790	NE1 6EE	GB	0101000020E6100000687000A205CDF9BF4746BD96467C4B40
85791	NE68 7SR	GB	0101000020E61000009CB8663C5B91FABF2C5B35199FCA4B40
85792	NE68 7XP	GB	0101000020E61000003059260D7F77FABF92EA3BBF28CA4B40
85793	NE66 2PN	GB	0101000020E61000000911154FE218FBBFDFD27B7434B44B40
85794	WC1B 4BH	GB	0101000020E61000002D8B45B0CA35BFBF983D48D091C24940
85795	NN8 1NG	GB	0101000020E61000000F0BDB6D1CC3E5BFE5AF5BC7A2264A40
85796	OX15 0SH	GB	0101000020E610000051F86C1D1C2CF5BF8A213999B8FD4940
85797	NN1 2AA	GB	0101000020E6100000D4C62297499EECBF4276DEC6661E4A40
85798	NR2 2RB	GB	0101000020E610000078584D7C5A8AF43F27D0717F3F504A40
85799	NN8 2DR	GB	0101000020E6100000053411363CBDE6BFCD3B4ED191244A40
85800	NR11 8TZ	GB	0101000020E61000001B99EC44EE4EF53F89809E61C56D4A40
85801	NR12 7DN	GB	0101000020E61000008D8BB49E6BC9F53F01AF850FDB5C4A40
85802	NR10 3HH	GB	0101000020E61000000B58BCA2A57CF43FE04E7D7B32584A40
85803	NR1 1EZ	GB	0101000020E6100000122B48D85CFAF43F6DF9ED9007504A40
85804	NR2 3DA	GB	0101000020E6100000462EEEF5A482F43F6516461F98504A40
85805	NR9 5JW	GB	0101000020E6100000E569543B1EEEF13FE50929E4EF5A4A40
85806	NR11 8TH	GB	0101000020E6100000CBF023A7443CF53F1B7727F816704A40
85807	NR1 1TJ	GB	0101000020E6100000E6E8F17B9B1EF53F2AC76471FF4F4A40
85808	NR1 3RE	GB	0101000020E610000005F8133A5498F43FFBD813138A4F4A40
85809	YO15 2HU	GB	0101000020E6100000BF7C57A945E9C7BF41D076F1230B4B40
85810	LL57 3UR	GB	0101000020E61000006F3854D5C95C10C0514DF88EA29B4A40
85811	EH54 9AQ	GB	0101000020E6100000B60EB33CB4040CC03AD274D1EBEF4B40
85812	EH54 7AF	GB	0101000020E61000001E7D7550E7500CC0A281CA8B5BF14B40
85813	LA14 5UG	GB	0101000020E61000007E1D386744E909C02AA913D044104B40
85814	TQ13 9RR	GB	0101000020E61000005BB1BFEC9EDC0CC0C8EF6DFAB3434940
85815	SW6 3JD	GB	0101000020E61000008D47A98427F4CABFB6662B2FF9BB4940
85816	BN2 1QF	GB	0101000020E6100000FFB34181D2ABC0BFD2904CE207694940
85817	OX33 1JN	GB	0101000020E61000008DA2BDB0EB8DF1BFF3FD79BF76DE4940
85818	M1 3BB	GB	0101000020E6100000831D5ABFF4E101C0D60BF43FAFBC4A40
85819	E16 2PX	GB	0101000020E6100000A67AD745764AA83FA3682FEC7AC04940
85820	RG9 2AR	GB	0101000020E6100000C685A867E6EEECBF5B368474C2C44940
85821	SW7 4ES	GB	0101000020E61000009B20EA3E00A9C7BF3813D38558BF4940
85822	EX6 7YF	GB	0101000020E610000076940913D4AD0CC015D33BCBE2554940
85823	BA3 4BD	GB	0101000020E61000004C163483B1CB03C0BFCC33D356A34940
85824	DL2 2LY	GB	0101000020E610000012F7837A2D42FABFFA83E1594B484B40
85825	L3 4AD	GB	0101000020E610000072B499F9C4F007C00DEEBDAE15B34A40
85826	LL12 0AY	GB	0101000020E6100000E18B3694C89007C0D3D4E5A6E38E4A40
85827	GL7 2LE	GB	0101000020E61000009C2BEA9694B8FFBFA593B1495ADD4940
85828	CV37 6YT	GB	0101000020E610000048D9BD3D513FFBBF7F5243D4EA184A40
85829	CA10 3QU	GB	0101000020E61000000B09C715DF3805C0BB3A58E3523D4B40
85830	DN22 7XG	GB	0101000020E61000005025BE6BB482EEBFFAEADD31D2A94A40
85831	BS26 2HU	GB	0101000020E61000009CC30169091A07C0ADFBA634CBA54940
85832	G69 9BS	GB	0101000020E61000000B7E8345317810C0AD1E0790E7F24B40
85833	DH8 9BB	GB	0101000020E6100000B9655F30BA27FEBF359AF4A80C6D4B40
85834	PO4 0RN	GB	0101000020E610000092CC06739D39F1BF2ED537F6CD634940
85835	GU10 2QB	GB	0101000020E61000008CDCD3D51D8BE9BF2733DE567A934940
85836	TN26 1AR	GB	0101000020E61000008E8D153C52FBE93FFD7D872100984940
85837	G63 9NG	GB	0101000020E61000009A385E262F7F11C0DA006C4084054C40
85838	PH18 5TL	GB	0101000020E61000007AC4E8B985DE0EC0621B4C1EAA624C40
85839	HP19 0FY	GB	0101000020E61000008476B94E44EBE9BF854A0D8164EA4940
85840	BD12 0ST	GB	0101000020E6100000FFB27BF2B050FCBF0DE02D90A0E04A40
85841	CH1 2LY	GB	0101000020E610000085268925E52E07C0317DAF2138984A40
85842	CM23 5ST	GB	0101000020E6100000FC87735BC224C93F605C8E7DE7EF4940
85843	L17 3AA	GB	0101000020E6100000C4D25D65AF9307C01F8E340C2DB14A40
85844	CH1 3AH	GB	0101000020E6100000D59D1F2D6B0A07C040B4A04114994A40
85845	CO6 4PZ	GB	0101000020E6100000A93369E6D8B0EB3FF827B19EACFF4940
85846	RH17 7SF	GB	0101000020E6100000532E8AA7E976B6BF5A311A01EE7E4940
85847	SN4 0NE	GB	0101000020E6100000AF4CF5EDEFAFFBBF7B405C16ECC14940
85848	B16 9RY	GB	0101000020E61000000AD7A3703D0AFFBF5C8FC2F5283C4A40
85849	CT1 3DU	GB	0101000020E610000084BFBF3EC36EF13F560166DAD8A24940
85850	TN30 6HX	GB	0101000020E6100000E766403C99FFE53FE8D7E8327B8B4940
85851	IG8 9NY	GB	0101000020E6100000112655736A7B843FB0BC880F1CCD4940
85852	HU10 6ER	GB	0101000020E61000000FAD43A57996DCBFC0673DDF43E14A40
85853	HG1 5AH	GB	0101000020E6100000C6A6C0C27C7BF8BFD75F9FCE4FFF4A40
85854	CV32 5JQ	GB	0101000020E6100000E787B60831CCF8BF5E829FAD0D254A40
85855	CH1 3AF	GB	0101000020E61000007297092E720D07C0C3714B71F6984A40
85856	G2 7EN	GB	0101000020E6100000C3001A89F60F11C08A771DFD31EE4B40
85857	PE33 0RH	GB	0101000020E6100000708390E2D2E7DA3FAB2D2B03BD574A40
85858	TW8 0EN	GB	0101000020E61000006AB46675BC93D2BF77700BF1A3BE4940
85859	ML11 9UE	GB	0101000020E610000034A97D4748590EC088C25F7A58D64B40
85860	M30 9HG	GB	0101000020E61000001A36CAFACDC402C0AFF7D15F9EBE4A40
85861	SW5 0LR	GB	0101000020E6100000BF9CD9AED007C9BFDFA5D425E3BE4940
85862	LU1 5LX	GB	0101000020E61000004E2ED032AEDFDBBFBCEA01F3D0EF4940
85863	EN6 3QQ	GB	0101000020E61000007E5DE1B8E754CCBFE1BABDFFEAD74940
85864	N12 0QZ	GB	0101000020E61000003D633432952CC6BFA14441AC9BCD4940
85865	CF32 9SH	GB	0101000020E6100000EEEBC03923CA0CC014D044D8F0C44940
85866	EH9 2BX	GB	0101000020E6100000F017B325AB6209C03B7E5EA747F74B40
85867	WA16 0RW	GB	0101000020E6100000E74FC01B776F03C0AA317C9F05AC4A40
85868	CH7 6HJ	GB	0101000020E6100000741E5F8C92B108C08FFBFB3152994A40
85869	BT42 1EA	GB	0101000020E610000043A56FA4FC6019C06C7A097B3E704B40
85870	BS35 1HH	GB	0101000020E6100000996DE611554004C084192A3195CE4940
85871	PE19 8EN	GB	0101000020E6100000BE816ED4AF99D2BF7000474C9A1A4A40
85872	MK17 8DW	GB	0101000020E6100000ED35EEE1531FE4BF17E7B9CFBB014A40
85873	LA13 9JS	GB	0101000020E610000020CABCFA1DAF09C0DE74CB0EF1104B40
85874	WN1 2DD	GB	0101000020E61000002429E961681505C04DC928852FC74A40
85875	WN6 0TD	GB	0101000020E61000008ED8DDF2475705C0419E5DBEF5CA4A40
85876	WN1 1XA	GB	0101000020E61000007CBB80F2D20805C0BF96FCF444C64A40
85877	EX1 1BU	GB	0101000020E610000073664EA6F0450CC0ED0C28DB4D5C4940
85878	EX4 4AH	GB	0101000020E610000010C75FFF1A550CC040BBE8D08E5D4940
85879	WN1 2AD	GB	0101000020E6100000EA8A636E080F05C0D4E649E361C64A40
85880	EX35 6AG	GB	0101000020E61000002648B6042AAD0EC03F12407B3F9D4940
85881	EX2 8HN	GB	0101000020E6100000A0FD4811194E0CC079E78DE9425B4940
85882	EX4 4NU	GB	0101000020E610000043F28414F2570CC0D8FCAEBE705D4940
85883	EX5 4EJ	GB	0101000020E6100000E384AEE9E6F70BC09630896995624940
85884	NP4 0RH	GB	0101000020E6100000525A40E7BC2E08C03BC9EEB3DED84940
85885	NR23 1EX	GB	0101000020E6100000EBFD463B6E38EB3FBAEE528FD9794A40
85886	NR31 6DJ	GB	0101000020E61000001DC29DB069AAFB3F714DCB59E9484A40
85887	EX35 6HS	GB	0101000020E61000000BF148BC3CAD0EC030A017EE5C9D4940
85888	WA4 2EL	GB	0101000020E61000008F570425237C04C0AD8512931BB04A40
85889	WA3 5BB	GB	0101000020E61000004B901150E1A803C0270DDA50D6B64A40
85890	EX11 1AQ	GB	0101000020E61000007FAFD7AA13460AC05854C4E924604940
85891	NR11 8BG	GB	0101000020E61000003CD285FD43FFF63F78D6C97443704A40
85892	WA12 9SU	GB	0101000020E6100000D61DDCB451ED04C01CB5041150BA4A40
85893	LS9	GB	0101000020E6100000AB7B6473D53CF8BF0CB1FA230CE74A40
85894	DL16 7QX	GB	0101000020E61000005EF79DF9B136FABFBA3A8BD4775A4B40
85895	NG18 3HS	GB	0101000020E6100000B1581EFF609BF2BF6F7E688B10914A40
85896	WS14 0PJ	GB	0101000020E610000085378FB6368CFCBFE8185813C0504A40
85897	CM23 5QZ	GB	0101000020E61000002BB28CC34FD2C83FB3A899FFA1EF4940
85898	SW7 4JX	GB	0101000020E6100000021E62CD12AEC7BFB789496E03BF4940
85899	UB9 5BG	GB	0101000020E61000005C9F533F58AEDFBF4671456403C94940
85900	NE63 9AT	GB	0101000020E61000009FE50262D5E2F8BF85A374813C994B40
85901	NE31 2YA	GB	0101000020E610000012BF67C6D019F8BF2320D851927C4B40
85902	WD23 2EN	GB	0101000020E6100000BAED241D4332D8BF453A8A13A2D34940
85903	NE20 0AQ	GB	0101000020E61000006F17F5A4A743FCBF26AB22DC648B4B40
85904	WD3 1QN	GB	0101000020E6100000AA5BE26D4A9EDDBFB8184D7853D04940
85905	WA16 0HB	GB	0101000020E6100000FD659C2BEF4F03C099CEF34CD4A54A40
85906	EX7 0QN	GB	0101000020E6100000299C381499F40BC0C64FE3DEFC4A4940
85907	NE34 9PQ	GB	0101000020E6100000E4C578831E40F7BFEBDDC435E37C4B40
85908	PL25 3RB	GB	0101000020E610000082CEFF0648F712C0DC966D4CF42A4940
85909	EX34 8AY	GB	0101000020E610000078FEFEDEB78310C0A279A5D1899A4940
85910	EX34 0BX	GB	0101000020E6100000E7543200542110C0FDC28602119A4940
85911	HA4 0HG	GB	0101000020E6100000397AA125346ED9BF739B15F659C74940
85912	TN38 0BD	GB	0101000020E6100000D5313A6225BDE13F73579015E56C4940
85913	PR9 0NB	GB	0101000020E61000007A634DD4EEF907C03EE43A81C1D34A40
85914	TA24 6HE	GB	0101000020E6100000052049A4C8150BC0FC091D2A7C944940
85915	EX18 7JZ	GB	0101000020E61000009391B86961060FC0DD0B220BFE714940
85916	NR34 9HA	GB	0101000020E6100000D3D8035207FEF83FA248522D7D3A4A40
85917	ST18 9AR	GB	0101000020E61000007E9796B489E300C03721A5C05F624A40
85918	LL30 2EA	GB	0101000020E610000024EDEB6580B00EC09519259EA2A94A40
85919	CF1 9SW	GB	0101000020E610000085EB51B81E8509C01F85EB51B8BE4940
85920	NR8 6EF	GB	0101000020E61000000788388C3893F33FF56569A7E6564A40
85921	NR30 1EQ	GB	0101000020E61000000BB6114F76D3FB3FA0BA5E3F694E4A40
85922	KW10 6TT	GB	0101000020E610000044A51133FBDC0FC05977E2282FFC4C40
85923	WA14 1HY	GB	0101000020E610000023B6604E75CD02C05B1A097E65B24A40
85924	W1K 1BE	GB	0101000020E610000062C3081E355FC3BF58BDBC33ACC04940
85925	BD1 5LD	GB	0101000020E6100000BADA8AFD65F7FBBF304CA60A46E54A40
85926	BA2 4DN	GB	0101000020E610000072E8E390C3D602C0E20CB4F116B14940
85927	EX3 0QH	GB	0101000020E610000038D7D58970980BC0331070AD9B574940
85928	NP18 2YG	GB	0101000020E6100000B6F3FDD4786907C0E9B7AF03E7CC4940
85929	SN1 1TN	GB	0101000020E61000005DE3F1BC6D89FCBF01F03BC5EBC74940
85930	B2 5EP	GB	0101000020E6100000A71485A7A15FFEBF35212CB1523D4A40
85931	E1 6QL	GB	0101000020E61000008F79D3E3ADA9B2BF7288B83995C24940
85932	SA70 8DA	GB	0101000020E610000048403B962DE012C02E5D1CF054D64940
85933	LL54 7YF	GB	0101000020E61000001CEE23B7261511C095F25A09DD8D4A40
85934	LL30 2LP	GB	0101000020E61000006CA45B655CA70EC01A47F652C2A94A40
85935	SA69 9ER	GB	0101000020E6100000C51968E32DCC12C04EFFA380FEDA4940
85936	KY1 4SL	GB	0101000020E610000073B6251708B708C0049953B8D4114C40
85937	GL7 2DG	GB	0101000020E61000008C9D95592989FFBF1EB5D32016DC4940
85938	GL7 6BY	GB	0101000020E61000001B9D81FE33DCFFBF57B75EF9CAD64940
85939	GL7 1QX	GB	0101000020E61000006935C9343F83FFBF316D495865DB4940
85940	GL7 1EH	GB	0101000020E6100000F90269B57671FFBF5E262FD747DB4940
85941	CO6 4SA	GB	0101000020E61000007E12E9C8DB9BEC3F76C7BD54C7FE4940
85942	W1J 8LL	GB	0101000020E6100000F26CDD6DE170C2BF3B74FB5EE3C04940
85943	S40 1AY	GB	0101000020E61000007AADDFA705EAF6BF6C35351A0A9E4A40
85944	S42 6AE	GB	0101000020E61000009704D329C2FFF6BF2E9110871A964A40
85945	GL7 2DG	GB	0101000020E61000008C9D95592989FFBF1EB5D32016DC4940
85946	DN35 8QL	GB	0101000020E6100000ED6E70B2A5F896BF55E491F108C74A40
85947	DN35 0AE	GB	0101000020E6100000A3A6A7D94D3A93BF2878AFFFDFC64A40
85948	CO2 0HS	GB	0101000020E610000014E4BB2265BCEB3FAE59579A0EEE4940
85949	S40 1AY	GB	0101000020E61000007AADDFA705EAF6BF6C35351A0A9E4A40
85950	GL7 5RS	GB	0101000020E61000004723FA10AF66FEBF17C2209F46DB4940
85951	CH4 8JY	GB	0101000020E61000005EAE8F98EA4307C0DC9E20B1DD964A40
85952	CH2 2AX	GB	0101000020E6100000251C1FD2142607C07AA3FBDE4B994A40
85953	CH2 3NL	GB	0101000020E610000033E3C85E4AF806C097B3D2FFCD994A40
85954	CH3 9JS	GB	0101000020E61000000692C19B7F3506C01EB57867A3894A40
85955	CH4 8JQ	GB	0101000020E61000009F82B2DFC93D07C0D67F8C6FDE964A40
85956	CH1 1RS	GB	0101000020E6100000EAE923F0871F07C0B42FEAA408984A40
85957	CH1 3AE	GB	0101000020E6100000181F0B76680D07C091B75CFDD8984A40
85958	CH2 3NJ	GB	0101000020E610000000C3972E690107C0091E3A98A8994A40
85959	CH1 3NF	GB	0101000020E610000041D8840F801307C0FA4674CFBA984A40
85960	CH2 3NT	GB	0101000020E610000034958FEE31F206C09F6120BE029A4A40
85961	CH2 1LH	GB	0101000020E61000005A6842EE7D0507C0B47B4D6AC39C4A40
85962	BH15 1RZ	GB	0101000020E6100000A69CE367199DFFBF7717329BA35B4940
85963	GL50 3BG	GB	0101000020E610000030C676AD73B200C00E9F7422C1F24940
85964	GL50 1TX	GB	0101000020E6100000801D49939C9D00C06268757286F24940
85965	GL53 0LA	GB	0101000020E61000007E52A6FE65B200C0A0901E3807F14940
85966	GL52 6ST	GB	0101000020E61000009BA49EAAE77900C052E3EF28DFF24940
85967	CH2 2AJ	GB	0101000020E6100000C0DC3873592607C08D02E9071A9A4A40
85968	CH2 3HZ	GB	0101000020E610000069C537143EFB06C06B7418DD8B994A40
85969	CH2 3NJ	GB	0101000020E610000000C3972E690107C0091E3A98A8994A40
85970	GL52 6YL	GB	0101000020E6100000ECEA44381C5C00C0BEB6C887EAF04940
85971	CH1 3AE	GB	0101000020E6100000B3F2261AFF0907C0488ECFBFB8984A40
85972	GL52 2QH	GB	0101000020E61000001C51EB47D48500C095C67949ADF34940
85973	GL50 4JR	GB	0101000020E61000009C72784DB79400C0098C979CCAF34940
85974	GL50 3RN	GB	0101000020E6100000D2AF085971B500C0BA9404F236F34940
85975	GL50 3AY	GB	0101000020E61000001569150F85A900C07A6D94C7A3F24940
85976	GL52 6ST	GB	0101000020E6100000D141E8B7E77900C0A331C029DFF24940
85977	GL52 6TD	GB	0101000020E61000005C71169BFB7000C0553F259D37F34940
85978	LS9 0EE	GB	0101000020E6100000E8C1DD59BBADF7BF473CD9CD8CE64A40
85979	GL50 2QW	GB	0101000020E6100000533AFD4575AF00C0B3DC88DD2DF24940
85980	W3 7JT	GB	0101000020E610000061167F805AB1D0BF3CE3569CC5C04940
85981	GL52 6UU	GB	0101000020E610000011CE5D013B4D00C0531333B1AFF04940
85982	GL51 4XA	GB	0101000020E61000000F481D7810D600C06C32F499FDEF4940
85983	CB5 9ND	GB	0101000020E61000001FE135615BFCC83F39AB4ACAF9214A40
85984	GL54 5PQ	GB	0101000020E6100000711C78B5DC99FEBF27D87F9D9BFE4940
85985	GL54 5TZ	GB	0101000020E610000083A44FABE8CFFDBFAEB02A0CDBF54940
85986	W1H 7BY	GB	0101000020E6100000054D4BAC8C46C0BF84B872F6CEC04940
85987	EC3N 2NU	GB	0101000020E6100000BDDF68C70DBFB3BF327381CB63C14940
85988	CB6 2BD	GB	0101000020E6100000AA17289B05E9B83F3BC1F479A9324A40
85989	CB5 9HW	GB	0101000020E6100000B5B05D90E33DC83F6FA186CA1A224A40
85990	CB4 1ER	GB	0101000020E6100000FD4E93196F6BC03FC18A6F02751B4A40
85991	CB4 1SR	GB	0101000020E6100000FF2B8606BD92C23FFFE1F8EB5F1D4A40
85992	CB3 0DQ	GB	0101000020E6100000EA8A42601F7CBA3FBC3FC70FA11B4A40
85993	CB4 1XA	GB	0101000020E61000009B447353B93FC03F4F1B7A30CE1B4A40
85994	CB3 8PB	GB	0101000020E6100000DB7A92E36ABEBCBF4F0B93E6651E4A40
85995	CB1 7BX	GB	0101000020E6100000E0B1E9526D81C23F8A5759DB14184A40
85996	CB4 1DA	GB	0101000020E610000091966F229FFCC03FF836FDD98F1B4A40
85997	CB4 1DE	GB	0101000020E61000001038B7AE3D58C13F3EA76ACC351B4A40
85998	CB2 2PB	GB	0101000020E61000004E9253E00962C13F1CBDD0121A184A40
85999	CB2 2RJ	GB	0101000020E610000031FEC753A060C13FEA6D7DA2FC174A40
86000	IV2 4AG	GB	0101000020E6100000A21DEE25B8E510C0C0D635F26ABC4C40
86001	EC3N 2HS	GB	0101000020E6100000164CFC51D499B3BFFDF675E09CC14940
86002	BD9 4DR	GB	0101000020E6100000A20D1BC0B679FCBFBD63C27982E84A40
86003	PE2 6HE	GB	0101000020E61000005B94F575C2C6D4BF4F7A14EB2A464A40
86004	BD10 0PQ	GB	0101000020E610000042A154B1E741FBBFD51AEF33D3EB4A40
86005	BH1 2NW	GB	0101000020E6100000710168942EDDFDBF3B8C497F2F5C4940
86006	BH2 5HL	GB	0101000020E61000007242322E6635FEBF7B264575845B4940
86007	BH2 5BD	GB	0101000020E61000008BB0415CC20CFEBF77007F89DC5B4940
86008	BH1 2NN	GB	0101000020E6100000232015B5EAE9FDBFD9FB9EA2345C4940
86009	BH2 5LB	GB	0101000020E61000005F4EBFFA2E3BFEBFE5F7EC6FBF5B4940
86010	BH2 5HR	GB	0101000020E61000002669A3DF6335FEBFE93125EDA15B4940
86011	BH2 5EJ	GB	0101000020E6100000399D64ABCB29FEBFC8F19E5E845B4940
86012	BH1 3AL	GB	0101000020E6100000C18F6AD8EFE9FDBF92A4B5B3F95B4940
86013	BH2 5AX	GB	0101000020E610000045D4449F8F12FEBF5AAC9795DC5B4940
86014	BH1 3EE	GB	0101000020E6100000245A97BFE7CCFDBFC15DAC5E345C4940
86015	BH2 5HR	GB	0101000020E61000002669A3DF6335FEBFE93125EDA15B4940
86016	BH2 5JT	GB	0101000020E6100000AF27BA2EFC40FEBF0972AB7BBF5B4940
86017	BH2 5JL	GB	0101000020E6100000C39B35785F35FEBF30890EDCDC5B4940
86018	BH2 5PG	GB	0101000020E61000008DF6D3DA8F2FFEBF7A1A3048FA5B4940
86019	BH1 1RS	GB	0101000020E61000005CCB64389EEFFDBF1F69705B5B5D4940
86020	BH2 5HW	GB	0101000020E61000002669A3DF6335FEBFE93125EDA15B4940
86021	BH1 2BT	GB	0101000020E61000009CA4F9635AFBFDBF77C54263DC5B4940
86022	BH1 3PF	GB	0101000020E6100000567CE82741A4FDBF1D33F55F8C5C4940
86023	BH1 3DE	GB	0101000020E6100000BA1281EA1FE4FDBFB3B6291E175C4940
86024	BH1 3ET	GB	0101000020E610000030116F9D7FBBFDBF1B33E433345C4940
86025	BH1 2NP	GB	0101000020E61000002772778CE1E0FDBF6A728CBF485C4940
86026	BH1 3AR	GB	0101000020E61000006C7308C14FC1FDBF8FE046CA165C4940
86027	BH4 8JA	GB	0101000020E610000098F6CDFDD563FEBF3D98B9652C5B4940
86028	BH5 1AE	GB	0101000020E6100000672D605D7081FDBF9521D8028C5C4940
86029	BH6 3NL	GB	0101000020E6100000AD6E505667F0FCBFE966DA594F5C4940
86030	BH2 5HL	GB	0101000020E61000007242322E6635FEBF7B264575845B4940
86031	FY4 1NG	GB	0101000020E610000043F5204E717608C03A1B97169AE44A40
86032	FY2 9JN	GB	0101000020E6100000463C7E141A6D08C012B23DC450EC4A40
86033	BH1 3PT	GB	0101000020E61000002E14FAAAA6B5FDBFC7287403AA5C4940
86034	BH1 3AP	GB	0101000020E610000025C7F1D14FC1FDBF5DE312CB165C4940
86035	CF10 1EZ	GB	0101000020E61000002DAF5C6F9B6909C05EBA490C02BD4940
86036	FY4 1NJ	GB	0101000020E61000005BCF108E597608C0EDBEBE315FE44A40
86037	FY4 1NQ	GB	0101000020E610000043F5204E717608C03A1B97169AE44A40
86038	FY2 9QQ	GB	0101000020E610000068D94933CC6F08C02FEA494F47EB4A40
86039	FY1 4DE	GB	0101000020E61000006346787B106208C0033E3F8C10E84A40
86040	FY4 1RN	GB	0101000020E6100000F6BA7F0B367608C07F7A3BDB06E44A40
86041	WC1N 1DB	GB	0101000020E610000076711B0DE02DC0BF508D976E12C34940
86042	FY1 2EY	GB	0101000020E61000006D348DE1427208C0089FED9EAAE94A40
86043	BB2 4JP	GB	0101000020E61000000EE896676FEA03C03A1966B2C9DC4A40
86044	FY2 9TQ	GB	0101000020E6100000E14790A56A6608C0CCB4FD2B2BEB4A40
86045	FY2 9RP	GB	0101000020E610000068BC6367C06F08C03E5C72DC29EB4A40
86046	FY1 1SA	GB	0101000020E610000037F5262B2B7208C0083FCCB96FE94A40
86047	B26 3QR	GB	0101000020E61000006A8505D13CF3FBBF40408C4A09394A40
86048	NR12 7BG	GB	0101000020E610000009B83187EE63F53FC792832392584A40
86049	B26 3PG	GB	0101000020E6100000B157B329B271FCBF20990E9D9E394A40
86050	SW5 0EN	GB	0101000020E6100000E02F664B5645C8BF9EAE939FF9BE4940
86051	B17 8NJ	GB	0101000020E61000005409055BDB4AFFBF0C1C7519A33C4A40
86052	B3 3HG	GB	0101000020E610000064E0CA23C97DFEBFD0A2D2E3523D4A40
86053	B17 8BL	GB	0101000020E61000001CDF28C30269FFBFE50412B9853C4A40
86054	B47 6DJ	GB	0101000020E6100000EF9ABD57A042FEBF1D15793EB52E4A40
86055	B17 8DL	GB	0101000020E61000005C374A03E450FFBF450D4BA8853C4A40
86056	B30 1LA	GB	0101000020E61000004BF1A77CBEFCFEBF25A0788489364A40
86057	B68 0BS	GB	0101000020E61000003D2122D2C2FFFFBF706EF0DE413B4A40
86058	CV3 6PB	GB	0101000020E6100000FD87F4DBD781F8BF45D8F0F44A314A40
86059	B37 7HT	GB	0101000020E610000095ADEE8B5DB0FBBFB872D007063C4A40
86060	B5 7UB	GB	0101000020E6100000EDA584BB0E90FEBFB6A39300903A4A40
86061	B31 2DW	GB	0101000020E61000007377E79A1345FFBF54D9C1D20A354A40
86062	B92 7QT	GB	0101000020E6100000196A5E1FE7A7FCBF9C8DF051DA394A40
86063	B17 8DR	GB	0101000020E6100000B0A3BB35FA62FFBF41D3122BA33C4A40
86064	B5 7SL	GB	0101000020E6100000841FE6DC37A8FEBF7FF8F9EFC1394A40
86065	B24 8BJ	GB	0101000020E61000005437177FDB73FDBF78A8B75043424A40
86066	B24 0BY	GB	0101000020E61000002C2C92584D3DFDBF760438091A444A40
86067	B27 6QB	GB	0101000020E6100000D6EE0D74A33EFDBFA222F36D66394A40
86068	B91 3RF	GB	0101000020E610000010E18D3C786CFCBF227652D1AB344A40
86069	B20 2PL	GB	0101000020E61000003229F4B006DEFEBFE2804C2146424A40
86070	B29 7LR	GB	0101000020E6100000F0B3224E4DA8FEBFC9ABB06F60384A40
86071	B16 9RP	GB	0101000020E610000059839C9C46FFFEBF79A97DDF643C4A40
86072	B24 8QT	GB	0101000020E61000001DE560360186FDBFB7692222EB414A40
86073	TD15 2SQ	GB	0101000020E610000023E9E45652D8FCBFD961A7B3EED54B40
86074	TD15 1EP	GB	0101000020E6100000A9EA2F05B50900C05826B2C524E24B40
86075	BT7 1RQ	GB	0101000020E6100000E01FA5C810BE17C09F18FE78544B4B40
86076	BT15 4EF	GB	0101000020E6100000B20E4757E9BE17C037B5222015514B40
86077	B27 6QG	GB	0101000020E6100000A3AEB5F7A94AFDBF01EABC7CA1394A40
86078	BT36 4TQ	GB	0101000020E6100000E12E562F1AE517C04AFFDCE1C0584B40
86079	BT38 7AF	GB	0101000020E6100000FE8EF2DDF73917C03D55CF937C5B4B40
86080	BT56 8LR	GB	0101000020E6100000CC0A45BA9FB31AC0A2A2A0CA1F994B40
86081	BT7 1HL	GB	0101000020E61000007CB5BF8D76B917C0FD6683C8F94A4B40
86082	CH7 6HB	GB	0101000020E610000052C8515D19A808C0301391D6A2984A40
86083	BT57 8RT	GB	0101000020E610000050B7FD3C572D1AC0F86C1D1CEC9B4B40
86084	BT56 8NF	GB	0101000020E61000004F6E803E366E1AC00458E4D70F9A4B40
86085	BT39 0AH	GB	0101000020E6100000953D53F9E85E18C0D861F140095A4B40
86086	ME14 2AE	GB	0101000020E6100000CDB2A34829FEE03F93444DF972A44940
86087	BT57 8QG	GB	0101000020E610000078E860A2E6181AC00BB20A40489A4B40
86088	MK45 3LA	GB	0101000020E6100000C1FAE4CD86A1DEBF5BBD7960B6074A40
86089	MK40 3PD	GB	0101000020E610000096F551FCCE65DDBFC8A29F5F4A114A40
86090	MK40 2UA	GB	0101000020E6100000FD25F3D94BE4DDBFBBBFD5952A124A40
86091	AB10 6PS	GB	0101000020E6100000725E526B50FA00C0E54B039A63914C40
86092	AB11 6HH	GB	0101000020E6100000CD25B094C0D100C04EFE38AB4F924C40
86093	PR7 5LP	GB	0101000020E610000089D2DEE00B9305C037894160E5D04A40
86094	SK9 3LG	GB	0101000020E6100000B90893AFF2BA01C09AF3E27D42AD4A40
86095	BL9 6BJ	GB	0101000020E6100000CC666902A04502C0F36382D030CC4A40
86096	AB15 4PT	GB	0101000020E610000036E26EB5F32201C076B11F18F6914C40
86097	AB10 6NL	GB	0101000020E6100000664B7C0C5B1501C0D412A76AED904C40
86098	AB10 1XP	GB	0101000020E61000001428BDCA35F000C025F5543D4F924C40
86099	HD2 2BG	GB	0101000020E61000008B0CBCA47BC7FCBF75C35B8C26D44A40
86100	BL9 6UT	GB	0101000020E61000007ABCDA9B290E02C0383D39549DCE4A40
86101	B93 0EB	GB	0101000020E6100000EAF5DD639F76FBBF3BB13D69972F4A40
86102	HX7 5DQ	GB	0101000020E61000009F002FD8B2C1FFBFF5616298B8DD4A40
86103	LS29 9PA	GB	0101000020E610000091FAA188FB3EFDBF1DF8623953F64A40
86104	LS29 9HE	GB	0101000020E6100000AB425E6ADF57FDBF9FCA694FC9F64A40
86105	HD7 4AN	GB	0101000020E610000013A2D7FA7D9AFDBF961F5D11A1D14A40
86106	HD3 3AN	GB	0101000020E610000086AE073DE2F2FCBFA28FB0AA09D44A40
86107	AB11 6NF	GB	0101000020E610000051E1630B9CC700C0364DE9AA8A924C40
86108	LS23 6HT	GB	0101000020E6100000F9307BD9769AF5BFFAB1EEC451F24A40
86109	CV1 2LH	GB	0101000020E6100000F0D709D40737F8BFE12DEB596B334A40
86110	CV3 1FP	GB	0101000020E6100000D64FA4A080B2F7BF42075DC2A1334A40
86111	CV1 4BP	GB	0101000020E6100000C950BA997636F8BF266195C107354A40
86112	CV3 2AX	GB	0101000020E61000000285892536CEF6BFF874AAB972324A40
86113	HD2 2AG	GB	0101000020E6100000E719FB928DC7FCBF5E8DA2BDB0D34A40
86114	HX1 1TS	GB	0101000020E6100000B813364DE9CAFDBF57E311818FDC4A40
86115	SE1 7BJ	GB	0101000020E6100000476815472FB4BCBF88765FDF98BF4940
86116	B95 5DL	GB	0101000020E61000008F8D40BCAE1FFCBF1D33F55F8C244A40
86117	B93 8QE	GB	0101000020E6100000371147681567FCBFF69E2523C2304A40
86118	B95 5RA	GB	0101000020E6100000AD9A31169774FCBF76D4E29D8D274A40
86119	PO18 8HL	GB	0101000020E61000009B35D6D0966BEBBFEAC387CD586A4940
86120	PO19 1PD	GB	0101000020E61000007ECFFEF62BD3E8BF687FFB95296B4940
86121	BN18 9RJ	GB	0101000020E610000006369D537FB3E0BFACE46377816F4940
86122	LS29 8DG	GB	0101000020E6100000E564E256412CFDBF43E1B37570F64A40
86123	PO18 0HU	GB	0101000020E6100000270AD17A28ACE7BF2341C07352744940
86124	RH17 5EG	GB	0101000020E6100000C633DFF641ACC0BF41B36A5EB57F4940
86125	BN11 3QL	GB	0101000020E6100000C9117C1D8274D8BF49CCFD1F71674940
86126	B61 7JA	GB	0101000020E6100000AF2E16A21DA500C05D30A9BB61284A40
86127	RH11 0JH	GB	0101000020E6100000139164CDFD52CCBF705BB9E99F8E4940
86128	HD9 2QG	GB	0101000020E61000002345099F526AFDBF3470F6BD3CC64A40
86129	BD8 7AX	GB	0101000020E6100000DF20109EBF3FFCBF90B28F5F89E74A40
86130	PO20 0LX	GB	0101000020E6100000E06EA4C74A27E9BFD074C0BF525E4940
86131	PO18 9HX	GB	0101000020E6100000B86D29311958EABFF3AACE6A81764940
86132	GU29 0JB	GB	0101000020E6100000AA7D3A1E33D0E8BF9BAC510FD17A4940
86133	BN11 3QG	GB	0101000020E6100000EF5846CCE75AD8BFC70AD21A70674940
86134	DY9 0RW	GB	0101000020E6100000BDF3D59F0E1501C05EA8B2DE5E384A40
86135	BN17 5LQ	GB	0101000020E61000003E6754DE6350E1BFF81E8439E7664940
86136	WS1 2EL	GB	0101000020E6100000E25C1EC6FF98FFBFB47CB83F724A4A40
86137	LS29 8BT	GB	0101000020E610000096C86891ABC8FCBF821367CB0DF54A40
86138	BN11 2LX	GB	0101000020E610000030840E4DE8B4D6BF25FE0A9432684940
86139	BN5 9LJ	GB	0101000020E61000005DC136E2C96ED1BF696C544C4A724940
86140	BD22 8DU	GB	0101000020E6100000F00280BE8851FFBFE7CD3C1460EA4A40
86141	TN33 9PP	GB	0101000020E6100000EEC5617A0C20DD3F43C6A354C2774940
86142	BN14 0TA	GB	0101000020E6100000334352277A22DABF96C85E1FF86E4940
86143	B46 3BL	GB	0101000020E6100000A3BC45161F55FBBFD17D946CD03F4A40
86144	DY6 0EN	GB	0101000020E6100000EB8FA71AFA7501C0203DA37F12404A40
86145	BN27 4SE	GB	0101000020E6100000AEF776A62B33D73F786FFBD467704940
86146	TN40 1JL	GB	0101000020E610000051BB5F05F86EDE3FADB54137456B4940
86147	HP3 9RH	GB	0101000020E61000006A4E5E6402FEDDBF61D2CE1F89DE4940
86148	HD6 4HJ	GB	0101000020E61000009306126FF818FCBFB0F902C46ED94A40
86149	EN2 0QN	GB	0101000020E61000003C331C2A21B3B6BFBE1E02FD74D44940
86150	RH13 6PG	GB	0101000020E6100000EECEDA6D179AD1BFF6A6D887AB864940
86151	TN31 7UN	GB	0101000020E61000009E9F3DF2623CE73F8B4FA6762B7C4940
86152	TN5 7DQ	GB	0101000020E6100000382ADC97D821DB3FC80CAF7F32864940
86153	TN33 0SU	GB	0101000020E61000008010C99063EBDD3F31AC87D459734940
86154	BN20 0AB	GB	0101000020E610000014EB54F99E91C93FA27F828B155F4940
86155	TN31 7ES	GB	0101000020E610000039BF1715276DE73FC767B27F9E794940
86156	LS29 8RJ	GB	0101000020E61000001C846F50B100FDBF1B536639BFF54A40
86157	HX7 8AD	GB	0101000020E6100000B2666490BB1800C0FC19DEACC1DE4A40
86158	BN26 5UR	GB	0101000020E61000003263C0481E3EC43FFAFB7BDFAE674940
86159	TN31 7EY	GB	0101000020E610000039BF1715276DE73FC767B27F9E794940
86160	BN8 6LP	GB	0101000020E6100000A547F883262EB63FB44F11F1206C4940
86161	BN7 2ND	GB	0101000020E61000009CBDD82038D3893F06668522DD6F4940
86162	TN31 7DB	GB	0101000020E61000006845DEB61261E73F2620772882794940
86163	BN25 1RH	GB	0101000020E61000000FBFF6274C73BA3FA18735F0FE624940
86164	BN8 6PW	GB	0101000020E61000004E5FCFD72C97C13F6FC61FFB0F774940
86165	BN9 9QL	GB	0101000020E6100000B1F3DB7CC800A93FFE8815246C654940
86166	BN2 7HR	GB	0101000020E6100000763B5684F645ADBFE7429BD2B0664940
86167	BN27 1RN	GB	0101000020E6100000C7CBE4E5FA88D53F4130A248526F4940
86168	TN31 7JY	GB	0101000020E6100000889AB8BA3B79E73FC71F77D7BA794940
86169	TN31 7HA	GB	0101000020E6100000BFD8D6AAB86CE73FAF75531181794940
86170	TN33 0EA	GB	0101000020E6100000F9FDF6D0990FDF3FA094FF7F52754940
86171	BN3 3JP	GB	0101000020E6100000DF7D9FBB6E5BC5BF74EA6FAE066A4940
86172	BN27 4RU	GB	0101000020E6100000378AAC3594DAD53F9F42098E26714940
86173	DL8 3SR	GB	0101000020E6100000466348A9DFC0FFBFE5CEF17629254B40
86174	YO14 9LA	GB	0101000020E610000000338408DD4AD2BF93269474831A4B40
86175	HG4 5JQ	GB	0101000020E61000006258B4EF4073F9BFD8391790071A4B40
86176	YO7 1LH	GB	0101000020E6100000571A42DF2778F5BFE243E44FAF1D4B40
86177	BA2 7FZ	GB	0101000020E610000024C4255FBA8902C086004D7562AC4940
86178	DL7 8SL	GB	0101000020E61000000C080841A204F7BF8C987E2EBF2A4B40
86179	LS29 9JG	GB	0101000020E61000004D1C344C512CFDBF475936A8FAF54A40
86180	YO24 4AZ	GB	0101000020E6100000D043DAB774A3F1BFEA821DA60DFA4A40
86181	SN11 0EH	GB	0101000020E61000008CE8E802A80B00C0C2F2B2E9F2B74940
86182	BA15 2RA	GB	0101000020E61000000EA0B930CDF601C09C7108BF8EAD4940
86183	YO21 3JX	GB	0101000020E6100000C40776FC1708E4BF0DE4349FCE3E4B40
86184	BS8 4EW	GB	0101000020E6100000639BEC5061ED04C0D9F70EA228BA4940
86185	CB8 8DY	GB	0101000020E61000004F468837DA4DDA3F9EB945685D1F4A40
86186	HD7 4NH	GB	0101000020E6100000902DA510C3E4FDBF944C9A7B52D24A40
86187	YO24 4BB	GB	0101000020E6100000AC85FEAE74A3F1BF7CF0DAA50DFA4A40
86188	YO24 1DB	GB	0101000020E6100000814067D2A68AF1BF7D93A641D1F94A40
86189	YO30 7AG	GB	0101000020E61000005AB91798156AF1BF8AB4E8F8C3FB4A40
86190	BS39 4NS	GB	0101000020E610000067B3432CFD1004C0CE19569355AD4940
86191	YO24 1GE	GB	0101000020E6100000AD7A0ACA7E87F1BF0D7D66FFF2F94A40
86192	YO10 4HE	GB	0101000020E6100000F7E6374C3428F1BFCB15399F95F84A40
86193	YO23 3TL	GB	0101000020E6100000DF4CF15DEF43F2BFD8A5FC5A4DF34A40
86194	YO31 7EH	GB	0101000020E610000062DDD330D75DF1BFFFEA71DF6AFB4A40
86195	YO1 8AQ	GB	0101000020E61000008D6D08443E5EF1BF74A4E9A2D7FA4A40
86196	YO24 4DF	GB	0101000020E6100000D3FA5B02F0AFF1BF76D146640EFA4A40
86197	YO31 7TQ	GB	0101000020E6100000F8472932840DF1BF9F82B2DFC9FB4A40
86198	YO30 6LH	GB	0101000020E6100000B94F3349D18FF1BF3424383F0FFC4A40
86199	YO30 7DE	GB	0101000020E6100000ED3E11D5A570F1BFCC0BB08F4EFB4A40
86200	YO24 4BB	GB	0101000020E6100000AC85FEAE74A3F1BF7CF0DAA50DFA4A40
86201	YO1 9QD	GB	0101000020E610000020B75F3E5931F1BFDF18028063FA4A40
86202	YO24 4BB	GB	0101000020E6100000AC85FEAE74A3F1BF7CF0DAA50DFA4A40
86203	YO24 1HE	GB	0101000020E610000015EC4F7A90AAF1BF9010B019CAF84A40
86204	YO30 6LL	GB	0101000020E61000007CF2B0506B9AF1BFCA703C9F01FC4A40
86205	YO30 7DW	GB	0101000020E61000004E5656E4217DF1BF19EB76514FFB4A40
86206	YO41 4BX	GB	0101000020E61000008CF337A11081EDBF22E6ED6360F54A40
86207	YO30 6AQ	GB	0101000020E610000013CAA4817D76F1BFCEB88F2DE2FB4A40
86208	YO62 5XB	GB	0101000020E61000002CA0AB089292EFBF40F10813EB194B40
86209	YO10 3LF	GB	0101000020E6100000B42506DC4EB6F0BF957D5704FFF94A40
86210	YO30 7DH	GB	0101000020E610000002D369DD0675F1BF1A7CABBF6FFB4A40
86211	YO24 1DE	GB	0101000020E61000005186AA984A7FF1BF41BCAE5FB0F94A40
86212	YO24 1QG	GB	0101000020E6100000BB174E886FB7F1BF9600A19A37F84A40
86213	YO30 6BL	GB	0101000020E6100000752C8E817795F1BFC08F60663CFC4A40
86214	YO31 7PA	GB	0101000020E61000004B6AB290CA3EF1BFBF428B112EFB4A40
86215	YO10 4HG	GB	0101000020E61000000F9BC8CC052EF1BFE7C2482F6AF84A40
86216	YO10 4HN	GB	0101000020E6100000E7D0D84DDF21F1BFAD2C76A0F3F74A40
86217	YO24 1AS	GB	0101000020E61000003E67C17A928AF1BFD961A7B3EEF94A40
86218	YO10 5AU	GB	0101000020E6100000D37602507B20F1BF069D103AE8F94A40
86219	YO30 5RE	GB	0101000020E61000006EF13A2C1EA8F1BFEF5A9DF75AFC4A40
86220	YO10 4BE	GB	0101000020E6100000912E91668733F1BFA7107E9873F94A40
86221	YO30 7BH	GB	0101000020E610000065FD6662BA70F1BF703DAF1D31FB4A40
86222	YO23 2UL	GB	0101000020E6100000A76FE36080AEF1BFFB65E6B809F34A40
86223	YO24 4BB	GB	0101000020E6100000AC85FEAE74A3F1BF7CF0DAA50DFA4A40
86224	YO30 7DQ	GB	0101000020E6100000E232B8F7BA76F1BF8A37D7D589FB4A40
86225	YO31 7PF	GB	0101000020E6100000EC3A0AC67738F1BFAA413D224BFB4A40
86226	YO60 7DA	GB	0101000020E610000065CEE9680BFEECBFEC34D252790F4B40
86227	DL10 5HJ	GB	0101000020E6100000B4A61E0EB7A8FBBF6F6990DD60364B40
86228	YO30 6BQ	GB	0101000020E6100000F015DD7A4D8FF1BFF0FD68931EFC4A40
86229	YO30 7DG	GB	0101000020E6100000E232B8F7BA76F1BF8A37D7D589FB4A40
86230	YO42 2NX	GB	0101000020E6100000A9E1B611AAAFE8BF7A88EBBD9DF44A40
86231	YO23 1PF	GB	0101000020E6100000A1794A181778F1BF9C07663B95F94A40
86232	YO30 7DJ	GB	0101000020E61000002C22D456367DF1BF285D9FDE31FB4A40
86233	YO24 1ET	GB	0101000020E61000001A7FEC3F7CAAF1BF18F4948BE7F84A40
86234	YO7 4JG	GB	0101000020E61000007940344E9E8DF7BF90BC7328431F4B40
86235	DL10 5JU	GB	0101000020E610000059BE2EC37FDAFBBFD769A4A5F2394B40
86236	HG4 4AH	GB	0101000020E610000027D9EA724A40FABF46072461DF214B40
86237	BD23 5AQ	GB	0101000020E6100000AE13F29C88F9FFBF86B58C2F35094B40
86238	YO32 2RG	GB	0101000020E6100000FB8161AF66F3F1BFD9A72DBF1D054B40
86239	DL8 3PT	GB	0101000020E6100000C5403278F37F01C06B555C6622284B40
86240	YO61 3LF	GB	0101000020E61000002C3DE477E4F9F3BF201D684F13114B40
86241	BD23 5PS	GB	0101000020E61000005290E91A775400C01D4F159D760D4B40
86242	YO18 7DW	GB	0101000020E61000008E45894CAFC3E8BF6E026784121F4B40
86243	DL7 8AN	GB	0101000020E61000002BF697DD9307F7BF9C35785F952A4B40
86244	DL8 4NR	GB	0101000020E6100000C8C969F40FE7FCBF9501B1B673244B40
86245	YO62 5JG	GB	0101000020E61000008474C295FD24F0BF5CA32FCE291D4B40
86246	YO18 7AA	GB	0101000020E6100000B8239C16BCE8E8BF46ABA45F6C1F4B40
86247	DL8 5AS	GB	0101000020E6100000EDFE67830245FDBF95F48B6DAD274B40
86248	BD23 5AE	GB	0101000020E6100000AE13F29C88F9FFBF86B58C2F35094B40
86249	YO18 8PN	GB	0101000020E61000005F741EBA4585E9BF19B95D1E21234B40
86250	YO18 8AL	GB	0101000020E6100000116047D22427E9BFFC83EDCCA91F4B40
86251	BD24 9JD	GB	0101000020E61000007CE24A87983C02C0F7EAE3A1EF084B40
86252	YO12 6AF	GB	0101000020E610000040F5B468A6A0DABF3533E9A518254B40
86253	YO7 4LT	GB	0101000020E61000006A1899DB18F6F5BFE990E56E211D4B40
86254	MK17 9QB	GB	0101000020E6100000C17C68D59DDDE3BFF41373B5BAFE4940
86255	YO18 8RA	GB	0101000020E6100000B42D14FAAA66ECBFCEFA39AA3F2D4B40
86256	YO14 9JA	GB	0101000020E61000008AFB3493147DD2BF0F7052E2841A4B40
86257	DL10 4RG	GB	0101000020E61000008DEB843C27E2FBBF59B1AEC046334B40
86258	DL8 4DW	GB	0101000020E6100000BECA90195E1F00C078D90AF54F264B40
86259	YO61 4AH	GB	0101000020E610000044A7E7DD5870F3BFC367469AD31A4B40
86260	DL8 3HG	GB	0101000020E6100000827170E998A300C0F5AFF6C143284B40
86261	DL8 1NE	GB	0101000020E61000002C790282B5E1FABFED320BD3482A4B40
86262	YO17 6UE	GB	0101000020E610000027FB422333B2E8BF8FC360FE0A1B4B40
86263	YO17 7HD	GB	0101000020E61000008A7D5DE1B8E7E8BF4B13002DA7124B40
86264	DL7 8SG	GB	0101000020E61000000C080841A204F7BF8C987E2EBF2A4B40
86265	WV10 6TA	GB	0101000020E61000008196AE601B0101C098079F9C57514A40
86266	DL8 4LS	GB	0101000020E6100000A2748EA61F99FEBFC4DD6AE745254B40
86267	BD23 5QE	GB	0101000020E6100000E57162597ADE00C090F238B12C124B40
86268	HG4 4EF	GB	0101000020E61000007E141A2DAC80FABF22A3A8D83D1C4B40
86269	YO8 9JH	GB	0101000020E61000007870C16389B8F2BFCC7454DA87E24A40
86270	BD23 5AT	GB	0101000020E61000009BBAE12D46F3FFBFF1F5B52E35094B40
86271	BD24 9LY	GB	0101000020E6100000BB253960573302C0DA1544EE330A4B40
86272	YO31 7PB	GB	0101000020E61000005430CFEFA03EF1BF0C9F63F668FB4A40
86273	BS1 3AD	GB	0101000020E610000090A0F831E6AE04C07CF2B0506BBA4940
86274	BD24 9DU	GB	0101000020E6100000DA6443ED6D3902C0E8B2E26597084B40
86275	DL8 4DF	GB	0101000020E610000005A73E90BCD3FFBFAA1C4938E3264B40
86276	DE45 1DA	GB	0101000020E610000032B32A1D07D9FABF058651B5829B4A40
86277	DL7 9AY	GB	0101000020E61000001DFE3FF3DEFDF8BF78E860A2E6264B40
86278	S60 2TY	GB	0101000020E6100000491448F34193F5BF062F20D274B54A40
86279	S60 2AY	GB	0101000020E6100000D7FE29B05B9FF5BFF325AF29EBB54A40
86280	S60 2BP	GB	0101000020E6100000D447E00F3F9FF5BFFEC00B1126B64A40
86281	BT80 8JQ	GB	0101000020E6100000239D982D0D011BC0F8050D603E514B40
86282	DN6 8LF	GB	0101000020E61000009BF749FFDC61F3BFDECC430136CB4A40
86283	DN6 9JF	GB	0101000020E6100000F2C2E7983DBAF2BFAC7DF09018CC4A40
86284	DL3 7BQ	GB	0101000020E61000003EEDF0D7640DF9BF2AB39CDF8B434B40
86285	DL2 2SW	GB	0101000020E6100000D923D40CA902F9BFFAEE5696E83D4B40
86286	DL1 5JJ	GB	0101000020E6100000E765A0741AC8F8BF857EBA429E424B40
86287	DH1 5SA	GB	0101000020E6100000CB129D651621F9BF4D614AC917674B40
86288	DH1 2PD	GB	0101000020E610000047B4780CEAB6F8BF528E137019614B40
86289	BT51 4AD	GB	0101000020E6100000D064FF3C0D681AC00EF9C2BF63844B40
86290	S60 3EL	GB	0101000020E6100000243BA656AE5BF5BFDA2A5647ADB54A40
86291	DL12 9EB	GB	0101000020E61000005424BAC2161600C000378B170B4C4B40
86292	DH9 0LS	GB	0101000020E6100000153F219628F6FABF02E7D6B507714B40
86293	DH1 4PS	GB	0101000020E6100000734587925955F9BF50E3FF0A30634B40
86294	BT22 1PE	GB	0101000020E6100000500CDAF51C3216C076FA415DA4304B40
86295	BT80 8NG	GB	0101000020E61000008B225AE14CFA1AC0828DEBDFF5524B40
86296	BT80 8UP	GB	0101000020E6100000FF9BE43519FF1AC07D2672F64B4C4B40
86297	BT80 8QS	GB	0101000020E6100000391E525DD7051BC07D8CA58722514B40
86298	DL2 1PE	GB	0101000020E61000005BA505798725F8BF19688874893D4B40
86299	LE2 1RB	GB	0101000020E6100000A46BD5976DCBF1BF397B7E508B4F4A40
86300	OX28 6BH	GB	0101000020E610000098350C7ACAC5F7BF81785DBF60E44940
86301	CA27 0ES	GB	0101000020E6100000BF654E97C5D40CC03472CC689A3E4B40
86302	SN13 0PA	GB	0101000020E6100000764F1E166ACD01C0F64AB43FABB64940
86303	BA12 9AN	GB	0101000020E6100000D363004D297401C0E47DC1131F9A4940
86304	SN7 7RF	GB	0101000020E610000038DCA227C00BF9BF9BF97A63ADCC4940
86305	OX13 6RZ	GB	0101000020E610000070500CDAF51CF5BF1562E41BC0CF4940
86306	BA14 9BL	GB	0101000020E6100000F7065F984CD501C0A25F5B3FFDA94940
86307	GL13 9BG	GB	0101000020E61000005140248D1BA803C000F7E1C567D84940
86308	GL13 9BG	GB	0101000020E61000005140248D1BA803C000F7E1C567D84940
86309	GL56 9DS	GB	0101000020E61000002CEADD697CD0FBBF47BDF1FFF4024A40
86310	DN21 1HH	GB	0101000020E6100000EC95C338C9A0E8BFEC5C627660B34A40
86311	OX44 7UX	GB	0101000020E610000055EC7948424CF2BF3E03EACDA8D74940
86312	OX29 9XP	GB	0101000020E6100000D8E43AD7410FF8BFC35CF7FB6AE94940
86313	OX10 9JF	GB	0101000020E6100000E5E3DD08C05CF2BFCFD5DFDD0DC64940
86314	RG9 2LJ	GB	0101000020E61000000B9A7A03EAE2ECBF70B72E79DFC44940
86315	OX7 6XQ	GB	0101000020E610000012BF620D1759FABFEF97AA0F7FF34940
86316	RG9 6HE	GB	0101000020E6100000D7112CB3AD0BEEBFBE96A13BD2CB4940
86317	OX15 6AA	GB	0101000020E610000069C537143E1BF6BF022E235058064A40
86318	OX18 4BW	GB	0101000020E610000097F2107CC208FABF1D95F66118E84940
86319	OX16 5HS	GB	0101000020E610000057D2E5289B6DF5BFC9D3A8763C074A40
86320	OX7 6TH	GB	0101000020E61000000C16985F17CFF9BF67F6D44565F74940
86321	OX7 5QH	GB	0101000020E61000006FFA0ED99B33F8BF2DD736209DF84940
86322	OX28 5ES	GB	0101000020E61000000770C4A40905F8BF0A1346B3B2E44940
86323	OX18 2HA	GB	0101000020E6100000605F460C96C5F8BF76AD1809C8DC4940
86324	RG9 2LR	GB	0101000020E61000005CE84A04AABFECBF681888AFC0C44940
86325	BN25 1RJ	GB	0101000020E61000007F582547F075BA3F92150D631C634940
86326	CV1 2LH	GB	0101000020E6100000F0D709D40737F8BFE12DEB596B334A40
86327	LS22 6RU	GB	0101000020E6100000A1489CBA9740F6BFBF55E8CDF2F64A40
86328	SO41 6BA	GB	0101000020E6100000D813B8D0F0C1F9BFA9AB96CF4D644940
86329	SP5 2LN	GB	0101000020E61000003D47E4BB947AFBBF8D6555DF547D4940
86330	BH24 2EG	GB	0101000020E6100000E994EC7D4F51FDBF408A952C826B4940
86331	SO24 9AD	GB	0101000020E6100000593739D78B9CF2BFDE663BF07B8B4940
86332	SP6 3HY	GB	0101000020E610000058E1968FA444FDBF291F27F15E744940
86333	BH25 7QL	GB	0101000020E61000001FEE8F9CF1C2FABF711E4E603A5E4940
86334	OX7 6NJ	GB	0101000020E61000001F2A32DF6676F9BF3C725AA615F54940
86335	SN7 7HU	GB	0101000020E6100000BE930502535CF9BF5EB0654348D44940
86336	HP9 1ND	GB	0101000020E6100000CC4D8A45C26DE4BF6A28FFA4EBCC4940
86337	SL7 1BA	GB	0101000020E61000007B02171A3ED8E8BFBCE1E3B8F8C84940
86338	PE19 5XA	GB	0101000020E61000008BAB25789E53D0BFBD40A43A78254A40
86339	CB6 3JQ	GB	0101000020E61000002A6AD55350F6CB3F76D2B139BD2C4A40
86340	GL5 2AJ	GB	0101000020E6100000CF0FC8CAD4B901C06AE10DC40DDF4940
86341	GL7 5AN	GB	0101000020E6100000F7521D177AA9FCBFD87624A82BDF4940
86342	SL1 4UT	GB	0101000020E6100000C76E55C84BADE3BFBE2F2E5569C24940
86343	DL7 8EG	GB	0101000020E6100000A479B6FDE1FDF6BFFF34FFF9C72B4B40
86344	OX28 4AZ	GB	0101000020E610000039E0A936EEC3F7BFDFF4D3241DE44940
86345	ST14 8AG	GB	0101000020E61000000169FF03ACD5FDBFF3F22A210E734A40
86346	SK11 0HE	GB	0101000020E610000014BEADAA4DF200C06BB697D98C9E4A40
86347	RG4 6UP	GB	0101000020E6100000773D87E8C62AEDBFC73E12407BBC4940
86348	SL7 3NF	GB	0101000020E61000009F2A95A6F703E9BFED4F98E60CCB4940
86349	IV3 5NG	GB	0101000020E61000001C2883B20FEB10C08C0C33B3DDBC4C40
86350	HP22 5HL	GB	0101000020E6100000D6D5D3FD5235E7BF92F6F53240E64940
86351	HP9 1LZ	GB	0101000020E6100000D72F7D546885E4BF991C2DBDECCC4940
86352	SL2 3HL	GB	0101000020E6100000BC1D86FB6D74E3BFE48409A359C74940
86353	DL12 0QG	GB	0101000020E610000035E37ED12FAB00C0A7CB6262F34F4B40
86354	CV37 7LN	GB	0101000020E61000007440B73C7B33FBBF592437D439184A40
86355	CV37 7LW	GB	0101000020E6100000DBC765378E33FBBFB6FE4C73E1174A40
86356	CV37 7LN	GB	0101000020E6100000FCEBD0417B33FBBFA7CFA6D439184A40
86357	CV37 6PB	GB	0101000020E61000008791B98D6169FBBFBB67B85C58184A40
86358	CV37 6UY	GB	0101000020E61000007C18C4813C45FBBFA285D65343194A40
86359	CV37 6YW	GB	0101000020E6100000F1A29884573FFBBF678AAD5ECD184A40
86360	CV37 9TU	GB	0101000020E61000008DD0CFD4EBD6FCBF09C4EBFA05184A40
86361	SN6 6HD	GB	0101000020E61000001DDF837C751AFEBF949A875D25D14940
86362	ML1 3RB	GB	0101000020E6100000764F1E166A0D10C03108AC1C5AE44B40
86363	CV37 6UA	GB	0101000020E61000006A1FE16A534BFBBF67A5FF9BCD184A40
86364	CV35 7NL	GB	0101000020E61000008EB8D7B4188DFABFAEE13B94152B4A40
86365	CV37 9DP	GB	0101000020E6100000A5225F53319FFBBFB763EAAEEC184A40
86366	CV37 6HT	GB	0101000020E61000009588A6A26769FBBF77DB85E63A184A40
86367	CV37 6HT	GB	0101000020E61000009588A6A26769FBBF77DB85E63A184A40
86368	CV37 6HS	GB	0101000020E6100000A47F93B76D69FBBFC70E2A711D184A40
86369	CV37 9DR	GB	0101000020E610000068D0D03FC1A5FBBF18004FFFFE184A40
86370	CV37 9LQ	GB	0101000020E610000098593AD510ABFBBFAD46C03280194A40
86371	CV37 6PB	GB	0101000020E6100000C2237D9C6169FBBF3EB3BC5C58184A40
86372	CV37 9DB	GB	0101000020E6100000C3B414353D8DFBBF258227E3CE184A40
86373	CV37 6HS	GB	0101000020E6100000A47F93B76D69FBBFC70E2A711D184A40
86374	CV21 4EE	GB	0101000020E6100000E03C8B941C86F3BF904C874ECF2D4A40
86375	CV32 4PF	GB	0101000020E61000007DD0B359F579F8BF32C3EB9F4C254A40
86376	CV32 6DL	GB	0101000020E6100000429369D9FFC5F8BF96C338C9A0254A40
86377	CV21 3BA	GB	0101000020E610000013FFC1D19F27F4BFE256410C742F4A40
86378	CV35 7LS	GB	0101000020E61000006273C410EF6FFABF344C6DA983274A40
86379	CV34 5QJ	GB	0101000020E6100000F545E7A15B14F9BFA2F37574B7244A40
86380	CV35 0RJ	GB	0101000020E61000001C237E6A61BBF8BFB0C8AF1F620F4A40
86381	CV32 5BE	GB	0101000020E610000054E57B4622B4F8BF971705662A254A40
86382	CV32 6JF	GB	0101000020E6100000F37112EFA595F8BF89A768F68A264A40
86383	CV31 3PQ	GB	0101000020E610000072EEC04A4FA2F8BFBF1FC88B96244A40
86384	CV37 9XJ	GB	0101000020E61000002A65636F7334FCBF6EB83423281C4A40
86385	CV37 7LP	GB	0101000020E61000003C94F92B8A2DFBBFCB6D35CAFE174A40
86386	SR3 2QB	GB	0101000020E610000076A49F15BD58F6BF78D55E9F946E4B40
86387	CV34 4PH	GB	0101000020E610000048DA32857332F9BFEA6AE1687D244A40
86388	CV34 6HJ	GB	0101000020E610000005CA5CCFC680F9BF8B2CE3F093234A40
86389	CR9 2BN	GB	0101000020E61000004796276B2FFDB8BF31F378B537B04940
86390	RG9 6HF	GB	0101000020E61000009A339188DFC3EDBF9E9F3DF262CC4940
86391	CR0 1HD	GB	0101000020E61000007434FDC863BCB8BF2E2C6E92D5AE4940
86392	CR9 2BN	GB	0101000020E61000004796276B2FFDB8BF31F378B537B04940
86393	IP2 9AS	GB	0101000020E610000093196F2BBD36F23FD833DF1C09064A40
86394	IP1 2PY	GB	0101000020E6100000B80375CAA33BF23F6C0B2A0538084A40
86395	IP1 3AH	GB	0101000020E6100000B92F11B6727BF23F7B3648145C074A40
86396	SY1 1XL	GB	0101000020E6100000910F7A36ABFE05C0B4E386DF4D5A4A40
86397	SY4 5RS	GB	0101000020E610000086F8D1BA577705C0B06AB52C046F4A40
86398	SY3 8BH	GB	0101000020E6100000913E52E9CC5206C02056C9117C5B4A40
86399	TA20 2HW	GB	0101000020E61000002BFBAE08FE9707C04ED5986B2C6F4940
86400	SA71 4HN	GB	0101000020E61000009581035ABAA213C0E012807F4AD64940
86401	NN8 2DP	GB	0101000020E6100000B2FFF0A952E9E5BFE3EF28DF7D254A40
86402	OX2 7BT	GB	0101000020E61000008CFB99BEFA37F4BF30FF1E4528E34940
86403	OX5 1EB	GB	0101000020E6100000376A13949382F4BF8EF6334D3CE84940
86404	OX2 9NB	GB	0101000020E6100000DEF31F79B7DFF4BF7E1688F414E04940
86405	OX4 4AE	GB	0101000020E6100000428067D6ADC9F3BFB1DE1F2488DE4940
86406	OX1 4RA	GB	0101000020E610000003BA012FCB10F4BFE5388F41A9DE4940
86407	OX4 1SE	GB	0101000020E6100000BAA4C5747CCFF3BFFB41B85DC3DE4940
86408	OX4 4EY	GB	0101000020E61000001F83A35172B8F3BF42475C147EDD4940
86409	OX2 7PL	GB	0101000020E6100000706D5F42304FF4BFAE9CFA9632E44940
86410	OX1 4SU	GB	0101000020E610000042F7E214E816F4BFA1F9A62D51DE4940
86411	OX2 6JU	GB	0101000020E61000006EEEF4F25732F4BF9322DEAC94E24940
86412	OX4 1SE	GB	0101000020E6100000FCA3C88A7CCFF3BF49ED275EC3DE4940
86413	OX2 7PW	GB	0101000020E6100000ABCB29013149F4BFD7B331C04FE44940
86414	OX4 4AG	GB	0101000020E6100000F7BC0670BFC3F3BFF9C02BD587DE4940
86415	OX1 3SU	GB	0101000020E61000002F9402C1D20FF4BFC412C59A80E04940
86416	OX4 1SQ	GB	0101000020E61000007D6B71D75CCFF3BF3F3A5E49FEDE4940
86417	OX4 1SE	GB	0101000020E6100000FCA3C88A7CCFF3BF49ED275EC3DE4940
86418	OX4 4HT	GB	0101000020E61000009DBCC804FC9AF3BFB876A22424DD4940
86419	OX4 4AA	GB	0101000020E6100000AF6D9BF39DC9F3BFA51C8299A5DE4940
86420	OX2 0AA	GB	0101000020E610000097E5CA24135DF4BFF5794D8E49E04940
86421	OX2 9HA	GB	0101000020E6100000E13A366AD4DFF4BFA2191C09DADF4940
86422	L17 1AN	GB	0101000020E6100000AFE53A32FB7107C0165C621BA7B14A40
86423	L19 3PG	GB	0101000020E610000052B648DA8D5E07C013AD2699E6AE4A40
86424	L25 5PG	GB	0101000020E6100000651D8EAED2DD06C0567B7D5292B04A40
86425	L2 3SW	GB	0101000020E61000005CE8A5BD1CF107C0291D514601B44A40
86426	EH9 2BR	GB	0101000020E610000047713381C76C09C073CCC353D9F74B40
86427	WD25 8JH	GB	0101000020E61000007F710404CE6DD6BF6280F3CB28D44940
86428	PR8 1LL	GB	0101000020E6100000D581621A3C1208C009BE0E417AD24A40
86429	PR9 9EX	GB	0101000020E61000001C446B459BF307C0701C1DFC69D34A40
86430	PR9 0DP	GB	0101000020E61000000253BC804D0C08C0C66757C62BD34A40
86431	PR8 2BH	GB	0101000020E6100000BA032B3D891E08C01038B7AE3DD24A40
86432	PR9 9NG	GB	0101000020E610000068FA360E06D807C0C4E85ECC3BD44A40
86433	PR8 1LS	GB	0101000020E61000006EBF7CB2621808C0D75A4EF85BD24A40
86434	PR9 0EZ	GB	0101000020E6100000A6DD9ED6230308C08672A25D85D34A40
86435	L3 4DE	GB	0101000020E6100000EFF5FFBB4FDF07C04E0D349F73B24A40
86436	PR9 0HN	GB	0101000020E61000009BD9F85D22F807C057F1A19F04D44A40
86437	LN5 0QZ	GB	0101000020E61000007BC44373F87FE4BF0CEB217596874A40
86438	LN1 3AS	GB	0101000020E6100000589DE62ED340E1BFF36B35351A9E4A40
86439	DN15 6PY	GB	0101000020E61000000CC2813573EDE4BF4F50D4E308CB4A40
86440	LN5 8ER	GB	0101000020E61000006565451ED239E1BF290A4F43AF9B4A40
86441	LN5 8EN	GB	0101000020E6100000EE30DC6FA377E1BFFEEDB25F779B4A40
86442	LE11 2AQ	GB	0101000020E6100000AE17F9ABB631F3BFD200DE0209624A40
86443	ME20 6HJ	GB	0101000020E61000005B3AAC91D910DC3FDD6A4A7032A64940
86444	LN6 8RB	GB	0101000020E610000039E2D0284B97E2BFE709C8BADF984A40
86445	LN6 3SE	GB	0101000020E61000000EC1CCD2A9C6E3BFB0A316EF6C9A4A40
86446	LN2 5RT	GB	0101000020E61000005D2D1CAD0FD0E0BFA39D899FB59D4A40
86447	M33 3PJ	GB	0101000020E61000001CFF54C8D48602C0BCF1287422B44A40
86448	M20 3LJ	GB	0101000020E6100000B0993226B3E001C064647F8FB0B64A40
86449	LE6 0AF	GB	0101000020E6100000DFF30D96FBCEF3BF1994C4ED2B584A40
86450	LS9 0EQ	GB	0101000020E6100000C478CDAB3AABF7BF3C139A2496E64A40
86451	LE2 1RB	GB	0101000020E6100000A46BD5976DCBF1BF397B7E508B4F4A40
86452	LE11 3NW	GB	0101000020E610000094DE9277696EF3BF92A6F3410C624A40
86453	LE11 2AQ	GB	0101000020E6100000AE17F9ABB631F3BFD200DE0209624A40
86454	LE11 3TD	GB	0101000020E6100000E7A507AAEBD5F3BF1931FD5C7E614A40
86455	M14 5RE	GB	0101000020E61000003C0E2840B9C201C023F3C81F0CBA4A40
86456	M20 3ZA	GB	0101000020E610000084E02B99E7E901C0F730E6743AB64A40
86457	M6 8ES	GB	0101000020E61000006F568EDA0E9702C01DC9E53FA4BE4A40
86458	M13 0HY	GB	0101000020E6100000E066F16261C801C0B416B02EB8BA4A40
86459	M30 9HQ	GB	0101000020E610000046D3D9C9E0C802C02733DE567ABE4A40
86460	M32 0RS	GB	0101000020E6100000088B2F7F2A5302C0B68BC45FEEBA4A40
86461	M41 9LT	GB	0101000020E610000016FC917DEBBE02C09D86037C12B94A40
86462	M20 4GJ	GB	0101000020E61000004B7125A061D401C0DB364A66CEB64A40
86463	M14 6AB	GB	0101000020E610000092BC299B28C801C0DFA3A3C112B84A40
86464	M3 5JY	GB	0101000020E610000099897D5DE11802C06BCC90CFD0BD4A40
86465	M27 6WE	GB	0101000020E61000006DB589BE7BC602C0A7FE4E4EC5C34A40
86466	ME1 1BG	GB	0101000020E6100000C55CAD6E5056E03F9D9FE238F0B04940
86467	CM4 0EH	GB	0101000020E610000029668FE0DE46DA3F07C816D0EBD84940
86468	BB1 9EU	GB	0101000020E610000069D086B2A6F803C08DEF8B4B55E64A40
86469	M21 0UH	GB	0101000020E61000001D94F36FDE2A02C0CA453DC3A2B84A40
86470	M21 0AY	GB	0101000020E6100000F283289C333702C07D3A604FA2B84A40
86471	BL9 5NA	GB	0101000020E61000009EE4B3E1556B02C0216F5E413FD14A40
86472	PR2 3EB	GB	0101000020E610000089D0FEC33AAE05C01E7F675034E34A40
86473	M2 7DH	GB	0101000020E6100000A5BCBE25ECF601C053A83483B4BD4A40
86474	CT9 2EG	GB	0101000020E6100000692A7A96D655F63F3CC7365FDBB14940
86475	CT9 2JJ	GB	0101000020E61000008198DFC4EB75F63F6781768714B24940
86476	ME1 1PX	GB	0101000020E61000007B4CA4349B07E03F24A8D02F00B24940
86477	JE2 4GJ	GB	0101000020E61000005E3F0E9425E400C0A30799BF9D974840
86478	PR3 2TB	GB	0101000020E6100000F7D3DA8F6FCA04C06709D748B7EC4A40
86479	YO21 3HX	GB	0101000020E6100000A07E61438108E4BF323212EB9E3E4B40
86480	HR1 3JG	GB	0101000020E6100000932DDC03BEDC04C030A3B327DC114A40
86481	SG1 3LJ	GB	0101000020E610000043AED4B32094CABFE534FA87E3F34940
86482	HR1 1LE	GB	0101000020E61000000AED41AD0EB505C01ED48F977F094A40
86483	HR2 9QX	GB	0101000020E61000006195C107657006C0DD28B2D650064A40
86484	HR4 7AR	GB	0101000020E61000006F18BB33C93E06C07ABB6FC67A0A4A40
86485	BA11 1AF	GB	0101000020E6100000117B57F3D29302C078149D1B899D4940
86486	HP2 5BH	GB	0101000020E6100000CC248F4C2C15DEBF2A24F48EAEE04940
86487	HR1 4PE	GB	0101000020E61000002D6A320EEEED04C06ECB7389D2004A40
86488	HR1 3AH	GB	0101000020E6100000A66BDC5152A605C025F5543D4F0A4A40
86489	PO4 0NQ	GB	0101000020E61000003C58B55A1622F1BFA3E5E55542644940
86490	SO15 5DL	GB	0101000020E61000002D2FF12EB4B6F6BF4D2CE6A3A9744940
86491	SO15 5DQ	GB	0101000020E61000003352EFA99CB6F6BF9DB00E91E4744940
86492	SO31 7EB	GB	0101000020E610000064ACDB453DC9F4BFEDFE678302714940
86493	SO15 2JJ	GB	0101000020E6100000CC9651D1FD81F6BF2CADD05158754940
86494	SO16 7DH	GB	0101000020E6100000126C5CFFAEAFF6BF872BB17CA7774940
86495	GL19 3EF	GB	0101000020E61000008D30FB2B1A1103C0B3C414F6FEEE4940
86496	SO21 1DB	GB	0101000020E61000003691990B5CDEF3BF6840BD19358B4940
86497	GL16 8LG	GB	0101000020E61000001C13808403FF04C08FF9FFBF51E24940
86498	OX7 6UH	GB	0101000020E6100000B67581DC8F05FABFADA987C32DF44940
86499	GL1 3PG	GB	0101000020E610000005FA449E24DD01C047E9D2BF24EF4940
86500	PL12 6LJ	GB	0101000020E6100000F500B016ACDC10C0B56A303D7C354940
86501	PL21 0BQ	GB	0101000020E610000064B4E96399590FC066AB819CE6314940
86502	KA30 8PG	GB	0101000020E61000000FF6813F577E13C099BC5C1F31E74B40
86503	KA30 8QL	GB	0101000020E6100000EDBB22F8DF7A13C0DCE33BE75DE64B40
86504	KA30 8NF	GB	0101000020E6100000048E71B69A7A13C0BFE3CF48E8E54B40
86505	KA30 8DR	GB	0101000020E610000071FEAF05807813C0B3ABE9AA1BE54B40
86506	KA30 8EY	GB	0101000020E6100000465E8A36BD6F13C0FCFE191A19E44B40
86507	TQ2 6RH	GB	0101000020E6100000D2D56718885F0CC06EA1D057353A4940
86508	TQ2 6QJ	GB	0101000020E6100000F582918FC45C0CC0AB59FADF703A4940
86509	TQ2 5LL	GB	0101000020E6100000D56D9A88C85A0CC0C6DD205A2B3C4940
86510	PL1 2PP	GB	0101000020E610000062E81D16869610C0FB1CC473DB2E4940
86511	PL1 2PZ	GB	0101000020E6100000D76432C1159510C0C5909C4CDC2E4940
86512	PL1 2QD	GB	0101000020E610000070E4260FB09310C0DFB18E99FA2E4940
86513	PL8 2NW	GB	0101000020E6100000337F913F341B10C088904B00242C4940
86514	TQ4 6AT	GB	0101000020E610000030FBD060AE800CC0B11F18F66A374940
86515	TQ1 2EF	GB	0101000020E610000001D479F9421D0CC069368FC3603A4940
86516	TQ1 1QS	GB	0101000020E610000033B21A01CB200CC0658F5033A43B4940
86517	TQ1 2LQ	GB	0101000020E61000001C655820D51B0CC07C1F589FBC3A4940
86518	TQ2 5UQ	GB	0101000020E61000001D13735A014F0CC054B252F7B73B4940
86519	DE23 8JX	GB	0101000020E610000034886AA56B81F7BF4ACA822E86744A40
86520	TQ2 5TN	GB	0101000020E61000003710DC92663D0CC02720DC53283B4940
86521	PL4 6AH	GB	0101000020E6100000488B3386399110C0DC24ABC722304940
86522	SK2 7AB	GB	0101000020E61000002C012127862701C0C523561E1BB24A40
86523	SK4 2QN	GB	0101000020E61000000421B479775F01C031444E5FCFB54A40
86524	SK3 9NQ	GB	0101000020E610000015C9C49E576B01C003116DBD22B34A40
86525	SK7 3NX	GB	0101000020E6100000CEDDAE97A65801C002B27C02CDAF4A40
86526	SK8 6JZ	GB	0101000020E610000081334289E08901C03CA2427573AF4A40
86527	SK6 2AR	GB	0101000020E61000001FFF44E643F000C0A4F1508305B64A40
86528	TR18 4NW	GB	0101000020E610000043AD69DE712A16C00EF9C2BF630E4940
86529	TR18 4AE	GB	0101000020E610000033C51C041D2516C00282397AFC0E4940
86530	DE6 5GX	GB	0101000020E61000008D086B083332FCBF40A8E6CD3C6F4A40
86531	DE22 4LY	GB	0101000020E61000008FECAFF62E80F8BF65C01F9F8C774A40
86532	DE22 3AD	GB	0101000020E61000006BEB4C463AE8F7BFBF5BC5877E764A40
86533	CA1 2NS	GB	0101000020E6100000A799E14B505B07C032D7165CFB704B40
86534	HP14 3PF	GB	0101000020E6100000316DEE9EF21EECBF600A6A53D0D04940
86535	PE36 6HX	GB	0101000020E61000007EB750647336E03F96BB8A1DB1794A40
86536	MK19 6JY	GB	0101000020E6100000BD59DEB0C88AECBF0BB37515F7044A40
86537	PE1 5QT	GB	0101000020E61000006E855561D806CCBF1668774831494A40
86538	PE2 8AX	GB	0101000020E61000003DA6A43D14BBCEBF442F489FFB474A40
86539	PE2 9BP	GB	0101000020E610000086915ED4EE57CFBF3FEBD09FEC474A40
86540	PE8 6SH	GB	0101000020E6100000F2ABDE86BD75D9BFD65D34BFF5424A40
86541	HP12 3AR	GB	0101000020E61000000E187F36CDD6E8BF8BC058DFC0D14940
86542	M33 3QN	GB	0101000020E6100000BED7B562249002C0BB833353B5B44A40
86543	M33 5AN	GB	0101000020E61000002526F9285BB802C05B61B389F7B54A40
86544	RG1 6LL	GB	0101000020E6100000CC8580327C7AEFBF7DCAD69F69B94940
86545	RG1 8AZ	GB	0101000020E610000015A7FF51403FEFBF7BA933524ABB4940
86546	SL4 3AQ	GB	0101000020E6100000408A3A730F89E3BF600729D3C3BC4940
86547	SL4 5DB	GB	0101000020E6100000D6ECDC0FD3D9E3BF7B3EB95CB3BD4940
86548	SL4 3DA	GB	0101000020E61000006DE34F5436ACE3BF927E56F4E2BC4940
86549	NE26 2RG	GB	0101000020E6100000BFF3B692501CF7BF17FFBB6182854B40
86550	AB43 9DA	GB	0101000020E6100000B043EB973E0A00C0A395D63ACCD84C40
86551	LU3 1BT	GB	0101000020E61000008E7B4ED598EBDABF25CCB4FD2BF14940
86552	LU1 2NA	GB	0101000020E6100000F2272A1BD6D4DABFE4C17174F0F04940
86553	LU3 1LF	GB	0101000020E6100000D7C45D1844FFDABF5F28603B18F24940
86554	RG6 1EY	GB	0101000020E61000007F9CD5A7C1C9EDBFA47CF2C4B4B84940
86555	RG1 8AY	GB	0101000020E6100000E71241AE6A3FEFBF16E5E6DC2CBB4940
86556	RG31 6DL	GB	0101000020E6100000D402EBA06185F0BF903FA9DA94BB4940
86557	EH11 1NH	GB	0101000020E61000002458665B17C809C0E3F2695F8AF74B40
86558	GL53 7HN	GB	0101000020E61000006B5501ADAF9400C059294EFFA3F24940
86559	CM16 4DG	GB	0101000020E6100000FB592C45F295B83F31186D9F9FD84940
86560	TR26 2BN	GB	0101000020E61000003BE12538F5E915C0B64AB0389C1A4940
86561	PE27 5EX	GB	0101000020E6100000B8CD897A1728B5BFDE422EA31E284A40
86562	BB7 3EP	GB	0101000020E610000045AFBD51568C03C0A06B5015C2FB4A40
86563	GL6 0LX	GB	0101000020E6100000E35531F037C501C0BFC579EEF3D84940
86564	PE31 8BB	GB	0101000020E6100000131736B9CEB5E33F2F0ED363007B4A40
86565	PE30 1LR	GB	0101000020E610000015257C4A2943D93F3D1867C2E5604A40
86566	AB39 2PZ	GB	0101000020E61000004698A25C1AAF01C0CC892C88377C4C40
86567	DE13 9AA	GB	0101000020E6100000BC9B02F45658FABF709A99F4526C4A40
86568	ST7 2JL	GB	0101000020E6100000527AD988BDA602C03D108424668B4A40
86569	DT5 1HW	GB	0101000020E6100000C5A39E4F2E7703C005A96FF48C454940
86570	IP23 8JT	GB	0101000020E61000001C1FD214A694F03F629C645012274A40
86571	TF1 2LA	GB	0101000020E6100000E204A6D3BAED03C058AE1287C7574A40
86572	PR7 5LR	GB	0101000020E610000088C6C9B3818A05C0D608B3BFA2D04A40
86573	CM3 6RR	GB	0101000020E61000007CCF3E12D30EE53F65CFE2E8D1D54940
86574	CO15 1UU	GB	0101000020E6100000A7DC8EBAE78AF23F4C6B781FECE44940
86575	HR9 6HX	GB	0101000020E6100000E25F5F460CF604C0DB519CA38EEF4940
86576	HR3 5AG	GB	0101000020E610000069BF5A5AB2FF08C0E5B0A0D56E094A40
86577	SS0 8DS	GB	0101000020E6100000E31B0A9FAD03E63F2C00D75FC0C44940
86578	SS1 3BG	GB	0101000020E6100000EEFCEC9117E3E73F281312C4D4C34940
86579	HR3 5AD	GB	0101000020E6100000EB63F492B5FC08C0B5B63A4A6F094A40
86580	TA8 1BT	GB	0101000020E610000038AFFBD86EFC07C016D1C0D9F79D4940
86581	SS1 2YB	GB	0101000020E61000006277CB1F1DA8E73F3752B648DAC34940
86582	ST4 6SP	GB	0101000020E6100000B2632310AF9B01C04BF1A77CBE7D4A40
86583	CO15 1JN	GB	0101000020E6100000851733784E69F23F3CB203F8B8E44940
86584	SS0 8DX	GB	0101000020E6100000358584DED1F5E53F01FBE8D495C44940
86585	TQ7 4AR	GB	0101000020E6100000D074C0BF52170FC0EFEC86C844244940
86586	CM0 8AS	GB	0101000020E61000005760C8EA560FEA3F041665DB0ED04940
86587	LS9 0SE	GB	0101000020E6100000F2B6D26BB331F8BF6ADD06B5DFE44A40
86588	CO13 9EQ	GB	0101000020E6100000BC934F8F6DD9F33F186CD910D2E94940
86589	HR3 5DQ	GB	0101000020E6100000FDAB7DF0900809C0ABC5F18D32094A40
86590	LL26 0RE	GB	0101000020E6100000AA52697A3F340EC0D7C5C8EDF28B4A40
86591	CO15 1RA	GB	0101000020E6100000E655421C9069F23F5DC47762D6E44940
86592	SS1 3AA	GB	0101000020E61000004ED60341DBC5E73F4055E0BFD4C34940
86593	GL54 2AN	GB	0101000020E6100000BCA1DFADE223FCBFEE81B1193BF14940
86594	SS0 8BU	GB	0101000020E6100000750FE518841AE63FA37BBAE0EAC44940
86595	PL28 8JH	GB	0101000020E61000005CCE00721D0E14C060ED8387C4434940
86596	CO13 9EL	GB	0101000020E6100000CCCEB45AE6D8F33F1B17693D97E94940
86597	TS16 9BG	GB	0101000020E61000004904151B1491F5BFF86140D36B434B40
86598	SS1 1HG	GB	0101000020E6100000D0E2F2439877E63F54FF92E789C44940
86599	DE13 9RS	GB	0101000020E6100000976945E57077FBBF681B24E93F664A40
86600	GL54 2AF	GB	0101000020E61000001B01CB000618FCBF1842CEFBFFF04940
86601	LE65 2TA	GB	0101000020E610000031F63044E6E3F7BFF9D5AACA6F614A40
86602	OL6 7BD	GB	0101000020E61000001AA721AAF0D700C0D2109F854EBE4A40
86603	BA15 2LA	GB	0101000020E61000003A443756BD5702C02C54ED8964AC4940
86604	TD15 2AN	GB	0101000020E6100000EA4C90C7C21600C0E8ECAEFDAEE14B40
86605	CO13 9HQ	GB	0101000020E61000002424777D8BF3F33FB1AE658DD5EA4940
86606	ST3 7TW	GB	0101000020E61000001F285C3409C300C0F31E679AB07B4A40
86607	DD9 7TA	GB	0101000020E6100000B04797EDF94005C0520548D9C7674C40
86608	GL54 2BU	GB	0101000020E6100000CE7559CDEC23FCBF0657342E00F14940
86609	TS16 0DF	GB	0101000020E6100000614AC9175997F5BFCB9C2E8B89434B40
86610	EX34 8AY	GB	0101000020E61000009C00F8E4B78310C0547DEED1899A4940
86611	IV21 2BS	GB	0101000020E6100000EEBBD86AC5C516C02201FE840EDD4C40
86612	PO10 7PU	GB	0101000020E61000002E0494E1D337EEBFF891D75ACA6D4940
86613	CR0 1TS	GB	0101000020E610000074F04C689258BABF2FF99FFCDDAF4940
86614	W2 6QA	GB	0101000020E610000033FE7DC68503C7BF4B6EB99FF8C14940
86615	RG30 3UN	GB	0101000020E6100000295C8FC2F528F0BFF6285C8FC2B54940
86616	L34 9HA	GB	0101000020E61000000AD7A3703D0A07C07B14AE47E1BA4A40
86617	B43 7AG	GB	0101000020E6100000CE53011D0402FFBFD148E97156474A40
86618	M50 3XW	GB	0101000020E6100000C7293A92CBFF01C0053411363CBD4A40
86619	LE2 7FQ	GB	0101000020E6100000B309302C7F3EF2BFB2463D44A3514A40
86620	RG30 1EH	GB	0101000020E61000006571044BA321F0BFE2CCDA66DDBA4940
86621	BA2 6JF	GB	0101000020E6100000CDCCCCCCCCCC02C052B81E85EBB14940
86622	AL3 8HT	GB	0101000020E6100000EA043411363CDDBF3411363CBDEA4940
86623	SO23 9LQ	GB	0101000020E610000081EED50B6104F5BF6FD8E1A8CF874940
86624	SG19 1DH	GB	0101000020E6100000E71DA7E8482ED3BFA835CD3B4E114A40
86625	CM77 8DH	GB	0101000020E6100000A5CC17C5BC98E23FDF652BD43FEF4940
86626	YO30 5PA	GB	0101000020E610000012A5BDC11726F2BFBA6B09F9A0FF4A40
86627	SY13 1EN	GB	0101000020E61000005A31D8E45B7105C0190914818F7B4A40
86628	PR25 4QR	GB	0101000020E6100000731331FC127705C0506FB82240DA4A40
86629	SG5 1AF	GB	0101000020E610000025DFB6007ED7D1BFBF64E3C116F94940
86630	SL3 7RL	GB	0101000020E61000008AE3C0ABE54EE2BFA6553E1581C04940
86631	BT32 3LH	GB	0101000020E610000084B46BE7A01019C0E5773F13062C4B40
86632	PE25 2UB	GB	0101000020E610000039F9E3AC3E0DD63F4BF1A77CBE924A40
86633	FY8 1LS	GB	0101000020E61000004F4EFE38AB3F08C0598EEB3AAFDF4A40
86634	LL30 1BB	GB	0101000020E61000000FD62ABA28880EC0AC08253619A94A40
86635	PO12 2QT	GB	0101000020E61000002FD8CE76D395F2BF64B6105676644940
86636	LS9 6EL	GB	0101000020E6100000D7F9B7CB7E1DF8BF9D0DF96706E74A40
86637	BB4 6QE	GB	0101000020E610000004DC05E0258802C0A1425CD610D94A40
86638	LE17 6DH	GB	0101000020E6100000356502D94637F2BF4A1F5FE74B344A40
86639	RG20 5PP	GB	0101000020E610000061F82DDF9FF7F3BF5FF0694E5EA94940
86640	RG20 8DD	GB	0101000020E61000006807C9F3FA42F6BF59B78B7A52B84940
86641	RM2 5EL	GB	0101000020E61000009AE650988D94C93F368675ED0FCB4940
86642	LL32 8QD	GB	0101000020E6100000733BF9C958A60EC0960ABD0D50964A40
86643	PL27 6LA	GB	0101000020E6100000A6FB879469AB13C02248152DCF454940
86644	TF9 1PY	GB	0101000020E61000004217651A73DD03C004C65D31A1734A40
86645	ML1 3HU	GB	0101000020E6100000EF3B86C77EF60FC03C17467A51E54B40
86646	FK8 2QG	GB	0101000020E610000024F771BD38840FC0D9AF5CEBE20E4C40
86647	SO51 6AF	GB	0101000020E610000025FB36B0949EF8BF1218B82A73794940
86648	ST13 5NW	GB	0101000020E6100000DDCE5156F23600C02CBC26FF2E8D4A40
86649	PL17 7AS	GB	0101000020E6100000BE26DB28014311C0511AC5CD84404940
86650	PL7 5AX	GB	0101000020E610000059A15ADA2FE30FC05A6683DFD5304940
86651	S33 8WH	GB	0101000020E61000009606A9D41F6BFCBF75605798E0AB4A40
86652	DH3 3BJ	GB	0101000020E61000003CCBEC260A32F9BF99190D4B896D4B40
86653	DT11 8DB	GB	0101000020E6100000F4770DFF8B9100C03CD6A861E1754940
86654	GU1 2JH	GB	0101000020E6100000D5C9CDFBF5A6E1BFA7ED69CBDC9E4940
86655	TF8 7LH	GB	0101000020E610000042EFFF76E8BE03C046E3CA85BC4F4A40
86656	BS34 6ND	GB	0101000020E61000006B024CE6468B04C07C4A0835C7C44940
86657	CT16 3DJ	GB	0101000020E6100000263902E6911FF43FA6DED972FC934940
86658	SK9 2BT	GB	0101000020E6100000F3852156A58F01C0512E586D28AA4A40
86659	SL3 9AE	GB	0101000020E61000009A6645CAD2BBE2BFBE3A6EC824BF4940
86660	TA6 3PN	GB	0101000020E61000002F069F7E011508C09ABBCB825F904940
86661	GU22 7RT	GB	0101000020E6100000E67DEE94A6F2E1BF2EA4595FF8A74940
86662	IP33 1HP	GB	0101000020E6100000B4C05104CEE8E63F22F5D674C81F4A40
86663	PR7 1LB	GB	0101000020E610000035F267E2971E05C0B90BFFAF9BD34A40
86664	TN15 7RF	GB	0101000020E610000071EAE7730CEDD33FADF18AC172A74940
86665	DN21 3UD	GB	0101000020E610000014224DADD84EE5BF1BA7EEB88BBF4A40
86666	BT28 3SU	GB	0101000020E6100000E57C81BECC6C18C0205657BC134A4B40
86667	CM13 3SL	GB	0101000020E6100000AA2DD0494AF5D83F024E8CB802CA4940
86668	BB7 2EU	GB	0101000020E61000001A7E14CE9E2603C0953D3C5DB3EF4A40
86669	CA14 4BX	GB	0101000020E6100000BA0D0F0643520CC0B1DB0CDC26524B40
86670	DE45 1JE	GB	0101000020E610000006685BCD3A23FBBF881057CEDE984A40
86671	GU10 3DJ	GB	0101000020E61000009E2633DE563AE9BFCDB7F41E1D964940
86672	SN6 7AD	GB	0101000020E610000022E2E6543260FBBF074C9649C3D04940
86673	PH2 0PY	GB	0101000020E61000008A0D55B2153C0CC0296E47FEC12D4C40
86674	CV8 1NG	GB	0101000020E61000006D033A3D366CF9BFE5474DD2342C4A40
86675	FY6 8LT	GB	0101000020E61000004BDF5CDD609907C0FBE7FC2332EC4A40
86676	GL2 7BP	GB	0101000020E6100000995748D5832903C0F04CF63C30DE4940
86677	DE5 3RA	GB	0101000020E61000009D2EDCD0CC97F6BF9E9FF61C97874A40
86678	KT24 5LU	GB	0101000020E6100000C2621E43119CD9BF3EF5FEF5C0A24940
86679	OX9 3ER	GB	0101000020E610000073A900CE4146EFBFA1CF91A68BDF4940
86680	SG17 5JF	GB	0101000020E610000024C09FD0A142D4BF618841052C034A40
86681	CT10 3LG	GB	0101000020E61000002F2416E75EF6F63FF15C29159EB14940
86682	PE15 9LH	GB	0101000020E6100000ABD9B91FA633B63FE62E7887CA454A40
86683	CB11 4QT	GB	0101000020E61000006F8A7DB89A2BC43F5AF5B9DA8AFC4940
86684	GL6 6UN	GB	0101000020E61000008E2BE400B09001C09CD9531795E44940
86685	GU11 3DG	GB	0101000020E61000009F4F2ED7EC92E8BF1EBA4505F39E4940
86686	IP24 1AD	GB	0101000020E6100000EB6F09C03FE5E73F0A80F10C1A354A40
86687	BA13 3DQ	GB	0101000020E61000007A0FE1A9917701C0D50D6F319AA14940
86688	TR27 4HQ	GB	0101000020E6100000CDB1BCAB1EB015C0CAE8DBDD5E174940
86689	ST14 8EU	GB	0101000020E6100000FA473A5EDCE1FDBF089854C8F0724A40
86690	CM8 2AF	GB	0101000020E6100000B8C5A1235E83E43F0D52F01472E64940
86691	TR7 2QF	GB	0101000020E6100000A154B1E7214914C0A016838769354940
86692	LU6 1QZ	GB	0101000020E6100000CB411A5FC573E2BF4602B27C02EF4940
86693	SY1 1HU	GB	0101000020E610000047A8BE98D20F06C0626534F2795A4A40
86694	TQ7 4BG	GB	0101000020E610000035666DAEF5300FC0DEE11BAFE5234940
86695	BR1 3RX	GB	0101000020E6100000CEB348C961E6813FE5FB98C57AB44940
86696	L40 5TH	GB	0101000020E6100000DC4D4B07469906C014D2753CC1CB4A40
86697	DE7 5GF	GB	0101000020E610000007AFE1121504F5BFB996591C3F7C4A40
86698	PE11 1SU	GB	0101000020E61000006A9AC129BD80C3BFBFE3CA8FAE644A40
86699	GU1 2BX	GB	0101000020E61000006806F1811DBFE1BF0F56AD96859E4940
86700	RM12 6SB	GB	0101000020E610000077D43D5700F8CB3F6D7AAB09FDC64940
86701	TQ2 5HP	GB	0101000020E610000024D6E253004C0CC0AE0A79A97D3B4940
86702	IP19 8AH	GB	0101000020E61000002659E25C1E06F83FFCC401F4FB2B4A40
86703	SA31 1LQ	GB	0101000020E61000004C7ED5DBB03711C0F4C87AC5AEED4940
86704	B49 6NQ	GB	0101000020E6100000C7287403AAC4FCBF2778F98CFA194A40
86705	DG7 1HX	GB	0101000020E6100000F54718062C690FC0426CFAFDAC784B40
86706	TF9 3PU	GB	0101000020E610000009580630C05904C0E930BA17F3704A40
86707	OX17 2SD	GB	0101000020E6100000D9017C5CC0F0F2BF2B291CE6700D4A40
86708	BA22 7QW	GB	0101000020E61000007A5EE0A8CBD804C00E3F49CB92824940
86709	TA6 3DB	GB	0101000020E61000002984C42C6A0608C08F615FFC7E904940
86710	IP12 1EX	GB	0101000020E610000051F0B9B8320DF53F7017AB178D0C4A40
86711	AB41 9NQ	GB	0101000020E61000007E073700B89500C06860149F23AE4C40
86712	HP4 1AH	GB	0101000020E61000004D6D043D2F30E2BF3B1DC87A6AE14940
86713	CF38 2LT	GB	0101000020E6100000571DDE18A7A60AC0D594641D8EC74940
86714	SL7 1RP	GB	0101000020E61000004A647A1DCCC1E8BFF3D198FF46C84940
86715	DG9 8TD	GB	0101000020E61000000CF1DD20397714C09D1432CC136C4B40
86716	RG27 8NW	GB	0101000020E6100000EA0F83AF9EC9ECBF224AC5104AA74940
86717	AL3 4SB	GB	0101000020E61000003985F0C39C7BD6BF39E686F079E04940
86718	RG18 9DS	GB	0101000020E6100000F12A6B9BE2B1F4BF58E6ADBA0EB94940
86719	TS14 8HG	GB	0101000020E6100000611A868F88C9F1BFD29AD5F14E424B40
86720	CM24 8EY	GB	0101000020E6100000D1764CDD955DC83FCD1BCCCB06F34940
86721	OX14 3EG	GB	0101000020E6100000E4501AC5CD64F3BF7B1D273BECD34940
86722	BS21 7PU	GB	0101000020E61000006880C1244BDC06C0BE068E1546B94940
86723	FK10 2HS	GB	0101000020E610000024CA83995B7A0EC0C8C649822C104C40
86724	CB11 4TD	GB	0101000020E61000005AC7A7B68AB4CA3F7D9983FB5C044A40
86725	CM22 7BQ	GB	0101000020E6100000AB3C26F7E05ACB3FA5E48BACEBE74940
86726	GU7 3BX	GB	0101000020E6100000A28ED838ACFAE2BFDE054A0A2C994940
86727	CM16 4AP	GB	0101000020E61000007EB89A2B39DDBC3FC84851C2A7D94940
86728	BT20 5EY	GB	0101000020E61000004BCB48BDA7AA16C06D640DCD2B554B40
86729	B60 4JR	GB	0101000020E61000001E3F0A8D169600C0754D92F826284A40
86730	PE19 7GG	GB	0101000020E6100000B2310ADD802AD2BFC823B891B21D4A40
86731	SO51 0LP	GB	0101000020E610000028FEDE5CB2A0F8BFA66A16C330854940
86732	TD15 1SZ	GB	0101000020E6100000F821CA726DB300C0658BA4DDE8E14B40
86733	PL28 8RP	GB	0101000020E61000009A0C22AD8CC913C0CA5EA5715E454940
86734	SP1 1JH	GB	0101000020E61000000E8E48CACCBBFCBFF99C60A4BC884940
86735	BA5 2PD	GB	0101000020E610000030911CFA382405C0131FE91DB89A4940
86736	SK11 9JY	GB	0101000020E61000003FE0264811EE01C03BB71A2323A04A40
86737	CM77 8PD	GB	0101000020E610000060394206F26CE33F2B12B81A7EEB4940
86738	PE28 0EA	GB	0101000020E610000009E23C9CC0F4D8BF3D2E05FFB6254A40
86739	PE8 6ND	GB	0101000020E6100000EEBB7DB1529CD8BFC73C3C951D484A40
86740	ME14 1BH	GB	0101000020E610000020D1923470E1E03F8258F456F6A24940
86741	BA22 8LD	GB	0101000020E610000059EAE9BB0C7305C0B9CB09D072804940
86742	RH6 8QG	GB	0101000020E6100000698F8927CA04C5BF1F8BA7FD9A974940
86743	BA4 5QF	GB	0101000020E610000070C916EE013F04C0C73DA76ACC974940
86744	SS4 1PJ	GB	0101000020E6100000EB15BB229D66E53FAC6E9AE381CA4940
86745	SK11 6UT	GB	0101000020E6100000F9043F60D40401C09F724C16F7A04A40
86746	PL26 6QH	GB	0101000020E61000004425BF8FB42513C0E54691B586224940
86747	TR11 4BJ	GB	0101000020E610000029988CBEDD3D14C0DA52ACBFCA124940
86748	GL54 1HY	GB	0101000020E610000094EF6316EB65FBBFE98CDE5FF3F24940
86749	W5 2JL	GB	0101000020E6100000C0C2FB0ACFF4D2BF629C1D7B06C34940
86750	SY11 4DF	GB	0101000020E6100000364BB846BA0508C04FB6DCF4C26F4A40
86751	PL20 7RA	GB	0101000020E61000008DD9ED0E846710C00D0BFF3394404940
86752	NR16 1QU	GB	0101000020E610000021B0726891EDF13FB52D6FB31D404A40
86753	IV27 4HN	GB	0101000020E610000058A8DA13C9E413C05148D7F104134D40
86754	EX23 8RF	GB	0101000020E61000000FB4A789E32D12C03810374CD96A4940
86755	HP1 1JH	GB	0101000020E6100000D60341DBC58FDEBFA7ADB607C6DF4940
86756	CM2 0AJ	GB	0101000020E6100000255B5D4E0988DD3F9B221BA3D0DC4940
86757	CA13 0EJ	GB	0101000020E610000039B148926EF30AC06717D9BCD4544B40
86758	PH23 3AT	GB	0101000020E61000007EF02DEE37810EC03D18D9174EA44C40
86759	DG7 3BB	GB	0101000020E610000048AC6CEFB8CC0FC0FA7E9AF54A7D4B40
86760	SA10 6JQ	GB	0101000020E6100000AD11667F45D30EC0B65FE39FBED24940
86761	SN14 6UZ	GB	0101000020E6100000CC1363F4370C01C00B4C5DE800BD4940
86762	EH1 1TH	GB	0101000020E6100000005F2865F47D09C04582D4E672F94B40
86763	IG8 8AE	GB	0101000020E6100000C839C36AB29AAD3F438EF43C94CD4940
86764	W14 9NS	GB	0101000020E6100000B744BCE29A1CCABF0DE0DC4821BE4940
86765	NE28 9HP	GB	0101000020E610000038BBFC211292F8BF9952D6F026804B40
86766	M18 7LJ	GB	0101000020E6100000336B4A2ED64601C0D9DA6080BBBA4A40
86767	S10 2PY	GB	0101000020E61000003584566C3BF1F7BFEEC4F1EB23B04A40
86768	TA6 6TS	GB	0101000020E6100000AF997CB3CDED07C08EB1135E828D4940
86769	WA4 2LD	GB	0101000020E610000050027A65077604C08690D2F056B04A40
86770	IP6 0AR	GB	0101000020E6100000674B6570E5C3F13F807993A27F0D4A40
86771	B4 6HY	GB	0101000020E6100000666666666666FEBF3D0AD7A3703D4A40
86772	CT20 2EB	GB	0101000020E6100000F959258B0DBBF23F75799E38B3894940
86773	TW5 9QE	GB	0101000020E61000000E1683C4CC57DABF8F9E71CD5CBD4940
86774	TS4 3BS	GB	0101000020E610000033C4B12E6EA3F3BFB6847CD0B3494B40
86775	WA1 1QA	GB	0101000020E6100000C50ADA8B38C604C0E1D53F7601B14A40
86776	TR16 4AP	GB	0101000020E610000072003C23C3E814C06E65E73F741F4940
86777	TF11 9BA	GB	0101000020E6100000699F6BB8F8FA02C03B59EB3DF5544A40
86778	YO51 9LB	GB	0101000020E61000006DE1B60CF155F6BF618CBF223C0C4B40
86779	EH48 1LQ	GB	0101000020E610000070CE88D2DEE00CC0C286A757CAF24B40
86780	M34 3SH	GB	0101000020E6100000701F5E7C761501C011BD31A946BA4A40
86781	G1 4LT	GB	0101000020E6100000E4141DC9E5FF10C04BC8073D9BED4B40
86782	BD11 1EA	GB	0101000020E61000006B065D67E864FABFB86576CC2FE04A40
86783	CV7 7PL	GB	0101000020E6100000AAF23D2311BAFABFAFD815E934384A40
86784	LL49 9HB	GB	0101000020E610000029FDCE40768810C0B15879B8D3764A40
86785	NG5 8NE	GB	0101000020E610000098454C7CFA4FF2BFE7E155EDD2804A40
86786	S60 4NA	GB	0101000020E61000008781238B78A6F5BF226577C0F6B34A40
86787	SO14 6QR	GB	0101000020E6100000D446753A9075F6BF66F4A3E194754940
86788	PA15 4RT	GB	0101000020E6100000B5A679C729FA12C038F8C264AAF84B40
86789	CM2 9AJ	GB	0101000020E6100000A43F8FAC576CDD3F45D5AF743EDC4940
86790	BS8 3RA	GB	0101000020E61000000FBCB5A73F4605C01321BFC815BC4940
86791	LS9 6JP	GB	0101000020E6100000884677103B13F8BF895FB1868BE64A40
86792	YO24 1QQ	GB	0101000020E61000008A66E7320AB1F1BF191F452172F84A40
86793	DE4 3PX	GB	0101000020E610000000E15FDEC5FEF8BFC365D319B18E4A40
86794	ME14 1XQ	GB	0101000020E61000002CDFE98486B4E03FBE9A4D918DA34940
86795	NR25 7TL	GB	0101000020E610000029E55A59479AF03FEBD10AC2CB784A40
86796	LN9 5DX	GB	0101000020E61000007D57AEFEA260BDBF7EF00CE0CE9A4A40
86797	FY8 1NN	GB	0101000020E61000009E08D8CA283308C0F60BC70A76DF4A40
86798	WF9 1AB	GB	0101000020E61000009797A85070A0F4BFC7F9171824D14A40
86799	FK2 8PJ	GB	0101000020E6100000BE254A8CAF170EC04819710168074C40
86800	NR2 2LA	GB	0101000020E610000081CB3394B28BF43FCD4F0CF1514F4A40
86801	RH11 7SX	GB	0101000020E6100000579B7B1F796DC8BFB47D90B10F904940
86802	NW7 3HB	GB	0101000020E610000082CF6ADCF698D0BFF05EFFBFFBCF4940
86803	TQ11 0DJ	GB	0101000020E61000005F2A919FE8450EC0ADED3724FF3C4940
86804	OX17 3NG	GB	0101000020E6100000E374ED66A1F8F4BFB7E0FBD126024A40
86805	IP23 8HD	GB	0101000020E610000028CAC4FEC957F13F1CA2C5AAA5254A40
86806	BH15 1BP	GB	0101000020E61000009BFB4B5551D1FFBF3C7F9B444B5B4940
86807	CV34 6AW	GB	0101000020E6100000967F8868CF80F9BF46A0B07A76234A40
86808	CO9 1HU	GB	0101000020E610000021BC2CDCA844E43F8687D5C4A7F84940
86809	OX13 6QJ	GB	0101000020E61000008E1B237E6AA1F5BF61A8C30AB7D74940
86810	LS9 6NT	GB	0101000020E61000000E6954E064DBF7BFE6ADBA0ED5E64A40
86811	TF3 4HS	GB	0101000020E610000021AD10DA9B9503C02F506EB530564A40
86812	PO8 8ED	GB	0101000020E6100000C00A2A897024F0BFBADB1B9A77724940
86813	PO4 8LW	GB	0101000020E6100000E84020E1C5ACF0BFD61BB5C2F4654940
86814	L18 8BH	GB	0101000020E6100000426B346F8B6807C049C4EF0115B14A40
86815	CM3 3PT	GB	0101000020E610000053F2A08FE8D4DF3F20B24813EFE24940
86816	SK9 3LD	GB	0101000020E6100000D455ECF50FBE01C099FA8D37B8AD4A40
86817	NR2 2DA	GB	0101000020E6100000F02109444D79F43F9953678D384F4A40
86818	DA12 5UQ	GB	0101000020E6100000490009532C08D83FD600D021A3B44940
86819	TQ7 3AJ	GB	0101000020E6100000F9FF27356AF40EC06E6AA0F99C234940
86820	KW10 6SF	GB	0101000020E61000004C78F821259C0FC0587D642948FD4C40
86821	BA12 7NW	GB	0101000020E6100000140FDE0D583802C08063CF9ECB974940
86822	PE36 6JJ	GB	0101000020E6100000DEFE78899306E03FED612F14F0794A40
86823	W1J 9LN	GB	0101000020E6100000CBC80F4BB9B1C1BFE6A3D6451BC14940
86824	DD7 7JE	GB	0101000020E6100000BDE88601A6B705C069A0432AD63F4C40
86825	M15 6BP	GB	0101000020E61000004ADE5CA3B5F301C041E3522D53BC4A40
86826	PH19 1AF	GB	0101000020E61000004F5F2A919FF810C07B922A40CA764C40
86827	LN10 6RW	GB	0101000020E6100000BFBE315FB939CCBF1FDCF86E4E934A40
86828	G3 6TX	GB	0101000020E6100000C7681D554D1011C06AFAEC80EBEE4B40
86829	LL54 5NA	GB	0101000020E61000000A5B1978E1BF11C091E1B3A0F07E4A40
86830	TN13 2TD	GB	0101000020E61000007197F5498B86C43F3B7716188DA64940
86831	DN19 7EX	GB	0101000020E6100000C9AAE26F7629D9BF002912958BD84A40
86832	RG41 5JD	GB	0101000020E6100000A57FEE70E03AECBF5401F73C7FB74940
86833	CA13 9JS	GB	0101000020E61000007F0F030242F00AC0AB4D524FD5544B40
86834	DA5 1AS	GB	0101000020E61000008D55945C0F70C23FF4BA8FEDC6B84940
86835	DE13 0DJ	GB	0101000020E6100000A579E636F8EAF9BFAEB8E7E2F76B4A40
86836	RG29 1RS	GB	0101000020E6100000A1B48185DD01EFBF74C06499349C4940
86837	TA11 7PD	GB	0101000020E610000031EB287B09D505C01853716216874940
86838	S81 8HF	GB	0101000020E61000000C80352A170AF1BF4B686A9044B04A40
86839	TQ6 9EN	GB	0101000020E6100000D8D9EB38D9B10CC07EBF3D74E62C4940
86840	TQ7 3HE	GB	0101000020E6100000C82A0021EDDA0EC045A973FB9B1F4940
86841	HR6 0ER	GB	0101000020E610000010F39B78BD5A05C09C6C0377A01F4A40
86842	PE27 4TG	GB	0101000020E6100000FE48111956F1A2BFA675656199284A40
86843	CM14 4HJ	GB	0101000020E610000089EA52C83A41D33F50F5D0E39CCE4940
86844	BB7 1QA	GB	0101000020E6100000F8D96DBCE0D802C09B7A38DCA2F04A40
86845	RG9 1BG	GB	0101000020E6100000E873A4E9A2D7ECBF974D25A886C44940
86846	TF8 7AU	GB	0101000020E61000000DB6C7C15BE603C0407EDBB86A504A40
86847	DE74 2DF	GB	0101000020E61000006B0B07F62393F4BF61C4EDB9146B4A40
86848	PE38 9DH	GB	0101000020E61000004E4B0746B90FD83F58207A52264D4A40
86849	DN40 3AY	GB	0101000020E6100000AEFDB68A72A7D0BFEE73B91711CE4A40
86850	EH40 3DP	GB	0101000020E61000006C43831CAD4105C0EEC28324FBFD4B40
86851	BN11 3QD	GB	0101000020E6100000C9E7D3326B2CD8BF0F5A17D06E674940
86852	PE31 8BS	GB	0101000020E610000048A46DFC894AE53F4DCBFE2F8D7B4A40
86853	RG41 2YL	GB	0101000020E61000008F13F199962FEBBF072C309927B54940
86854	PE30 2PU	GB	0101000020E6100000165BF745F84DDA3FA87D29F2DA604A40
86855	BR1 2EN	GB	0101000020E61000003C54AE4BE889A63F22FE614B8FB24940
86856	CM7 5PL	GB	0101000020E61000005B9ECA134FF0E13FEF028DE84AF54940
86857	TN8 7NP	GB	0101000020E6100000C31D683877D1BC3F99BDE3494F994940
86858	M41 5GJ	GB	0101000020E6100000F8B5E4A7271203C0EA7EA9FAF0B84A40
86859	SK10 5BG	GB	0101000020E61000000B986F66BCCD00C086C5783257A54A40
86860	AB41 7BP	GB	0101000020E61000001BDA006C40E401C0C00EF7EC14B74C40
86861	SW6 1HS	GB	0101000020E61000005D62ED6EEC79C8BF3BFF048487BD4940
86862	BA1 1LF	GB	0101000020E61000004D6A2BA097DC02C072B1CACEA0B04940
86863	S71 5EH	GB	0101000020E6100000639B0D5F4AC0F6BFF40870A5D7C54A40
86864	EH12 6UG	GB	0101000020E61000006486D286DF3F0AC069463C623FFA4B40
86865	ML8 5QB	GB	0101000020E61000008EA11A31DE3B0FC0FF8EFC4FEBDC4B40
86866	G2 4PB	GB	0101000020E610000002476FA9641311C0C99CFC5088EE4B40
86867	DG11 2SF	GB	0101000020E61000003D15007B36FB0AC01DB0E0BB23924B40
86868	EH3 9HZ	GB	0101000020E61000007D07F89B749E09C010A579A4DAF84B40
86869	SG1 3AZ	GB	0101000020E61000004127A51CA3E7CABF9BAF50730BF54940
86870	CF62 7XY	GB	0101000020E6100000FCE10D87AA4A0AC0F59E324D04B34940
86871	PH2 8HB	GB	0101000020E6100000ADF6A1ECDC810BC07B5AED7D44324C40
86872	DG1 1LT	GB	0101000020E61000009AA9A1F16AD70CC0402AACF125894B40
86873	IV12 4HP	GB	0101000020E6100000051BC5DC2F030FC070A772AFD3CA4C40
86874	DD5 2QL	GB	0101000020E6100000538AD4B68CD406C077325E11813C4C40
86875	DD8 1RJ	GB	0101000020E61000005DAC037BA70D08C0DADE13909B4D4C40
86876	KA3 6AU	GB	0101000020E6100000881FE525D4CB11C00A3510B983D34B40
86877	LL55 4TY	GB	0101000020E6100000E360DEFFA17610C0A859F124618F4A40
86878	IV2 4LF	GB	0101000020E61000000012716600EF10C0C605E92771BA4C40
86879	TR7 2RS	GB	0101000020E6100000929735B1C04714C0310CB32B88354940
86880	EH10 6JD	GB	0101000020E61000001A544BD59EB309C00F8B029146F54B40
86881	SA12 6QP	GB	0101000020E61000002614BDB42A870EC0D1C3DD14E7CB4940
86882	YO23 1JX	GB	0101000020E610000081AE22484A5FF1BFB5ECFFD258F94A40
86883	YO62 6TF	GB	0101000020E6100000D418631690ECEBBFAF9FB426CC234B40
86884	LL13 0TF	GB	0101000020E61000005F9445065E8607C09977C52195824A40
86885	BN18 9AD	GB	0101000020E610000047062BE118B8E1BF9A9CA728416D4940
86886	MK9 1AL	GB	0101000020E61000004694F6065F98E8BF5C2041F163044A40
86887	KY12 8QW	GB	0101000020E61000007705E7FBC5020CC0E51D688445074C40
86888	SA71 5NT	GB	0101000020E6100000275DCD161D7A13C04F58F99D1AD64940
86889	NE1 5DH	GB	0101000020E6100000D7A3703D0AD7F9BF6ABC7493187C4B40
86890	WC1X 9QN	GB	0101000020E6100000EA043411363CBDBF5DDC460378C34940
86891	DD2 1PG	GB	0101000020E61000004FC34813153408C0510123747F3A4C40
86892	FK1 5RY	GB	0101000020E6100000B36EC8AED05D0EC06EDD5645FBFF4B40
86893	KT17 2DE	GB	0101000020E6100000D025C1C01836CEBFB04E3A36A7AE4940
86894	SW3 3QZ	GB	0101000020E61000007FD93D7958A8C5BF90A0F831E6BE4940
86895	PL1 3LG	GB	0101000020E61000007FE5555E719910C03138E532F72E4940
86896	DG1 4JX	GB	0101000020E610000057E55E3A8F5D0BC0E9A555399C844B40
86897	L34 9HA	GB	0101000020E610000021DCAEE1330307C032303C4041BB4A40
86898	CT17 9BP	GB	0101000020E6100000895D64CD8B05F53F3507E21E868F4940
86899	LA22 9SS	GB	0101000020E610000000107AADB93408C0613BE006B13A4B40
86900	HA1 2EF	GB	0101000020E61000001966A857B84FD5BF917AFE9D75CA4940
86901	EH10 4HH	GB	0101000020E6100000683300B4E3A709C0335E880F0BF84B40
86902	EH1 3QY	GB	0101000020E61000009CA223B9FC8709C0FB3A70CE88FA4B40
86903	LS9 6QD	GB	0101000020E6100000A725564623DFF7BF78D4981073E74A40
86904	NG5 2EF	GB	0101000020E610000049A559524E71F2BF0CAEF606587C4A40
86905	NE16 3BE	GB	0101000020E61000003FB9CE0834EDFABFB0DF2F40447B4B40
86906	SE1 7PB	GB	0101000020E610000019C16B3C7DA9BEBF72A3C85A43C04940
86907	N14 6EN	GB	0101000020E6100000F05EFFBFFBF4BFBFC2813573EDCF4940
86908	CV34 6RE	GB	0101000020E6100000A54E401361C3F9BFB6F3FDD478214A40
86909	WA14 4DP	GB	0101000020E61000000DD59CD565CD02C0084F41AEEFB14A40
86910	LL61 5YH	GB	0101000020E61000007A3E5EA340C210C05BD48272369C4A40
86911	TS14 6PT	GB	0101000020E6100000A4703D0AD7A3F0BF85EB51B81E454B40
86912	NE46 3LT	GB	0101000020E6100000D086D86D0BD300C0D963BF7A1E7C4B40
86913	BS8 1LX	GB	0101000020E6100000FC1065B9B6E104C08DB85BEDBCBA4940
86914	L3 5TB	GB	0101000020E6100000E1229CBB02C607C0EE7BD45FAFB34A40
86915	EH12 5LG	GB	0101000020E6100000C2DCEEE53EC909C02B2DC83B2CF94B40
86916	MK45 2JQ	GB	0101000020E610000045FC1E5091DEE0BF9E3017A710064A40
86917	RG21 3EE	GB	0101000020E61000005EE52C93B147F1BF1087B6AD77A04940
86918	LS9 7EY	GB	0101000020E610000068925852EE3EF8BF849B8C2AC3E64A40
86919	CB1 1LY	GB	0101000020E610000045D5AABB8453C03F775D768A80194A40
86920	B27 7UJ	GB	0101000020E6100000108EFE3CB23EFDBFE49E3C99F0384A40
86921	B40 1PP	GB	0101000020E6100000986613909174FBBF1FF693489A394A40
86922	NE2 2TB	GB	0101000020E61000009A9999999999F9BF1F85EB51B87E4B40
86923	DE1 2SQ	GB	0101000020E6100000993A1B34EC6EF7BF948D67CD18754A40
86924	LL12 0DE	GB	0101000020E61000008F97B22F809007C05DC07F7E158E4A40
86925	WR11 8UT	GB	0101000020E6100000E355EA1AAC6EFEBF0CAF1FC034134A40
86926	CW5 5AS	GB	0101000020E6100000CE3D7A7CA83004C07A1EBB8F8C884A40
86927	PH21 1LA	GB	0101000020E61000002F51BD35B03510C0E8DB82A5BA8A4C40
86928	RH6 7EX	GB	0101000020E610000006668522DDCFC5BFF1643733FA954940
86929	HR7 4DL	GB	0101000020E610000064CC5D4BC80704C055302AA913184A40
86930	CT20 2EA	GB	0101000020E6100000EE0912DBDDC3F23F38691A14CD894940
86931	TR19 6XH	GB	0101000020E61000002A6AD553504616C02A83B4102E084940
86932	PR3 5JB	GB	0101000020E6100000F4FDD478E9A605C06FF085C954E14A40
86933	B69 2BD	GB	0101000020E6100000295C8FC2F52800C0BADA8AFD653F4A40
86934	PR8 1RB	GB	0101000020E610000046DCEAD9761508C00C455C2ED2D24A40
86935	YO10 4PJ	GB	0101000020E6100000D9DABB396E2EF1BF3C44A6F3D6F74A40
86936	OX15 6QB	GB	0101000020E6100000ADEAAA15AD49F6BF32D036B075094A40
86937	YO25 6AN	GB	0101000020E6100000BFF7B32F0B33DCBFEDAB9667AA004B40
86938	SW7 5EH	GB	0101000020E61000003F575BB1BFECC6BF2BF697DD93BF4940
86939	LA23 3NF	GB	0101000020E6100000ECC039234AF706C0B06BD473ED2C4B40
86940	W2 3LG	GB	0101000020E61000007D61BD47B9D8C6BFFF89B5EB6AC14940
86941	TQ2 6RQ	GB	0101000020E6100000F876F2B9785F0CC02C1670E3173A4940
86942	CV1 1LZ	GB	0101000020E61000005F30BAE7B930F8BFB082245B39344A40
86943	YO1 7EF	GB	0101000020E610000078328120155EF1BF9D25478812FB4A40
86944	TN31 6YH	GB	0101000020E610000064C1ED9E76A7E53F614330411F7D4940
86945	CA11 0PB	GB	0101000020E61000003BC559FA989707C093095D6178454B40
86946	TA24 5PU	GB	0101000020E610000094F6065F98CC0BC0FDA19927D79A4940
86947	GL8 8YJ	GB	0101000020E61000008CFA9B857ADC01C0C5A8617B8AD34940
86948	GL8 8QL	GB	0101000020E61000002E7079AC199901C04AB54FC763CE4940
86949	PL1 3LD	GB	0101000020E61000001A71C4047C9910C01001A3A5142F4940
86950	HR9 6LL	GB	0101000020E61000003231A715F05005C0D9065BDD8BF64940
86951	NN12 8QH	GB	0101000020E610000093E6DBF7B2E1F0BF818ED07B950E4A40
86952	BA2 7FY	GB	0101000020E610000037A4AA39DB8002C08139CEFBECAB4940
86953	HG4 2BU	GB	0101000020E6100000C5083C8B397BF8BF9A09C88F5F114B40
86954	SP1 2AN	GB	0101000020E610000047738F65F4B5FCBFC329E08FBC884940
86955	E14 8JR	GB	0101000020E61000006E85B01A4B589BBFB2D7BB3FDEBF4940
86956	BN21 4EE	GB	0101000020E61000001D2E16DF8031D23FDF06DDA768614940
86957	SA6 8WB	GB	0101000020E6100000D7F9B7CB7E4D0FC02C0A606F07D54940
86958	SK10 2JJ	GB	0101000020E6100000F635DC91FB0701C08E3F51D9B0A24A40
86959	BT74 6RW	GB	0101000020E61000002A2389B9FF7B1EC0A1D56E60172A4B40
86960	RH5 6LG	GB	0101000020E61000003D433866D913DABF28B0A5EC99974940
86961	PO14 1PE	GB	0101000020E6100000061B8D32D156F3BF069D103AE86C4940
86962	WS13 8RD	GB	0101000020E6100000652CE45B6923FCBFB9B601E9AC5B4A40
86963	SP2 0BH	GB	0101000020E61000007493BD4AE3BCFDBF2B5BDA5F2C8A4940
86964	IV2 7PA	GB	0101000020E6100000EA04341136BC10C0849ECDAACFBD4C40
86965	SO31 6AF	GB	0101000020E610000068B3452D2827F4BFCA43F009236F4940
86966	ST16 2JU	GB	0101000020E6100000A9422777E4EF00C07D430C3452674A40
86967	W2 4BH	GB	0101000020E610000000B90E1F227FC8BF49B9A063ACC14940
86968	SW5 0EN	GB	0101000020E6100000E02F664B5645C8BF9EAE939FF9BE4940
86969	SW1V 1SA	GB	0101000020E6100000EBB506DA1028C2BF63F236D1CFBE4940
86970	SW5 0TP	GB	0101000020E6100000E12BC920C898C8BFBE560F8624BF4940
86971	PA23 7NE	GB	0101000020E6100000EA1D13CE13B413C02F2D8FDA69F94B40
86972	RH10 1UA	GB	0101000020E6100000F54A598638D6C5BFD8817346948E4940
86973	RH10 9ST	GB	0101000020E6100000B3A72E2AF3A0C7BFEE2B6A8BC6914940
86974	NE69 7BS	GB	0101000020E61000002EE00ACD1A81FBBFBC5D8A0684CD4B40
86975	TR21 0HU	GB	0101000020E6100000AFE4C5EAD84419C06D9D57F35EF54840
86976	W1U 6JX	GB	0101000020E610000096B377465B95C4BF52A85D02A6C24940
86977	W14 8RS	GB	0101000020E6100000295140248D1BCABFA95D5D5F35BF4940
86978	CF47 8BG	GB	0101000020E61000004A80F51329080BC0D257EB1F9FDF4940
86979	AB51 0AE	GB	0101000020E6100000448001F4639E02C0BEFD7C05F0AC4C40
86980	W11 2RS	GB	0101000020E6100000DCF3FC69A33AC9BFB49080D1E5C14940
86981	GL52 2AH	GB	0101000020E6100000ECF25256788C00C0A613645F0DF44940
86982	GL6 6UN	GB	0101000020E61000008E2BE400B09001C09CD9531795E44940
86983	SW7 3PF	GB	0101000020E610000039971A551124C7BF35A996E4A8BE4940
86984	W1J 7ER	GB	0101000020E6100000E97706B243A1C2BF069C4AABC6C04940
86985	SW5 9PF	GB	0101000020E61000001A266431FB86C9BFE09AE040EDBE4940
86986	LS9 7QW	GB	0101000020E6100000965B5A0D893BF8BF1BBCAFCA85E64A40
86987	W14 8SN	GB	0101000020E61000004B0AB772B271CABF164AB4510EBF4940
86988	LL57 2BG	GB	0101000020E61000007649415CDE8910C0E193F36A259D4A40
86989	AL3 4RY	GB	0101000020E610000027CEFEFE9C7BD6BF5C70BAF079E04940
86990	WA16 6DT	GB	0101000020E61000002CE807BF1EFD02C087D6D4C3E1A64A40
86991	SG1 1HA	GB	0101000020E6100000D829560DC2DCC9BFE21236F22FF34940
86992	DL2 1RH	GB	0101000020E6100000D881734694F6F6BFA857CA32C4414B40
86993	DT7 3JQ	GB	0101000020E6100000EC246C89A67D07C0FBD813138A5C4940
86994	EX23 8HJ	GB	0101000020E61000002497A4D70B3212C0E6577380606A4940
86995	BH23 3NT	GB	0101000020E610000038AFFBD86EECFBBF7D9EF5DF395D4940
86996	IV14 9ES	GB	0101000020E61000007FB4498FF04F12C05EF58079C8C84C40
86997	TW17 9JZ	GB	0101000020E610000077AE39515C1FDDBFEF7B8AD294B14940
86998	W2 3LG	GB	0101000020E61000007D61BD47B9D8C6BFFF89B5EB6AC14940
86999	M90 4WP	GB	0101000020E61000005AC47DD2F32C02C08D31A81DDBAE4A40
87000	CB1 3LH	GB	0101000020E61000000AA6F512BE52C63F3468E89FE0184A40
87001	AB23 8XR	GB	0101000020E6100000CFFCC5C7827D00C04E131159FF9F4C40
87002	HG1 2RZ	GB	0101000020E61000007532153B4AC0F8BF33728D0417FF4A40
87003	PR1 3AU	GB	0101000020E610000059BFFCC2E99405C0C0EC82E77CE14A40
87004	LD1 5DY	GB	0101000020E61000006FF7A2D832060BC0B9869899B91E4A40
87005	TA1 2LR	GB	0101000020E6100000F90FE9B7AF8308C0423EE8D9AC824940
87006	SA61 2DU	GB	0101000020E6100000C861307F85E413C0079046AA94E64940
87007	TN24 8QQ	GB	0101000020E610000088635DDC4603EC3F07CE1951DA934940
87008	AB15 7AQ	GB	0101000020E6100000832F4CA60A4601C00AD7A3703D924C40
87009	DD3 6SP	GB	0101000020E61000009BCAA2B08BF207C07341C758B73C4C40
87010	BS23 4NG	GB	0101000020E61000009B5A11908ADA07C0DB42A1AF6AAA4940
87011	LL26 0UL	GB	0101000020E6100000ED612F14B07D0EC0F3D4D97F53964A40
87012	W2 2TP	GB	0101000020E610000069558D569C47C6BF3B9D4F10C1C14940
87013	SP6 2AX	GB	0101000020E6100000032269DC4026FCBFE91F8EBFFE794940
87014	CV34 6TW	GB	0101000020E61000002D8C3E3091BCF9BF3B8C497F2F214A40
87015	PH34 4DZ	GB	0101000020E6100000D07EA4880C8B13C09C285316CF7C4C40
87016	SP6 3HY	GB	0101000020E610000058E1968FA444FDBF291F27F15E744940
87017	BT36 4RH	GB	0101000020E6100000D72E127FB9EB17C05C7347FFCB564B40
87018	NG18 4SE	GB	0101000020E61000005646239F571CF3BF6C239EEC66904A40
87019	BT47 2NH	GB	0101000020E6100000CB49287D21341DC019C4ACBC897E4B40
87020	EH12 5EH	GB	0101000020E6100000297AE063B0C209C07868B3452DF94B40
87021	DD10 8EW	GB	0101000020E6100000672B2FF99FBC03C07FEC3F7CAA5A4C40
87022	IG9 5HT	GB	0101000020E610000002412553AAE99F3F58CBF852D3CF4940
87023	BN3 1HQ	GB	0101000020E6100000493FC84F36A7C4BF20E9997F70694940
87024	WC1B 5JD	GB	0101000020E61000004B2F7B2304F5BFBF4DED56E075C24940
87025	NW3 4RB	GB	0101000020E61000006840BD19355FC5BF0B444FCAA4C64940
87026	CT2 9HX	GB	0101000020E61000002545316720C8F03F605366D15BA74940
87027	WR9 7PA	GB	0101000020E6100000F5B1859715F300C06FBCF45C0A254A40
87028	NP18 1HQ	GB	0101000020E6100000445266DE057507C0F2553C3FD6CD4940
87029	DE24 8HX	GB	0101000020E6100000764F1E166A4DF7BFBEC1172653754A40
87030	RG20 8JU	GB	0101000020E6100000FEFAB69A54E0F5BF2E058D61DAB44940
87031	DA5 1ND	GB	0101000020E61000003F73D6A71C93C33F80F44D9A06B94940
87032	B16 9NB	GB	0101000020E6100000797CAB10B72CFFBF36274316683C4A40
87033	NN16 0AJ	GB	0101000020E610000076CD9A0E5351E7BF99219FA1C9324A40
87034	NR33 0BQ	GB	0101000020E61000001C7920B248D3FB3F2277C7180E3B4A40
87035	WR12 7DE	GB	0101000020E61000000A50AE8449ECFDBF4D7276210C054A40
87036	TR27 5BN	GB	0101000020E61000001E9129FE738F15C0CF0A44037C1A4940
87037	TR2 4BN	GB	0101000020E61000001106F934820014C0EE1120F939234940
87038	PL25 3SG	GB	0101000020E6100000672C9ACE4EFE12C0A7DDF98F962A4940
87039	OX20 1DX	GB	0101000020E61000007A66930DB5D7F5BFC3C771F101F04940
87040	SW7 3DB	GB	0101000020E6100000CC1A063DE522C7BF9D546157C6BE4940
87041	BD23 4EB	GB	0101000020E61000005C5430CFEF6001C0BA731717FDFF4A40
87042	IV2 5BE	GB	0101000020E6100000D65210A1E9A310C0DEABB4977DBA4C40
87043	DE23 6AD	GB	0101000020E61000002F777F1F82D0F7BFCB954EDFC3744A40
87044	EH6 6LA	GB	0101000020E6100000C03E3A75E57309C05900AEBF80FD4B40
87045	W1B 5EL	GB	0101000020E6100000935EC7C45581C1BF789AF7F837C14940
87046	WA13 9BP	GB	0101000020E6100000BE71AD516A0A04C0BDD930540FB14A40
87047	WR1 1EA	GB	0101000020E610000081C6CB2149C701C09A2573BFD2184A40
87048	S60 4NA	GB	0101000020E610000088855AD3BC63F5BF0AD80E46ECB34A40
87049	EH4 3HL	GB	0101000020E610000047DE2A6974F409C02A9FDEBF4BFA4B40
87050	PL25 3RD	GB	0101000020E61000002C68B51BD8F512C04D4C1762F52A4940
87051	E16 1XL	GB	0101000020E6100000986A662D05A48D3F45AEE5DF78C14940
87052	AB42 1PL	GB	0101000020E61000005858703FE0C1FCBF87A5811FD5C04C40
87053	LN1 1YW	GB	0101000020E6100000A6D26B8DEA7FE1BFDD0323184F9D4A40
87054	W1T 1LB	GB	0101000020E6100000029A081B9E5EC1BF51DA1B7C61C24940
87055	WR14 4AA	GB	0101000020E6100000DFF58F41CBA302C0C71B4A01AA0E4A40
87056	EC4M 7LS	GB	0101000020E61000005538DD0DFD6EB9BFF82466ACECC14940
87057	PH13 9AL	GB	0101000020E6100000CEFE40B96D1F0AC04B94185F0F464C40
87058	BA4 4PR	GB	0101000020E6100000F46C567DAE3604C001DE02098A974940
87059	EC4N 7BB	GB	0101000020E6100000637D295ABED0B6BFA801464177C14940
87060	CF48 4BD	GB	0101000020E610000035F91C0E01E60AC09D007965CDDC4940
87061	WS13 7AR	GB	0101000020E6100000AE0FCF382B5FFDBFE1954024E5574A40
87062	AL1 1JQ	GB	0101000020E61000000467EEF660BFD4BF2A8F69CB0BDF4940
87063	PA3 2SW	GB	0101000020E61000003445251A49B711C0F203FCBF8FEE4B40
87064	HR9 6BL	GB	0101000020E6100000C53C2B69C52705C0076CBD95DBEB4940
87065	AB23 8BL	GB	0101000020E610000072F90FE9B7AF00C039454772F9974C40
87066	NN6 7XR	GB	0101000020E6100000AA29C93A1C5DF2BF9B711AA20A2D4A40
87067	WR12 7LJ	GB	0101000020E610000006D6F534F55CFDBFB0AD582928054A40
87068	E1 6JQ	GB	0101000020E610000063F030ED9BFBB3BF31EE06D15AC34940
87069	NE1 4DN	GB	0101000020E6100000EEED96E480DDF9BFD0D38041D27B4B40
87070	B66 4ET	GB	0101000020E610000059AC41952387FFBFC3A2E5EA8E3D4A40
87071	PA34 5PZ	GB	0101000020E61000006942493778E515C0F79B3F5C28354C40
87072	PA34 4LS	GB	0101000020E6100000E0BFD42A55ED15C0E7A331FF8D344C40
87073	PH2 9DP	GB	0101000020E6100000E6D5EF7849D20BC0B4CDE8A27C234C40
87074	PH16 5EQ	GB	0101000020E6100000FA0CA837A3D60DC0C3B7B06EBC5A4C40
87075	PH7 4BP	GB	0101000020E61000000CB32B88DCC70EC0B1EBCD5E6C304C40
87076	PH2 8EB	GB	0101000020E6100000A58C13BAA67B0BC03424383F0F324C40
87077	PH16 5EW	GB	0101000020E61000007A85D00434D00DC0F840D730165B4C40
87078	BA1 7HZ	GB	0101000020E61000005F29CB10C7BA02C0986E1283C0B24940
87079	IV51 9DG	GB	0101000020E61000001008CFDFDFC318C0FBF14D89DAB44C40
87080	PA37 1PB	GB	0101000020E6100000E03EE2BF8F8815C03DF6C283F7394C40
87081	PA34 5AA	GB	0101000020E6100000187D0569C6EA15C01DEE7E7099354C40
87082	PH49 4HX	GB	0101000020E610000051D845D1032714C0664E97C5C4544C40
87083	PA31 8SJ	GB	0101000020E6100000517310796DF415C058293562C3074C40
87084	CF64 3DH	GB	0101000020E6100000FB1AEEC8FD6309C0C8D2872EA8B74940
87085	PA23 7TJ	GB	0101000020E6100000336F9359D6D013C07B1B17E5C4F24B40
87086	PA34 5QD	GB	0101000020E6100000D156CAD70AE715C0B443577D09354C40
87087	PA34 5AD	GB	0101000020E6100000187D0569C6EA15C01DEE7E7099354C40
87088	DG7 1AA	GB	0101000020E61000009C50888043680FC0A7BBA1DFAD784B40
87089	DG7 1EL	GB	0101000020E6100000C3F2E7DB82750FC042B9C89816784B40
87090	PH7 3JA	GB	0101000020E610000051F52B9D0FAF0EC0193E7D5FB72F4C40
87091	PH2 7JZ	GB	0101000020E6100000E41D96BCF0090BC0F1BA7EC16E314C40
87092	LN5 7EP	GB	0101000020E6100000107CB39D5443E1BF154998C2F39C4A40
87093	IV43 8QY	GB	0101000020E6100000C38E8FAE833117C03264148257964C40
87094	ST4 4EG	GB	0101000020E6100000DF5740FC577101C02C29779FE37F4A40
87095	IV51 9YE	GB	0101000020E6100000AE1DD665426D19C0483E65EBCFCA4C40
87096	IV43 8QR	GB	0101000020E61000004B85C2B1783317C0A8F45D5B89924C40
87097	IV55 8ZT	GB	0101000020E6100000531AD6F95C9A1AC0F032C34659B94C40
87098	GU15 3UQ	GB	0101000020E6100000CA7DBCA13A27E7BF6D47270120AC4940
87099	IV51 9BU	GB	0101000020E6100000D81A00602BC718C04EA72B8EB9B44C40
87100	IV43 8QW	GB	0101000020E6100000804A58C5623617C06EC9818905944C40
87101	LS27 0JZ	GB	0101000020E61000003D4A80F513E9F9BFD305065ACBDE4A40
87102	WF2 8TY	GB	0101000020E6100000A2D283E0C345F8BF251AFD98B1D64A40
87103	WF1 1EH	GB	0101000020E6100000004E94298B07F8BFAEA70CD242D74A40
87104	AB11 6JU	GB	0101000020E6100000BF2A6871FECA00C0E084AFA08A924C40
87105	HU1 2LS	GB	0101000020E61000008FB16E17F5A4D5BF3875D487E4DE4A40
87106	TW10 6UY	GB	0101000020E6100000146DFEC75839D3BFDF8CE63D98B94940
87107	LS16 5JX	GB	0101000020E61000008AF6C2AE375BF9BF33BD699F33EA4A40
87108	YO24 1DR	GB	0101000020E610000006E3964517AAF1BFA33A1DC87AF94A40
87109	LS6 3BW	GB	0101000020E6100000F853E3A59B44F9BF5B4A4C0636E84A40
87110	LS6 3AG	GB	0101000020E6100000B3CD8DE9094BF9BF6C8198DFC4E84A40
87111	LS18 4JX	GB	0101000020E61000001B03FC64D63CFABFC9D177126CEA4A40
87112	LS8 2QD	GB	0101000020E610000057FF8C77EC0CF8BF5B176D44E6E94A40
87113	LS1 4HJ	GB	0101000020E6100000E1890FA26BD5F8BF679714C4E5E54A40
87114	LS17 8BL	GB	0101000020E61000007D5FB7634588F8BF5C0AFE6D05ED4A40
87115	S10 3ES	GB	0101000020E6100000CC118D49DA28F8BFBBE4C97F92AF4A40
87116	LS6 3AG	GB	0101000020E61000007EA59828E750F9BF7E141A2DACE84A40
87117	LS7 4HA	GB	0101000020E610000085D78926AB5DF8BFB19CCE5F32E94A40
87118	LS8 4ET	GB	0101000020E61000005656E4219D4BF8BF64BD6257A4E84A40
87119	LS19 6HU	GB	0101000020E6100000519C69E304FDFABF6E0C9C948BED4A40
87120	WC1E 6JA	GB	0101000020E61000007C408C4F8270C1BF4925FD3CD4C24940
87121	LS7 2PS	GB	0101000020E6100000C06DB76E94E6F8BFB82D80DF75EA4A40
87122	BS8 1PG	GB	0101000020E61000006C9B3D2BC4DE04C028D9452CBDBA4940
87123	S10 5BD	GB	0101000020E6100000708802C7AF09F8BF5E1F8C8E9AB04A40
87124	S10 2HW	GB	0101000020E6100000D0CE0E5DF5C5F7BFD084814298B04A40
87125	S11 8TG	GB	0101000020E6100000E8B523E6A316F8BFE021D62CE1AE4A40
87126	S7 1DR	GB	0101000020E6100000954D147C2EAEF7BF66321CCF67AE4A40
87127	S11 8US	GB	0101000020E6100000585410786A0AF8BF3429AFDCA5AE4A40
87128	S10 2QQ	GB	0101000020E6100000CEA1B19BBE03F8BF8BB6741607B04A40
87129	S7 1NQ	GB	0101000020E6100000F2727DC454DFF7BF9A740069A4AE4A40
87130	BS1 5TR	GB	0101000020E610000011A0F023C8D204C0B2BAD573D2B94940
87131	BS31 1SN	GB	0101000020E610000033EDAC2704EC03C0DF8728CBB5B44940
87132	BS16 3DT	GB	0101000020E610000098E0D407925704C0A264CD23DABC4940
87133	BS8 2BA	GB	0101000020E6100000C8A53B99C9E104C05A5DF34F15BB4940
87134	BS7 0SN	GB	0101000020E6100000FF3B478902A204C0EA3015D165C04940
87135	BS8 2EG	GB	0101000020E610000069F51FE39BE704C05877876FBCBA4940
87136	BS32 4AA	GB	0101000020E61000007FD31431879104C029D3EEAB80C64940
87137	BS31 1PE	GB	0101000020E6100000963D096CCEF103C09B7DD41522B44940
87138	CO1 2TZ	GB	0101000020E610000025AC5D78FD60ED3F37FF63ACECF14940
87139	S21 3WF	GB	0101000020E6100000D8E6153B5963F5BFF61F7BB842A64A40
87140	EH30 9YJ	GB	0101000020E6100000D55C6E30D4410BC029F4B006DEFD4B40
87141	BH1 2EU	GB	0101000020E6100000B47570B037F1FDBF459BE3DC265C4940
87142	BS6 7EE	GB	0101000020E6100000DC3C1FAF51D004C00D11DCED1FBC4940
87143	BS32 4DT	GB	0101000020E6100000CDABDFF1929404C02F19C748F6C64940
87144	BS32 4AA	GB	0101000020E6100000DFCBD82B879104C0650A8CAB80C64940
87145	BS40 7YE	GB	0101000020E61000009B24F14D2EC905C032250EB081A94940
87146	BS8 2XN	GB	0101000020E6100000BC3088FEBFF004C092297A3B1DBC4940
87147	BS9 3AU	GB	0101000020E6100000F81A82E332EE04C0710E8DDDF4BD4940
87148	BA2 3JZ	GB	0101000020E61000006DB9E985F1F902C01EC0C7050CB04940
87149	BA2 7LT	GB	0101000020E61000007A7DF7D8A79D02C0C0B8AF5EA0A64940
87150	BA1 7RB	GB	0101000020E6100000E51FC720C17E02C083948E28A3B34940
87151	BA1 1JP	GB	0101000020E61000001E56139F96DA02C0360AA41F68B04940
87152	BA2 7TL	GB	0101000020E6100000E0354305E2A002C0EB91617028A94940
87153	BA2 3AL	GB	0101000020E6100000A76153420BF402C0C14DEBDBEEAF4940
87154	BA2 3JX	GB	0101000020E61000006DB9E985F1F902C01EC0C7050CB04940
87155	BA2 3AL	GB	0101000020E6100000A76153420BF402C0C14DEBDBEEAF4940
87156	BA1 3QH	GB	0101000020E6100000B8335D99013803C0A8EE80A1FDB14940
87157	BA1 7RS	GB	0101000020E6100000ED6877A3EA7202C0CE588F5610B34940
87158	BA2 6LD	GB	0101000020E6100000D4E7B4B810C502C080BCB266BFB04940
87159	BA2 3ND	GB	0101000020E61000005DA21FB2EDF902C0D933958FEEAF4940
87160	BA1 3LE	GB	0101000020E61000006021781E0A3203C01A7E5BA36AB14940
87161	BA2 6XG	GB	0101000020E6100000FBCA83F4149902C0E88AADFB22B24940
87162	BA1 2NA	GB	0101000020E61000006566B0F380F302C09675A49F15B14940
87163	EX8 1DS	GB	0101000020E6100000FC5F64B8F0620BC019B2158FE64E4940
87164	BA1 1HE	GB	0101000020E6100000A6040EB276E502C0B6DCF4C2F8B04940
87165	BA2 7AY	GB	0101000020E610000096DDDD14A0A702C083C2A04CA3B04940
87166	BA1 3PT	GB	0101000020E6100000595249F8392903C049D8B79388B14940
87167	BA1 3JX	GB	0101000020E6100000E2395B40681D03C01DE32FD230B14940
87168	BA2 7HL	GB	0101000020E6100000A16F664F5DA402C06490604FE0AD4940
87169	BA2 6LX	GB	0101000020E61000008679EAECBFD902C0444310316FB14940
87170	BA2 4DL	GB	0101000020E61000005CF1C3F7B4D902C0E2DEA1CD16B14940
87171	BA2 6XQ	GB	0101000020E61000002D7C7DAD4B8D02C0EB7C2E0906B24940
87172	BA1 3JZ	GB	0101000020E6100000CC423BA7592003C034F7EBA930B14940
87173	BN21 2BY	GB	0101000020E610000083FE9D488B0ED23F97C79A9141634940
87174	BA1 7RR	GB	0101000020E61000007B81FEE7D57502C099107349D5B24940
87175	BA1 3PX	GB	0101000020E6100000C059EFDC202F03C0BD8C62B9A5B14940
87176	BA2 3AL	GB	0101000020E6100000A76153420BF402C0C14DEBDBEEAF4940
87177	BA2 2BY	GB	0101000020E6100000D4CF40D1E1F602C066CC6E7720AF4940
87178	BA2 6SH	GB	0101000020E6100000DFDFC6849DB002C016CE6B7504B24940
87179	BA2 4EZ	GB	0101000020E61000008565C7A1D9D002C05A50734DDCB04940
87180	BA1 2LN	GB	0101000020E61000009799C5D059EE02C051596B2D6EB14940
87181	YO12 6AG	GB	0101000020E6100000E643ABEEEC86DABFF756C96C35254B40
87182	YO12 7QU	GB	0101000020E610000023E06B63473EDABF3D08A63FA0244B40
87183	YO11 2QW	GB	0101000020E61000000FA03AB1E2AFD9BF7AE063B0E2224B40
87184	YO13 9NJ	GB	0101000020E6100000CB36267ACFF7E3BF232D95B7231D4B40
87185	YO11 2ED	GB	0101000020E610000073C009E0C1AAD9BF816ACDA0EB234B40
87186	YO12 4PS	GB	0101000020E6100000C1919B3CC06EDCBF9F330E9A021E4B40
87187	BA22 8JG	GB	0101000020E6100000376F9C14E69D05C0CEFC6A0E10784940
87188	YO10 4HG	GB	0101000020E6100000A5434C2E6B27F1BFA0BD9FBF75F84A40
87189	YO21 3EL	GB	0101000020E6100000B2518CE20BC9E3BFC5F13279B93E4B40
87190	SN10 1JQ	GB	0101000020E610000039FD8F02FAF3FFBF251F605221AD4940
87191	BS23 2AN	GB	0101000020E61000000D2950D54EDE07C08D7C5EF1D4AC4940
87192	BS23 2EJ	GB	0101000020E610000014F00DB307F607C052A7B01065AD4940
87193	BA2 4PX	GB	0101000020E6100000B221495A3BEB02C082E15CC30CB04940
87194	HG1 5EJ	GB	0101000020E61000005AEDC459CFA0F8BF20D954C4C6FF4A40
87195	YO12 6AF	GB	0101000020E61000007B57199AA6A0DABFDFAB81A618254B40
87196	YO11 2PW	GB	0101000020E610000039FC242D4BAAD9BFF6DD639FB6234B40
87197	YO12 7HZ	GB	0101000020E610000040378F1E1AF1D9BFC334C291F6244B40
87198	YO12 7HD	GB	0101000020E6100000F881F5C99B8DD9BFB32A1D07B9244B40
87199	YO11 2AY	GB	0101000020E6100000D06BA285BA7ED9BF75AC527AA6224B40
87200	YO12 7NB	GB	0101000020E61000007F220505943CDABF3F36C98FF8244B40
87201	YO11 2ET	GB	0101000020E61000007B38375C9A91D9BF7C7F83F6EA234B40
87202	YO11 2PP	GB	0101000020E610000062A7B3EE7AC4D9BFEAC59ADBCE234B40
87203	YO11 2ES	GB	0101000020E61000007B38375C9A91D9BF7C7F83F6EA234B40
87204	YO11 2AA	GB	0101000020E610000014B8D0F0C1C6D9BFB548241B59234B40
87205	YO15 2EU	GB	0101000020E61000008BD9379C9E1CC8BF5C60EA42070B4B40
87206	EX39 2QY	GB	0101000020E6100000E1911DC0C7D510C03D0AD7A370834940
87207	BN2 1TR	GB	0101000020E6100000FDA02E52280BC1BF4F779E78CE684940
87208	BN1 2FG	GB	0101000020E610000037E565A8E562C3BFF09F13E74D694940
87209	BN2 1AE	GB	0101000020E6100000CA5EA5715E52C0BF4EE6690AAE684940
87210	BN1 2FH	GB	0101000020E610000037E565A8E562C3BFF09F13E74D694940
87211	BN2 1PB	GB	0101000020E610000008E9842BFB09C1BFD5C44CECEB684940
87212	BN1 2FF	GB	0101000020E6100000AADB34119135C3BFD6D6FCB62F694940
87213	BN1 2FA	GB	0101000020E610000074F684DB9035C3BF9AF0A6B62F694940
87214	BN21 4DJ	GB	0101000020E6100000558C4EF11362D23FA4DA4C2ABF614940
87215	RH18 5EZ	GB	0101000020E6100000D260095A3794A03F31C802CBB68C4940
87216	DN33 2LX	GB	0101000020E6100000D53840D58D1CB8BFE36F7B82C4C44A40
87217	BT63 5JE	GB	0101000020E6100000B24F5B7E3BAC19C049AB104537374B40
87218	BT63 5PW	GB	0101000020E6100000FEFD18294AB019C0429EB87768394B40
87219	SL6 2EA	GB	0101000020E6100000846D6BDB95F5E5BFD1D621344BBF4940
87220	SL6 7LR	GB	0101000020E6100000AEE5DF788850E7BF78EA364D44C34940
87221	DD5 1AR	GB	0101000020E6100000379BD88D881307C010A10040043C4C40
87222	TR11 4DW	GB	0101000020E610000047B87F1B184714C02BE0F9A0C2124940
87223	L40 7SN	GB	0101000020E6100000C36CB87EB0F206C015F5937BCBCA4A40
87224	YO15 1LF	GB	0101000020E61000007E9E5099AC9BBEBF8763A769610F4B40
87225	YO16 4UJ	GB	0101000020E6100000BA3AB6549401D0BF979CC9ED4D094B40
87226	YO15 2EU	GB	0101000020E61000008BD9379C9E1CC8BF5C60EA42070B4B40
87227	YO15 2LS	GB	0101000020E6100000BAB29C687DE8C6BFF5864757B30B4B40
87228	YO15 3JJ	GB	0101000020E61000005226DAFA8E86C9BF8733BF9A030A4B40
87229	YO15 3LF	GB	0101000020E6100000F19AFCBBE3B9C9BF784485EAE6094B40
87230	EX39 5JL	GB	0101000020E610000054C3239639D210C0281FCC37EC7D4940
87231	CF71 7AF	GB	0101000020E610000068D11A0787980BC06F26B8EE2CBB4940
87232	BT52 2NY	GB	0101000020E61000002AC6F99B50901AC07457C04EFB924B40
87233	IV15 9HA	GB	0101000020E610000001BF469220B411C0A78F65660BCC4C40
87234	TS16 0DH	GB	0101000020E6100000C3B661EE3CA4F5BFA2085D4D14434B40
87235	S40 1NL	GB	0101000020E6100000AB8ABA206C02F7BFAF665364639E4A40
87236	EH1 3JD	GB	0101000020E610000034075273037F09C0ACAA97DF69FA4B40
87237	EH9 1QS	GB	0101000020E6100000D03EFB36696F09C0662893BF20F84B40
87238	IV30 1AW	GB	0101000020E610000097D58569299A0AC0580F4EFA31D34C40
87239	EH6 6JJ	GB	0101000020E6100000DB807456B07209C0C7AD934440FD4B40
87240	EH7 5JR	GB	0101000020E6100000857CD0B3597509C0423EE8D9ACFA4B40
87241	IV30 1QS	GB	0101000020E61000007FB1080FE47A0AC07AD8559286D24C40
87242	IV30 1NY	GB	0101000020E6100000F8FFCC7BF7920AC00D28E5FF9FD24C40
87243	IV30 1QW	GB	0101000020E61000007CA10627307E0AC0E541E7264BD24C40
87244	IV30 1QR	GB	0101000020E61000004953F30B65770AC02FFF7CB669D24C40
87245	IV30 6UL	GB	0101000020E61000001793E008B0C60AC0B270D6030DD34C40
87246	PH26 3HN	GB	0101000020E6100000082F36B786D90CC067335E25A5AA4C40
87247	EH12 5JQ	GB	0101000020E6100000B300B73874D409C07636E49F19F94B40
87248	EH7 5JB	GB	0101000020E61000007D0162B7747109C090543AB3B8FA4B40
87249	EH12 5JD	GB	0101000020E6100000B1E37D243ED609C062B8DF46EFF84B40
87250	EH6 4NS	GB	0101000020E610000019BAC8F3CF8209C09D610F92AAFC4B40
87251	EH3 7RY	GB	0101000020E61000006AC2514DA4BF09C035255987A3F94B40
87252	EH16 5PE	GB	0101000020E61000005BC1806FE45B09C082C06FE8D2F64B40
87253	EH9 2BU	GB	0101000020E6100000FA563552006609C0E48D829664F74B40
87254	EH7 5AH	GB	0101000020E6100000594FADBEBA6A09C033654C6661FA4B40
87255	EH7 5AB	GB	0101000020E6100000AB7587B9497109C0B7A5C46460FA4B40
87256	TR25 0QW	GB	0101000020E61000000AD7A3703D0A19C07B14AE47E1FA4840
87257	EH3 5NS	GB	0101000020E6100000BFA3213E0B9D09C0C417377F5DFB4B40
87258	EH1 2NF	GB	0101000020E6100000A243E048A09109C04A2E5ADB6FF94B40
87259	EH9 1RQ	GB	0101000020E6100000D36A48DC636909C02C2D23F59EF74B40
87260	EH10 4EZ	GB	0101000020E61000005425805138A109C083989537D1F74B40
87261	EH16 5AE	GB	0101000020E61000004179C48D006309C0571C7343F8F74B40
87262	EH1 2AE	GB	0101000020E6100000AC376A85E9AB09C02B49433289F94B40
87263	EH12 5JQ	GB	0101000020E6100000B300B73874D409C07636E49F19F94B40
87264	EH11 2JW	GB	0101000020E610000065C80CAF7FD209C0DA17755204F84B40
87265	EH12 5LB	GB	0101000020E6100000950F41D5E8C509C0FE9AAC510FF94B40
87266	EH2 3AB	GB	0101000020E610000042A79E07A29B09C0773FD4A1C6F94B40
87267	EH14 5NX	GB	0101000020E61000006B550B1F237A0AC02379D2B5BBF24B40
87268	EH2 2NH	GB	0101000020E6100000E880C932699809C05BEF9293E4F94B40
87269	EH9 2AL	GB	0101000020E61000005A5139DCFDA009C00D5AA3795BF74B40
87270	IV2 6AR	GB	0101000020E61000003ED4111B87C510C0EFB902C067BA4C40
87271	IV21 2BD	GB	0101000020E61000008FB63BB544B816C048AE51C543DB4C40
87272	IV14 9EG	GB	0101000020E61000007C35F6DB8D6412C05649641F64C94C40
87273	PO31 7PJ	GB	0101000020E61000007250C24CDBBFF4BF0F9FCFDB33604940
87274	PO37 6PT	GB	0101000020E61000002C239AE557F8F2BFB96DDFA3FE4F4940
87275	PO37 6EA	GB	0101000020E6100000CCAA196371C9F2BFFDA5A03605514940
87276	HP5 2TU	GB	0101000020E6100000B45B261EAB2FE5BF3295D97B4CDD4940
87277	PO31 8DF	GB	0101000020E6100000E523F9AF4BF3F4BFD2E89954F0614940
87278	IV41 8PH	GB	0101000020E610000061F3BBFAC2ED16C04CD8C8BFE0A24C40
87279	IV14 9ES	GB	0101000020E61000007FB4498FF04F12C05EF58079C8C84C40
87280	PO38 2HA	GB	0101000020E6100000B25A5E8E5E1AF5BF5B7D33394E4C4940
87281	PO40 9RA	GB	0101000020E61000002488A9E3E735F8BF1DE38A8BA3554940
87282	PO31 7SA	GB	0101000020E610000092C5C39C1CC5F4BFE60FC1C95A614940
87283	PH33 6DX	GB	0101000020E61000007BCB8B02337514C04A90B6966E684C40
87284	SL3 9EA	GB	0101000020E610000018265305A392E2BF4B598638D6BD4940
87285	IV2 4AG	GB	0101000020E6100000D15D6D20B8E510C0C961E6F16ABC4C40
87286	PH33 6TG	GB	0101000020E610000068EE7C9AEE5814C0440367DFCB694C40
87287	IV55 8WA	GB	0101000020E6100000F4740429DE501AC05FDA00049DB74C40
87288	IV1 1ES	GB	0101000020E61000001F48DE3994E910C08DAD0C4F54BD4C40
87289	PH33 7LY	GB	0101000020E610000066B911BB5B5E14C0D3BEB9BF7A6C4C40
87290	IV14 9DN	GB	0101000020E6100000078C3F9B662312C0859675FF58CB4C40
87291	IV52 8TW	GB	0101000020E610000082A87A808E9D16C02699602E25AB4C40
87292	IV22 2JX	GB	0101000020E6100000D06630A1DD6C16C0F415496018E24C40
87293	IV1 1EN	GB	0101000020E61000001F48DE3994E910C08DAD0C4F54BD4C40
87294	W2 4BG	GB	0101000020E61000004F649C757C6AC8BF3C3487FFCFC14940
87295	SW1X 7XL	GB	0101000020E6100000C8201C5833D7C4BFB763EAAEECBF4940
87296	LU5 4RT	GB	0101000020E6100000AD69DE718A8EE0BF7DAEB6627FF14940
87297	SE9 3QS	GB	0101000020E61000003B8CD72947E2B03F43EC90BEB0B74940
87298	SW1V 4DG	GB	0101000020E6100000211D1EC2F869C2BF4CD246BFC7BE4940
87299	E14 3QS	GB	0101000020E610000073147BC3D89D99BF4F8B660A42BF4940
87300	W1U 6HR	GB	0101000020E610000033422E275767C4BFFCF8F0D187C24940
87301	BT55 7LZ	GB	0101000020E610000013E51C86A0E41AC04B75012F33964B40
87302	PH22 1PE	GB	0101000020E6100000024C74F112A70EC06781768714984C40
87303	PH33 6BY	GB	0101000020E61000000FF8B2A3276314C05DE5643D10694C40
87304	W1U 6JX	GB	0101000020E610000096B377465B95C4BF52A85D02A6C24940
87305	E10 7EB	GB	0101000020E61000006E0091D9B4AD91BF76EA80DA5EC94940
87306	W4 1QN	GB	0101000020E6100000043752B6485AD0BF96D5CFF643BF4940
87307	WC1B 5BH	GB	0101000020E6100000A9EA2F05B529C0BF050D47A176C24940
87308	SW1W 8DJ	GB	0101000020E6100000557DF8437DDCC3BF6863809FCCBE4940
87309	W1D 6BL	GB	0101000020E6100000CF8F75278EF2C0BFA67F492A53C14940
87310	SW1V 2BL	GB	0101000020E61000006C04E275FD82C1BF06E973FFA2BE4940
87311	W1J 7ER	GB	0101000020E6100000E97706B243A1C2BF069C4AABC6C04940
87312	W2 1UB	GB	0101000020E6100000870CD9B00E16C6BFC7179439FBC14940
87313	DE13 7AE	GB	0101000020E61000009B1BD31396F8FBBF3FB9B76CBE5D4A40
87314	E14 4QT	GB	0101000020E610000008ED3081B63096BF3C026ECCA1C04940
87315	ST10 3HW	GB	0101000020E6100000708AD8710D1DFEBF00FD63C680864A40
87316	SW3 4RY	GB	0101000020E6100000FA6F6FC8505FC4BF05099B4BBBBE4940
87317	WC1H 0AL	GB	0101000020E6100000C9C27C1E4883C0BF0F05D8ECEDC24940
87318	N21 2RS	GB	0101000020E6100000043DD4B66114B8BFE6289BCD3ED14940
87319	E14 9RH	GB	0101000020E61000006245B2ECEEA690BFB9D8599995BF4940
87320	SE10 9NW	GB	0101000020E6100000EFEDF19DF3AE75BFA7412CF6F2BD4940
87321	SW3 5EE	GB	0101000020E6100000F39A0DE83BAEC5BFB0BCF5AB4ABE4940
87322	E2 9PJ	GB	0101000020E6100000582BC9F08E42ACBFDDCF29C8CFC34940
87323	W2 1HH	GB	0101000020E61000002A65636F7374C6BF61E696B1FCC14940
87324	SW1V 2DB	GB	0101000020E610000089C1B28817FAC1BF2E1D739EB1BE4940
87325	SW5 0EN	GB	0101000020E6100000E58F76971C9BC8BF9D6062A0E9BE4940
87326	SE10 9NF	GB	0101000020E61000007BC7DFAC776E70BFC6AEA3607CBD4940
87327	EC3V 9DJ	GB	0101000020E61000001A1AAABDE36FB6BFCCED5EEE93C14940
87328	W2 3AA	GB	0101000020E610000069577C9E9A26C7BF84C8D8BFA1C14940
87329	NN3 9DA	GB	0101000020E610000052256F25E0FCE9BF8774D3C1551F4A40
87330	MK44 3SA	GB	0101000020E6100000E17A14AE47E1DABF8FC2F5285C0F4A40
87331	SW1X 8DT	GB	0101000020E6100000FD17C12CD8F9C3BF3E38EE806ABF4940
87332	SW1X 0BD	GB	0101000020E6100000EADED4511F92C4BF42203C7F7FBF4940
87333	NW2 2NL	GB	0101000020E6100000F41D577E7445CABFEDCBE37A25C84940
87334	NW11 8AY	GB	0101000020E6100000E367C81DDBD7C9BF303A0FDDA2C94940
87335	W1U 6JF	GB	0101000020E6100000A23B2DE4B622C4BF2E3BC43F6CC24940
87336	W1U 5LQ	GB	0101000020E61000005EF7562426A8C3BF21109EBFBFC24940
87337	E18 2JG	GB	0101000020E61000005EB642FDD3B2923FA35C1ABFF0CB4940
87338	WC1H 9EL	GB	0101000020E610000012B9A6617450C0BF89503F8445C34940
87339	W1K 6LL	GB	0101000020E61000002B85402E71E4C3BFEA5674907CC14940
87340	SW1V 4DG	GB	0101000020E6100000211D1EC2F869C2BF4CD246BFC7BE4940
87341	W2 1RU	GB	0101000020E6100000F15E5A796E46C6BF35B6D782DEC14940
87342	W2 3DW	GB	0101000020E6100000DA77A0A932E7C6BF40529F3FC8C14940
87343	W2 4EW	GB	0101000020E61000008FDFDBF4673FC9BF27DC2BF356C14940
87344	W2 1RU	GB	0101000020E6100000F15E5A796E46C6BF35B6D782DEC14940
87345	W2 4HP	GB	0101000020E6100000816FE4CB553DC8BF3EB0E3BF40C14940
87346	W5 5BX	GB	0101000020E61000004FAE2990D959D3BF526CBBBF30C14940
87347	N4 2LX	GB	0101000020E6100000DC92663DC626B9BFBA7889FBD9C84940
87348	SW7 4HH	GB	0101000020E6100000F2FE89DBB28DC7BF3259DC7F64BF4940
87349	W1H 7JB	GB	0101000020E6100000E85A6A73524EC4BFDE99643FE6C14940
87350	W1U 8JF	GB	0101000020E6100000F6C3BE53B769C4BFAF9C18ED4CC24940
87351	SW5 0TP	GB	0101000020E6100000E12BC920C898C8BFBE560F8624BF4940
87352	SW7 3EE	GB	0101000020E6100000855561D80693C6BF12FB5F09FFBE4940
87353	NW11 7QH	GB	0101000020E610000031CB434BC395C8BFAB984A3FE1C84940
87354	W2 3LH	GB	0101000020E6100000E27E7676E8AAC6BF554FE61F7DC14940
87355	W2 2TP	GB	0101000020E610000069558D569C47C6BF3B9D4F10C1C14940
87356	W2 2HB	GB	0101000020E6100000298EA8F523EAC4BF252EB6FFB7C14940
87357	SE3 7TH	GB	0101000020E610000093020B60CAC0913F62A30799BFBC4940
87358	W14 8RP	GB	0101000020E610000099D29FA28F9ECABF751A0EF049BF4940
87359	TD6 0RQ	GB	0101000020E6100000D85020A2873005C0A951A3EB1DCA4B40
87360	SW7 3EE	GB	0101000020E6100000855561D80693C6BF12FB5F09FFBE4940
87361	W1H 7FD	GB	0101000020E61000005D7AEA47799CC4BF41142752F5C14940
87362	NW1 2EZ	GB	0101000020E6100000D122DBF97E6AC1BF18DD8B7967C34940
87363	WC1E 6HJ	GB	0101000020E61000007FC6942E4E13C1BF2933154AB5C24940
87364	SW1V 4BJ	GB	0101000020E610000034153D4BEBCAC1BFA07C30DFB0BE4940
87365	SW7 3DL	GB	0101000020E6100000465F419AB168C6BF4A9DDBDF34BF4940
87366	W8 6JN	GB	0101000020E6100000D2F99573CEF4C8BF99E83DDF60BF4940
87367	EX39 5TQ	GB	0101000020E6100000DE544909669911C04CB560F3BB7F4940
87368	WC2R 2PP	GB	0101000020E61000000CBDB497231ABDBFCF650F5949C14940
87369	E1W 1UN	GB	0101000020E6100000ED5921F6532DB3BF5A50734DDCC04940
87370	W2 4PX	GB	0101000020E610000010EF94698F72C8BF29498DBFA3C14940
87371	E4 6QU	GB	0101000020E6100000CFCCDDF824C185BF9F2E9CB525D04940
87372	SW1V 2BG	GB	0101000020E6100000B9C5FCDCD094C1BFE63FA4DFBEBE4940
87373	N8 7BU	GB	0101000020E61000006ADB300A82C7BDBFF90505EFF5CA4940
87374	N4 2LX	GB	0101000020E6100000DC92663DC626B9BFBA7889FBD9C84940
87375	WC1H 9JP	GB	0101000020E610000086538B2DA97FC0BF4DEF874446C34940
87376	SW7 5EN	GB	0101000020E61000000ED6A4805946C7BF5D740D8EEDBF4940
87377	NR1 1JE	GB	0101000020E610000038D1F8CFE4ECF43FD540F339774F4A40
87378	W8 5AS	GB	0101000020E6100000FEF96CD38ED1C7BF3238EFA42AC04940
87379	W4 1PR	GB	0101000020E61000009BA10271685BD0BF1FFA491009BF4940
87380	WC2H 7BL	GB	0101000020E6100000CF8F75278EF2C0BFA67F492A53C14940
87381	WC1H 9JP	GB	0101000020E610000086538B2DA97FC0BF4DEF874446C34940
87382	SW7 1LU	GB	0101000020E6100000A93693CA6F2CC6BF339875B5CBBF4940
87383	W1J 7JZ	GB	0101000020E61000003AAC1512D500C3BF9D8F21B6AAC04940
87384	W2 4NP	GB	0101000020E6100000C55E167D7FAFC8BF51A199AB8FC14940
87385	E4 7HE	GB	0101000020E610000060BD9BB8663C6BBF8F4C2C955CD04940
87386	PE30 1JS	GB	0101000020E610000057BB815DA857D93FFA916CBFC6604A40
87387	IP15 5BJ	GB	0101000020E6100000B745A37FA5A2F93F1C7FF3F9E0134A40
87388	HU1 2BX	GB	0101000020E610000065AC15F1C6D7D5BF02278007ABDE4A40
87389	EH12 5EF	GB	0101000020E610000023DBF97E6ABC09C0F0A7C64B37F94B40
87390	WC1N 1DB	GB	0101000020E610000076711B0DE02DC0BF508D976E12C34940
87391	MK16 0JA	GB	0101000020E6100000A8EF3705F22FE6BFA477D6E050064A40
87392	G3 8HN	GB	0101000020E61000006AC1D74CC82111C06F209918CFED4B40
87393	WC1H 0DG	GB	0101000020E6100000302AA913D044C0BF17B7D100DEC24940
87394	WC1H 9EU	GB	0101000020E61000001D386744696FC0BF4260E5D022C34940
87395	WA8 3UJ	GB	0101000020E61000000355489E90B205C06A053C1F54B14A40
87396	SO43 7AS	GB	0101000020E61000006EAE8DBD8644F9BFCF633E6725704940
87397	TR7 2PQ	GB	0101000020E6100000DDB2CCED214914C04155B28769354940
87398	CV37 0PY	GB	0101000020E6100000F3ED34048DA2FABF3C98C68FEE1C4A40
87399	PL19 8AQ	GB	0101000020E6100000E6577380609610C08021F5E857464940
87400	WR14 3ET	GB	0101000020E610000083B00ED8B9A302C0C5ADEFB4160E4A40
87401	IP8 3AR	GB	0101000020E610000081FD21478490F13F0F4240BE84064A40
87402	CM6 2BZ	GB	0101000020E6100000016C6192A1F5D23F3D8F452B1BF64940
87403	RH10 8XH	GB	0101000020E61000007B62D01B847FC5BFA46DDB7B21904940
87404	NG8 6AZ	GB	0101000020E610000072C10F8A8A39F3BFA15AAAF61C7E4A40
87405	SW18 1EG	GB	0101000020E610000097365EB2D8C3C8BFEB232FECE2BA4940
87406	L35 1RZ	GB	0101000020E6100000D8B969334E7F06C0C0D84DB99AB34A40
87407	WS2 8TJ	GB	0101000020E610000014AE47E17A1400C00AD7A3703D4A4A40
87408	BH20 5AL	GB	0101000020E6100000943515A276ED00C0303D39C1B9544940
87409	GY5 7HB	GB	0101000020E6100000CFDA6D179AAB04C07CF9F8DFA5BB4840
87410	TW14 9AD	GB	0101000020E6100000801C25937922DABF5BE7A58371B94940
87411	BL9 7BQ	GB	0101000020E61000000C89C5B9973502C088765FDF98CB4A40
87412	WV15 6HL	GB	0101000020E61000004CF443B63DBB02C078561C188A3B4A40
87413	BA2 4EZ	GB	0101000020E61000008565C7A1D9D002C05A50734DDCB04940
87414	LL24 0AR	GB	0101000020E6100000083BF02A9E640EC02CFB7B17198B4A40
87415	SG4 7JR	GB	0101000020E6100000DB7A3CE3B155CEBF75F574BF54F64940
87416	RG27 0AS	GB	0101000020E61000003F350301D7FAEFBFF72EEFBB33AB4940
87417	S41 7NJ	GB	0101000020E6100000954AD3FB21D1F6BF620BE654D79E4A40
87418	FK7 7XH	GB	0101000020E61000001973D712F2410FC0AC8BDB68000F4C40
87419	CT5 2BP	GB	0101000020E61000001C2AAF5D267FF03F348E26518EAE4940
87420	B16 8SJ	GB	0101000020E61000006A3DC0B625BAFEBF6F5E5D94673C4A40
87421	GL3 4SS	GB	0101000020E6100000648401953B1D01C0331D95F661EB4940
87422	CA10 3SB	GB	0101000020E61000005F2BFC7497DF04C09B38B9DFA1394B40
87423	S4 7YE	GB	0101000020E6100000F93EAD86EA5CF7BF7447E82F80B14A40
87424	G12 0UX	GB	0101000020E61000000097606E803811C0D76727B3DCF04B40
87425	SS6 7SP	GB	0101000020E6100000BC96900F7A36E33FEE5A423EE8C94940
87426	YO32 9TE	GB	0101000020E6100000EF38454772F9F0BFE9263108ACFC4A40
87427	EC1V 9LN	GB	0101000020E6100000E8D9ACFA5C6DB5BF6C09F9A067C34940
87428	LA12 8NB	GB	0101000020E6100000772CB64945C307C0E84F768E5C224B40
87429	HP4 1NS	GB	0101000020E61000003FC978EF03EBE1BFE14389963CE64940
87430	ST17 0RJ	GB	0101000020E61000001F752F882CC800C05D77C51C1C614A40
87431	BN18 9ND	GB	0101000020E6100000F1EE2111B535E1BFA785EE3940744940
87432	SW1A 2TS	GB	0101000020E6100000FCA9F1D24D62C0BF37894160E5C04940
87433	OX4 4XP	GB	0101000020E6100000F4CE577F3A54F3BF1E59541FA3DB4940
87434	BN2 1PD	GB	0101000020E61000007E2AB8697DDBC0BFDBE3E02DEB684940
87435	IP33 1LT	GB	0101000020E61000006D01A1F5F0E5E63F552305604D1F4A40
87436	SW1V 2BJ	GB	0101000020E61000007808E3A7716FC1BF7C8967BFA4BE4940
87437	AB21 7DW	GB	0101000020E6100000FBE0634DB88501C063CBF52DA8994C40
87438	WC1B 4AR	GB	0101000020E610000082734694F606BFBF43AD69DE71C24940
87439	PO15 5RJ	GB	0101000020E6100000EE5A423EE8D9F3BFA089B0E1E96D4940
87440	WC1B 5BB	GB	0101000020E6100000A8C64B378941C0BF17B7D100DEC24940
87441	TA6 6QA	GB	0101000020E61000000591AF7E181F08C025503477C38B4940
87442	B28 9ES	GB	0101000020E6100000713D0AD7A370FDBFF6285C8FC2354A40
87443	M1 6DP	GB	0101000020E61000007B49F61760E401C0EE1146C05CBD4A40
87444	CV2 2HP	GB	0101000020E610000026FE28EACCFDF6BF6C95607138374A40
87445	BN17 5RW	GB	0101000020E61000009B0CA8E65B97E2BFCDCBF91329664940
87446	EH16 5AY	GB	0101000020E610000085E40929E45F09C08F8B6A1151F84B40
87447	EH45 8BA	GB	0101000020E6100000E2E995B20C7109C0B37BF2B050D34B40
87448	NW2 1LP	GB	0101000020E61000001925D64C38A0CCBFF2BF2A5155C94940
87449	LS1 2HA	GB	0101000020E6100000D3BCE3141DC9F8BFD95F764F1EE64A40
87450	TN33 0SP	GB	0101000020E61000003332C85D84A9DE3F08A98020E5734940
87451	W1J 7BH	GB	0101000020E61000004E455AC543A1C2BF238F75ABC6C04940
87452	HD3 3RH	GB	0101000020E6100000D082AB973A43FDBF303BD56BC4D54A40
87453	CH65 2AL	GB	0101000020E61000009A79724D812C07C0813FFCFCF7A44A40
87454	CF32 8UU	GB	0101000020E61000005AD9999DA0A80CC0B6E10BEE62C74940
87455	SO17 1AQ	GB	0101000020E6100000C246FE052747F6BF31AE5D7FB7764940
87456	SE1 9HH	GB	0101000020E610000010E3DAF5775BB8BFFB912232ACC04940
87457	FY8 1NB	GB	0101000020E6100000B21CD7755E3908C035C52D3075DF4A40
87458	IV12 5ND	GB	0101000020E6100000B3356CA521440FC05793A7ACA6CA4C40
87459	DE14 2WF	GB	0101000020E6100000E3A59BC420B0FABF2041F163CC654A40
87460	TN22 2EH	GB	0101000020E61000000506FF113C74B63F34773E4D777F4940
87461	NN4 5FB	GB	0101000020E610000081B1BE81C98DECBF598638D6C5174A40
87462	AB51 5HS	GB	0101000020E610000000000000000004C048E17A14AEA74C40
87463	EH39 4LZ	GB	0101000020E610000018CC0921BAE805C0CEB9E81F95074C40
87464	SY23 4DF	GB	0101000020E6100000694C2D00325910C041DC30653B2F4A40
87465	W5 3HN	GB	0101000020E61000005D8E1F761B9ED2BFEC86D56E67C14940
87466	LS22 5HE	GB	0101000020E61000000EA4D7DB7034F6BF73710F9A41F64A40
87467	CM18 7BA	GB	0101000020E61000007F0489E37C0EC03FEAAE70BBA5E04940
87468	LS9 7TF	GB	0101000020E6100000A438471D1D57F8BFF7065F984CE74A40
87469	SK17 6BD	GB	0101000020E61000005B2ACA00AB9EFEBFC2A15CBF05A14A40
87470	PA3 2SJ	GB	0101000020E61000002D96F778EEBB11C08F58329779EE4B40
87471	BA12 9HH	GB	0101000020E61000002F138764AF3001C05C54F36B17994940
87472	EH2 2EQ	GB	0101000020E6100000A01A2FDD248609C0A7E8482EFFF94B40
87473	RM11 3UJ	GB	0101000020E61000003E556C69C1CDCD3F060CCFA185CA4940
87474	SY1 1XL	GB	0101000020E610000090696D1ADBFB05C0EF20D15F435A4A40
87475	SW1Y 6JF	GB	0101000020E610000045BCC645EDB2C1BFE996A6D3FDC04940
87476	GU46 6BT	GB	0101000020E610000010E6BD048378EABFA5397F01A7AA4940
87477	DH3 3QR	GB	0101000020E6100000D0042F9F51FFF8BF03441C469C6C4B40
87478	NE1 1RQ	GB	0101000020E6100000C4B1BC18BBC6F9BF7A494A17EE7B4B40
87479	LS1 8TL	GB	0101000020E6100000B4B7B24920BBF8BFE5BE7C8269E64A40
87480	PO18 0QB	GB	0101000020E6100000EEB15C85807BE7BFE01965E4C96E4940
87481	CV8 2LN	GB	0101000020E61000004A0C022B8716F9BF226C787AA52C4A40
87482	HR8 2EY	GB	0101000020E61000005E7C462CA66103C0CE955A5262044A40
87483	SW7 4PG	GB	0101000020E610000053944BE3175EC7BFE45938FF65BF4940
87484	NR34 9PL	GB	0101000020E6100000017B96314FF8F83F692332079C3A4A40
87485	GL54 2HS	GB	0101000020E61000002669A3DF6335FCBF26FB8CB04DF34940
87486	BT7 2JB	GB	0101000020E61000003D49BA66F2BD17C019726C3D434C4B40
87487	SP1 3TE	GB	0101000020E6100000C9E53FA4DFBEFCBF7DAEB6627F894940
87488	PO11 0NQ	GB	0101000020E61000000EBE30992A18EFBF27C286A7576A4940
87489	W2 4RT	GB	0101000020E610000097B9B92BCD83C8BF3A28EC9836C14940
87490	JE3 1JA	GB	0101000020E610000032384A5E9D2301C0716D4D5F749C4840
87491	W1H 7TW	GB	0101000020E610000065219004476DC4BFBEAE1F95F4C14940
87492	NP20 1QU	GB	0101000020E610000034120EAE9AFA07C0C74167A46ECB4940
87493	PO15 7AJ	GB	0101000020E610000011C7BAB88D06F4BF1B0DE02D90704940
87494	BN1 2FU	GB	0101000020E6100000AADB34119135C3BFD6D6FCB62F694940
87495	SG12 8LD	GB	0101000020E61000006B68C1932FCBA53F43B54C7CF1E34940
87496	GU27 2JY	GB	0101000020E6100000B57C6EB257A9E6BF1E30B4DF7F8B4940
87497	WC2B 5BZ	GB	0101000020E6100000A7AE7C96E741BFBF4BD1BD93FEC14940
87498	BA1 2QF	GB	0101000020E6100000B5A4A31CCCE602C0E262FB7F8BB14940
87499	TF3 4EH	GB	0101000020E6100000C5FFB0B4728C03C0E24E086EBB554A40
87500	EH1 2JF	GB	0101000020E61000003F3CA190CA9409C0F4B2BB7A34F94B40
87501	UB7 9NA	GB	0101000020E6100000FF21FDF675E0DCBFFF21FDF675C04940
87502	PH2 8PH	GB	0101000020E61000004C3F20511A6E0BC043FD450883324C40
87503	GU9 9RP	GB	0101000020E6100000AB9DBC23BE2EE9BF04F3469C049D4940
87504	HU14 3LG	GB	0101000020E610000046DC52BDEB22DEBF37DEC25F38DC4A40
87505	OX4 4GX	GB	0101000020E6100000BD61E25CB1B9F3BFA339E5E330DB4940
87506	BS1 6BF	GB	0101000020E61000003297639864AF04C007BC31DCB7B94940
87507	MK44 3AR	GB	0101000020E61000007E4ADFB595A8D3BFADFC321823194A40
87508	SW1P 4DD	GB	0101000020E610000018B72701972BC0BF0FE99E1223BF4940
87509	CF23 9XF	GB	0101000020E6100000079C3D81C42F09C07BA88B1903C14940
87510	B6 4BE	GB	0101000020E610000049B3C3A92030FEBFCD2445BF113F4A40
87511	G5 0TW	GB	0101000020E610000071BA1BFADD0211C04332891F08ED4B40
87512	RG20 8NJ	GB	0101000020E6100000B9AD11E7FFE2F6BF6B66F0A10BB64940
87513	OX14 1TZ	GB	0101000020E6100000C43B3F1301D9F4BF3F61B6889BD54940
87514	PE9 2AG	GB	0101000020E610000003571E49EED5DEBF0767A66A71534A40
87515	HU1 2NL	GB	0101000020E61000006BB52C04DEEED5BFB13CA30804DF4A40
87516	PO40 9PE	GB	0101000020E61000004E0B5EF41564F8BF9C19FD6838564940
87517	W1J 7BX	GB	0101000020E610000085B71B050702C3BFA082F1438DC04940
87518	PE21 8SH	GB	0101000020E61000000AFE6D0503BE99BFAAAFF897EE7C4A40
87519	NE27 0BY	GB	0101000020E61000004E612E74E82EF8BF756DBEFD38834B40
87520	G1 1DQ	GB	0101000020E6100000ACFE8CFB240111C09EB424CBFFED4B40
87521	EH3 9DE	GB	0101000020E6100000A06274F73B9B09C04E2EB996F8F84B40
87522	WR6 5JD	GB	0101000020E61000000BDA3FAABC6802C0B19F6A99B1154A40
87523	DY5 1UR	GB	0101000020E610000095D4096822EC00C012A5BDC1173E4A40
87524	NN6 7EX	GB	0101000020E61000002FDD24068195F2BF30BB270F0B2D4A40
87525	SN5 7XG	GB	0101000020E6100000EC2FBB270F0BFDBF48BF7D1D38C74940
87526	LS3 1LY	GB	0101000020E61000008C85051DCB00F9BFE22EE6DA5CE64A40
87527	CR9 5AA	GB	0101000020E61000000A3AEF398F8EB7BF1881F5DBBEAF4940
87528	AL2 3DS	GB	0101000020E610000000A6D2704664D7BFB33D03B55BDC4940
87529	WC1B 4HD	GB	0101000020E610000000F5B06197F2BFBFA9BB575293C24940
87530	OL9 8DE	GB	0101000020E6100000231718893B4401C0C0397749C9C24A40
87531	PE37 7LJ	GB	0101000020E61000005D218347E10BE63FBC5D1D6A15534A40
87532	KT16 8AP	GB	0101000020E610000079D8FAD81313E0BF3820F8CE1EB24940
87533	NP15 1SY	GB	0101000020E61000006937FA980F4807C07FFB952941DA4940
87534	NR17 1AY	GB	0101000020E610000084D89942E775EF3F674D87A9883F4A40
87535	EH3 9SR	GB	0101000020E6100000FE612A81BDAB09C0FFB5C6E430F94B40
87536	SW1X 8HQ	GB	0101000020E6100000DB9B2E77A526C4BFFB922524A6BF4940
87537	EH12 5BY	GB	0101000020E6100000F6DE40CA4DC909C040DA37AB49F94B40
87538	HP10 9YL	GB	0101000020E6100000A35FB6F86F39E6BF1F4F26C9CECD4940
87539	CT1 1TT	GB	0101000020E6100000C77834D84B58F13F9D918F7D53A34940
87540	YO1 9PL	GB	0101000020E6100000ACC5720E4839F1BF1118E1A924FA4A40
87541	BT2 7AP	GB	0101000020E6100000D4EFB864F9BD17C06612F5828F4B4B40
87542	M20 2WG	GB	0101000020E61000005C1E668D4CFC01C08ECAD6C530B54A40
87543	W1J 5HE	GB	0101000020E6100000F09838F441CFC2BF88BE0CDDE4C04940
87544	CF35 5EA	GB	0101000020E61000006AAFB2740DC80BC08AAB9A8595C14940
87545	G84 0NX	GB	0101000020E61000006F180209557713C0E193F36AA5014C40
87546	EH19 3JB	GB	0101000020E6100000BB7805C335AA08C0624EDF51F4ED4B40
87547	BT47 3QP	GB	0101000020E610000087F24FBA3E3D1DC0E91C4D3FF27E4B40
87548	WC2H 7HG	GB	0101000020E61000009A35A1DEC6C5C0BF09AE738517C14940
87549	W1H 7JW	GB	0101000020E6100000C286A757CA32C4BF8BFD65F7E4C14940
87550	E16 1AB	GB	0101000020E610000040A8E6CD3C14903F20D5B0DF13C14940
87551	WC1B 5AD	GB	0101000020E6100000759049D93194BFBF26EBB49192C24940
87552	CW12 2NH	GB	0101000020E61000008DDE5FF3609101C0B3672A1FDD974A40
87553	YO61 1UF	GB	0101000020E610000055EA7DD64195F4BF871D3DB321084B40
87554	NW3 3HP	GB	0101000020E610000031C6A6E6891FC6BFF0548D4CAAC54940
87555	RG14 1QY	GB	0101000020E6100000C7293A92CB7FF5BF23DBF97E6AB44940
87556	M4 1SH	GB	0101000020E6100000EF31F8FE7DE701C0FA7C1D03B5BD4A40
87557	CB2 1PG	GB	0101000020E6100000F2214D614A09C13F156D2E01AF184A40
87558	HA9 6BA	GB	0101000020E6100000234A7B832F4CD2BF3B014D840DC74940
87559	WC1E 6HG	GB	0101000020E6100000D6C56D3480B7C0BF18265305A3C24940
87560	YO1 6JF	GB	0101000020E61000000CC33899675EF1BF9B715CBE9CFA4A40
87561	NE1 5SX	GB	0101000020E61000003786388A37E0F9BF47898B13477C4B40
87562	SW7 5BD	GB	0101000020E610000088E06EFF80BDC6BF11D5A59075BF4940
87563	BH14 8JR	GB	0101000020E610000087E354C61A29FFBFF68E64A07C5A4940
87564	SW7 3EG	GB	0101000020E6100000855561D80693C6BF12FB5F09FFBE4940
87565	CT1 3RY	GB	0101000020E6100000C18D942D9216F13F49BA66F2CDA24940
87566	PE21 6SH	GB	0101000020E610000054359F457F0095BFF200F3E9617D4A40
87567	TS15 9PE	GB	0101000020E61000007A11120E62CCF5BF19B446F3B63E4B40
87568	M1 3LA	GB	0101000020E61000000044276F73E701C0CE2F31333FBD4A40
87569	MK40 1RW	GB	0101000020E61000000B7F28C669D0DDBFE6E2815E3E114A40
87570	G73 2AR	GB	0101000020E6100000594DB14CBADF10C0AE9225F9E5E84B40
87571	PH1 5QP	GB	0101000020E6100000266607A6E47E0BC06E719741D8324C40
87572	PH2 0LT	GB	0101000020E61000006A14D9A1769C0BC03CBEB3F95C324C40
87573	M16 0PX	GB	0101000020E61000008658952E115002C01F59D59F78BA4A40
87574	BS1 6JZ	GB	0101000020E610000014900DDC35B804C0A20460B099B94940
87575	NE61 3LL	GB	0101000020E6100000D5CA845FEA67FABF92BE5AFFF8984B40
87576	ST7 2QQ	GB	0101000020E6100000D0A39872746302C0F40A76894B8B4A40
87577	HD9 7DA	GB	0101000020E6100000939A2CA4B297FCBF6142BBF9FCC84A40
87578	LE65 2FQ	GB	0101000020E6100000D459773DE2A1F7BF87414FB9785F4A40
87579	NW1 2LW	GB	0101000020E610000022FDF675E09CC1BFEBE2361AC0C34940
87580	G84 8ES	GB	0101000020E6100000458D95DA83FB12C008F7D22D9E004C40
87581	SW3 2DB	GB	0101000020E6100000F6A32A6B70A2C5BFB7E32F2871BF4940
87582	CB8 8NB	GB	0101000020E610000090254B642105DA3FA8F019E9421F4A40
87583	BN18 0LS	GB	0101000020E61000008AF4DDD8ACADE3BF657A31B0A86C4940
87584	PE30 4NB	GB	0101000020E610000059EBD0581751DA3F0035D1C1DC5D4A40
87585	PL12 6SD	GB	0101000020E6100000321CCF67401D11C052B7B3AF3C3C4940
87586	WS15 1DY	GB	0101000020E6100000C8F2093433BEFEBF6C2796D0275F4A40
87587	WC2H 9HB	GB	0101000020E61000002063EE5A423EC0BF60E5D022DBC14940
87588	W1A 3BE	GB	0101000020E61000005D6B5CF08362C1BFAA7E0DD716C24940
87589	IV2 3LP	GB	0101000020E61000005763220804D810C028737F3755BC4C40
87590	DT1 1HF	GB	0101000020E6100000EEF17273527D03C06A9D53F1885B4940
87591	CF37 2NP	GB	0101000020E61000007F8A3E7A1E170BC037E0F3C308CE4940
87592	CF72 8ND	GB	0101000020E61000006ABC749318040BC009F9A067B3C24940
87593	OX2 7PL	GB	0101000020E61000004DAF8339304FF4BF7B41559632E44940
87594	W1G 9BL	GB	0101000020E61000009286CCF5B321C3BFE5ADDED40CC24940
87595	CO6 1DU	GB	0101000020E610000010D771C95F44E93F0E833B48B6F04940
87596	W1T 1RJ	GB	0101000020E610000063409BC18476C1BF6E90A4FF40C24940
87597	SS14 3AE	GB	0101000020E61000009AD6E515014EDC3FFA7F982ECBCA4940
87598	B2 4JQ	GB	0101000020E610000025A783B0AB65FEBFD9286246353D4A40
87599	EC1M 6AH	GB	0101000020E6100000C01EE3EFB609BABFA6E72C9FA4C24940
87600	SO41 0RF	GB	0101000020E6100000A473D9435672F9BFBA51BF66145E4940
87601	SN3 4SH	GB	0101000020E6100000214A1EC99190FBBF043B66EF78CB4940
87602	MK17 8NU	GB	0101000020E61000007823980FADBAE4BF7065E487A5014A40
87603	SW1X 9SG	GB	0101000020E61000009FCDAACFD556C4BFBA6B09F9A0BF4940
87604	SW1X 9PY	GB	0101000020E6100000D34D62105839C4BF2B8716D9CEBF4940
87605	BT1 3LP	GB	0101000020E610000003098A1F63AE17C03FC6DCB5844C4B40
87606	W1J 8LL	GB	0101000020E6100000F26CDD6DE170C2BF3B74FB5EE3C04940
87607	NG2 7RN	GB	0101000020E6100000C522E1D63856F2BF03FBF900EE764A40
87608	ST5 1HX	GB	0101000020E6100000B4E7323509BE01C050F05EFFBF814A40
87609	SE1 0JA	GB	0101000020E61000005A9E7E850979B9BF77663B0C91C04940
87610	WC1B 5BP	GB	0101000020E6100000992A1895D409C0BF3480B74082C24940
87611	GL5 2PF	GB	0101000020E6100000B6ED201BED8D01C070067FBF98DB4940
87612	DE45 1SP	GB	0101000020E6100000E391D332ADE8F9BF87A6ECF4839F4A40
87613	SY5 6QG	GB	0101000020E6100000CDE3D5DE4C7105C090DF36AEDA564A40
87614	W1J 7BJ	GB	0101000020E61000006ADE718A8EE4C2BF7F6ABC7493C04940
87615	AB24 5QH	GB	0101000020E61000003716EE3EC2B600C02D72CED661944C40
87616	CV8 3DY	GB	0101000020E6100000A491A1F3B25FF7BFE29DE1A5D22F4A40
87617	EC2R 5BJ	GB	0101000020E6100000DD17E137CF22B7BF12A27C410BC24940
87618	S7 1NQ	GB	0101000020E61000009FCCFDDD54DFF7BFF0AA2069A4AE4A40
87619	GL4 8ED	GB	0101000020E610000014AD14B62A8B01C0445EB3B5AEEA4940
87620	W1F 7HL	GB	0101000020E610000035192805EA08C2BF350F1E75CDC14940
87621	OX2 8AL	GB	0101000020E6100000A766F0A6448AF4BFC3A633CFC8E44940
87622	HG1 2SY	GB	0101000020E6100000F3A4A069F6B9F8BF8C8D92BA51FF4A40
87623	M1 7DL	GB	0101000020E61000004C37894160E501C00612143FC6BC4A40
87624	WA16 0SU	GB	0101000020E6100000F90FE9B7AF0303C03B014D840DA74A40
87625	W2 1UB	GB	0101000020E6100000870CD9B00E16C6BFC7179439FBC14940
87626	CB3 9AN	GB	0101000020E6100000BBBF4CA4CCB7BA3FFB016D7D211A4A40
87627	L22 5PR	GB	0101000020E6100000ECA353573E3B08C0FD6B79E57ABC4A40
87628	IM2 4RA	GB	0101000020E610000088F4DBD781F311C0BE9F1A2FDD144B40
87629	LS21 3NU	GB	0101000020E6100000777BABD60BE3FABFD0C49730EAF14A40
87630	HG1 2HU	GB	0101000020E61000000F7C58E4E1B9F8BF1DB9E2A08CFF4A40
87631	OX25 3QL	GB	0101000020E610000038876BB5879DF3BF78B06AB52CEE4940
87632	GL20 5RT	GB	0101000020E61000004A221776FA4401C0E167248EF1FE4940
87633	SP1 2AP	GB	0101000020E610000092DF68E81BB0FCBFA0CCC07ABC884940
87634	OX1 4PS	GB	0101000020E6100000EDE8B2AABB10F4BF85E331B7C6DE4940
87635	LS9 8AT	GB	0101000020E6100000E50D30F31D3CF8BF267156444DE64A40
87636	BT20 5ED	GB	0101000020E610000033A041B755AC16C0BA4222E4F1544B40
87637	SW7 4LH	GB	0101000020E610000043D0E58E7D57C6BF221A70A5BDBF4940
87638	WC2H 7HL	GB	0101000020E61000009A35A1DEC6C5C0BF09AE738517C14940
87639	N22 7AY	GB	0101000020E6100000B0E0230791B1C0BF627F7E8406CC4940
87640	KT13 8BQ	GB	0101000020E61000008D28ED0DBE30DDBFF241CF66D5AF4940
87641	DT11 7AJ	GB	0101000020E61000006AC02A5B475401C0F91EB92B776D4940
87642	LE1 3TE	GB	0101000020E6100000F61CA21BAB1EF2BF7102D369DD514A40
87643	CV22 6QW	GB	0101000020E6100000DEB7109A138AF4BF971A46E6362B4A40
87644	E16 1SL	GB	0101000020E61000008C2FDAE38574A03F272D019DEEC04940
87645	GL51 0TS	GB	0101000020E61000009781E905B60E01C0F73ED14CA2F24940
87646	CA28 8AA	GB	0101000020E61000006666666666A60CC051AF4AD86D454B40
87647	BH1 2BZ	GB	0101000020E61000009A3726422501FEBF8951F6E7F95B4940
87648	WC2R 2PR	GB	0101000020E6100000EA043411363CBDBFEF38454772C14940
87649	AL3 7AF	GB	0101000020E6100000DE790DBAB794DABFE28C8F86BBE44940
87650	W1U 2BE	GB	0101000020E610000098DD9387855AC3BF273108AC1CC24940
87651	RH6 0EP	GB	0101000020E6100000A49872744B61CDBF8432E8DF89944940
87652	S41 7RW	GB	0101000020E6100000091B9E5E29CBF6BF6744696FF09D4A40
87653	BT42 3LZ	GB	0101000020E6100000FAAA3999E8C818C01BA50E9CBA684B40
87654	RG18 3RP	GB	0101000020E61000002D313EE8B355F4BF4C63EB81E5B44940
87655	RH10 7ZR	GB	0101000020E61000004A099BE3D7ADC2BFA0EB6555708D4940
87656	SS14 3DG	GB	0101000020E6100000EE6FCE5D5282DD3FDE18AC7FEACA4940
87657	WD17 1RN	GB	0101000020E6100000D5AC4F135FA8D9BFCA2E2586B5D44940
87658	BA5 2RX	GB	0101000020E610000087E9BA71042D05C0874BD057B79A4940
87659	SN1 3EG	GB	0101000020E6100000C74B37894160FCBF11C7BAB88DC64940
87660	NG15 7PY	GB	0101000020E6100000FDD8243FE217F3BF7847212466834A40
87661	SA69 9NH	GB	0101000020E6100000BD186FD003CC12C05E0E6036A6DA4940
87662	CF5 2AD	GB	0101000020E61000005215AEA29AAD09C087D4FE1884BE4940
87663	CA23 3DT	GB	0101000020E6100000FAA1EB253A250CC0B25B452B29414B40
87664	NG16 3SS	GB	0101000020E6100000C3CD1E727719F5BFBBD573D23B824A40
87665	NP20 5QN	GB	0101000020E610000076C6527F18FC07C0BC1FB75F3ECD4940
87666	CV2 2ST	GB	0101000020E6100000EBC705EB28FCF6BF27E50711DD374A40
87667	CT9 2HX	GB	0101000020E61000006D72F8A41369F63F185A9D9CA1B14940
87668	SA15 4HA	GB	0101000020E6100000FE4D83FD32AB10C0C0A37CF77DD84940
87669	LA7 7NW	GB	0101000020E6100000284E49319BBB05C02CD670917B1F4B40
87670	LE15 8RP	GB	0101000020E6100000AA1069FD28C8E3BF683A7D35EE514A40
87671	RH10 9GY	GB	0101000020E610000037BF06E9CEB8C7BF4D80064081914940
87672	PR5 0UL	GB	0101000020E6100000D07DF7968BF304C08BA569CC3BE24A40
87673	SG18 9EA	GB	0101000020E61000003CAC263E2DF5D4BF3A1966B2C90A4A40
87674	S66 2SF	GB	0101000020E610000098EABD89054CF4BFC1103C358CB64A40
8767