## Copyright 2021 Intel Corporation
## SPDX-License-Identifier: Apache-2.0

set(COMPONENT_NAME benchmark)

if (INSTALL_IN_SEPARATE_DIRECTORIES)
  set(COMPONENT_PATH ${INSTALL_DIR_ABSOLUTE}/${COMPONENT_NAME})
else()
  set(COMPONENT_PATH ${INSTALL_DIR_ABSOLUTE})
endif()

ExternalProject_Add(${COMPONENT_NAME}
  URL "https://github.com/google/benchmark/archive/refs/tags/v1.8.3.zip"
  URL_HASH "SHA256=abfc22e33e3594d0edf8eaddaf4d84a2ffc491ad74b6a7edc6e7a608f690e691"

  # Skip updating on subsequent builds (faster)
  UPDATE_COMMAND ""

  DEPENDS gtest

  CMAKE_ARGS
    -DCMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE}
    -DCMAKE_INSTALL_PREFIX:PATH=${COMPONENT_PATH}
    -DBENCHMARK_ENABLE_TESTING=OFF
    -DBENCHMARK_ENABLE_GTEST_TESTS=OFF
    -DBENCHMARK_ENABLE_WERROR=OFF
    -DCMAKE_BUILD_TYPE=${DEPENDENCIES_BUILD_TYPE}
)
list(APPEND CMAKE_PREFIX_PATH ${COMPONENT_PATH})
string(REPLACE ";" "|" CMAKE_PREFIX_PATH "${CMAKE_PREFIX_PATH}")
