# --
# Kernel/Language/pl.pm - provides pl language translation
# Copyright (C) 2002-2004 Martin Edenhofer <martin at otrs.org>
# Translated by Tomasz Melissa <janek at rumianek.com>
# --
# $Id: pl.pm,v 1.13 2004/08/24 08:20:42 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::pl;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.13 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Tue Aug 24 10:11:10 2004 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 Minuty',
      ' 5 minutes' => ' 5 Minut',
      ' 7 minutes' => ' 7 Minut',
      '(Click here to add)' => '(By doda kliknij tutaj)',
      '...Back' => '',
      '10 minutes' => '10 Minut',
      '15 minutes' => '15 Minut',
      'Added User "%s"' => '',
      'AddLink' => 'Dodaj link',
      'Admin-Area' => 'Administracja',
      'agent' => 'agent',
      'Agent-Area' => 'Obsuga',
      'all' => 'wszystkie',
      'All' => 'Wszystkie',
      'Attention' => 'Uwaga',
      'Back' => 'Powrt',
      'before' => 'przedtem',
      'Bug Report' => 'Zgo bd',
      'Calendar' => '',
      'Cancel' => 'Anuluj',
      'change' => 'zmie',
      'Change' => 'Zmie',
      'change!' => 'Zmie!',
      'click here' => 'kliknij tutaj',
      'Comment' => 'Komentarz',
      'Contract' => '',
      'Crypt' => '',
      'Crypted' => '',
      'Customer' => 'Klient',
      'customer' => 'klient',
      'Customer Info' => 'Informacja o kliencie',
      'day' => 'dzie',
      'day(s)' => 'dzie(dni)',
      'days' => 'dni',
      'description' => 'opis',
      'Description' => 'Opis',
      'Directory' => '',
      'Dispatching by email To: field.' => 'Przekazywanie na podstawie pola DO:',
      'Dispatching by selected Queue.' => 'Przekazywanie na podstawie zaznaczonej kolejki.',
      'Don\'t show closed Tickets' => 'Nie pokazuj zamknitych zgosze',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nie uywaj uytkownika z UserID 1 (Konto systemowe)! Stwrz nowych uytkownikw!',
      'Done' => 'Zrobione',
      'end' => 'koniec',
      'Error' => 'Bd',
      'Example' => 'Przykad',
      'Examples' => 'Przykady',
      'Facility' => 'Uatwienie',
      'FAQ-Area' => 'Pytania i odpowiedzi (FAQ)',
      'Feature not active!' => 'Funkcja nie aktywna!',
      'go' => 'Start',
      'go!' => 'Start!',
      'Group' => 'Grupa',
      'History::AddNote' => 'Added note (%s)',
      'History::Bounce' => 'Bounced to "%s".',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Lock' => 'Locked ticket.',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::Remove' => '%s',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Unlock' => 'Unlocked ticket.',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'Hit' => 'Odsona',
      'Hits' => 'Odson',
      'hour' => 'godzina',
      'hours' => 'godz.',
      'Ignore' => 'Ignoruj',
      'invalid' => 'Niepoprawne',
      'Invalid SessionID!' => 'Niepoprawne ID Sesji!',
      'Language' => 'Jzyk',
      'Languages' => 'Jzyki',
      'last' => 'ostatnie',
      'Line' => 'Linia',
      'Lite' => 'Lekkie',
      'Login failed! Your username or password was entered incorrectly.' => 'Logowanie niepoprawne! Twj uytkownik lub haso zostay wpisane niepoprawnie.',
      'Logout successful. Thank you for using OTRS!' => 'Wylogowanie zakoczone! Dzikujemy za uywanie OTRS!',
      'Message' => 'Wiadomo',
      'minute' => 'minuta',
      'minutes' => 'min.',
      'Module' => 'Modu',
      'Modulefile' => 'Plik Moduu',
      'month(s)' => 'miesic(-cy)',
      'Name' => 'Nazwa',
      'New Article' => 'Nowy artyku',
      'New message' => 'Nowa wiadomo',
      'New message!' => 'Nowa wiadomo!',
      'Next' => '',
      'Next...' => '',
      'No' => 'Nie',
      'no' => 'nie',
      'No entry found!' => 'Nic nie odnaleziono!',
      'No Permission!' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => '',
      'No suggestions' => 'Brak podpowiedzi',
      'none' => 'brak danych',
      'none - answered' => 'brak - odpowiedziane',
      'none!' => 'brak!',
      'Normal' => 'Normalne',
      'off' => 'wyczone',
      'Off' => 'Wyczone',
      'On' => 'Wczone',
      'on' => 'wczone',
      'Online Agent: %s' => '',
      'Online Customer: %s' => '',
      'Password' => 'Haso',
      'Passwords dosn\'t match! Please try it again!' => '',
      'Pending till' => 'Oczekuje do',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosz odpowiedz na to zgoszenie, by mc powroci do zwykego widoku kolejki zgosze!',
      'Please contact your admin' => 'Skontaktuj si z Administratorem',
      'please do not edit!' => 'nie edytowa!',
      'possible' => 'moliwe',
      'Preview' => 'Podgld',
      'QueueView' => 'Podgld kolejki',
      'reject' => 'odrzu',
      'replace with' => 'zamie z',
      'Reset' => 'Resetuj',
      'Salutation' => 'Zwrot grzecznociowy',
      'Session has timed out. Please log in again.' => 'Sesja wygasa. Zaloguj si ponownie',
      'Show closed Tickets' => 'Poka zamknite zgoszenia',
      'Sign' => '',
      'Signature' => 'Podpis',
      'Signed' => '',
      'Size' => '',
      'Sorry' => 'Przykro mi',
      'Stats' => 'Statystyki',
      'Subfunction' => 'Funkcja podrzdna',
      'submit' => 'akceptuj',
      'submit!' => 'akceptuj!',
      'system' => 'System',
      'Take this Customer' => '',
      'Take this User' => 'Uyj tego uytkownika',
      'Text' => 'Tre',
      'The recommended charset for your language is %s!' => 'Sugerowane kodowanie dla Twojego jzyka to %s!',
      'Theme' => 'Schemat',
      'There is no account with that login name.' => 'Nie istnieje konto z takim loginem.',
      'Ticket Number' => '',
      'Timeover' => 'Timeover',
      'To: (%s) replaced with database email!' => 'DO: (%s) zamienione z adresem email z bazy danych',
      'top' => 'gra',
      'Type' => 'Typ',
      'update' => 'uaktualnij',
      'Update' => 'Uaktualnij',
      'update!' => 'uaktualnij!',
      'Upload' => '',
      'User' => 'Uytkownik',
      'Username' => 'Nazwa uytkownika',
      'Valid' => 'Zastosowanie',
      'Warning' => 'Ostrzeenie',
      'week(s)' => 'tydzie(tygodnie)',
      'Welcome to OTRS' => 'Witamy w OTRS',
      'Word' => 'Sowo',
      'wrote' => 'napisa',
      'year(s)' => 'rok(lat)',
      'Yes' => 'Tak',
      'yes' => 'tak',
      'You got new message!' => 'Masz now wiadomo!',
      'You have %s new message(s)!' => 'Masz %s nowych wiadomoci!',
      'You have %s reminder ticket(s)!' => 'Masz %s przypomnie o zgoszeniach!',

    # Template: AAAMonth
      'Apr' => 'Kwi',
      'Aug' => 'Sie',
      'Dec' => 'Gru',
      'Feb' => 'Lut',
      'Jan' => 'Sty',
      'Jul' => 'Lip',
      'Jun' => 'Cze',
      'Mar' => 'Mar',
      'May' => 'Maj',
      'Nov' => 'Lis',
      'Oct' => 'Pa',
      'Sep' => 'Wrz',

    # Template: AAAPreferences
      'Closed Tickets' => 'Zamknite zgoszenia',
      'CreateTicket' => '',
      'Custom Queue' => 'Kolejka modyfikowana',
      'Follow up notification' => 'Powiadomienie o odpowiedzi',
      'Frontend' => 'Interfejs',
      'Mail Management' => 'Zarzdzanie poczt',
      'Max. shown Tickets a page in Overview.' => 'Limit pokazywanych zgosze na stronie Podsumowania',
      'Max. shown Tickets a page in QueueView.' => 'Limit pokazywanych zgosze na stronie Podgldu Kolejki',
      'Move notification' => 'Powiadomienie o przesuniciu',
      'New ticket notification' => 'Powiadomienie o nowym zgoszeniu',
      'Other Options' => 'Inne opcje',
      'PhoneView' => 'Nowy telefon',
      'Preferences updated successfully!' => 'Ustawienia zapisano pomylnie!',
      'QueueView refresh time' => 'Okres odwierzania Podgldu Kolejki',
      'Screen after new ticket' => 'Ekran po nowym zgoszeniu',
      'Select your default spelling dictionary.' => 'Wybierz domylny sownik.',
      'Select your frontend Charset.' => 'Wybierz kodowanie.',
      'Select your frontend language.' => 'Wybierz jzyk.',
      'Select your frontend QueueView.' => 'Wybierz Podgld Kolejki.',
      'Select your frontend Theme.' => 'Wybierz schemat wygldu systemu.',
      'Select your QueueView refresh time.' => 'Wybierz okres odwierzania Podgldu Kolejki.',
      'Select your screen after creating a new ticket.' => 'Wybierz ekran, ktry pokae si po rejestracji nowego zgoszenia',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Wylij mi wiadomo, gdy klient odpowie na zgoszenie, ktrego ja jestem wacicielem.',
      'Send me a notification if a ticket is moved into one of "My Queues".' => '',
      'Send me a notification if a ticket is unlocked by the system.' => 'Wylij mi wiadomo, gdy zgoszenie zostanie odblokowane przez system.',
      'Send me a notification if there is a new ticket in "My Queues".' => '',
      'Show closed tickets.' => 'Poka zamknite zgoszenia.',
      'Spelling Dictionary' => 'Sownik pisowni',
      'Ticket lock timeout notification' => 'Powiadomienie o przekroczonym czasie blokady zgoszenia',
      'TicketZoom' => 'Podgld zgoszenia',

    # Template: AAATicket
      '1 very low' => '1 bardzo niski',
      '2 low' => '2 niski',
      '3 normal' => '3 normalny',
      '4 high' => '4 wysoki',
      '5 very high' => '5 bardzo wysoki',
      'Action' => 'Akcja',
      'Age' => 'Wiek',
      'Article' => 'Artyku',
      'Attachment' => 'Zacznik',
      'Attachments' => 'Zaczniki',
      'Bcc' => 'Bcc',
      'Bounce' => 'Odbij',
      'Cc' => 'Cc',
      'Close' => 'Zamknij',
      'closed' => '',
      'closed successful' => 'zamknite z powodzeniem',
      'closed unsuccessful' => 'zamknite bez powodzenia',
      'Compose' => 'Stwrz',
      'Created' => 'Utworzone',
      'Createtime' => 'Utworzone o',
      'email' => 'e-mail',
      'eMail' => 'E-Mail',
      'email-external' => 'e-mail zewntrzny',
      'email-internal' => 'e-mail wewntrzny',
      'Forward' => 'Przelij dalej',
      'From' => 'Od',
      'high' => 'wysoki',
      'History' => 'Historia',
      'If it is not displayed correctly,' => 'Jeli nie jest wywietlane poprawnie,',
      'lock' => 'zablokowane',
      'Lock' => 'Zablokowane',
      'low' => 'niski',
      'Move' => 'Przesu',
      'new' => 'nowe',
      'normal' => 'normalny',
      'note-external' => 'Notatka zewntrzna',
      'note-internal' => 'Notatka wewntrzna',
      'note-report' => 'Notatka raportujaca',
      'open' => 'otwarte',
      'Owner' => 'Waciciel',
      'Pending' => 'Oczekujce',
      'pending auto close+' => 'oczekujce na automatyczne zamknicie+',
      'pending auto close-' => 'oczekujce na automatyczne zamknicie-',
      'pending reminder' => 'oczekujce przypomnienie',
      'phone' => 'telefon',
      'plain' => 'bez formatowania',
      'Priority' => 'Priorytet',
      'Queue' => 'Kolejka',
      'removed' => 'usunite',
      'Sender' => 'Nadawca',
      'sms' => 'SMS',
      'State' => 'Status',
      'Subject' => 'Temat',
      'This is a' => 'To jest',
      'This is a HTML email. Click here to show it.' => 'To jest e-mail w formacie HTML. Kliknij tutaj, by go przeczyta.',
      'This message was written in a character set other than your own.' => 'Ta wiadomo zostaa napisana z uyciem kodowania znakw innego ni Twj.',
      'Ticket' => 'Zgoszenie',
      'Ticket "%s" created!' => 'Zgoszenie "%s" utworzone!',
      'To' => 'Do',
      'to open it in a new window.' => 'by otworzy w oddzielnym oknie',
      'Unlock' => 'Odblokuj',
      'unlock' => 'odblokuj',
      'very high' => 'bardzo wysoki',
      'very low' => 'bardzo niski',
      'View' => 'Widok',
      'webrequest' => 'zgoszenie z WWW',
      'Zoom' => 'Podgld',

    # Template: AAAWeekDay
      'Fri' => 'Ptk',
      'Mon' => 'Pnd',
      'Sat' => 'Sob',
      'Sun' => 'Ndz',
      'Thu' => 'Czw',
      'Tue' => 'Wtr',
      'Wed' => 'rd',

    # Template: AdminAttachmentForm
      'Add' => 'Dodaj',
      'Attachment Management' => 'Konfiguracja zacznikw',

    # Template: AdminAutoResponseForm
      'Auto Response From' => 'Automatyczna odpowied Od',
      'Auto Response Management' => 'Konfiguracja automatycznych odpowiedzi',
      'Note' => 'Uwagi',
      'Response' => 'Odpowied',
      'to get the first 20 character of the subject' => 'by wstawi pierwsze 20 znakw tematu',
      'to get the first 5 lines of the email' => 'by wstawi 5 pierwszych linii wiadomoci',
      'to get the from line of the email' => 'by wstawi pole Od wiadomoci',
      'to get the realname of the sender (if given)' => 'by wstawi prawdziwe imi i nazwisko klienta (jeli podano)',
      'to get the ticket id of the ticket' => 'by wstawi ID zgoszenia',
      'to get the ticket number of the ticket' => 'by wstawi numer zgoszenia',
      'Useable options' => 'Uyteczne opcje',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Konfiguracja uytkownikw',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => '',
      'Result' => '',
      'Search' => 'Szukaj',
      'Search for' => '',
      'Select Source (for add)' => '',
      'Source' => 'rdo',
      'The message being composed has been closed.  Exiting.' => 'Wiadomo edytowana zostaa zamknita.  Wychodz.',
      'This values are read only.' => '',
      'This values are required.' => '',
      'This window must be called from compose window' => 'To okno musi zosta wywoane z okna edycji',

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'Zmie %s ustawienia',
      'Customer User <-> Group Management' => 'Klient <-> Konfiguracja Grup',
      'Full read and write access to the tickets in this group/queue.' => 'Prawa penego odczytu i zapisu zgosze w tej grupie/kolejce',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Jeli nic nie zaznaczono, wtedy uytkownik nie bdzie mia praw w tej grupie (zgoszenia bd niedostpne)',
      'Permission' => 'Prawo dostpu',
      'Read only access to the ticket in this group/queue.' => 'Prawo jedynie do odczytu zgosze w tej grupie/kolejce',
      'ro' => 'ro',
      'rw' => 'rw',
      'Select the user:group permissions.' => 'Wybierz prawa dostpu dla uytkownika:grupy',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Zmie uytkownika <-> Ustawienia grupy',

    # Template: AdminEmail
      'Admin-Email' => 'Wiadomo od Administratora',
      'Body' => 'Tre',
      'OTRS-Admin Info!' => 'Informacja od Administratora OTRS!',
      'Recipents' => 'Adresaci',
      'send' => 'wylij',

    # Template: AdminEmailSent
      'Message sent to' => 'Wiadomo wysana do',

    # Template: AdminGenericAgent
      '(e. g. 10*5155 or 105658*)' => '(np. 10*5155 lub 105658*)',
      '(e. g. 234321)' => '(np. 3242442)',
      '(e. g. U5150)' => '(np. U4543)',
      '-' => '',
      'Add Note' => 'Dodaj notatk',
      'Agent' => 'Agent',
      'and' => 'i',
      'CMD' => '',
      'Customer User Login' => 'Login Klienta',
      'CustomerID' => 'ID klienta',
      'CustomerUser' => 'Klient',
      'Days' => '',
      'Delete' => 'Kasuj',
      'Delete tickets' => '',
      'Edit' => 'Edytuj',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Przeszukiwanie penotekstowe w artykule (np. "Ja*k" lub "Rumia*)',
      'GenericAgent' => '',
      'Hours' => '',
      'Job-List' => '',
      'Jobs' => '',
      'Last run' => '',
      'Minutes' => '',
      'Modules' => '',
      'New Agent' => '',
      'New Customer' => '',
      'New Owner' => 'Nowy waciciel',
      'New Priority' => '',
      'New Queue' => 'Nowa kolejka',
      'New State' => '',
      'New Ticket Lock' => '',
      'No time settings.' => 'Brak ustawie czasu',
      'Param 1' => '',
      'Param 2' => '',
      'Param 3' => '',
      'Param 4' => '',
      'Param 5' => '',
      'Param 6' => '',
      'Save' => '',
      'Save Job as?' => '',
      'Schedule' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
      'Ticket created' => 'Zgoszenie utworzone',
      'Ticket created between' => 'Zgoszenie utworzone midzy',
      'Ticket Lock' => '',
      'TicketFreeText' => 'Dodatkowe informacje o zgoszeniu',
      'Times' => 'Razy',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => '',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Stwrz nowe grupy, by mc efektywniej zarzdza dostpem do zgosze rnych grup uytkownikow (np. Serwisu, Sprzeday itp...).',
      'Group Management' => 'Zarzdzanie grupami',
      'It\'s useful for ASP solutions.' => 'Pomocne w rozwizanich ASP.',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Grupa Admin pozwala posiada prawa Administracji systemem. Grupa Stats umoliwia przegldanie statystyk zgosze.',

    # Template: AdminLog
      'System Log' => 'Log Systemu',
      'Time' => '',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Email od Admina',
      'Attachment <-> Response' => 'Zacznik <-> Odpowied',
      'Auto Response <-> Queue' => 'AutoOdpowied <-> Kolejka',
      'Auto Responses' => 'AutoOdpowiedzi',
      'Customer User' => 'Klienci',
      'Customer User <-> Groups' => 'Klienci <-> Grupy',
      'Email Addresses' => 'Adresy email',
      'Groups' => 'Grupy',
      'Logout' => 'Wyloguj',
      'Misc' => 'Rne',
      'Notifications' => 'Powiadomienia',
      'PGP Keys' => '',
      'PostMaster Filter' => 'Filtr PostMaster',
      'PostMaster POP3 Account' => 'Konto pocztowe POP3 - PostMaster',
      'Responses' => 'Odpowiedzi',
      'Responses <-> Queue' => 'Odpowiedzi <-> Kolejka',
      'Role' => '',
      'Role <-> Group' => '',
      'Role <-> User' => '',
      'Roles' => '',
      'Select Box' => 'Zapytanie SQL',
      'Session Management' => 'Zarzdzanie sesjami',
      'SMIME Certificates' => '',
      'Status' => 'Status',
      'System' => 'System',
      'User <-> Groups' => 'Uytkownik <-> Grupy',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opcje konfiguracyjne (np. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Notification Management' => 'Konfiguracja Powiadomie',
      'Notifications are sent to an agent or a customer.' => 'Powiadomienia s wysyane do agenta obsugi lub klienta',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opcje aktualnego klienta (np. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcje aktualnego agenta obsugi (np. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opcje dotyczce waciciela zgoszenia (np. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',

    # Template: AdminPGPForm
      'Bit' => '',
      'Expires' => '',
      'File' => '',
      'Fingerprint' => '',
      'FIXME: WHAT IS PGP?' => '',
      'Identifier' => '',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'Key' => 'Klucz',
      'PGP Key Management' => '',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Wszystkie przychodzce na jedno konto wiadomoci bd umieszczone w zaznacznej kolejce!',
      'Dispatching' => 'Przekazanie',
      'Host' => 'Host',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',
      'POP3 Account Management' => 'Konfiguracja kont POP3',
      'Trusted' => 'Zaufane',

    # Template: AdminPostMasterFilter
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
      'Filtername' => '',
      'Header' => '',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',
      'Match' => 'Odpowiada',
      'PostMaster Filter Management' => '',
      'Set' => 'Ustaw',
      'Value' => 'Warto',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Kolejka <-> Konfiguracja AutoOdpowiedzi',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = brak eskalacji',
      '0 = no unlock' => '0 = bez odblokowania',
      'Customer Move Notify' => 'Powiadomienie klienta o przesuniciu',
      'Customer Owner Notify' => 'Powiadomienie klienta o zmianie waciciela',
      'Customer State Notify' => 'Powiadomienie klienta o zmianie statusu',
      'Escalation time' => 'Czas eskalacji',
      'Follow up Option' => 'Opcja Follow Up',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Jeli zgoszenie byo zamknite, a klient przyle do niego kolejn odpowied, wtedy zgoszenie zostanie zablokowane w kolejce starego waciciela.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Jeli, w podanym czasie, nie zostanie udzielona odpowied na zgoszenie, wtedy tylko to zgoszenie bdzie widoczne w kolejce.',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Jeli agent zablokuje zgoszenie, a nastpnie nie odpowie na nie w cigu wskazanego czasu, wtedy zgoszenie zostanie automatycznie odblokowane. Dziki temu pozostali agenci bd mogli je zobaczy.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'System wyle powiadomienie do klienta, gdy zgoszenie zostanie przesunite do innej kolejki.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie waciciel zgoszenia.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie status zgoszenia.',
      'Queue Management' => 'Konfiguracja kolejek',
      'Sub-Queue of' => 'Kolejka podrzdna',
      'Systemaddress' => 'Adres systemowy',
      'The salutation for email answers.' => 'Zwrot grzecznociowy dla odpowiedzi emailowych.',
      'The signature for email answers.' => 'Podpis dla odpowiedzi emailowych.',
      'Ticket lock after a follow up' => 'Zgoszenie zablokowane po odpowiedzi (Follow Up)',
      'Unlock timeout' => 'Limit czasowy odblokowania',
      'Will be the sender address of this queue for email answers.' => 'Bdzie adresem nadawcy odpowiedzi emailowych wysyanych z tej kolejki.',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Standardowe odpowiedzi <-> Konfiguracja kolejek',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Odpowied',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Standardowe odpowiedzi <-> Konfiguracja standardowych zacznikw',

    # Template: AdminResponseAttachmentForm

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Odpowied to domylny tekst wstawiany do odpowiedzi klientowi, dziki czemu agent moe szybciej odpowiedzie na zgoszenie.',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'Don\'t forget to add a new response a queue!' => 'Nie zapomnij powiza nowej odpowiedzi z jak kolejk!',
      'Next state' => 'Nastpny status',
      'Response Management' => 'Konfiguracja Odpowiedzi',
      'The current ticket state is' => 'Aktualny status zgoszenia to',
      'Your email address is new' => '',

    # Template: AdminRoleForm
      'Create a role and put groups in it. Then add the role to the users.' => '',
      'It\'s useful for a lot of users and groups.' => '',
      'Role Management' => '',

    # Template: AdminRoleGroupChangeForm
      'create' => 'utwrz',
      'move_into' => 'przesu do',
      'owner' => 'waciciel',
      'Permissions to change the ticket owner in this group/queue.' => 'Uprawnienia do zmiany waciciela zgoszenia w tej grupie/kolejce',
      'Permissions to change the ticket priority in this group/queue.' => 'Uprawnienia do zmiany priorytetu zgoszenia w tej grupie/kolejce',
      'Permissions to create tickets in this group/queue.' => 'Uprawnienia do tworzenia zgosze w tej grupie/kolejce',
      'Permissions to move tickets into this group/queue.' => 'Uprawnienia do przesuwania zgosze do tej grupy/kolejki',
      'priority' => 'priorytet',
      'Role <-> Group Management' => '',

    # Template: AdminRoleGroupForm
      'Change role <-> group settings' => '',

    # Template: AdminRoleUserChangeForm
      'Active' => '',
      'Role <-> User Management' => '',
      'Select the role:user relations.' => '',

    # Template: AdminRoleUserForm
      'Change user <-> role settings' => '',

    # Template: AdminSMIMEForm
      'Add Certificate' => '',
      'Add Private Key' => '',
      'FIXME: WHAT IS SMIME?' => '',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => '',
      'Secret' => '',
      'SMIME Certificate Management' => '',

    # Template: AdminSalutationForm
      'customer realname' => 'Prawdziwe dane klienta',
      'for agent firstname' => 'dla imienia agenta',
      'for agent lastname' => 'dla nazwiska agenta',
      'for agent login' => 'dla loginu agenta',
      'for agent user id' => 'dla ID uytkownika agenta',
      'Salutation Management' => 'Konfiguracja zwrotw grzecznociowych',

    # Template: AdminSelectBoxForm
      'Limit' => 'Limit',
      'SQL' => 'SQL',

    # Template: AdminSelectBoxResult
      'Select Box Result' => 'Wyniki Zapytania',

    # Template: AdminSession
      'kill all sessions' => 'Zamknij wszystkie sesje',
      'kill session' => 'Zamknij sesj',
      'Overview' => 'Podsumowanie',
      'Session' => '',
      'Sessions' => 'Sesje',
      'Uniq' => 'Unikalne',

    # Template: AdminSignatureForm
      'Signature Management' => 'Konfiguracja podpisw',

    # Template: AdminStateForm
      'See also' => 'Zobacz take',
      'State Type' => 'Typ statusu',
      'System State Management' => 'Konfiguracja statusw',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Pamitaj, by auktualni rwnie domylne statusy w pliku Kernel/Config.pm !',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Wszystkie wiadomoci przysane na ten adres w polu (Do:) zostan umieszczone w tej kolejce.',
      'Email' => 'E-Mail',
      'Realname' => 'Prawdziwe Imi i Nazwisko',
      'System Email Addresses Management' => 'Konfiguracja adresw email Systemu',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'Nie zapomnij doda uytkownika do grup!',
      'Firstname' => 'Imi',
      'Lastname' => 'Nazwisko',
      'User Management' => 'Zarzdzanie Uytkownikami',
      'User will be needed to handle tickets.' => 'Uytkownik bdzie niezbdny do obsugi zgoszenia.',

    # Template: AdminUserGroupChangeForm
      'User <-> Group Management' => 'Uytkownik <-> Zarzdzanie grupami',

    # Template: AdminUserGroupForm

    # Template: AgentBook
      'Address Book' => 'Ksika adresowa',
      'Discard all changes and return to the compose screen' => 'Anuluj wszystkie zmiany i powr do ekranu edycji',
      'Return to the compose screen' => 'Powr do ekranu edycji',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Wiadomo musi zawiera wypenione adresem polu Do: (odbiorca)!',
      'Bounce ticket' => 'Odbij zgoszenie',
      'Bounce to' => 'Odbij do',
      'Inform sender' => 'Powiadom nadawc',
      'Next ticket state' => 'Nastpny status zgoszenia',
      'Send mail!' => 'Wylij wiadomo!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'W polu Do: musi znale si adres email (np. klient@przyklad.pl)!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Twoja wiadomo o numerze zgoszenia: "<OTRS_TICKET>" zostaa przekazana na adres "<OTRS_BOUNCE_TO>" . Prosimy kontaktowa si pod tym adresem we wszystkich sprawach dotyczcych tego zgoszenia.',

    # Template: AgentBulk
      '$Text{"Note!' => '',
      'A message should have a subject!' => 'Wiadomosc powinna posiada temat!',
      'Note type' => 'Typ notatki',
      'Note!' => 'Notatka!',
      'Options' => 'Opcje',
      'Spell Check' => 'Sprawd poprawno',
      'Ticket Bulk Action' => '',

    # Template: AgentClose
      ' (work units)' => ' (jednostek roboczych)',
      'A message should have a body!' => 'Wiadomo powinna zawiera jak tre!',
      'Close ticket' => 'Zamknij zgoszenie',
      'Close type' => 'Typ zamknicia',
      'Close!' => 'Zamknij!',
      'Note Text' => 'Tekst notatki',
      'Time units' => 'Jednostek czasu',
      'You need to account time!' => 'Musisz zaraportowa czas!',

    # Template: AgentCompose
      'A message must be spell checked!' => 'Wiadomo musi zosta sprawdzona sownikiem!',
      'Attach' => 'Wstaw',
      'Compose answer for ticket' => 'Edytuj odpowied na zgoszenie',
      'for pending* states' => 'dla statusw "oczekujcych" z pola powyej',
      'Is the ticket answered' => 'Czy na zgoszenie udzielono odpowiedzi',
      'Pending Date' => 'Termin wyznaczony',

    # Template: AgentCrypt

    # Template: AgentCustomer
      'Change customer of ticket' => 'Zmie klienta dla zgoszenia',
      'Search Customer' => 'Szukaj klienta',
      'Set customer user and customer id of a ticket' => 'Wska klienta i ID klienta dla zgoszenia',

    # Template: AgentCustomerHistory
      'All customer tickets.' => 'Wszystkie zgoszenia klienta',
      'Customer history' => 'Historia klienta',

    # Template: AgentCustomerMessage
      'Follow up' => 'Odpowiedz',

    # Template: AgentCustomerView
      'Customer Data' => 'Dane klienta',

    # Template: AgentEmailNew
      'All Agents' => 'Wszyscy agenci',
      'Clear To' => '',
      'Compose Email' => 'Nowa wiadomo',
      'new ticket' => 'Nowe zgoszenie',

    # Template: AgentForward
      'Article type' => 'Typ artykuu',
      'Date' => 'Data',
      'End forwarded message' => 'Koniec przekazywanej wiadomoci',
      'Forward article of ticket' => 'Przeka artyku zgoszenia',
      'Forwarded message from' => 'Wiadomo przekazana przez',
      'Reply-To' => 'Odpowied do',

    # Template: AgentFreeText
      'Change free text of ticket' => 'Dodaj lub zmie dodatkowe informacje o zgoszeniu',

    # Template: AgentHistoryForm
      'History of' => 'Historia',

    # Template: AgentHistoryRow

    # Template: AgentInfo
      'Info' => 'Info',

    # Template: AgentLookup
      'Lookup' => '',

    # Template: AgentMailboxNavBar
      'All messages' => 'Wszystkie wiadomoci',
      'down' => 'd',
      'Mailbox' => 'Skrzynka',
      'New' => 'Nowe',
      'New messages' => 'Nowe wiadomoci',
      'Open' => 'Otwarte',
      'Open messages' => 'Otwarte wiadomoci',
      'Order' => 'Porzdek',
      'Pending messages' => 'Oczekujce wiadomoci',
      'Reminder' => 'Przypomnienie',
      'Reminder messages' => 'Tekst przypomnienia',
      'Sort by' => 'Sortuj wedug',
      'Tickets' => 'Zgloszenia',
      'up' => 'gra',

    # Template: AgentMailboxTicket
      '"}' => '',
      '"}","14' => '',
      'Add a note to this ticket!' => '',
      'Change the ticket customer!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket priority!' => '',
      'Close this ticket!' => '',
      'Shows the detail view of this ticket!' => '',
      'Unlock this ticket!' => '',

    # Template: AgentMove
      'Move Ticket' => 'Przesu zgoszenie',
      'Previous Owner' => 'Poprzedni waciciel',
      'Queue ID' => 'ID Kolejki',

    # Template: AgentNavigationBar
      'Agent Preferences' => '',
      'Bulk Action' => '',
      'Bulk Actions on Tickets' => '',
      'Create new Email Ticket' => '',
      'Create new Phone Ticket' => '',
      'Email-Ticket' => '',
      'Locked tickets' => 'zablokowane zgoszenia',
      'new message' => 'nowe wiadomoci',
      'Overview of all open Tickets' => '',
      'Phone-Ticket' => '',
      'Preferences' => 'Ustawienia',
      'Search Tickets' => '',
      'Ticket selected for bulk action!' => '',
      'You need min. one selected Ticket!' => '',

    # Template: AgentNote
      'Add note to ticket' => 'Dodaj notatk do zgoszenia',

    # Template: AgentOwner
      'Change owner of ticket' => 'Zmie waciciela zgoszenia',
      'Message for new Owner' => 'Wiadomo do nowego waciciela',

    # Template: AgentPending
      'Pending date' => 'Data oczekiwania',
      'Pending type' => 'Typ oczekiwania',
      'Set Pending' => 'Ustaw oczekiwanie',

    # Template: AgentPhone
      'Phone call' => 'Telefon',

    # Template: AgentPhoneNew
      'Clear From' => 'Wyczy pole Od:',

    # Template: AgentPlain
      'ArticleID' => 'ID Artykuu',
      'Download' => '',
      'Plain' => 'Puste',
      'TicketID' => 'ID Zgoszenia',

    # Template: AgentPreferencesCustomQueue
      'My Queues' => '',
      'You also get notified about this queues via email if enabled.' => '',
      'Your queue selection of your favorite queues.' => '',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Zmie haso',
      'New password' => 'Wpisz nowe haso',
      'New password again' => 'Ponownie wpisz nowe haso',

    # Template: AgentPriority
      'Change priority of ticket' => 'Zmie priorytet zgoszenia',

    # Template: AgentSpelling
      'Apply these changes' => 'Zastosuj te zmiany',
      'Spell Checker' => 'Sownik',
      'spelling error(s)' => 'bdw jzykowych',

    # Template: AgentStatusView
      'D' => 'D',
      'of' => 'z',
      'Site' => 'Witryna',
      'sort downward' => 'sortuj malejco',
      'sort upward' => 'sortuj rosnco',
      'Ticket Status' => 'Status zgoszenia',
      'U' => 'G',

    # Template: AgentTicketLink
      'Delete Link' => '',
      'Link' => 'Link',
      'Link to' => 'Link do',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Zgoszenie zablokowane!',
      'Ticket unlock!' => 'Zgoszenie odblokowane!',

    # Template: AgentTicketPrint

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Zaraportowany czas',
      'Escalation in' => 'Eskalowane w',

    # Template: AgentUtilSearch
      'Profile' => 'Profil',
      'Result Form' => 'Formularz wynikw',
      'Save Search-Profile as Template?' => 'Zachowaj profil wyszukiwania jako szablon',
      'Search-Template' => 'Szablon wyszukiwania',
      'Select' => 'Zaznacz',
      'Ticket Search' => 'Wyszukiwanie zgoszenia',
      'Yes, save it with name' => 'Tak, zapisz to pod nazw',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Przeszukiwanie historii klienta',
      'Customer history search (e. g. "ID342425").' => 'Przeszukiwanie historii klienta (np. "ID342425").',
      'No * possible!' => 'Nie uywaj znaku "*"!',

    # Template: AgentUtilSearchResult
      'Change search options' => 'Zmie kryteria wyszukiwania',
      'Results' => 'Wyniki',
      'Search Result' => 'Wyniki wyszukiwania',
      'Total hits' => 'Wszystkich trafie',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Wszystkie zamknite zgoszenia',
      'All open tickets' => 'Wszystkie otwarte zgoszenia',
      'closed tickets' => 'zamknite zgoszenia',
      'open tickets' => 'otwarte zgoszenia',
      'or' => 'lub',
      'Provides an overview of all' => 'Pozwala podejrze wszystkie',
      'So you see what is going on in your system.' => 'Dziki temu widzisz co dzieje si w systemie.',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Napisz Odpowied (Follow Up)',
      'Your own Ticket' => 'Twoje wasne zgoszenie',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Napisz odpowied',
      'Contact customer' => 'Skontaktuj si z klientem',
      'phone call' => 'telefon',

    # Template: AgentZoomArticle
      'Split' => 'Podziel',

    # Template: AgentZoomBody
      'Change queue' => 'Zmie kolejk',

    # Template: AgentZoomHead
      'Change the ticket free fields!' => '',
      'Free Fields' => 'Dodatkowe informacje',
      'Link this ticket to an other one!' => '',
      'Lock it to work on it!' => '',
      'Print' => 'Drukuj',
      'Print this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Shows the ticket history!' => '',

    # Template: AgentZoomStatus
      '"}","18' => '',
      'Locked' => '',
      'SLA Age' => '',

    # Template: Copyright
      'printed by' => 'wydrukowane przez',

    # Template: CustomerAccept

    # Template: CustomerCreateAccount
      'Create Account' => 'Utwrz konto',
      'Login' => 'Login',

    # Template: CustomerError
      'Traceback' => 'led wstecz',

    # Template: CustomerFAQArticleHistory
      'FAQ History' => 'Historia FAQ',

    # Template: CustomerFAQArticlePrint
      'Category' => 'Kategoria',
      'Keywords' => 'Sowa kluczowe',
      'Last update' => 'Ostatnia aktualizacja',
      'Problem' => 'Problem',
      'Solution' => 'Rozwizanie',
      'Symptom' => 'Objawy',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Historia FAQ',

    # Template: CustomerFAQArticleView
      'FAQ Article' => 'Artyku FAQ',
      'Modified' => 'Zmodyfikowany',

    # Template: CustomerFAQOverview
      'FAQ Overview' => 'Podsumowanie FAQ',

    # Template: CustomerFAQSearch
      'FAQ Search' => 'Szukaj w FAQ',
      'Fulltext' => 'Penotekstowe',
      'Keyword' => 'Sowo kluczowe',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Wyniki przeszukiwania FAQ',

    # Template: CustomerFooter
      'Powered by' => 'Oparte na',

    # Template: CustomerLostPassword
      'Lost your password?' => 'Zapomniae hasa?',
      'Request new password' => 'Proba o nowe haso',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'CompanyTickets' => '',
      'Create new Ticket' => 'Utwrz nowe zgoszenie',
      'FAQ' => 'FAQ',
      'MyTickets' => '',
      'New Ticket' => 'Nowe zgoszenie',
      'Welcome %s' => 'Witaj %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView

    # Template: CustomerTicketSearch

    # Template: CustomerTicketSearchResultPrint

    # Template: CustomerTicketSearchResultShort

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Kliknij tutaj, by zgosi bd systemu OTRS!',

    # Template: FAQArticleDelete
      'FAQ Delete' => 'Skasuj artyku FAQ',
      'You really want to delete this article?' => 'Naprawd chcesz usun ten artyku FAQ?',

    # Template: FAQArticleForm
      'A article should have a title!' => '',
      'Comment (internal)' => 'Komentarz (wewntrzny)',
      'Filename' => 'Nazwa pliku',
      'Title' => '',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQArticleViewSmall

    # Template: FAQCategoryForm
      'FAQ Category' => 'Kategoria FAQ',
      'Name is required!' => '',

    # Template: FAQLanguageForm
      'FAQ Language' => 'Jzyk FAQ',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: Footer
      'Top of Page' => 'Gra strony',

    # Template: FooterSmall

    # Template: InstallerBody
      'Create Database' => 'Stwrz baz danych',
      'Drop Database' => 'Usu baz danych',
      'Finished' => 'Zakoczono',
      'System Settings' => 'Ustawienia systemu',
      'Web-Installer' => 'Instalator Web',

    # Template: InstallerFinish
      'Admin-User' => 'Administrator',
      'After doing so your OTRS is up and running.' => 'Po zakoczeniu tych czynnoci Twj system OTRS bdzie gotowy do pracy',
      'Have a lot of fun!' => 'yczymy dobrej zabawy!',
      'Restart your webserver' => 'Uruchom ponownie serwer WWW',
      'Start page' => 'Strona startowa',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Musisz wpisa nastpujce polecenie w linii komend (Terminal/Shell).',
      'Your OTRS Team' => 'Twj Team OTRS',

    # Template: InstallerLicense
      'accept license' => 'akceptuj Licencj',
      'don\'t accept license' => 'nie akceptuj Licencji',
      'License' => 'Licencja',

    # Template: InstallerStart
      'Create new database' => 'Stwrz now baz danych',
      'DB Admin Password' => 'Haso Administratora bazy danych',
      'DB Admin User' => 'Uytkownik administrujcy baz danych',
      'DB Host' => 'Host bazy danych',
      'DB Type' => 'Typ bazy danych',
      'default \'hot\'' => 'domylne \'hot\'',
      'Delete old database' => 'Usu star baz danych',
      'next step' => 'Nastpny krok',
      'OTRS DB connect host' => 'Host bazy danych',
      'OTRS DB Name' => 'Nazwa bazy danych OTRS',
      'OTRS DB Password' => 'Haso dostpu do bazy dla OTRS',
      'OTRS DB User' => 'Uytkownik bazy danych OTRS',
      'your MySQL DB should have a root password! Default is empty!' => 'Twoja baza danych MYSQL powinna mie ustawione jakie haso dla uytkownika root. Domylnie jest puste!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '',
      '(Email of the system admin)' => '(Adres E-Mail Administratora Systemu)',
      '(Full qualified domain name of your system)' => '(Pena nazwa domeny Twojego systemu FQDN)',
      '(Logfile just needed for File-LogModule!)' => '(Logfile jest potrzebny jedynie dla moduu File-Log!)',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identyfikator systemu. Wszystkie zgoszenia oraz sesje http bd zaczynay si od tego cigu)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identyfikator zgoszenia. np. \'Ticket#\', \'Call#\' lub \'MyTicket#\')',
      '(Used default language)' => '(Domylny jzyk)',
      '(Used log backend)' => '(Uywany log backend)',
      '(Used ticket number format)' => '(Uywany format numerowania zgosze)',
      'CheckMXRecord' => 'Sprawd rekord MX',
      'Default Charset' => 'Domylne kodowanie',
      'Default Language' => 'Domylny jzyk',
      'Logfile' => 'Plik logu',
      'LogModule' => 'Modu logowania',
      'Organization' => 'Organizacja',
      'System FQDN' => 'Pena domena systemu FQDN',
      'SystemID' => 'ID Systemu',
      'Ticket Hook' => 'Identyfikator zgoszenia',
      'Ticket Number Generator' => 'Generator numerw zgosze',
      'Use utf-8 it your database supports it!' => 'Uywaj kodowania UTF-8 jeli pozwala Ci na to baza danych!',
      'Webfrontend' => 'Interfejs webowy',

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Brak dostpu',

    # Template: Notify

    # Template: PrintFooter
      'URL' => 'URL',

    # Template: QueueView
      'All tickets' => 'Wszystkie zgoszenia',
      'Page' => 'Strona',
      'Queues' => 'Kolejki',
      'Tickets available' => 'Dostpne zgoszenia',
      'Tickets shown' => 'Pokazane zgoszenia',

    # Template: SystemStats

    # Template: Test
      'OTRS Test Page' => 'OTRS Strona testowa',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Eskalacja zgoszenia!',

    # Template: TicketView

    # Template: TicketViewLite

    # Template: Warning

    # Template: css
      'Home' => 'Home',

    # Template: customer-css
      'Contact' => 'Kontakt',
      'Online-Support' => 'Serwis Online',
      'Products' => 'Produkty',
      'Support' => 'Serwis',

    # Misc
      '"}","15' => '',
      '"}","30' => '',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line!)' => '(Sprawd rekordy MX dla uywanych w odpowiedziach adresw email. Nie uywaj "Sprawd rekord MX", gdy Twj system uywa poczenia Dial-Up!)',
      '(E-Mail of the system admin)' => '(Adres email Administratora)',
      'A message should have a From: recipient!' => 'Wiadomo musi zawiera wypenione pole Od: !',
      'Add auto response' => 'Dodaj automatyczn odpowied',
      'AgentFrontend' => 'Frontend Agenta',
      'Article free text' => 'Dowolny tekst artykuu',
      'Backend' => 'Backend',
      'BackendMessage' => 'Komunikat Backend',
      'Bottom of Page' => 'D strony',
      'Change Response <-> Attachment settings' => 'Zmie odpowied <-> Konfiguracja zacznikw',
      'Change answer <-> queue settings' => 'Zmie odpowied <-> Konfiguracja kolejek',
      'Change auto response settings' => 'Zmie ustawienia automatycznych odpowiedzi',
      'Charset' => 'Kodowanie',
      'Charsets' => 'Kodowania',
      'Closed' => 'Zamknite',
      'Create' => 'Utwrz',
      'Customer called' => 'Zadzwoni klient',
      'Customer user will be needed to to login via customer panels.' => 'Klient bdzie musia logowa si poprzez interfejs WWW klienta.',
      'FAQ State' => 'Status FAQ',
      'Fulltext search' => 'Przeszukiwanie penotekstowe',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Przeszukiwanie penoteksotwe (np. "Tom*sz" lub "Jane*" lub "janek+rumianek")',
      'Graphs' => 'Wykresy',
      'Handle' => 'Obsuguj (Handle)',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Jeli Twoje konto jest zaufane, zostanie uyty nagwek x-otrs (dla priorytetu...)!',
      'In Queue' => 'W kolejce',
      'Lock Ticket' => 'Zablokuj zgoszenie',
      'Max Rows' => 'Limit liczby wierszy',
      'My Tickets' => 'Moje zgoszenia',
      'New state' => 'Nowy status',
      'New ticket via call.' => 'Nowe zgoszenie telefoniczne.',
      'New user' => 'Nowy uytkownik',
      'Pending!' => 'Oczekuje!',
      'Phone call at %s' => 'Telefon: %s',
      'Please go away!' => 'Prosz zrezygnuj!',
      'PostMasterFilter Management' => 'Konfiguracja konta PostMaster',
      'Screen after new phone ticket' => 'Ekran po nowym zgoszeniu telefonicznym',
      'Search in' => 'Szukaj w',
      'Select source:' => 'Wybierz rdo:',
      'Select your custom queues' => 'Wybierz swoje kolejki',
      'Select your screen after creating a new ticket via PhoneView.' => 'Wybierz ekran, ktry pokae si po stworzeniu nowego zgoszenia telefonicznego',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Wylij mi wiadomo, gdy zgoszenie zostanie przesunite do innej kolejki.',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Wylij mi wiadomo, gdy pojawi sie nowe zgoszenie w moich kolejkach.',
      'SessionID' => 'ID Sesji',
      'Set customer id of a ticket' => 'Ustaw ID klienta dla zgoszenia',
      'Short Description' => 'Krtki opis',
      'Show all' => 'Poka wszystko',
      'System Charset Management' => 'Konfiguracja kodowania dla systemu',
      'System Language Management' => 'Konfiguracja jezyka systemu',
      'Ticket free text' => 'Dodatkowe informacje o zgoszeniu',
      'Ticket limit:' => 'Limit zgoszenia',
      'Ticket-Overview' => 'Zgloszenie - Podgld',
      'Time till escalation' => 'Czas do eskalacji',
      'Utilities' => 'Wyszukiwanie',
      'With Priority' => 'Z priorytetem',
      'With State' => 'Ze statusem',
      'You have to be in the admin group!' => 'Musisz nalee do grupy Admin!',
      'You have to be in the stats group!' => 'Musisz nalee do grupy Stats!',
      'You need a email address (e. g. customer@example.com) in From:!' => 'Musisz wpisa email (np. klient@przyklad.pl) w polu Od:!',
      'auto responses set' => 'ustawione AutoOdpowiedzi',
      'by' => 'przez',
      'invalid-temporarily' => 'Tymczasowo nieuywane',
      'search' => 'szukaj',
      'search (e. g. 10*5155 or 105658*)' => 'szukaj (np. "10*5155" lub "105658*")',
      'store' => 'Store',
      'tickets' => 'Zgoszenia',
      'valid' => 'poprawne',
    );

    # $$STOP$$

    $Self->{Translation} = \%Hash;
}
# --
1;
