# --
# Kernel/Language/pl.pm - provides pl language translation
# Copyright (C) 2001-2005 Martin Edenhofer <martin+code@otrs.org>
# Translated by Tomasz Melissa <janek at rumianek.com>
# --
# $Id: pl.pm,v 1.23 2005/10/15 12:08:12 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::pl;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.23 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Thu Jul 28 22:14:38 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Tak',
      'No' => 'Nie',
      'yes' => 'tak',
      'no' => 'nie',
      'Off' => 'Wyczone',
      'off' => 'wyczone',
      'On' => 'Wczone',
      'on' => 'wczone',
      'top' => 'gra',
      'end' => 'koniec',
      'Done' => 'Zrobione',
      'Cancel' => 'Anuluj',
      'Reset' => 'Resetuj',
      'last' => 'ostatnie',
      'before' => 'przedtem',
      'day' => 'dzie',
      'days' => 'dni',
      'day(s)' => 'dzie(dni)',
      'hour' => 'godzina',
      'hours' => 'godz.',
      'hour(s)' => '',
      'minute' => 'minuta',
      'minutes' => 'min.',
      'minute(s)' => '',
      'month' => '',
      'months' => '',
      'month(s)' => 'miesic(-cy)',
      'week' => '',
      'week(s)' => 'tydzie(tygodnie)',
      'year' => '',
      'years' => '',
      'year(s)' => 'rok(lat)',
      'wrote' => 'napisa',
      'Message' => 'Wiadomo',
      'Error' => 'Bd',
      'Bug Report' => 'Zgo bd',
      'Attention' => 'Uwaga',
      'Warning' => 'Ostrzeenie',
      'Module' => 'Modu',
      'Modulefile' => 'Plik Moduu',
      'Subfunction' => 'Funkcja podrzdna',
      'Line' => 'Linia',
      'Example' => 'Przykad',
      'Examples' => 'Przykady',
      'valid' => 'poprawne',
      'invalid' => 'Niepoprawne',
      'invalid-temporarily' => '',
      ' 2 minutes' => ' 2 Minuty',
      ' 5 minutes' => ' 5 Minut',
      ' 7 minutes' => ' 7 Minut',
      '10 minutes' => '10 Minut',
      '15 minutes' => '15 Minut',
      'Mr.' => '',
      'Mrs.' => '',
      'Next' => '',
      'Back' => 'Powrt',
      'Next...' => '',
      '...Back' => '',
      '-none-' => '',
      'none' => 'brak danych',
      'none!' => 'brak!',
      'none - answered' => 'brak - odpowiedziane',
      'please do not edit!' => 'nie edytowa!',
      'AddLink' => 'Dodaj link',
      'Link' => '',
      'Linked' => '',
      'Link (Normal)' => '',
      'Link (Parent)' => '',
      'Link (Child)' => '',
      'Normal' => 'Normalne',
      'Parent' => '',
      'Child' => '',
      'Hit' => 'Odsona',
      'Hits' => 'Odson',
      'Text' => 'Tre',
      'Lite' => 'Lekkie',
      'User' => 'Uytkownik',
      'Username' => 'Nazwa uytkownika',
      'Language' => 'Jzyk',
      'Languages' => 'Jzyki',
      'Password' => 'Haso',
      'Salutation' => 'Zwrot grzecznociowy',
      'Signature' => 'Podpis',
      'Customer' => 'Klient',
      'CustomerID' => 'ID klienta',
      'CustomerIDs' => '',
      'customer' => 'klient',
      'agent' => '',
      'system' => 'System',
      'Customer Info' => 'Informacja o kliencie',
      'go!' => 'Start!',
      'go' => 'Start',
      'All' => 'Wszystkie',
      'all' => 'wszystkie',
      'Sorry' => 'Przykro mi',
      'update!' => 'uaktualnij!',
      'update' => 'uaktualnij',
      'Update' => 'Uaktualnij',
      'submit!' => 'akceptuj!',
      'submit' => 'akceptuj',
      'Submit' => '',
      'change!' => 'Zmie!',
      'Change' => 'Zmie',
      'change' => 'zmie',
      'click here' => 'kliknij tutaj',
      'Comment' => 'Komentarz',
      'Valid' => 'Zastosowanie',
      'Invalid Option!' => '',
      'Invalid time!' => '',
      'Invalid date!' => '',
      'Name' => 'Nazwa',
      'Group' => 'Grupa',
      'Description' => 'Opis',
      'description' => 'opis',
      'Theme' => 'Schemat',
      'Created' => 'Utworzone',
      'Created by' => '',
      'Changed' => '',
      'Changed by' => '',
      'Search' => 'Szukaj',
      'and' => 'i',
      'between' => '',
      'Fulltext Search' => '',
      'Data' => '',
      'Options' => 'Opcje',
      'Title' => '',
      'Item' => '',
      'Delete' => 'Kasuj',
      'Edit' => 'Edytuj',
      'View' => 'Widok',
      'Number' => '',
      'System' => '',
      'Contact' => 'Kontakt',
      'Contacts' => '',
      'Export' => '',
      'Up' => '',
      'Down' => '',
      'Add' => 'Dodaj',
      'Category' => 'Kategoria',
      'Viewer' => '',
      'New message' => 'Nowa wiadomo',
      'New message!' => 'Nowa wiadomo!',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosz odpowiedz na to zgoszenie, by mc powroci do zwykego widoku kolejki zgosze!',
      'You got new message!' => 'Masz now wiadomo!',
      'You have %s new message(s)!' => 'Masz %s nowych wiadomoci!',
      'You have %s reminder ticket(s)!' => 'Masz %s przypomnie o zgoszeniach!',
      'The recommended charset for your language is %s!' => 'Sugerowane kodowanie dla Twojego jzyka to %s!',
      'Passwords dosn\'t match! Please try it again!' => '',
      'Password is already in use! Please use an other password!' => '',
      'Password is already used! Please use an other password!' => '',
      'You need to activate %s first to use it!' => '',
      'No suggestions' => 'Brak podpowiedzi',
      'Word' => 'Sowo',
      'Ignore' => 'Ignoruj',
      'replace with' => 'zamie z',
      'Welcome to OTRS' => 'Witamy w OTRS',
      'There is no account with that login name.' => 'Nie istnieje konto z takim loginem.',
      'Login failed! Your username or password was entered incorrectly.' => 'Logowanie niepoprawne! Twj uytkownik lub haso zostay wpisane niepoprawnie.',
      'Please contact your admin' => 'Skontaktuj si z Administratorem',
      'Logout successful. Thank you for using OTRS!' => 'Wylogowanie zakoczone! Dzikujemy za uywanie OTRS!',
      'Invalid SessionID!' => 'Niepoprawne ID Sesji!',
      'Feature not active!' => 'Funkcja nie aktywna!',
      'Take this Customer' => '',
      'Take this User' => 'Uyj tego uytkownika',
      'possible' => 'moliwe',
      'reject' => 'odrzu',
      'Facility' => 'Uatwienie',
      'Timeover' => '',
      'Pending till' => 'Oczekuje do',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nie uywaj uytkownika z UserID 1 (Konto systemowe)! Stwrz nowych uytkownikw!',
      'Dispatching by email To: field.' => 'Przekazywanie na podstawie pola DO:',
      'Dispatching by selected Queue.' => 'Przekazywanie na podstawie zaznaczonej kolejki.',
      'No entry found!' => 'Nic nie odnaleziono!',
      'Session has timed out. Please log in again.' => 'Sesja wygasa. Zaloguj si ponownie',
      'No Permission!' => '',
      'To: (%s) replaced with database email!' => 'DO: (%s) zamienione z adresem email z bazy danych',
      'Cc: (%s) added database email!' => '',
      '(Click here to add)' => '(By doda kliknij tutaj)',
      'Preview' => 'Podgld',
      'Added User "%s"' => '',
      'Contract' => '',
      'Online Customer: %s' => '',
      'Online Agent: %s' => '',
      'Calendar' => '',
      'File' => '',
      'Filename' => 'Nazwa pliku',
      'Type' => 'Typ',
      'Size' => '',
      'Upload' => '',
      'Directory' => '',
      'Signed' => '',
      'Sign' => '',
      'Crypted' => '',
      'Crypt' => '',

      # Template: AAAMonth
      'Jan' => 'Sty',
      'Feb' => 'Lut',
      'Mar' => '',
      'Apr' => 'Kwi',
      'May' => 'Maj',
      'Jun' => 'Cze',
      'Jul' => 'Lip',
      'Aug' => 'Sie',
      'Sep' => 'Wrz',
      'Oct' => 'Pa',
      'Nov' => 'Lis',
      'Dec' => 'Gru',

      # Template: AAANavBar
      'Admin-Area' => 'Administracja',
      'Agent-Area' => 'Obsuga',
      'Ticket-Area' => '',
      'Logout' => 'Wyloguj',
      'Agent Preferences' => '',
      'Preferences' => 'Ustawienia',
      'Agent Mailbox' => '',
      'Stats' => 'Statystyki',
      'Stats-Area' => '',
      'FAQ-Area' => 'Pytania i odpowiedzi (FAQ)',
      'FAQ' => '',
      'FAQ-Search' => '',
      'FAQ-Article' => '',
      'New Article' => 'Nowy artyku',
      'FAQ-State' => '',
      'Admin' => '',
      'A web calendar' => '',
      'WebMail' => '',
      'A web mail client' => '',
      'FileManager' => '',
      'A web file manager' => '',
      'Artefact' => '',
      'Incident' => '',
      'Advisory' => '',
      'WebWatcher' => '',
      'Customer Users' => '',
      'Customer Users <-> Groups' => '',
      'Users <-> Groups' => '',
      'Roles' => '',
      'Roles <-> Users' => '',
      'Roles <-> Groups' => '',
      'Salutations' => '',
      'Signatures' => '',
      'Email Addresses' => '',
      'Notifications' => '',
      'Category Tree' => '',
      'Admin Notification' => '',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Ustawienia zapisano pomylnie!',
      'Mail Management' => 'Zarzdzanie poczt',
      'Frontend' => 'Interfejs',
      'Other Options' => 'Inne opcje',
      'Change Password' => '',
      'New password' => '',
      'New password again' => '',
      'Select your QueueView refresh time.' => 'Wybierz okres odwierzania Podgldu Kolejki.',
      'Select your frontend language.' => 'Wybierz jzyk.',
      'Select your frontend Charset.' => 'Wybierz kodowanie.',
      'Select your frontend Theme.' => 'Wybierz schemat wygldu systemu.',
      'Select your frontend QueueView.' => 'Wybierz Podgld Kolejki.',
      'Spelling Dictionary' => 'Sownik pisowni',
      'Select your default spelling dictionary.' => 'Wybierz domylny sownik.',
      'Max. shown Tickets a page in Overview.' => 'Limit pokazywanych zgosze na stronie Podsumowania',
      'Can\'t update password, passwords dosn\'t match! Please try it again!' => '',
      'Can\'t update password, invalid characters!' => '',
      'Can\'t update password, need min. 8 characters!' => '',
      'Can\'t update password, need 2 lower and 2 upper characters!' => '',
      'Can\'t update password, need min. 1 digit!' => '',
      'Can\'t update password, need min. 2 characters!' => '',
      'Password is needed!' => '',

      # Template: AAATicket
      'Lock' => 'Zablokowane',
      'Unlock' => 'Odblokuj',
      'History' => 'Historia',
      'Zoom' => 'Podgld',
      'Age' => 'Wiek',
      'Bounce' => 'Odbij',
      'Forward' => 'Przelij dalej',
      'From' => 'Od',
      'To' => 'Do',
      'Cc' => '',
      'Bcc' => '',
      'Subject' => 'Temat',
      'Move' => 'Przesu',
      'Queue' => 'Kolejka',
      'Priority' => 'Priorytet',
      'State' => 'Status',
      'Compose' => 'Stwrz',
      'Pending' => 'Oczekujce',
      'Owner' => 'Waciciel',
      'Owner Update' => '',
      'Sender' => 'Nadawca',
      'Article' => 'Artyku',
      'Ticket' => 'Zgoszenie',
      'Createtime' => 'Utworzone o',
      'plain' => 'bez formatowania',
      'eMail' => 'E-Mail',
      'email' => 'e-mail',
      'Close' => 'Zamknij',
      'Action' => 'Akcja',
      'Attachment' => 'Zacznik',
      'Attachments' => 'Zaczniki',
      'This message was written in a character set other than your own.' => 'Ta wiadomo zostaa napisana z uyciem kodowania znakw innego ni Twj.',
      'If it is not displayed correctly,' => 'Jeli nie jest wywietlane poprawnie,',
      'This is a' => 'To jest',
      'to open it in a new window.' => 'by otworzy w oddzielnym oknie',
      'This is a HTML email. Click here to show it.' => 'To jest e-mail w formacie HTML. Kliknij tutaj, by go przeczyta.',
      'Free Fields' => '',
      'Merge' => '',
      'closed successful' => 'zamknite z powodzeniem',
      'closed unsuccessful' => 'zamknite bez powodzenia',
      'new' => 'nowe',
      'open' => 'otwarte',
      'closed' => '',
      'removed' => 'usunite',
      'pending reminder' => 'oczekujce przypomnienie',
      'pending auto close+' => 'oczekujce na automatyczne zamknicie+',
      'pending auto close-' => 'oczekujce na automatyczne zamknicie-',
      'email-external' => 'e-mail zewntrzny',
      'email-internal' => 'e-mail wewntrzny',
      'note-external' => 'Notatka zewntrzna',
      'note-internal' => 'Notatka wewntrzna',
      'note-report' => 'Notatka raportujaca',
      'phone' => 'telefon',
      'sms' => 'SMS',
      'webrequest' => 'zgoszenie z WWW',
      'lock' => 'zablokowane',
      'unlock' => 'odblokuj',
      'very low' => 'bardzo niski',
      'low' => 'niski',
      'normal' => 'normalny',
      'high' => 'wysoki',
      'very high' => 'bardzo wysoki',
      '1 very low' => '1 bardzo niski',
      '2 low' => '2 niski',
      '3 normal' => '3 normalny',
      '4 high' => '4 wysoki',
      '5 very high' => '5 bardzo wysoki',
      'Ticket "%s" created!' => 'Zgoszenie "%s" utworzone!',
      'Ticket Number' => '',
      'Ticket Object' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => '',
      'Don\'t show closed Tickets' => 'Nie pokazuj zamknitych zgosze',
      'Show closed Tickets' => 'Poka zamknite zgoszenia',
      'Email-Ticket' => '',
      'Create new Email Ticket' => '',
      'Phone-Ticket' => '',
      'Create new Phone Ticket' => '',
      'Search Tickets' => '',
      'Edit Customer Users' => '',
      'Bulk-Action' => '',
      'Bulk Actions on Tickets' => '',
      'Send Email and create a new Ticket' => '',
      'Overview of all open Tickets' => '',
      'Locked Tickets' => '',
      'Lock it to work on it!' => '',
      'Unlock to give it back to the queue!' => '',
      'Shows the ticket history!' => '',
      'Print this ticket!' => '',
      'Change the ticket priority!' => '',
      'Change the ticket free fields!' => '',
      'Link this ticket to an other objects!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket customer!' => '',
      'Add a note to this ticket!' => '',
      'Merge this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Close this ticket!' => '',
      'Look into a ticket!' => '',
      'Delete this ticket!' => '',
      'Mark as Spam!' => '',
      'My Queues' => '',
      'Shown Tickets' => '',
      'New ticket notification' => 'Powiadomienie o nowym zgoszeniu',
      'Send me a notification if there is a new ticket in "My Queues".' => '',
      'Follow up notification' => 'Powiadomienie o odpowiedzi',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Wylij mi wiadomo, gdy klient odpowie na zgoszenie, ktrego ja jestem wacicielem.',
      'Ticket lock timeout notification' => 'Powiadomienie o przekroczonym czasie blokady zgoszenia',
      'Send me a notification if a ticket is unlocked by the system.' => 'Wylij mi wiadomo, gdy zgoszenie zostanie odblokowane przez system.',
      'Move notification' => 'Powiadomienie o przesuniciu',
      'Send me a notification if a ticket is moved into one of "My Queues".' => '',
      'Your queue selection of your favorite queues. You also get notified about this queues via email if enabled.' => '',
      'Custom Queue' => 'Kolejka modyfikowana',
      'QueueView refresh time' => 'Okres odwierzania Podgldu Kolejki',
      'Screen after new ticket' => 'Ekran po nowym zgoszeniu',
      'Select your screen after creating a new ticket.' => 'Wybierz ekran, ktry pokae si po rejestracji nowego zgoszenia',
      'Closed Tickets' => 'Zamknite zgoszenia',
      'Show closed tickets.' => 'Poka zamknite zgoszenia.',
      'Max. shown Tickets a page in QueueView.' => 'Limit pokazywanych zgosze na stronie Podgldu Kolejki',
      'Responses' => 'Odpowiedzi',
      'Responses <-> Queue' => '',
      'Auto Responses' => '',
      'Auto Responses <-> Queue' => '',
      'Attachments <-> Responses' => '',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Bounce' => 'Bounced to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::AddNote' => 'Added note (%s)',
      'History::Lock' => 'Locked ticket.',
      'History::Unlock' => 'Unlocked ticket.',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Remove' => '%s',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

      # Template: AAAWeekDay
      'Sun' => 'Ndz',
      'Mon' => 'Pnd',
      'Tue' => 'Wtr',
      'Wed' => 'rd',
      'Thu' => 'Czw',
      'Fri' => 'Ptk',
      'Sat' => 'Sob',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Konfiguracja zacznikw',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Konfiguracja automatycznych odpowiedzi',
      'Response' => 'Odpowied',
      'Auto Response From' => 'Automatyczna odpowied Od',
      'Note' => 'Uwagi',
      'Useable options' => 'Uyteczne opcje',
      'to get the first 20 character of the subject' => 'by wstawi pierwsze 20 znakw tematu',
      'to get the first 5 lines of the email' => 'by wstawi 5 pierwszych linii wiadomoci',
      'to get the from line of the email' => 'by wstawi pole Od wiadomoci',
      'to get the realname of the sender (if given)' => 'by wstawi prawdziwe imi i nazwisko klienta (jeli podano)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'Wiadomo edytowana zostaa zamknita.  Wychodz.',
      'This window must be called from compose window' => 'To okno musi zosta wywoane z okna edycji',
      'Customer User Management' => 'Konfiguracja uytkownikw',
      'Search for' => '',
      'Result' => '',
      'Select Source (for add)' => '',
      'Source' => 'rdo',
      'This values are read only.' => '',
      'This values are required.' => '',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => '',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => '',
      'Change %s settings' => 'Zmie %s ustawienia',
      'Select the user:group permissions.' => 'Wybierz prawa dostpu dla uytkownika:grupy',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Jeli nic nie zaznaczono, wtedy uytkownik nie bdzie mia praw w tej grupie (zgoszenia bd niedostpne)',
      'Permission' => 'Prawo dostpu',
      'ro' => '',
      'Read only access to the ticket in this group/queue.' => 'Prawo jedynie do odczytu zgosze w tej grupie/kolejce',
      'rw' => '',
      'Full read and write access to the tickets in this group/queue.' => 'Prawa penego odczytu i zapisu zgosze w tej grupie/kolejce',

      # Template: AdminCustomerUserGroupForm

      # Template: AdminEmail
      'Message sent to' => 'Wiadomo wysana do',
      'Recipents' => 'Adresaci',
      'Body' => 'Tre',
      'send' => 'wylij',

      # Template: AdminGenericAgent
      'GenericAgent' => '',
      'Job-List' => '',
      'Last run' => '',
      'Run Now!' => '',
      'x' => '',
      'Save Job as?' => '',
      'Is Job Valid?' => '',
      'Is Job Valid' => '',
      'Schedule' => '',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Przeszukiwanie penotekstowe w artykule (np. "Ja*k" lub "Rumia*)',
      '(e. g. 10*5155 or 105658*)' => '(np. 10*5155 lub 105658*)',
      '(e. g. 234321)' => '(np. 3242442)',
      'Customer User Login' => 'Login Klienta',
      '(e. g. U5150)' => '(np. U4543)',
      'Agent' => '',
      'TicketFreeText' => 'Dodatkowe informacje o zgoszeniu',
      'Ticket Lock' => '',
      'Times' => 'Razy',
      'No time settings.' => 'Brak ustawie czasu',
      'Ticket created' => 'Zgoszenie utworzone',
      'Ticket created between' => 'Zgoszenie utworzone midzy',
      'New Priority' => '',
      'New Queue' => 'Nowa kolejka',
      'New State' => '',
      'New Agent' => '',
      'New Owner' => 'Nowy waciciel',
      'New Customer' => '',
      'New Ticket Lock' => '',
      'CustomerUser' => 'Klient',
      'Add Note' => 'Dodaj notatk',
      'CMD' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
      'Delete tickets' => '',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => '',
      'Modules' => '',
      'Param 1' => '',
      'Param 2' => '',
      'Param 3' => '',
      'Param 4' => '',
      'Param 5' => '',
      'Param 6' => '',
      'Save' => '',

      # Template: AdminGroupForm
      'Group Management' => 'Zarzdzanie grupami',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Grupa Admin pozwala posiada prawa Administracji systemem. Grupa Stats umoliwia przegldanie statystyk zgosze.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Stwrz nowe grupy, by mc efektywniej zarzdza dostpem do zgosze rnych grup uytkownikow (np. Serwisu, Sprzeday itp...).',
      'It\'s useful for ASP solutions.' => 'Pomocne w rozwizanich ASP.',

      # Template: AdminLog
      'System Log' => 'Log Systemu',
      'Time' => '',

      # Template: AdminNavigationBar
      'Users' => '',
      'Groups' => 'Grupy',
      'Misc' => 'Rne',

      # Template: AdminNotificationForm
      'Notification Management' => 'Konfiguracja Powiadomie',
      'Notification' => '',
      'Notifications are sent to an agent or a customer.' => 'Powiadomienia s wysyane do agenta obsugi lub klienta',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opcje konfiguracyjne (np. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opcje dotyczce waciciela zgoszenia (np. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcje aktualnego agenta obsugi (np. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opcje aktualnego klienta (np. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',

      # Template: AdminPackageManager
      'Package Manager' => '',
      'Uninstall' => '',
      'Verion' => '',
      'Do you really want to uninstall this package?' => '',
      'Install' => '',
      'Package' => '',
      'Online Repository' => '',
      'Version' => '',
      'Vendor' => '',
      'Upgrade' => '',
      'Local Repository' => '',
      'Status' => '',
      'Overview' => 'Podsumowanie',
      'Download' => '',
      'Rebuild' => '',
      'Reinstall' => '',

      # Template: AdminPGPForm
      'PGP Management' => '',
      'Identifier' => '',
      'Bit' => '',
      'Key' => 'Klucz',
      'Fingerprint' => '',
      'Expires' => '',
      'In this way you can directly edit the keyring configured in SysConfig.' => '',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'Konfiguracja kont POP3',
      'Host' => '',
      'Trusted' => 'Zaufane',
      'Dispatching' => 'Przekazanie',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Wszystkie przychodzce na jedno konto wiadomoci bd umieszczone w zaznacznej kolejce!',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => '',
      'Filtername' => '',
      'Match' => 'Odpowiada',
      'Header' => '',
      'Value' => 'Warto',
      'Set' => 'Ustaw',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => '',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'Konfiguracja kolejek',
      'Sub-Queue of' => 'Kolejka podrzdna',
      'Unlock timeout' => 'Limit czasowy odblokowania',
      '0 = no unlock' => '0 = bez odblokowania',
      'Escalation time' => 'Czas eskalacji',
      '0 = no escalation' => '0 = brak eskalacji',
      'Follow up Option' => 'Opcja Follow Up',
      'Ticket lock after a follow up' => 'Zgoszenie zablokowane po odpowiedzi (Follow Up)',
      'Systemaddress' => 'Adres systemowy',
      'Customer Move Notify' => 'Powiadomienie klienta o przesuniciu',
      'Customer State Notify' => 'Powiadomienie klienta o zmianie statusu',
      'Customer Owner Notify' => 'Powiadomienie klienta o zmianie waciciela',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Jeli agent zablokuje zgoszenie, a nastpnie nie odpowie na nie w cigu wskazanego czasu, wtedy zgoszenie zostanie automatycznie odblokowane. Dziki temu pozostali agenci bd mogli je zobaczy.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Jeli, w podanym czasie, nie zostanie udzielona odpowied na zgoszenie, wtedy tylko to zgoszenie bdzie widoczne w kolejce.',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Jeli zgoszenie byo zamknite, a klient przyle do niego kolejn odpowied, wtedy zgoszenie zostanie zablokowane w kolejce starego waciciela.',
      'Will be the sender address of this queue for email answers.' => 'Bdzie adresem nadawcy odpowiedzi emailowych wysyanych z tej kolejki.',
      'The salutation for email answers.' => 'Zwrot grzecznociowy dla odpowiedzi emailowych.',
      'The signature for email answers.' => 'Podpis dla odpowiedzi emailowych.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'System wyle powiadomienie do klienta, gdy zgoszenie zostanie przesunite do innej kolejki.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie status zgoszenia.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie waciciel zgoszenia.',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => '',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Odpowied',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => '',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Konfiguracja Odpowiedzi',
      'A response is default text to write faster answer (with default text) to customers.' => 'Odpowied to domylny tekst wstawiany do odpowiedzi klientowi, dziki czemu agent moe szybciej odpowiedzie na zgoszenie.',
      'Don\'t forget to add a new response a queue!' => 'Nie zapomnij powiza nowej odpowiedzi z jak kolejk!',
      'Next state' => 'Nastpny status',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'The current ticket state is' => 'Aktualny status zgoszenia to',
      'Your email address is new' => '',

      # Template: AdminRoleForm
      'Role Management' => '',
      'Create a role and put groups in it. Then add the role to the users.' => '',
      'It\'s useful for a lot of users and groups.' => '',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => '',
      'move_into' => 'przesu do',
      'Permissions to move tickets into this group/queue.' => 'Uprawnienia do przesuwania zgosze do tej grupy/kolejki',
      'create' => 'utwrz',
      'Permissions to create tickets in this group/queue.' => 'Uprawnienia do tworzenia zgosze w tej grupie/kolejce',
      'owner' => 'waciciel',
      'Permissions to change the ticket owner in this group/queue.' => 'Uprawnienia do zmiany waciciela zgoszenia w tej grupie/kolejce',
      'priority' => 'priorytet',
      'Permissions to change the ticket priority in this group/queue.' => 'Uprawnienia do zmiany priorytetu zgoszenia w tej grupie/kolejce',

      # Template: AdminRoleGroupForm
      'Role' => '',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => '',
      'Active' => '',
      'Select the role:user relations.' => '',

      # Template: AdminRoleUserForm

      # Template: AdminSalutationForm
      'Salutation Management' => 'Konfiguracja zwrotw grzecznociowych',
      'customer realname' => 'Prawdziwe dane klienta',
      'for agent firstname' => 'dla imienia agenta',
      'for agent lastname' => 'dla nazwiska agenta',
      'for agent user id' => 'dla ID uytkownika agenta',
      'for agent login' => 'dla loginu agenta',

      # Template: AdminSelectBoxForm
      'Select Box' => 'Zapytanie SQL',
      'SQL' => '',
      'Limit' => '',
      'Select Box Result' => 'Wyniki Zapytania',

      # Template: AdminSession
      'Session Management' => 'Zarzdzanie sesjami',
      'Sessions' => 'Sesje',
      'Uniq' => 'Unikalne',
      'kill all sessions' => 'Zamknij wszystkie sesje',
      'Session' => '',
      'kill session' => 'Zamknij sesj',

      # Template: AdminSignatureForm
      'Signature Management' => 'Konfiguracja podpisw',

      # Template: AdminSMIMEForm
      'SMIME Management' => '',
      'Add Certificate' => '',
      'Add Private Key' => '',
      'Secret' => '',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => '',

      # Template: AdminStateForm
      'System State Management' => 'Konfiguracja statusw',
      'State Type' => 'Typ statusu',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Pamitaj, by auktualni rwnie domylne statusy w pliku Kernel/Config.pm !',
      'See also' => 'Zobacz take',

      # Template: AdminSysConfig
      'SysConfig' => '',
      'Group selection' => '',
      'Show' => '',
      'Download Settings' => '',
      'Download all system config changes.' => '',
      'Load Settings' => '',
      'Subgroup' => '',
      'Elements' => '',

      # Template: AdminSysConfigEdit
      'Config Options' => '',
      'Default' => '',
      'Content' => '',
      'New' => 'Nowe',
      'New Group' => '',
      'Group Ro' => '',
      'New Group Ro' => '',
      'NavBarName' => '',
      'Image' => '',
      'Prio' => '',
      'Block' => '',
      'NavBar' => '',
      'AccessKey' => '',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Konfiguracja adresw email Systemu',
      'Email' => 'E-Mail',
      'Realname' => 'Prawdziwe Imi i Nazwisko',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Wszystkie wiadomoci przysane na ten adres w polu (Do:) zostan umieszczone w tej kolejce.',

      # Template: AdminUserForm
      'User Management' => 'Zarzdzanie Uytkownikami',
      'Firstname' => 'Imi',
      'Lastname' => 'Nazwisko',
      'User will be needed to handle tickets.' => 'Uytkownik bdzie niezbdny do obsugi zgoszenia.',
      'Don\'t forget to add a new user to groups and/or roles!' => '',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => '',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Ksika adresowa',
      'Return to the compose screen' => 'Powr do ekranu edycji',
      'Discard all changes and return to the compose screen' => 'Anuluj wszystkie zmiany i powr do ekranu edycji',

      # Template: AgentCalendarSmall

      # Template: AgentCalendarSmallIcon

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => '',

      # Template: AgentLinkObject
      'Link Object' => '',
      'Select' => 'Zaznacz',
      'Results' => 'Wyniki',
      'Total hits' => 'Wszystkich trafie',
      'Site' => 'Witryna',
      'Detail' => '',

      # Template: AgentLookup
      'Lookup' => '',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => '',
      'You need min. one selected Ticket!' => '',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Sownik',
      'spelling error(s)' => 'bdw jzykowych',
      'or' => 'lub',
      'Apply these changes' => 'Zastosuj te zmiany',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Wiadomo musi zawiera wypenione adresem polu Do: (odbiorca)!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'W polu Do: musi znale si adres email (np. klient@przyklad.pl)!',
      'Bounce ticket' => 'Odbij zgoszenie',
      'Bounce to' => 'Odbij do',
      'Next ticket state' => 'Nastpny status zgoszenia',
      'Inform sender' => 'Powiadom nadawc',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Twoja wiadomo o numerze zgoszenia: "<OTRS_TICKET>" zostaa przekazana na adres "<OTRS_BOUNCE_TO>" . Prosimy kontaktowa si pod tym adresem we wszystkich sprawach dotyczcych tego zgoszenia.',
      'Send mail!' => 'Wylij wiadomo!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Wiadomosc powinna posiada temat!',
      'Ticket Bulk Action' => '',
      'Spell Check' => 'Sprawd poprawno',
      'Note type' => 'Typ notatki',
      'Unlock Tickets' => '',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Wiadomo powinna zawiera jak tre!',
      'You need to account time!' => 'Musisz zaraportowa czas!',
      'Close ticket' => 'Zamknij zgoszenie',
      'Note Text' => 'Tekst notatki',
      'Close type' => 'Typ zamknicia',
      'Time units' => 'Jednostek czasu',
      ' (work units)' => ' (jednostek roboczych)',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'Wiadomo musi zosta sprawdzona sownikiem!',
      'Compose answer for ticket' => 'Edytuj odpowied na zgoszenie',
      'Attach' => 'Wstaw',
      'Pending Date' => 'Termin wyznaczony',
      'for pending* states' => 'dla statusw "oczekujcych" z pola powyej',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'Zmie klienta dla zgoszenia',
      'Set customer user and customer id of a ticket' => 'Wska klienta i ID klienta dla zgoszenia',
      'Customer User' => 'Klienci',
      'Search Customer' => 'Szukaj klienta',
      'Customer Data' => 'Dane klienta',
      'Customer history' => 'Historia klienta',
      'All customer tickets.' => 'Wszystkie zgoszenia klienta',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Odpowiedz',

      # Template: AgentTicketEmail
      'Compose Email' => 'Nowa wiadomo',
      'new ticket' => 'Nowe zgoszenie',
      'Clear To' => '',
      'All Agents' => 'Wszyscy agenci',
      'Termin1' => '',

      # Template: AgentTicketForward
      'Article type' => 'Typ artykuu',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'Dodaj lub zmie dodatkowe informacje o zgoszeniu',

      # Template: AgentTicketHistory
      'History of' => 'Historia',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'Zgoszenie zablokowane!',
      'Ticket unlock!' => 'Zgoszenie odblokowane!',

      # Template: AgentTicketMailbox
      'Mailbox' => 'Skrzynka',
      'Tickets' => 'Zgloszenia',
      'All messages' => 'Wszystkie wiadomoci',
      'New messages' => 'Nowe wiadomoci',
      'Pending messages' => 'Oczekujce wiadomoci',
      'Reminder messages' => 'Tekst przypomnienia',
      'Reminder' => 'Przypomnienie',
      'Sort by' => 'Sortuj wedug',
      'Order' => 'Porzdek',
      'up' => 'gra',
      'down' => 'd',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => '',
      'Ticket Merge' => '',
      'Merge to' => '',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',

      # Template: AgentTicketMove
      'Queue ID' => 'ID Kolejki',
      'Move Ticket' => 'Przesu zgoszenie',
      'Previous Owner' => 'Poprzedni waciciel',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Dodaj notatk do zgoszenia',
      'Inform Agent' => '',
      'Optional' => '',
      'Inform involved Agents' => '',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Zmie waciciela zgoszenia',
      'Message for new Owner' => 'Wiadomo do nowego waciciela',

      # Template: AgentTicketPending
      'Set Pending' => 'Ustaw oczekiwanie',
      'Pending type' => 'Typ oczekiwania',
      'Pending date' => 'Data oczekiwania',

      # Template: AgentTicketPhone
      'Phone call' => 'Telefon',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'Wyczy pole Od:',

      # Template: AgentTicketPlain
      'Plain' => 'Puste',
      'TicketID' => 'ID Zgoszenia',
      'ArticleID' => 'ID Artykuu',

      # Template: AgentTicketPrint
      'Ticket-Info' => '',
      'Accounted time' => 'Zaraportowany czas',
      'Escalation in' => 'Eskalowane w',
      'Linked-Object' => '',
      'Parent-Object' => '',
      'Child-Object' => '',
      'by' => 'przez',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Zmie priorytet zgoszenia',

      # Template: AgentTicketQueue
      'Tickets shown' => 'Pokazane zgoszenia',
      'Page' => 'Strona',
      'Tickets available' => 'Dostpne zgoszenia',
      'All tickets' => 'Wszystkie zgoszenia',
      'Queues' => 'Kolejki',
      'Ticket escalation!' => 'Eskalacja zgoszenia!',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'Twoje wasne zgoszenie',
      'Compose Follow up' => 'Napisz Odpowied (Follow Up)',
      'Compose Answer' => 'Napisz odpowied',
      'Contact customer' => 'Skontaktuj si z klientem',
      'Change queue' => 'Zmie kolejk',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'Wyszukiwanie zgoszenia',
      'Profile' => 'Profil',
      'Search-Template' => 'Szablon wyszukiwania',
      'Created in Queue' => '',
      'Result Form' => 'Formularz wynikw',
      'Save Search-Profile as Template?' => 'Zachowaj profil wyszukiwania jako szablon',
      'Yes, save it with name' => 'Tak, zapisz to pod nazw',
      'Customer history search' => 'Przeszukiwanie historii klienta',
      'Customer history search (e. g. "ID342425").' => 'Przeszukiwanie historii klienta (np. "ID342425").',
      'No * possible!' => 'Nie uywaj znaku "*"!',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Wyniki wyszukiwania',
      'Change search options' => 'Zmie kryteria wyszukiwania',

      # Template: AgentTicketSearchResultPrint
      '"}' => '',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'sortuj rosnco',
      'U' => 'G',
      'sort downward' => 'sortuj malejco',
      'D' => '',

      # Template: AgentTicketStatusView
      'Ticket Status View' => '',
      'Open Tickets' => '',

      # Template: AgentTicketZoom
      'Split' => 'Podziel',

      # Template: AgentTicketZoomStatus
      'Locked' => '',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerCalendarSmallIcon

      # Template: CustomerError
      'Traceback' => 'led wstecz',

      # Template: CustomerFAQ
      'Print' => 'Drukuj',
      'Keywords' => 'Sowa kluczowe',
      'Symptom' => 'Objawy',
      'Problem' => '',
      'Solution' => 'Rozwizanie',
      'Modified' => 'Zmodyfikowany',
      'Last update' => 'Ostatnia aktualizacja',
      'FAQ System History' => 'Historia FAQ',
      'modified' => '',
      'FAQ Search' => 'Szukaj w FAQ',
      'Fulltext' => 'Penotekstowe',
      'Keyword' => 'Sowo kluczowe',
      'FAQ Search Result' => 'Wyniki przeszukiwania FAQ',
      'FAQ Overview' => 'Podsumowanie FAQ',

      # Template: CustomerFooter
      'Powered by' => 'Oparte na',

      # Template: CustomerFooterSmall

      # Template: CustomerHeader

      # Template: CustomerHeaderSmall

      # Template: CustomerLogin
      'Login' => '',
      'Lost your password?' => 'Zapomniae hasa?',
      'Request new password' => 'Proba o nowe haso',
      'Create Account' => 'Utwrz konto',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Witaj %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'z',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Kliknij tutaj, by zgosi bd systemu OTRS!',

      # Template: FAQ
      'Comment (internal)' => 'Komentarz (wewntrzny)',
      'A article should have a title!' => '',
      'New FAQ Article' => '',
      'Do you really want to delete this Object?' => '',
      'System History' => '',

      # Template: FAQCategoryForm
      'Name is required!' => '',
      'FAQ Category' => 'Kategoria FAQ',

      # Template: FAQLanguageForm
      'FAQ Language' => 'Jzyk FAQ',

      # Template: Footer
      'QueueView' => 'Podgld kolejki',
      'PhoneView' => 'Nowy telefon',
      'Top of Page' => 'Gra strony',

      # Template: FooterSmall

      # Template: Header
      'Home' => '',

      # Template: HeaderSmall

      # Template: Installer
      'Web-Installer' => 'Instalator Web',
      'accept license' => 'akceptuj Licencj',
      'don\'t accept license' => 'nie akceptuj Licencji',
      'Admin-User' => 'Administrator',
      'Admin-Password' => '',
      'your MySQL DB should have a root password! Default is empty!' => 'Twoja baza danych MYSQL powinna mie ustawione jakie haso dla uytkownika root. Domylnie jest puste!',
      'Database-User' => '',
      'default \'hot\'' => 'domylne \'hot\'',
      'DB connect host' => '',
      'Database' => '',
      'Create' => '',
      'false' => '',
      'SystemID' => 'ID Systemu',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identyfikator systemu. Wszystkie zgoszenia oraz sesje http bd zaczynay si od tego cigu)',
      'System FQDN' => 'Pena domena systemu FQDN',
      '(Full qualified domain name of your system)' => '(Pena nazwa domeny Twojego systemu FQDN)',
      'AdminEmail' => 'Email od Admina',
      '(Email of the system admin)' => '(Adres E-Mail Administratora Systemu)',
      'Organization' => 'Organizacja',
      'Log' => '',
      'LogModule' => 'Modu logowania',
      '(Used log backend)' => '(Uywany log backend)',
      'Logfile' => 'Plik logu',
      '(Logfile just needed for File-LogModule!)' => '(Logfile jest potrzebny jedynie dla moduu File-Log!)',
      'Webfrontend' => 'Interfejs webowy',
      'Default Charset' => 'Domylne kodowanie',
      'Use utf-8 it your database supports it!' => 'Uywaj kodowania UTF-8 jeli pozwala Ci na to baza danych!',
      'Default Language' => 'Domylny jzyk',
      '(Used default language)' => '(Domylny jzyk)',
      'CheckMXRecord' => 'Sprawd rekord MX',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Musisz wpisa nastpujce polecenie w linii komend (Terminal/Shell).',
      'Restart your webserver' => 'Uruchom ponownie serwer WWW',
      'After doing so your OTRS is up and running.' => 'Po zakoczeniu tych czynnoci Twj system OTRS bdzie gotowy do pracy',
      'Start page' => 'Strona startowa',
      'Have a lot of fun!' => 'yczymy dobrej zabawy!',
      'Your OTRS Team' => 'Twj Team OTRS',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'Brak dostpu',

      # Template: Notify
      'Important' => '',

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'wydrukowane przez',

      # Template: Redirect

      # Template: SystemStats
      'Format' => '',

      # Template: Test
      'OTRS Test Page' => 'OTRS Strona testowa',
      'Counter' => '',

      # Template: Warning
      # Misc
      'OTRS DB connect host' => 'Host bazy danych',
      'Create Database' => 'Stwrz baz danych',
      'DB Host' => 'Host bazy danych',
      'Ticket Number Generator' => 'Generator numerw zgosze',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identyfikator zgoszenia. np. \'Ticket#\', \'Call#\' lub \'MyTicket#\')',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'Ticket Hook' => 'Identyfikator zgoszenia',
      'Close!' => 'Zamknij!',
      'TicketZoom' => 'Podgld zgoszenia',
      'Don\'t forget to add a new user to groups!' => 'Nie zapomnij doda uytkownika do grup!',
      'License' => 'Licencja',
      'OTRS DB Name' => 'Nazwa bazy danych OTRS',
      'System Settings' => 'Ustawienia systemu',
      'Finished' => 'Zakoczono',
      'DB Admin User' => 'Uytkownik administrujcy baz danych',
      'Change user <-> group settings' => 'Zmie uytkownika <-> Ustawienia grupy',
      'DB Type' => 'Typ bazy danych',
      'next step' => 'Nastpny krok',
      'Admin-Email' => 'Wiadomo od Administratora',
      'Create new database' => 'Stwrz now baz danych',
      'Delete old database' => 'Usu star baz danych',
      'OTRS DB User' => 'Uytkownik bazy danych OTRS',
      'OTRS DB Password' => 'Haso dostpu do bazy dla OTRS',
      'DB Admin Password' => 'Haso Administratora bazy danych',
      'Drop Database' => 'Usu baz danych',
      '(Used ticket number format)' => '(Uywany format numerowania zgosze)',
      'FAQ History' => 'Historia FAQ',
      'Package not correctly deployed, you need to deploy it again!' => '',
      'Customer called' => '',
      'Phone' => '',
      'Office' => '',
      'CompanyTickets' => '',
      'MyTickets' => '',
      'New Ticket' => '',
      'Create new Ticket' => '',
      'installed' => '',
      'uninstalled' => '',
    };
    # $$STOP$$
}
# --
1;
