/* This is exapmle of a test library for OUTO. 

   This file is under no copyright what so ever (e.g. is public domain)
   as this is ment for copypaste

   You may use contents of this file as You see fit.

   this file should in the future grow to contain all new features and trics 
   included. it is ment also for testing those trics actually work

   read also the README file please
 */


#include <assert.h>
#include <stdio.h>
/* #include "yoursoftware.h" */

/* this is required */
#include <outo.h>


char* outo_name = "larger_example";

/* 
 * The tests functions may be named how ever, but they must take no parameters
 * and return int.
 *
 * All debug info goes to the debug file, which is defined on command line or
 * /tmp/.outo by default
 * 
 * Each test is run separately so that _only_ init_tests() is run. You may not
 * assume that earlier tests are done when a test is run.
 *
 * @return 1 on succes, 0 (or anything else) on failure. 
 * The return code can be found on the debug (not yet :)
 */

/*--------------BASIC CASES__________________*/

int test1()
{
  printf("test one output\n");
  return 1; /* succes */
}

int test2()
{
  fprintf(stderr, "test two output to stderr\n");
  return 0; /* failure */
}


/*------------- ASSERT CASES ------------------*/

/** this test is wanted to throw assert, which is will do and thus be passed */
int test3()
{
  printf("now should throw an assert\n");
  assert(0);
  return 1;
}

/** this test is not wanted to throw assert, but it will*/
int test4()
{
  assert(0);
  return 1;
}

/** This test is wanted to throw assert (see below), but it won't*/ 
int test5()
{
  return 1;
}

/** there is two macros PASS and FAIL who write a message to debug and return
    1 and 0, respectively. note also that you can anme the test functions as 
    you see fit
 */
int failing()
{
  if(1)
    FAIL("a message to debug");
  else
    PASS("a message to debug");
}

/*---------------INITIALIZATION---------------*/

/* You may skip init if you don't need it */
/*
  void init_test()
  { 
  }
*/

/**
 * You may have a post_test() function which will be called after each test.
 * Keep in mind that the process calling post_test exits after that and next 
 * test is done in separate process. post_test will not be called after 
 * tests cases that throw assert (or die in some other signal)
 */
void post_test()
{ 
  printf("test closed\n");
}

/* btw. writing init_test or post_test that dies on signal or exits is 
   a good way to get misleading test results */

/*------------------ GENERAL ------------------*/

/** 
 * The tests cases, i.e. a pointer to the test function, explanation and
 * what is the expected result, normal return or assert
 *
 * struct testcase is defined in outo.h
 */
testcase cases[] = {
  {*test1, "test one", EXPECT_OK},
  {*test2, "test two, should fail", EXPECT_OK},
  {*test3, "test three explanation which is too long", EXPECT_ASSERT},
  {*test4, "test four blah blah", EXPECT_OK},
  {*test5, "wanting assert", EXPECT_ASSERT},
  {*failing, "testing PASS and FAIL", EXPECT_OK},
  /*
    it's quite normal to forget to edit the function name when you copypaste 
    the testcase definition. Outo detects this and warns you when you run the
    tests
  */
  {*test5, "a duplicate test", EXPECT_OK}, 
  {0} /* remember the terminating null */
};


/** 
 * The get_tests function
 *
 * You should not change this function to do anythin else than return the 
 * struct array, because things which use any form of IPC may break (e.g.
 * shared memory, pipes, sockets). Do initing your tests in init_tests()
 *
 *  @return a null terminating array of testcase structs
 */
testcase* get_tests()
{  
  return cases;
}

