//
// $Id: TextFileContentProbe.h 4177 2007-06-25 18:57:36Z bakerj $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef TEXTFILECONTENTPROBE_H
#define TEXTFILECONTENTPROBE_H

#include "FileFinder.h"
#include "AbsProbe.h"

#ifdef WIN32
	#define SNPRINTF _snprintf
#else
	#define SNPRINTF snprintf
#endif

using namespace std;

/**
	This class is responsible for collecting date for the :ind-sctextfilecontent_item definied OVAL System Characteristics Schema.
	This class should be platform independant.
*/
class TextFileContentProbe : public AbsProbe {

public:
	~TextFileContentProbe();
	
	ItemVector* CollectItems(Object* object);

	/**  Return a new Item created for storing text file content information */
	Item* CreateItem();

	/** Gets single instance of the TextFileContentProbe. Uses lazy initialization. */
	static AbsProbe* Instance();

private:
	TextFileContentProbe();

	/** The static Singleton instance of the TextFileContentFileProbe. */
	static TextFileContentProbe* instance;

	/** Return true if the specified line matches the criteria in the ObjectEntity. 
		If true any resulting substrings are returned on the substrings vector. 

		TODO: need to implement
	*/
	bool GetSubsrtings(string lineFromFile, ObjectEntity* line, StringVector* substrings);

	/** Read the specified file one line at time and add matching lines to the resultiong Item.
		Call out to the GetSubstrings function to determine if a given line in a file matches the criteria
		specified in the ObjectEntity. 

		TODO: need to implement
	*/
	Item* GetLines(string path, string fileName, ObjectEntity* line);


};

#endif
