///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/utilities/PathManager.h>

namespace Core {

/// The singleton instance of this class.
PathManager* PathManager::_singletonInstance = NULL;

/******************************************************************************
* Initializes the path manager.
******************************************************************************/
PathManager::PathManager() : _executableDirectory(QCoreApplication::applicationDirPath())
{
	OVITO_ASSERT(QDir(_executableDirectory).exists());
	QDir prefixDir(_executableDirectory);
#if defined(Q_WS_WIN) || defined(Q_WS_MAC)
	// The executable is in the root directory.
	_prefixDirectory = prefixDir.absolutePath();
	_libraryDirectory = _prefixDirectory;
    _pluginsDirectory = _prefixDirectory + "/plugins";
    _scriptsDirectory = _prefixDirectory + "/scripts";
	_helpDirectory = _prefixDirectory + "/doc";
#else
	// The executable is in the bin/ sub-directory.
	prefixDir.cdUp();
	_prefixDirectory = prefixDir.absolutePath();	
	_libraryDirectory = _prefixDirectory + "/lib/ovito";
    _pluginsDirectory = _prefixDirectory + "/lib/ovito/plugins";
    _scriptsDirectory = _prefixDirectory + "/share/ovito/scripts";
	_helpDirectory = _prefixDirectory + "/share/ovito/doc";
#endif
	_scenesDirectory = QDir::homePath();
	
	VerboseLogger() << "Application paths:" << endl;
	VerboseLogger() << "   Prefix:" << _prefixDirectory << endl;
	VerboseLogger() << "   Executable:" << _executableDirectory << endl;
	VerboseLogger() << "   Libraries:" << _libraryDirectory << endl;
	VerboseLogger() << "   Plugins:" << _pluginsDirectory << endl;
	VerboseLogger() << "   Scripts:" << _scriptsDirectory << endl;
	VerboseLogger() << "   Scenes:" << _scenesDirectory << endl;
	VerboseLogger() << "   Help files:" << _helpDirectory << endl;
}

};
