<?php

/*

  File: owl.php
  Author: Chris
  Date: 2000/12/14

  Owl: Copyright Chris Vincent <cvincent@project802.net>

  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

*/

// Some urls
// owl_root_url below should not contain http://servername/intranet, but
// just the URL from the root of the web server.

$default->owl_root_url		= "/intranet";
$default->owl_graphics_url	= $default->owl_root_url . "/graphics";

// Ensure that the system_ButtonStyle you choose is a style that exists in 
// all locale
$default->system_ButtonStyle	= "rsdx_blue1";
//$default->system_ButtonStyle	= "Blue";

// Directory where owl is located
// this is the full physical path to where
// Owl was installed
$default->owl_fs_root		= "/var/www/html/intranet";
$default->owl_LangDir		= $default->owl_fs_root . "/locale";

// Directory where The Documents Directory is On Disc
// This path should not include the Documents directory name
// only the path leading to it.

// NOTE: There should be a directory writeable by the web server
//       called Documents in $default->owl_FileDir.  If you want to make 
//	 that a different name you need to rename this directory to what 
//	 ever you want then change the name of the Documents folder in 
//	 the folders table. Using mysql or pgsql update statment.
//	 Check the README FILE


// ***************************************************
// Use File System BEGIN
// ***************************************************

// Use the file system of the database to store the
// files uploaded.
// $default->owl_use_fs            = true		// This stores uploaded files to the Hard Drive
// $default->owl_use_fs            = false		// This stores uploaded files to a table in the database
// Note that temporary files are created to gzip files
// so set to something that is valid, and is writable by the web server
// For Example: $default->owl_FileDir           =  "/tmp/OWLDB";
// 
// NOTE: This feature is only functional with Mysql
// I don't plan on fixing this unless there is a big demand
// For this feature and Postgres.
// 

$default->owl_use_fs            = true;

//  set to 1 to compress the data in the database 
//  when using $default->owl_use_fs = false this compresses the data 
//  before storing to the database

//$default->owl_compressed_database = 1;

// ***************************************************
// Use File System END
// ***************************************************

//****************************************************
// Pick your language system default language
// now each user can pick his language
// if they are allowed by the admin to change their
// preferences.
//****************************************************
// b5
// Brazilian
// Bulgarian
// Chinese
// CVS
// Czech
// Danish
// Deutsch
// Dutch
// English
// Francais
// Hungarian
// Italian
// Norwegian
// Polish
// Portuguese
// Russian
// Spanish
// 

$default->owl_lang		= "English";
$default->owl_notify_link       = "http://" . $_SERVER["SERVER_NAME"] . $default->owl_root_url . "/";


// Table Prefix
$default->owl_table_prefix = "";
//$default->owl_table_prefix = "owl_";


// Table with user info
$default->owl_users_table		= $default->owl_table_prefix . "users";

// Table with group memebership for users 
$default->owl_users_grpmem_table	= $default->owl_table_prefix . "membergroup";
$default->owl_sessions_table 		= $default->owl_table_prefix . "active_sessions";

// Table with file info
$default->owl_files_table		= $default->owl_table_prefix . "files";

// Table with folders info
$default->owl_folders_table		= $default->owl_table_prefix . "folders";

// Table with group info
$default->owl_groups_table		= $default->owl_table_prefix . "groups";

// Table with mime info
$default->owl_mime_table		= $default->owl_table_prefix . "mimes";

// Table with html attributes
$default->owl_html_table		= $default->owl_table_prefix . "html";

// Table with html attributes
$default->owl_prefs_table		= $default->owl_table_prefix . "prefs";

// Table with file data info
$default->owl_files_data_table  	= $default->owl_table_prefix . "filedata";

// Table with files that are monitored
$default->owl_monitored_file_table  	= $default->owl_table_prefix . "monitored_file";

// Table with folders that are monitored
$default->owl_monitored_folder_table  	= $default->owl_table_prefix . "monitored_folder";

// Table with all logging
$default->owl_log_table  		= $default->owl_table_prefix . "owl_log";
 
// Table with all user comments
$default->owl_comment_table  		= $default->owl_table_prefix . "comments";
 
// Table with all news
$default->owl_news_table  		= $default->owl_table_prefix . "news";

// Search Tables
$default->owl_wordidx  			= $default->owl_table_prefix . "wordidx";
$default->owl_searchidx 		= $default->owl_table_prefix . "searchidx";

// Custom Document Fields Tables
$default->owl_docfields_table		= $default->owl_table_prefix . "docfields";
$default->owl_docfieldslabel_table	= $default->owl_table_prefix . "docfieldslabel";
$default->owl_doctype_table          	= $default->owl_table_prefix . "doctype";
$default->owl_docfieldvalues_table	= $default->owl_table_prefix . "docfieldvalues";

// Custom Document Fields Tables
$default->owl_keyword_table		= $default->owl_table_prefix . "metakeywords";

// Custom Document Fields Tables
$default->owl_peerreview_table		= $default->owl_table_prefix . "peerreview";

//**********************************************
// Global Date Format BEGIN
// -------------------------------------
//
// If you want one date format for all the language files
// set the variable bellow to the date patern of your
// Choice.   If you require a different pattern for 
// different lanugages, edit each language file
// and set your pattern in the Date Format Section of 
// each file
//
//
// Examples of Valid patterns:
//$default->generic_date_format 	= "Y-m-d"; 			// 2003-03-07
//$default->generic_date_format 	= "Y-m-d H:i:s";		// 2003-03-13 16:46:24
//$default->generic_date_format 	= "r";				// Thu, 13 Mar 2003 16:46:24 -0500
//$default->generic_date_format 	= "d-M-Y h:i:s a";		// 13-Mar-2003 04:46:24 pm
//$default->generic_date_format 	= "Y-m-d\\<\B\R\\>H:i:s";	// 2003-03-13<br />16:46:24
//$default->generic_date_format         = "Y-M-d\\<\B\R\\>H:i ";  	// 2003-Mar-09<br>12:29 
//$default->generic_date_format         = "d-m-y\\<\B\R\\>H:i ";  	// 27-10-02<br>10:58
//$default->generic_date_format         = "D-M-Y\\<\B\R\\>H:i ";  	// Sun-Oct-2002<br>10:58 
//
// For more options check the php documentation:
// http://www.php.net/manual/en/function.date.php
//**********************************************

$default->generic_date_format 	= "";

//**********************************************
// Global Date Format END
//**********************************************

//**********************************************
// LookATHD Feature Filter Section BEGIN
// -------------------------------------
//
// Uncomment the 2 lines following this section
// to exclude files that have db or txt for 
// an extension
// 
// You can add as many extention as you need.
// and files with the extensions listed below
// are not added to the LookAtHD feature
//
//**********************************************


//$default->lookHD_ommit_ext[] = "db";
//$default->lookHD_ommit_ext[] = "txt";


// to exclude Folders 
// Carefull as this applies to that foldername in any directory

$default->lookHD_ommit_directory[] = "CVS";

//**********************************************
// LookATHD Feature Filter Section END
//**********************************************

//**********************************************
// OMMIT FILES Section BEGIN
//**********************************************

//$default->upload_ommit_ext[] = "pdf";
//$default->upload_ommit_ext[] = "exe";

//**********************************************
// OMMIT FILES Section END
//**********************************************

//**********************************************
// LookATHD Feature Filter Section END
//**********************************************

// Change this to reflect the database you are using
// Mysql 
require_once("$default->owl_fs_root/phplib/db_mysql.inc");
// Oracle  
//require_once("$default->owl_fs_root/phplib/db_oci8.inc");
// PostgreSQL  
//require_once("$default->owl_fs_root/phplib/db_pgsql.inc");


//**********************************************
// Database info BEGIN
//**********************************************
                                                                                                                                                                                                
$default->owl_default_db = 0;    // This indicates what database should be selected by Default  when multiple repositories are defined
                                                                                                                                                                                                
// First Database Information
$default->owl_db_id[0]           = "0";
$default->owl_db_user[0]           = "root";
$default->owl_db_pass[0]           = "";
$default->owl_db_host[0]           = "localhost";
$default->owl_db_name[0]           = "intranet";
$default->owl_db_display_name[0]   = "Intranet";
$default->owl_db_FileDir[0]           =  "/var/www/html/intranet";

// Second Database

//$default->owl_db_id[1]           = "1";
//$default->owl_db_user[1]           = "root";
//$default->owl_db_pass[1]           = "";
//$default->owl_db_host[1]           = "localhost";
//$default->owl_db_name[1]           = "db95498435";
//$default->owl_db_display_name[1]           = "Extranet";
//$default->owl_db_FileDir[1]           =  "/var/www/html/Extranet";
                                                                                                                                                                                                
// Third Database and so on and so on....
                                                                                                                                                                                                
//**********************************************
// Database info END
//**********************************************

// This is to display the version information in the footer

$default->version = "Owl 0.81 20050826";
$default->site_title = "Owl Intranet --  " . $default->version;
$default->phpversion = "4.3.10";

$default->debug = false;

// BEGIN Drop Down Menu Order

$default->FolderMenuOrder = array(
'folder_delete', 
'folder_edit', 
'folder_copy', 
'folder_move', 
'folder_monitor', 
'folder_download'
);
$default->FileMenuOrder = array(
'file_log',
'file_delete',
'file_edit',
'file_link',
'file_copy',
'file_move',
'file_update',
'file_download',
'file_comment',
'file_lock',
'file_email',
'file_monitor',
'file_find',
'file_view'
);

// END Drop Down Menu Order

// BEGIN WORDIDX exlusion List
$default->words_to_exclude_from_wordidx[] = "the";
$default->words_to_exclude_from_wordidx[] = "a";
$default->words_to_exclude_from_wordidx[] = "is";
$default->words_to_exclude_from_wordidx[] = "on";
$default->words_to_exclude_from_wordidx[] = "or";
$default->words_to_exclude_from_wordidx[] = "he";
$default->words_to_exclude_from_wordidx[] = "she";
$default->words_to_exclude_from_wordidx[] = "his";
$default->words_to_exclude_from_wordidx[] = "her";
// END WORDIDX

// This is for adding a view icon to file types
// that are not currently supported by Owl
// DO NOT ADD FILE Types that already have
// a view icon (the magnifying glass) Or you will endup with 2 of them

$default->view_other_file_type_inline[] = "Your-Extension-without-the-dot-here";


$default->list_of_chars_to_remove_from_wordidx = "\"?$()/\*.;:,";

$default->list_of_valid_chars_in_file_names = "-A-Za-z0-9._[:space:]ÀàÁáÂâÃãÄäÅåÆæÇçÈèÉéÊêËëÌìÍíÎîÐðÏïÑñÒòÓóÔôÕõÖö×÷ØøÙùÚúÛûÜüÝýßÞþÿ()@#$\{}+,";

$default->default_sort_column = "name"; // Values are: name -- major_minor_revision -- filename -- f_size -- creatorid -- smodified -- sortchecked_out
$default->default_sort_order = "ASC";  // Values are ASC OR DESC

$default->charset = "UTF-8";

// This removes the ability to set a password on Files or Folders
$default->display_password_override = 1;

// Sets the Defautl MASK when OWL Creates a directory;
$default->directory_mask = 0777;
//$default->directory_mask = 02777;

// What authitencation should Owl Use.
// 0 = Old Standard Owl Authentication
// 1 = .htaccess authentication (username must also exists as the Owl users Table)
// 2 = pop3 authentication (username must also exists as the Owl users Table)
// 3 = LDAP authentication (username must also exists as the Owl users Table)

$default->auth = 0;

// Auth 2  POP3
$default->auth_port = "110";
$default->auth_host = "192.168.11.41";

// Auth 3 LDAP
$default->ldapserver = "host name or ip of ldap box";
$default->ldapserverroot = "ou=People,dc=??????,dc=???";
$default->ldapuserattr = "uid"; // whatever holds logon name in your ldap schema
$default->ldapprotocolversion = "3"; // or 2 to match your ldap


// If you are behind a load-balanced proxy, thus the IP
// changes, you get an "session in use" error, because
// active sessions are checked against the tripple (sessid,uid,ip). 
//
// DEFAULT
// true ---> track it as yet, i.e. (sessid,uid,ip)
//
// false --> track it alternate, i.e. (sessid,uid)
$default->active_session_ip = true;
?>
