<?php
/**
 * Name:          dumpfiles.php
 * 
 * Author:        Andy Balaam
 * 
 * Date:          2004-09-09
 * 
 * Copyright (c) 2004 Andy Balaam
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 * 
 * If you had set the owl_use_fs option to false, and now you
 * want to extract the files from the database into your filesystem,
 * edit the settings at the top of this script and run it like so:
 *
 * php dumpfiles.php
 *
 */
 
# --------------------------- Edit these settings --------------------------



# Enter your MySQL database details

$db_username = "user";
$db_password = "pass";
$db_host = "host";
$db_dbname = "db";





# Choose what you want the script to do

$action = "list";   # Choose this to just list the full file paths to stdout
#$action = "dirlist"; # Choose this to list your files by directory to stdout
#$action = "dump";   # Choose this to actually dump them to your filesystem






# Enter where on your computer you want the files dumped

# Even on Windows, use forward-slashed paths.

#$directorybase = "C:/My Documents/intranetbackup/";
$directorybase = "/home/andy/intranetbackup/";
#$directorybase = ""; # Use blank for a path relative to this script






# Enter the file separator for your system = '/' should work for everyone,
# even on Windows.
$file_separator = "/";      # This _should_ work on Windows as well as *nix






# ------------------ The program starts here ---------------------------

# Use a PEAR class for databases
require("DB.php");

# Connect to the database
$Owl = DB::connect("mysql://$db_username:$db_password@$db_host/$db_dbname");

# Get the latest version of each file
$result = $Owl->query(
     "SELECT f1.id, f1.filename, f1.parent, "
    ."f1.major_revision+(f1.minor_revision/1000.0) AS mval, "
    ."f1.major_revision, f1.minor_revision "
    ."FROM files f1, files f2 "
    ."WHERE f1.name=f2.name AND f1.parent=f2.parent "
    ."GROUP BY f1.id "
    ."HAVING f1.major_revision+(f1.minor_revision/1000.0) = "
    ."MAX(f2.major_revision+(f2.minor_revision/1000.0))" );
   
if (DB::isError($result)) {
    die ($result->getMessage()."\n");
}

# Collect all the results into 3 arrays
while ($row = $result->fetchRow()) {
    
    $ids[]       = $row[0];
    $filenames[] = $row[1];
    $parents[]   = $row[2];
    
}

$result->free();

# Get the list of folders
$result = $Owl->query( "SELECT id, name, parent FROM folders" );
   
if (DB::isError($result)) {
    die ($result->getMessage()."\n");
}

# Collect all the results into 2 hashes
while ($row = $result->fetchRow()) {
    
    $id = $row[0];
    $folder_names[$id]  = $row[1];
    $folder_parents[$id] = $row[2];
    
}

$result->free();

# Find the full path of each file

$num_files = count($ids);

for( $i=0; $i<$num_files; $i++ ) { 
    
    $full_path = $filenames[$i];
    $par = $parents[$i];
    
    while( $par != 0 ) {
        
        $name = $folder_names[$par];
        $par  = $folder_parents[$par];
        
        $full_path = $name . $file_separator . $full_path;

    }
    
    $full_paths[] = $full_path;

}

if( $action == "list" ) {
    
    # Print the file paths as a simple list
    
    sort( $full_paths );
    
    foreach( $full_paths as $path ) {
        echo "$path\n";
    }
    
} elseif( $action == "dirlist" ) {
    
    # Print the file paths sorted by folders
    
    foreach( $full_paths as $path ) {
        
        $last_slash_pos = strrpos($path,$file_separator);
        
        $dir_path = substr( $path, 0, $last_slash_pos );
        $file_name = substr( $path, $last_slash_pos + 1 );
        
        $files_in_dir[$dir_path][] = $file_name;
        
    }
    
    ksort( $files_in_dir );
    
    foreach( $files_in_dir as $dir => $files ) {
        
        echo "\n" . $dir . "\n";
        
        sort( $files );
        foreach( $files as $file ) {
            echo "  " . $file . "\n";
        }
        
    }
    
} elseif( $action == "dump" ) {
    
    # Dump the actual files to disk inside a directory structure
    
    for( $i=0; $i<$num_files; $i++ ) {
        
        $path = $directorybase.$full_paths[$i];
        
        $dir_path = substr( $path,0,strrpos($path,$file_separator) );
        
        if( !mkdir_p( $dir_path ) ) {
            
            die( "Error making directory: \"$dir_path\"\n" );
            
        }

        $row3 = $Owl->getRow( "SELECT data FROM filedata WHERE id="
            . $ids[$i] );
        
        $data = $row3[0];
        
        if( !$data ) {
            echo "Error reading file from database: \"$path\".\n";
            continue;
        }
        
        echo "$path\n";
        
        $file = fopen( $path, "w" );
        
        if( !$file ) {
            
            die( "Error opening file: \"$path\".\n" );
            
        }
        
        if( fwrite( $file, $row3[0] ) ) {
            
            echo "Successfully dumped file: \"$path\".\n";
            
        } else {
            
            die( "Error writing to file: \"$path\".\n" );
            
        }
        
        fclose( $file );
        
    }
    
    echo "Finished.\n";
    
} else {
    
    die( "Unknown action: $action\n" );
    
}

$Owl->disconnect();

# ----------------------- functions -----------------------------------

# Written by bart, taken from here:
# http://uk2.php.net/manual/en/function.mkdir.php
function mkdir_p($target) {
    global $file_separator;
    
    if (is_dir($target)||empty($target)) {
        return 1;
        # best case check first
    }
    
    if (file_exists($target) && !is_dir($target)) {
        return 0;
    }
    
    if (mkdir_p(substr($target,0,strrpos($target,$file_separator)))) {
        if (!file_exists($target)) {
            return mkdir($target);
            # crawl back up & create dir tree
        }
    }
    
    return 0;
}

?>

