dnl Configure paths for LIBCURL
dnl
dnl Copyright (C) 2001 Daniel Caujolle-Bert <segfault@club-internet.fr>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl  
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl  
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl  
dnl  
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a configuration
dnl script generated by Autoconf, you may include it under the same
dnl distribution terms that you use for the rest of that program.
dnl  

dnl AM_PATH_CURL[MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for LIBCURL, and define CURL_CFLAGS and CURL_LIBS
dnl
AC_DEFUN([AM_PATH_CURL], [

    dnl 
    dnl Get the cflags and libraries from the curl-config script
    dnl
    AC_ARG_WITH([curl-prefix],
                AC_HELP_STRING([--with-curl-prefix=PFX], 
                               [prefix where CURL is installed (optional)]),
                [curl_config_prefix="$withval"], [curl_config_prefix=""])
    AC_ARG_WITH([curl-exec-prefix],
                AC_HELP_STRING([--with-curl-exec-prefix=PFX], 
                               [exec prefix where CURL is installed (optional)]), 
                [curl_config_exec_prefix="$withval"], [curl_config_exec_prefix=""])
    AC_ARG_ENABLE([curltest], 
                AC_HELP_STRING([--disable-curltest], 
                               [do not try to compile and run a test CURL program]),
                [], [enable_curltest=yes])

  if test x$curl_config_exec_prefix != x ; then
     curl_config_args="$curl_config_args --exec-prefix=$curl_config_exec_prefix"
     if test x${CURL_CONFIG+set} != xset ; then
        CURL_CONFIG=$curl_config_exec_prefix/bin/curl-config
     fi
  fi
  if test x$curl_config_prefix != x ; then
     curl_config_args="$curl_config_args --prefix=$curl_config_prefix"
     if test x${CURL_CONFIG+set} != xset ; then
        CURL_CONFIG=$curl_config_prefix/bin/curl-config
     fi
  fi

  min_curl_version=ifelse([$1], ,0.5.0,$1)
  if test "x$enable_curltest" != "xyes" ; then
    AC_MSG_CHECKING([for CURL-LIB version >= $min_curl_version])
  else
    AC_PATH_PROG(CURL_CONFIG, curl-config, no)
    AC_MSG_CHECKING([for CURL-LIB version >= $min_curl_version])
    no_curl=""
    if test "$CURL_CONFIG" = "no" ; then
      no_curl=yes
    else
      CURL_CFLAGS=`$CURL_CONFIG $curl_config_args --cflags`
      CURL_LIBS=`$CURL_CONFIG $curl_config_args --libs`
      curl_config_major_version=`$CURL_CONFIG $curl_config_args --version | \
	sed -e 's/^[[a-zA-Z{\ }]]*//g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      curl_config_minor_version=`$CURL_CONFIG $curl_config_args --version | \
	sed -e 's/^[[a-zA-Z{\ }]]*//g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      curl_config_sub_version=`$CURL_CONFIG $curl_config_args --version | \
        sed -e 's/^[[a-zA-Z{\ }]]*//g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $CURL_CFLAGS"
      LIBS="$CURL_LIBS $LIBS"
dnl
dnl Now check if the installed CURL is sufficiently new. (Also sanity
dnl checks the results of curl-config to some extent
dnl
      AC_LANG_SAVE()
      AC_LANG_C()
      rm -f conf.curltest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

int 
main ()
{
  int   major, minor, sub;
  char *tmp_version;
  int   curl_major_version, curl_minor_version, curl_sub_version;
  
  system ("touch conf.curltest");
  
  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = (char *) strdup("$min_curl_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &sub) != 3) {
    printf("%s, bad version string\n", "$min_curl_version");
    exit(1);
  }
  
  if((sscanf(LIBCURL_VERSION, "%d.%d.%d", 
	     &curl_major_version, &curl_minor_version, &curl_sub_version)) == 3) {

    if ((curl_major_version != $curl_config_major_version) ||
	(curl_minor_version != $curl_config_minor_version) ||
	(curl_sub_version != $curl_config_sub_version))
      {
	printf("\n*** 'curl-config --version' returned %d.%d.%d, but CURL (%d.%d.%d)\n", 
	       $curl_config_major_version, $curl_config_minor_version, $curl_config_sub_version,
	       curl_major_version, curl_minor_version, curl_sub_version);
	printf ("*** was found! If curl-config was correct, then it is best\n");
	printf ("*** to remove the old version of CURL. You may also be able to fix the error\n");
	printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
	printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
	printf("*** required on your system.\n");
	printf("*** If curl-config was wrong, set the environment variable CURL_CONFIG\n");
	printf("*** to point to the correct copy of curl-config, and remove the file config.cache\n");
	printf("*** before re-running configure\n");
      } 
    else
      {
	if ((curl_major_version > major) ||
	    ((curl_major_version == major) && (curl_minor_version > minor)) ||
	    ((curl_major_version == major) && (curl_minor_version == minor) && (curl_sub_version >= sub)))
	  {
	    return 0;
	  }
	else
	  {
	    printf("\n*** An old version of CURL (%d.%d.%d) was found.\n",
		   curl_major_version, curl_minor_version, curl_sub_version);
	    printf("*** You need a version of CURL newer than %d.%d.%d. The latest version of\n",
		   major, minor, sub);
	    printf("*** CURL is always available from:\n");
	    printf("***        http://curl.sf.net/\n");
	    printf("***\n");
	    printf("*** If you have already installed a sufficiently new version, this error\n");
	    printf("*** probably means that the wrong copy of the curl-config shell script is\n");
	    printf("*** being found. The easiest way to fix this is to remove the old version\n");
	    printf("*** of CURL, but you can also set the CURL_CONFIG environment to point to the\n");
	    printf("*** correct copy of curl-config. (In this case, you will have to\n");
	    printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
	    printf("*** so that the correct libraries are found at run-time))\n");
	  }
      }
  }
  else
    {
      printf("\n*** Unable to retrieve CURL version ***\n");
    }
  return 1;
}
],, no_curl=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
    fi
    if test "x$no_curl" = x ; then
       AC_MSG_RESULT(yes)
       ifelse([$2], , :, [$2])     
    else
      AC_MSG_RESULT(no)
      if test "$CURL_CONFIG" = "no" ; then
        echo "*** The curl-config script installed by CURL could not be found"
        echo "*** If CURL was installed in PREFIX, make sure PREFIX/bin is in"
        echo "*** your path, or set the CURL_CONFIG environment variable to the"
        echo "*** full path to curl-config."
      else
        if test -f conf.curltest ; then
          :
        else
          echo "*** Could not run CURL test program, checking why..."
          CFLAGS="$CFLAGS $CURL_CFLAGS"
          LIBS="$LIBS $CURL_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
],      [ return (CURL_VERSION_NUM); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding CURL or finding the wrong"
          echo "*** version of CURL. If it is not finding CURL, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means CURL was incorrectly installed"
          echo "*** or that you have moved CURL since it was installed. In the latter case, you"
          echo "*** may want to edit the curl-config script: $CURL_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
        fi
      fi
    CURL_CFLAGS=""
    CURL_LIBS=""
    ifelse([$3], , :, [$3])
  fi
  AC_SUBST(CURL_CFLAGS)
  AC_SUBST(CURL_LIBS)
  AC_LANG_RESTORE()
  rm -f conf.curltest
])

dnl
dnl checking for curl
dnl
AC_DEFUN([AC_CHECK_CURL], [
    AC_ARG_WITH([curl],
                AC_HELP_STRING([--without-curl], 
                               [Turn off CURL support.]),
                [], [with_curl=yes])

    if test x"$with_curl" = xyes; then
        have_curl=yes
        AM_PATH_CURL([7.10.2], , have_curl=no)
        if test x"$have_curl" == x"no"; then
            AC_MSG_WARN(*** All of CURL dependent parts will be disabled. ***)
        else
            AC_DEFINE(HAVE_CURL,,[Define this if you have libcurl installed])
        fi
    else
        have_curl=no
    fi
    AM_CONDITIONAL(HAVE_CURL, test x$have_curl = "xyes")
])
