
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gui_utils.h 1406 2006-10-21 12:25:25Z mschwerin $
 *
 */

#ifndef HAVE_GUI_UTILS_H
#define HAVE_GUI_UTILS_H
#ifdef __cplusplus
extern "C" {
#endif

#include "i18n.h"
#include "oxine.h"
#include "playlist.h"

void current_menu_cb (void *oxine_p);
void playback_ended_menu_cb (void *oxine_p);
void backto_menu_cb (void *oxine_p);

void show_user_interface (void *oxine_p);
void hide_user_interface (void *oxine_p);

void show_menu_background (const char *mrl);
otk_widget_t *create_new_window (bool persistent, bool with_clock);

void show_stream_parameter (oxine_t * oxine, odk_stream_param_t param);

typedef enum {
    DIALOG_PLAIN,
    DIALOG_OK,
    DIALOG_OK_CANCEL,
    DIALOG_YES_NO,
    DIALOG_RETRY_CANCEL
} message_dialog_type_t;

void show_message_dialog (otk_cb_t ok_cb, void *ok_cb_data,
                          otk_cb_t cancel_cb, void *cancel_cb_data,
                          message_dialog_type_t type,
                          const char *background_mrl,
                          const char *format, ...);

static inline void
please_wait (void)
{
    show_message_dialog (NULL, NULL, NULL, NULL, DIALOG_PLAIN,
                         NULL, _("Please wait..."));
}

void playlist_play_first (oxine_t * oxine, otk_cb_t next_menu,
                          playlist_t * playlist);
void playlist_play_item (oxine_t * oxine, otk_cb_t next_menu,
                         playlist_t * playlist, playitem_t * playitem);
void playlist_play_prev (oxine_t * oxine);
void playlist_play_next (oxine_t * oxine);

void playlist_rw_change_cb (playlist_t * playlist);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_GUI_UTILS_H */
