
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: main_menu.h 1522 2006-11-11 13:57:10Z mschwerin $
 *
 */

#ifndef HAVE_MAIN_MENU_H
#define HAVE_MAIN_MENU_H
#ifdef __cplusplus
extern "C" {
#endif

#include "oxine.h"

void eject_cb (void *oxine_p);
void execute_cb (void *cmd_p);
void shutdown_cb (void *oxine_p);

void play_dvd_cb (void *oxine_p);
void play_dvb_cb (void *oxine_p);
void play_v4l_cb (void *oxine_p);
#ifdef HAVE_VDR
void play_vdr_cb (void *oxine_p);
#endif
void play_mrl_cb (void *mrl_p);
void play_audiocd_cb (void *oxine_p);
void play_vcd_cb (void *oxine_p);

void show_sub_menu_cb (void *menu_mrl_p);
void show_main_menu_cb (void *oxine_p);

void main_menu_init (void);
void main_menu_free (void);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_MAIN_MENU_H */
