
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_border.c 2034 2007-05-14 17:30:04Z mschwerin $
 */
#include "config.h"

#include "heap.h"
#include "i18n.h"
#include "odk.h"
#include "otk.h"

typedef struct {
    otk_widget_t widget;
} otk_border_t;


static void
border_destroy (otk_widget_t * this)
{
    otk_border_t *border = (otk_border_t *) this;

    if (!otk_widget_is_correct (this, OTK_WIDGET_BORDER))
        return;

    ho_free (border);
}


static void
border_draw (otk_widget_t * this)
{
    if (!otk_widget_is_correct (this, OTK_WIDGET_BORDER))
        return;

    int palette = otk_get_palette (this->otk, OTK_PALETTE_LABEL);

    odk_draw_rect (this->odk, this->x, this->y, this->w, this->h, 5,
                   palette + OSD_TEXT_PALETTE_FOREGROUND, false);

    this->need_repaint = false;
}


otk_widget_t *
otk_border_new (otk_t * otk, int x, int y, int w, int h)
{
    otk_border_t *border = ho_new (otk_border_t);

    otk_widget_constructor ((otk_widget_t *) border, otk,
                            OTK_WIDGET_BORDER, x, y, w, h);

    border->widget.selectable = OTK_SELECTABLE_NONE;
    border->widget.draw = border_draw;
    border->widget.destroy = border_destroy;

    return (otk_widget_t *) border;
}
