//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __NAPT_PACKAGE_H_2005_02_19
#define __NAPT_PACKAGE_H_2005_02_19

#include <map>
#include <list>

#include <qstring.h>
#include <q3cstring.h>


class QStringList;


using namespace std;

namespace NApt
{

/** This is struct is straight forward. It holds the information as received by apt-cache show. */
struct Package
{
	enum InstalledState
	{
		NOT_INSTALLED,
		INSTALLED
	};
	Package();
	Package(const QString& name);
	/** @brief Constructs a package from the given lines containing the package information.
	  *
	  * The lines should look like the output of apt-cache show packagename
	  */
	Package(const QStringList& lines);
	/** This holds the name of the package. */
	QString name;
	QString essential;
	QString priority;
	QString section;
	QString installedSize;
	QString maintainer;
	QString architecture;
	QString source;
	QString version;
	QString replaces;
	QString provides;
	QString preDepends;
	QString depends;
	QString recommends;
	QString suggests;
	QString conflicts;
	QString filename;
	QString size;
	QString md5sum;
	QString conffiles;
	QString description;

	/* This enum is obsolete now, but is still maintained as I use it in the perl script to generate
	 * some code. */
/*	enum Section
	{
		INVALID_SECTION,
		PACKAGE, ESSENTIAL, PRIORITY, SECTION, INSTALLED_SIZE, MAINTAINER, ARCHITECTURE, SOURCE,
		VERSION, REPLACES, PROVIDES, PRE_DEPENDS, DEPENDS, RECOMMENDS, SUGGESTS, CONFLICTS, 
		FILENAME, SIZE, MD5SUM, CONFFILES, DESCRIPTION
		INSTALLED_VERSION
	};*/
	
	
	InstalledState installedState;
	Q3CString installedVersion;
	
	/** This should be filled with the first line of the description. */
	Q3CString shortDescription;
	uint getSize() const 	{ return size.toUInt(); }
	uint getInstallSize() const	{ return installedSize.toUInt(); }
	typedef list< pair<uint, uint> > BorderList;
	/** @brief This function returns a list of the packages contained in the string. 
		*
		* It is based on some simple parsing rules and might fail if the text is not
		* formatted as expected. See the source for details (the list is assumed to
		* have the form like the dependencies)
		* @returns a list of the packages in the current string. The pairs contain
		* the first char and the one after the last for the package.
		*/
	static BorderList getPackageList(const QString& s);
	/** t must provide the operator()(QString&) wich is applied on attributes. */
	template <typename T> void processEntries(T& t);
	
	/** @brief This parses the handed lines and sets the information for this package. 
	  *
	  * The lines should be have the form &quot;Section: section information&quot;. 
	  * Where each section information be only one line except for the Description
	  * section which is allowed to have more lines. 
	  * @param lines the lines containing the information, to be handed without a 
	  * trailing newline
	  */
	void parseInformation(const QStringList& lines);
private:
	static QString _emptyString;

};



template <typename T> 
void Package::processEntries(T& t)
{
	t(name);
	t(essential);
	t(priority);
	t(section);
	t(installedSize);
	t(maintainer);
	t(architecture);
	t(source);
	t(version);
	t(replaces);
	t(provides);
	t(preDepends);
	t(depends);
	t(recommends);
	t(suggests);
	t(conflicts);
	t(filename);
	t(size);
	t(md5sum);
	t(conffiles);
	t(description);
}


}	// namespace NApt

#endif	// __NAPT_PACKAGE_H_2005_02_19
