// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See the LICENSE file in builder/azure for license information.

package constants

// complete flags
const (
	CertInstalled string = "certInstalled"
	CertUploaded  string = "certUploaded"
	DiskExists    string = "diskExists"
	ImageCreated  string = "imageCreated"
	SrvExists     string = "srvExists"
	VmExists      string = "vmExists"
	VmRunning     string = "vmRunning"
)
const (
	AuthorizedKey         string = "authorizedKey"
	Certificate           string = "certificate"
	Config                string = "config"
	Error                 string = "error"
	HardDiskName          string = "hardDiskName"
	MediaLink             string = "mediaLink"
	OSImageName           string = "osImageName"
	PrivateKey            string = "privateKey"
	RequestManager        string = "requestManager"
	ServicePrincipalToken string = "servicePrincipalToken"
	SSHHost               string = "sshHost"
	Thumbprint            string = "thumbprint"
	Ui                    string = "ui"
)
const (
	ArmBlobEndpoint                    string = "arm.BlobEndpoint"
	ArmCaptureTemplate                 string = "arm.CaptureTemplate"
	ArmComputeName                     string = "arm.ComputeName"
	ArmCertificateUrl                  string = "arm.CertificateUrl"
	ArmDeploymentName                  string = "arm.DeploymentName"
	ArmKeyVaultName                    string = "arm.KeyVaultName"
	ArmLocation                        string = "arm.Location"
	ArmOSDiskVhd                       string = "arm.OSDiskVhd"
	ArmPublicIPAddressName             string = "arm.PublicIPAddressName"
	ArmResourceGroupName               string = "arm.ResourceGroupName"
	ArmIsResourceGroupCreated          string = "arm.IsResourceGroupCreated"
	ArmStorageAccountName              string = "arm.StorageAccountName"
	ArmTemplateParameters              string = "arm.TemplateParameters"
	ArmVirtualMachineCaptureParameters string = "arm.VirtualMachineCaptureParameters"
)
