//=======================================================================
// mainwindow.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_MAIN_WINDOW_H
#define GPACO_MAIN_WINDOW_H

#include "maintreeview.h"
#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/uimanager.h>

namespace Gpaco
{

class MainWindow : public Gtk::Window 
{
	public:

	MainWindow();
	~MainWindow();

	MainTreeView& treeView()		{ return mTreeView; }
	Gtk::ProgressBar& progressBar()	{ return mProgressBar; }
	Gtk::Label& label()				{ return mLabel; }

	bool isColumnVisible(int colId);
	void setColumnVisible(int colId, bool visible = true);

	private:

	Gtk::Label						mLabel;
	MainTreeView					mTreeView;
	Gtk::ProgressBar				mProgressBar;
	Glib::RefPtr<Gtk::UIManager>	mpUIManager;
	Glib::RefPtr<Gtk::ActionGroup>	mpActionGroup;
	Glib::RefPtr<Gtk::Action>		mpActionUpdate;
	Glib::RefPtr<Gtk::Action>		mpActionViewFiles;
	Glib::RefPtr<Gtk::Action>		mpActionPkgInfo;
	Glib::RefPtr<Gtk::Action>		mpActionRemovePkg;
	Glib::RefPtr<Gtk::Action>		mpActionCreatePackage;
	Glib::RefPtr<Gtk::Action>		mpActionUnlogPkg;

	virtual bool on_delete_event(GdkEventAny*);
	void quit();
	bool writeLabel();
	void buildUIManager();
	bool onPkgMenu(GdkEvent*);

};

// Global MainWindow
extern MainWindow* gpMainWindow;

} // namespace Gpaco


#endif  // GPACO_MAIN_WINDOW_H
