//=======================================================================
// main.cc - The main source file.
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "global.h"
#include "log.h"
#include <iostream>
#include <stdexcept>

using std::endl;
using std::cerr;
using std::cout;
using namespace Paco;


void checkDbAge()
{
    struct stat s;

    if (lstat(Config::stamp().c_str(), &s) < 0)
      	Config::touchStamp();
	else if (time(0) - s.st_mtime > Config::maxDbAge() * 24 * 3600) {
		cout.flush();
		cerr << "*** Warning: The database is older than "
		 	<< Config::maxDbAge() << " days.\n*** Run 'paco -ua' to update it.\n";
	}
}


int main(int argc, char* argv[])
{
	std::ios::sync_with_stdio(false);

	try {
		
		Config::init();
		Options o(argc, argv);
		PkgSet pSet;

		if (o.mode() != LOG) {
			if (o.mode() == QUERYFILES || o.allPkgs())
				pSet.getAllPkgs();
			else
				pSet.getPkgs(o.args());
			if (pSet.empty())
				exit(EXIT_FAILURE);
		}
		
		switch (o.mode()) {
			case PKGLIST:		pSet.listPkgs(o); break;
			case FILELIST:		pSet.listFiles(o); break;
			case REMOVE:		pSet.remove(o); break;
			case UPDATE:		pSet.update(o.allPkgs()); break;
			case UNLOG:			pSet.unlog(); break;
    		case QUERYFILES:	pSet.queryFiles(o.args()); break;
    		case CONFOPTS:		pSet.printConfOpts(); break;
    		case INFO:			pSet.printInfo(); break;
			case LOG:			Log::run(o); break;
			default:			assert(0);
		}

		if (Config::maxDbAge())
			checkDbAge();
	}

	catch (std::runtime_error& x) {
		cerr << "paco: " << x.what() << endl;
		gExitStatus = EXIT_FAILURE;
	}

	exit(gExitStatus);
}

