/*
**  POP3CacheManager.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_POP3CacheManager
#define _Pantomime_H_POP3CacheManager

#import <Foundation/NSArray.h>
#import <Foundation/NSCoder.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@class POP3CacheObject;

@interface POP3CacheManager: NSObject <NSCoding>
{
  NSMutableArray *pop3CacheObjects;
  NSString *pathToCache;
}

- (id) init;
- (id) initWithPath: (NSString *) thePath;
- (void) dealloc;

- (BOOL) synchronize;

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;


//
// access/mutation methods
//
- (void) addObject: (POP3CacheObject *) thePOP3CacheObject;
- (void) removeObject: (POP3CacheObject *) thePOP3CacheObject;

- (POP3CacheObject *) findPOP3CacheObject: (NSString *) theUID;

- (NSArray *) pop3CacheObjects;
- (void) setPOP3CacheObjects: (NSArray *) thePOP3CacheObjects;

- (NSString *) pathToCache;
- (void) setPathToCache: (NSString *) thePathToCache;


//
// class methods
//
+ (id) pop3CacheObjectsFromDiskWithPath: (NSString *) thePath;

@end

#endif // _Pantomime_H_POP3CacheManager
