#ifndef INCLUDE_ALIAS_ENTITY_H
#define INCLUDE_ALIAS_ENTITY_H

#include "Entity.h"

class AliasEntity : public Entity {

 public:

  AliasEntity();
  ~AliasEntity();

  void setBody(char *);
  void setCommand(char *);
  void setMacroKey(int);

  char * getBody();
  char * getCommand();
  int getMacroKey();

  void save(FILE *);
  bool load(FILE *, char *);

  void execute(char *, char *);
  bool findExecute(EntityType, char *, char *, void *, bool);

  GtkWidget * getWidgets();
  void apply();
  void getWidgetData();
  void destroyWidgets();

  void keypressed(GdkEventKey *);

 private:

  int macro_key;
  char * body;
  char * command;

  bool widgets; // Are the widgets active for this alias?

  GtkTextBuffer * body_buffer;

};

#endif // INCLUDE_ALIAS_ENTITY_H
