#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "CommandInterpreter.h"
#include "PluginHandler.h"
#include "mudclient.h"
#include "EntityHandler.h"
#include "AliasEntity.h"

#include "Prefs.h"

extern EntityHandler * entities;
extern PluginHandler * phandler;

CommandInterpreter::CommandInterpreter() {
}

CommandInterpreter::~CommandInterpreter() {
}

/**
 * Interprets 'buf' for sending to Connection c.
 *
 * This is where all the hooks to things like alias parsing and semicolon
 * parsing ought to take place.
 */

void StringToRGB(char *, gushort *, gushort *, gushort *);

void CommandInterpreter::interpret(Connection * c, char * buf) {

  // Add to the command history here
  if (!c->getSocket()->echo())
    c->getHistory()->add(buf, c->queryPreferences()->getPreferenceBoolean("HistoryIgnoreRepeats"));

  // Is local echo enabled?
  if (c->queryPreferences()->getPreferenceBoolean("LocalEcho")) {	
    char echobuf[16384];
    gushort red, green, blue;
	StringToRGB(c->queryPreferences()->getPreference("Echo_RGB"), &red, &green, &blue);

	red = ((red * 100 / 65535) * 255) / 100;
	green = ((green * 100 / 65535) * 255) / 100;
	blue = ((blue * 100 / 65535) * 255) / 100;

	if (!c->getSocket()->echo())
		snprintf(echobuf, 16384, "\033[%3.3d;%3.3d;%3.3dp%s\033[q\n",
			red, green, blue, buf);
	else
		snprintf(echobuf, 16384, "\033[%3.3d;%3.3d;%3.3dp<password not echoed>\033[q\n",
			red, green, blue);

    c->getVT()->append(echobuf); 
    c->getVT()->scroll();
  } else
   if (c->queryPreferences()->getPreferenceBoolean("DoublePrompt")) {
     c->getVT()->append("\n");
      c->getVT()->scroll();
   }

  // Is semi-colon separation enabled?
  if (c->queryPreferences()->getPreferenceBoolean("SemiColon")) {
    char * pc;
    char * last = buf;
    char * lastsemi = buf;
    
    while ((pc = strchr(lastsemi, ';'))) {
      if (*(pc - 1) == '\\') {
	lastsemi = pc; // Because we're about to memmove some stuff.
	memmove(pc - 1, pc, strlen(pc) + 1);
	continue;
      }
      
      *pc = '\0';
      aliases(c, last);
      last = pc + 1;
      lastsemi = pc + 1;
    }
    
    aliases(c, last);

    if (c->queryPreferences()->getPreferenceBoolean("clearinput"))
      c->getVT()->setInput("");
    else {
      if (c->getSocket()->echo())
        c->getVT()->setInput("");
      else
        gtk_editable_select_region(GTK_EDITABLE(c->getVT()->getInput()), 0, -1);
    }
    return;
  } else {
    aliases(c, buf);
    if (c->queryPreferences()->getPreferenceBoolean("clearinput"))
      c->getVT()->setInput("");
    else {
      if (c->getSocket()->echo())
        c->getVT()->setInput("");
      else
        gtk_editable_select_region(GTK_EDITABLE(c->getVT()->getInput()), 0, -1);
    }
  }
}

struct macro_data {
  int keyval;
  char * alias_name;
};

int CommandInterpreter::checkMacros(Connection * c, GdkEventKey * e) {
  char outbuf[16384];
  char inbuf[16384];

  inbuf[0] = '\0';
  outbuf[0] = '\0';

  entities->findExecute(EntityAlias, "key", (char *)&e->keyval, (void *)outbuf, false);
  phandler->processInputFilters(c, outbuf);

  if (strlen(outbuf) > 0) {
    strcat(outbuf, "\n");
    c->getSocket()->write(outbuf, strlen(outbuf));
    return 1;
  }

  return 0;
}

void CommandInterpreter::aliases(Connection * c, char * inbuf) {
  char outbuf[16384];
  outbuf[0] = '\0';

  entities->findExecute(EntityAlias, "command", inbuf, (void *)outbuf, false);
  if (strlen(outbuf) == 0)
    strcpy(outbuf, inbuf);

  phandler->processInputFilters(c, outbuf);

  if (strlen(outbuf) == 0 && strlen(inbuf) > 0)
    return;

  strcat(outbuf, "\n");
  c->getSocket()->write(outbuf, strlen(outbuf));
}
