#include "mudclient.h"

#include "TeloptFilter.h"
#include "PromptFilter.h"
#include "Prefs.h"
#include "Connection.h"

PromptFilter::PromptFilter(Connection * s)
  : Filter(s, "Non-Standard-Prompt")
{
  conn = s;
}

PromptFilter::~PromptFilter() {
  conn = NULL;
}

// Looks for preferences associated with the Connection this filter is for.
// If prefs->getUsePromptTerminator() != 0 and [0] != '\0', then search
// for the terminator and replace with MAGIC_PROMPT_STRING as in EOLFilter

bool PromptFilter::process(Buffer &out) {

  Prefs * prefs = conn->queryPreferences();

  if (!prefs->getPreferenceBoolean("UsePromptTerminator")) {
    input.transfer_to(out);
    return true;
  }

  char * terminator = prefs->getPreference("PromptTerminator");
  if (!terminator || terminator[0] == '\0') {
    input.transfer_to(out);
    return true;
  }

  char * pc;
  char * last;
  char * end;

  pc = input.getText();
  end = pc + input.getLength();
  last = pc;

  while (pc <= end && (pc = strstr(pc, terminator))) {
  
    // Append everything up to pc.
    out.append(last, pc - last);

    // Append MAGIC_PROMPT
    static char eolstr[] = { MAGIC_PROMPT };
    out.append(eolstr, 1);

    // Reset the last pointer and pc pointer.

    pc = pc + strlen(terminator);
    last = pc;

  }

  if (last)
    out.append(last, end - last);
  input.reset();
  return true;
}
