# Noughts and Crosses for Papaya using the Turf Client Protocol

# Send: c15 c<name1,name2,name3,name4|all> <argument>
# Recv: <name> <argument>

# Valid arguments for OXO:

# OXO.wannaplay (sent to all to ask who wants to play)
# OXO.willplay  (message sent back from client saying OXO is supported)
# OXO.challenge (Challenges <player> to a game.)
# OXO.deny      (Refuses a challenge)
# OXO.gameon    (Accepts a challenge)

# OXO.select <x> <y> (Places piece at x,y)

# OXO.reset     (Resets the board, and gives the turn to the player who
#                didn't give the reset)
# OXO.quit      (Terminates the game)

# As this is a completely client-side game, we have to assume the clients
# are honest.

import papaya
import re

from gtk import *

def oxo_accept(player, mode):
    global oxo_myturn
    global turfgame_playing

    conn = None
    for c in turfgame_playing["OXO"]:
        if turfgame_playing["OXO"][c] == player:
            conn = c

    if conn == None:
        return

    oxo_create_board(conn)
    oxo_myturn[conn] = mode

def oxo_decline(player):
    # Blank function
    return

def oxo_client_protocol(input):
    global oxo_parser

    print "OXO input " + input

    result = oxo_parser.match(input)
    if result == None:
        return input

    player = result.group(1)
    cmd = result.group(2)
    arg = result.group(3)

    if cmd == 'select':
        result = arg_parser.match(arg)

        x = int(result.group(1))
        y = int(result.group(2))
        oxo_select_from(player, x, y)
        return

    return input
    
def oxo_terminate(player):
    global oxo_boards
    oxo_boards[papaya_connection].destroy()
    del oxo_boards[papaya_connection]

    papaya.message("Noughts and Crosses", player + " has terminated the games.")

def oxo_reset(player):
    global oxo_markers
    global oxo_buttons
    global oxo_myturn
    
    papaya.message("Noughts and Crosses", player + " has reset the board.  It's now your turn.")

    for i in [1,2,3,4,5,6,7,8,9]:
        oxo_markers[papaya_connection][i] = " "
        oxo_buttons[papaya_connection][i].children()[0].set_text(" ")

    oxo_myturn[papaya_connection] = 1

def oxo_select_from(player, x, y):
    global oxo_myturn
    global oxo_markers
    global oxo_buttons

    # Message from other player

    conn = papaya_connection

    number = (y - 1) * 3 + x
    if oxo_markers[conn][number] == " ":
        oxo_buttons[conn][number].children()[0].set_text("X")
        oxo_markers[conn][number] = "X"
        oxo_myturn[conn] = 1
        return

    papaya.message("Noughts and Crosses", "Player tried to take %d, %d which is already taken.  Dodgy client?" % (x, y))
    return

def oxo_quit_clicked(widget, conn):
    global oxo_boards
    global turfgame_playing
    global papaya_connection

    oxo_boards[conn].destroy()
    del oxo_boards[conn]

    papaya_connection = conn
    papaya.send("c15 c" + turfgame_playing["OXO"][conn] + " OXO.quit")

def oxo_reset_clicked(widget, conn):
    global oxo_markers
    global oxo_buttons
    global oxo_myturn
    global turfgame_playing
    global papaya_connection
    
    papaya.message("Noughts and Crosses", "You reset the board.  It is " + turfgame_playing["OXO"][conn] + "'s turn.")

    for i in [1,2,3,4,5,6,7,8,9]:
        oxo_markers[conn][i] = " "
        oxo_buttons[conn][i].children()[0].set_text(" ")

    oxo_myturn[conn] = 0

    papaya_connection = conn
    papaya.send("c15 c" + turfgame_playing["OXO"][conn] + " OXO.reset")
    
def oxo_board_clicked(widget, conn):
    global oxo_buttons
    global oxo_signals
    global turfgame_playing
    global oxo_markers
    global papaya_connection
    global oxo_myturn

    if oxo_myturn[conn] == 0:
        papaya.message("Noughts and Crosses", "It's not your turn!")
        return
    
    for i in [1,2,3,4,5,6,7,8,9]:
        if oxo_buttons[conn][i] == widget:
            if oxo_markers[conn][i] == " ":
                # Send that we've clicked this button to the other user.
                column = (i - 1)/ 3 + 1
                row = i % 3
                if row == 0:
                    row = 3

                msg = 'c15 c%s OXO.select %d %d' % (turfgame_playing["OXO"][conn], row, column)
                papaya_connection = conn
                papaya.send(msg)

                widget.children()[0].set_text("O")

#                widget.set_text("O")
                oxo_markers[conn][i] = "O"
                oxo_myturn[conn] = 0
                return
            else:
                # Print an error message to us.
                papaya.message("Noughts and Crosses", "That square has already been selected.  Please choose another.")
                return

    papaya.message("Unable to find button clicked in list.")
    return

def oxo_create_board(conn):
    global oxo_boards
    global oxo_buttons
    global oxo_signals
    global turfgame_playing
    global oxo_markers
    global oxo_myturn

    window = GtkWindow(WINDOW_TOPLEVEL)
    window.set_title(conn + " - Noughts and Crosses vs " + turfgame_playing["OXO"][conn])
    window.show()

    # Create nine buttons -- initially blank, will turn to O or X
    # Laid out in a homogenous table.

    vbox = GtkVBox(2)
    vbox.show()
    vbox.set_homogeneous(FALSE)
    window.add(vbox)

    table = GtkTable(3, 3, TRUE)
    table.show()
    vbox.pack_start(table, TRUE, TRUE, 0)

    oxo_myturn[conn] = 0
    oxo_buttons[conn] = {}
    oxo_markers[conn] = {}
    oxo_signals[conn] = {}
    for i in [1,2,3,4,5,6,7,8,9]:
        oxo_buttons[conn][i] = GtkButton(" ")
        oxo_buttons[conn][i].show()
        oxo_markers[conn][i] = " "
        # Add events to the buttons
        oxo_signals[conn][i] = oxo_buttons[conn][i].connect("clicked", oxo_board_clicked, conn)

    # Add the buttons to the table.
    
    table.attach(oxo_buttons[conn][1], 0, 1, 0, 1)
    table.attach(oxo_buttons[conn][2], 1, 2, 0, 1)
    table.attach(oxo_buttons[conn][3], 2, 3, 0, 1)
    table.attach(oxo_buttons[conn][4], 0, 1, 1, 2)
    table.attach(oxo_buttons[conn][5], 1, 2, 1, 2)
    table.attach(oxo_buttons[conn][6], 2, 3, 1, 2)
    table.attach(oxo_buttons[conn][7], 0, 1, 2, 3)
    table.attach(oxo_buttons[conn][8], 1, 2, 2, 3)
    table.attach(oxo_buttons[conn][9], 2, 3, 2, 3)

    hbuttonbox = GtkHButtonBox()
    hbuttonbox.show()

    quit_button = GtkButton("Quit Game")
    quit_button.show()
    quit_button.connect("clicked", oxo_quit_clicked, conn) 

    reset_button = GtkButton("Reset Game")
    reset_button.show()
    reset_button.connect("clicked", oxo_reset_clicked, conn)

    hbuttonbox.pack_start(quit_button)
    hbuttonbox.pack_start(reset_button)

    vbox.pack_start(hbuttonbox, FALSE, FALSE, 0)

    oxo_boards[conn] = window
    
def oxo_clicked(extra, row, column, more, conn):
    global oxo_clists
    global papaya_connection

    name = oxo_clists[conn].get_text(row, 0)

    # Send a challenge to 'name'
    papaya_connection = conn
    papaya.send("c15 c" + name + " OXO.challenge")

def oxo_destroyed(object, args):
    global oxo_windows

    for key in oxo_windows.keys():
        if oxo_windows[key] == object:
            oxo_destroy_widget(key)

def oxo_destroy_widget(key):
    global oxo_windows
    global oxo_clists
    global oxo_players
    
    if oxo_windows.has_key(key) == 1:
        del oxo_windows[key]
    if oxo_clists.has_key(key) == 1:
        del oxo_clists[key]
    if oxo_players.has_key(key) == 1:
        del oxo_players[key]

def oxo_create_widget(conn):

    global oxo_windows
    global oxo_clists

    window = GtkWindow(WINDOW_TOPLEVEL)
    window.set_title(conn + " - Noughts and Crosses")
    window.connect("destroy", oxo_destroyed, 'disconnect')
    window.show(window)

    clist = GtkCList(1, ['Willing Players'])
    clist.show()
    window.add(clist)

    clist.connect("select_row", oxo_clicked, conn)

    oxo_windows[conn] = window
    oxo_clists[conn] = clist

def oxo_widget_redraw(conn):

    global oxo_clists
    global oxo_players

    # Remove the contents of the clist
    oxo_clists[conn].clear()

    for i in oxo_players[conn]:
        oxo_clists[conn].append([i])

def oxo_init():

    global oxo_windows
    global oxo_players
    global oxo_clists
    global oxo_challenge_window
    global oxo_buttons
    global oxo_signals
    global oxo_boards
    global oxo_markers
    global oxo_myturn
    global oxo_parser
    global arg_parser

    oxo_windows = {}
    oxo_players = {}
    oxo_clists = {}
    oxo_challenge_window = {}
    oxo_buttons = {}
    oxo_signals = {}
    oxo_boards = {}
    oxo_markers = {}
    oxo_myturn = {}

    oxo_parser = re.compile("([^ ]+) OXO\.([^ ]+)(.*)")
    arg_parser = re.compile(" ([1-3]) ([1-3])")

    papaya.turf_add("oxo_client_protocol")

    turfgame_register("OXO", oxo_accept, oxo_decline, oxo_terminate, oxo_reset)

oxo_init()
