#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "zchat.h"

extern int session_id;
extern struct connection * first_connection;

void on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_help_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_chat_input_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  char text[16384];
  char * data;
  struct command * comm;
  char * tmpptr = (char *)&session_id;

  sprintf(text, "You chat to everyone: '%s'\n", gtk_entry_get_text(GTK_ENTRY(chat_input)));
  gtk_text_insert(GTK_TEXT(chat_output), NULL, NULL, NULL, text, -1);

  sprintf(text, "%s chats to everyone: '%s'\n", get_chat_name(), gtk_entry_get_text(GTK_ENTRY(chat_input)));
  if (strlen(text) == 0)
    return;
  gtk_entry_set_text(GTK_ENTRY(chat_input), "");

  printf("Text to send is %s\n", text);

  // Create a command and send this text to everyone.
  comm = new_command();
  comm->id = TextEverybody;

  comm->len = strlen(text) + 4;
  data = (char *)malloc(strlen(text) + 5);
  data[0] = tmpptr[0];
  data[1] = tmpptr[1];
  data[2] = tmpptr[2];
  data[3] = tmpptr[3];
  memcpy(data+4, text, strlen(text) + 1);
  comm->data = data;
  build_command(comm);

  send_command_to_all(comm);
  // Parse the data in the chat input area.
  delete_command(comm);

  // @@  interpret(text);

}

GtkWidget * connect_dialog = NULL;

void connect_selected (GtkMenuItem * menuitem, gpointer data) {

  if (connect_dialog) {
    gtk_widget_show(connect_dialog);
    return;
  }

  connect_dialog = create_chat_connect_window();
  gtk_widget_show(connect_dialog);
}

void disconnect_selected (GtkMenuItem * menuitem, gpointer data) {
  // @@ Complete me
}

void on_connection_ok_clicked (GtkButton * button, gpointer user_data) {

  char host[16384];
  char port_str[16384];
  int port;

  // Parse the data in the boxes.
  sprintf(host, "%s", gtk_entry_get_text(GTK_ENTRY(host_entry)));
  sprintf(port_str, "%s", gtk_entry_get_text(GTK_ENTRY(port_entry)));
  port = atoi(port_str);

  // Create a connection to the server.
  if (!connect_to_client(host, port))
    printf("Connection to %s port %d failed.\n", host, port);

  // Destroy the dialog box.
  gtk_widget_hide(connect_dialog);
  gtk_widget_destroy(connect_dialog);
  connect_dialog = NULL;
}


void on_connection_cancel_clicked (GtkButton * button, gpointer user_data) {
  gtk_widget_hide(connect_dialog);
  gtk_widget_destroy(connect_dialog);
  connect_dialog = NULL;
}

void list_selected(GtkMenuItem * item, gpointer data) {
  list_connections();
}

void on_request_lists_selected(GtkMenuItem * item, gpointer data) {

  struct connection * tmp = first_connection;

  for (;tmp; tmp = tmp->next) {
    if (tmp->status == ConnConnected) {
      struct command * cmd = new_command();
      cmd->id = RequestConnections;
      cmd->len = 0;
      cmd->data = NULL;
      
      build_command(cmd);
      send_command(tmp, cmd);
    }
  }
}
