#!/bin/bash

set -e

PARAMSPIDER_EXPECTED_OUTPUT='debian/tests/output/expected_output.txt'
PARAMSPIDER_TMP="${AUTOPKGTEST_TMP:-/tmp}/paramspider_test"

mkdir -p "$PARAMSPIDER_TMP"

# Copy expected output to temporary directory
cp -r "$PARAMSPIDER_EXPECTED_OUTPUT" "$PARAMSPIDER_TMP/"
cd "$PARAMSPIDER_TMP"

if ! paramspider --domain 'testphp.vulnweb.com'; then
  echo "Error: paramspider command failed. Exiting with code 77."
  exit 77
fi

paramspider_output=$(sort < 'results/testphp.vulnweb.com.txt')
expected_output=$(sort < 'expected_output.txt')

# Compare the sorted paramspider output with the sorted expected output
if [ "$paramspider_output" == "$expected_output" ]; then
    echo "Output matches the content of the file!"
else
    echo "Output does not match the expected content."
    diff -u <(echo "$expected_output") <(echo "$paramspider_output")
    exit 1
fi

# Clean up temporary directory
rm -rf "$PARAMSPIDER_TMP"
