/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <LightAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for LightAttributes::LightType
//

static const char *LightType_strings[] = {
"Ambient", "Object", "Camera"
};

std::string
LightAttributes::LightType_ToString(LightAttributes::LightType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return LightType_strings[index];
}

std::string
LightAttributes::LightType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return LightType_strings[index];
}

bool
LightAttributes::LightType_FromString(const std::string &s, LightAttributes::LightType &val)
{
    val = LightAttributes::Ambient;
    for(int i = 0; i < 3; ++i)
    {
        if(s == LightType_strings[i])
        {
            val = (LightType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Init utility for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LightAttributes::Init()
{
    enabledFlagCanBeToggled = true;
    enabledFlag = true;
    type = Camera;
    direction[0] = 0;
    direction[1] = 0;
    direction[2] = -1;
    brightness = 1;

    LightAttributes::SelectAll();
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Copy utility for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LightAttributes::Copy(const LightAttributes &obj)
{
    enabledFlagCanBeToggled = obj.enabledFlagCanBeToggled;
    enabledFlag = obj.enabledFlag;
    type = obj.type;
    direction[0] = obj.direction[0];
    direction[1] = obj.direction[1];
    direction[2] = obj.direction[2];

    color = obj.color;
    brightness = obj.brightness;

    LightAttributes::SelectAll();
}

// Type map format string
const char *LightAttributes::TypeMapFormatString = LIGHTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t LightAttributes::TmfsStruct = {LIGHTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Default constructor for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::LightAttributes() : 
    AttributeSubject(LightAttributes::TypeMapFormatString),
    color(255, 255, 255)
{
    LightAttributes::Init();
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Constructor for the derived classes of LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::LightAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    color(255, 255, 255)
{
    LightAttributes::Init();
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Copy constructor for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::LightAttributes(const LightAttributes &obj) : 
    AttributeSubject(LightAttributes::TypeMapFormatString)
{
    LightAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LightAttributes::LightAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::LightAttributes(const LightAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LightAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LightAttributes::~LightAttributes
//
// Purpose: 
//   Destructor for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LightAttributes::~LightAttributes()
{
    // nothing here
}

LightAttributes& 
LightAttributes::operator = (const LightAttributes &obj)
{
    if (this == &obj) return *this;
    enabledFlagCanBeToggled = obj.enabledFlagCanBeToggled;
    if (enabledFlagCanBeToggled)
        enabledFlag = obj.enabledFlag;
    type = obj.type;
    direction[0] = obj.direction[0];
    direction[1] = obj.direction[1];
    direction[2] = obj.direction[2];

    color = obj.color;
    brightness = obj.brightness;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: LightAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::operator == (const LightAttributes &obj) const
{
    // Compare the direction arrays.
    bool direction_equal = true;
    for(int i = 0; i < 3 && direction_equal; ++i)
        direction_equal = (direction[i] == obj.direction[i]);

    // Create the return value
    return ((enabledFlagCanBeToggled == obj.enabledFlagCanBeToggled) &&
            (enabledFlag == obj.enabledFlag) &&
            (type == obj.type) &&
            direction_equal &&
            (color == obj.color) &&
            (brightness == obj.brightness));
}

// ****************************************************************************
// Method: LightAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::operator != (const LightAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LightAttributes::TypeName
//
// Purpose: 
//   Type name method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
LightAttributes::TypeName() const
{
    return "LightAttributes";
}

// ****************************************************************************
// Method: LightAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LightAttributes *tmp = (const LightAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LightAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LightAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LightAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LightAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LightAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LightAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LightAttributes(*this);
    else
        retval = new LightAttributes;

    return retval;
}

// ****************************************************************************
// Method: LightAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LightAttributes::SelectAll()
{
    Select(ID_enabledFlagCanBeToggled, (void *)&enabledFlagCanBeToggled);
    Select(ID_enabledFlag,             (void *)&enabledFlag);
    Select(ID_type,                    (void *)&type);
    Select(ID_direction,               (void *)direction, 3);
    Select(ID_color,                   (void *)&color);
    Select(ID_brightness,              (void *)&brightness);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LightAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LightAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LightAttributes.
    DataNode *node = new DataNode("LightAttributes");

    if(completeSave || !FieldsEqual(ID_enabledFlagCanBeToggled, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabledFlagCanBeToggled", enabledFlagCanBeToggled));
    }

    if(completeSave || !FieldsEqual(ID_enabledFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabledFlag", enabledFlag));
    }

    if(completeSave || !FieldsEqual(ID_type, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("type", LightType_ToString(type)));
    }

    if(completeSave || !FieldsEqual(ID_direction, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("direction", direction, 3));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;
    if(completeSave || !FieldsEqual(ID_brightness, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("brightness", brightness));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LightAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LightAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LightAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("enabledFlagCanBeToggled")) != 0)
        SetEnabledFlagCanBeToggled(node->AsBool());
    if((node = searchNode->GetNode("enabledFlag")) != 0)
        SetEnabledFlag(node->AsBool());
    if((node = searchNode->GetNode("type")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetType(LightType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LightType value;
            if(LightType_FromString(node->AsString(), value))
                SetType(value);
        }
    }
    if((node = searchNode->GetNode("direction")) != 0)
        SetDirection(node->AsDoubleArray());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
    if((node = searchNode->GetNode("brightness")) != 0)
        SetBrightness(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LightAttributes::SetEnabledFlagCanBeToggled(bool enabledFlagCanBeToggled_)
{
    enabledFlagCanBeToggled = enabledFlagCanBeToggled_;
    Select(ID_enabledFlagCanBeToggled, (void *)&enabledFlagCanBeToggled);
}

void
LightAttributes::SetEnabledFlag(bool enabledFlag_)
{
    if (enabledFlagCanBeToggled)
    {
        enabledFlag = enabledFlag_;
        Select(1, (void *)&enabledFlag);
    }
}

void
LightAttributes::SetType(LightAttributes::LightType type_)
{
    type = type_;
    Select(ID_type, (void *)&type);
}

void
LightAttributes::SetDirection(const double *direction_)
{
    direction[0] = direction_[0];
    direction[1] = direction_[1];
    direction[2] = direction_[2];
    Select(ID_direction, (void *)direction, 3);
}

void
LightAttributes::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(ID_color, (void *)&color);
}

void
LightAttributes::SetBrightness(double brightness_)
{
    brightness = brightness_;
    Select(ID_brightness, (void *)&brightness);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
LightAttributes::GetEnabledFlagCanBeToggled() const
{
    return enabledFlagCanBeToggled;
}

bool
LightAttributes::GetEnabledFlag() const
{
    return enabledFlag;
}

LightAttributes::LightType
LightAttributes::GetType() const
{
    return LightType(type);
}

const double *
LightAttributes::GetDirection() const
{
    return direction;
}

double *
LightAttributes::GetDirection()
{
    return direction;
}

const ColorAttribute &
LightAttributes::GetColor() const
{
    return color;
}

ColorAttribute &
LightAttributes::GetColor()
{
    return color;
}

double
LightAttributes::GetBrightness() const
{
    return brightness;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LightAttributes::SelectDirection()
{
    Select(ID_direction, (void *)direction, 3);
}

void
LightAttributes::SelectColor()
{
    Select(ID_color, (void *)&color);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LightAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LightAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_enabledFlagCanBeToggled: return "enabledFlagCanBeToggled";
    case ID_enabledFlag:             return "enabledFlag";
    case ID_type:                    return "type";
    case ID_direction:               return "direction";
    case ID_color:                   return "color";
    case ID_brightness:              return "brightness";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LightAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LightAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_enabledFlagCanBeToggled: return FieldType_bool;
    case ID_enabledFlag:             return FieldType_bool;
    case ID_type:                    return FieldType_enum;
    case ID_direction:               return FieldType_doubleArray;
    case ID_color:                   return FieldType_color;
    case ID_brightness:              return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LightAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LightAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_enabledFlagCanBeToggled: return "bool";
    case ID_enabledFlag:             return "bool";
    case ID_type:                    return "enum";
    case ID_direction:               return "doubleArray";
    case ID_color:                   return "color";
    case ID_brightness:              return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LightAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LightAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LightAttributes &obj = *((const LightAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_enabledFlagCanBeToggled:
        {  // new scope
        retval = (enabledFlagCanBeToggled == obj.enabledFlagCanBeToggled);
        }
        break;
    case ID_enabledFlag:
        {  // new scope
        retval = (enabledFlag == obj.enabledFlag);
        }
        break;
    case ID_type:
        {  // new scope
        retval = (type == obj.type);
        }
        break;
    case ID_direction:
        {  // new scope
        // Compare the direction arrays.
        bool direction_equal = true;
        for(int i = 0; i < 3 && direction_equal; ++i)
            direction_equal = (direction[i] == obj.direction[i]);

        retval = direction_equal;
        }
        break;
    case ID_color:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    case ID_brightness:
        {  // new scope
        retval = (brightness == obj.brightness);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

