#!perl
# Copyright (C) 2001-2005, The Perl Foundation.
# $Id: /local/t/library/pcre.t 12838 2006-05-30T14:19:10.150135Z coke  $

use strict;
use warnings;
use lib qw( t . lib ../lib ../../lib );
use Test::More;
use Parrot::Test;


=head1 NAME

t/library/pcre.t - testing library/pcre.pir

=head1 SYNOPSIS

    % prove t/library/pcre.t

=head1 DESCRIPTION

This program tests whether the 'pcre.pir' library accesses
the installed PCRE library, and matches patterns successfully.

=cut


# if we keep pcre, we need a config test
my $cmd = ($^O =~ /MSWin32/) ? "pcregrep --version" : "pcre-config --version";
my $has_pcre = 0 == Parrot::Test::run_command(
    $cmd, STDERR => File::Spec->devnull,
);

SKIP: {
    skip("no pcre-config", Test::Builder->new()->expected_tests())
        unless $has_pcre;

## 1
pir_output_is( <<'CODE', <<'OUT', 'soup to nuts' );


.sub main :main
    load_bytecode "library/pcre.pir"
    .local pmc func
    .local pmc lib


    find_global func, 'PCRE', 'init'
    if_null func, NOK1
    branch OK1
NOK1:
    print 'not '
OK1:
    print "ok 1\n"

    lib= func()
    if_null lib, NOK2
    branch OK2
NOK2:
    print 'not '
OK2:
    print "ok 2\n"


    .local string s
    .local string pat

    s= '--a--'
    pat= 'a'

    .local pmc code
    .local string error
    .local int errptr

    func= find_global 'PCRE', 'compile'
    ( code, error, errptr )= func( pat, 0 )

    .local int is_code_defined
    is_code_defined= defined code
    if is_code_defined goto OK3
    print 'not '
OK3:
    print "ok 3\n"

    .local int ok
    .local pmc result

    func= find_global 'PCRE', 'match'
    ( ok, result )= func( code, s, 0, 0 )

    unless ok < 0 goto OK4
    print 'not '
OK4:
    print "ok 4\n"

    .local int i
    i= 0
    .local string match

    func= find_global 'PCRE', 'dollar'
    match= func( s, ok, result, i )
    if 'a' == match goto OK5
    print 'not '
OK5:
    print "ok 5\n"

.end
CODE
ok 1
ok 2
ok 3
ok 4
ok 5
OUT

};


## remember to change the number of tests! :-)
BEGIN { plan tests => 1; }

