///
// Copyright (C) 2003, 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "dialogwrap.h"

DialogWrap::DialogWrap(const Glib::ustring& name)
  : Gtk::Dialog(name + " - Passepartout",
		false /* modal */, false /* separator */)
{}

DialogWrap::DialogWrap(const Glib::ustring& name, Gtk::Window& parent)
  : Gtk::Dialog(name + " - Passepartout",
		parent, true /* modal */, false /* separator */)
{}

void DialogWrap::show_raise() {
  Glib::RefPtr<Gdk::Window> win = get_window();
  win->show();			// uniconify if necessary
  win->raise();			// raise if necessary
}

Gtk::Button* DialogWrap::fix_button(Gtk::Button* button, int action_id) {
  Gtk::Button *b = manage(button);
  // Note: It seems that activate means "in any way except a simple click".
  // So we have to add callbacks for both activate and clicked.
  b->signal_clicked().connect(bind(slot(*this, &Gtk::Dialog::on_response),
				   action_id));
  b->signal_activate().connect(bind(slot(*this, &Gtk::Dialog::on_response),
				    action_id));
  return b;
}

UtilityWindow::UtilityWindow(const Glib::ustring& name) {
  set_title(name + " - Passepartout");
}

void UtilityWindow::show_raise() {
  Glib::RefPtr<Gdk::Window> win = get_window();
  win->show();			// uniconify if necessary
  win->raise();			// raise if necessary
}
