/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

/*
  Prototypes for functions handling the conversion of a file
  in the PDB format to a dihedral angle format.
*/
#ifndef PDB_DHL1_H
#define PDB_DHL1_H

#include "Pdb_line.h"
#include<map>
#include<string>

const int NUM_PDB_LINES=700;

void read_file(char* filename,
	       Pdb_line* memfile);

void prt_seq_Nterm(ofstream& f_out2,
		   char* Nendgrp);

void prt_seq_Cterm(ofstream& f_out2,
		   char* Cendgrp);

void prt_seq(Pdb_line* memfile,
	     char dir,
	     char* filename,
	     char* Nendgrp,
	     char* Cendgrp);

void pdb_to_dhl(Pdb_line* memfile,
		char dir,
		char* filename,
		char* Nendgrp,
		char* Cendgrp);

void ppo_Nterm(Pdb_line* memfile,
	       map<string, int>& m0, map<string, int>& m1,
	       map<string, int>& m2,
	       double* ppo,
	       double* x,double* y,double* z,
	       char* Nendgrp);

void ppo_Cterm(Pdb_line* memfile,
	       map<string, int>& m0, map<string, int>& m1,
	       map<string, int>& m2,
	       double* ppo,
	       double* x,double* y,double* z,
	       char* Cendgrp);

void fill_first_3(Pdb_line* memfile,
		  char dir,
		  map<string, int>& m0, map<string, int>& m1,
		  map<string, int>& m2,
		  string& m0key, string& m1key, string& m2key,
		  int& idx);

void write_dhl_line(double* ppo,
		    double* chi,
		    int chicnt,
		    ofstream& f_out);

void lp_comp(Pdb_line* memfile,
	     char dir,
	     map<string, int>& m0, map<string, int>& m1,
	     map<string, int>& m2,
	     double* ppo,
	     double* chi,
	     int* chicnt,
	     double* x,double* y,double* z,
	     int& idx,
	     char* resname,
	     ofstream& f_out);

void ppo_dhl(Pdb_line* memfile,
	     map<string, int>& m0, map<string, int>& m1,
	     map<string, int>& m2,
	     double* ppo,
	     double* x, double* y, double* z);

void mult_mat_vec(double A[][3],double B[],double C[]);

double dihedral_angle(double x[4],double y[4],double z[4]);

void chi_dhl(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z,
	     char* resname);

void prt_inp_Nterm(ofstream& f_out,
		   char* Nendgrp);

void prt_inp_Cterm(ofstream& f_out,
		   char* Cendgrp);

#endif
