/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

#include "Pdb_line.h"

/* Pdb_line constructor. Note the default values for some fields.
   
   (For this project, many fields were unnecessary and
   have been commented out.)
*/
Pdb_line::
Pdb_line(){
  
  bl_count = new int[BL_ARRAY_SIZE];
  /*
    header = new char[7];
    header[0]=' '; header[1]='\0';
  */
  atname = new char[5];
  atname[0]=' '; atname[1]='\0';
  /*atnum = 0; */
  altloc = ' ';
  resname = new char[5];
  resname[0]=' '; resname[1]='\0';
  /*chainid = ' '; */
  resnum = 0;
  /*icode = ' '; */
  x=0.000;y=0.000;z=0.000;
  /*occup=1.0;bfac=.00; */

  /*
    new_pos_str = new char[30];
    blanks = new char[5];
  */
}

/* Pdb_line destructor.
 */
Pdb_line::
~Pdb_line(){
  /*
    delete[] header;
  */
  delete[] bl_count;
  delete[] atname;
  delete[] resname;
  /*
    delete[] new_pos_str;
    delete[] blanks;
  */
}

/*
Pdb_line&
Pdb_line::
operator=(Pdb_line& from){

  int i;
  // Copy bl_count
  for(i=0; i<BL_ARRAY_SIZE; i++)
    bl_count[i] = from.bl_count[i];

  // Copy header
  for(i=0; i<7; i++)
    header[i] = from.header[i];

  // Copy atname, resname, blanks
  for(i=0; i<5; i++){
    atname[i] = from.atname[i];
    resname[i] = from.resname[i];
    blanks[i] = from.blanks[i];
  }

  atnum = from.atnum;
  altloc = from.altloc;
  chainid = from.chainid;
  resnum = from.resnum;
  icode = from.icode;
  x = from.x; y = from.y; z = from.z;
  occup = from.occup; bfac = from.bfac;

  for(i=0; i<30; i++)
    new_pos_str[i] = from.new_pos_str[i];

  return *this;
}
*/

/* Should have to read from the disk only
   once per execution sequence. Doing so
   more than once per exec. seq. may result
   in a segmentation fault.
*/
bool
Pdb_line::read_file(ifstream& f_in, char* line){

/* Assume f_in is at start of a line*/

  if(f_in.eof()){
    return false;
  }
  else if(!f_in){
    cerr << "File is not opened for input." << endl;
    exit(1);
  }
  else {
    char* substr = new char[20];
    int size;
    size = fline_to_str(f_in, line, size);
//  cout << "line: " << line << endl;
// fill header:
//  extract_str(substr,line,size,0,5,-1,0);
//  strcpy(header,substr);
//  cout << "header: " << header << endl;
// atnum:
//  extract_str(substr,line,size,6,10,0,1);
//  atnum = atoi(substr);
//  cout << "atnum: " << atnum << endl; 
// atname:
    extract_str(substr,line,size,12,15,-1,0);
    strcpy(atname,substr);
//  cout << "atname:" << atname << endl;
// altloc:
    extract_str(substr,line,size,16,16,-1,0);
    altloc = substr[0];
//  cout << "altloc: " << altloc << endl;
// resname:
    extract_str(substr,line,size,17,19,-1,0);
    strcpy(resname,substr);
//  cout << "resname: " << resname << endl;
// chainid:
//  extract_str(substr,line,size,21,21,-1,0);
//  chainid = substr[0];
//  cout << "chainid: " << chainid << endl;
// resnum:
    extract_str(substr,line,size,22,25,1,1);
    resnum = atoi(substr);
//  cout << "resnum: " << resnum << endl;
// icode:
//  extract_str(substr,line,size,26,26,-1,0);
//  icode = substr[0];
//  cout << "icode: " << icode << endl;
// x,y,z,occup,bfac:
    extract_str(substr,line,size,30,37,2,1);
    x = atof(substr);
    extract_str(substr,line,size,38,45,3,1);
    y = atof(substr);
    extract_str(substr,line,size,46,53,4,1);
    z = atof(substr);
//  cout << "x,y,z: " << x << " " << y << " " << z << endl;
//  extract_str(substr,line,size,54,59,5,1);
//  occup = atof(substr);
//  cout << "occup: " << occup << endl;
//  extract_str(substr,line,size,60,65,6,1);
//  bfac = atof(substr);
//  cout << "bfac: " << bfac << endl;

  delete[] substr;

  }
  return true;
}

/*
   Fills substr with specified portion
   of the ATOM line. Prepares bl_count[]
   for file writing purposes (not used
   by pdb2dhl program).

   (If reading a number (bool num=1):
   count number of blanks; begin
   reading number into substr at 1st
   non-blank.)
*/
void
Pdb_line::extract_str(char* substr,
		      char* line,
		      int line_size,
		      int begin,
		      int end,
		      int bl,
		      bool num){
  if(num==1) bl_count[bl] = 0;

  if((end > (line_size-1)) && num==0){  // Catch wrong input (character(s)).
    substr[0]='\0';
    return; 
  }
  else if(end > (line_size-1)){         // Catch wrong input (number).
    bl_count[bl]=-1;
    return;
  }
  else if(num==0){                      // If extracting character(s):
    int j=0;
    for(int i=begin; i<=end; i++,j++){  // Construct substring.
      substr[j] = line[i];
    }
    substr[j] = '\0';
  }
  else {
    int j=0;
    for(int i=begin; i<=end; i++,j++){  // If extracting a number:
      if(line[i]==' '){                 // Compute amount of padding (may be useful).
        ++bl_count[bl]; 
        j=-1;
        continue;
      }
      substr[j] = line[i];              // Construct substring.
    }
    substr[j] = '\0';
  }
}

/* Fill char* line with the whole ATOM line
   (including blanks). "size" can be used for
   error-handling purposes.
*/
int
Pdb_line::
fline_to_str(ifstream& f_in, char* line, int size){
  size = 0;
  f_in.unsetf(ios::skipws);
  int i=0;
  f_in >> line[i];

  while(line[i] != '\n' && !f_in.eof()){
    ++i;

    f_in >> line[i];

    ++size;
  }
  line[i] = '\0';
  return size;
}

/* Writes one ATOM line to disk.
 */
/*
void
Pdb_line::write_pdb_file(ofstream& f_out){
 
  // 4 blanks max 
  f_out << header;
  make_blanks(bl_count[0]);
  f_out << blanks;
  f_out << atnum;
  f_out << " ";
  f_out << atname;
  f_out << altloc;
  f_out << resname;
  f_out << " ";
  f_out << chainid;
  make_blanks(bl_count[1]);
  f_out << blanks;
  f_out << resnum;
  f_out << icode;
  f_out << "   ";
  make_blanks(bl_count[2]);
  f_out << blanks;
  write_file(f_out, gen3(x));
  make_blanks(bl_count[3]);
  f_out << blanks;
  write_file(f_out, gen3(y));
  make_blanks(bl_count[4]);
  f_out << blanks;
  write_file(f_out, gen3(z));
  make_blanks(bl_count[5]);
  f_out << blanks;
  write_file(f_out, gen2(occup));
  make_blanks(bl_count[6]);
  f_out << blanks;
  write_file(f_out, gen2(bfac));
  //f_out << '\n';

}
*/

/* Creates whitespace padding for a field of an
   ATOM line.
*/
/*
void
Pdb_line::make_blanks(int blc){

  if(blc==-1){                          // No padding needed here.
    blanks[0] = '\0';
    return;
  }
  int i;
  for(i=0; i<blc; i++)
    blanks[i] = ' ';
  blanks[i] = '\0';
}
*/

/* Computes how much whitespace should be
   used to pad a number field of an ATOM line.
*/
/*
void
Pdb_line::set_pos_bl_count(char fld,
			   double new_pos){
  int bl_idx;
  int len=0, i=0;

  // Access bl_count correctly (with appropriate
  // bl_idx value):

  if(fld=='x'){ // if x
    bl_idx = 2; 
  }
  else if(fld=='y'){ // if y
    bl_idx = 3;
  }
  else{ // if z
    bl_idx = 4;
  }

  sprintf(new_pos_str,"%f",new_pos);    // Create char* from double.
  while(new_pos_str[i] != '.'){         // Compute amount of padding needed.
    ++len;
    ++i;
  }
  len = len+4;
  len = 8-len;                          // x,y,z fields are 8 chars long.

  bl_count[bl_idx] = len; 

}
*/

/* Effectively delete a blank from ATOM line at the
   specified field. (Not all fields are padded).
*/
/*
void
Pdb_line::chp_blnk(int idx){
  bl_count[idx]--;
}
*/

Format Pdb_line::gen3(3);
Format Pdb_line::gen2(2);

