##########################################################################################
## pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format     ##
## Copyright (C) 2002  Farokh Jamalyaria                                                ##
##                                                                                      ##
## This program is free software; you can redistribute it and/or                        ##
## modify it under the terms of the GNU General Public License                          ##
## as published by the Free Software Foundation; either version 2                       ##
## of the License, or (at your option) any later version.                               ##
##                                                                                      ##
## This program is distributed in the hope that it will be useful,                      ##
## but WITHOUT ANY WARRANTY; without even the implied warranty of                       ##
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                        ##
## GNU General Public License for more details.                                         ##
##                                                                                      ##
## You should have received a copy of the GNU General Public License                    ##
## along with this program; if not, write to the Free Software                          ##
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.          ##
##                                                                                      ##
## Author's contact information:                                                        ##
## Farokh Jamalyaria, farokhj@yahoo.com                                                 ##
## 9 Commons Lobby G222                                                                 ##
## College Station, TX 77840                                                            ##
##########################################################################################

#!/usr/bin/perl

# This program extracts ATOM lines of a PDB file,
# clips each to an acceptable length for my PDB
# reader, and then outputs to a PDB file of name
# <original-name>.ATOM.

# command-line args: <inp_file>.pdb

$in_file = $ARGV[0];
open (IN, $in_file) || die "cannot open $in_file";

# remove the ".pdb" from the filename:
for($i = 0; $i <=3; $i++){
  chop($in_file);
}

# construct output filename:
$out_file = ">>$in_file" . ".ATOM";

open (OUT, $out_file) || die "cannot open $out_file";

while(<IN>) {
  if (/^ATOM\b/){
    $line = $_;
    $line = clip($line);	# clip the line, then
    push(@lines,$line);		# push line onto array.
  }
}

$length = @lines;

# remove newline from last line:
chop(@lines[$length-1]);

# write the lines:
for($i=0; $i < $length; $i++){
  print OUT $lines[$i];
}

close(IN) || die "cannot close $in_file";
close(OUT) || die "cannot close $out_file";

## Subroutines:

# clip the line to an acceptable length (67 chars,
# counting newline):
sub clip {
  $line = $_[0];
  $size = length($line);
  while($size > 66){
    chop($line);
    $size--;
  }
  $line = $line . "\n";
  return $line;
}
