/*
 * dialog_filechooser.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_DIALOG_FILECHOOSER_H
#define PDFCHAIN_DIALOG_FILECHOOSER_H

#include "pdfchain.h"
#include "dialog_filechooser_extension.h"


/*** File Chooser Dialogs *****************************************************/

class
cFCDialog : public Gtk::FileChooserDialog
{
	public:
		cFCDialog( Gtk::Window& , const Glib::ustring& , Gtk::FileChooserAction , bool , Pdfchain::Id::FileType );
		virtual ~cFCDialog();

		int run();

	protected:

		static std::string sCurrentFolder;
		Pdfchain::Id::FileType eFileType;

		Gtk::Button	*pButton_Ok,
					*pButton_Cancel;
};


// File Chooser Dialog : Cat - Add files
class
cFCDialog_Cat_AddFiles : public cFCDialog
{
	public:

		cFCDialog_Cat_AddFiles( Gtk::Window& , const Glib::ustring& , Gtk::FileChooserAction , bool , Pdfchain::Id::FileType );
		virtual ~cFCDialog_Cat_AddFiles();

		Glib::ustring getStr_Pages();
		Glib::ustring getStr_EvenOdd();
		Glib::ustring getStr_Rotation();
		Glib::ustring getStr_Password();
		Glib::ustring getCmd_EvenOdd();
		Glib::ustring getCmd_Rotation();
		
	protected:

		cExpander_CatOptions mExpander;
};


// File Chooser Dialog : Save as
class
cFCDialog_SaveAs : public cFCDialog
{
	public:

		cFCDialog_SaveAs( Gtk::Window& , const Glib::ustring& , Pdfchain::Id::FileType );
		virtual ~cFCDialog_SaveAs();

		std::string	get_filename();

	protected:

		Gtk::CheckButton	mCButton_AddExtension;
		Gtk::MessageDialog	mMDialog_OverwriteConfirm;

		std::string	addExtension( std::string );
};



/*** File Chooser Button ******************************************************/

class
cFCButton : public Gtk::FileChooserButton
{
	public:

		cFCButton ( const Glib::ustring& , Gtk::FileChooserAction , Pdfchain::Id::FileType );
		virtual ~cFCButton();
};




#endif