/***********************************************************************
 *
 * Copyright (C) 2010-2011 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#include <QAction>
#include <QtGui>
#include <QtCore>

#include "frmprincipal.h"
#include "constants.h"
#include "funcions.h"
#include "moviment.h"

extern QTranslator *qt_translator;
extern QTranslator *appTranslator;

const int numeroLiniesDadesJoc=3;

const int alcadaMenuBarraTasques=60;

QString localePrograma;

int jocResolt;

//Contador dels intents de trobar una solució
//Evita els casos en què no es troba la solució
//d'un problema que en té
int intentsSolucio=0;


/****************************************
*
*16/12/10: canviat el sistema per mostrar les
* marques personals (void veureRecordsPersonals())
* Ara es fa amb un diàleg per evitar els problemes
* de la finestra flotant.
*
*16/12/10: canviat el sistema per mostrar les
*solucions. Ara es fa a un Tab i s'ha eliminat
*l'opció de menú
*****************************************/


frmPrincipal::frmPrincipal()
{
  localePrograma=QLocale::system().name();

  //jocResolt=false;

  setWindowIcon(QIcon(":/peg-solitaire.png"));
  setWindowTitle( tr("Solitari"));
  setMinimumSize (QSize(600,380));
  this->move(300,100);

   jocFram=new QFrame(this);
   jocFram->setGeometry(0,alcadaMenuBarraTasques,300,300);
   jocFram->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
   jocFram->setMinimumSize(QSize(300,300));

    //rellotge
    rellotgeLabel = new Rellotge(jocFram);
    rellotgeLabel->setMinimumSize(QSize(300,10));
    rellotgeLabel->move(QPoint(0,10));
    rellotgeLabel->setAlignment(Qt::AlignHCenter);
    rellotgeLabel->estableixTemps("00:00:00");

    //Tabs
    tabArbres= new QTabWidget(jocFram);
    tabArbres->setMinimumSize(QSize(290,250));
    tabArbres->move(QPoint(0,50));
    //arbre de figures
    arbreModalitatsJocTreeWidget= new QTreeWidget(jocFram);
    arbreModalitatsJocTreeWidget->setMinimumSize(QSize(280,220));
   // arbreModalitatsJocTreeWidget->move(QPoint(0,70));
    arbreModalitatsJocTreeWidget->expandAll();
   // connect(arbreModalitatsJocTreeWidget,SIGNAL(itemClicked(QTreeWidgetItem*, int)),
     //      this,SLOT(seleccioModalitatJoc(QTreeWidgetItem*, int)));
    connect(arbreModalitatsJocTreeWidget,SIGNAL(itemSelectionChanged()),
          this,SLOT(seleccioModalitatJoc()));
    //S'afegeix a un tab
    tabArbres->addTab(arbreModalitatsJocTreeWidget, tr("Modalitats del joc"));

    //Visualitzador de solucions
    arbreSolucionsTreeWidget= new QTreeWidget(this);
    arbreSolucionsTreeWidget->setMinimumSize(QSize(280,220));
    arbreSolucionsTreeWidget->setColumnCount(2) ;
    arbreSolucionsTreeWidget->setColumnHidden(1,true);
    connect(arbreSolucionsTreeWidget,SIGNAL(itemDoubleClicked(QTreeWidgetItem*, int)),
           this,SLOT(carregaSolucio(QTreeWidgetItem*, int)));
    /*
    solucionsDockWidget = new QDockWidget(tr("Solucions"));
    solucionsDockWidget->setWidget(arbreSolucionsTreeWidget);
    */
   //S'afegeix a un tab
    tabArbres->addTab(arbreSolucionsTreeWidget, tr("Solucions"));

   movimentsUndoStack = new QUndoStack(this);
   taulerJoc= new Tauler (movimentsUndoStack,rellotgeLabel,this,this);
   taulerJoc->move(QPoint(300,alcadaMenuBarraTasques));

   //Rellotge per a les eleccions a l'atzar
    QTime rellotgeQTime (0,0,0);
    rellotgeQTime.currentTime();
    rellotgeQTime.start();

    creaAcccions();
    creaMenus();
    creaBarraTasques();

    llegeixArxiuData();
    carregaArbreModalitatsJoc();
    comprovaDirectoriHome();
    /* 18/01/11
       Eliminat (a Debian) per considerar-ho contrari a les
       "llibertats"
      */
    //comprovaRegistre();
}


/*
  Carrega el contingut de l'arxiu data.sol a la
  llista dadesArxiuData
  */
void  frmPrincipal::llegeixArxiuData(){
    //obrim l'arxiu de jocs
    QString nomArxiu=directoriLinux()+DIRECTORI_ARXIU_GAMES_SOL;
    QFile arxiuData(nomArxiu);
    if (!arxiuData.open(QIODevice::ReadOnly | QIODevice::Text)){
        QMessageBox::critical(this,  tr("Solitari"),
                                QString(tr("No s'ha trobat l'arxiu %1")).arg(nomArxiu) );
         return ;
     }
     QTextStream entrada(&arxiuData);
     QString linia0 = entrada.readLine();
     dadesArxiuData.clear();
     while (!linia0.isNull()) {
         if ( ! (linia0.mid(0,1)=="#") ){
            dadesArxiuData.append(linia0); //tipus de joc
            for(int dades=0 ; dades<numeroLiniesDadesJoc-1;++dades){
            dadesArxiuData.append(entrada.readLine());
          }
         }
       linia0 = entrada.readLine();
     } //final del while de la lectura de l'arxiu
}

void frmPrincipal::carregaArbreModalitatsJoc(){

//Cadenes amb els noms de les modalitats de joc per a la traducció
//El codi de joc de data.sol cal que coincideixi amb l'index a l'array
//El primer és el ròtul de l'arbre amb les modalitats del joc
    static const char * const nomModalitatsJoc[] = {
        QT_TR_NOOP("Modalitats del joc"),
        QT_TR_NOOP("Clàssic"),
        QT_TR_NOOP("Clàssic-simetria"),
        QT_TR_NOOP("Clàssic-casa"),
        QT_TR_NOOP("Clàssic-creu petita"),
        QT_TR_NOOP("Clàssic-creu gran"),
        QT_TR_NOOP("Clàssic-invers"),
        QT_TR_NOOP("Clàssic-superior"),
        QT_TR_NOOP("Clàssic-inferior"),
        QT_TR_NOOP("Clàssic-fletxa 1"),
        QT_TR_NOOP("Clàssic-piràmide 15"),
        QT_TR_NOOP("Clàssic-diamant"),
        QT_TR_NOOP("Clàssic-  1"),
        QT_TR_NOOP("Clàssic- 2"),
        QT_TR_NOOP("Clàssic-rombe"),
        QT_TR_NOOP("Solitari 3x5"),
        QT_TR_NOOP("Triangular 4x7"),
        QT_TR_NOOP("Europeu- 1"),
        QT_TR_NOOP("Asimètric 8x8"),
        QT_TR_NOOP("Clàssic-diagonal"),
        QT_TR_NOOP("Clàssic- 3"),
        QT_TR_NOOP("Clàssic- 4"),
        QT_TR_NOOP("Asimètric-superior"),
        QT_TR_NOOP("Asimètric 8x8- 1"),
        QT_TR_NOOP("Asimètric 8x8- 2"),
        QT_TR_NOOP("Clàssic-central"),
        QT_TR_NOOP("Europeu diagonal- 1"),
        QT_TR_NOOP("Quadrat 5x5"),
        QT_TR_NOOP("Quadrat 5x5- 1"),
        QT_TR_NOOP("Clàssic-quadrat central"),
        QT_TR_NOOP("Clàssic-rectangle central"),
        QT_TR_NOOP("Europeu- 3"),
        QT_TR_NOOP("Clàssic arbre - 1"),
        QT_TR_NOOP("Clàssic- 5"),
        QT_TR_NOOP("Quadrat 5x5-central"),
        QT_TR_NOOP("Quadrat 5x5-H"),
        QT_TR_NOOP("Wiegleb"),
        QT_TR_NOOP("Diamant 9x9"),
        QT_TR_NOOP("Europeu-creu"),
        QT_TR_NOOP("Wiegleb-clàssic"),
        QT_TR_NOOP("Clàssic- 6"),
        QT_TR_NOOP("Clàssic-S"),
        QT_TR_NOOP("Clàssic- 7"),
        QT_TR_NOOP("Europeu diagonal"),
        QT_TR_NOOP("Quadrat 6x6"),
        QT_TR_NOOP("Diamant 5x5"),
        QT_TR_NOOP("Diamant 7x7"),
        QT_TR_NOOP("Anglès antic"),
        QT_TR_NOOP("Incomplet 6x6"),
        QT_TR_NOOP("Incomplet 7x7"),
        QT_TR_NOOP("Wiegleb reduit"),
        QT_TR_NOOP("Solitari 8x9"),
        QT_TR_NOOP("Solitari 5x6"),
        QT_TR_NOOP("Wiegleb-fletxa"),
        QT_TR_NOOP("Clàssic- 8"),
        QT_TR_NOOP("Clàssic-E"),
        QT_TR_NOOP("Clàssic-fletxa 2"),
        QT_TR_NOOP("Clàssic-piràmide 9"),
        QT_TR_NOOP("Clàssic-  9"),
        QT_TR_NOOP("Clàssic- 10"),
        QT_TR_NOOP("Clàssic-R"),
        QT_TR_NOOP("Clàssic-T"),
        QT_TR_NOOP("Diamant 9x9- 1"),
        QT_TR_NOOP("Solitari 5x6- 1"),
        QT_TR_NOOP("Quadrat 6x6- 1"),
        QT_TR_NOOP("Quadrat 5x5- 2"),
        QT_TR_NOOP("Quadrat 5x5-quadrats"),
        QT_TR_NOOP("Triangular 4x7- 1"),
        QT_TR_NOOP("Triangular 4x7- 2"),
        QT_TR_NOOP("Triangular 4x7- 3"),
        QT_TR_NOOP("Triangular 4x7- 4"),
        QT_TR_NOOP("Triangular 4x7- 5"),
        QT_TR_NOOP("Triangular 4x7-quadrat"),
        QT_TR_NOOP("Triangular 4x7-piràmide"),
        QT_TR_NOOP("Wiegleb- 1"),
        QT_TR_NOOP("Quadrat 5x5-piràmide"),
        QT_TR_NOOP("Solitari 7x5"),
        QT_TR_NOOP("Asimètric 6x6"),
        QT_TR_NOOP("Quadrat 9x9"),
        QT_TR_NOOP("Anglès antic-diamant"),
        QT_TR_NOOP("Triangular 5"),
        QT_TR_NOOP("Triangular 4"),
        QT_TR_NOOP("Triangular 5-1"),
        QT_TR_NOOP("Triangular 5-2"),
        QT_TR_NOOP("Triangular 5-3"),
        QT_TR_NOOP("Triangular 6"),
        QT_TR_NOOP("Clàssic- 11"),
        QT_TR_NOOP("Wiegleb-creu petita"),
        QT_TR_NOOP("Wiegleb reduit  1"),
        QT_TR_NOOP("Wiegleb-simetria"),
        QT_TR_NOOP("Wiegleb diagonal"),
        QT_TR_NOOP("Wiegleb reduit  2"),
        QT_TR_NOOP("Wiegleb reduit  3"),
        QT_TR_NOOP("Wiegleb reduit  4"),
        QT_TR_NOOP("Asimètric 6x6 invers"),
        QT_TR_NOOP("Asimètric 8x8 invers"),
        QT_TR_NOOP("Europeu invers"),
        QT_TR_NOOP("Wiegleb invers"),
        QT_TR_NOOP("Wiegleb reduit  invers"),
        QT_TR_NOOP("Solitari 3x5 bis"),
        QT_TR_NOOP("Solitari 4x4"),
        QT_TR_NOOP("Solitari 6x5"),
        QT_TR_NOOP("Solitari 4x5"),
        QT_TR_NOOP("Solitari 3x5 bis- 1"),
        QT_TR_NOOP("Solitari 4x5- 1"),
        QT_TR_NOOP("Solitari 4x5- 2"),
        QT_TR_NOOP("Triangular 6- 1"),
        QT_TR_NOOP("Triangular 7"),
        QT_TR_NOOP("Triangular 8"),
        QT_TR_NOOP("Triangular 9"),        
        QT_TR_NOOP("Europeu diagonal quadrat"),
        QT_TR_NOOP("Clàssic-diagonal molinet"),
        QT_TR_NOOP("Quadrat 5x5- 3"),
        QT_TR_NOOP("Triangular 10"),
        QT_TR_NOOP("Quadrat 8x8"),
        QT_TR_NOOP("Diamant 9x9- 2"),
        QT_TR_NOOP("Clàssic- 12"),
        QT_TR_NOOP("Europeu- 4"),
        QT_TR_NOOP("Clàssic- 13"),
        QT_TR_NOOP("Clàssic- 14"),
        QT_TR_NOOP("Clàssic- 15"),
        QT_TR_NOOP("Clàssic- 16"),
        QT_TR_NOOP("Clàssic- 17"),
        QT_TR_NOOP("Clàssic- 18"),
        QT_TR_NOOP("Clàssic- 19"),
        QT_TR_NOOP("Circular"),
        QT_TR_NOOP("Quadrat 7x7"),
        QT_TR_NOOP("Solitari 7x5 invers"),
        QT_TR_NOOP("Clàssic diagonal - quadrat central"),
        QT_TR_NOOP("Quadrat 5x5- 4"),
        QT_TR_NOOP("Clàssic - O"),
        QT_TR_NOOP("Clàssic - 20"),
        QT_TR_NOOP("Clàssic - 21"),
        QT_TR_NOOP("Clàssic - 22"),
        QT_TR_NOOP("Clàssic arbre - 2"),
        QT_TR_NOOP("Clàssic - 23"),
        QT_TR_NOOP("Clàssic - 24"),
        QT_TR_NOOP("Clàssic - 25"),
        QT_TR_NOOP("Clàssic - 26"),
        QT_TR_NOOP("Clàssic - 27"),
        QT_TR_NOOP("Clàssic - 28"),
        QT_TR_NOOP("Clàssic - 29"),
        QT_TR_NOOP("Clàssic - 30"),
        QT_TR_NOOP("Clàssic - 31"),
        QT_TR_NOOP("Clàssic ampliat"),
        0
    };

    QApplication::setOverrideCursor(Qt::WaitCursor);
     if (dadesArxiuData.size()>0){
         //netejam
         arbreModalitatsJocTreeWidget->clear();
         arbreModalitatsJocTreeWidget->setColumnCount(numeroLiniesDadesJoc);
         arbreModalitatsJocTreeWidget->setColumnHidden(1,true);
         arbreModalitatsJocTreeWidget->setColumnHidden(2,true);
         arbreModalitatsJocTreeWidget->setColumnHidden(3,true);
         arbreModalitatsJocTreeWidget->setColumnHidden(4,true);

         //posam la capçalera de l'arbre
         QTreeWidgetItem *item=new QTreeWidgetItem();
         item->setIcon(0,QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/hi_q.png"));
         item->setText(0,tr(nomModalitatsJoc[0]));
         arbreModalitatsJocTreeWidget->setHeaderItem(item);


         QList<QTreeWidgetItem *> itemsArbre;
         for(int llista=0 ; llista<dadesArxiuData.size()/numeroLiniesDadesJoc;++llista){
               QTreeWidgetItem *item=new QTreeWidgetItem();
               QStringList  tipusJoc = dadesArxiuData.value(llista*numeroLiniesDadesJoc).split(" ");
               item->setText(0,tr(nomModalitatsJoc[tipusJoc.value(0).toInt()]));
               item->setText(1,dadesArxiuData.value(llista*numeroLiniesDadesJoc));
               item->setText(2,dadesArxiuData.value(llista*numeroLiniesDadesJoc+1));
               item->setText(3,dadesArxiuData.value(llista*numeroLiniesDadesJoc+2));
            //   item->setText(4,dadesArxiuData.value(llista*numeroLiniesDadesJoc+3));

               itemsArbre.append(item);
         }
      arbreModalitatsJocTreeWidget->insertTopLevelItems(0,itemsArbre);
      arbreModalitatsJocTreeWidget->expandAll();
      arbreModalitatsJocTreeWidget->sortItems(0,Qt::AscendingOrder);
      //Seleccionam el darrer joc jugat en tancar el programa
     QSettings tipusJoc;
     bool trobat=false;
     int modalidadJoc=tipusJoc.value( QString("General/modalidadJoc"),1).toInt();
      for(int i=0 ; i<arbreModalitatsJocTreeWidget->topLevelItemCount();++i){
          QStringList  modJoc= arbreModalitatsJocTreeWidget->topLevelItem(i)->text(1).split(" ");
          if (modJoc.value(0).toInt()==modalidadJoc){
              arbreModalitatsJocTreeWidget->topLevelItem(i)->setSelected(true);
              arbreModalitatsJocTreeWidget->setCurrentItem(arbreModalitatsJocTreeWidget->topLevelItem(i));
              //seleccioModalitatJoc(arbreModalitatsJocTreeWidget->topLevelItem(i),1);
              //arbreModalitatsJocTreeWidget->clicked();
              trobat=true;
              break;
          }
      }
      if ((! trobat) && ( arbreModalitatsJocTreeWidget->topLevelItemCount()>0)) {
          arbreModalitatsJocTreeWidget->topLevelItem(0)->setSelected(true);
          arbreModalitatsJocTreeWidget->setCurrentItem(arbreModalitatsJocTreeWidget->topLevelItem(0));
      }
     item->setText(0,tr(nomModalitatsJoc[0])+" ("+QString::number(
                arbreModalitatsJocTreeWidget->topLevelItemCount()) +")");
     }
     QApplication::setOverrideCursor(Qt::ArrowCursor);
}

/*
Gestiona la selecció de la modalitat de joc
quan es clica sobre l'arbre de modalitats
*/
//void  frmPrincipal::seleccioModalitatJoc(QTreeWidgetItem *, int){
void  frmPrincipal::seleccioModalitatJoc(){
   // if (!arbreModalitatsJocTreeWidget->selectedItems().isEmpty()){
    if (arbreModalitatsJocTreeWidget->selectedItems().count()==1){
       QTreeWidgetItem *item;
       item=arbreModalitatsJocTreeWidget->selectedItems().first();
       //No s'ha clicat el nus arrel
       if (item->childCount()==0){
           movimentsUndoStack->clear();
           iniciSolucioAction->setEnabled(movimentsUndoStack->canUndo());
           jocResolt=0;
           taulerJoc->joc_CarregaJoc(item->text(1),item->text(2),item->text(3));
        //   taulerJoc->joc_CarregaJoc(item->text(1),item->text(2),item->text(3), item->text(4));

           QSettings records;
           QStringList  tipusJoc = item->text(1).split(" ");
           QString record=records.value( QString("%1/record").arg(tipusJoc.value(0)) ,
                                                                 QString("0")).toString();
           if (record != "0"){
               statusBar()->showMessage(QString(tr("Joc carregat. El vostre record actual és:  %1")).arg(record));}
           else statusBar()->clearMessage();
        //S'ha eliminat perquè causava algún problema
        //En carregar el joc al taulerJoc, s'ha afegit fitInView(sceneRect(), Qt::KeepAspectRatio);
           //Això és per obligar a que el tauler de joc "s'ajusti" a les dimensions del joc
           //seleccionat (sense que disminuexi la finestra)
       //    this->resize(this->size()+QSize(-1,-1)+QSize(1,1));
           solucioJocActual_configuracioInicial.clear();
           solucioJocActual_configuracioInicial.append(taulerJoc->configuracioActual(true));
           //Comprovam l'arxiu de solucions
           comprovaArxiuSolucions();

           //Si les solucions estan visibles, actualitzam
          // if( solucionsDockWidget->isVisible()){veureSolucionsSlot();}
           veureSolucionsSlot();
       }
   }
}


void frmPrincipal::tradueixGUI(){

     surtAction->setText(tr("&Surt"));
     veureRecordsPersonalsAction->setText(tr("Veure records"));
     ajudaAction->setText(tr("Ajuda"));
     creditsPrograma->setText(tr("Credits"));
    // undoAction->setText(tr("&Retrocedeix"));
     //redoAction->setText(tr("&Avança"));

     solucionaJocActual->setText(tr("Resol"));


     aplicacioMenu->setTitle(tr("Programa"));
     movimentsMenu->setTitle(tr("&Moviments joc"));
     idiomaMenu->setTitle(tr("Idioma"));
     ajudaMenu->setTitle(tr("Ajuda"));

    setWindowTitle( tr("Solitari"));

    veureRecordsPersonalsAction->setText(tr("Veure marques personals"));
    eliminaRecordsPersonalsAction->setText(tr("Elimina marques personals"));
    reiniciaJocActual->setText(tr("Reinicia el joc actual"));
     iniciSolucioAction->setText(tr("Inici solució"));
     solucionaJocActual->setText(tr("Resol"));
     /* 16/10/12 Eliminats
     veureSolucions->setText(tr("Veure solucions"));
     */

     tabArbres->setTabText(0,tr("Modalitats del joc"));
     tabArbres->setTabText(1,tr("Solucions"));

    carregaArbreModalitatsJoc();
}


void frmPrincipal::creaAcccions()
{
    surtAction = new QAction(tr("&Surt"), this);
    surtAction->setShortcut(tr("Ctrl+S"));
    surtAction->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/quit.png"));
    connect(surtAction, SIGNAL(triggered()), this, SLOT(close()));

    veureRecordsPersonalsAction = new QAction(tr("Veure marques personals"), this);
    connect(veureRecordsPersonalsAction, SIGNAL(triggered()), this, SLOT(veureRecordsPersonals()));

    eliminaRecordsPersonalsAction = new QAction(tr("Elimina marques personals"), this);
    connect(eliminaRecordsPersonalsAction, SIGNAL(triggered()), this, SLOT(eliminaRecordsPersonals()));

    reiniciaJocActual = new QAction(tr("Reinicia el joc actual"), this);
    reiniciaJocActual->setShortcut(tr("Ctrl+R"));
    reiniciaJocActual->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/view-refresh.png"));
    connect(reiniciaJocActual, SIGNAL(triggered()), this, SLOT(seleccioModalitatJoc()));

    pausaAction= new QAction(tr("Pausa"), this);
    pausaAction->setShortcut(tr("Ctrl+P"));
    pausaAction->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/atura.png"));
    connect(pausaAction, SIGNAL(triggered()), this, SLOT(pausaJocSlot()));

/* 07/02/11  Per ara, aixó queda aturat. Cal tenir més garanties
   sobre la seva efectivitat
    sugereixMovimentAction= new QAction(tr("Suggereix moviment"), this);
    sugereixMovimentAction->setShortcut(tr("Ctrl+M"));
    sugereixMovimentAction->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/sugereix.png"));
    connect(sugereixMovimentAction, SIGNAL(triggered()), this, SLOT(sugereixMovimentSlot()));
    */


   //Això és degut al tema de les traduccions
   // undoAction=movimentsUndoStack->createUndoAction(this,tr("&Retrocedeix"));
    undoAction=movimentsUndoStack->createUndoAction(this);
    undoAction->setShortcut(tr("Ctrl+Z"));
    undoAction->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/edit-undo.png"));

    redoAction=movimentsUndoStack->createRedoAction(this);
    redoAction->setShortcut(tr("Shift+Ctrl+Z"));
    redoAction->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/edit-redo.png"));

    iniciSolucioAction= new QAction(tr("Inici solució"), this);
    connect(iniciSolucioAction, SIGNAL(triggered()), this, SLOT(iniciSolucioSlot()));
    iniciSolucioAction->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/go-first.png"));
    iniciSolucioAction->setEnabled(false);


     creditsPrograma= new QAction(tr("Credits"), this);
     connect(creditsPrograma, SIGNAL(triggered()), this, SLOT(creditsProgramaSlot()));

     ajudaAction= new QAction(tr("Ajuda"), this);
     connect(ajudaAction, SIGNAL(triggered()), this, SLOT(ajudaSlot()));


     solucionaJocActual = new QAction(tr("Resol"), this);
     solucionaJocActual->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/soluciona.png"));
     //connect(solucionaJocActual, SIGNAL(triggered()), this, SLOT(solucionaJocActual_Inicia()));
     connect(solucionaJocActual, SIGNAL(triggered()), this, SLOT(solucionaJocRapid()));

/*     solucionaJocActualRapid = new QAction(tr("Resol ràpid"), this);
     solucionaJocActualRapid->setIcon(QIcon(directoriLinux()+QDir().separator()+DIRECTORI_IMATGES+"/soluciona.png"));
     connect(solucionaJocActualRapid, SIGNAL(triggered()), this, SLOT(solucionaJocRapid()));
     */


/* 16/10/12 Eliminats
     veureSolucions= new QAction(tr("Veure solucions"), this);
     connect(veureSolucions, SIGNAL(triggered()), this, SLOT(veureSolucionsSlot()));
    */
}


void frmPrincipal::creaBarraTasques()
{

    aplicacioToolBar = addToolBar("Solitari");
    aplicacioToolBar->setIconSize(QSize(22,22));
    aplicacioToolBar->addAction(surtAction);

    aplicacioToolBar->addAction(reiniciaJocActual);
    aplicacioToolBar->addAction(pausaAction);
    /* 07/02/11
    aplicacioToolBar->addAction(sugereixMovimentAction);
    */
    aplicacioToolBar->addSeparator();
    aplicacioToolBar->addAction(iniciSolucioAction);
    aplicacioToolBar->addAction(undoAction);
    aplicacioToolBar->addAction(redoAction);
    aplicacioToolBar->addSeparator();
    aplicacioToolBar->addAction(solucionaJocActual);
   // aplicacioToolBar->addAction(solucionaJocActualRapid);
}


void frmPrincipal::creaMenus()
{
    aplicacioMenu = menuBar()->addMenu(tr("Programa"));
    aplicacioMenu->addAction(veureRecordsPersonalsAction);
    aplicacioMenu->addAction(eliminaRecordsPersonalsAction);

    /* 16/10/12 Eliminats
    aplicacioMenu->addSeparator();
    aplicacioMenu->addAction(veureSolucions);
    */

    aplicacioMenu->addSeparator();
    aplicacioMenu->addAction(surtAction);

    movimentsMenu= menuBar()->addMenu(tr("&Moviments joc"));
    movimentsMenu->addAction(undoAction);
    movimentsMenu->addAction(redoAction);

    idiomaMenu = new QMenu(tr("Idioma"));
    menuBar()->addMenu(idiomaMenu);

     ajudaMenu= new QMenu(tr("Ajuda"));
     menuBar()->addMenu(ajudaMenu);
     ajudaMenu->addAction(ajudaAction);
     ajudaMenu->addAction(creditsPrograma);


    creaIdiomaMenu();
}


 /*
Suggereix el següent moviment a l'usuari
*/
void  frmPrincipal::sugereixMovimentSlot(){
    if(rellotgeLabel->rellotgeEnMarxa()){
        QStringList movimentsAnteriors;
        QString darrerMoviment;
        QStringList  movimentsSuggerits;
      /*  for(int j=0;j<movimentsUndoStack->count();j++){
            movimentsAnteriors.append(QString("%1 %2").
                                arg(j+1).
                                arg(coordenadesAMoviment(movimentsUndoStack->text(j)))) ;
        }*/
        darrerMoviment.append(coordenadesAMoviment(movimentsUndoStack->text(
                movimentsUndoStack->index()-1)));
        carregaConfiguracionsEliminades();
        //Cal carregar els moviments possibles de les fitxes
       taulerJoc->solucionaJocActual_CalculaMovimentsPosibles();
        movimentsSuggerits.append(
                taulerJoc->solucionaJocActual_CarregaMovimentsArbre(solucioJocActual_configuracionsEliminades,
                                                         darrerMoviment));
        /*
        qDebug("movimentsSuggerits %d", movimentsSuggerits.count());
        qDebug("darrerMoviment %d", darrerMoviment.length());
        qCritical("darrerMoviment %s", qPrintable(darrerMoviment));

 qDebug("movimentsSuggerits.count() %d", movimentsSuggerits.count());
        qCritical("movimentsSuggerits.value(0) %s", qPrintable(movimentsSuggerits.value(0)));
        */
        if (movimentsSuggerits.count()>0){
            darrerMoviment.clear();
            darrerMoviment.append(movimentsSuggerits.value(qrand() % movimentsSuggerits.count()));
            //Marcam el moviment seleccionat en el tauler de joc
            taulerJoc->marcaMoviment(darrerMoviment);
            qCritical("darrerMoviment %s", qPrintable(darrerMoviment));
        }
    }
}


/*
  Manté el joc en pausa
  */
void frmPrincipal::pausaJocSlot(){
    //Si s'està jugant, s'atura el joc
    if(rellotgeLabel->rellotgeEnMarxa()){
        QProgressDialog pausaProgres(tr("Pausa"), tr("Continua"), 0,0 ,this);
        rellotgeLabel->aturaRellotge();
        pausaProgres.setWindowModality(Qt::WindowModal);
        pausaProgres.setVisible(true);        
        QString configuracioJoc= taulerJoc->configuracioActual();
        qApp->processEvents();
        bool continua=true;
        while (continua){
            taulerJoc->estatFitxesAtzar();
            if (pausaProgres.wasCanceled()){
                continua=false;
                taulerJoc->carregaConfiguracio(configuracioJoc);
                rellotgeLabel->iniciaRellotge();}
            qApp->processEvents();
        }
        pausaProgres.close();
}
}


void frmPrincipal::iniciSolucioSlot(int pmoviment){
    if (pmoviment>0){
    while (movimentsUndoStack->canUndo() && movimentsUndoStack->index()> pmoviment ){
        movimentsUndoStack->undo();
    }
}
    else{
        while (movimentsUndoStack->canUndo() ){
        movimentsUndoStack->undo();
    }
    }
statusBar()->clearMessage();
//iniciSolucioAction->setEnabled(movimentsUndoStack->canUndo());
}

//Crea el menú de selecció d'idioma de l'aplicació
void frmPrincipal::creaIdiomaMenu(){

    idiomaActionGroup = new QActionGroup(this);
    connect(idiomaActionGroup, SIGNAL(triggered(QAction *)), this, SLOT(canviaIdioma(QAction *)));

    QDir dir(directoriLinux()+QDir().separator()+DIRECTORI_LOCALES);
    QStringList arxiusIdioma = dir.entryList(QStringList("solitari_*.qm"));

for (int i = 0; i < arxiusIdioma.size(); ++i) {
    QString locale = arxiusIdioma[i];
    locale.remove(0, locale.indexOf('_') + 1);
    locale.truncate(locale.lastIndexOf('.'));

    QTranslator translator;
    translator.load(arxiusIdioma[i], directoriLinux()+QDir().separator()+DIRECTORI_LOCALES);
    QString language =translator.translate("Traduccio","English");
    QAction *action = new QAction(tr("&%1 %2").arg(i + 1).arg(language), this);
    action->setCheckable(true);
    action->setData(locale);

    idiomaMenu->addAction(action);
    idiomaActionGroup->addAction(action);

    if (locale == QLocale::system().name()){
        action->setChecked(true);
        //a debian, sense això es carregan les cadenes
        //orginals enlloc de les traduïdes
        canviaIdioma(action);
       }
  }
}


void frmPrincipal::canviaIdioma(QAction *action)
{
    localePrograma = action->data().toString();
    appTranslator->load("solitari_" + localePrograma, directoriLinux()+QDir().separator()+DIRECTORI_LOCALES);
    qt_translator->load(QLatin1String("qt_") + localePrograma, QLibraryInfo::location(QLibraryInfo::TranslationsPath));
     tradueixGUI();
}

void frmPrincipal::resizeEvent ( QResizeEvent * event ){
    QSize augment=this->size()-this->minimumSize();
    taulerJoc->resize(QSize(taulerJoc->minimumSize()+augment));
    jocFram->resize(QSize(jocFram->minimumSize().width(), jocFram->minimumSize().height()+augment.height()));
    tabArbres->resize(QSize(tabArbres->minimumSize().width(),
                                               tabArbres->minimumSize().height()+augment.height()));
    arbreModalitatsJocTreeWidget->resize(QSize(arbreModalitatsJocTreeWidget->minimumSize().width(),
                                               arbreModalitatsJocTreeWidget->minimumSize().height()+augment.height()));
}

void frmPrincipal::closeEvent(QCloseEvent* event){
   QStringList  tipusJoc =   arbreModalitatsJocTreeWidget->selectedItems().first()->text(1).split(" ");
   QSettings().setValue("General/modalidadJoc",tipusJoc.value(0));
}

void frmPrincipal::creditsProgramaSlot(){
    QDate avui=QDate::currentDate () ;
    QString missatge=QString("<h2>"+tr("Solitari")+
                         QString(" v. %1</h2>").arg(qApp->applicationVersion()));
    if (avui.year()==2010){
        missatge.append(QString("<p> &copy;  "+QString("2010")+"  I. De Marchi <br/>" ));
    }
    else {
    missatge.append(QString("<p> &copy;  "+QString("2010-%1").arg(avui.year())+"  I. De Marchi<br/>" ));
    }
    missatge.append(QString(tr("Sota llicència GPL 2.0 o posterior")+"<br/>"));

    missatge.append(QString("<a href=\"%1\">%1</a><br/>").arg(ADRECA_WEB_PROGRAMA_1));
    missatge.append(QString("<a href=\"%1\">%1</a><br/>").arg(ADRECA_WEB_PROGRAMA_2));
    missatge.append(QString("<a href=mailto:%1>%1</a><br/>").arg(ADRECA_CORREU));

    QMessageBox::about(this,
            QString(tr("Credits del %1").arg(qApp->applicationName())),missatge);
}

void frmPrincipal::veureRecordsPersonals(){
    if (arbreModalitatsJocTreeWidget->topLevelItemCount()==0){ return;}
    QString missatge=QString("<h2>"+ tr("Marques personals")+"</h2>");
    QSettings records;
    for(int i=0;i<=arbreModalitatsJocTreeWidget->topLevelItemCount()-1;i++){
        QStringList  tipusJoc = arbreModalitatsJocTreeWidget->topLevelItem(i)->text(1).split(" ");
        QString record=records.value( QString("%1/record").
                                  arg(tipusJoc.value(0)) ,
                                  QString("--")).toString();
        if( !(record.compare("--")==0)){
          missatge.append(QString("<br>"+arbreModalitatsJocTreeWidget->topLevelItem(i)->text(0)+
                          "    -> "+record  ))  ;
       //   missatge.append(QString("<p>"+arbreModalitatsJocTreeWidget->topLevelItem(i)->text(0)+
         //                 "    -> "+record  ))  ;
        }
    }
    QMessageBox::about(this,QString(tr("Marques personals")),missatge);


/*
QTextEdit  *texte = new QTextEdit (missatge );
texte->setReadOnly(true);
QDockWidget *recordsPersonalsDockWidget = new QDockWidget(tr("Marques personals"));
recordsPersonalsDockWidget->setWidget(texte);
recordsPersonalsDockWidget->setMinimumSize(400,300);
recordsPersonalsDockWidget->move(QPoint(this->pos().x()+50,this->pos().y()+200));
//solucionsDockWidget->setAllowedAreas(Qt::NoDockWidgetArea);
addDockWidget(Qt::BottomDockWidgetArea, recordsPersonalsDockWidget);
//addDockWidget(Qt::NoDockWidgetArea, solucionsDockWidget);
recordsPersonalsDockWidget->setFloating(false);
*/
}

/*
  Elimina tots els records personals
  */
void frmPrincipal::eliminaRecordsPersonals(){
    QMessageBox missatgeBox;
        missatgeBox.setText(tr("Elimina les marques personals"));
        missatgeBox.setInformativeText(tr("De debó voleu eliminar les vostres marques?"));
        missatgeBox.setIcon(QMessageBox::Question);
        missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        missatgeBox.setDefaultButton(QMessageBox::No);
        if(missatgeBox.exec()==QMessageBox::Yes){
          QSettings records;
          records.clear();
        }
}



void frmPrincipal::ajudaSlot(){
 QDir dirArxiu;
 QString directori=directoriLinux()+
                            QDir().separator()+
                            DIR_HELP+
                            QDir().separator()+
                            "index.html";

    if (dirArxiu.exists(directori)){
     //Això evita problemes amb els espais als noms dels directoris
        QDesktopServices::openUrl(QUrl("file:///"+directori+"#"+localePrograma, QUrl::TolerantMode));
    }
   else  QDesktopServices::openUrl(QUrl("file:///"+directoriLinux()+
                            QDir().separator()+
                            DIR_HELP+
                            QDir().separator()+
                            "index.html", QUrl::TolerantMode));
}


void frmPrincipal::solucionaJocActual_Inicia(){

    QApplication::setOverrideCursor(Qt::WaitCursor);
    statusBar()->clearMessage();

       jocResolt=0;
       taulerJoc->solucionaJocActual_CalculaMovimentsPosibles();
       //Si ja hi ha moviments fets, llavors es "conservan" i es busca
       //la solució a partir de la situació actual
       if(movimentsUndoStack->count()>0){
          retrocedeixMoviment=movimentsUndoStack->index();
          solucionaJocActual_movimentsJaRealitzats.clear();
          iniciSolucioSlot();          
         // solucioJocActual_configuracioInicial.append(taulerJoc->configuracioActual(true));
          while (movimentsUndoStack->canRedo()){               
               solucionaJocActual_darrerMoviment=QString("%1 ").arg(movimentsUndoStack->index()+1);
               solucionaJocActual_darrerMoviment.append(
                       coordenadesAMoviment(movimentsUndoStack->text(movimentsUndoStack->index())));
               solucionaJocActual_movimentsJaRealitzats.append(solucionaJocActual_darrerMoviment);
               movimentsUndoStack->redo();
          }
       }
       else {
           solucioJocActual_configuracioInicial.clear();
           solucioJocActual_configuracioInicial.append(taulerJoc->configuracioActual(true));
           retrocedeixMoviment=0;
           movimentsUndoStack->clear();
       }
   //    solucioJocActual_configuracioInicial.append(taulerJoc->configuracioActual(true));

       solucioJocActual_configuracionsEliminades.clear();
       solucioJocActual_configuracionsEliminadesPerDesar.clear();

       solucionaJocActual_movimentsPosiblesActuals.clear();

         carregaConfiguracionsEliminades();
    //   movimentsUndoStack->clear();
       solucionaJocActual_CarregaMovimentsInicialsArbre();
      // qApp->processEvents();
   }


void frmPrincipal::solucionaJocActual_CarregaMovimentsInicialsArbre(){
    //qDebug("iniciaRellotge()");
    rellotgeLabel->iniciaRellotge();
    solucionaJocActual_comencaRecerca();
    QApplication::setOverrideCursor(Qt::ArrowCursor);
}


void frmPrincipal::solucionaJocActual_comencaRecerca(){

   //  QProgressDialog progres(tr("Cercant solució"), tr("Atura"), 0,
     //                                         taulerJoc->numeroDeMovimentsJoc() ,this);
    //Això és pel problema a windows en què si es mou
    //la finestra de diàleg, llavors s'atura la cerca però
    //no el rellotge
    #if defined(Q_OS_WIN32)
        QProgressDialog progres(tr("Cercant solució"), tr("Atura"), 0,
                                              taulerJoc->numeroDeMovimentsJoc() ,this,
                                             Qt::FramelessWindowHint);
    #else
        QProgressDialog progres(tr("Cercant solució"), tr("Atura"), 0,
                                              taulerJoc->numeroDeMovimentsJoc() ,this);
    #endif
     progres.setWindowModality(Qt::WindowModal);
     if (movimentsUndoStack->index()>0){
     progres.setValue(movimentsUndoStack->index()-1);}
     progres.setVisible(true);
     progres.setLabelText(missatgeNumeroMoviments());
     qApp->processEvents();

     bool reinicia=false;
     int numMovimentsPerReiniciar=taulerJoc->numeroDeMovimentsJoc()*3;

     int numeroFitxesMajorConfigEliminada=0;
     int numeroMovimentsProvats=0;

  while (jocResolt !=2){
      solucionaJocActual_movimentsPosiblesActuals.clear();
      solucionaJocActual_movimentsPosiblesActuals.append(              
              taulerJoc->solucionaJocActual_CarregaMovimentsArbre(solucionaJocActual_movimentsEliminats,
                                                               solucionaJocActual_darrerMoviment));

      bool fitxesAIllades=false;
      fitxesAIllades=taulerJoc->solucionaJocActual_FitxesAillades();
      QString configAct=taulerJoc->configuracioActual();


      if ( (solucionaJocActual_movimentsPosiblesActuals.count()>0) && (jocResolt ==0)
          && !(solucioJocActual_configuracionsEliminades.contains(configAct))
          && !(fitxesAIllades)  ){
       //   && taulerJoc->movimentFitxaCentral() ) {

          int numeroItem=0;

          if (solucionaJocActual_movimentsPosiblesActuals.count()>1){
                  qsrand(rellotgeQTime.msecsTo(QTime::currentTime()));
                  numeroItem=qrand() % (solucionaJocActual_movimentsPosiblesActuals.count());
          }

          if (numeroItem>=solucionaJocActual_movimentsPosiblesActuals.count()){ numeroItem=0;}
          QStringList  movimentsItem= QStringList(solucionaJocActual_movimentsPosiblesActuals.value(numeroItem).split(" "));
          taulerJoc->ferMoviment(movimentsItem.value(0).toInt()
                                 ,movimentsItem.value(1).toInt(),movimentsItem.value(2).toInt());

          ++numeroMovimentsProvats;
          progres.setValue(movimentsUndoStack->index()-1);
          progres.setLabelText(missatgeNumeroMoviments());
          qApp->processEvents();

          //int indexmovimentsUndoStack=movimentsUndoStack->index();
          solucionaJocActual_darrerMoviment=QString("%1 ").arg(movimentsUndoStack->index());
          solucionaJocActual_darrerMoviment.append(solucionaJocActual_movimentsPosiblesActuals.value(numeroItem));
          solucionaJocActual_movimentsJaRealitzats.append(solucionaJocActual_darrerMoviment);
        }
      else {

          if (movimentsUndoStack->index() !=0 ){
              jocResolt=0;
              taulerJoc->eliminaFitxesVermelles();
             // QString configAct=taulerJoc->configuracioActual();
                numeroFitxesMajorConfigEliminada=qMax(numeroFitxesMajorConfigEliminada,
                                                                             numeroConfiguracio(configAct));
                 if (     (! solucioJocActual_configuracionsEliminades.contains(configAct))  ){
                  //Aqui cal eliminar les configuracions posteriors de solucioJocActual_configuracionsEliminades
                  solucionaJocActual_eliminaConfiguracionsPosteriors(configAct);
                  solucioJocActual_configuracionsEliminadesPerDesar.append(configAct);
                  solucioJocActual_configuracionsEliminades.prepend(configAct);
                  reinicia=true;
              }

              if ( (solucionaJocActual_movimentsEliminats.indexOf(solucionaJocActual_darrerMoviment)==-1 ) &&
                   !(solucionaJocActual_darrerMoviment.isEmpty()) ){
                  solucionaJocActual_eliminaMovimentsPosteriors();
                  solucionaJocActual_movimentsEliminats.append(solucionaJocActual_darrerMoviment);
              }

              movimentsUndoStack->undo();

              progres.setValue(movimentsUndoStack->index()-1);
              progres.setLabelText(missatgeNumeroMoviments());
              if (solucionaJocActual_movimentsJaRealitzats.size()>0){
                  solucionaJocActual_movimentsJaRealitzats.removeAt(solucionaJocActual_movimentsJaRealitzats.size()-1);
              }
              solucionaJocActual_darrerMoviment=solucionaJocActual_movimentsJaRealitzats.value(
                      solucionaJocActual_movimentsJaRealitzats.size()-1);


             if ( ( ( reinicia ) &&  retrocedeixMoviment==0 &&
                  (  (numeroMovimentsProvats % numMovimentsPerReiniciar) == 0) )  ){
                     iniciSolucioSlot();
                     solucionaJocActual_movimentsJaRealitzats.clear();
                     solucionaJocActual_darrerMoviment.clear();
                     progres.setValue(0);
                     progres.setLabelText(missatgeNumeroMoviments());
                     reinicia=false;
                 }
         }

          else{
              rellotgeLabel->aturaRellotge();
              progres.cancel();
              //27/01/11
              //Això pot ésser que millori el tema dels problemes
              //en què el programa no aconsegueix trobar la solució
             solucionaJocActual_movimentsEliminats.clear();
             /*04/02/11
               Pareix que això disminueix la freqüència en què el programa
               no aconsegueix trobar la solució al joc
               */
             eliminaArxiuConfgEliminades();
             // desaConfiguracionsEliminades();
             statusBar()->showMessage(tr("No ha estat possible trobar una solució!"));

             /* 06/02/11
                Això evita que no es trobi una solució
                Continuam amb la recerca de solució
                */
             if (intentsSolucio<3){
                 intentsSolucio++;
                 movimentsUndoStack->clear();
                 iniciSolucioSlot();
                 solucionaJocActual_Inicia();}
             return;
          }
      }
      if (progres.wasCanceled()){
           rellotgeLabel->aturaRellotge();
           desaConfiguracionsEliminades();
           solucionaJocActual_movimentsJaRealitzats.clear();
           solucionaJocActual_movimentsEliminats.clear();
          break;}
     }//final wihle

        if (jocResolt==2){
            progres.cancel();
            desaSolucions();
         //   qDebug("num conf eliminades %d", solucioJocActual_configuracionsEliminades.count());
         //   qCritical("temps %s ", qPrintable(rellotgeLabel->retornaTemps(1)));
            desaConfiguracionsEliminades();
            solucionaJocActual_movimentsJaRealitzats.clear();
            solucionaJocActual_movimentsEliminats.clear();
            retrocedeixMoviment=0;
            veureSolucionsSlot();
            intentsSolucio=0;
          //Comentar les 3 següents linies per evitar la repetició de recerca de solució
         /*     iniciSolucioSlot();
                 if(taulerJoc->estatDelJoc()==solucio){movimentsUndoStack->clear();}
                 solucionaJocActual_Inicia();
                 */
             return;
        }
}

void frmPrincipal::solucionaJocActual_eliminaMovimentsPosteriors(){
    QStringList  *darrerMoviment =new QStringList(solucionaJocActual_darrerMoviment.split(" "));
    QStringList  *darrerMovimentEliminat=new QStringList(solucionaJocActual_movimentsEliminats.value(
            solucionaJocActual_movimentsEliminats.size()-1).split(" "));
    while (darrerMovimentEliminat->value(0).toInt()>darrerMoviment->value(0).toInt()){
        solucionaJocActual_movimentsEliminats.removeAt(solucionaJocActual_movimentsEliminats.size()-1);
        darrerMovimentEliminat->clear();
        darrerMovimentEliminat->append(solucionaJocActual_movimentsEliminats.value(
            solucionaJocActual_movimentsEliminats.size()-1).split(" "));
    }
    delete(darrerMoviment);
    delete(darrerMovimentEliminat);
}

void frmPrincipal::solucionaJocActual_eliminaConfiguracionsPosteriors(QString config){

   if (solucioJocActual_configuracionsEliminadesPerDesar.count()==0){
        return;}
  int numConfiguracio=numeroConfiguracio(config);
  if(taulerJoc->p_tipusMoviment !=2){
    while ( (numeroConfiguracio(solucioJocActual_configuracionsEliminadesPerDesar.value(
            solucioJocActual_configuracionsEliminadesPerDesar.count()-1))<numConfiguracio) &&
            (solucioJocActual_configuracionsEliminadesPerDesar.count()>0) ){
    solucioJocActual_configuracionsEliminadesPerDesar.removeLast();} 
  }
  else{
      while ( (numeroConfiguracio(solucioJocActual_configuracionsEliminadesPerDesar.value(
            solucioJocActual_configuracionsEliminadesPerDesar.count()-1))>numConfiguracio) &&
            (solucioJocActual_configuracionsEliminadesPerDesar.count()>0) ){
    solucioJocActual_configuracionsEliminadesPerDesar.removeLast();}
  }
}

/*
  Elimina configuracions de solucioJocActual_configuracionsEliminades
  No es fa servir

void frmPrincipal::solucionaJocActual_eliminaConfiguracions(){
    while (solucioJocActual_configuracionsEliminades.count()>10000){
        solucioJocActual_configuracionsEliminades.removeLast();
    }
}
*/


/* Aquesta funció no es fa servir
void frmPrincipal::escriuArxiuSolucio(){    
    QSettings *arxiuSolucio=new QSettings(QSettings::UserScope,"De Marchi", "solucio");
    arxiuSolucio->clear();
    for(int llista=0 ; llista<solucionaJocActual_movimentsJaRealitzats.size();++llista){
        arxiuSolucio->setValue(QString("solucio/%1").arg(llista+1),solucionaJocActual_movimentsJaRealitzats.value(llista));
    }
    delete (arxiuSolucio);
    qApp->processEvents();

}
*/

/*
  Busca una solució ha partir d'una altra solució
  */
void frmPrincipal::solucionaJocRapid(){
    solucionaJocActual_movimentsJaRealitzats.clear();
    solucionaJocActual_darrerMoviment.clear();
    //reiniciam els intents
    intentsSolucio=0;
    /* 27/01/11
    Si el joc està finalitzat, llavors primer reiniciam
    Això evita que en les modalitats amb poques fitxes
    el programa no trobi la solució  ¿?
      */
    if(jocResolt==2){
      seleccioModalitatJoc();
    }
    taulerJoc->setEstatDelJoc(solucio);
     jocResolt=0;
     //Posa a zero el rellotge 01/01/11
    //Si es clicava una segona vegada desprès d'obtenir
    //una solució, llavors s'acumulava el temps
    rellotgeLabel->estableixTemps(QString("00:00:00"));
    if(movimentsUndoStack->index()==0){
        movimentsUndoStack->clear();
        //Primer carregam les solucions disponibles
        solucioJocActual_configuracioInicial.clear();
        solucioJocActual_configuracioInicial.append(taulerJoc->configuracioActual(true));

        comprovaArxiuSolucions();
        carregaSolucions();
        if  (solucionsTrobades.count()>0) {
            //Seleccionam una solució a l'atzar
            qsrand(rellotgeQTime.msecsTo(QTime::currentTime()));
            int selec=qrand() % (solucionsTrobades.count());
            QStringList movimentsSolucio=solucionsTrobades.value(selec).split(" ");
            /*02/02/11 AIxò és per controlar les solucions incorrectes
              (que no tenen el nombre de moviments corresponents al joc
              */
            while (movimentsSolucio.count() != taulerJoc->numeroDeMovimentsJoc()*4){
             qCritical("%s", qPrintable(solucionsTrobades.value(selec)));
              solucionsTrobades.removeOne(solucionsTrobades.value(selec));
                //solucionsTrobades.removeAt(selec);
              desaSolucions();
             // qDebug("eliminada %d", selec);
              int selec=qrand() % (solucionsTrobades.count());
              movimentsSolucio=solucionsTrobades.value(selec).split(" ");
            }
          //  if(movimentsSolucio.count() != taulerJoc->numeroDeMovimentsJoc()*4 ){
            //      qDebug("problemes %d", movimentsSolucio.count());
            //}
            selec=qrand() % ((movimentsSolucio.count()/8));
            selec=qMax(selec,taulerJoc->p_numMoviments);
            QString mov;
            rellotgeLabel->iniciaRellotge();
            for(int i=0;i<(movimentsSolucio.count()/4);i++){
                if(i<(movimentsSolucio.count()/4)-selec){
                    taulerJoc->ferMoviment(movimentsSolucio.value(i*4+1).toInt(),
                                           movimentsSolucio.value(i*4+2).toInt(),
                                           movimentsSolucio.value(i*4+3).toInt());}

                if(i>taulerJoc->p_numMoviments){
                    mov=QString("%1 %2 %3 %4").
                            arg(movimentsSolucio.value(i*4)).
                            arg(movimentsSolucio.value(i*4+1)).
                            arg(movimentsSolucio.value(i*4+2)).
                            arg((movimentsSolucio.value(i*4+3)));
                    solucionaJocActual_movimentsEliminats.append(mov);
                 }
            }
        solucionaJocActual_darrerMoviment.append(mov);
        }
  }
 solucionaJocActual_Inicia();
}

/*
  Elimina l'arxiu de configuracions eliminades. Es fa servir
  quan el programa no aconsegueix trobar una solucuió al joc
  */
void frmPrincipal::eliminaArxiuConfgEliminades(){
  comprovaDirectoriHome();
  QString nomArxiu=nomArxiuJoc(1);
  QFile arxiu(nomArxiu);
  arxiu.remove(nomArxiu);
}

void frmPrincipal::desaConfiguracionsEliminades(int tipus){

    if (solucioJocActual_configuracionsEliminadesPerDesar.count()==0){
        return;}

    int numero=0;

    QProgressDialog progres(tr("Desant dades"), tr("Atura"), 0,solucioJocActual_configuracionsEliminadesPerDesar.count() ,this);
    progres.setWindowModality(Qt::WindowModal);
    progres.setValue(numero);
    progres.setVisible(true);
    qApp->processEvents();

    comprovaDirectoriHome();

   QString nomArxiu=nomArxiuJoc(1);

    QFile arxiu(nomArxiu);
    bool arxiuObert=false;
    if (tipus==0){
        if (arxiu.open(QIODevice::Append)){arxiuObert=true;}
    }
    else if (arxiu.open(QIODevice::WriteOnly)){arxiuObert=true;}

      if (arxiuObert){
         QTextStream entrada(&arxiu);
         for(int j=0;j<solucioJocActual_configuracionsEliminadesPerDesar.count();j++){
                 entrada<<(QString("%1\n").arg(solucioJocActual_configuracionsEliminadesPerDesar.value(j) )) ;
                 progres.setValue(++numero);
                 progres.setLabelText(QString("Desant dades: %1 de %2").arg(numero).
                                      arg(solucioJocActual_configuracionsEliminadesPerDesar.count()));
                 if (progres.wasCanceled()) { break;  }
        qApp->processEvents();
          }
        }
      arxiu.close();
     }


void frmPrincipal::carregaConfiguracionsEliminades(){
    int numero=0;

    QString nomArxiu=nomArxiuJoc(1);

    QFile arxiu(nomArxiu);
    /*23/01/2011
      Aqui hi havia una divisió per zero!
      Quan es fa un joc invers amb modificació de l'usuari
      */
    qint64 tamanyArxiu=arxiu.size()/(1+taulerJoc->numeroDeMovimentsJoc());
  /*  if (taulerJoc->numeroDeMovimentsJoc()>0){
        tamanyArxiu =1+arxiu.size()/(1+taulerJoc->numeroDeMovimentsJoc());}
    else tamanyArxiu =arxiu.size();*/

    QProgressDialog progres(tr("Carregant dades"), tr("Atura"), 0,tamanyArxiu ,this);


    progres.setWindowModality(Qt::WindowModal);
    progres.setValue(numero);
    progres.setVisible(true);
    qApp->processEvents();

   solucioJocActual_configuracionsEliminades.clear();

     if (arxiu.open(QIODevice::ReadOnly)){
         QTextStream entrada(&arxiu);
         QString linia0 = entrada.readLine();
     while (!linia0.isNull()) {
         if ( ! solucioJocActual_configuracionsEliminadesPerDesar.contains(linia0)){
             solucioJocActual_configuracionsEliminades.append(linia0);
             solucioJocActual_configuracionsEliminadesPerDesar.append(linia0);
             progres.setValue(++numero);
             progres.setLabelText(QString("Carregant dades: %1 de %2").arg(numero).arg(tamanyArxiu));
            }
            linia0 = entrada.readLine();            
            if (progres.wasCanceled())  break;
        qApp->processEvents();
         }
      arxiu.close();
      progres.cancel();
      desaConfiguracionsEliminades(1);
     }
}

void frmPrincipal::carregaSolucions(){
    QString nomArxiu=nomArxiuJoc(2);

    QFile arxiu(nomArxiu);
    solucionsTrobades.clear();
   // qDebug("Items in list: %d", solucionsTrobades.size());
  /*  if (!arxiu.open(QIODevice::ReadOnly)){
         }
      else {*/

    if (arxiu.open(QIODevice::ReadOnly)){
         QTextStream entrada(&arxiu);
         QString linia0 = entrada.readLine();
     while (!linia0.isNull()) {
            QStringList movimentsSolucio=linia0.split(" ");
            if (movimentsSolucio.count() == taulerJoc->numeroDeMovimentsJoc()*4){
                solucionsTrobades.append(linia0);}
            // qDebug("llistat: %d", solucionsTrobades.size());
            linia0 = entrada.readLine();
            /* 13/01/11
               Aquesta linea provocava un error en la càrrrega de les
               dades de les solucions quan es feia un canvi ràpid en la
               selecció de la modalitar de joc*/
            //qApp->processEvents();
         }
     // qDebug("Items in list: %d", solucionsTrobades.size());
      arxiu.close();
     }
}

void frmPrincipal::desaSolucions(){
     if (solucionaJocActual_movimentsJaRealitzats.count()==0){
        return;}
    /* 02/02/11  A vegades s'escriu malament la solució (no s'afageixen tots
      els moviments). Això evita aquest problema
     */
      if(solucionaJocActual_movimentsJaRealitzats.count()  != taulerJoc->numeroDeMovimentsJoc() ){
        // qDebug("problemes amb la solució %d",solucionaJocActual_movimentsJaRealitzats.count() );
        //  qDebug("count %d",solucionaJocActual_movimentsJaRealitzats.count() );
         return;
     }

   comprovaDirectoriHome();
   QString nomArxiu=nomArxiuJoc(2);

    carregaSolucions();
    QString solucioActual;
         for(int j=0;j<solucionaJocActual_movimentsJaRealitzats.count()-1;j++){
            solucioActual.append(QString("%1 ").arg(solucionaJocActual_movimentsJaRealitzats.value(j) )) ;
        }
    /*04/02/11  Eliminats els espais buits del final
       */
    solucioActual.append(QString("%1").arg(solucionaJocActual_movimentsJaRealitzats.value(
            solucionaJocActual_movimentsJaRealitzats.count()-1) )) ;
    if( ! solucionsTrobades.contains(solucioActual)){
    QFile arxiu(nomArxiu);
      if (arxiu.open(QIODevice::Append)){         
         QTextStream entrada(&arxiu);
         entrada<<(QString("%1\n").arg(solucioActual )) ;
         statusBar()->showMessage(tr("S'ha trobat una nova solució!"));
        // qDebug("S'ha trobat una nova solució!");
        }
      arxiu.close();
     }
}

/*
  Desa la solució actual continguda a movimentsUndoStack
  Es fa servir des de taulerJoc
  */
void frmPrincipal::desaSolucions1(){
     if (movimentsUndoStack->count()==0){
        return;}
   comprovaDirectoriHome();
   QString nomArxiu=nomArxiuJoc(2);

    carregaSolucions();
    QString solucioActual;
         for(int j=0;j<movimentsUndoStack->count()-1;j++){
            solucioActual.append(QString("%1 %2 ").
                                arg(j+1).
                                arg(coordenadesAMoviment(movimentsUndoStack->text(j)))) ;
        }
     /*04/02/11  Eliminats els espais buits del final
       */
    solucioActual.append(QString("%1 %2").
                                arg(movimentsUndoStack->count()).
                                arg(coordenadesAMoviment(movimentsUndoStack->text(
                                       movimentsUndoStack->count()-1)))) ;
    if( ! solucionsTrobades.contains(solucioActual)){
    QFile arxiu(nomArxiu);
      if (arxiu.open(QIODevice::Append)){
         QTextStream entrada(&arxiu);
         entrada<<(QString("%1\n").arg(solucioActual )) ;
         statusBar()->showMessage(tr("S'ha trobat una nova solució!"));
        // qDebug("S'ha trobat una nova solució!");
        }
      arxiu.close();
     }
}


void frmPrincipal::veureSolucionsSlot(){
 arbreSolucionsTreeWidget->clear();
 /*
 //posam la capçalera de l'arbre
 //Això provoca una errada a windows
 //quan es navega per l'arbre de modalitats del
 //joc. S'ha passat al final del procediment
 QTreeWidgetItem *item=new QTreeWidgetItem();
 QString textSolucio=arbreModalitatsJocTreeWidget->selectedItems().first()->text(0);
 item->setText(0,arbreModalitatsJocTreeWidget->selectedItems().first()->text(0));
 arbreSolucionsTreeWidget->setHeaderItem(item);
 */

//solucionsDockWidget->move(QPoint(this->pos().x()+10,this->pos().y()+this->height()/3+40));
/*solucionsDockWidget->move(QPoint(this->pos().x()+10,this->pos().y()+10));
solucionsDockWidget->setAllowedAreas(Qt::LeftDockWidgetArea);
addDockWidget(Qt::LeftDockWidgetArea, solucionsDockWidget);
//addDockWidget(Qt::NoDockWidgetArea, solucionsDockWidget);
solucionsDockWidget->setFloating(true);
solucionsDockWidget->setVisible(true);
*/

//Carregam les solucions
//solucionsTrobades.clear();
carregaSolucions();
int numeroSolucio=1;
if (solucionsTrobades.count()>0){
//qDebug("Items in list: %d", solucionsTrobades.size());
//arbreSolucionsTreeWidget->clear();
for(int i=0;i<solucionsTrobades.count();i++){
    if ( ! solucionsTrobades.value(i).mid(0,1).contains("#")){
    //afegim un item arrel a l'arbre
    QTreeWidgetItem *itemSolucio=new QTreeWidgetItem();
    QList<QTreeWidgetItem *> itemsArbre;
    QStringList movimentsSolucio=solucionsTrobades.value(i).split(" ");
         for(int moviment=0 ; moviment<movimentsSolucio.count()/4;++moviment){
               QTreeWidgetItem *item=new QTreeWidgetItem();
               item->setText(0,
                        movimentACoordenades(movimentsSolucio.value(4*moviment+1),movimentsSolucio.value(4*moviment+3)));
               item->setText(1,QString("%1 %2 %3").arg(movimentsSolucio.value(4*moviment+1)).
                             arg(movimentsSolucio.value(4*moviment+2)).
                             arg(movimentsSolucio.value(4*moviment+3)) );
               itemsArbre.append(item);
         }
      itemSolucio->insertChildren(0,itemsArbre);
      itemSolucio->setText(0,tr("Solució %1").arg(numeroSolucio));
      arbreSolucionsTreeWidget->insertTopLevelItem(numeroSolucio-1,itemSolucio);
      ++numeroSolucio;
      arbreModalitatsJocTreeWidget->expandAll();
    }
  }
}
else {
    QTreeWidgetItem *itemSolucio=new QTreeWidgetItem();
    itemSolucio->setText(0,tr("No hi ha solucions"));
    //arbreSolucionsTreeWidget->clear();
    arbreSolucionsTreeWidget->insertTopLevelItem(numeroSolucio-1,itemSolucio);
}
QTreeWidgetItem *itemCapcalera=new QTreeWidgetItem();
QString textCapcalera=arbreModalitatsJocTreeWidget->selectedItems().first()->text(0);
textCapcalera.append(" ("+QString("%1").arg(numeroSolucio-1)+")");
itemCapcalera->setText(0,textCapcalera);
arbreSolucionsTreeWidget->setHeaderItem(itemCapcalera);
tabArbres->setTabText(1,tr("Solucions")+" ("+QString("%1").arg(numeroSolucio-1)+")");

}

void frmPrincipal::carregaSolucio(QTreeWidgetItem*, int){
    if(arbreSolucionsTreeWidget->selectedItems().first()->childCount()>0){
        QMessageBox missatgeBox;
        missatgeBox.setText(tr("Carregar ")+arbreSolucionsTreeWidget->selectedItems().first()->text(0));
        missatgeBox.setInformativeText(tr("De debó voleu carregar la solució? Perdreu els moviments que heu fet!"));
        missatgeBox.setIcon(QMessageBox::Question);
        missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        missatgeBox.setDefaultButton(QMessageBox::No);
        if(missatgeBox.exec()==QMessageBox::Yes){
        taulerJoc->setEstatDelJoc(solucio);
        iniciSolucioSlot();
        solucioJocActual_configuracioInicial.clear();
        solucioJocActual_configuracioInicial.append(taulerJoc->configuracioActual(true));
        for(int i=0;i<arbreSolucionsTreeWidget->selectedItems().first()->childCount();i++){
          QStringList movimentsSolucio=
                  arbreSolucionsTreeWidget->selectedItems().first()->child(i)->text(1).split(" ");
                  taulerJoc->ferMoviment(movimentsSolucio.value(0).toInt(),
                                                  movimentsSolucio.value(1).toInt(),
                                                  movimentsSolucio.value(2).toInt());
        }
  /* 13/01/11
     Aquest missatge es mostrava encara que la resposta
     fos NO*/
 // iniciSolucioSlot();
  statusBar()->showMessage(tr("S'ha carregat la ")+arbreSolucionsTreeWidget->selectedItems().first()->text(0)+
                           tr(". Feu servir els botons Avança i Retrocedeix per veure la solució. "));
    }
}
}

/*
  Converteix les dades d'un moviment en número
  a coordenades
  */
QString frmPrincipal::movimentACoordenades(QString inici,QString final){
    int numero_inici=inici.toInt();
    int numero_final=final.toInt();
    return QString("(%1,%2) -> (%3,%4)").arg(numero_inici/100).arg(numero_inici % 100).
                                arg(numero_final/100).arg(numero_final % 100);
}

/*
  Converteix les dades d'un moviment en coordenades
  a números
  */
QString frmPrincipal::coordenadesAMoviment(QString coordenades){
  QRegExp coord(".(\\d+),(\\d+). -> .(\\d+),(\\d+).");
  if (coord.exactMatch(coordenades)){
      int fitxaBotada=((coord.cap(1).toInt()+coord.cap(3).toInt())/2)*100+
                      ((coord.cap(2).toInt()+coord.cap(4).toInt())/2);
      return QString("%1 %2 %3").arg(coord.cap(1).toInt()*100+coord.cap(2).toInt()).
          arg(fitxaBotada).
          arg(coord.cap(3).toInt()*100+coord.cap(4).toInt());
  }
  else {
      return   QString("");}
}

/*
  Retorna el nom i directori de l'arxiu de dades/solucions del joc
  actual.
  tipus=1 -> arxiu amb les configuracions eliminades
  tipus=2 -> arxiu amb les solucions
   */
QString frmPrincipal::nomArxiuJoc(int tipus){
   comprovaDirectoriHome();
   QString nomArxiu=QDir::homePath ();
   QString extensio;
   if (tipus==1){ extensio=".txt";}
   else  extensio=".sol";
    nomArxiu.append (QDir().separator());
    nomArxiu.append (qApp->applicationName());
    nomArxiu.append (QDir().separator());
    nomArxiu.append (QString(solucioJocActual_configuracioInicial+" _"+
                        QString("%1").arg(taulerJoc->p_modalitatJocActual)+extensio));
    return nomArxiu;
}

/*
  Comprova que existeix el directori /Solitari
  en el directori d'usuari
  */
void frmPrincipal::comprovaDirectoriHome(){
    QDir dirArxiu(QDir::homePath ());
    if (!dirArxiu.exists(qApp->applicationName())){
         dirArxiu.mkdir(qApp->applicationName());
      }
}

void frmPrincipal::comprovaRegistre(){
     QSettings registre;
    // int reg=registre.value( QString("General/Registre"),0).toInt();
    if (registre.value( QString("General/Registre"),0).toInt()==0){
     if(QDesktopServices::openUrl(ADRECA_WEB_REGISTRE)){
        QSettings().setValue("General/Registre",1);
     };
  }
}

/*
  Retorna la cadena amb el missatge del número de moviments realitzats
  i total
  */
QString frmPrincipal::missatgeNumeroMoviments(){
QString numMovAct=QString("%1").arg(movimentsUndoStack->index()-1);
QString totalMovJoc=QString("%1").arg(taulerJoc->numeroDeMovimentsJoc());

while (numMovAct.length()<totalMovJoc.length()){numMovAct.prepend("0");}
return QString(tr("Moviment ")+numMovAct+tr(" de ")+totalMovJoc);
//return QString(tr("Moviment ")+numMovAct+tr(" de ")+totalMovJoc+" config %1 ").
 //                                           arg(solucioJocActual_configuracionsEliminades.count());
}

/*
  Copia l'arxiu de solucions en el directori
  de l'usuari
  */
void frmPrincipal::comprovaArxiuSolucions(){
    QString nomArxiuDesti=nomArxiuJoc(2);
    QString nomArxiuInicial=directoriLinux();
    nomArxiuInicial.append(QDir().separator());
    nomArxiuInicial.append(DIRECTORI_DADES);
    nomArxiuInicial.append(QDir().separator());
    nomArxiuInicial.append(QString(solucioJocActual_configuracioInicial+" _"+
                        QString("%1").arg(taulerJoc->p_modalitatJocActual)+".sol"));
    QFile arxiu(nomArxiuInicial);
    arxiu.copy( nomArxiuDesti);
}

 //Mostra un missatge passat pel tauler del joc
void frmPrincipal::mostraMissatge(int codi){
    switch (codi) {
     case 0:
         statusBar()->showMessage(tr("No hi ha més moviments: el joc ha finalitzat!"));
         break;
     case 1:
         statusBar()->showMessage(tr("Joc resolt!"));
         break;
     case 2:
         QMessageBox::information(this,tr("Nova marca personal"),
                                 tr("Heu establert un nou record personal en aquesta modalitat de joc"));
         break;
     case 3:
         statusBar()->showMessage(
                 QString(tr("Moviment %1 de %2 ")).arg(movimentsUndoStack->index()).
                 arg(taulerJoc->numeroDeMovimentsJoc()));
         break;
     }
}
