# $Id: NautilusBookmarks.pm,v 1.4 2004/02/17 12:30:31 jodrell Exp $
# This file is part of PerlPanel.
# 
# PerlPanel is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# PerlPanel is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with PerlPanel; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Copyright: (C) 2003-2004 Gavin Brown <gavin.brown@uk.com>
#
package Gnome2::NautilusBookmarks;
use Gtk2;
use XML::Simple;
use base 'Gtk2::Button';
use strict;

sub new {
	my $package = shift;
	my $self = $package->SUPER::new;
	bless($self, $package);

	my $child = shift;
	$self->add($child);

	$self->{file} = sprintf('%s/.nautilus/bookmarks.xml', $ENV{HOME});

	$self->create_menu;

	Glib::Timeout->add(1000, sub {
		my $mtime = (stat($self->{file}))[9];
		$self->create_menu if ($mtime > $self->{mtime});
	});

	return $self;
}

sub create_menu {
	my $self = shift;
	my $bookmarks = XMLin($self->{file});
	$self->{mtime} = (stat($bookmarks))[9];
	my @data = ( ['/', undef, undef, undef, '<Branch>'] );
	foreach my $name (sort keys %{$bookmarks->{bookmark}}) {
		push(@data, [
			'/'.$name,
			undef,
			sub { system("nautilus --no-desktop \"$bookmarks->{bookmark}->{$name}->{uri}\" &") },
			undef,
			'<StockItem>',
			'gtk-jump-to',
		]);
	}
	$self->{factory} = Gtk2::ItemFactory->new('Gtk2::Menu', '<main>', undef);
	$self->{factory}->create_items(@data);
}

sub get_menu {
	my $self = shift;
	if (!defined($self->{menu})) {
		$self->{menu} = $self->{factory}->get_widget('<main>');
	}
	return $self->{menu};
}

1;
